VisualHeal.Druid = {};

VisualHeal.Druid.HealingSpells = {};
VisualHeal.Druid.HealingSpells[VISUALHEAL_SPELL_HEALING_TOUCH] = {7, 13, 19 , 25, 31, 37, 43, 49, 55, 59, 61, 67, 70};
VisualHeal.Druid.HealingSpells[VISUALHEAL_SPELL_REGROWTH] = {17, 23, 29, 35, 41, 47, 53, 59, 65, 70};

function VisualHeal.Druid:GetSpellInfo(name, rank, target)
    local i, powerInfusion;

    -- Get static spell info (cached by main module)
    local spellInfo = VisualHeal:GetSpellInfo(name)[rank];

    if (not spellInfo) then
        return nil;
    end

    -- Get +healing bonus
    local bonus = GetSpellBonusHealing();

    local spellTab = self.HealingSpells[name];

    -- Detect Power Infusion
    if (VisualHeal:DetectBuff('player', "Spell_Holy_PowerInfusion")) then
        powerInfusion = 1.2;
    else
        powerInfusion = 1.0;
    end

    -- Gift of Nature - Increases healing by 2% per rank on all spells
    local _, _, _, _, talentGiftOfNature = GetTalentInfo(3, 12);
    local talentGiftOfNature = 2 * talentGiftOfNature / 100 + 1;

    -- Process individual spells
    if (name == VISUALHEAL_SPELL_HEALING_TOUCH) then
        local nBonus;

        -- Empowered Healing
        local _, _, _, _, talentEmpoweredTouch = GetTalentInfo(3, 14);

        -- Determine normalisation
        if (rank < 5) then
            if (rank == 1) then
                nBonus = (1.5 / 3.5) * bonus * (10 * talentEmpoweredTouch / 100 + 1) * 0.2875;
            elseif (rank == 2) then
                nBonus = (2.0 / 3.5) * bonus * (10 * talentEmpoweredTouch / 100 + 1) * 0.55;
            elseif (rank == 3) then
                nBonus = (2.5 / 3.5) * bonus * (10 * talentEmpoweredTouch / 100 + 1) * 0.775;
            elseif (rank == 4) then
                nBonus = (3.0 / 3.5) * bonus * (10 * talentEmpoweredTouch / 100 + 1);
            end        
        else
            nBonus = bonus * (10 * talentEmpoweredTouch / 100 + 1);
        end

        spellInfo.EffectiveHeal = talentGiftOfNature * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    elseif (name == VISUALHEAL_SPELL_REGROWTH) then
        local nBonus;
        if (rank == 1) then
            nBonus = (2.0 / 3.5) * bonus * 0.48 * 0.7;
        elseif (rank == 2) then
            nBonus = (2.0 / 3.5) * bonus * 0.5 * 0.925;
        else
            nBonus = (2.0 / 3.5) * bonus * 0.5;
        end
        spellInfo.EffectiveHeal = talentGiftOfNature * powerInfusion * (spellInfo.Heal + nBonus * VisualHeal:GetSpellBonusHealingPenalty(spellTab[rank], UnitLevel('player')));
    end

    return spellInfo;
end