--
-- Handle all frame attachments here...
--

function UFAB_AttachFrame(frame1_n, frame2_n, unit)
	frame1	= getglobal(frame1_n)

	if (InCombatLockdown()) then
		--
		-- Don't try to move/hide frames when in combat as this will cause Blizzard to
		-- whine and try to disable the add-on...
		--
		return
	end

	if (not frame1) then
		--DEFAULT_CHAT_FRAME:AddMessage("UFAB_AttachFrame: "..frame1_n" does not exist")
		return
	end

	if (not UnitExists(unit)) then
		--DEFAULT_CHAT_FRAME:AddMessage("UFAB_Attachframe: "..unit.." does not exist, hiding "..frame1_n)
		frame1:Hide()
		return
	end

	if (frame2_n == "unknown") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB_AttachFrame: frame2 unknown, displaying "..frame1_n)
		frame1:Show()
	else
		frame2	= getglobal(frame2_n)
		if (frame2) then
			--DEFAULT_CHAT_FRAME:AddMessage("UFAB_AttachFrame: attaching "..frame1_n.." to "..frame2_n)
			frame1:ClearAllPoints()
			frame1:SetPoint(ATTACH_POINT, frame2)
			frame1:Show()
		else
			DEFAULT_CHAT_FRAME:AddMessage("UFAB_AttachFrame: attaching "..frame1_n.." to "..frame2_n.." failed: "..frame2_n.." does not exist!")
			frame1:Hide()
		end
	end
end

function UFAB_PlayerCheck()
	local frame

	style_main			= UFAB_AutoDetect(FRAME_PLAYER)

	UFAB_AttachFrame("UFABPlayerBarFrame", UFAB_FrameName(FRAME_PLAYER, "", style_main), "player")
	UFAB_AttachFrame("UFABPetBarFrame", UFAB_FrameName(FRAME_PET, "", style_main), "pet")
end

function UFAB_TargetCheck(self)
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: TargetCheck called. Main style = "..UFAB_FrameStyleName(UFAB_AutoDetect(FRAME_PLAYER)))
	style_main	= UFAB_AutoDetect(FRAME_PLAYER)

	if (UnitExists("target")) then
		if (UnitCanAttack("player", "target") or UnitCanAttack("target", "player")) then
			getglobal("UFABTargetBarFrame"):Hide()
			UFAB_AttachFrame("UFABEnemyTargetBarFrame", UFAB_FrameName(FRAME_TARGET, "", style_main), "target")
		else 
			getglobal("UFABEnemyTargetBarFrame"):Hide()
			UFAB_AttachFrame("UFABTargetBarFrame", UFAB_FrameName(FRAME_TARGET, "", style_main), "target")
		end
	else 
		getglobal("UFABTargetBarFrame"):Hide()
		getglobal("UFABEnemyTargetBarFrame"):Hide()
	end
	UFAB_AttachFrame("UFABToTBarFrame", UFAB_FrameName(FRAME_TOT, "", style_main), "targettarget")
	UFAB_AttachFrame("UFABToTTBarFrame", UFAB_FrameName(FRAME_TOTT, "", style_main), "targettargettarget")
end

function UFAB_FocusCheck(self)
	style_main	= UFAB_AutoDetect(FRAME_PLAYER)

	UFAB_AttachFrame("UFABFocusBarFrame", UFAB_FrameName(FRAME_FOCUS, "", style_main), "focus")
end

function UFAB_PartyCheck(self)
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: PartyCheck called. Party style = "..UFAB_FrameStyleName(UFAB_AutoDetect(FRAME_PARTY)))
	local frame
	style_party	= UFAB_AutoDetect(FRAME_PARTY)

	for i = 1, 4 do 
		UFAB_AttachFrame("UFABParty"..i.."BarFrame", UFAB_FrameName(FRAME_PARTY, i, style_main), "party"..i)
		UFAB_AttachFrame("UFABPartyPet"..i.."BarFrame", UFAB_FrameName(FRAME_PARTY_PET, i, style_main), "partypet"..i)
	end
end

function UFAB_RaidCheck(self)
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: RaidCheck called. Raid style = "..UFAB_FrameStyleName(UFAB_AutoDetect(FRAME_RAID)))
	--
	-- Jas: I have some serious concerns about the performance efficiency of this function.
	--      If the RAID_ROSTER_UPDATE call is made frequently, then this will do a lot of
	--      work hiding/showing frames. I think what needs to be done is to actually create
	--      the frames on the fly... don't create raid frames until you're in a raid. Then
	--      UFAB will track what has been made and if the frame hasn't been made yet, don't
	--      bother hiding it.
	--
	--      If the show/hide calls are negligible hits at 40 updates a second, then this is
	--      irrelevant. It's something that needs to be further tested under stressful
	--      conditions.
	--
	local frame

	style_raid	= UFAB_AutoDetect(FRAME_RAID)

	if (GetNumRaidMembers() > 0) then
		for i = 1, 40 do
			UFAB_AttachFrame("UFABRaid"..i.."BarFrame", UFAB_FrameName(FRAME_RAID, i, style_main), "raid"..i)
		end
	else
		for i = 1, 40 do
			getglobal("UFABRaid"..i.."BarFrame"):Hide()
		end
	end
end
