--
-- This is used to detect the name of the unit frame to attach to.
--

STYLE_BLIZZARD	= 0
STYLE_DRAGGABLE	= 1
STYLE_AGUF	= 2
STYLE_PERL	= 3
STYLE_DUF	= 4
STYLE_CTUF	= 5
STYLE_XPERL	= 6
STYLE_NPERL	= 7

FRAME_PLAYER	= 1
FRAME_PARTY	= 2
FRAME_RAID	= 3
FRAME_TARGET	= 4
FRAME_TOT	= 5
FRAME_TOTT	= 6
FRAME_FOCUS	= 7
FRAME_PET	= 8
FRAME_PARTY_PET	= 9

function UFAB_FrameStyleName(frame_style)
	local frame_sname = ""

	if (frame_style == STYLE_BLIZZARD) then
		frame_sname	= "Blizzard"
	elseif (frame_style == STYLE_AGUF) then
		frame_sname	= "agUnitFrames"
	elseif (frame_style == STYLE_CTUF) then
		frame_sname	= "CT Unit Frames"
	elseif (frame_style == STYLE_DUF) then
		frame_sname	= "Discord Unit Frames"
	elseif (frame_style == STYLE_PERL) then
		frame_sname	= "Perl Classic Unit Frames"
	elseif (frame_style == STYLE_XPERL) then
		frame_sname	= "X-Perl Unit Frames"
	elseif (frame_style == STYLE_NPERL) then
		frame_sname	= "Nymbia's Perl UnitFrames"
	else
		frame_sname	= "UFAB Draggable"
	end

	return frame_sname;
end

function UFAB_FrameTypeName(frame_type)
	local frame_name = ""

	if (frame_type == FRAME_PLAYER) then
		frame_name	= "Player"
	elseif (frame_type == FRAME_PARTY) then
		frame_name	= "Party"
	elseif (frame_type == FRAME_RAID) then
		frame_name	= "Raid"
	elseif (frame_type == FRAME_TARGET) then
		frame_name	= "Target"
	elseif (frame_type == FRAME_TOT) then
		frame_name	= "ToT"
	elseif (frame_type == FRAME_TOTT) then
		frame_name	= "ToTT"
	elseif (frame_type == FRAME_FOCUS) then
		frame_name	= "Focus"
	elseif (frame_type == FRAME_PET) then
		frame_name	= "Player Pet"
	elseif (frame_type == FRAME_PARTY_PET) then
		frame_name	= "Party Pet"
	else
		frame_name	= "unknown"
	end

	return frame_name
end

function UFAB_FrameName(frame_type, frame_number, frame_style)
	local frame_name = "unknown"
	local frame_sname = ""

	if (frame_style == STYLE_BLIZZARD) then
		frame_sname	= "Blizzard"
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "PlayerFrame"
		elseif (frame_type == FRAME_PET) then
			frame_name	= "PetFrame"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "PartyMemberFrame"..frame_number
		elseif (frame_type == FRAME_RAID) then
			frame_name	= "RaidGroupButton"..frame_number
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "TargetFrame"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "TargetofTargetFrame"
		end
	elseif (frame_style == STYLE_AGUF) then
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "aUFplayer"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "aUFgrouppartyUnitButton"..frame_number
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "aUFtarget"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "aUFtargettarget"
		elseif (frame_type == FRAME_TOTT) then
			frame_name	= "aUFtargettargettarget"
		elseif (frame_type == FRAME_FOCUS) then
			frame_name	= "aUFfocus"
		elseif (frame_type == FRAME_PET) then
			frame_name	= "aUFpet"
		end
	elseif (frame_style == STYLE_CTUF) then
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "CT_PlayerFrame"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "CT_PartyFrame"..frame_number
		elseif (frame_type == FRAME_RAID) then
			local group	= frame_number / 5
			local unit	= frame_number % 5

			frame_name	= "CTRAGroup"..group..unit
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "CT_TargetFrame"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "CT_AssistFrame"
		end
	elseif (frame_style == STYLE_PERL) then
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "Perl_Player_Frame"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "Perl_Party_MemberFrame"..frame_number
		elseif (frame_type == FRAME_RAID) then
			frame_name	= "Perl_Raid"..frame_number
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "Perl_Target_Frame"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "Perl_Target_Target_Frame"
		elseif (frame_type == FRAME_TOTT) then
			frame_name	= "Perl_Target_Target_Target_Frame"
		elseif (frame_type == FRAME_PET) then
			frame_name	= "Perl_Player_Pet_Frame"
		elseif (frame_type == FRAME_PARTY_PET) then
			frame_name	= "Perl_Party_Pet"..frame_number
		elseif (frame_type == FRAME_FOCUS) then
			frame_name	= "Perl_Focus_Frame"
		end
	elseif (frame_style == STYLE_DUF) then
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "DUF_PlayerFrame"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "DUF_PartyFrame"..frame_number
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "DUF_TargetFrame"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "DUF_TargetOfTargetFrame"
		elseif (frame_type == FRAME_FOCUS) then
			frame_name	= "DUF_FocusFrame"
		elseif (frame_type == FRAME_PET) then
			frame_name	= "DUF_PetFrame"
		elseif (frame_type == FRAME_PARTY_PET) then
			frame_name	= "DUF_PartyPetFrame"..frame_number
		end
	elseif (frame_style == STYLE_XPERL) then
		if (frame_type == FRAME_PLAYER) then
			frame_name	= "XPerl_Player"
		elseif (frame_type == FRAME_PARTY) then
			frame_name	= "XPerl_party"..frame_number
		elseif (frame_type == FRAME_TARGET) then
			frame_name	= "XPerl_Target"
		elseif (frame_type == FRAME_TOT) then
			frame_name	= "XPerl_TargetTarget"
		elseif (frame_type == FRAME_FOCUS) then
			frame_name	= "XPerl_Focus"
		elseif (frame_type == FRAME_PET) then
			frame_name	= "XPerl_Player_Pet"
		elseif (frame_type == FRAME_PARTY_PET) then
			frame_name	= "XPerl_partypet"..frame_number
		elseif (frame_type == FRAME_RAID) then
			local group	= frame_number / 5
			local unit	= frame_number % 5

			frame_name	= "XPerl_Raid_Grp"..group.."UnitButton"..unit
		end
	end

	--DEFAULT_CHAT_FRAME:AddMessage( "UFActionBars "..VERSION..": Attaching to "..frame_name.." (style of "..UFAB_FrameStyleName(frame_style)..")")
	return frame_name;
end


function UFAB_AutoDetect(frame_type)
	local frame_sname = ""
	local frame_name = ""

	if (frame_type == FRAME_PLAYER) then
		frame_name	= "Main"
		if (getglobal("aUFplayer")) then
			frame_style	= STYLE_AGUF
		elseif (getglobal("Perl_Player_Frame")) then
			frame_style	= STYLE_PERL
		elseif (getglobal("DUF_PlayerFrame")) then
			frame_style	= STYLE_DUF
		elseif (getglobal("CT_PlayerFrame")) then
			frame_style	= STYLE_CTUF
		elseif (getglobal("XPerl_Player")) then
			frame_style	= STYLE_XPERL
		elseif (getglobal("PlayerFrame")) then
			frame_style	= STYLE_BLIZZARD
		else
			--
			-- Not Blizzard, and not detected... use draggable bars.
			--
			frame_style	= STYLE_DRAGGABLE
		end
	elseif (frame_type == FRAME_PARTY) then
		frame_name	= "Party"
		if (getglobal("aUFgrouppartyUnitButton1")) then
			frame_style	= STYLE_AGUF
		elseif (getglobal("Perl_Party_MemberFrame1")) then
			frame_style	= STYLE_PERL
		elseif (getglobal("DUF_PartyFrame1")) then
			frame_style	= STYLE_DUF
		elseif (getglobal("CT_PartyFrame1")) then
			frame_style	= STYLE_CTUF
		elseif (getglobal("XPerl_party1")) then
			frame_style	= STYLE_XPERL
		elseif (getglobal("PartyMemberFrame1")) then
			frame_style	= STYLE_BLIZZARD
		else
			frame_style	= STYLE_DRAGGABLE
		end
	elseif (frame_type == FRAME_RAID) then
		frame_name	= "Raid"
		if (getglobal("Perl_Raid1")) then
			frame_style	= STYLE_PERL
		elseif (getglobal("XPerl_Raid_Grp1UnitButton1")) then
			frame_style	= STYLE_XPERL
		elseif (getglobal("RaidGroupButton1")) then
			frame_style	= STYLE_BLIZZARD
		else
			frame_style	= STYLE_DRAGGABLE
		end
	end

	--DEFAULT_CHAT_FRAME:AddMessage( "UFActionBars V0.3: Detected "..frame_name.." style of "..UFAB_FrameStyleName(frame_style))
	return frame_style;
end
