function UFAB_CloseConfig()
	UFABConfig:Hide();
	UFAB_ConfigChange()
end

function UFAB_Slider(text,high,low,step)
	getglobal(this:GetName().."Text"):SetText(text);
	getglobal(this:GetName().."High"):SetText(high);
	getglobal(this:GetName().."Low"):SetText(low);
	this:SetMinMaxValues(low,high);
	this:SetValueStep(step);
end

function UFAB_ConfigClick()
	if (this:GetName() == "UFABConfigInnerFireFade") then
		UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade	= this:GetChecked();
	elseif (this:GetName() == "UFABConfigRaidBarsVertical") then
		UFAB_Config[UFAB_Realm][UFAB_Char].raid_bars_vertical	= this:GetChecked();
	end
	UFAB_ConfigChange()
end

function UFAB_ConfigSlide()
	if (this:GetName() == "UFABConfigSliderPlayerScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderPetScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderTargetScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderToTScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderToTTScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderFocusScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderPartyScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale		= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderPartyPetScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale	= this:GetValue();
	elseif (this:GetName() == "UFABConfigSliderRaidScale") then
		UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale		= this:GetValue();
	end
	UFAB_ConfigChange()
end

function UFAB_RescaleBars()
	if (not InCombatLockdown()) then
		getglobal("UFABPlayerBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale)
		getglobal("UFABPetBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale)
		getglobal("UFABTargetBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale)
		getglobal("UFABToTBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale)
		getglobal("UFABToTTBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale)
		getglobal("UFABFocusBarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale)
		for i = 1, 4 do 
			getglobal("UFABParty"..i.."BarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale)
			getglobal("UFABPartyPet"..i.."BarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale)
		end
		for i = 1, 40 do 
			getglobal("UFABRaid"..i.."BarFrame"):SetScale(UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale)
		end
	end
end

function UFAB_ConfigChange()
	UFAB_RescaleBars()
end

function UFAB_ShowConfig()
	-- make sure our profile has been loaded
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char] ) then -- config not loaded
		this:Hide(); -- hide our config pane
		return;
	end
	getglobal(this:GetName().."InnerFireFade"):SetChecked(UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade );
	getglobal(this:GetName().."RaidBarsVertical"):SetChecked(UFAB_Config[UFAB_Realm][UFAB_Char].raid_bars_vertical );		
	getglobal(this:GetName().."SliderPlayerScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale );
	getglobal(this:GetName().."SliderPetScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale );
	getglobal(this:GetName().."SliderTargetScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale );
	getglobal(this:GetName().."SliderToTScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale );
	getglobal(this:GetName().."SliderToTTScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale );
	getglobal(this:GetName().."SliderFocusScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale );
	getglobal(this:GetName().."SliderPartyScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale );
	getglobal(this:GetName().."SliderPartyPetScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale );
	getglobal(this:GetName().."SliderRaidScale"):SetValue(UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale );

end

function UFAB_ConfigPrint()
	DEFAULT_CHAT_FRAME:AddMessage("UFAB Config parameters")

	--
	-- restore all options to default values
	--
	if (UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade) then
		DEFAULT_CHAT_FRAME:AddMessage("Inner fire fade: on")
	else
		DEFAULT_CHAT_FRAME:AddMessage("Inner fire fade: off")
	end

	if (UFAB_Config[UFAB_Realm][UFAB_Char].raid_bars_vertical) then
		DEFAULT_CHAT_FRAME:AddMessage("Raid bars vertical: on")
	else
		DEFAULT_CHAT_FRAME:AddMessage("Raid bars vertical: off")
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("Num player buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_player_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num pet buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_pet_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num target buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_target_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num tot buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_tot_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num tott buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_tott_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num focus buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_focus_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num party buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_party_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num party pet buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_party_pet_buttons)
	DEFAULT_CHAT_FRAME:AddMessage("Num raid buttons: "..UFAB_Config[UFAB_Realm][UFAB_Char].num_raid_buttons)

	DEFAULT_CHAT_FRAME:AddMessage("Player button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Pet button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Target button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("ToT button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("ToTT button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Focus button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Party pet button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Party button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale)
	DEFAULT_CHAT_FRAME:AddMessage("Raid button scale: "..UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale)
end

function UFAB_ConfigReset()
	DEFAULT_CHAT_FRAME:AddMessage("UFAB Config reset")

	--
	-- restore all options to default values
	--
	UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade			= UFAB_Config_Default_inner_fire_fade; 
	UFAB_Config[UFAB_Realm][UFAB_Char].raid_bars_vertical			= UFAB_Config_Default_raid_bars_vertical; 
	UFAB_Config[UFAB_Realm][UFAB_Char].num_player_buttons			= UFAB_Config_Default_num_player_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_pet_buttons			= UFAB_Config_Default_num_pet_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_target_buttons			= UFAB_Config_Default_num_target_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_tot_buttons			= UFAB_Config_Default_num_tot_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_tott_buttons			= UFAB_Config_Default_num_tott_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_focus_buttons			= UFAB_Config_Default_num_focus_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_party_buttons			= UFAB_Config_Default_num_party_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_party_pet_buttons		= UFAB_Config_Default_num_party_pet_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].num_raid_buttons			= UFAB_Config_Default_num_raid_buttons;
	UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale			= UFAB_Config_Default_player_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale			= UFAB_Config_Default_pet_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale			= UFAB_Config_Default_target_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale			= UFAB_Config_Default_tot_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale			= UFAB_Config_Default_tott_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale			= UFAB_Config_Default_focus_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale		= UFAB_Config_Default_party_pet_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale			= UFAB_Config_Default_party_button_scale;
	UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale			= UFAB_Config_Default_raid_button_scale;
end

-----------------------------------------
-- Load the user's configuration settings
-----------------------------------------
function UFAB_LoadVariables()
	if (UFAB_VARIABLES_LOADED) then
		return
	end

	-- initialize our SavedVariable
	if ( not UFAB_Config ) then 
	 	UFAB_Config = {}; 
	end
	if ( not UFAB_Config[UFAB_Realm] ) then 
	 	UFAB_Config[UFAB_Realm] = {}; 
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char] ) then 
	 	UFAB_Config[UFAB_Realm][UFAB_Char] = {}; 
	end

	--
	-- load each option, set default if not there
	--
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade ) then 
		UFAB_Config[UFAB_Realm][UFAB_Char].inner_fire_fade			= UFAB_Config_Default_inner_fire_fade; 
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].raid_bats_vertical ) then 
		UFAB_Config[UFAB_Realm][UFAB_Char].raid_bars_vertical			= UFAB_Config_Default_raid_bars_vertical; 
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_player_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_player_buttons			= UFAB_Config_Default_num_player_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_pet_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_pet_buttons			= UFAB_Config_Default_num_pet_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_target_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_target_buttons			= UFAB_Config_Default_num_target_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_tot_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_tot_buttons			= UFAB_Config_Default_num_tot_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_tott_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_tott_buttons			= UFAB_Config_Default_num_tott_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_focus_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_focus_buttons			= UFAB_Config_Default_num_focus_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_party_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_party_buttons			= UFAB_Config_Default_num_party_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_party_pet_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_party_pet_buttons		= UFAB_Config_Default_num_party_pet_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].num_raid_buttons ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].num_raid_buttons			= UFAB_Config_Default_num_raid_buttons;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale			= UFAB_Config_Default_player_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale			= UFAB_Config_Default_pet_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale			= UFAB_Config_Default_target_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale			= UFAB_Config_Default_tot_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale			= UFAB_Config_Default_tott_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale			= UFAB_Config_Default_focus_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale		= UFAB_Config_Default_party_pet_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale			= UFAB_Config_Default_party_button_scale;
	end
	if ( not UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale ) then
		UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale			= UFAB_Config_Default_raid_button_scale;
	end

	--
	-- record that we have been loaded
	--
	UFAB_VARIABLES_LOADED = true;

	--
	-- we know other addons have been "loaded" now
	-- optional dependance on myAddOns, leads to our config panel
	--
	if( myAddOnsFrame_Register ) then
		myAddOnsFrame_Register( UFAB_details );
	end

	--
	-- configuration might have changed
	--
	UFAB_ConfigChange();
 end
