------------------------------------
-- Handle any slash commands entered
------------------------------------
function UFAB_SlashCommandHandler(msg)

	local a, b, command = string.find( msg, "(%w+)" );

	if( command == nil ) then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB Commands are as follows:")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab config -- does nothing at the moment")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab resetpos -- does nothing at the moment")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab showparty -- this won't show party pets though")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab showplayer")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab showpet")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab showfocus")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab hideparty -- this will also hide party pets")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab hideraid")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab hidetargets -- hide target/tot/tott/focus/pet")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab hideall")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab partyreset")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab configprint")
		DEFAULT_CHAT_FRAME:AddMessage("/ufab configreset")
		return;
	else
		command = string.lower(msg);
	end

	if ( command == "config") then
		getglobal("UFABConfig"):Show()
		return;
	end

	if ( command == "resetpos" ) then
		-- TODO: implement resetting position of bars to default
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: resetpos");
	end

	if (command == "showparty") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Showing party bars");

		for i = 1, 4 do 
			getglobal("UFABParty"..i.."BarFrame"):Show()
		end
	end

	if (command == "showplayer") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Showing player bar");

		getglobal("UFABPlayerBarFrame"):Show()
	end

	if (command == "showpet") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Showing player pet bar");

		getglobal("UFABPetBarFrame"):Show()
	end

	if (command == "showfocus") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Showing focus bar");

		getglobal("UFABFocusBarFrame"):Show()
	end

	if (command == "hideparty") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Hiding party bars");

		for i = 1, 4 do 
			getglobal("UFABParty"..i.."BarFrame"):Hide()
			getglobal("UFABPartyPet"..i.."BarFrame"):Hide()
		end
	end

	if (command == "hideraid") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Hiding raid bars");

		for i = 1, 40 do 
			getglobal("UFABRaid"..i.."BarFrame"):Hide()
		end
	end

	if (command == "hidetargets") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Hiding target, focus, and pet bars");

		getglobal("UFABTargetBarFrame"):Hide()
		getglobal("UFABToTBarFrame"):Hide()
		getglobal("UFABToTTBarFrame"):Hide()
		getglobal("UFABFocusBarFrame"):Hide()
		getglobal("UFABPetBarFrame"):Hide()
	end

	if ( command == "hideall") then
		DEFAULT_CHAT_FRAME:AddMessage("UFAB: Hiding all UFAB bars");

		getglobal("UFABTargetBarFrame"):Hide()
		getglobal("UFABToTBarFrame"):Hide()
		getglobal("UFABToTTBarFrame"):Hide()
		getglobal("UFABFocusBarFrame"):Hide()
		getglobal("UFABPetBarFrame"):Hide()
		getglobal("UFABPlayerBarFrame"):Hide()
		for i = 1, 4 do 
			getglobal("UFABParty"..i.."BarFrame"):Hide()
			getglobal("UFABPartyPet"..i.."BarFrame"):Hide()
		end
		for i = 1, 40 do 
			getglobal("UFABRaid"..i.."BarFrame"):Hide()
		end
	end 

	if ( command == "partyreset" ) then
		UFAB_PartyCheck()
	end

	if ( command == "configprint" ) then
		UFAB_ConfigPrint()
	end

	if ( command == "configreset" ) then
		UFAB_ConfigReset()
	end
end
