-- The idea of UFAB is orginally based on Group Buttons by Loz.
-- 
-- Credits:
--  Thanks to Mairelon for the awesome sample code.
--  Thanks to Mubari for the initial framework for PartyBars.
--
-- Creation Date : 2006-12-16
--
-- History:		
--
-- 2006-12-16	v.0.1	jasmeralia	Forked from PartyBars and added support for raid windows 
-- 2006-12-19	v.0.2	jasmeralia	Optimized code and fixed some bugs.
-- 2006-12-26	v.0.3	jasmeralia	Added support for autodetecting the Unit Frame mods used and start of config framework.
-- 2006-12-28	v.0.4	jasmeralia	Cleaned up/optimized the XML and improved detection code.
-- 2006-12-31	v.0.5	jasmeralia	Added support for XPerl and added UFAB_RescaleBars() on UFAB_ConfigChange().
-- 2006-12-31	v.0.6	jasmeralia	Added support for separate hostile target bars. Added initial config options.
--

VERSION			= 0.6

ATTACH_POINT		= "BOTTOMRIGHT"

function UFAB_LoadButtons(bar_frame, num_buttons, base, unit, scale)
	local relpt 	= bar_frame

	--DEFAULT_CHAT_FRAME:AddMessage( "UFAB_LoadButtons: "..bar_frame:GetName() )
	for i = 1,num_buttons do
		local btn = CreateFrame("CheckButton", unit..i, bar_frame, "UFActionButtonTemplate")

		btn:SetScale(scale)
		btn:SetScript("OnAttributeChanged", ActionButton_Update)
		btn:SetAttribute("type", "action")
		btn:SetAttribute("action", base + i)
		btn:SetAttribute("*unit*", unit)
		if i == 1 then
			btn:SetPoint("TOPLEFT", relpt, "TOPRIGHT")
		else
			btn:SetPoint("LEFT", relpt, "RIGHT")
		end

		relpt = btn
	end

	bar_frame:Hide()
end

function UFAB_InitializeFrames()
	local	frame
	local	btns_player	= UFAB_Config[UFAB_Realm][UFAB_Char].num_player_buttons
	local	btns_pet	= UFAB_Config[UFAB_Realm][UFAB_Char].num_pet_buttons
	local	btns_focus	= UFAB_Config[UFAB_Realm][UFAB_Char].num_focus_buttons
	local	btns_target	= UFAB_Config[UFAB_Realm][UFAB_Char].num_target_buttons
	local	btns_tot	= UFAB_Config[UFAB_Realm][UFAB_Char].num_tot_buttons
	local	btns_tott	= UFAB_Config[UFAB_Realm][UFAB_Char].num_tott_buttons
	local	btns_party	= UFAB_Config[UFAB_Realm][UFAB_Char].num_party_buttons
	local	btns_ppets	= UFAB_Config[UFAB_Realm][UFAB_Char].num_party_pet_buttons
	local	btns_raid	= UFAB_Config[UFAB_Realm][UFAB_Char].num_raid_buttons

	local	scale_player	= UFAB_Config[UFAB_Realm][UFAB_Char].player_button_scale
	local	scale_pet	= UFAB_Config[UFAB_Realm][UFAB_Char].pet_button_scale
	local	scale_focus	= UFAB_Config[UFAB_Realm][UFAB_Char].focus_button_scale
	local	scale_target	= UFAB_Config[UFAB_Realm][UFAB_Char].target_button_scale
	local	scale_tot	= UFAB_Config[UFAB_Realm][UFAB_Char].tot_button_scale
	local	scale_tott	= UFAB_Config[UFAB_Realm][UFAB_Char].tott_button_scale
	local	scale_party	= UFAB_Config[UFAB_Realm][UFAB_Char].party_button_scale
	local	scale_ppets	= UFAB_Config[UFAB_Realm][UFAB_Char].party_pet_button_scale
	local	scale_raid	= UFAB_Config[UFAB_Realm][UFAB_Char].raid_button_scale

	local	base		= 120 - btns_target - btns_player - btns_pet - btns_focus - btns_target - btns_tot - btns_tott - btns_party - btns_ppets - btns_raid

	--
	-- Start by creating the main buttons
	--
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Hostile Target bar - "..base.."-"..base+btns_target)
	frame	= getglobal("UFABEnemyTargetBarFrame")
	UFAB_LoadButtons(frame, btns_target, base, "target", scale_target)
	base	= base + btns_target

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Player bars - "..base.."-"..base+btns_player)
	frame	= getglobal("UFABPlayerBarFrame")
	UFAB_LoadButtons(frame, btns_player, base, "player", scale_player)
	base	= base + btns_player

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Target bars - "..base.."-"..base+btns_target)
	frame	= getglobal("UFABTargetBarFrame")
	UFAB_LoadButtons(frame, btns_target, base, "target", scale_target)
	base	= base + btns_target

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: ToT bars - "..base.."-"..base+btns_tot)
	frame	= getglobal("UFABToTBarFrame")
	UFAB_LoadButtons(frame, btns_tot, base, "targettarget", scale_tot)
	base	= base + btns_tot

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: ToTT bars - "..base.."-"..base+btns_tott)
	frame	= getglobal("UFABToTTBarFrame")
	UFAB_LoadButtons(frame, btns_tott, base, "targettargettarget", scale_tott)
	base	= base + btns_tott

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Focus bars - "..base.."-"..base+btns_focus)
	frame	= getglobal("UFABFocusBarFrame")
	UFAB_LoadButtons(frame, btns_focus, base, "focus", scale_focus)
	base	= base + btns_focus

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Pet bars - "..base.."-"..base+btns_pet)
	frame	= getglobal("UFABPetBarFrame")
	UFAB_LoadButtons(frame, btns_pet, base, "pet", scale_pet)
	base	= base + btns_pet


	-- Now create the buttons for each party member
	-- These buttons share IDs across party frames so adding a spell to
	-- one will affect all 4.

	local units = {}
	for i = 1, 4 do
		local frame = getglobal("UFABParty"..i.."BarFrame")
		UFAB_LoadButtons(frame, btns_party, base, "party"..i, scale_party)
	end

	--
	-- Increment the base by the number of buttons used for the party action bars
	--
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Party bars - "..base.."-"..base+btns_party)
	base = base + btns_party

	-- Now create the buttons for each party member
	-- These buttons share IDs across party frames so adding a spell to
	-- one will affect all 4.

	local units = {}
	for i = 1, 4 do
		local frame = getglobal("UFABPartyPet"..i.."BarFrame")
		UFAB_LoadButtons(frame, btns_ppets, base, "partypet"..i, scale_ppets)
	end

	--
	-- Increment the base by the number of buttons used for the party action bars
	--
	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Party pet bars - "..base.."-"..base+btns_ppets)
	base = base + btns_party

	-- Now create the buttons for each raid member
	-- These buttons share IDs across raid frames so adding a spell to
	-- one will affect all 40.

	local unitsR = {}
	for i = 1, 40 do 
		local frame = getglobal("UFABRaid"..i.."BarFrame")
		UFAB_LoadButtons(frame, btns_raid, base, "raid"..i, scale_raid)
	end

	--DEFAULT_CHAT_FRAME:AddMessage("UFAB: Raid bars - "..base.."-"..base+btns_raid)
	--
	-- Now initialize things...
	--

	UFAB_PlayerCheck()
	UFAB_PartyCheck()
	UFAB_RaidCheck()
	UFAB_TargetCheck()

	--
	-- Done, let the player know we've loaded.
	--

	DEFAULT_CHAT_FRAME:AddMessage( "UFAB v"..VERSION.." Loaded" )
end

function UFAB_OnLoad(self)
	--
	-- Setup the slash commands
	--

	SLASH_UFAB1 = "/UFAB";
	SLASH_UFAB2 = "/ufab";
	SlashCmdList["UFAB"] = function(msg)
		UFAB_SlashCommandHandler(msg);
	end

	style_main			= STYLE_DRAGGABLE
	style_party			= STYLE_DRAGGABLE
	style_raid			= STYLE_DRAGGABLE

	UFAB_Globals()

	self:RegisterEvent("PLAYER_AURAS_CHANGED");
	self:RegisterEvent("PARTY_MEMBERS_CHANGED");
	self:RegisterEvent("RAID_ROSTER_UPDATE");
	self:RegisterEvent("VARIABLES_LOADED");
	self:RegisterEvent("PET_UI_UPDATE");
	self:RegisterEvent("RAID_TARGET_UPDATE");
	self:RegisterEvent("PLAYER_FOCUS_CHANGED");
	self:RegisterEvent("UNIT_TARGET");
	self:RegisterEvent("UNIT_PET");
	--self:RegisterEvent("PLAYER_ENTERING_WORLD");
end

function UFAB_OnEvent(self, event, ...)
	if (event == "VARIABLES_LOADED") then
		-- Load the saved config
		UFAB_LoadVariables()
		UFAB_InitializeFrames()
	end

	if (event == "PET_UI_UPDATE" or event == "UNIT_PET") then
		UFAB_TargetCheck()
		UFAB_PlayerCheck()
	end

	if (event == "PARTY_MEMBERS_CHANGED") then
		UFAB_PlayerCheck()
		UFAB_TargetCheck()
		UFAB_PartyCheck()
	end

	if (event == "RAID_ROSTER_UPDATE") then
		UFAB_TargetCheck()
		UFAB_RaidCheck()
	end

	if (event == "RAID_TARGET_UPDATE") then
		UFAB_TargetCheck()
		UFAB_FocusCheck()
		UFAB_RaidCheck()
	end

	if (event == "PLAYER_TARGET_CHANGED") then
		UFAB_PlayerCheck()
		UFAB_TargetCheck()
		UFAB_FocusCheck()
	end

	if (event == "UNIT_TARGET") then
		UFAB_PlayerCheck()
		UFAB_TargetCheck()
		UFAB_FocusCheck()
	end

	if (event == "PLAYER_FOCUS_CHANGED") then
		UFAB_TargetCheck()
		UFAB_FocusCheck()
	end

	if (event == "PLAYER_AURAS_CHANGED") then
		UFAB_PlayerCheck()
		UFAB_TargetCheck()
		UFAB_FocusCheck()
		UFAB_AuraHacks()
	end
end
