-------------------------------------------------------------------------------
-- SmartDebuff
-- Created by Aeldra (EU-Proudmoore)
--
-- Supports you to cast debuff spells on friendly units
-------------------------------------------------------------------------------

SMARTDEBUFF_VERSION       = "v2.0a";
SMARTDEBUFF_TITLE         = "SmartDebuff";
SMARTDEBUFF_SUBTITLE      = "Debuff support";
SMARTDEBUFF_DESC          = "Supports you to cast debuff spells on friendly units";
SMARTDEBUFF_VERS_TITLE    = SMARTDEBUFF_TITLE .. " " .. SMARTDEBUFF_VERSION;
SMARTDEBUFF_OPTIONS_TITLE = SMARTDEBUFF_VERS_TITLE .. " Options";

BINDING_HEADER_SMARTDEBUFF = "SmartDebuff";
SMARTDEBUFF_BOOK_TYPE_SPELL = "spell";

local maxRaid = 40;
local maxPets = 20;

local isLoaded = false;
local isPlayer = false;
local isInit = false;
local isSetUnits = false;
local isSetPets = false;
local isSetSpells = false;
local isSoundPlayed = false;

local tTicker = 0;
local tDebuff = 0;
local tSound = 0;

local sRealmName = nil;
local sPlayerName = nil;
local sID = nil;
local sPlayerClass = nil;
local iGroupSetup = -1;

local cGroups = { };
local cClasses = { };
local cPets = { };
local cHeals = nil;
local cSpells = nil;

local canDebuff = false;
local hasDebuff = false;

local cAddUnitList = { };
local cIgnoreUnitList = { };


local cOrderClass = {"WARRIOR", "PRIEST", "DRUID", "PALADIN", "SHAMAN", "MAGE", "WARLOCK", "HUNTER", "ROGUE"};
local cOrderGrp   = {1, 2 , 3, 4 , 5 , 6, 7, 8};

local imgSDB       = "Interface\\Icons\\Spell_Holy_LayOnHands";
--local imgIconOn  = "Interface\\AddOns\\SmartBuff\\Icons\\MiniMapButtonEnabled";
--local imgIconOff = "Interface\\AddOns\\SmartBuff\\Icons\\MiniMapButtonDisabled";

local DebugChatFrame = DEFAULT_CHAT_FRAME;


--Returns a chat color code string
local function BCC(r, g, b)
	return string.format("|cff%02x%02x%02x", (r*255), (g*255), (b*255));
end

local BL  = BCC(0, 0, 1);
local BLD = BCC(0, 0, 0.7);
local BLL = BCC(0.5, 0.8, 1);
local GR  = BCC(0, 1, 0);
local GRD = BCC(0, 0.7, 0);
local GRL = BCC(0.6, 1, 0.6);
local RD  = BCC(1, 0, 0);
local RDD = BCC(0.7, 0, 0);
local RDL = BCC(1, 0.3, 0.3);
local YL  = BCC(1, 1, 0);
local YLD = BCC(0.7, 0.7, 0);
local YLL = BCC(1, 1, 0.5);
local OR  = BCC(1, 0.7, 0);
local ORD = BCC(0.7, 0.5, 0);
local ORL = BCC(1, 0.6, 0.3);
local WH  = BCC(1, 1, 1);
local CY  = BCC(0.5, 1, 1);

local function ChkS(text)
  if (text == nil) then
    text = "";
  end
  return text;
end


-- SMARTDEBUFF_OnLoad
function SMARTDEBUFF_OnLoad()
  this:RegisterEvent("ADDON_LOADED");
  this:RegisterEvent("PLAYER_ENTERING_WORLD");
  this:RegisterEvent("UNIT_NAME_UPDATE");
  
  this:RegisterEvent("PARTY_MEMBERS_CHANGED");
  this:RegisterEvent("RAID_ROSTER_UPDATE");
  this:RegisterEvent("PLAYER_REGEN_ENABLED");
	this:RegisterEvent("PLAYER_REGEN_DISABLED");
	
	this:RegisterEvent("LEARNED_SPELL_IN_TAB");
  this:RegisterEvent("UNIT_PET");
  
  --One of them allows SmartDebuff to be closed with the Escape key
  tinsert(UISpecialFrames, "SmartDebuffOF");
	UIPanelWindows["SmartDebuffOF"] = nil;
  
	SlashCmdList["SMARTDEBUFF"] = SMARTDEBUFF_command;
	SLASH_SMARTDEBUFF1 = "/sdb";
	SLASH_SMARTDEBUFF2 = "/smartdebuff";

	SlashCmdList["SMARTDEBUFFOPTIONS"] = SMARTDEBUFF_ToggleOF;
	SLASH_SMARTDEBUFFOPTIONS1 = "/sdbo";
	
  SlashCmdList["SMARTDEBUFFRELOAD"] = function(msg) ReloadUI(); end;
	SLASH_SMARTDEBUFFRELOAD1 = "/rui";  
end
-- END SMARTDEBUFF_OnLoad


-- SMARTDEBUFF_OnEvent
function SMARTDEBUFF_OnEvent(event)
  --DebugChatFrame:AddMessage(event);
	if ((event == "UNIT_NAME_UPDATE" and arg1 == "player") or event == "PLAYER_ENTERING_WORLD") then
		isPlayer = true;
  elseif(event == "ADDON_LOADED" and arg1 == SMARTDEBUFF_TITLE) then
    isLoaded = true;
  end
    
  if (isLoaded and isPlayer and not isInit) then
    SMARTDEBUFF_Options_Init();
  end
  
  if (not isInit or SMARTDEBUFF_Options == nil) then
    return;
  end;
  
  if (event == "PARTY_MEMBERS_CHANGED" or event == "RAID_ROSTER_UPDATE") then
    isSetUnits = true;
  
  elseif (event == "UNIT_PET" or (event == "UNIT_NAME_UPDATE" and string.find(arg1, "pet"))) then
    isSetPets = true;
    
  elseif (event == "PLAYER_REGEN_DISABLED") then
    SMARTDEBUFF_CheckSFButtons(true);
    SMARTDEBUFF_Ticker(true);
    
  elseif (event == "PLAYER_REGEN_ENABLED") then
    SMARTDEBUFF_CheckSFButtons();
    SMARTDEBUFF_Ticker(true);

	elseif (event == "LEARNED_SPELL_IN_TAB") then   
    isSetSpells = true;
  end

end
-- END SMARTDEBUFF_OnEvent


function SMARTDEBUFF_OnUpdate(elapsed)
  if (isInit) then
    SMARTDEBUFF_Ticker();
    SMARTDEBUFF_CheckDebuffs();
  end
end

function SMARTDEBUFF_Ticker(force)
  if (force or GetTime() > tTicker + 1) then
    tTicker = GetTime();
    
    if (isSetPets and not isSetUnits) then
      isSetPets = false;
      if (canDebuff and SmartDebuffSF:IsVisible()) then
        if (InCombatLockdown()) then
          isSetUnits = true;
        else
          SMARTDEBUFF_AddMsgD("Unit pet changed");
          SMARTDEBUFF_SetPetButtons();
        end
      end    
    end
    
    if (isSetUnits) then
      isSetUnits = false;
      SMARTDEBUFF_SetUnits();
    end
    
    if (isSetSpells) then
      isSetSpells = false;
      SMARTDEBUFF_SetSpells();
    end    
    
  end 
end


-- Will dump the value of msg to the default chat window
function SMARTDEBUFF_AddMsg(msg, force)
  if (DEFAULT_CHAT_FRAME and (force or SMARTDEBUFF_Options.ShowMsgNormal)) then
    DEFAULT_CHAT_FRAME:AddMessage(YLL .. msg .. "|r");
  end
end

function SMARTDEBUFF_AddMsgErr(msg, force)
  if (DEFAULT_CHAT_FRAME and (force or SMARTDEBUFF_Options.ShowMsgError)) then
    DEFAULT_CHAT_FRAME:AddMessage(RDL .. SMARTDEBUFF_TITLE .. ": " .. msg .. "|r");
  end
end

function SMARTDEBUFF_AddMsgWarn(msg, force)
  if (DEFAULT_CHAT_FRAME and (force or SMARTDEBUFF_Options.ShowMsgWarning)) then
    DEFAULT_CHAT_FRAME:AddMessage(CY .. msg .. "|r");
  end
end

function SMARTDEBUFF_AddMsgD(msg, r, g, b)
  if (r == nil) then r = 0.5; end
  if (g == nil) then g = 0.8; end
  if (b == nil) then b = 1; end
  if (DEFAULT_CHAT_FRAME and SMARTDEBUFF_Options and SMARTDEBUFF_Options.Debug) then
    DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
  end
end


-- Creates an array of units
function SMARTDEBUFF_SetUnits()
  if (not isInit or InCombatLockdown()) then
    isSetUnits = true;
    return;
  end    
  
  local i = 0;
  local n = 0;
  local j = 0;
  local s = nil;
  local psg = 0;
  local b = false;

-- player
-- pet
-- party1-4
-- partypet1-4
-- raid1-40
-- raidpet1-40
 
  iGroupSetup = -1;
  if (GetNumRaidMembers() ~= 0) then
    iGroupSetup = 3;
	elseif (GetNumPartyMembers() ~= 0) then
	  iGroupSetup = 2;
	else
    iGroupSetup = 1;
  end
  
  cGroups = { };
  cClasses = { };
  cPets = { };
  
  cAddUnitList = { };
  cIgnoreUnitList = { };
  
  -- Raid Setup  
  if (iGroupSetup == 3) then
    local name, rank, subgroup, level, class, classeng, zone, online, isDead;
	  
	  for n = 1, maxRaid, 1 do
		  name, rank, subgroup, level, class, classeng, zone, online, isDead = GetRaidRosterInfo(n);
		  if (name) then
		    
		    SMARTDEBUFF_AddUnit("raid", n, subgroup, classeng);
		              		  
		    --SmartBuff_AddToUnitList(1, sRUnit, subgroup);
		    --SmartBuff_AddToUnitList(2, sRUnit, subgroup);
		  end

	  end --end for
	  SMARTDEBUFF_AddMsgD("Raid Unit-Setup finished");
	
	-- Party Setup
	elseif (iGroupSetup == 2) then        
    SMARTDEBUFF_AddUnit("player", 0, 1, sPlayerClass);
    for j = 1, 4, 1 do
      SMARTDEBUFF_AddUnit("party", j, 1);		  
      --SmartBuff_AddToUnitList(1, "party"..j, 1);
		  --SmartBuff_AddToUnitList(2, "party"..j, 1);      
    end
    SMARTDEBUFF_AddMsgD("Party Unit-Setup finished");
  
  -- Solo Setup
  else    
    SMARTDEBUFF_AddUnit("player", 0, 1, sPlayerClass);
    SMARTDEBUFF_AddMsgD("Solo Unit-Setup finished");
  end  
  
  SMARTDEBUFF_SetButtons();
end

function SMARTDEBUFF_AddUnit(unit, i, sg, uc)
  local u = unit;
  local up = "pet";
  if (unit ~= "player") then
    u = unit..i;
    up = unit.."pet"..i;
  end
  
  if (UnitExists(u)) then
    if (not cGroups[sg]) then
      cGroups[sg] = { };
    end
    cGroups[sg][i] = { };
    cGroups[sg][i].Unit = u;
    cGroups[sg][i].Subgroup = sg;
    SMARTDEBUFF_AddMsgD("Unit to subgroup added: " .. UnitName(u) .. ", " .. u .. ", " .. sg);
    
    if (not uc) then
      _, uc = UnitClass(u);
    end

    if (uc) then
      if (not cClasses[uc]) then
        cClasses[uc] = { };
      end

      cClasses[uc][i] = { };
      cClasses[uc][i].Unit = u;
      cClasses[uc][i].Subgroup = sg;
      SMARTDEBUFF_AddMsgD("Unit to class added: " .. UnitName(u) .. ", " .. u .. ", " .. sg);
      
      if (uc == "HUNTER" or uc == "WARLOCK") then
        cPets[i] = { };
        cPets[i].Unit = up;
        cPets[i].Subgroup = sg;
        cPets[i].Owner = u;
        cPets[i].OwnerClass = uc;
        if (UnitName(up)) then
          SMARTDEBUFF_AddMsgD("Pet added: " .. UnitName(up) .. ", " .. up .. ", " .. sg);
        end
      end
    end
    
  end
end

-- END SMARTDEBUFF_SetUnits


-- Helper functions ---------------------------------------------------------------------------------------
function SMARTDEBUFF_toggleBool(b, msg)
  if (not b or b == nil) then
    b = true;
    SMARTDEBUFF_AddMsg(SMARTDEBUFF_TITLE .. ": " .. msg .. GR .. "On");
  else
    b = false
    SMARTDEBUFF_AddMsg(SMARTDEBUFF_TITLE .. ": " .. msg .. RD .."Off");
  end
  return b;
end

function SMARTDEBUFF_BoolState(b, msg)
  if (b) then
    SMARTDEBUFF_AddMsg(SMARTDEBUFF_TITLE .. ": " .. msg .. GR .. "On");
  else
    SMARTDEBUFF_AddMsg(SMARTDEBUFF_TITLE .. ": " .. msg .. RD .."Off");
  end
end

function SMARTDEBUFF_Split(msg, char)
	local arr = { };
	while (string.find(msg, char)) do
		local iStart, iEnd = string.find(msg, char);
		tinsert(arr, strsub(msg, 1, iStart - 1));
		msg = strsub(msg, iEnd + 1, strlen(msg));
	end
	if (strlen(msg) > 0) then
		tinsert(arr, msg);
	end
	return arr;
end

function SmartDebuffOFSlider_OnLoad(low, high, step)
  if (this:GetOrientation() ~= "VERTICAL") then
    getglobal(this:GetName().."Low"):SetText(low);
  else
    getglobal(this:GetName().."Low"):SetText("");
  end
  getglobal(this:GetName().."High"):SetText(high);
	this:SetMinMaxValues(low, high);
	this:SetValueStep(step);
end
-- END Bool helper functions


-- IsFeignDeath(unit)
function SMARTDEBUFF_IsFeignDeath(unit)
	for i = 1, 32, 1 do
		local name, _, icon = UnitBuff(unit, i);
		if (icon) then
			if (string.find(string.lower(icon), "feigndeath")) then
				return true;
			end
		else
			break;
		end
	end
  return false;
end
-- END SMARTBUFF_IsFeignDeath


-- Get Spell ID from spellbook
function SMARTDEBUFF_GetSpellID(spellname)
	if (spellname) then 
	  spellname = string.lower(spellname);
	else
	  return nil;
	end
	
	local i = 0;
	local id = nil;
	local spellN;
	while true do
	  i = i + 1;
   	spellN = GetSpellName(i, SMARTDEBUFF_BOOK_TYPE_SPELL);
   	if (not spellN or string.lower(spellN) == spellname) then
   	  break;
   	end   	
	end
	while (spellN ~= nil) do
	  id = i;
	  i = i + 1;
   	spellN = GetSpellName(i, SMARTDEBUFF_BOOK_TYPE_SPELL);
	  if (not spellN or string.lower(spellN) ~= spellname) then 
		  break;
		end
	end	
	return id;
end
-- END SMARTDEBUFF_GetSpellID


function SMARTDEBUFF_SetSpells()
  local i = 1;
  cSpells = nil;
  
  -- TOCHANGE
  cSpells = {};
  cHeals = {};
  canDebuff = true;
  -- check debuff spells
  if (sPlayerClass == "DRUID") then
    cSpells = {};
    canDebuff = true;

    -- Cure Poison / Abolish Poison
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_CUREPOISON)) then
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_CUREPOISON, i};
      SMARTDEBUFF_AddMsgD("Debuff spell found: " .. SMARTDEBUFF_CUREPOISON);
    end
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_ABOLISHPOISON)) then
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_ABOLISHPOISON, i};
      SMARTDEBUFF_AddMsgD("Debuff spell found: " .. SMARTDEBUFF_ABOLISHPOISON);
    end
    i = i + 1;
    
    --Remove Curse
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_REMOVECURSE)) then
      cSpells[SMARTDEBUFF_CURSE] = {SMARTDEBUFF_REMOVECURSE, i};
      SMARTDEBUFF_AddMsgD("Debuff spell found: " .. SMARTDEBUFF_REMOVECURSE);
    end
    i = i + 1;
    
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_REJUVENATION)) then
      cHeals[SMARTDEBUFF_HEAL] = {SMARTDEBUFF_REJUVENATION, 1};
      SMARTDEBUFF_AddMsgD("Heal spell found: " .. SMARTDEBUFF_REJUVENATION);
    end
    
  elseif (sPlayerClass == "PRIEST") then
    cSpells = {};
    canDebuff = true;
    
    -- Cure Disease / Abolish Disease
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_CUREDISEASE)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_CUREDISEASE, i};
    end
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_ABOLISHDISEASE)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_ABOLISHDISEASE, i};    
    end
    i = i + 1;
    
    --Dispel Magic
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_DISPELLMAGIC)) then
      cSpells[SMARTDEBUFF_MAGIC] = {SMARTDEBUFF_DISPELLMAGIC, i};
    end
    
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_RENEW)) then
      cHeals[SMARTDEBUFF_HEAL] = {SMARTDEBUFF_RENEW, 1};
    end    
    
    --cSpells[SMARTDEBUFF_MAGIC] = SMARTDEBUFF_DISPELLMAGIC;
    --canDebuffEnemyMagic = true;
  elseif (sPlayerClass == "MAGE") then
    cSpells = {};
    canDebuff = true;
    
    -- Remove Lesser Curse
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_REMOVELESSERCURSE)) then
      cSpells[SMARTDEBUFF_CURSE] = {SMARTDEBUFF_REMOVELESSERCURSE, i};
    end
    i = i + 1;    
    
    -- Polymorph
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_POLYMORPH)) then
      cSpells[SMARTDEBUFF_CHARMED] = {SMARTDEBUFF_POLYMORPH, i};
    end
  elseif (sPlayerClass == "PALADIN") then
    cSpells = {};
    canDebuff = true;
    
    -- Purify (Disease, Poison)
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_PURIFY)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_PURIFY, i};
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_PURIFY, i};
    end
    
    --Cleanse (Disease, Poison, Magic)
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_CLEANSE)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_CLEANSE, i};
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_CLEANSE, i};    
      cSpells[SMARTDEBUFF_MAGIC] = {SMARTDEBUFF_CLEANSE, i};
    end
  elseif (sPlayerClass == "SHAMAN") then
    cSpells = {};
    canDebuff = true;
    
    -- Cure Disease / Abolish Disease
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_CUREDISEASE)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_CUREDISEASE, i};
    end
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_ABOLISHDISEASE)) then
      cSpells[SMARTDEBUFF_DISEASE] = {SMARTDEBUFF_ABOLISHDISEASE, i}; 
    end
    i = i + 1;
    
    -- Cure Poison / Abolish Poison
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_CUREPOISON)) then
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_CUREPOISON, i};
    end
    if (SMARTDEBUFF_GetSpellID(SMARTDEBUFF_ABOLISHPOISON)) then
      cSpells[SMARTDEBUFF_POISON] = {SMARTDEBUFF_ABOLISHPOISON, i};
    end
    
    --Purge
    --cSpells[SMARTDEBUFF_MAGIC] = SMARTDEBUFF_PURGE;    
  end
  
end


-- Init the SmartDebuff variables ---------------------------------------------------------------------------------------
function SMARTDEBUFF_Options_Init()
  if (isInit or InCombatLockdown()) then return; end 

	_, sPlayerClass = UnitClass("player");
	sRealmName = GetCVar("RealmName");
	sPlayerName = UnitName("player");
	sID = sRealmName .. ":" .. sPlayerName;
	
	SMARTDEBUFF_SetSpells();
  
  if (not SMARTDEBUFF_Options) then SMARTDEBUFF_Options = { }; end
	if (SMARTDEBUFF_Options.Toggle == nil) then	SMARTDEBUFF_Options.Toggle = true; end
  if (SMARTDEBUFF_Options.ShowSF == nil) then SMARTDEBUFF_Options.ShowSF = true; end
  if (SMARTDEBUFF_Options.ShowPets == nil) then SMARTDEBUFF_Options.ShowPets = true; end  
  
  if (SMARTDEBUFF_Options.ShowClassColors == nil) then SMARTDEBUFF_Options.ShowClassColors = true; end
  if (SMARTDEBUFF_Options.SortedByClass == nil) then SMARTDEBUFF_Options.SortedByClass = true; end
  if (SMARTDEBUFF_Options.ShowLR == nil) then SMARTDEBUFF_Options.ShowLR = false; end
  
  if (SMARTDEBUFF_Options.DebuffGrp == nil) then	SMARTDEBUFF_Options.DebuffGrp = {true, true, true, true, true, true, true, true}; end
  if (SMARTDEBUFF_Options.ANormal == nil) then SMARTDEBUFF_Options.ANormal = 0.6; end
  if (SMARTDEBUFF_Options.ANormalOOR == nil) then SMARTDEBUFF_Options.ANormalOOR = 0.3; end
  if (SMARTDEBUFF_Options.ADebuff == nil) then SMARTDEBUFF_Options.ADebuff = 1.0; end
  
  if (SMARTDEBUFF_Options.ColNormal == nil) then SMARTDEBUFF_Options.ColNormal = { r = 0.39, g = 0.42, b = 0.64 }; end
  if (SMARTDEBUFF_Options.ColDebuffL == nil) then SMARTDEBUFF_Options.ColDebuffL = { r = 0.0, g = 0.0, b = 1.0 }; end
  if (SMARTDEBUFF_Options.ColDebuffR == nil) then SMARTDEBUFF_Options.ColDebuffR = { r = 1.0, g = 0.0, b = 0.0 }; end
  
  if (SMARTDEBUFF_Options.ShowHP == nil) then SMARTDEBUFF_Options.ShowHP = true; end
  if (SMARTDEBUFF_Options.ShowMana == nil) then SMARTDEBUFF_Options.ShowMana = true; end
  if (SMARTDEBUFF_Options.Invert == nil) then SMARTDEBUFF_Options.Invert = true; end
  if (SMARTDEBUFF_Options.BtnW == nil) then SMARTDEBUFF_Options.BtnW = 28; end
  if (SMARTDEBUFF_Options.BtnH == nil) then SMARTDEBUFF_Options.BtnH = 20; end
  
  if (SMARTDEBUFF_Options.ShowTooltip == nil) then SMARTDEBUFF_Options.ShowTooltip = true; end
  if (SMARTDEBUFF_Options.UseSound == nil) then SMARTDEBUFF_Options.UseSound = false; end
  if (SMARTDEBUFF_Options.TargetMode == nil) then SMARTDEBUFF_Options.TargetMode = false; end
      
  if (not SMARTDEBUFF_Options.AddList) then SMARTDEBUFF_Options.AddList = { }; end
  if (not SMARTDEBUFF_Options.IgnoreList) then SMARTDEBUFF_Options.IgnoreList = { }; end
  
  if (not SMARTDEBUFF_Options.ShowMsgNormal) then SMARTDEBUFF_Options.ShowMsgNormal = true; end
  if (not SMARTDEBUFF_Options.ShowMsgError) then SMARTDEBUFF_Options.ShowMsgError = true; end
  if (not SMARTDEBUFF_Options.ShowMsgWarning) then SMARTDEBUFF_Options.ShowMsgWarning = true; end
	
	  
  if (SMARTDEBUFF_Options.FirstStart == nil) then SMARTDEBUFF_Options.FirstStart = "V0";	end
  if (SMARTDEBUFF_Options.Debug == nil) then SMARTDEBUFF_Options.Debug = false;	end 
	
  -- Cosmos support
  if(EarthFeature_AddButton) then 
    EarthFeature_AddButton(
      { id = SMARTDEBUFF_TITLE;
        name = SMARTDEBUFF_TITLE;
        subtext = SMARTDEBUFF_SUBTITLE; 
        tooltip = "";      
        icon = imgSDB;
        callback = SMARTDEBUFF_ToggleSF;
        test = nil;
      } );
  elseif (Cosmos_RegisterButton) then 
    Cosmos_RegisterButton(SMARTDEBUFF_TITLE, SMARTDEBUFF_TITLE, SMARTDEBUFF_SUBTITLE, imgSDB, SMARTDEBUFF_ToggleSF);
  end

	-- CTMod support
	if(CT_RegisterMod) then
		CT_RegisterMod(
			SMARTDEBUFF_TITLE,
			SMARTDEBUFF_SUBTITLE,
			5,
			imgSDB,
			SMARTDEBUFF_DESC,
			"switch",
			"",
			SMARTDEBUFF_ToggleSF);
	end
  
  if (canDebuff) then
    SMARTDEBUFF_CreateButtons();
  end
  
	SMARTDEBUFF_AddMsg(SMARTDEBUFF_VERS_TITLE .. " " .. SMARTDEBUFF_MSG_LOADED, true);
  SMARTDEBUFF_AddMsg("/sdb - " .. SMARTDEBUFF_MSG_SDB, true);
	isInit = true;  
	
	if (SMARTDEBUFF_Options.FirstStart ~= SMARTDEBUFF_VERSION) then
	  SMARTDEBUFF_Options.FirstStart = SMARTDEBUFF_VERSION;
	  SMARTDEBUFF_ToggleOF();
	end
  SMARTDEBUFF_SetUnits();
  SMARTDEBUFF_CheckSF();
  
end
-- END SMARTDEBUFF_Options_Init


-- SmartDebuff commandline menu ---------------------------------------------------------------------------------------
function SMARTDEBUFF_command(msg)
  if (not isInit) then
    SMARTDEBUFF_AddMsgWarn(SMARTDEBUFF_VERS_TITLE.." not initialized correctly!", true);
    return;
  end
  
  if(msg == "help" or msg == "?") then
    SMARTDEBUFF_AddMsg(SMARTDEBUFF_VERS_TITLE, true);
    SMARTDEBUFF_AddMsg("Syntax: /sdb [command] or /smartdebuff [command]", true);
    SMARTDEBUFF_AddMsg("o  -  " .. SMARTBUFF_OFT, true); 
  elseif (msg == "options" or msg == "o") then
    SMARTDEBUFF_ToggleOF();
  elseif (msg == "debug") then
    SMARTDEBUFF_Options.Debug = SMARTDEBUFF_toggleBool(SMARTDEBUFF_Options.Debug, "Debug active = ");  
  else
    SMARTDEBUFF_ToggleSF();
  end
end
-- END SMARTDEBUFF_command


-- Playerlist functions ---------------------------------------------------------------------------------------
--[[
function SmartBuff_PlayerSetup_OnShow()
end

function SmartBuff_PlayerSetup_OnHide()
end

function SmartBuff_PS_GetList()
  if (iCurrentList == 1) then
    return SMARTBUFF_Options.AddList;
  else
    return SMARTBUFF_Options.IgnoreList;
  end  
end

function SmartBuff_PS_GetUnitList()
  if (iCurrentList == 1) then
    return cAddUnitList;
  else
    return cIgnoreUnitList;
  end
end

function SmartBuff_UnitIsAdd(unit)
  local b = false;
  if (unit and cAddUnitList[unit]) then
    b = true;
  end
  return b;
end

function SmartBuff_UnitIsIgnored(unit)
  local b = false;
  if (unit and cIgnoreUnitList[unit]) then
    b = true;
  end
  return b;
end

function SmartBuff_PS_Show(i)
  iCurrentList = i;
  iLastPlayer = -1;
  local obj = SmartBuff_PlayerSetup_Title;
  if (iCurrentList == 1) then
    obj:SetText("Additional list");
  else
    obj:SetText("Ignore list");
  end
  obj:ClearFocus();
  SmartBuff_PlayerSetup_EditBox:ClearFocus();
  SmartBuff_PlayerSetup:Show();
  SmartBuff_PS_SelectPlayer(0);  
end

function SmartBuff_PS_AddPlayer()
  local cList = SmartBuff_PS_GetList();
  local un = UnitName("target");
  if (un and not UnitIsUnit("player", "target") and UnitIsPlayer("target") and (UnitInRaid("target") or UnitInParty("target") or SMARTBUFF_Options.Debug)) then
	  if (not cList[un]) then
	    cList[un] = true;
      SmartBuff_PS_SelectPlayer(0);    
    end
  end
end

function SmartBuff_PS_RemovePlayer()
  local n = 0;
  local cList = SmartBuff_PS_GetList();
  for player in pairs(cList) do
    n = n + 1;
    if (n == iLastPlayer) then
      cList[player] = nil;
      break;
    end
  end  
  SmartBuff_PS_SelectPlayer(0);  
end

function SmartBuff_AddToUnitList(idx, unit, subgroup)
  iCurrentList = idx;
  local cList = SmartBuff_PS_GetList();
  local cUnitList = SmartBuff_PS_GetUnitList(); 
  if (unit and subgroup) then
    local un = UnitName(unit);
    if (un and cList[un]) then
      cUnitList[unit] = subgroup;
      --SMARTDEBUFF_AddMsgD("Added to UnitList:" .. un .. "(" .. unit .. ")");
    end
  end
end

function SmartBuff_PS_SelectPlayer(iOp)
  local idx = iLastPlayer + iOp;
  local cList = SmartBuff_PS_GetList();
  local s = "";
  
  local tn = 0;
  for player in pairs(cList) do
    tn = tn + 1;
    s = s .. player .. "\n";
  end
  
  -- update list in textbox
  if (iOp == 0) then
	  SmartBuff_PlayerSetup_EditBox:SetText(s);
	  --SmartBuff_PlayerSetup_EditBox:ClearFocus();
	end
  
  -- highlight selected player
  if (tn > 0) then
    if (idx > tn) then idx = tn; end
    if (idx < 1)  then idx = 1; end
    iLastPlayer = idx;
    --SmartBuff_PlayerSetup_EditBox:ClearFocus();
    local n = 0;
    local i = 0;
    local w = 0;
	  for player in pairs(cList) do
	    n = n + 1;
	    w = string.len(player);
	    if (n == idx) then
	      SmartBuff_PlayerSetup_EditBox:HighlightText(i + n - 1, i + n + w);
	      break;
	    end
	    i = i + w;
	  end
	end
end

function SmartBuff_PS_Resize()
  local h = SmartBuffOptionsFrame:GetHeight();
  local b = true;
  
  if (h < 200) then
    SmartBuffOptionsFrame:SetHeight(SMARTBUFF_OPTIONSFRAME_HEIGHT);
    --SmartBuff_BuffSetup:SetHeight(SMARTBUFF_OPTIONSFRAME_HEIGHT);
    b = true;
  else
    SmartBuffOptionsFrame:SetHeight(40);
    --SmartBuff_BuffSetup:SetHeight(40);
    b = false;
  end
  SmartBuff_ShowControls("SmartBuffOptionsFrame", b); 
  if (b) then
    SMARTBUFF_SetCheckButtonBuffs(1);
  end
end
]]--
-- END Playerlist functions




-- SmartDebuff frame functions

function SMARTDEBUFF_ToggleSF()
  if (not isInit or not canDebuff or InCombatLockdown()) then return; end
  
  SMARTDEBUFF_Options.ShowSF = not SMARTDEBUFF_Options.ShowSF;
  SMARTDEBUFF_CheckSF();
  
  if (IsAddOnLoaded("SmartBuff") and SmartBuffOptionsFrame:IsVisible()) then
    if (SmartBuffOptionsFrame_cbSmartDebuff) then
      SmartBuffOptionsFrame_cbSmartDebuff:SetChecked(SMARTDEBUFF_Options.ShowSF);
    end
  end
end

function SMARTDEBUFF_CheckSF()
  if (not isInit or not canDebuff or InCombatLockdown()) then return; end
  
  if (not SMARTDEBUFF_Options.ShowSF) then
    SmartDebuffSF:Hide();
  else
    SmartDebuffSF:Show();
    SMARTDEBUFF_CheckSFButtons();
    SMARTDEBUFF_SetUnits();
  end
end

function SMARTDEBUFF_CheckSFButtons(hide)
  if (SmartDebuffSF:IsVisible()) then
    if (canDebuff and not InCombatLockdown() and not hide) then
      SmartDebuffSF_Title:SetText("martDebuff");
      SmartDebuffSF_btnClose:Show();
      SmartDebuffSF_btnStyle:Show();
      SmartDebuffSF_btnOptions:Show();
    else
      SmartDebuffSF_Title:SetText("SmartDebuff");
      SmartDebuffSF_btnClose:Hide();
      SmartDebuffSF_btnStyle:Hide();
      SmartDebuffSF_btnOptions:Hide();
      SmartDebuffOF:Hide();  
    end
  end
end




function SMARTDEBUFF_CreateButtons()
  local frame = getglobal("SmartDebuffSF");
  
	if (frame) then
    local i = 1;
    
    for i = 1, maxRaid, 1 do
          
      local button = CreateFrame("Button", "SmartDebuffBtn"..i, frame, "SecureActionButtonTemplate");
      button:SetWidth(1);
      button:SetHeight(1);
      button:ClearAllPoints();
      
    	-- create bg texture
    	button.texture = button:CreateTexture(nil, "BORDER");
    	button.texture:SetTexture(0, 0, 0);
    	button.texture:SetAllPoints(button);
    	button.texture:SetBlendMode("BLEND");
    	
    	-- create hp texture
    	button.hp = button:CreateTexture(nil, "STATUSBAR");
    	button.hp:SetTexture(0, 1, 0);
    	button.hp:SetBlendMode("DISABLE");
      button.hp:ClearAllPoints();
    	
    	-- create mana texture
    	button.mana = button:CreateTexture(nil, "STATUSBAR");
    	button.mana:SetTexture(0, 0, 1);
    	button.mana:SetBlendMode("DISABLE");
      button.mana:ClearAllPoints();
      
      button:EnableMouse(true);
      --button:EnableMouseWheel(true);
      button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
      button:SetScript("OnEnter", SMARTDEBUFF_ButtonTooltipOnEnter);
      button:SetScript("OnLeave", SMARTDEBUFF_ButtonTooltipOnLeave);
      
      button:SetAttribute("unit", nil);
      button:SetAttribute("type1", "spell");
      button:SetAttribute("type2", "spell");
      button:SetAttribute("type3", "target");
      button:SetAttribute("spell1", nil);
      button:SetAttribute("spell2", nil);
    end
    
    for i = 1, maxPets, 1 do      
      local button = CreateFrame("Button", "SmartDebuffPetBtn"..i, frame, "SecureActionButtonTemplate");
      button:SetWidth(1);
      button:SetHeight(1);
      button:ClearAllPoints();
      
    	-- create bg texture
    	button.texture = button:CreateTexture(nil, "BORDER");
    	button.texture:SetTexture(0, 0, 0);
    	button.texture:SetAllPoints(button);
    	button.texture:SetBlendMode("BLEND");
    	
    	-- create hp texture
    	button.hp = button:CreateTexture(nil, "STATUSBAR");
    	button.hp:SetTexture(0, 1, 0);
    	button.hp:SetBlendMode("DISABLE");
      button.hp:ClearAllPoints();
    	
    	-- create mana texture
    	button.mana = button:CreateTexture(nil, "STATUSBAR");
    	button.mana:SetTexture(0, 0, 1);
    	button.mana:SetBlendMode("DISABLE");
      button.mana:ClearAllPoints();
      
      button:EnableMouse(true);
      button:RegisterForClicks("LeftButtonUp", "RightButtonUp");
      button:SetScript("OnEnter", SMARTDEBUFF_ButtonTooltipOnEnter);
      button:SetScript("OnLeave", SMARTDEBUFF_ButtonTooltipOnLeave);      
      
      button:SetAttribute("unit", nil);
      button:SetAttribute("type1", "spell");
      button:SetAttribute("type2", "spell");
      button:SetAttribute("type3", "target");
      button:SetAttribute("spell1", nil);
      button:SetAttribute("spell2", nil);      
    end
	end
end

function SMARTDEBUFF_SetButtons()
  if (not isInit or not canDebuff or InCombatLockdown()) then return; end
  
  local i, j;
  -- reset all buttons
  for i = 1, maxRaid, 1 do
    SMARTDEBUFF_SetButton(nil, i, nil, nil, nil);
  end  
  
  local spell1 = nil;
  local spell2 = nil;
  if (cSpells) then
    for debuff in pairs(cSpells) do
      if (debuff) then
        if (cSpells[debuff][2] == 1) then
          spell1 = cSpells[debuff][1];
          SMARTDEBUFF_AddMsgD("Set spell 1: " .. spell1);
        elseif (cSpells[debuff][2] == 2) then
          spell2 = cSpells[debuff][1];
          SMARTDEBUFF_AddMsgD("Set spell 2: " .. spell2);
        end
      end
    end
  else
    return;
  end
  
  local heal1 = nil;
  if (cHeals[SMARTDEBUFF_HEAL]) then
    heal1 = cHeals[SMARTDEBUFF_HEAL][1];
  end
  
  local unitpre = "";
  local nMax = 0;
  local frame = getglobal("SmartDebuffSF");
  -- set buttons depending on group size
  if (iGroupSetup == 3) then
    unitpre = "raid";
    nMax = maxRaid;
  elseif (iGroupSetup == 2) then
    unitpre = "party";
    nMax = 5;
    SMARTDEBUFF_SetButton("player", 1, spell1, spell2, heal1);
  elseif (iGroupSetup == 1) then
    SMARTDEBUFF_SetButton("player", 1, spell1, spell2, heal1);
  else
    return;
  end
  
  local unit, units;
  if (iGroupSetup == 2) then
    for i = 2, nMax, 1 do
      unit = unitpre..(i - 1);
      if (UnitExists(unit)) then
        SMARTDEBUFF_SetButton(unit, i, spell1, spell2, heal1);
      end
    end
  elseif (iGroupSetup == 3) then    
    i = 1;
    local cGrp;
    local cl, data, units;
    
    if (SMARTDEBUFF_Options.SortedByClass) then
      cGrp = cClasses;
      for j, cl in ipairs(cOrderClass) do
        units = cGrp[cl];
        if (units) then
          for _, data in pairs(units) do
            if (UnitExists(data.Unit) and SMARTDEBUFF_Options.DebuffGrp[data.Subgroup]) then
              SMARTDEBUFF_SetButton(data.Unit, i, spell1, spell2, heal1);
              i = i + 1;
            end
          end
        end
      end    
      
    else
      cGrp = cGroups;
      for j = 1, 8, 1 do
        units = cGrp[j];
        if (units and SMARTDEBUFF_Options.DebuffGrp[j]) then
          for _, data in pairs(units) do
            if (UnitExists(data.Unit)) then
              SMARTDEBUFF_SetButton(data.Unit, i, spell1, spell2, heal1);
              i = i + 1;
            end
          end
        end
        if (math.fmod(i - 1, 5) ~= 0) then
          i = i + (5 - math.fmod(i - 1, 5));
        end
      end      
    end

  end
  --SMARTDEBUFF_AddMsgD("Debuff buttons set");
  
  SMARTDEBUFF_SetPetButtons(spell1, spell2, heal1);  
  SMARTDEBUFF_SetStyle();
end

function SMARTDEBUFF_SetPetButtons(spell1, spell2, heal1)
  if (not isInit or not canDebuff or InCombatLockdown()) then return; end
    
  local i;
  local b = false;
  -- reset all buttons
  for i = 1, maxPets, 1 do
    SMARTDEBUFF_SetButton(nil, i, nil, nil, nil, 1);
  end
  
  if (not spell1 and not spell2) then
    b = true;
    if (cSpells) then
      for debuff in pairs(cSpells) do
        if (debuff) then
          if (cSpells[debuff][2] == 1) then
            spell1 = cSpells[debuff][1];
            SMARTDEBUFF_AddMsgD("Set spell 1: " .. spell1);
          elseif (cSpells[debuff][2] == 2) then
            spell2 = cSpells[debuff][1];
            SMARTDEBUFF_AddMsgD("Set spell 2: " .. spell2);
          end
        end
      end
    else
      return;
    end
  end
  
  if (not heal1 and cHeals[SMARTDEBUFF_HEAL]) then
    heal1 = cHeals[SMARTDEBUFF_HEAL][1];
  end  
  
  local data;
  if (SMARTDEBUFF_Options.ShowPets) then
    i = 1;
    for _, data in pairs(cPets) do
      if (UnitExists(data.Unit) and i <= maxPets) then
        --local _, uc = UnitClass(data.Owner);
        --SMARTDEBUFF_AddMsgD("Set Pet: " .. unit .. ", " .. UnitName(unit) .. ", " .. uc);
        if (data.OwnerClass and data.OwnerClass == "HUNTER" and (iGroupSetup ~= 3 or (iGroupSetup == 3 and SMARTDEBUFF_Options.DebuffGrp[data.Subgroup]))) then
          --SMARTDEBUFF_AddMsgD("Set Pet: " .. unit .. ", " .. UnitName(unit));
          SMARTDEBUFF_SetButton(data.Unit, i, spell1, spell2, heal1, 1);
          i = i + 1;
        end
      end
    end
  end

  --SMARTDEBUFF_AddMsgD("Debuff pet buttons set");
  
  if (b) then
    SMARTDEBUFF_SetStyle();
  end
end


function SMARTDEBUFF_SetButton(unit, idx, spell1, spell2, heal1, pet)
  if (not canDebuff or InCombatLockdown()) then return; end
  
  local btn;
  if (pet) then
    btn = getglobal("SmartDebuffPetBtn"..idx);
  else
    btn = getglobal("SmartDebuffBtn"..idx);
  end
  
  if (not btn) then return; end
  
  if (SMARTDEBUFF_Options.TargetMode) then
    btn:SetAttribute("unit", unit);
    btn:SetAttribute("type1", "target");
    btn:SetAttribute("type2", "spell");
    btn:SetAttribute("spell2", heal1);      
    btn:SetAttribute("alt-type1", "spell");
    btn:SetAttribute("alt-spell1", spell1);
    btn:SetAttribute("alt-type2", "spell");
    btn:SetAttribute("alt-spell2", spell2);
    btn:SetAttribute("shift-type1", nil);    
  else
    btn:SetAttribute("unit", unit);
    btn:SetAttribute("type1", "spell");
    btn:SetAttribute("type2", "spell");
    btn:SetAttribute("spell1", spell1);
    btn:SetAttribute("spell2", spell2);
    btn:SetAttribute("alt-type1", "spell");
    btn:SetAttribute("alt-spell1", heal1);
    btn:SetAttribute("alt-type2", nil);
    btn:SetAttribute("alt-spell2", nil);
    btn:SetAttribute("shift-type1", "target");
  end
  
  if (unit) then
    btn:SetAlpha(0.5);
    btn:Show();
  else
    btn:SetAlpha(0.1);
    btn:Hide();
  end
end


function SMARTDEBUFF_SetButtonState(unit, idx, nr, ir, pet)
  local btn;
  local un = "";
  local uc = "";
  local st = "";

  if (pet) then
    btn = getglobal("SmartDebuffPetBtn"..idx);
  else
    btn = getglobal("SmartDebuffBtn"..idx);
  end
  
  if (not btn) then return; end
  
  local col = nil;
  if (unit and UnitExists(unit) and not pet) then
    un = UnitName(unit);
    _, uc = UnitClass(unit);
    if (SMARTDEBUFF_Options.ShowClassColors) then
      col = RAID_CLASS_COLORS[uc];
    end
  elseif (unit and UnitExists(unit)) then
    un = UnitName(unit);
    if (pet and SMARTDEBUFF_Options.ShowClassColors) then
      col = { r = 0.39, g = 0.42, b = 0.64 };
    end
  end
    
  if (not col) then
    col = SMARTDEBUFF_Options.ColNormal;
  end
  
  --SMARTDEBUFF_AddMsgD(un);
  
  if (unit and UnitExists(unit)) then
    if (UnitIsAFK(unit)) then
      un = "AFK";
      col = { r = 0.2, g = 0.1, b = 0 };
    end  
    if (UnitIsDeadOrGhost(unit) or not UnitIsConnected(unit)) then
      col = { r = 0, g = 0, b = 0 };
      if (not UnitIsConnected(unit)) then
        un = "offline";
      else
        if (uc and uc == "HUNTER" and SMARTDEBUFF_IsFeignDeath(unit)) then
          un = "-FD-";
          col = { r = 0.15, g = 0.05, b = 0 };
        else
          un = "+" .. un .. "+";
        end
      end
    end
    local wd = math.floor(btn:GetWidth() / 5.5);
    if (string.len(un) > wd) then
      un = string.sub(un, 1, wd);
    end
    st = un;
  else
    st = "?";
  end
  
  -- GameFontHighlightSmall
  -- GameFontHighlightLarge
  -- SmartDebuff_GameFontHighlightMini  
  btn:SetTextFontObject("SmartDebuff_GameFontHighlightMini");
  btn:SetHighlightFontObject("SmartDebuff_GameFontHighlightMini");  
  if (nr == 0) then
    btn.texture:SetTexture(col.r, col.g, col.b, 0.6);
    if (ir == 1) then
      btn:SetAlpha(SMARTDEBUFF_Options.ANormal);
    else
      btn:SetAlpha(SMARTDEBUFF_Options.ANormalOOR);
    end
  elseif (nr == 1) then
    col = SMARTDEBUFF_Options.ColDebuffL;
    if (ir == 1) then
      btn.texture:SetTexture(col.r, col.g, col.b, 1);
      if (SMARTDEBUFF_Options.ShowLR) then
        st = "L";
      end
    else
      btn.texture:SetTexture(col.r / 2, col.g / 2, col.b / 2, 1);
      if (SMARTDEBUFF_Options.ShowLR) then
        st = "-";
      end
    end
    btn:SetAlpha(SMARTDEBUFF_Options.ADebuff);
    if (SMARTDEBUFF_Options.ShowLR) then
      btn:SetTextFontObject("GameFontHighlightLarge");
      btn:SetHighlightFontObject("GameFontHighlightLarge");    
    end
  elseif (nr == 2) then
    col = SMARTDEBUFF_Options.ColDebuffR;
    if (ir == 1) then
      btn.texture:SetTexture(col.r, col.g, col.b, 1);
      if (SMARTDEBUFF_Options.ShowLR) then
        st = "R";
      end
    else
      btn.texture:SetTexture(col.r / 2, col.g / 2, col.b / 2, 1);
      if (SMARTDEBUFF_Options.ShowLR) then
        st = "-";
      end
    end
    btn:SetAlpha(SMARTDEBUFF_Options.ADebuff);
    if (SMARTDEBUFF_Options.ShowLR) then
      btn:SetTextFontObject("GameFontHighlightLarge");
      btn:SetHighlightFontObject("GameFontHighlightLarge");     
    end
  else
    btn.texture:SetTexture(col.r, col.g, col.b, 0.6);
    btn:SetAlpha(SMARTDEBUFF_Options.ANormalOOR);
  end
  btn:SetText(st);
  btn.texture:SetAllPoints(btn);
  
  SmartDebuff_SetButtonBars(btn, unit);
end

function SmartDebuff_SetButtonBars(btn, unit)
  if (unit) then -- and btn:IsVisible()
    local w = btn:GetWidth();
    local h = btn:GetHeight() / 4 - 1;
    local upt = UnitPowerType(unit);
    local cur = UnitHealth(unit);
    local nmax = UnitHealthMax(unit);
    local n = math.floor(w * (cur / nmax));
    local col = { r = 0, g = 1, b = 0 };
    
    --btn.hp:ClearAllPoints();
    --btn.mana:ClearAllPoints();
    
    if (SMARTDEBUFF_Options.Invert) then n = w - n; end
    if (n <= 0 or n > w or UnitIsDeadOrGhost(unit) or not UnitIsConnected(unit) or not SMARTDEBUFF_Options.ShowHP) then n = 0; end
    --if (n == max) then n = w; end;
    btn.hp:SetTexture(col.r, col.g, col.b, 1);
    btn.hp:SetPoint("TOPLEFT", btn , "TOPLEFT", 0, 0);
    btn.hp:SetPoint("TOPRIGHT", btn , "TOPLEFT", n, 0);
    btn.hp:SetPoint("BOTTOMLEFT", btn , "TOPLEFT", 0, -h);
    btn.hp:SetPoint("BOTTOMRIGHT", btn , "TOPLEFT", n, -h);
    
    cur = UnitMana(unit);
    nmax = UnitManaMax(unit);
    n = math.floor(w * (cur / nmax));
    if (upt == 3) then
      -- 3 for Energy
      col = { r = 1, g = 1, b = 0 };
    elseif (upt == 2) then
      -- 2 for Focus (hunter pets)
      col = { r = 1, g = 0.5, b = 0.25 };
    elseif (upt == 1) then
      -- 1 for Rage
      col = { r = 1, g = 0, b = 0 };
    else
      -- 0 for Mana 
      col = { r = 0, g = 0, b = 1 };
    end
    
    if (SMARTDEBUFF_Options.Invert) then n = w - n; end
    if (n <= 0 or n > w or upt ~= 0 or UnitIsDeadOrGhost(unit) or not UnitIsConnected(unit) or not SMARTDEBUFF_Options.ShowMana) then n = 0; end
    --if (n == max) then n = w; end;
    btn.mana:SetTexture(col.r, col.g, col.b, 1);
    
    btn.mana:SetPoint("TOPLEFT", btn , "BOTTOMLEFT", 0, h);
    btn.mana:SetPoint("TOPRIGHT", btn , "BOTTOMLEFT", n, h);
    btn.mana:SetPoint("BOTTOMLEFT", btn , "BOTTOMLEFT", 0, 0);
    btn.mana:SetPoint("BOTTOMRIGHT", btn , "BOTTOMLEFT", n, 0);      
  end
end


function SMARTDEBUFF_SetStyle()
  if (not canDebuff) then return; end
  
  local frmH, frmW, btnH, btnW;
  local cds;
  local nMax = 0;
  local frame = getglobal("SmartDebuffSF");
  if (not frame:IsVisible()) then return; end;  
  
  if (iGroupSetup == 3) then
    nMax = maxRaid;
  elseif (iGroupSetup == 2) then
    nMax = 5;
  elseif (iGroupSetup == 1) then
    nMax = 1;
  else
    return;
  end
  
  btnW = SMARTDEBUFF_Options.BtnW;
  btnH = SMARTDEBUFF_Options.BtnH;
  
  if (btnW == btnH) then
    cds = 1;
  else
    cds = 2;
  end
  
  local i = 0;
  local j = 0;
  local btn;
  local sp = 0;
  local ln = 0;
  local offX = 0;
  local offY = 0;
  local sbtn, unit, uc, luc;

  for j = 0, (nMax - 1), 1 do
    btn = getglobal("SmartDebuffBtn"..(j + 1));
    btn:SetWidth(btnW);
    btn:SetHeight(btnH);        

    if (SMARTDEBUFF_Options.SortedByClass) then
      if (btn:IsVisible()) then
        sbtn = SecureStateChild_GetEffectiveButton(btn);
        unit = SecureButton_GetModifiedAttribute(btn, "unit", sbtn, "");
        _, uc = UnitClass(unit);
        if (j == 0) then luc = uc; end
        
        if (j > 0 and luc ~= uc) then
          luc = uc;
          i = 0;
          sp = sp + btnW + 4;
        end
        btn:SetPoint("TOPLEFT", frame, "TOPLEFT", 4 + sp, -20 - i * (btnH + 2));
      end
    
    elseif (cds == 2) then
      if (j > 0 and math.fmod(j, 5) == 0) then
        i = 0;
        sp = sp + btnW + 4;
      end
      if (j > 0 and math.fmod(j, 20) == 0) then
        sp = 0;
        ln = ln + 5 * (btnH + 2) + 4;
      end
      btn:SetPoint("TOPLEFT", frame, "TOPLEFT", 4 + sp, -20 - i * (btnH + 2) - ln);
    else
      if (j > 0 and math.fmod(j, 5) == 0) then
        sp = sp + 4;
      end
      if (j > 0 and math.fmod(j, 10) == 0) then
        ln = ln + 1;
        sp = 0;
        i = 0;
      end    
      btn:SetPoint("TOPLEFT", frame, "TOPLEFT", 4 + i * (btnW + 2) + sp, -20 - ln * (btnW + 4));
    end
    
    if (btn:IsVisible()) then
      local tX = btn:GetLeft() - frame:GetLeft() + btnW + 8;
      local tY = frame:GetTop() - btn:GetTop() + btnH + 4;
      if (tX > offX) then
        offX = tX;
      end
      if (tY > offY) then
        offY = tY;
      end
      --SMARTDEBUFF_AddMsgD("Get button values");
    end     
    i = i + 1;
  end
  
  i = 0;
  j = 0;
  sp = 0;
  ln = 0;
  local offPX = offX;
  for j = 0, 19, 1 do
    btn = getglobal("SmartDebuffPetBtn"..(j + 1));
    btn:SetWidth(btnW);
    btn:SetHeight(btnH);        

    if (SMARTDEBUFF_Options.SortedByClass) then
      btn:SetPoint("TOPLEFT", frame, "TOPLEFT", offX + sp, -20 - i * (btnH + 2));
    elseif (cds == 2) then
      if (j > 0 and math.fmod(j, 5) == 0) then
        i = 0;
        sp = sp + btnW + 4;
      end
      if (j > 0 and math.fmod(j, 10) == 0) then
        sp = 0;
        ln = ln + 5 * (btnH + 2) + 4;
      end
      btn:SetPoint("TOPLEFT", frame, "TOPLEFT", offX + sp, -20 - i * (btnH + 2) - ln);
    else
      if (j > 0 and math.fmod(j, 5) == 0) then
        sp = sp + 4;
      end
      if (j > 0 and math.fmod(j, 5) == 0) then
        ln = ln + 1;
        sp = 0;
        i = 0;
      end    
      btn:SetPoint("TOPLEFT", frame, "TOPLEFT", offX + i * (btnW + 2) + sp, -20 - ln * (btnW + 4));
    end
    if (btn:IsVisible()) then
      offPX = btn:GetLeft() - frame:GetLeft() + btnW + 8;
    end    
    i = i + 1;
  end  
  
  frmW = offPX - 4;
  frmH = offY;
  if (frmW < 120) then frmW = 120; end
  frame:SetWidth(frmW);
  if (frmH < 20) then frmH = 20; end
  frame:SetHeight(frmH);
    
  --SMARTDEBUFF_AddMsgD("Debuff style set");
  SMARTDEBUFF_CheckDebuffs(true);
end


function SMARTDEBUFF_ToggleClassColors()
  SMARTDEBUFF_Options.ShowClassColors = SMARTDEBUFF_toggleBool(SMARTDEBUFF_Options.ShowClassColors, "Use class colors = ");
  if (SmartDebuffOF:IsVisible()) then
    SmartDebuffOF_cbClassColors:SetChecked(SMARTDEBUFF_Options.ShowClassColors);
  end  
  SMARTDEBUFF_CheckDebuffs(true);
end

function SMARTDEBUFF_ToggleShowLR()
  SMARTDEBUFF_Options.ShowLR = SMARTDEBUFF_toggleBool(SMARTDEBUFF_Options.ShowLR, "Show L/R = ");
  if (SmartDebuffOF:IsVisible()) then
    SmartDebuffOF_cbShowLR:SetChecked(SMARTDEBUFF_Options.ShowLR);
  end  
  SMARTDEBUFF_CheckDebuffs(true);
end

function SMARTDEBUFF_ToggleSortedByClass()
  SMARTDEBUFF_Options.SortedByClass = SMARTDEBUFF_toggleBool(SMARTDEBUFF_Options.SortedByClass, "Sorted by class = ");
  SMARTDEBUFF_SetButtons();
end

function SMARTDEBUFF_ButtonTooltipOnEnter()
  if (not this or not this:IsVisible() or InCombatLockdown() or not SMARTDEBUFF_Options.ShowTooltip) then return; end
  
  local sbtn = SecureStateChild_GetEffectiveButton(this);
  local unit = SecureButton_GetModifiedAttribute(this, "unit", sbtn, "");
  if (unit) then
    GameTooltip_SetDefaultAnchor(GameTooltip, UIParent);
    GameTooltip:SetUnit(unit);
    GameTooltip:Show();
  end
end

function SMARTDEBUFF_ButtonTooltipOnLeave()
  GameTooltip:Hide();
end

-- END SmartDebuff frame functions


-- SmartDebuff functions
-- Main check function, called by update event
function SMARTDEBUFF_CheckDebuffs(force)
  if (not isInit or not canDebuff or (not force and GetTime() < tDebuff + 0.5)) then
    return;
  end 
  tDebuff = GetTime();
  
  hasDebuff = false;
  
  if (SmartDebuffSF:IsVisible() and cSpells) then
    local unitpre = "";
    local nMax = 0;
    local i, j;
    
    local unit, btn, sbtn, spell;
    for i = 1, maxRaid, 1 do
      btn = getglobal("SmartDebuffBtn"..i);
      sbtn = SecureStateChild_GetEffectiveButton(btn);
      if (sbtn) then
        unit = SecureButton_GetModifiedAttribute(btn, "unit", sbtn, "");
        spell = SecureButton_GetModifiedAttribute(btn, "spell1", sbtn, "");
        if (not spell) then
          spell = SecureButton_GetModifiedAttribute(btn, "spell2", sbtn, "");
        end        
        if (unit and UnitExists(unit)) then
          --SMARTDEBUFF_AddMsgD("Unit found: " .. unit .. ", " .. UnitName(unit) .. ", " .. i);
          SMARTDEBUFF_CheckUnitDebuffs(spell, unit, i);
        end
      end
    end    
    
    if (SMARTDEBUFF_Options.ShowPets) then
      i = 1;
      for i = 1, maxPets, 1  do
        btn = getglobal("SmartDebuffPetBtn"..i);
        sbtn = SecureStateChild_GetEffectiveButton(btn);
        if (sbtn) then
          unit = SecureButton_GetModifiedAttribute(btn, "unit", sbtn, "");
          spell = SecureButton_GetModifiedAttribute(btn, "spell1", sbtn, "");
          if (not spell) then
            spell = SecureButton_GetModifiedAttribute(btn, "spell2", sbtn, "");
          end
          if (unit and UnitExists(unit)) then
            --SMARTDEBUFF_AddMsgD("Pet found: " .. unit .. ", " .. UnitName(unit) .. ", " .. i);
            SMARTDEBUFF_CheckUnitDebuffs(spell, unit, i, 1);
          end
        end
      end
    end    
    
    --SMARTDEBUFF_AddMsgD("Debuffs checked");
  end
  if (not hasDebuff) then
    isSoundPlayed = false;
  end
end

-- Dectects debuffs on a single unit
function SMARTDEBUFF_CheckUnitDebuffs(spell, unit, idx, pet)  
  local name, dtype, uclass, ir;
  if (spell) then
    if (IsSpellInRange(spell, unit) == 1) then
      ir = 1;
    else
      ir = 0;
    end
    --SMARTDEBUFF_AddMsgD("Check unit: " .. unit .. ", " .. UnitName(unit) .. ", " .. idx);

    n = 1;
    while (true) do
      --name,rank,icon,count,type = UnitDebuff("unit", id or "name"[,"rank"])
      name, _, icon, _, dtype = UnitDebuff(unit, n);
      
      if (not icon) then
        break;
      end
      
      if (name and dtype) then
        --SMARTDEBUFF_AddMsgD("Debuff found: " .. name .. ", " .. dtype);
        _, uclass = UnitClass(unit);
        if (cSpells[dtype] and not UnitCanAttack("player", unit) and not SMARTDEBUFF_DEBUFFSKIPLIST[name] and not (SMARTDEBUFF_DEBUFFCLASSSKIPLIST[uclass] and SMARTDEBUFF_DEBUFFCLASSSKIPLIST[uclass][name])) then
          hasDebuff = true;
          SMARTDEBUFF_SetButtonState(unit, idx, cSpells[dtype][2], ir, pet);
          SMARTDEBUFF_PlaySound();
          return;
        end
      end

      n = n + 1;
      --SMARTDEBUFF_AddMsgD("Check debuff");
    end
    
    -- check if a player is charmed, can be attacked and is polymorphable
    if (cSpells[SMARTDEBUFF_CHARMED] and UnitIsCharmed(unit) and UnitCanAttack("player", unit) and UnitCreatureType(unit) == SMARTDEBUFF_HUMANOID) then
      hasDebuff = true;
      SMARTDEBUFF_SetButtonState(unit, idx, cSpells[SMARTDEBUFF_CHARMED][2], ir, pet);
      SMARTDEBUFF_PlaySound();
      return;
    end      
      
    SMARTDEBUFF_SetButtonState(unit, idx, 0, ir, pet);
  else
    SMARTDEBUFF_SetButtonState(unit, idx, -1, 0, pet);
  end
  
end

function SMARTDEBUFF_PlaySound()
  if (SMARTDEBUFF_Options.UseSound and not isSoundPlayed) then
    PlaySoundFile(SMARTDEBUFF_CONST_SOUND);
    isSoundPlayed = true;
    --SMARTDEBUFF_AddMsgD("Play sound");
  end
end
-- END SmartDebuff functions



function SMARTDEBUFF_ToggleOF()
  if (not isInit or not canDebuff or InCombatLockdown()) then return; end
  local frame = SmartDebuffOF;
  if (frame:IsVisible()) then
    frame:Hide();
  else
    frame:Show();
  end
end

function SMARTDEBUFF_OFToggleGrp(i)
  SMARTDEBUFF_Options.DebuffGrp[i] = not SMARTDEBUFF_Options.DebuffGrp[i];
  isSetUnits = true;
end

function SMARTDEBUFF_OFOnShow()
end

function SMARTDEBUFF_OFOnHide()
end






