PhanxChat = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "AceHook-2.1")
PhanxChat:RegisterDB("PhanxChatDB")
local L = AceLibrary("AceLocale-2.2"):new("PhanxChat")

function PhanxChat:OnInitialize()
	self.options = {
		name = L["PhanxChat"],
		desc = L["The chat box, as Phanx wishes it to be."],
		type = "group",
		args = {
			editattop = {
				name = L["Edit At Top"],
				desc = L["Moves the edit box to the top of the chat frame."],
				type = "toggle",
				get = function() return self.db.profile.editattop end,
				set = function(v) self.db.profile.editattop = v; self:EditBox() end
			},
			hidemenu = {
				name = L["Hide Menu"],
				desc = L["Hides the chat menu button."],
				type = "toggle",
				get = function() return self.db.profile.hidemenu end,
				set = function(v) self.db.profile.hidemenu = v; self:ToggleMenu() end
			},
--			reminder = {
--				name = L["Reminder Button"],
--				desc = L["Show a reminder button while scrolled up in the chat frame."],
--				type = "toggle",
--				get = function() return self.db.profile.reminder end,
--				set = function(v) self.db.profile.reminder = v end
--			},
			shortstrings = {
				name = L["Short Strings"],
				desc = L["Shortens chat strings and channel names."],
				type = "toggle",
				get = function() return self.db.profile.shortstrings end,
				set = function(v) self.db.profile.shortstrings = v; self:ShortStrings() end
			},
			stickychannels = {
				name = L["Sticky Channels"],
				desc = L["Makes channels and officer chat sticky."],
				type = "toggle",
				get = function() return self.db.profile.stickychannels end,
				set = function(v) self.db.profile.stickychannels = v; self:StickyChannels() end
			},
			noflash = {
				name = L["Suppress Flashing"],
				desc = L["Stops the chat tabs from flashing."],
				type = "toggle",
				get = function() return self.db.profile.noflash end,
				set = function(v) self.db.profile.noflash = v; self:NoFlash() end
			},
			url = {
				name = L["URL Options"],
				desc = L["Options for how URLs are transformed into clickable links for easy copying."],
				type = "group",
				args = {
					color = {
						name = L["Color"],
						desc = L["Sets the color for URLs in chat."],
						type = "color",
						hasAlpha = false,
						get = function() return self.db.profile.url.color.r, self.db.profile.url.color.g, self.db.profile.url.color.b end,
						set = function(r, g, b) self.db.profile.url.color.r, self.db.profile.url.color.g, self.db.profile.url.color.b = r, g, b end
					},
					brackets = {
						name = L["Show Brackets"],
						desc = L["Show brackets around URLs in chat."],
						type = "toggle",
						get = function() return self.db.profile.url.brackets end,
						set = function(v) self.db.profile.url.brackets = v end
					},
					popup = {
						name = L["Use Popups"],
						desc = L["Opens a popup with clicked URLs in a text box. If disabled, clicked URLs will be pasted in the chat edit box instead."],
						type = "toggle",
						get = function() return self.db.profile.url.popup end,
						set = function(v) self.db.profile.url.popup = v end
					}
				}
			}
		}
	}

	self:RegisterChatCommand({"/pchat","/pc"}, self.options)

	self:RegisterDefaults("profile", {
		editattop = true,
		hidemenu = true,
		reminder = true,
		shortstrings = true,
		stickychannels = true,
		noflash = true,
		url = {
			color = {r = 0, g = 0.4, b = 0.9},
			brackets = true,
			popup = true,
		},
		channelcolors = {},
	})
end

function PhanxChat:OnEnable()
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("UPDATE_CHAT_COLOR")
	self:RegisterEvent("CHAT_MSG_CHANNEL_NOTICE")

	self:SecureHook("ChatFrame_OnUpdate")
	self:Hook("SetItemRef",true)					-- @TODO: taint ohnoes!

	for i=1,7 do
		local cf = getglobal("ChatFrame"..i)
		self:Hook(cf, "AddMessage", true)			-- @TODO: taint ohnoes!
		self:HookScript(cf, "OnMouseWheel")
		cf:EnableMouseWheel(1)
		cf:SetMaxLines(500)
--		self:MakeReminder(i)
	end
	for i=2,7 do
		local ct = getglobal("ChatFrame"..i.."Tab")
		self:HookScript(ct, "OnDragStart")
		self:HookScript(ct, "OnDragStop")
	end

	ChatFrameMenuButton:SetAlpha(0.4)
	ChatFrameMenuButton:ClearAllPoints()
	ChatFrameMenuButton:SetPoint("TOPRIGHT", ChatFrame1, "TOPRIGHT", 0, 0)
	if self.db.profile.hidemenu then ChatFrameMenuButton:Hide() end

	local eb = VisorEditBox or ChatFrameEditBox
	eb:SetAltArrowKeyMode(false)
	self:EditBox()

	self:NoFlash()
	self:ShortStrings()
	self:StickyChannels()
end

function PhanxChat:OnDisable()
	for i = 1,7 do
		local cf = getglobal("ChatFrame"..i)
		local ub = getglobal("ChatFrame"..i.."UpButton")
		local db = getglobal("ChatFrame"..i.."DownButton")
		local bb = getglobal("ChatFrame"..i.."BottomButton")
		local rb = getglobal("ChatFrame"..i.."ReminderButton")
		ub:Show()
		db:Show()
		bb:ClearAllPoints()
		bb:SetPoint("TOP", db, "BOTTOM", 0, 2)
		bb:Show()
		rb:Hide()
	end
	local eb = VisorEditBox or ChatFrameEditBox
	eb:ClearAllPoints()
	eb:SetPoint("TOPLEFT", "ChatFrame1", "BOTTOMLEFT", -5, 0)
	eb:SetPoint("TOPRIGHT", "ChatFrame1", "BOTTOMRIGHT", 5, 0)
	eb:SetAltArrowKeyMode(true)
	ChatTypeInfo["CHANNEL"].sticky = 0
	ChatTypeInfo["OFFICER"].sticky = 0
	CHAT_FLAG_AFK = "<AFK> "
	CHAT_FLAG_DND = "<DND> "
	CHAT_FLAG_GM = "<GM> "
	CHAT_WHISPER_GET = "%s whispers:\32"
	CHAT_WHISPER_INFORM_GET = "To %s:\32"
	CHAT_GUILD_GET = "[Guild] %s:\32"
	CHAT_OFFICER_GET = "[Officer] %s:\32"
	CHAT_PARTY_GET = "[Party] %s:\32"
	CHAT_RAID_GET = "[Raid] %s:\32"
	CHAT_RAID_LEADER_GET = "[Raid Leader] %s:\32"
	CHAT_RAID_WARNING_GET = "[Raid Warning] %s:\32"
	CHAT_BATTLEGROUND_GET =  "[Battleground] %s:\32"
	CHAT_BATTLEGROUND_LEADER_GET = "[Battleground Leader] %s:\32"
end

function PhanxChat:ChatFrame_OnUpdate(elapsed)
--	self.hooks["ChatFrame_OnUpdate"](elapsed)
	for i = 1,NUM_CHAT_WINDOWS do
		local cf = getglobal("ChatFrame"..i)
		local ub = getglobal("ChatFrame"..i.."UpButton")
		local db = getglobal("ChatFrame"..i.."DownButton")
		local bb = getglobal("ChatFrame"..i.."BottomButton")
		local rb = getglobal("ChatFrame"..i.."ReminderButton")
		ub:Hide()
		db:Hide()
		bb:SetPoint("RIGHT", cf, "TOPRIGHT", 0, 0)
		bb:SetPoint("LEFT", cf, "TOPRIGHT", -32, 0)
		bb:SetPoint("TOP", cf, "BOTTOM", 0, 28)
		bb:SetPoint("BOTTOM", cf, "BOTTOM", 0, 0)
		if not cf:AtBottom() then bb:Show() else bb:Hide() end
--		if self.db.profile.reminder and not cf:AtBottom() then rb:Show() else rb:Hide() end
	end
end

function PhanxChat:OnMouseWheel()
	self.hooks[this]["OnMouseWheel"]()
	if arg1 > 0 then
		if IsShiftKeyDown() then this:ScrollToTop()
		elseif IsControlKeyDown() then this:ScrollUp() this:ScrollUp() this:ScrollUp()
		else this:ScrollUp() end
	elseif arg1 < 0 then
		if IsShiftKeyDown() then this:ScrollToBottom()
		elseif IsControlKeyDown() then this:ScrollDown() this:ScrollDown() this:ScrollDown()
		else this:ScrollDown() end
	end
end

function PhanxChat:OnDragStart()
	if IsShiftKeyDown() then    
		self.hooks[this]["OnDragStart"]()
	end
end

function PhanxChat:OnDragStop()
	if IsShiftKeyDown() then    
		self.hooks[this]["OnDragStop"]()
	end
end

function PhanxChat:NoFlash()
	if self.db.profile.noflash then
		if not self:IsHooked("FCF_FlashTab") then self:Hook("FCF_FlashTab",true) end
	elseif not self.db.profile.noflash then
		if self:IsHooked("FCF_FlashTab") then self:Unhook("FCF_FlashTab") end
	end
end

function PhanxChat:FCF_FlashTab()
	-- flashing tabs, be gone!
end

function PhanxChat:MakeReminder(id)
	local cf = getglobal("ChatFrame"..id)
	local rb = CreateFrame("Button","ChatFrame"..id.."ReminderButton",cf)
	rb:SetFrameStrata("BACKGROUND")
	rb:SetWidth(32)
	rb:SetHeight(32)
	rb:SetNormalTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollEnd-Up")
	rb:SetPushedTexture("Interface\\ChatFrame\\UI-ChatIcon-ScrollEnd-Down")
	rb:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
	rb:SetPoint("RIGHT", cf, "RIGHT", 0, 0)
	rb:SetPoint("LEFT", cf, "RIGHT", -32, 0)
	rb:SetPoint("TOP", cf, "BOTTOM", 0, 28)
	rb:SetPoint("BOTTOM", cf, "BOTTOM", 0, 0)
	rb:SetScript("OnClick", function() PlaySound("igChatBottom"); this:GetParent():ScrollToBottom() end)
	rb:Hide()
end

function PhanxChat:ToggleMenu()
	local b = ChatFrameMenuButton
	if b:IsVisible() then b:Hide() else b:Show() end
end

function PhanxChat:EditBox()
	local eb = VisorEditBox or ChatFrameEditBox
	eb:ClearAllPoints()
	if self.db.profile.editattop then
		eb:SetPoint("BOTTOMLEFT", "ChatFrame1", "TOPLEFT", -5, 0)
		eb:SetPoint("BOTTOMRIGHT", "ChatFrame1", "TOPRIGHT", 5, 0)
	else
		eb:SetPoint("TOPLEFT", "ChatFrame1", "BOTTOMLEFT", -5, 0)
		eb:SetPoint("TOPRIGHT", "ChatFrame1", "BOTTOMRIGHT", 5, 0)
	end
end

function PhanxChat:StickyChannels()
	if self.db.profile.stickychannels then
		ChatTypeInfo["CHANNEL"].sticky = 1
		ChatTypeInfo["OFFICER"].sticky = 1
	else
		ChatTypeInfo["CHANNEL"].sticky = 0
		ChatTypeInfo["OFFICER"].sticky = 0
	end
end

function PhanxChat:ShortStrings()
	if self.db.profile.shortstrings then
		CHAT_FLAG_AFK = "[AFK] "
		CHAT_FLAG_DND = "[DND] "
		CHAT_FLAG_GM = "[GM] "
		CHAT_WHISPER_GET = "From %s:\32"
		CHAT_WHISPER_INFORM_GET = "To %s:\32"
		CHAT_GUILD_GET = "[G]%s:\32"
		CHAT_OFFICER_GET = "[O]%s:\32"
		CHAT_PARTY_GET = "[P]%s:\32"
		CHAT_RAID_GET = "[R]%s:\32"
		CHAT_RAID_LEADER_GET = "[RL]%s:\32"
		CHAT_RAID_WARNING_GET = "[!]%s:\32"
		CHAT_BATTLEGROUND_GET =  "[BG]%s:\32"
		CHAT_BATTLEGROUND_LEADER_GET = "[BGL]%s:\32"
	else
		CHAT_FLAG_AFK = "<AFK> "
		CHAT_FLAG_DND = "<DND> "
		CHAT_FLAG_GM = "<GM> "
		CHAT_WHISPER_GET = "%s whispers:\32"
		CHAT_WHISPER_INFORM_GET = "To %s:\32"
		CHAT_GUILD_GET = "[Guild] %s:\32"
		CHAT_OFFICER_GET = "[Officer] %s:\32"
		CHAT_PARTY_GET = "[Party] %s:\32"
		CHAT_RAID_GET = "[Raid] %s:\32"
		CHAT_RAID_LEADER_GET = "[Raid Leader] %s:\32"
		CHAT_RAID_WARNING_GET = "[Raid Warning] %s:\32"
		CHAT_BATTLEGROUND_GET =  "[Battleground] %s:\32"
		CHAT_BATTLEGROUND_LEADER_GET = "[Battleground Leader] %s:\32"
	end
end

function PhanxChat:AddMessage(cf, msg, r, g, b, id)
	msg = msg or ''
	r = r or ''
	g = g or ''
	b = b or ''
	id = id or nil
	if self.db.profile.shortstrings then
		msg = string.gsub(msg, '%[(%d)%..-General%]', '[%1/GEN]')
		msg = string.gsub(msg, '%[(%d)%..-Trade%]', '[%1/TRD]')
		msg = string.gsub(msg, '%[(%d)%..-LocalDefense%]', '[%1/LD]')
		msg = string.gsub(msg, '%[(%d)%..-WorldDefense%]', '[%1/WD]')
		msg = string.gsub(msg, '%[(%d)%..-LookingForGroup%]', '[%1/LFG]')
		msg = string.gsub(msg, '%[(%d)%..-GuildRecruitment%]', '[%1/GR]')
	end
	msg = self:MarkURL(msg)
	self.hooks[cf]["AddMessage"](cf, msg, r, g, b, id)
end

function PhanxChat:MarkURL(msg)
	-- www.X.Y url
	msg = string.gsub(msg, " www%.([_A-Za-z0-9-]+)%.(%S+)%s?", self:LinkURL("www.%1.%2"))
	-- X://Y url
	msg = string.gsub(msg, " (%a+)://(%S+)%s?", self:LinkURL("%1://%2"))
	-- X@X.Y url (---> email)
	msg = string.gsub(msg, " ([_A-Za-z0-9-%.]+)@([_A-Za-z0-9-]+)%.([_A-Za-z0-9-%.]+)%s?", self:LinkURL("%1@%2.%3"))
	-- XXX.YYY.ZZZ.WWW:VVVV url (IP of ts server for example)
	msg = string.gsub(msg, " (%d%d?%d?)%.(%d%d?%d?)%.(%d%d?%d?)%.(%d%d?%d?):(%d%d?%d?%d?%d?)%s?", self:LinkURL("%1.%2.%3.%4:%5"))
	-- XXX.YYY.ZZZ.WWW url (---> IP)
	msg = string.gsub(msg, " (%d%d?%d?)%.(%d%d?%d?)%.(%d%d?%d?)%.(%d%d?%d?)%s?", self:LinkURL("%1.%2.%3.%4"))
	-- X.Y.Z url
	msg = string.gsub(msg, " ([_A-Za-z0-9-]+)%.([_A-Za-z0-9-]+)%.(%S+)%s?", self:LinkURL("%1.%2.%3"))
	-- X.Y.Z:WWWW url  (ts server for example)
	msg = string.gsub(msg, " ([_A-Za-z0-9-]+)%.([_A-Za-z0-9-]+)%.(%S+)%:([_0-9-]+)%s?", self:LinkURL("%1.%2.%3:%4"))
    return msg
end

function PhanxChat:SetItemRef(link, text, button)
	if ( strsub(link, 1, 3) == "url" ) then
		self:ShowURL(link)
	else
		self.hooks.SetItemRef(link, text, button)
	end
end

function PhanxChat:LinkURL(link)
	local returnedLink = " "
	
	local color = string.format("%02x%02x%02x", self.db.profile.url.color.r*255, self.db.profile.url.color.g*255, self.db.profile.url.color.b*255)
	returnedLink = " |cff" .. color
	
	returnedLink = returnedLink .. "|Hurl:" .. link .. "|h"
	
--	if ( self.db.profile.urlbracket ) then
		returnedLink = returnedLink .. "[" .. link .. "]"
--	else
--		returnedLink = returnedLink .. link
--	end
	
	returnedLink = returnedLink .. "|h|r "
	
	return returnedLink
end

function PhanxChat:ShowURL(link)
    link = strsub(link, 5)
    if self.db.profile.url.popup then
        self:StaticPopupURL(link)
    else
        self:EditBoxURL(link)
    end
end

function PhanxChat:StaticPopupURL(link)
    StaticPopupDialogs["SHOW_URL"] = {
        text = "URL : %s",
        button2 = TEXT(CLOSE),
        hasEditBox = 1,
        hasWideEditBox = 1,
        showAlert = 1, -- HACK : it's the only way I found to make de StaticPopup have sufficient width to show WideEditBox :(

        OnShow = function()
            local editBox = getglobal(this:GetName().."WideEditBox");
            editBox:SetText(format(link));
            editBox:SetFocus();
            editBox:HighlightText(0);

            local button = getglobal(this:GetName().."Button2");
            button:ClearAllPoints();
            button:SetWidth(200);
            button:SetPoint("CENTER", editBox, "CENTER", 0, -30);

            getglobal(this:GetName().."AlertIcon"):Hide();  -- HACK : we hide the false AlertIcon
        end,

        OnHide = function() end,
        OnAccept = function() end,
        OnCancel = function() end,
        EditBoxOnEscapePressed = function() this:GetParent():Hide(); end,
        timeout = 0,
        whileDead = 1,
        hideOnEscape = 1
    }
    StaticPopup_Show ("SHOW_URL", link)
end

function PhanxChat:EditBoxURL(link)
    if (not ChatFrameEditBox:IsShown()) then
        ChatFrame_OpenChat(link, DEFAULT_CHAT_FRAME)
    else
        ChatFrameEditBox:Insert(link)
    end
end

function PhanxChat:PLAYER_ENTERING_WORLD()
	FCF_SelectDockFrame(ChatFrame1)
end

function PhanxChat:UPDATE_CHAT_COLOR(ChatType,cr,cg,cb)
	if ChatType then
		local number = string.gmatch(arg1, "CHANNEL(%d+)")()
		if number then
			local _, name = GetChannelName(number)
			if name then
				local name, zoneSuffix = string.gmatch(name, L["(%w+)%s?(.*)"])()
				
				local color = self.db.profile.channelcolors[name]
				if not color then
					self.db.profile.channelcolors[name] = {r=cr, g=cg, b=cb}
				else
					color.r=cr
					color.g=cg
					color.b=cb
				end
			end
		end
	end
end

function PhanxChat:CHAT_MSG_CHANNEL_NOTICE(NoticeType,a2,a3,LongName,a5,a6,a7,number,cname)
	if (not strfind(LongName, "%d+%. .*")) then
		return
	elseif (arg1 == "YOU_JOINED") then
		local name, zoneSuffix = string.gmatch(cname, L["(%w+)%s?(.*)"])()
		local color = self.db.profile.channelcolors[name]
		if (color) then
			ChangeChatColor("CHANNEL"..number, color.r, color.g, color.b)
		else
			color = ChatTypeInfo["CHANNEL"..number]
			self.db.profile.channelcolors[name] = {r=color.r, g=color.g, b=color.b}
		end
	end
end