---------------------------------------------------------------------------------------
------------------------------------- VARIABLES ---------------------------------------
MCNAME = "MyChannel";
MCVERS = "2.0";
MCFOR = "R\195\170ve de Dragon";
local enTest = false;
local junkCapture = false;
local mcr,mcg,mcb; -- couleurs
local firstChangeArea = true;
local noticeChat = false;
------- valeurs par defaut
local defChannelName = "";
local defChannelPass = "";
local defWindowName = "";
local defAutoJoin = 1;
local defSticky = 0;
local defVisIconMap = 1;
local defPosIconMap = 30;
local defQuitBtnState = 0; -- non utilise
-------
LISTWHO = "";
TABLEWHO = {};
TABLEWHOBTN = {};
NUMBTNPOPUP = 0;
LISTCHANNELS = "";
SCROLL_TEXTHEIGHT = 14; -- interligne liste connectes (voir aussi le fichier XML)
MCSETTINGS = GetCVar("realmName")..UnitName("player");
-------
MyChannelSaved = {};
MyChannelSaved[MCSETTINGS] = {};
MyChannelDatas = {};

---------------------------------------------------------------------------------------
----------------------------------- EVENEMENTS ----------------------------------------
function chargementMyChannel()
	------------- slash commandes
	SlashCmdList["MYCHANNELSAY"] = mcSayChannel;
		SLASH_MYCHANNELSAY1 = "/channelsay";
		SLASH_MYCHANNELSAY2 = "/mcsay";
		SLASH_MYCHANNELSAY3 = "/mc";
		
	SlashCmdList["MYCHANNELJOIN"] = mcJoinChannel;
		SLASH_MYCHANNELJOIN1 = "/channeljoin";
		SLASH_MYCHANNELJOIN2 = "/mcjoin";
		
	SlashCmdList["MYCHANNELLEAVE"] = mcLeaveChannel;
		SLASH_MYCHANNELLEAVE1 = "/channelleave";
		SLASH_MYCHANNELLEAVE2 = "/mcleave";
		
	SlashCmdList["MYCHANNELTEST"] = mcStatusChannel;
		SLASH_MYCHANNELTEST1 = "/mcstatus";
		SLASH_MYCHANNELTEST2 = "/mcs";
		SLASH_MYCHANNELTEST3 = "/mct";
		
	SlashCmdList["MYCHANNELWHO"] = mcListChannel;
		SLASH_MYCHANNELWHO1 = "/channelwho";
		SLASH_MYCHANNELWHO2 = "/mcwho";
		
	SlashCmdList["MYCHANNELLIST"] = mcListAllChannel;
		SLASH_MYCHANNELLIST1 = "/channellist";
		SLASH_MYCHANNELLIST2 = "/mclist";
		
	SlashCmdList["MYCHANNELINV"] = mcInviteChannel;
		SLASH_MYCHANNELINV1 = "/channelinvite";
		SLASH_MYCHANNELINV2 = "/mcinvite";
		SLASH_MYCHANNELINV3 = "/mcinv";
		
	SlashCmdList["MYCHANNELBAN"] = mcBanChannel;
		SLASH_MYCHANNELBAN1 = "/channelban";
		SLASH_MYCHANNELBAN2 = "/mcban";
		
	SlashCmdList["MYCHANNELUNBAN"] = mcUnbanChannel;
		SLASH_MYCHANNELUNBAN1 = "/channelunban";
		SLASH_MYCHANNELUNBAN2 = "/mcunban";
		
	SlashCmdList["MYCHANNELMODO"] = mcModoChannel;
		SLASH_MYCHANNELMODO1 = "/channelmodo";
		SLASH_MYCHANNELMODO2 = "/mcmodo";
		
	SlashCmdList["MYCHANNELUNMODO"] = mcUnmodoChannel;
		SLASH_MYCHANNELUNMODO1 = "/channelunmodo";
		SLASH_MYCHANNELUNMODO2 = "/mcunmodo";
		
	SlashCmdList["MYCHANNELOWNER"] = mcOwnerChannel;
		SLASH_MYCHANNELOWNER1 = "/channelowner";
		SLASH_MYCHANNELOWNER2 = "/mcowner";
		
	SlashCmdList["MYCHANNELOPTIONS"] = myChannelOptions;
		SLASH_MYCHANNELOPTIONS1 = "/channelopt";
		SLASH_MYCHANNELOPTIONS2 = "/mcoption";
		SLASH_MYCHANNELOPTIONS3 = "/mcoptions";
		SLASH_MYCHANNELOPTIONS4 = "/mcopt";

	SlashCmdList["MYCHANNELHELPVERSION"] = mcEchoVersion;
		SLASH_MYCHANNELHELPVERSION1 = "/channelversion";
		SLASH_MYCHANNELHELPVERSION2 = "/mcversion";
		SLASH_MYCHANNELHELPVERSION3 = "/mcvers";

	SlashCmdList["MYCHANNELHELP"] = mcHelpChannel;
		SLASH_MYCHANNELHELP1 = "/channelhelp";
		SLASH_MYCHANNELHELP2 = "/mchelp";

	-------------- bindings
	BINDING_HEADER_MYCHANNEL = MCNAME
	BINDING_NAME_STARTMESSAGE = BIND_NAME_STARTMSG
	BINDING_NAME_SHOWOPTIONS = BIND_NAME_OPTIONS
	
	-------------- suite
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("ZONE_CHANGED_NEW_AREA");
	--this:RegisterEvent("PLAYER_ENTERING_WORLD");
end

function evenementMyChannel()
	if (event == "VARIABLES_LOADED") then
		if (DEFAULT_CHAT_FRAME) then mcEchoVersion(true);end;
		MyChannelDatas = MyChannelSaved[MCSETTINGS];
		------- icone minimap
		local visIcon;
		if (MyChannelDatas == nil or MyChannelDatas["visIconMap"] == nil) then
			visIcon = defVisIconMap;
		else
			visIcon = MyChannelDatas["visIconMap"];
		end;
		if (visIcon == 1) then MyChannelIconFrame:Show(); else MyChannelIconFrame:Hide(); end;
		local posIcon;
		if (MyChannelDatas == nil or MyChannelDatas["posIconMap"] == nil) then
			posIcon = defPosIconMap;
		else
			posIcon = MyChannelDatas["posIconMap"];
		end;
		MyChannelIconFrame:SetPoint("TOPLEFT","Minimap","TOPLEFT", 54 - (80 * cos(posIcon)),(80 * sin(posIcon)) - 54);
		-------
	elseif (event == "ZONE_CHANGED_NEW_AREA") then
		if (nomCanalOK() == 1) then
			if (firstChangeArea) then
				firstChangeArea = false;
				if (MyChannelDatas["autoJoin"] == 1) then
					mcJoinChannel();
					ChatTypeInfo["CHANNEL"].sticky = MyChannelDatas["sticky"]; -- necessaire ici car sticky non memorise
				else
					mcLeaveChannel();
				end;
			else
				--mcJoinChannel(); not needed
			end;
		end;
	end;
end

---------------------------------------------------------------------------------------
------------------------------------ GESTION CANAUX -----------------------------------
function mcJoinChannel()
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (nbreCanaux() == 10) then
		echo(MCNAME..": "..TOOMUCH.."(10)","red");
		return;
	end;
	JoinChannelByName(MyChannelDatas["channelName"],MyChannelDatas["channelPass"],DEFAULT_CHAT_FRAME:GetID());
	ChatTypeInfo["CHANNEL"].sticky = MyChannelDatas["sticky"];
	local nomWindow = videSiNul(MyChannelDatas["windowName"]);
	if (nomWindow ~= "") then -- fenetre perso voulu
		local nomChatFrame = mcGetChatFrameByName(nomWindow);
		if (nomChatFrame) then -- fenetre perso existe
			ChatFrame_AddChannel(nomChatFrame,MyChannelDatas["channelName"]); -- affichage canal dans fenetre perso
			RemoveChatWindowChannel(1,MyChannelDatas["channelName"]); -- retire canal de la fenetre General
		else
			echo(MCNAME..": "..NOWINDOW..mckwote(nomWindow),"red");
		end;
	else
		if (not DEFAULT_CHAT_FRAME) then return; end
		nomWindow = GENERALCHATNAME;
		ChatFrame_AddChannel(DEFAULT_CHAT_FRAME,MyChannelDatas["channelName"]); -- affichage canal dans general
	end;
end

function mcLeaveChannel()
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		return;
	end;
	ChatTypeInfo["CHANNEL"].sticky = 0;
	LeaveChannelByName(MyChannelDatas["channelName"]);
end

function mcListAllChannel()
	ListChannels(arg); -- /infodisc
	--echo(LISTCHANNELS,"grey"); non utile v 1.14
end

function mcListChannel(noTest)
	if (noTest == nil or noTest == "") then
		if (nomCanalOK() ~= 1) then
			echo(MCNAME.." "..ERRORNOINIT,"red");
			myChannelOptions();
			return;
		end;
		if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
			echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
			return;
		end;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		LISTWHO = "";
		MCScrollBar_Update("vide")
	else
		ListChannelByName(MyChannelDatas["channelName"]); -- /infodisc nomCanal
	end;
	if (noTest == nil or noTest == "") then echo(LISTWHO,"grey"); end;
end

function mcInviteChannel(playerName)
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	ChannelInvite(MyChannelDatas["channelName"],playerName);
	echo(MCNAME..": "..mckwote(playerName).." is invited to "..mcbrak(MyChannelDatas["channelName"]),"yellow");
end
		
function mcBanChannel(playerName)
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	ChannelBan(MyChannelDatas["channelName"],playerName);
	echo(MCNAME..": "..mckwote(playerName).." is banned from "..mcbrak(MyChannelDatas["channelName"]),"yellow");
end

function mcUnbanChannel(playerName)
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	ChannelUnban(MyChannelDatas["channelName"],playerName);
	echo(MCNAME..": "..mckwote(playerName).." is no longer banned from "..mcbrak(MyChannelDatas["channelName"]),"yellow");
end

function mcModoChannel(playerName)
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	ChannelModerator(MyChannelDatas["channelName"],playerName);
	echo(MCNAME..": "..mckwote(playerName).." is moderator of "..mcbrak(MyChannelDatas["channelName"]),"yellow");
end

function mcUnmodoChannel(playerName)
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	ChannelUnmoderator(MyChannelDatas["channelName"],playerName);
	echo(MCNAME..": "..mckwote(playerName).." is no longer moderator if "..mcbrak(MyChannelDatas["channelName"]),"yellow");
end

function mcOwnerChannel()
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then
		echo(MCNAME.." "..STATUS_NOTCONNECTED,"red");
		return;
	end;
	if (isOwner() == 0) then
		echo(MCNAME..": "..NOOWNER,"red");
		return;
	end;
	DisplayChannelOwner(MyChannelDatas["channelName"]);
end

function mcStatusChannel(noChat)
	local chaineStatus;
	if (nomCanalOK() ~= 1) then
		chaineStatus = STATUS_NOTINIT;
	else
		chaineStatus = getStatusChannel(MyChannelDatas["channelName"]);
		if (chaineStatus ~= "") then
			chaineStatus = STATUS_CONNECTED.." "..chaineStatus;
		else
			chaineStatus = STATUS_NOTCONNECTED;
		end;
	end;
	if (noChat == nil or noChat == "") then
		echo(MCNAME.." "..STATUS_TITLE..chaineStatus,"orange");
	else
		return chaineStatus;
	end
end

function isOwner()-- bug si seul connecte au canal ?
	-- renvoit 1 si le player est le owner du canal (sinon 0)
	ListChannelByName(MyChannelDatas["channelName"]); -- maj LISTWHO
	local nom1,nom2 = "*"..UnitName("player"),"@"..UnitName("player");
	if (string.find(LISTWHO,nom1,1,true) ~= nil or string.find(LISTWHO,nom2,1,true) ~= nil) then
		return 1;
	else
		return 0;
	end;
end

function isReallyConnected()
	-- renvoit 1 si le player est vraiment connecte au canal, sinon 0
	if (nomCanalOK() ~= 1) then return 0; end;
	ListChannels(); -- maj LISTCHANNELS
	local nomCanal = ". "..MyChannelDatas["channelName"].."]";
	if (string.find(LISTCHANNELS,nomCanal,1,true) ~= nil) then
		return 1;
	else
		return 0;
	end;
end

function nomCanalOK()
	if (MyChannelDatas ~= nil) then
		if (MyChannelDatas["channelName"] ~= nil and MyChannelDatas["channelName"] ~= "") then return 1; else return 0; end;
	end;
	return 0;
end

function getStatusChannel(nomCanalVoulu)
	-- renvoit le nom du canal si connecte, sinon ""
	local numCanal = chercheCanal(nomCanalVoulu);
	if (numCanal > 0) then
		return(mcbrak(numCanal..", "..nomCanalVoulu));
	else
		return "";
	end;
end

function chercheCanal(nomCanalVoulu)
	-- scanne les canaux de 1 a 10 pour trouver le nom du canal voulu
	-- renvoit le numero du canal trouve ou 0
	local i,idCanal,nomCanal;
	for i = 1,10,1 do
		idCanal,nomCanal = GetChannelName(i);
		if (idCanal ~= 0 and nomCanal ~= nil) then
			if (nomCanal == nomCanalVoulu) then return i; end;
		end;
	end;
	return 0; -- introuvable
end

function nbreCanaux()
	-- renvoit le nomnre de canaux ouverts
	local i,idCanal,nomCanal;
	local nbre = 0;
	for i = 1,10,1 do
		idCanal,nomCanal = GetChannelName(i);
		if (idCanal ~= 0 and nomCanal ~= nil) then
			nbre = nbre + 1
		end;
	end;
	return nbre;
end

function mcGetChatFrameByName(nomWindow)
	if (window == "general") then return DEFAULT_CHAT_FRAME; end
	for i = 1,NUM_CHAT_WINDOWS do
		local windowName = GetChatWindowInfo(i);
		if (windowName == nomWindow) then
			return getglobal("ChatFrame"..i);
		end
	end
	return nil;
end

function getCanalEventNotice(nomCanalEvent)
	if (nomCanalOK() == 1) then
		local nomCanal = string.lower(string.sub(nomCanalEvent,string.find(nomCanalEvent," ",1,true) + 1));
		if (nomCanal == MyChannelDatas["channelName"]) then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end

---------------------------------------------------------------------------------------
----------------------------------- HOOK CHAT EVENT -----------------------------------
----- hook event chat "ChatFrame_OnEvent"
old_ChatFrame_OnEvent = ChatFrame_OnEvent;
function ChatFrame_OnEvent(event)
	if (event == "CHAT_MSG_CHANNEL_LIST") then -- event "/infodisc" et "/infodisc nomCanal"
		local msg = arg1; -- liste canaux ou liste joueurs si param = numero canal
		if (msg) then
			if strsub(msg,1,1) == "[" then
				-- event "/infodisc" : liste canaux
				LISTCHANNELS = msg;
				if ( not MyChannelOptionsFrame:IsVisible()) then echo(msg,"yellow"); end;
			else
				-- event "/infodisc nomCanal" : liste joueurs
				LISTWHO = msg;
				if (MyChannelOptionsFrame:IsVisible()) then
					makeTableConnected();
					MCScrollBar_Update();
				else
					echo(msg,"yellow");
				end;
			end;
		end;
		
	elseif (event == "CHAT_MSG_CHANNEL_NOTICE") then
		-- messages Join et Left channel
		local msg1,msg2,msg3,msg4 = arg1,arg2,arg3,arg4;
		if (msg1 == "YOU_JOINED") then
			if (getCanalEventNotice(msg4)) then
				if (MyChannelOptionsFrame:IsVisible()) then -- infos retour sur dlog
					MyChannelTxtStatus:SetText(STATUS_CONNECTED.." "..videSiNul(msg4));
					mcListChannel("noTest");
				else -- infos retour dans chat
					if (noticeChat) then
						local lePass = "";
						if (MyChannelDatas["channelPass"] ~= "") then
							lePass = JOINCHANNELPASS..mckwote(MyChannelDatas["channelPass"]);
						end;
						local nomWindow = MyChannelDatas["windowName"];
						if (nomWindow == "") then nomWindow = GENERALCHATNAME; end;
						echo(MCNAME..": "..JOINCHANNEL..mckwote(MyChannelDatas["channelName"])..lePass..JOINCHANNELWIND..mckwote(nomWindow),"yellow");
					end;
				end;
			end;
		elseif (msg1 == "YOU_LEFT") then
			if (getCanalEventNotice(msg4)) then
				if (MyChannelOptionsFrame:IsVisible()) then -- infos retour sur dlog
					MyChannelTxtStatus:SetText(STATUS_NOTCONNECTED);
					MCScrollBar_Update("vide");
				else -- infos retour dans chat
					if (noticeChat) then echo(MCNAME..": "..LEAVECHANNEL..mckwote(MyChannelDatas["channelName"]),"yellow"); end;
				end;
			end;
		end;
	
	elseif (event == "CHAT_MSG_SYSTEM" and MyChannelOptionsFrame:IsVisible()) then
		-- bloque l'affichage d'une requete "Who"
		if (GetNumWhoResults() == 1) then
			local nom,guilde,niveau,race,classe,zone = GetWhoInfo(1);
			getglobal("PopUpPlayerClass_Text"):SetText(classe.." "..niveau);
			getglobal("PopUpPlayerGuild_Text"):SetText(videSiNul(truncChaine(guilde,15)));
			getglobal("PopUpPlayerZone_Text"):SetText(videSiNul(truncChaine(zone,15)));
		else
			getglobal("PopUpPlayerClass_Text"):SetText("");
			getglobal("PopUpPlayerGuild_Text"):SetText(GetNumWhoResults().." "..WHO_RESULT.." !");
			getglobal("PopUpPlayerZone_Text"):SetText("");
		end;
		--local msg1,msg2 = arg1,arg2;
		--echo("=*="..videSiNul(msg1).."="..videSiNul(msg2).."=*=");
	else
		-- on repasse l'event
		old_ChatFrame_OnEvent(event);
	end;
end

---------------------------------------------------------------------------------------
------------------------------------ START MESSAGE ------------------------------------
function mcSayChannel()
	-- commence un msg sur le canal
	if (nomCanalOK() ~= 1) then
		echo(MCNAME.." "..ERRORNOINIT,"red");
		myChannelOptions();
		return;
	end;
	local nomCanalVoulu = MyChannelDatas["channelName"];
	local numCanal = chercheCanal(nomCanalVoulu);
	if (enTest) then
		echo("==="..MCNAME..": Requested channel "..mcbrak(nomCanalVoulu).." - "..numCanal,"gray");
	end
	if (numCanal > 0) then
		tapeMessage("/"..numCanal.." ");
	else
		echo(MCNAME..": "..STATUS_NOTCONNECTED.." "..mcbrak(nomCanalVoulu),"red");
	end;
end

function tapeMessage(prefixe)
	-- tape le debut du message dans la Chat Box pour ouvrir un canal
	if (not ChatFrameEditBox:IsVisible()) then
		ChatFrame_OpenChat(prefixe);
	else
		ChatFrameEditBox:SetText(prefixe); -- marche pas : aucune touche ne repond si visible
	end;
	ChatEdit_ParseText(ChatFrame1.editBox,0);
end

---------------------------------------------------------------------------------------
------------------------------------ DLOGS --------------------------------------------
function myChannelOptions()
	if (MyChannelOptionsFrame:IsVisible()) then
		MyChannelOptionsFrame:Hide();
	else
		if (MyChannelDatas == nil or MyChannelDatas["channelName"] == nil) then
			MyChannelDatas = {};
			MyChannelDatas["channelName"] = defChannelName;
			MyChannelDatas["channelPass"] = defChannelPass;
			MyChannelDatas["windowName"] = defWindowName;
			MyChannelDatas["autoJoin"] = defAutoJoin;
			MyChannelDatas["sticky"] = defSticky;
			MyChannelDatas["visIconMap"] = defVisIconMap;
			MyChannelDatas["posIconMap"] = defPosIconMap;
		end;
		MyChannelOptionsFrame:Show();
		mcListChannel("noTest");
	end;
end

function MyChannelOptionsDlogApply()
	MyChannelDatas["channelName"] = MyChannelOptNom:GetText();
	MyChannelDatas["channelPass"] = MyChannelOptPass:GetText();
	MyChannelDatas["windowName"] = MyChannelOptWind:GetText();
	-- attention : NomCaseACocher:GetChecked() renvoit 1 ou nil
	MyChannelDatas["autoJoin"] = attribueBinaire(MyChannelOptAutoJoin:GetChecked());
	if (MyChannelDatas["channelName"] == "") then MyChannelDatas["autoJoin"] = 0; end
	MyChannelDatas["sticky"] = attribueBinaire(MyChannelOptSticky:GetChecked());
	ChatTypeInfo["CHANNEL"].sticky = MyChannelDatas["sticky"];
	MyChannelDatas["visIconMap"] = attribueBinaire(MyChannelShowIcon:GetChecked());
	MyChannelDatas["posIconMap"] = MyChannelIconSlider:GetValue();
	MyChannelSaved[MCSETTINGS] = MyChannelDatas;
end

function MyChannelInitSlider(slider)
	local sl = getglobal(slider)
	getglobal(slider .. "Low"):SetText("0");
	getglobal(slider .. "High"):SetText("360");
	getglobal(slider .. "Text"):SetText(MyChannelDatas["posIconMap"]);
end

function MCScrollBar_Update(vide)
	if (vide ~= nil and vide ~= "") then TABLEWHO = {}; end;
	local line; -- 1 through nbreLiVis
	local linePlusOffset; -- an index into our data calculated from the scroll offset
	TABLEWHOBTN = {};
	local nbreLiMax = getn(TABLEWHO); -- nombre de lignes
	local nbreLiVis = 16; -- nombre de lignes visibles : nbreLiVis * SCROLL_TEXTHEIGHT = hauteur ScrollFrame et aussi nombre de boutons-lignes
	FauxScrollFrame_Update(MCScrollBar,nbreLiMax,nbreLiVis,SCROLL_TEXTHEIGHT);
	if (enTest) then echo("========== Scroll at "..FauxScrollFrame_GetOffset(MCScrollBar)); end;
	for line = 1,nbreLiVis,1 do
		linePlusOffset = line + FauxScrollFrame_GetOffset(MCScrollBar);
		if (linePlusOffset <= nbreLiMax) then
			getglobal("BtnLine"..line.."_Text"):SetText(TABLEWHO[linePlusOffset]);
			TABLEWHOBTN[line] = truncChaine(TABLEWHO[linePlusOffset],15);
			getglobal("BtnLine"..line):Show();
		else
			getglobal("BtnLine"..line):Hide();
		end;
	end;
end

function makeTableConnected()
	-- construit la table TABLEWHO avec la liste des joueurs connectes pour scrollFrame
	if (nomCanalOK() ~= 1) then return; end;
	if (getStatusChannel(MyChannelDatas["channelName"]) == "") then return; end;
	local sep = ";";
	local listeJoueurs = string.gsub(LISTWHO,", ",sep)..sep;
	listeJoueurs = string.gsub(string.gsub(listeJoueurs,"@","*"),"*","* "); -- repere pour owner
	local i,posSep = 1,0;
	TABLEWHO = {};
	while (string.find(listeJoueurs,sep,1,true) ~= nil) do
		posSep = string.find(listeJoueurs,sep,1,true);
		TABLEWHO[i] = string.sub(listeJoueurs,1,posSep - 1);
		listeJoueurs = string.sub(listeJoueurs,posSep + 1);
		i = i + 1;
	end;
	table.sort(TABLEWHO);
	if (enTest) then echo("====== TABLEWHO : "..getn(TABLEWHO).." cases. Case 1 ="..TABLEWHO[1].."="); end;
	if (junkCapture) then
		TABLEWHO = {};
		TABLEWHO[1] = "* Swann";
		TABLEWHO[2] = "Allia";
		TABLEWHO[3] = "Fafner";
		TABLEWHO[4] = "Juanita";
		TABLEWHO[5] = "Kameliard";
		TABLEWHO[6] = "Minibang";
		TABLEWHO[7] = "Moonrise";
		TABLEWHO[8] = "Pepezemoko";
		TABLEWHO[9] = "Sargon";
		TABLEWHO[10] = "Zaxya";
	end;
end

function joinBtn()
	mcJoinChannel();
	MyChannelTxtStatus:SetText(STATUS_CHANGED_JOIN);
	--MyChannelDatas["quitBtnState"] = 0;
	MyChannelSaved[MCSETTINGS] = MyChannelDatas;
end

function leaveBtn()
	if (isReallyConnected() == 1) then
		mcLeaveChannel();
		MyChannelTxtStatus:SetText(STATUS_CHANGED_LEAVE);
		--MyChannelDatas["quitBtnState"] = 1;
		MyChannelSaved[MCSETTINGS] = MyChannelDatas;
	end;
end

function enterBtnListe()
	MyChannelMenuList:Hide();
	getglobal("PopUpPlayerClass_Text"):SetText("");
	getglobal("PopUpPlayerGuild_Text"):SetText("");
	getglobal("PopUpPlayerZone_Text"):SetText("");
	getglobal("PopUpPlayerName_Text"):SetText(string.gsub(TABLEWHOBTN[NUMBTNPOPUP],"* ",""));
	MyChannelMenuList:SetPoint("TOPLEFT",this,"TOPLEFT",121,61);
	MyChannelMenuList:Show();
end

function clickBtnListe()
	getglobal("PopUpPlayerClass_Text"):SetText("");
	getglobal("PopUpPlayerGuild_Text"):SetText("  "..WHO_SEARCHING.."...");
	getglobal("PopUpPlayerZone_Text"):SetText("");
	SendWho(string.gsub(TABLEWHOBTN[NUMBTNPOPUP],"* ","")); -- hook
end

---------------------------------------------------------------------------------------
-------------------------------------- LIBRAIRIE --------------------------------------
function mcEchoVersion(chargement)
	if (chargement) then
		DEFAULT_CHAT_FRAME:AddMessage(MCNAME.." "..MCVERS.." loaded. "..MCMSG,0.1,0.6,0.5);
	else
		echo(MCNAME.." version "..MCVERS..". "..MCMSG,"blue");
	end; 
end

function echo(chaine,nomCouleur)
	if (DEFAULT_CHAT_FRAME) then
		defCouleurMC(nomCouleur);
		ChatFrame1:AddMessage(chaine,mcr,mcg,mcb);
	end;
end

function arrondi(valeur)
	if (valeur - math.floor(valeur) > 0.5) then valeur = valeur + 0.5;end;
	return (math.floor(valeur));
end

function inversionValeur(valeur)
	return(abs(valeur - 1));
end

function attribueBinaire(valeur)
	if (valeur == 1) then return (1); else return (0); end;
end

function strToInteger(chaine)
	local strArg = chaine;
	local strToInt = 0;
	while ((strArg ~= "") and (strArg)) do
		strToInt = strToInt * 10;
		strToInt = strToInt + (string.byte(strsub(strArg, 1, 1)) - string.byte("0"));
		strArg = strsub(strArg, 2);
	end;
	return (strToInt);		
end

function truncChaine(chaine,taille)
	if (string.len(chaine) > taille) then
		return (string.sub(chaine,1,taille - 3).."...");
	else
		return chaine;
	end;
end

function mckwote(chaine)
	return("'"..videSiNul(chaine).."'");
end

function mcbrak(chaine)
	return("["..videSiNul(chaine).."]");
end

function videSiNul(valeur)
	if (valeur == nil) then return ""; else return valeur; end;
end

function nilSiNul(valeur)
	if (valeur == nil) then return "NIL"; else return valeur; end;
end

function booleanToStr(valeur)
	if (valeur) then return "TRUE"; else return "FALSE"; end;
end

function defCouleurMC(nomCouleur)
	if (nomCouleur == "red") then
		mcr,mcg,mcb = 1,0,0;
	elseif (nomCouleur == "green") then
		mcr,mcg,mcb = 0,1,0;
	elseif (nomCouleur == "blue") then
		mcr,mcg,mcb = 0,0,1;
	elseif (nomCouleur == "orange") then
		mcr,mcg,mcb = 0.8,0.3,0.1;
	elseif (nomCouleur == "yellow") then
		mcr,mcg,mcb = 1,1,0;
	elseif (nomCouleur == "grey" or nomCouleur == "gray") then
		mcr,mcg,mcb = 0.6,0.6,0.6;
	else
		mcr,mcg,mcb = 1,1,1;
	end;
end

---------------------------------------------------------------------------------------
------------------------------------- ONLINE HELP -------------------------------------
function mcHelpChannel()
	echo(MCNAME..": available /commands ======","blue");
	echo("   "..mckwote("/mc").." : starts a message","grey");
	echo("   "..mckwote("/mcopt").." : displays settings panel","grey");
	echo("   "..mckwote("/mcjoin").." : joins the defined custom channel","grey");
	echo("   "..mckwote("/mcleave").." : leaves the defined custom channel","grey");
	echo("   "..mckwote("/mcstatus").." : displays infos about your connection","grey");
	echo("   "..mckwote("/mcwho").." : displays the players who are connected","grey");
	echo("   "..mckwote("/mclist").." : displays the list of all connected channels","grey");
	echo("   "..mckwote("/mcvers").." : displays MyChannel version","grey");
	echo("====================","blue");
end

---------------------------------------------------------------------------------------