-- MetaMapTRK
-- Written by MetaHawk - aka Urshurak

TRK_ICON_PATH    = "Interface\\AddOns\\MetaMapTRK\\Icons\\";

TRK_Options = {};
TRK_Data    = {};
TRK_NodeList = {};

TRK_Default = {
	["Herbs"]    = false,
	["Ores"]     = false,
	["Treasure"] = false,
	["Unmined"]  = false,
	["ShowAll"]  = false,
	["ShowHerb"] = true,
	["ShowOre"]  = true,
	["ShowTreasure"] = true,
	["FilterHerb"] = true,
	["FilterOre"]  = true,
	["FilterTreasure"] = true,
	["Sortby"]   = "name",
	["Padding"]  = 10,
}

TRK_FilterMenu = {
	[1] = {TRK_SORT_TITLE,  "Sortbyname"},
	[2] = {TRK_SORT_LEVEL,  "Sortbylevel"},
	[3] = {"", "", 1},
	[4] = {TRK_FILTER_ALL,  "ShowAll"},
	[5] = {TRK_FILTER_HERB, "ShowHerb"},
	[6] = {TRK_FILTER_ORE,  "ShowOre"},
	[7] = {TRK_FILTER_TREASURE, "ShowTreasure"},
---	[8] = {"", "", 1},
}

TRK_VarsLoaded  = false;
TRK_LastSearch	= "";
TRK_LastNode    = 0;
TRK_ButtonTotal	= 0;
TRK_HerbTotal = 0;
TRK_OreTotal = 0;
TRK_TreasureTotal = 0;
TRK_ItemTotal = 0;

function TRK_OnLoad()
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("WORLD_MAP_UPDATE");
	this:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
	this:RegisterEvent("UI_ERROR_MESSAGE");
end

function TRK_OnEvent(event)
	if(event == "ADDON_LOADED" and arg1 == "MetaMapTRK") then
		TRK_LoadConfig();
		UIDropDownMenu_Initialize(TRK_FilterSelectMenu, TRK_FilterMenuInit, "MENU");
		UIDropDownMenu_Initialize(TRK_QuickMenu, TRK_QuickMenuInit, "MENU");
	elseif(event == "WORLD_MAP_UPDATE" and TRK_DisplayFrame:IsVisible()) then
		TRK_DisplayInit();
	elseif(event == "CHAT_MSG_SPELL_SELF_BUFF") then
		TRK_ProcessNode(event);
	elseif(event == "UI_ERROR_MESSAGE") then
		TRK_ProcessNode(event);
	end
end

function TRK_LoadConfig()
	for option, value in pairs(TRK_Default) do
		if(TRK_Options[option] == nil) then TRK_Options[option] = value; end
	end
	TRK_Default = nil;
	if(TRK_Data == nil) then TRK_Data = {}; end
	TRK_VarsLoaded = true;
end

function TRK_ToggleFrame()
	if(TRK_DisplayFrame:IsVisible()) then
		MetaMapContainer_ShowFrame();
	else
		if(not WorldMapFrame:IsVisible()) then
			MetaMap_ToggleFrame(WorldMapFrame);
		end
		MetaMapContainer_ShowFrame(TRK_DisplayFrame);
		TRK_DisplayInit();
	end
end

function TRK_GetTrackerEntry(mName)
	for index, mTable in pairs(TRK_TrackerTable) do
		if(string.lower(mName) == string.lower(mTable.en) or string.lower(mName) == string.lower(mTable.de) or string.lower(mName) == string.lower(mTable.fr)) then
			return mTable[MetaMap_Locale], index, mTable.cat;
		end
	end
end

function TRK_AddNode(zone, name, creator, x, y)
	if(TRK_Data[zone]) then
		for index, value in ipairs(TRK_Data[zone]) do
			if(abs(value.xPos-x) <= 0.01 and abs(value.yPos-y) <= 0.01) then
				return;
			end
		end
	end
	local _, entry = TRK_GetTrackerEntry(name);
	if(not entry) then MetaMap_Print(TRK_TABLE_ERR..": "..name, true); return; end
	if(not TRK_Data[zone]) then
		TRK_Data[zone] = {};
	end
	tinsert(TRK_Data[zone], {ref = entry, creator = creator, xPos = x, yPos = y});
	return true;
end

function TRK_ProcessNode(event)
	if(not MetaMapOptions.MetaMapTracker) then return; end
	local x, y = GetPlayerMapPosition("player");
	if(x == 0 and y == 0) then return; end
	local zone = GetRealZoneText();
	if(string.match(event, "CHAT_MSG")) then
		if(string.match(arg1, TRK_DETECT_HERB) and TRK_Options.Herbs) then
			local name = string.match(arg1, "^"..TRK_DETECT_HERB.." (.+)%.$");
			if(name) then
				TRK_AddNode(zone, name, UnitName("player"), x, y);
			end
		elseif(string.match(arg1, TRK_DETECT_ORE) and TRK_Options.Ores) then
			local name = string.match(arg1, "^"..TRK_DETECT_ORE.." (.+)%.$");
			if(name) then
				TRK_AddNode(zone, name, UnitName("player"), x, y);
			end
		elseif(string.match(arg1, TRK_DETECT_TREASURE) and TRK_Options.Treasure) then
			local name = string.match(arg1, "^"..TRK_DETECT_TREASURE.." (.+)%.$");
			if(name) then
				TRK_AddNode(zone, name, UnitName("player"), x, y);
			end
		end
	elseif(string.match(event, "UI_ERROR_MESSAGE") and TRK_Options.Unmined) then
		local name = GameTooltipTextLeft1:GetText();
		if(name and strlen(name) > 0) then
			if(string.find(arg1, TRK_HERBALISM) and TRK_Options.Herbs) then
				TRK_AddNode(zone, name, UnitName("player"), x, y);
			elseif(string.find(arg1, TRK_MINING) and TRK_Options.Ores) then
				TRK_AddNode(zone, name, UnitName("player"), x, y);
			end
		end
	end
end

function TRK_DisplayNodes(mapName)
	local buttonID = 1;
	local dataZone = TRK_Data[mapName];
	if(dataZone) then
		for index, value in ipairs(dataZone) do
			local showThis = false;
			local cat = TRK_TrackerTable[value.ref].cat;
			if(cat == "Herb" and TRK_Options.FilterHerb) then showThis = true; end
			if(cat == "Ore" and TRK_Options.FilterOre) then showThis = true; end
			if(cat == "Treasure" and TRK_Options.FilterTreasure) then showThis = true; end
			if(showThis) then
				local temp = TRK_CreateNodeObject(buttonID);
				local x = dataZone[index].xPos * WorldMapButton:GetWidth();
				local y = -dataZone[index].yPos * WorldMapButton:GetHeight();
				temp:SetParent("WorldMapButton");
				temp:SetPoint("CENTER", "WorldMapButton", "TOPLEFT", x, y);
				getglobal("TRK_Node"..buttonID.."Texture"):SetTexture(TRK_ICON_PATH..TRK_TrackerTable[value.ref].icon);
				temp.ref = value.ref;
				temp.node = index;
				temp:Show();
				buttonID = buttonID +1;
			end
		end
	end
	for i=buttonID, TRK_LastNode, 1 do
		getglobal("TRK_Node"..i):Hide();
	end
end

function TRK_NodeOnEnter(ref, noteID)
	local mapName = MetaMap_GetCurrentMapInfo();
	WorldMapTooltip:SetOwner(this, "ANCHOR_LEFT");
	WorldMapTooltip:AddDoubleLine(TRK_TrackerTable[ref][MetaMap_Locale], TRK_TrackerTable[ref].cat, 0, 1, 0, 0.6, 0.6, 0.6);
	WorldMapTooltip:AddDoubleLine(TRK_HEADER_LEVEL, TRK_TrackerTable[ref].level, 0.75, 0.85, 0, 0.75, 0.85, 0, 1);
	WorldMapTooltip:AddDoubleLine(TRK_CREATOR, TRK_Data[mapName][noteID].creator, 0, 0.75, 0.85, 0, 0.75, 0.85, 1);
	WorldMapTooltip:Show();
end

function TRK_NodeOnClick(arg1, id)
end

function TRK_QuickMenuInit()
end

function TRK_DisplayInit()
	TRK_NodeList.Herbs = {}; TRK_NodeList.Ores = {}; TRK_NodeList.Treasure = {};
	TRK_HerbTotal, TRK_OreTotal, TRK_TreasureTotal, TRK_ItemTotal = 0,0,0,0;
	local mapName = MetaMap_GetCurrentMapInfo();
	for zoneName, iTable in pairs(TRK_Data) do
		TRK_ItemTotal = TRK_ItemTotal + #(iTable);
		if(MetaMap_CheckRelatedZone(zoneName, mapName) or TRK_Options.ShowAll) then
			for index, value in ipairs(iTable) do
				local showThis = false;
				local name = TRK_TrackerTable[value.ref][MetaMap_Locale];
				local level = TRK_TrackerTable[value.ref].level;
				local cat = TRK_TrackerTable[value.ref].cat;
				if(cat == "Herb" and TRK_Options.ShowHerb) then showThis = true; end
				if(cat == "Ore" and TRK_Options.ShowOre) then showThis = true; end
				if(cat == "Treasure" and TRK_Options.ShowTreasure) then showThis = true; end
				if((TRK_Options.ShowAll or showThis) and string.find(string.lower(name),string.lower(TRK_LastSearch),1,true)) then
					if(cat == "Herb") then
						local id = TRK_FindMatch(TRK_NodeList.Herbs, name);
						if(id) then
							TRK_NodeList.Herbs[id].nodes = TRK_NodeList.Herbs[id].nodes +1;
						else
							tinsert(TRK_NodeList.Herbs, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level});
						end
						TRK_HerbTotal = TRK_HerbTotal +1;
					elseif(cat == "Ore") then
						local id = TRK_FindMatch(TRK_NodeList.Ores, name);
						if(id) then
							TRK_NodeList.Ores[id].nodes = TRK_NodeList.Ores[id].nodes +1;
						else
							tinsert(TRK_NodeList.Ores, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level});
						end
						TRK_OreTotal = TRK_OreTotal +1;
					elseif(cat == "Treasure") then
						local id = TRK_FindMatch(TRK_NodeList.Treasure, name);
						if(id) then
							TRK_NodeList.Treasure[id].nodes = TRK_NodeList.Treasure[id].nodes +1;
						else
							tinsert(TRK_NodeList.Treasure, {name = name, nodes = 1, index = value.ref, zone = zoneName, noteID = index, level = level});
						end
						TRK_TreasureTotal = TRK_TreasureTotal +1;
					end
				end
			end
		end
	end
	TRK_SortTrackerList(TRK_Options.Sortby);
	TRK_HeaderText:SetText(mapName);
	TRK_InfoText1:SetText("Total items: |cffffff00"..TRK_ItemTotal.."|r   Displayed: |cffffff00"..TRK_HerbTotal+TRK_OreTotal+TRK_TreasureTotal);
	if(MetaMapOptions.MetaMapTracker) then
		TRK_InfoText2:SetText(TRK_TRACKING..": |cff00ff00"..TRK_TRACKING2);
	else
		TRK_InfoText2:SetText(TRK_TRACKING..": |cffff0000"..TRK_TRACKING1);
	end
	TRK_RefreshDisplay();
end

function TRK_SortTrackerList(sort)
	local tmp = MetaMap_sortType;
	MetaMap_sortType = sort;
  table.sort(TRK_NodeList.Herbs, MetaMap_SortCriteria);
  table.sort(TRK_NodeList.Ores, MetaMap_SortCriteria);
  table.sort(TRK_NodeList.Treasure, MetaMap_SortCriteria);
	MetaMap_sortType = tmp;
end

function TRK_FindMatch(table, name)
	for index, value in pairs(table) do
		if(value.name == name) then
			return index;
		end
	end
end

function TRK_RefreshDisplay()
	local buttonID = 1;
	local ScrollHeight = 0;
	local button, buttonText;
	if(#(TRK_NodeList.Herbs) > 0) then
		local button = TRK_CreateButton(buttonID);
		local buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("|cFFBFBFFF"..TRK_HERBALISM.." - "..TRK_HerbTotal.." "..TRK_HEADER_NODES);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -10);
		else
			button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Herbs) do
		button = TRK_CreateButton(buttonID);
		buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("    "..mList.name);
		getglobal("TRKButton"..buttonID.."Nodes"):SetText(mList.nodes);
		getglobal("TRKButton"..buttonID.."Level"):SetText(TRK_TrackerTable[mList.index].level);
		button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
	end
	if(#(TRK_NodeList.Ores) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("|cFFBFBFFF"..TRK_MINING.." - "..TRK_OreTotal.." "..TRK_HEADER_NODES);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -10);
		else
			button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Ores) do
		button = TRK_CreateButton(buttonID);
		buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("    "..mList.name);
		getglobal("TRKButton"..buttonID.."Nodes"):SetText(mList.nodes);
		getglobal("TRKButton"..buttonID.."Level"):SetText(TRK_TrackerTable[mList.index].level);
		button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
	end
	if(#(TRK_NodeList.Treasure) > 0) then
		button = TRK_CreateButton(buttonID);
		buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("|cFFBFBFFF"..TRK_TREASURE.." - "..TRK_TreasureTotal.." "..TRK_HEADER_NODES);
		if(buttonID == 1) then
			button:SetPoint("TOPLEFT", "TRK_ScrollChild", "TOPLEFT", 10, -10);
		else
			button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		end
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
		button:Show();
	end
	for index, mList in ipairs(TRK_NodeList.Treasure) do
		button = TRK_CreateButton(buttonID);
		buttontext = getglobal("TRKButton"..buttonID.."Text");
		buttontext:SetText("    "..mList.name);
		getglobal("TRKButton"..buttonID.."Nodes"):SetText(mList.nodes);
		getglobal("TRKButton"..buttonID.."Level"):SetText(TRK_TrackerTable[mList.index].level);
		button:SetPoint("TOP", getglobal("TRKButton"..buttonID-1), "BOTTOM", 0, 0)
		button:SetHeight(buttontext:GetHeight() + TRK_Options.Padding);
		button:Show();
		ScrollHeight = ScrollHeight + button:GetHeight();
		buttonID = buttonID +1;
	end
	for i=buttonID, TRK_ButtonTotal, 1 do
		getglobal("TRKButton"..i):Hide()
	end
	TRK_ScrollChild:SetHeight(ScrollHeight);
	TRK_ScrollFrame:UpdateScrollChildRect()
end

function TRK_FilterMenuInit()
	for index, menuItem in ipairs(TRK_FilterMenu) do
		local check = nil;
		local spacer = nil;
		if(menuItem[3]) then spacer = 1; end
		if(TRK_Options.Sortby == string.gsub(menuItem[2], "Sortby", "")) then
			check = 1;
		elseif(TRK_Options[menuItem[2]]) then
			check = 1;
		end
		local info = {};
		info.isTitle = spacer;
		info.notClickable = spacer;
		info.checked = check;
		info.text = menuItem[1];
		info.value = menuItem[2];
		info.func = TRK_FilterMenuOnClick;
		UIDropDownMenu_AddButton(info);
	end
end

function TRK_FilterMenuOnClick()
	if(string.match(this.value, "Sortby")) then
		TRK_Options.Sortby = string.gsub(this.value, "Sortby", "");
		TRK_SortTrackerList(TRK_Options.Sortby);
		TRK_RefreshDisplay();
		return;
	else
		TRK_ToggleOptions(this.value);
	end
  UIDropDownMenu_SetText(this:GetText(), TRK_FilterSelect);
	TRK_DisplayInit();
end

function TRK_MetaMapMenuOnClick()
	TRK_ToggleOptions(this.value);
	TRK_DisplayInit();
	MetaMap_MainMapUpdate();
end

function TRK_CreateNodeObject(id)
	local button;
	if(getglobal("TRK_Node"..id)) then
		button = getglobal("TRK_Node"..id);
		button.index = nil;
	else
		button = CreateFrame("Button" ,"TRK_Node"..id, WorldMapButton, "TRK_NodeTemplate");
		TRK_LastNode = TRK_LastNode +1;
	end
	return button;
end

function TRK_CreateButton(id)
	local button;
	if(getglobal("TRKButton"..id)) then
		button = getglobal("TRKButton"..id);
		getglobal("TRKButton"..id.."Text"):SetText("");
		getglobal("TRKButton"..id.."Nodes"):SetText("");
		getglobal("TRKButton"..id.."Level"):SetText("");
	else
		button = CreateFrame("Button" ,"TRKButton"..id, TRK_ScrollChild, "TRK_ButtonTemplate");
		button:SetWidth(TRK_ScrollChild:GetWidth());
		TRK_ButtonTotal = TRK_ButtonTotal +1;
	end
	button:SetID(id);
	return button;
end

function TRK_ToggleOptions(key, value)
	if(value) then
		TRK_Options[key] = value;
	else
		TRK_Options[key] = not TRK_Options[key];
	end
	return TRK_Options[key];
end

TRK_TrackerTable = {
	--- Herbs
	[1]  = {cat = "Herb", en = "Silverleaf", de = "Silberblatt", fr = "Feuillargent", level = 1, icon = "Herb_Silverleaf"},
	[2]  = {cat = "Herb", en = "Peacebloom", de = "Friedensblume", fr = "Pacifique", level = 1, icon = "Herb_Peacebloom"},
	[3]  = {cat = "Herb", en = "Earthroot", de = "Erdwurzel", fr = "Terrestrine", level = 15, icon = "Herb_Earthroot"},
	[4]  = {cat = "Herb", en = "Mageroyal", de = "Magusk\195\182nigskraut", fr = "Mage Royal", level = 50, icon = "Herb_Mageroyal"},
	[5]  = {cat = "Herb", en = "Swiftthistle", de = "Flitzdistel", fr = "Chardonnier", level = 50, icon = "Herb_Swiftthistle"},
	[6]  = {cat = "Herb", en = "Briarthorn", de = "Wilddornrose", fr = "Eglantine", level = 75, icon = "Herb_Briarthorn"},
	[7]  = {cat = "Herb", en = "Stranglekelp", de = "W\195\188rgetang", fr = "Etouffante", level = 85, icon = "Herb_Stranglekelp"},
	[8]  = {cat = "Herb", en = "Bruiseweed", de = "Beulengras", fr = "Doulourante", level = 100, icon = "Herb_Bruiseweed"},
	[9]  = {cat = "Herb", en = "Wild Steelbloom", de = "Wildstahlblume", fr = "Aci\195\169rite Sauvage", level = 115, icon = "Herb_WildSteelbloom"},
	[10] = {cat = "Herb", en = "Grave Moss", de = "Grabmoos", fr = "Tombeline", level = 120, icon = "Herb_GraveMoss"},
	[11] = {cat = "Herb", en = "Kingsblood", de = "K\195\182nigsblut", fr = "Sang-Royal", level = 125, icon = "Herb_Kingsblood"},
	[12] = {cat = "Herb", en = "Liferoot", de = "Lebenswurz", fr = "Viet\195\169rule", level = 150, icon = "Herb_Liferoot"},
	[13] = {cat = "Herb", en = "Fadeleaf", de = "Blassblatt", fr = "P\195\162lerette", level = 160, icon = "Herb_Fadeleaf"},
	[14] = {cat = "Herb", en = "Goldthorn", de = "Golddorn", fr = "Dor\195\169pine", level = 175, icon = "Herb_Goldthorn"},
	[15] = {cat = "Herb", en = "Khadgar's Whisker", de = "Khadgars Schnurrbart", fr = "Moustache de Khadgar", level = 185, icon = "Herb_KhadgarsWhisker"},
	[16] = {cat = "Herb", en = "Wintersbite", de = "Winterbiss", fr = "Hivernale", level = 195, icon = "Herb_Wintersbite"},
	[17] = {cat = "Herb", en = "Firebloom", de = "Feuerbl\195\188te", fr = "Fleur de Feu", level = 205, icon = "Herb_Firebloom"},
	[18] = {cat = "Herb", en = "Purple Lotus", de = "Lila Lotus", fr = "Lotus Pourpre", level = 210, icon = "Herb_PurpleLotus"},
	[19] = {cat = "Herb", en = "Wildvine", de = "Wildranke", fr = "Sauvageonne", level = 210, icon = ""},
	[20] = {cat = "Herb", en = "Arthas' Tears", de = "Arthas\226\128\153 Tr\195\164nen", fr = "Larmes d'Arthas", level = 220, icon = "Herb_ArthasTears"},
	[21] = {cat = "Herb", en = "Sungrass", de = "Sonnengras", fr = "Soleillette", level = 230, icon = "Herb_Sungrass"},
	[22] = {cat = "Herb", en = "Blindweed", de = "Blindkraut", fr = "Aveuglette", level = 235, icon = "Herb_Blindweed"},
	[23] = {cat = "Herb", en = "Ghost Mushroom", de = "Geisterpilz", fr = "Champignon Fant\195\180me", level = 245, icon = "Herb_GhostMushroom"},
	[24] = {cat = "Herb", en = "Gromsblood", de = "Gromsblut", fr = "Gromsang", level = 250, icon = "Herb_Gromsblood"},
	[25] = {cat = "Herb", en = "Golden Sansam", de = "Goldener Sansam", fr = "Sansam Dor\195\169", level = 260, icon = "Herb_GoldenSansam"},
	[26] = {cat = "Herb", en = "Dreamfoil", de = "Traumblatt", fr = "Feuiller\195\170ve", level = 270, icon = "Herb_Dreamfoil"},
	[27] = {cat = "Herb", en = "Mountain Silversage", de = "Bergsilberweisling", fr = "Sauge-Argent des Montagnes", level = 280, icon = "Herb_MountainSilversage"},
	[28] = {cat = "Herb", en = "Plaguebloom", de = "Pestbl\195\188te", fr = "Fleur de Peste", level = 285, icon = "Herb_Plaguebloom"},
	[29] = {cat = "Herb", en = "Icecap", de = "Eiskappe", fr = "Calot de Glace", level = 290, icon = "Herb_Icecap"},
	[30] = {cat = "Herb", en = "Black Lotus", de = "Schwarzer Lotus", fr = "Lotus Noir", level = 300, icon = "Herb_BlackLotus"},
	[31] = {cat = "Herb", en = "Felweed", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	[32] = {cat = "Herb", en = "Dreaming Glory", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	[33] = {cat = "Herb", en = "Terocone", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	[34] = {cat = "Herb", en = "Ragveil", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	[35] = {cat = "Herb", en = "Netherbloom", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	[36] = {cat = "Herb", en = "Flamecap", de = "", fr = "", level = 301, icon = "Herb_Generic"},
	--- Ores
	[50] = {cat = "Ore", en = "Copper Vein", de = "Kupfervorkommen", fr = "Filon de cuivre", level = 1, icon = "Ore_Copper"},
	[51] = {cat = "Ore", en = "Tin Vein", de = "Zinnvorkommen", fr = "Filon \195\169tain", level = 65, icon = "Ore_Tin"},
	[52] = {cat = "Ore", en = "Silver Vein", de = "Silbervorkommen", fr = "Filon Argent", level = 75, icon = "Ore_Silver"},
	[53] = {cat = "Ore", en = "Iron Deposit", de = "Eisenvorkommen", fr = "Gisement de fer", level = 125, icon = "Ore_Iron"},
	[54] = {cat = "Ore", en = "Gold Vein", de = "Goldvorkommen", fr = "Filon d'or", level = 155, icon = "Ore_Gold"},
	[55] = {cat = "Ore", en = "Mithril Deposit", de = "Mithrilablagerung", fr = "Gisement de mithril", level = 175, icon = "Ore_Mithril"},
	[56] = {cat = "Ore", en = "Truesilver Deposit", de = "Echtsilberablagerung", fr = "Gisement de vrai-argent", level = 230, icon = "Ore_Truesilver"},
	[57] = {cat = "Ore", en = "Dark Iron Deposit", de = "Dunkeleisenablagerung", fr = "Gisement de sombrefer", level = 230, icon = "Ore_DarkIron"},
	[58] = {cat = "Ore", en = "Small Thorium Vein", de = "Kleines Thoriumvorkommen", fr = "Petit filon de thorium", level = 245, icon = "Ore_Thorium"},
	[59] = {cat = "Ore", en = "Rich Thorium Vein", de = "Reiches Thoriumvorkommen", fr = "Riche filon de thorium", level = 275, icon = "Ore_RThorium"},
	[60] = {cat = "Ore", en = "Fel Iron Deposit", de = "", fr = "", level = 300, icon = "Ore_Generic"},
	[61] = {cat = "Ore", en = "Adamantite Vein", de = "", fr = "", level = 325, icon = "Ore_Generic"},
	[62] = {cat = "Ore", en = "Rich Adamantite Vein", de = "", fr = "", level = 375, icon = "Ore_Generic"},
	[63] = {cat = "Ore", en = "Khorium Vein", de = "", fr = "", level = 375, icon = "Ore_Generic"},
	--- Treasure
	[80] = {cat = "Treasure", en = "Alliance Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[81] = {cat = "Treasure", en = "Horde Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[82] = {cat = "Treasure", en = "Battered Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[83] = {cat = "Treasure", en = "Locked Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[84] = {cat = "Treasure", en = "Rusty Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[85] = {cat = "Treasure", en = "Solid Chest", de = "", fr = "", level = 0, icon = "Treasure_Chest"},
	[86] = {cat = "Treasure", en = "Armor Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[87] = {cat = "Treasure", en = "Food Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[88] = {cat = "Treasure", en = "Horde Supply Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[89] = {cat = "Treasure", en = "Sealed Supply Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[90] = {cat = "Treasure", en = "Scattered Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[91] = {cat = "Treasure", en = "Weapon Crate", de = "", fr = "", level = 0, icon = "Treasure_Crate"},
	[92] = {cat = "Treasure", en = "Sealed Barrel", de = "", fr = "", level = 0, icon = "Treasure_Barrel"},
	[93] = {cat = "Treasure", en = "Blood of Heroes", de = "Blut von Helden", fr = "Sang des H\195\169ros", level = 0, icon = "Treasure_BloodHero"},
	[94] = {cat = "Treasure", en = "Shellfish Trap", de = "Schalentierfalle", fr = "Casier \195\160 Crustac\195\169s", level = 0, icon = "Treasure_ShellfishTrap"},
	[95] = {cat = "Treasure", en = "Giant Clam", de = "Muschel", fr = "Palourde", level = 0, icon = "Treasure_Clam"},
	[96] = {cat = "Treasure", en = "Power Crystal", de = "Machtkristall", fr = "Cristal de Puissance", level = 0, icon = "Treasure_PowerCrystal"},
	[97] = {cat = "Treasure", en = "Un'Goro Dirt Pile", de = "", fr = "", level = 0, icon = "Treasure_DirtPile"},
	[98] = {cat = "Treasure", en = "Bloodpetal Sprout", de = "Blutbl\195\188tenspr\195\182ssling", fr = "Pousse de P\195\169tale de Sang", level = 0, icon = "Treasure_Sprout"},
}
