--[[
	Bongos Bindings
--]]

local enabled

local function ShowEmptyButtons()
	bg_showGrid = 1
	BActionButton.ForAll(BActionButton.ShowGrid)
	BPetBar_ForAllButtons(BPetButton.ShowGrid)
end

local function HideEmptyButtons()
	bg_showGrid = nil
	BActionButton.ForAll(BActionButton.HideGrid)
	BPetBar_ForAllButtons(BPetButton.HideGrid)
end

--[[ Options Frame Functions ]]--

function BOptionsBinder_OnShow()
	enabled = true
	ShowEmptyButtons()

	if InCombatLockdown() then
		CQ.Do(KeyBound_Enable)
	else
		KeyBound_Enable()
	end
end

function BOptionsBinder_OnHide()
	enabled = nil

	HideEmptyButtons()
	KeyBound_Disable()
end

local wasEnabled
BEvent:AddAction('PLAYER_REGEN_ENABLED', function()
	if wasEnabled or enabled then
		ShowEmptyButtons()
	end
	wasEnabled = nil
end)

BEvent:AddAction('PLAYER_REGEN_DISABLED', function()
	wasEnabled = enabled
	if wasEnabled then
		HideEmptyButtons()
	end
end)