--[[
	BCastBar
		A Bongos based cast bar
--]]

local function AdjustWidth(castingBar)
	local castingBarName = castingBar:GetName()

	local textWidth = getglobal(castingBarName .. "Text"):GetStringWidth()
	if getglobal(castingBarName .. "Time"):IsShown() then
		textWidth = textWidth + 36
	end

	local diff = textWidth * 1.25 - castingBar.normalWidth
	if diff > 0 then
		diff = textWidth * 1.25 - castingBar:GetWidth()
	else
		diff = castingBar.normalWidth - castingBar:GetWidth()
	end

	if diff ~= 0 then
		castingBar:GetParent():SetWidth(castingBar:GetParent():GetWidth() + diff)
		castingBar:SetWidth(castingBar:GetWidth() + diff)

		getglobal(castingBarName .. "Border"):SetWidth( getglobal(castingBarName .. "Border"):GetWidth() + (diff * 1.32))
		getglobal(castingBarName .. "Flash"):SetWidth( getglobal(castingBarName .. "Flash"):GetWidth() + (diff * 1.32))
	end
end

function BCastingBarFrame_OnUpdate()
	local barSpark = getglobal(this:GetName().."Spark")
	local barFlash = getglobal(this:GetName().."Flash")
	local barTime = getglobal(this:GetName().."Time")

	if this.casting then
		local status = GetTime()
		if status > this.maxValue then
			status = this.maxValue
		end
		if status == this.maxValue then
			this:SetValue(this.maxValue)
			this:SetStatusBarColor(0.0, 1.0, 0.0)
			barSpark:Hide()
			barFlash:SetAlpha(0.0)
			barFlash:Show()
			this.casting = nil
			this.flash = 1
			this.fadeOut = 1
			return
		end
		this:SetValue(status)
		barFlash:Hide()
		local sparkPosition = ((status - this.startTime) / (this.maxValue - this.startTime)) * this:GetWidth()
		if sparkPosition < 0 then
			sparkPosition = 0
		end
		barSpark:SetPoint("CENTER", this, "LEFT", sparkPosition, 2)

		--time display
		barTime:SetText(format("%.1f", this.maxValue - status))
		AdjustWidth(this)
	elseif this.channeling then
		local time = GetTime()
		if time > this.endTime then
			time = this.endTime
		end
		if time == this.endTime then
			this:SetStatusBarColor(0.0, 1.0, 0.0)
			barSpark:Hide()
			barFlash:SetAlpha(0.0)
			barFlash:Show()
			this.channeling = nil
			this.flash = 1
			this.fadeOut = 1
			return
		end
		local barValue = this.startTime + (this.endTime - time)
		this:SetValue(barValue)
		barFlash:Hide()
		local sparkPosition = ((barValue - this.startTime) / (this.endTime - this.startTime)) * this:GetWidth()
		barSpark:SetPoint("CENTER", this, "LEFT", sparkPosition, 2)

		--time display
		barTime:SetText(format("%.1f", this.endTime - time))
		AdjustWidth(this)
	elseif GetTime() < this.holdTime then
		return
	elseif this.flash then
		local alpha = barFlash:GetAlpha() + CASTING_BAR_FLASH_STEP
		if alpha < 1 then
			barFlash:SetAlpha(alpha)
		else
			barFlash:SetAlpha(1.0)
			this.flash = nil
		end
	elseif this.fadeOut then
		local alpha = this:GetAlpha() - CASTING_BAR_ALPHA_STEP
		if alpha > 0 then
			this:SetAlpha(alpha)
		else
			this.fadeOut = nil
			this:Hide()
		end
	end
end

--[[ CastingBar Constructor ]]--

local function CastingBar_Create(parent)
	local bar = CreateFrame("StatusBar", parent:GetName() .. "CastBar", parent, "BongosCastingBarTemplate")
	bar.normalWidth = bar:GetWidth()

	return bar
end

--[[ Config Functions ]]--

local function ToggleText(bar, enable)
	local castingBar = getglobal(bar:GetName() .. 'CastBar')

	if enable then
		getglobal(castingBar:GetName() .. "Time"):Show()
		bar.sets.showText = 1
	else
		getglobal(castingBar:GetName() .. "Time"):Hide()
		bar.sets.showText = nil
	end

	AdjustWidth(castingBar)
end

local function CreateConfigMenu(name)
	local menu = CreateFrame("Button", name, UIParent, "BongosRightClickMenu")
	menu:SetWidth(220)
	menu:SetHeight(150)
	menu:SetText("Cast Bar")

	local timeButton = CreateFrame("CheckButton", name .. "Time", menu, "BongosCheckButtonTemplate")
	timeButton:SetScript("OnClick", function() ToggleText(this:GetParent().frame, this:GetChecked()) end)
	timeButton:SetPoint("TOPLEFT", menu, "TOPLEFT", 8, -28)
	timeButton:SetText(BONGOS_CASTBAR_SHOW_TIME)

	local scaleSlider = CreateFrame("Slider", name .. "Scale", menu, "BongosScaleSlider")
	scaleSlider:SetPoint("TOPLEFT", timeButton, "BOTTOMLEFT", 2, -10)

	local opacitySlider = CreateFrame("Slider", name .. "Opacity", menu, "BongosOpacitySlider")
	opacitySlider:SetPoint("TOP", scaleSlider, "BOTTOM", 0, -24)
end

local function ShowMenu(bar)
	if not BongosCastBarMenu then
		CreateConfigMenu("BongosCastBarMenu")
		BongosCastBarMenu.frame = bar
	end

	BongosCastBarMenu.onShow = 1

	BongosCastBarMenuTime:SetChecked(bar.sets.showText)
	BongosCastBarMenuScale:SetValue(bar:GetScale() * 100)
	BongosCastBarMenuOpacity:SetValue(bar:GetAlpha() * 100)

	BMenu.ShowForBar(BongosCastBarMenu, bar)
	BongosCastBarMenu.onShow = nil
end

--[[ Startup ]]--

local function OnCreate(bar)
	CastingBarFrame:UnregisterAllEvents()
	CastingBarFrame:Hide()

	local castingBar = CastingBar_Create(bar)
	castingBar:SetPoint("TOPLEFT", bar, "TOPLEFT", 8, -12)
end

BProfile.AddStartup(function()
	local bar = BBar.Create("cast", "BCastBar", "BCastBarSets", ShowMenu, 1, nil, OnCreate)
	bar:SetWidth(212) bar:SetHeight(30)

	if not bar:IsUserPlaced() then
		bar:SetPoint("CENTER", UIParent, "CENTER", 0, 20)
	end
	ToggleText(bar, bar.sets.showText)
end)