--[[
	BPetButton
		A Pet Action Button
		Should work exactly like the normal pet action buttons, but with a modified appearance
--]]

local function ReuseAndRename(oldName, newName, parent)
	local button = getglobal(oldName)
	setglobal(newName, button)

	button:SetParent(parent)
	button:SetAlpha(parent:GetAlpha())
	button:SetFrameLevel(0)
	
	parent:SetAttribute('addchild', button)

	return button
end

BPetButton = {
	Create = function(id, parent)
		local button = ReuseAndRename('PetActionButton' .. id, 'BPetActionButton' .. id, parent)
		parent:SetAttribute('addchild', button)

		BPetButton.Style(button)
		BPetButton.UpdateHotkey(button)
		BPetButton.SetScripts(button)
		
		if not BActionSets_HotkeysShown() then
			getglobal(button:GetName() .. 'HotKey'):Hide()
		end

		return button
	end,
	
	Style = function(button)
		local name = button:GetName()
		
		getglobal(name .. "AutoCastable"):SetPoint("CENTER", button, "CENTER", 0, -1)
		
		local autoCast = getglobal(name .. "AutoCast")
		autoCast:SetPoint("TOPLEFT", button, "TOPLEFT", -0.5, -1)
		autoCast:SetPoint("BOTTOMRIGHT", button, "BOTTOMRIGHT", 0.5, -1.5)
		
		getglobal(name .. 'Icon'):SetTexCoord(0.06, 0.94, 0.06, 0.94)
		getglobal(name .. 'NormalTexture2'):SetVertexColor(1, 1, 1, 1)
	end,

	SetScripts = function(button)
		button:RegisterForDrag('LeftButton', 'RightButton')
		button:RegisterForClicks('anyUp')

		button:SetScript("OnLoad", nil)
		button:SetScript("OnEvent", nil)
		button:SetScript("OnDragStart", BPetButton.OnDragStart)
		button:SetScript('PostClick', BPetButton.PostClick)
		button:SetScript("OnDragStart", BPetButton.OnDragStart)
		button:SetScript("OnReceiveDrag", BPetButton.OnReceiveDrag)
		button:SetScript("OnEnter", BPetButton.OnEnter)
		button:SetScript("OnLeave", BPetButton.OnLeave)
	end,

	--[[ OnX Functions ]]--

	PostClick = function()
		if bg_showGridPet then
			this:SetChecked(0)
			PickupPetAction(this:GetID())
		end
	end,

	OnDragStart = function()
		if not BActionSets_ButtonsLocked() or BActionSets_IsQuickMoveKeyDown() or bg_showGridPet then
			this:SetChecked(0)
			PickupPetAction(this:GetID())
		end
	end,

	OnReceiveDrag = function()
		if BActionSets_IsQuickMoveKeyDown() or bg_showGridPet then
			this:SetChecked(0)
			PickupPetAction(this:GetID())
		end
	end,

	OnEnter = function()
		if BActionSets_TooltipsShown() then
			PetActionButton_OnEnter()
		end
	end,

	OnLeave = function()
		PetActionButton_OnLeave(this)
	end,

	--[[ Update Functions ]]--

	Update = function(button)
		local name, subtext, texture, isToken, isActive, autoCastAllowed, autoCastEnabled = GetPetActionInfo(button:GetID())
		local buttonName = button:GetName()

		button.isToken = isToken
		button.tooltipSubtext = subtext
		button:SetChecked(isActive)

		if name then
			CQ.Show(button)
		elseif not(bg_showGridPet or BActionSets_ShowGrid()) then
			CQ.Hide(button)
		end

		local icon = getglobal(button:GetName() .. "Icon")

		if texture then
			if GetPetActionsUsable() then
				SetDesaturation(icon, false)
			else
				SetDesaturation(icon, true)
			end
			icon:Show()
			button:SetNormalTexture('Interface\\Buttons\\UI-Quickslot2')
			getglobal(buttonName .. 'NormalTexture2'):SetVertexColor(1, 1, 1, 1)
		else
			icon:Hide()
			button:SetNormalTexture('Interface\\Buttons\\UI-Quickslot')
			getglobal(buttonName .. 'NormalTexture2'):SetVertexColor(1, 1, 1, 0.5)
		end

		if not isToken then
			icon:SetTexture(texture)
			button.tooltipName = name
		else
			icon:SetTexture(getglobal(texture))
			button.tooltipName = getglobal(name)
		end

		local autoCastTexture = getglobal(buttonName .. 'AutoCastable')
		if autoCastAllowed then
			autoCastTexture:Show()
		else
			autoCastTexture:Hide()
		end

		local autoCastModel = getglobal(buttonName .. 'AutoCast')
		if autoCastEnabled then
			autoCastModel:Show()
		else
			autoCastModel:Hide()
		end
	end,

	UpdateCooldown = function(button)
		local start, duration, enable = GetPetActionCooldown(button:GetID())
		CooldownFrame_SetTimer(getglobal(button:GetName() .. 'Cooldown'), start, duration, enable)
	end,

	UpdateHotkey = function(button)
		BBasicActionButton.UpdateHotkey(button, 'BONUSACTIONBUTTON')
	end,

	ShowGrid = function(button) 
		CQ.Show(button)
	end,

	HideGrid = function(button)
		if not GetPetActionInfo(button:GetID()) then
			CQ.Hide(button)
		end
	end,
}