--[[
	Bongos_ActionBar\main.lua
		Handles variable loading\updating
--]]

--[[ Settings Loading ]]--

local function LoadDefaults()
	BActionSets = {
		g = {
			version = GetAddOnMetadata("Bongos_ActionBar", "Version"),
			buttonsLocked = 1,
			tooltips = 1,
			quickMove = 1,
			colorOutOfRange = 1,
			rangeColor = {r = 1, g = 0.5, b = 0.5},
			numActionBars = 10,
		},
	}
end

local function UpdateSettings(currentVersion)
	BActionSets.g.buttonsLocked = 1

	if not BActionSets[1] then
		BActionSets[1] = {
			vis = 1,
			paging = 1,
		}
	end

	local class = select(2,UnitClass("player"))
	if class == 'DRUID' then
		BActionSets[1].stances = {8, nil, 6, nil, 9, nil, 7} --bear, aquatic, cat, travel, moonkin, flight, prowl
	elseif class == 'WARRIOR' then
		BActionSets[1].stances = {6, 7, 8}
	elseif class == 'ROGUE' then
		BActionSets[1].stances = {6}
	elseif class == 'PRIEST' then
		BActionSets[1].stances = {6}
	end
	BActionSets.g.version = currentVersion
end

local function LoadVariables()
	local currentVersion = GetAddOnMetadata("Bongos_ActionBar", "Version")

	if not(BActionSets and BActionSets.g and BActionSets.g.version) then
		LoadDefaults()
	elseif TLib.VToN(BActionSets.g.version) < TLib.VToN(currentVersion) then
		UpdateSettings(currentVersion)
	end
end

--[[ Startup ]]--

BProfile.RegisterForSave("BActionSets.g")
BProfile.AddStartup(LoadVariables)