local NORMALTEX_RATIO = 1.833333333

BBasicActionButton = {
	Create = function(id, name, parent, size, template)
		local button = CreateFrame("CheckButton", name, parent, template)
		button:SetID(id)
		button:SetAlpha(parent:GetAlpha())
		button:SetHeight(size)
		button:SetWidth(size)

		--icon texture
		local iconTexture = button:CreateTexture(name .. "Icon", "BACKGROUND")
		iconTexture:SetTexCoord(0.06, 0.94, 0.06, 0.94)
		iconTexture:SetAllPoints(button)

		--normal, pushed, highlight, checked textures
		local normalTexture = button:CreateTexture(name .. "NormalTexture")
		normalTexture:SetTexture("Interface\\Buttons\\UI-Quickslot2")
		normalTexture:SetHeight(NORMALTEX_RATIO * size)
		normalTexture:SetWidth(NORMALTEX_RATIO * size)
		normalTexture:SetPoint("CENTER", button, "CENTER", 0, -1)

		button:SetNormalTexture(normalTexture)
		button:SetPushedTexture("Interface\\Buttons\\UI-Quickslot-Depress")
		button:SetHighlightTexture("Interface\\Buttons\\ButtonHilight-Square")
		button:SetCheckedTexture("Interface\\Buttons\\CheckButtonHilight")

		--hotkey
		local hotkey = button:CreateFontString(name .. "HotKey", "ARTWORK")
		hotkey:SetFontObject(NumberFontNormalSmallGray)
		hotkey:SetPoint("TOPRIGHT", button, "TOPRIGHT", 2, -2)
		hotkey:SetJustifyH("RIGHT")
		hotkey:SetWidth(size)
		hotkey:SetHeight(10)
		if not BActionSets_HotkeysShown() then
			hotkey:Hide()
		end

		--cooldown model
		CreateFrame("Model", name .. "Cooldown", button, "CooldownFrameTemplate")

		return button
	end,
	
	GetHotkey = function(button, type)
		local key = GetBindingKey('CLICK ' .. button:GetName() .. ':LeftButton')
		if not key and type then
			key = GetBindingText(GetBindingKey(type .. button:GetID()), 'KEY_')
		end

		--hotkeys are shortened to one letter for Alt, Ctrl, Shift, and Num Pad
		if key then
			key = key:upper()
			key = key:gsub(' ', '')
			key = key:gsub('ALT%-', 'A')
			key = key:gsub('CTRL%-', 'C')
			key = key:gsub('SHIFT%-', 'S')

			key = key:gsub('NUMPAD', 'N')

			key = key:gsub('BACKSPACE', 'BS')
			key = key:gsub('PLUS', '%+')
			key = key:gsub('MINUS', '%-')
			key = key:gsub('MULTIPLY', '%*')
			key = key:gsub('DIVIDE', '%/')
			key = key:gsub('HOME', 'HN')
			key = key:gsub('INSERT', 'Ins')
			key = key:gsub('DELETE', 'Del')
			key = key:gsub('BUTTON3', 'M3')
			key = key:gsub('BUTTON4', 'M4')
			key = key:gsub('BUTTON5', 'M5')
			key = key:gsub('MOUSEWHEELDOWN', 'WD')
			key = key:gsub('MOUSEWHEELUP', 'WU')
			key = key:gsub('PAGEDOWN', 'PD')
			key = key:gsub('PAGEUP', 'PU')
		end	
		return key
	 end,

	UpdateHotkey = function(button)
		getglobal(button:GetName() .. 'HotKey'):SetText(BBasicActionButton.GetHotkey(button) or '')
	end,

	ShowHotkey = function(button, show)
		if show then
			getglobal(button:GetName() .. "HotKey"):Show()
		else
			getglobal(button:GetName() .. "HotKey"):Hide()
		end
	end,
}