--[[
	Class Button
--]]

BClassButton = {
	--constructor
	Create = function(id, parent)
		local name = parent:GetName() .. "Button" .. id
		local _, spellName = GetShapeshiftFormInfo(id)
		local button = BBasicActionButton.Create(id, name, parent, 30, 'SecureActionButtonTemplate')
		button:SetAttribute('type', 'spell')
		button:SetAttribute('*spell1', spellName)
		button:SetAttribute('*spell2', spellName)

		if not BActionSets.g.hideHotkeys then
			BClassButton.UpdateHotkey(button)
		end
		
		BClassButton.SetScripts(button)
		
		return button
    end,

	--load scripts
	SetScripts = function(button)
		button:SetScript("PostClick", BClassButton.PostClick)
		button:SetScript("OnEnter", BClassButton.OnEnter)
		button:SetScript("OnLeave", BClassButton.OnLeave)
	end,

	--[[ OnX Functions ]]--

	PostClick = function()
		this:SetChecked(not this:GetChecked())
	end,

	OnEnter = function()
		if BActionSets.g.tooltips then
			if GetCVar("UberTooltips") == "1" then
				GameTooltip_SetDefaultAnchor(GameTooltip, this)
			else
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT")
			end
			GameTooltip:SetShapeshift(this:GetID())
		end
	end,

	OnLeave = function() 
		GameTooltip:Hide() 
	end,

	Update = function(button)
		local texture, name, isActive, isCastable = GetShapeshiftFormInfo(button:GetID())
		button:SetChecked(isActive)

		--update icon
		local icon = getglobal(button:GetName() .. "Icon")
		icon:SetTexture(texture)
		if isCastable then
			icon:SetVertexColor(1.0, 1.0, 1.0)
		else
			icon:SetVertexColor(0.4, 0.4, 0.4)
		end

		--update cooldown
		local cooldown = getglobal(button:GetName() .. "Cooldown")
		if texture then
			cooldown:Show()
		else
			cooldown:Hide()
		end
		local start, duration, enable = GetShapeshiftFormCooldown(button:GetID())
		CooldownFrame_SetTimer(cooldown, start, duration, enable)
	end,

	UpdateHotkey = function(button)
		BBasicActionButton.UpdateHotkey(button, "SHAPESHIFTBUTTON")
	end,
}