--[[
	State.lua
		Does state changing for class bars and paging
--]]

local PLAYER_CLASS = select(2,UnitClass("player"))
local MAX_PAGES = 12
local classMap = ''
local pageMap = ''
local maxState = 0
local statesLoaded

--[[ State Mapping ]]--

local function AddState(stateString, fromState, toState)
	if stateString then
		return stateString .. format('%s:%s;', fromState, toState)
	end
	return format('%s:%s;', fromState, toState)
end

--[[ Class States ]]--

local function LoadDruidStates(stateMachine)
	for i = 0, 6 do
		stateMachine:SetAttribute('statemap-stance-' .. i, i * 1000) -- shapeshift forms
	end
	stateMachine:SetAttribute('statemap-stealth-1', '3000:7000') -- prowl enter
	stateMachine:SetAttribute('statemap-stealth-0', '7000:3000') -- prowl leave
end

local function LoadWarriorStates(stateMachine)
	for i = 0, 3 do
		stateMachine:SetAttribute('statemap-stance-' .. i, i * 1000) -- stances
	end
end

local function LoadRogueStates(stateMachine)
	for i = 0, 1 do
		stateMachine:SetAttribute('statemap-stance-' .. i, i * 1000) -- stealth enter/leave
	end
end

local function LoadPriestStates(stateMachine)
	for i = 0, 1 do
		stateMachine:SetAttribute('statemap-stance-' .. i, i * 1000) -- healer/shadow form
	end
end

--[[ Page States ]]--

local function LoadPageStates(stateMachine)
	for page = 1, MAX_PAGES do
		local stateMap = ''
		for state = 0, maxState do
			local sIndex = state*1000
			stateMap = AddState(stateMap, sIndex .. '-' .. sIndex + MAX_PAGES-1, sIndex + page-1)
		end
		stateMachine:SetAttribute('statemap-actionbar-' .. page, stateMap)
	end
end

local function LoadStateMaps()
	-- load class mapping
	local stances = BONGOS_STANCES[PLAYER_CLASS]
	if stances then
		for i in pairs(stances) do
			classMap = AddState(classMap, i * 1000, 's' .. i)
			maxState = maxState + 1
		end
	end

	--load page mapping
	pageMap = ''	
	for state = 0, maxState do
		for page = 1, MAX_PAGES do
			pageMap = AddState(pageMap, (state * 1000) + (page - 1), 'p' .. page - 1)
		end
	end	
end

--[[ Constructor ]]--

function BState_Update(stateMachine)
	local currentState = 0
	if class == 'DRUID' and IsStealthed() then
		if GetShapeshiftForm() == 3 then
			currentState = '7000' + GetActionBarPage() - 1
		end
	else
		currentState =  1000 * GetShapeshiftForm() + GetActionBarPage() - 1
	end
	stateMachine:SetAttribute('state', currentState)
end

function BState_Create(parent)
	if not statesLoaded then
		LoadStateMaps()
		statesLoaded = true
	end
		
	local stateMachine = CreateFrame('Frame', nil, parent, 'SecureStateDriverTemplate')
	if PLAYER_CLASS == 'DRUID' then
		LoadDruidStates(stateMachine)
	elseif PLAYER_CLASS == 'ROGUE' then
		LoadRogueStates(stateMachine)	
	elseif PLAYER_CLASS == 'WARRIOR' then
		LoadWarriorStates(stateMachine)
	elseif PLAYER_CLASS == 'PRIEST' then
		LoadPriestStates(stateMachine)
	end
	LoadPageStates(stateMachine)

--	stateMachine:SetAttribute('unit2', 'player')
	stateMachine:SetAttribute('statebutton', classMap .. pageMap)
--	stateMachine:SetAttribute('statebutton2', classMap .. pageMap)
	
	BState_Update(stateMachine)

	return stateMachine
end