--[[
	BActionMain
		The event handler and loader for ActionBars
--]]

bg_showGrid = nil --determines if empty buttons are being shown or not.

local eventsLoaded = false

--[[ Event Handler ]]--

local function OnEvent()
	if event == 'ACTIONBAR_SLOT_CHANGED' then
		if arg1 == 0 then
			BActionButton.ForAll(BActionButton.Update)
		else
			BActionButton.ForID(arg1, BActionButton.Update)
		end
	elseif event == 'PLAYER_ENTERING_WORLD' then
		BActionButton.ForAll(BActionButton.Update)
	elseif event == 'PLAYER_TARGET_CHANGED' then
		BActionButton.ForAllShown(BActionButton.UpdateUsable)
	elseif event == 'ACTIONBAR_SHOWGRID' then
		bg_showGrid = true
		BActionButton.ForAll(BActionButton.ShowGrid)
	elseif event == 'ACTIONBAR_HIDEGRID' then
		bg_showGrid = nil
		BActionButton.ForAllShown(BActionButton.HideGrid)
	elseif event == 'UPDATE_BINDINGS' then
		BActionButton.ForAllShown(BActionButton.UpdateHotkey)
	elseif event == 'PLAYER_AURAS_CHANGED' then
		BActionButton.ForAllShown(BActionButton.UpdateUsable)
	elseif event == 'UNIT_INVENTORY_CHANGED' then
		if arg1 == 'player' then
			BActionButton.ForAllShown(BActionButton.Update)
		end
	elseif event == 'ACTIONBAR_UPDATE_USABLE' or event == 'UPDATE_INVENTORY_ALERTS' or event == 'ACTIONBAR_UPDATE_COOLDOWN' then
		BActionButton.ForAllShown(BActionButton.UpdateCooldown)
		BActionButton.ForAllShown(BActionButton.UpdateUsable)
	elseif event == 'ACTIONBAR_UPDATE_STATE' or event == 'CRAFT_SHOW' or event == 'CRAFT_CLOSE' or event == 'TRADE_SKILL_SHOW' or event == 'TRADE_SKILL_CLOSE' then
		BActionButton.ForAllShown(BActionButton.UpdateState)
	elseif event == 'PLAYER_ENTER_COMBAT' or event == 'PLAYER_LEAVE_COMBAT' or event == 'START_AUTOREPEAT_SPELL' or event == 'STOP_AUTOREPEAT_SPELL' then
		BActionButton.ForAllShown(BActionButton.UpdateFlash)
	end
end

local function RegisterEvents()
	local frame = CreateFrame("Frame")

	frame:SetScript('OnEvent', OnEvent)

	frame:RegisterEvent("PLAYER_ENTERING_WORLD")
	frame:RegisterEvent("ACTIONBAR_SHOWGRID")
	frame:RegisterEvent("ACTIONBAR_HIDEGRID")	
	frame:RegisterEvent("ACTIONBAR_SLOT_CHANGED")
	frame:RegisterEvent("UPDATE_BINDINGS")

	frame:RegisterEvent('ACTIONBAR_UPDATE_STATE')
	frame:RegisterEvent('ACTIONBAR_UPDATE_USABLE')
	frame:RegisterEvent('ACTIONBAR_UPDATE_COOLDOWN')
	frame:RegisterEvent('UPDATE_INVENTORY_ALERTS')
	frame:RegisterEvent('PLAYER_AURAS_CHANGED')
	frame:RegisterEvent('UNIT_INVENTORY_CHANGED')
	frame:RegisterEvent('CRAFT_SHOW')
	frame:RegisterEvent('CRAFT_CLOSE')
	frame:RegisterEvent('TRADE_SKILL_SHOW')
	frame:RegisterEvent('TRADE_SKILL_CLOSE')
	frame:RegisterEvent('PLAYER_ENTER_COMBAT')
	frame:RegisterEvent('PLAYER_LEAVE_COMBAT')
	frame:RegisterEvent('START_AUTOREPEAT_SPELL')
	frame:RegisterEvent('STOP_AUTOREPEAT_SPELL')
end

--[[ Startup ]]--

BProfile.AddStartup(function()
	if not eventsLoaded then 
		RegisterEvents()
		eventsLoaded = true 
	end
	
	for i = 1, BActionBar.GetNumber() do 
		BActionBar.Create(i) 
	end
end)