--[[
	slash
		Slash command handler for Bongos
		All commands start with /bg or /bongos
		
	Valid strings for <bar>:
		<number> - an action bar
		bags - bag bar
		menu - menu bar
		pet - pet bar
		class - class bar
		stats - stat bar
		all - all bars
--]]

local function GetRestofMessage(args)
	if args[2] then
		local name = args[2]
		for i = 3, #args do
			name = name .. " " .. args[i]
		end
		return name
	end
end

--Display commands
local function ShowCommands()
	BMsg(BONGOS_COMMANDS)
	BMsg(BONGOS_SHOW_OPTIONS)
	BMsg(BONGOS_SHOW_HELP)
	
	--bar commands
	BMsg(BONGOS_LOCK)
	BMsg(BONGOS_UNLOCK)
	BMsg(BONGOS_SHOW)
	BMsg(BONGOS_HIDE)
	BMsg(BONGOS_TOGGLE)
	BMsg(BONGOS_SET_SCALE)
	BMsg(BONGOS_SET_OPACITY)
	BMsg(BONGOS_SET_STICKY)

	--Profile commands
	BMsg(BONGOS_LOAD_PROFILE)
	BMsg(BONGOS_SAVE_PROFILE)
	BMsg(BONGOS_DELETE_PROFILE)
	BMsg(BONGOS_RESET)
	BMsg(BONGOS_SET_DEFAULT_PROFILE)
	BMsg(BONGOS_CLEAR_DEFAULT_PROFILE)
end

--Slash handler
SlashCmdList["BongosCOMMAND"] = function(msg)
	if msg == "" then
		if BongosOptions then
			BongosOptions:Show()
		else
			local enabled = select(4, GetAddOnInfo("Bongos_Options"))
			if enabled then
				LoadAddOn("Bongos_Options")
			else
				ShowCommands()
			end
		end		
	else
		local args = {strsplit(' ', msg)}
		local cmd = args[1]:lower()
		
		if cmd == "help" or cmd == "?" then
			ShowCommands()
		elseif cmd == "lock" then
			Bongos_SetLock(true)
		elseif cmd == "unlock" then
			Bongos_SetLock(nil)
		elseif cmd == "stickybars" then
			Bongos_SetStickyBars(args[2]:lower() == "on")
		elseif cmd == "show" then
			for i = 2, #args do
				Bongos_ForBar(args[i]:lower(), BBar.Show, 1)
			end
		elseif cmd == "hide" then
			for i = 2, #args do
				Bongos_ForBar(args[i]:lower(), BBar.Hide, 1)
			end
		elseif cmd == "toggle" then
			for i = 2, #args do
				Bongos_ForBar(args[i]:lower(), BBar.Toggle, 1)
			end
		elseif cmd == "scale" then
			local size = #args
			local scale = tonumber(args[size])
			for i = 2, size - 1 do
				Bongos_ForBar(args[i]:lower(), BBar.SetScale, scale, 1)
			end
		elseif cmd == "setalpha" then
			local size = #args
			local alpha = tonumber(args[size])
			for i = 2, size - 1 do
				Bongos_ForBar(args[i]:lower(), BBar.SetAlpha, alpha, 1)
			end
		elseif cmd == "reset" then
			BProfile.Reset()
		elseif cmd == "load" then
			BProfile.Load(GetRestofMessage(args))
		elseif cmd == "save" then
			BProfile.Save(GetRestofMessage(args))
		elseif cmd == "delete" then
			BProfile.Delete(GetRestofMessage(args))
		elseif cmd == "setdefault" then
			BProfile.SetDefault(GetRestofMessage(args))
		elseif cmd == "cleardefault" then
			BProfile.SetDefault(nil)
		else
			BMsg(format(BONGOS_UNKNOWN_COMMAND, cmd or 'nil'))
		end
	end
end
SLASH_BongosCOMMAND1 = "/bongos"
SLASH_BongosCOMMAND2 = "/bob"