--[[
	CQ.lua
		A library of functions that will perform an action right when the user is no longer in combat
--]]

local actions = {}
local showList = {}
local hideList = {}
local attachList = {}

CQ = {
	Do = function(action)
		if InCombatLockdown() then
			table.insert(actions, action)
		else
			action()
		end
	end,
	
	Show = function(frame)
		if InCombatLockdown() then
			showList[frame] = true
			hideList[frame] = nil
		else
			frame:Show()
		end
	end,
	
	Hide = function(frame)
		if InCombatLockdown() then
			hideList[frame] = true
			showList[frame] = nil
		else
			frame:Hide()
		end
	end,
	
	SetParent = function(frame, parent)
		if InCombatLockdown() then
			attachList[frame] = parent
		else
			frame:SetParent(parent)
		end
	end,
}

local function WatchEvents()
	local watcher = CreateFrame('Frame')

	watcher:SetScript('OnEvent', function()
		for i, action in pairs(actions) do
			action()
			actions[i] = nil
		end

		for frame, parent in pairs(attachList) do
			frame:SetParent(parent)
			attachList[frame] = nil
		end

		for frame in pairs(showList) do
			frame:Show()
			showList[frame] = nil
		end

		for frame in pairs(hideList) do
			frame:Hide()
			hideList[frame] = nil
		end
	end)
	watcher:RegisterEvent('PLAYER_REGEN_ENABLED')
end
WatchEvents()