--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0394 (eagle)
	Revision: $Id: GatherInterface.lua 386 2007-01-04 06:57:35Z esamynn $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Interface functions
]]

-- dropdown menus
function Gatherer.Interface.WMDropDownGType_Initialize()
	local index
	local info = {}
	local iconGtype = Gatherer.Var.MainMapItem.gatherType

	if ( Gatherer.Var.MainMapItem.newType ) then
		iconGtype = Gatherer.Var.MainMapItem.newType
	end

	for index, value in Gather_DB_TypeIndex do
		if ( type(value) == "number" and value ~= 3 )
		then
			info.text = index
			info.value = value
			if ( value == iconGtype ) then
				info.checked = 1
			else
				info.checked = nil
			end
			info.func = Gatherer.Interface.WMDropDownGType_OnClick
			UIDropDownMenu_AddButton(info)
		end
	end

	if ( type(Gatherer.Var.MainMapItem.gatherType) == "number" )
	then
		UIDropDownMenu_SetText(Gather_DB_TypeIndex[Gatherer.Var.MainMapItem.gatherType], Gatherer.Interface.WMDropDownGType)
	else
		UIDropDownMenu_SetText(Gatherer.Var.MainMapItem.gatherType, Gatherer.Interface.WMDropDownGType)
	end
end

function Gatherer.Interface.WMDropDownGType_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer.Interface.WMDropDownGType, this:GetID())
	Gatherer.Var.MainMapItem.newType = Gather_DB_TypeIndex[UIDropDownMenu_GetText(Gatherer.Interface.WMDropDownGType)]

	UIDropDownMenu_ClearAll(Gatherer.Interface.WMDropDownIcons)
	UIDropDownMenu_Initialize(Gatherer.Interface.WMDropDownIcons, Gatherer.Interface.WMDropDownIcons_Initialize)
end

function Gatherer.Interface.WMDropDownIcons_Initialize()
	local index
	local info = {}
	local iconGtype = "Default"

	if ( Gatherer.Var.MainMapItem.newType ) then
		iconGtype = Gatherer.Var.MainMapItem.newType
	else
		iconGtype = Gatherer.Var.MainMapItem.gatherType
	end

	for index, value in GatherIcons_TokenConversion[iconGtype] do
		info.text = index
		info.value = value
		if ( value == Gatherer.Var.MainMapItem.gatherIcon and not Gatherer.Var.MainMapItem.newType) then
			info.checked = 1
		else
			info.checked = nil
		end
		info.func = Gatherer.Interface.WMDropDownIcons_OnClick
		UIDropDownMenu_AddButton(info)
	end

	UIDropDownMenu_SetText(Gatherer_GetDB_IconIndex(Gatherer.Var.MainMapItem.gatherIcon, iconGtype), Gatherer.Interface.WMDropDownIcons)
end

function Gatherer.Interface.WMDropDownIcons_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer.Interface.WMDropDownIcons, this:GetID())
	Gatherer.Var.MainMapItem.newIcon = Gatherer_GetDB_IconIndex(UIDropDownMenu_GetText(Gatherer.Interface.WMDropDownIcons), Gatherer.Var.MainMapItem.gatherType)
end

function Gatherer.Interface.WMDropDownScope_Initialize()
	local index
	local scope_list = { "Node", "Zone", "Continent", "World" }
	local info = {}

	Gatherer.Var.MainMapItem.scope = "Node"
	for index in scope_list do
		info.text = scope_list[index]
		info.value = index
		if ( scope_list[index] == "Node" ) then
			info.checked = 1
		else
			info.checked = nil
		end
		info.func = Gatherer.Interface.WMDropDownScope_OnClick
		UIDropDownMenu_AddButton(info)
	end
	UIDropDownMenu_SetSelectedID(Gatherer.Interface.WMDropDownScope, 1)
end

function Gatherer.Interface.WMDropDownScope_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer.Interface.WMDropDownScope, this:GetID())
	Gatherer.Var.MainMapItem.scope = UIDropDownMenu_GetText(Gatherer.Interface.WMDropDownScope)
end

function Gatherer.Interface.ShowTooltip()
	GameTooltip:SetOwner(Gatherer_Popup, "ANCHOR_LEFT")
	GameTooltip:SetText(this.tooltipText)
	GameTooltip:Show()
end

-- Counter for fixed item count
fixedItemCount = 0
gathererFixItems = 0

-- Number of buttons for the menu defined in the XML file.
Gatherer.Var.NumButtons = 7

-- Constants used in determining menu width/height.
Gatherer.Var.BorderWidth = 15
Gatherer.Var.ButtonHeight = 12
Gatherer.Var.Subframes = {
	"Gatherer_FiltersOptionsBorderFrame",
	"Gatherer_GathererOptionsBorderFrame",
	"Gatherer_DisplayOptionsBorderFrame",
}

-- List of toggles to display.
Gatherer.Var.QuickMenu = {
	{name=GATHERER_TEXT_TOGGLE_MINIMAP, option="useMinimap"},
	{name=GATHERER_TEXT_TOGGLE_MAINMAP, option="useMainmap"},
	{name=GATHERER_TEXT_TOGGLE_HERBS, option="herbs"},
	{name=GATHERER_TEXT_TOGGLE_MINERALS, option="mining"},
	{name=GATHERER_TEXT_TOGGLE_TREASURE, option="treasure"},
	{name=GATHERER_TEXT_TOGGLE_REPORT, option="report" },
	{name=GATHERER_TEXT_TOGGLE_SEARCH, option="search" },
}


-- ******************************************************************
function Gatherer.Interface.OnLoad()
	-- Create the slash commands to show/hide the menu.
	SlashCmdList["GATHERER_SHOWMENU"] = Gatherer.Interface.ShowMenu
	SLASH_GATHERER_SHOWMENU1 = "/gatherer_showmenu"
	SlashCmdList["GATHERER_HIDEMENU"] = Gatherer.Interface.HideMenu
	SLASH_GATHERER_HIDEMENU1 = "/gatherer_hidemenu"

	-- Create the slash commands to show/hide the options window.
	SlashCmdList["GATHERER_SHOWOPTIONS"] = Gatherer.Interface.ShowOptions
	SLASH_GATHERER_SHOWOPTIONS1 = "/gatherer_showoptions"
	SlashCmdList["GATHERER_HIDEOPTIONS"] = Gatherer.Interface.HideOptions
	SLASH_GATHERER_HIDEOPTIONS1 = "/gatherer_hideoptions"
end

function Gatherer.Interface.OnEvent()
	if ( event == "VARIABLES_LOADED" ) then
		local playerName = UnitName("player")
		if ((playerName) and (playerName ~= UNKNOWNOBJECT)) then Gather_Player = playerName; end
		Gatherer.Interface.InitializeOptions()
		Gatherer.Interface.InitializeMenu()
		return
	end
	if ( event == "UNIT_NAME_UPDATE" ) then
		if ((arg1) and (arg1 == "player")) then
			local playerName = UnitName("player")
			if ((playerName) and (playerName ~= UNKNOWNOBJECT)) then
				Gather_Player = playerName
				Gatherer.Interface.InitializeMenu()
			end
		end
	end
end

-- ***********************************************************
-- Tab selection code
function Gatherer.Interface.ToggleDialog(tab)
	local subFrame = getglobal(tab)
	if ( subFrame ) then
		PanelTemplates_SetTab(Gatherer_DialogFrame, subFrame:GetID())
		if ( Gatherer_DialogFrame:IsVisible() ) then
				PlaySound("igCharacterInfoTab")
				Gatherer.Interface.DialogFrame_ShowSubFrame(tab)
		else
			Gatherer_DialogFrame:Show()
			Gatherer.Interface.DialogFrame_ShowSubFrame(tab)
		end
	end
end

function Gatherer.Interface.DialogFrame_ShowSubFrame(frameName)
	for index, value in GATHERERUI_SUBFRAMES do
		if ( value == frameName ) then
			getglobal(value):Show()
		else
			getglobal(value):Hide()
		end
	end
end
function GathererUIFrameTab_OnClick()
	if ( this:GetName() == "Gatherer_DialogFrameTab1" ) then
		Gatherer.Interface.ToggleDialog("Gatherer_FiltersOptionsBorderFrame")
	elseif ( this:GetName() == "Gatherer_DialogFrameTab2" ) then
		Gatherer.Interface.ToggleDialog("Gatherer_GathererOptionsBorderFrame")
	elseif ( this:GetName() == "Gatherer_DialogFrameTab3" ) then
		Gatherer.Interface.ToggleDialog("Gatherer_DisplayOptionsBorderFrame")
	end
	PlaySound("igCharacterInfoTab")
end

-- ******************************************************************
function Gatherer.Interface.ShowMenu(x, y, anchor)
	if (Gatherer_Popup:IsVisible()) then
		Gatherer.Interface.Hide()
		return
	end

	if (not x or not y) then
		-- Get the cursor position.  Point is relative to the bottom left corner of the screen.
		x, y = GetCursorPosition()
	end

	if (anchor == nil) then
		anchor = "center"
	end

	-- Adjust for the UI scale.
	x = x / UIParent:GetEffectiveScale()
	y = y / UIParent:GetEffectiveScale()

	-- Adjust for the height/width/anchor of the menu.
	if (anchor == "topright") then
		x = x - Gatherer_Popup:GetWidth()
		y = y - Gatherer_Popup:GetHeight()
	elseif (anchor == "topleft") then
		y = y - Gatherer_Popup:GetHeight()
	elseif (anchor == "bottomright") then
		x = x - Gatherer_Popup:GetWidth()
	elseif (anchor == "bottomleft") then
		-- do nothing.
	else
		-- anchor is either "center" or not a valid value.
		x = x - Gatherer_Popup:GetWidth() / 2
		y = y - Gatherer_Popup:GetHeight() / 2
	end

	-- Clear the current anchor point, and set it to be centered under the mouse.
	Gatherer_Popup:ClearAllPoints()
	Gatherer_Popup:SetPoint("BOTTOMLEFT", "UIParent", "BOTTOMLEFT", x, y)
	Gatherer.Interface.Show()
end

-- ******************************************************************
function Gatherer.Interface.HideMenu()
	Gatherer.Interface.Hide()
end

-- ******************************************************************
function Gatherer.Interface.InitializeOptions()
	local SETTINGS = Gatherer.Settings

	if ( SETTINGS.showWorldMapFilters == 1 ) then
		GathererWD_DropDownFilters:Show()
	else
		GathererWD_DropDownFilters:Hide()
	end

	if ( SETTINGS.disableWMFreezeWorkaround == 1 ) then
		Gatherer_WorldMapDisplay:Show()
	else
		Gatherer_WorldMapDisplay:Hide()
	end

	if ( SETTINGS.useMainmap)
	then
		Gatherer_WorldMapDisplay:SetText("Hide Items")
		GathererMapOverlayFrame:Show()
	else
		Gatherer_WorldMapDisplay:SetText("Show Items")
		GathererMapOverlayFrame:Hide()
	end

	GathererHelp.currentPage = GathererHelp.currentPage or tonumber("1")

	-- UI related
	Gatherer_CheckShowOnMouse:SetChecked(SETTINGS.ShowOnMouse)
	Gatherer_CheckHideOnMouse:SetChecked(SETTINGS.HideOnMouse)
	Gatherer_CheckShowOnClick:SetChecked(SETTINGS.ShowOnClick)
	Gatherer_CheckHideOnClick:SetChecked(SETTINGS.HideOnClick)
	Gatherer_CheckHideIcon:SetChecked(SETTINGS.HideIcon)
	Gatherer_CheckHideOnButton:SetChecked(SETTINGS.HideOnButton)
	Gatherer_IconFrame:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 52 - (SETTINGS.Radius * cos(SETTINGS.Position)), (SETTINGS.Radius * sin(SETTINGS.Position)) - 52)

	-- Gatherer related
	Gatherer_CheckNoMinIcon:SetChecked(SETTINGS.NoIconOnMinDist)
	Gatherer_CheckRareOre:SetChecked(SETTINGS.rareOre)
	Gatherer_CheckMapMinder:SetChecked(SETTINGS.mapMinder)
	Gatherer_CheckHideMiniNotes:SetChecked(SETTINGS.HideMiniNotes)
	Gatherer_CheckToggleWorldNotes:SetChecked(SETTINGS.ToggleWorldNotes)
	Gatherer_CheckToggleWorldFilters:SetChecked(SETTINGS.showWorldMapFilters)
	Gatherer_CheckHerbRecord:SetChecked(SETTINGS.filterRecording[1])
	Gatherer_CheckOreRecord:SetChecked(SETTINGS.filterRecording[2])
	Gatherer_CheckTreasureRecord:SetChecked(SETTINGS.filterRecording[0])
	Gatherer_CheckDisableWMFix:SetChecked(SETTINGS.disableWMFreezeWorkaround)

	Gatherer.Interface.InitializeMenu()
end

-- ******************************************************************
function Gatherer.Interface.InitializeMenu()

	Gatherer_IconFrame.haveAbilities = true

	if ( Gatherer.Settings and Gatherer.Settings.HideIcon and Gatherer.Settings.HideIcon == 1 ) then
		Gatherer_IconFrame:Hide()
	else
		Gatherer_IconFrame:Show()
	end


	-- Set the text for the buttons while keeping track of how many
	-- buttons we actually need.
	local count = 0
	for quickoptionpos, quickoptiondata in Gatherer.Interface.QuickMenu do
		quickoptions = quickoptiondata.name
		gathermap_id = quickoptiondata.option
		count = count + 1
		local button = getglobal("Gatherer_PopupButton"..count)
		Gatherer_Value="none"
		if ( gathermap_id =="useMinimap" ) then
			Gatherer_Value = "off"
			if (Gatherer.Settings.useMinimap) then Gatherer_Value = "on"; end
			button.SpellID = "toggle"
		elseif (  gathermap_id == "useMainmap" ) then
			Gatherer_Value = "off"
			if (Gatherer.Settings.useMainmap) then Gatherer_Value = "on"; end
			button.SpellID = "mainmap toggle"
		elseif ( gathermap_id == "report" ) then
			button.SpellID = "report"
			Gatherer_Value = ""
		elseif ( gathermap_id == "search" ) then
			button.SpellID = "search"
			Gatherer_Value = ""
		else
			Gatherer_Value = Gatherer.Command.GetFilterVal(gathermap_id)
			button.SpellID = gathermap_id.." toggle"
		end

		if ( Gatherer_Value ~= "" ) then
			button:SetText(quickoptions.."["..Gatherer_Value.."]")
		else
			button:SetText(quickoptions)
		end
		button:Show()
	end

	-- Set the width for the menu.
	local width = Gatherer_TitleButton:GetWidth()
	for i = 1, count do
		width = math.max(width, getglobal("Gatherer_PopupButton"..i):GetTextWidth())
	end
	Gatherer_Popup:SetWidth(width + 2 * Gatherer.Var.BorderWidth)

	-- By default, the width of the button is set to the width of the text
	-- on the button.  Set the width of each button to the width of the
	-- menu so that you can still click on it without being directly
	-- over the text.
	for i = 1, count do
		getglobal("Gatherer_PopupButton"..i):SetWidth(width)
	end

	-- Hide the buttons we don't need.
	for i = count + 1, Gatherer.Var.NumButtons do
		getglobal("Gatherer_PopupButton"..i):Hide()
	end

	-- Set the height for the menu.
	Gatherer_Popup:SetHeight(Gatherer.Var.ButtonHeight + ((count + 1) * Gatherer.Var.ButtonHeight) + (3 * Gatherer.Var.ButtonHeight))
end

-- ******************************************************************
function Gatherer.Interface.ButtonClick()
	Gatherer.Command.Process(this.SpellID)
	Gatherer.Interface.InitializeMenu()
end

-- ******************************************************************
function Gatherer.Interface.Show()
	-- Check to see if the aspect menu is shown.  If so, hide it before
	-- showing the tracking menu.
	if (Gatherer_Popup and Gatherer_Popup:IsVisible()) then
		Gatherer.Interface.Hide()
	end

	Gatherer_Popup:Show()
end

-- ******************************************************************
function Gatherer.Interface.Hide()
	Gatherer_Popup:Hide()
end

-- ******************************************************************
function Gatherer.Interface.ShowOptions()
	Gatherer_DialogFrame:Show()
--	Gatherer.Interface.ToggleDialog(GATHERERUI_SUBFRAMES[PanelTemplates_GetSelectedTab(Gatherer_DialogFrame)])
end

-- ******************************************************************
function Gatherer.Interface.HideOptions()
	Gatherer_DialogFrame:Hide()
end

-- ******************************************************************
function Gatherer.Interface.OnUpdate(dummy)
	-- Check to see if the mouse is still over the menu or the icon.
	if (Gatherer.Settings.HideOnMouse == 1 and Gatherer_Popup:IsVisible()) then
		if (not MouseIsOver(Gatherer_Popup) and not MouseIsOver(Gatherer_IconFrame)) then
			-- If not, hide the menu.
			Gatherer.Interface.Hide()
		end
	end
end

-- ******************************************************************
function Gatherer.Interface.IconFrameOnEnter()
	-- Set the anchor point of the menu so it shows up next to the icon.
	Gatherer_Popup:ClearAllPoints()
	Gatherer_Popup:SetPoint("TOPRIGHT", "Gatherer_IconFrame", "TOPLEFT")

	-- Show the menu.
	if (Gatherer.Settings.ShowOnMouse == 1) then
		Gatherer.Interface.Show()
	end
end

-- ******************************************************************
function Gatherer.Interface.IconFrameOnClick()
	if (Gatherer_Popup:IsVisible()) then
		if (Gatherer.Settings.HideOnClick == 1) then
			Gatherer.Interface.Hide()
		end
	else
		if (Gatherer.Settings.ShowOnClick == 1) then
			Gatherer.Interface.Show()
		end
	end
end

-- ******************************************************************
function GathererUIDropDownTheme_Initialize()
	for value in Gather_IconSet do
		local info = {}
		info.text = value
		info.checked = nil
		info.func = GathererUIDropDownTheme_OnClick
		UIDropDownMenu_AddButton(info)
		if (Gatherer.Settings.iconSet == info.text) then
			UIDropDownMenu_SetText(info.text, Gatherer_DropDownTheme)
		end
	end
end

function GathererUIDropDownHerbs_Initialize()
	GathererUIDropDown_Initialize("Herb", "Herbs")
end

function GathererUIDropDownOre_Initialize()
	GathererUIDropDown_Initialize("Ore")
end

function GathererUIDropDownTreasure_Initialize()
	GathererUIDropDown_Initialize("Treasure")
end

local function menuSortFunction(a, b)
	local aSkillLevel = Gather_SkillLevel[a] or 0
	local bSkillLevel = Gather_SkillLevel[b] or 0
	return string.format("%03d%s", aSkillLevel, a) < string.format("%03d%s", bSkillLevel, b)
end

function GathererUIDropDown_Initialize(gatherType, dropDownText)
	if not ( dropDownText ) then
		dropDownText = gatherType
	end

	if ( Gatherer_RareMatches[UIDROPDOWNMENU_MENU_VALUE] ) then
		GathererUIDropDownSub_Initialize(UIDROPDOWNMENU_MENU_VALUE, gatherType, dropDownText)
		return
	end

	local varMenuVal1, varMenuVal2
	local value = Gatherer.Command.GetFilterVal(gatherType)

	if ( value == "on" ) then
		varMenuVal1 = "auto"
		varMenuVal2 = "off"
	elseif ( value == "off" ) then
		varMenuVal1 = "auto"
		varMenuVal2 = "on"
	else
		varMenuVal1 = "on"
		varMenuVal2 = "off"
	end
	UIDropDownMenu_SetText(Gatherer.Util.GetMenuName(value), getglobal("Gatherer_DropDown"..dropDownText))

	local rareItem = {}
	for specificType, rareMatch in Gatherer_RareMatches do
		if (GatherIcons_TokenConversion[gatherType][specificType]) then
			rareItem[rareMatch] = specificType
		end
	end

	local gathererFilters = {}
	for _, specificType in GatherIcons_TokenConversion[gatherType] do
		if not ( rareItem[specificType] ) then
			tinsert(gathererFilters, specificType)
		end
	end

	table.sort(gathererFilters, menuSortFunction)
	local info = {
		notCheckable = 1,
		func = GathererUIDropDownFilter_OnClick,
		arg1 = gatherType,
		arg2 = dropDownText,
		textR = NORMAL_FONT_COLOR.r,
		textG = NORMAL_FONT_COLOR.g,
		textB = NORMAL_FONT_COLOR.b,
	}

	info.value = varMenuVal1
	info.text = Gatherer.Util.GetMenuName(varMenuVal1)
	UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL)

	info.value = varMenuVal2
	info.text = Gatherer.Util.GetMenuName(varMenuVal2)
	UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL)

	local info = {
		keepShownOnClick = 1,
		func = GathererUIDropDownFilter_OnClick,
		arg1 = gatherType,
		arg2 = dropDownText,
	}
	for index, value in ipairs(gathererFilters) do
		info.text = Gatherer.Util.GetMenuName(Gatherer_GetGatherCanonicalName(value))
		info.value = value
		if (Gatherer_RareMatches[value]) then
			info.hasArrow = 1
			info.func = nil
		else
			info.hasArrow = nil
			info.func = GathererUIDropDownFilter_OnClick
		end
		Gatherer_Debug(gatherType, value)
		if ( Gatherer.Settings.interested[gatherType][value] ) then
			info.checked = 1
		else
			info.checked = nil
		end

		UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL)
	end
end

function GathererUIDropDownSub_Initialize(nonRareType, gatherType, dropDownText)
	if (not dropDownText) then
		if (gatherType == "Herb") then
			dropDownText = "Herbs"
		elseif (gatherType == "Ore") then
			dropDownText = "Ore"
		elseif (gatherType == "Treasure") then
			dropDownText = "Treasure"
		end
	end

	local info = {
		keepShownOnClick = 1,
		func = GathererUIDropDownFilter_OnClick,
		arg1 = gatherType,
		arg2 = dropDownText,
	}
	for i = 1, 2 do
		local value = (i == 1) and nonRareType or Gatherer_RareMatches[nonRareType]
		info.text = Gatherer.Util.GetMenuName(Gatherer_GetGatherCanonicalName(value))
		info.value = value
		info.checked = nil
		info.func = getglobal("GathererUIDropDownFilter"..dropDownText.."_OnClick")
		info.keepShownOnClick = 1

		if ( Gatherer.Settings.interested[gatherType][value] ) then
			info.checked = 1
		end
		info.textR = 1
		info.textG = 1
		info.textB = 1

		UIDropDownMenu_AddButton(info, UIDROPDOWNMENU_MENU_LEVEL)
	end
end

-- World Map functions
-- World Map filters dropdown Load
function Gatherer_WorldMapFilter_Load()
	UIDropDownMenu_SetText(GATHERER_FILTERDM_TEXT, GathererWD_DropDownFilters)

	if ( UIDROPDOWNMENU_MENU_VALUE == "Herb" ) then
		GathererUIDropDownHerbs_Initialize()
		return
	elseif ( UIDROPDOWNMENU_MENU_VALUE == "Ore" ) then
		GathererUIDropDownOre_Initialize()
		return
	elseif ( UIDROPDOWNMENU_MENU_VALUE == "Treasure" ) then
		GathererUIDropDownTreasure_Initialize()
		return
	elseif( Gatherer_RareMatches[UIDROPDOWNMENU_MENU_VALUE] ) then
		for gatherType in GatherIcons_TokenConversion do
			if (GatherIcons_TokenConversion[gatherType][UIDROPDOWNMENU_MENU_VALUE]) then
				GathererUIDropDownSub_Initialize(UIDROPDOWNMENU_MENU_VALUE, gatherType)
				break
			end
		end

		return
	end


	local info = {}
	info.text = GATHERER_TEXT_TOGGLE_HERBS.."["..Gatherer.Command.GetFilterVal("herbs").."]"
	info.value = "Herb"
	info.hasArrow = 1
	info.func = nil
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)

	local info = {}
	info.text = GATHERER_TEXT_TOGGLE_MINERALS.."["..Gatherer.Command.GetFilterVal("mining").."]"
	info.value = "Ore"
	info.hasArrow = 1
	info.func = nil
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)

	local info = {}
	info.text = GATHERER_TEXT_TOGGLE_TREASURE.."["..Gatherer.Command.GetFilterVal("treasure").."]"
	info.value = "Treasure"
	info.hasArrow = 1
	info.func = nil
	info.notCheckable = 1
	UIDropDownMenu_AddButton(info)
end

-- ******************************************************************
function GathererUIDropDownTheme_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer_DropDownTheme, this:GetID())
	local cmd = UIDropDownMenu_GetText(Gatherer_DropDownTheme)
	Gatherer.Command.Process("theme "..cmd)
end

function GathererUIDropDownFilter_OnClick( gatherType, dropDownText )
	if ( UIDROPDOWNMENU_MENU_LEVEL == 1 and this:GetID() < 3 ) then
		UIDropDownMenu_SetText(Gatherer.Util.GetMenuName(this.value), getglobal("Gatherer_DropDown"..dropDownText))
		Gatherer.Command.SetFilter(gatherType, this.value)
		Gatherer.Interface.InitializeMenu()
	else
		Gatherer.Settings.interested[gatherType][this.value] = not this.checked
	end
	Gatherer.MapNotes.MapDraw()
end

function Gatherer.Interface.OnEnterPressed_HerbSkillEditBox()
	if ( Gatherer_HerbSkillEditBox:GetNumber() > 300 ) then
		Gatherer_HerbSkillEditBox:SetNumber(300)
	end
	if ( Gatherer_HerbSkillEditBox:GetNumber() < 0 ) then
		Gatherer_HerbSkillEditBox:SetNumber(0)
	end

	Gatherer.Settings.minSetHerbSkill = Gatherer_HerbSkillEditBox:GetNumber()
end

function Gatherer.Interface.OnEnterPressed_OreSkillEditBox()
	if ( Gatherer_OreSkillEditBox:GetNumber() > 300 ) then
		Gatherer_OreSkillEditBox:SetNumber(300)
	end
	if ( Gatherer_OreSkillEditBox:GetNumber() < 0 ) then
		Gatherer_OreSkillEditBox:SetNumber(0)
	end
	Gatherer.Settings.minSetOreSkill = Gatherer_OreSkillEditBox:GetNumber()
end

function Gatherer.Interface.OnEnterPressed_IconSizeEditBox()
	if ( Gatherer_WorldMapIconSize:GetNumber() < 8 or Gatherer_WorldMapIconSize:GetNumber() > 16 ) then
		if ( Gatherer.Settings.IconSize ) then
			Gatherer_WorldMapIconSize:SetNumber(Gatherer.Settings.IconSize)
		else
			Gatherer_WorldMapIconSize:SetNumber(12)
		end
	end
	Gatherer.Settings.IconSize = Gatherer_WorldMapIconSize:GetNumber()
end

function Gatherer.Interface.OnEnterPressed_IconAlphaEditBox()
	if ( Gatherer_WorldMapIconAlpha:GetNumber() < 20 or Gatherer_WorldMapIconAlpha:GetNumber() > 100 ) then
		if ( Gatherer.Settings.IconAlpha ) then
			Gatherer_WorldMapIconAlpha:SetNumber(Gatherer.Settings.IconAlpha/100)
		else
			Gatherer_WorldMapIconAlpha:SetNumber(80)
		end
	end
	Gatherer.Settings.IconAlpha = Gatherer_WorldMapIconAlpha:GetNumber()
end

-- *******************************************************************
-- Zone Rematch Section: Handle with care

function Gatherer.Interface.ZoneRematch(sourceZoneMapping, destZoneMapping)
	local zone_swap=0
	local new_idx_z, gatherType
	NewGatherItems = {}
	fixedItemCount = 0

	Gatherer.Util.ChatPrint(GATHERER_TEXT_APPLY_REMATCH.." "..sourceZoneMapping.." -> "..destZoneMapping)

	for idx_c, rec_continent in GatherItems do
		if (idx_c ~= 0) then NewGatherItems[idx_c]= {}; end
		for idx_z, rec_zone in rec_continent do
			if ( idx_c ~= 0 and idx_z ~= 0) then
				new_idx_z= Gatherer.Interface.ZoneMatchTable[sourceZoneMapping][destZoneMapping][idx_c][idx_z]
				if ( idx_z ~= new_idx_z ) then zone_swap = zone_swap + 1; end

				NewGatherItems[idx_c][new_idx_z] = {}
				for myItems, rec_gatheritem in rec_zone do
					local fixedItemName
					if (gathererFixItems == 1) then
						fixedItemName = Gatherer.Interface.FixItemName(myItems)
					else
						fixedItemName= myItems
					end
					NewGatherItems[idx_c][new_idx_z][fixedItemName] = {}
					for idx_item, myGather in rec_gatheritem do
						local myGatherType, myIcon
						if ( type(myGather.gtype) == "number" ) then
							myGatherType = myGather.gtype
						else
							myGatherType = Gather_DB_TypeIndex[myGather.gtype]
						end
						if ( type(myGather.icon) == "number" ) then
							myIcon= myGather.icon
						else
							myIcon= Gatherer_GetDB_IconIndex(myGather.icon, myGatherType)
						end
						-- convertion of rich thorium veins to new format
						if ( myGatherType == 2 and myIcon == 8 ) then
							myIcon = Gatherer_GetDB_IconIndex(Gatherer_FindOreType(fixedItemName), myGatherType)
						end

						NewGatherItems[idx_c][new_idx_z][fixedItemName][idx_item] = { x=myGather.x, y=myGather.y, gtype=myGatherType, icon=myIcon, count=myGather.count }
						fixedItemCount = fixedItemCount + 1
					end
				end
			end
		end
	end
	Gatherer.Util.ChatPrint("Zone swapping completed ("..zone_swap.." done, "..fixedItemCount.." items accounted for).")
end

-- *******************************************************************
-- Zone Match UI functions
function Gatherer.Interface.ShowRematchDialog()
	if ( Gatherer_ZoneRematchDialog:IsVisible() ) then
		Gatherer_ZoneRematchDialog:Hide()
		Gatherer_DestinationZoneDropDown:Hide()
	else
		Gatherer_ZoneRematchDialog:Show()
	end
end

-- *******************************************************************
-- DropDown Menu functions
function GathererUIDropDownSourceZone_Initialize()
	for index in Gatherer.Interface.ZoneMatchTable do
		local info = {}
		info.text = index
		info.checked = nil
		info.func = GathererUIDropDownFilterSourceZone_OnClick
		UIDropDownMenu_AddButton(info)
		if ( Gatherer.Settings.DataBuild and Gatherer.Settings.DataBuild == info.text ) then
			UIDropDownMenu_SetText(info.text, Gatherer_SourceZoneDropDown)
		end
	end
end

function GathererUIDropDownDestionationZone_Initialize()
	local cmd = UIDropDownMenu_GetText(Gatherer_SourceZoneDropDown)
	if ( cmd and cmd ~= "" ) then
		for index in Gatherer.Interface.ZoneMatchTable[cmd] do
			local info = {}
			info.text = index
			info.checked = nil
			info.func = GathererUIDropDownFilterDestinationZone_OnClick
			UIDropDownMenu_AddButton(info)
		end
	end
end

-- *******************************************************************
-- OnClick in DropDown Menu functions
function GathererUIDropDownFilterSourceZone_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer_SourceZoneDropDown, this:GetID())
	Gatherer_DestinationZoneDropDown:Show()
end

function GathererUIDropDownFilterDestinationZone_OnClick()
	UIDropDownMenu_SetSelectedID(Gatherer_DestinationZoneDropDown, this:GetID())
end

-- *******************************************************************
-- Apply Button
function Gatherer.Interface.ShowRematchDialogApply()
	local source, dest
	source = UIDropDownMenu_GetText(Gatherer_SourceZoneDropDown)
	dest = UIDropDownMenu_GetText(Gatherer_DestinationZoneDropDown)

	if( source and dest ) then
		-- hide Option dialog (since the position of the confirmation dialog can cause miss-click on stuff in there)
		Gatherer.Interface.HideOptions()
		-- add extra confirmation dialog
		StaticPopup_Show("CONFIRM_REMATCH")
	elseif ( not source ) then
		Gatherer.Util.ChatPrint(GATHERER_TEXT_SRCZONE_MISSING)
	else
		Gatherer.Util.ChatPrint(GATHERER_TEXT_DESTZONE_MISSING)
	end
end


StaticPopupDialogs["CONFIRM_REMATCH"] = {
	text = TEXT(GATHERER_TEXT_CONFIRM_REMATCH),
	button1 = TEXT(ACCEPT),
	button2 = TEXT(DECLINE),
	OnAccept = function()
		Gatherer.Interface.ConfirmZoneRematch()
	end,
	timeout = 60,
	showAlert = 1,
}

function Gatherer.Interface.ConfirmZoneRematch()
	local source = UIDropDownMenu_GetText(Gatherer_SourceZoneDropDown)
	local dest = UIDropDownMenu_GetText(Gatherer_DestinationZoneDropDown)

	-- Swap tables and Recompute notes
	Gatherer.Interface.ZoneRematch(source, dest)
	GatherItems = NewGatherItems
	Gatherer.Settings.DataBuild = dest
	Gatherer.Interface.ShowRematchDialog()
end

-- **************************************************************************
-- Help Page functions.
-- Update the help
function Gatherer.Interface.HelpFrame_Update()

	-- Check if an addon is selected
	Gatherer_HelpFrameName:SetText("Gatherer Help")

	local help = GathererHelp

	local currentPage = help.currentPage
	local totalPages = 9

	Gatherer_HelpFrameHelp:SetText(help[currentPage])
	Gatherer_HelpFramePage:SetText("Page "..currentPage.."/"..totalPages)
	Gatherer.Interface.HelpFrame_UpdateButtons()
end

-- Enable/Disable the help buttons
function Gatherer.Interface.HelpFrame_UpdateButtons()

	-- Get the help
	local help = GathererHelp

	-- Check if there is an help
	local currentPage = help.currentPage
	local totalPages = 9

	-- Check if the current help page is the first one
	if (currentPage == 1) then
		Gatherer_HelpFramePrevPageButton:Disable()
	else
		Gatherer_HelpFramePrevPageButton:Enable()
	end

	-- Check if the current help page is the last one
	if (currentPage == totalPages) then
		Gatherer_HelpFrameNextPageButton:Disable()
	else
		Gatherer_HelpFrameNextPageButton:Enable()
	end
end

-- Help previous page OnClick event
function Gatherer.Interface.HelpFramePrevPageButton_OnClick()

	-- Set the current page to previous page
	local help = GathererHelp
	help.currentPage = help.currentPage - 1

	-- Update the help
	Gatherer.Interface.HelpFrame_Update()
end

-- Help next page OnClick event
function Gatherer.Interface.HelpFrameNextPageButton_OnClick()

	-- Set the current page to next page
	local help = GathererHelp
	help.currentPage = help.currentPage + 1

	-- Update the help
	Gatherer.Interface.HelpFrame_Update()
end



-- **************************************************************************
-- Button OnClick Functions

function Gatherer.Interface.ResetGatherTypeInterest( gatherType )
	local settings = Gatherer_PlayerConfig.interested[gatherType]
	for k, v in settings do
		settings[k] = nil
	end
	for _, specificType in GatherIcons_TokenConversion[gatherType] do
		settings[specificType] = true
	end
end

