--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0394 (eagle)
	Revision: $Id: GatherEvent.lua 388 2007-01-04 23:53:05Z norganna $

	License:
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program(see GPL.txt); if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Event handling routines
]]
local _tr = Gatherer.Locale.Tr
local _trC = Gatherer.Locale.TrClient
local _trL = Gatherer.Locale.TrLocale

function Gatherer.Event.OnLoad()
	this:RegisterEvent("WORLD_MAP_UPDATE")
	this:RegisterEvent("CLOSE_WORLD_MAP"); -- never triggered apparently
	this:RegisterEvent("LEARNED_SPELL_IN_TAB"); -- follow current skills
	this:RegisterEvent("SPELLS_CHANGED"); -- follow current skills
	this:RegisterEvent("SKILL_LINES_CHANGED"); -- follow current skills
	this:RegisterEvent("UI_ERROR_MESSAGE"); -- track failed gathering

	-- Events for off world non processing
	this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("PLAYER_LEAVING_WORLD")

	-- Addon Loaded and player login/logout events
	this:RegisterEvent("ADDON_LOADED")
	this:RegisterEvent("PLAYER_LOGIN")
	this:RegisterEvent("PLAYER_LOGOUT")

	-- Communications
	this:RegisterEvent("CHAT_MSG_ADDON")

	SLASH_GATHER1 = "/gather"
	SLASH_GATHER2 = "/gatherer"
	SlashCmdList["GATHER"] = function(msg)
		Gatherer.Command.Process(msg)
	end

	LibSwag.RegisterHook("Gatherer", Gatherer.Event.OnSwag)
end

local lastMessage = ""
function Gatherer.Event.OnEvent( event, ... )
	-- Enable/Disable event processing for zoning
	if (event == "PLAYER_ENTERING_WORLD" ) then
		GatherNoteUpdateFrame:Show()

	elseif (event == "PLAYER_LEAVING_WORLD" ) then
		GatherNoteUpdateFrame:Hide()

	elseif (event == "WORLD_MAP_UPDATE") then
		if (WorldMapFrame:IsVisible()) then
			Gatherer.MapNotes.MapDraw()
		elseif (Gatherer.Var.MapOpen) then
			Gatherer.MapNotes.MapDraw()
		end
	elseif ( event == "CLOSE_WORLD_MAP") then
		Gatherer.MapNotes.MapDraw()

	elseif( event == "ADDON_LOADED" ) then
		local addon = select(1, ...)
		if (addon and string.lower(addon) == "gatherer") then
			--[[
			if ( myAddOnsFrame_Register ) then
				-- myAddons Support
				GathererDetails["name"] = "Gatherer"
				GathererDetails["version"] = GATHERER_VERSION
				GathererDetails["author"] = "Norganna"
				GathererDetails["website"] = "http://gathereraddon.com"
				GathererDetails["category"] = MYADDONS_CATEGORY_PROFESSIONS
				GathererDetails["frame"] = "Gatherer"
				GathererDetails["optionsframe"] = "Gatherer.Interface.DialogFrame"
				
				-- Register the addon in myAddOns
				if(myAddOnsFrame_Register) then
					myAddOnsFrame_Register(GathererDetails, GathererHelp)
				end
			end
			--]]
			
			LibSwag.Init()
			
			Gatherer.Config.Load()
			Gatherer.Var.Loaded = true
			Gatherer.MiniNotes.UpdateMinimapNotes(0, true)
			
			Gatherer.Util.Print("Gatherer v"..Gatherer.Var.Version.." -- Loaded!")
			
			if (Gatherer.Settings.useMainmap == true) then
				Gatherer_WorldMapDisplay:SetText("Hide Items")
			else
				Gatherer_WorldMapDisplay:SetText("Show Items")
			end
			
			-- record current version number in order to identify the data for backup utilities
			Gatherer.Settings.Version = GATHERER_VERSION
			
			-- Get values for World Map once for all
			Gatherer.Var.WmWidth = WorldMapDetailFrame:GetWidth()
			Gatherer.Var.WmHeight = WorldMapDetailFrame:GetHeight()
			Gatherer.Var.WmLevel = WorldMapPlayer:GetFrameLevel()
		end
	elseif ( event == "PLAYER_LOGIN" ) then
		local SETTINGS = Gatherer.Settings
		local useMinimap = (SETTINGS.useMinimap) and "On" or "Off"
		local useMainmap = (SETTINGS.useMainmap) and "On" or "Off"
		local mapMinder = (SETTINGS.mapMinder) and "On" or "Off"
		local minderTime = (SETTINGS.minderTime or 0).."s"

		if ( SETTINGS.logInfo and SETTINGS.logInfo == "on" ) then
			Gatherer.Util.Print("[Player: "..Gatherer.Var.PlayerName..", Theme: "..SETTINGS.iconSet..", Mainmap: "..useMainmap..", Minimap: "..useMinimap..", MaxDist: "..SETTINGS.maxDist.." units, NoteCount: "..SETTINGS.number..", Fade: "..SETTINGS.fadePerc.."% at "..SETTINGS.fadeDist.." units, IconDist: "..SETTINGS.miniIconDist.."px on minimap, MapMinder: "..mapMinder.." ("..minderTime.."), Filters: herbs="..Gatherer.Command.GetFilterVal("herbs")..", mining="..Gatherer.Command.GetFilterVal("mining")..", treasure="..Gatherer.Command.GetFilterVal("treasure").."]")
		end

	elseif ( event == "PLAYER_LOGOUT" ) then
		Gatherer.Config.Save()

	elseif ( event == "LEARNED_SPELL_IN_TAB" or event == "SPELLS_CHANGED" ) then
		local numSkills = tonumber(GetNumSkillLines())
		if ( GetNumSkillLines() > 0 ) then
			Gatherer.Util.GetSkills()
		end
	elseif ( event == "SKILL_LINES_CHANGED" ) then
		local numSkills = tonumber(GetNumSkillLines())
		if ( GetNumSkillLines() > 0 ) then
			Gatherer.Util.GetSkills()
		end
	elseif ( event == "CHAT_MSG_ADDON" ) then
		local prefix, message, how, who = select(1, ...)
		if (prefix == "GathX" and message ~= lastMessage and who ~= UnitName("player")) then
			lastMessage = message
			local objectID, gatherC, zoneToken, gatherX, gatherY, loot = strsplit(";", message)
			objectID = tonumber(objectID)
			gatherC = tonumber(gatherC)
			gatherX = tonumber(gatherX)
			gatherY = tonumber(gatherY)
			if (objectID and gatherC and gatherX and gatherY) then
				local gatherZ = Gatherer.ZoneTokens.GetZoneIndex(gatherC, zoneToken)
				local gatherType = Gatherer.Nodes.Objects[objectID]

				if (gatherType) then
					local coins, loots = Gatherer.Util.LootSplit(loot)
					Gatherer.Api.AddGather(objectID, gatherType, "", who, coins, loots, false, gatherC, gatherZ, gatherX, gatherY)
					local objName = Gatherer.Util.GetNodeName(objectID);
					Gatherer.Util.ChatPrint(_tr("Received gather of %1 from %2 (%3)", objName, who, _tr(how:lower())))
				end
			end
		end
	elseif ( event == "UI_ERROR_MESSAGE" ) then
		local message =  select(1, ...)
		local skill = Gatherer.Util.ParseFormattedMessage(ERR_USE_LOCKED_WITH_ITEM_S, message)
		if (not skill) then
			skill = Gatherer.Util.ParseFormattedMessage(ERR_USE_LOCKED_WITH_SPELL_KNOWN_SI, message)
		end

		-- Check if there was a skill mentioned, then check to see if we're moused over a valid object
		if (skill) then
			LibSwag.SetTooltip()
			local tooltip = LibSwag.GetLastTip()
			if (not tooltip) then return end
			local tip = tooltip.tip

			local objId = Gatherer.Nodes.Names[tip]
			if (objId) then
				-- We have a mouseover on a valid object that's just fired off
				-- a "Requires" message.
				local gType = Gatherer.Nodes.Objects[objId]
				Gatherer.Api.AddGather(objId, gType, tip, "REQUIRE", 0, {}, false)
			end
		end
	elseif ( event ) then
		Gatherer.Util.ChatPrint("Gatherer Unknown event: "..event)
	end
end

function Gatherer.Event.OnSwag(lootType, lootTable, coinAmount, extraData)
	if (lootType ~= "KILL") then
		local gatherType
		if (lootType == "MINE") then gatherType="Mine"
		elseif (lootType == "HERB") then gatherType="Herb"
		elseif (lootType == "SKIN") then gatherType="Skin"
		elseif (lootType == "FISH") then gatherType="Fish"
		elseif (lootType == "OPEN") then gatherType="Treasure"
		end

		local locale = GetLocale()

		local node = "Unknown"
		if (extraData and extraData.tip) then node = extraData.tip end
		local object = Gatherer.Nodes.Names[node]
		if (not object) then return end

		local objectType = Gatherer.Nodes.Objects[object]
		if (objectType ~= lootType) then return end

		Gatherer.Api.AddGather(object, gatherType, storagetip, nil, coinAmount, lootTable, true)
	end
end
