--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0372 (eagle)
	Revision: $Id: GatherMapping.lua 360 2006-12-22 04:40:19Z esamynn $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Mapping and cartography functions
]]

-- reference to the Astrolabe mapping library
local Astrolabe = AceLibrary:GetInstance(Gatherer.AstrolabeVersion)

function Gatherer.Mapping.HideAll()
	local mmPos = 0
	while (mmPos < Gatherer.Var.MaxNumNotes) do
		mmPos = mmPos+1
		local gatherNote = getglobal("GatherNote"..mmPos)
		gatherNote:Hide()
	end
end

function Gatherer.Mapping.GetNoteObject( noteNumber )
	local button = getglobal("GatherMain"..noteNumber)
	if not ( button ) then
		local overlayFrameNumber = math.ceil(noteNumber / 100)
		local overlayFrame = GathererMapOverlayParent[overlayFrameNumber]
		if not ( overlayFrame ) then
			overlayFrame = CreateFrame("Frame", "GathererMapOverlayFrame"..overlayFrameNumber, GathererMapOverlayParent, "GathererMapOverlayTemplate")
			GathererMapOverlayParent[overlayFrameNumber] = overlayFrame
		end
		button = CreateFrame("Button" ,"GatherMain"..noteNumber, overlayFrame, "GatherMainTemplate")
		button:SetID(noteNumber)
		overlayFrame[(noteNumber-1) % 100 + 1] = button
		Gatherer.Util.Debug("create id "..noteNumber.." frame ".. overlayFrameNumber)
	end
	return button
end

function Gatherer.Mapping.MapDraw()
	if not ( GathererMapOverlayParent:IsVisible() ) then
		return
	end
	local SETTINGS = Gatherer.Settings
	local maxNotes = SETTINGS.maxWorldMapNotes or 600
	local noteCount = 0

	-- prevent the function from running twice at the same time.
	if (Gatherer.Var.UpdateWorldMap == 0 ) then return; end
	Gatherer.Var.UpdateWorldMap = 0
	
	local mapContinent = GetCurrentMapContinent()
	local mapZone = GetCurrentMapZone()
	if ( Gatherer.Storage.HasDataOnZone(mapContinent, mapZone) ) then
		for nodeId, gatherType, num in Gatherer.Storage.ZoneGatherNames(mapContinent, mapZone) do
			if ( Gatherer.Config.ShowOnMainMap(nodeId, gatherType) ) then
				for index, xPos, yPos, count in Gatherer.Storage.ZoneGatherNodes(mapContinent, mapZone, nodeId) do
					if ( noteCount < maxNotes ) then
						noteCount = noteCount + 1
						local mainNote = Gatherer.Mapping.GetNoteObject(noteCount)
						
						if ( SETTINGS and SETTINGS.IconAlpha ~= nil ) then
							mainNote:SetAlpha(SETTINGS.IconAlpha / 100)
						else
							mainNote:SetAlpha(0.8)
						end
						
						Astrolabe:PlaceIconOnWorldMap(WorldMapDetailFrame, mainNote, mapContinent, mapZone, xPos, yPos)
						
						local texture = Gatherer.Util.GetNodeTexture(nodeId)
						getglobal(mainNote:GetName().."Texture"):SetTexture(texture)
						
						if ( SETTINGS.IconSize ~= nil ) then
							mainNote:SetWidth(SETTINGS.IconSize)
							mainNote:SetHeight(SETTINGS.IconSize)
						end
						
						mainNote.continent = mapContinent
						mainNote.zone = mapZone
						mainNote.nodeId = nodeId
						mainNote.localIndex = index
						
						mainNote:Show()
					else -- reached note limit
						break
					end
				end
			end
		end
	end
	
	local numUsedOverlays = math.ceil(noteCount / 100)
	for i, overlay in ipairs(GathererMapOverlayParent) do
		if ( i <= numUsedOverlays ) then
			overlay:Show()
		else
			overlay:Hide()
		end
	end
	
	Gatherer.Var.UpdateWorldMap = -1
end

function Gatherer.Mapping.MapOverlayFrame_OnHide( frame )
	for _, childFrame in ipairs(frame) do
		childFrame:Hide()
	end
end

function Gatherer.Mapping.MapOverlayParent_OnLoad( frame )
	frame:Show()
	frame:RegisterEvent("WORLD_MAP_UPDATE")
end

function Gatherer.Mapping.MapOverlayParent_OnEvent( frame, event )
	if ( event == "WORLD_MAP_UPDATE" ) then
		Gatherer.Mapping.MapDraw()
	end
end
