--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0347 (eagle)
	Revision: $Id: GatherConfig.lua 328 2006-12-03 04:45:24Z esamynn $

	License:
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program(see GPL.txt); if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Saved Variables Configuration and management code
]]

Gatherer.Settings = {}

_G = getfenv(0)
local metatable = { __index = _G }
setmetatable( Gatherer.Config, metatable )
setfenv(1, Gatherer.Config)

-- increment this number by 1 to wipe all of the user's current
-- settings when they upgrade
local SETTINGS_VERSION = 1

Default_Settings = {
	["minderTime"] = 5,
	["maxDist"] = 20,
	["alphaUnderMinIcon"] = 80,
	["number"] = 10,
	["mapMinder"] = false,
	["showWorldMapFilters"] = 0,
	["logInfo"] = "on",
	["iconSet"] = "shaded",
	["ToggleWorldNotes"] = 0,
	["IconSize"] = 12,
	["useMinimapText"] = "on",
	["disableWMFreezeWorkaround"] = 1,
	["filter"] = "all",

	-- Minimap Display Options
	["NoIconOnMinDist"] = 0,
	["HideIcon"] = 0,
	["HideMiniNotes"] = 0,
	["miniIconDist"] = 30, --old default of 40
	["fadeDist"] = 60, --old default of 40
	["fadePerc"] = 80,

	--
	["rareOre"] = 0,

	-- MiniMap Icon Show Menu Options
	["ShowOnMouse"] = 1,
	["ShowOnClick"] = 0,
	["ShowOnButton"] = 0,
	["HideOnMouse"] = 1,
	["HideOnClick"] = 0,
	["HideOnButton"] = 0,

	-- Minimap Icon Position
	["Position"] = 12,
	["Radius"] = 80,

	-- location display
	["useMainmap"] = true,
	["useMinimap"] = true,

	-- per gather type tables
	-- these tables are filled in by the code immediately after this table definition
	["interested"] = {},
	["filterRecording"] = {},
	["filters"] = {},

	-- min skill filters
	["minSetOreSkill"] = nil,
	["minSetHerbSkill"] = nil,
}

--[[ set per gather type defaults
for gatherType, nodeTypes in pairs() do
	Default_Settings.filterRecording[gatherType] = false
	Default_Settings.filters[gatherType] = "auto"

	local interestedTypeTable = {}
	for _, nodeType in pairs(nodeTypes) do
		if ( nodeType ~= "default" ) then
			interestedTypeTable[nodeType] = true
		end
	end
	Default_Settings.interested[gatherType] = interestedTypeTable
end
--]]

--defines keys which are saved in the PerCharacter settings
PerCharacter = {
	"interested",
	"filterRecording",
	"filters",
	"minSetOreSkill",
	"minSetHerbSkill",
}

-- Note: This function WILL NOT handle self referencing table
-- structures correctly (ie. it will never terminate)
local function deepCopy( source, dest )
	for k, v in pairs(source) do
		if ( type(v) == "table" ) then
			if not ( type(dest[k]) == "table" ) then
				dest[k] = {}
			end
			deepCopy(v, dest[k])
		else
			dest[k] = v
		end
	end
end

--Load settings from the SavedVariables tables
function Load()
	local Settings = Gatherer.Settings
	deepCopy(Default_Settings, Settings)
	
	if ( Gatherer_SavedSettings_AccountWide and 
	     Gatherer_SavedSettings_AccountWide.SETTINGS_VERSION == SETTINGS_VERSION ) then
		deepCopy(Gatherer_SavedSettings_AccountWide, Settings)
	end

	if ( Gatherer_SavedSettings_PerCharacter and 
	     Gatherer_SavedSettings_PerCharacter.SETTINGS_VERSION == SETTINGS_VERSION ) then
		deepCopy(Gatherer_SavedSettings_PerCharacter, Settings)
	end
end

--Save settings to the SavedVariables tables
-- Call this when the PLAYER_LOGOUT event fires or saved settings
-- will not be updated
function Save()
	local data = Gatherer.Settings

	local accountSettings = { SETTINGS_VERSION = SETTINGS_VERSION }
	for key in pairs(data) do
		accountSettings[key] = data[key]
	end
	_G.Gatherer_SavedSettings_AccountWide = accountSettings

	local characterSettings = { SETTINGS_VERSION = SETTINGS_VERSION }
	for _, key in pairs(PerCharacter) do
		characterSettings[key] = data[key]
	end
	_G.Gatherer_SavedSettings_PerCharacter = characterSettings
end
