--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0347 (eagle)
	Revision: $Id: GatherApi.lua 345 2006-12-06 03:52:18Z norganna $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	These functions can be used by external addons for interfacing with
	Gatherer. We will try and keep these functions as unchanged as possible.
]]

-- reference to the Astrolabe mapping library
local Astrolabe = AceLibrary:GetInstance(Gatherer.AstrolabeVersion)

-- This function can be used as an interface by other addons to record things
-- in Gatherer's database, though display is still based only on what is defined
-- in Gatherer items and icons tables.
-- Parameters:
--   objectId (number): the object id for this node (from Gatherer.Nodes)
--   gatherType (string): gather type (Mine, Herb, Skin, Fish, Treasure)
--   tooltipText (string): the text in the tooltip (unused)
--   gatherSource (string): the name of the sender (or nil if you collected it)
--   gatherCoins (number): amount of copper found in the node
--   gatherLoot (table): a table of loot: { { link, count }, ...}
local lastHarvest = {}
function Gatherer.Api.AddGather(objectId, gatherType, tooltipText, gatherSource, gatherCoins, gatherLoot, wasGathered, gatherC, gatherZ, gatherX, gatherY)
	if (Gatherer.Settings.filterRecording and Gatherer.Settings.filterRecording[gatherType] and not Gatherer.Settings.interested[gatherType][specificType] ) then
		return
	end

	if not (gatherC and gatherZ and gatherX and gatherY) then
		gatherC, gatherZ, gatherX, gatherY = Astrolabe:GetCurrentPlayerPosition()
		if not (gatherC and gatherZ and gatherX and gatherY) then
			return
		end
	end

	if (not GatherDrops) then GatherDrops = {} end
	if (not GatherDrops[objectId]) then GatherDrops[objectId] = {} end

	local lootText = gatherCoins
	for pos, loot in ipairs(gatherLoot) do
		local id = loot.id
		if (not id and loot.link) then
			id = Gatherer.Util.BreakLink(loot.link)
		end
		if (id) then
			local count = loot.count
			if (count) then
				local total = GatherDrops[objectId].total or 0
				local current = GatherDrops[objectId][id] or 0
				GatherDrops[objectId][id] = current + count
				GatherDrops[objectId].total = total + 1

				lootText = lootText .. ":" .. id .. "x" .. count
			end
		end
	end

	local index = Gatherer.Storage.AddNode(objectId, gatherType, gatherC, gatherZ, gatherX, gatherY, gatherSource, wasGathered)
	if ( type(objectId) == "number" ) then
		local _, _, _, harvested = Gatherer.Storage.GetNodeInfo(gatherC, gatherZ, objectId, index)

		-- If this is our gather
		if (not gatherSource) then
			-- Check if this node's been just harvested by us
			if not (lastHarvest and lastHarvest.c == gatherC and lastHarvest.z == gatherZ and lastHarvest.o == objectId and lastHarvest.i == index) then
				-- Ok, so lets broadcast this node
				local sendMessage = strjoin(";", objectId, gatherC, Gatherer.ZoneTokens.GetZoneToken(gatherC, gatherZ), gatherX, gatherY, lootText)
		--		if (Gatherer.Settings.BcastGuild) then
					if (IsInGuild()) then
						SendAddonMessage("GathX", sendMessage, "GUILD")
					end
		--		end
		--		if (Gatherer.Settings.BcastRaid) then
					if (GetNumRaidMembers() > 0) then
						SendAddonMessage("GathX", sendMessage, "RAID")
					elseif (GetNumPartyMembers() > 0) then
						SendAddonMessage("GathX", sendMessage, "PARTY")
					end
		--		end
			end
			lastHarvest.c = gatherC
			lastHarvest.z = gatherZ
			lastHarvest.o = objectId
			lastHarvest.i = index
		end
	end

	Gatherer.Event.OnUpdate(0,true)
	Gatherer.Mapping.MapDraw()
end
