--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0331 (eagle)
	Revision: $Id: GatherMapping.lua 314 2006-11-27 03:50:18Z esamynn $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

	Mapping and cartography functions
]]

-- reference to the Astrolabe mapping library
local Astrolabe = AceLibrary:GetInstance(Gatherer.AstrolabeVersion)

function Gatherer.Mapping.HideAll()
	local mmPos = 0
	while (mmPos < Gatherer.Var.MaxNumNotes) do
		mmPos = mmPos+1
		local gatherNote = getglobal("GatherNote"..mmPos)
		gatherNote:Hide()
	end
end

function Gatherer.Mapping.CreateNoteObject(noteNumber)
	local button
	local overlayFrameNumber = math.floor((noteNumber - 1000) / 100 + 1)
	if(getglobal("GatherMain"..noteNumber)) then
		button = getglobal("GatherMain"..noteNumber)
	else
		Gatherer.Util.Debug("create id "..noteNumber.." frame ".. overlayFrameNumber)
		button = CreateFrame("Button" ,"GatherMain"..noteNumber, getglobal("GathererMapOverlayFrame"..overlayFrameNumber), "GatherMainTemplate")
		button:SetID(noteNumber)
	end

	return button
end

function Gatherer.Mapping.MapDraw()
	local lastUnused = 1000
	local maxNotes = 1600
	local SETTINGS = Gatherer.Settings

	-- prevent the function from running twice at the same time.
	if (Gatherer.Var.UpdateWorldMap == 0 ) then return; end
	Gatherer.Var.UpdateWorldMap = 0

	if ((Gatherer.Var.MapOpen) and (SETTINGS.useMainmap)) then
		local mapContinent = GetCurrentMapContinent()
		local mapZone = GetCurrentMapZone()
		if ( Gatherer.Storage.HasDataOnZone(mapContinent, mapZone) ) then
			for gatherName, gatherType, num, specificType in Gatherer.Storage.ZoneGatherNames(mapContinent, mapZone) do
				local allowed = Gatherer.Command.GetFilter(gatherType)
				local minSetSkillLevel = 0

				-- extra filtering options
				if (SETTINGS) then

					if( gatherType == "Ore" ) then -- Ore
						minSetSkillLevel = SETTINGS.minSetOreSkill or -1
					elseif ( gatherType == "Herb" ) then -- Herb
						minSetSkillLevel = SETTINGS.minSetHerbSkill or -1
					end

					if ( allowed and minSetSkillLevel > (Gather_SkillLevel[specificType] or 500) or
						 (SETTINGS.rareOre == 1 and Gather_SkillLevel[Gather_RareMatch[specificType]] and
						  Gather_SkillLevel[specificType] < Gather_SkillLevel[Gather_RareMatch[specificType]] and
						  minSetSkillLevel > Gather_SkillLevel[Gather_RareMatch[specificType]] )
					) then
						allowed = false
					end
				end

				if ( allowed and
					((SETTINGS == nil) or
					 (SETTINGS.interested == nil) or SETTINGS.interested[gatherType][specificType] ~= false or
					  (SETTINGS.rareOre == 1 and SETTINGS.interested[gatherType][Gather_RareMatch[specificType]])
					)
				) then

					for index, xPos, yPos, count in Gatherer.Storage.ZoneGatherNodes(mapContinent, mapZone, gatherName) do

						-- Delay code to try to work around the delay display problem, pause for 50 ms each 100 items
						if ( lastUnused > 1000 and lastUnused < maxNotes and mod(lastUnused, 100) == 0 ) then
							local overlayFrameNumber = math.floor((lastUnused - 1000 )/100 + 1)
							getglobal("GathererMapOverlayFrame"..overlayFrameNumber):Show()

						elseif (lastUnused < 1100 and not GathererMapOverlayFrame1:IsShown() ) then
							GathererMapOverlayFrame1:Show()
						end

						if ((xPos) and (yPos) and (xPos>0) and (yPos>0) and (lastUnused <= maxNotes)) then
							local mainNote = Gatherer.Mapping.CreateNoteObject(lastUnused)

							local mnX,mnY
							mnX = xPos / 100 * Gatherer.Var.WmWidth
							mnY = -yPos / 100 * Gatherer.Var.WmHeight

							if ( SETTINGS and SETTINGS.IconAlpha ~= nil ) then
								mainNote:SetAlpha(SETTINGS.IconAlpha / 100)
							else
								mainNote:SetAlpha(0.8)
							end

							mainNote:SetPoint("CENTER", "GathererMapOverlayFrame", "TOPLEFT", mnX, mnY)

							if ( SETTINGS.ToggleWorldNotes == 1) then
								mainNote.toolTip = Gatherer.Util.GetMenuName(gatherName, specificType)
							else
								mainNote.toolTip = Gatherer.Util.GetMenuName(getglobal(specificType), specificType)
							end

							local texture = Gather_IconSet["iconic"][gatherType][specificType]
							getglobal(mainNote:GetName().."Texture"):SetTexture(texture)

							if ( SETTINGS and SETTINGS.IconSize ~= nil ) then
								mainNote:SetWidth(SETTINGS.IconSize)
								mainNote:SetHeight(SETTINGS.IconSize)
							end

							mainNote.continent = mapContinent
							mainNote.zoneIndex = mapZone
							mainNote.gatherName = gatherName
							mainNote.localIndex = index
							mainNote.gatherType = gatherType
							mainNote.gatherIcon = gatherType

							if ( not mainNote:IsShown() ) then
								mainNote:Show()
							end
							lastUnused = lastUnused + 1
						end
					end
				end
			end
		end
	end

	local i=1000
	for i=lastUnused, maxNotes, 1 do
		-- Delay code to try to work around the delay display problem, pause for 50 ms each 100 items
		local overlayFrameNumber = math.floor((i - 1000) / 100 +1)

		if ( i < maxNotes and mod(i, 100) == 0 )
		then
			getglobal("GathererMapOverlayFrame"..overlayFrameNumber):Hide()
		end

		local mainNote = getglobal("GatherMain"..i)
		if ( mainNote and mainNote:IsShown() ) then
			mainNote:SetPoint("CENTER", "GathererMapOverlayFrame", "TOPLEFT", Gatherer.Var.WmWidth+16, Gatherer.Var.WmHeight+16)
		end
	end

	Gatherer.Var.UpdateWorldMap = -1
end

function Gatherer.Mapping.IsMinimapInCity()
	local tempzoom = 0
	local inCity = false
	if (GetCVar("minimapZoom") == GetCVar("minimapInsideZoom")) then
		if (GetCVar("minimapInsideZoom")+0 >= 3) then
			Minimap:SetZoom(Minimap:GetZoom() - 1)
			tempzoom = 1
		else
			Minimap:SetZoom(Minimap:GetZoom() + 1)
			tempzoom = -1
		end
	end
	if (GetCVar("minimapInsideZoom")+0 == Minimap:GetZoom()) then inCity = true; end
	Minimap:SetZoom(Minimap:GetZoom() + tempzoom)
	return inCity
end

function Gatherer.Mapping.MinimapPosition(deltaX, deltaY, scaleX, scaleY) -- works out the distance on the minimap
        local mapX = deltaX * scaleX
        local mapY = deltaY * scaleY
        local mapDist = 0

        mapDist = Gatherer_Pythag(mapX, mapY)
        if (mapDist >= 57) then
		mapX = mapX * 58 / mapDist
		mapY = mapY * 58 / mapDist
        end
        return mapX, mapY, mapDist
end

function Gatherer.Mapping.LoadZoneData()
	local continentData = { GetMapContinents() }
	for continentIndex, continentName in pairs(continentData) do
		local zoneData = { GetMapZones(continentIndex) }
		for zoneIndex, zoneName in pairs(zoneData) do
			Gatherer.Var.ZoneData[zoneName] = { [1] = continentIndex, [2] = zoneIndex }
		end
	end
end

function Gatherer.Mapping.GetCurrentZone()
	local zoneData = Gatherer.Var.ZoneData[GetRealZoneText()]
	if ( zoneData ) then
		return zoneData[1], zoneData[2]
	else
		return 0,0
	end
end

function Gatherer.Mapping.ChangeMap()
	local mapContinent = GetCurrentMapContinent()
	local mapZone = GetCurrentMapZone()
	local minderCurZone = false

	if ((Gatherer.Var.CloseMap ~= nil) and (Gatherer.Var.CloseMap.continent == Gatherer.Var.LastZone.continent) and (Gatherer.Var.CloseMap.zone == Gatherer.Var.LastZone.zone)) then
		minderCurZone = true
	end

	local playerContinent, playerZone = Gatherer.Mapping.GetCurrentZone()
	Gatherer.Var.LastZone = { continent = playerContinent, zone = playerZone }
	if ((playerContinent == 0) or (playerZone == 0)) then return false; end
	if ((playerContinent == mapContinent) and (playerZone == mapZone)) then return true; end

	if ( GetCurrentMapContinent()>0 and playerZone and playerZone > 0 ) then
		if (not WorldMapFrame:IsVisible()) then
			SetMapZoom(playerContinent, playerZone)
		end
	end
	local lastTime = 0
	if ((Gatherer.Var.CloseMap ~= nil) and (Gatherer.Var.CloseMap.time ~= nil)) then
		lastTime = Gatherer.Var.CloseMap.time
	end

	if (minderCurZone) then
		Gatherer.Var.MapOpen = false
		Gatherer.Var.CloseMap = { continent = playerContinent, zone = playerZone, time = lastTime }
	end

	return true
end

function Gatherer.Mapping.GetPlayerPos(forced)
	local currentZoneName = GetRealZoneText()
	if (currentZoneName ~= Gatherer.Var.LastZone) then
		forced = true
	end
	Gatherer.Var.LastZone = currentZoneName
	if (forced) then Gatherer.Mapping.ChangeMap(); end

	local px, py = GetPlayerMapPosition("player")
	if ((px == 0) and (py == 0)) then
		if (not forced) then
			if (Gatherer.Mapping.ChangeMap()) then
				px, py = GetPlayerMapPosition("player")
			else
				return 0,0
			end
		end
	end
	return px, py
end


