--[[
	Gatherer Addon for World of Warcraft(tm).
	Version: 2.99.0.0331 (eagle)
	Revision: $Id: GatherLocale.lua 313 2006-11-27 01:47:53Z norganna $

	License:
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program(see GPL.txt); if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Localization routines
]]

function Gatherer.Locale.Tr(key, ...)
	local localization = Babylonian.getString(GathererStrings, key, key)
	--[TODO 2.0] unpack
	return Gatherer.Locale.Translate(localization, unpack(arg))
end
function Gatherer.Locale.TrClient(key)
	return Babylonian.fetchString(GathererStrings, GetLocale(), key)
end
function Gatherer.Locale.TrLocale(key)
	return Babylonian.getString(GathererStrings, GetLocale(), key)
end

function Gatherer.Locale.Translate(localization, ...)
	if (not localization) then return "" end
	local newloc = ""

	--[TODO 2.0] arg.n
	for i = 1, arg.n do
		local s, b, e
		s = 1 b = 1
		while (b > 0) do
			b,e = string.find(localization, "%"..i, s, true)
			if (b and b > 0) then
				--[TODO 2.0] arg[]
				local argv = arg[i] or ""
				if (type(argv) == "table") then argv = "TABLE" end
				newloc = newloc .. string.sub(localization, s, b-1) .. argv;
				s = e + 1
			else
				b = 0
			end
		end
		newloc = newloc .. string.sub(localization, s)
		localization = newloc
		newloc = ""
	end
	return localization
end

