--[[
	Gatherable Nodes, type groupings definitions
	Revision: $Id: GatherCategories.lua 331 2006-12-04 21:26:34Z mentalpower $

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat

]]


_G = getfenv(0)
local metatable = { __index = _G }
setmetatable( Gatherer.Categories, metatable )
setfenv(1, Gatherer.Categories)

-- Mapping of Object IDs to categories
ObjectCategories = {
	[1731] = "ORE_COPPER",
	[1732] = "ORE_TIN",
	[1733] = "ORE_SILVER",
	[73940] = "ORE_SILVER",
	[1735] = "ORE_IRON",
	[1734] = "ORE_GOLD",
	[73941] = "ORE_GOLD",
	[2040] = "ORE_MITHRIL",
	[123310] = "ORE_MITHRIL",
	[2047] = "ORE_TRUESILVER",
	[123309] = "ORE_TRUESILVER",
	[324] = "ORE_THORIUM",
	[123848] = "ORE_THORIUM",
	[180215] = "ORE_THORIUM",
	[175404] = "ORE_RTHORIUM",
	[177388] = "ORE_RTHORIUM",
	[175404] = "ORE_RTHORIUM",
	[165658] = "ORE_DARKIRON",
	[142141] = "HERB_ARTHASTEAR",
	[176589] = "HERB_BLACKLOTUS",
	[142143] = "HERB_BLINDWEED",
	[1621] = "HERB_BRIARTHORN",
	[1622] = "HERB_BRUISEWEED",
	[176584] = "HERB_DREAMFOIL",
	[1619] = "HERB_EARTHROOT",
	[2042] = "HERB_FADELEAF",
	[2866] = "HERB_FIREBLOOM",
	[142144] = "HERB_GHOSTMUSHROOM",
	[176583] = "HERB_GOLDENSANSAM",
	[2046] = "HERB_GOLDTHORN",
	[1628] = "HERB_GRAVEMOSS",
	[142145] = "HERB_GROMSBLOOD",
	[176588] = "HERB_ICECAP",
	[2043] = "HERB_KHADGARSWHISKER",
	[1624] = "HERB_KINGSBLOOD",
	[2041] = "HERB_LIFEROOT",
	[1620] = "HERB_MAGEROYAL",
	[176586] = "HERB_MOUNTAINSILVERSAGE",
	[1618] = "HERB_PEACEBLOOM",
	[176587] = "HERB_PLAGUEBLOOM",
	[142140] = "HERB_PURPLELOTUS",
	[1617] = "HERB_SILVERLEAF",
	[2045] = "HERB_STRANGLEKELP",
	[142142] = "HERB_SUNGRASS",
	[1623] = "HERB_WILDSTEELBLOOM",
	[2044] = "HERB_WINTERSBITE",
}

-- This table defines the object name which will be used by the UI
-- to refer to all objects of a specific category
CategoryNameIds = {
	-- Ores
	["ORE_COPPER"] = 1731,
	["ORE_TIN"] = 1732,
	["ORE_SILVER"] = 1733,
	["ORE_IRON"] = 1735,
	["ORE_GOLD"] = 1734,
	["ORE_MITHRIL"] = 2040,
	["ORE_TRUESILVER"] = 2047,
	["ORE_THORIUM"] = 324,
	["ORE_RTHORIUM"] = 175404,
	["ORE_DARKIRON"] = 165658,
	-- TBC Ores
	["ORE_FELIRON"] = 181555,
	["ORE_ADAMANTITE"] = -1,
	["ORE_RADAMANTITE"]= -1,
	["ORE_KHORIUM"]    = -1,
	-- Herbs
	["HERB_ARTHASTEAR"] = 142141,
	["HERB_BLACKLOTUS"] = 176589,
	["HERB_BLINDWEED"] = 142143,
	["HERB_BRIARTHORN"] = 1621,
	["HERB_BRUISEWEED"] = 1622,
	["HERB_DREAMFOIL"] = 176584,
	["HERB_EARTHROOT"] = 1619,
	["HERB_FADELEAF"] = 2042,
	["HERB_FIREBLOOM"] = 2866,
	["HERB_GHOSTMUSHROOM"] = 142144,
	["HERB_GOLDENSANSAM"] = 176583,
	["HERB_GOLDTHORN"] = 2046,
	["HERB_GRAVEMOSS"] = 1628,
	["HERB_GROMSBLOOD"] = 142145,
	["HERB_ICECAP"] = 176588,
	["HERB_KHADGARSWHISKER"] = 2043,
	["HERB_KINGSBLOOD"] = 1624,
	["HERB_LIFEROOT"] = 2041,
	["HERB_MAGEROYAL"] = 1620,
	["HERB_MOUNTAINSILVERSAGE"] = 176586,
	["HERB_PEACEBLOOM"] = 1618,
	["HERB_PLAGUEBLOOM"] = 176587,
	["HERB_PURPLELOTUS"] = 142140,
	["HERB_SILVERLEAF"] = 1617,
	["HERB_STRANGLEKELP"] = 2045,
	["HERB_SUNGRASS"] = 142142,
	["HERB_WILDSTEELBLOOM"] = 1623,
	["HERB_WINTERSBITE"] = 2044,
	-- TBC Herbs
	["HERB_FELWEED"]           = 181270,
	["HERB_DREAMINGGLORY"]     = 181271,
	["HERB_TEROCONE"]          = -1,
	["HERB_RAGVEIL"]           = 183043,
	["HERB_NETHERBLOOM"]       = -1,
	["HERB_FLAMECAP"]          = -1,
	-- Treasure
	
}