--[[
	Informant
	An addon for World of Warcraft that shows pertinent information about
	an item in a tooltip when you hover over the item in the game.
	3.9.0.1285 (Kangaroo)
	$Id: InfData.lua 1285 2007-01-02 04:38:50Z tml $
	Informant ItemData

	License:
		This program is free software; you can redistribute it and/or
		modify it under the terms of the GNU General Public License
		as published by the Free Software Foundation; either version 2
		of the License, or (at your option) any later version.

		This program is distributed in the hope that it will be useful,
		but WITHOUT ANY WARRANTY; without even the implied warranty of
		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		GNU General Public License for more details.

		You should have received a copy of the GNU General Public License
		along with this program(see GPL.txt); if not, write to the Free Software
		Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	Note:
		This AddOn's source code is specifically designed to work with
		World of Warcraft's interpreted AddOn system.
		You have an implicit licence to use this AddOn with these facilities
		since that is it's designated purpose as per:
		http://www.fsf.org/licensing/licenses/gpl-faq.html#InterpreterIncompat
--]]


-- Skills that are needed below
Informant.SetSkills({
	[171]="Alchemy",
	[164]="Blacksmithing",
	[185]="Cooking",
	[-11]="Druid",
	[333]="Enchanting",
	[202]="Engineering",
	[129]="FirstAid",
	[165]="Leatherworking",
	[-8]="Mage",
	[186]="Mining",
	[-2]="Paladin",
	[-5]="Priest",
	[-4]="Rogue",
	[-7]="Shaman",
	[197]="Tailoring",
	[-9]="Warlock",
})

Informant.SetRequirements({
	[8207]="165:240",
	[10501]="202:220",
	[8204]="165:225",
	[8203]="165:220",
	[4258]="165:170",
	[12624]="164:270",
	[12632]="164:295",
	[6048]="171:135",
	[6050]="171:190",
	[5963]="165:170",
	[7921]="164:210",
	[10548]="202:240",
	[4333]="197:155",
	[15080]="165:295",
	[15072]="165:280",
	[7148]="202:165",
	[13442]="171:255",
	[3850]="164:175",
	[16006]="202:285",
	[11604]="164:285",
	[11608]="164:265",
	[7946]="164:245",
	[15046]="165:270",
	[7932]="164:235",
	[12797]="164:300",
	[7944]="164:240",
	[6037]="171:225",
	[7969]="164:235",
	[9060]="164:200",
	[10576]="202:250",
	[3854]="164:200",
	[4398]="202:200",
	[16207]="333:290",
	[3490]="164:125",
	[15065]="165:285",
	[15071]="165:275",
	[6451]="129:180",
	[9144]="171:225",
	[8206]="165:245",
	[4596]="171:50",
	[2457]="171:50",
	[10506]="202:230",
	[10518]="202:225",
	[6263]="197:100",
	[15060]="165:285",
	[12217]="185:200",
	[3852]="164:170",
	[15073]="165:275",
	[12794]="164:300",
	[8174]="165:200",
	[5965]="165:185",
	[7942]="164:220",
	[5782]="165:170",
	[6657]="185:85",
	[15058]="165:295",
	[4336]="197:200",
	[3384]="171:110",
	[5763]="197:115",
	[7061]="197:195",
	[15064]="165:275",
	[6052]="171:190",
	[14046]="197:260",
	[15054]="165:270",
	[2317]="165:100",
	[2459]="171:60",
	[13446]="171:275",
	[2572]="197:40",
	[7059]="197:190",
	[16023]="202:275",
	[10502]="202:225",
	[16000]="202:275",
	[10029]="197:235",
	[14342]="197:250",
	[5634]="171:150",
	[15086]="165:280",
	[14100]="197:270",
	[3845]="164:195",
	[3841]="164:175",
	[4407]="202:180",
	[15057]="165:275",
	[4256]="165:175",
	[3843]="164:170",
	[3856]="164:200",
	[10510]="202:220",
	[15062]="165:300",
	[8544]="129:210",
	[3825]="171:175",
	[10018]="197:225",
	[10033]="197:240",
	[13452]="171:280",
	[10007]="197:215",
	[12218]="185:225",
	[15082]="165:280",
	[6468]="165:115",
	[12419]="164:290",
	[15056]="165:285",
	[9197]="171:240",
	[13871]="197:280",
	[4250]="165:120",
	[3826]="171:180",
	[14155]="197:300",
	[7391]="165:200",
	[13868]="197:255",
	[12418]="164:285",
	[8200]="165:215",
	[4403]="202:165",
	[3471]="164:35",
	[3474]="164:60",
	[6662]="171:90",
	[4260]="165:195",
	[8209]="165:235",
	[4367]="202:100",
	[15069]="165:285",
	[15075]="165:290",
	[16022]="202:300",
	[15045]="165:260",
	[15092]="165:275",
	[4372]="202:120",
	[4397]="202:200",
	[4455]="165:165",
	[13445]="171:265",
	[2307]="165:90",
	[7386]="165:190",
	[6049]="171:165",
	[4255]="165:155",
	[9224]="171:250",
	[5764]="197:175",
	[10546]="202:210",
	[7060]="197:190",
	[10008]="197:215",
	[4373]="202:120",
	[7375]="165:175",
	[6051]="171:100",
	[12415]="164:270",
	[5765]="197:185",
	[3726]="185:110",
	[5780]="165:90",
	[8192]="165:210",
	[7047]="197:145",
	[4321]="197:140",
	[4244]="165:100",
	[4322]="197:165",
	[7056]="197:180",
	[15079]="165:285",
	[7053]="197:175",
	[10030]="197:240",
	[4396]="202:200",
	[4313]="197:95",
	[3855]="164:185",
	[3391]="171:150",
	[3390]="171:140",
	[15070]="165:295",
	[4457]="185:175",
	[7063]="197:205",
	[12408]="164:255",
	[4393]="202:185",
	[7967]="164:215",
	[9036]="171:210",
	[4395]="202:195",
	[3851]="164:155",
	[14107]="197:275",
	[7280]="165:35",
	[8201]="165:220",
	[3829]="171:200",
	[8216]="165:240",
	[9061]="171:210",
	[15061]="165:270",
	[13459]="171:290",
	[8208]="165:250",
	[2312]="165:75",
	[3828]="171:195",
	[16007]="202:300",
	[13869]="197:255",
	[12790]="164:300",
	[15066]="165:290",
	[12782]="164:290",
	[12216]="185:225",
	[8205]="165:220",
	[4325]="197:175",
	[15053]="165:285",
	[12410]="164:280",
	[4594]="185:175",
	[15083]="165:260",
	[3846]="164:185",
	[9264]="171:250",
	[3481]="164:125",
	[3824]="171:165",
	[4327]="197:200",
	[12405]="164:250",
	[5541]="164:140",
	[15063]="165:290",
	[10009]="197:215",
	[5633]="171:175",
	[5631]="171:60",
	[6714]="202:100",
	[13931]="185:250",
	[15999]="202:270",
	[13870]="197:265",
	[12360]="171:275",
	[9088]="171:240",
	[7934]="164:245",
	[3387]="171:250",
	[8364]="185:175",
	[13858]="197:260",
	[13864]="197:280",
	[6384]="197:120",
	[4262]="165:185",
	[13462]="171:285",
	[4328]="197:180",
	[5095]="185:50",
	[3837]="164:190",
	[4248]="165:120",
	[6467]="165:105",
	[6466]="165:90",
	[14106]="197:300",
	[15067]="165:270",
	[13863]="197:275",
	[14101]="197:270",
	[4401]="202:75",
	[12210]="185:175",
	[12213]="185:175",
	[5781]="165:95",
	[5958]="165:105",
	[7352]="165:135",
	[13928]="185:240",
	[16766]="185:225",
	[15995]="202:260",
	[4319]="197:145",
	[9210]="171:245",
	[4383]="202:145",
	[15088]="165:300",
	[4241]="197:95",
	[3577]="171:225",
	[9149]="171:225",
	[14111]="197:290",
	[14108]="197:285",
	[8187]="165:205",
	[2311]="165:60",
	[14104]="197:290",
	[12796]="164:300",
	[15050]="165:290",
	[15993]="202:260",
	[10055]="197:235",
	[13935]="185:275",
	[3727]="185:125",
	[3840]="164:160",
	[5783]="165:190",
	[3484]="164:145",
	[2869]="164:130",
	[13867]="197:300",
	[15994]="202:260",
	[2585]="197:105",
	[6242]="197:70",
	[10423]="164:155",
	[7924]="164:215",
	[7065]="197:165",
	[13512]="171:300",
	[12414]="164:300",
	[12798]="164:300",
	[11607]="164:275",
	[4264]="165:200",
	[3492]="164:145",
	[4315]="197:120",
	[6264]="197:115",
	[2864]="164:80",
	[4592]="185:50",
	[14043]="197:270",
	[12406]="164:250",
	[10054]="197:230",
	[6240]="197:55",
	[10052]="197:220",
	[10040]="197:250",
	[9206]="171:245",
	[12420]="164:300",
	[15078]="165:275",
	[10048]="197:120",
	[6043]="164:165",
	[12645]="164:275",
	[7506]="202:125",
	[7358]="165:140",
	[15048]="165:285",
	[15068]="165:300",
	[4593]="185:100",
	[1017]="185:100",
	[2685]="185:110",
	[3663]="185:90",
	[724]="185:50",
	[1082]="185:100",
	[733]="185:75",
	[7359]="165:145",
	[2682]="185:85",
	[13851]="185:175",
	[3386]="171:120",
	[10499]="202:175",
	[4623]="171:215",
	[12633]="164:300",
	[3728]="185:150",
	[13443]="171:260",
	[3729]="185:175",
	[3849]="164:160",
	[12214]="185:175",
	[5762]="197:70",
	[15095]="165:300",
	[10036]="197:250",
	[10034]="197:240",
	[10035]="197:245",
	[13857]="197:260",
	[6042]="164:150",
	[8202]="165:240",
	[7049]="197:150",
	[3666]="185:110",
	[3664]="185:120",
	[9366]="164:205",
	[4252]="165:140",
	[15049]="165:295",
	[12781]="164:285",
	[12792]="164:290",
	[2888]="185:25",
	[3665]="185:130",
	[4311]="197:100",
	[4317]="197:125",
	[3220]="185:60",
	[16005]="202:285",
	[7373]="165:165",
	[3662]="185:80",
	[6239]="197:55",
	[9172]="171:235",
	[15093]="165:280",
	[15087]="165:290",
	[4332]="197:135",
	[15997]="202:285",
	[6385]="197:120",
	[3853]="164:180",
	[4335]="197:185",
	[13933]="185:275",
	[6290]="185:1",
	[15094]="165:290",
	[12416]="164:260",
	[5472]="185:10",
	[15051]="165:300",
	[14112]="197:300",
	[7284]="165:120",
	[4381]="202:140",
	[7283]="165:100",
	[5474]="185:35",
	[7676]="185:60",
	[5526]="185:90",
	[6890]="185:40",
	[4331]="197:125",
	[5477]="185:50",
	[787]="185:1",
	[12212]="185:175",
	[6038]="185:175",
	[13927]="185:225",
	[13930]="185:225",
	[13929]="185:240",
	[13934]="185:275",
	[6453]="129:130",
	[5478]="185:90",
	[18045]="185:225",
	[6887]="185:225",
	[13932]="185:250",
	[13866]="197:295",
	[15081]="165:300",
	[4254]="165:150",
	[14103]="197:275",
	[18486]="197:300",
	[12209]="185:125",
	[13455]="171:280",
	[13865]="197:285",
	[18238]="165:200",
	[5479]="185:100",
	[12803]="171:275",
	[13454]="171:285",
	[16040]="202:300",
	[3485]="164:150",
	[6041]="164:190",
	[4386]="202:155",
	[15052]="165:300",
	[16008]="202:290",
	[4456]="165:165",
	[5476]="185:50",
	[5480]="185:110",
	[15090]="165:300",
	[13506]="171:300",
	[15091]="165:270",
	[12641]="164:300",
	[12808]="171:275",
	[13461]="171:290",
	[12409]="164:280",
	[14142]="197:270",
	[14045]="197:280",
	[14128]="197:300",
	[14042]="197:260",
	[6731]="164:100",
	[14044]="197:275",
	[14139]="197:300",
	[12636]="164:300",
	[13447]="171:270",
	[15074]="165:265",
	[12215]="185:200",
	[11811]="333:265",
	[13456]="171:290",
	[7914]="164:160",
	[4323]="197:170",
	[15059]="165:300",
	[13458]="171:290",
	[4388]="202:160",
	[16004]="202:275",
	[15077]="165:255",
	[12224]="185:1",
	[5473]="185:20",
	[7390]="165:200",
	[15055]="165:300",
	[8212]="165:250",
	[8215]="165:250",
	[7943]="164:225",
	[12417]="164:295",
	[14132]="197:275",
	[14130]="197:300",
	[7078]="171:275",
	[15084]="165:265",
	[14141]="197:275",
	[13860]="197:265",
	[7076]="171:275",
	[7928]="164:225",
	[5770]="197:150",
	[4852]="202:185",
	[6316]="185:50",
	[13453]="171:275",
	[8211]="165:225",
	[18254]="185:275",
	[8213]="165:245",
	[12783]="164:300",
	[18511]="165:300",
	[17198]="185:35",
	[7349]="165:135",
	[10025]="197:245",
	[5081]="165:40",
	[17723]="197:190",
	[7080]="171:275",
	[14137]="197:290",
	[18588]="202:200",
	[12260]="164:190",
	[18631]="202:260",
	[18662]="165:150",
	[17197]="185:1",
	[15996]="202:265",
	[13457]="171:290",
	[16009]="202:290",
	[14138]="197:300",
	[17708]="171:190",
	[18509]="165:300",
	[9312]="202:150",
	[18634]="202:260",
	[18637]="202:275",
	[18594]="202:275",
	[18587]="202:265",
	[13513]="171:300",
	[18405]="197:300",
	[9318]="202:150",
	[18660]="202:260",
	[9313]="202:150",
	[18504]="165:300",
	[14143]="197:265",
	[14153]="197:300",
	[4329]="197:200",
	[12784]="164:300",
	[7913]="164:160",
	[3847]="164:200",
	[12614]="164:300",
	[18510]="165:300",
	[8210]="165:220",
	[17716]="202:190",
	[15085]="165:300",
	[15076]="165:265",
	[18506]="165:300",
	[18645]="202:265",
	[13510]="171:300",
	[13511]="171:300",
	[18408]="197:300",
	[18508]="165:300",
	[16979]="197:300",
	[16982]="165:295",
	[14152]="197:300",
	[7916]="164:180",
	[11605]="164:280",
	[12631]="164:290",
	[12628]="164:285",
	[11606]="164:270",
	[12640]="164:300",
	[14134]="197:275",
	[8214]="165:225",
	[4376]="202:125",
	[6709]="165:90",
	[7915]="164:175",
	[7917]="164:185",
	[7926]="164:220",
	[7927]="164:220",
	[7947]="164:255",
	[11826]="202:205",
	[12428]="164:265",
	[12424]="164:265",
	[12425]="164:270",
	[12426]="164:295",
	[12427]="164:295",
	[12422]="164:300",
	[12611]="164:300",
	[12429]="164:300",
	[12613]="164:300",
	[12620]="164:300",
	[12619]="164:300",
	[12618]="164:300",
	[12773]="164:275",
	[12774]="164:275",
	[12775]="164:280",
	[12776]="164:280",
	[12777]="164:280",
	[7082]="171:275",
	[13444]="171:295",
	[14136]="197:285",
	[14154]="197:300",
	[15047]="165:300",
	[15096]="165:300",
	[16980]="197:300",
	[16983]="165:300",
	[16984]="165:300",
	[16989]="164:295",
	[17014]="164:295",
	[17013]="164:300",
	[16988]="164:300",
	[17015]="164:300",
	[17016]="164:300",
	[17704]="164:190",
	[17721]="165:190",
	[18253]="171:300",
	[18168]="202:300",
	[18407]="197:300",
	[18409]="197:300",
	[18413]="197:300",
	[18638]="202:290",
	[18639]="202:300",
	[18948]="165:155",
	[18263]="197:300",
	[19051]="164:290",
	[19052]="165:290",
	[19056]="197:290",
	[19440]="129:300",
	[19057]="164:300",
	[19058]="165:300",
	[19059]="197:300",
})

Informant.SetVendors({
	[1]="Aayndia Floralwind <Expert Leatherworker>",
	[2]="Abe Winters <Apprentice Armorer>",
	[3]="Abigail Shiel <Trade Supplies>",
	[4]="Adair Gilroy <Librarian>",
	[5]="Adlin Pridedrift <General Supplies>",
	[6]="Aeolynn <Clothier>",
	[7]="Agustus Moulaine <Mail Armor Merchant>",
	[9]="Alchemist Narett <Expert Alchemist>",
	[10]="Alchemist Pestlezugg <Alchemy Supplies>",
	[11]="Aldia <General Supplies>",
	[12]="Aldren Cordon <Clothier>",
	[13]="Aldric Moore <Mail Armor Merchant>",
	[14]="Alexandra Bolero <Tailoring Supplies>",
	[15]="Alexandre Lefevre <Leather Armor Merchant>",
	[16]="Algernon <Alchemy Supplies>",
	[17]="Allan Hafgan <Staves Merchant>",
	[18]="Allyndia <Food & Drink Vendor>",
	[19]="Alowicious Czervik <Sweet Treats>",
	[20]="Altsoba Ragetotem <Weapon Merchant>",
	[21]="Alyssa Eva <Reagent Vendor>",
	[22]="Alyssa Griffith <Bag Vendor>",
	[23]="Amy Davenport <Tradeswoman>",
	[25]="Andiss <Armorer & Shieldcrafter>",
	[26]="Andrea Boynton <Clothier>",
	[27]="Andrew Hilbert <Trade Goods>",
	[28]="Andrew Krighton <Armorer & Shieldcrafter>",
	[29]="Androd Fadran <Leatherworking Supplies>",
	[30]="Antonio Perelli <Traveling Salesman>",
	[35]="Archibald Kava <Cloth & Leather Armor Merchant>",
	[36]="Ardwyn Cailen <Wand Merchant>",
	[37]="Argent Defender <The Argent Dawn>",
	[38]="Argent Guard <The Argent Dawn>",
	[39]="Argent Quartermaster Hasana <The Argent Dawn>",
	[40]="Argent Quartermaster Lightspark <The Argent Dawn>",
	[42]="Asoran <General Goods Vendor>",
	[44]="Avette Fellwood <Bowyer>",
	[45]="Balai Lok'Wein <Potions, Scrolls and Reagents>",
	[46]="Bale <General Goods>",
	[47]="Banalash <Trade Goods>",
	[48]="Barg <General Supplies>",
	[49]="Barim Jurgenstaad <Reagent Vendor>",
	[51]="Barkeep Dobbins <Bartender>",
	[52]="Barkeep Hann <Bartender>",
	[53]="Barkeep Kelly <Bartender>",
	[55]="Bartender Lillian <Bartender>",
	[56]="Bartender Wental <Food and Drinks>",
	[57]="Bartleby <Drunk>",
	[58]="Ben Trias <Apprentice of Cheese>",
	[59]="Bengus Deepforge <Artisan Blacksmith>",
	[60]="Bernard Brubaker <Leather Armor Merchant>",
	[61]="Bernard Gump <Florist>",
	[62]="Bernie Heisten <Food & Drink>",
	[63]="Bhaldaran Ravenshade <Bowyer>",
	[64]="Billibub Cogspinner <Engineering Supplier>",
	[65]="Bimble Longberry <Fruit Vendor>",
	[66]="Bingus <Weapon Merchant>",
	[68]="Bixi Wobblebonk <Weapon Master>",
	[69]="Blacksmith Rand <Apprentice Armorer>",
	[70]="Blixrez Goodstitch <Leatherworking Supplies>",
	[71]="Blixxrak <Light Armor Merchant>",
	[72]="Blizrik Buckshot <Gunsmith>",
	[73]="Bliztik <Alchemy Supplies>",
	[76]="Bombus Finespindle <Leatherworking Supplies>",
	[78]="Boran Ironclink <Armorer>",
	[79]="Borand <Bowyer>",
	[80]="Borstan <Meat Vendor>",
	[81]="Borya <Tailoring Supplies>",
	[82]="Bowen Brisboise <Journeyman Tailor>",
	[84]="Brahnmar <Armorer>",
	[85]="Brak Durnad <Weaponsmith>",
	[86]="Brannol Eaglemoon <Clothier>",
	[87]="Brant Jasperbloom <Herbalist>",
	[88]="Brenwyn Wintersteel <Blade Merchant>",
	[89]="Bretta Goldfury <Gun Merchant>",
	[90]="Brienna Starglow <Tailoring Supplies>",
	[91]="Brikk Keencraft <Master Blacksmith>",
	[92]="Brinna Valanaar <Bowyer>",
	[93]="Bro'kin <Alchemy Supplies>",
	[94]="Brog Hamfist <General Supplies>",
	[95]="Brogus Thunderbrew <Food and Drink>",
	[96]="Bromiir Ormsen <Heavy Armor Merchant>",
	[97]="Bronk <Alchemy Supplies>",
	[98]="Bronk Steelrage <Armorer and Shieldcrafter>",
	[99]="Bront Coldcleave <Butcher>",
	[100]="Brooke Stonebraid <Mining Supplier>",
	[101]="Brother Cassius <Reagent Vendor>",
	[102]="Brother Danil <General Supplies>",
	[104]="Bruuk Barleybeard <Bartender>",
	[105]="Bryan Cross <Shield Merchant>",
	[106]="Bryllia Ironbrand <General Goods Vendor>",
	[107]="Burbik Gearspanner <Trade Supplier>",
	[108]="Burdrak Harglhelm <Leather Armor Merchant>",
	[109]="Burkrum <Heavy Armor Merchant>",
	[111]="Caretaker Alen <The Argent Dawn>",
	[112]="Carla Granger <Cloth Armor Merchant>",
	[113]="Catherine Leland <Fishing Supplier>",
	[114]="Cawind Trueaim <Gunsmith & Bowyer>",
	[115]="Charity Mipsy <General Goods>",
	[116]="Charys Yserian <Arcane Trinkets Vendor>",
	[119]="Christi Galvanis <General Goods>",
	[120]="Christoph Jeffcoat <Tradesman>",
	[121]="Christopher Hewen <General Trade Goods Vendor>",
	[122]="Chylina <General Supplies>",
	[123]="Clarise Gnarltree <Expert Blacksmith>",
	[124]="Cliff Hadin <Bowyer>",
	[125]="Clyde Ranthal <Leatherworking Supplies>",
	[127]="Constance Brisboise <Apprentice Clothier>",
	[129]="Corina Steele <Weaponsmith>",
	[131]="Corporal Bluth <Camp Trader>",
	[132]="Craig Nollward <Cook>",
	[133]="Crazk Sparks <Fireworks Merchant>",
	[134]="Cutac <Cloth & Leather Armor Merchant>",
	[135]="Cylina Darkheart <Demon Trainer>",
	[136]="Daeolyn Summerleaf <General Goods>",
	[138]="Dalmond <General Goods>",
	[139]="Dalria <Trade Goods>",
	[140]="Dane Winslow <Demon Trainer>",
	[141]="Daniel Bartlett <General Trade Supplier>",
	[142]="Danielle Zipstitch <Tailoring Supplies>",
	[143]="Danlyia <Food & Drink Vendor>",
	[144]="Dannie Fizzwizzle <Demon Trainer>",
	[145]="Darcy <Waitress>",
	[146]="Dargon <Food & Drink Merchant>",
	[147]="Darian Singh <Fireworks Vendor>",
	[148]="Dark Iron Entrepreneur <Speciality Goods>",
	[149]="Darnall <Tailoring Supplies>",
	[150]="Dawn Brightstar <Arcane Goods>",
	[151]="Dellylah <Food & Drink Vendor>",
	[152]="Deneb Walker <Scrolls & Potions>",
	[153]="Denni'ka <Butcher>",
	[154]="Derak Nightfall <Cook>",
	[156]="Dermot Johns <Cloth & Leather Armor Merchant>",
	[157]="Dewin Shimmerdawn <Alchemy Supplies>",
	[158]="Dirge Quikcleave <Butcher>",
	[160]="Dolkin Craghelm <Mail Armor Merchant>",
	[161]="Dolman Steelfury <Weapon Merchant>",
	[162]="Donald Rabonne <Fisherman>",
	[163]="Donni Anthania <Crazy Cat Lady>",
	[164]="Dorin Songblade <Armorer>",
	[166]="Drac Roughcut <Tradesman>",
	[167]="Drake Lindgren <General & Trade Supplies>",
	[168]="Drakk Stonehand <Master Leatherworking Trainer>",
	[169]="Dranh <Skinner>",
	[171]="Drovnar Strongbrew <Alchemy Supplies>",
	[173]="Dulciea Frostmoon <Cloth Armor Merchant>",
	[174]="Duncan Cullen <Light Armor Merchant>",
	[175]="Duokna <General Goods>",
	[176]="Durnan Furcutter <Cloth & Leather Armor Merchant>",
	[177]="Dwane Wertle <Chef>",
	[178]="Edna Mullby <Trade Supplier>",
	[179]="Edris Barleybeard <Barmaid>",
	[180]="Edwin Harly <General Supplies>",
	[181]="Edwina Monzor <Fletcher>",
	[182]="Elaine Trias <Mistress of Cheese>",
	[183]="Eldraeith <Herbalism Supplier>",
	[184]="Eleanor Rusk <General Goods Vendor>",
	[185]="Elisa Steelhand <Blacksmithing Supplies>",
	[186]="Eliza Callen <Leather Armor Merchant>",
	[187]="Elizabeth Van Talen <Engineering Supplier>",
	[188]="Elly Langston <Barmaid>",
	[189]="Elynna <Tailoring Supplies>",
	[190]="Emmithue Smails <Sweet Treats>",
	[191]="Emrul Riknussun <Cooking Supplier>",
	[192]="Erika Tate <Cooking Supplier>",
	[193]="Evan Larson <Hatter>",
	[194]="Evie Whirlbrew <Alchemy Supplies>",
	[195]="Fahran Silentblade <Tools & Supplies>",
	[196]="Falkan Armonis <Reagent Vendor>",
	[199]="Faralorn <General Supplies>",
	[200]="Fargon Mortalak <Superior Armorer>",
	[202]="Felder Stover <Weaponsmith>",
	[203]="Felicia Doan <General Trade Goods Vendor>",
	[204]="Felicia Gump <Herbalism Supplier>",
	[205]="Felika <General Trade Goods Merchant>",
	[208]="Fillius Fizzlespinner <Trade Supplier>",
	[209]="Fimble Finespindle <Expert Leatherworker>",
	[210]="First Sergeant Hola'mahi <Reagent Vendor>",
	[211]="Fizzlebang Booms <Fireworks Vendor>",
	[213]="Flakk <Trade Supplies>",
	[215]="Fradd Swiftgear <Engineering Supplies>",
	[216]="Franklin Hamar <Tailoring Supplies>",
	[217]="Frast Dokner <Apprentice Weaponsmith>",
	[218]="Frederick Stover <Bow & Arrow Merchant>",
	[219]="Freja Nightwing <Leather Armor Merchant>",
	[221]="Fyrenna <Food & Drink Vendor>",
	[222]="Gabrielle Chase <Food & Drink>",
	[224]="Gaelden Hammersmith <Stormpike Supply Officer>",
	[225]="Gagsprocket <Engineering Goods>",
	[226]="Gahroot <Butcher>",
	[227]="Galthuk <Two-Handed Weapons Merchant>",
	[228]="Gamili Frosthide <Cloth & Leather Armor Merchant>",
	[229]="Gamon <Classes: Rogue>",
	[230]="Garyl <Tabard Vendor>",
	[231]="Gavin Gnarltree <Weaponsmith>",
	[233]="Gearcutter Cogspinner <Engineering Supplies>",
	[234]="Geenia Sunshadow <Speciality Dress Maker>",
	[235]="Geoffrey Hartwell <Weapon Merchant>",
	[236]="George Candarte <Leatherworking Supplies>",
	[237]="Georgia <Bat Handler>",
	[238]="Georgio Bolero <Artisan Tailor>",
	[239]="Gerald Crawley <Poison Supplier>",
	[240]="Gerik Koen <Two Handed Weapon Merchant>",
	[241]="Gharash <Blacksmithing Supplies>",
	[242]="Ghok'kah <Tailoring Supplies>",
	[243]="Ghrawt <Bowyer>",
	[244]="Gikkix <Fisherman>",
	[245]="Gina Lang <Demon Trainer>",
	[246]="Gina MacGregor <Trade Supplies>",
	[247]="Ginny Longberry <Reagent Vendor>",
	[248]="Gloria Femmel <Cooking Supplies>",
	[249]="Glyx Brewright <Alchemy Supplies>",
	[250]="Godan <Expert Enchanter>",
	[251]="Godric Rothgar <Armorer & Shieldcrafter>",
	[252]="Golnir Bouldertoe <Mining Supplier>",
	[253]="Golorn Frostbeard <Tradesman>",
	[255]="Gorbold Steelhand <General Trade Supplier>",
	[256]="Gordon Wendham <Weapons Merchant>",
	[257]="Gorina <Mining Supplier>",
	[260]="Gothor Brumn <Armorer>",
	[261]="Gotri <Bag Vendor>",
	[262]="Granis Swiftaxe <Warrior Trainer>",
	[263]="Graud <General Goods>",
	[264]="Graw Cornerstone <Mail Armor Merchant>",
	[265]="Grawl <General Goods>",
	[266]="Grawn Thromwyn <Weaponsmith>",
	[267]="Grawnal <General Goods>",
	[268]="Grazlix <Armorer & Shieldcrafter>",
	[270]="Gregor MacVince <Horse Breeder>",
	[271]="Gregory Ardus <Staff & Mace Merchant>",
	[272]="Greishan Ironstove <Traveling Merchant>",
	[273]="Grelkor <Blacksmithing Supplies>",
	[274]="Grenil Steelfury <Weapon Merchant>",
	[275]="Greshka <Demon Master>",
	[276]="Gretchen Vogel <Waitress>",
	[277]="Gretta Ganter <Fisherman Supplies>",
	[279]="Grimnal <Mail & Plate Merchant>",
	[280]="Grimtak <Butcher>",
	[281]="Grod <Leather Armor Merchant>",
	[282]="Grondal Moonbreeze <Journeyman Tailor>",
	[283]="Groum Stonebeard <Journeyman Blacksmith>",
	[284]="Gruham Rumdnul <General Supplies>",
	[285]="Gruna <Food & Drink>",
	[286]="Grundel Harkin <Armorer>",
	[287]="Grunnda Wolfheart <Frostwolf Supply Officer>",
	[288]="Gruul Darkblade <Weaponsmith>",
	[291]="Gunder Thornbush <Tradesman>",
	[292]="Gunther Weller <Weapons Merchant>",
	[294]="Gwenna Firebrew <Barmaid>",
	[295]="Gwina Stonebranch <Herbalism Supplier>",
	[296]="Gwyn Farrow <Mushroom Merchant>",
	[297]="Hae'Wilani <Axecrafter>",
	[298]="Hagrus <Reagents Vendor>",
	[299]="Hahrana Ironhide <Master Leatherworker>",
	[300]="Hai'zan <Butcher>",
	[301]="Hal McAllister <Fish Merchant>",
	[302]="Halija Whitestrider <Clothier>",
	[303]="Haljan Oakheart <General Goods>",
	[304]="Hamlin Atkins <Mushroom Farmer>",
	[305]="Hammon Karwn <Superior Tradesman>",
	[306]="Handor <Cloth & Leather Armor Merchant>",
	[307]="Hank the Hammer <The Mithril Order>",
	[308]="Hannah Akeley <Reagent Supplier>",
	[309]="Hans Weston <Armorer & Shieldsmith>",
	[311]="Hansel Heavyhands <The Thorium Brotherhood>",
	[312]="Harant Ironbrace <Armorer and Shieldcrafter>",
	[313]="Harb Clawhoof <Kodo Mounts>",
	[314]="Haren Kanmae <Superior Bowyer>",
	[315]="Harggan <Blacksmithing Supplies>",
	[317]="Harick Boulderdrum <Wands Merchant>",
	[318]="Harklan Moongrove <Alchemy Supplies>",
	[319]="Harklane <Fish Vendor>",
	[321]="Harlon Thornguard <Armorer & Shieldsmith>",
	[322]="Harlown Darkweave <Leatherworking Supplies>",
	[323]="Harn Longcast <Fishing Supplies>",
	[324]="Harnor <Food & Drink>",
	[325]="Harold Raims <Apprentice Weaponsmith>",
	[326]="Harold Riggs <Fishing Trainer>",
	[327]="Hartash <Weapon Merchant>",
	[328]="Hegnar Rumbleshot <Gunsmith>",
	[329]="Hegnar Swiftaxe <Axe Merchant>",
	[330]="Heinrich Stone <Blade Merchant>",
	[331]="Heldan Galesong <Fisherman>",
	[332]="Helene Peltskinner <Skinner>",
	[333]="Helenia Olden <Trade Supplies>",
	[334]="Henry Chapal <Gunsmith>",
	[335]="Herble Baubbletump <Engineering and Mining Supplies>",
	[340]="Himmik <Food & Drink>",
	[341]="Hjoldir Stoneblade <Blade Merchant>",
	[342]="Homer Stonefield <Fruit Seller>",
	[343]="Honni Goldenoat <Baker>",
	[346]="Horthus <Reagents Vendor>",
	[347]="Hragran <Cloth & Leather Armor Merchant>",
	[348]="Hraq <Blacksmithing Supplier>",
	[349]="Hraug <Demon Trainer>",
	[350]="Huklah <Cloth & Leather Armor Merchant>",
	[351]="Hula'mahi <Reagents and Herbs>",
	[352]="Hurklor <Blacksmithing Supplies>",
	[353]="Illiyana Moonblaze <Silverwing Supply Officer>",
	[354]="Illyanie <Cloth Armor Merchant>",
	[355]="Ingrys Stonebrow <Cloth Armor Merchant>",
	[356]="Innkeeper Abeqwa <Innkeeper>",
	[357]="Innkeeper Adegwa <Innkeeper>",
	[358]="Innkeeper Allison <Innkeeper>",
	[359]="Innkeeper Anderson <Innkeeper>",
	[360]="Innkeeper Bates <Innkeeper>",
	[361]="Innkeeper Belm <Innkeeper>",
	[362]="Innkeeper Boorand Plainswind <Innkeeper>",
	[363]="Innkeeper Brianna <Innkeeper>",
	[364]="Innkeeper Byula <Innkeeper>",
	[365]="Innkeeper Farley <Innkeeper>",
	[366]="Innkeeper Firebrew <Innkeeper>",
	[367]="Innkeeper Greul <Innkeeper>",
	[368]="Innkeeper Grosk <Innkeeper>",
	[369]="Innkeeper Hearthstove <Innkeeper>",
	[370]="Innkeeper Heather <Innkeeper>",
	[371]="Innkeeper Helbrek <Innkeeper>",
	[372]="Innkeeper Janene <Innkeeper>",
	[373]="Innkeeper Jayka <Innkeeper>",
	[374]="Innkeeper Kauth <Innkeeper>",
	[375]="Innkeeper Kaylisk <Innkeeper>",
	[376]="Innkeeper Keldamyr <Innkeeper>",
	[377]="Innkeeper Lyshaerya <Innkeeper>",
	[378]="Innkeeper Renee <Innkeeper>",
	[379]="Innkeeper Shay <Innkeeper>",
	[380]="Innkeeper Shul'kar <Innkeeper>",
	[381]="Innkeeper Sikewa <Innkeeper>",
	[382]="Innkeeper Skindle <Innkeeper>",
	[383]="Innkeeper Thulbek <Innkeeper>",
	[384]="Innkeeper Thulfram <Innkeeper>",
	[385]="Innkeeper Trelayne <Innkeeper>",
	[386]="Innkeeper Vizzie <Innkeeper>",
	[387]="Innkeeper Wiley <Innkeeper>",
	[388]="Irene Sureshot <Gunsmith>",
	[390]="Ironzar <Weaponsmith>",
	[391]="Jabbey <General Goods>",
	[392]="Jadenvis Seawatcher <Reagent Vendor>",
	[393]="Jahan Hawkwing <Leather & Mail Armor Merchant>",
	[394]="Jandi <Herbalism Trainer>",
	[395]="Jandia <Trade Supplies>",
	[396]="Janet Hommers <Food & Drink>",
	[397]="Jangdor Swiftstrider <Leatherworking Supplies>",
	[398]="Janna Brightmoon <Clothier>",
	[399]="Jannos Ironwill <Superior Macecrafter>",
	[400]="Janos Hammerknuckle <Weaponsmith>",
	[401]="Jansen Underwood <Blacksmithing Supplies>",
	[402]="Jarel Moor <Bartender>",
	[403]="Jark <General Goods>",
	[404]="Jase Farlane <Trade Supplies>",
	[405]="Jason Lemieux <Mushroom Seller>",
	[406]="Jasper Fel <Shady Dealer>",
	[408]="Jawn Highmesa <General Goods>",
	[409]="Jaxin Chong <Expert Alchemist>",
	[410]="Jaxxil Sparks <Holiday Fireworks Vendor>",
	[411]="Jaysin Lanyda <Poisons & Reagents>",
	[412]="Jazzik <General Supplies>",
	[413]="Jazzrik <Blacksmithing Supplies>",
	[414]="Jeeda <Apprentice Witch Doctor>",
	[415]="Jeena Featherbow <Bowyer>",
	[416]="Jekyll Flandring <Frostwolf Supply Officer>",
	[417]="Jennabink Powerseam <Tailoring Supplies & Specialty Goods>",
	[418]="Jensen Farran <Bowyer>",
	[419]="Jern Hornhelm <Explorers' League>",
	[420]="Jessara Cordell <Enchanting Supplies>",
	[421]="Jhag <Journeyman Enchanter>",
	[422]="Jhawna Oatwind <Baker>",
	[423]="Jillian Tanner <Leatherworking Supplies>",
	[424]="Jin'sora <Bow Merchant>",
	[425]="Joachim Brenlow <Bartender>",
	[426]="Johan Focht <Miner>",
	[427]="Jondor Steelbrow <Guild Master>",
	[428]="Jonivera Farmountain <General Goods>",
	[429]="Jorb <Lizzarik's Bodyguard>",
	[430]="Joshua Kien <General Supplies>",
	[431]="Joshua Maclure <Vintner>",
	[432]="Jubahl Corpseseeker <Demon Trainer>",
	[433]="Julia Gallina <Wine Vendor>",
	[434]="Jun'ha <Tailoring Supplies>",
	[435]="Jutak <Blade Trader>",
	[436]="K'waii <General Goods>",
	[437]="Kaita Deepforge <Blacksmithing Supplies>",
	[438]="Kaja <Guns and Ammo Merchant>",
	[439]="Kalyimah Stormcloud <Bags & Sacks>",
	[440]="Kamari <Journeyman Leatherworker>",
	[441]="Kara Adams <Shield Crafter>",
	[442]="Karen Taylor <Mining and Smithing Supplies>",
	[443]="Kareth <Blade Merchant>",
	[445]="Karm Ironquill <Mining Supplies>",
	[446]="Karolek <Expert Leatherworker>",
	[447]="Kat Sampson <Leather Armor Merchant>",
	[448]="Kathrum Axehand <Axe Merchant>",
	[449]="Katie Hunter <Horse Breeder>",
	[450]="Katis <Wand Merchant>",
	[451]="Katoom the Angler <Fishing Trainer & Supplies>",
	[452]="Kawnie Softbreeze <General Goods>",
	[453]="Kayla Smithe <Demon Trainer>",
	[454]="Kayren Soothallow <General Goods>",
	[455]="Kazan Mogosh <Food & Drink Merchant>",
	[456]="Keeg Gibn <Ale and Wine>",
	[457]="Keena <Trade Goods>",
	[458]="Keina <Bowyer>",
	[459]="Keldric Boucher <Arcane Goods Vendor>",
	[460]="Kelgruk Bloodaxe <Weapon Crafter>",
	[461]="Kelm Hargunth <Warsong Supply Officer>",
	[462]="Kelomir Ironhand <Maces & Staves>",
	[463]="Kelsey Yance <Cook>",
	[464]="Kendor Kabonka <Master of Cooking Recipes>",
	[465]="Kennah Hawkseye <Gunsmith>",
	[466]="Kerlonian Evershade <Druid of the Claw>",
	[467]="Kersok Prond <Tradesman>",
	[468]="Khara Deepwater <Fishing Supplies>",
	[469]="Khardan Proudblade <Weaponsmith>",
	[470]="Kharedon <Light Armor Merchant>",
	[472]="Kiknikle <Stylish Clothier>",
	[473]="Kil'hala <Journeyman Tailor>",
	[474]="Killian Sanatha <Fisherman>",
	[475]="Kilxx <Fisherman>",
	[476]="Kimberly Hiett <Fletcher>",
	[477]="Kira Songshine <Traveling Baker>",
	[478]="Kireena <Trade Goods>",
	[479]="Kiro <War Harness Maker>",
	[480]="Kitha <Demon Trainer>",
	[481]="Kithas <Enchanting Supplies>",
	[482]="Kixxle <Potions & Herbs>",
	[483]="Kizz Bluntstrike <Macecrafter>",
	[484]="Kizzak Sparks <Holiday Fireworks Vendor>",
	[485]="Kor'geld <Alchemy Supplies>",
	[486]="Kor'jus <Mushroom Vendor>",
	[487]="Koru <Mace & Staves Vendor>",
	[489]="Krak <Armorer>",
	[490]="Krakk <Superior Armorer>",
	[491]="Kreg Bilmn <General Supplies>",
	[492]="Kriggon Talsone <Fisherman>",
	[493]="Krinkle Goodsteel <Blacksmithing Supplies>",
	[494]="Krond <Butcher>",
	[495]="Kulwia <Trade Supplies>",
	[496]="Kuna Thunderhorn <Bowyer & Fletching Goods>",
	[497]="Kurdrum Barleybeard <Reagents & Poisons>",
	[498]="Kurgul <Demon Trainer>",
	[499]="Kurll <Food & Drink>",
	[500]="Kurran Steele <Cloth & Leather Armor Merchant>",
	[501]="Kylanna <Expert Alchemist>",
	[502]="Kyndri <Baker>",
	[503]="Kyra Boucher <Reagent Vendor>",
	[504]="Kzan Thornslash <Weaponsmith>",
	[505]="Kzixx <Rare Goods>",
	[506]="Laer Stepperunner <Food & Drink>",
	[507]="Lah'Mawhani <Trade Supplies>",
	[508]="Laird <Fish Vendor>",
	[509]="Lamar Veisilli <Fruit Seller>",
	[510]="Lana Thunderbrew <Blacksmithing Supplies>",
	[511]="Landria <Bow Merchant>",
	[512]="Lara Moore <Leather Armor Merchant>",
	[513]="Lard <Innkeeper>",
	[514]="Lardan <Leatherworking Supplies>",
	[515]="Larhka <Beverage Merchant>",
	[516]="Lauren Newcomb <Light Armor Merchant>",
	[517]="Lawrence Schneider <Journeyman Tailor>",
	[518]="Lelanai <Tiger Handler>",
	[519]="Leo Sarn <Enchanting Supplies>",
	[520]="Leonard Porter <Leatherworking Supplies>",
	[521]="Lhara <Darkmoon Faire Exotic Goods>",
	[523]="Lieutenant Jackspring <Reagent Vendor>",
	[524]="Lil Timmy <Boy with kittens>",
	[525]="Lillian Singh <Holiday Fireworks Vendor>",
	[526]="Lilly <Enchanting Supplies>",
	[527]="Lina Stover <Bow & Gun Merchant>",
	[528]="Lindea Rabonne <Tackle and Bait>",
	[529]="Lindsay Ashlock <General Supplies>",
	[530]="Lisbeth Schneider <Clothier>",
	[531]="Lissyphus Finespindle <Light Armor Merchant>",
	[532]="Lizzarik <Weapon Dealer>",
	[533]="Llana <Reagent Supplies>",
	[534]="Logannas <Alchemy Supplies>",
	[535]="Lohgan Eva <Tailoring Supplies>",
	[536]="Lokhtos Darkbargainer <The Thorium Brotherhood>",
	[537]="Loorana <Food & Drink>",
	[538]="Lorelae Wintersong <Trade Supplies>",
	[539]="Loslor Rudge <Engineering Supplies>",
	[540]="Lucan Cordell <Expert Enchanter>",
	[541]="Lumak <Fishing Trainer>",
	[542]="Lunnix Sprocketslip <Mining Supplies>",
	[543]="Lyesa Steelbrow <Guild Tabard Vendor>",
	[544]="Lyrai <General Supplies>",
	[545]="Lyranne Feathersong <Food & Drink>",
	[546]="Mabel Solaj <General Goods Vendor>",
	[547]="Maeva Snowbraid <Robe Merchant>",
	[548]="Magenius <Reagents Vendor>",
	[550]="Mahnott Roughwound <Weaponsmith>",
	[551]="Mahu <Leatherworking & Tailoring Supplies>",
	[552]="Mai'Lahii <Fishing Supplies>",
	[553]="Makaru <Mining Trainer>",
	[554]="Malgin Barleybrew <Bael'dun Morale Officer>",
	[555]="Malissa <Poison Supplier>",
	[556]="Maliynn <Food & Drink Vendor>",
	[557]="Mallen Swain <Tailoring Supplies>",
	[558]="Malygen <General Goods>",
	[559]="Mangorn Flinthammer <Heavy Armor Merchant>",
	[560]="Marda Weller <Weapons Merchant>",
	[561]="Mardrack Greenwell <Food & Drink>",
	[562]="Maria Lumere <Alchemy Supplies>",
	[563]="Marie Holdston <Weaponsmith>",
	[565]="Maris Granger <Skinning Trainer>",
	[566]="Marjak Keenblade <Weaponsmith>",
	[567]="Martine Tramblay <Fishing Supplies>",
	[568]="Master Smith Burninate <The Thorium Brotherhood>",
	[569]="Mavralyn <Leather Armor & Leatherworking Supplies>",
	[570]="Maxton Strang <Mail Armor Merchant>",
	[571]="Mayda Thane <Cobbler>",
	[572]="Mazk Snipeshot <Engineering Supplies>",
	[574]="Meliri <Weaponsmith>",
	[575]="Meri Ironweave <Armorer & Shieldcrafter>",
	[576]="Merideth Carlson <Horse Breeder>",
	[578]="Micha Yance <Trade Goods>",
	[579]="Mike Miller <Bread Merchant>",
	[580]="Mikhail <Bartender>",
	[581]="Milli Featherwhistle <Mechanostrider Merchant>",
	[582]="Millie Gregorian <Tailoring Supplies>",
	[584]="Montarr <Lorekeeper>",
	[585]="Moodan Sungrain <Baker>",
	[586]="Moorane Hearthgrain <Baker>",
	[587]="Moorat Longstride <General Goods>",
	[588]="Morg Gnarltree <Armorer>",
	[590]="Morgum <Leather Armor Merchant>",
	[591]="Morhan Coppertongue <Metalsmith>",
	[592]="Morley Eberlein <Clothier>",
	[594]="Mrs. Winters <General Supplies>",
	[595]="Mu'uta <Bowyer>",
	[597]="Muragus <Staff Merchant>",
	[599]="Murndan Derth <Gunsmith>",
	[600]="Muuran <Superior Macecrafter>",
	[601]="My'lanna <Food & Drink Merchant>",
	[603]="Myra Tyrngaarde <Bread Vendor>",
	[604]="Mystic Yayo'jin <Reagent Vendor>",
	[605]="Mythrin'dir <General Trade Supplier>",
	[606]="Naal Mistrunner <Cooking Supplier>",
	[607]="Nadia Vernon <Bowyer>",
	[608]="Naela Trance <Bowyer>",
	[609]="Namdo Bizzfizzle <Engineering Supplies>",
	[610]="Nan Mistrunner <Fruit Vendor>",
	[611]="Nandar Branson <Alchemy Supplies>",
	[612]="Nantar <Baker>",
	[613]="Naram Longclaw <Weaponsmith>",
	[614]="Nargal Deatheye <Weaponsmith>",
	[615]="Nargatt <Food & Drink>",
	[616]="Narianna <Bowyer>",
	[617]="Narj Deepslice <Butcher>",
	[618]="Narkk <Pirate Supplies>",
	[620]="Narret Shadowgrove <Trade Supplies>",
	[621]="Nata Dawnstrider <Enchanting Supplies>",
	[622]="Natheril Raincaller <General Goods>",
	[623]="Neal Allen <Engineering & General Goods Supplier>",
	[624]="Neema <Waitress>",
	[625]="Nerrist <Trade Goods>",
	[626]="Nessa Shadowsong <Fishing Supplies>",
	[627]="Nida Winterhoof <Herbalism Supplier>",
	[628]="Nillen Andemar <Macecrafter>",
	[629]="Nina Lightbrew <Alchemy Supplies>",
	[630]="Nioma <Leatherworking Supplies>",
	[632]="Nixxrak <Heavy Armor Merchant>",
	[633]="Nixxrax Fillamug <Food and Drink>",
	[634]="Nyoma <Cooking Supplies>",
	[635]="Officer Areyn <Accessories Quartermaster>",
	[636]="Ogg'marr <Butcher>",
	[637]="Ogunaro Wolfrunner <Kennel Master>",
	[638]="Old Man Heming <Fisherman>",
	[639]="Oliver Dwor <Apprentice Weaponsmith>",
	[640]="Ollanus <Light Armor Merchant>",
	[641]="Olthran Craghelm <Heavy Armor Merchant>",
	[642]="Olvia <Meat Vendor>",
	[644]="Osric Strang <Heavy Armor Merchant>",
	[645]="Otho Moji'ko <Cooking Supplier>",
	[646]="Ott <Weaponsmith>",
	[647]="Outfitter Eric <Speciality Tailoring Supplies>",
	[648]="Overwatch Mark I <Protector>",
	[649]="Owen Vaughn <Reagent Vendor>",
	[650]="Pakwa <Bag Vendor>",
	[651]="Patrice Dwyer <Poison Supplies>",
	[652]="Piter Verance <Weaponsmith & Armorer>",
	[653]="Pithwick <Bag Vendor>",
	[654]="Pizznukle <Leather Armor Merchant>",
	[656]="Poranna Snowbraid <Tailoring Supplies>",
	[657]="Pratt McGrubben <Leatherworking Supplies>",
	[658]="Priestess Josetta <Priest Trainer>",
	[659]="Professor Thaddeus Paleo <Darkmoon Faire Cards & Exotic Goods>",
	[663]="Qia <Trade Goods Supplies>",
	[664]="Qixdi Goodstitch <Cloth Armor and Accessories>",
	[665]="Quartermaster Hicks <Master Weaponsmith>",
	[666]="Quartermaster Hudson <Armorer & Shieldcrafter>",
	[667]="Quartermaster Lewis <Quartermaster>",
	[668]="Quartermaster Miranda Breechlock <The Argent Dawn>",
	[670]="Raena Flinthammer <Light Armor Merchant>",
	[671]="Rallic Finn <Bowyer>",
	[672]="Ranik <Trade Supplies>",
	[673]="Rann Flamespinner <Tailoring Supplies>",
	[674]="Rarc <Armorer & Shieldcrafter>",
	[675]="Rarck <General Goods>",
	[676]="Rartar <Alchemy Supplies>",
	[677]="Rashona Straglash <Horde Cloth Quartermaster>",
	[680]="Rebecca Laughlin <Tabard Vendor>",
	[681]="Rekkul <Poison Vendor>",
	[682]="Rendow <Leather Armor Merchant>",
	[684]="Rikqiz <Leatherworking Supplies>",
	[686]="Rivern Frostwind <Wintersaber Trainers>",
	[687]="Robert Aebischer <Superior Armorsmith>",
	[688]="Roberto Pupellyverbos <Merlot Connoisseur>",
	[689]="Rotgath Stonebeard <Expert Blacksmith>",
	[691]="Ruw <Herbalism Trainer>",
	[692]="Rybrad Coldbank <Weaponsmith>",
	[693]="Saenorion <Leatherworking Supplies>",
	[695]="Salazar Bloch <Book Dealer>",
	[696]="Samor Festivus <Shady Dealer>",
	[698]="Sana <Mail Armor Merchant>",
	[699]="Sanuye Runetotem <Leather Armor Merchant>",
	[700]="Sarah Raycroft <General Goods>",
	[702]="Savanne <Fishing Supplies>",
	[703]="Scott Carevin <Mushroom Seller>",
	[704]="Sebastian Meloche <Armorer>",
	[705]="Selina Weston <Alchemy & Herbalism Supplies>",
	[707]="Seoman Griffith <Leather Armor Merchant>",
	[708]="Sergeant Ba'sha <Accessories Quartermaster>",
	[709]="Sergeant De Vries <Morale Officer>",
	[710]="Sergeant Major Clate <Food and Drink>",
	[711]="Sewa Mistrunner <Fishing Supplier>",
	[713]="Shaldyn <Clothier>",
	[714]="Shalomon <Weaponsmith>",
	[715]="Shan'ti <Fruit Vendor>",
	[716]="Shandrina <Trade Goods>",
	[717]="Shankys <Fishing Supplies>",
	[718]="Sheendra Tallgrass <Trade Supplies>",
	[720]="Sheri Zipstitch <Tailoring Supplies>",
	[721]="Sherman Femmel <Butcher>",
	[722]="Shimra <General Trade Goods Merchant>",
	[723]="Shoja'my <Stable Master>",
	[724]="Shoma <Weapon Vendor>",
	[726]="Shrye Ragefist <Food and Drink>",
	[727]="Shylenai <Owl Trainer>",
	[728]="Shyn <Wind Rider Master>",
	[729]="Sinda <Leather Armor Merchant>",
	[730]="Skolmin Goldfury <Bow Merchant>",
	[732]="Slagg <Superior Butcher>",
	[733]="Sloan McCoy <Poison Supplier>",
	[734]="Sly Garrett <Shady Goods>",
	[735]="Smith Argus <Journeyman Blacksmith>",
	[736]="Smith Slagtree <Blacksmithing Supplies>",
	[737]="Smudge Thunderwood <Poison Vendor>",
	[738]="Sognar Cliffbeard <Meat Vendor>",
	[739]="Soolie Berryfizz <Alchemy Supplies>",
	[740]="Sovik <Engineering Supplies>",
	[741]="Spackle Thornberry <Demon Trainer>",
	[742]="Springspindle Fizzlegear <Artisan Engineer>",
	[744]="Sraaz <Pie Vendor>",
	[745]="Sranda <Light Armor & Weapons Merchant>",
	[746]="Stamp Thunderhorn <Darkmoon Faire Food Vendor>",
	[747]="Starn <Gunsmith & Bowyer>",
	[749]="Stone Guard Zarg <Food and Drink>",
	[751]="Strumner Flintheel <Armor Crafter>",
	[752]="Stuart Fleming <Fisherman>",
	[753]="Sumi <Blacksmithing Supplier>",
	[754]="Svalbrad Farmountain <Trade Goods>",
	[755]="Sylannia <Darkmoon Faire Drink Vendor>",
	[757]="Syurana <Trade Goods Supplies>",
	[758]="Tai'tasi <Trade Supplies>",
	[759]="Taldan <Drink Vendor>",
	[760]="Tally Berryfizz <Expert Alchemist>",
	[761]="Tamar <Leatherworking Supplies>",
	[762]="Tandaan Lightmane <Leather Armor Merchant>",
	[763]="Tansy Puddlefizz <Fishing Supplier>",
	[764]="Tarban Hearthgrain <Baker>",
	[765]="Tarhus <Reagent Vendor>",
	[766]="Tari'qa <Trade Supplies>",
	[767]="Tarren Mill Deathguard <Soulbound>",
	[769]="Tel'Athir <Journeyman Alchemist>",
	[770]="Terry Palin <Lumberjack>",
	[771]="Thaddeus Webb <Enchanting Supplies>",
	[772]="Thalgus Thunderfist <Weapon Merchant>",
	[774]="Thanthaldis Snowgleam <Stormpike Supply Officer>",
	[775]="Tharynn Bouden <Trade Supplies>",
	[776]="Thelgrum Stonehammer <Mining Supplier>",
	[778]="Theresa Moulaine <Robe Vendor>",
	[779]="Thomas Miller <Baker>",
	[780]="Thonys Pillarstone <Journeyman Enchanter>",
	[781]="Thralosh <Cloth & Leather Armor Merchant>",
	[782]="Thrawn Boltar <Blacksmithing Supplies>",
	[783]="Thulman Flintcrag <Guns Vendor>",
	[784]="Thultash <Food & Drink Vendor>",
	[785]="Thultazor <Arcane Goods Vendor>",
	[786]="Thund <Journeyman Engineer>",
	[788]="Thurgrum Deepforge <Blacksmithing Supplies>",
	[789]="Thurman Mullby <General Goods Vendor>",
	[791]="Thuwd <Skinning Trainer>",
	[792]="Thyssiana <Hippogryph Master>",
	[793]="Tilli Thistlefuzz <Enchanting Supplies>",
	[795]="Tink Sprocketwhistle <Engineering Supplies>",
	[796]="Tiyani <Food & Drink Vendor>",
	[797]="Toddrick <Butcher>",
	[798]="Tognus Flintfire <Journeyman Blacksmith>",
	[799]="Tomas <Cook>",
	[801]="Tor'phan <Cloth & Leather Armor Merchant>",
	[802]="Torq Ironblast <Gunsmith>",
	[803]="Trak'gen <General Goods Merchant>",
	[804]="Trayexir <Weapon Merchant>",
	[805]="Trenton Lighthammer <The Mithril Order>",
	[806]="Trixie Quikswitch <Expert Engineer>",
	[807]="Truk Wildbeard <Bartender>",
	[808]="Tukk <General Goods Vendor>",
	[809]="Tumi <Heavy Armor Merchant>",
	[810]="Tunkk <Leatherworking Supplies>",
	[811]="Turhaw <Butcher>",
	[812]="Turuk Amberstill <Dwarven Weaponsmith>",
	[813]="Tynnus Venomsprout <Shady Dealer>",
	[814]="Uhgar <Weaponsmith>",
	[815]="Ukra'nor <Staff Merchant>",
	[816]="Ullanna <Trade Supplies>",
	[817]="Ulthaan <Butcher>",
	[818]="Ulthir <Alchemy Supplies>",
	[819]="Uma Bartulm <Herbalism & Alchemy Supplies>",
	[820]="Unger Statforth <Horse Breeder>",
	[822]="Ursula Deline <Warlock Trainer>",
	[823]="Urtharo <Weapon Merchant>",
	[824]="Urtrun Clanbringer <Guild Master>",
	[825]="Uthok <General Supplies>",
	[826]="Uthrok <Bowyer & Gunsmith>",
	[827]="Uttnar <Butcher>",
	[828]="Vaean <Enchanting Supplies>",
	[829]="Valdaron <Tailoring Supplies>",
	[830]="Varg Windwhisper <Leather Armor Merchant>",
	[831]="Varia Hardhide <Leather Armor Merchant>",
	[832]="Veldan Lightfoot <Leather Armor Merchant>",
	[833]="Vernon Hale <Bait and Tackle Supplier>",
	[834]="Veron Amberstill <Ram Breeder>",
	[835]="Vexspindle <Cloth & Leather Armor Merchant>",
	[836]="Vharr <Superior Weaponsmith>",
	[837]="Vikki Lonsav <General Goods>",
	[838]="Vivianna <Trade Supplies>",
	[839]="Vizzklick <Tailoring Supplies>",
	[840]="Voloren <Fishing Supplier>",
	[841]="Vosur Brakthel <Journeyman Alchemist>",
	[842]="Vrang Wildgore <Weaponsmith & Armorcrafter>",
	[843]="Vrok Blunderblast <Gunsmith>",
	[845]="Watcher Callahan <The Night Watch>",
	[847]="Wenna Silkbeard <Special Goods Dealer>",
	[848]="Werg Thickblade <Leatherworking Supplies>",
	[851]="Wigcik <Superior Fisherman>",
	[852]="Wik'Tar <Fish Merchant & Supplies>",
	[853]="Wilhelm Strang <Mail Armor Merchant>",
	[854]="William MacGregor <Bowyer>",
	[855]="Wixxrak <Weaponsmith & Gunsmith>",
	[856]="Wizbang Booms <Holiday Fireworks Vendor>",
	[857]="Worb Strongstitch <Light Armor Merchant>",
	[858]="Wrahk <Tailoring Supplies>",
	[859]="Wren Darkspring <Demon Trainer>",
	[860]="Wrinkle Goodsteel <Superior Armor Crafter>",
	[861]="Wuark <Armorer & Shieldcrafter>",
	[862]="Wulan <Cooking Supplies>",
	[863]="Wunna Darkmane <Trade Goods>",
	[864]="Wynne Larson <Robe Merchant>",
	[865]="Xai'ander <Weaponsmith>",
	[866]="Xan'tish <Snake Vendor>",
	[867]="Xandar Goodbeard <General Supplies>",
	[868]="Xen'to <Cooking Supplier>",
	[869]="Xizk Goodstitch <Tailoring Supplies>",
	[870]="Xizzer Fizzbolt <Engineering Supplies>",
	[871]="Yaelika Farclaw <Reagents & Poisons>",
	[872]="Yanni Stoutheart <General Supplies>",
	[874]="Yonada <Tailoring & Leatherworking Supplies>",
	[877]="Zachariah Post <Undead Horse Merchant>",
	[878]="Zamja <Cooking Trainer>",
	[879]="Zan Shivsproket <Speciality Engineer>",
	[880]="Zanara <Bowyer>",
	[881]="Zansoa <Fishing Supplies>",
	[882]="Zarena Cromwind <Superior Weaponsmith>",
	[883]="Zargh <Butcher>",
	[884]="Zarrin <Cook>",
	[885]="Zeal'aya <Herbalism Supplier>",
	[886]="Zendo'jian <Weapon Vendor>",
	[887]="Ziggle Sparks <Holiday Fireworks Vendor>",
	[888]="Zixil <Merchant Supreme>",
	[889]="Zizzek <Fisherman>",
	[891]="Zjolnir <Raptor Handler>",
	[892]="Zlagk <Butcher>",
	[893]="Zora Guthrek <Trade Goods>",
	[894]="Zulrg <Weaponsmith>",
})

-- The base item data
Informant.SetDatabase({
	[12884]="0:0:0:0:1:::0:0:", -- Arnak's Hoof
	[12650]="0:0:0:0:1:::0:0:", -- Attuned Dampener
	[7227]="0:0:0:0:1:::0:0:", -- Balnir Snapdragons
	[6781]="0:0:0:0:1:::0:0:", -- Bartleby's Mug
	[6929]="0:0:0:0:1:::0:0:", -- Bath'rah's Parchment
	[6927]="0:0:0:0:1:::0:0:", -- Big Will's Ear
	[18154]="0:0:0:0:1:::0:0:", -- Blizzard Stationery
	[5044]="0:0:0:0:1:::0:0:", -- Blue Ribboned Gift
	[16282]="0:0:0:0:1:::0:0:", -- Bundle of Hides
	[15314]="0:0:0:0:1:::0:0:", -- Bundle of Relics
	[6812]="0:0:0:0:1:::0:0:", -- Case of Elunite
	[8423]="0:0:0:0:1:::0:0:", -- Cerebral Cortex Compound
	[1113]="0:0:0:0:20:Food::0:0:", -- Conjured Bread
	[8079]="0:0:0:0:20:Drink::0:0:", -- Conjured Crystal Water
	[2288]="0:0:0:0:20:Drink::0:0:", -- Conjured Fresh Water
	[8077]="0:0:0:0:20:Drink::0:0:", -- Conjured Mineral Water
	[5349]="0:0:0:0:20:Food::0:0:", -- Conjured Muffin
	[1487]="0:0:0:0:20:Food::0:0:", -- Conjured Pumpernickel
	[2136]="0:0:0:0:20:Drink::0:0:", -- Conjured Purified Water
	[1114]="0:0:0:0:20:Food::0:0:", -- Conjured Rye
	[8075]="0:0:0:0:20:Food::0:0:", -- Conjured Sourdough
	[8078]="0:0:0:0:20:Drink::0:0:", -- Conjured Sparkling Water
	[3772]="0:0:0:0:20:Drink::0:0:", -- Conjured Spring Water
	[8076]="0:0:0:0:20:Food::0:0:", -- Conjured Sweet Roll
	[5350]="0:0:0:0:20:Drink::0:0:", -- Conjured Water
	[5880]="0:0:0:0:1:::0:0:", -- Crate With Holes
	[11197]="0:0:0:0:1:::0:0:", -- Dark Keeper Key
	[9311]="0:0:0:0:1:::0:0:", -- Default Stationery
	[8548]="0:0:0:0:1:::0:0:", -- Divino-matic Rod
	[7627]="0:0:0:0:1:::0:0:", -- Dolanaar Delivery
	[7970]="0:0:0:0:1:::0:0:", -- E.C.A.C.
	[6635]="0:0:0:0:1:::0:0:", -- Earth Sapta
	[8432]="0:0:0:0:1:::0:0:", -- Eau de Mixilpixil
	[8048]="0:0:0:0:1:::0:0:", -- Emerald Dreamcatcher
	[12922]="0:0:0:0:1:::0:0:", -- Empty Canteen
	[11914]="0:0:0:0:20:::0:0:", -- Empty Cursed Ooze Jar
	[11953]="0:0:0:0:20:::0:0:", -- Empty Pure Sample Jar
	[11948]="0:0:0:0:20:::0:0:", -- Empty Tainted Ooze Jar
	[10687]="0:0:0:0:1:::0:0:", -- Empty Vial Labeled #1
	[10688]="0:0:0:0:1:::0:0:", -- Empty Vial Labeled #2
	[10689]="0:0:0:0:1:::0:0:", -- Empty Vial Labeled #3
	[10690]="0:0:0:0:1:::0:0:", -- Empty Vial Labeled #4
	[10663]="0:0:0:0:1:::0:0:", -- Essence of Hakkar
	[6851]="0:0:0:0:1:::0:0:", -- Essence of the Exile
	[8444]="0:0:0:0:1:::0:0:", -- Executioner's Key
	[6636]="0:0:0:0:1:::0:0:", -- Fire Sapta
	[13761]="0:0:0:0:1:::0:0:", -- Frozen Eggs
	[6842]="0:0:0:0:1:::0:0:", -- Furen's Instructions
	[6926]="0:0:0:0:1:::0:0:", -- Furen's Notes
	[11405]="0:0:0:0:20:::0:0:", -- Giant Silver Vein
	[8424]="0:0:0:0:1:::0:0:", -- Gizzard Gum
	[19011]="0:0:0:0:1:::0:0:", -- Greater Healthstone
	[5510]="0:0:0:0:1:::0:0:", -- Greater Healthstone
	[16895]="0:0:0:0:1:::0:0:", -- Greater Soulstone
	[8412]="0:0:0:0:1:::0:0:", -- Ground Scorpok Assay
	[9569]="0:0:0:0:1:::0:0:", -- Hallowed Scroll
	[18640]="0:0:0:0:2:::0:0:", -- Happy Fun Rock
	[5509]="0:0:0:0:1:::0:0:", -- Healthstone
	[19009]="0:0:0:0:1:::0:0:", -- Healthstone
	[8095]="0:0:0:0:1:::0:0:", -- Hinott's Oil
	[12586]="0:0:0:0:50:::0:0:", -- Immature Venom Sac
	[12894]="0:0:0:0:1:::0:0:", -- Joseph's Wedding Ring
	[13703]="0:0:0:0:20:::0:0:", -- Kodo Bone
	[14542]="0:0:0:0:1:::0:0:", -- Kravel's Crate
	[5511]="0:0:0:0:1:::0:0:", -- Lesser Healthstone
	[16892]="0:0:0:0:1:::0:0:", -- Lesser Soulstone
	[14894]="0:0:0:0:1:::0:0:", -- Lily Root
	[8411]="0:0:0:0:1:::0:0:", -- Lung Juice Cocktail
	[9421]="0:0:0:0:1:::0:0:", -- Major Healthstone
	[19013]="0:0:0:0:1:::0:0:", -- Major Healthstone
	[19012]="0:0:0:0:1:::0:0:", -- Major Healthstone
	[16896]="0:0:0:0:1:::0:0:", -- Major Soulstone
	[8007]="0:0:0:0:1:::0:0:", -- Mana Citrine
	[5513]="0:0:0:0:1:::0:0:", -- Mana Jade
	[8008]="0:0:0:0:1:::0:0:", -- Mana Ruby
	[6782]="0:0:0:0:1:::0:0:", -- Marshal Haggard's Badge
	[5512]="0:0:0:0:1:::0:0:", -- Minor Healthstone
	[5232]="0:0:0:0:1:::0:0:", -- Minor Soulstone
	[13156]="0:0:0:0:1:::0:0:", -- Mystic Crystal
	[11413]="0:0:0:0:1:::0:0:", -- Nagmara's Filled Vial
	[11952]="0:0:0:0:20:::0:0:", -- Night Dragon's Breath
	[9319]="0:0:0:0:1:::0:0:", -- Nimboya's Laden Pike
	[12885]="0:0:0:0:1:::0:0:", -- Pamela's Doll
	[12886]="0:0:0:0:1:::0:0:", -- Pamela's Doll's Head
	[7127]="0:0:0:0:20:::0:0:", -- Powdered Azurite
	[8410]="0:0:0:0:1:::0:0:", -- R.O.I.D.S.
	[5043]="0:0:0:0:1:::0:0:", -- Red Ribboned Gift
	[13562]="0:0:0:0:1:::0:0:", -- Remains of Trey Lightforge
	[13155]="0:0:0:0:20:::0:0:", -- Resonating Skull
	[12924]="0:0:0:0:5:::0:0:", -- Ritual Candle
	[12533]="0:0:0:0:1:::0:0:", -- Roughshod Pike
	[10621]="0:0:0:0:1:::0:0:", -- Runed Scroll
	[11148]="0:0:0:0:20:::0:0:", -- Samophlange Manual Page
	[9546]="0:0:0:0:1:::0:0:", -- Simple Scroll
	[6486]="0:0:0:0:20:::0:0:", -- Singed Scale
	[16893]="0:0:0:0:1:::0:0:", -- Soulstone
	[7516]="0:0:0:0:1:::0:0:", -- Tabetha's Instructions
	[18297]="0:0:0:0:5:::0:0:", -- Thornling Seed
	[7629]="0:0:0:0:1:::0:0:", -- Ukor's Burden
	[7266]="0:0:0:0:1:::0:0:", -- Ur's Treatise on Shadow Magic
	[6841]="0:0:0:0:1:::0:0:", -- Vial of Phlogiston
	[6464]="0:0:0:0:20:::0:0:", -- Wailing Essence
	[6074]="0:0:0:0:1:::0:0:", -- War Horn Mouthpiece
	[12712]="0:0:0:0:1:::0:0:", -- Warosh's Mojo
	[6637]="0:0:0:0:1:::0:0:", -- Water Sapta
	[11951]="0:0:0:0:20:::0:0:", -- Whipper Root Tuber
	[11950]="0:0:0:0:20:Food::0:0:", -- Windblossom Berries
	[12820]="0:0:0:0:10:::0:0:", -- Winterfall Firewater
	[13367]="0:0:0:0:1:::0:0:", -- Wrapped Gift
	[6458]="4:1:0:0:20:Food::0:0:", -- Oil Covered Fish
	[17303]="10:2:0:0:10:Giftwrap::1:0:119,122,184,199,267,412,495,529,789,803,808", -- Blue Ribboned Wrapping Paper
	[19222]="10:2:0:0:10:Alcohol::1:0:755", -- Cheap Beer
	[17304]="10:2:0:0:10:Giftwrap::0:0:", -- Green Ribboned Wrapping Paper
	[961]="10:2:0:0:10:Food::0:0:", -- Healing Herb
	[17307]="10:2:0:0:10:Giftwrap::0:0:", -- Purple Ribboned Wrapping Paper
	[17202]="10:0:0:0:20::202:0:0:", -- Snowball
	[8164]="10:2:0:0:10:::0:0:", -- Test Stationery
	[5476]="12:3:0:0:20:Food::0:0:", -- Fillet of Frenzy
	[1177]="12:3:0:0:10:Potion::0:0:", -- Oil of Olaf
	[3434]="15:3:0:0:10:::0:0:", -- Slumber Sand
	[2679]="20:5:0:0:20:Food::0:0:", -- Charred Wolf Meat
	[5997]="20:5:0:0:5:Potion::0:0:", -- Elixir of Minor Defense
	[18662]="20:5:0:0:5:::0:0:", -- Heavy Leather Ball
	[4592]="20:1:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Longjaw Mud Snapper
	[118]="20:5:0:0:5:Potion:171:0:0:", -- Minor Healing Potion
	[6291]="20:1:0:0:20:Food:185:0:0:", -- Raw Brilliant Smallfish
	[6289]="20:1:0:0:20:Food:185:0:0:", -- Raw Longjaw Mud Snapper
	[6303]="20:1:0:0:20:Food:185:0:0:", -- Raw Slitherskin Mackerel
	[6657]="20:5:0:0:20:::0:0:", -- Savory Deviate Delight
	[6947]="22:5:0:0:10:Poison::0:0:", -- Instant Poison
	[2681]="24:6:0:0:20:Food::0:0:", -- Roasted Boar Meat
	[16166]="25:1:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Bean Soup
	[6643]="25:6:0:0:1:::0:0:", -- Bloated Smallfish
	[6290]="25:1:0:0:20:Food::0:0:", -- Brilliant Smallfish
	[11584]="25:1:0:0:20:Food::0:0:", -- Cactus Apple Surprise
	[17344]="25:1:0:0:20:Food::0:0:", -- Candy Cane
	[19223]="25:1:0:0:20:Food::5:0:746", -- Darkmoon Dog
	[2070]="25:1:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Darnassian Bleu
	[4604]="25:1:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Forest Mushroom Cap
	[7097]="25:1:0:0:20:Food::0:0:", -- Leg Meat
	[159]="25:1:0:0:20:Drink:202,185:5:0:5,11,18,42,46,48,51,52,53,55,56,57,58,62,80,94,95,102,106,111,115,119,122,131,136,138,143,145,146,151,153,154,158,167,175,179,180,182,184,188,191,192,199,221,222,229,244,248,262,263,265,267,276,280,284,285,294,296,303,305,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,391,396,403,408,412,422,428,430,431,436,452,454,455,456,461,463,477,491,495,499,502,506,513,515,529,537,544,545,546,556,558,561,568,578,580,585,587,594,601,606,612,615,622,623,624,633,634,636,645,667,675,700,709,710,721,726,728,749,759,764,784,789,796,803,807,808,811,825,837,862,867,868,872,884,892", -- Refreshing Spring Water
	[5057]="25:1:0:0:20:Food::0:0:", -- Ripe Watermelon
	[3448]="25:6:0:0:20:Food::0:0:", -- Senggin Root
	[4536]="25:1:0:0:20:Food:185:5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Shiny Red Apple
	[6299]="25:1:0:0:20:Food::0:0:", -- Sickly Looking Fish
	[787]="25:1:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Slitherskin Mackerel
	[4656]="25:1:0:0:20:Food::0:0:", -- Small Pumpkin
	[11109]="25:6:0:0:1:Food::0:0:", -- Special Chicken Feed
	[4540]="25:1:0:0:20:Food::5:0:5,56,62,95,102,132,143,175,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,430,452,455,477,502,506,537,544,561,579,585,586,603,612,615,624,633,710,726,728,749,764,779,789,803,854", -- Tough Hunk of Bread
	[117]="25:1:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Tough Jerky
	[1178]="30:7:0:0:20:::0:0:", -- Explosive Rocket
	[13927]="32:8:0:0:20:Food::0:0:", -- Cooked Glossy Mightfish
	[17198]="36:9:0:0:20:::0:0:", -- Egg Nog
	[5474]="36:9:0:0:20:Food::0:0:", -- Roasted Kodo Meat
	[2888]="40:10:0:0:20:Food::0:0:", -- Beer Basted Boar Ribs
	[7807]="40:10:0:0:20:Food::0:0:", -- Candy Bar
	[7808]="40:10:0:0:20:Food::0:0:", -- Chocolate Square
	[12224]="40:10:0:0:20:Food::0:0:", -- Crispy Bat Wing
	[12238]="40:2:0:0:20:Food::0:0:", -- Darkshore Grouper
	[17197]="40:10:0:0:20:Food::0:0:", -- Gingerbread Cookie
	[6888]="40:10:0:0:20:Food::0:0:", -- Herb Baked Egg
	[13929]="40:10:0:0:20:Food::0:0:", -- Hot Smoked Bass
	[5472]="40:10:0:0:20:Food::0:0:", -- Kaldorei Spider Kabob
	[7806]="40:10:0:0:20:Food::0:0:", -- Lollipop
	[2455]="40:10:0:0:5:Potion::1:1:150,429,532", -- Minor Mana Potion
	[6308]="40:2:0:0:20:Food:185:0:0:", -- Raw Bristle Whisker Catfish
	[6317]="40:2:0:0:20:Food:185:0:0:", -- Raw Loch Frenzy
	[6361]="40:2:0:0:20:Food:185:0:0:", -- Raw Rainbow Fin Albacore
	[1326]="40:10:0:0:20:Food::0:0:", -- Sauteed Sunfish
	[5473]="40:10:0:0:20:Food::0:0:", -- Scorpid Surprise
	[2680]="40:10:0:0:20:Food::0:1:797", -- Spiced Wolf Meat
	[3382]="40:10:0:0:5:Potion::0:0:", -- Weak Troll's Blood Potion
	[3087]="45:11:0:0:10:Potion::0:0:", -- Mug of Shimmer Stout
	[4941]="45:11:0:0:20:::0:0:", -- Really Sticky Glue
	[9312]="50:12:0:0:5:Firework::1:0:410,484,525,856,887", -- Blue Firework
	[5048]="50:12:0:0:10:Giftwrap::1:0:119,122,184,199,267,412,495,529,789,803,808", -- Blue Ribboned Wrapping Paper
	[2723]="50:12:0:0:20:Alcohol::1:0:51,57,104,179,188,229,294,366,402,425,431,433,456,554,633,688,709,710,749", -- Bottle of Pinot Noir
	[19221]="50:12:0:0:10:Alcohol::1:0:755", -- Darkmoon Special Reserve
	[9313]="50:12:0:0:5:Firework::1:0:410,484,525,856,887", -- Green Firework
	[17196]="50:12:0:0:20:Alcohol:185:0:0:", -- Holiday Spirits
	[1399]="50:12:0:0:20:::0:0:", -- Magic Candle
	[9318]="50:12:0:0:5:Firework::1:0:410,484,525,856,887", -- Red Firework
	[5042]="50:12:0:0:10:Giftwrap::1:0:11,48,51,94,138,167,180,184,296,403,436,491,587,594,667,789,803,867,872", -- Red Ribboned Wrapping Paper
	[2894]="50:12:0:0:10:Alcohol:185:1:0:262,361,384,872", -- Rhapsody Malt
	[6529]="50:12:0:0:20:Lure::1:0:3,23,27,48,113,121,141,162,166,167,178,185,203,205,213,246,253,255,277,323,451,466,468,475,478,495,507,528,529,552,567,579,594,605,620,626,638,672,702,711,717,722,752,754,758,763,766,775,803,816,833,840,852,854,863,881,889,893", -- Shiny Bauble
	[2686]="50:12:0:0:10:Alcohol::1:0:262,361,384,872", -- Thunder Ale
	[3775]="52:13:0:0:10:Poison::0:0:", -- Crippling Poison
	[1401]="56:14:0:0:20:::0:0:", -- Green Tea Leaf
	[2457]="60:15:0:0:5:Potion:165:0:0:", -- Elixir of Minor Agility
	[2458]="60:15:0:0:5:Potion::0:0:", -- Elixir of Minor Fortitude
	[13893]="60:15:0:0:20:Food:185:0:0:", -- Large Raw Mightfish
	[2304]="60:15:0:0:10:::0:0:", -- Light Armor Kit
	[6316]="60:3:0:0:20:Food::0:0:", -- Loch Frenzy Delight
	[18253]="60:15:0:0:5:Potion::0:0:", -- Major Rejuvenation Potion
	[2456]="60:15:0:0:5:Potion::0:0:", -- Minor Rejuvenation Potion
	[18255]="60:15:0:0:20:Food:185:0:0:", -- Runn Tum Tuber
	[13934]="72:18:0:0:20:Food::0:0:", -- Mightfish Steak
	[5237]="72:18:0:0:10:Poison::0:0:", -- Mind-numbing Poison
	[18254]="72:18:0:0:20:Food::0:0:", -- Runn Tum Tuber Surprise
	[5477]="74:18:0:0:20:Food::0:0:", -- Strider Stew
	[5525]="80:20:0:0:20:Food::0:1:797", -- Boiled Clams
	[2684]="80:20:0:0:20:Food::0:1:797", -- Coyote Steak
	[2454]="80:20:0:0:5:Potion::0:0:", -- Elixir of Lion's Strength
	[3391]="80:20:0:0:5:Potion:164:0:0:", -- Elixir of Ogre's Strength
	[6949]="80:20:0:0:10:Poison::0:0:", -- Instant Poison II
	[9036]="80:20:0:0:5:Potion::0:0:", -- Magic Resistance Potion
	[3384]="80:20:0:0:5:Potion::0:0:", -- Minor Magic Resistance Potion
	[8365]="80:4:0:0:20:Food:185:0:0:", -- Raw Mithril Head Trout
	[13758]="80:4:0:0:20:Food:185:0:0:", -- Raw Redgill
	[6362]="80:4:0:0:20:Food:185:0:0:", -- Raw Rockscale Cod
	[4603]="80:4:0:0:20:Food:185:0:0:", -- Raw Spotted Yellowtail
	[5066]="85:21:0:0:10:Food::0:0:", -- Fissure Plant
	[835]="95:23:0:0:1:::0:0:", -- Large Rope Net
	[5457]="95:23:0:0:10:::0:0:", -- Severed Voodoo Claw
	[6811]="100:25:0:0:20:Lure::0:0:", -- Aquadynamic Fish Lens
	[6645]="100:25:0:0:1:::0:0:", -- Bloated Mud Snapper
	[2682]="100:25:0:0:20:Food::0:0:", -- Cooked Crab Claw
	[2683]="100:25:0:0:20:Food::0:0:", -- Crab Cake
	[3662]="100:25:0:0:20:Food::0:0:", -- Crocolisk Steak
	[19182]="100:25:0:0:200:::0:0:", -- Darkmoon Faire Prize Ticket
	[4596]="100:25:0:0:5:Potion::0:0:", -- Discolored Healing Potion
	[2687]="100:25:0:0:20:Food::0:1:797", -- Dry Pork Ribs
	[13930]="100:5:0:0:20:Food::0:0:", -- Filet of Redgill
	[1127]="100:25:0:0:10:::0:0:", -- Flash Bundle
	[724]="100:25:0:0:20:Food::0:0:", -- Goretusk Liver Pie
	[2633]="100:25:0:0:10:::0:0:", -- Jungle Remedy
	[858]="100:25:0:0:5:Potion::1:1:30,150,180,296,429,459,529,532,659,705", -- Lesser Healing Potion
	[6530]="100:25:0:0:20:Lure::1:0:23,27,47,48,107,113,120,121,139,141,162,166,178,203,205,208,246,255,263,277,291,305,323,333,395,404,451,457,466,467,468,475,478,495,507,528,529,538,552,567,578,579,605,625,626,638,663,672,702,711,716,717,718,722,752,754,757,763,766,803,816,833,838,840,852,854,881,889,893", -- Nightcrawlers
	[5740]="100:25:0:0:5:Firework::1:0:133,147,148,211,410,484,525,856,887", -- Red Fireworks Rocket
	[9314]="100:25:0:0:5:Firework::1:0:410,484,525,856,887", -- Red Streaks Firework
	[3013]="100:25:0:0:5:Scroll::1:1:4,150,659,695", -- Scroll of Protection
	[1181]="100:25:0:0:5:Scroll::1:1:4,150,659,695", -- Scroll of Spirit
	[2459]="100:25:0:0:5:Potion:164,165:0:0:", -- Swiftness Potion
	[2892]="120:30:0:0:10:Poison::0:0:", -- Deadly Poison
	[6950]="120:30:0:0:10:Poison::0:0:", -- Instant Poison III
	[3385]="120:30:0:0:5:Potion::1:1:45,73,116,152,318,414,501,505,636,659,845", -- Lesser Mana Potion
	[3387]="120:30:0:0:5:Potion::0:0:", -- Limited Invulnerability Potion
	[5631]="120:30:0:0:5:Potion::0:0:", -- Rage Potion
	[13754]="120:6:0:0:20:Food:185:0:0:", -- Raw Glossy Mightfish
	[2596]="120:30:0:0:20:Alcohol:185:1:0:51,57,104,179,188,229,294,366,402,425,431,433,456,554,633,688,709,710,749", -- Skin of Dwarven Stout
	[7676]="120:30:0:0:10:Potion::0:0:", -- Thistle Tea
	[11846]="120:30:0:0:20:Alcohol::0:0:", -- Wizbang's Special Brew
	[17404]="125:6:0:0:20:Drink::0:0:", -- Blended Bean Brew
	[414]="125:6:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Dalaran Sharp
	[17119]="125:6:0:0:20:Food::0:0:", -- Deeprun Rat Kabob
	[4541]="125:6:0:0:20:Food::5:0:56,62,95,132,143,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,455,477,502,506,537,561,579,585,586,603,612,615,624,633,710,726,728,749,764,779,854", -- Freshly Baked Bread
	[2287]="125:6:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Haunch of Meat
	[17406]="125:6:0:0:20:Food::0:0:", -- Holiday Cheesewheel
	[1179]="125:6:0:0:20:Drink:185:5:0:18,46,48,51,52,53,55,56,57,58,62,95,111,119,122,131,136,138,143,145,146,151,153,158,179,180,182,184,188,199,221,222,229,244,262,267,276,280,284,285,294,296,303,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,391,396,408,412,422,431,454,455,456,461,477,495,499,502,506,513,515,529,537,545,546,556,558,561,568,580,585,601,612,615,623,624,633,636,667,700,709,710,726,728,749,759,784,789,796,803,807,808,811,867,872,892", -- Ice Cold Milk
	[5095]="125:3:0:0:20:Food::0:0:", -- Rainbow Fin Albacore
	[4605]="125:6:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Red-speckled Mushroom
	[6890]="125:6:0:0:20:Food::0:0:", -- Smoked Bear Meat
	[19304]="125:6:0:0:20:Food::5:0:746", -- Spiced Beef Jerky
	[5205]="125:31:0:0:10:::0:0:", -- Sprouted Frond
	[18633]="125:6:0:0:20:Food::5:0:19,190", -- Styleen's Sour Suckerpop
	[4537]="125:6:0:0:20:Food::5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Tel'Abim Banana
	[16167]="125:6:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Versicolor Treat
	[6373]="140:35:0:0:5:Potion::0:0:", -- Elixir of Firepower
	[17708]="140:35:0:0:5:Potion::0:0:", -- Elixir of Frost Power
	[3390]="140:35:0:0:5:Potion:165:0:0:", -- Elixir of Lesser Agility
	[3386]="140:35:0:0:5:::0:0:", -- Elixir of Poison Resistance
	[9264]="140:35:0:0:5:Potion::0:0:", -- Elixir of Shadow Power
	[6372]="140:35:0:0:5:Potion::0:0:", -- Swim Speed Potion
	[13755]="140:7:0:0:20:Food:185:0:0:", -- Winter Squid
	[3703]="145:36:0:0:10:Alcohol::1:0:379", -- Southshore Stout
	[5206]="150:37:0:0:10:::0:0:", -- Bogling Root
	[4945]="150:37:0:0:1:::0:0:", -- Faintly Glowing Skull
	[2593]="150:37:0:0:20:Alcohol::1:0:51,57,104,179,188,229,294,366,402,425,431,433,456,554,633,688,709,710,749", -- Flask of Port
	[955]="150:37:0:0:5:Scroll::1:1:4,150,659,695", -- Scroll of Intellect
	[1180]="150:37:0:0:5:Scroll::1:1:4,150,659,695", -- Scroll of Stamina
	[17403]="150:37:0:0:20:Alcohol::0:0:", -- Steamwheedle Fizzy Spirits
	[9315]="150:37:0:0:5:Firework::1:0:410,484,525,856,887", -- Yellow Rose Firework
	[3220]="160:40:0:0:20:Food::0:0:", -- Blood Sausage
	[3389]="160:40:0:0:5:Potion:165:0:0:", -- Elixir of Defense
	[13928]="160:8:0:0:20:Food::0:0:", -- Grilled Squid
	[3388]="160:40:0:0:5:Potion::0:0:", -- Strong Troll's Blood Potion
	[5951]="165:41:0:0:10:::0:0:", -- Moist Towelette
	[10918]="170:42:0:0:10:Poison::0:0:", -- Wound Poison
	[1434]="175:43:0:0:20:::0:0:", -- Glowing Wax Stick
	[13756]="180:9:0:0:20:Food:185:0:0:", -- Raw Summer Bass
	[18287]="200:50:0:0:20:Alcohol::0:0:", -- Evermurky
	[13759]="200:10:0:0:20:Food:185:0:0:", -- Raw Nightfin Snapper
	[13760]="200:10:0:0:20:Food:185:0:0:", -- Raw Sunscale Salmon
	[3012]="200:50:0:0:5:Scroll::1:1:4,45,150,152,584,659,695", -- Scroll of Agility
	[954]="200:50:0:0:5:Scroll::1:1:4,45,150,152,584,659,695", -- Scroll of Strength
	[2893]="220:55:0:0:10:Poison::0:0:", -- Deadly Poison II
	[13888]="240:12:0:0:20:Food:185:0:0:", -- Darkclaw Lobster
	[13931]="240:12:0:0:20:Food::0:0:", -- Nightfin Soup
	[13932]="240:12:0:0:20:Food::0:0:", -- Poached Sunscale Salmon
	[6532]="250:62:0:0:20:Lure::1:0:47,107,113,120,121,139,141,162,178,203,205,208,255,263,277,291,305,323,333,395,404,451,457,467,468,475,478,507,528,538,552,567,578,605,625,626,638,663,702,711,716,717,718,722,752,754,757,763,803,833,838,840,852,881,889,893", -- Bright Baubles
	[7307]="250:62:0:0:20:Lure::0:0:", -- Flesh Eating Worm
	[6051]="250:62:0:0:5:::0:0:", -- Holy Protection Potion
	[9317]="250:62:0:0:5:Firework::1:0:410,484,525,856,887", -- Red, White and Blue Firework
	[1478]="250:62:0:0:5:Scroll::1:1:4,45,152,584", -- Scroll of Protection II
	[1712]="250:62:0:0:5:Scroll::1:1:4,45,152,584,695", -- Scroll of Spirit II
	[4952]="255:63:0:0:10:::0:0:", -- Stormstout
	[10920]="270:67:0:0:10:Poison::0:0:", -- Wound Poison II
	[1322]="275:68:0:0:10:::0:0:", -- Fishliver Oil
	[5478]="280:70:0:0:20:Food::0:0:", -- Dig Rat Stew
	[13933]="280:14:0:0:20:Food::0:0:", -- Lobster Stew
	[5526]="300:75:0:0:20:Food::0:0:", -- Clam Chowder
	[5634]="300:75:0:0:5:Potion::0:0:", -- Free Action Potion
	[929]="300:75:0:0:5:Potion:197:1:1:45,73,116,152,157,318,414,482,505,584,636,696,845", -- Healing Potion
	[8926]="300:75:0:0:10:Poison::0:0:", -- Instant Poison IV
	[4595]="300:75:0:0:10:Alcohol::1:0:633", -- Junglevine Wine
	[6951]="300:75:0:0:10:Poison::0:0:", -- Mind-numbing Poison II
	[2290]="300:75:0:0:5:Scroll::1:1:4,45,152,584,659,695", -- Scroll of Intellect II
	[1711]="300:75:0:0:5:Scroll::1:1:4,45,152,584,659,695", -- Scroll of Stamina II
	[2685]="300:75:0:0:20:Food::0:0:", -- Succulent Pork Ribs
	[1703]="325:81:0:0:10:::0:0:", -- Crystal Basilisk Spine
	[1191]="330:82:0:0:1:::0:0:", -- Bag of Marbles
	[4600]="340:85:0:0:20:Alcohol::1:0:104,633,807", -- Cherry Grog
	[10841]="340:85:0:0:20:Drink::0:0:", -- Goldthorn Tea
	[1477]="350:87:0:0:5:Scroll::1:1:659", -- Scroll of Agility II
	[2289]="350:87:0:0:5:Scroll::1:1:659", -- Scroll of Strength II
	[5342]="355:88:0:0:10:::0:0:", -- Raptor Punch
	[4953]="355:88:0:0:10:::0:0:", -- Trogg Ale
	[6662]="380:95:0:0:5:Potion::0:0:", -- Elixir of Giant Growth
	[5996]="380:95:0:0:5:::0:0:", -- Elixir of Water Breathing
	[5527]="380:95:0:0:20:Food::0:1:797", -- Goblin Deviled Clams
	[5480]="380:95:0:0:20:Food::0:0:", -- Lean Venison
	[12209]="380:95:0:0:20:Food::0:0:", -- Lean Wolf Steak
	[13881]="400:100:0:0:1:::0:0:", -- Bloated Redgill
	[3664]="400:100:0:0:20:Food::0:0:", -- Crocolisk Gumbo
	[8984]="400:100:0:0:10:Poison::0:0:", -- Deadly Poison III
	[3383]="400:100:0:0:5:Potion:165,197:0:0:", -- Elixir of Wisdom
	[3666]="400:100:0:0:20:Food::0:0:", -- Gooey Spider Cake
	[13459]="400:100:0:0:5:Potion::0:0:", -- Greater Shadow Protection Potion
	[8927]="400:100:0:0:10:Poison::0:0:", -- Instant Poison V
	[3823]="400:100:0:0:5:Potion:164:0:0:", -- Lesser Invisibility Potion
	[4421]="400:100:0:0:5:Scroll::1:1:659", -- Scroll of Protection III
	[4424]="400:100:0:0:5:Scroll::1:1:659", -- Scroll of Spirit III
	[1017]="400:100:0:0:20:Food::0:0:", -- Seasoned Wolf Kabob
	[6048]="400:100:0:0:5::197,333:0:0:", -- Shadow Protection Potion
	[733]="400:100:0:0:20:Food::0:0:", -- Westfall Stew
	[3826]="420:105:0:0:5:Potion::0:0:", -- Mighty Troll's Blood Potion
	[3825]="440:110:0:0:5:Potion::0:0:", -- Elixir of Fortitude
	[1262]="445:111:0:0:1:::0:0:", -- Keg of Thunderbrew Lager
	[4419]="450:112:0:0:5:Scroll::0:0:", -- Scroll of Intellect III
	[4422]="450:112:0:0:5:Scroll::0:0:", -- Scroll of Stamina III
	[6149]="480:120:0:0:5:Potion::1:1:97,194,534,629,676,691,785", -- Greater Mana Potion
	[3827]="480:120:0:0:5:Potion:197:1:1:9,93,171,249,409,611,819", -- Mana Potion
	[1970]="480:120:0:0:10:::0:0:", -- Restoring Balm
	[3726]="500:125:0:0:20:Food::0:0:", -- Big Bear Steak
	[4593]="500:4:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Bristle Whisker Catfish
	[9451]="500:25:0:0:20:Drink::0:0:", -- Bubbling Water
	[5479]="500:125:0:0:20:Food::0:0:", -- Crispy Lizard Tail
	[422]="500:25:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Dwarven Mild
	[19299]="500:25:0:0:20:Drink::5:0:755", -- Fizzy Faire Drink
	[1710]="500:125:0:0:5:Potion::1:1:9,87,93,171,249,611,819", -- Greater Healing Potion
	[3727]="500:125:0:0:20:Food::0:0:", -- Hot Lion Chops
	[8928]="500:125:0:0:10:Poison::0:0:", -- Instant Poison VI
	[1205]="500:25:0:0:20:Drink::5:0:18,42,46,51,52,53,55,56,57,58,62,95,106,111,115,119,122,131,136,143,145,146,151,153,158,179,182,184,188,199,221,222,229,244,262,263,265,267,276,280,284,285,294,303,305,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,391,396,408,412,422,428,431,454,455,456,461,477,495,499,502,506,513,515,529,537,545,546,556,558,561,568,580,585,601,612,615,622,623,624,633,636,675,700,709,710,726,728,749,759,784,789,796,803,807,808,811,825,837,892", -- Melon Juice
	[4542]="500:25:0:0:20:Food::5:0:56,62,95,132,143,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,455,477,502,506,537,561,579,585,586,603,612,615,624,633,710,726,728,749,764,779,854", -- Moist Cornbread
	[3663]="500:125:0:0:20:Food::0:0:", -- Murloc Fin Soup
	[3770]="500:25:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Mutton Chop
	[19305]="500:25:0:0:20:Food::5:0:746", -- Pickled Kodo Foot
	[4425]="500:125:0:0:5:Scroll::0:0:", -- Scroll of Agility III
	[4426]="500:125:0:0:5:Scroll::0:0:", -- Scroll of Strength III
	[4538]="500:25:0:0:20:Food::5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Snapvine Watermelon
	[4606]="500:25:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Spongy Morel
	[16170]="500:25:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Steamed Mandu
	[17349]="500:125:0:0:10:::1:0:224,287,416,774", -- Superior Healing Draught
	[17352]="500:125:0:0:10:Potion::1:0:224,287,416,774", -- Superior Mana Draught
	[7228]="500:25:0:0:20:Food::5:0:19,190", -- Tigule and Foror's Strawberry Ice Cream
	[10921]="500:125:0:0:10:Poison::0:0:", -- Wound Poison III
	[4791]="535:133:0:0:20:Drink::0:0:", -- Enchanted Water
	[10305]="550:100:0:0:5:Scroll::0:0:", -- Scroll of Protection IV
	[10306]="550:100:0:0:5:Scroll::0:0:", -- Scroll of Spirit IV
	[10592]="600:150:0:0:5:Potion:202:0:0:", -- Catseye Elixir
	[3665]="600:150:0:0:20:Food::0:0:", -- Curiously Tasty Omelet
	[11325]="600:150:0:0:20:::0:0:", -- Dark Iron Ale Mug
	[8985]="600:150:0:0:10:Poison::0:0:", -- Deadly Poison IV
	[3828]="600:150:0:0:5:Potion::0:0:", -- Elixir of Detect Lesser Invisibility
	[3829]="600:150:0:0:5::164,197,202,333:0:0:", -- Frost Oil
	[5633]="600:150:0:0:5:Potion:165:0:0:", -- Great Rage Potion
	[1082]="600:150:0:0:20:Food::0:0:", -- Redridge Goulash
	[10308]="600:112:0:0:5:Scroll::0:0:", -- Scroll of Intellect IV
	[10307]="600:112:0:0:5:Scroll::0:0:", -- Scroll of Stamina IV
	[3824]="600:150:0:0:5::165,164,171,197:0:0:", -- Shadow Oil
	[10309]="650:125:0:0:5:Scroll::0:0:", -- Scroll of Agility IV
	[10310]="650:125:0:0:5:Scroll::0:0:", -- Scroll of Strength IV
	[6049]="680:170:0:0:5:::0:0:", -- Fire Protection Potion
	[3776]="700:175:0:0:10:Poison::0:0:", -- Crippling Poison II
	[9186]="700:175:0:0:10:Poison::0:0:", -- Mind-numbing Poison III
	[10922]="700:175:0:0:10:Poison::0:0:", -- Wound Poison IV
	[4481]="705:176:0:0:10:::0:0:", -- Cresting Charm
	[4479]="715:178:0:0:10:::0:0:", -- Burning Charm
	[4480]="740:185:0:0:10:::0:0:", -- Thundering Charm
	[8949]="800:200:0:0:5:Potion:165:0:0:", -- Elixir of Agility
	[8951]="800:200:0:0:5:Potion:165:0:0:", -- Elixir of Greater Defense
	[2313]="800:200:0:0:10:::0:0:", -- Medium Armor Kit
	[8956]="800:200:0:0:5:::0:0:", -- Oil of Immolation
	[9030]="800:200:0:0:5:::0:0:", -- Restorative Potion
	[4598]="850:212:0:0:10:::0:1:717", -- Goblin Fishing Pole
	[2091]="855:213:0:0:10:::0:0:", -- Magic Dust
	[18839]="1000:250:0:0:5:Potion::0:0:", -- Combat Healing Potion
	[12003]="1000:250:0:0:20:Alcohol::0:0:", -- Dark Dwarven Lager
	[4607]="1000:50:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Delicious Cave Mold
	[12190]="1000:250:0:0:5:::0:0:", -- Dreamless Sleep Potion
	[18294]="1000:250:0:0:5:Potion::0:0:", -- Elixir of Greater Water Breathing
	[9088]="1000:250:0:0:5:::0:0:", -- Gift of Arthas
	[4539]="1000:50:0:0:20:Food::5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Goldenbark Apple
	[17407]="1000:50:0:0:20:Food::0:0:", -- Graccu's Homemade Meat Pie
	[17405]="1000:50:0:0:20:Drink::0:0:", -- Green Garden Tea
	[9681]="1000:50:0:0:20:Food::0:0:", -- Grilled King Crawler Legs
	[17348]="1000:250:0:0:10:::1:0:224,287,416,774", -- Major Healing Draught
	[17351]="1000:250:0:0:10:Potion::1:0:224,287,416,774", -- Major Mana Draught
	[18288]="1000:250:0:0:20:Alcohol::0:0:", -- Molasses Firewater
	[18632]="1000:50:0:0:20:Food::5:0:19,190", -- Moonbrook Riot Taffy
	[4544]="1000:50:0:0:20:Food::5:0:56,62,95,132,143,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,455,477,502,506,537,561,579,585,586,603,612,615,624,633,710,726,728,749,764,779,854", -- Mulgore Spice Bread
	[13889]="1000:5:0:0:20:Food:185:0:0:", -- Raw Whitescale Salmon
	[19224]="1000:50:0:0:20:Food::5:0:746", -- Red Hot Wings
	[4594]="1000:6:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Rockscale Cod
	[19026]="1000:250:0:0:10:Firework::0:0:", -- Snake Bloom Firework
	[1707]="1000:62:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Stormwind Brie
	[3928]="1000:250:0:0:5:Potion::1:1:97,194,534,629,659,676,691,785", -- Superior Healing Potion
	[1708]="1000:50:0:0:20:Drink::5:0:18,42,46,51,52,53,55,56,57,58,62,95,106,111,115,119,131,136,143,145,146,151,153,158,179,182,184,188,199,221,222,229,244,262,263,265,276,280,285,294,305,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,391,396,422,428,431,454,455,456,461,477,499,502,506,513,515,537,545,556,558,561,568,580,585,601,612,615,622,624,633,636,675,700,709,710,726,728,749,759,784,789,796,803,807,808,811,825,837,892", -- Sweet Nectar
	[19062]="1000:50:0:0:20:::5:0:353,461", -- Warsong Gulch Field Ration
	[3771]="1000:50:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Wild Hog Shank
	[16169]="1000:62:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Wild Ricecake
	[9144]="1000:250:0:0:5:Potion::0:0:", -- Wildvine Potion
	[18841]="1100:275:0:0:5:Potion::0:0:", -- Combat Mana Potion
	[13935]="1200:10:0:0:20:Food::0:0:", -- Baked Salmon
	[4457]="1200:300:0:0:20:Food::0:0:", -- Barbecued Buzzard Wing
	[12213]="1200:300:0:0:20:Food::0:0:", -- Carrion Surprise
	[16971]="1200:300:0:0:20:Food::0:0:", -- Clamlette Surprise
	[12217]="1200:300:0:0:20:::0:0:", -- Dragonbreath Chili
	[9154]="1200:300:0:0:5:Potion::0:0:", -- Elixir of Detect Undead
	[6050]="1200:300:0:0:5:::0:0:", -- Frost Protection Potion
	[12215]="1200:300:0:0:20:Food::0:0:", -- Heavy Kodo Stew
	[12212]="1200:300:0:0:20:Food::0:0:", -- Jungle Stew
	[12218]="1200:300:0:0:20:Food::0:0:", -- Monster Omelet
	[12214]="1200:300:0:0:20:Food::0:0:", -- Mystery Stew
	[6052]="1200:300:0:0:5:::0:0:", -- Nature Protection Potion
	[12210]="1200:300:0:0:20:Food::0:0:", -- Roast Raptor
	[3729]="1200:300:0:0:20:Food::0:0:", -- Soothing Turtle Bisque
	[12216]="1200:300:0:0:20:Food::0:0:", -- Spiced Chili Crab
	[17222]="1200:300:0:0:20:Food::0:0:", -- Spider Sausage
	[3728]="1200:300:0:0:20:Food::0:0:", -- Tasty Lion Steak
	[18045]="1200:300:0:0:20:Food::0:0:", -- Tender Wolf Steak
	[13546]="1250:62:0:0:20:Food::0:0:", -- Bloodbelly Fish
	[6807]="1250:62:0:0:20:Food::0:0:", -- Frog Leg Stew
	[6038]="1250:312:0:0:20:Food::0:0:", -- Giant Clam Scorcho
	[13851]="1250:312:0:0:20:Food::0:0:", -- Hot Wolf Ribs
	[8364]="1250:6:0:0:20:Food::0:0:", -- Mithril Head Trout
	[2594]="1500:375:0:0:20:Alcohol::1:0:51,57,104,179,188,229,294,366,371,402,425,431,433,456,554,580,633,688,709,710,749", -- Flagon of Mead
	[4623]="1500:375:0:0:5:Potion::0:0:", -- Lesser Stoneshield Potion
	[9155]="1600:400:0:0:5:Potion::0:0:", -- Arcane Elixir
	[9360]="1600:400:0:0:1:Alcohol::0:0:", -- Cuergo's Gold
	[9361]="1600:400:0:0:1:Alcohol::0:0:", -- Cuergo's Gold with Worm
	[17048]="1600:400:0:0:10:::0:0:", -- Rumsey Rum
	[13443]="1600:400:0:0:5:Potion::1:1:659", -- Superior Mana Potion
	[9260]="1600:400:0:0:10:Alcohol:171:0:0:", -- Volatile Rum
	[5816]="1620:405:0:0:1:::0:0:", -- Light of Elune
	[18635]="2000:100:0:0:20:Food::5:0:19,190", -- Bellara's Nutterbar
	[19300]="2000:100:0:0:20:Drink::5:0:755", -- Bottled Winterspring Water
	[10684]="2000:500:0:0:1:::0:0:", -- Colossal Parachute
	[19306]="2000:100:0:0:20:Food::5:0:746", -- Crunchy Frog
	[4599]="2000:100:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Cured Ham Steak
	[9233]="2000:500:0:0:5:Potion::0:0:", -- Elixir of Detect Demon
	[13445]="2000:500:0:0:5:Potion::0:0:", -- Elixir of Superior Defense
	[3927]="2000:150:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Fine Aged Cheddar
	[17402]="2000:500:0:0:20:Alcohol::0:0:", -- Greatfather's Winter Ale
	[16168]="2000:100:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Heaven Peach
	[9172]="2000:500:0:0:5:Potion::0:0:", -- Invisibility Potion
	[2595]="2000:500:0:0:20:Alcohol::1:0:51,57,104,179,188,229,294,366,402,425,431,433,456,554,633,688,709,710,749", -- Jug of Bourbon
	[13442]="2000:500:0:0:5:Potion::0:0:", -- Mighty Rage Potion
	[4602]="2000:100:0:0:20:Food::5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Moon Harvest Pumpkin
	[1645]="2000:100:0:0:20:Drink::5:0:18,42,46,51,52,53,55,56,57,58,62,95,106,111,115,119,131,136,143,145,146,151,153,158,179,182,184,188,199,221,222,229,244,262,263,265,276,280,285,294,305,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,391,396,422,428,431,454,455,456,461,477,499,502,506,513,515,537,545,556,558,561,568,580,585,601,612,615,622,624,633,636,675,700,709,710,726,728,749,759,784,789,796,803,807,808,811,825,837,892", -- Moonberry Juice
	[4608]="2000:100:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Raw Black Truffle
	[17747]="2000:500:0:0:5:::0:0:", -- Razorlash Root
	[4601]="2000:100:0:0:20:Food::5:0:56,62,95,132,143,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,455,477,502,506,537,561,579,585,586,603,612,615,624,633,710,726,728,749,764,779,854", -- Soft Banana Bread
	[17408]="2000:100:0:0:20:Food::0:0:", -- Spicy Beefstick
	[6887]="2000:5:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Spotted Yellowtail
	[16766]="2000:100:0:0:20:Food::0:0:", -- Undermine Clam Chowder
	[4546]="2135:533:0:0:1:::0:0:", -- Call of the Raptor
	[9197]="2400:600:0:0:5:::0:0:", -- Elixir of Dream Vision
	[9187]="2400:600:0:0:5:Potion::0:0:", -- Elixir of Greater Agility
	[5421]="2600:650:0:0:1:::0:0:", -- Fiery Enchantment
	[4265]="2600:650:0:0:10:::0:0:", -- Heavy Armor Kit
	[9224]="2800:700:0:0:5:Potion:333:0:0:", -- Elixir of Demonslaying
	[9206]="2800:700:0:0:5:Potion::0:0:", -- Elixir of Giants
	[11885]="2846:711:0:0:1:::0:0:", -- Shadowforge Torch
	[13454]="3000:750:0:0:5:Potion::0:0:", -- Greater Arcane Elixir
	[13461]="3000:750:0:0:5:Potion::0:0:", -- Greater Arcane Protection Potion
	[13457]="3000:750:0:0:5:Potion::0:0:", -- Greater Fire Protection Potion
	[13456]="3000:750:0:0:5:Potion::0:0:", -- Greater Frost Protection Potion
	[13458]="3000:750:0:0:5:Potion::0:0:", -- Greater Nature Protection Potion
	[13455]="3000:750:0:0:5:Potion::0:0:", -- Greater Stoneshield Potion
	[10830]="3000:750:0:0:10:::0:0:", -- M73 Frag Grenade
	[13462]="3000:750:0:0:5:Potion::0:0:", -- Purification Potion
	[8959]="3200:160:0:0:20:Food::0:0:", -- Raw Spinefin Halibut
	[8529]="3500:175:0:0:20:::0:0:", -- Noggenfogger Elixir
	[8932]="4000:200:0:0:20:Food::5:0:51,56,58,62,95,132,177,182,222,356,357,359,365,381,385,455,624,726,807", -- Alterac Swiss
	[19225]="4000:200:0:0:20:Food::5:0:746", -- Deep Fried Candybar
	[8953]="4000:200:0:0:20:Food::5:0:18,65,95,131,143,151,177,342,362,364,383,509,515,556,610,710,715,749", -- Deep Fried Plantains
	[8948]="4000:200:0:0:20:Food::5:0:111,296,304,324,360,377,378,396,405,486,703,710,726,749", -- Dried King Bolete
	[9179]="4000:1000:0:0:5:Potion::0:0:", -- Elixir of Greater Intellect
	[11444]="4000:200:0:0:20:Food::0:0:", -- Grim Guzzler Boar
	[8950]="4000:200:0:0:20:Food::5:0:56,62,95,132,143,177,262,272,276,285,343,358,359,361,367,369,372,374,376,377,384,422,455,477,502,506,537,561,579,585,586,603,612,615,624,633,710,726,728,744,749,764,779,854", -- Homemade Cherry Pie
	[13446]="4000:1000:0:0:5:Potion::1:1:37,39,40,237,668", -- Major Healing Potion
	[11415]="4000:200:0:0:20:Food::0:0:", -- Mixed Berries
	[8766]="4000:200:0:0:20:Drink::5:0:18,51,52,53,55,56,57,58,62,95,111,131,143,145,146,151,153,158,179,182,188,221,222,229,244,262,276,280,285,294,311,319,324,340,353,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,386,387,396,422,431,455,456,461,477,499,502,506,513,515,537,545,556,561,568,580,585,601,612,615,624,633,636,709,710,726,728,749,759,784,796,807,811,892", -- Morning Glory Dew
	[8952]="4000:200:0:0:20:Food::5:0:56,80,95,99,122,132,153,158,177,226,229,280,294,300,311,340,366,368,371,373,375,379,380,386,461,494,499,568,580,615,617,636,642,710,721,726,732,738,749,784,797,799,807,811,817,827,878,883,892", -- Roasted Quail
	[15564]="4000:1000:0:0:10:::0:0:", -- Rugged Armor Kit
	[16171]="4000:200:0:0:20:Food::5:0:18,143,146,151,221,353,545,556,561,601,796", -- Shinsollo
	[8957]="4000:200:0:0:20:Food::5:0:95,145,244,276,301,319,331,340,363,370,382,383,387,468,475,492,508,513,726,752,833,851,852", -- Spinefin Halibut
	[8173]="4000:1000:0:0:10:::0:0:", -- Thick Armor Kit
	[19318]="5000:250:0:0:20:::5:0:224,287,416,774", -- Bottled Alterac Spring Water
	[13453]="5000:1250:0:0:5:Potion::0:0:", -- Elixir of Brute Force
	[13452]="5000:1250:0:0:5:Potion::0:0:", -- Elixir of the Mongoose
	[13447]="5000:1250:0:0:5:Potion::0:0:", -- Elixir of the Sages
	[13810]="6000:300:0:0:20:::5:0:39,40,668", -- Blessed Sunfruit
	[13813]="6000:300:0:0:20:::5:0:39,40,668", -- Blessed Sunfruit Juice
	[13724]="6000:300:0:0:20:::5:0:39,40,668", -- Enriched Manna Biscuit
	[13444]="6000:1500:0:0:5:Potion::1:1:37,39,40,668", -- Major Mana Potion
	[19301]="7000:350:0:0:20:::5:0:224,287,416,774", -- Alterac Manna Biscuit
	[13513]="20000:5000:0:0:5:::0:0:", -- Flask of Chromatic Resistance
	[13511]="20000:5000:0:0:5:::0:0:", -- Flask of Distilled Wisdom
	[13506]="20000:5000:0:0:5:::0:0:", -- Flask of Petrification
	[13512]="20000:5000:0:0:5:::0:0:", -- Flask of Supreme Power
	[13510]="20000:5000:0:0:5:::0:0:", -- Flask of the Titans
	[18606]="50000:12500:0:0:1:::0:0:", -- Alliance Battle Standard
	[18607]="50000:12500:0:0:1:::0:0:", -- Horde Battle Standard
	[18258]="0:0:0:0:1:::0:0:", -- Gordok Ogre Suit
	[18269]="1500:375:0:0:10:::0:0:", -- Gordok Green Grog
	[18284]="1500:375:0:0:10:::0:0:", -- Kreeg's Stout Beatdown
	[1187]="4325:1081:0:0:1:::0:0:", -- Spiked Collar
	[15778]="5000:1250:0:0:1:::0:0:", -- Mechanical Yeti
	[15723]="11300:2825:0:0:1:::0:0:", -- Tea with Sugar
	[13508]="19115:4778:0:0:1:::0:0:", -- Eye of Arachnida
	[13509]="21573:5393:0:0:1:::0:0:", -- Clutch of Foresight
	[13514]="23280:5820:0:0:1:::0:0:", -- Wail of the Banshee
	[3456]="25500:6375:0:0:1:::0:0:", -- Dog Whistle
	[18251]="20000:5000:0:0:10:::0:0:", -- Core Armor Kit
	[19045]="50000:12500:0:0:1:::1:0:224,774", -- Stormpike Battle Standard
	[19142]="75615:18903:0:0:1:::0:0:", -- Fire Runed Grimoire
	[11845]="250:62:1:0:1:::0:0:", -- Handmade Leather Bag
	[1537]="250:62:1:0:1:::0:0:", -- Old Blanchy's Feed Pouch
	[4496]="500:125:1:0:1:::1:0:11,22,48,51,94,119,122,138,167,180,184,199,261,267,296,403,412,436,439,491,495,529,587,594,650,653,667,789,803,808,867,872", -- Small Brown Pouch
	[4238]="800:200:1:0:1:::0:0:", -- Linen Bag
	[3233]="850:212:1:0:1:::0:0:", -- Gnoll Hide Sack
	[5081]="1000:250:1:0:1:::0:0:", -- Kodo Hide Bag
	[4957]="1000:250:1:0:1:::0:0:", -- Old Moneybag
	[5762]="1000:250:1:0:1:::0:0:", -- Red Linen Bag
	[5571]="1000:250:1:0:1:::0:0:", -- Small Black Pouch
	[828]="1000:250:1:0:1:::0:0:", -- Small Blue Pouch
	[5572]="1000:250:1:0:1:::0:0:", -- Small Green Pouch
	[805]="1000:250:1:0:1:::0:0:", -- Small Red Pouch
	[2082]="1000:250:1:0:1:::0:0:", -- Wizbang's Gunnysack
	[4240]="1200:300:1:0:1:::0:0:", -- Woolen Bag
	[3343]="1800:450:1:0:1:::0:0:", -- Captain Sander's Booty Bag
	[4241]="1800:450:1:0:1:::0:0:", -- Green Woolen Bag
	[1729]="2000:500:1:0:1:::0:0:", -- Gunnysack of the Night Watch
	[6446]="2130:532:1:0:1:::0:0:", -- Snakeskin Bag
	[4498]="2500:625:1:0:1:::1:0:11,22,42,46,48,51,94,95,106,111,115,119,122,131,136,138,167,180,184,199,261,263,265,267,284,296,303,305,311,391,403,408,412,428,436,439,454,491,495,529,546,558,568,587,594,622,623,650,653,667,675,700,789,803,808,825,837,867,872", -- Brown Leather Satchel
	[932]="2550:637:1:0:1:::0:0:", -- Fel Steed Saddlebags
	[5763]="2800:700:1:0:1:::0:0:", -- Red Woolen Bag
	[856]="3500:875:1:0:1:::0:0:", -- Blue Leather Bag
	[5573]="3500:875:1:0:1:::0:0:", -- Green Leather Bag
	[1470]="3500:875:1:0:1:::0:0:", -- Murloc Skin Bag
	[2657]="3500:875:1:0:1:::0:0:", -- Red Leather Bag
	[5574]="3500:875:1:0:1:::0:0:", -- White Leather Bag
	[918]="5000:1250:1:0:1:::0:0:", -- Deviate Hide Pack
	[3352]="5000:1250:1:0:1:::0:0:", -- Ooze-covered Bag
	[6756]="5500:1375:1:0:1:::0:0:", -- Jewelry Box
	[4245]="8000:2000:1:0:1:::0:0:", -- Small Silk Pack
	[804]="10000:2500:1:0:1:::0:0:", -- Large Blue Sack
	[5576]="10000:2500:1:0:1:::0:0:", -- Large Brown Sack
	[5575]="10000:2500:1:0:1:::0:0:", -- Large Green Sack
	[857]="10000:2500:1:0:1:::0:0:", -- Large Red Sack
	[933]="10000:2500:1:0:1:::0:0:", -- Large Rucksack
	[10050]="10000:2500:1:0:1:::0:0:", -- Mageweave Bag
	[10051]="10000:2500:1:0:1:::0:0:", -- Red Mageweave Bag
	[5764]="12000:3000:1:0:1:::0:0:", -- Green Silk Pack
	[5765]="16000:4000:1:0:1:::0:0:", -- Black Silk Pack
	[4497]="20000:5000:1:0:1:::1:0:22,42,46,95,106,111,115,119,131,136,184,199,261,263,265,284,303,305,311,391,408,428,439,454,546,558,568,622,623,650,653,675,700,789,803,808,825,837", -- Heavy Brown Bag
	[1725]="20000:5000:1:0:1:::0:0:", -- Large Knapsack
	[14046]="20000:5000:1:0:1:::0:0:", -- Runecloth Bag
	[1652]="20000:5000:1:0:1:::0:0:", -- Sturdy Lunchbox
	[11324]="25000:6250:1:0:1:::0:0:", -- Explorer's Knapsack
	[3914]="25000:6250:1:0:1:::0:0:", -- Journeyman's Backpack
	[9587]="25000:6250:1:0:1:::0:0:", -- Thawpelt Sack
	[1685]="25000:6250:1:0:1:::0:0:", -- Troll-hide Bag
	[19291]="100000:25000:1:0:1:::0:0:", -- Darkmoon Storage Box
	[4499]="100000:25000:1:0:1:::1:1:22,261,650,653", -- Huge Brown Sack
	[10959]="35000:8750:1:0:1:::0:0:", -- Demon Hide Sack
	[17966]="35000:8750:1:0:1:::0:0:", -- Onyxia Hide Backpack
	[4500]="35000:8750:1:0:1:::0:0:", -- Traveler's Backpack
	[11742]="35000:8750:1:0:1:::0:0:", -- Wayfarer's Knapsack
	[14155]="80000:20000:1:0:1:::0:0:", -- Mooncloth Bag
	[14156]="160000:40000:1:0:1:::0:0:", -- Bottomless Bag
	[1416]="364:72:2:0:1:::0:0:", -- Rusty Hatchet
	[1516]="1185:237:2:0:1:::0:0:", -- Worn Hatchet
	[1816]="2432:486:2:0:1:::0:0:", -- Unbalanced Axe
	[1819]="3840:768:2:0:1:::0:0:", -- Gouging Pick
	[1827]="6412:1282:2:0:1:::0:0:", -- Meat Cleaver
	[3785]="18250:3650:2:0:1:::0:0:", -- Keen Axe
	[4019]="41683:8336:2:0:1:::0:0:", -- Heavy Flint Axe
	[13818]="67157:13431:2:0:1:::0:0:", -- Jagged Axe
	[37]="38:7:2:0:1:::0:0:", -- Worn Axe
	[3293]="58:11:2:0:1:::0:0:", -- Deadman Cleaver
	[2054]="80:16:2:0:1:::0:0:", -- Trogg Hand Axe
	[2134]="82:16:2:0:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Hand Axe
	[1383]="126:25:2:0:1:::0:0:", -- Stone Tomahawk
	[4923]="128:25:2:0:1:::0:0:", -- Primitive Hatchet
	[2047]="129:25:2:0:1:::0:0:", -- Anvilmar Hand Axe
	[778]="278:55:2:0:1:::0:0:", -- Kobold Excavation Pick
	[1011]="400:80:2:0:1:::0:0:", -- Sharp Axe
	[2066]="407:81:2:0:1:::0:0:", -- Skull Hatchet
	[2260]="532:106:2:0:1:::0:0:", -- Frostmane Hand Axe
	[2490]="540:108:2:0:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,812,814,823", -- Tomahawk
	[2845]="546:109:2:0:1:::0:0:", -- Copper Axe
	[768]="567:113:2:0:1:::0:0:", -- Lumberjack Axe
	[3443]="691:138:2:0:1:::0:0:", -- Ceremonial Tomahawk
	[3071]="1155:231:2:0:1:::0:0:", -- Striking Hatchet
	[853]="2409:481:2:0:1:::1:0:88,274,292,329,393,429,532,560,613,614,823,886", -- Hatchet
	[2029]="4419:883:2:0:1:::1:0:88,231,274,292,329,390,560,886", -- Cleaver
	[2849]="6345:1269:2:0:1:::0:0:", -- Bronze Axe
	[927]="6953:1390:2:0:1:::1:0:1,84,85,88,231,292,329,560,646,865,886", -- Double Axe
	[2522]="22548:4509:2:0:1:::1:0:20,88,297,329,448,563,665,836,865,882,894", -- Crescent Axe
	[2530]="52219:10443:2:0:1:::1:0:20,88,202,288,297,327,329,448,574,745,855", -- Francisca
	[2281]="1504:300:2:0:1:::0:0:", -- Rodentia Flint Axe
	[4561]="1546:309:2:0:1:::0:0:", -- Scalping Tomahawk
	[5459]="2361:472:2:0:1:::0:0:", -- Defender Axe
	[2265]="2387:477:2:0:1:::0:0:", -- Stonesplinter Axe
	[5344]="2812:562:2:0:1:::0:0:", -- Pointed Axe
	[6978]="3363:672:2:0:1:::0:0:", -- Umbral Axe
	[6979]="3376:675:2:0:1:::0:0:", -- Haggard's Axe
	[7115]="3415:683:2:0:1:::0:0:", -- Heirloom Axe
	[1927]="3451:690:2:0:1:::0:0:", -- Deadmines Cleaver
	[6966]="3468:693:2:0:1:::0:0:", -- Elunite Axe
	[7326]="3480:696:2:0:1:::0:0:", -- Thun'grim's Axe
	[826]="3661:732:2:0:1:::0:0:", -- Brutish Riverpaw Axe
	[2073]="3713:742:2:0:1:::0:0:", -- Dwarven Hatchet
	[3489]="4688:937:2:0:1:::0:0:", -- Thick War Axe
	[3154]="5470:1094:2:0:1:::0:0:", -- Thelsamar Axe
	[4568]="8474:1694:2:0:1:::0:0:", -- Grunt Axe
	[4949]="8532:1706:2:0:1:::0:0:", -- Orcish Cleaver
	[5196]="9154:1830:2:0:1:::0:0:", -- Smite's Reaver
	[790]="10101:2020:2:0:1:::0:0:", -- Forester's Axe
	[4445]="10341:2068:2:0:1:::0:0:", -- Flesh Carver
	[885]="11504:2300:2:0:1:::0:0:", -- Black Metal Axe
	[1459]="11902:2380:2:0:1:::0:0:", -- Shadowhide Scalper
	[15230]="13778:2755:2:0:1:::0:0:", -- Ridge Cleaver
	[4826]="15436:3087:2:0:1:::1:1:116,148,646,652,802", -- Marauder Axe
	[4824]="16856:3371:2:0:1:::1:1:116,148,646,652", -- Blurred Axe
	[4825]="20472:4094:2:0:1:::1:1:116,148,646,652,802", -- Callous Axe
	[17046]="23983:4796:2:0:1:::0:0:", -- Gutterblade
	[9608]="25144:5028:2:0:1:::0:0:", -- Shoni's Disarming Tool
	[15231]="25166:5033:2:0:1:::0:0:", -- Splitting Hatchet
	[6194]="26543:5308:2:0:1:::0:0:", -- Barreling Reaper
	[3755]="27236:5447:2:0:1:::0:0:", -- Fish Gutter
	[15232]="30561:6112:2:0:1:::0:0:", -- Hacking Cleaver
	[4126]="31980:6396:2:0:1:::0:0:", -- Guerrilla Cleaver
	[2080]="32954:6590:2:0:1:::0:0:", -- Hillborne Axe
	[6738]="35203:7040:2:0:1:::0:0:", -- Bleeding Crescent
	[2044]="36787:7357:2:0:1:::0:0:", -- Crescent of Forlorn Spirits
	[863]="44820:8964:2:0:1:::0:0:", -- Gloom Reaper
	[17704]="45890:9178:2:0:1:::0:0:", -- Edge of Winter
	[15233]="52380:10476:2:0:1:::0:0:", -- Savage Axe
	[15234]="56770:11354:2:0:1:::0:0:", -- Greater Scythe
	[10772]="60853:12170:2:0:1:::0:0:", -- Glutton's Cleaver
	[7941]="62601:12520:2:0:1:::0:0:", -- Heavy Mithril Axe
	[7942]="73296:14659:2:0:1:::0:0:", -- Blue Glittering Axe
	[1994]="83480:16696:2:0:1:::0:0:", -- Ebonclaw Reaver
	[15235]="105454:21090:2:0:1:::0:0:", -- Crescent Edge
	[10744]="120797:24159:2:0:1:::0:0:", -- Axe of the Ebon Drake
	[9684]="128648:25729:2:0:1:::0:0:", -- Force of the Hippogryph
	[15236]="137428:27485:2:0:1:::0:0:", -- Moon Cleaver
	[15862]="143946:28789:2:0:1:::0:0:", -- Blitzcleaver
	[10805]="148309:29661:2:0:1:::0:0:", -- Eater of the Dead
	[15237]="152630:30526:2:0:1:::0:0:", -- Corpse Harvester
	[11702]="153135:30627:2:0:1:::0:0:", -- Grizzle's Skinner
	[12773]="165399:33079:2:0:1:::0:0:", -- Ornate Thorium Handaxe
	[15238]="182480:36496:2:0:1:::0:0:", -- Warlord's Axe
	[15239]="212049:42409:2:0:1:::0:0:", -- Felstone Reaver
	[18347]="215336:43067:2:0:1:::0:0:", -- Well Balanced Axe
	[17002]="224127:44825:2:0:1:::0:0:", -- Ichor Spitter
	[15240]="246405:49281:2:0:1:::0:0:", -- Demon's Claw
	[5426]="8431:1686:2:0:1:::0:0:", -- Serpent's Kiss
	[2807]="12264:2452:2:0:1:::0:0:", -- Guillotine Axe
	[12990]="12946:2589:2:0:1:::0:0:", -- Razor's Edge
	[1292]="16504:3300:2:0:1:::0:0:", -- Butcher's Cleaver
	[1481]="16688:3337:2:0:1:::0:0:", -- Grimclaw
	[1454]="19689:3937:2:0:1:::0:0:", -- Axe of the Enforcer
	[2878]="25718:5143:2:0:1:::0:0:", -- Bearded Boneaxe
	[9485]="26440:5288:2:0:1:::0:0:", -- Vibroblade
	[7786]="28028:5605:2:0:1:::0:0:", -- Headsplitter
	[6692]="48942:9788:2:0:1:::0:0:", -- Pronged Reaver
	[934]="53411:10682:2:0:1:::0:0:", -- Stalvan's Reaper
	[7761]="56453:11290:2:0:1:::0:0:", -- Steelclaw Reaver
	[9378]="56901:11380:2:0:1:::0:0:", -- Shovelphlange's Mining Axe
	[1602]="58427:11685:2:0:1:::0:0:", -- Sickle Axe
	[9465]="92804:18560:2:0:1:::0:0:", -- Digmaster 5000
	[2815]="98890:19778:2:0:1:::0:0:", -- Curve-bladed Ripper
	[10623]="123740:24748:2:0:1:::0:0:", -- Winter's Bite
	[9478]="144265:28853:2:0:1:::0:0:", -- Ripsaw
	[13014]="173526:34705:2:0:1:::0:0:", -- Axe of Rin'ji
	[12527]="176662:35332:2:0:1:::0:0:", -- Ribsplitter
	[12774]="180220:36044:2:0:1:::0:0:", -- Dawn's Edge
	[10837]="194005:38801:2:0:1:::0:0:", -- Tooth of Eranikus
	[11920]="203662:40732:2:0:1:::0:0:", -- Wraith Scythe
	[13286]="220533:44106:2:0:1:::0:0:", -- Rivenspike
	[13408]="220713:44142:2:0:1:::0:0:", -- Soul Breaker
	[12621]="225425:45085:2:0:1:::0:0:", -- Demonfork
	[18498]="237219:47443:2:0:1:::0:0:", -- Hedgecutter
	[15853]="257091:51418:2:0:1:::0:0:", -- Windreaper
	[18737]="262137:52427:2:0:1:::0:0:", -- Bone Slicing Hatchet
	[13015]="269788:53957:2:0:1:::0:0:", -- Serathil
	[13952]="283415:56683:2:0:1:::0:0:", -- Iceblade Hacker
	[12798]="285752:57150:2:0:1:::0:0:", -- Annihilator
	[17016]="319868:63973:2:0:1:::0:0:", -- Dark Iron Destroyer
	[19103]="319995:63999:2:0:1:::1:0:287,416", -- Frostbite
	[871]="148139:29627:2:0:1:::0:0:", -- Flurry Axe
	[18827]="153626:30725:2:0:1:::0:0:", -- Grand Marshal's Handaxe
	[18828]="154170:30834:2:0:1:::0:0:", -- High Warlord's Cleaver
	[811]="270619:54123:2:0:1:::0:0:", -- Axe of the Deep Woods
	[19362]="530494:106098:2:0:1:::0:0:", -- Doom's Edge
	[17068]="674164:134832:2:0:1:::0:0:", -- Deathbringer
	[1417]="326:65:2:1:1:::0:0:", -- Beaten Battle Axe
	[1512]="973:194:2:1:1:::0:0:", -- Crude Battle Axe
	[1812]="2264:452:2:1:1:::0:0:", -- Short-handled Battle Axe
	[1824]="5523:1104:2:1:1:::0:0:", -- Shiny War Axe
	[1828]="8046:1609:2:1:1:::0:0:", -- Stone War Axe
	[3779]="14175:2835:2:1:1:::0:0:", -- Hefty War Axe
	[4020]="55948:11189:2:1:1:::0:0:", -- Splintering Battle Axe
	[13819]="99404:19880:2:1:1:::0:0:", -- Balanced War Axe
	[12282]="43:8:2:1:1:::0:0:", -- Worn Battleaxe
	[2479]="107:21:2:1:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Broad Axe
	[5777]="151:30:2:1:1:::0:0:", -- Brave's Axe
	[1386]="160:32:2:1:1:::0:0:", -- Thistlewood Axe
	[2491]="484:96:2:1:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,812,814,823", -- Large Axe
	[3189]="497:99:2:1:1:::0:0:", -- Wood Chopper
	[3325]="703:140:2:1:1:::0:0:", -- Vile Fin Battle Axe
	[1196]="2214:442:2:1:1:::1:0:88,274,292,329,393,429,532,560,613,614,823,886", -- Tabar
	[6206]="2777:555:2:1:1:::0:0:", -- Rock Chipper
	[2025]="5304:1060:2:1:1:::1:0:88,231,274,292,329,390,560,886", -- Bearded Axe
	[926]="9784:1956:2:1:1:::1:0:1,84,85,88,231,292,329,560,646,865,886", -- Battle Axe
	[7958]="12178:2435:2:1:1:::0:0:", -- Bronze Battle Axe
	[2523]="28285:5657:2:1:1:::1:0:1,20,88,227,235,240,297,329,448,460,563,665,772,836,865,882,894", -- Bullova
	[2531]="56169:11233:2:1:1:::1:0:20,88,202,227,235,240,288,297,327,329,448,460,574,745,772,855", -- Great Axe
	[4562]="1491:298:2:1:1:::0:0:", -- Severing Axe
	[3488]="3066:613:2:1:1:::0:0:", -- Copper Battle Axe
	[15268]="5121:1024:2:1:1:::0:0:", -- Twin-bladed Axe
	[3586]="5171:1034:2:1:1:::0:0:", -- Logsplitter
	[1959]="6117:1223:2:1:1:::0:0:", -- Cold Iron Pick
	[6094]="6393:1278:2:1:1:::0:0:", -- Piercing Axe
	[3195]="6862:1372:2:1:1:::0:0:", -- Barbaric Battle Axe
	[15424]="7023:1404:2:1:1:::0:0:", -- Axe of Orgrimmar
	[2203]="7463:1492:2:1:1:::0:0:", -- Brashclaw's Chopper
	[2823]="8092:1618:2:1:1:::0:0:", -- Mo'grosh Can Opener
	[5626]="8587:1717:2:1:1:::0:0:", -- Skullchipper
	[2907]="8778:1755:2:1:1:::0:0:", -- Dwarven Tree Chopper
	[1893]="8876:1775:2:1:1:::0:0:", -- Miner's Revenge
	[5318]="8946:1789:2:1:1:::0:0:", -- Zhovur Axe
	[1220]="9039:1807:2:1:1:::0:0:", -- Lupine Axe
	[872]="10058:2011:2:1:1:::0:0:", -- Rockslicer
	[3199]="11310:2262:2:1:1:::0:0:", -- Battle Slayer
	[5749]="13321:2664:2:1:1:::0:0:", -- Scythe Axe
	[2175]="13416:2683:2:1:1:::0:0:", -- Shadowhide Battle Axe
	[1455]="14657:2931:2:1:1:::0:0:", -- Blackrock Champion's Axe
	[15269]="15183:3036:2:1:1:::0:0:", -- Massive Battle Axe
	[1461]="16936:3387:2:1:1:::0:0:", -- Slayer's Battle Axe
	[3191]="19289:3857:2:1:1:::0:0:", -- Arced War Axe
	[6905]="20054:4010:2:1:1:::0:0:", -- Reef Axe
	[2227]="20667:4133:2:1:1:::0:0:", -- Heavy Ogre War Axe
	[2015]="22219:4443:2:1:1:::0:0:", -- Black Metal War Axe
	[3201]="22483:4496:2:1:1:::0:0:", -- Barbarian War Axe
	[756]="24818:4963:2:1:1:::0:0:", -- Tunnel Pick
	[3210]="28134:5626:2:1:1:::0:0:", -- Brutal War Axe
	[12249]="30195:6039:2:1:1:::1:1:231,297,646", -- Merciless Axe
	[12250]="40341:8068:2:1:1:::1:1:297,563,836,894", -- Midnight Axe
	[3855]="56243:11248:2:1:1:::0:0:", -- Massive Iron Axe
	[3856]="71106:14221:2:1:1:::0:0:", -- Shadow Crescent Axe
	[9521]="71912:14382:2:1:1:::0:0:", -- Skullsplitter
	[1640]="78188:15637:2:1:1:::0:0:", -- Monstrous War Axe
	[9626]="81219:16243:2:1:1:::0:0:", -- Dwarven Charge
	[9679]="87750:17550:2:1:1:::0:0:", -- Tok'kar's Murloc Chopper
	[1680]="91170:18234:2:1:1:::0:0:", -- Headchopper
	[1521]="96027:19205:2:1:1:::0:0:", -- Lumbering Ogre Axe
	[15270]="113877:22775:2:1:1:::0:0:", -- Gigantic War Axe
	[1639]="142301:28460:2:1:1:::0:0:", -- Grinning Axe
	[10652]="151543:30308:2:1:1:::0:0:", -- Will of the Mountain Giant
	[12775]="199746:39949:2:1:1:::0:0:", -- Huge Thorium Battleaxe
	[11816]="203678:40735:2:1:1:::0:0:", -- Angerforge's Battle Axe
	[11907]="205250:41050:2:1:1:::0:0:", -- Beastslayer
	[12000]="205269:41053:2:1:1:::0:0:", -- Limb Cleaver
	[15271]="218506:43701:2:1:1:::0:0:", -- Colossal Great Axe
	[15272]="258702:51740:2:1:1:::0:0:", -- Razor Axe
	[15273]="285543:57108:2:1:1:::0:0:", -- Death Striker
	[5423]="10421:2084:2:1:1:::0:0:", -- Boahn's Fang
	[12975]="11026:2205:2:1:1:::0:0:", -- Prospector Axe
	[1318]="15332:3066:2:1:1:::0:0:", -- Night Reaver
	[5194]="15399:3079:2:1:1:::0:0:", -- Taskmaster Axe
	[13016]="23855:4771:2:1:1:::0:0:", -- Killmaim
	[9486]="27417:5483:2:1:1:::0:0:", -- Supercharger Battle Axe
	[7753]="39371:7874:2:1:1:::0:0:", -- Bloodspiller
	[2299]="43784:8756:2:1:1:::0:0:", -- Burning War Axe
	[6687]="49652:9930:2:1:1:::0:0:", -- Corpsemaker
	[9459]="67801:13560:2:1:1:::0:0:", -- Thermaplugg's Left Arm
	[10570]="79375:15875:2:1:1:::0:0:", -- Manslayer
	[6975]="83831:16766:2:1:1:::0:0:", -- Whirlwind Axe
	[9383]="84476:16895:2:1:1:::0:0:", -- Obsidian Cleaver
	[13017]="86048:17209:2:1:1:::0:0:", -- Hellslayer Battle Axe
	[7717]="94616:18923:2:1:1:::0:0:", -- Ravager
	[9425]="107446:21489:2:1:1:::0:0:", -- Pendulum of Doom
	[6830]="117381:23476:2:1:1:::0:0:", -- Bonebiter
	[13018]="159835:31967:2:1:1:::0:0:", -- Executioner's Cleaver
	[9481]="170335:34067:2:1:1:::0:0:", -- The Minotaur
	[17730]="214759:42951:2:1:1:::0:0:", -- Gatorbite Axe
	[13003]="248203:49640:2:1:1:::0:0:", -- Lord Alexander's Battle Axe
	[11607]="256125:51225:2:1:1:::0:0:", -- Dark Iron Sunderer
	[13285]="274624:54924:2:1:1:::0:0:", -- The Nicker
	[18324]="275949:55189:2:1:1:::0:0:", -- Waveslicer
	[11931]="290516:58103:2:1:1:::0:0:", -- Dreadforge Retaliator
	[13983]="333772:66754:2:1:1:::0:0:", -- Gravestone War Axe
	[18759]="339223:67844:2:1:1:::0:0:", -- Malicious Axe
	[12784]="365181:73036:2:1:1:::0:0:", -- Arcanite Reaper
	[870]="107640:21528:2:1:1:::0:0:", -- Fiery War Axe
	[18830]="175663:35132:2:1:1:::0:0:", -- Grand Marshal's Sunderer
	[18831]="176343:35268:2:1:1:::0:0:", -- High Warlord's Battle Axe
	[2291]="222900:44580:2:1:1:::0:0:", -- Kang the Decapitator
	[1263]="395323:79064:2:1:1:::0:0:", -- Brain Hacker
	[18538]="483741:96748:2:1:1:::0:0:", -- Treant's Bane
	[19354]="675430:135086:2:1:1:::0:0:", -- Draconic Avenger
	[17104]="895337:179067:2:1:1:::0:0:", -- Spinal Reaper
	[19353]="904062:180812:2:1:1:::0:0:", -- Drake Talon Cleaver
	[2773]="195:39:2:2:1:::0:0:", -- Cracked Shortbow
	[2777]="734:146:2:2:1:::0:0:", -- Feeble Shortbow
	[2780]="1872:374:2:2:1:::0:0:", -- Light Hunting Bow
	[2782]="3759:751:2:2:1:::0:0:", -- Mishandled Recurve Bow
	[2785]="5311:1062:2:2:1:::0:0:", -- Stiff Recurve Bow
	[3778]="7705:1541:2:2:1:::0:0:", -- Taut Compound Bow
	[4025]="25351:5070:2:2:1:::0:0:", -- Balanced Long Bow
	[13824]="45078:9015:2:2:1:::0:0:", -- Recurve Long Bow
	[2504]="29:5:2:2:1:::1:0:92,218,527,616", -- Worn Shortbow
	[2505]="59:11:2:2:1:::1:0:92,218,527,616", -- Polished Shortbow
	[12449]="96:19:2:2:1:::0:0:", -- Primitive Bow
	[12447]="96:19:2:2:1:::0:0:", -- Thistlewood Bow
	[8179]="144:28:2:2:1:::0:0:", -- Cadet's Bow
	[2506]="285:57:2:2:1:::1:0:92,218,243,415,436,458,527,616,671,804", -- Hornwood Recurve Bow
	[4931]="671:134:2:2:1:::0:0:", -- Hickory Shortbow
	[5596]="708:141:2:2:1:::0:0:", -- Ashwood Bow
	[2507]="1751:350:2:2:1:::1:0:63,79,92,124,218,243,246,415,436,458,527,607,608,616,671,804,826,854,886", -- Laminated Recurve Bow
	[3026]="3812:762:2:2:1:::1:0:44,63,79,92,114,124,218,246,314,418,424,496,527,595,607,608,616,730,747,826,854,880,886", -- Reinforced Bow
	[3027]="6349:1269:2:2:1:::1:0:44,92,114,218,314,418,424,496,527,595,616,730,747,880", -- Heavy Recurve Bow
	[9400]="27073:5414:2:2:1:::0:0:", -- Baelog's Shortbow
	[8180]="1203:240:2:2:1:::0:0:", -- Hunting Bow
	[5346]="2125:425:2:2:1:::0:0:", -- Orcish Battle Bow
	[2903]="2578:515:2:2:1:::0:0:", -- Daryl's Hunting Bow
	[3036]="2578:515:2:2:1:::0:0:", -- Heavy Shortbow
	[11303]="3184:636:2:2:1:::1:1:218,424,496,511,521,671,730", -- Fine Shortbow
	[11304]="4861:972:2:2:1:::1:1:44,79,124,246,579,607,608,747,826,854", -- Fine Longbow
	[4576]="5922:1184:2:2:1:::0:0:", -- Light Bow
	[3039]="8052:1610:2:2:1:::0:0:", -- Short Ash Bow
	[3078]="11572:2314:2:2:1:::0:0:", -- Naga Heartpiercer
	[8183]="12132:2426:2:2:1:::0:0:", -- Precision Bow
	[3742]="14311:2862:2:2:1:::0:0:", -- Bow of Plunder
	[6739]="14958:2991:2:2:1:::0:0:", -- Cliffrunner's Aim
	[15284]="15199:3039:2:2:1:::0:0:", -- Long Battle Bow
	[5817]="16134:3226:2:2:1:::0:0:", -- Lunaris Bow
	[3493]="17133:3426:2:2:1:::0:0:", -- Raptor's End
	[11306]="19467:3893:2:2:1:::1:1:218,424,511,521,730", -- Sturdy Recurve
	[15285]="20305:4061:2:2:1:::0:0:", -- Archer's Longbow
	[4474]="21037:4207:2:2:1:::0:0:", -- Ravenwood Bow
	[3037]="24071:4814:2:2:1:::0:0:", -- Whipwood Recurve Bow
	[11305]="25814:5162:2:2:1:::1:1:63,92,314,418,521,595,747,880", -- Dense Shortbow
	[15286]="27843:5568:2:2:1:::0:0:", -- Long Redwood Bow
	[4087]="43611:8722:2:2:1:::0:0:", -- Trueshot Bow
	[17686]="49686:9937:2:2:1:::0:0:", -- Master Hunter's Bow
	[4110]="59995:11999:2:2:1:::0:0:", -- Master Hunter's Bow
	[15287]="62583:12516:2:2:1:::0:0:", -- Crusader Bow
	[11307]="67952:13590:2:2:1:::1:1:218,424,730", -- Massive Longbow
	[11308]="78828:15765:2:2:1:::1:1:114,511,521,616", -- Sylvan Shortbow
	[19114]="89435:17887:2:2:1:::0:0:", -- Highland Bow
	[15291]="97958:19591:2:2:1:::0:0:", -- Harpy Needler
	[15294]="100679:20135:2:2:1:::0:0:", -- Siege Bow
	[15295]="113560:22712:2:2:1:::0:0:", -- Quillfire Bow
	[16622]="136535:27307:2:2:1:::0:0:", -- Thornflinger
	[13175]="153095:30619:2:2:1:::0:0:", -- Voone's Twitchbow
	[18482]="154930:30986:2:2:1:::0:0:", -- Ogre Toothpick Shooter
	[15288]="168715:33743:2:2:1:::0:0:", -- Blasthorn Bow
	[15296]="173287:34657:2:2:1:::0:0:", -- Hawkeye Bow
	[15289]="205809:41161:2:2:1:::0:0:", -- Archstrike Bow
	[6469]="11201:2240:2:2:1:::0:0:", -- Venomstrike
	[3021]="12105:2421:2:2:1:::0:0:", -- Ranger Bow
	[13019]="23828:4765:2:2:1:::0:0:", -- Harpyclaw Short Bow
	[6696]="25431:5086:2:2:1:::0:0:", -- Nightstalker Bow
	[10567]="43628:8725:2:2:1:::0:0:", -- Quillshooter
	[13020]="44927:8985:2:2:1:::0:0:", -- Skystriker Bow
	[9426]="51375:10275:2:2:1:::0:0:", -- Monolithic Bow
	[13021]="83473:16694:2:2:1:::0:0:", -- Needle Threader
	[10624]="86246:17249:2:2:1:::0:0:", -- Stinging Bow
	[11628]="122167:24433:2:2:1:::0:0:", -- Houndmaster's Bow
	[17753]="130233:26046:2:2:1:::0:0:", -- Verdant Keeper's Aim
	[13022]="139952:27990:2:2:1:::0:0:", -- Gryphonwing Long Bow
	[18323]="164943:32988:2:2:1:::0:0:", -- Satyr's Bow
	[12653]="181593:36318:2:2:1:::0:0:", -- Riphook
	[18680]="189474:37894:2:2:1:::0:0:", -- Ancient Bone Bow
	[18729]="191512:38302:2:2:1:::0:0:", -- Screeching Bow
	[19562]="205958:41191:2:2:1:::1:0:353", -- Outrunner's Bow
	[16996]="207256:41451:2:2:1:::0:0:", -- Gorewood Bow
	[13023]="213515:42703:2:2:1:::0:0:", -- Eaglehorn Long Bow
	[19558]="220059:44011:2:2:1:::1:0:461", -- Outrider's Bow
	[18713]="0:0:2:2:1:::0:0:", -- Rhok'delar, Longbow of the Ancient Keepers
	[2825]="73609:14721:2:2:1:::0:0:", -- Bow of Searing Arrows
	[18835]="107426:21485:2:2:1:::0:0:", -- High Warlord's Recurve
	[2824]="160159:32031:2:2:1:::0:0:", -- Hurricane
	[18833]="173657:34731:2:2:1:::0:0:", -- Grand Marshal's Bullseye
	[17069]="378731:75746:2:2:1:::0:0:", -- Striker's Mark
	[2774]="140:28:2:3:1:::0:0:", -- Rust-covered Blunderbuss
	[2778]="737:147:2:3:1:::0:0:", -- Cheap Blunderbuss
	[2781]="1676:335:2:3:1:::0:0:", -- Dirty Blunderbuss
	[2783]="2954:590:2:3:1:::0:0:", -- Shoddy Blunderbuss
	[2786]="5865:1173:2:3:1:::0:0:", -- Oiled Blunderbuss
	[3780]="9388:1877:2:3:1:::0:0:", -- Long-barreled Musket
	[4026]="21812:4362:2:3:1:::0:0:", -- Sentinel Musket
	[13825]="50841:10168:2:3:1:::0:0:", -- Primed Musket
	[2508]="27:5:2:3:1:::1:0:783", -- Old Blunderbuss
	[2510]="41:8:2:3:1:::1:0:89,328,465,783", -- Solid Blunderbuss
	[12446]="95:19:2:3:1:::0:0:", -- Anvilmar Musket
	[12448]="96:19:2:3:1:::0:0:", -- Light Hunting Rifle
	[8182]="203:40:2:3:1:::0:0:", -- Pellet Rifle
	[8181]="397:79:2:3:1:::0:0:", -- Hunting Rifle
	[2509]="414:82:2:3:1:::1:1:89,328,438,465,527,747,772,783,826,843", -- Ornate Blunderbuss
	[2511]="1324:264:2:3:1:::1:1:334,388,438,527,747,772,826,843", -- Hunter's Boomstick
	[3023]="3771:754:2:3:1:::1:0:72,89,114,334,388,438,527,599,747,802,855", -- Large Bore Blunderbuss
	[3024]="7098:1419:2:3:1:::1:0:72,89,114,438,527,599,747,802,855", -- BKP 2700 "Enforcer"
	[3025]="18478:3695:2:3:1:::1:0:72,114,855", -- BKP 42 "Ultra"
	[4362]="938:187:2:3:1:::0:0:", -- Rough Boomstick
	[3079]="1486:297:2:3:1:::0:0:", -- Skorn's Rifle
	[4577]="1784:356:2:3:1:::0:0:", -- Compact Shotgun
	[2904]="2977:595:2:3:1:::0:0:", -- Daryl's Hunting Rifle
	[3567]="4613:922:2:3:1:::0:1:717", -- Dwarven Fishing Pole
	[3040]="4701:940:2:3:1:::0:0:", -- Hunter's Muzzle Loader
	[5309]="5190:1038:2:3:1:::0:0:", -- Privateer Musket
	[15205]="5317:1063:2:3:1:::0:0:", -- Owlsight Rifle
	[4369]="5899:1179:2:3:1:::0:0:", -- Deadly Blunderbuss
	[4372]="9000:1800:2:3:1:::0:0:", -- Lovingly Crafted Boomstick
	[4379]="11788:2357:2:3:1:::0:0:", -- Silver-plated Shotgun
	[4383]="15915:3183:2:3:1:::0:0:", -- Moonsight Rifle
	[3041]="18846:3769:2:3:1:::0:0:", -- "Mage-Eye" Blunderbuss
	[3042]="22887:4577:2:3:1:::0:0:", -- BKP "Sparrow" Smallbore
	[17042]="28464:5692:2:3:1:::0:0:", -- Nail Spitter
	[6798]="31934:6386:2:3:1:::0:0:", -- Blasting Hackbut
	[4086]="31934:6386:2:3:1:::0:0:", -- Flash Rifle
	[8188]="32071:6414:2:3:1:::0:0:", -- Explosive Shotgun
	[15691]="34545:6909:2:3:1:::0:0:", -- Sidegunner Shottie
	[15322]="38726:7745:2:3:1:::0:0:", -- Smoothbore Gun
	[4127]="40368:8073:2:3:1:::0:0:", -- Shrapnel Blaster
	[10508]="44794:8958:2:3:1:::0:0:", -- Mithril Blunderbuss
	[17687]="49686:9937:2:3:1:::0:0:", -- Master Hunter's Rifle
	[3430]="55134:11026:2:3:1:::0:0:", -- Sniper Rifle
	[10510]="56845:11369:2:3:1:::0:0:", -- Mithril Heavy-bore Rifle
	[4111]="60214:12042:2:3:1:::0:0:", -- Master Hunter's Rifle
	[4089]="75302:15060:2:3:1:::0:0:", -- Ricochet Blunderbuss
	[15323]="88956:17791:2:3:1:::0:0:", -- Percussion Shotgun
	[15995]="98697:19739:2:3:1:::0:0:", -- Thorium Rifle
	[13474]="123624:24724:2:3:1:::0:0:", -- Farmer Dalson's Shotgun
	[15324]="127828:25565:2:3:1:::0:0:", -- Burnside Rifle
	[18460]="153811:30762:2:3:1:::0:0:", -- Unsophisticated Hand Cannon
	[16992]="154370:30874:2:3:1:::0:0:", -- Smokey's Explosive Launcher
	[15325]="158924:31784:2:3:1:::0:0:", -- Sharpshooter Harquebus
	[13136]="7280:1456:2:3:1:::0:0:", -- Lil Timmy's Peashooter
	[2098]="15104:3020:2:3:1:::0:0:", -- Double-barreled Shotgun
	[9487]="18163:3632:2:3:1:::0:0:", -- Hi-tech Supergun
	[7729]="27573:5514:2:3:1:::0:0:", -- Chesterfall Musket
	[13137]="29374:5874:2:3:1:::0:0:", -- Ironweaver
	[9456]="33262:6652:2:3:1:::0:0:", -- Glass Shooter
	[13138]="57661:11532:2:3:1:::0:0:", -- The Silencer
	[9422]="65262:13052:2:3:1:::0:0:", -- Shadowforge Bushmaster
	[9412]="83405:16681:2:3:1:::0:0:", -- Galgann's Fireblaster
	[13139]="105149:21029:2:3:1:::0:0:", -- Guttbuster
	[11629]="122635:24527:2:3:1:::0:0:", -- Houndmaster's Rifle
	[17717]="132129:26425:2:3:1:::0:0:", -- Megashot Rifle
	[16004]="145762:29152:2:3:1:::0:0:", -- Dark Iron Rifle
	[13248]="148349:29669:2:3:1:::0:0:", -- Burstshot Harquebus
	[13146]="173521:34704:2:3:1:::0:0:", -- Shell Launcher Shotgun
	[13380]="192216:38443:2:3:1:::0:0:", -- Willey's Portable Howitzer
	[16007]="203125:40625:2:3:1:::0:0:", -- Flawless Arcanite Rifle
	[18755]="215646:43129:2:3:1:::0:0:", -- Xorothian Firestick
	[18860]="112353:22470:2:3:1:::0:0:", -- High Warlord's Street Sweeper
	[2100]="122699:24539:2:3:1:::0:0:", -- Precisely Calibrated Boomstick
	[18855]="179726:35945:2:3:1:::0:0:", -- Grand Marshal's Hand Cannon
	[2099]="225203:45040:2:3:1:::0:0:", -- Dwarven Hand Cannon
	[18282]="331739:66347:2:3:1:::0:0:", -- Core Marksman Rifle
	[17072]="412860:82572:2:3:1:::0:0:", -- Blastershot Launcher
	[19368]="532872:106574:2:3:1:::0:0:", -- Dragonbreath Hand Cannon
	[6196]="0:0:2:4:1:::0:0:", -- Noboru's Cudgel
	[1415]="363:72:2:4:1:::0:0:", -- Carpenter's Mallet
	[1510]="752:150:2:4:1:::0:0:", -- Heavy Hammer
	[1815]="1832:366:2:4:1:::0:0:", -- Ornamental Mace
	[1823]="3896:779:2:4:1:::0:0:", -- Bludgeoning Cudgel
	[11411]="7420:1484:2:4:1:::0:0:", -- Large Bear Bone
	[1825]="7742:1548:2:4:1:::0:0:", -- Bulky Bludgeon
	[3787]="21448:4289:2:4:1:::0:0:", -- Stone Club
	[4021]="35991:7198:2:4:1:::0:0:", -- Blunting Mace
	[13820]="60211:12042:2:4:1:::0:0:", -- Clout Mace
	[36]="38:7:2:4:1:::0:0:", -- Worn Mace
	[2130]="54:10:2:4:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Club
	[3262]="54:10:2:4:1:::0:0:", -- Putrid Wooden Hammer
	[3294]="58:11:2:4:1:::0:0:", -- Deadman Club
	[2055]="80:16:2:4:1:::0:0:", -- Small Wooden Hammer
	[1382]="122:24:2:4:1:::0:0:", -- Rock Mace
	[10544]="127:25:2:4:1:::0:0:", -- Thistlewood Maul
	[5580]="128:25:2:4:1:::0:0:", -- Militia Hammer
	[2048]="129:25:2:4:1:::0:0:", -- Anvilmar Hammer
	[3269]="129:25:2:4:1:::0:0:", -- Forsaken Maul
	[4924]="129:25:2:4:1:::0:0:", -- Primitive Club
	[2492]="284:56:2:4:1:::1:0:129,161,217,256,266,271,274,436,550,628,639,714,729,798,804,812,814,823", -- Cudgel
	[766]="286:57:2:4:1:::0:0:", -- Flanged Mace
	[1389]="291:58:2:4:1:::0:0:", -- Kobold Mining Mallet
	[2259]="378:75:2:4:1:::0:0:", -- Frostmane Club
	[2844]="530:106:2:4:1:::0:0:", -- Copper Mace
	[4563]="552:110:2:4:1:::0:0:", -- Billy Club
	[781]="552:110:2:4:1:::0:0:", -- Stone Gnoll Hammer
	[1158]="731:146:2:4:1:::0:0:", -- Solid Metal Club
	[1913]="742:148:2:4:1:::0:0:", -- Studded Blackjack
	[3329]="896:179:2:4:1:::0:0:", -- Spiked Wooden Plank
	[2064]="958:191:2:4:1:::0:0:", -- Trogg Club
	[852]="1739:347:2:4:1:::1:0:68,271,274,292,393,429,462,483,487,532,560,613,614,628,823", -- Mace
	[2028]="5065:1013:2:4:1:::1:1:68,231,271,274,292,390,462,487,560", -- Hammer
	[2848]="5595:1119:2:4:1:::0:0:", -- Bronze Mace
	[925]="7797:1559:2:4:1:::1:0:1,68,84,85,231,271,292,462,487,560,646,865", -- Flail
	[2524]="19192:3838:2:4:1:::1:0:1,20,66,68,399,462,563,600,665,836,865,882,894", -- Truncheon
	[19292]="20113:4022:2:4:1:::0:0:", -- Last Months Mutton
	[2532]="52608:10521:2:4:1:::1:0:20,66,202,288,327,399,462,574,600,745,855", -- Morning Star
	[19293]="96881:19376:2:4:1:::0:0:", -- Last Years Mutton
	[3223]="1534:306:2:4:1:::0:0:", -- Frostmane Scepter
	[4948]="1633:326:2:4:1:::0:0:", -- Stinging Mace
	[4971]="1919:383:2:4:1:::0:0:", -- Skorn's Hammer
	[2075]="1932:386:2:4:1:::0:0:", -- Priest's Mace
	[4303]="1991:398:2:4:1:::0:0:", -- Cranial Thumper
	[1009]="2451:490:2:4:1:::0:0:", -- Compact Hammer
	[5587]="2562:512:2:4:1:::0:0:", -- Thornroot Club
	[4569]="3063:612:2:4:1:::0:0:", -- Staunch Hammer
	[6982]="3415:683:2:4:1:::0:0:", -- Umbral Mace
	[6983]="3428:685:2:4:1:::0:0:", -- Haggard's Hammer
	[1926]="3438:687:2:4:1:::0:0:", -- Weighted Sap
	[7117]="3441:688:2:4:1:::0:0:", -- Heirloom Hammer
	[6968]="3494:698:2:4:1:::0:0:", -- Elunite Hammer
	[7328]="3506:701:2:4:1:::0:0:", -- Thun'grim's Mace
	[2267]="3558:711:2:4:1:::0:0:", -- Stonesplinter Mace
	[1394]="3700:740:2:4:1:::0:0:", -- Driftwood Club
	[5324]="3881:776:2:4:1:::0:0:", -- Engineer's Hammer
	[3570]="4197:839:2:4:1:::0:0:", -- Bonegrinding Pestle
	[1214]="4651:930:2:4:1:::0:0:", -- Gnoll Punisher
	[2079]="4669:933:2:4:1:::0:0:", -- Sergeant's Warhammer
	[1480]="4773:954:2:4:1:::0:0:", -- Fist of the People's Militia
	[827]="4858:971:2:4:1:::0:0:", -- Wicked Blackjack
	[1958]="4876:975:2:4:1:::0:0:", -- Petrified Shinbone
	[2821]="5589:1117:2:4:1:::0:0:", -- Mo'grosh Masher
	[15445]="5637:1127:2:4:1:::0:0:", -- Hammer of Orgrimmar
	[15222]="6096:1219:2:4:1:::0:0:", -- Barbed Club
	[1440]="6151:1230:2:4:1:::0:0:", -- Gnoll Skull Basher
	[5757]="6816:1363:2:4:1:::0:0:", -- Hardwood Cudgel
	[5197]="7989:1597:2:4:1:::0:0:", -- Cookie's Tenderizer
	[1296]="8408:1681:2:4:1:::0:0:", -- Blackrock Mace
	[4439]="8944:1788:2:4:1:::0:0:", -- Bruiser Club
	[1457]="9251:1850:2:4:1:::0:0:", -- Shadowhide Mace
	[1938]="9810:1962:2:4:1:::0:0:", -- Block Mallet
	[789]="9847:1969:2:4:1:::0:0:", -- Stout Battlehammer
	[15223]="11884:2376:2:4:1:::0:0:", -- Jagged Star
	[6360]="12905:2581:2:4:1:::0:0:", -- Steelscale Crushfish
	[6323]="13058:2611:2:4:1:::0:0:", -- Baron's Scepter
	[15224]="13479:2695:2:4:1:::0:0:", -- Battlesmasher
	[3491]="13709:2741:2:4:1:::0:0:", -- Heavy Bronze Mace
	[920]="14106:2821:2:4:1:::0:0:", -- Wicked Spiked Mace
	[5541]="18469:3693:2:4:1:::0:0:", -- Iridescent Hammer
	[3492]="22764:4552:2:4:1:::0:0:", -- Mighty Iron Hammer
	[865]="25480:5096:2:4:1:::0:0:", -- Leaden Mace
	[15225]="29793:5958:2:4:1:::0:0:", -- Sequoia Hammer
	[5256]="36136:7227:2:4:1:::0:0:", -- Kovork's Rattle
	[4978]="39882:7976:2:4:1:::0:0:", -- Ryedol's Hammer
	[17039]="41585:8317:2:4:1:::0:0:", -- Skullbreaker
	[4122]="41922:8384:2:4:1:::0:0:", -- Bookmaker's Scepter
	[15226]="43778:8755:2:4:1:::0:0:", -- Giant Club
	[1207]="49460:9892:2:4:1:::0:0:", -- Murphstar
	[4511]="56284:11256:2:4:1:::0:0:", -- Black Water Hammer
	[6804]="56312:11262:2:4:1:::0:0:", -- Windstorm Hammer
	[8194]="69388:13877:2:4:1:::0:0:", -- Goblin Nutcracker
	[7945]="86455:17291:2:4:1:::0:0:", -- Big Black Mace
	[9419]="90384:18076:2:4:1:::0:0:", -- Galgann's Firehammer
	[1608]="94703:18940:2:4:1:::0:0:", -- Skullcrusher Mace
	[7946]="108304:21660:2:4:1:::0:0:", -- Runed Mithril Hammer
	[15227]="109625:21925:2:4:1:::0:0:", -- Diamond-Tip Bludgeon
	[9686]="129573:25914:2:4:1:::0:0:", -- Spirit of the Faerie Dragon
	[16769]="133081:26616:2:4:1:::0:0:", -- Furbolg Medicine Totem
	[9651]="134140:26828:2:4:1:::0:0:", -- Gryphon Rider's Stormhammer
	[15228]="141543:28308:2:4:1:::0:0:", -- Smashing Star
	[15863]="144482:28896:2:4:1:::0:0:", -- Grave Scepter
	[10804]="147758:29551:2:4:1:::0:0:", -- Fist of the Damned
	[11120]="150720:30144:2:4:1:::0:0:", -- Belgrom's Hammer
	[11964]="150783:30156:2:4:1:::0:0:", -- Swiftstrike Cudgel
	[15229]="159622:31924:2:4:1:::0:0:", -- Blesswind Hammer
	[11906]="163615:32723:2:4:1:::0:0:", -- Beastsmasher
	[18044]="169154:33830:2:4:1:::0:0:", -- Hurley's Tankard
	[12792]="196279:39255:2:4:1:::0:0:", -- Volcanic Hammer
	[13204]="196316:39263:2:4:1:::0:0:", -- Bashguuder
	[18048]="217945:43589:2:4:1:::0:0:", -- Mastersmith's Hammer
	[17003]="224911:44982:2:4:1:::0:0:", -- Skullstone Hammer
	[1483]="10129:2025:2:4:1:::0:0:", -- Face Smasher
	[2256]="14982:2996:2:4:1:::0:0:", -- Skeletal Club
	[6472]="15094:3018:2:4:1:::0:0:", -- Stinging Viper
	[2194]="16383:3276:2:4:1:::0:0:", -- Diamond Hammer
	[3414]="20144:4028:2:4:1:::0:0:", -- Crested Scepter
	[9488]="22096:4419:2:4:1:::0:0:", -- Oscillating Power Hammer
	[13024]="24319:4863:2:4:1:::0:0:", -- Beazel's Basher
	[13048]="29858:5971:2:4:1:::0:0:", -- Looming Gavel
	[7752]="34514:6902:2:4:1:::0:0:", -- Dreamslayer
	[2816]="36620:7324:2:4:1:::0:0:", -- Death Speaker Scepter
	[7687]="44180:8836:2:4:1:::0:0:", -- Ironspine's Fist
	[9457]="44510:8902:2:4:1:::0:0:", -- Royal Diplomatic Scepter
	[9386]="49296:9859:2:4:1:::0:0:", -- Excavator's Brand
	[13025]="52324:10464:2:4:1:::0:0:", -- Deadwood Sledge
	[10571]="54635:10927:2:4:1:::0:0:", -- Ebony Boneclub
	[936]="58104:11620:2:4:1:::0:0:", -- Midnight Mace
	[7736]="59854:11970:2:4:1:::0:0:", -- Fight Club
	[9427]="74265:14853:2:4:1:::0:0:", -- Stonevault Bonebreaker
	[7721]="89611:17922:2:4:1:::0:0:", -- Hand of Righteousness
	[13026]="97208:19441:2:4:1:::0:0:", -- Heaven's Light
	[9359]="97888:19577:2:4:1:::0:0:", -- Wirt's Third Leg
	[4090]="103683:20736:2:4:1:::0:0:", -- Mug O' Hurt
	[7954]="115799:23159:2:4:1:::0:0:", -- The Shatterer
	[9639]="120556:24111:2:4:1:::0:0:", -- The Hand of Antu'sul
	[17055]="133735:26747:2:4:1:::0:0:", -- Changuk Smasher
	[17943]="160783:32156:2:4:1:::0:0:", -- Fist of Stone
	[13027]="169160:33832:2:4:1:::0:0:", -- Bonesnapper
	[10838]="173325:34665:2:4:1:::0:0:", -- Might of Hakkar
	[17733]="173678:34735:2:4:1:::0:0:", -- Fist of Stone
	[1721]="179079:35815:2:4:1:::0:0:", -- Viking Warhammer
	[11805]="202196:40439:2:4:1:::0:0:", -- Rubidium Hammer
	[12781]="213605:42721:2:4:1:::0:0:", -- Serenity
	[11923]="218244:43648:2:4:1:::0:0:", -- The Hammer of Grace
	[18671]="225923:45184:2:4:1:::0:0:", -- Baron Charr's Sceptre
	[18321]="246601:49320:2:4:1:::0:0:", -- Energetic Rod
	[18683]="255504:51100:2:4:1:::0:0:", -- Hammer of the Vesper
	[13401]="257201:51440:2:4:1:::0:0:", -- The Cruel Hand of Timmy
	[13183]="258857:51771:2:4:1:::0:0:", -- Venomspitter
	[18376]="261534:52306:2:4:1:::0:0:", -- Timeworn Mace
	[13028]="263025:52605:2:4:1:::0:0:", -- Bludstone Hammer
	[14487]="266113:53222:2:4:1:::0:0:", -- Bonechill Hammer
	[13006]="274202:54840:2:4:1:::0:0:", -- Mass of McGowan
	[12794]="281520:56304:2:4:1:::0:0:", -- Masterwork Stormhammer
	[13349]="292144:58428:2:4:1:::0:0:", -- Scepter of the Unholy
	[19104]="321137:64227:2:4:1:::1:0:224,774", -- Stormstrike Hammer
	[8708]="0:0:2:4:1:::0:0:", -- Hammer of Expertise
	[868]="107664:21532:2:4:1:::0:0:", -- Ardent Custodian
	[18865]="152509:30501:2:4:1:::0:0:", -- Grand Marshal's Punisher
	[18866]="153053:30610:2:4:1:::0:0:", -- High Warlord's Bludgeon
	[810]="226335:45267:2:4:1:::0:0:", -- Hammer of the Northern Wind
	[11684]="315430:63086:2:4:1:::0:0:", -- Ironfoe
	[2243]="352770:70554:2:4:1:::0:0:", -- Hand of Edward the Odd
	[17112]="452792:90558:2:4:1:::0:0:", -- Empyrean Demolisher
	[17105]="510891:102178:2:4:1:::0:0:", -- Aurastone Hammer
	[19170]="518448:103689:2:4:1:::0:0:", -- Ebon Hand
	[19335]="644128:128825:2:4:1:::0:0:", -- Spineshatter
	[1414]="486:97:2:5:1:::0:0:", -- Cracked Sledge
	[1514]="1470:294:2:5:1:::0:0:", -- Rusty Warhammer
	[1814]="3018:603:2:5:1:::0:0:", -- Battered Mallet
	[1820]="4818:963:2:5:1:::0:0:", -- Wooden Maul
	[1826]="8828:1765:2:5:1:::0:0:", -- Rock Maul
	[3782]="17257:3451:2:5:1:::0:0:", -- Large War Club
	[4022]="60297:12059:2:5:1:::0:0:", -- Crushing Maul
	[13821]="89968:17993:2:5:1:::0:0:", -- Bulky Maul
	[2361]="45:9:2:5:1:::0:0:", -- Battleworn Hammer
	[2480]="72:14:2:5:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Large Club
	[5761]="153:30:2:5:1:::0:0:", -- Anvilmar Sledge
	[5579]="160:32:2:5:1:::0:0:", -- Militia Warhammer
	[1195]="236:47:2:5:1:::0:0:", -- Kobold Mining Shovel
	[3334]="343:68:2:5:1:::0:0:", -- Farmer's Shovel
	[3190]="499:99:2:5:1:::0:0:", -- Beatstick
	[2493]="701:140:2:5:1:::1:0:129,161,217,256,266,271,274,436,550,628,639,714,729,798,804,812,814,823", -- Wooden Mallet
	[5595]="1177:235:2:5:1:::0:0:", -- Thicket Hammer
	[1197]="2666:533:2:5:1:::1:0:68,271,274,292,393,429,462,483,487,532,560,613,614,628,823", -- Giant Mace
	[6214]="2978:595:2:5:1:::0:0:", -- Heavy Copper Maul
	[5187]="5407:1081:2:5:1:::0:0:", -- Rhahk'Zor's Hammer
	[2026]="6286:1257:2:5:1:::1:1:68,231,271,274,292,390,462,487,560", -- Rock Hammer
	[7956]="9722:1944:2:5:1:::0:0:", -- Bronze Warhammer
	[924]="10972:2194:2:5:1:::1:0:1,68,84,85,231,271,292,462,487,560,646,865", -- Maul
	[2525]="26489:5297:2:5:1:::1:0:1,20,66,227,235,240,399,460,462,563,600,665,772,836,865,882,894", -- War Hammer
	[2533]="61107:12221:2:5:1:::1:0:20,66,202,227,235,240,288,327,399,460,462,574,600,745,772,855", -- War Maul
	[3103]="2334:466:2:5:1:::0:0:", -- Coldridge Hammer
	[4964]="2516:503:2:5:1:::0:0:", -- Goblin Smasher
	[2254]="2534:506:2:5:1:::0:0:", -- Icepane Warhammer
	[4564]="3053:610:2:5:1:::0:0:", -- Spiked Club
	[3440]="3202:640:2:5:1:::0:0:", -- Bonecracker
	[5345]="3529:705:2:5:1:::0:0:", -- Stonewood Hammer
	[4570]="4611:922:2:5:1:::0:0:", -- Birchwood Maul
	[6205]="4613:922:2:5:1:::0:0:", -- Burrowing Shovel
	[4777]="7040:1408:2:5:1:::1:1:30,429,483,532,628,842", -- Ironwood Maul
	[4778]="7350:1470:2:5:1:::1:1:30,429,483,529,532,628,842", -- Heavy Spiked Mace
	[1218]="10321:2064:2:5:1:::0:0:", -- Heavy Gnoll War Club
	[3193]="10361:2072:2:5:1:::0:0:", -- Oak Mallet
	[3571]="10593:2118:2:5:1:::0:0:", -- Trogg Beater
	[1458]="13117:2623:2:5:1:::0:0:", -- Shadowhide Maul
	[3198]="13709:2741:2:5:1:::0:0:", -- Battering Hammer
	[15259]="16533:3306:2:5:1:::0:0:", -- Hefty Battlehammer
	[911]="16622:3324:2:5:1:::0:0:", -- Ironwood Treebranch
	[1264]="18357:3671:2:5:1:::0:0:", -- Headbasher
	[5322]="20081:4016:2:5:1:::0:0:", -- Demolition Hammer
	[2058]="20986:4197:2:5:1:::0:0:", -- Kazon's Maul
	[6093]="22091:4418:2:5:1:::0:0:", -- Orc Crusher
	[15464]="22523:4504:2:5:1:::0:0:", -- Brute Hammer
	[9604]="28160:5632:2:5:1:::0:0:", -- Mechanic's Pipehammer
	[5815]="29355:5871:2:5:1:::0:0:", -- Glacial Stone
	[3851]="31294:6258:2:5:1:::0:0:", -- Solid Iron Maul
	[1991]="41788:8357:2:5:1:::0:0:", -- Goblin Power Shovel
	[3852]="41804:8360:2:5:1:::0:0:", -- Golden Iron Destroyer
	[1679]="48177:9635:2:5:1:::0:0:", -- Korg Bat
	[1990]="50385:10077:2:5:1:::0:0:", -- Ballast Maul
	[1523]="51305:10261:2:5:1:::0:0:", -- Huge Stone Club
	[15260]="57783:11556:2:5:1:::0:0:", -- Stone Hammer
	[15261]="67653:13530:2:5:1:::0:0:", -- Sequoia Branch
	[4128]="72939:14587:2:5:1:::0:0:", -- Silver Spade
	[4548]="75143:15028:2:5:1:::0:0:", -- Servomechanic Sledgehammer
	[11265]="82424:16484:2:5:1:::0:0:", -- Cragwood Maul
	[4983]="84185:16837:2:5:1:::0:0:", -- Rock Pulverizer
	[9678]="87429:17485:2:5:1:::0:0:", -- Tok'kar's Murloc Basher
	[15262]="107763:21552:2:5:1:::0:0:", -- Greater Maul
	[3208]="126893:25378:2:5:1:::0:0:", -- Conk Hammer
	[15263]="144448:28889:2:5:1:::0:0:", -- Royal Mallet
	[15264]="207589:41517:2:5:1:::0:0:", -- Backbreaker
	[11803]="209074:41814:2:5:1:::0:0:", -- Force of Magma
	[15265]="234116:46823:2:5:1:::0:0:", -- Painbringer
	[18481]="257259:51451:2:5:1:::0:0:", -- Skullcracking Mace
	[15266]="272026:54405:2:5:1:::0:0:", -- Fierce Mauler
	[15267]="301018:60203:2:5:1:::0:0:", -- Brutehammer
	[12983]="11813:2362:2:5:1:::0:0:", -- Rakzur Club
	[3194]="12479:2495:2:5:1:::0:0:", -- Black Malice
	[7230]="15515:3103:2:5:1:::0:0:", -- Smite's Mighty Hammer
	[3203]="27184:5436:2:5:1:::0:0:", -- Dense Triangle Mace
	[1976]="31703:6340:2:5:1:::0:0:", -- Slaghammer
	[6953]="37297:7459:2:5:1:::0:0:", -- Verigan's Fist
	[9449]="47822:9564:2:5:1:::0:0:", -- Manual Crowd Pummeler
	[7730]="50732:10146:2:5:1:::0:0:", -- Cobalt Crusher
	[13045]="54048:10809:2:5:1:::0:0:", -- Viscous Hammer
	[6327]="64118:12823:2:5:1:::0:0:", -- The Pacifier
	[9391]="64158:12831:2:5:1:::0:0:", -- The Shoveler
	[6976]="86321:17264:2:5:1:::0:0:", -- Whirlwind Warhammer
	[1722]="97038:19407:2:5:1:::0:0:", -- Thornstone Sledgehammer
	[7723]="112836:22567:2:5:1:::0:0:", -- Mograine's Might
	[9423]="127319:25463:2:5:1:::0:0:", -- The Jackhammer
	[9413]="161244:32248:2:5:1:::0:0:", -- The Rockpounder
	[13046]="175213:35042:2:5:1:::0:0:", -- Blanchard's Stout
	[10626]="183661:36732:2:5:1:::0:0:", -- Ragehammer
	[12528]="189165:37833:2:5:1:::0:0:", -- The Judge's Gavel
	[17766]="224317:44863:2:5:1:::0:0:", -- Princess Theradras' Scepter
	[11608]="228803:45760:2:5:1:::0:0:", -- Dark Iron Pulverizer
	[12776]="240624:48124:2:5:1:::0:0:", -- Enchanted Battlehammer
	[11921]="270836:54167:2:5:1:::0:0:", -- Impervious Giant
	[13047]="282942:56588:2:5:1:::0:0:", -- Twig of the World Tree
	[13167]="297052:59410:2:5:1:::0:0:", -- Fist of Omokk
	[14531]="299458:59891:2:5:1:::0:0:", -- Frightskull Shaft
	[13393]="311904:62380:2:5:1:::0:0:", -- Malown's Slam
	[18531]="326918:65383:2:5:1:::0:0:", -- Unyielding Maul
	[18717]="344091:68818:2:5:1:::0:0:", -- Hammer of the Grand Crusader
	[12969]="354420:70884:2:5:1:::0:0:", -- Seeping Willow
	[12796]="354564:70912:2:5:1:::0:0:", -- Hammer of the Titans
	[18420]="356184:71236:2:5:1:::0:0:", -- Bonecrusher
	[15418]="367988:73597:2:5:1:::0:0:", -- Shimmering Platinum Warhammer
	[18867]="191978:38395:2:5:1:::0:0:", -- Grand Marshal's Battle Hammer
	[18868]="192658:38531:2:5:1:::0:0:", -- High Warlord's Pulverizer
	[2915]="276447:55289:2:5:1:::0:0:", -- Taran Icebreaker
	[17073]="568157:113631:2:5:1:::0:0:", -- Earthshaker
	[17193]="611554:122310:2:5:1:::0:0:", -- Sulfuron Hammer
	[19358]="653192:130638:2:5:1:::0:0:", -- Draconic Maul
	[18803]="677972:135594:2:5:1:::0:0:", -- Finkle's Lava Dredger
	[19357]="830469:166093:2:5:1:::0:0:", -- Herald of Woe
	[19323]="1564900:312980:2:5:1:::1:0:287,416,774", -- The Unstoppable Force
	[17182]="1663117:332623:2:5:1:::0:0:", -- Sulfuras, Hand of Ragnaros
	[1485]="7053:1410:2:6:1:::0:0:", -- Pitchfork
	[15810]="10145:2029:2:6:1:::1:0:292,560", -- Short Spear
	[15811]="27132:5426:2:6:1:::1:0:292,560", -- Heavy Spear
	[1406]="10398:2079:2:6:1:::0:0:", -- Pearl-encrusted Spear
	[5200]="11615:2323:2:6:1:::0:0:", -- Impaling Harpoon
	[6679]="24264:4852:2:6:1:::0:0:", -- Armor Piercer
	[1522]="51121:10224:2:6:1:::0:0:", -- Headhunting Spear
	[11864]="170542:34108:2:6:1:::0:0:", -- White Bone Spear
	[12989]="14271:2854:2:6:1:::0:0:", -- Gargoyle's Bite
	[13057]="26911:5382:2:6:1:::0:0:", -- Bloodpike
	[1726]="60915:12183:2:6:1:::0:0:", -- Poison-tipped Bone Spear
	[7758]="75370:15074:2:6:1:::0:0:", -- Ruthless Shiv
	[13054]="79026:15805:2:6:1:::0:0:", -- Grim Reaper
	[13058]="109167:21833:2:6:1:::0:0:", -- Khoo's Point
	[9416]="141092:28218:2:6:1:::0:0:", -- Grimlok's Charge
	[13055]="146838:29367:2:6:1:::0:0:", -- Bonechewer
	[9480]="158625:31725:2:6:1:::0:0:", -- Eyegouger
	[9475]="166732:33346:2:6:1:::0:0:", -- Diabolic Skiver
	[7959]="169289:33857:2:6:1:::0:0:", -- Blight
	[13059]="193598:38719:2:6:1:::0:0:", -- Stoneraven
	[10799]="196442:39288:2:6:1:::0:0:", -- Headspike
	[12243]="229901:45980:2:6:1:::0:0:", -- Smoldering Claw
	[13056]="241653:48330:2:6:1:::0:0:", -- Frenzied Striker
	[11809]="256435:51287:2:6:1:::0:0:", -- Flame Wrath
	[18725]="299636:59927:2:6:1:::0:0:", -- Peacemaker
	[13060]="303923:60784:2:6:1:::0:0:", -- The Needler
	[13148]="313145:62629:2:6:1:::0:0:", -- Chillpike
	[18502]="350636:70127:2:6:1:::0:0:", -- Monstrous Glaive
	[19106]="366765:73353:2:6:1:::0:0:", -- Ice Barbed Spear
	[12583]="371731:74346:2:6:1:::0:0:", -- Blackhand Doomsaw
	[18869]="174946:34989:2:6:1:::0:0:", -- Grand Marshal's Glaive
	[18871]="181156:36231:2:6:1:::0:0:", -- High Warlord's Pig Sticker
	[17223]="485373:97074:2:6:1:::0:0:", -- Thunderstrike
	[17074]="492571:98514:2:6:1:::0:0:", -- Shadowstrike
	[1413]="276:55:2:7:1:::0:0:", -- Feeble Sword
	[1511]="969:193:2:7:1:::0:0:", -- Commoner's Sword
	[1817]="2507:501:2:7:1:::0:0:", -- Stock Shortsword
	[1821]="4940:988:2:7:1:::0:0:", -- Warped Blade
	[1829]="7818:1563:2:7:1:::0:0:", -- Short Cutlass
	[3783]="15244:3048:2:7:1:::0:0:", -- Light Scimitar
	[4017]="34550:6910:2:7:1:::0:0:", -- Sharp Shortsword
	[13816]="52808:10561:2:7:1:::0:0:", -- Fine Longsword
	[3935]="0:0:2:7:1:::0:0:", -- Smotts' Cutlass
	[997]="17:3:2:7:1:::0:0:", -- Fire Sword of Crippling
	[25]="35:7:2:7:1:::0:0:", -- Worn Shortsword
	[3295]="54:10:2:7:1:::0:0:", -- Deadman Blade
	[2131]="54:10:2:7:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Shortsword
	[1384]="56:11:2:7:1:::0:0:", -- Dull Blade
	[2057]="81:16:2:7:1:::0:0:", -- Pitted Defias Shortsword
	[3267]="128:25:2:7:1:::0:0:", -- Forsaken Shortsword
	[1161]="128:25:2:7:1:::0:0:", -- Militia Shortsword
	[5586]="130:26:2:7:1:::0:0:", -- Thistlewood Blade
	[18610]="181:36:2:7:1:::0:0:", -- Keen Machete
	[4560]="185:37:2:7:1:::0:0:", -- Fine Scimitar
	[2258]="416:83:2:7:1:::0:0:", -- Frostmane Shortsword
	[2488]="536:107:2:7:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,814,823", -- Gladius
	[3319]="550:110:2:7:1:::0:0:", -- Short Sabre
	[2847]="551:110:2:7:1:::0:0:", -- Copper Shortsword
	[2065]="569:113:2:7:1:::0:0:", -- Rockjaw Blade
	[2282]="696:139:2:7:1:::0:0:", -- Rodentia Shortsword
	[1008]="720:144:2:7:1:::0:0:", -- Well-used Sword
	[2268]="732:146:2:7:1:::0:0:", -- Stonesplinter Blade
	[4932]="899:179:2:7:1:::0:0:", -- Harpy Wing Clipper
	[3455]="941:188:2:7:1:::0:0:", -- Deathstalker Shortsword
	[851]="2023:404:2:7:1:::1:0:88,161,227,274,292,329,393,429,443,460,532,560,613,614,724,823", -- Cutlass
	[2027]="3815:763:2:7:1:::1:0:88,227,231,274,292,329,390,443,460,560,724", -- Scimitar
	[2850]="7197:1439:2:7:1:::0:0:", -- Bronze Shortsword
	[923]="8743:1748:2:7:1:::1:0:1,84,85,88,227,231,292,329,443,460,560,646,724,865", -- Longsword
	[2520]="24628:4925:2:7:1:::1:0:1,88,227,235,329,330,341,435,443,460,563,665,724,836,865,882,894", -- Broadsword
	[2528]="51836:10367:2:7:1:::1:0:88,202,235,288,327,329,330,341,435,443,460,574,724,745,855", -- Falchion
	[727]="1224:244:2:7:1:::0:0:", -- Notched Shortsword
	[18957]="1441:288:2:7:1:::0:0:", -- Brushwood Blade
	[5744]="1933:386:2:7:1:::0:0:", -- Pale Skinner
	[4766]="2407:481:2:7:1:::1:1:393,429,532,591,614,842", -- Feral Blade
	[4765]="2877:575:2:7:1:::1:1:429,532,591,614,842", -- Enamelled Broadsword
	[15335]="2904:580:2:7:1:::0:0:", -- Briarsteel Shortsword
	[6984]="3441:688:2:7:1:::0:0:", -- Umbral Sword
	[6985]="3454:690:2:7:1:::0:0:", -- Haggard's Sword
	[7118]="3454:690:2:7:1:::0:0:", -- Heirloom Sword
	[6967]="3481:696:2:7:1:::0:0:", -- Elunite Sword
	[7329]="3519:703:2:7:1:::0:0:", -- Thun'grim's Sword
	[1925]="3938:787:2:7:1:::0:0:", -- Defias Rapier
	[1219]="4119:823:2:7:1:::0:0:", -- Redridge Machete
	[15210]="4128:825:2:7:1:::0:0:", -- Raider Shortsword
	[3572]="4861:972:2:7:1:::0:0:", -- Daryl's Shortsword
	[14145]="5161:1032:2:7:1:::0:0:", -- Cursed Felblade
	[2074]="5271:1054:2:7:1:::0:0:", -- Solid Shortblade
	[2078]="5350:1070:2:7:1:::0:0:", -- Northern Shortsword
	[1469]="5900:1180:2:7:1:::0:0:", -- Scimitar of Atun
	[1951]="6290:1258:2:7:1:::0:0:", -- Blackwater Cutlass
	[5321]="7423:1484:2:7:1:::0:0:", -- Elegant Shortsword
	[16891]="8485:1697:2:7:1:::0:0:", -- Claystone Shortsword
	[1937]="8500:1700:2:7:1:::0:0:", -- Buzz Saw
	[5192]="9015:1803:2:7:1:::0:0:", -- Thief's Blade
	[15211]="9584:1916:2:7:1:::0:0:", -- Militant Shortsword
	[6633]="10659:2131:2:7:1:::0:0:", -- Butcher's Slicer
	[3462]="11418:2283:2:7:1:::0:0:", -- Talonstrike
	[2035]="11503:2300:2:7:1:::0:0:", -- Sword of the Night Sky
	[3740]="12262:2452:2:7:1:::0:0:", -- Decapitating Sword
	[2046]="12307:2461:2:7:1:::0:0:", -- Bluegill Kukri
	[16890]="12416:2483:2:7:1:::0:0:", -- Slatemetal Cutlass
	[2263]="13098:2619:2:7:1:::0:0:", -- Phytoblade
	[3400]="13806:2761:2:7:1:::0:0:", -- Lucine Longsword
	[11121]="14705:2941:2:7:1:::0:0:", -- Darkwater Talwar
	[886]="14747:2949:2:7:1:::0:0:", -- Black Metal Shortsword
	[2018]="16345:3269:2:7:1:::0:0:", -- Skeletal Longsword
	[15212]="17252:3450:2:7:1:::0:0:", -- Fighter Broadsword
	[753]="19211:3842:2:7:1:::0:0:", -- Dragonmaw Shortsword
	[3186]="22180:4436:2:7:1:::0:0:", -- Viking Sword
	[3849]="27340:5468:2:7:1:::0:0:", -- Hardened Iron Shortsword
	[3850]="36523:7304:2:7:1:::0:0:", -- Jade Serpentblade
	[8224]="38278:7655:2:7:1:::0:0:", -- Silithid Ripper
	[15213]="40829:8165:2:7:1:::0:0:", -- Mercenary Blade
	[864]="48580:9716:2:7:1:::0:0:", -- Knightly Longsword
	[15214]="56781:11356:2:7:1:::0:0:", -- Nobles Brand
	[4977]="59465:11893:2:7:1:::0:0:", -- Sword of Hammerfall
	[4116]="61686:12337:2:7:1:::0:0:", -- Olmann Sewar
	[8196]="69895:13979:2:7:1:::0:0:", -- Ebon Scimitar
	[4987]="77920:15584:2:7:1:::0:0:", -- Dwarf Captain's Sword
	[7943]="79459:15891:2:7:1:::0:0:", -- Wicked Mithril Blade
	[15215]="83720:16744:2:7:1:::0:0:", -- Furious Falchion
	[19040]="97341:19468:2:7:1:::0:0:", -- Zorbin's Mega-Slicer
	[7944]="100463:20092:2:7:1:::0:0:", -- Dazzling Mithril Rapier
	[15216]="129661:25932:2:7:1:::0:0:", -- Rune Sword
	[10803]="147207:29441:2:7:1:::0:0:", -- Blade of the Wretched
	[13182]="154429:30885:2:7:1:::0:0:", -- Phase Blade
	[15217]="154980:30996:2:7:1:::0:0:", -- Widow Blade
	[15705]="169154:33830:2:7:1:::0:0:", -- Tidecrest Blade
	[11902]="170973:34194:2:7:1:::0:0:", -- Linken's Sword of Mastery
	[15801]="179303:35860:2:7:1:::0:0:", -- Valiant Shortsword
	[15800]="180413:36082:2:7:1:::0:0:", -- Intrepid Shortsword
	[15218]="185239:37047:2:7:1:::0:0:", -- Crystal Sword
	[12061]="201060:40212:2:7:1:::0:0:", -- Blade of Reckoning
	[15219]="206882:41376:2:7:1:::0:0:", -- Dimensional Blade
	[18463]="207361:41472:2:7:1:::0:0:", -- Ogre Pocket Knife
	[10696]="209454:41890:2:7:1:::0:0:", -- Enchanted Azsharite Felbane Sword
	[15814]="209558:41911:2:7:1:::0:0:", -- Hameya's Slayer
	[15782]="215714:43142:2:7:1:::0:0:", -- Beaststalker Blade
	[15220]="217465:43493:2:7:1:::0:0:", -- Battlefell Sabre
	[15221]="259732:51946:2:7:1:::0:0:", -- Holy War Sword
	[935]="8712:1742:2:7:1:::0:0:", -- Night Watch Shortsword
	[12976]="8852:1770:2:7:1:::0:0:", -- Ironpatch Blade
	[6504]="14667:2933:2:7:1:::0:0:", -- Wingblade
	[5191]="14822:2964:2:7:1:::0:0:", -- Cruel Barb
	[1482]="14822:2964:2:7:1:::0:0:", -- Shadowfang
	[2011]="19200:3840:2:7:1:::0:0:", -- Twisted Sabre
	[1493]="19610:3922:2:7:1:::0:0:", -- Heavy Marauder Scimitar
	[13032]="20693:4138:2:7:1:::0:0:", -- Sword of Corruption
	[1727]="22814:4562:2:7:1:::0:0:", -- Sword of Decay
	[16886]="27462:5492:2:7:1:::0:0:", -- Outlaw Sabre
	[8226]="28737:5747:2:7:1:::0:0:", -- The Butcher
	[12974]="30525:6105:2:7:1:::0:0:", -- The Black Knight
	[9446]="37820:7564:2:7:1:::0:0:", -- Electrocutioner Leg
	[13033]="40472:8094:2:7:1:::0:0:", -- Zealot Blade
	[8225]="46111:9222:2:7:1:::0:0:", -- Tainted Pierce
	[8223]="50333:10066:2:7:1:::0:0:", -- Blade of the Basilisk
	[9718]="57106:11421:2:7:1:::0:0:", -- Reforged Blade of Heroes
	[1265]="58874:11774:2:7:1:::0:0:", -- Scorpion Sting
	[9392]="64901:12980:2:7:1:::0:0:", -- Annealed Blade
	[9424]="67970:13594:2:7:1:::0:0:", -- Ginn-su Sword
	[13034]="73551:14710:2:7:1:::0:0:", -- Speedsteel Rapier
	[9401]="84507:16901:2:7:1:::0:0:", -- Nordic Longshank
	[10823]="88981:17796:2:7:1:::0:0:", -- Vanquisher's Sword
	[6802]="91277:18255:2:7:1:::0:0:", -- Sword of Omen
	[6829]="93572:18714:2:7:1:::0:0:", -- Sword of Serenity
	[9511]="105300:21060:2:7:1:::0:0:", -- Bloodletter Scalpel
	[754]="117784:23556:2:7:1:::0:0:", -- Shortsword of Vengeance
	[13035]="125706:25141:2:7:1:::0:0:", -- Serpent Slicer
	[7961]="127541:25508:2:7:1:::0:0:", -- Phantom Blade
	[9379]="131917:26383:2:7:1:::0:0:", -- Sang'thraze the Deflector
	[11086]="137016:27403:2:7:1:::0:0:", -- Jang'thraze the Protector
	[17054]="143942:28788:2:7:1:::0:0:", -- Joonho's Mercy
	[17719]="160530:32106:2:7:1:::0:0:", -- Inventor's Focal Sword
	[17705]="164272:32854:2:7:1:::0:0:", -- Thrash Blade
	[11784]="169177:33835:2:7:1:::0:0:", -- Arbiter's Blade
	[12535]="174629:34925:2:7:1:::0:0:", -- Doomforged Straightedge
	[10797]="175347:35069:2:7:1:::0:0:", -- Firebreather
	[8190]="186433:37286:2:7:1:::0:0:", -- Hanzo Sword
	[12777]="193242:38648:2:7:1:::0:0:", -- Blazing Rapier
	[11817]="196273:39254:2:7:1:::0:0:", -- Lord General's Sword
	[13036]="204943:40988:2:7:1:::0:0:", -- Assassination Blade
	[18310]="237032:47406:2:7:1:::0:0:", -- Fiendish Machete
	[14576]="243853:48770:2:7:1:::0:0:", -- Ebon Hilt of Marduk
	[15806]="256366:51273:2:7:1:::0:0:", -- Mirah's Song
	[13246]="268114:53622:2:7:1:::0:0:", -- Argent Avenger
	[18484]="269110:53822:2:7:1:::0:0:", -- Cho'Rush's Blade
	[12940]="274063:54812:2:7:1:::0:0:", -- Dal'Rend's Sacred Charge
	[19110]="274611:54922:2:7:1:::0:0:", -- Cold Forged Blade
	[19550]="274611:54922:2:7:1:::1:0:461", -- Legionnaire's Sword
	[19554]="274611:54922:2:7:1:::1:0:353", -- Protector's Sword
	[6622]="277000:55400:2:7:1:::0:0:", -- Sword of Zeal
	[13361]="283650:56730:2:7:1:::0:0:", -- Skullforge Reaver
	[13953]="284402:56880:2:7:1:::0:0:", -- Silent Fang
	[12797]="284716:56943:2:7:1:::0:0:", -- Frostguard
	[18396]="287583:57516:2:7:1:::0:0:", -- Mind Carver
	[12939]="301818:60363:2:7:1:::0:0:", -- Dal'Rend's Tribal Guardian
	[17015]="318693:63738:2:7:1:::0:0:", -- Dark Iron Reaver
	[869]="92648:18529:2:7:1:::0:0:", -- Dazzling Longsword
	[16345]="151892:30378:2:7:1:::0:0:", -- High Warlord's Blade
	[809]="195625:39125:2:7:1:::0:0:", -- Bloodrazor
	[12584]="248182:49636:2:7:1:::0:0:", -- Grand Marshal's Longsword
	[2244]="259289:51857:2:7:1:::0:0:", -- Krol Blade
	[10847]="284608:56921:2:7:1:::0:0:", -- Dragon's Call
	[19168]="514451:102890:2:7:1:::0:0:", -- Blackguard
	[18832]="520447:104089:2:7:1:::0:0:", -- Brutality Blade
	[17103]="559117:111823:2:7:1:::0:0:", -- Azuresong Mageblade
	[18348]="563257:112651:2:7:1:::0:0:", -- Quel'Serrar
	[17075]="676334:135266:2:7:1:::0:0:", -- Vis'kag the Bloodletter
	[19351]="699948:139989:2:7:1:::0:0:", -- Maladath, Runed Blade of the Black Flight
	[19019]="1258828:251765:2:7:1:::0:0:", -- Thunderfury, Blessed Blade of the Windseeker
	[1412]="246:49:2:8:1:::0:0:", -- Crude Bastard Sword
	[1513]="1465:293:2:8:1:::0:0:", -- Old Greatsword
	[1811]="2255:451:2:8:1:::0:0:", -- Blunt Claymore
	[1818]="6109:1221:2:8:1:::0:0:", -- Standard Claymore
	[1830]="8919:1783:2:8:1:::0:0:", -- Long Bastard Sword
	[3781]="15628:3125:2:8:1:::0:0:", -- Broad Claymore
	[4018]="31863:6372:2:8:1:::0:0:", -- Whetted Claymore
	[13817]="93984:18796:2:8:1:::0:0:", -- Tapered Greatsword
	[2754]="69:13:2:8:1:::0:0:", -- Tarnished Bastard Sword
	[1194]="104:20:2:8:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Bastard Sword
	[5779]="152:30:2:8:1:::0:0:", -- Forsaken Bastard Sword
	[2489]="342:68:2:8:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,814,823", -- Two-handed Sword
	[8177]="358:71:2:8:1:::0:0:", -- Practice Sword
	[7955]="1208:241:2:8:1:::0:0:", -- Copper Claymore
	[1198]="2676:535:2:8:1:::1:0:88,227,274,292,329,393,429,443,460,532,560,613,614,724,823", -- Claymore
	[2024]="6078:1215:2:8:1:::1:1:88,227,231,274,292,329,390,443,460,560,724", -- Espadon
	[7957]="11028:2205:2:8:1:::0:0:", -- Bronze Greatsword
	[922]="12038:2407:2:8:1:::1:0:1,84,85,88,227,231,292,329,443,460,560,646,724,865", -- Dacian Falx
	[6741]="15072:3014:2:8:1:::0:0:", -- Orcish War Sword
	[2521]="30896:6179:2:8:1:::1:0:1,88,227,235,240,329,341,435,460,563,665,772,836,865,882,894", -- Flamberge
	[2529]="65031:13006:2:8:1:::1:0:88,202,227,235,240,288,327,329,341,435,460,574,745,772,855", -- Zweihander
	[9602]="1504:300:2:8:1:::0:0:", -- Brushwood Blade
	[8178]="1531:306:2:8:1:::0:0:", -- Training Sword
	[4939]="1977:395:2:8:1:::0:0:", -- Steady Bastard Sword
	[3192]="2479:495:2:8:1:::0:0:", -- Short Bastard Sword
	[3188]="4398:879:2:8:1:::0:0:", -- Coral Claymore
	[4567]="5247:1049:2:8:1:::0:0:", -- Merc Sword
	[1566]="5663:1132:2:8:1:::0:0:", -- Edge of the People's Militia
	[2204]="5665:1133:2:8:1:::0:0:", -- Brashclaw's Skewer
	[6186]="6864:1372:2:8:1:::0:0:", -- Trogg Slicer
	[3196]="6886:1377:2:8:1:::0:0:", -- Edged Bastard Sword
	[2822]="7012:1402:2:8:1:::0:0:", -- Mo'grosh Toothpick
	[11854]="7472:1494:2:8:1:::0:0:", -- Samophlange Screwdriver
	[3487]="7490:1498:2:8:1:::0:0:", -- Heavy Copper Broadsword
	[1387]="7892:1578:2:8:1:::0:0:", -- Ghoulfang
	[1460]="8842:1768:2:8:1:::0:0:", -- Shadowhide Two-handed Sword
	[5182]="8849:1769:2:8:1:::0:0:", -- Shiver Blade
	[5615]="8883:1776:2:8:1:::0:0:", -- Woodsman Sword
	[15248]="8959:1791:2:8:1:::0:0:", -- Gleaming Claymore
	[4817]="12311:2462:2:8:1:::1:1:30,84,85,529,599,646,652,802", -- Blessed Claymore
	[4818]="14273:2854:2:8:1:::1:1:30,84,85,529,599,646,652,802", -- Executioner's Sword
	[6641]="18376:3675:2:8:1:::0:0:", -- Haunting Blade
	[15249]="19388:3877:2:8:1:::0:0:", -- Polished Zweihander
	[3206]="22910:4582:2:8:1:::0:0:", -- Cavalier Two-hander
	[2014]="24346:4869:2:8:1:::0:0:", -- Black Metal Greatsword
	[2084]="28547:5709:2:8:1:::0:0:", -- Darksteel Bastard Sword
	[5614]="30735:6147:2:8:1:::0:0:", -- Seraph's Strike
	[3822]="32405:6481:2:8:1:::0:0:", -- Runic Darkblade
	[3209]="33917:6783:2:8:1:::0:0:", -- Ancient War Sword
	[15250]="34474:6894:2:8:1:::0:0:", -- Glimmering Flamberge
	[5813]="35439:7087:2:8:1:::0:0:", -- Emil's Brand
	[2000]="44136:8827:2:8:1:::0:0:", -- Archeus
	[3197]="46478:9295:2:8:1:::0:0:", -- Stonecutter Claymore
	[3853]="50768:10153:2:8:1:::0:0:", -- Moonsteel Broadsword
	[3854]="70603:14120:2:8:1:::0:0:", -- Frost Tiger Blade
	[1625]="73773:14754:2:8:1:::0:0:", -- Exquisite Flamberge
	[1986]="74309:14861:2:8:1:::0:0:", -- Gutrender
	[15251]="88428:17685:2:8:1:::0:0:", -- Headstriker Sword
	[1604]="97319:19463:2:8:1:::0:0:", -- Chromatic Sword
	[8199]="123306:24661:2:8:1:::0:0:", -- Battlefield Destroyer
	[15252]="139530:27906:2:8:1:::0:0:", -- Tusker Sword
	[15253]="157738:31547:2:8:1:::0:0:", -- Beheading Blade
	[15254]="177922:35584:2:8:1:::0:0:", -- Dark Espadon
	[15255]="212728:42545:2:8:1:::0:0:", -- Gallant Flamberge
	[18410]="227582:45516:2:8:1:Buff::0:0:", -- Sprinter's Sword
	[15256]="237656:47531:2:8:1:::0:0:", -- Massacre Sword
	[15257]="276172:55234:2:8:1:::0:0:", -- Shin Blade
	[15258]="320928:64185:2:8:1:::0:0:", -- Divine Warblade
	[12992]="16302:3260:2:8:1:::0:0:", -- Searing Blade
	[2205]="19806:3961:2:8:1:::0:0:", -- Duskbringer
	[13041]="22582:4516:2:8:1:::0:0:", -- Guardian Blade
	[3417]="23146:4629:2:8:1:::0:0:", -- Onyx Claymore
	[1975]="28721:5744:2:8:1:::0:0:", -- Pysan's Old Greatsword
	[9490]="30609:6121:2:8:1:::0:0:", -- Gizmotron Megachopper
	[13049]="30958:6191:2:8:1:::0:0:", -- Deanship Claymore
	[6909]="35777:7155:2:8:1:::0:0:", -- Strike of the Hydra
	[2877]="42623:8524:2:8:1:::0:0:", -- Combatant Claymore
	[7689]="55621:11124:2:8:1:::0:0:", -- Morbid Dawn
	[9385]="61404:12280:2:8:1:::0:0:", -- Archaic Defender
	[10573]="68773:13754:2:8:1:::0:0:", -- Boneslasher
	[6977]="86627:17325:2:8:1:::0:0:", -- Whirlwind Sword
	[13042]="87983:17596:2:8:1:::0:0:", -- Sword of the Magistrate
	[10758]="100723:20144:2:8:1:::0:0:", -- X'caliboar
	[13051]="114557:22911:2:8:1:::0:0:", -- Witchfury
	[10628]="146225:29245:2:8:1:::0:0:", -- Deathblow
	[13043]="161949:32389:2:8:1:::0:0:", -- Blade of the Titans
	[9418]="164258:32851:2:8:1:::0:0:", -- Stoneslayer
	[7960]="192743:38548:2:8:1:::0:0:", -- Truesilver Champion
	[13052]="208388:41677:2:8:1:::0:0:", -- Warmonger
	[12463]="212231:42446:2:8:1:::0:0:", -- Drakefang Butcher
	[11786]="253699:50739:2:8:1:::0:0:", -- Stone of the Earth
	[13044]="264000:52800:2:8:1:::0:0:", -- Demonslayer
	[16039]="267990:53598:2:8:1:::0:0:", -- Ta'Kierthan Songblade
	[12782]="284042:56808:2:8:1:::0:0:", -- Corruption
	[13053]="295933:59186:2:8:1:::0:0:", -- Doombringer
	[14541]="342132:68426:2:8:1:::0:0:", -- Barovian Family Sword
	[18520]="343264:68652:2:8:1:::0:0:", -- Barbarous Blade
	[13163]="347688:69537:2:8:1:::0:0:", -- Relentless Scythe
	[13982]="349130:69826:2:8:1:::0:0:", -- Warblade of Caer Darrow
	[13348]="363849:72769:2:8:1:::0:0:", -- Demonshear
	[12790]="373098:74619:2:8:1:::0:0:", -- Arcanite Champion
	[1982]="147568:29513:2:8:1:::0:0:", -- Nightblade
	[18877]="185217:37043:2:8:1:::0:0:", -- High Warlord's Greatsword
	[18876]="300592:60118:2:8:1:::0:0:", -- Grand Marshal's Claymore
	[9372]="309681:61936:2:8:1:::0:0:", -- Sul'thraze the Lasher
	[647]="350121:70024:2:8:1:::0:0:", -- Destiny
	[13505]="456725:91345:2:8:1:::0:0:", -- Runeblade of Baron Rivendare
	[12592]="476207:95241:2:8:1:::0:0:", -- Blackblade of Shahram
	[2801]="523648:104729:2:8:1:::0:0:", -- Blade of Hanna
	[18542]="626393:125278:2:8:1:::0:0:", -- Typhoon
	[18822]="628843:125768:2:8:1:::0:0:", -- Obsidian Edged Blade
	[19334]="802268:160453:2:8:1:::0:0:", -- The Untamed Blade
	[17076]="982192:196438:2:8:1:::0:0:", -- Bonereaver's Edge
	[1411]="343:68:2:10:1:::0:0:", -- Withered Staff
	[1515]="984:196:2:10:1:::0:0:", -- Rough Wooden Staff
	[1813]="2614:522:2:10:1:::0:0:", -- Chipped Quarterstaff
	[1822]="5484:1096:2:10:1:::0:0:", -- Cedar Walking Stick
	[1831]="8953:1790:2:10:1:::0:0:", -- Oaken War Staff
	[3784]="21042:4208:2:10:1:::0:0:", -- Metal Stave
	[4024]="49109:9821:2:10:1:::0:0:", -- Heavy War Staff
	[13823]="59622:11924:2:10:1:::0:0:", -- Stout War Staff
	[3661]="45:9:2:10:1:::0:0:", -- Handcrafted Staff
	[35]="47:9:2:10:1:::0:0:", -- Bent Staff
	[1388]="71:14:2:10:1:::0:0:", -- Crooked Staff
	[2132]="102:20:2:10:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Short Staff
	[5776]="150:30:2:10:1:::0:0:", -- Elder's Cane
	[3277]="150:30:2:10:1:::0:0:", -- Executor Staff
	[5778]="151:30:2:10:1:::0:0:", -- Primitive Walking Stick
	[1159]="160:32:2:10:1:::0:0:", -- Militia Quarterstaff
	[5393]="160:32:2:10:1:::0:0:", -- Thistlewood Staff
	[5581]="161:32:2:10:1:::0:0:", -- Smooth Walking Staff
	[3335]="230:46:2:10:1:::0:0:", -- Farmer's Broom
	[1010]="498:99:2:10:1:::0:0:", -- Gnarled Short Staff
	[767]="504:100:2:10:1:::0:0:", -- Long Bo Staff
	[2495]="504:100:2:10:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,814,823,886", -- Walking Stick
	[3327]="708:141:2:10:1:::0:0:", -- Vile Fin Oracle Staff
	[7094]="871:174:2:10:1:::0:0:", -- Driftwood Branch
	[4961]="918:183:2:10:1:::0:0:", -- Dreamwatcher Staff
	[2067]="931:186:2:10:1:::0:0:", -- Frostbit Staff
	[2257]="944:188:2:10:1:::0:0:", -- Frostmane Staff
	[4938]="1182:236:2:10:1:::0:0:", -- Blemished Wooden Staff
	[854]="3022:604:2:10:1:::1:0:68,271,274,292,393,429,462,487,532,560,613,614,823,886", -- Quarter Staff
	[2030]="5544:1108:2:10:1:::1:0:68,231,271,274,292,390,462,487,560,886", -- Gnarled Staff
	[928]="9860:1972:2:10:1:::1:0:1,68,84,85,231,271,292,462,487,560,646,865,886", -- Long Staff
	[2527]="29356:5871:2:10:1:::1:0:17,20,66,68,399,462,563,597,600,665,815,836,865,882,894", -- Battle Staff
	[2535]="61556:12311:2:10:1:::1:0:17,20,66,202,288,327,399,462,574,597,600,745,815,855", -- War Staff
	[9603]="1510:302:2:10:1:::0:0:", -- Gritroot Staff
	[9513]="1526:305:2:10:1:::0:0:", -- Ley Staff
	[9514]="1532:306:2:10:1:::0:0:", -- Arcane Staff
	[3446]="2963:592:2:10:1:::0:0:", -- Darkwood Staff
	[6215]="3009:601:2:10:1:::0:0:", -- Balanced Fighting Stick
	[4566]="3157:631:2:10:1:::0:0:", -- Sturdy Quarterstaff
	[15397]="3656:731:2:10:1:::0:0:", -- Oakthrush Staff
	[1933]="4528:905:2:10:1:::0:0:", -- Staff of Conjuring
	[5340]="4596:919:2:10:1:::0:0:", -- Cauldron Stirrer
	[1928]="4979:995:2:10:1:::0:0:", -- Defias Mage Staff
	[1405]="5923:1184:2:10:1:::0:0:", -- Foamspittle Staff
	[3902]="6588:1317:2:10:1:::0:0:", -- Staff of Nobles
	[1391]="6961:1392:2:10:1:::0:0:", -- Riverpaw Mystic Staff
	[15444]="7023:1404:2:10:1:::0:0:", -- Staff of Orgrimmar
	[4575]="7435:1487:2:10:1:::0:0:", -- Medicine Staff
	[1473]="7489:1497:2:10:1:::0:0:", -- Riverside Staff
	[1539]="7861:1572:2:10:1:::0:0:", -- Gnarled Hermit's Staff
	[5306]="8554:1710:2:10:1:::0:0:", -- Wind Rider Staff
	[1300]="9270:1854:2:10:1:::0:0:", -- Lesser Staff of the Spire
	[4437]="9278:1855:2:10:1:::0:0:", -- Channeler's Staff
	[16894]="9967:1993:2:10:1:::0:0:", -- Clear Crystal Rod
	[3452]="11610:2322:2:10:1:::0:0:", -- Ceranium Rod
	[3227]="13169:2633:2:10:1:::0:0:", -- Nightbane Staff
	[5613]="13177:2635:2:10:1:::0:0:", -- Staff of the Purifier
	[880]="13460:2692:2:10:1:::0:0:", -- Staff of Horrors
	[16889]="15467:3093:2:10:1:::0:0:", -- Polished Walking Staff
	[15109]="16723:3344:2:10:1:::0:0:", -- Staff of Soran'ruk
	[2950]="17384:3476:2:10:1:::0:0:", -- Icicle Rod
	[1317]="17501:3500:2:10:1:::0:0:", -- Hardened Root Staff
	[2013]="18222:3644:2:10:1:::0:0:", -- Cryptbone Staff
	[2280]="20117:4023:2:10:1:::0:0:", -- Kam's Walking Stick
	[2226]="20589:4117:2:10:1:::0:0:", -- Ogremage Staff
	[2072]="22070:4414:2:10:1:::0:0:", -- Dwarven Magestaff
	[2077]="25295:5059:2:10:1:::0:0:", -- Magician Staff
	[1998]="36199:7239:2:10:1:::0:0:", -- Bloodscalp Channeling Staff
	[3185]="40440:8088:2:10:1:::0:0:", -- Acrobatic Staff
	[12251]="53896:10779:2:10:1:::1:1:521,882,894", -- Big Stick
	[12252]="63095:12619:2:10:1:::1:1:882", -- Staff of Protection
	[9517]="65572:13114:2:10:1:::0:0:", -- Celestial Stave
	[15105]="71989:14397:2:10:1:::0:0:", -- Staff of Noh'Orahil
	[15106]="72237:14447:2:10:1:::0:0:", -- Staff of Dar'Orahil
	[1664]="73475:14695:2:10:1:::0:0:", -- Spellforce Rod
	[866]="83204:16640:2:10:1:::0:0:", -- Monk's Staff
	[1613]="95699:19139:2:10:1:::0:0:", -- Spiritchaser Staff
	[11857]="106888:21377:2:10:1:::0:0:", -- Sanctimonial Rod
	[9527]="108069:21613:2:10:1:::0:0:", -- Spellshifter Rod
	[4134]="112477:22495:2:10:1:::0:0:", -- Nimboya's Mystical Staff
	[10826]="127506:25501:2:10:1:::0:0:", -- Staff of Lore
	[9683]="149764:29952:2:10:1:::0:0:", -- Strength of the Treant
	[15274]="158334:31666:2:10:1:::0:0:", -- Diviner Long Staff
	[15275]="178574:35714:2:10:1:::0:0:", -- Thaumaturgist Staff
	[15276]="226315:45263:2:10:1:::0:0:", -- Magus Long Staff
	[15278]="251429:50285:2:10:1:::0:0:", -- Solstice Staff
	[10698]="263735:52747:2:10:1:::0:0:", -- Enchanted Azsharite Felbane Staff
	[18353]="275154:55030:2:10:1:::0:0:", -- Stoneflower Staff
	[17004]="282145:56429:2:10:1:::0:0:", -- Sarah's Guide
	[1484]="14612:2922:2:10:1:::0:0:", -- Witching Stave
	[5201]="15809:3161:2:10:1:::0:0:", -- Emberstone Staff
	[2271]="16278:3255:2:10:1:::0:0:", -- Staff of the Blessed Seer
	[890]="17588:3517:2:10:1:::0:0:", -- Twisted Chanter's Staff
	[3415]="17993:3598:2:10:1:::0:0:", -- Staff of the Friar
	[2042]="18195:3639:2:10:1:::0:0:", -- Staff of Westfall
	[6505]="18401:3680:2:10:1:::0:0:", -- Crescent Staff
	[6631]="20266:4053:2:10:1:::0:0:", -- Living Root
	[7713]="23886:4777:2:10:1:::0:0:", -- Illusionary Rod
	[6318]="24014:4802:2:10:1:::0:0:", -- Odo's Ley Staff
	[2549]="25082:5016:2:10:1:::0:0:", -- Staff of the Shade
	[1155]="29770:5954:2:10:1:::0:0:", -- Rod of the Sleepwalker
	[791]="35347:7069:2:10:1:::0:0:", -- Gnarled Ash Staff
	[9452]="41051:8210:2:10:1:Buff::0:0:", -- Hydrocane
	[6689]="41336:8267:2:10:1:::0:0:", -- Wind Spirit Staff
	[7710]="61398:12279:2:10:1:::0:0:", -- Loksey's Training Stick
	[7757]="64374:12874:2:10:1:::0:0:", -- Windweaver Staff
	[937]="72885:14577:2:10:1:::0:0:", -- Black Duskwood Staff
	[9408]="93198:18639:2:10:1:::0:0:", -- Ironshod Bludgeon
	[1720]="131048:26209:2:10:1:::0:0:", -- Tanglewood Staff
	[10627]="134870:26974:2:10:1:::0:0:", -- Bludgeon of the Grinning Dog
	[18082]="140809:28161:2:10:1:::0:0:", -- Zum'rah's Vexing Cane
	[9482]="147925:29585:2:10:1:::0:0:", -- Witch Doctor's Cane
	[9477]="179682:35936:2:10:1:::0:0:", -- The Chief's Enforcer
	[19567]="200979:40195:2:10:1:::1:0:461", -- Advisor's Gnarled Staff
	[17743]="203739:40747:2:10:1:::0:0:", -- Resurgence Rod
	[11750]="216171:43234:2:10:1:::0:0:", -- Kindling Stave
	[1607]="217103:43420:2:10:1:::0:0:", -- Soulkeeper
	[10844]="221570:44314:2:10:1:::0:0:", -- Spire of Hakkar
	[12532]="242506:48501:2:10:1:::0:0:", -- Spire of the Stoneshaper
	[18311]="283224:56644:2:10:1:::0:0:", -- Quel'dorai Channeling Rod
	[11932]="291612:58322:2:10:1:::0:0:", -- Guiding Stave of Wisdom
	[13372]="318845:63769:2:10:1:::0:0:", -- Slavedriver's Cane
	[15854]="322514:64502:2:10:1:::0:0:", -- Dancing Sliver
	[13000]="326129:65225:2:10:1:::0:0:", -- Staff of Hale Magefire
	[13161]="328748:65749:2:10:1:::0:0:", -- Trindlehaven Staff
	[13249]="338914:67782:2:10:1:::0:0:", -- Argent Crusader
	[19566]="350857:70171:2:10:1:::1:0:461", -- Advisor's Gnarled Staff
	[19570]="356148:71229:2:10:1:::1:0:353", -- Lorekeeper's Staff
	[18534]="357515:71503:2:10:1:::0:0:", -- Rod of the Ogre Magi
	[19101]="397057:79411:2:10:1:::1:0:287,416", -- Whiteout Staff
	[19102]="398525:79705:2:10:1:::1:0:224,774", -- Crackling Staff
	[18609]="0:0:2:10:1:::0:0:", -- Anathema
	[18608]="0:0:2:10:1:::0:0:", -- Benediction
	[873]="108853:21770:2:10:1:::0:0:", -- Staff of Jordan
	[18874]="183196:36639:2:10:1:::0:0:", -- High Warlord's War Staff
	[943]="214318:42863:2:10:1:::0:0:", -- Warden Staff
	[812]="285093:57018:2:10:1:::0:0:", -- Glowing Brightwood Staff
	[18873]="297299:59459:2:10:1:::0:0:", -- Grand Marshal's Stave
	[944]="415003:83000:2:10:1:::0:0:", -- Elemental Mage Staff
	[13937]="435067:87013:2:10:1:::0:0:", -- Headmaster's Charge
	[17113]="596390:119278:2:10:1:::0:0:", -- Amberseal Keeper
	[18842]="693232:138646:2:10:1:::0:0:", -- Staff of Dominance
	[19355]="824178:164835:2:10:1:::0:0:", -- Shadow Wing Focus Staff
	[18715]="903890:180778:2:10:1:::0:0:", -- Lok'delar, Stave of the Ancient Keepers
	[15905]="2130:426:2:13:1:::1:1:460,724,772", -- Right-Handed Brass Knuckles
	[15906]="2138:427:2:13:1:::1:1:460,724,772", -- Left-Handed Brass Knuckles
	[15903]="8117:1623:2:13:1:::1:1:227,460,724,772", -- Right-Handed Claw
	[15907]="8237:1647:2:13:1:::1:1:227,460,724,772", -- Left-Handed Claw
	[7683]="19792:3958:2:13:1:::0:0:", -- Bloody Brass Knuckles
	[15904]="21708:4341:2:13:1:::1:1:460,724,772", -- Right-Handed Blades
	[15909]="22107:4421:2:13:1:::1:1:724,772", -- Left-Handed Blades
	[11863]="135957:27191:2:13:1:::0:0:", -- White Bone Shredder
	[11743]="153672:30734:2:13:1:::0:0:", -- Rockfist
	[18462]="206595:41319:2:13:1:::0:0:", -- Jagged Bone Fist
	[2942]="18316:3663:2:13:1:::0:0:", -- Iron Knuckles
	[11603]="153283:30656:2:13:1:::0:0:", -- Vilerend Slicer
	[17738]="166758:33351:2:13:1:::0:0:", -- Claw of Celebras
	[11744]="196213:39242:2:13:1:::0:0:", -- Bloodfist
	[13399]="231560:46312:2:13:1:::0:0:", -- Gargoyle Shredder Talons
	[13198]="254256:50851:2:13:1:::0:0:", -- Hurd Smasher
	[18843]="151451:30290:2:13:1:::0:0:", -- Grand Marshal's Right Knuckles
	[18844]="151995:30399:2:13:1:::0:0:", -- High Warlord's Right Claw
	[18847]="153612:30722:2:13:1:::0:0:", -- Grand Marshal's Left Knuckles
	[18848]="154141:30828:2:13:1:::0:0:", -- High Warlord's Left Claw
	[18202]="452881:90576:2:13:1:::0:0:", -- Eskhandar's Left Claw
	[18203]="454525:90905:2:13:1:::0:0:", -- Eskhandar's Right Claw
	[19365]="684643:136928:2:13:1:::0:0:", -- Claw of the Black Drake
	[4616]="17:3:2:14:1:::0:0:", -- Ryedol's Lucky Pick
	[5956]="18:3:2:14:1:::1:0:3,23,27,47,48,59,64,91,107,120,121,141,166,167,178,185,203,205,208,213,215,225,233,241,246,253,255,273,283,291,311,315,335,348,352,395,401,413,437,442,466,467,478,493,495,507,510,529,538,539,568,572,578,579,594,605,609,620,623,672,689,718,722,736,740,753,754,758,766,775,782,788,795,803,805,806,816,838,854,863,870,879,893", -- Blacksmith Hammer
	[2901]="81:16:2:14:1:::1:0:3,23,27,47,48,59,64,91,100,107,120,121,139,141,166,167,178,185,203,205,208,213,215,225,233,241,246,252,253,255,257,263,273,283,291,305,311,315,333,335,348,352,395,401,404,413,419,437,442,445,457,466,467,478,493,495,507,510,529,538,539,542,553,568,572,578,579,594,605,609,620,623,625,663,672,689,716,718,722,736,740,742,753,754,757,758,766,775,776,782,788,795,803,805,806,816,838,854,861,863,870,879,893", -- Mining Pick
	[7005]="82:16:2:14:1:::1:0:3,22,23,27,29,47,48,70,76,121,125,139,141,166,167,168,178,185,203,205,209,213,236,246,253,255,263,299,305,306,322,333,397,404,423,457,466,478,495,500,507,514,520,529,538,579,594,605,620,625,630,657,663,672,684,693,716,718,722,754,757,758,761,766,775,791,803,810,816,838,848,854,857,863,874,893", -- Skinning Knife
	[6219]="721:144:2:14:1:::0:0:", -- Arclight Spanner
	[2138]="192:38:2:15:1:::0:0:", -- Sharpened Letter Opener
	[2763]="1203:240:2:15:1:::0:0:", -- Fisherman Knife
	[5516]="1589:317:2:15:1:::0:0:", -- Threshadon Fang
	[2764]="2202:440:2:15:1:::0:0:", -- Small Dagger
	[2765]="4057:811:2:15:1:::0:0:", -- Hunting Knife
	[2766]="7823:1564:2:15:1:::0:0:", -- Deft Stiletto
	[3786]="19785:3957:2:15:1:::0:0:", -- Shiny Dirk
	[4023]="31079:6215:2:15:1:::0:0:", -- Fine Pointed Dagger
	[13822]="57212:11442:2:15:1:::0:0:", -- Spiked Dagger
	[5040]="0:0:2:15:1:::0:0:", -- Shadow Hunter Knife
	[2092]="35:7:2:15:1:::0:0:", -- Worn Dagger
	[2787]="53:10:2:15:1:::0:0:", -- Trogg Dagger
	[3296]="54:10:2:15:1:::0:0:", -- Deadman Dagger
	[2139]="57:11:2:15:1:::1:0:25,161,256,274,325,400,469,504,566,692,823", -- Dirk
	[2224]="122:24:2:15:1:::0:0:", -- Militia Dagger
	[2137]="124:24:2:15:1:::0:0:", -- Whittling Knife
	[2195]="127:25:2:15:1:::0:0:", -- Anvilmar Knife
	[5392]="127:25:2:15:1:::0:0:", -- Thistlewood Dagger
	[3268]="128:25:2:15:1:::0:0:", -- Forsaken Dagger
	[4925]="129:25:2:15:1:::0:0:", -- Primitive Hand Blade
	[4565]="193:38:2:15:1:::0:0:", -- Simple Dagger
	[2494]="401:80:2:15:1:::1:0:129,161,217,256,266,274,436,550,639,714,729,798,804,814,823", -- Stiletto
	[10547]="408:81:2:15:1:::0:0:", -- Camping Knife
	[3225]="548:109:2:15:1:::0:0:", -- Bloodstained Knife
	[4840]="713:142:2:15:1:::0:0:", -- Long Bayonet
	[4302]="732:146:2:15:1:::0:0:", -- Small Green Dagger
	[5605]="750:150:2:15:1:::0:0:", -- Pruning Knife
	[2225]="916:183:2:15:1:::0:0:", -- Sharp Kitchen Knife
	[7166]="973:194:2:15:1:::0:0:", -- Copper Dagger
	[3445]="1133:226:2:15:1:::0:0:", -- Ceremonial Knife
	[5093]="1238:247:2:15:1:::0:0:", -- Razormane Backstabber
	[2207]="2390:478:2:15:1:::1:0:88,227,274,292,329,393,429,443,460,532,560,613,614,724,823", -- Jambiya
	[2208]="3650:730:2:15:1:::1:0:88,227,231,274,292,329,390,443,460,560,724", -- Poniard
	[2169]="4717:943:2:15:1:::0:0:", -- Buzzer Blade
	[2209]="7115:1423:2:15:1:::1:0:1,84,85,88,227,231,292,329,443,460,560,646,724,865", -- Kris
	[6681]="15622:3124:2:15:1:::0:0:", -- Thornspike
	[2526]="19336:3867:2:15:1:::1:0:1,88,227,235,329,330,341,435,443,460,563,665,724,836,865,882,894", -- Main Gauche
	[2534]="45431:9086:2:15:1:::1:0:88,202,235,288,327,329,330,341,435,443,574,724,745,855", -- Rondel
	[1917]="1256:251:2:15:1:::0:0:", -- Jeweled Dagger
	[816]="1527:305:2:15:1:::0:0:", -- Small Hand Blade
	[2140]="1616:323:2:15:1:::0:0:", -- Carving Knife
	[4947]="1627:325:2:15:1:::0:0:", -- Jagged Dagger
	[4974]="1940:388:2:15:1:::0:0:", -- Compact Fighting Knife
	[7298]="2344:468:2:15:1:::0:0:", -- Blade of Cunning
	[2266]="2396:479:2:15:1:::0:0:", -- Stonesplinter Dagger
	[2218]="2505:501:2:15:1:::0:0:", -- Craftsman's Dagger
	[15396]="2913:582:2:15:1:::0:0:", -- Curvewood Dagger
	[2632]="3029:605:2:15:1:::0:0:", -- Curved Dagger
	[6980]="3389:677:2:15:1:::0:0:", -- Haggard's Dagger
	[6981]="3402:680:2:15:1:::0:0:", -- Umbral Dagger
	[7116]="3428:685:2:15:1:::0:0:", -- Heirloom Dagger
	[7327]="3493:698:2:15:1:::0:0:", -- Thun'grim's Dagger
	[6969]="3506:701:2:15:1:::0:0:", -- Elunite Dagger
	[1287]="3518:703:2:15:1:::0:0:", -- Giant Tarantula Fang
	[2088]="3648:729:2:15:1:::0:0:", -- Long Crawler Limb
	[5112]="3651:730:2:15:1:::0:0:", -- Ritual Blade
	[820]="4738:947:2:15:1:::0:0:", -- Slicer Blade
	[4571]="4896:979:2:15:1:::0:0:", -- War Knife
	[3581]="5230:1046:2:15:1:::0:0:", -- Serrated Knife
	[2020]="5249:1049:2:15:1:::0:0:", -- Hollowfang Blade
	[14151]="5279:1055:2:15:1:::0:0:", -- Chanting Blade
	[2089]="5567:1113:2:15:1:::0:0:", -- Scrimshaw Dagger
	[1936]="5569:1113:2:15:1:::0:0:", -- Goblin Screwdriver
	[15443]="5598:1119:2:15:1:::0:0:", -- Kris of Orgrimmar
	[899]="6241:1248:2:15:1:::0:0:", -- Venom Web Fang
	[2235]="6406:1281:2:15:1:::0:0:", -- Brackclaw
	[5627]="6896:1379:2:15:1:::0:0:", -- Relic Blade
	[3184]="6973:1394:2:15:1:::0:0:", -- Hook Dagger
	[2908]="7048:1409:2:15:1:::0:0:", -- Thornblade
	[3848]="7130:1426:2:15:1:::0:0:", -- Big Bronze Knife
	[5279]="7184:1436:2:15:1:::0:0:", -- Harpy Skinner
	[6333]="9645:1929:2:15:1:::0:0:", -- Spikelash Dagger
	[6448]="9714:1942:2:15:1:::0:0:", -- Tail Spike
	[5540]="10539:2107:2:15:1:::0:0:", -- Pearl-handled Dagger
	[3490]="13658:2731:2:15:1:::0:0:", -- Deadly Bronze Poniard
	[15241]="15060:3012:2:15:1:::0:0:", -- Battle Knife
	[5752]="15548:3109:2:15:1:::0:0:", -- Wyvern Tailspike
	[4449]="16662:3332:2:15:1:::0:0:", -- Naraxis' Fang
	[2819]="19152:3830:2:15:1:::0:0:", -- Cross Dagger
	[3336]="19933:3986:2:15:1:::0:0:", -- Flesh Piercer
	[15242]="22133:4426:2:15:1:::0:0:", -- Honed Stiletto
	[12247]="28372:5674:2:15:1:::1:1:231,646", -- Broad Bladed Knife
	[12248]="32029:6405:2:15:1:::1:1:435,521,563,836", -- Daring Dirk
	[15243]="39357:7871:2:15:1:::0:0:", -- Deadly Kris
	[12259]="40363:8072:2:15:1:::0:0:", -- Glinting Steel Dagger
	[1465]="49124:9824:2:15:1:::0:0:", -- Tigerbane
	[12260]="51977:10395:2:15:1:::0:0:", -- Searing Golden Blade
	[9520]="57309:11461:2:15:1:::0:0:", -- Silent Hunter
	[15244]="63848:12769:2:15:1:::0:0:", -- Razor Blade
	[9680]="70451:14090:2:15:1:::0:0:", -- Tok'kar's Murloc Shanker
	[3187]="74353:14870:2:15:1:::0:0:", -- Sacrificial Kris
	[11856]="78876:15775:2:15:1:::0:0:", -- Ceremonial Elven Blade
	[10703]="83963:16792:2:15:1:::0:0:", -- Fiendish Skiv
	[4088]="92615:18523:2:15:1:::0:0:", -- Dreadblade
	[9467]="93409:18681:2:15:1:::0:0:", -- Gahz'rilla Fang
	[15245]="116423:23284:2:15:1:::0:0:", -- Vorpal Dagger
	[7947]="124460:24892:2:15:1:::0:0:", -- Ebon Shiv
	[15706]="169154:33830:2:15:1:::0:0:", -- Hunt Tracker Blade
	[12062]="201827:40365:2:15:1:::0:0:", -- Skilled Fighting Blade
	[10697]="210221:42044:2:15:1:::0:0:", -- Enchanted Azsharite Felbane Dagger
	[15783]="216460:43292:2:15:1:::0:0:", -- Beasthunter Dagger
	[15246]="228524:45704:2:15:1:::0:0:", -- Demon Blade
	[15247]="252880:50576:2:15:1:::0:0:", -- Bloodstrike Dagger
	[2567]="12546:2509:2:15:1:::0:0:", -- Evocator's Blade
	[1935]="14874:2974:2:15:1:::0:0:", -- Assassin's Blade
	[3413]="16147:3229:2:15:1:::0:0:", -- Doomspike
	[2236]="16931:3386:2:15:1:::0:0:", -- Blackfang
	[2941]="17761:3552:2:15:1:::0:0:", -- Prison Shank
	[4446]="17972:3594:2:15:1:::0:0:", -- Blackvenom Blade
	[4454]="19001:3800:2:15:1:::0:0:", -- Talon of Vultros
	[7714]="19174:3834:2:15:1:::0:0:", -- Hypnotic Blade
	[6904]="23326:4665:2:15:1:::0:0:", -- Bite of Serra'kis
	[6220]="24468:4893:2:15:1:::0:0:", -- Meteor Shard
	[776]="28826:5765:2:15:1:::0:0:", -- Vendetta
	[9453]="32961:6592:2:15:1:::0:0:", -- Toxic Revenger
	[2912]="33656:6731:2:15:1:::0:0:", -- Claw of the Shadowmancer
	[7682]="38392:7678:2:15:1:::0:0:", -- Torturing Poker
	[6691]="44332:8866:2:15:1:::0:0:", -- Swinetusk Shank
	[6331]="47333:9466:2:15:1:::0:0:", -- Howling Blade
	[9384]="48947:9789:2:15:1:::0:0:", -- Stonevault Shiv
	[5756]="50134:10026:2:15:1:::0:0:", -- Sliverblade
	[8006]="62360:12472:2:15:1:::0:0:", -- The Ziggler
	[10761]="85966:17193:2:15:1:::0:0:", -- Coldrage Dagger
	[6831]="87613:17522:2:15:1:::0:0:", -- Black Menace
	[4091]="112398:22479:2:15:1:::0:0:", -- Widowmaker
	[5616]="113690:22738:2:15:1:::0:0:", -- Gutwrencher
	[10625]="136831:27366:2:15:1:::0:0:", -- Stealthblade
	[17752]="143928:28785:2:15:1:::0:0:", -- Satyr's Lash
	[12531]="144416:28883:2:15:1:::0:0:", -- Searing Needle
	[10750]="176577:35315:2:15:1:::0:0:", -- Lifeforce Dirk
	[11635]="177256:35451:2:15:1:::0:0:", -- Hookfang Shanker
	[17710]="177417:35483:2:15:1:::0:0:", -- Charstone Dirk
	[6660]="180788:36157:2:15:1:::0:0:", -- Julie's Dagger
	[12791]="197059:39411:2:15:1:::0:0:", -- Barman Shanker
	[10828]="202136:40427:2:15:1:::0:0:", -- Dire Nail
	[18491]="203475:40695:2:15:1:::0:0:", -- Lorespinner
	[11922]="217457:43491:2:15:1:::0:0:", -- Blood-etched Blade
	[12582]="255997:51199:2:15:1:::0:0:", -- Keris of Zul'Serak
	[13964]="261533:52306:2:15:1:::0:0:", -- Witchblade
	[14024]="262111:52422:2:15:1:::0:0:", -- Frightalon
	[13218]="266942:53388:2:15:1:::0:0:", -- Fang of the Crystal Spider
	[18758]="270363:54072:2:15:1:::0:0:", -- Specter's Blade
	[19542]="274611:54922:2:15:1:::1:0:461", -- Scout's Blade
	[19546]="274611:54922:2:15:1:::1:0:353", -- Sentinel's Blade
	[13368]="277190:55438:2:15:1:::0:0:", -- Bonescraper
	[13360]="282585:56517:2:15:1:::0:0:", -- Gift of the Elven Magi
	[18392]="283553:56710:2:15:1:::0:0:", -- Distracting Dagger
	[18372]="283580:56716:2:15:1:::0:0:", -- Blade of the New Moon
	[13984]="289034:57806:2:15:1:::0:0:", -- Darrowspike
	[12709]="289956:57991:2:15:1:::0:0:", -- Finkle's Skinner
	[12783]="291079:58215:2:15:1:::0:0:", -- Heartseeker
	[5267]="299255:59851:2:15:1:::0:0:", -- Scarlet Kris
	[19099]="315329:63065:2:15:1:::1:0:287,416", -- Glacial Blade
	[19100]="316503:63300:2:15:1:::1:0:224,774", -- Electrified Dagger
	[2164]="135159:27031:2:15:1:::0:0:", -- Gut Ripper
	[18840]="149834:29966:2:15:1:::0:0:", -- High Warlord's Razor
	[2163]="233550:46710:2:15:1:::0:0:", -- Shadowblade
	[17780]="233983:46796:2:15:1:::0:0:", -- Blade of Eternal Darkness
	[18838]="242293:48458:2:15:1:::0:0:", -- Grand Marshal's Dirk
	[12590]="378124:75624:2:15:1:::0:0:", -- Felstriker
	[14555]="393863:78772:2:15:1:::0:0:", -- Alcor's Sunrazor
	[18878]="428226:85645:2:15:1:::0:0:", -- Sorcerous Dagger
	[17071]="522363:104472:2:15:1:::0:0:", -- Gutgore Ripper
	[18805]="546375:109275:2:15:1:::0:0:", -- Core Hound Tooth
	[17070]="546537:109307:2:15:1:::0:0:", -- Fang of the Mystics
	[19346]="654536:130907:2:15:1:::0:0:", -- Dragonfang Blade
	[18816]="743570:148714:2:15:1:::0:0:", -- Perdition's Blade
	[19324]="1256618:251323:2:15:1:::1:0:287,416,774", -- The Lobotomizer
	[5379]="0:0:2:16:200:::0:0:", -- Boot Knife
	[3111]="15:0:2:16:200:::200:0:5,11,48,51,88,94,102,138,167,175,180,184,296,329,403,430,436,452,491,544,587,594,667,789,803,867,872,886", -- Crude Throwing Axe
	[2947]="15:0:2:16:200:::200:0:5,11,48,51,88,94,102,138,167,175,180,184,296,329,403,430,436,452,491,544,587,594,667,789,803,867,872,886", -- Small Throwing Knife
	[2946]="30:0:2:16:200:::200:0:11,48,51,88,94,119,122,138,167,180,184,199,267,296,329,403,412,436,491,495,529,587,594,667,789,803,808,867,872,886", -- Balanced Throwing Dagger
	[3131]="30:0:2:16:200:::200:0:11,48,51,88,94,119,122,138,167,180,184,199,267,296,329,403,412,436,491,495,529,587,594,667,789,803,808,867,872,886", -- Weighted Throwing Axe
	[3107]="75:0:2:16:200:::200:0:42,46,88,95,106,111,115,119,122,131,136,184,199,263,265,267,284,303,305,311,329,391,408,412,428,454,495,529,546,558,568,622,623,675,700,789,803,808,825,837,886", -- Keen Throwing Knife
	[3135]="75:0:2:16:200:::200:0:42,46,88,106,111,115,119,122,131,136,184,199,263,265,267,284,303,305,311,329,391,408,412,428,454,495,529,546,558,568,622,623,675,700,789,803,808,825,837,886", -- Sharp Throwing Axe
	[3137]="200:0:2:16:200:::200:0:42,46,88,95,106,111,115,119,131,136,184,199,263,265,284,303,305,311,329,391,408,428,454,546,558,568,622,623,675,700,789,803,808,825,837,886", -- Deadly Throwing Axe
	[3108]="200:0:2:16:200:::200:0:42,46,88,106,111,115,119,131,136,184,199,263,265,284,303,305,311,329,391,408,428,454,546,558,568,622,623,675,700,789,803,808,825,837,886", -- Heavy Throwing Dagger
	[15326]="800:1:2:16:200:::200:0:42,46,88,106,111,115,119,131,136,184,199,263,265,305,311,329,391,428,454,558,568,622,675,700,789,803,808,825,837,886", -- Gleaming Throwing Axe
	[15327]="800:1:2:16:200:::200:0:42,46,88,95,106,111,115,119,131,136,184,199,263,265,305,311,329,391,428,454,558,568,622,675,700,789,803,808,825,837,886", -- Wicked Throwing Dagger
	[3463]="37:9:2:16:200:::0:0:", -- Silver Star
	[13173]="47:11:2:16:200:::0:0:", -- Flightblade Throwing Axe
	[15807]="294:58:2:18:1:::1:1:560,772", -- Light Crossbow
	[15808]="3640:728:2:18:1:::1:1:560,772", -- Fine Light Crossbow
	[15809]="14691:2938:2:18:1:::1:1:560,772", -- Heavy Crossbow
	[6315]="12733:2546:2:18:1:::0:0:", -- Steelarrow Crossbow
	[13037]="23645:4729:2:18:1:::0:0:", -- Crystalpine Stinger
	[13038]="48150:9630:2:18:1:::0:0:", -- Swiftwind
	[13039]="89461:17892:2:18:1:::0:0:", -- Skull Splitting Crossbow
	[13040]="147220:29444:2:18:1:::0:0:", -- Heartseeking Crossbow
	[12651]="180279:36055:2:18:1:::0:0:", -- Blackcrow
	[18738]="187966:37593:2:18:1:::0:0:", -- Carapace Spine Crossbow
	[18388]="209641:41928:2:18:1:::0:0:", -- Stoneshatter
	[19107]="220858:44171:2:18:1:::0:0:", -- Bloodseeker
	[18836]="107834:21566:2:18:1:::0:0:", -- Grand Marshal's Repeater
	[18837]="108231:21646:2:18:1:::0:0:", -- High Warlord's Crossbow
	[11287]="521:104:2:19:1:::0:0:", -- Lesser Magic Wand
	[5092]="1203:240:2:19:1:::0:0:", -- Charred Razormane Wand
	[11288]="2330:466:2:19:1:::0:0:", -- Greater Magic Wand
	[5208]="3340:668:2:19:1:::1:0:36,317,450", -- Smoldering Wand
	[5209]="3855:771:2:19:1:::1:0:36,317,450", -- Gloom Wand
	[5210]="5808:1161:2:19:1:::1:0:36,317,450", -- Burning Wand
	[5211]="5830:1166:2:19:1:::1:0:36,317,450", -- Dusk Wand
	[11289]="10743:2148:2:19:1:::0:0:", -- Lesser Mystic Wand
	[5236]="14394:2878:2:19:1:::1:0:36,317,450", -- Combustible Wand
	[5347]="15713:3142:2:19:1:::1:0:36,317,450", -- Pestilent Wand
	[11290]="15789:3157:2:19:1:::0:0:", -- Greater Mystic Wand
	[5238]="35727:7145:2:19:1:::1:0:36,317,450", -- Pitchwood Wand
	[5239]="38731:7746:2:19:1:::1:0:36,317,450", -- Blackbone Wand
	[5069]="1466:293:2:19:1:::0:0:", -- Fire Wand
	[5604]="1901:380:2:19:1:::0:0:", -- Elven Wand
	[5071]="2216:443:2:19:1:::0:0:", -- Shadow Wand
	[5242]="3115:623:2:19:1:::0:0:", -- Cinder Wand
	[5212]="3361:672:2:19:1:::0:1:639", -- Blazing Wand
	[12296]="3612:722:2:19:1:::0:0:", -- Spark of the People's Militia
	[5326]="3880:776:2:19:1:::0:0:", -- Flaring Baton
	[15204]="3899:779:2:19:1:::0:0:", -- Moonstone Wand
	[5241]="4105:821:2:19:1:::0:0:", -- Dwarven Flamestick
	[5207]="5406:1081:2:19:1:::0:1:639", -- Opaque Wand
	[5252]="5877:1175:2:19:1:::0:0:", -- Wand of Decay
	[5240]="6221:1244:2:19:1:::0:1:639", -- Torchlight Wand
	[7607]="6998:1399:2:19:1:::0:1:639", -- Sable Wand
	[8071]="7673:1534:2:19:1:::0:0:", -- Sizzle Stick
	[8186]="11156:2231:2:19:1:::0:0:", -- Dire Wand
	[6677]="12006:2401:2:19:1:::0:0:", -- Spellcrafter Wand
	[5356]="12971:2594:2:19:1:::0:0:", -- Branding Rod
	[5250]="13233:2646:2:19:1:::0:0:", -- Charred Wand
	[15465]="13565:2713:2:19:1:::0:0:", -- Stingshot Wand
	[8184]="14737:2947:2:19:1:::0:0:", -- Firestarter
	[5818]="16197:3239:2:19:1:::0:1:639", -- Moonbeam Wand
	[5244]="17325:3465:2:19:1:::0:1:639", -- Consecrated Wand
	[5246]="17450:3490:2:19:1:::0:0:", -- Excavation Rod
	[9489]="18450:3690:2:19:1:::0:0:", -- Gyromatic Icemaker
	[5214]="19678:3935:2:19:1:::0:1:639", -- Wand of Eventide
	[5245]="25458:5091:2:19:1:::0:0:", -- Summoner's Wand
	[5213]="26093:5218:2:19:1:::0:0:", -- Scorching Wand
	[16789]="29962:5992:2:19:1:::0:0:", -- Captain Rackmore's Tiller
	[6797]="31812:6362:2:19:1:::0:0:", -- Eyepoker
	[5248]="34245:6849:2:19:1:::0:1:639", -- Flash Wand
	[15692]="34677:6935:2:19:1:::0:0:", -- Kodo Brander
	[6729]="35939:7187:2:19:1:::0:0:", -- Fizzle's Zippy Lighter
	[5253]="39761:7952:2:19:1:::0:0:", -- Goblin Igniter
	[5247]="39806:7961:2:19:1:::0:0:", -- Rod of Sorrow
	[7513]="40857:8171:2:19:1:::0:1:639", -- Ragefire Wand
	[7514]="41010:8202:2:19:1:::0:0:", -- Icefury Wand
	[4547]="41596:8319:2:19:1:::0:0:", -- Gnomish Zapper
	[11263]="42097:8419:2:19:1:::0:0:", -- Nether Force Wand
	[6806]="42540:8508:2:19:1:::0:0:", -- Dancing Flame
	[5215]="43281:8656:2:19:1:::0:1:639", -- Ember Wand
	[5249]="43292:8658:2:19:1:::0:0:", -- Burning Sliver
	[5216]="59109:11821:2:19:1:::0:0:", -- Umbral Wand
	[11860]="64854:12970:2:19:1:::0:0:", -- Charged Lightning Rod
	[10704]="68246:13649:2:19:1:::0:0:", -- Chillnail Splinter
	[9654]="84644:16928:2:19:1:::0:0:", -- Cairnstone Sliver
	[19118]="86722:17344:2:19:1:::0:0:", -- Nature's Breath
	[15279]="91339:18267:2:19:1:::0:0:", -- Ivory Wand
	[15280]="103018:20603:2:19:1:::0:0:", -- Wizard's Hand
	[15281]="130550:26110:2:19:1:::0:0:", -- Glowstar Rod
	[18301]="146815:29363:2:19:1:::0:0:", -- Lethtendris's Wand
	[15282]="153143:30628:2:19:1:::0:0:", -- Dragon Finger
	[16993]="154945:30989:2:19:1:::0:0:", -- Smokey's Fireshooter
	[15283]="186826:37365:2:19:1:::0:0:", -- Lunar Wand
	[5243]="6562:1312:2:19:1:::0:0:", -- Firebelcher
	[12984]="7115:1423:2:19:1:::0:0:", -- Skycaller
	[5198]="8301:1660:2:19:1:::0:0:", -- Cookie's Stirring Rod
	[13062]="14958:2991:2:19:1:::0:0:", -- Thunderwood
	[7001]="17677:3535:2:19:1:::0:0:", -- Gravestone Scepter
	[13063]="29259:5851:2:19:1:::0:0:", -- Starfaller
	[7708]="33249:6649:2:19:1:::0:0:", -- Necrotic Wand
	[9381]="43144:8628:2:19:1:::0:0:", -- Earthen Rod
	[10572]="47960:9592:2:19:1:::0:0:", -- Freezing Shard
	[10766]="48304:9660:2:19:1:::0:0:", -- Plaguerot Sprig
	[13064]="57435:11487:2:19:1:::0:0:", -- Jaina's Firestarter
	[9483]="95695:19139:2:19:1:::0:0:", -- Flaming Incinerator
	[13065]="104728:20945:2:19:1:::0:0:", -- Wand of Allistarj
	[17745]="112599:22519:2:19:1:::0:0:", -- Noxious Shooter
	[11748]="125416:25083:2:19:1:::0:0:", -- Pyric Caduceus
	[10836]="144946:28989:2:19:1:::0:0:", -- Rod of Corrosion
	[12605]="145533:29106:2:19:1:::0:0:", -- Serpentine Skuller
	[13396]="154265:30853:2:19:1:::0:0:", -- Skul's Ghastly Touch
	[13004]="167954:33590:2:19:1:::0:0:", -- Torch of Austen
	[18338]="182979:36595:2:19:1:::0:0:", -- Wand of Arcane Potency
	[18483]="186810:37362:2:19:1:::0:0:", -- Mana Channeling Wand
	[13534]="188639:37727:2:19:1:::0:0:", -- Banshee Finger
	[13938]="196521:39304:2:19:1:::0:0:", -- Bonecreeper Stylus
	[18761]="205055:41011:2:19:1:::0:0:", -- Oblivion's Touch
	[16997]="208016:41603:2:19:1:::0:0:", -- Stormrager
	[19108]="221635:44327:2:19:1:::0:0:", -- Wand of Biting Cold
	[17077]="298709:59741:2:19:1:::0:0:", -- Crimson Shocker
	[19130]="388958:77791:2:19:1:::0:0:", -- Cold Snap
	[19367]="517308:103461:2:19:1:::0:0:", -- Dragon's Touch
	[6256]="23:4:2:20:1:::1:0:3,23,27,47,48,113,121,139,141,162,166,167,178,185,203,205,213,246,253,255,263,277,305,323,333,404,451,457,466,468,475,478,495,507,528,529,538,552,567,579,594,605,620,625,626,638,663,672,702,711,716,717,718,722,752,754,757,758,763,766,775,803,816,833,838,840,852,854,863,881,889,893", -- Fishing Pole
	[6365]="901:180:2:20:1:::1:1:113,162,277,323,451,468,475,528,541,552,567,626,638,702,711,717,752,763,833,840,852,881,889", -- Strong Fishing Pole
	[12225]="939:187:2:20:1:::0:0:", -- Blump Family Fishing Pole
	[6367]="16892:3378:2:20:1:::0:0:", -- Big Iron Fishing Pole
	[19022]="139307:27861:2:20:1:::0:0:", -- Nat Pagle's Extreme Angler FC-5000
	[15794]="195:39:4:0:1:::0:0:", -- Ripped Ogre Loincloth
	[9333]="295:73:4:0:20:::0:0:", -- Tarnished Silver Necklace
	[7997]="406:81:4:0:1:::0:0:", -- Red Defias Mask
	[12846]="0:0:4:0:1:::0:0:", -- Argent Dawn Commission
	[19160]="0:0:4:0:1:::0:0:", -- Contest Winner's Tabard
	[13699]="0:0:4:0:1:::0:0:", -- Firestone
	[13700]="0:0:4:0:1:::0:0:", -- Greater Firestone
	[13602]="0:0:4:0:1:::0:0:", -- Greater Spellstone
	[1254]="0:0:4:0:1:::0:0:", -- Lesser Firestone
	[13701]="0:0:4:0:1:::0:0:", -- Major Firestone
	[13603]="0:0:4:0:1:::0:0:", -- Major Spellstone
	[5514]="0:0:4:0:1:::0:0:", -- Mana Agate
	[7297]="0:0:4:0:1:::0:0:", -- Morbent's Bane
	[11522]="0:0:4:0:1:::0:0:", -- Silver Totem of Aquementas
	[5522]="0:0:4:0:1:::0:0:", -- Spellstone
	[10515]="0:0:4:0:1:::0:0:", -- Torch of Retribution
	[5411]="0:0:4:0:1:::0:0:", -- Winterhoof Cleansing Totem
	[6097]="1:1:4:0:1:::0:0:", -- Acolyte's Shirt
	[6096]="1:1:4:0:1:::0:0:", -- Apprentice's Shirt
	[6125]="1:1:4:0:1:::0:0:", -- Brawler's Harness
	[49]="1:1:4:0:1:::0:0:", -- Footpad's Shirt
	[53]="1:1:4:0:1:::0:0:", -- Neophyte's Shirt
	[154]="1:1:4:0:1:::0:0:", -- Primitive Mantle
	[6134]="1:1:4:0:1:::0:0:", -- Primitive Mantle
	[38]="1:1:4:0:1:::0:0:", -- Recruit's Shirt
	[6120]="1:1:4:0:1:::0:0:", -- Recruit's Shirt
	[148]="1:1:4:0:1:::0:0:", -- Rugged Trapper's Shirt
	[45]="1:1:4:0:1:::0:0:", -- Squire's Shirt
	[6117]="1:1:4:0:1:::0:0:", -- Squire's Shirt
	[127]="1:1:4:0:1:::0:0:", -- Trapper's Shirt
	[140]="4:1:4:0:1:::0:0:", -- Brawler's Boots
	[47]="4:1:4:0:1:::0:0:", -- Footpad's Shoes
	[40]="4:1:4:0:1:::0:0:", -- Recruit's Boots
	[6122]="4:1:4:0:1:::0:0:", -- Recruit's Boots
	[43]="4:1:4:0:1:::0:0:", -- Squire's Boots
	[121]="4:1:4:0:1:::0:0:", -- Thug Boots
	[6138]="4:1:4:0:1:::0:0:", -- Thug Boots
	[6136]="4:1:4:0:1:::0:0:", -- Thug Shirt
	[59]="5:1:4:0:1:::0:0:", -- Acolyte's Shoes
	[55]="5:1:4:0:1:::0:0:", -- Apprentice's Boots
	[51]="5:1:4:0:1:::0:0:", -- Neophyte's Boots
	[129]="5:1:4:0:1:::0:0:", -- Rugged Trapper's Boots
	[2105]="5:1:4:0:1:::0:0:", -- Thug Shirt
	[6127]="5:1:4:0:1:::0:0:", -- Trapper's Boots
	[4344]="58:11:4:0:1:::0:0:", -- Brown Linen Shirt
	[2575]="100:25:4:0:1:::0:0:", -- Red Linen Shirt
	[2579]="150:37:4:0:1:::0:0:", -- Green Linen Shirt
	[3421]="200:50:4:0:1:::1:0:61,204", -- Simple Wildflowers
	[6786]="298:59:4:0:1:::0:0:", -- Simple Dress
	[2577]="300:75:4:0:1:::0:0:", -- Blue Linen Shirt
	[2576]="300:75:4:0:1:::0:0:", -- White Linen Shirt
	[859]="350:87:4:0:1:::0:0:", -- Fine Cloth Shirt
	[16059]="400:100:4:0:1:::1:0:12,26,112,302,472,516,640,670,713", -- Common Brown Shirt
	[3428]="400:100:4:0:1:::1:0:12,26,112,302,472,516,530,640,670,713", -- Common Gray Shirt
	[16060]="400:100:4:0:1:::1:0:12,26,112,302,472,516,640,670,713", -- Common White Shirt
	[3419]="500:125:4:0:1:::1:0:61,204", -- Red Rose
	[3342]="550:137:4:0:1:::0:0:", -- Captain Sander's Shirt
	[5107]="698:139:4:0:1:::0:0:", -- Deckhand's Shirt
	[2587]="800:200:4:0:1:::0:0:", -- Gray Woolen Shirt
	[8626]="1000:250:4:0:1:::1:0:410,484,525,856,887", -- Blue Sparkler
	[8624]="1000:250:4:0:1:::1:0:410,484,525,856,887", -- Red Sparkler
	[6384]="1000:250:4:0:1:::0:0:", -- Stylish Blue Shirt
	[6385]="1000:250:4:0:1:::0:0:", -- Stylish Green Shirt
	[4330]="1000:250:4:0:1:::0:0:", -- Stylish Red Shirt
	[8625]="1000:250:4:0:1:::1:0:410,484,525,856,887", -- White Sparkler
	[3422]="2000:500:4:0:1:::1:0:61,204", -- Beautiful Wildflowers
	[4332]="2000:500:4:0:1:::0:0:", -- Bright Yellow Shirt
	[6795]="2000:500:4:0:1:::0:0:", -- White Swashbuckler's Shirt
	[6833]="2000:500:4:0:1:::0:0:", -- White Tuxedo Shirt
	[4334]="2200:550:4:0:1:::0:0:", -- Formal White Shirt
	[2562]="2300:575:4:0:1:::0:0:", -- Bouquet of Scarlet Begonias
	[3360]="2500:625:4:0:1:::0:0:", -- Stitches' Femur
	[6835]="2521:504:4:0:1:::0:0:", -- Black Tuxedo Pants
	[13897]="2976:595:4:0:1:::1:0:234,530", -- White Traditional Hanbok
	[19295]="3000:750:4:0:1:::0:0:", -- Darkmoon Flower
	[17723]="3000:750:4:0:1:::0:0:", -- Green Holiday Shirt
	[6796]="3000:750:4:0:1:::0:0:", -- Red Swashbuckler's Shirt
	[3426]="4000:1000:4:0:1:::1:0:530", -- Bold Yellow Shirt
	[4333]="4800:1200:4:0:1:::0:0:", -- Dark Silk Shirt
	[3420]="5000:1250:4:0:1:::1:0:61,204", -- Black Rose
	[7809]="5124:1024:4:0:1:::0:0:", -- Easter Dress
	[4336]="6000:1500:4:0:1:::0:0:", -- Black Swashbuckler's Shirt
	[10056]="6000:1500:4:0:1:::0:0:", -- Orange Mageweave Shirt
	[10052]="6000:1500:4:0:1:::0:0:", -- Orange Martial Shirt
	[4335]="6000:1500:4:0:1:::0:0:", -- Rich Purple Silk Shirt
	[3427]="6000:1500:4:0:1:::1:0:530", -- Stylish Black Shirt
	[10034]="8000:2000:4:0:1:::0:0:", -- Tuxedo Shirt
	[19031]="10000:2500:4:0:1:::1:0:287,416", -- Frostwolf Battle Tabard
	[5976]="10000:2500:4:0:1:::1:0:127,230,427,543,680,824", -- Guild Tabard
	[7338]="10000:2500:4:0:1:::1:0:664", -- Mood Ring
	[15196]="10000:2500:4:0:1:::1:0:635", -- Private's Tabard
	[15197]="10000:2500:4:0:1:::1:0:708", -- Scout's Tabard
	[19032]="10000:2500:4:0:1:::1:0:224,774", -- Stormpike Battle Tabard
	[10054]="12000:3000:4:0:1:::0:0:", -- Lavender Mageweave Shirt
	[10055]="12000:3000:4:0:1:::0:0:", -- Pink Mageweave Shirt
	[13899]="17641:3528:4:0:1:::1:1:234", -- Red Traditional Hanbok
	[3423]="20000:5000:4:0:1:::1:0:61,204", -- Bouquet of White Roses
	[10053]="22497:4499:4:0:1:::0:0:", -- Simple Black Dress
	[14617]="25000:6250:4:0:1:::0:0:", -- Sawbones Shirt
	[11840]="28550:7137:4:0:1:::0:0:", -- Master Builder's Shirt
	[15198]="40000:10000:4:0:1:::0:0:", -- Knight's Colors
	[15199]="40000:10000:4:0:1:::0:0:", -- Stone Guard's Herald
	[7341]="50000:12500:4:0:1:::1:0:664", -- Cubic Zirconia Ring
	[19506]="50000:12500:4:0:1:::1:0:353", -- Silverwing Battle Tabard
	[19505]="50000:12500:4:0:1:::0:0:", -- Warsong Battle Tabard
	[13896]="55102:11020:4:0:1:::0:0:", -- Blue Wedding Hanbok
	[7342]="100000:25000:4:0:1:::1:0:664", -- Silver Piffeny Band
	[13900]="137214:27442:4:0:1:::1:1:234", -- Green Wedding Hanbok
	[7339]="250000:62500:4:0:1:::1:0:664", -- Miniscule Diamond Ring
	[13898]="288699:57739:4:0:1:::1:0:234,530", -- Royal Dangui
	[3424]="500000:125000:4:0:1:::1:0:61,204", -- Bouquet of Black Roses
	[7340]="500000:125000:4:0:1:::1:0:664", -- Flawless Diamond Solitaire
	[7337]="1000000:250000:4:0:1:::1:0:664", -- The Rock
	[9362]="0:0:4:0:1:::0:0:", -- Brilliant Gold Ring
	[2944]="0:0:4:0:1:::0:0:", -- Cursed Eye of Paleth
	[17690]="0:0:4:0:1:::0:0:", -- Frostwolf Insignia Rank 1
	[17905]="0:0:4:0:1:::0:0:", -- Frostwolf Insignia Rank 2
	[17906]="0:0:4:0:1:::0:0:", -- Frostwolf Insignia Rank 3
	[19141]="0:0:4:0:1:::0:0:", -- Luffa
	[4614]="0:0:4:0:1:::0:0:", -- Pendant of Myzrael
	[9243]="0:0:4:0:1:::0:0:", -- Shriveled Heart
	[13544]="0:0:4:0:1:::0:0:", -- Spectral Essence
	[17691]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 1
	[17900]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 2
	[17901]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 3
	[1077]="100:25:4:0:1:::0:0:", -- Defias Mage Ring
	[7507]="1600:400:4:0:1:::0:0:", -- Arcane Orb
	[7508]="1600:400:4:0:1:::0:0:", -- Ley Orb
	[5351]="1615:403:4:0:1:::0:0:", -- Bounty Hunter's Ring
	[3235]="1650:412:4:0:1:::0:0:", -- Ring of Scorn
	[15969]="1700:425:4:0:1:::0:0:", -- Beaded Orb
	[15925]="1758:439:4:0:1:::0:0:", -- Journeyman's Stave
	[5611]="1810:452:4:0:1:::0:0:", -- Tear of Grief
	[1319]="1850:462:4:0:1:::0:0:", -- Ring of Iron Will
	[11965]="1858:464:4:0:1:::0:0:", -- Quartz Ring
	[11981]="1985:496:4:0:1:::0:0:", -- Lead Band
	[15944]="2051:512:4:0:1:::0:0:", -- Ancestral Orb
	[15932]="2110:527:4:0:1:::0:0:", -- Disciple's Stein
	[2943]="2150:537:4:0:1:::0:0:", -- Eye of Paleth
	[5622]="2225:556:4:0:1:::0:0:", -- Clergy Ring
	[15866]="2250:562:4:0:1:::0:0:", -- Veildust Medicine Bag
	[15970]="2348:587:4:0:1:::0:0:", -- Native Branch
	[3451]="2430:607:4:0:1:::0:0:", -- Nightglow Concoction
	[15933]="2480:620:4:0:1:::0:0:", -- Simple Branch
	[1189]="2500:625:4:0:1:::0:0:", -- Overseer's Ring
	[6199]="2600:650:4:0:1:::0:0:", -- Black Widow Band
	[1076]="2600:650:4:0:1:::0:0:", -- Defias Renegade Ring
	[5313]="2600:650:4:0:1:::0:0:", -- Totemic Clan Ring
	[2917]="2660:665:4:0:1:::0:0:", -- Tranquil Ring
	[6341]="2665:666:4:0:1:::0:0:", -- Eerie Stable Lantern
	[7559]="2665:666:4:0:1:::0:0:", -- Runic Cane
	[6678]="2710:677:4:0:1:::0:0:", -- Band of Elven Grace
	[11855]="3130:782:4:0:1:::0:0:", -- Tork Wrench
	[15926]="3210:802:4:0:1:::0:0:", -- Spellbinder Orb
	[4998]="3350:837:4:0:1:::0:0:", -- Blood Ring
	[12054]="3350:837:4:0:1:::0:0:", -- Demon Band
	[12052]="3350:837:4:0:1:::0:0:", -- Ring of the Moon
	[12053]="3350:837:4:0:1:::0:0:", -- Volcanic Rock Ring
	[15945]="3351:837:4:0:1:::0:0:", -- Runic Stave
	[15206]="3430:857:4:0:1:::0:0:", -- Jadefinger Baton
	[11993]="3498:874:4:0:1:::0:0:", -- Clay Ring
	[17694]="3525:881:4:0:1:::0:0:", -- Band of the Fist
	[17692]="3525:881:4:0:1:::0:0:", -- Horn Ring
	[4535]="3530:882:4:0:1:::0:0:", -- Ironforge Memorial Ring
	[12008]="3581:895:4:0:1:::0:0:", -- Savannah Ring
	[6748]="3590:897:4:0:1:::0:0:", -- Monkey Ring
	[6750]="3590:897:4:0:1:::0:0:", -- Snake Hoop
	[6749]="3590:897:4:0:1:::0:0:", -- Tiger Band
	[11995]="3658:914:4:0:1:::0:0:", -- Ivory Band
	[1172]="3875:968:4:0:1:::0:0:", -- Grayson's Torch
	[11968]="3988:997:4:0:1:::0:0:", -- Amber Hoop
	[5001]="4155:1038:4:0:1:::0:0:", -- Heart Ring
	[7554]="4158:1039:4:0:1:::0:0:", -- Willow Branch
	[4999]="4210:1052:4:0:1:::0:0:", -- Azora's Will
	[11982]="4251:1062:4:0:1:::0:0:", -- Viridian Band
	[15971]="4258:1064:4:0:1:::0:0:", -- Aboriginal Rod
	[12006]="4258:1064:4:0:1:::0:0:", -- Meadow Ring
	[12007]="4258:1064:4:0:1:::0:0:", -- Prairie Ring
	[11967]="4351:1087:4:0:1:::0:0:", -- Zircon Band
	[7608]="4425:1106:4:0:1:::0:0:", -- Seer's Fine Stein
	[15946]="4495:802:4:0:1:::0:0:", -- Mystic's Sphere
	[4135]="4520:1130:4:0:1:::0:0:", -- Bloodbone Band
	[8350]="4520:1130:4:0:1:::0:0:", -- The 1 Ring
	[11983]="4521:1130:4:0:1:::0:0:", -- Chrome Ring
	[1131]="4545:1136:4:0:1:::0:0:", -- Totem of Infliction
	[15912]="4594:1148:4:0:1:::0:0:", -- Buccaneer's Orb
	[15972]="4685:1171:4:0:1:::0:0:", -- Ritual Stein
	[10298]="4975:1243:4:0:1:::0:0:", -- Gnomeregan Band
	[1116]="5000:1250:4:0:1:::0:0:", -- Ring of Pure Silver
	[3739]="5000:1250:4:0:1:::0:0:", -- Skull Ring
	[1462]="5225:1306:4:0:1:::0:0:", -- Ring of the Shadow
	[11994]="5251:1312:4:0:1:::0:0:", -- Coral Band
	[6669]="5515:1378:4:0:1:::0:0:", -- Sacred Band
	[15974]="5846:1461:4:0:1:::0:0:", -- Pagan Rod
	[6743]="5850:1462:4:0:1:::0:0:", -- Sustaining Ring
	[3760]="6000:1500:4:0:1:::0:0:", -- Band of the Undercity
	[2043]="6000:1500:4:0:1:::0:0:", -- Ring of Forlorn Spirits
	[5002]="6140:1535:4:0:1:::0:0:", -- Glowing Green Talisman
	[6790]="6160:1540:4:0:1:::0:0:", -- Ring of Calm
	[7558]="6438:1609:4:0:1:::0:0:", -- Shimmering Stave
	[5007]="6530:1632:4:0:1:::0:0:", -- Band of Thorns
	[5323]="6530:1632:4:0:1:::0:0:", -- Everglow Lantern
	[9769]="6548:1637:4:0:1:::0:0:", -- Greenweave Branch
	[5009]="6785:1696:4:0:1:::0:0:", -- Mindbender Loop
	[11970]="6841:1710:4:0:1:::0:0:", -- Spinel Ring
	[11996]="6854:1713:4:0:1:::0:0:", -- Basalt Ring
	[5003]="6855:1713:4:0:1:::0:0:", -- Crystal Starfire Medallion
	[1996]="6880:1720:4:0:1:::0:0:", -- Voodoo Band
	[11969]="6887:1721:4:0:1:::0:0:", -- Jacinth Circle
	[11986]="6981:1745:4:0:1:::0:0:", -- Thallium Hoop
	[15927]="7458:1864:4:0:1:::0:0:", -- Bright Sphere
	[1449]="7500:1875:4:0:1:::0:0:", -- Minor Channeling Ring
	[15947]="7548:1887:4:0:1:::0:0:", -- Sanguine Star
	[5011]="7650:1912:4:0:1:::0:0:", -- Welken Ring
	[4836]="8002:2000:4:0:1:::1:1:505,648,845,888", -- Fireproof Orb
	[4838]="8002:2000:4:0:1:::1:1:505,648,888", -- Orb of Power
	[4837]="8002:2000:4:0:1:::1:1:505,648,888", -- Strength of Will
	[9800]="8110:2027:4:0:1:::0:0:", -- Ivy Orb
	[9642]="8370:2092:4:0:1:::0:0:", -- Band of the Great Tortoise
	[4550]="8370:2092:4:0:1:::0:0:", -- Coldwater Ring
	[4549]="8370:2092:4:0:1:::0:0:", -- Seafire Band
	[1993]="8400:2100:4:0:1:::0:0:", -- Ogremind Ring
	[11985]="8576:2144:4:0:1:::0:0:", -- Cerulean Ring
	[4130]="8685:2171:4:0:1:::0:0:", -- Smotts' Compass
	[12009]="8698:2174:4:0:1:::0:0:", -- Tundra Ring
	[11984]="8756:2189:4:0:1:::0:0:", -- Cobalt Ring
	[15973]="9254:2313:4:0:1:::0:0:", -- Watcher's Star
	[15928]="9548:2387:4:0:1:::0:0:", -- Silver-thread Rod
	[15975]="9684:2421:4:0:1:::0:0:", -- Raincaller Scepter
	[12012]="9853:2463:4:0:1:::0:0:", -- Marsh Ring
	[12010]="9876:2469:4:0:1:::0:0:", -- Fen Ring
	[5754]="10155:2538:4:0:1:::0:0:", -- Wolfpack Medallion
	[7553]="10170:2542:4:0:1:::0:0:", -- Band of the Unicorn
	[9627]="10170:2542:4:0:1:::0:0:", -- Explorer's League Lodestar
	[7552]="10170:2542:4:0:1:::0:0:", -- Falcon's Hook
	[15934]="10384:2596:4:0:1:::0:0:", -- Sage's Stave
	[15962]="10864:2716:4:0:1:::0:0:", -- Satyr's Rod
	[5180]="11110:2777:4:0:1:::0:0:", -- Necklace of Harmony
	[6774]="11540:2885:4:0:1:::0:0:", -- Uthek's Finger
	[11987]="11543:2885:4:0:1:::0:0:", -- Iridium Circle
	[11998]="11587:2896:4:0:1:::0:0:", -- Jet Loop
	[4125]="12570:3142:4:0:1:::0:0:", -- Tranquil Orb
	[15935]="13295:3323:4:0:1:::0:0:", -- Durable Rod
	[2933]="15000:3750:4:0:1:::0:0:", -- Seal of Wrynn
	[10299]="15112:3778:4:0:1:::0:0:", -- Gnomeregan Amulet
	[11971]="15876:3969:4:0:1:::0:0:", -- Amethyst Band
	[12020]="15878:3969:4:0:1:::0:0:", -- Thallium Choker
	[11973]="15887:3971:4:0:1:::0:0:", -- Hematite Link
	[12028]="16030:4007:4:0:1:::0:0:", -- Basalt Necklace
	[15689]="16160:4040:4:0:1:::0:0:", -- Trader's Ring
	[6898]="16530:4132:4:0:1:Restorative::0:0:", -- Orb of Soran'ruk
	[15976]="16584:4146:4:0:1:::0:0:", -- Thistlefur Branch
	[12040]="16658:4164:4:0:1:::0:0:", -- Forest Pendant
	[4112]="16730:4182:4:0:1:::0:0:", -- Choker of the High Shaman
	[7609]="16843:4210:4:0:1:::0:0:", -- Elder's Amber Stave
	[12019]="16881:4220:4:0:1:::0:0:", -- Cerulean Talisman
	[12039]="16899:4224:4:0:1:::0:0:", -- Tundra Necklace
	[4430]="17230:4307:4:0:1:::0:0:", -- Ethereal Talisman
	[15929]="17585:4396:4:0:1:::0:0:", -- Nightsky Orb
	[15977]="18456:4614:4:0:1:::0:0:", -- Vital Orb
	[6757]="18520:4630:4:0:1:::0:0:", -- Jaina's Signet Ring
	[5079]="18570:4642:4:0:1:::0:0:", -- Cold Basilisk Eye
	[11972]="18597:4649:4:0:1:::0:0:", -- Carnelian Loop
	[12013]="18599:4649:4:0:1:::0:0:", -- Desert Ring
	[12011]="18599:4649:4:0:1:::0:0:", -- Forest Hoop
	[2820]="18650:4662:4:0:1:Buff::0:0:", -- Nifty Stopwatch
	[10659]="18650:4662:4:0:1:::0:0:", -- Shard of Afrasa
	[12022]="18875:4718:4:0:1:::0:0:", -- Iridium Chain
	[11975]="18958:4739:4:0:1:::0:0:", -- Topaz Ring
	[12042]="18997:4749:4:0:1:::0:0:", -- Marsh Chain
	[15918]="19392:4848:4:0:1:::0:0:", -- Conjurer's Sphere
	[7749]="19540:4885:4:0:1:::0:0:", -- Omega Orb
	[15963]="19548:4887:4:0:1:::0:0:", -- Stonecloth Branch
	[15690]="19650:4912:4:0:1:::0:0:", -- Kodobone Necklace
	[11974]="19885:4971:4:0:1:::0:0:", -- Aquamarine Ring
	[12001]="19885:4971:4:0:1:::0:0:", -- Onyx Ring
	[12023]="19885:4971:4:0:1:::0:0:", -- Tellurium Necklace
	[12047]="19987:4996:4:0:1:::0:0:", -- Spectral Necklace
	[18984]="20000:5000:4:0:1:::0:0:", -- Dimensional Ripper - Everlook
	[7344]="20000:5000:4:0:1:::0:0:", -- Torch of Holy Flame
	[18986]="20000:5000:4:0:1:::0:0:", -- Ultrasafe Transporter: Gadgetzan
	[12034]="20050:5012:4:0:1:::0:0:", -- Marble Necklace
	[12044]="20581:5145:4:0:1:::0:0:", -- Arctic Pendant
	[12025]="21130:5282:4:0:1:::0:0:", -- Selenium Chain
	[5029]="21130:5282:4:0:1:::0:0:", -- Talisman of the Naga Lord
	[10739]="21170:5292:4:0:1:::0:0:", -- Ring of Fortitude
	[15978]="21542:5385:4:0:1:::0:0:", -- Geomancer's Rod
	[7556]="21548:5387:4:0:1:::0:0:", -- Twilight Orb
	[12029]="21581:5395:4:0:1:::0:0:", -- Greenstone Talisman
	[12043]="21587:5396:4:0:1:::0:0:", -- Desert Choker
	[12032]="21587:5396:4:0:1:::0:0:", -- Onyx Choker
	[12024]="21587:5396:4:0:1:::0:0:", -- Vanadium Talisman
	[4743]="21720:5430:4:0:1:::0:0:", -- Pulsating Crystalline Shard
	[12035]="22053:5513:4:0:1:::0:0:", -- Obsidian Pendant
	[18425]="22150:5537:4:0:1:::0:0:", -- Kreeg's Mug
	[5028]="22150:5537:4:0:1:::0:0:", -- Lord Sakrasis' Scepter
	[11999]="22155:5538:4:0:1:::0:0:", -- Lodestone Hoop
	[10780]="22170:5542:4:0:1:::0:0:", -- Mark of Hakkar
	[4984]="22520:5630:4:0:1:::0:0:", -- Skull of Impending Doom
	[9622]="22660:5665:4:0:1:::0:0:", -- Reedknot Ring
	[12046]="23030:5757:4:0:1:::0:0:", -- Jungle Necklace
	[7610]="23245:5811:4:0:1:::0:0:", -- Aurora Sphere
	[15979]="23515:7215:4:0:1:::0:0:", -- Embersilk Stave
	[16009]="23720:5930:4:0:1:::0:0:", -- Voice Amplification Modulator
	[12036]="23930:5982:4:0:1:::0:0:", -- Granite Necklace
	[17774]="24535:6133:4:0:1:::0:0:", -- Mark of the Chosen
	[15704]="24580:6145:4:0:1:::0:0:", -- Hunter's Insignia Medal
	[11905]="24813:6203:4:0:1:::0:0:", -- Linken's Boomerang
	[9882]="24836:6209:4:0:1:::0:0:", -- Sorcerer Sphere
	[12027]="25030:6257:4:0:1:::0:0:", -- Vermilion Necklace
	[12014]="25158:6289:4:0:1:::0:0:", -- Arctic Ring
	[11991]="25268:6317:4:0:1:::0:0:", -- Quicksilver Ring
	[12002]="25289:6322:4:0:1:::0:0:", -- Marble Circle
	[15964]="25458:6364:4:0:1:::0:0:", -- Silksand Star
	[9588]="25852:6463:4:0:1:::0:0:", -- Nogg's Gold Ring
	[9538]="25852:6463:4:0:1:::0:0:", -- Talvash's Gold Ring
	[10455]="25859:6464:4:0:1:::0:0:", -- Chained Essence of Eranikus
	[11997]="25876:6469:4:0:1:::0:0:", -- Greenstone Circle
	[12048]="26030:6507:4:0:1:::0:0:", -- Prismatic Pendant
	[11868]="26170:6542:4:0:1:::0:0:", -- Choking Band
	[11869]="26170:6542:4:0:1:::0:0:", -- Sha'ni's Ring
	[11945]="26370:6592:4:0:1:::0:0:", -- Dark Iron Ring
	[13371]="26630:6657:4:0:1:::0:0:", -- Father Flame
	[13171]="28000:7000:4:0:1:::0:0:", -- Smokey's Lighter
	[11862]="28170:7042:4:0:1:::0:0:", -- White Bone Band
	[9655]="28370:7092:4:0:1:::0:0:", -- Seedtime Hoop
	[15799]="28435:7108:4:0:1:::0:0:", -- Heroic Commendation Medal
	[11988]="28455:7113:4:0:1:::0:0:", -- Tellurium Band
	[7555]="28493:7123:4:0:1:::0:0:", -- Regal Star
	[17773]="28530:7132:4:0:1:::0:0:", -- Prodigious Shadowshard Pendant
	[17772]="28530:7132:4:0:1:::0:0:", -- Zealous Shadowshard Pendant
	[11859]="28540:7135:4:0:1:::0:0:", -- Jademoon Orb
	[12030]="28574:7143:4:0:1:::0:0:", -- Jet Chain
	[11122]="28650:7162:4:0:1:::0:0:", -- Carrot on a Stick
	[13473]="28658:7164:4:0:1:::0:0:", -- Felstone Good Luck Charm
	[7611]="29458:7364:4:0:1:::0:0:", -- Mistscape Stave
	[15702]="29585:7396:4:0:1:::0:0:", -- Chemist's Ring
	[11992]="29585:7396:4:0:1:::0:0:", -- Vermilion Band
	[11978]="29658:7414:4:0:1:::0:0:", -- Jasper Link
	[15867]="29857:7464:4:0:1:::0:0:", -- Prismcharm
	[15980]="29878:7469:4:0:1:::0:0:", -- Darkmist Orb
	[11979]="29885:7471:4:0:1:::0:0:", -- Perdiot Circle
	[11989]="29887:7471:4:0:1:::0:0:", -- Vanadium Loop
	[18302]="30122:7530:4:0:1:::0:0:", -- Band of Vigor
	[9914]="30230:7557:4:0:1:::0:0:", -- Royal Scepter
	[7557]="30385:7596:4:0:1:::0:0:", -- Gossamer Rod
	[12026]="31030:7757:4:0:1:::0:0:", -- Quicksilver Pendant
	[12045]="31068:7767:4:0:1:::0:0:", -- Swamp Pendant
	[11976]="31112:7778:4:0:1:::0:0:", -- Sardonyx Knuckle
	[12016]="31125:7781:4:0:1:::0:0:", -- Jungle Ring
	[16623]="31135:7783:4:0:1:::0:0:", -- Opaline Medallion
	[15981]="31548:7215:4:0:1:::0:0:", -- Lunar Sphere
	[17768]="31565:7891:4:0:1:::0:0:", -- Woodseed Hoop
	[12031]="31578:7894:4:0:1:::0:0:", -- Lodestone Necklace
	[11977]="31587:7896:4:0:1:::0:0:", -- Serpentine Loop
	[11946]="31650:7912:4:0:1:::0:0:", -- Fire Opal Necklace
	[15937]="31690:7922:4:0:1:::0:0:", -- Hibernal Sphere
	[12065]="31813:7953:4:0:1:::0:0:", -- Ward of the Elements
	[15965]="31986:7996:4:0:1:::0:0:", -- Windchaser Orb
	[13475]="32436:8109:4:0:1:::0:0:", -- Dalson Family Wedding Ring
	[15982]="32568:8142:4:0:1:::0:0:", -- Bloodwoven Rod
	[6723]="32620:8155:4:0:1:::0:0:", -- Medal of Courage
	[11990]="33225:8306:4:0:1:::0:0:", -- Selenium Loop
	[12057]="33500:8375:4:0:1:::0:0:", -- Dragonscale Band
	[12056]="33500:8375:4:0:1:::0:0:", -- Ring of the Heavens
	[12055]="33500:8375:4:0:1:::0:0:", -- Stardust Band
	[12058]="33505:8376:4:0:1:::0:0:", -- Demonic Bone Ring
	[15983]="33548:8387:4:0:1:::0:0:", -- Gaea's Scepter
	[7746]="33720:8430:4:0:1:::0:0:", -- Explorers' League Commendation
	[9944]="34283:8570:4:0:1:::0:0:", -- Abjurer's Crystal
	[15467]="34520:8630:4:0:1:::0:0:", -- Inventor's League Ring
	[10779]="35230:8807:4:0:1:::0:0:", -- Demon's Blood
	[12015]="35245:8811:4:0:1:::0:0:", -- Swamp Ring
	[12005]="35254:8813:4:0:1:::0:0:", -- Granite Ring
	[13217]="35258:8814:4:0:1:::0:0:", -- Band of the Penitent
	[1490]="35640:8910:4:0:1:::0:0:", -- Guardian Talisman
	[15936]="35802:8950:4:0:1:::0:0:", -- Duskwoven Branch
	[12017]="35853:8963:4:0:1:::0:0:", -- Prismatic Band
	[10708]="35930:8982:4:0:1:::0:0:", -- Skullspell Orb
	[12102]="36170:9042:4:0:1:::0:0:", -- Ring of the Aristocrat
	[12038]="36370:9092:4:0:1:::0:0:", -- Lagrave's Seal
	[15966]="36548:9137:4:0:1:::0:0:", -- Venomshroud Orb
	[15930]="36584:9146:4:0:1:::0:0:", -- Imperial Red Scepter
	[12004]="36652:9163:4:0:1:::0:0:", -- Obsidian Band
	[15938]="38203:9550:4:0:1:::0:0:", -- Mystical Orb
	[15984]="38458:9614:4:0:1:::0:0:", -- Opulent Scepter
	[9644]="39540:9885:4:0:1:::0:0:", -- Thermotastic Egg Timer
	[15985]="39548:9887:4:0:1:::0:0:", -- Arachnidian Branch
	[744]="40000:10000:4:0:1:::0:0:", -- Thunderbrew's Boot Flask
	[11870]="41150:10287:4:0:1:::0:0:", -- Oblivion Orb
	[15967]="41218:10304:4:0:1:::0:0:", -- Highborne Star
	[1404]="41225:10306:4:0:1:::0:0:", -- Tidal Charm
	[17759]="41230:10307:4:0:1:::0:0:", -- Mark of Resolution
	[17001]="41258:10314:4:0:1:::0:0:", -- Elemental Circle
	[15939]="41823:10455:4:0:1:::0:0:", -- Councillor's Scepter
	[11980]="42158:10539:4:0:1:::0:0:", -- Opal Ring
	[15931]="42584:10646:4:0:1:::0:0:", -- Arcane Star
	[13212]="42683:10670:4:0:1:::0:0:", -- Halycon's Spiked Collar
	[15986]="43254:10813:4:0:1:::0:0:", -- Bonecaster's Star
	[10709]="43814:10953:4:0:1:::0:0:", -- Pyrestone Orb
	[15940]="43829:10957:4:0:1:::0:0:", -- Elegant Scepter
	[15987]="43985:10996:4:0:1:::0:0:", -- Astral Orb
	[19115]="44012:11003:4:0:1:::0:0:", -- Flask of Forest Mojo
	[19038]="44581:11145:4:0:1:::0:0:", -- Ring of Subtlety
	[13315]="45587:11396:4:0:1:::0:0:", -- Testament of Hope
	[15941]="49382:12345:4:0:1:::0:0:", -- High Councillor's Scepter
	[15988]="49885:12471:4:0:1:::0:0:", -- Resplendent Orb
	[15989]="49995:12498:4:0:1:::0:0:", -- Eternal Rod
	[15942]="51029:12757:4:0:1:::0:0:", -- Master's Rod
	[11904]="55260:13815:4:0:1:::0:0:", -- Spirit of Aquementas
	[18343]="58462:14615:4:0:1:::0:0:", -- Petrified Band
	[18345]="58908:14727:4:0:1:::0:0:", -- Murmuring Ring
	[18400]="59412:14853:4:0:1:::0:0:", -- Ring of Living Stone
	[12926]="59630:14907:4:0:1:::0:0:", -- Flaming Band
	[13283]="59630:14907:4:0:1:::0:0:", -- Magus Ring
	[19120]="65132:16283:4:0:1:::0:0:", -- Rune of the Guard Captain
	[13177]="65585:16396:4:0:1:::0:0:", -- Talisman of Evasion
	[11196]="67500:16875:4:0:1:::0:0:", -- Mindburst Medallion
	[10778]="67720:16930:4:0:1:::0:0:", -- Necklace of Sanctuary
	[18672]="71420:17855:4:0:1:::0:0:", -- Elemental Ember
	[18402]="74651:18662:4:0:1:::0:0:", -- Glowing Crystal Ring
	[18674]="88014:22003:4:0:1:::0:0:", -- Hardened Stone Band
	[18679]="100546:25136:4:0:1:::0:0:", -- Frigid Ring
	[18464]="116541:29135:4:0:1:::0:0:", -- Gordok Nose Ring
	[16768]="150000:37500:4:0:1:::0:0:", -- Furbolg Medicine Pouch
	[16309]="0:0:4:0:1:::0:0:", -- Drakefire Amulet
	[17907]="0:0:4:0:1:::0:0:", -- Frostwolf Insignia Rank 4
	[18468]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18467]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18472]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18470]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18469]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18465]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18473]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18466]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[18471]="0:0:4:0:1:::0:0:", -- Royal Seal of Eldre'Thalas
	[12344]="0:0:4:0:1:::0:0:", -- Seal of Ascension
	[17902]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 4
	[17903]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 5
	[18602]="0:0:4:0:1:::0:0:", -- Tome of Sacrifice
	[2951]="2625:656:4:0:1:::0:0:", -- Ring of the Underwood
	[2039]="3000:750:4:0:1:::0:0:", -- Plains Ring
	[1156]="3250:812:4:0:1:::0:0:", -- Lavishly Jeweled Ring
	[6332]="4615:1153:4:0:1:::0:0:", -- Black Pearl Ring
	[12985]="4615:1153:4:0:1:::0:0:", -- Ring of Defense
	[13031]="5605:1401:4:0:1:::0:0:", -- Orb of Mistmantle
	[11811]="6000:1500:4:0:1:::0:0:", -- Smoking Heart of the Mountain
	[12996]="6110:1527:4:0:1:::0:0:", -- Band of Purification
	[6463]="6110:1527:4:0:1:::0:0:", -- Deep Fathom Ring
	[5183]="6300:1575:4:0:1:::0:0:", -- Pulsating Hydra Heart
	[2802]="6500:1625:4:0:1:::0:0:", -- Blazing Emblem
	[6321]="6600:1650:4:0:1:::0:0:", -- Silverlaine's Family Seal
	[6693]="7265:1816:4:0:1:::0:0:", -- Agamaggan's Clutch
	[16887]="7954:1988:4:0:1:::0:0:", -- Witch's Finger
	[6414]="8220:2055:4:0:1:::0:0:", -- Seal of Sylvanas
	[13097]="8658:2164:4:0:1:::0:0:", -- Thunderbrow Ring
	[1491]="8830:2207:4:0:1:::0:0:", -- Ring of Precision
	[1714]="10140:2535:4:0:1:::0:0:", -- Necklace of Calisea
	[13094]="10584:2646:4:0:1:::0:0:", -- The Queen's Jewel
	[6695]="12010:3002:4:0:1:::0:0:", -- Stygian Bone Amulet
	[2565]="12453:3113:4:0:1:::0:0:", -- Rod of Molten Fire
	[9447]="12950:3237:4:0:1:::0:0:", -- Electrocutioner Lagnut
	[13093]="13524:3381:4:0:1:::0:0:", -- Blush Ember Ring
	[7731]="13930:3482:4:0:1:::0:0:", -- Ghostshard Talisman
	[18859]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18864]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18854]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18856]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18857]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18862]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18863]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18858]="15000:3750:4:0:1:::1:0:635", -- Insignia of the Alliance
	[18850]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18846]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18834]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18845]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18849]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18853]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18851]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[18852]="15000:3750:4:0:1:::1:0:708", -- Insignia of the Horde
	[2879]="15605:3121:4:0:1:::0:0:", -- Antipodean Rod
	[7686]="17235:4308:4:0:1:::0:0:", -- Ironspine's Eye
	[9461]="18345:4586:4:0:1:::0:0:", -- Charged Gear
	[1973]="18475:4618:4:0:1:::0:0:", -- Orb of Deception
	[6803]="19540:4885:4:0:1:::0:0:", -- Prophetic Cane
	[19521]="20000:5000:4:0:1:::1:0:461", -- Advisor's Ring
	[19513]="20000:5000:4:0:1:::1:0:461", -- Legionnaire's Band
	[19525]="20000:5000:4:0:1:::1:0:353", -- Lorekeeper's Ring
	[18442]="20000:5000:4:0:1:::1:0:635", -- Master Sergeant's Insignia
	[15108]="20000:5000:4:0:1:Restorative::0:0:", -- Orb of Dar'Orahil
	[15107]="20000:5000:4:0:1:Restorative::0:0:", -- Orb of Noh'Orahil
	[19517]="20000:5000:4:0:1:::1:0:353", -- Protector's Band
	[19537]="20000:5000:4:0:1:::1:0:461", -- Scout's Medallion
	[15200]="20000:5000:4:0:1:::1:0:708", -- Senior Sergeant's Insignia
	[19541]="20000:5000:4:0:1:::1:0:353", -- Sentinel's Medallion
	[10769]="21110:5277:4:0:1:::0:0:", -- Glowing Eye of Mordresh
	[1713]="21400:5350:4:0:1:::0:0:", -- Ankh of Life
	[7515]="21530:5382:4:0:1:::0:0:", -- Celestial Orb
	[4696]="22150:5537:4:0:1:Drink::0:0:", -- Lapidis Tankard of Tidesippe
	[10795]="22170:5542:4:0:1:::0:0:", -- Drakeclaw Band
	[13029]="22453:5613:4:0:1:::0:0:", -- Umbral Crystal
	[13087]="23584:5896:4:0:1:::0:0:", -- River Pride Choker
	[10824]="23720:5930:4:0:1:::0:0:", -- Amberglow Talisman
	[10710]="24520:6130:4:0:1:::0:0:", -- Dragonclaw Ring
	[13084]="26458:6614:4:0:1:::0:0:", -- Kaleidoscope Chain
	[13095]="26584:6646:4:0:1:::0:0:", -- Assault Band
	[7685]="27340:5468:4:0:1:::0:0:", -- Orb of the Forgotten Seer
	[1992]="27340:5468:4:0:1:::0:0:", -- Swampchill Fetish
	[12545]="28330:7082:4:0:1:::0:0:", -- Eye of Orgrimmar
	[9533]="28370:7092:4:0:1:::0:0:", -- Masons Fraternity Ring
	[12548]="28410:7102:4:0:1:::0:0:", -- Magni's Will
	[11302]="28520:7130:4:0:1:::0:0:", -- Uther's Strength
	[12543]="28625:7156:4:0:1:::0:0:", -- Songstone of Ironforge
	[12544]="29630:7407:4:0:1:::0:0:", -- Thrall's Resolve
	[13088]="29654:7413:4:0:1:::0:0:", -- Gazlowe's Charm
	[18444]="30000:7500:4:0:1:::1:0:635", -- Master Sergeant's Insignia
	[18428]="30000:7500:4:0:1:::1:0:708", -- Senior Sergeant's Insignia
	[10770]="31340:7835:4:0:1:::0:0:", -- Mordresh's Lifeless Skull
	[9393]="31530:7882:4:0:1:::0:0:", -- Beacon of Hope
	[15855]="31555:7888:4:0:1:::0:0:", -- Ring of Protection
	[13096]="31654:7913:4:0:1:::0:0:", -- Band of the Hierophant
	[13089]="32156:8039:4:0:1:::0:0:", -- Skibi's Pendant
	[11262]="32570:8142:4:0:1:::0:0:", -- Orb of Lorica
	[15873]="32578:8144:4:0:1:::0:0:", -- Ragged John's Neverending Cup
	[10711]="33510:8377:4:0:1:::0:0:", -- Dragon's Blood Necklace
	[2262]="34985:8746:4:0:1:::0:0:", -- Mark of Kern
	[15856]="35155:8788:4:0:1:::0:0:", -- Archlight Talisman
	[10796]="35930:8982:4:0:1:::0:0:", -- Drakestone
	[7888]="35961:8990:4:0:1:::0:0:", -- Jarkal's Enhancing Necklace
	[7673]="35961:8990:4:0:1:::0:0:", -- Talvash's Enhancing Necklace
	[14023]="35965:8991:4:0:1:::0:0:", -- Barov Peasant Caller
	[14022]="35965:8991:4:0:1:::0:0:", -- Barov Peasant Caller
	[17744]="36125:9031:4:0:1:::0:0:", -- Heart of Noxxion
	[13085]="36548:9137:4:0:1:::0:0:", -- Horizon Choker
	[7722]="37180:9295:4:0:1:::0:0:", -- Triune Amulet
	[13515]="38400:9600:4:0:1:::0:0:", -- Ramstein's Lightning Bolts
	[13209]="38462:9615:4:0:1:::0:0:", -- Seal of the Dawn
	[13213]="38533:9633:4:0:1:::0:0:", -- Smolderweb's Eye
	[18289]="38804:9701:4:0:1:::0:0:", -- Barbed Thorn Necklace
	[12930]="40000:10000:4:0:1:::0:0:", -- Briarwood Reed
	[11832]="40000:10000:4:0:1:::0:0:", -- Burst of Knowledge
	[11810]="40000:10000:4:0:1:::0:0:", -- Force of Will
	[11815]="40000:10000:4:0:1:::0:0:", -- Hand of Justice
	[18443]="40000:10000:4:0:1:::1:0:635", -- Master Sergeant's Insignia
	[11819]="40000:10000:4:0:1:::0:0:", -- Second Wind
	[16335]="40000:10000:4:0:1:::1:0:708", -- Senior Sergeant's Insignia
	[19024]="40124:10031:4:0:1:::0:0:", -- Arena Grand Master
	[16058]="40625:10156:4:0:1:::0:0:", -- Fordring's Seal
	[17737]="40655:10163:4:0:1:::0:0:", -- Cloud Stone
	[15411]="41135:10283:4:0:1:::0:0:", -- Mark of Fordring
	[11625]="41810:10452:4:0:1:::0:0:", -- Enthralled Sphere
	[13261]="41810:10452:4:0:1:::0:0:", -- Globe of D'sak
	[13164]="42158:10539:4:0:1:::0:0:", -- Heart of the Scale
	[13091]="42549:10637:4:0:1:::0:0:", -- Medallion of Grand Marshal Morris
	[13001]="42594:10648:4:0:1:::0:0:", -- Maiden's Circle
	[10829]="42720:10680:4:0:1:::0:0:", -- Dragon's Eye
	[18022]="42837:10709:4:0:1:::0:0:", -- Royal Seal of Alexis
	[16999]="42837:10709:4:0:1:::0:0:", -- Royal Seal of Alexis
	[13379]="42939:10734:4:0:1:::0:0:", -- Piccolo of the Flaming Fire
	[11118]="43180:10795:4:0:1:::0:0:", -- Archaedic Stone
	[10634]="43250:10812:4:0:1:::0:0:", -- Mindseye Circle
	[13382]="43400:10850:4:0:1:::0:0:", -- Cannonball Runner
	[5266]="44630:11157:4:0:1:::0:0:", -- Eye of Adaegus
	[19520]="45000:11250:4:0:1:::1:0:461", -- Advisor's Ring
	[19512]="45000:11250:4:0:1:::1:0:461", -- Legionnaire's Band
	[19524]="45000:11250:4:0:1:::1:0:353", -- Lorekeeper's Ring
	[19515]="45000:11250:4:0:1:::1:0:353", -- Protector's Band
	[19536]="45000:11250:4:0:1:::1:0:461", -- Scout's Medallion
	[19540]="45000:11250:4:0:1:::1:0:353", -- Sentinel's Medallion
	[17707]="46525:11631:4:0:1:::0:0:", -- Gemshard Heart
	[13141]="48373:12093:4:0:1:::0:0:", -- Tooth of Gnarr
	[18314]="48400:12100:4:0:1:::0:0:", -- Ring of Demonic Guile
	[18315]="48400:12100:4:0:1:::0:0:", -- Ring of Demonic Potency
	[12103]="48630:12157:4:0:1:::0:0:", -- Star of Mystaria
	[13392]="48846:12211:4:0:1:::0:0:", -- The Postmaster's Seal
	[12059]="49510:12377:4:0:1:::0:0:", -- Conqueror's Medallion
	[13524]="49835:12458:4:0:1:::0:0:", -- Skull of Burning Shadows
	[19303]="50000:12500:4:0:1:::1:1:521", -- Darkmoon Necklace
	[19302]="50000:12500:4:0:1:::1:1:521", -- Darkmoon Ring
	[18317]="50012:12503:4:0:1:::0:0:", -- Tempest Talisman
	[13960]="51315:12828:4:0:1:::0:0:", -- Heart of the Fiend
	[9641]="52165:13041:4:0:1:::0:0:", -- Lifeblood Amulet
	[13030]="52453:13113:4:0:1:::0:0:", -- Basilisk Bone
	[11935]="52650:13162:4:0:1:::0:0:", -- Magmus Stone
	[13385]="52950:13237:4:0:1:::0:0:", -- Tome of Knowledge
	[11824]="54630:13657:4:0:1:::0:0:", -- Cyclopean Band
	[13178]="55130:13782:4:0:1:::0:0:", -- Rosewine Circle
	[13002]="58469:14617:4:0:1:::0:0:", -- Lady Alizabeth's Pendant
	[11755]="58510:14627:4:0:1:::0:0:", -- Verek's Collar
	[17713]="58565:14641:4:0:1:::0:0:", -- Blackstone Ring
	[15805]="58650:14662:4:0:1:::0:0:", -- Penelope's Rose
	[13373]="59387:14846:4:0:1:::0:0:", -- Band of Flesh
	[17045]="59387:14846:4:0:1:::0:0:", -- Blood of the Martyr
	[18565]="59413:14853:4:0:1:::0:0:", -- Band of Allegiance
	[18585]="59413:14853:4:0:1:::0:0:", -- Band of Allegiance
	[18586]="59413:14853:4:0:1:::0:0:", -- Lonetree's Circle
	[19519]="60000:15000:4:0:1:::1:0:461", -- Advisor's Ring
	[19511]="60000:15000:4:0:1:::1:0:461", -- Legionnaire's Band
	[19523]="60000:15000:4:0:1:::1:0:353", -- Lorekeeper's Ring
	[19516]="60000:15000:4:0:1:::1:0:353", -- Protector's Band
	[19535]="60000:15000:4:0:1:::1:0:461", -- Scout's Medallion
	[19539]="60000:15000:4:0:1:::1:0:353", -- Sentinel's Medallion
	[17044]="60155:15038:4:0:1:::0:0:", -- Will of the Martyr
	[18103]="61010:15252:4:0:1:::0:0:", -- Band of Rumination
	[13098]="61130:15282:4:0:1:::0:0:", -- Painweaver Band
	[15857]="61342:15335:4:0:1:::0:0:", -- Magebane Scion
	[13345]="61830:15457:4:0:1:::0:0:", -- Seal of Rivendare
	[7734]="61980:15495:4:0:1:::0:0:", -- Six Demon Bag
	[6440]="63250:15812:4:0:1:::0:0:", -- Brainlash
	[13965]="65000:16250:4:0:1:::0:0:", -- Blackhand's Breadth
	[13968]="65000:16250:4:0:1:::0:0:", -- Eye of the Beast
	[13966]="65000:16250:4:0:1:::0:0:", -- Mark of Tyranny
	[11669]="68630:17157:4:0:1:::0:0:", -- Naglering
	[18354]="69864:17466:4:0:1:::0:0:", -- Pimgib's Collar
	[19096]="71648:17912:4:0:1:::1:0:287,416", -- Frostwolf Advisor's Pendant
	[19095]="71648:17912:4:0:1:::1:0:287,416", -- Frostwolf Legionnaire's Pendant
	[19098]="71648:17912:4:0:1:::1:0:224,774", -- Stormpike Sage's Pendant
	[19097]="71648:17912:4:0:1:::1:0:224,774", -- Stormpike Soldier's Pendant
	[19518]="75000:18750:4:0:1:::1:0:461", -- Advisor's Ring
	[19510]="75000:18750:4:0:1:::1:0:461", -- Legionnaire's Band
	[19522]="75000:18750:4:0:1:::1:0:353", -- Lorekeeper's Ring
	[19514]="75000:18750:4:0:1:::1:0:353", -- Protector's Band
	[19534]="75000:18750:4:0:1:::1:0:461", -- Scout's Medallion
	[19538]="75000:18750:4:0:1:::1:0:353", -- Sentinel's Medallion
	[12929]="78585:19646:4:0:1:::0:0:", -- Emberfury Talisman
	[11933]="78585:19646:4:0:1:::0:0:", -- Imperial Jewel
	[11934]="79685:19921:4:0:1:::0:0:", -- Emperor's Seal
	[18371]="82948:20737:4:0:1:::0:0:", -- Mindtap Talisman
	[19159]="84564:21141:4:0:1:::0:0:", -- Woven Ivy Necklace
	[18370]="86450:21612:4:0:1:::0:0:", -- Vigilance Charm
	[18381]="86542:21635:4:0:1:::0:0:", -- Evil Eye Pendant
	[11928]="88181:22045:4:0:1:::0:0:", -- Thaurissan's Royal Scepter
	[18397]="89857:22464:4:0:1:::0:0:", -- Elder Magus Pendant
	[17982]="95846:23961:4:0:1:::0:0:", -- Ragnaros Core
	[19491]="100000:25000:4:0:1:::0:0:", -- Amulet of the Darkmoon
	[19426]="100000:25000:4:0:1:::0:0:", -- Orb of the Darkmoon
	[12609]="102494:20498:4:0:1:::0:0:", -- Polychromatic Visionwrap
	[18678]="106541:26635:4:0:1:::0:0:", -- Tempestria's Frozen Necklace
	[18399]="108413:27103:4:0:1:::0:0:", -- Ocean's Breeze
	[18398]="108413:27103:4:0:1:::0:0:", -- Tidal Loop
	[18762]="110526:27631:4:0:1:::0:0:", -- Shard of the Green Flame
	[18340]="115412:28853:4:0:1:::0:0:", -- Eidolon Talisman
	[18760]="123465:30866:4:0:1:::0:0:", -- Necromantic Band
	[18500]="125360:31340:4:0:1:::0:0:", -- Tarnished Elven Ring
	[18691]="125601:31400:4:0:1:::0:0:", -- Dark Advisor's Pendant
	[18728]="129865:32466:4:0:1:::0:0:", -- Anastari Heirloom
	[19109]="135681:33920:4:0:1:::0:0:", -- Deep Rooted Ring
	[18695]="137801:34450:4:0:1:::0:0:", -- Spellbound Tome
	[18523]="139243:34810:4:0:1:::0:0:", -- Brightly Glowing Stone
	[18684]="144564:36141:4:0:1:::0:0:", -- Dimly Opalescent Ring
	[18522]="145013:36253:4:0:1:::0:0:", -- Band of the Ogre King
	[18701]="145640:36410:4:0:1:::0:0:", -- Innervating Band
	[18395]="146580:36645:4:0:1:::0:0:", -- Emerald Flame Ring
	[862]="152890:38222:4:0:1:::0:0:", -- Runed Ring
	[18536]="154658:38664:4:0:1:::0:0:", -- Milli's Lexicon
	[18723]="167814:41953:4:0:1:::0:0:", -- Animated Chain Necklace
	[18537]="264540:66135:4:0:1:::0:0:", -- Counterattack Lodestone
	[17909]="0:0:4:0:1:::0:0:", -- Frostwolf Insignia Rank 6
	[17904]="0:0:4:0:1:::0:0:", -- Stormpike Insignia Rank 6
	[18820]="0:0:4:0:1:::0:0:", -- Talisman of Ephemeral Power
	[18646]="0:0:4:0:1:::0:0:", -- The Eye of Divinity
	[18665]="0:0:4:0:1:::0:0:", -- The Eye of Shadow
	[942]="18000:4500:4:0:1:::0:0:", -- Freezing Band
	[1980]="24800:6200:4:0:1:::0:0:", -- Underworld Band
	[18404]="26856:6714:4:0:1:::0:0:", -- Onyxia Tooth Pendant
	[13353]="41810:10452:4:0:1:::0:0:", -- Book of the Dead
	[14558]="42000:10500:4:0:1:::0:0:", -- Lady Maye's Pendant
	[1315]="52000:13000:4:0:1:::0:0:", -- Lei of Lilies
	[14557]="71520:17880:4:0:1:::0:0:", -- The Lion Horn of Stormwind
	[1443]="84500:21125:4:0:1:::0:0:", -- Jeweled Amulet of Cainwyn
	[13143]="85490:21372:4:0:1:::0:0:", -- Mark of the Dragon Lord
	[1447]="91100:22775:4:0:1:::0:0:", -- Ring of Saviors
	[17063]="95846:23961:4:0:1:::0:0:", -- Band of Accuria
	[17110]="98595:24648:4:0:1:::0:0:", -- Seal of the Archmagus
	[833]="112000:28000:4:0:1:::0:0:", -- Lifestone
	[2246]="120000:30000:4:0:1:::0:0:", -- Myrmidon's Signet
	[18205]="133150:33287:4:0:1:::0:0:", -- Eskhandar's Collar
	[17065]="133525:33381:4:0:1:::0:0:", -- Medallion of Steadfast Might
	[17109]="134500:33625:4:0:1:::0:0:", -- Choker of Enlightenment
	[17111]="138595:34648:4:0:1:::0:0:", -- Blazefury Medallion
	[17064]="183658:45914:4:0:1:::0:0:", -- Shard of the Scale
	[18406]="184123:46030:4:0:1:::0:0:", -- Onyxia Blood Talisman
	[17082]="184585:46146:4:0:1:::0:0:", -- Shard of the Flame
	[18403]="196240:49060:4:0:1:::0:0:", -- Dragonslayer's Signet
	[18879]="213456:53364:4:0:1:::0:0:", -- Heavy Dark Iron Ring
	[19140]="241024:60256:4:0:1:::0:0:", -- Cauterizing Band
	[18543]="254912:63728:4:0:1:::0:0:", -- Ring of Entropy
	[18821]="256120:64030:4:0:1:::0:0:", -- Quick Strike Ring
	[18815]="256380:64095:4:0:1:::0:0:", -- Essence of the Pure Flame
	[19336]="288156:72039:4:0:1:::0:0:", -- Arcane Infused Gem
	[19341]="288156:72039:4:0:1:::0:0:", -- Lifegiving Gem
	[19339]="288156:72039:4:0:1:::0:0:", -- Mind Quickening Gem
	[19340]="288156:72039:4:0:1:::0:0:", -- Rune of Metamorphosis
	[19343]="288156:72039:4:0:1:::0:0:", -- Scrolls of Blinding Light
	[19337]="288156:72039:4:0:1:::0:0:", -- The Black Book
	[19342]="288156:72039:4:0:1:::0:0:", -- Venomous Totem
	[17067]="301810:75452:4:0:1:::0:0:", -- Ancient Cornerstone Grimoire
	[19138]="319412:79853:4:0:1:::0:0:", -- Band of Sulfuras
	[19434]="323454:80863:4:0:1:::0:0:", -- Band of Dark Dominion
	[19371]="353421:88355:4:0:1:::0:0:", -- Pendant of the Fallen Dragon
	[18813]="356412:89103:4:0:1:::0:0:", -- Ring of Binding
	[18814]="356542:89135:4:0:1:::0:0:", -- Choker of the Fire Lord
	[19406]="364641:91160:4:0:1:::0:0:", -- Drake Fang Talisman
	[19147]="365815:91453:4:0:1:::0:0:", -- Ring of Spell Power
	[19288]="400000:100000:4:0:1:::0:0:", -- Darkmoon Card: Blue Dragon
	[19289]="400000:100000:4:0:1:::0:0:", -- Darkmoon Card: Maelstrom
	[19290]="400000:100000:4:0:1:::0:0:", -- Darkmoon Card: Twisting Nether
	[19395]="412413:103103:4:0:1:::0:0:", -- Rejuvenating Gem
	[19431]="412471:103117:4:0:1:::0:0:", -- Styleen's Impeding Scarab
	[19403]="421312:105328:4:0:1:::0:0:", -- Band of Forced Concentration
	[19397]="429754:107438:4:0:1:::0:0:", -- Ring of Blackrock
	[19312]="500000:125000:4:0:1:::1:0:287,416,774", -- Lei of the Lifegiver
	[19315]="500000:125000:4:0:1:::1:0:287,416,774", -- Therazane's Touch
	[19309]="500000:125000:4:0:1:::1:0:287,416,774", -- Tome of Shadow Force
	[19310]="500000:125000:4:0:1:::1:0:287,416,774", -- Tome of the Ice Lord
	[19325]="755555:188888:4:0:1:::1:0:287,416,774", -- Don Julio's Band
	[1396]="4:1:4:1:1:::0:0:", -- Acolyte's Pants
	[6140]="4:1:4:1:1:::0:0:", -- Apprentice's Robe
	[139]="4:1:4:1:1:::0:0:", -- Brawler's Pants
	[48]="4:1:4:1:1:::0:0:", -- Footpad's Pants
	[6098]="4:1:4:1:1:::0:0:", -- Neophyte's Robe
	[6119]="4:1:4:1:1:::0:0:", -- Neophyte's Robe
	[6123]="4:1:4:1:1:::0:0:", -- Novice's Robe
	[6139]="4:1:4:1:1:::0:0:", -- Novice's Robe
	[6121]="4:1:4:1:1:::0:0:", -- Recruit's Pants
	[6118]="4:1:4:1:1:::0:0:", -- Squire's Pants
	[44]="4:1:4:1:1:::0:0:", -- Squire's Pants
	[120]="4:1:4:1:1:::0:0:", -- Thug Pants
	[6137]="4:1:4:1:1:::0:0:", -- Thug Pants
	[57]="5:1:4:1:1:::0:0:", -- Acolyte's Robe
	[6129]="5:1:4:1:1:::0:0:", -- Acolyte's Robe
	[1395]="5:1:4:1:1:::0:0:", -- Apprentice's Pants
	[56]="5:1:4:1:1:::0:0:", -- Apprentice's Robe
	[128]="5:1:4:1:1:::0:0:", -- Deprecated Tauren Trapper's Pants
	[52]="5:1:4:1:1:::0:0:", -- Neophyte's Pants
	[6144]="5:1:4:1:1:::0:0:", -- Neophyte's Robe
	[6124]="5:1:4:1:1:::0:0:", -- Novice's Pants
	[39]="5:1:4:1:1:::0:0:", -- Recruit's Pants
	[147]="5:1:4:1:1:::0:0:", -- Rugged Trapper's Pants
	[6126]="5:1:4:1:1:::0:0:", -- Trapper's Pants
	[1377]="6:1:4:1:1:::0:0:", -- Frayed Gloves
	[3363]="7:1:4:1:1:::0:0:", -- Frayed Belt
	[1378]="9:1:4:1:1:::0:0:", -- Frayed Pants
	[1372]="11:2:4:1:1:::0:0:", -- Ragged Cloak
	[3365]="16:3:4:1:1:::0:0:", -- Frayed Bracers
	[1374]="16:3:4:1:1:::0:0:", -- Frayed Shoes
	[1380]="21:4:4:1:1:::0:0:", -- Frayed Robe
	[1376]="23:4:4:1:1:::0:0:", -- Frayed Cloak
	[2652]="36:7:4:1:1:::0:0:", -- Flimsy Chain Cloak
	[1429]="38:7:4:1:1:::0:0:", -- Patchwork Cloak
	[1430]="38:7:4:1:1:::0:0:", -- Patchwork Gloves
	[3370]="50:10:4:1:1:::0:0:", -- Patchwork Belt
	[2644]="56:11:4:1:1:::0:0:", -- Loose Chain Cloak
	[3373]="71:14:4:1:1:::0:0:", -- Patchwork Bracers
	[1433]="72:14:4:1:1:::0:0:", -- Patchwork Armor
	[1431]="101:20:4:1:1:::0:0:", -- Patchwork Pants
	[1421]="144:28:4:1:1:::0:0:", -- Worn Hide Cloak
	[1427]="147:29:4:1:1:::0:0:", -- Patchwork Shoes
	[3375]="152:30:4:1:1:::0:0:", -- Calico Bracers
	[3374]="227:45:4:1:1:::0:0:", -- Calico Belt
	[1505]="244:48:4:1:1:::0:0:", -- Warped Cloak
	[1499]="255:51:4:1:1:::0:0:", -- Calico Pants
	[1498]="285:57:4:1:1:::0:0:", -- Calico Gloves
	[1495]="294:58:4:1:1:::0:0:", -- Calico Shoes
	[1497]="356:71:4:1:1:::0:0:", -- Calico Cloak
	[1501]="402:80:4:1:1:::0:0:", -- Calico Tunic
	[3376]="431:86:4:1:1:::0:0:", -- Canvas Belt
	[1733]="443:88:4:1:1:::0:0:", -- Worn Cloak
	[1790]="469:93:4:1:1:::0:0:", -- Patched Cloak
	[3377]="497:99:4:1:1:::0:0:", -- Canvas Bracers
	[1767]="505:101:4:1:1:::0:0:", -- Canvas Gloves
	[1741]="562:112:4:1:1:::0:0:", -- Laced Cloak
	[1764]="568:113:4:1:1:::0:0:", -- Canvas Shoes
	[1766]="658:131:4:1:1:::0:0:", -- Canvas Cloak
	[3378]="660:132:4:1:1:::0:0:", -- Brocade Belt
	[1770]="719:143:4:1:1:::0:0:", -- Canvas Vest
	[3379]="762:152:4:1:1:::0:0:", -- Brocade Bracers
	[1769]="816:163:4:1:1:::0:0:", -- Canvas Shoulderpads
	[1775]="1064:212:4:1:1:::0:0:", -- Brocade Gloves
	[1768]="1085:217:4:1:1:::0:0:", -- Canvas Pants
	[1777]="1114:222:4:1:1:::0:0:", -- Brocade Shoulderpads
	[1772]="1235:247:4:1:1:::0:0:", -- Brocade Shoes
	[1783]="1238:247:4:1:1:::0:0:", -- Cross-stitched Gloves
	[1776]="1287:257:4:1:1:::0:0:", -- Brocade Pants
	[1798]="1397:279:4:1:1:::0:0:", -- Rawhide Cloak
	[1774]="1406:281:4:1:1:::0:0:", -- Brocade Cloak
	[3381]="1515:303:4:1:1:::0:0:", -- Cross-stitched Bracers
	[1778]="1685:337:4:1:1:::0:0:", -- Brocade Vest
	[3380]="1826:365:4:1:1:::0:0:", -- Cross-stitched Belt
	[1749]="1982:396:4:1:1:::0:0:", -- Linked Chain Cloak
	[1785]="2322:464:4:1:1:::0:0:", -- Cross-stitched Shoulderpads
	[1806]="2330:466:4:1:1:::0:0:", -- Tough Cloak
	[1780]="2445:489:4:1:1:::0:0:", -- Cross-stitched Sandals
	[3796]="2467:493:4:1:1:::0:0:", -- Interlaced Gloves
	[3792]="2606:521:4:1:1:::0:0:", -- Interlaced Belt
	[1782]="2709:541:4:1:1:::0:0:", -- Cross-stitched Cloak
	[1784]="2734:546:4:1:1:::0:0:", -- Cross-stitched Pants
	[3793]="3243:648:4:1:1:::0:0:", -- Interlaced Boots
	[8746]="3411:682:4:1:1:::0:0:", -- Interlaced Cowl
	[1786]="3419:683:4:1:1:::0:0:", -- Cross-stitched Vest
	[1757]="3643:728:4:1:1:::0:0:", -- Reinforced Chain Cloak
	[3794]="3874:774:4:1:1:::0:0:", -- Interlaced Bracers
	[3798]="4510:902:4:1:1:::0:0:", -- Interlaced Shoulderpads
	[3795]="4909:981:4:1:1:::0:0:", -- Interlaced Cloak
	[3936]="4926:985:4:1:1:::0:0:", -- Crochet Belt
	[3811]="5323:1064:4:1:1:::0:0:", -- Double-stitched Cloak
	[3803]="5432:1086:4:1:1:::0:0:", -- Hardened Cloak
	[3938]="5949:1189:4:1:1:::0:0:", -- Crochet Bracers
	[3799]="7304:1460:4:1:1:::0:0:", -- Interlaced Vest
	[8749]="8019:1603:4:1:1:::0:0:", -- Crochet Hat
	[3940]="8154:1630:4:1:1:::0:0:", -- Crochet Gloves
	[3797]="8460:1692:4:1:1:::0:0:", -- Interlaced Pants
	[3937]="10092:2018:4:1:1:::0:0:", -- Crochet Boots
	[3964]="10638:2127:4:1:1:::0:0:", -- Thick Cloak
	[3943]="11221:2244:4:1:1:::0:0:", -- Crochet Vest
	[3939]="11283:2256:4:1:1:::0:0:", -- Crochet Cloak
	[3944]="11389:2277:4:1:1:::0:0:", -- Twill Belt
	[3946]="12159:2431:4:1:1:::0:0:", -- Twill Bracers
	[3941]="12993:2598:4:1:1:::0:0:", -- Crochet Pants
	[3942]="13183:2636:4:1:1:::0:0:", -- Crochet Shoulderpads
	[3948]="15463:3092:4:1:1:::0:0:", -- Twill Gloves
	[3947]="16292:3258:4:1:1:::0:0:", -- Twill Cloak
	[3945]="19263:3852:4:1:1:::0:0:", -- Twill Boots
	[3972]="19456:3891:4:1:1:::0:0:", -- Smooth Cloak
	[8754]="19687:3937:4:1:1:::0:0:", -- Twill Cover
	[4003]="20451:4090:4:1:1:::0:0:", -- Overlinked Chain Cloak
	[3950]="20789:4157:4:1:1:::0:0:", -- Twill Shoulderpads
	[3951]="29487:5897:4:1:1:::0:0:", -- Twill Vest
	[3995]="31422:6284:4:1:1:::0:0:", -- Laminated Scale Cloak
	[3949]="32586:6517:4:1:1:::0:0:", -- Twill Pants
	[4854]="0:0:4:1:1:::0:0:", -- Demon Scarred Cloak
	[12064]="4:1:4:1:1:::0:0:", -- Gamemaster Hood
	[11508]="5:1:4:1:1:::0:0:", -- Gamemaster's Slippers
	[2586]="6:1:4:1:1:::0:0:", -- Gamemaster's Robe
	[3263]="22:4:4:1:1:::0:0:", -- Webbed Pants
	[11192]="23:4:4:1:1:::0:0:", -- Outfitter Gloves
	[719]="23:4:4:1:1:::0:0:", -- Rabbit Handler Gloves
	[3595]="23:4:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Belt
	[3596]="23:4:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Bracers
	[6060]="24:4:4:1:1:::0:0:", -- Flax Bracers
	[3599]="24:4:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Belt
	[3600]="24:4:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Bracers
	[2119]="24:4:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Gloves
	[4919]="25:5:4:1:1:::0:0:", -- Soft Wool Belt
	[11187]="25:5:4:1:1:::0:0:", -- Stemleaf Bracers
	[711]="25:5:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Gloves
	[11848]="26:5:4:1:1:::0:0:", -- Flax Belt
	[3275]="26:5:4:1:1:::0:0:", -- Flax Gloves
	[11190]="26:5:4:1:1:::0:0:", -- Viny Gloves
	[2110]="31:6:4:1:1:::0:0:", -- Light Magesmith Robe
	[3260]="31:6:4:1:1:::0:0:", -- Scarlet Initiate Robes
	[11850]="35:7:4:1:1:::0:0:", -- Short Duskbat Cape
	[80]="35:7:4:1:1:::0:0:", -- Soft Fur-lined Shoes
	[4915]="35:7:4:1:1:::0:0:", -- Soft Wool Boots
	[3261]="35:7:4:1:1:::0:0:", -- Webbed Cloak
	[5405]="36:7:4:1:1:::0:0:", -- Draped Cloak
	[6173]="36:7:4:1:1:::0:0:", -- Snow Boots
	[195]="36:7:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Boots
	[2117]="36:7:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Shoes
	[4920]="37:7:4:1:1:::0:0:", -- Battleworn Cape
	[11847]="38:7:4:1:1:::0:0:", -- Battered Cloak
	[3274]="38:7:4:1:1:::0:0:", -- Flax Boots
	[11475]="38:7:4:1:1:::0:0:", -- Wine-stained Cloak
	[6185]="47:9:4:1:1:::0:0:", -- Bear Shawl
	[6076]="47:9:4:1:1:::0:0:", -- Tapered Pants
	[4916]="48:9:4:1:1:::0:0:", -- Soft Wool Vest
	[193]="48:9:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Vest
	[10655]="49:9:4:1:1:::0:0:", -- Sedgeweed Britches
	[194]="49:9:4:1:1:::1:0:35,350,516,674", -- Tattered Cloth Pants
	[2121]="50:10:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Armor
	[2120]="50:10:4:1:1:::1:0:156,176,228,251,398,544", -- Thin Cloth Pants
	[3270]="51:10:4:1:1:::0:0:", -- Flax Vest
	[6713]="51:10:4:1:1:::0:0:", -- Ripped Pants
	[79]="52:10:4:1:1:::0:0:", -- Dwarven Cloth Britches
	[11189]="52:10:4:1:1:::0:0:", -- Woodland Robes
	[3070]="55:11:4:1:1:::0:0:", -- Ensign Cloak
	[2570]="55:11:4:1:1:::0:0:", -- Linen Cloak
	[3322]="55:11:4:1:1:::0:0:", -- Wispy Cloak
	[3641]="78:15:4:1:1:::0:0:", -- Journeyman's Bracers
	[3323]="79:15:4:1:1:::0:0:", -- Ghostly Bracers
	[14087]="82:16:4:1:1:::0:0:", -- Beaded Cuffs
	[12299]="82:16:4:1:1:::0:0:", -- Netted Gloves
	[2571]="84:16:4:1:1:::0:0:", -- Viny Wrappings
	[14093]="106:21:4:1:1:::0:0:", -- Beaded Cord
	[983]="108:21:4:1:1:::0:0:", -- Red Linen Sash
	[2960]="109:21:4:1:1:::0:0:", -- Journeyman's Gloves
	[3642]="111:22:4:1:1:::0:0:", -- Ancestral Bracers
	[7026]="111:22:4:1:1:::0:0:", -- Linen Belt
	[4665]="113:22:4:1:1:::0:0:", -- Burnt Cloak
	[5606]="115:23:4:1:1:::0:0:", -- Gardening Gloves
	[4663]="115:23:4:1:1:::0:0:", -- Journeyman's Belt
	[10045]="117:23:4:1:1:::0:0:", -- Simple Linen Pants
	[4936]="118:23:4:1:1:::0:0:", -- Dirt-trodden Boots
	[4658]="118:23:4:1:1:::0:0:", -- Warrior's Cloak
	[15475]="120:24:4:1:1:::0:0:", -- Charger's Cloak
	[3833]="121:24:4:1:1:::0:0:", -- Adept's Cloak
	[15007]="122:24:4:1:1:::0:0:", -- Primal Cape
	[4662]="123:24:4:1:1:::0:0:", -- Journeyman's Cloak
	[14088]="124:24:4:1:1:::0:0:", -- Beaded Cloak
	[5458]="138:27:4:1:1:::0:0:", -- Dirtwood Belt
	[793]="139:27:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Gloves
	[4672]="141:28:4:1:1:::0:0:", -- Ancestral Belt
	[6513]="141:28:4:1:1:::0:0:", -- Disciple's Sash
	[6062]="142:28:4:1:1:::0:0:", -- Heavy Cord Bracers
	[3224]="142:28:4:1:1:::0:0:", -- Silver-lined Bracers
	[2326]="145:29:4:1:1:::0:0:", -- Ivy-weave Bracers
	[3602]="145:29:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Belt
	[3603]="145:29:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Bracers
	[3606]="147:29:4:1:1:::1:0:82,127,134,516,640", -- Woven Belt
	[7350]="148:29:4:1:1:::0:0:", -- Disciple's Bracers
	[3607]="148:29:4:1:1:::1:0:82,127,134,516,640", -- Woven Bracers
	[1183]="149:29:4:1:1:::0:0:", -- Elastic Wristguards
	[4307]="149:29:4:1:1:::0:0:", -- Heavy Linen Gloves
	[2369]="150:30:4:1:1:::1:0:82,127,134,516,640", -- Woven Gloves
	[14089]="151:30:4:1:1:::0:0:", -- Beaded Gloves
	[4963]="152:30:4:1:1:::0:0:", -- Thunderhorn Cloak
	[2114]="155:31:4:1:1:::0:0:", -- Snowy Robe
	[2568]="156:31:4:1:1:::0:0:", -- Brown Linen Vest
	[4261]="159:31:4:1:1:::0:0:", -- Solliden's Trousers
	[4668]="160:32:4:1:1:::0:0:", -- Battle Chain Cloak
	[7095]="161:32:4:1:1:::0:0:", -- Bog Boots
	[10046]="161:32:4:1:1:::0:0:", -- Simple Linen Boots
	[4671]="162:32:4:1:1:::0:0:", -- Ancestral Cloak
	[3834]="162:32:4:1:1:::0:0:", -- Sturdy Cloth Trousers
	[2612]="163:32:4:1:1:::1:0:547,778,801,864", -- Plain Robe
	[2959]="164:32:4:1:1:::0:0:", -- Journeyman's Boots
	[4674]="164:32:4:1:1:::0:0:", -- Tribal Cloak
	[3153]="169:33:4:1:1:::0:0:", -- Oil-stained Cloak
	[7276]="170:34:4:1:1:::0:0:", -- Handstitched Leather Cloak
	[6508]="172:34:4:1:1:::0:0:", -- Infantry Cloak
	[5590]="179:35:4:1:1:::0:0:", -- Cord Bracers
	[6202]="179:35:4:1:1:::0:0:", -- Fingerless Gloves
	[4958]="180:36:4:1:1:::0:0:", -- Sun-beaten Cloak
	[14095]="182:36:4:1:1:::0:0:", -- Native Bands
	[6515]="185:37:4:1:1:::0:0:", -- Disciple's Gloves
	[792]="207:41:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Sandals
	[6520]="209:41:4:1:1:::0:0:", -- Pioneer Cloak
	[15483]="209:41:4:1:1:::0:0:", -- War Torn Cape
	[15299]="211:42:4:1:1:::0:0:", -- Grizzly Cape
	[6514]="212:42:4:1:1:::0:0:", -- Disciple's Cloak
	[14098]="218:43:4:1:1:::0:0:", -- Native Cloak
	[3008]="218:43:4:1:1:::0:0:", -- Wendigo Fur Cloak
	[5767]="221:44:4:1:1:::0:0:", -- Violet Robes
	[3442]="223:44:4:1:1:::0:0:", -- Apprentice Sash
	[6148]="223:44:4:1:1:::0:0:", -- Web-covered Boots
	[2367]="223:44:4:1:1:::1:0:82,127,134,516,640", -- Woven Boots
	[9744]="224:44:4:1:1:::0:0:", -- Simple Bands
	[14086]="225:45:4:1:1:::0:0:", -- Beaded Sandals
	[4308]="225:45:4:1:1:::0:0:", -- Green Linen Bracers
	[11191]="227:45:4:1:1:::0:0:", -- Farmer's Boots
	[2165]="227:45:4:1:1:::0:0:", -- Old Blanchy's Blanket
	[3453]="232:46:4:1:1:::0:0:", -- Quilted Bracers
	[3328]="233:46:4:1:1:::0:0:", -- Spider Web Robe
	[3644]="237:47:4:1:1:::0:0:", -- Barbaric Cloth Bracers
	[14099]="237:47:4:1:1:::0:0:", -- Native Sash
	[1479]="238:47:4:1:1:::0:0:", -- Salma's Oven Mitts
	[3290]="241:48:4:1:1:::0:0:", -- Ancestral Gloves
	[4933]="241:48:4:1:1:::0:0:", -- Seasoned Fighter's Cloak
	[10550]="243:48:4:1:1:::0:0:", -- Wooly Mittens
	[9742]="246:49:4:1:1:::0:0:", -- Simple Cord
	[2905]="266:53:4:1:1:::0:0:", -- Goat Fur Cloak
	[9745]="270:54:4:1:1:::0:0:", -- Simple Cape
	[3216]="275:55:4:1:1:::0:0:", -- Warm Winter Robe
	[1171]="277:55:4:1:1:::0:0:", -- Well-stitched Robe
	[794]="279:55:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Pants
	[795]="280:56:4:1:1:::0:1:6,86,112,228,332,500,592,658", -- Knitted Tunic
	[9746]="282:56:4:1:1:::0:0:", -- Simple Gloves
	[3289]="288:57:4:1:1:::0:0:", -- Ancestral Boots
	[7351]="290:58:4:1:1:::0:0:", -- Disciple's Boots
	[9761]="294:58:4:1:1:::0:0:", -- Cadet Cloak
	[2364]="296:59:4:1:1:::1:0:82,127,134,516,640", -- Woven Vest
	[2366]="298:59:4:1:1:::1:0:82,127,134,516,640", -- Woven Pants
	[14102]="300:60:4:1:1:::0:0:", -- Native Handwraps
	[4343]="301:60:4:1:1:::0:0:", -- Brown Linen Pants
	[2238]="303:60:4:1:1:::0:0:", -- Urchin's Pants
	[4684]="307:61:4:1:1:::0:0:", -- Spellbinder Belt
	[9743]="335:67:4:1:1:::0:0:", -- Simple Shoes
	[4686]="336:67:4:1:1:::0:0:", -- Barbaric Cloth Cloak
	[4687]="338:67:4:1:1:::0:0:", -- Barbaric Cloth Belt
	[5591]="338:67:4:1:1:::0:0:", -- Rain-spotted Cape
	[2580]="338:67:4:1:1:::0:0:", -- Reinforced Linen Cape
	[4692]="344:68:4:1:1:::0:0:", -- Ceremonial Cloak
	[9754]="350:70:4:1:1:::0:0:", -- Gypsy Cloak
	[14115]="351:70:4:1:1:::0:0:", -- Aboriginal Bands
	[4677]="351:70:4:1:1:::0:0:", -- Veteran Cloak
	[4772]="353:70:4:1:1:::0:0:", -- Warm Cloak
	[3643]="355:71:4:1:1:::0:0:", -- Spellbinder Bracers
	[710]="361:72:4:1:1:::0:0:", -- Bracers of the People's Militia
	[4944]="361:72:4:1:1:::0:0:", -- Handsewn Cloak
	[2972]="364:72:4:1:1:::0:0:", -- Spellbinder Gloves
	[15401]="364:72:4:1:1:::0:0:", -- Welldrip Gloves
	[14110]="420:84:4:1:1:::0:0:", -- Native Sandals
	[5618]="430:86:4:1:1:::0:0:", -- Scout's Cloak
	[15015]="433:86:4:1:1:::0:0:", -- Lupine Cloak
	[2569]="437:87:4:1:1:::0:0:", -- Linen Boots
	[860]="447:89:4:1:1:::0:0:", -- Cavalier's Boots
	[4680]="456:91:4:1:1:::0:0:", -- Brackwater Cloak
	[4683]="461:92:4:1:1:::0:0:", -- Spellbinder Cloak
	[9600]="465:93:4:1:1:::0:0:", -- Lace Pants
	[3331]="509:101:4:1:1:::0:0:", -- Melrache's Cape
	[6549]="509:101:4:1:1:::0:0:", -- Soldier's Cloak
	[15490]="526:105:4:1:1:::0:0:", -- Bloodspattered Cloak
	[3454]="527:105:4:1:1:::0:0:", -- Reconnaissance Boots
	[14116]="530:106:4:1:1:::0:0:", -- Aboriginal Cape
	[4689]="532:106:4:1:1:::0:0:", -- Hunting Cloak
	[15398]="542:108:4:1:1:::0:0:", -- Sandcomber Boots
	[2971]="544:108:4:1:1:::0:0:", -- Spellbinder Boots
	[2310]="561:112:4:1:1:::0:0:", -- Embossed Leather Cloak
	[839]="566:113:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Gloves
	[3589]="576:115:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Belt
	[3590]="578:115:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Bracers
	[2613]="607:121:4:1:1:::1:0:547,778,801,864", -- Double-stitched Robes
	[6555]="652:130:4:1:1:::0:0:", -- Bard's Cloak
	[2584]="711:142:4:1:1:::0:0:", -- Woolen Cape
	[2240]="758:151:4:1:1:::0:0:", -- Rugged Cape
	[10047]="822:164:4:1:1:::0:0:", -- Simple Kilt
	[840]="853:170:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Shoes
	[3597]="1081:216:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Belt
	[2582]="1082:216:4:1:1:::0:0:", -- Green Woolen Vest
	[3598]="1085:217:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Bracers
	[5109]="1116:223:4:1:1:::0:0:", -- Stonesplinter Rags
	[837]="1124:224:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Armor
	[838]="1128:225:4:1:1:::1:0:6,12,26,112,302,472,516,640,670,713", -- Heavy Weave Pants
	[203]="1147:229:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Gloves
	[2614]="1161:232:4:1:1:::1:0:547,778,801,864", -- Robe of Apprenticeship
	[5110]="1289:257:4:1:1:::0:0:", -- Dalaran Wizard's Robe
	[14169]="1433:286:4:1:1:::0:0:", -- Aboriginal Shoulder Pads
	[4698]="1508:301:4:1:1:::0:0:", -- Seer's Mantle
	[14170]="1655:331:4:1:1:::0:0:", -- Buccaneer's Mantle
	[4314]="1659:331:4:1:1:::0:0:", -- Double-stitched Woolen Shoulders
	[202]="1714:342:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Shoes
	[14368]="1730:346:4:1:1:::0:0:", -- Mystic's Shoulder Pads
	[14126]="1983:396:4:1:1:::0:0:", -- Ritual Amice
	[2316]="2043:408:4:1:1:::0:0:", -- Dark Leather Cloak
	[6566]="2055:411:4:1:1:::0:0:", -- Shimmering Amice
	[2158]="2066:413:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Gloves
	[3591]="2097:419:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Belt
	[3592]="2104:420:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Bracers
	[4315]="2126:425:4:1:1:::0:0:", -- Reinforced Woolen Shoulders
	[14157]="2169:433:4:1:1:::0:0:", -- Pagan Mantle
	[200]="2270:454:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Vest
	[201]="2278:455:4:1:1:::1:0:6,112,354,355,640,664,835", -- Thick Cloth Pants
	[6787]="2331:466:4:1:1:::0:0:", -- White Woolen Dress
	[2616]="2659:531:4:1:1:::1:0:547,778,801,864", -- Shimmering Silk Robes
	[2156]="3077:615:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Boots
	[7048]="3725:745:4:1:1:::0:0:", -- Azure Silk Hood
	[3732]="4006:801:4:1:1:::0:0:", -- Hooded Cowl
	[2159]="4148:829:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Pants
	[2160]="4163:832:4:1:1:::1:0:6,174,306,354,440,446,664,801", -- Padded Armor
	[7050]="4995:999:4:1:1:::0:0:", -- Silk Headband
	[2615]="5091:1018:4:1:1:::1:0:547,778,801,864", -- Chromatic Robe
	[3719]="5139:1027:4:1:1:::0:0:", -- Hillman's Cloak
	[2434]="5165:1033:4:1:1:::1:0:14,173,174,306,347,355,440,446,664,745,801,857", -- Russet Gloves
	[3593]="5477:1095:4:1:1:::1:0:14,173,174,306,347,355,440,446,664,745,801,857", -- Russet Belt
	[3594]="5497:1099:4:1:1:::1:0:14,173,174,306,347,355,440,446,664,745,801,857", -- Russet Bracers
	[2432]="7690:1538:4:1:1:::1:0:14,173,174,306,347,355,440,446,571,664,745,801,857", -- Russet Boots
	[3889]="7922:1584:4:1:1:::1:0:14,173,174,193,306,347,355,440,446,664,745,801,857", -- Russet Hat
	[10035]="8676:1735:4:1:1:::0:0:", -- Tuxedo Pants
	[10036]="8708:1741:4:1:1:::0:0:", -- Tuxedo Jacket
	[10040]="8836:1767:4:1:1:::0:0:", -- White Wedding Dress
	[2429]="10138:2027:4:1:1:::1:0:14,173,174,306,347,355,440,446,664,745,801,857", -- Russet Vest
	[2431]="10215:2043:4:1:1:::1:0:14,173,174,306,347,355,440,446,664,745,801,857", -- Russet Pants
	[7058]="10262:2052:4:1:1:::0:0:", -- Crimson Silk Vest
	[2617]="10991:2198:4:1:1:::1:0:547,778,801,864", -- Burning Robes
	[7062]="12150:2430:4:1:1:::0:0:", -- Crimson Silk Pantaloons
	[2440]="14099:2819:4:1:1:::1:0:71,173,174,306,355,440,446,470,531,664,745,781,801", -- Embroidered Gloves
	[3587]="14314:2862:4:1:1:::1:0:14,71,173,174,306,355,440,446,470,531,664,745,781,801", -- Embroidered Belt
	[3588]="14365:2873:4:1:1:::1:0:14,71,173,174,306,355,440,446,470,531,664,745,781,801", -- Embroidered Bracers
	[2438]="20996:4199:4:1:1:::1:0:14,71,173,174,306,355,440,446,470,531,571,664,745,781,801", -- Embroidered Boots
	[3892]="21940:4388:4:1:1:::1:0:71,173,174,193,306,355,440,446,470,531,664,745,781,801", -- Embroidered Hat
	[2618]="26639:5327:4:1:1:::1:0:547,778,801,864", -- Silver Dress Robes
	[2435]="27683:5536:4:1:1:::1:0:14,71,173,174,306,355,440,446,470,531,664,745,781,801", -- Embroidered Armor
	[2437]="27890:5578:4:1:1:::1:0:14,71,173,174,306,355,440,446,470,531,664,745,781,801", -- Embroidered Pants
	[5387]="0:0:4:1:1:::0:0:", -- Enchanted Moonstalker Cloak
	[3985]="0:0:4:1:1:::0:0:", -- Monogrammed Sash
	[16607]="80:16:4:1:1:::0:0:", -- Acolyte's Sacrificial Robes
	[16604]="86:17:4:1:1:::0:0:", -- Moon Robes of Elune
	[16605]="87:17:4:1:1:::0:0:", -- Friar's Robes of the Light
	[16606]="87:17:4:1:1:::0:0:", -- Juju Hex Robes
	[2958]="473:94:4:1:1:::0:0:", -- Journeyman's Pants
	[9598]="473:94:4:1:1:::0:0:", -- Sleeping Robes
	[6238]="491:98:4:1:1:::0:0:", -- Brown Linen Robe
	[2572]="496:99:4:1:1:::0:0:", -- Red Linen Robe
	[6241]="496:99:4:1:1:::0:0:", -- White Linen Robe
	[2957]="596:119:4:1:1:::0:0:", -- Journeyman's Vest
	[14090]="597:119:4:1:1:::0:0:", -- Beaded Britches
	[10554]="597:119:4:1:1:::0:0:", -- Foreman Pants
	[14091]="599:119:4:1:1:::0:0:", -- Beaded Robe
	[14094]="606:121:4:1:1:::0:0:", -- Beaded Wraps
	[6511]="608:121:4:1:1:::0:0:", -- Journeyman's Robe
	[10553]="657:131:4:1:1:::0:0:", -- Foreman Vest
	[3217]="674:134:4:1:1:::0:0:", -- Foreman Belt
	[10820]="691:138:4:1:1:::0:0:", -- Jackseed Belt
	[4767]="695:139:4:1:1:::0:0:", -- Coppercloth Gloves
	[4768]="698:139:4:1:1:::0:0:", -- Adept's Gloves
	[10637]="698:139:4:1:1:::0:0:", -- Brewer's Gloves
	[14113]="699:139:4:1:1:::0:0:", -- Aboriginal Sash
	[2283]="700:140:4:1:1:::0:0:", -- Rat Cloth Belt
	[3308]="721:144:4:1:1:::0:0:", -- Barbaric Cloth Gloves
	[3344]="729:145:4:1:1:::0:0:", -- Captain Sander's Sash
	[6543]="735:147:4:1:1:::0:0:", -- Willow Bracers
	[6267]="747:149:4:1:1:::0:0:", -- Disciple's Pants
	[6239]="802:160:4:1:1:::0:0:", -- Red Linen Vest
	[6240]="805:161:4:1:1:::0:0:", -- Blue Linen Vest
	[10549]="811:162:4:1:1:::0:0:", -- Rancher's Trousers
	[6539]="811:162:4:1:1:::0:0:", -- Willow Belt
	[14117]="816:163:4:1:1:::0:0:", -- Aboriginal Gloves
	[6541]="817:163:4:1:1:::0:0:", -- Willow Gloves
	[5337]="836:167:4:1:1:::0:0:", -- Wayfaring Gloves
	[4310]="902:180:4:1:1:::0:0:", -- Heavy Woolen Gloves
	[6527]="937:187:4:1:1:::0:0:", -- Ancestral Robe
	[14025]="941:188:4:1:1:::0:0:", -- Mystic's Belt
	[3645]="947:189:4:1:1:::0:0:", -- Seer's Cuffs
	[14366]="948:189:4:1:1:::0:0:", -- Mystic's Bracelets
	[6512]="955:191:4:1:1:::0:0:", -- Disciple's Robe
	[3291]="1013:202:4:1:1:::0:0:", -- Ancestral Woollies
	[3292]="1016:203:4:1:1:::0:0:", -- Ancestral Tunic
	[6266]="1028:205:4:1:1:::0:0:", -- Disciple's Vest
	[3449]="1035:207:4:1:1:::0:0:", -- Mystic Shawl
	[5610]="1040:208:4:1:1:::0:0:", -- Gustweald Cloak
	[10821]="1040:208:4:1:1:::0:0:", -- Sower's Cloak
	[14148]="1043:208:4:1:1:::0:0:", -- Crystalline Cuffs
	[5967]="1045:209:4:1:1:::0:0:", -- Girdle of Nobility
	[6537]="1051:210:4:1:1:::0:0:", -- Willow Boots
	[10638]="1052:210:4:1:1:::0:0:", -- Long Draping Cape
	[2284]="1055:211:4:1:1:::0:0:", -- Rat Cloth Cloak
	[7738]="1058:211:4:1:1:::0:0:", -- Evergreen Gloves
	[1270]="1067:213:4:1:1:::0:0:", -- Finely Woven Cloak
	[5315]="1069:213:4:1:1:::0:0:", -- Timberland Armguards
	[14365]="1072:214:4:1:1:::0:0:", -- Mystic's Cape
	[10919]="1074:214:4:1:1:::0:0:", -- Apothecary Gloves
	[15452]="1075:215:4:1:1:::0:0:", -- Featherbead Bracers
	[2984]="1077:215:4:1:1:::0:0:", -- Seer's Gloves
	[3307]="1078:215:4:1:1:::0:0:", -- Barbaric Cloth Boots
	[14122]="1098:219:4:1:1:::0:0:", -- Ritual Bands
	[6542]="1099:219:4:1:1:::0:0:", -- Willow Cape
	[15309]="1100:220:4:1:1:::0:0:", -- Feral Cloak
	[4699]="1105:221:4:1:1:::0:0:", -- Seer's Belt
	[2578]="1120:224:4:1:1:::0:0:", -- Barbaric Linen Vest
	[4309]="1133:226:4:1:1:::0:0:", -- Handstitched Linen Britches
	[5420]="1138:227:4:1:1:::0:0:", -- Banshee Armor
	[9747]="1139:227:4:1:1:::0:0:", -- Simple Britches
	[9786]="1173:234:4:1:1:::0:0:", -- Raider's Cloak
	[14097]="1183:236:4:1:1:::0:0:", -- Native Pants
	[4312]="1186:237:4:1:1:::0:0:", -- Soft-soled Linen Boots
	[14166]="1191:238:4:1:1:::0:0:", -- Buccaneer's Bracers
	[14114]="1211:242:4:1:1:::0:0:", -- Aboriginal Footwraps
	[14131]="1214:242:4:1:1:::0:0:", -- Ritual Belt
	[6242]="1217:243:4:1:1:::0:0:", -- Blue Linen Robe
	[14160]="1255:251:4:1:1:::0:0:", -- Pagan Bands
	[1355]="1259:251:4:1:1:::0:0:", -- Buckskin Cape
	[14367]="1259:251:4:1:1:::0:0:", -- Mystic's Gloves
	[4701]="1263:252:4:1:1:::0:0:", -- Inscribed Cloak
	[14724]="1265:253:4:1:1:::0:0:", -- War Paint Cloak
	[4771]="1324:264:4:1:1:::0:0:", -- Harvest Cloak
	[3511]="1338:267:4:1:1:::0:0:", -- Cloak of the People's Militia
	[2308]="1338:267:4:1:1:::0:0:", -- Fine Leather Cloak
	[1561]="1343:268:4:1:1:::0:0:", -- Harvester's Robe
	[15501]="1346:269:4:1:1:::0:0:", -- Outrunner's Cloak
	[16981]="1356:271:4:1:1:::0:0:", -- Owlbeard Bracers
	[9748]="1371:274:4:1:1:::0:0:", -- Simple Robe
	[6477]="1372:274:4:1:1:::0:0:", -- Grassland Sash
	[7509]="1376:275:4:1:1:::0:0:", -- Manaweave Robe
	[9749]="1376:275:4:1:1:::0:0:", -- Simple Blouse
	[14563]="1377:275:4:1:1:::0:0:", -- Prospector's Cloak
	[14168]="1379:275:4:1:1:::0:0:", -- Buccaneer's Gloves
	[7510]="1381:276:4:1:1:::0:0:", -- Spellfire Robes
	[4786]="1393:278:4:1:1:::1:1:12,26,302,472", -- Wise Man's Belt
	[1304]="1398:279:4:1:1:::0:0:", -- Riding Gloves
	[2983]="1400:280:4:1:1:::0:0:", -- Seer's Boots
	[3565]="1403:280:4:1:1:::0:0:", -- Beerstained Gloves
	[14173]="1405:281:4:1:1:::0:0:", -- Buccaneer's Cord
	[12295]="1413:282:4:1:1:::0:0:", -- Leggings of the People's Militia
	[11936]="1421:284:4:1:1:::0:0:", -- Relic Hunter Belt
	[14123]="1439:287:4:1:1:::0:0:", -- Ritual Cape
	[14124]="1463:292:4:1:1:::0:0:", -- Ritual Gloves
	[6378]="1463:292:4:1:1:::0:0:", -- Seer's Cape
	[3161]="1474:294:4:1:1:::0:0:", -- Robe of the Keeper
	[6563]="1478:295:4:1:1:::0:0:", -- Shimmering Bracers
	[14149]="1538:307:4:1:1:::0:0:", -- Subterranean Cape
	[14164]="1563:312:4:1:1:::0:0:", -- Pagan Belt
	[9768]="1586:317:4:1:1:::0:0:", -- Greenweave Bracers
	[5111]="1601:320:4:1:1:::0:0:", -- Rathorian's Cape
	[4660]="1622:324:4:1:1:::0:0:", -- Walking Boots
	[14364]="1624:324:4:1:1:::0:0:", -- Mystic's Slippers
	[14096]="1627:325:4:1:1:::0:0:", -- Native Vest
	[4695]="1635:327:4:1:1:::0:0:", -- Burnished Cloak
	[4436]="1657:331:4:1:1:::0:0:", -- Jewel-encrusted Sash
	[3309]="1666:333:4:1:1:::0:0:", -- Barbaric Loincloth
	[2970]="1666:333:4:1:1:::0:0:", -- Spellbinder Pants
	[9779]="1671:334:4:1:1:::0:0:", -- Bandit Cloak
	[14161]="1685:337:4:1:1:::0:0:", -- Pagan Cape
	[14109]="1705:341:4:1:1:::0:0:", -- Native Robe
	[6528]="1792:358:4:1:1:::0:0:", -- Spellbinder Robe
	[14167]="1793:358:4:1:1:::0:0:", -- Buccaneer's Cape
	[2583]="1796:359:4:1:1:::0:0:", -- Woolen Boots
	[9766]="1809:361:4:1:1:::0:0:", -- Greenweave Sash
	[1832]="1811:362:4:1:1:::0:0:", -- Lucky Trousers
	[6570]="1815:363:4:1:1:::0:0:", -- Shimmering Sash
	[5195]="1823:364:4:1:1:::0:0:", -- Gold-flecked Gloves
	[15508]="1827:365:4:1:1:::0:0:", -- Grunt's Cape
	[14174]="1840:368:4:1:1:::0:0:", -- Buccaneer's Boots
	[892]="1849:369:4:1:1:::0:0:", -- Gnoll Casting Gloves
	[6628]="1851:370:4:1:1:::0:0:", -- Raven's Claws
	[5542]="1852:370:4:1:1:::0:0:", -- Pearl-clasped Cloak
	[15114]="1862:372:4:1:1:::0:0:", -- Rigid Cape
	[14119]="1891:378:4:1:1:::0:0:", -- Aboriginal Loincloth
	[2969]="1909:381:4:1:1:::0:0:", -- Spellbinder Vest
	[1299]="1953:390:4:1:1:::0:0:", -- Lesser Belt of the Spire
	[6565]="1969:393:4:1:1:::0:0:", -- Shimmering Gloves
	[4368]="2043:408:4:1:1::202:0:0:", -- Flying Tiger Goggles
	[1930]="2044:408:4:1:1:::0:0:", -- Stonemason Cloak
	[6466]="2067:413:4:1:1:::0:0:", -- Deviate Scale Cloak
	[4782]="2076:415:4:1:1:::1:1:12,26,302,472", -- Solstice Robe
	[14129]="2079:415:4:1:1:::0:0:", -- Ritual Sandals
	[4313]="2083:416:4:1:1:::0:0:", -- Red Woolen Boots
	[9770]="2084:416:4:1:1:::0:0:", -- Greenweave Cloak
	[6531]="2085:417:4:1:1:::0:0:", -- Barbaric Cloth Robe
	[5970]="2092:418:4:1:1:::0:0:", -- Serpent Gloves
	[14150]="2103:420:4:1:1:::0:0:", -- Robe of Evocation
	[3019]="2115:423:4:1:1:::0:0:", -- Noble's Robe
	[3229]="2122:424:4:1:1:::0:0:", -- Tarantula Silk Sash
	[15449]="2127:425:4:1:1:::0:0:", -- Ghastly Trousers
	[6575]="2155:431:4:1:1:::0:0:", -- Defender Cloak
	[6540]="2156:431:4:1:1:::0:0:", -- Willow Pants
	[3647]="2169:433:4:1:1:::0:0:", -- Bright Bracers
	[1929]="2171:434:4:1:1:::0:0:", -- Silk-threaded Trousers
	[3310]="2211:442:4:1:1:::0:0:", -- Barbaric Cloth Vest
	[3457]="2220:444:4:1:1:::0:0:", -- Stamped Trousers
	[14745]="2221:444:4:1:1:::0:0:", -- Hulking Cloak
	[14162]="2228:445:4:1:1:::0:0:", -- Pagan Mitts
	[4708]="2309:461:4:1:1:::0:0:", -- Bright Belt
	[5343]="2310:462:4:1:1:::0:0:", -- Barkeeper's Cloak
	[4785]="2345:469:4:1:1:::0:0:", -- Brimstone Belt
	[2168]="2349:469:4:1:1:::0:0:", -- Foreman's Boots
	[14370]="2364:472:4:1:1:::0:0:", -- Mystic's Woolies
	[3582]="2372:474:4:1:1:::0:0:", -- Acidproof Cloak
	[4311]="2378:475:4:1:1:::0:0:", -- Heavy Woolen Cloak
	[3074]="2380:476:4:1:1:::0:0:", -- Smoldering Gloves
	[7739]="2401:480:4:1:1:::0:0:", -- Timberland Cape
	[6536]="2443:488:4:1:1:::0:0:", -- Willow Vest
	[6538]="2461:492:4:1:1:::0:0:", -- Willow Robe
	[14571]="2481:496:4:1:1:::0:0:", -- Bristlebark Cape
	[3066]="2487:497:4:1:1:::0:0:", -- Bright Gloves
	[6562]="2542:508:4:1:1:::0:0:", -- Shimmering Boots
	[6564]="2560:512:4:1:1:::0:0:", -- Shimmering Cloak
	[1560]="2568:513:4:1:1:::0:0:", -- Bluegill Sandals
	[7283]="2595:519:4:1:1:::0:0:", -- Black Whelp Cloak
	[6908]="2611:522:4:1:1:::0:0:", -- Ghamoo-ra's Bind
	[14373]="2624:524:4:1:1:::0:0:", -- Sanguine Belt
	[4331]="2630:526:4:1:1:::0:0:", -- Phoenix Gloves
	[5314]="2643:528:4:1:1:::0:0:", -- Boar Hunter's Cape
	[14375]="2644:528:4:1:1:::0:0:", -- Sanguine Cuffs
	[9771]="2662:532:4:1:1:::0:0:", -- Greenweave Gloves
	[15333]="2685:537:4:1:1:::0:0:", -- Wrangler's Cloak
	[6659]="2705:541:4:1:1:::0:0:", -- Scarab Trousers
	[4781]="2735:547:4:1:1:::1:1:12,26,302,472", -- Whispering Vest
	[5444]="2740:548:4:1:1:::0:0:", -- Miner's Cape
	[9793]="2753:550:4:1:1:::0:0:", -- Ivycloth Bracelets
	[14376]="2759:551:4:1:1:::0:0:", -- Sanguine Cape
	[5310]="2778:555:4:1:1:::0:0:", -- Sea Dog Britches
	[6179]="2782:556:4:1:1:::0:0:", -- Privateer's Cape
	[3563]="2787:557:4:1:1:::0:0:", -- Seafarer's Pantaloons
	[6585]="2792:558:4:1:1:::0:0:", -- Scouting Cloak
	[4710]="2808:561:4:1:1:::0:0:", -- Forest Cloak
	[2982]="2829:565:4:1:1:::0:0:", -- Seer's Pants
	[9812]="2851:570:4:1:1:::0:0:", -- Fortified Cloak
	[14159]="2852:570:4:1:1:::0:0:", -- Pagan Shoes
	[4434]="2861:572:4:1:1:::0:0:", -- Scarecrow Trousers
	[14120]="2887:577:4:1:1:::0:0:", -- Aboriginal Robe
	[14121]="2897:579:4:1:1:::0:0:", -- Aboriginal Vest
	[6263]="2947:589:4:1:1:::0:0:", -- Blue Overalls
	[14377]="3011:602:4:1:1:::0:0:", -- Sanguine Handwraps
	[15519]="3035:607:4:1:1:::0:0:", -- Spiked Chain Cloak
	[4799]="3042:608:4:1:1:::1:1:123,231,268,588,687,835,842", -- Antiquated Cloak
	[4318]="3052:610:4:1:1:::0:0:", -- Gloves of Meditation
	[2241]="3078:615:4:1:1:::0:0:", -- Desperado Cape
	[6191]="3079:615:4:1:1:::0:0:", -- Kimbra Boots
	[9767]="3080:616:4:1:1:::0:0:", -- Greenweave Sandals
	[6381]="3127:625:4:1:1:::0:0:", -- Bright Cloak
	[9795]="3134:626:4:1:1:::0:0:", -- Ivycloth Gloves
	[1190]="3150:630:4:1:1:::0:0:", -- Overseer's Cloak
	[6629]="3150:630:4:1:1:::0:0:", -- Sporid Cape
	[14177]="3159:631:4:1:1:::0:0:", -- Watcher's Cuffs
	[9799]="3179:635:4:1:1:::0:0:", -- Ivycloth Sash
	[3076]="3184:636:4:1:1:::0:0:", -- Smoldering Boots
	[2585]="3193:638:4:1:1:::0:0:", -- Gray Woolen Robe
	[6632]="3211:642:4:1:1:::0:0:", -- Feyscale Cloak
	[14185]="3237:647:4:1:1:::0:0:", -- Watcher's Cinch
	[2981]="3242:648:4:1:1:::0:0:", -- Seer's Robe
	[4792]="3279:655:4:1:1:::1:1:302,417", -- Spirit Cloak
	[3065]="3290:658:4:1:1:::0:0:", -- Bright Boots
	[6561]="3378:675:4:1:1:::0:0:", -- Seer's Padded Armor
	[14125]="3381:676:4:1:1:::0:0:", -- Ritual Leggings
	[4036]="3408:681:4:1:1:::0:0:", -- Silver-thread Cuffs
	[4714]="3408:681:4:1:1:::0:0:", -- Silver-thread Sash
	[4828]="3420:684:4:1:1:::1:1:116,417,505,648,845,847,888", -- Nightwind Belt
	[4706]="3438:687:4:1:1:::0:0:", -- Lambent Scale Cloak
	[6095]="3440:688:4:1:1:::0:0:", -- Wandering Boots
	[14374]="3497:699:4:1:1:::0:0:", -- Sanguine Sandals
	[15526]="3523:704:4:1:1:::0:0:", -- Sentry's Cape
	[9805]="3549:709:4:1:1:::0:0:", -- Superior Cloak
	[14187]="3587:717:4:1:1:::0:0:", -- Raincaller Cuffs
	[4373]="3613:722:4:1:1:::0:0:", -- Shadow Goggles
	[6482]="3640:728:4:1:1:::0:0:", -- Firewalker Boots
	[14171]="3693:738:4:1:1:::0:0:", -- Buccaneer's Pants
	[4316]="3715:743:4:1:1:::0:0:", -- Heavy Woolen Pants
	[4793]="3720:744:4:1:1:::1:1:302,417", -- Sylvan Cloak
	[6613]="3722:744:4:1:1:::0:0:", -- Sage's Bracers
	[3752]="3729:745:4:1:1:::0:0:", -- Grunt Vest
	[14179]="3738:747:4:1:1:::0:0:", -- Watcher's Cape
	[4827]="3748:749:4:1:1:::1:1:116,417,505,648,847,888", -- Wizard's Belt
	[14194]="3781:756:4:1:1:::0:0:", -- Raincaller Cord
	[6393]="3803:760:4:1:1:::0:0:", -- Silver-thread Gloves
	[6503]="3814:762:4:1:1:::0:0:", -- Harlequin Robes
	[1351]="3843:768:4:1:1:::0:0:", -- Fingerbone Bracers
	[6465]="3843:768:4:1:1:::0:0:", -- Robe of the Moccasin
	[6998]="3872:774:4:1:1:::0:0:", -- Nimbus Boots
	[14181]="3877:775:4:1:1:::0:0:", -- Watcher's Handwraps
	[3018]="3906:781:4:1:1:::0:0:", -- Hide of Lupos
	[5969]="3908:781:4:1:1:::0:0:", -- Regent's Cloak
	[14369]="4048:809:4:1:1:::0:0:", -- Mystic's Wrap
	[6611]="4063:812:4:1:1:::0:0:", -- Sage's Sash
	[2232]="4064:812:4:1:1:::0:0:", -- Dark Runner Boots
	[4319]="4076:815:4:1:1:::0:0:", -- Azure Silk Gloves
	[14371]="4079:815:4:1:1:::0:0:", -- Mystic's Robe
	[9792]="4115:823:4:1:1:::0:0:", -- Ivycloth Boots
	[6615]="4123:824:4:1:1:::0:0:", -- Sage's Gloves
	[7047]="4124:824:4:1:1:::0:0:", -- Hands of Darkness
	[9794]="4145:829:4:1:1:::0:0:", -- Ivycloth Cloak
	[4829]="4153:830:4:1:1:::1:1:116,417,505,648,847,888", -- Dreamer's Belt
	[4790]="4158:831:4:1:1:::1:1:302,417", -- Inferno Cloak
	[14172]="4188:837:4:1:1:::0:0:", -- Buccaneer's Robes
	[14402]="4189:837:4:1:1:::0:0:", -- Resilient Bands
	[15461]="4207:841:4:1:1:::0:0:", -- Lightheel Boots
	[14175]="4235:847:4:1:1:::0:0:", -- Buccaneer's Vest
	[15124]="4237:847:4:1:1:::0:0:", -- Robust Cloak
	[16985]="4238:847:4:1:1:::0:0:", -- Windseeker Boots
	[4797]="4262:852:4:1:1:::1:1:123,231,268,588,687,835,842", -- Fiery Cloak
	[10404]="4323:864:4:1:1:::0:0:", -- Durable Belt
	[9821]="4357:871:4:1:1:::0:0:", -- Durable Bracers
	[6340]="4375:875:4:1:1:::0:0:", -- Fenrus' Hide
	[7712]="4407:881:4:1:1:::0:0:", -- Mantle of Doan
	[14191]="4407:881:4:1:1:::0:0:", -- Raincaller Mitts
	[6264]="4420:884:4:1:1:::0:0:", -- Greater Adept's Robe
	[6226]="4452:890:4:1:1:::0:0:", -- Bloody Apron
	[6664]="4460:892:4:1:1:::0:0:", -- Voodoo Mantle
	[3561]="4475:895:4:1:1:::0:0:", -- Resilient Poncho
	[4447]="4509:901:4:1:1:::0:0:", -- Cloak of Night
	[7049]="4570:914:4:1:1:::0:0:", -- Truefaith Gloves
	[14176]="4600:920:4:1:1:::0:0:", -- Watcher's Boots
	[6568]="4603:920:4:1:1:::0:0:", -- Shimmering Trousers
	[6593]="4614:922:4:1:1:::0:0:", -- Battleforge Cloak
	[14197]="4625:925:4:1:1:::0:0:", -- Thistlefur Bands
	[4713]="4630:926:4:1:1:::0:0:", -- Silver-thread Cloak
	[4661]="4645:929:4:1:1:::0:0:", -- Bright Mantle
	[17695]="4654:930:4:1:1:::0:0:", -- Chestnut Mantle
	[10657]="4669:933:4:1:1:::0:0:", -- Talbar Mantle
	[14406]="4675:935:4:1:1:::0:0:", -- Resilient Cord
	[10048]="4678:935:4:1:1:::0:0:", -- Colorful Kilt
	[16740]="4712:942:4:1:1:::0:0:", -- Shredder Operating Gloves
	[14133]="4752:950:4:1:1:::0:0:", -- Ritual Tunic
	[4463]="4769:953:4:1:1:::0:0:", -- Beaded Raptor Collar
	[10287]="4822:964:4:1:1:::0:0:", -- Greenweave Mantle
	[10654]="4827:965:4:1:1:::0:0:", -- Jutebraid Gloves
	[9823]="4828:965:4:1:1:::0:0:", -- Durable Gloves
	[16661]="4828:965:4:1:1:::0:0:", -- Soft Willow Cape
	[14752]="4892:978:4:1:1:::0:0:", -- Slayer's Cape
	[14188]="4911:982:4:1:1:::0:0:", -- Raincaller Cloak
	[7004]="4924:984:4:1:1:::0:0:", -- Prelacy Cape
	[6667]="4962:992:4:1:1:::0:0:", -- Engineer's Cloak
	[14378]="4987:997:4:1:1:::0:0:", -- Sanguine Mantle
	[16990]="4990:998:4:1:1:::0:0:", -- Spritekin Cloak
	[14127]="4999:999:4:1:1:::0:0:", -- Ritual Shroud
	[5274]="5018:1003:4:1:1:::0:0:", -- Rose Mantle
	[3461]="5029:1005:4:1:1:::0:0:", -- High Robe of the Adjudicator
	[9609]="5046:1009:4:1:1:::0:0:", -- Shilly Mitts
	[7370]="5064:1012:4:1:1:::0:0:", -- Elder's Sash
	[15340]="5081:1016:4:1:1:::0:0:", -- Pathfinder Cloak
	[14403]="5088:1017:4:1:1:::0:0:", -- Resilient Handgrips
	[4715]="5130:1026:4:1:1:::0:0:", -- Emblazoned Cloak
	[5751]="5140:1028:4:1:1:::0:0:", -- Webwing Cloak
	[7355]="5155:1031:4:1:1:::0:0:", -- Elder's Bracers
	[3555]="5161:1032:4:1:1:::0:0:", -- Robe of Solomon
	[2034]="5179:1035:4:1:1:::0:0:", -- Scholarly Robes
	[6567]="5182:1036:4:1:1:::0:0:", -- Shimmering Armor
	[9796]="5190:1038:4:1:1:::0:0:", -- Ivycloth Mantle
	[6394]="5205:1041:4:1:1:::0:0:", -- Silver-thread Boots
	[14165]="5208:1041:4:1:1:::0:0:", -- Pagan Britches
	[14205]="5212:1042:4:1:1:::0:0:", -- Thistlefur Belt
	[3558]="5220:1044:4:1:1:::0:0:", -- Fen Keeper Robe
	[6569]="5222:1044:4:1:1:::0:0:", -- Shimmering Robe
	[14206]="5232:1046:4:1:1:::0:0:", -- Vital Bracelets
	[4317]="5382:1076:4:1:1:::0:0:", -- Phoenix Pants
	[14582]="5444:1088:4:1:1:::0:0:", -- Dokebi Cape
	[7366]="5490:1098:4:1:1:::0:0:", -- Elder's Gloves
	[4711]="5561:1112:4:1:1:::0:0:", -- Glimmering Cloak
	[6612]="5562:1112:4:1:1:::0:0:", -- Sage's Boots
	[3324]="5599:1119:4:1:1:::0:0:", -- Ghostly Mantle
	[4321]="5600:1120:4:1:1:::0:0:", -- Spider Silk Slippers
	[6614]="5603:1120:4:1:1:::0:0:", -- Sage's Cloak
	[5812]="5645:1129:4:1:1:::0:0:", -- Robes of Antiquity
	[15457]="5671:1134:4:1:1:::0:0:", -- Desert Shoulders
	[5971]="5681:1136:4:1:1:::0:0:", -- Feathered Cape
	[2913]="5766:1153:4:1:1:::0:0:", -- Silk Mantle of Gamn
	[9448]="5774:1154:4:1:1:::0:0:", -- Spidertank Oilrag
	[15537]="5816:1163:4:1:1:::0:0:", -- Wicked Chain Cloak
	[4798]="5832:1166:4:1:1:::1:1:123,231,268,588,687,835,842", -- Heavy Runed Cloak
	[14182]="5836:1167:4:1:1:::0:0:", -- Watcher's Mantle
	[14163]="5841:1168:4:1:1:::0:0:", -- Pagan Wraps
	[7711]="5855:1171:4:1:1:::0:0:", -- Robe of Doan
	[9838]="5872:1174:4:1:1:::0:0:", -- Banded Cloak
	[14186]="5897:1179:4:1:1:::0:0:", -- Raincaller Mantle
	[6744]="5950:1190:4:1:1:::0:0:", -- Gloves of Kapelan
	[9822]="5963:1192:4:1:1:::0:0:", -- Durable Cape
	[14209]="5980:1196:4:1:1:::0:0:", -- Vital Sash
	[6407]="5994:1198:4:1:1:::0:0:", -- Nightsky Wristbands
	[6604]="6000:1200:4:1:1:::0:0:", -- Dervish Cape
	[7511]="6016:1203:4:1:1:::0:0:", -- Astral Knot Robe
	[15468]="6035:1207:4:1:1:::0:0:", -- Windsong Drape
	[3072]="6036:1207:4:1:1:::0:0:", -- Smoldering Robe
	[7512]="6039:1207:4:1:1:::0:0:", -- Nether-lace Robe
	[3073]="6059:1211:4:1:1:::0:0:", -- Smoldering Pants
	[14400]="6078:1215:4:1:1:::0:0:", -- Resilient Cape
	[3759]="6080:1216:4:1:1:::0:0:", -- Insulated Sage Gloves
	[9831]="6166:1233:4:1:1:::0:0:", -- Scaled Cloak
	[4720]="6170:1234:4:1:1:::0:0:", -- Nightsky Sash
	[15547]="6172:1234:4:1:1:::0:0:", -- Thick Scale Cloak
	[7106]="6173:1234:4:1:1:::0:0:", -- Zodiac Gloves
	[14158]="6180:1236:4:1:1:::0:0:", -- Pagan Vest
	[14199]="6200:1240:4:1:1:::0:0:", -- Thistlefur Gloves
	[9515]="6243:1248:4:1:1:::0:0:", -- Nether-lace Tunic
	[14195]="6262:1252:4:1:1:::0:0:", -- Raincaller Boots
	[3569]="6310:1262:4:1:1:::0:0:", -- Vicar's Robe
	[6395]="6321:1264:4:1:1:::0:0:", -- Silver-thread Amice
	[6314]="6343:1268:4:1:1:::0:0:", -- Wolfmaster Cape
	[3067]="6375:1275:4:1:1:::0:0:", -- Bright Pants
	[14414]="6381:1276:4:1:1:::0:0:", -- Stonecloth Belt
	[9516]="6429:1285:4:1:1:::0:0:", -- Astral Knot Blouse
	[3556]="6429:1285:4:1:1:::0:0:", -- Dread Mage Hat
	[14416]="6429:1285:4:1:1:::0:0:", -- Stonecloth Bindings
	[2902]="6527:1305:4:1:1:::0:0:", -- Cloak of the Faith
	[6685]="6554:1310:4:1:1:::0:0:", -- Death Speaker Mantle
	[17047]="6565:1313:4:1:1:::0:0:", -- Luminescent Amice
	[3749]="6603:1320:4:1:1:::0:0:", -- High Apothecary Cloak
	[2566]="6613:1322:4:1:1:::0:0:", -- Sacrificial Robes
	[14211]="6626:1325:4:1:1:::0:0:", -- Vital Handwraps
	[7419]="6631:1326:4:1:1:::0:0:", -- Phalanx Cloak
	[6608]="6644:1328:4:1:1:::0:0:", -- Bright Armor
	[9772]="6644:1328:4:1:1:::0:0:", -- Greenweave Leggings
	[5766]="6691:1338:4:1:1:::0:0:", -- Lesser Wizard's Robe
	[4040]="6738:1347:4:1:1:::0:0:", -- Nightsky Gloves
	[9605]="6783:1356:4:1:1:::0:0:", -- Repairman's Cape
	[15135]="6788:1357:4:1:1:::0:0:", -- Cutthroat's Cape
	[9853]="6842:1368:4:1:1:::0:0:", -- Conjurer's Cinch
	[9773]="6847:1369:4:1:1:::0:0:", -- Greenweave Robe
	[6617]="6855:1371:4:1:1:::0:0:", -- Sage's Mantle
	[9774]="6872:1374:4:1:1:::0:0:", -- Greenweave Vest
	[4121]="6902:1380:4:1:1:::0:0:", -- Gemmed Gloves
	[14411]="6938:1387:4:1:1:::0:0:", -- Stonecloth Gloves
	[4385]="7052:1410:4:1:1::202:0:0:", -- Green Tinted Goggles
	[10288]="7052:1410:4:1:1:::0:0:", -- Sage's Circlet
	[7356]="7056:1411:4:1:1:::0:0:", -- Elder's Cloak
	[6751]="7057:1411:4:1:1:::0:0:", -- Mourning Shawl
	[9536]="7059:1411:4:1:1:::0:0:", -- Fairywing Mantle
	[3069]="7063:1412:4:1:1:::0:0:", -- Bright Robe
	[4462]="7126:1425:4:1:1:::0:0:", -- Cloak of Rot
	[9846]="7148:1429:4:1:1:::0:0:", -- Conjurer's Bracers
	[14372]="7151:1430:4:1:1:::0:0:", -- Sanguine Armor
	[15585]="7234:1446:4:1:1:::0:0:", -- Pardoc Grips
	[15559]="7250:1450:4:1:1:::0:0:", -- Pillager's Cloak
	[14399]="7328:1465:4:1:1:::0:0:", -- Resilient Boots
	[14380]="7369:1473:4:1:1:::0:0:", -- Sanguine Robe
	[7052]="7440:1488:4:1:1:::0:0:", -- Azure Silk Belt
	[7046]="7473:1494:4:1:1:::0:0:", -- Azure Silk Pants
	[7055]="7519:1503:4:1:1:::0:0:", -- Crimson Silk Belt
	[14221]="7554:1510:4:1:1:::0:0:", -- Geomancer's Bracers
	[4328]="7623:1524:4:1:1:::0:0:", -- Spider Belt
	[9797]="7640:1528:4:1:1:::0:0:", -- Ivycloth Pants
	[14198]="7659:1531:4:1:1:::0:0:", -- Thistlefur Cloak
	[14178]="7661:1532:4:1:1:::0:0:", -- Watcher's Cap
	[9820]="7707:1541:4:1:1:::0:0:", -- Durable Boots
	[7334]="7721:1544:4:1:1:::0:0:", -- Efflorescent Robe
	[6903]="7747:1549:4:1:1:::0:0:", -- Gaze Dreamer Pants
	[7437]="7772:1554:4:1:1:::0:0:", -- Twilight Cuffs
	[10289]="7787:1557:4:1:1:::0:0:", -- Durable Hat
	[6780]="7800:1560:4:1:1:::0:0:", -- Lilac Sash
	[7438]="7802:1560:4:1:1:::0:0:", -- Twilight Belt
	[9848]="7922:1584:4:1:1:::0:0:", -- Conjurer's Gloves
	[14189]="7940:1588:4:1:1:::0:0:", -- Raincaller Cap
	[9824]="7998:1599:4:1:1:::0:0:", -- Durable Shoulders
	[14397]="8001:1600:4:1:1:::0:0:", -- Resilient Mantle
	[15354]="8003:1600:4:1:1:::0:0:", -- Headhunter's Cloak
	[14379]="8075:1615:4:1:1:::0:0:", -- Sanguine Trousers
	[5820]="8114:1622:4:1:1:::0:0:", -- Faerie Mantle
	[14210]="8184:1636:4:1:1:::0:0:", -- Vital Cape
	[14217]="8193:1638:4:1:1:::0:0:", -- Geomancer's Cord
	[9791]="8224:1644:4:1:1:::0:0:", -- Ivycloth Tunic
	[16658]="8246:1649:4:1:1:::0:0:", -- Wildhunter Cloak
	[4716]="8294:1658:4:1:1:::0:0:", -- Combat Cloak
	[2032]="8328:1665:4:1:1:::0:0:", -- Gallan Cuffs
	[14196]="8365:1673:4:1:1:::0:0:", -- Thistlefur Sandals
	[4719]="8383:1676:4:1:1:::0:0:", -- Nightsky Cloak
	[7433]="8421:1684:4:1:1:::0:0:", -- Twilight Gloves
	[14763]="8425:1685:4:1:1:::0:0:", -- Enduring Cape
	[9798]="8434:1686:4:1:1:::0:0:", -- Ivycloth Robe
	[6418]="8486:1697:4:1:1:::0:0:", -- Aurora Sash
	[19507]="8507:1701:4:1:1:::0:0:", -- Inquisitor's Shawl
	[4723]="8518:1703:4:1:1:::0:0:", -- Humbert's Pants
	[14409]="8535:1707:4:1:1:::0:0:", -- Stonecloth Cape
	[14183]="8550:1710:4:1:1:::0:0:", -- Watcher's Leggings
	[7750]="8562:1712:4:1:1:::0:0:", -- Mantle of Woe
	[14184]="8584:1716:4:1:1:::0:0:", -- Watcher's Robes
	[14226]="8658:1731:4:1:1:::0:0:", -- Embersilk Bracelets
	[15147]="8769:1753:4:1:1:::0:0:", -- Ghostwalker Cloak
	[7411]="8846:1769:4:1:1:::0:0:", -- Infiltrator Cloak
	[5181]="8890:1778:4:1:1:::0:0:", -- Vibrant Silk Cape
	[9867]="8894:1778:4:1:1:::0:0:", -- Renegade Cloak
	[9847]="8895:1779:4:1:1:::0:0:", -- Conjurer's Cloak
	[14401]="8933:1786:4:1:1:::0:0:", -- Resilient Cap
	[14235]="8948:1789:4:1:1:::0:0:", -- Embersilk Cord
	[4133]="8970:1794:4:1:1:::0:0:", -- Darkspear Cuffs
	[2234]="9033:1806:4:1:1:::0:0:", -- Nightwalker Armor
	[5770]="9037:1807:4:1:1:::0:0:", -- Robes of Arcana
	[4322]="9053:1810:4:1:1:::0:0:", -- Enchanter's Cowl
	[9699]="9062:1812:4:1:1:::0:0:", -- Garrison Cloak
	[15568]="9069:1813:4:1:1:::0:0:", -- Marauder's Cloak
	[7367]="9093:1818:4:1:1:::0:0:", -- Elder's Mantle
	[4037]="9106:1821:4:1:1:::0:0:", -- Silver-thread Pants
	[14222]="9174:1834:4:1:1:::0:0:", -- Geomancer's Gloves
	[11884]="9231:1846:4:1:1:::0:0:", -- Moonlit Amice
	[7354]="9324:1864:4:1:1:::0:0:", -- Elder's Boots
	[14180]="9351:1870:4:1:1:::0:0:", -- Watcher's Jerkin
	[4324]="9373:1874:4:1:1:::0:0:", -- Azure Silk Vest
	[4140]="9375:1875:4:1:1:::0:0:", -- Palm Frond Mantle
	[7357]="9378:1875:4:1:1:::0:0:", -- Elder's Hat
	[6682]="9504:1900:4:1:1:::0:0:", -- Death Speaker Robes
	[14231]="9524:1904:4:1:1:::0:0:", -- Embersilk Mitts
	[16791]="9561:1912:4:1:1:::0:0:", -- Silkstream Cuffs
	[14419]="9596:1919:4:1:1:::0:0:", -- Silksand Bracers
	[14190]="9660:1932:4:1:1:::0:0:", -- Raincaller Vest
	[14192]="9732:1946:4:1:1:::0:0:", -- Raincaller Robes
	[15864]="9738:1947:4:1:1:::0:0:", -- Condor Bracers
	[4043]="9790:1958:4:1:1:::0:0:", -- Aurora Bracers
	[9879]="9824:1964:4:1:1:::0:0:", -- Sorcerer Bracelets
	[6406]="9854:1970:4:1:1:::0:0:", -- Nightsky Boots
	[4505]="9870:1974:4:1:1:::0:0:", -- Swampland Trousers
	[4744]="9933:1986:4:1:1:::0:0:", -- Arcane Runed Bracers
	[4035]="9944:1988:4:1:1:::0:0:", -- Silver-thread Robe
	[4323]="9995:1999:4:1:1:::0:0:", -- Shadow Hood
	[7460]="10004:2000:4:1:1:::0:0:", -- Knight's Cloak
	[14193]="10031:2006:4:1:1:::0:0:", -- Raincaller Pants
	[14214]="10048:2009:4:1:1:::0:0:", -- Vital Boots
	[7061]="10087:2017:4:1:1:::0:0:", -- Earthen Silk Belt
	[10043]="10167:2033:4:1:1:::0:0:", -- Pious Legwraps
	[1297]="10193:2038:4:1:1:::0:0:", -- Robes of the Shadowcaster
	[14219]="10230:2046:4:1:1:::0:0:", -- Geomancer's Cloak
	[14201]="10303:2060:4:1:1:::0:0:", -- Thistlefur Mantle
	[7110]="10349:2069:4:1:1:::0:0:", -- Silver-thread Armor
	[3560]="10514:2102:4:1:1:::0:0:", -- Mantle of Honor
	[10499]="10526:2105:4:1:1:::0:0:", -- Bright-Eye Goggles
	[4042]="10536:2107:4:1:1:::0:0:", -- Aurora Gloves
	[7436]="10558:2111:4:1:1:::0:0:", -- Twilight Cape
	[4722]="10591:2118:4:1:1:::0:0:", -- Insignia Cloak
	[4329]="10603:2120:4:1:1:::0:0:", -- Star Belt
	[15579]="10614:2122:4:1:1:::0:0:", -- Sparkleshell Cloak
	[14426]="10626:2125:4:1:1:::0:0:", -- Silksand Girdle
	[9880]="10650:2130:4:1:1:::0:0:", -- Sorcerer Gloves
	[1659]="10682:2136:4:1:1:::0:0:", -- Engineering Gloves
	[9845]="10683:2136:4:1:1:::0:0:", -- Conjurer's Shoes
	[9875]="10697:2139:4:1:1:::0:0:", -- Sorcerer Sash
	[9390]="10734:2146:4:1:1:::0:0:", -- Revelosh's Gloves
	[6609]="10740:2148:4:1:1:::0:0:", -- Sage's Cloth
	[6610]="10780:2156:4:1:1:::0:0:", -- Sage's Robe
	[7684]="10924:2184:4:1:1:::0:0:", -- Bloodmage Mantle
	[14212]="10974:2194:4:1:1:::0:0:", -- Vital Shoulders
	[4545]="11010:2202:4:1:1:::0:0:", -- Radiant Silver Bracers
	[7476]="11019:2203:4:1:1:::0:0:", -- Regal Sash
	[6616]="11019:2203:4:1:1:::0:0:", -- Sage's Pants
	[14593]="11051:2210:4:1:1:::0:0:", -- Hawkeye's Cloak
	[4039]="11078:2215:4:1:1:::0:0:", -- Nightsky Cowl
	[4504]="11112:2222:4:1:1:::0:0:", -- Dwarven Guard Cloak
	[4718]="11118:2223:4:1:1:::0:0:", -- Nightsky Mantle
	[6745]="11197:2239:4:1:1:::0:0:", -- Swiftrunner Cape
	[7053]="11201:2240:4:1:1:::0:0:", -- Azure Silk Cloak
	[6282]="11219:2243:4:1:1:::0:0:", -- Sacred Burial Trousers
	[14200]="11294:2258:4:1:1:::0:0:", -- Thistlefur Cap
	[14422]="11314:2262:4:1:1:::0:0:", -- Silksand Gloves
	[7377]="11347:2269:4:1:1:::0:0:", -- Frost Leather Cloak
	[4325]="11362:2272:4:1:1:::0:0:", -- Boots of the Enchanter
	[14408]="11376:2275:4:1:1:::0:0:", -- Stonecloth Boots
	[9519]="11444:2288:4:1:1:::0:0:", -- Durtfeet Stompers
	[14240]="11473:2294:4:1:1:::0:0:", -- Darkmist Bands
	[14412]="11494:2298:4:1:1:::0:0:", -- Stonecloth Epaulets
	[14241]="11558:2311:4:1:1:::0:0:", -- Darkmist Handguards
	[7056]="11574:2314:4:1:1:::0:0:", -- Crimson Silk Cloak
	[14208]="11580:2316:4:1:1:::0:0:", -- Vital Headband
	[2953]="11606:2321:4:1:1:::0:0:", -- Watch Master's Cloak
	[7057]="11618:2323:4:1:1:::0:0:", -- Green Silken Shoulders
	[10747]="11637:2327:4:1:1:::0:0:", -- Teacher's Sash
	[4726]="11703:2340:4:1:1:::0:0:", -- Chief Brigadier Cloak
	[14245]="11733:2346:4:1:1:::0:0:", -- Darkmist Girdle
	[2805]="11762:2352:4:1:1:::0:0:", -- Yeti Fur Cloak
	[9825]="11775:2355:4:1:1:::0:0:", -- Durable Pants
	[14398]="11778:2355:4:1:1:::0:0:", -- Resilient Tunic
	[2621]="11787:2357:4:1:1:::0:0:", -- Cowl of Necromancy
	[7475]="11856:2371:4:1:1:::0:0:", -- Regal Cuffs
	[14248]="11864:2372:4:1:1:::0:0:", -- Lunar Bindings
	[9860]="11912:2382:4:1:1:::0:0:", -- Archer's Cloak
	[9849]="11927:2385:4:1:1:::0:0:", -- Conjurer's Hood
	[14229]="11938:2387:4:1:1:::0:0:", -- Embersilk Cloak
	[6726]="11941:2388:4:1:1:::0:0:", -- Razzeric's Customized Seatbelt
	[9850]="11971:2394:4:1:1:::0:0:", -- Conjurer's Mantle
	[7065]="11990:2398:4:1:1:::0:0:", -- Green Silk Armor
	[10359]="12151:2430:4:1:1:::0:0:", -- Everlast Boots
	[15364]="12157:2431:4:1:1:::0:0:", -- Trickster's Cloak
	[7471]="12275:2455:4:1:1:::0:0:", -- Regal Gloves
	[14404]="12359:2471:4:1:1:::0:0:", -- Resilient Leggings
	[14405]="12402:2480:4:1:1:::0:0:", -- Resilient Robe
	[2954]="12425:2485:4:1:1:::0:0:", -- Night Watch Pantaloons
	[4326]="12482:2496:4:1:1:::0:0:", -- Long Silken Cloak
	[15594]="12600:2520:4:1:1:::0:0:", -- Steadfast Cloak
	[6417]="12680:2536:4:1:1:::0:0:", -- Aurora Cloak
	[5965]="12680:2536:4:1:1:::0:0:", -- Guardian Cloak
	[7434]="12680:2536:4:1:1:::0:0:", -- Twilight Boots
	[1997]="12694:2538:4:1:1:::0:0:", -- Pressed Felt Robe
	[7064]="12849:2569:4:1:1:::0:0:", -- Crimson Silk Gloves
	[4979]="12939:2587:4:1:1:::0:0:", -- Enchanted Stonecloth Bracers
	[9826]="13001:2600:4:1:1:::0:0:", -- Durable Robe
	[2622]="13015:2603:4:1:1:::0:0:", -- Nimar's Tribal Headdress
	[4736]="13081:2616:4:1:1:::0:0:", -- Mistscape Sash
	[15153]="13131:2626:4:1:1:::0:0:", -- Nocturnal Cloak
	[14255]="13144:2628:4:1:1:::0:0:", -- Lunar Belt
	[4393]="13162:2632:4:1:1:::0:0:", -- Craftsman's Monocle
	[4732]="13162:2632:4:1:1:::0:0:", -- Glyphed Cloak
	[14429]="13220:2644:4:1:1:::0:0:", -- Windchaser Cuffs
	[7368]="13385:2677:4:1:1:::0:0:", -- Elder's Pants
	[4045]="13415:2683:4:1:1:::0:0:", -- Mistscape Bracers
	[7051]="13481:2696:4:1:1:::0:0:", -- Earthen Vest
	[14223]="13494:2698:4:1:1:::0:0:", -- Geomancer's Spaulders
	[9877]="13541:2708:4:1:1:::0:0:", -- Sorcerer Cloak
	[14410]="13549:2709:4:1:1:::0:0:", -- Stonecloth Circlet
	[14218]="13568:2713:4:1:1:::0:0:", -- Geomancer's Boots
	[7432]="13589:2717:4:1:1:::0:0:", -- Twilight Cowl
	[9898]="13591:2718:4:1:1:::0:0:", -- Jazeraint Cloak
	[3345]="13601:2720:4:1:1:::0:0:", -- Silk Wizard Hat
	[9819]="13630:2726:4:1:1:::0:0:", -- Durable Tunic
	[6416]="13642:2728:4:1:1:::0:0:", -- Aurora Boots
	[4476]="13672:2734:4:1:1:::0:0:", -- Beastwalker Robe
	[4643]="13741:2748:4:1:1:::0:0:", -- Grimsteel Cape
	[4139]="13745:2749:4:1:1:::0:0:", -- Junglewalker Sandals
	[7435]="13747:2749:4:1:1:::0:0:", -- Twilight Mantle
	[14203]="13770:2754:4:1:1:::0:0:", -- Thistlefur Pants
	[14435]="13893:2778:4:1:1:::0:0:", -- Windchaser Cinch
	[7059]="13905:2781:4:1:1:::0:0:", -- Crimson Silk Shoulders
	[7060]="13958:2791:4:1:1:::0:0:", -- Azure Shoulders
	[6428]="13975:2795:4:1:1:::0:0:", -- Mistscape Gloves
	[6737]="14027:2805:4:1:1:::0:0:", -- Dryleaf Pants
	[14253]="14095:2819:4:1:1:::0:0:", -- Lunar Handwraps
	[15697]="14129:2825:4:1:1:::0:0:", -- Kodo Rustler Boots
	[9909]="14242:2848:4:1:1:::0:0:", -- Royal Bands
	[10003]="14296:2859:4:1:1:::0:0:", -- Black Mageweave Gloves
	[14431]="14388:2877:4:1:1:::0:0:", -- Windchaser Handguards
	[14420]="14446:2889:4:1:1:::0:0:", -- Silksand Cape
	[14260]="14503:2900:4:1:1:::0:0:", -- Bloodwoven Bracers
	[14236]="14546:2909:4:1:1:::0:0:", -- Embersilk Boots
	[9890]="14595:2919:4:1:1:::0:0:", -- Huntsman's Cape
	[5624]="14634:2926:4:1:1:::0:0:", -- Circlet of the Order
	[5016]="14775:2955:4:1:1:::0:0:", -- Artisan's Trousers
	[7369]="14777:2955:4:1:1:::0:0:", -- Elder's Robe
	[14602]="14975:2995:4:1:1:::0:0:", -- Warden's Cloak
	[7353]="14991:2998:4:1:1:::0:0:", -- Elder's Padded Armor
	[2620]="15067:3013:4:1:1:::0:0:", -- Augural Shroud
	[7492]="15077:3015:4:1:1:::0:0:", -- Captain's Cloak
	[14771]="15150:3030:4:1:1:::0:0:", -- Ravager's Cloak
	[4729]="15184:3036:4:1:1:::0:0:", -- Aurora Mantle
	[14204]="15206:3041:4:1:1:::0:0:", -- Thistlefur Robe
	[9906]="15216:3043:4:1:1:::0:0:", -- Royal Sash
	[17043]="15274:3054:4:1:1:::0:0:", -- Zealot's Robe
	[14207]="15381:3076:4:1:1:::0:0:", -- Vital Leggings
	[10461]="15410:3082:4:1:1:::0:0:", -- Shadowy Bracers
	[9910]="15437:3087:4:1:1:::0:0:", -- Royal Gloves
	[7446]="15462:3092:4:1:1:::0:0:", -- Sentinel Cloak
	[14232]="15486:3097:4:1:1:::0:0:", -- Embersilk Mantle
	[14418]="15490:3098:4:1:1:::0:0:", -- Silksand Boots
	[7525]="15530:3106:4:1:1:::0:0:", -- Gossamer Bracers
	[14258]="15545:3109:4:1:1:::0:0:", -- Bloodwoven Cord
	[4117]="15596:3119:4:1:1:::0:0:", -- Scorching Sash
	[9876]="15733:3146:4:1:1:::0:0:", -- Sorcerer Slippers
	[4041]="15749:3149:4:1:1:::0:0:", -- Aurora Cowl
	[9636]="15772:3154:4:1:1:::0:0:", -- Swashbuckler Sash
	[14262]="15783:3156:4:1:1:::0:0:", -- Bloodwoven Mitts
	[6405]="15839:3167:4:1:1:::0:0:", -- Nightsky Trousers
	[14239]="15881:3176:4:1:1:::0:0:", -- Darkmist Cape
	[3764]="15905:3181:4:1:1:::0:0:", -- Mantis Boots
	[15104]="15940:3188:4:1:1:::0:0:", -- Wingborne Boots
	[10018]="16376:3275:4:1:1:::0:0:", -- Red Mageweave Gloves
	[7474]="16407:3281:4:1:1:::0:0:", -- Regal Cloak
	[7111]="16648:3329:4:1:1:::0:0:", -- Nightsky Armor
	[14251]="16661:3332:4:1:1:::0:0:", -- Lunar Cloak
	[10023]="16672:3334:4:1:1:::0:0:", -- Shadoweave Gloves
	[14202]="16681:3336:4:1:1:::0:0:", -- Thistlefur Jerkin
	[7526]="16835:3367:4:1:1:::0:0:", -- Gossamer Belt
	[9634]="16905:3381:4:1:1:::0:0:", -- Skilled Handling Gloves
	[14423]="17033:3406:4:1:1:::0:0:", -- Silksand Shoulder Pads
	[14415]="17051:3410:4:1:1:::0:0:", -- Stonecloth Britches
	[7472]="17115:3423:4:1:1:::0:0:", -- Regal Boots
	[9878]="17124:3424:4:1:1:::0:0:", -- Sorcerer Hat
	[14220]="17214:3442:4:1:1:::0:0:", -- Geomancer's Cap
	[2955]="17247:3449:4:1:1:::0:0:", -- First Mate Hat
	[5608]="17315:3463:4:1:1:::0:0:", -- Living Cowl
	[9881]="17320:3464:4:1:1:::0:0:", -- Sorcerer Mantle
	[6791]="17321:3464:4:1:1:::0:0:", -- Hellion Boots
	[15371]="17338:3467:4:1:1:::0:0:", -- Wolf Rider's Cloak
	[10500]="17394:3478:4:1:1::202:0:0:", -- Fire Goggles
	[14268]="17432:3486:4:1:1:::0:0:", -- Gaea's Cuffs
	[10543]="17585:3517:4:1:1::202:0:0:", -- Goblin Construction Helmet
	[9851]="17623:3524:4:1:1:::0:0:", -- Conjurer's Breeches
	[15455]="17705:3541:4:1:1:::0:0:", -- Dustfall Robes
	[12253]="17728:3545:4:1:1:::1:1:857", -- Brilliant Red Cloak
	[15603]="17731:3546:4:1:1:::0:0:", -- Ancient Cloak
	[14213]="17768:3553:4:1:1:::0:0:", -- Vital Raiment
	[2623]="17772:3554:4:1:1:::0:0:", -- Holy Diadem
	[14228]="17799:3559:4:1:1:::0:0:", -- Embersilk Coronet
	[7521]="17803:3560:4:1:1:::0:0:", -- Gossamer Gloves
	[4038]="17810:3562:4:1:1:::0:0:", -- Nightsky Robe
	[11469]="17815:3563:4:1:1:::0:0:", -- Bloodband Bracers
	[14215]="17898:3579:4:1:1:::0:0:", -- Vital Tunic
	[8108]="17972:3594:4:1:1:::0:0:", -- Hibernal Bracers
	[14276]="17991:3598:4:1:1:::0:0:", -- Gaea's Belt
	[10462]="18044:3608:4:1:1:::0:0:", -- Shadowy Belt
	[4735]="18105:3621:4:1:1:::0:0:", -- Mistscape Cloak
	[8110]="18110:3622:4:1:1:::0:0:", -- Hibernal Gloves
	[9929]="18314:3662:4:1:1:::0:0:", -- Brigade Cloak
	[10705]="18333:3666:4:1:1:::0:0:", -- Firwillow Wristbands
	[7470]="18341:3668:4:1:1:::0:0:", -- Regal Wizard Hat
	[8114]="18388:3677:4:1:1:::0:0:", -- Hibernal Sash
	[14430]="18432:3686:4:1:1:::0:0:", -- Windchaser Cloak
	[14238]="18457:3691:4:1:1:::0:0:", -- Darkmist Boots
	[9844]="18546:3709:4:1:1:::0:0:", -- Conjurer's Vest
	[7473]="18554:3710:4:1:1:::0:0:", -- Regal Mantle
	[6432]="18708:3741:4:1:1:::0:0:", -- Imperial Cloak
	[15165]="18723:3744:4:1:1:::0:0:", -- Imposing Cape
	[6832]="18849:3769:4:1:1:::0:0:", -- Cloak of Blight
	[9852]="19102:3820:4:1:1:::0:0:", -- Conjurer's Robe
	[14272]="19104:3820:4:1:1:::0:0:", -- Gaea's Handwraps
	[6424]="19127:3825:4:1:1:::0:0:", -- Blackforge Cape
	[14439]="19180:3836:4:1:1:::0:0:", -- Venomshroud Armguards
	[2624]="19264:3852:4:1:1:::0:0:", -- Thinking Cap
	[14250]="19364:3872:4:1:1:::0:0:", -- Lunar Slippers
	[16738]="19468:3893:4:1:1:::0:0:", -- Witherseed Gloves
	[7431]="19495:3899:4:1:1:::0:0:", -- Twilight Pants
	[14224]="19508:3901:4:1:1:::0:0:", -- Geomancer's Trousers
	[10545]="19646:3929:4:1:1:::0:0:", -- Gnomish Goggles
	[14421]="19725:3945:4:1:1:::0:0:", -- Silksand Circlet
	[14413]="19736:3947:4:1:1:::0:0:", -- Stonecloth Robe
	[4047]="19799:3959:4:1:1:::0:0:", -- Mistscape Boots
	[9937]="20023:4004:4:1:1:::0:0:", -- Abjurer's Bands
	[4137]="20053:4010:4:1:1:::0:0:", -- Darkspear Shoes
	[6789]="20060:4012:4:1:1:::0:0:", -- Ceremonial Centaur Blanket
	[14261]="20222:4044:4:1:1:::0:0:", -- Bloodwoven Cloak
	[14243]="20376:4075:4:1:1:::0:0:", -- Darkmist Mantle
	[9658]="20432:4086:4:1:1:::0:0:", -- Boots of the Maharishi
	[10502]="20441:4088:4:1:1::202:0:0:", -- Spellpower Goggles Xtreme
	[19123]="20572:4114:4:1:1:::0:0:", -- Everwarm Handwraps
	[9945]="20623:4124:4:1:1:::0:0:", -- Abjurer's Sash
	[4120]="20963:4192:4:1:1:::0:0:", -- Robe of Crystal Waters
	[7430]="20974:4194:4:1:1:::0:0:", -- Twilight Robe
	[14279]="21031:4206:4:1:1:::0:0:", -- Opulent Bracers
	[4734]="21041:4208:4:1:1:::0:0:", -- Mistscape Mantle
	[10066]="21101:4220:4:1:1:::0:0:", -- Duskwoven Sash
	[9660]="21139:4227:4:1:1:::0:0:", -- Stargazer Cloak
	[7483]="21192:4238:4:1:1:::0:0:", -- Ranger Cloak
	[14446]="21241:4248:4:1:1:::0:0:", -- Venomshroud Belt
	[9908]="21289:4257:4:1:1:::0:0:", -- Royal Cape
	[14407]="21331:4266:4:1:1:::0:0:", -- Stonecloth Vest
	[9703]="21362:4272:4:1:1:::0:0:", -- Scorched Cape
	[7544]="21484:4296:4:1:1:::0:0:", -- Champion's Cape
	[7524]="21486:4297:4:1:1:::0:0:", -- Gossamer Cape
	[14656]="21500:4300:4:1:1:::0:0:", -- Scorpashi Cape
	[9939]="21586:4317:4:1:1:::0:0:", -- Abjurer's Gloves
	[4746]="21620:4324:4:1:1:::0:0:", -- Doomsayer's Robe
	[10008]="21826:4365:4:1:1:::0:0:", -- White Bandit Mask
	[15611]="21847:4369:4:1:1:::0:0:", -- Bonelink Cape
	[2231]="21933:4386:4:1:1:::0:0:", -- Inferno Robe
	[10501]="21993:4398:4:1:1:Buff::0:0:", -- Catseye Ultra Goggles
	[14246]="22256:4451:4:1:1:::0:0:", -- Darkmist Wizard Hat
	[6801]="22282:4456:4:1:1:::0:0:", -- Baroque Apron
	[14247]="22337:4467:4:1:1:::0:0:", -- Lunar Mantle
	[14233]="22381:4476:4:1:1:::0:0:", -- Embersilk Leggings
	[14442]="22407:4481:4:1:1:::0:0:", -- Venomshroud Mitts
	[12254]="22416:4483:4:1:1:::1:1:470,857", -- Well Oiled Cloak
	[10782]="22694:4538:4:1:1:::0:0:", -- Hakkar'i Shroud
	[6429]="22724:4544:4:1:1:::0:0:", -- Mistscape Wizard Hat
	[7112]="22735:4547:4:1:1:::0:0:", -- Aurora Armor
	[14282]="22760:4552:4:1:1:::0:0:", -- Opulent Gloves
	[6415]="22825:4565:4:1:1:::0:0:", -- Aurora Robe
	[9907]="22909:4581:4:1:1:::0:0:", -- Royal Boots
	[4044]="22921:4584:4:1:1:::0:0:", -- Aurora Pants
	[19116]="22952:4590:4:1:1:::0:0:", -- Greenleaf Handwraps
	[14781]="23089:4617:4:1:1:::0:0:", -- Khan's Cloak
	[7429]="23100:4620:4:1:1:::0:0:", -- Twilight Armor
	[14286]="23103:4620:4:1:1:::0:0:", -- Opulent Belt
	[14432]="23397:4679:4:1:1:::0:0:", -- Windchaser Amice
	[14225]="23471:4694:4:1:1:::0:0:", -- Geomancer's Wraps
	[10518]="23482:4696:4:1:1:::0:0:", -- Parachute Cloak
	[10724]="23484:4696:4:1:1:::0:0:", -- Gnomish Rocket Boots
	[7189]="23562:4712:4:1:1:::0:0:", -- Goblin Rocket Boots
	[9635]="23567:4713:4:1:1:::0:0:", -- Master Apothecary Cape
	[14428]="23586:4717:4:1:1:::0:0:", -- Windchaser Footpads
	[10059]="23697:4739:4:1:1:::0:0:", -- Duskwoven Bracers
	[7063]="23707:4741:4:1:1:::0:0:", -- Crimson Silk Robe
	[10062]="23791:4758:4:1:1:::0:0:", -- Duskwoven Gloves
	[11858]="23842:4768:4:1:1:::0:0:", -- Battlehard Cape
	[17750]="23848:4769:4:1:1:::0:0:", -- Chloromesh Girdle
	[9959]="24017:4803:4:1:1:::0:0:", -- Warmonger's Cloak
	[9998]="24076:4815:4:1:1:::0:0:", -- Black Mageweave Vest
	[9665]="24134:4826:4:1:1:::0:0:", -- Wingcrest Gloves
	[14291]="24153:4830:4:1:1:::0:0:", -- Arachnidian Bracelets
	[9999]="24164:4832:4:1:1:::0:0:", -- Black Mageweave Leggings
	[4113]="24265:4853:4:1:1:::0:0:", -- Medicine Blanket
	[14270]="24389:4877:4:1:1:::0:0:", -- Gaea's Cloak
	[11888]="24398:4879:4:1:1:::0:0:", -- Quintis' Research Gloves
	[14216]="24438:4887:4:1:1:::0:0:", -- Geomancer's Jerkin
	[14252]="24571:4914:4:1:1:::0:0:", -- Lunar Coronet
	[7522]="24814:4962:4:1:1:::0:0:", -- Gossamer Boots
	[15624]="24855:4971:4:1:1:::0:0:", -- Gryphon Cloak
	[10700]="24918:4983:4:1:1:::0:0:", -- Encarmine Boots
	[7523]="24965:4993:4:1:1:::0:0:", -- Gossamer Shoulderpads
	[8247]="24988:4997:4:1:1:::0:0:", -- Imperial Red Bracers
	[15632]="24989:4997:4:1:1:::0:0:", -- Formidable Cape
	[8109]="25059:5011:4:1:1:::0:0:", -- Hibernal Cloak
	[9883]="25130:5026:4:1:1:::0:0:", -- Sorcerer Pants
	[9912]="25188:5037:4:1:1:::0:0:", -- Royal Amice
	[15382]="25215:5043:4:1:1:::0:0:", -- Rageclaw Cloak
	[14259]="25280:5056:4:1:1:::0:0:", -- Bloodwoven Boots
	[9915]="25456:5091:4:1:1:::0:0:", -- Royal Headband
	[8253]="25539:5107:4:1:1:::0:0:", -- Imperial Red Sash
	[11311]="25553:5110:4:1:1:::0:0:", -- Emberscale Cape
	[13856]="25564:5112:4:1:1:::0:0:", -- Runecloth Belt
	[14289]="25659:5131:4:1:1:::0:0:", -- Arachnidian Girdle
	[10180]="25707:5141:4:1:1:::0:0:", -- Mystical Belt
	[9919]="25746:5149:4:1:1:::0:0:", -- Tracker's Cloak
	[14230]="25822:5164:4:1:1:::0:0:", -- Embersilk Tunic
	[10503]="25847:5169:4:1:1:::0:0:", -- Rose Colored Goggles
	[14294]="26119:5223:4:1:1:::0:0:", -- Arachnidian Gloves
	[10506]="26136:5227:4:1:1:Buff::0:0:", -- Deepdive Helmet
	[14234]="26200:5240:4:1:1:::0:0:", -- Embersilk Robes
	[10001]="26285:5257:4:1:1:::0:0:", -- Black Mageweave Robe
	[14436]="26351:5270:4:1:1:::0:0:", -- Windchaser Coronet
	[10002]="26380:5276:4:1:1:::0:0:", -- Shadoweave Pants
	[10009]="26424:5284:4:1:1:::0:0:", -- Red Mageweave Pants
	[14424]="26584:5316:4:1:1:::0:0:", -- Silksand Legwraps
	[8249]="26682:5336:4:1:1:::0:0:", -- Imperial Red Gloves
	[14440]="26737:5347:4:1:1:::0:0:", -- Venomshroud Cape
	[15173]="26939:5387:4:1:1:::0:0:", -- Potent Cape
	[10029]="26959:5391:4:1:1:::0:0:", -- Red Mageweave Shoulders
	[14242]="27068:5413:4:1:1:::0:0:", -- Darkmist Pants
	[10024]="27107:5421:4:1:1:::0:0:", -- Black Mageweave Headband
	[9884]="27244:5448:4:1:1:::0:0:", -- Sorcerer Robe
	[14301]="27257:5451:4:1:1:::0:0:", -- Bonecaster's Bindings
	[10026]="27298:5459:4:1:1::202:0:0:", -- Black Mageweave Boots
	[13870]="27358:5471:4:1:1:::0:0:", -- Frostweave Gloves
	[10027]="27396:5479:4:1:1:::0:0:", -- Black Mageweave Shoulders
	[10726]="27603:5520:4:1:1:::0:0:", -- Gnomish Mind Control Cap
	[14451]="27684:5536:4:1:1:::0:0:", -- Highborne Gloves
	[14448]="27777:5555:4:1:1:::0:0:", -- Highborne Bracelets
	[7533]="27789:5557:4:1:1:::0:0:", -- Cabalist Cloak
	[14454]="27993:5598:4:1:1:::0:0:", -- Highborne Cord
	[14266]="28031:5606:4:1:1:::0:0:", -- Bloodwoven Pads
	[14269]="28346:5669:4:1:1:::0:0:", -- Gaea's Slippers
	[10103]="28437:5687:4:1:1:::0:0:", -- Councillor's Sash
	[10176]="28446:5689:4:1:1:::0:0:", -- Mystical Gloves
	[10173]="28592:5718:4:1:1:::0:0:", -- Mystical Bracers
	[10004]="28694:5738:4:1:1:::0:0:", -- Shadoweave Robe
	[7520]="28737:5747:4:1:1:::0:0:", -- Gossamer Headpiece
	[14143]="28817:5763:4:1:1:::0:0:", -- Ghostweave Belt
	[11875]="28881:5776:4:1:1:::0:0:", -- Breezecloud Bracers
	[10007]="28999:5799:4:1:1:::0:0:", -- Red Mageweave Vest
	[9874]="29005:5801:4:1:1:::0:0:", -- Sorcerer Drape
	[4114]="29130:5826:4:1:1:::0:0:", -- Darktide Cape
	[10588]="29171:5834:4:1:1:::0:0:", -- Goblin Rocket Helmet
	[11634]="29432:5886:4:1:1:::0:0:", -- Silkweb Gloves
	[14417]="29440:5888:4:1:1:::0:0:", -- Silksand Tunic
	[8111]="29452:5890:4:1:1:::0:0:", -- Hibernal Mantle
	[14280]="29596:5919:4:1:1:::0:0:", -- Opulent Cape
	[8127]="29689:5937:4:1:1:::0:0:", -- Myrmidon's Cape
	[8107]="29692:5938:4:1:1:::0:0:", -- Hibernal Boots
	[10028]="29692:5938:4:1:1:::0:0:", -- Shadoweave Shoulders
	[14043]="29778:5955:4:1:1:::0:0:", -- Cindercloth Gloves
	[8115]="29902:5980:4:1:1:::0:0:", -- Hibernal Cowl
	[14263]="29936:5987:4:1:1:::0:0:", -- Bloodwoven Mask
	[10030]="30037:6007:4:1:1:::0:0:", -- Admiral's Hat
	[9938]="30147:6029:4:1:1:::0:0:", -- Abjurer's Cloak
	[10031]="30150:6030:4:1:1:::0:0:", -- Shadoweave Boots
	[14791]="30282:6056:4:1:1:::0:0:", -- Protector Cape
	[14101]="30334:6066:4:1:1:::0:0:", -- Brightcloth Gloves
	[10033]="30377:6075:4:1:1:::0:0:", -- Red Mageweave Headband
	[14142]="30436:6087:4:1:1:::0:0:", -- Ghostweave Gloves
	[10096]="30653:6130:4:1:1:::0:0:", -- Councillor's Cuffs
	[14438]="30961:6192:4:1:1:::0:0:", -- Venomshroud Boots
	[14304]="30973:6194:4:1:1:::0:0:", -- Bonecaster's Belt
	[14257]="30973:6194:4:1:1:::0:0:", -- Lunar Leggings
	[8120]="31036:6207:4:1:1:::0:0:", -- Heraldic Cloak
	[14665]="31072:6214:4:1:1:::0:0:", -- Keeper's Cloak
	[11662]="31094:6218:4:1:1:::0:0:", -- Ban'thok Sash
	[14425]="31118:6223:4:1:1:::0:0:", -- Silksand Wraps
	[7469]="31421:6284:4:1:1:::0:0:", -- Regal Leggings
	[8216]="31617:6323:4:1:1:::0:0:", -- Big Voodoo Cloak
	[11917]="31674:6334:4:1:1:::0:0:", -- Shizzle's Nozzle Wiper
	[10079]="31852:6370:4:1:1:::0:0:", -- Lord's Cape
	[14273]="31874:6374:4:1:1:::0:0:", -- Gaea's Amice
	[15392]="31911:6382:4:1:1:::0:0:", -- Jadefire Cloak
	[9648]="31963:6392:4:1:1:::0:0:", -- Chainlink Towel
	[9936]="32016:6403:4:1:1:::0:0:", -- Abjurer's Boots
	[14302]="32587:6517:4:1:1:::0:0:", -- Bonecaster's Gloves
	[9941]="32619:6523:4:1:1:::0:0:", -- Abjurer's Mantle
	[14311]="32621:6524:4:1:1:::0:0:", -- Celestial Bindings
	[10099]="32839:6567:4:1:1:::0:0:", -- Councillor's Gloves
	[14271]="32995:6599:4:1:1:::0:0:", -- Gaea's Circlet
	[13863]="33085:6617:4:1:1:::0:0:", -- Runecloth Gloves
	[8285]="33186:6637:4:1:1:::0:0:", -- Arcane Bands
	[10042]="33222:6644:4:1:1:::0:0:", -- Cindercloth Robe
	[10060]="33339:6667:4:1:1:::0:0:", -- Duskwoven Cape
	[15643]="33379:6675:4:1:1:::0:0:", -- Ironhide Cloak
	[7332]="33462:6692:4:1:1:::0:0:", -- Regal Armor
	[7113]="33535:6707:4:1:1:::0:0:", -- Mistscape Armor
	[14278]="33626:6725:4:1:1:::0:0:", -- Opulent Mantle
	[9653]="33727:6745:4:1:1:::0:0:", -- Speedy Racer Goggles
	[14443]="33729:6745:4:1:1:::0:0:", -- Venomshroud Mantle
	[15183]="33756:6751:4:1:1:::0:0:", -- Praetorian Cloak
	[7468]="33815:6763:4:1:1:::0:0:", -- Regal Robe
	[14433]="33822:6764:4:1:1:::0:0:", -- Windchaser Woolies
	[10044]="33827:6765:4:1:1:::0:0:", -- Cindercloth Boots
	[9645]="33841:6768:4:1:1:::0:0:", -- Gnomish Inventor Boots
	[4046]="33919:6783:4:1:1:::0:0:", -- Mistscape Pants
	[8291]="33922:6784:4:1:1:::0:0:", -- Arcane Sash
	[10025]="33952:6790:4:1:1:::0:0:", -- Shadoweave Mask
	[9951]="33976:6795:4:1:1:::0:0:", -- Chieftain's Cloak
	[14292]="33978:6795:4:1:1:::0:0:", -- Arachnidian Cape
	[14320]="34277:6855:4:1:1:::0:0:", -- Resplendent Bracelets
	[14309]="34334:6866:4:1:1:::0:0:", -- Celestial Belt
	[14244]="34354:6870:4:1:1:::0:0:", -- Darkmist Wraps
	[14285]="34527:6905:4:1:1:::0:0:", -- Opulent Boots
	[9940]="34772:6954:4:1:1:::0:0:", -- Abjurer's Hood
	[12255]="34987:6997:4:1:1:::1:1:781,801", -- Pale Leggings
	[6427]="35081:7016:4:1:1:::0:0:", -- Mistscape Robe
	[8248]="35161:7032:4:1:1:::0:0:", -- Imperial Red Cloak
	[10058]="35417:7083:4:1:1:::0:0:", -- Duskwoven Sandals
	[8287]="35437:7087:4:1:1:::0:0:", -- Arcane Gloves
	[15652]="35699:7139:4:1:1:::0:0:", -- Merciless Cloak
	[10041]="35806:7161:4:1:1:::0:0:", -- Dreamweave Circlet
	[10063]="35826:7165:4:1:1:::0:0:", -- Duskwoven Amice
	[14441]="35834:7166:4:1:1:::0:0:", -- Venomshroud Mask
	[15791]="35860:7172:4:1:1:::0:0:", -- Turquoise Sash
	[10216]="35901:7180:4:1:1:::0:0:", -- Elegant Belt
	[14237]="36030:7206:4:1:1:::0:0:", -- Darkmist Armor
	[18306]="36075:7215:4:1:1:::0:0:", -- Gloves of Shadowy Mist
	[15707]="36078:7215:4:1:1:::0:0:", -- Brantwood Sash
	[11768]="36121:7224:4:1:1:::0:0:", -- Incendic Bracers
	[9911]="36142:7228:4:1:1:::0:0:", -- Royal Trousers
	[10194]="36728:7345:4:1:1:::0:0:", -- Crusader's Cloak
	[12083]="36743:7348:4:1:1:::0:0:", -- Valconian Sash
	[14450]="36824:7364:4:1:1:::0:0:", -- Highborne Cloak
	[10185]="37064:7412:4:1:1:::0:0:", -- Swashbuckler's Cape
	[8266]="37341:7468:4:1:1:::0:0:", -- Ebonhold Cloak
	[15858]="37653:7530:4:1:1:::0:0:", -- Freewind Gloves
	[14249]="37798:7559:4:1:1:::0:0:", -- Lunar Vest
	[11624]="37832:7566:4:1:1:::0:0:", -- Kentic Amice
	[14296]="37840:7568:4:1:1:::0:0:", -- Arachnidian Pauldrons
	[14457]="37878:7575:4:1:1:::0:0:", -- Elunarian Cuffs
	[7519]="38175:7635:4:1:1:::0:0:", -- Gossamer Pants
	[14327]="38296:7659:4:1:1:::0:0:", -- Resplendent Belt
	[10061]="38309:7661:4:1:1:::0:0:", -- Duskwoven Turban
	[14300]="38425:7685:4:1:1:::0:0:", -- Bonecaster's Cape
	[14254]="38493:7698:4:1:1:::0:0:", -- Lunar Raiment
	[14290]="38628:7725:4:1:1:::0:0:", -- Arachnidian Footpads
	[10802]="39156:7831:4:1:1:::0:0:", -- Wingveil Cloak
	[17775]="39207:7841:4:1:1:::0:0:", -- Acumen Robes
	[10213]="39251:7850:4:1:1:::0:0:", -- Elegant Bracers
	[14314]="39270:7854:4:1:1:::0:0:", -- Celestial Handwraps
	[18475]="39536:7907:4:1:1:::0:0:", -- Oddly Magical Belt
	[8246]="39586:7917:4:1:1:::0:0:", -- Imperial Red Boots
	[14264]="40066:8013:4:1:1:::0:0:", -- Bloodwoven Pants
	[8250]="40170:8034:4:1:1:::0:0:", -- Imperial Red Mantle
	[10071]="40315:8063:4:1:1:::0:0:", -- Righteous Cloak
	[11626]="40409:8081:4:1:1:::0:0:", -- Blackveil Cape
	[18337]="40516:8103:4:1:1:::0:0:", -- Orphic Bracers
	[10174]="40607:8121:4:1:1:::0:0:", -- Mystical Cape
	[14801]="40782:8156:4:1:1:::0:0:", -- Bloodlust Cape
	[10144]="40820:8164:4:1:1:::0:0:", -- High Councillor's Sash
	[14281]="40890:8178:4:1:1:::0:0:", -- Opulent Crown
	[10108]="41016:8203:4:1:1:::0:0:", -- Wanderer's Cloak
	[9905]="41258:8251:4:1:1:::0:0:", -- Royal Blouse
	[10214]="41356:8271:4:1:1:::0:0:", -- Elegant Gloves
	[14673]="41518:8303:4:1:1:::0:0:", -- Pridelord Cape
	[14323]="41612:8322:4:1:1:::0:0:", -- Resplendent Gauntlets
	[11623]="41665:8333:4:1:1:::0:0:", -- Spritecaster Cape
	[8112]="42181:8436:4:1:1:::0:0:", -- Hibernal Pants
	[9913]="42454:8490:4:1:1:::0:0:", -- Royal Gown
	[10136]="42653:8530:4:1:1:::0:0:", -- High Councillor's Bracers
	[15427]="42683:8536:4:1:1:::0:0:", -- Peerless Cloak
	[14337]="42731:8546:4:1:1:::0:0:", -- Eternal Cord
	[14465]="42980:8596:4:1:1:::0:0:", -- Elunarian Belt
	[14299]="43013:8602:4:1:1:::0:0:", -- Bonecaster's Boots
	[10179]="43161:8632:4:1:1:::0:0:", -- Mystical Boots
	[8254]="43199:8639:4:1:1:::0:0:", -- Imperial Red Circlet
	[13525]="43492:8698:4:1:1:::0:0:", -- Darkbind Fingers
	[14434]="43531:8706:4:1:1:::0:0:", -- Windchaser Robes
	[11865]="43541:8708:4:1:1:::0:0:", -- Rancor Boots
	[10098]="43684:8736:4:1:1:::0:0:", -- Councillor's Cloak
	[13860]="43705:8741:4:1:1:::0:0:", -- Runecloth Cloak
	[12256]="43828:8765:4:1:1:::1:1:306,761,781", -- Cindercloth Leggings
	[10120]="43987:8797:4:1:1:::0:0:", -- Ornate Cloak
	[14447]="44008:8801:4:1:1:::0:0:", -- Highborne Footpads
	[14452]="44184:8836:4:1:1:::0:0:", -- Highborne Pauldrons
	[10255]="44671:8934:4:1:1:::0:0:", -- Master's Belt
	[14330]="44812:8962:4:1:1:::0:0:", -- Eternal Bindings
	[12050]="44818:8963:4:1:1:::0:0:", -- Hazecover Boots
	[14629]="44825:8965:4:1:1:::0:0:", -- Necropile Cuffs
	[15999]="45014:9002:4:1:1:::0:0:", -- Spellpower Goggles Xtreme Plus
	[10175]="45054:9010:4:1:1:::0:0:", -- Mystical Headwrap
	[8215]="45086:9017:4:1:1:::0:0:", -- Wild Leather Cloak
	[15703]="45163:9032:4:1:1:::0:0:", -- Chemist's Smock
	[15661]="45180:9036:4:1:1:::0:0:", -- Impenetrable Cloak
	[10140]="45425:9085:4:1:1:::0:0:", -- High Councillor's Gloves
	[8297]="45565:9113:4:1:1:::0:0:", -- Traveler's Cloak
	[14427]="45623:9124:4:1:1:::0:0:", -- Windchaser Wraps
	[8259]="45721:9144:4:1:1:::0:0:", -- Serpentskin Cloak
	[14313]="46493:9298:4:1:1:::0:0:", -- Celestial Cape
	[9942]="46708:9341:4:1:1:::0:0:", -- Abjurer's Pants
	[14461]="46714:9342:4:1:1:::0:0:", -- Elunarian Handgrips
	[10248]="46856:9371:4:1:1:::0:0:", -- Master's Bracers
	[7517]="46863:9372:4:1:1:::0:0:", -- Gossamer Tunic
	[7518]="47031:9406:4:1:1:::0:0:", -- Gossamer Robe
	[8286]="47137:9427:4:1:1:::0:0:", -- Arcane Cloak
	[14321]="47190:9438:4:1:1:::0:0:", -- Resplendent Cloak
	[14044]="47516:9503:4:1:1:::0:0:", -- Cindercloth Cloak
	[13864]="47767:9553:4:1:1:::0:0:", -- Runecloth Boots
	[15804]="47873:9574:4:1:1:::0:0:", -- Cerise Drape
	[15789]="47873:9574:4:1:1:::0:0:", -- Deep River Cloak
	[15812]="47873:9574:4:1:1:::0:0:", -- Orchid Amice
	[10742]="47948:9589:4:1:1:::0:0:", -- Dragonflight Leggings
	[10172]="48018:9603:4:1:1:::0:0:", -- Mystical Mantle
	[15190]="48070:9614:4:1:1:::0:0:", -- Grand Cloak
	[14298]="48144:9628:4:1:1:::0:0:", -- Bonecaster's Spaulders
	[11873]="48309:9661:4:1:1:::0:0:", -- Ethereal Mist Cape
	[13868]="48328:9665:4:1:1:::0:0:", -- Frostweave Robe
	[8113]="48473:9694:4:1:1:::0:0:", -- Hibernal Robe
	[13869]="48513:9702:4:1:1:::0:0:", -- Frostweave Tunic
	[11677]="48563:9712:4:1:1:::0:0:", -- Graverot Cape
	[14103]="48582:9716:4:1:1:::0:0:", -- Brightcloth Cloak
	[15671]="48912:9782:4:1:1:::0:0:", -- Magnificent Cloak
	[10231]="49079:9815:4:1:1:::0:0:", -- Engraved Cape
	[14265]="49268:9853:4:1:1:::0:0:", -- Bloodwoven Wraps
	[14293]="49287:9857:4:1:1:::0:0:", -- Arachnidian Circlet
	[11908]="49434:9886:4:1:1:::0:0:", -- Archaeologist's Quarry Boots
	[14267]="49633:9926:4:1:1:::0:0:", -- Bloodwoven Jerkin
	[10251]="49731:9946:4:1:1:::0:0:", -- Master's Gloves
	[14333]="49937:9987:4:1:1:::0:0:", -- Eternal Gloves
	[14449]="50628:10125:4:1:1:::0:0:", -- Highborne Crown
	[14277]="50656:10131:4:1:1:::0:0:", -- Gaea's Tunic
	[10095]="51476:10295:4:1:1:::0:0:", -- Councillor's Boots
	[8106]="52194:10438:4:1:1:::0:0:", -- Hibernal Armor
	[12113]="52219:10443:4:1:1:::0:0:", -- Sunborne Cape
	[14274]="52244:10448:4:1:1:::0:0:", -- Gaea's Leggings
	[8304]="52565:10513:4:1:1:::0:0:", -- Hero's Cape
	[8284]="52570:10514:4:1:1:::0:0:", -- Arcane Boots
	[14042]="52808:10561:4:1:1:::0:0:", -- Cindercloth Vest
	[14813]="53007:10601:4:1:1:::0:0:", -- Warstrike Cape
	[10224]="53778:10755:4:1:1:::0:0:", -- Nightshade Cloak
	[17523]="53790:10758:4:1:1:::0:0:", -- Smokey's Drape
	[10064]="53874:10774:4:1:1:::0:0:", -- Duskwoven Pants
	[14111]="53875:10775:4:1:1:::0:0:", -- Felcloth Hood
	[14459]="53991:10798:4:1:1:::0:0:", -- Elunarian Cloak
	[13857]="54393:10878:4:1:1:::0:0:", -- Runecloth Tunic
	[13858]="54589:10917:4:1:1:::0:0:", -- Runecloth Robe
	[14444]="54775:10955:4:1:1:::0:0:", -- Venomshroud Leggings
	[10097]="54959:10991:4:1:1:::0:0:", -- Councillor's Circlet
	[12608]="55132:11026:4:1:1:::0:0:", -- Butcher's Apron
	[10212]="55348:11069:4:1:1:::0:0:", -- Elegant Cloak
	[10100]="55544:11108:4:1:1:::0:0:", -- Councillor's Shoulders
	[14108]="55560:11112:4:1:1:::0:0:", -- Felcloth Boots
	[14275]="55575:11115:4:1:1:::0:0:", -- Gaea's Raiment
	[12066]="55747:11149:4:1:1:::0:0:", -- Shaleskin Cape
	[18307]="55815:11163:4:1:1:::0:0:", -- Riptide Shoes
	[14316]="56355:11271:4:1:1:::0:0:", -- Celestial Pauldrons
	[9943]="56358:11271:4:1:1:::0:0:", -- Abjurer's Robe
	[10148]="56367:11273:4:1:1:::0:0:", -- Mighty Cloak
	[13866]="56794:11358:4:1:1:::0:0:", -- Runecloth Headband
	[18339]="56853:11370:4:1:1:::0:0:", -- Eidolon Cloak
	[9946]="56982:11396:4:1:1:::0:0:", -- Abjurer's Tunic
	[14319]="57007:11401:4:1:1:::0:0:", -- Resplendent Boots
	[15681]="57033:11406:4:1:1:::0:0:", -- Triumphant Cloak
	[10159]="57220:11444:4:1:1:::0:0:", -- Mercurial Cloak
	[8292]="57382:11476:4:1:1:::0:0:", -- Arcane Cover
	[15784]="57705:11541:4:1:1:::0:0:", -- Crystal Breeze Mantle
	[12109]="57845:11569:4:1:1:::0:0:", -- Azure Moon Amice
	[12110]="58054:11610:4:1:1:::0:0:", -- Raincaster Drape
	[14310]="58076:11615:4:1:1:::0:0:", -- Celestial Slippers
	[14283]="58233:11646:4:1:1:::0:0:", -- Opulent Leggings
	[14331]="58273:11654:4:1:1:::0:0:", -- Eternal Cloak
	[16008]="58696:11739:4:1:1:::0:0:", -- Master Engineer's Goggles
	[11822]="58973:11794:4:1:1:::0:0:", -- Omnicast Boots
	[15815]="59304:11860:4:1:1:::0:0:", -- Hameya's Cloak
	[8288]="59381:11876:4:1:1:::0:0:", -- Arcane Pads
	[14683]="59660:11932:4:1:1:::0:0:", -- Indomitable Cloak
	[14437]="60014:12002:4:1:1:::0:0:", -- Venomshroud Vest
	[10219]="60056:12011:4:1:1:::0:0:", -- Elegant Circlet
	[14307]="60323:12064:4:1:1:::0:0:", -- Bonecaster's Crown
	[8251]="60401:12080:4:1:1:::0:0:", -- Imperial Red Pants
	[14100]="60449:12089:4:1:1:::0:0:", -- Brightcloth Robe
	[10065]="60767:12153:4:1:1:::0:0:", -- Duskwoven Robe
	[10138]="61371:12274:4:1:1:::0:0:", -- High Councillor's Cloak
	[10211]="61383:12276:4:1:1:::0:0:", -- Elegant Boots
	[10258]="61461:12292:4:1:1:::0:0:", -- Adventurer's Cape
	[14445]="61765:12353:4:1:1:::0:0:", -- Venomshroud Silk Robes
	[11911]="61960:12392:4:1:1:::0:0:", -- Treetop Leggings
	[14132]="62206:12441:4:1:1:::0:0:", -- Wizardweave Leggings
	[13530]="62269:12453:4:1:1:::0:0:", -- Fangdrip Runners
	[18677]="62439:12487:4:1:1:::0:0:", -- Zephyr Cloak
	[11841]="62636:12527:4:1:1:::0:0:", -- Senior Designer's Pantaloons
	[13867]="62850:12570:4:1:1:::0:0:", -- Runecloth Shoulders
	[14458]="62867:12573:4:1:1:::0:0:", -- Elunarian Boots
	[10057]="63558:12711:4:1:1:::0:0:", -- Duskwoven Tunic
	[14130]="63843:12768:4:1:1:::0:0:", -- Wizardweave Turban
	[10177]="64165:12833:4:1:1:::0:0:", -- Mystical Leggings
	[10210]="64228:12845:4:1:1:::0:0:", -- Elegant Mantle
	[14141]="64296:12859:4:1:1:::0:0:", -- Ghostweave Vest
	[12185]="64477:12895:4:1:1:::0:0:", -- Bloodsail Admiral's Hat
	[8245]="64614:12922:4:1:1:::0:0:", -- Imperial Red Tunic
	[18350]="65319:13063:4:1:1:::0:0:", -- Amplifying Cloak
	[14284]="65678:13135:4:1:1:::0:0:", -- Opulent Robes
	[14107]="65704:13140:4:1:1:::0:0:", -- Felcloth Pants
	[14325]="66023:13204:4:1:1:::0:0:", -- Resplendent Epaulets
	[9649]="66146:13229:4:1:1:::0:0:", -- Royal Highmark Vestments
	[14295]="66184:13236:4:1:1:::0:0:", -- Arachnidian Legguards
	[13216]="66252:13250:4:1:1:::0:0:", -- Crown of the Penitent
	[14287]="66414:13282:4:1:1:::0:0:", -- Opulent Tunic
	[15437]="66506:13301:4:1:1:::0:0:", -- Supreme Cape
	[10267]="66689:13337:4:1:1:::0:0:", -- Masterwork Cape
	[10142]="67007:13401:4:1:1:::0:0:", -- High Councillor's Mantle
	[10249]="67179:13435:4:1:1:::0:0:", -- Master's Cloak
	[13871]="67183:13436:4:1:1:::0:0:", -- Frostweave Pants
	[14045]="67404:13480:4:1:1:::0:0:", -- Cindercloth Pants
	[10137]="67420:13484:4:1:1:::0:0:", -- High Councillor's Boots
	[14112]="67549:13509:4:1:1:::0:0:", -- Felcloth Shoulders
	[14312]="67708:13541:4:1:1:::0:0:", -- Celestial Crown
	[14631]="67714:13542:4:1:1:::0:0:", -- Necropile Boots
	[13865]="67775:13555:4:1:1:::0:0:", -- Runecloth Pants
	[14297]="67782:13556:4:1:1:::0:0:", -- Arachnidian Robes
	[8252]="68114:13622:4:1:1:::0:0:", -- Imperial Red Robe
	[12905]="68165:13633:4:1:1:::0:0:", -- Wildfire Cape
	[14633]="68197:13639:4:1:1:::0:0:", -- Necropile Mantle
	[15119]="68415:13683:4:1:1:::0:0:", -- Highborne Pants
	[14322]="68563:13712:4:1:1:::0:0:", -- Resplendent Circlet
	[14329]="70332:14066:4:1:1:::0:0:", -- Eternal Boots
	[14463]="70572:14114:4:1:1:::0:0:", -- Elunarian Spaulders
	[14288]="70662:14132:4:1:1:::0:0:", -- Arachnidian Armor
	[10139]="71291:14258:4:1:1:::0:0:", -- High Councillor's Circlet
	[14305]="71747:14349:4:1:1:::0:0:", -- Bonecaster's Sarong
	[14144]="71871:14374:4:1:1:::0:0:", -- Ghostweave Pants
	[10178]="72375:14475:4:1:1:::0:0:", -- Mystical Robe
	[10181]="73202:14640:4:1:1:::0:0:", -- Mystical Armor
	[14460]="73309:14661:4:1:1:::0:0:", -- Elunarian Diadem
	[10247]="73539:14707:4:1:1:::0:0:", -- Master's Boots
	[10250]="74331:14866:4:1:1:::0:0:", -- Master's Hat
	[10102]="75101:15020:4:1:1:::0:0:", -- Councillor's Robes
	[10253]="75123:15024:4:1:1:::0:0:", -- Master's Mantle
	[15824]="75307:15061:4:1:1:::0:0:", -- Astoria Robes
	[14335]="75432:15086:4:1:1:::0:0:", -- Eternal Spaulders
	[10104]="75686:15137:4:1:1:::0:0:", -- Councillor's Tunic
	[14104]="77420:15484:4:1:1:::0:0:", -- Brightcloth Pants
	[14332]="78373:15674:4:1:1:::0:0:", -- Eternal Crown
	[14453]="78386:15677:4:1:1:::0:0:", -- Highborne Robes
	[10101]="78781:15756:4:1:1:::0:0:", -- Councillor's Pants
	[14455]="78962:15792:4:1:1:::0:0:", -- Highborne Padded Armor
	[18450]="79073:15814:4:1:1:::0:0:", -- Robe of Combustion
	[14128]="80465:16093:4:1:1:::0:0:", -- Wizardweave Robe
	[14303]="81045:16209:4:1:1:::0:0:", -- Bonecaster's Shroud
	[18346]="81726:16345:4:1:1:::0:0:", -- Threadbare Trousers
	[14315]="82752:16550:4:1:1:::0:0:", -- Celestial Kilt
	[14317]="83165:16633:4:1:1:::0:0:", -- Celestial Silk Robes
	[8289]="83441:16688:4:1:1:::0:0:", -- Arcane Leggings
	[10217]="83444:16688:4:1:1:::0:0:", -- Elegant Leggings
	[14324]="83533:16706:4:1:1:::0:0:", -- Resplendent Sarong
	[13535]="84146:16829:4:1:1:::0:0:", -- Coldtouch Phantom Wraps
	[14306]="84154:16830:4:1:1:::0:0:", -- Bonecaster's Vest
	[8283]="85690:17138:4:1:1:::0:0:", -- Arcane Armor
	[10215]="86939:17387:4:1:1:::0:0:", -- Elegant Robes
	[8290]="87927:17585:4:1:1:::0:0:", -- Arcane Robe
	[10218]="87945:17589:4:1:1:::0:0:", -- Elegant Tunic
	[14308]="88997:17799:4:1:1:::0:0:", -- Celestial Tunic
	[14106]="90268:18053:4:1:1:::0:0:", -- Felcloth Robe
	[14632]="90608:18121:4:1:1:::0:0:", -- Necropile Leggings
	[14318]="92044:18408:4:1:1:::0:0:", -- Resplendent Tunic
	[14462]="93758:18751:4:1:1:::0:0:", -- Elunarian Sarong
	[14326]="97399:19479:4:1:1:::0:0:", -- Resplendent Robes
	[13203]="97492:19498:4:1:1:::0:0:", -- Armswake Cloak
	[10143]="98864:19772:4:1:1:::0:0:", -- High Councillor's Robe
	[14334]="100221:20044:4:1:1:::0:0:", -- Eternal Sarong
	[10141]="100518:20103:4:1:1:::0:0:", -- High Councillor's Pants
	[14336]="100686:20137:4:1:1:::0:0:", -- Eternal Wraps
	[10135]="103318:20663:4:1:1:::0:0:", -- High Councillor's Tunic
	[10252]="104799:20959:4:1:1:::0:0:", -- Master's Leggings
	[10246]="107712:21542:4:1:1:::0:0:", -- Master's Vest
	[10254]="110823:22164:4:1:1:::0:0:", -- Master's Robe
	[12977]="1776:355:4:1:1:::0:0:", -- Magefist Gloves
	[1974]="2320:464:4:1:1:::0:0:", -- Mindthrust Bracers
	[2911]="2623:524:4:1:1:::0:0:", -- Keller's Girdle
	[12979]="3086:617:4:1:1:::0:0:", -- Firebane Cloak
	[6449]="3509:701:4:1:1:::0:0:", -- Glowing Lizardscale Cloak
	[16975]="4067:813:4:1:1:::0:0:", -- Warsong Sash
	[2059]="4318:863:4:1:1:::0:0:", -- Sentry Cloak
	[12987]="4533:906:4:1:1:::0:0:", -- Darkweave Breeches
	[5193]="4700:940:4:1:1:::0:0:", -- Cape of the Brotherhood
	[4320]="4897:979:4:1:1:::0:0:", -- Spidersilk Boots
	[6392]="5003:1000:4:1:1:::0:0:", -- Belt of Arugal
	[12998]="5103:1020:4:1:1:::0:0:", -- Magician's Mantle
	[5202]="5737:1147:4:1:1:::0:0:", -- Corsair's Overshirt
	[6461]="5954:1190:4:1:1:::0:0:", -- Slime-encrusted Pads
	[1486]="6012:1202:4:1:1:::0:0:", -- Tree Bark Jacket
	[13106]="6081:1216:4:1:1:::0:0:", -- Glowing Magical Bracelets
	[18440]="6443:1288:4:1:1:::1:0:635", -- Sergeant's Cape
	[3748]="6524:1304:4:1:1:::0:0:", -- Feline Mantle
	[9491]="6542:1308:4:1:1:::0:0:", -- Hotshot Pilot's Gloves
	[18427]="6611:1322:4:1:1:::1:0:135,140,144,245,275,349,432,453,480,498,708,741,822,859", -- Sergeant's Cloak
	[13005]="6657:1331:4:1:1:::0:0:", -- Amy's Blanket
	[2292]="6673:1334:4:1:1:::0:0:", -- Necrology Robes
	[13099]="7155:1431:4:1:1:::0:0:", -- Moccasins of the White Hare
	[6901]="7615:1523:4:1:1:::0:0:", -- Glowing Thresher Cape
	[2800]="7625:1525:4:1:1:::0:0:", -- Black Velvet Robes
	[9395]="7828:1565:4:1:1:::0:0:", -- Gloves of Old
	[6324]="9463:1892:4:1:1:::0:0:", -- Robes of Arugal
	[2721]="9914:1982:4:1:1:::0:0:", -- Holy Shroud
	[9454]="9923:1984:4:1:1:::0:0:", -- Acidic Walkers
	[6697]="10208:2041:4:1:1:::0:0:", -- Batwing Mantle
	[19529]="10613:2122:4:1:1:::1:0:461", -- Battle Healer's Cloak
	[13105]="10737:2147:4:1:1:::0:0:", -- Sutarn's Ring
	[19533]="10772:2154:4:1:1:::1:0:353", -- Caretaker's Cape
	[6910]="11492:2298:4:1:1:::0:0:", -- Leech Pants
	[9508]="11762:2352:4:1:1:::0:0:", -- Mechbuilder's Overalls
	[13108]="12231:2446:4:1:1:::0:0:", -- Tigerstrike Mantle
	[18457]="13373:2674:4:1:1:::1:0:635", -- Sergeant Major's Silk Cuffs
	[7691]="13445:2689:4:1:1:::0:0:", -- Embalmed Shroud
	[18437]="13721:2744:4:1:1:::1:0:708", -- First Sergeant's Silk Cuffs
	[4197]="13828:2765:4:1:1:::0:0:", -- Berylline Pads
	[10771]="14552:2910:4:1:1:::0:0:", -- Deathmage Sash
	[5257]="15799:3159:4:1:1:::0:0:", -- Dark Hooded Cape
	[9492]="15862:3172:4:1:1:::0:0:", -- Electromagnetic Gigaflux Reactivator
	[7728]="16118:3223:4:1:1:::0:0:", -- Beguiler Robes
	[10578]="16885:3377:4:1:1:::0:0:", -- Thoughtcast Boots
	[13121]="17142:3428:4:1:1:::0:0:", -- Wing of the Whelpling
	[13103]="17268:3453:4:1:1:::0:0:", -- Pads of the Venom Spider
	[7709]="17797:3559:4:1:1:::0:0:", -- Blighted Leggings
	[2277]="18104:3620:4:1:1:::0:0:", -- Necromancer Leggings
	[9397]="18364:3672:4:1:1:::0:0:", -- Energy Cloak
	[10574]="18878:3775:4:1:1:::0:0:", -- Corpseshroud
	[4327]="18941:3788:4:1:1:::0:0:", -- Icy Cloak
	[10019]="19721:3944:4:1:1:::0:0:", -- Dreamweave Gloves
	[9433]="20669:4133:4:1:1:::0:0:", -- Forgotten Wraps
	[18441]="20891:4178:4:1:1:::1:0:635", -- Sergeant's Cape
	[9623]="20992:4198:4:1:1:::0:0:", -- Civinad Robes
	[16341]="21425:4285:4:1:1:::1:0:135,140,144,245,275,349,432,453,480,498,708,741,822,859", -- Sergeant's Cloak
	[18083]="22613:4522:4:1:1:::0:0:", -- Jumanza Grips
	[6900]="23427:4685:4:1:1:::0:0:", -- Enchanted Gold Bloodrobe
	[7054]="23504:4700:4:1:1:::0:0:", -- Robe of Power
	[19528]="23904:4780:4:1:1:::1:0:461", -- Battle Healer's Cloak
	[10776]="23999:4799:4:1:1:::0:0:", -- Silky Spider Cape
	[9431]="24426:4885:4:1:1:::0:0:", -- Papal Fez
	[1716]="25335:5067:4:1:1:::0:0:", -- Robe of the Magi
	[9407]="25470:5094:4:1:1:::0:0:", -- Stoneweaver Leggings
	[9429]="26184:5236:4:1:1:::0:0:", -- Miner's Hat of the Deep
	[10581]="26553:5310:4:1:1:::0:0:", -- Death's Head Vestment
	[7720]="26783:5356:4:1:1:::0:0:", -- Whitemane's Chapeau
	[13100]="27107:5421:4:1:1:::0:0:", -- Furen's Boots
	[18456]="28065:5613:4:1:1:::1:0:635", -- Sergeant Major's Silk Cuffs
	[9434]="28240:5648:4:1:1:::0:0:", -- Elemental Raiment
	[16391]="28261:5652:4:1:1:::0:0:", -- Knight-Lieutenant's Silk Gloves
	[16486]="28477:5695:4:1:1:::1:0:708", -- First Sergeant's Silk Cuffs
	[17596]="28480:5696:4:1:1:::0:0:", -- Knight-Lieutenant's Satin Gloves
	[16487]="28584:5716:4:1:1:::0:0:", -- Blood Guard's Silk Gloves
	[17577]="28589:5717:4:1:1:::0:0:", -- Blood Guard's Dreadweave Gloves
	[18709]="28794:5758:4:1:1:::0:0:", -- Arena Wristguards
	[17755]="29093:5818:4:1:1:::0:0:", -- Satyrmane Sash
	[17564]="29332:5866:4:1:1:::0:0:", -- Knight-Lieutenant's Dreadweave Gloves
	[17617]="29344:5868:4:1:1:::0:0:", -- Blood Guard's Satin Gloves
	[9512]="31705:6341:4:1:1:::0:0:", -- Blackmetal Cape
	[10787]="31914:6382:4:1:1:::0:0:", -- Atal'ai Gloves
	[11310]="32990:6598:4:1:1:::0:0:", -- Flameseer Mantle
	[12466]="34327:6865:4:1:1:::0:0:", -- Dawnspire Cord
	[13144]="34327:6865:4:1:1:::0:0:", -- Serenity Belt
	[13102]="34399:6879:4:1:1:::0:0:", -- Cassandra's Grace
	[10762]="34519:6903:4:1:1:::0:0:", -- Robes of the Lich
	[12546]="37316:7463:4:1:1:::0:0:", -- Aristocratic Cuffs
	[10808]="38146:7629:4:1:1:::0:0:", -- Gloves of the Atal'ai Prophet
	[10504]="38852:7770:4:1:1:::0:0:", -- Green Lens
	[9470]="39292:7858:4:1:1:::0:0:", -- Bad Mojo Mask
	[11962]="39699:7939:4:1:1:::0:0:", -- Manacle Cuffs
	[10021]="39731:7946:4:1:1:::0:0:", -- Dreamweave Vest
	[10629]="40330:8066:4:1:1:::0:0:", -- Mistwalker Boots
	[13409]="40596:8119:4:1:1:::0:0:", -- Tearfall Bracers
	[16703]="40690:8138:4:1:1:::0:0:", -- Dreadmist Bracers
	[13109]="40762:8152:4:1:1:::0:0:", -- Blackflame Cape
	[17569]="41614:8322:4:1:1:::0:0:", -- Lieutenant Commander's Dreadweave Mantle
	[17610]="41761:8352:4:1:1:::0:0:", -- Champion's Satin Cowl
	[17570]="41774:8354:4:1:1:::0:0:", -- Champion's Dreadweave Hood
	[16369]="42081:8416:4:1:1:::0:0:", -- Knight-Lieutenant's Silk Boots
	[17613]="42236:8447:4:1:1:::0:0:", -- Champion's Satin Shoulderpads
	[17573]="42249:8449:4:1:1:::0:0:", -- Champion's Dreadweave Shoulders
	[17594]="42405:8481:4:1:1:::0:0:", -- Knight-Lieutenant's Satin Boots
	[16485]="42556:8511:4:1:1:::0:0:", -- Blood Guard's Silk Footwraps
	[17576]="42724:8544:4:1:1:::0:0:", -- Blood Guard's Dreadweave Boots
	[16697]="42886:8577:4:1:1:::0:0:", -- Devout Bracers
	[18461]="42888:8577:4:1:1:::1:0:135,140,144,245,275,349,432,453,480,498,708,741,822,859", -- Sergeant's Cloak
	[19121]="42929:8585:4:1:1:::0:0:", -- Deep Woodlands Cloak
	[16702]="42964:8592:4:1:1:::0:0:", -- Dreadmist Belt
	[11766]="43031:8606:4:1:1:::0:0:", -- Flameweave Cuffs
	[17598]="43035:8607:4:1:1:::0:0:", -- Lieutenant Commander's Diadem
	[16489]="43191:8638:4:1:1:::0:0:", -- Champion's Silk Hood
	[10630]="43320:8664:4:1:1:::0:0:", -- Soulcatcher Halo
	[16685]="43470:8694:4:1:1:::0:0:", -- Magister's Belt
	[17562]="43683:8736:4:1:1:::0:0:", -- Knight-Lieutenant's Dreadweave Boots
	[16683]="43827:8765:4:1:1:::0:0:", -- Magister's Bindings
	[17616]="43860:8772:4:1:1:::0:0:", -- Blood Guard's Satin Boots
	[13181]="43988:8797:4:1:1:::0:0:", -- Demonskin Gloves
	[16342]="44154:8830:4:1:1:::1:0:635", -- Sergeant's Cape
	[16415]="44167:8833:4:1:1:::0:0:", -- Lieutenant Commander's Silk Spaulders
	[17566]="44318:8863:4:1:1:::0:0:", -- Lieutenant Commander's Headguard
	[16416]="44322:8864:4:1:1:::0:0:", -- Lieutenant Commander's Crown
	[17601]="44659:8931:4:1:1:::0:0:", -- Lieutenant Commander's Satin Amice
	[16492]="44810:8962:4:1:1:::0:0:", -- Champion's Silk Shoulderpads
	[9415]="44986:8997:4:1:1:::0:0:", -- Grimlok's Tribal Vestments
	[16696]="45292:9058:4:1:1:::0:0:", -- Devout Belt
	[16684]="45468:9093:4:1:1:::0:0:", -- Magister's Gloves
	[17739]="45504:9100:4:1:1:::0:0:", -- Grovekeeper's Drape
	[17748]="45539:9107:4:1:1:::0:0:", -- Vinerot Sandals
	[16705]="45639:9127:4:1:1:::0:0:", -- Dreadmist Wraps
	[11807]="45766:9153:4:1:1:::0:0:", -- Sash of the Burning Heart
	[12626]="45956:9191:4:1:1:::0:0:", -- Funeral Cuffs
	[19047]="46164:9232:4:1:1:::0:0:", -- Wisdom of the Timbermaw
	[16692]="46861:9372:4:1:1:::0:0:", -- Devout Gloves
	[18327]="46880:9376:4:1:1:::0:0:", -- Whipvine Cord
	[13403]="47008:9401:4:1:1:::0:0:", -- Grimgore Noose
	[12554]="47373:9474:4:1:1:::0:0:", -- Hands of the Exalted Herald
	[18387]="47443:9488:4:1:1:::0:0:", -- Brightspark Gloves
	[19094]="47443:9488:4:1:1:::1:0:224,774", -- Stormpike Cloth Girdle
	[18497]="47443:9488:4:1:1:::0:0:", -- Sublime Wristguards
	[13958]="47528:9505:4:1:1:::0:0:", -- Wyrmthalak's Shackles
	[19527]="48159:9631:4:1:1:::1:0:461", -- Battle Healer's Cloak
	[18369]="49577:9915:4:1:1:::0:0:", -- Gordok's Handwraps
	[13253]="49916:9983:4:1:1:::0:0:", -- Hands of Power
	[18740]="50505:10101:4:1:1:::0:0:", -- Thuzadin Sash
	[17715]="51128:10225:4:1:1:::0:0:", -- Eye of Theradras
	[18730]="51254:10250:4:1:1:::0:0:", -- Shadowy Laced Handwraps
	[12589]="51257:10251:4:1:1:::0:0:", -- Dustfeather Sash
	[12465]="51309:10261:4:1:1:::0:0:", -- Nightfall Drape
	[19090]="51428:10285:4:1:1:::1:0:287,416", -- Frostwolf Cloth Belt
	[17732]="51916:10383:4:1:1:::0:0:", -- Rotgrip Mantle
	[14543]="52394:10478:4:1:1:::0:0:", -- Darkshade Gloves
	[10843]="52977:10595:4:1:1:::0:0:", -- Featherskin Cape
	[10751]="53170:10634:4:1:1:::0:0:", -- Gemburst Circlet
	[18697]="54339:10867:4:1:1:::0:0:", -- Coldstone Slippers
	[13956]="54751:10950:4:1:1:::0:0:", -- Clutch of Andros
	[9484]="54811:10962:4:1:1:::0:0:", -- Spellshock Leggings
	[12552]="54901:10980:4:1:1:::0:0:", -- Blisterbane Wrap
	[17568]="55273:11054:4:1:1:::0:0:", -- Knight-Captain's Dreadweave Robe
	[18407]="55696:11139:4:1:1:::0:0:", -- Felcloth Gloves
	[18408]="55893:11178:4:1:1:::0:0:", -- Inferno Gloves
	[17611]="55895:11179:4:1:1:::0:0:", -- Legionnaire's Satin Trousers
	[17571]="55912:11182:4:1:1:::0:0:", -- Legionnaire's Dreadweave Leggings
	[11839]="55958:11191:4:1:1:::0:0:", -- Chief Architect's Monocle
	[18409]="56096:11219:4:1:1:::0:0:", -- Mooncloth Gloves
	[17612]="56108:11221:4:1:1:::0:0:", -- Legionnaire's Satin Vestments
	[17572]="56119:11223:4:1:1:::0:0:", -- Legionnaire's Dreadweave Robe
	[14134]="56401:11280:4:1:1:::0:0:", -- Cloak of Fire
	[13107]="56457:11291:4:1:1:::0:0:", -- Magiskull Cuffs
	[18693]="57127:11425:4:1:1:::0:0:", -- Shivery Handwraps
	[17741]="57238:11447:4:1:1:::0:0:", -- Nature's Embrace
	[13122]="57447:11489:4:1:1:::0:0:", -- Dark Phantom Cape
	[17599]="57594:11518:4:1:1:::0:0:", -- Knight-Captain's Satin Leggings
	[16490]="57801:11560:4:1:1:::0:0:", -- Legionnaire's Silk Pants
	[18295]="57913:11582:4:1:1:::0:0:", -- Phasing Boots
	[12551]="57972:11594:4:1:1:::0:0:", -- Stoneshield Cloak
	[15802]="58243:11648:4:1:1:::0:0:", -- Mooncloth Boots
	[16413]="58463:11692:4:1:1:::0:0:", -- Knight-Captain's Silk Raiment
	[16414]="58676:11735:4:1:1:::0:0:", -- Knight-Captain's Silk Leggings
	[17567]="59304:11860:4:1:1:::0:0:", -- Knight-Captain's Dreadweave Leggings
	[17600]="59333:11866:4:1:1:::0:0:", -- Knight-Captain's Satin Robes
	[16491]="59534:11906:4:1:1:::0:0:", -- Legionnaire's Silk Robes
	[13013]="61778:12355:4:1:1:::0:0:", -- Elder Wizard's Mantle
	[12542]="61781:12356:4:1:1:::0:0:", -- Funeral Pyre Vestment
	[17050]="62683:12536:4:1:1:::0:0:", -- Chan's Imperial Robes
	[11782]="63602:12720:4:1:1:::0:0:", -- Boreal Mantle
	[13008]="64076:12815:4:1:1:::0:0:", -- Dalewind Trousers
	[19056]="64705:12941:4:1:1:::0:0:", -- Argent Boots
	[18743]="67777:13555:4:1:1:::0:0:", -- Gracious Cape
	[13007]="67926:13585:4:1:1:::0:0:", -- Mageflame Cloak
	[16704]="68196:13639:4:1:1:::0:0:", -- Dreadmist Sandals
	[13282]="68423:13684:4:1:1:::0:0:", -- Ogreseer Tower Boots
	[13376]="68693:13738:4:1:1:::0:0:", -- Royal Tribunal Cloak
	[11812]="69895:13979:4:1:1:::0:0:", -- Cape of the Fire Salamander
	[16691]="70029:14005:4:1:1:::0:0:", -- Devout Sandals
	[18328]="70583:14116:4:1:1:::0:0:", -- Shadewood Cloak
	[18496]="71165:14233:4:1:1:::0:0:", -- Heliotrope Cloak
	[13374]="71576:14315:4:1:1:::0:0:", -- Soulstealer Mantle
	[12556]="71585:14317:4:1:1:::0:0:", -- High Priestess Boots
	[13101]="71592:14318:4:1:1:::0:0:", -- Wolfrunner Shoes
	[12604]="71844:14368:4:1:1:::0:0:", -- Starfire Tiara
	[18727]="72438:14487:4:1:1:::0:0:", -- Crimson Felt Hat
	[16682]="72914:14582:4:1:1:::0:0:", -- Magister's Boots
	[11930]="72941:14588:4:1:1:::0:0:", -- The Emperor's New Cape
	[16689]="72986:14597:4:1:1:::0:0:", -- Magister's Mantle
	[16695]="74627:14925:4:1:1:::0:0:", -- Devout Mantle
	[11123]="75186:15037:4:1:1:::0:0:", -- Rainstrider Leggings
	[19083]="75224:15044:4:1:1:::1:0:287,416", -- Frostwolf Legionnaire's Cloak
	[19084]="75500:15100:4:1:1:::1:0:224,774", -- Stormpike Soldier's Cloak
	[10806]="75731:15146:4:1:1:::0:0:", -- Vestments of the Atal'ai Prophet
	[19085]="75776:15155:4:1:1:::1:0:287,416", -- Frostwolf Advisor's Cloak
	[15138]="75993:15198:4:1:1:::0:0:", -- Onyxia Scale Cloak
	[13397]="76008:15201:4:1:1:::0:0:", -- Stoneskin Gargoyle Cape
	[10807]="76012:15202:4:1:1:::0:0:", -- Kilt of the Atal'ai Prophet
	[19086]="76045:15209:4:1:1:::1:0:224,774", -- Stormpike Sage's Cloak
	[18681]="76079:15215:4:1:1:::0:0:", -- Burial Shawl
	[16701]="78254:15650:4:1:1:::0:0:", -- Dreadmist Mantle
	[18507]="78460:15692:4:1:1:::0:0:", -- Boots of the Full Moon
	[13386]="78610:15722:4:1:1:::0:0:", -- Archivist Cape
	[14139]="79204:15840:4:1:1:::0:0:", -- Mooncloth Shoulders
	[16686]="79562:15912:4:1:1:::0:0:", -- Magister's Crown
	[18382]="79858:15971:4:1:1:::0:0:", -- Fluctuating Cloak
	[18757]="80813:16162:4:1:1:::0:0:", -- Diabolic Mantle
	[18745]="81194:16238:4:1:1:::0:0:", -- Sacred Cloth Leggings
	[16693]="81676:16335:4:1:1:::0:0:", -- Devout Crown
	[13390]="81837:16367:4:1:1:::0:0:", -- The Postmaster's Band
	[13185]="82111:16422:4:1:1:::0:0:", -- Sunderseer Mantle
	[13391]="82127:16425:4:1:1:::0:0:", -- The Postmaster's Treads
	[18689]="82301:16460:4:1:1:::0:0:", -- Phantasmal Cloak
	[19105]="82383:16476:4:1:1:::0:0:", -- Frost Runed Headdress
	[13340]="82494:16498:4:1:1:::0:0:", -- Cape of the Black Baron
	[11929]="82905:16581:4:1:1:::0:0:", -- Haunting Specter Leggings
	[16698]="83182:16636:4:1:1:::0:0:", -- Dreadmist Mask
	[14140]="83469:16693:4:1:1:::0:0:", -- Mooncloth Circlet
	[18720]="83532:16706:4:1:1:::0:0:", -- Shroud of the Nathrezim
	[18495]="83851:16770:4:1:1:::0:0:", -- Redoubt Cloak
	[18389]="84152:16830:4:1:1:::0:0:", -- Cloak of the Cosmos
	[12967]="84420:16884:4:1:1:::0:0:", -- Bloodmoon Cloak
	[12968]="84740:16948:4:1:1:::0:0:", -- Frostweaver Cape
	[14136]="85127:17025:4:1:1:::0:0:", -- Robe of Winter Night
	[14538]="85312:17062:4:1:1:::0:0:", -- Deadwalker Mantle
	[18413]="85353:17070:4:1:1:::0:0:", -- Cloak of Warding
	[19530]="85492:17098:4:1:1:::1:0:353", -- Caretaker's Cape
	[18102]="85794:17158:4:1:1:::0:0:", -- Dragonrider Boots
	[18734]="85970:17194:4:1:1:::0:0:", -- Pale Moon Cloak
	[18735]="86266:17253:4:1:1:::0:0:", -- Maleki's Footwraps
	[13986]="87349:17469:4:1:1:::0:0:", -- Crown of Caer Darrow
	[13369]="87634:17526:4:1:1:::0:0:", -- Fire Striders
	[19059]="87708:17541:4:1:1:::0:0:", -- Argent Shoulders
	[15421]="89275:17855:4:1:1:::0:0:", -- Shroud of the Exile
	[18526]="89621:17924:4:1:1:::0:0:", -- Crown of the Ogre King
	[14137]="90567:18113:4:1:1:::0:0:", -- Mooncloth Leggings
	[19526]="90580:18116:4:1:1:::1:0:461", -- Battle Healer's Cloak
	[13170]="96151:19230:4:1:1:::0:0:", -- Skyshroud Leggings
	[13206]="99402:19880:4:1:1:::0:0:", -- Wolfshear Leggings
	[14138]="100210:20042:4:1:1:::0:0:", -- Mooncloth Vest
	[16687]="101407:20281:4:1:1:::0:0:", -- Magister's Leggings
	[11924]="102378:20475:4:1:1:::0:0:", -- Robes of the Royal Crown
	[18386]="102943:20588:4:1:1:::0:0:", -- Padre's Trousers
	[14626]="103664:20732:4:1:1:::0:0:", -- Necropile Robe
	[16694]="104102:20820:4:1:1:::0:0:", -- Devout Skirt
	[13388]="105586:21117:4:1:1:::0:0:", -- The Postmaster's Tunic
	[16699]="106014:21202:4:1:1:::0:0:", -- Dreadmist Leggings
	[18385]="107684:21536:4:1:1:::0:0:", -- Robe of Everlasting Night
	[14577]="107926:21585:4:1:1:::0:0:", -- Skullsmoke Pants
	[18532]="108145:21629:4:1:1:::0:0:", -- Mindsurge Robe
	[18486]="108417:21683:4:1:1:::0:0:", -- Mooncloth Robe
	[13389]="108730:21746:4:1:1:::0:0:", -- The Postmaster's Trousers
	[14340]="108891:21778:4:1:1:::0:0:", -- Freezing Lich Robes
	[12965]="111721:22344:4:1:1:::0:0:", -- Spiritshroud Leggings
	[16688]="112228:22445:4:1:1:::0:0:", -- Magister's Robes
	[16690]="113080:22616:4:1:1:::0:0:", -- Devout Robe
	[13346]="115591:23118:4:1:1:::0:0:", -- Robes of the Exalted
	[16700]="120358:24071:4:1:1:::0:0:", -- Dreadmist Robe
	[17608]="40617:8123:4:1:1:::0:0:", -- Marshal's Satin Gloves
	[17588]="40621:8124:4:1:1:::0:0:", -- General's Dreadweave Gloves
	[16540]="42031:8406:4:1:1:::0:0:", -- General's Silk Handguards
	[17620]="43605:8721:4:1:1:::0:0:", -- General's Satin Gloves
	[16440]="44054:8810:4:1:1:::0:0:", -- Marshal's Silk Gloves
	[17584]="44236:8847:4:1:1:::0:0:", -- Marshal's Dreadweave Gloves
	[16536]="60437:12087:4:1:1:::0:0:", -- Warlord's Silk Amice
	[17586]="60469:12093:4:1:1:::0:0:", -- General's Dreadweave Boots
	[17607]="60691:12138:4:1:1:::0:0:", -- Marshal's Satin Sandals
	[17590]="61402:12280:4:1:1:::0:0:", -- Warlord's Dreadweave Mantle
	[17591]="61631:12326:4:1:1:::0:0:", -- Warlord's Dreadweave Hood
	[16444]="62342:12468:4:1:1:::0:0:", -- Field Marshal's Silk Spaulders
	[16539]="62818:12563:4:1:1:::0:0:", -- General's Silk Boots
	[940]="62829:12565:4:1:1:::0:0:", -- Robes of Insight
	[17578]="63275:12655:4:1:1:::0:0:", -- Field Marshal's Coronal
	[17580]="63738:12747:4:1:1:::0:0:", -- Field Marshal's Dreadweave Shoulders
	[17583]="64437:12887:4:1:1:::0:0:", -- Marshal's Dreadweave Boots
	[17618]="64938:12987:4:1:1:::0:0:", -- General's Satin Boots
	[16437]="65383:13076:4:1:1:::0:0:", -- Marshal's Silk Footwraps
	[17622]="65871:13174:4:1:1:::0:0:", -- Warlord's Satin Mantle
	[17602]="65878:13175:4:1:1:::0:0:", -- Field Marshal's Headdress
	[16533]="66087:13217:4:1:1:::0:0:", -- Warlord's Silk Cowl
	[17623]="66106:13221:4:1:1:::0:0:", -- Warlord's Satin Cowl
	[16441]="66316:13263:4:1:1:::0:0:", -- Field Marshal's Coronet
	[17604]="66347:13269:4:1:1:::0:0:", -- Field Marshal's Satin Mantle
	[14146]="70421:14084:4:1:1:::0:0:", -- Gloves of Spell Mastery
	[18405]="73720:14744:4:1:1:::0:0:", -- Belt of the Archmage
	[16979]="74509:14901:4:1:1:::0:0:", -- Flarecore Gloves
	[3075]="75368:15073:4:1:1:::0:0:", -- Eye of Flame
	[17592]="82487:16497:4:1:1:::0:0:", -- Warlord's Dreadweave Robe
	[17593]="82801:16560:4:1:1:::0:0:", -- General's Dreadweave Pants
	[16443]="82809:16561:4:1:1:::0:0:", -- Field Marshal's Silk Vestments
	[18263]="84557:16911:4:1:1:::0:0:", -- Flarecore Wraps
	[17579]="84680:16936:4:1:1:::0:0:", -- Marshal's Dreadweave Leggings
	[19135]="84772:16954:4:1:1:::0:0:", -- Blacklight Bracer
	[16817]="85296:17059:4:1:1:::0:0:", -- Girdle of Prophecy
	[17581]="85298:17059:4:1:1:::0:0:", -- Field Marshal's Dreadweave Robe
	[16819]="85945:17189:4:1:1:::0:0:", -- Vambraces of Prophecy
	[16799]="85963:17192:4:1:1:::0:0:", -- Arcanist Bindings
	[16801]="86612:17322:4:1:1:::0:0:", -- Arcanist Gloves
	[16802]="86941:17388:4:1:1:::0:0:", -- Arcanist Belt
	[19595]="87549:17509:4:1:1:::1:0:353", -- Dryad's Wrist Bindings
	[16804]="87589:17517:4:1:1:::0:0:", -- Felheart Bracers
	[16805]="87918:17583:4:1:1:::0:0:", -- Felheart Gloves
	[17603]="88150:17630:4:1:1:::0:0:", -- Marshal's Satin Pants
	[16806]="88247:17649:4:1:1:::0:0:", -- Felheart Belt
	[16534]="88430:17686:4:1:1:::0:0:", -- General's Silk Trousers
	[17624]="88455:17691:4:1:1:::0:0:", -- Warlord's Satin Robes
	[16442]="88726:17745:4:1:1:::0:0:", -- Marshal's Silk Leggings
	[16535]="88743:17748:4:1:1:::0:0:", -- Warlord's Silk Raiment
	[17625]="88760:17752:4:1:1:::0:0:", -- General's Satin Leggings
	[17605]="88777:17755:4:1:1:::0:0:", -- Field Marshal's Satin Vestments
	[16812]="90203:18040:4:1:1:::0:0:", -- Gloves of Prophecy
	[11808]="96460:19292:4:1:1:::0:0:", -- Circle of Flame
	[12462]="101370:20274:4:1:1:::0:0:", -- Embrace of the Wind Serpent
	[18510]="104449:20889:4:1:1:::0:0:", -- Hide of the Wild
	[18511]="104855:20971:4:1:1:::0:0:", -- Shifting Cloak
	[16980]="106829:21365:4:1:1:::0:0:", -- Flarecore Mantle
	[18809]="108057:21611:4:1:1:::0:0:", -- Sash of Whispered Secrets
	[19136]="111403:22280:4:1:1:::0:0:", -- Mana Igniting Cord
	[18808]="113326:22665:4:1:1:::0:0:", -- Gloves of the Hypnotic Flame
	[12752]="114539:22907:4:1:1:::0:0:", -- Cap of the Scarlet Savant
	[18509]="115033:23006:4:1:1:::0:0:", -- Chromatic Cloak
	[16816]="127452:25490:4:1:1:::0:0:", -- Mantle of Prophecy
	[16797]="127958:25591:4:1:1:::0:0:", -- Arcanist Mantle
	[19369]="129350:25870:4:1:1:::0:0:", -- Gloves of Rapid Evolution
	[16800]="129425:25885:4:1:1:::0:0:", -- Arcanist Boots
	[3475]="130092:26018:4:1:1:::0:0:", -- Cloak of Flames
	[16803]="130905:26181:4:1:1:::0:0:", -- Felheart Slippers
	[19374]="131344:26268:4:1:1:::0:0:", -- Bracers of Arcane Accuracy
	[16807]="132864:26572:4:1:1:::0:0:", -- Felheart Shoulder Pads
	[16808]="133344:26668:4:1:1:::0:0:", -- Felheart Horns
	[16811]="134811:26962:4:1:1:::0:0:", -- Boots of Prophecy
	[16795]="136797:27359:4:1:1:::0:0:", -- Arcanist Crown
	[18204]="136851:27370:4:1:1:::0:0:", -- Eskhandar's Pelt
	[16928]="137868:27573:4:1:1:::0:0:", -- Nemesis Gloves
	[19400]="138017:27603:4:1:1:::0:0:", -- Firemaw's Clutch
	[16813]="139330:27866:4:1:1:::0:0:", -- Circlet of Prophecy
	[16818]="139475:27895:4:1:1:::0:0:", -- Netherwind Belt
	[16933]="140532:28106:4:1:1:::0:0:", -- Nemesis Belt
	[16913]="140546:28109:4:1:1:::0:0:", -- Netherwind Gloves
	[16934]="141067:28213:4:1:1:::0:0:", -- Nemesis Bracers
	[19407]="141561:28312:4:1:1:::0:0:", -- Ebony Flame Gloves
	[19132]="142191:28438:4:1:1:::0:0:", -- Crystal Adorned Crown
	[16918]="143210:28642:4:1:1:::0:0:", -- Netherwind Bindings
	[14152]="144076:28815:4:1:1:::0:0:", -- Robe of the Archmage
	[16920]="144281:28856:4:1:1:::0:0:", -- Handguards of Transcendence
	[14153]="144603:28920:4:1:1:::0:0:", -- Robe of the Void
	[14154]="145144:29028:4:1:1:::0:0:", -- Truefaith Vestments
	[18208]="145737:29147:4:1:1:::0:0:", -- Drape of Benediction
	[19131]="148730:29746:4:1:1:::0:0:", -- Snowblind Shoes
	[16925]="150767:30153:4:1:1:::0:0:", -- Belt of Transcendence
	[13314]="151110:30222:4:1:1:::0:0:", -- Alanna's Embrace
	[16926]="151303:30260:4:1:1:::0:0:", -- Bindings of Transcendence
	[18872]="151971:30394:4:1:1:::0:0:", -- Manastorm Leggings
	[19388]="156649:31329:4:1:1:::0:0:", -- Angelista's Grasp
	[19436]="159780:31956:4:1:1:::0:0:", -- Cloak of Draconic Might
	[18811]="163328:32665:4:1:1:::0:0:", -- Fireproof Cloak
	[18541]="165144:33028:4:1:1:::0:0:", -- Puissant Cape
	[19438]="169028:33805:4:1:1:::0:0:", -- Ringo's Blizzard Boots
	[16815]="169278:33855:4:1:1:::0:0:", -- Robes of Prophecy
	[16796]="169953:33990:4:1:1:::0:0:", -- Arcanist Leggings
	[16798]="171269:34253:4:1:1:::0:0:", -- Arcanist Robes
	[19156]="174557:34911:4:1:1:::0:0:", -- Flarecore Robe
	[16809]="178450:35690:4:1:1:::0:0:", -- Felheart Robes
	[16810]="179108:35821:4:1:1:::0:0:", -- Felheart Pants
	[19145]="185169:37033:4:1:1:::0:0:", -- Robe of Volatile Power
	[17078]="186019:37203:4:1:1:::0:0:", -- Sapphiron Drape
	[16814]="186432:37286:4:1:1:::0:0:", -- Pants of Prophecy
	[17107]="187685:37537:4:1:1:::0:0:", -- Dragon's Blood Cape
	[17102]="193445:38689:4:1:1:::0:0:", -- Cloak of the Shrouded Mists
	[19370]="194720:38944:4:1:1:::0:0:", -- Mantle of the Blackwing Cabal
	[19398]="200015:40003:4:1:1:::0:0:", -- Cloak of Firemaw
	[16929]="207606:41521:4:1:1:::0:0:", -- Nemesis Skullcap
	[16932]="209994:41998:4:1:1:::0:0:", -- Nemesis Spaulders
	[16912]="210038:42007:4:1:1:::0:0:", -- Netherwind Boots
	[16914]="211623:42324:4:1:1:::0:0:", -- Netherwind Crown
	[18545]="212731:42546:4:1:1:::0:0:", -- Leggings of Arcane Supremacy
	[16917]="214012:42802:4:1:1:::0:0:", -- Netherwind Mantle
	[19430]="214596:42919:4:1:1:::0:0:", -- Shroud of Pure Thought
	[16919]="215619:43123:4:1:1:::0:0:", -- Boots of Transcendence
	[19133]="216387:43277:4:1:1:::0:0:", -- Fel Infused Leggings
	[16921]="217204:43440:4:1:1:::0:0:", -- Halo of Transcendence
	[19165]="225032:45006:4:1:1:::0:0:", -- Flarecore Leggings
	[16927]="227758:45551:4:1:1:::0:0:", -- Nemesis Boots
	[19391]="237481:47496:4:1:1:::0:0:", -- Shimmering Geta
	[19399]="267707:53541:4:1:1:::0:0:", -- Black Ash Robe
	[16930]="277879:55575:4:1:1:::0:0:", -- Nemesis Leggings
	[16915]="283236:56647:4:1:1:::0:0:", -- Netherwind Pants
	[16922]="290677:58135:4:1:1:::0:0:", -- Leggings of Transcendence
	[153]="5:1:4:2:1:::0:0:", -- Primitive Kilt
	[6135]="5:1:4:2:1:::0:0:", -- Primitive Kilt
	[1366]="11:2:4:2:1:::0:0:", -- Ragged Leather Pants
	[1367]="14:2:4:2:1:::0:0:", -- Ragged Leather Boots
	[1370]="14:2:4:2:1:::0:0:", -- Ragged Leather Bracers
	[1368]="14:2:4:2:1:::0:0:", -- Ragged Leather Gloves
	[1369]="21:4:4:2:1:::0:0:", -- Ragged Leather Belt
	[1422]="31:6:4:2:1:::0:0:", -- Worn Leather Gloves
	[1364]="41:8:4:2:1:::0:0:", -- Ragged Leather Vest
	[1418]="46:9:4:2:1:::0:0:", -- Worn Leather Belt
	[1420]="92:18:4:2:1:::0:0:", -- Worn Leather Bracers
	[1423]="94:18:4:2:1:::0:0:", -- Worn Leather Pants
	[1419]="98:19:4:2:1:::0:0:", -- Worn Leather Boots
	[1504]="162:32:4:2:1:::0:0:", -- Warped Leather Bracers
	[1425]="188:37:4:2:1:::0:0:", -- Worn Leather Vest
	[1506]="255:51:4:2:1:::0:0:", -- Warped Leather Gloves
	[1509]="299:59:4:2:1:::0:0:", -- Warped Leather Vest
	[1502]="302:60:4:2:1:::0:0:", -- Warped Leather Belt
	[1791]="450:90:4:2:1:::0:0:", -- Patched Leather Gloves
	[1787]="510:102:4:2:1:::0:0:", -- Patched Leather Belt
	[1503]="546:109:4:2:1:::0:0:", -- Warped Leather Boots
	[1507]="616:123:4:2:1:::0:0:", -- Warped Leather Pants
	[1789]="680:136:4:2:1:::0:0:", -- Patched Leather Bracers
	[1797]="807:161:4:2:1:::0:0:", -- Rawhide Bracers
	[1788]="884:176:4:2:1:::0:0:", -- Patched Leather Boots
	[1793]="1037:207:4:2:1:::0:0:", -- Patched Leather Shoulderpads
	[1792]="1041:208:4:2:1:::0:0:", -- Patched Leather Pants
	[1799]="1056:211:4:2:1:::0:0:", -- Rawhide Gloves
	[1795]="1176:235:4:2:1:::0:0:", -- Rawhide Belt
	[1794]="1387:277:4:2:1:::0:0:", -- Patched Leather Jerkin
	[1802]="1688:337:4:2:1:::0:0:", -- Rawhide Tunic
	[1805]="1759:351:4:2:1:::0:0:", -- Tough Leather Bracers
	[1807]="1939:387:4:2:1:::0:0:", -- Tough Leather Gloves
	[1796]="2001:400:4:2:1:::0:0:", -- Rawhide Boots
	[1801]="2093:418:4:2:1:::0:0:", -- Rawhide Shoulderpads
	[1809]="2203:440:4:2:1:::0:0:", -- Tough Leather Shoulderpads
	[1803]="2325:465:4:2:1:::0:0:", -- Tough Leather Belt
	[1804]="2391:478:4:2:1:::0:0:", -- Tough Leather Boots
	[1800]="2397:479:4:2:1:::0:0:", -- Rawhide Pants
	[3802]="3136:627:4:2:1:::0:0:", -- Hardened Leather Bracers
	[1810]="3243:648:4:2:1:::0:0:", -- Tough Leather Armor
	[3804]="3825:765:4:2:1:::0:0:", -- Hardened Leather Gloves
	[1808]="4284:856:4:2:1:::0:0:", -- Tough Leather Pants
	[4982]="4807:961:4:2:1:::0:0:", -- Ripped Prospector Belt
	[3801]="5156:1031:4:2:1:::0:0:", -- Hardened Leather Boots
	[8747]="5181:1036:4:2:1:::0:0:", -- Hardened Leather Helm
	[3805]="5245:1049:4:2:1:::0:0:", -- Hardened Leather Pants
	[3800]="5343:1068:4:2:1:::0:0:", -- Hardened Leather Belt
	[3807]="5813:1162:4:2:1:::0:0:", -- Hardened Leather Tunic
	[3806]="6359:1271:4:2:1:::0:0:", -- Hardened Leather Shoulderpads
	[3963]="7012:1402:4:2:1:::0:0:", -- Thick Leather Bracers
	[3961]="7518:1503:4:2:1:::0:0:", -- Thick Leather Belt
	[8750]="9317:1863:4:2:1:::0:0:", -- Thick Leather Hat
	[3965]="11105:2221:4:2:1:::0:0:", -- Thick Leather Gloves
	[3966]="13128:2625:4:2:1:::0:0:", -- Thick Leather Pants
	[3967]="14519:2903:4:2:1:::0:0:", -- Thick Leather Shoulderpads
	[3962]="15399:3079:4:2:1:::0:0:", -- Thick Leather Boots
	[3969]="16283:3256:4:2:1:::0:0:", -- Smooth Leather Belt
	[3968]="16656:3331:4:2:1:::0:0:", -- Thick Leather Tunic
	[3973]="18286:3657:4:2:1:::0:0:", -- Smooth Leather Gloves
	[3971]="19057:3811:4:2:1:::0:0:", -- Smooth Leather Bracers
	[3975]="19482:3896:4:2:1:::0:0:", -- Smooth Leather Shoulderpads
	[3970]="21481:4296:4:2:1:::0:0:", -- Smooth Leather Boots
	[8753]="25990:5198:4:2:1:::0:0:", -- Smooth Leather Helmet
	[3974]="27434:5486:4:2:1:::0:0:", -- Smooth Leather Pants
	[3976]="34894:6978:4:2:1:::0:0:", -- Smooth Leather Armor
	[1027]="6:1:4:2:1:::0:0:", -- Mail Helmet A (Test)
	[1024]="6:1:4:2:1:::0:0:", -- Plate Helmet D2 (test)
	[4914]="29:5:4:2:1:::0:0:", -- Battleworn Leather Gloves
	[4954]="30:6:4:2:1:::0:0:", -- Nomadic Belt
	[10636]="30:6:4:2:1:::0:0:", -- Nomadic Gloves
	[2186]="30:6:4:2:1:::0:0:", -- Outfitter Belt
	[5394]="31:6:4:2:1:::0:0:", -- Archery Training Gloves
	[1835]="31:6:4:2:1:::1:1:35,350,516,674,831", -- Dirty Leather Belt
	[1836]="31:6:4:2:1:::1:1:35,350,516,831", -- Dirty Leather Bracers
	[2173]="31:6:4:2:1:::0:0:", -- Old Leather Belt
	[6070]="31:6:4:2:1:::0:0:", -- Wolfskin Bracers
	[6058]="32:6:4:2:1:::0:0:", -- Blackened Leather Belt
	[2122]="32:6:4:2:1:::1:0:156,176,219,228,251", -- Cracked Leather Belt
	[2124]="32:6:4:2:1:::1:1:156,176,219,228", -- Cracked Leather Bracers
	[2125]="32:6:4:2:1:::1:0:156,176,219,228,251", -- Cracked Leather Gloves
	[714]="32:6:4:2:1:::1:1:35,350,516,674,831", -- Dirty Leather Gloves
	[4908]="32:6:4:2:1:::0:0:", -- Nomadic Bracers
	[6171]="32:6:4:2:1:::0:0:", -- Wolf Handler Gloves
	[2108]="40:8:4:2:1:::0:0:", -- Frostmane Leather Vest
	[210]="45:9:4:2:1:::1:1:35,350,516,674,831", -- Dirty Leather Boots
	[2123]="48:9:4:2:1:::1:0:156,176,219,228,251", -- Cracked Leather Boots
	[2126]="59:11:4:2:1:::1:0:156,176,219,228,251", -- Cracked Leather Pants
	[2127]="60:12:4:2:1:::1:0:156,176,219,228,251", -- Cracked Leather Vest
	[209]="60:12:4:2:1:::1:1:35,350,516,674,831", -- Dirty Leather Pants
	[61]="60:12:4:2:1:::0:0:", -- Dwarven Leather Pants
	[60]="60:12:4:2:1:::0:0:", -- Layered Tunic
	[11851]="60:12:4:2:1:::0:0:", -- Scavenger Tunic
	[85]="62:12:4:2:1:::1:1:35,350,516,674,831", -- Dirty Leather Vest
	[4921]="63:12:4:2:1:::0:0:", -- Dust-covered Leggings
	[5398]="65:13:4:2:1:::0:0:", -- Canopy Leggings
	[6059]="65:13:4:2:1:::0:0:", -- Nomadic Vest
	[4907]="65:13:4:2:1:::0:0:", -- Woodland Tunic
	[3272]="65:13:4:2:1:::0:0:", -- Zombie Skin Leggings
	[5419]="68:13:4:2:1:::0:0:", -- Feral Bracers
	[4951]="69:13:4:2:1:::0:0:", -- Squealer's Belt
	[3200]="95:19:4:2:1:::0:0:", -- Burnt Leather Bracers
	[1359]="95:19:4:2:1:::0:0:", -- Lion-stamped Gloves
	[3435]="98:19:4:2:1:::0:0:", -- Zombie Skin Bracers
	[5936]="99:19:4:2:1:::0:0:", -- Animal Skin Belt
	[4962]="100:20:4:2:1:::0:0:", -- Double-layered Gloves
	[15003]="100:20:4:2:1:::0:0:", -- Primal Belt
	[5939]="100:20:4:2:1:::0:0:", -- Sewing Gloves
	[4928]="102:20:4:2:1:::0:0:", -- Sandrunner Wristguards
	[4906]="109:21:4:2:1:::0:0:", -- Rainwalker Boots
	[4666]="132:26:4:2:1:::0:0:", -- Burnt Leather Belt
	[18611]="139:27:4:2:1:::0:0:", -- Gnarlpine Leggings
	[3152]="140:28:4:2:1:::0:0:", -- Driving Gloves
	[15005]="141:28:4:2:1:::0:0:", -- Primal Bands
	[7277]="142:28:4:2:1:::0:0:", -- Handstitched Leather Bracers
	[2302]="147:29:4:2:1:::0:0:", -- Handstitched Leather Boots
	[3439]="150:30:4:2:1:::0:0:", -- Zombie Skin Boots
	[2374]="173:34:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Bracers
	[2375]="173:34:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Gloves
	[4237]="174:34:4:2:1:::0:0:", -- Handstitched Leather Belt
	[797]="176:35:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Gloves
	[4973]="178:35:4:2:1:::0:0:", -- Plains Hunter Wristguards
	[4675]="178:35:4:2:1:::0:0:", -- Tribal Belt
	[6517]="179:35:4:2:1:::0:0:", -- Pioneer Belt
	[6519]="180:36:4:2:1:::0:0:", -- Pioneer Bracers
	[1965]="180:36:4:2:1:::0:0:", -- White Wolf Gloves
	[2964]="181:36:4:2:1:::0:0:", -- Burnt Leather Gloves
	[2327]="182:36:4:2:1:::0:0:", -- Sturdy Leather Bracers
	[3285]="182:36:4:2:1:::0:0:", -- Tribal Bracers
	[4940]="182:36:4:2:1:::0:0:", -- Veiled Grips
	[1839]="184:36:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Belt
	[6147]="185:37:4:2:1:::0:0:", -- Ratty Old Belt
	[1840]="185:37:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Bracers
	[15008]="186:37:4:2:1:::0:0:", -- Primal Mitts
	[2371]="189:37:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Belt
	[5957]="200:40:4:2:1:::0:0:", -- Handstitched Leather Vest
	[3321]="207:41:4:2:1:::0:0:", -- Gray Fur Booties
	[2963]="208:41:4:2:1:::0:0:", -- Burnt Leather Boots
	[15004]="212:42:4:2:1:::0:0:", -- Primal Boots
	[15297]="227:45:4:2:1:::0:0:", -- Grizzly Bracers
	[6521]="236:47:4:2:1:::0:0:", -- Pioneer Gloves
	[15302]="237:47:4:2:1:::0:0:", -- Grizzly Belt
	[2373]="259:51:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Boots
	[1173]="262:52:4:2:1:::0:0:", -- Weather-worn Boots
	[796]="264:52:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Boots
	[2112]="271:54:4:2:1:::0:0:", -- Lumberjack Jerkin
	[4970]="271:54:4:2:1:::0:0:", -- Rough-hewn Kodo Leggings
	[6201]="272:54:4:2:1:::0:0:", -- Lithe Boots
	[9750]="287:57:4:2:1:::0:0:", -- Gypsy Sash
	[3583]="288:57:4:2:1:::0:0:", -- Weathered Belt
	[9752]="289:57:4:2:1:::0:0:", -- Gypsy Bands
	[4929]="291:58:4:2:1:::0:0:", -- Light Scorpid Armor
	[763]="293:58:4:2:1:::0:0:", -- Ice-covered Bracers
	[3286]="297:59:4:2:1:::0:0:", -- Tribal Gloves
	[3158]="303:60:4:2:1:::0:0:", -- Burnt Hide Bracers
	[2372]="343:68:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Pants
	[6518]="351:70:4:2:1:::0:0:", -- Pioneer Boots
	[3312]="353:70:4:2:1:::0:0:", -- Ceremonial Leather Bracers
	[798]="354:70:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Pants
	[799]="355:71:4:2:1:::1:0:108,228,332,500,512,575,658,665,729,762,832", -- Rough Leather Vest
	[4690]="356:71:4:2:1:::0:0:", -- Hunting Belt
	[4239]="357:71:4:2:1:::0:0:", -- Embossed Leather Gloves
	[2303]="358:71:4:2:1:::0:0:", -- Handstitched Leather Pants
	[5612]="363:72:4:2:1:::0:0:", -- Ivy Cuffs
	[9755]="366:73:4:2:1:::0:0:", -- Gypsy Gloves
	[2370]="377:75:4:2:1:::1:0:134,186,281,516,550,590,640,698,830", -- Battered Leather Harness
	[2237]="377:75:4:2:1:::0:0:", -- Patched Pants
	[7281]="421:84:4:2:1:::0:0:", -- Light Leather Bracers
	[15013]="430:86:4:2:1:::0:0:", -- Lupine Cuffs
	[15300]="432:86:4:2:1:::0:0:", -- Grizzly Gloves
	[4693]="433:86:4:2:1:::0:0:", -- Ceremonial Leather Belt
	[9751]="433:86:4:2:1:::0:0:", -- Gypsy Sandals
	[1213]="437:87:4:2:1:::0:0:", -- Gnoll Kindred Bracers
	[9601]="438:87:4:2:1:::0:0:", -- Cushioned Boots
	[3207]="438:87:4:2:1:::0:0:", -- Hunting Bracers
	[3284]="444:88:4:2:1:::0:0:", -- Tribal Boots
	[4942]="449:89:4:2:1:::0:0:", -- Tiger Hide Boots
	[3444]="451:90:4:2:1:::0:0:", -- Tiller's Vest
	[4968]="454:90:4:2:1:::0:0:", -- Bound Harness
	[15301]="541:108:4:2:1:::0:0:", -- Grizzly Slippers
	[2069]="609:121:4:2:1:::0:0:", -- Black Bear Hide Vest
	[4246]="625:125:4:2:1::165:0:0:", -- Fine Leather Belt
	[2975]="642:128:4:2:1:::0:0:", -- Hunting Boots
	[844]="720:144:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Gloves
	[1843]="725:145:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Belt
	[1844]="728:145:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Bracers
	[2311]="751:150:4:2:1:::0:0:", -- White Leather Jerkin
	[3311]="761:152:4:2:1:::0:0:", -- Ceremonial Leather Ankleguards
	[5780]="781:156:4:2:1:::0:0:", -- Murloc Scale Belt
	[843]="1077:215:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Boots
	[2307]="1216:243:4:2:1:::0:0:", -- Fine Leather Boots
	[1849]="1388:277:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Belt
	[1850]="1393:278:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Bracers
	[239]="1413:282:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Gloves
	[6523]="1422:284:4:2:1:::1:1:479", -- Buckled Harness
	[845]="1447:289:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Pants
	[846]="1452:290:4:2:1:::1:0:15,169,281,393,447,512,516,569,590,640,654,665,670,698,699,762,832", -- Tanned Leather Jerkin
	[2315]="1538:307:4:2:1:::0:0:", -- Dark Leather Boots
	[5254]="1544:308:4:2:1:::0:0:", -- Rugged Spaulders
	[5319]="1615:323:4:2:1:::0:0:", -- Bashing Pauldrons
	[15019]="1833:366:4:2:1:::0:0:", -- Lupine Mantle
	[4700]="1899:379:4:2:1:::0:0:", -- Inscribed Leather Spaulders
	[10405]="2045:409:4:2:1:::0:0:", -- Bandit Shoulders
	[238]="2112:422:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Boots
	[6588]="2291:458:4:2:1:::0:0:", -- Scouting Spaulders
	[5404]="2345:469:4:2:1:::0:0:", -- Serpent's Shoulders
	[15313]="2572:514:4:2:1:::0:0:", -- Feral Shoulder Pads
	[2142]="2620:524:4:2:1:::1:0:174,306,440,446,682,762,792,801", -- Cuirboulli Belt
	[2144]="2639:527:4:2:1:::1:0:174,306,440,446,682,762,792,801", -- Cuirboulli Bracers
	[2145]="2648:529:4:2:1:::1:0:174,306,440,446,682,762,792,801", -- Cuirboulli Gloves
	[236]="2795:559:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Armor
	[237]="2805:561:4:2:1:::1:0:60,281,512,590,640,682,698,762,792,835", -- Cured Leather Pants
	[6524]="2870:574:4:2:1:::1:1:479", -- Studded Leather Harness
	[2314]="3717:743:4:2:1:::0:0:", -- Toughened Leather Armor
	[2143]="3944:788:4:2:1:::1:0:14,174,306,440,446,682,762,792,801", -- Cuirboulli Boots
	[2146]="4809:961:4:2:1:::1:0:174,306,440,446,682,762,792,801", -- Cuirboulli Pants
	[6525]="5167:1033:4:2:1:::1:1:479", -- Grunt's Harness
	[2141]="5223:1044:4:2:1:::1:0:174,306,440,446,682,762,792,801", -- Cuirboulli Vest
	[2468]="6310:1262:4:2:1:::1:0:174,306,347,440,446,531,565,707,745,801,857", -- Studded Bracers
	[2469]="6334:1266:4:2:1:::1:0:174,306,347,440,446,531,565,707,745,801,857", -- Studded Gloves
	[2464]="6871:1374:4:2:1:::1:0:174,306,347,440,446,531,565,707,745,801,857", -- Studded Belt
	[5966]="6873:1374:4:2:1::164:0:0:", -- Guardian Gloves
	[2467]="9430:1886:4:2:1:::1:0:174,306,347,440,446,531,565,571,707,745,801,857", -- Studded Boots
	[3890]="10201:2040:4:2:1:::1:0:14,174,193,306,347,440,446,531,565,707,745,801,857", -- Studded Hat
	[9398]="12441:2488:4:2:1:::0:0:", -- Worn Running Boots
	[2465]="12477:2495:4:2:1:::1:0:174,306,347,440,446,531,565,707,745,801,857", -- Studded Pants
	[6526]="12487:2497:4:2:1:::1:1:479", -- Battle Harness
	[5739]="13694:2738:4:2:1:::0:0:", -- Barbaric Harness
	[2463]="13695:2739:4:2:1:::1:0:174,306,347,440,446,531,565,707,745,801,857", -- Studded Doublet
	[2471]="17040:3408:4:2:1:::1:0:71,174,306,440,446,470,531,565,707,745,781,801", -- Reinforced Leather Belt
	[2474]="17233:3446:4:2:1:::1:0:71,174,306,440,446,470,531,707,745,781,801", -- Reinforced Leather Bracers
	[2475]="17298:3459:4:2:1:::1:0:71,174,306,440,446,470,531,707,745,781,801", -- Reinforced Leather Gloves
	[2473]="25753:5150:4:2:1:::1:0:71,174,306,440,446,470,531,571,707,745,781,801", -- Reinforced Leather Boots
	[3893]="27523:5504:4:2:1:::1:0:71,174,193,306,440,446,470,531,707,745,781,801", -- Reinforced Leather Cap
	[2470]="33952:6790:4:2:1:::1:0:71,174,306,440,446,470,531,565,707,745,781,801", -- Reinforced Leather Vest
	[2472]="34211:6842:4:2:1:::1:0:71,174,306,440,446,470,531,565,707,745,781,801", -- Reinforced Leather Pants
	[17922]="576:115:4:2:1:::0:0:", -- Lionfur Armor
	[3000]="596:119:4:2:1:::0:0:", -- Brood Mother Carapace
	[4861]="596:119:4:2:1:::0:0:", -- Sleek Feathered Tunic
	[2962]="600:120:4:2:1:::0:0:", -- Burnt Leather Breeches
	[15399]="755:151:4:2:1:::0:0:", -- Dryweed Belt
	[2961]="779:155:4:2:1:::0:0:", -- Burnt Leather Vest
	[15009]="812:162:4:2:1:::0:0:", -- Primal Leggings
	[7280]="814:162:4:2:1:::0:0:", -- Rugged Leather Pants
	[15010]="815:163:4:2:1:::0:0:", -- Primal Wraps
	[2899]="846:169:4:2:1:::0:0:", -- Wendigo Collar
	[3314]="856:171:4:2:1:::0:0:", -- Ceremonial Leather Gloves
	[2976]="859:171:4:2:1:::0:0:", -- Hunting Gloves
	[6556]="873:174:4:2:1:::0:0:", -- Bard's Bracers
	[5275]="879:175:4:2:1:::0:0:", -- Binding Girdle
	[6558]="902:180:4:2:1:::0:0:", -- Bard's Belt
	[2312]="905:181:4:2:1::165:0:0:", -- Fine Leather Gloves
	[12522]="910:182:4:2:1:::0:0:", -- Bingles' Flying Gloves
	[15011]="919:183:4:2:1:::0:0:", -- Lupine Cord
	[2300]="962:192:4:2:1:::0:0:", -- Embossed Leather Vest
	[6269]="966:193:4:2:1:::0:0:", -- Pioneer Trousers
	[16608]="969:193:4:2:1:::0:0:", -- Aquarius Belt
	[3287]="998:199:4:2:1:::0:0:", -- Tribal Pants
	[15016]="1001:200:4:2:1:::0:0:", -- Lupine Handwraps
	[2817]="1006:201:4:2:1:::0:0:", -- Soft Leather Tunic
	[15306]="1042:208:4:2:1:::0:0:", -- Feral Bindings
	[6554]="1145:229:4:2:1:::0:0:", -- Bard's Gloves
	[3205]="1149:229:4:2:1:::0:0:", -- Inscribed Leather Bracers
	[6268]="1171:234:4:2:1:::0:0:", -- Pioneer Tunic
	[15308]="1208:241:4:2:1:::0:0:", -- Feral Cord
	[6085]="1217:243:4:2:1:::0:0:", -- Footman Tunic
	[6379]="1223:244:4:2:1:::0:0:", -- Inscribed Leather Belt
	[14561]="1225:245:4:2:1:::0:0:", -- Prospector's Cuffs
	[15405]="1225:245:4:2:1:::0:0:", -- Shucking Gloves
	[5617]="1235:247:4:2:1:::0:0:", -- Vagabond Leggings
	[821]="1248:249:4:2:1:::0:0:", -- Riverpaw Leather Vest
	[3288]="1253:250:4:2:1:::0:0:", -- Tribal Vest
	[2087]="1262:252:4:2:1:::0:0:", -- Hard Crawler Carapace
	[10401]="1278:255:4:2:1:::0:0:", -- Blackened Defias Gloves
	[2036]="1291:258:4:2:1:::0:0:", -- Dusty Mining Gloves
	[1944]="1296:259:4:2:1:::0:0:", -- Metalworking Gloves
	[1302]="1312:262:4:2:1:::0:0:", -- Black Whelp Gloves
	[1945]="1337:267:4:2:1:::0:0:", -- Woodworking Gloves
	[2309]="1343:268:4:2:1:::0:0:", -- Embossed Leather Boots
	[15453]="1349:269:4:2:1:::0:0:", -- Savannah Bracers
	[15310]="1398:279:4:2:1:::0:0:", -- Feral Gloves
	[14559]="1398:279:4:2:1:::0:0:", -- Prospector's Sash
	[15403]="1399:279:4:2:1:::0:0:", -- Ridgeback Bracers
	[9756]="1471:294:4:2:1:::0:0:", -- Gypsy Trousers
	[15012]="1480:296:4:2:1:::0:0:", -- Lupine Slippers
	[15303]="1495:299:4:2:1:::0:0:", -- Grizzly Pants
	[6557]="1511:302:4:2:1:::0:0:", -- Bard's Boots
	[14564]="1523:304:4:2:1:::0:0:", -- Prospector's Mitts
	[10413]="1539:307:4:2:1:::0:0:", -- Gloves of the Fang
	[2988]="1571:314:4:2:1:::0:0:", -- Inscribed Leather Gloves
	[9775]="1579:315:4:2:1:::0:0:", -- Bandit Cinch
	[9777]="1591:318:4:2:1:::0:0:", -- Bandit Bracers
	[2167]="1695:339:4:2:1:::0:0:", -- Foreman's Gloves
	[3578]="1699:339:4:2:1:::0:0:", -- Harvester's Pants
	[5629]="1736:347:4:2:1:::0:0:", -- Hammerfist Gloves
	[1211]="1738:347:4:2:1:::0:0:", -- Gnoll War Harness
	[4242]="1739:347:4:2:1:::0:0:", -- Embossed Leather Pants
	[5630]="1743:348:4:2:1:::0:0:", -- Windfelt Gloves
	[15110]="1758:351:4:2:1:::0:0:", -- Rigid Belt
	[1306]="1761:352:4:2:1:::0:0:", -- Wolfmane Wristguards
	[15112]="1771:354:4:2:1:::0:0:", -- Rigid Bracelets
	[5299]="1795:359:4:2:1:::0:0:", -- Gloves of the Moon
	[1314]="1814:362:4:2:1:::0:0:", -- Ghoul Fingers
	[2818]="1817:363:4:2:1:::0:0:", -- Stretched Leather Trousers
	[9757]="1819:363:4:2:1:::0:0:", -- Gypsy Tunic
	[4909]="1844:368:4:2:1:::0:0:", -- Kodo Hunter's Leggings
	[5341]="1844:368:4:2:1:::0:0:", -- Spore-covered Tunic
	[9780]="1849:369:4:2:1:::0:0:", -- Bandit Gloves
	[10402]="1926:385:4:2:1:::0:0:", -- Blackened Defias Boots
	[11853]="1941:388:4:2:1:::0:0:", -- Rambling Boots
	[2974]="1962:392:4:2:1:::0:0:", -- Hunting Pants
	[4789]="1998:399:4:2:1:::1:1:15,26,447,654", -- Stable Boots
	[10412]="2028:405:4:2:1:::0:0:", -- Belt of the Fang
	[2987]="2043:408:4:2:1:::0:0:", -- Inscribed Leather Boots
	[15305]="2062:412:4:2:1:::0:0:", -- Feral Shoes
	[15304]="2071:414:4:2:1:::0:0:", -- Grizzly Jerkin
	[6467]="2103:420:4:2:1:::0:0:", -- Deviate Scale Gloves
	[6092]="2104:420:4:2:1:::0:0:", -- Black Whelp Boots
	[6581]="2111:422:4:2:1:::0:0:", -- Scouting Belt
	[6583]="2126:425:4:2:1:::0:0:", -- Scouting Bracers
	[5609]="2235:447:4:2:1:::0:0:", -- Steadfast Cinch
	[10403]="2255:451:4:2:1:::0:0:", -- Blackened Defias Belt
	[3315]="2274:454:4:2:1:::0:0:", -- Ceremonial Leather Loincloth
	[1436]="2290:458:4:2:1:::0:0:", -- Frontier Britches
	[4243]="2308:461:4:2:1::165:0:0:", -- Fine Leather Tunic
	[1215]="2347:469:4:2:1:::0:0:", -- Support Girdle
	[14569]="2360:472:4:2:1:::0:0:", -- Bristlebark Bindings
	[15115]="2369:473:4:2:1:::0:0:", -- Rigid Gloves
	[2973]="2420:484:4:2:1:::0:0:", -- Hunting Tunic
	[14560]="2421:484:4:2:1:::0:0:", -- Prospector's Boots
	[6586]="2526:505:4:2:1:::0:0:", -- Scouting Gloves
	[15202]="2579:515:4:2:1:::0:0:", -- Wildkeeper Leggings
	[3313]="2595:519:4:2:1:::0:0:", -- Ceremonial Leather Harness
	[5327]="2595:519:4:2:1:::0:0:", -- Greasy Tinker's Pants
	[6382]="2616:523:4:2:1:::0:0:", -- Forest Leather Belt
	[6553]="2626:525:4:2:1:::0:0:", -- Bard's Trousers
	[4788]="2633:526:4:2:1:::1:1:15,26,447,654", -- Agile Boots
	[14567]="2648:529:4:2:1:::0:0:", -- Bristlebark Belt
	[5975]="2664:532:4:2:1:::0:0:", -- Ruffian Belt
	[15450]="2669:533:4:2:1:::0:0:", -- Dredgemire Leggings
	[6709]="2726:545:4:2:1:::0:0:", -- Moonglow Vest
	[9776]="2735:547:4:2:1:::0:0:", -- Bandit Boots
	[15331]="2776:555:4:2:1:::0:0:", -- Wrangler's Wristbands
	[10400]="2817:563:4:2:1:::0:0:", -- Blackened Defias Leggings
	[3202]="2921:584:4:2:1:::0:0:", -- Forest Leather Bracers
	[3429]="2931:586:4:2:1:::0:0:", -- Guardsman Belt
	[7284]="2933:586:4:2:1:::0:0:", -- Red Whelp Gloves
	[7285]="2944:588:4:2:1:::0:0:", -- Nimble Leather Gloves
	[7282]="2998:599:4:2:1:::0:0:", -- Light Leather Pants
	[5311]="3007:601:4:2:1:::0:0:", -- Buckled Boots
	[5781]="3008:601:4:2:1:::0:0:", -- Murloc Scale Breastplate
	[6552]="3009:601:4:2:1:::0:0:", -- Bard's Tunic
	[15111]="3046:609:4:2:1:::0:0:", -- Rigid Moccasins
	[14572]="3047:609:4:2:1:::0:0:", -- Bristlebark Gloves
	[15017]="3059:611:4:2:1:::0:0:", -- Lupine Leggings
	[15329]="3114:622:4:2:1:::0:0:", -- Wrangler's Belt
	[7000]="3252:650:4:2:1:::0:0:", -- Heartwood Girdle
	[15462]="3269:653:4:2:1:::0:0:", -- Loamflake Bracers
	[3058]="3414:682:4:2:1:::0:0:", -- Forest Leather Gloves
	[2317]="3446:689:4:2:1:::0:0:", -- Dark Leather Tunic
	[7348]="3454:690:4:2:1:::0:0:", -- Fletcher's Gloves
	[5422]="3460:692:4:2:1:::0:0:", -- Brambleweed Leggings
	[15122]="3507:701:4:2:1:::0:0:", -- Robust Bracers
	[4249]="3515:703:4:2:1:::0:0:", -- Dark Leather Belt
	[4794]="3515:703:4:2:1:::1:1:30,60,529,835", -- Wolf Bracers
	[4250]="3527:705:4:2:1:::0:0:", -- Hillman's Belt
	[4795]="3528:705:4:2:1:::1:1:30,60,529,835", -- Bear Bracers
	[15018]="3531:706:4:2:1:::0:0:", -- Lupine Vest
	[4796]="3540:708:4:2:1:::1:1:30,60,529,835", -- Owl Bracers
	[9801]="3542:708:4:2:1:::0:0:", -- Superior Belt
	[6480]="3566:713:4:2:1:::0:0:", -- Slick Deviate Leggings
	[1310]="3576:715:4:2:1:::0:0:", -- Smith's Trousers
	[2986]="3590:718:4:2:1:::0:0:", -- Inscribed Leather Pants
	[4244]="3618:723:4:2:1:::0:0:", -- Hillman's Leather Vest
	[9803]="3647:729:4:2:1:::0:0:", -- Superior Bracers
	[6582]="3655:731:4:2:1:::0:0:", -- Scouting Boots
	[1934]="3656:731:4:2:1:::0:0:", -- Stonemason Trousers
	[15312]="3728:745:4:2:1:::0:0:", -- Feral Leggings
	[3204]="3758:751:4:2:1:::0:0:", -- Deepwood Bracers
	[3230]="3842:768:4:2:1:::0:0:", -- Black Wolf Bracers
	[15120]="3934:786:4:2:1:::0:0:", -- Robust Girdle
	[10411]="3939:787:4:2:1:::0:0:", -- Footpads of the Fang
	[4248]="3958:791:4:2:1:::0:0:", -- Dark Leather Gloves
	[15348]="3962:792:4:2:1:::0:0:", -- Pathfinder Bracers
	[14568]="3987:797:4:2:1:::0:0:", -- Bristlebark Boots
	[6319]="4016:803:4:2:1:::0:0:", -- Girdle of the Blindwatcher
	[5199]="4024:804:4:2:1:::0:0:", -- Smelting Pants
	[14565]="4045:809:4:2:1:::0:0:", -- Prospector's Woolies
	[14580]="4093:818:4:2:1:::0:0:", -- Dokebi Bracers
	[2985]="4113:822:4:2:1:::0:0:", -- Inscribed Leather Breastplate
	[3562]="4117:823:4:2:1:::0:0:", -- Belt of Vindication
	[15334]="4141:828:4:2:1:::0:0:", -- Wrangler's Gloves
	[5958]="4145:829:4:2:1:::0:0:", -- Fine Leather Pants
	[9806]="4169:833:4:2:1:::0:0:", -- Superior Gloves
	[16659]="4282:856:4:2:1:::0:0:", -- Deftkin Belt
	[7349]="4308:861:4:2:1:::0:0:", -- Herbalist's Gloves
	[6600]="4338:867:4:2:1:::0:0:", -- Dervish Belt
	[6602]="4369:873:4:2:1:::0:0:", -- Dervish Bracers
	[6902]="4385:877:4:2:1:::0:0:", -- Bands of Serra'kis
	[16987]="4422:884:4:2:1:::0:0:", -- Screecher Belt
	[7358]="4428:885:4:2:1:::0:0:", -- Pilferer's Gloves
	[4049]="4443:888:4:2:1:::0:0:", -- Emblazoned Bracers
	[2017]="4477:895:4:2:1:::0:0:", -- Glowing Leather Bracers
	[3057]="4515:903:4:2:1:::0:0:", -- Forest Leather Boots
	[3741]="4614:922:4:2:1:::0:0:", -- Stomping Boots
	[6197]="4646:929:4:2:1:::0:0:", -- Loch Croc Hide Vest
	[5355]="4738:947:4:2:1:::0:0:", -- Beastmaster's Girdle
	[3585]="4767:953:4:2:1:::0:0:", -- Camouflaged Tunic
	[15347]="4777:955:4:2:1:::0:0:", -- Pathfinder Belt
	[2033]="4836:967:4:2:1:::0:0:", -- Ambassador's Boots
	[6605]="4857:971:4:2:1:::0:0:", -- Dervish Gloves
	[7359]="4890:978:4:2:1:::0:0:", -- Heavy Earthen Gloves
	[9781]="4910:982:4:2:1:::0:0:", -- Bandit Pants
	[15311]="4913:982:4:2:1:::0:0:", -- Feral Harness
	[4709]="4913:982:4:2:1:::0:0:", -- Forest Leather Mantle
	[14578]="4916:983:4:2:1:::0:0:", -- Dokebi Cord
	[6397]="4929:985:4:2:1:::0:0:", -- Emblazoned Gloves
	[6398]="4948:989:4:2:1:::0:0:", -- Emblazoned Belt
	[15125]="4954:990:4:2:1:::0:0:", -- Robust Gloves
	[6740]="5004:1000:4:2:1:::0:0:", -- Azure Sash
	[15469]="5048:1009:4:2:1:::0:0:", -- Windsong Cinch
	[6473]="5053:1010:4:2:1:::0:0:", -- Armor of the Fang
	[14566]="5054:1010:4:2:1:::0:0:", -- Prospector's Pads
	[15132]="5085:1017:4:2:1:::0:0:", -- Cutthroat's Armguards
	[9829]="5100:1020:4:2:1:::0:0:", -- Scaled Leather Bracers
	[897]="5112:1022:4:2:1:::0:0:", -- Madwolf Bracers
	[2949]="5196:1039:4:2:1:::0:0:", -- Mariner Boots
	[14562]="5199:1039:4:2:1:::0:0:", -- Prospector's Chestpiece
	[4247]="5248:1049:4:2:1:::0:0:", -- Hillman's Leather Gloves
	[15330]="5298:1059:4:2:1:::0:0:", -- Wrangler's Boots
	[4254]="5356:1071:4:2:1:::0:0:", -- Barbaric Gloves
	[3022]="5427:1085:4:2:1:::0:0:", -- Bluegill Breeches
	[5961]="5446:1089:4:2:1:::0:0:", -- Dark Leather Pants
	[15351]="5450:1090:4:2:1:::0:0:", -- Headhunter's Bands
	[3747]="5462:1092:4:2:1:::0:0:", -- Meditative Sash
	[6719]="5485:1097:4:2:1:::0:0:", -- Windborne Belt
	[6198]="5566:1113:4:2:1:::0:0:", -- Jurassic Wristguards
	[9782]="5568:1113:4:2:1:::0:0:", -- Bandit Jerkin
	[9827]="5570:1114:4:2:1:::0:0:", -- Scaled Leather Belt
	[15343]="5698:1139:4:2:1:::0:0:", -- Pathfinder Gloves
	[6587]="5732:1146:4:2:1:::0:0:", -- Scouting Trousers
	[15116]="5816:1163:4:2:1:::0:0:", -- Rigid Shoulders
	[7410]="5873:1174:4:2:1:::0:0:", -- Infiltrator Bracers
	[16741]="5890:1178:4:2:1:::0:0:", -- Oilrag Handwraps
	[4251]="5999:1199:4:2:1:::0:0:", -- Hillman's Shoulders
	[9802]="6024:1204:4:2:1:::0:0:", -- Superior Boots
	[15117]="6096:1219:4:2:1:::0:0:", -- Rigid Leggings
	[6668]="6226:1245:4:2:1:::0:0:", -- Draftsman Boots
	[9832]="6240:1248:4:2:1:::0:0:", -- Scaled Leather Gloves
	[15136]="6244:1248:4:2:1:::0:0:", -- Cutthroat's Belt
	[9807]="6278:1255:4:2:1:::0:0:", -- Superior Shoulders
	[14573]="6445:1289:4:2:1:::0:0:", -- Bristlebark Amice
	[7412]="6512:1302:4:2:1:::0:0:", -- Infiltrator Gloves
	[7352]="6533:1306:4:2:1:::0:0:", -- Earthen Leather Shoulders
	[4257]="6556:1311:4:2:1:::0:0:", -- Green Leather Belt
	[14583]="6668:1333:4:2:1:::0:0:", -- Dokebi Gloves
	[3431]="6677:1335:4:2:1:::0:0:", -- Bone-studded Leather
	[5316]="6778:1355:4:2:1:::0:0:", -- Barkshell Tunic
	[5317]="6803:1360:4:2:1:::0:0:", -- Dry Moss Tunic
	[7406]="6861:1372:4:2:1:::0:0:", -- Infiltrator Cord
	[15338]="6937:1387:4:2:1:::0:0:", -- Wrangler's Mantle
	[6584]="7082:1416:4:2:1:::0:0:", -- Scouting Tunic
	[19508]="7116:1423:4:2:1:::0:0:", -- Branded Leather Bracers
	[15458]="7116:1423:4:2:1:::0:0:", -- Tundra Boots
	[15121]="7167:1433:4:2:1:::0:0:", -- Robust Boots
	[6601]="7185:1437:4:2:1:::0:0:", -- Dervish Boots
	[15143]="7197:1439:4:2:1:::0:0:", -- Ghostwalker Bindings
	[4252]="7286:1457:4:2:1:::0:0:", -- Dark Leather Shoulders
	[7415]="7423:1484:4:2:1:::0:0:", -- Dervish Spaulders
	[3754]="7461:1492:4:2:1:::0:0:", -- Shepherd's Gloves
	[9698]="7524:1504:4:2:1:::0:0:", -- Gloves of Insight
	[6410]="7574:1514:4:2:1:::0:0:", -- Insignia Bracers
	[15137]="7583:1516:4:2:1:::0:0:", -- Cutthroat's Mitts
	[3055]="7631:1526:4:2:1:::0:0:", -- Forest Leather Chestpiece
	[3056]="7660:1532:4:2:1:::0:0:", -- Forest Leather Pants
	[15349]="7749:1549:4:2:1:::0:0:", -- Headhunter's Belt
	[4456]="7768:1553:4:2:1:::0:0:", -- Raptor Hide Belt
	[9687]="7771:1554:4:2:1:::0:0:", -- Grappler's Belt
	[15118]="7812:1562:4:2:1:::0:0:", -- Rigid Tunic
	[14574]="7840:1568:4:2:1:::0:0:", -- Bristlebark Britches
	[9857]="7851:1570:4:2:1:::0:0:", -- Archer's Bracers
	[4831]="7858:1571:4:2:1:::1:1:148,652,802,847", -- Stalking Pants
	[6335]="7905:1581:4:2:1:::0:0:", -- Grizzled Boots
	[4258]="7963:1592:4:2:1:::0:0:", -- Guardian Belt
	[6752]="8009:1601:4:2:1:::0:0:", -- Lancer Boots
	[7756]="8030:1606:4:2:1:::0:0:", -- Dog Training Gloves
	[15148]="8069:1613:4:2:1:::0:0:", -- Ghostwalker Belt
	[7751]="8072:1614:4:2:1:::0:0:", -- Vorrel's Boots
	[15355]="8100:1620:4:2:1:::0:0:", -- Headhunter's Mitts
	[17005]="8161:1632:4:2:1:::0:0:", -- Boorguard Tunic
	[3753]="8178:1635:4:2:1:::0:0:", -- Shepherd's Girdle
	[6399]="8196:1639:4:2:1:::0:0:", -- Emblazoned Shoulders
	[10653]="8197:1639:4:2:1:::0:0:", -- Trailblazer Boots
	[15127]="8237:1647:4:2:1:::0:0:", -- Robust Shoulders
	[6408]="8271:1654:4:2:1:::0:0:", -- Insignia Gloves
	[6409]="8302:1660:4:2:1:::0:0:", -- Insignia Belt
	[3392]="8317:1663:4:2:1:::0:0:", -- Ringed Helm
	[15336]="8345:1669:4:2:1:::0:0:", -- Wrangler's Leggings
	[4051]="8349:1669:4:2:1:::0:0:", -- Emblazoned Boots
	[6670]="8363:1672:4:2:1:::0:0:", -- Panther Armor
	[2233]="8452:1690:4:2:1:::0:0:", -- Shadow Weaver Leggings
	[15341]="8486:1697:4:2:1:::0:0:", -- Pathfinder Footpads
	[9861]="8768:1753:4:2:1:::0:0:", -- Archer's Gloves
	[4724]="8815:1763:4:2:1:::0:0:", -- Humbert's Helm
	[4048]="8837:1767:4:2:1:::0:0:", -- Emblazoned Hat
	[14579]="8958:1791:4:2:1:::0:0:", -- Dokebi Boots
	[14590]="9109:1821:4:2:1:::0:0:", -- Hawkeye's Bracers
	[15587]="9110:1822:4:2:1:::0:0:", -- Ringtail Girdle
	[15129]="9129:1825:4:2:1:::0:0:", -- Robust Helm
	[9828]="9225:1845:4:2:1:::0:0:", -- Scaled Leather Boots
	[9808]="9242:1848:4:2:1:::0:0:", -- Superior Leggings
	[9809]="9276:1855:4:2:1:::0:0:", -- Superior Tunic
	[14570]="9350:1870:4:2:1:::0:0:", -- Bristlebark Blouse
	[5753]="9423:1884:4:2:1:::0:0:", -- Ruffled Chaplet
	[15345]="9471:1894:4:2:1:::0:0:", -- Pathfinder Shoulder Pads
	[4830]="9474:1894:4:2:1:::1:1:148,652,847", -- Saber Leggings
	[9855]="9475:1895:4:2:1:::0:0:", -- Archer's Belt
	[9518]="9499:1899:4:2:1:::0:0:", -- Mud's Crushers
	[4259]="9672:1934:4:2:1:::0:0:", -- Green Leather Bracers
	[7335]="9685:1937:4:2:1:::0:0:", -- Grizzly Tunic
	[15149]="9800:1960:4:2:1:::0:0:", -- Ghostwalker Gloves
	[10406]="9884:1976:4:2:1:::0:0:", -- Scaled Leather Headband
	[14588]="9947:1989:4:2:1:::0:0:", -- Hawkeye's Cord
	[15126]="9947:1989:4:2:1:::0:0:", -- Robust Leggings
	[3566]="10116:2023:4:2:1:::0:0:", -- Raptorbane Armor
	[15131]="10117:2023:4:2:1:::0:0:", -- Cutthroat's Boots
	[15337]="10136:2027:4:2:1:::0:0:", -- Wrangler's Wraps
	[14587]="10153:2030:4:2:1:::0:0:", -- Dokebi Mantle
	[6784]="10159:2031:4:2:1:::0:0:", -- Braced Handguards
	[15471]="10172:2034:4:2:1:::0:0:", -- Brawnhide Armor
	[6688]="10295:2059:4:2:1:::0:0:", -- Whisperwind Headdress
	[6204]="10327:2065:4:2:1:::0:0:", -- Tribal Worg Helm
	[7447]="10343:2068:4:2:1:::0:0:", -- Sentinel Bracers
	[9834]="10371:2074:4:2:1:::0:0:", -- Scaled Leather Shoulders
	[7448]="10380:2076:4:2:1:::0:0:", -- Sentinel Girdle
	[4832]="10497:2099:4:2:1:::1:1:148,652,802,847", -- Mystic Sarong
	[4107]="10682:2136:4:2:1:::0:0:", -- Tiger Hunter Gloves
	[7378]="10731:2146:4:2:1:::0:0:", -- Dusky Bracers
	[7413]="10785:2157:4:2:1:::0:0:", -- Infiltrator Cap
	[9450]="10908:2181:4:2:1:::0:0:", -- Gnomebot Operating Boots
	[6607]="11012:2202:4:2:1:::0:0:", -- Dervish Leggings
	[15361]="11024:2204:4:2:1:::0:0:", -- Trickster's Sash
	[4980]="11048:2209:4:2:1:::0:0:", -- Prospector Gloves
	[3750]="11048:2209:4:2:1:::0:0:", -- Ribbed Breastplate
	[4059]="11169:2233:4:2:1:::0:0:", -- Glyphed Bracers
	[14594]="11182:2236:4:2:1:::0:0:", -- Hawkeye's Gloves
	[7443]="11217:2243:4:2:1:::0:0:", -- Sentinel Gloves
	[16873]="11271:2254:4:2:1:::0:0:", -- Braidfur Gloves
	[17721]="11340:2268:4:2:1:::0:0:", -- Gloves of the Greatfather
	[7408]="11405:2281:4:2:1:::0:0:", -- Infiltrator Shoulders
	[7409]="11445:2289:4:2:1:::0:0:", -- Infiltrator Boots
	[6419]="11497:2299:4:2:1:::0:0:", -- Glyphed Mitts
	[5783]="11581:2316:4:2:1:::0:0:", -- Murloc Scale Bracers
	[6421]="11585:2317:4:2:1:::0:0:", -- Glyphed Belt
	[6603]="11674:2334:4:2:1:::0:0:", -- Dervish Tunic
	[5814]="11756:2351:4:2:1:::0:0:", -- Snapbrook Armor
	[4255]="11830:2366:4:2:1::164:0:0:", -- Green Leather Armor
	[15154]="11860:2372:4:2:1:::0:0:", -- Nocturnal Sash
	[15360]="11861:2372:4:2:1:::0:0:", -- Trickster's Bindings
	[4050]="11874:2374:4:2:1:::0:0:", -- Emblazoned Leggings
	[15350]="11924:2384:4:2:1:::0:0:", -- Headhunter's Slippers
	[7386]="11937:2387:4:2:1:::0:0:", -- Green Whelp Bracers
	[15365]="12078:2415:4:2:1:::0:0:", -- Trickster's Handwraps
	[6732]="12108:2421:4:2:1:::0:0:", -- Gnomish Mechanic's Gloves
	[15128]="12126:2425:4:2:1:::0:0:", -- Robust Tunic
	[10760]="12141:2428:4:2:1:::0:0:", -- Swine Fists
	[15160]="12151:2430:4:2:1:::0:0:", -- Nocturnal Wristbands
	[15339]="12333:2466:4:2:1:::0:0:", -- Pathfinder Hat
	[4055]="12406:2481:4:2:1:::0:0:", -- Insignia Boots
	[15344]="12582:2516:4:2:1:::0:0:", -- Pathfinder Pants
	[15140]="12649:2529:4:2:1:::0:0:", -- Cutthroat's Mantle
	[4260]="12796:2559:4:2:1:::0:0:", -- Guardian Leather Bracers
	[15155]="12856:2571:4:2:1:::0:0:", -- Nocturnal Gloves
	[7387]="12939:2587:4:2:1::202:0:0:", -- Dusky Belt
	[9886]="12948:2589:4:2:1:::0:0:", -- Huntsman's Bands
	[15142]="13016:2603:4:2:1:::0:0:", -- Ghostwalker Boots
	[5964]="13049:2609:4:2:1:::0:0:", -- Barbaric Shoulders
	[9891]="13181:2636:4:2:1:::0:0:", -- Huntsman's Belt
	[6794]="13206:2641:4:2:1:::0:0:", -- Stormfire Gauntlets
	[14598]="13275:2655:4:2:1:::0:0:", -- Warden's Waistband
	[14584]="13365:2673:4:2:1:::0:0:", -- Dokebi Hat
	[14600]="13377:2675:4:2:1:::0:0:", -- Warden's Wristbands
	[14585]="13438:2687:4:2:1:::0:0:", -- Dokebi Leggings
	[15357]="13467:2693:4:2:1:::0:0:", -- Headhunter's Spaulders
	[4052]="13498:2699:4:2:1:::0:0:", -- Insignia Cap
	[15346]="13941:2788:4:2:1:::0:0:", -- Pathfinder Vest
	[4509]="13970:2794:4:2:1:::0:0:", -- Seawolf Gloves
	[5962]="13972:2794:4:2:1:::0:0:", -- Guardian Pants
	[4264]="14022:2804:4:2:1:Buff::0:0:", -- Barbaric Belt
	[4721]="14047:2809:4:2:1:::0:0:", -- Insignia Mantle
	[6396]="14073:2814:4:2:1:::0:0:", -- Emblazoned Chestpiece
	[9856]="14195:2839:4:2:1:::0:0:", -- Archer's Boots
	[3011]="14234:2846:4:2:1:::0:0:", -- Feathered Headdress
	[9892]="14287:2857:4:2:1:::0:0:", -- Huntsman's Gloves
	[9859]="14359:2871:4:2:1:::0:0:", -- Archer's Cap
	[14581]="14562:2912:4:2:1:::0:0:", -- Dokebi Chestguard
	[15150]="14756:2951:4:2:1:::0:0:", -- Ghostwalker Pads
	[14606]="14775:2955:4:2:1:::0:0:", -- Warden's Gloves
	[6727]="14982:2996:4:2:1:::0:0:", -- Razzeric's Racing Grips
	[7480]="15095:3019:4:2:1:::0:0:", -- Ranger Gloves
	[9833]="15157:3031:4:2:1:::0:0:", -- Scaled Leather Leggings
	[9835]="15266:3053:4:2:1:::0:0:", -- Scaled Leather Tunic
	[15139]="15279:3055:4:2:1:::0:0:", -- Cutthroat's Pants
	[7484]="15314:3062:4:2:1:::0:0:", -- Ranger Wristguards
	[7485]="15367:3073:4:2:1:::0:0:", -- Ranger Cord
	[4455]="15483:3096:4:2:1:::0:0:", -- Raptor Hide Harness
	[7373]="15485:3097:4:2:1:::0:0:", -- Dusky Leather Leggings
	[15369]="15486:3097:4:2:1:::0:0:", -- Wolf Rider's Belt
	[5963]="15756:3151:4:2:1:::0:0:", -- Barbaric Leggings
	[7414]="15879:3175:4:2:1:::0:0:", -- Infiltrator Pants
	[15377]="15959:3191:4:2:1:::0:0:", -- Wolf Rider's Wristbands
	[9863]="16037:3207:4:2:1:::0:0:", -- Archer's Shoulderpads
	[5782]="16055:3211:4:2:1:::0:0:", -- Thick Murloc Armor
	[6720]="16094:3218:4:2:1:::0:0:", -- Spirit Hunter Headdress
	[15130]="16262:3252:4:2:1:::0:0:", -- Cutthroat's Vest
	[4738]="16471:3294:4:2:1:::0:0:", -- Imperial Leather Belt
	[14589]="16473:3294:4:2:1:::0:0:", -- Hawkeye's Shoes
	[15134]="16475:3295:4:2:1:::0:0:", -- Cutthroat's Hat
	[4061]="16531:3306:4:2:1:::0:0:", -- Imperial Leather Bracers
	[10721]="16587:3317:4:2:1:::0:0:", -- Gnomish Harm Prevention Belt
	[15161]="16596:3319:4:2:1:::0:0:", -- Imposing Belt
	[6788]="16658:3331:4:2:1:::0:0:", -- Magram Hunter's Belt
	[15163]="16723:3344:4:2:1:::0:0:", -- Imposing Bracers
	[6690]="16731:3346:4:2:1:::0:0:", -- Ferine Leggings
	[4810]="16759:3351:4:2:1:::0:0:", -- Boulder Pads
	[10765]="16837:3367:4:2:1:::0:0:", -- Bonefingers
	[7444]="16887:3377:4:2:1:::0:0:", -- Sentinel Boots
	[15372]="16917:3383:4:2:1:::0:0:", -- Wolf Rider's Gloves
	[14596]="16942:3388:4:2:1:::0:0:", -- Hawkeye's Epaulets
	[15353]="17337:3467:4:2:1:::0:0:", -- Headhunter's Headdress
	[4256]="17387:3477:4:2:1:::0:0:", -- Guardian Armor
	[7441]="17573:3514:4:2:1:::0:0:", -- Sentinel Cap
	[9916]="17834:3566:4:2:1:::0:0:", -- Tracker's Belt
	[9704]="17865:3573:4:2:1:::0:0:", -- Rustler Gloves
	[9705]="17930:3586:4:2:1:::0:0:", -- Tharg's Shoelace
	[4063]="17980:3596:4:2:1:::0:0:", -- Imperial Leather Gloves
	[15358]="18020:3604:4:2:1:::0:0:", -- Headhunter's Woolies
	[9382]="18039:3607:4:2:1:::0:0:", -- Tromping Miner's Boots
	[4054]="18129:3625:4:2:1:::0:0:", -- Insignia Leggings
	[7445]="18303:3660:4:2:1:::0:0:", -- Sentinel Shoulders
	[7407]="18333:3666:4:2:1:::0:0:", -- Infiltrator Armor
	[15368]="18371:3674:4:2:1:::0:0:", -- Trickster's Pauldrons
	[1280]="18481:3696:4:2:1:::0:0:", -- Cloaked Hood
	[9920]="18606:3721:4:2:1:::0:0:", -- Tracker's Gloves
	[15146]="18652:3730:4:2:1:::0:0:", -- Ghostwalker Crown
	[6420]="18698:3739:4:2:1:::0:0:", -- Glyphed Boots
	[7374]="18804:3760:4:2:1:::0:0:", -- Dusky Leather Armor
	[6422]="18840:3768:4:2:1:::0:0:", -- Glyphed Helm
	[7375]="18869:3773:4:2:1:::0:0:", -- Green Whelp Armor
	[9925]="18949:3789:4:2:1:::0:0:", -- Tracker's Wristguards
	[4131]="19079:3815:4:2:1:::0:0:", -- Belt of Corruption
	[4731]="19122:3824:4:2:1:::0:0:", -- Glyphed Epaulets
	[9682]="19159:3831:4:2:1:::0:0:", -- Leather Chef's Belt
	[9631]="19341:3868:4:2:1:::0:0:", -- Pratt's Handcrafted Gloves
	[15362]="19357:3871:4:2:1:::0:0:", -- Trickster's Boots
	[9632]="19416:3883:4:2:1:::0:0:", -- Jangdor's Handcrafted Gloves
	[14654]="19655:3931:4:2:1:::0:0:", -- Scorpashi Wristbands
	[15356]="19678:3935:4:2:1:::0:0:", -- Headhunter's Armor
	[15166]="19728:3945:4:2:1:::0:0:", -- Imposing Gloves
	[15151]="19747:3949:4:2:1:::0:0:", -- Ghostwalker Legguards
	[4124]="19956:3991:4:2:1:::0:0:", -- Cap of Harmony
	[7534]="20080:4016:4:2:1:::0:0:", -- Cabalist Bracers
	[4057]="20163:4032:4:2:1:::0:0:", -- Insignia Chestguard
	[4543]="20494:4098:4:2:1:::0:0:", -- White Drakeskin Cap
	[8174]="20657:4131:4:2:1:::0:0:", -- Comfortable Leather Hat
	[9885]="20899:4179:4:2:1:::0:0:", -- Huntsman's Boots
	[14591]="20903:4180:4:2:1:::0:0:", -- Hawkeye's Helm
	[14657]="20979:4195:4:2:1:::0:0:", -- Scorpashi Gloves
	[14652]="21079:4215:4:2:1:::0:0:", -- Scorpashi Sash
	[15144]="21160:4232:4:2:1:::0:0:", -- Ghostwalker Rags
	[7390]="21188:4237:4:2:1:::0:0:", -- Dusky Boots
	[9889]="21203:4240:4:2:1:::0:0:", -- Huntsman's Cap
	[7391]="21265:4253:4:2:1:::0:0:", -- Swift Boots
	[9862]="21302:4260:4:2:1:::0:0:", -- Archer's Trousers
	[7530]="21366:4273:4:2:1:::0:0:", -- Cabalist Gloves
	[15158]="21602:4320:4:2:1:::0:0:", -- Nocturnal Shoulder Pads
	[9389]="21657:4331:4:2:1:::0:0:", -- Revelosh's Spaulders
	[7535]="21769:4353:4:2:1:::0:0:", -- Cabalist Belt
	[15378]="21793:4358:4:2:1:::0:0:", -- Rageclaw Belt
	[10748]="21903:4380:4:2:1:::0:0:", -- Wanderlust Boots
	[14603]="21916:4383:4:2:1:::0:0:", -- Warden's Mantle
	[15380]="21954:4390:4:2:1:::0:0:", -- Rageclaw Bracers
	[4109]="21966:4393:4:2:1:::0:0:", -- Excelsior Boots
	[8118]="22184:4436:4:2:1:::0:0:", -- Heraldic Bracers
	[15456]="22211:4442:4:2:1:::0:0:", -- Lightstep Leggings
	[15152]="22247:4449:4:2:1:::0:0:", -- Nocturnal Shoes
	[8176]="22475:4495:4:2:1:::0:0:", -- Nightscape Headband
	[14595]="22502:4500:4:2:1:::0:0:", -- Hawkeye's Breeches
	[17778]="22532:4506:4:2:1:::0:0:", -- Sagebrush Girdle
	[8116]="23160:4632:4:2:1:::0:0:", -- Heraldic Belt
	[9894]="23308:4661:4:2:1:::0:0:", -- Huntsman's Shoulders
	[14599]="23316:4663:4:2:1:::0:0:", -- Warden's Footpads
	[15172]="23534:4706:4:2:1:::0:0:", -- Potent Bands
	[8192]="23914:4782:4:2:1:::0:0:", -- Nightscape Shoulders
	[8121]="24219:4843:4:2:1:::0:0:", -- Heraldic Gloves
	[9949]="24276:4855:4:2:1:::0:0:", -- Chieftain's Bracers
	[7479]="24365:4873:4:2:1:::0:0:", -- Ranger Helm
	[15363]="24473:4894:4:2:1:::0:0:", -- Trickster's Headdress
	[7481]="24541:4908:4:2:1:::0:0:", -- Ranger Boots
	[7482]="24630:4926:4:2:1:::0:0:", -- Ranger Shoulders
	[9854]="24677:4935:4:2:1:::0:0:", -- Archer's Jerkin
	[15178]="24679:4935:4:2:1:::0:0:", -- Potent Belt
	[6433]="24767:4953:4:2:1:::0:0:", -- Imperial Leather Helm
	[7440]="25212:5042:4:2:1:::0:0:", -- Sentinel Trousers
	[15375]="25663:5132:4:2:1:::0:0:", -- Wolf Rider's Shoulder Pads
	[14663]="25707:5141:4:2:1:::0:0:", -- Keeper's Bindings
	[9947]="25965:5193:4:2:1:::0:0:", -- Chieftain's Belt
	[15366]="26251:5250:4:2:1:::0:0:", -- Trickster's Leggings
	[9952]="26276:5255:4:2:1:::0:0:", -- Chieftain's Gloves
	[15156]="26332:5266:4:2:1:::0:0:", -- Nocturnal Cap
	[10067]="26478:5295:4:2:1:::0:0:", -- Righteous Waistguard
	[15383]="26565:5313:4:2:1:::0:0:", -- Rageclaw Gloves
	[9657]="26669:5333:4:2:1:::0:0:", -- Vinehedge Cinch
	[10069]="26677:5335:4:2:1:::0:0:", -- Righteous Bracers
	[8201]="26754:5350:4:2:1:::0:0:", -- Big Voodoo Mask
	[10702]="26897:5379:4:2:1:::0:0:", -- Enormous Ogre Boots
	[4108]="27017:5403:4:2:1:::0:0:", -- Panther Hunter Leggings
	[7439]="27127:5425:4:2:1:::0:0:", -- Sentinel Breastplate
	[6431]="27181:5436:4:2:1:::0:0:", -- Imperial Leather Boots
	[15370]="27198:5439:4:2:1:::0:0:", -- Wolf Rider's Boots
	[14661]="27305:5461:4:2:1:::0:0:", -- Keeper's Cord
	[4976]="27431:5486:4:2:1:::0:0:", -- Mistspray Kilt
	[9917]="27598:5519:4:2:1:::0:0:", -- Tracker's Boots
	[8210]="27685:5537:4:2:1:::0:0:", -- Wild Leather Shoulders
	[15169]="27713:5542:4:2:1:::0:0:", -- Imposing Shoulders
	[15387]="27919:5583:4:2:1:::0:0:", -- Jadefire Bracelets
	[14592]="27974:5594:4:2:1:::0:0:", -- Hawkeye's Tunic
	[4060]="28244:5648:4:2:1:::0:0:", -- Glyphed Leggings
	[4737]="28715:5743:4:2:1:::0:0:", -- Imperial Leather Spaulders
	[9630]="28903:5780:4:2:1:::0:0:", -- Pratt's Handcrafted Boots
	[19119]="29015:5803:4:2:1:::0:0:", -- Owlbeast Hide Gloves
	[15162]="29146:5829:4:2:1:::0:0:", -- Imposing Boots
	[9633]="29237:5847:4:2:1:::0:0:", -- Jangdor's Handcrafted Boots
	[15359]="29776:5955:4:2:1:::0:0:", -- Trickster's Vest
	[8175]="29857:5971:4:2:1:::0:0:", -- Nightscape Tunic
	[14604]="29930:5986:4:2:1:::0:0:", -- Warden's Wizard Hat
	[15182]="29982:5996:4:2:1:::0:0:", -- Praetorian Wristbands
	[8255]="30052:6010:4:2:1:::0:0:", -- Serpentskin Girdle
	[15174]="30087:6017:4:2:1:::0:0:", -- Potent Gloves
	[9921]="30252:6050:4:2:1:::0:0:", -- Tracker's Headband
	[8257]="30265:6053:4:2:1:::0:0:", -- Serpentskin Bracers
	[4058]="30283:6056:4:2:1:::0:0:", -- Glyphed Breastplate
	[9923]="30477:6095:4:2:1:::0:0:", -- Tracker's Shoulderpads
	[10072]="30886:6177:4:2:1:::0:0:", -- Righteous Gloves
	[15157]="31000:6200:4:2:1:::0:0:", -- Nocturnal Leggings
	[8214]="31151:6230:4:2:1:::0:0:", -- Wild Leather Helmet
	[15388]="31785:6357:4:2:1:::0:0:", -- Jadefire Belt
	[14666]="31836:6367:4:2:1:::0:0:", -- Keeper's Gloves
	[7531]="32171:6434:4:2:1:::0:0:", -- Cabalist Boots
	[15393]="32395:6479:4:2:1:::0:0:", -- Jadefire Gloves
	[11502]="32551:6510:4:2:1:::0:0:", -- Loreskin Shoulders
	[10184]="32617:6523:4:2:1:::0:0:", -- Swashbuckler's Bracers
	[10190]="33349:6669:4:2:1:::0:0:", -- Swashbuckler's Belt
	[15180]="33433:6686:4:2:1:::0:0:", -- Praetorian Girdle
	[9893]="33448:6689:4:2:1:::0:0:", -- Huntsman's Leggings
	[15159]="33715:6743:4:2:1:::0:0:", -- Nocturnal Tunic
	[14653]="34271:6854:4:2:1:::0:0:", -- Scorpashi Slippers
	[15074]="34335:6867:4:2:1:::0:0:", -- Chimeric Gloves
	[14605]="34340:6868:4:2:1:::0:0:", -- Warden's Woolies
	[15083]="34363:6872:4:2:1:::0:0:", -- Wicked Leather Gauntlets
	[7529]="34486:6897:4:2:1:::0:0:", -- Cabalist Helm
	[15373]="34652:6930:4:2:1:::0:0:", -- Wolf Rider's Headgear
	[8260]="34691:6938:4:2:1:::0:0:", -- Serpentskin Gloves
	[10186]="34834:6966:4:2:1:::0:0:", -- Swashbuckler's Gloves
	[7532]="34876:6975:4:2:1:::0:0:", -- Cabalist Spaulders
	[7478]="34958:6991:4:2:1:::0:0:", -- Ranger Leggings
	[14660]="35315:7063:4:2:1:::0:0:", -- Scorpashi Shoulder Pads
	[9887]="35357:7071:4:2:1:::0:0:", -- Huntsman's Armor
	[11665]="35550:7110:4:2:1:::0:0:", -- Ogreseer Fists
	[8197]="35790:7158:4:2:1:::0:0:", -- Nightscape Boots
	[8117]="35808:7161:4:2:1:::0:0:", -- Heraldic Boots
	[15091]="35978:7195:4:2:1:::0:0:", -- Runic Leather Gauntlets
	[15184]="35986:7197:4:2:1:::0:0:", -- Praetorian Gloves
	[10107]="36094:7218:4:2:1:::0:0:", -- Wanderer's Bracers
	[4119]="36357:7271:4:2:1:::0:0:", -- Raptor Hunter Tunic
	[10109]="36366:7273:4:2:1:::0:0:", -- Wanderer's Belt
	[8200]="36378:7275:4:2:1:::0:0:", -- Big Voodoo Robe
	[15386]="36437:7287:4:2:1:::0:0:", -- Rageclaw Shoulder Pads
	[16739]="36502:7300:4:2:1:::0:0:", -- Rugwood Mantle
	[14601]="36535:7307:4:2:1:::0:0:", -- Warden's Wraps
	[14672]="36548:7309:4:2:1:::0:0:", -- Pridelord Bands
	[15084]="36555:7311:4:2:1:::0:0:", -- Wicked Leather Bracers
	[15374]="36816:7363:4:2:1:::0:0:", -- Wolf Rider's Leggings
	[17776]="36888:7377:4:2:1:::0:0:", -- Sprightring Helm
	[19039]="37019:7403:4:2:1:::0:0:", -- Zorbin's Water Resistant Hat
	[15167]="37421:7484:4:2:1:::0:0:", -- Imposing Bandana
	[15379]="38271:7654:4:2:1:::0:0:", -- Rageclaw Boots
	[15092]="38283:7656:4:2:1:::0:0:", -- Runic Leather Bracers
	[8122]="39377:7875:4:2:1:::0:0:", -- Heraldic Headpiece
	[14658]="39422:7884:4:2:1:::0:0:", -- Scorpashi Skullcap
	[8124]="39660:7932:4:2:1:::0:0:", -- Heraldic Spaulders
	[10110]="39739:7947:4:2:1:::0:0:", -- Wanderer's Gloves
	[15168]="39757:7951:4:2:1:::0:0:", -- Imposing Pants
	[9647]="39813:7962:4:2:1:::0:0:", -- Failed Flying Experiment
	[8295]="39940:7988:4:2:1:::0:0:", -- Traveler's Bracers
	[8211]="40012:8002:4:2:1:::0:0:", -- Wild Leather Vest
	[15428]="40120:8024:4:2:1:::0:0:", -- Peerless Belt
	[7477]="40624:8124:4:2:1:::0:0:", -- Ranger Tunic
	[8213]="40753:8150:4:2:1:::0:0:", -- Wild Leather Boots
	[14675]="40910:8182:4:2:1:::0:0:", -- Pridelord Gloves
	[11909]="41337:8267:4:2:1:::0:0:", -- Excavator's Utility Belt
	[14674]="41353:8270:4:2:1:::0:0:", -- Pridelord Girdle
	[15425]="41364:8272:4:2:1:::0:0:", -- Peerless Bracers
	[4062]="41795:8359:4:2:1:::0:0:", -- Imperial Leather Pants
	[9948]="41826:8365:4:2:1:::0:0:", -- Chieftain's Boots
	[15093]="41843:8368:4:2:1:::0:0:", -- Runic Leather Belt
	[9953]="42335:8467:4:2:1:::0:0:", -- Chieftain's Headdress
	[10745]="42492:8498:4:2:1:::0:0:", -- Kaylari Shoulders
	[15177]="42628:8525:4:2:1:::0:0:", -- Potent Shoulders
	[9955]="42654:8530:4:2:1:::0:0:", -- Chieftain's Shoulders
	[8293]="42713:8542:4:2:1:::0:0:", -- Traveler's Belt
	[8298]="42825:8565:4:2:1:::0:0:", -- Traveler's Gloves
	[9414]="43227:8645:4:2:1:::0:0:", -- Oilskin Leggings
	[15376]="43266:8653:4:2:1:::0:0:", -- Wolf Rider's Padded Armor
	[15171]="43487:8697:4:2:1:::0:0:", -- Potent Boots
	[15188]="43512:8702:4:2:1:::0:0:", -- Grand Armguards
	[8193]="43542:8708:4:2:1:::0:0:", -- Nightscape Pants
	[12114]="43671:8734:4:2:1:::0:0:", -- Nightfall Gloves
	[9922]="43726:8745:4:2:1:::0:0:", -- Tracker's Leggings
	[15708]="44825:8965:4:2:1:::0:0:", -- Blight Leather Gloves
	[8202]="45112:9022:4:2:1:::0:0:", -- Big Voodoo Pants
	[15191]="45174:9034:4:2:1:::0:0:", -- Grand Belt
	[15429]="45248:9049:4:2:1:::0:0:", -- Peerless Gloves
	[6430]="45493:9098:4:2:1:::0:0:", -- Imperial Leather Breastplate
	[10068]="45640:9128:4:2:1:::0:0:", -- Righteous Boots
	[15164]="45679:9135:4:2:1:::0:0:", -- Imposing Vest
	[10221]="45742:9148:4:2:1:::0:0:", -- Nightshade Girdle
	[15384]="45778:9155:4:2:1:::0:0:", -- Rageclaw Helm
	[10075]="46845:9369:4:2:1:::0:0:", -- Righteous Spaulders
	[14659]="46912:9382:4:2:1:::0:0:", -- Scorpashi Leggings
	[14662]="47065:9413:4:2:1:::0:0:", -- Keeper's Hooves
	[10223]="47330:9466:4:2:1:::0:0:", -- Nightshade Armguards
	[15070]="47521:9504:4:2:1:::0:0:", -- Frostsaber Gloves
	[14669]="48270:9654:4:2:1:::0:0:", -- Keeper's Mantle
	[15175]="48462:9692:4:2:1:::0:0:", -- Potent Helmet
	[10145]="48779:9755:4:2:1:::0:0:", -- Mighty Girdle
	[10073]="49293:9858:4:2:1:::0:0:", -- Righteous Helmet
	[13537]="49420:9884:4:2:1:::0:0:", -- Chillhide Bracers
	[16994]="49420:9884:4:2:1:::0:0:", -- Duskwing Gloves
	[18451]="49420:9884:4:2:1:::0:0:", -- Hyena Hide Belt
	[7528]="49471:9894:4:2:1:::0:0:", -- Cabalist Leggings
	[15088]="49508:9901:4:2:1:::0:0:", -- Wicked Leather Belt
	[14682]="49534:9906:4:2:1:::0:0:", -- Indomitable Armguards
	[19041]="49732:9946:4:2:1:::0:0:", -- Pratt's Handcrafted Tunic
	[19042]="49920:9984:4:2:1:::0:0:", -- Jangdor's Handcrafted Tunic
	[10225]="50062:10012:4:2:1:::0:0:", -- Nightshade Gloves
	[11963]="50128:10025:4:2:1:::0:0:", -- Penance Spaulders
	[10741]="50318:10063:4:2:1:::0:0:", -- Lordrec Helmet
	[15389]="50734:10146:4:2:1:::0:0:", -- Jadefire Sabatons
	[10827]="51191:10238:4:2:1:::0:0:", -- Surveyor's Tunic
	[8256]="51306:10261:4:2:1:::0:0:", -- Serpentskin Boots
	[9924]="51380:10276:4:2:1:::0:0:", -- Tracker's Tunic
	[10147]="51596:10319:4:2:1:::0:0:", -- Mighty Armsplints
	[8263]="51866:10373:4:2:1:::0:0:", -- Serpentskin Spaulders
	[15395]="51898:10379:4:2:1:::0:0:", -- Jadefire Epaulets
	[14655]="51962:10392:4:2:1:::0:0:", -- Scorpashi Breastplate
	[14636]="51983:10396:4:2:1:::0:0:", -- Cadaverous Belt
	[14684]="52389:10477:4:2:1:::0:0:", -- Indomitable Belt
	[15436]="52596:10519:4:2:1:::0:0:", -- Supreme Bracers
	[14640]="52783:10556:4:2:1:::0:0:", -- Cadaverous Gloves
	[15192]="52979:10595:4:2:1:::0:0:", -- Grand Gauntlets
	[8261]="53086:10617:4:2:1:::0:0:", -- Serpentskin Helm
	[11871]="53331:10666:4:2:1:::0:0:", -- Snarkshaw Spaulders
	[10256]="53376:10675:4:2:1:::0:0:", -- Adventurer's Bracers
	[14667]="53852:10770:4:2:1:::0:0:", -- Keeper's Wreath
	[13526]="54485:10897:4:2:1:::0:0:", -- Flamescarred Girdle
	[10149]="54579:10915:4:2:1:::0:0:", -- Mighty Gauntlets
	[15187]="54593:10918:4:2:1:::0:0:", -- Praetorian Pauldrons
	[10183]="54772:10954:4:2:1:::0:0:", -- Swashbuckler's Boots
	[15434]="54823:10964:4:2:1:::0:0:", -- Supreme Sash
	[8123]="56379:11275:4:2:1:::0:0:", -- Heraldic Leggings
	[7527]="56423:11284:4:2:1:::0:0:", -- Cabalist Chestpiece
	[15822]="56454:11290:4:2:1:::0:0:", -- Shadowskin Spaulders
	[15181]="56561:11312:4:2:1:::0:0:", -- Praetorian Boots
	[10259]="56679:11335:4:2:1:::0:0:", -- Adventurer's Belt
	[15071]="57218:11443:4:2:1:::0:0:", -- Frostsaber Boots
	[15385]="57248:11449:4:2:1:::0:0:", -- Rageclaw Leggings
	[15073]="57650:11530:4:2:1:::0:0:", -- Chimeric Boots
	[8212]="57925:11585:4:2:1:::0:0:", -- Wild Leather Leggings
	[14685]="57970:11594:4:2:1:::0:0:", -- Indomitable Gauntlets
	[11685]="58088:11617:4:2:1:::0:0:", -- Splinthide Shoulders
	[10187]="58928:11785:4:2:1:::0:0:", -- Swashbuckler's Eyepatch
	[11916]="59171:11834:4:2:1:::0:0:", -- Shizzle's Muzzle
	[10189]="59360:11872:4:2:1:::0:0:", -- Swashbuckler's Shoulderpads
	[10260]="59729:11945:4:2:1:::0:0:", -- Adventurer's Gloves
	[11675]="60266:12053:4:2:1:::0:0:", -- Shadefiend Boots
	[10106]="60601:12120:4:2:1:::0:0:", -- Wanderer's Boots
	[15176]="60606:12121:4:2:1:::0:0:", -- Potent Pants
	[11874]="60620:12124:4:2:1:::0:0:", -- Clouddrift Mantle
	[9954]="60629:12125:4:2:1:::0:0:", -- Chieftain's Leggings
	[15391]="60890:12178:4:2:1:::0:0:", -- Jadefire Cap
	[19127]="61290:12258:4:2:1:::0:0:", -- Charred Leather Tunic
	[15438]="61324:12264:4:2:1:::0:0:", -- Supreme Gloves
	[15381]="62967:12593:4:2:1:::0:0:", -- Rageclaw Chestguard
	[8294]="63259:12651:4:2:1:::0:0:", -- Traveler's Boots
	[8119]="63629:12725:4:2:1:::0:0:", -- Heraldic Breastplate
	[17751]="63936:12787:4:2:1:::0:0:", -- Brusslehide Leggings
	[15185]="64529:12905:4:2:1:::0:0:", -- Praetorian Coif
	[18043]="64563:12912:4:2:1:::0:0:", -- Coal Miner Boots
	[14671]="65062:13012:4:2:1:::0:0:", -- Pridelord Boots
	[15170]="65519:13103:4:2:1:::0:0:", -- Potent Armor
	[15086]="65771:13154:4:2:1:::0:0:", -- Wicked Leather Headband
	[14678]="65780:13156:4:2:1:::0:0:", -- Pridelord Pauldrons
	[10785]="66003:13200:4:2:1:::0:0:", -- Atal'ai Leggings
	[9950]="67091:13418:4:2:1:::0:0:", -- Chieftain's Breastplate
	[15426]="67098:13419:4:2:1:::0:0:", -- Peerless Boots
	[10111]="67223:13444:4:2:1:::0:0:", -- Wanderer's Hat
	[18308]="67239:13447:4:2:1:::0:0:", -- Clever Hat
	[9652]="67330:13466:4:2:1:::0:0:", -- Gryphon Rider's Leggings
	[10113]="67708:13541:4:2:1:::0:0:", -- Wanderer's Shoulders
	[14668]="67984:13596:4:2:1:::0:0:", -- Keeper's Woolies
	[18411]="68520:13704:4:2:1:::0:0:", -- Spry Boots
	[12082]="68634:13726:4:2:1:::0:0:", -- Wyrmhide Spaulders
	[14676]="69205:13841:4:2:1:::0:0:", -- Pridelord Halo
	[10074]="69928:13985:4:2:1:::0:0:", -- Righteous Leggings
	[15432]="70524:14104:4:2:1:::0:0:", -- Peerless Shoulders
	[15792]="70770:14154:4:2:1:::0:0:", -- Plow Wood Spaulders
	[15094]="70777:14155:4:2:1:::0:0:", -- Runic Leather Headband
	[8299]="71769:14353:4:2:1:::0:0:", -- Traveler's Helm
	[12041]="72233:14446:4:2:1:::0:0:", -- Windshear Leggings
	[10222]="72310:14462:4:2:1:::0:0:", -- Nightshade Boots
	[8301]="72317:14463:4:2:1:::0:0:", -- Traveler's Spaulders
	[15693]="72665:14533:4:2:1:::0:0:", -- Grand Shoulders
	[15054]="72799:14559:4:2:1:::0:0:", -- Volcanic Leggings
	[8262]="73029:14605:4:2:1:::0:0:", -- Serpentskin Leggings
	[15394]="73074:14614:4:2:1:::0:0:", -- Jadefire Pants
	[15058]="73464:14692:4:2:1:::0:0:", -- Stormshroud Shoulders
	[16995]="74130:14826:4:2:1:::0:0:", -- Duskwing Mantle
	[15861]="74845:14969:4:2:1:::0:0:", -- Swiftfoot Treads
	[14664]="75293:15058:4:2:1:::0:0:", -- Keeper's Armor
	[10781]="75359:15071:4:2:1:::0:0:", -- Hakkar'i Breastplate
	[18476]="75747:15149:4:2:1:::0:0:", -- Mud Stained Boots
	[15186]="76867:15373:4:2:1:::0:0:", -- Praetorian Leggings
	[15430]="77176:15435:4:2:1:::0:0:", -- Peerless Headband
	[10070]="77411:15482:4:2:1:::0:0:", -- Righteous Armor
	[15189]="78614:15722:4:2:1:::0:0:", -- Grand Boots
	[14641]="79477:15895:4:2:1:::0:0:", -- Cadaverous Walkers
	[10228]="79702:15940:4:2:1:::0:0:", -- Nightshade Spaulders
	[15055]="80097:16019:4:2:1:::0:0:", -- Volcanic Shoulders
	[15390]="80876:16175:4:2:1:::0:0:", -- Jadefire Chestguard
	[10146]="80970:16194:4:2:1:::0:0:", -- Mighty Boots
	[15072]="81169:16233:4:2:1:::0:0:", -- Chimeric Leggings
	[11876]="81437:16287:4:2:1:::0:0:", -- Plainstalker Tunic
	[12793]="82691:16538:4:2:1:::0:0:", -- Mixologist's Tunic
	[10226]="83084:16616:4:2:1:::0:0:", -- Nightshade Helmet
	[10188]="83587:16717:4:2:1:::0:0:", -- Swashbuckler's Leggings
	[14688]="83712:16742:4:2:1:::0:0:", -- Indomitable Epaulets
	[10257]="84385:16877:4:2:1:::0:0:", -- Adventurer's Boots
	[11193]="84692:16938:4:2:1:::0:0:", -- Blazewind Breastplate
	[15069]="85064:17012:4:2:1:::0:0:", -- Frostsaber Leggings
	[12960]="85626:17125:4:2:1:::0:0:", -- Tribal War Feathers
	[14681]="85696:17139:4:2:1:::0:0:", -- Indomitable Boots
	[10150]="86270:17254:4:2:1:::0:0:", -- Mighty Helmet
	[15053]="86377:17275:4:2:1:::0:0:", -- Volcanic Breastplate
	[15096]="86664:17332:4:2:1:::0:0:", -- Runic Leather Shoulders
	[8258]="86983:17396:4:2:1:::0:0:", -- Serpentskin Armor
	[10153]="87221:17444:4:2:1:::0:0:", -- Mighty Spaulders
	[15193]="87933:17586:4:2:1:::0:0:", -- Grand Crown
	[15087]="89463:17892:4:2:1:::0:0:", -- Wicked Leather Pants
	[10261]="89927:17985:4:2:1:::0:0:", -- Adventurer's Bandana
	[10263]="90583:18116:4:2:1:::0:0:", -- Adventurer's Shoulders
	[15435]="90997:18199:4:2:1:::0:0:", -- Supreme Shoes
	[14686]="91636:18327:4:2:1:::0:0:", -- Indomitable Headdress
	[10182]="91850:18370:4:2:1:::0:0:", -- Swashbuckler's Breastplate
	[15075]="92245:18449:4:2:1:::0:0:", -- Chimeric Vest
	[14677]="92621:18524:4:2:1:::0:0:", -- Pridelord Pants
	[15179]="92965:18593:4:2:1:::0:0:", -- Praetorian Padded Armor
	[15441]="92977:18595:4:2:1:::0:0:", -- Supreme Shoulders
	[15786]="94134:18826:4:2:1:::0:0:", -- Fernpulse Jerkin
	[10112]="95356:19071:4:2:1:::0:0:", -- Wanderer's Leggings
	[15825]="96512:19302:4:2:1:::0:0:", -- Traphook Jerkin
	[15439]="96936:19387:4:2:1:::0:0:", -- Supreme Crown
	[15431]="98368:19673:4:2:1:::0:0:", -- Peerless Leggings
	[11823]="98654:19730:4:2:1:::0:0:", -- Luminary Kilt
	[18478]="98841:19768:4:2:1:::0:0:", -- Hyena Hide Jerkin
	[18477]="98841:19768:4:2:1:::0:0:", -- Shaggy Leggings
	[10105]="99711:19942:4:2:1:::0:0:", -- Wanderer's Armor
	[8300]="100862:20172:4:2:1:::0:0:", -- Traveler's Leggings
	[14670]="101980:20396:4:2:1:::0:0:", -- Pridelord Armor
	[8296]="104305:20861:4:2:1:::0:0:", -- Traveler's Jerkin
	[15095]="104426:20885:4:2:1:::0:0:", -- Runic Leather Pants
	[14638]="104773:20954:4:2:1:::0:0:", -- Cadaverous Leggings
	[13531]="105959:21191:4:2:1:::0:0:", -- Crypt Stalker Leggings
	[15068]="109178:21835:4:2:1:::0:0:", -- Frostsaber Tunic
	[15433]="109245:21849:4:2:1:::0:0:", -- Peerless Armor
	[15090]="110012:22002:4:2:1:::0:0:", -- Runic Leather Armor
	[15194]="112063:22412:4:2:1:::0:0:", -- Grand Legguards
	[15085]="113662:22732:4:2:1:::0:0:", -- Wicked Leather Armor
	[10220]="116316:23263:4:2:1:::0:0:", -- Nightshade Tunic
	[10227]="116741:23348:4:2:1:::0:0:", -- Nightshade Leggings
	[14687]="116787:23357:4:2:1:::0:0:", -- Indomitable Leggings
	[15195]="118089:23617:4:2:1:::0:0:", -- Grand Breastplate
	[10152]="121666:24333:4:2:1:::0:0:", -- Mighty Leggings
	[15440]="123537:24707:4:2:1:::0:0:", -- Supreme Leggings
	[14680]="125507:25101:4:2:1:::0:0:", -- Indomitable Vest
	[10262]="126364:25272:4:2:1:::0:0:", -- Adventurer's Legguards
	[10151]="127283:25456:4:2:1:::0:0:", -- Mighty Tunic
	[10264]="133648:26729:4:2:1:::0:0:", -- Adventurer's Tunic
	[15442]="137166:27433:4:2:1:::0:0:", -- Supreme Breastplate
	[6468]="3292:658:4:2:1:::0:0:", -- Deviate Scale Belt
	[12999]="4267:853:4:2:1:::0:0:", -- Drakewing Bands
	[4253]="4810:962:4:2:1:::0:0:", -- Toughened Leather Gloves
	[888]="4903:980:4:2:1:::0:0:", -- Naga Battle Gloves
	[1978]="4904:980:4:2:1:::0:0:", -- Wolfclaw Gloves
	[13011]="5155:1031:4:2:1:::0:0:", -- Silver-lined Belt
	[720]="5350:1070:4:2:1:::0:0:", -- Brawler Gloves
	[1121]="5375:1075:4:2:1:::0:0:", -- Feet of the Lynx
	[12988]="5687:1137:4:2:1:::0:0:", -- Starsight Tunic
	[10410]="6280:1256:4:2:1:::0:0:", -- Leggings of the Fang
	[2041]="7060:1412:4:2:1:::0:0:", -- Tunic of Westfall
	[6911]="7210:1442:4:2:1:::0:0:", -- Moss Cinch
	[16977]="7242:1448:4:2:1:::0:0:", -- Warsong Boots
	[10399]="7335:1467:4:2:1:::0:0:", -- Blackened Defias Armor
	[1489]="7767:1553:4:2:1:::0:0:", -- Gloomshroud Armor
	[18948]="7945:1589:4:2:1:::0:0:", -- Barbaric Bracers
	[9455]="9129:1825:4:2:1:::0:0:", -- Emissary Cuffs
	[2264]="9788:1957:4:2:1:::0:0:", -- Mantle of Thieves
	[7754]="9798:1959:4:2:1:::0:0:", -- Harbinger Boots
	[9428]="10481:2096:4:2:1:::0:0:", -- Unearthed Bands
	[7690]="11164:2232:4:2:1:::0:0:", -- Ebon Vise
	[2278]="11633:2326:4:2:1:::0:0:", -- Forest Tracker Epaulets
	[7727]="12444:2488:4:2:1:::0:0:", -- Watchman Pauldrons
	[13114]="12870:2574:4:2:1:::0:0:", -- Troll's Bane Leggings
	[4262]="13260:2652:4:2:1:::0:0:", -- Gem-studded Leather Belt
	[3020]="13279:2655:4:2:1:::0:0:", -- Enduring Cap
	[9509]="13416:2683:4:2:1:::0:0:", -- Petrolspill Leggings
	[13119]="15316:3063:4:2:1:::0:0:", -- Enchanted Kodo Bracers
	[18238]="16608:3321:4:2:1:::0:0:", -- Shadowskin Gloves
	[18453]="16716:3343:4:2:1:::1:0:635", -- Sergeant Major's Dragonhide Armsplints
	[18455]="16716:3343:4:2:1:::1:0:635", -- Sergeant Major's Leather Armsplints
	[18436]="17086:3417:4:2:1:::1:0:708", -- First Sergeant's Dragonhide Armguards
	[10582]="18031:3606:4:2:1:::0:0:", -- Briar Tredders
	[18435]="18311:3662:4:2:1:::1:0:708", -- First Sergeant's Leather Armguards
	[13117]="19152:3830:4:2:1:::0:0:", -- Ogron's Sash
	[10777]="20070:4014:4:2:1:::0:0:", -- Arachnid Gloves
	[9420]="20416:4083:4:2:1:::0:0:", -- Adventurer's Pith Helmet
	[2276]="20466:4093:4:2:1:::0:0:", -- Swampwalker Boots
	[7755]="20702:4140:4:2:1:::0:0:", -- Flintrock Shoulders
	[9406]="20807:4161:4:2:1:::0:0:", -- Spirewind Fetter
	[9375]="21101:4220:4:2:1:::0:0:", -- Expert Goldminer's Helmet
	[13110]="24840:4968:4:2:1:::0:0:", -- Wolffear Harness
	[9624]="26338:5267:4:2:1:::0:0:", -- Triprunner Dungarees
	[8346]="26815:5363:4:2:1:::0:0:", -- Gauntlets of the Sea
	[10774]="29787:5957:4:2:1:::0:0:", -- Fleshhide Shoulders
	[7760]="30371:6074:4:2:1:::0:0:", -- Warchief Kilt
	[10583]="30956:6191:4:2:1:::0:0:", -- Quillward Harness
	[2564]="34085:6817:4:2:1:::0:0:", -- Elven Spirit Claws
	[16496]="34268:6853:4:2:1:Buff::0:0:", -- Blood Guard's Dragonhide Gauntlets
	[16497]="34402:6880:4:2:1:::1:0:708", -- First Sergeant's Leather Armguards
	[18452]="34553:6910:4:2:1:::1:0:635", -- Sergeant Major's Dragonhide Armsplints
	[16499]="34664:6932:4:2:1:::0:0:", -- Blood Guard's Leather Vices
	[18454]="34815:6963:4:2:1:::1:0:635", -- Sergeant Major's Leather Armsplints
	[13115]="34954:6990:4:2:1:::0:0:", -- Sheepshear Mantle
	[18710]="36122:7224:4:2:1:::0:0:", -- Arena Bracers
	[16396]="36942:7388:4:2:1:::0:0:", -- Knight-Lieutenant's Leather Gauntlets
	[16397]="37072:7414:4:2:1:Buff::0:0:", -- Knight-Lieutenant's Dragonhide Gloves
	[8345]="37109:7421:4:2:1:::0:0:", -- Wolfshead Helm
	[18434]="37468:7493:4:2:1:::1:0:708", -- First Sergeant's Dragonhide Armguards
	[10800]="37812:7562:4:2:1:::0:0:", -- Darkwater Bracers
	[1718]="40202:8040:4:2:1:::0:0:", -- Basilisk Hide Pants
	[12464]="42601:8520:4:2:1:::0:0:", -- Bloodfire Talons
	[12470]="43922:8784:4:2:1:::0:0:", -- Sandstalker Ankleguards
	[9534]="44236:8847:4:2:1:::0:0:", -- Engineer's Guild Headpiece
	[11686]="46645:9329:4:2:1:::0:0:", -- Girdle of Beastial Fury
	[13120]="47526:9505:4:2:1:::0:0:", -- Deepfury Bracers
	[13112]="48124:9624:4:2:1:::0:0:", -- Winged Helm
	[11866]="49098:9819:4:2:1:::0:0:", -- Nagmara's Whipping Belt
	[16423]="51392:10278:4:2:1:::0:0:", -- Lieutenant Commander's Dragonhide Epaulets
	[16424]="51586:10317:4:2:1:::0:0:", -- Lieutenant Commander's Dragonhide Shroud
	[16498]="51802:10360:4:2:1:::0:0:", -- Blood Guard's Leather Treads
	[11764]="51990:10398:4:2:1:::0:0:", -- Cinderhide Armsplints
	[16710]="52230:10446:4:2:1:::0:0:", -- Shadowcraft Bracers
	[16501]="52396:10479:4:2:1:::0:0:", -- Champion's Dragonhide Spaulders
	[12547]="52596:10519:4:2:1:::0:0:", -- Mar Alom's Grip
	[16503]="52790:10558:4:2:1:::0:0:", -- Champion's Dragonhide Helm
	[13118]="53007:10601:4:2:1:::0:0:", -- Serpentine Sash
	[16714]="53012:10602:4:2:1:::0:0:", -- Wildheart Bracers
	[16392]="53190:10638:4:2:1:::0:0:", -- Knight-Lieutenant's Leather Boots
	[16506]="53384:10676:4:2:1:::0:0:", -- Champion's Leather Headguard
	[16393]="53384:10676:4:2:1:::0:0:", -- Knight-Lieutenant's Dragonhide Footwraps
	[8348]="54099:10819:4:2:1:::0:0:", -- Helm of Fire
	[9479]="54294:10858:4:2:1:::0:0:", -- Embrace of the Lycan
	[18700]="54552:10910:4:2:1:::0:0:", -- Malefic Bracers
	[16507]="55014:11002:4:2:1:::0:0:", -- Champion's Leather Mantle
	[19044]="55584:11116:4:2:1:::0:0:", -- Might of the Timbermaw
	[16418]="55802:11160:4:2:1:::0:0:", -- Lieutenant Commander's Leather Veil
	[16713]="55984:11196:4:2:1:::0:0:", -- Shadowcraft Belt
	[16420]="56197:11239:4:2:1:::0:0:", -- Lieutenant Commander's Leather Spaulders
	[16494]="56412:11282:4:2:1:::0:0:", -- Blood Guard's Dragonhide Boots
	[18309]="56480:11296:4:2:1:::0:0:", -- Gloves of Restoration
	[18726]="56480:11296:4:2:1:::0:0:", -- Magistrate's Cuffs
	[18344]="56480:11296:4:2:1:::0:0:", -- Stonebark Gauntlets
	[18744]="56859:11371:4:2:1:::0:0:", -- Plaguebat Fur Gloves
	[17740]="57006:11401:4:2:1:::0:0:", -- Soothsayer's Headdress
	[13395]="57019:11403:4:2:1:::0:0:", -- Skul's Fingerbone Claws
	[17749]="57126:11425:4:2:1:::0:0:", -- Phytoskin Spaulders
	[10783]="57381:11476:4:2:1:::0:0:", -- Atal'ai Spaulders
	[16716]="58104:11620:4:2:1:::0:0:", -- Wildheart Belt
	[15063]="58505:11701:4:2:1:::0:0:", -- Devilsaur Gauntlets
	[10801]="58520:11704:4:2:1:::0:0:", -- Slitherscale Boots
	[16712]="58570:11714:4:2:1:::0:0:", -- Shadowcraft Gloves
	[19089]="59304:11860:4:2:1:::1:0:287,416", -- Frostwolf Leather Belt
	[19093]="59304:11860:4:2:1:::1:0:224,774", -- Stormpike Leather Girdle
	[13962]="60324:12064:4:2:1:::0:0:", -- Vosh'gajin's Strand
	[16717]="61223:12244:4:2:1:::0:0:", -- Wildheart Gloves
	[18368]="61742:12348:4:2:1:::0:0:", -- Gordok's Gloves
	[13957]="62139:12427:4:2:1:::0:0:", -- Gargoyle Slashers
	[13252]="62170:12434:4:2:1:::0:0:", -- Cloudrunner Girdle
	[17728]="62291:12458:4:2:1:::0:0:", -- Albino Crocscale Boots
	[13208]="62602:12520:4:2:1:::0:0:", -- Bleak Howler Armguards
	[12606]="63340:12668:4:2:1:::0:0:", -- Crystallized Girdle
	[15067]="63790:12758:4:2:1:::0:0:", -- Ironfeather Shoulders
	[14502]="65259:13051:4:2:1:::0:0:", -- Frostbite Girdle
	[18391]="65383:13076:4:2:1:::0:0:", -- Eyestalk Cord
	[18505]="65383:13076:4:2:1:::0:0:", -- Mugger's Belt
	[18377]="65383:13076:4:2:1:::0:0:", -- Quickdraw Gloves
	[9473]="66207:13241:4:2:1:::0:0:", -- Jinxed Hoodoo Skin
	[9474]="66450:13290:4:2:1:::0:0:", -- Jinxed Hoodoo Kilt
	[13258]="66715:13343:4:2:1:::0:0:", -- Slaghide Gauntlets
	[13184]="68191:13638:4:2:1:::0:0:", -- Fallbrush Handgrips
	[18525]="68652:13730:4:2:1:::0:0:", -- Bracers of Prosperity
	[19113]="68652:13730:4:2:1:::0:0:", -- Yeti Hide Bracers
	[15061]="69017:13803:4:2:1:::0:0:", -- Living Shoulders
	[13111]="69968:13993:4:2:1:::0:0:", -- Sandals of the Insurgent
	[12966]="70092:14018:4:2:1:::0:0:", -- Blackmist Armguards
	[16502]="70128:14025:4:2:1:::0:0:", -- Legionnaire's Dragonhide Trousers
	[18504]="70634:14126:4:2:1:::0:0:", -- Girdle of Insight
	[16504]="70653:14130:4:2:1:::0:0:", -- Legionnaire's Dragonhide Breastplate
	[16505]="70920:14184:4:2:1:::0:0:", -- Legionnaire's Leather Hauberk
	[18375]="71649:14329:4:2:1:::0:0:", -- Bracers of the Eclipse
	[18698]="71811:14362:4:2:1:::0:0:", -- Tattered Leather Hood
	[17742]="72253:14450:4:2:1:::0:0:", -- Fungus Shroud Armor
	[8349]="72391:14478:4:2:1:::0:0:", -- Feathered Breastplate
	[16508]="73619:14723:4:2:1:::0:0:", -- Legionnaire's Leather Leggings
	[16417]="74137:14827:4:2:1:::0:0:", -- Knight-Captain's Leather Armor
	[16419]="74670:14934:4:2:1:::0:0:", -- Knight-Captain's Leather Legguards
	[16421]="75195:15039:4:2:1:::0:0:", -- Knight-Captain's Dragonhide Tunic
	[16422]="75461:15092:4:2:1:::0:0:", -- Knight-Captain's Dragonhide Leggings
	[13009]="75839:15167:4:2:1:::0:0:", -- Cow King's Hide
	[18699]="76119:15223:4:2:1:::0:0:", -- Icy Tomb Spaulders
	[13404]="79478:15895:4:2:1:::0:0:", -- Mask of the Unforgiven
	[18325]="80686:16137:4:2:1:::0:0:", -- Felhide Cap
	[18322]="80686:16137:4:2:1:::0:0:", -- Waterspout Boots
	[11925]="82423:16484:4:2:1:::0:0:", -- Ghostshroud
	[11747]="83298:16659:4:2:1:::0:0:", -- Flamestrider Robes
	[11735]="83349:16669:4:2:1:::0:0:", -- Ragefury Eyepatch
	[16711]="87528:17505:4:2:1:::0:0:", -- Shadowcraft Boots
	[10842]="87976:17595:4:2:1:::0:0:", -- Windscale Sarong
	[19052]="88105:17621:4:2:1:::0:0:", -- Dawn Treaders
	[12553]="88496:17699:4:2:1:::0:0:", -- Swiftwalker Boots
	[16715]="88833:17766:4:2:1:::0:0:", -- Wildheart Boots
	[13210]="90122:18024:4:2:1:::0:0:", -- Pads of the Dread Wolf
	[13961]="90141:18028:4:2:1:::0:0:", -- Halycon's Muzzle
	[13257]="90441:18088:4:2:1:::0:0:", -- Demonic Runed Spaulders
	[16708]="90878:18175:4:2:1:::0:0:", -- Shadowcraft Spaulders
	[18716]="93277:18655:4:2:1:::0:0:", -- Ash Covered Boots
	[18490]="93277:18655:4:2:1:::0:0:", -- Insightful Hood
	[15057]="93642:18728:4:2:1:::0:0:", -- Stormshroud Pants
	[12927]="95745:19149:4:2:1:::0:0:", -- Truestrike Shoulders
	[16718]="96772:19354:4:2:1:::0:0:", -- Wildheart Spaulders
	[13116]="96851:19370:4:2:1:::0:0:", -- Spaulders of the Unseen
	[14503]="98260:19652:4:2:1:::0:0:", -- Death's Clutch
	[15064]="98585:19717:4:2:1:::0:0:", -- Warbear Harness
	[16707]="99813:19962:4:2:1:::0:0:", -- Shadowcraft Cap
	[13398]="100142:20028:4:2:1:::0:0:", -- Boots of the Shrieker
	[13954]="101934:20386:4:2:1:::0:0:", -- Verdant Footpads
	[18528]="102326:20465:4:2:1:::0:0:", -- Cyclone Spaulders
	[13113]="102730:20546:4:2:1:::0:0:", -- Feathermoon Headdress
	[18424]="102979:20595:4:2:1:::0:0:", -- Sedge Boots
	[18298]="103427:20685:4:2:1:::0:0:", -- Unbridled Leggings
	[15056]="104834:20966:4:2:1:::0:0:", -- Stormshroud Armor
	[12587]="105159:21031:4:2:1:::0:0:", -- Eye of Rend
	[13358]="105181:21036:4:2:1:::0:0:", -- Wyrmtongue Shoulders
	[15060]="106387:21277:4:2:1:::0:0:", -- Living Leggings
	[18506]="106702:21340:4:2:1:::0:0:", -- Mongoose Boots
	[14539]="107021:21404:4:2:1:::0:0:", -- Bone Ring Helm
	[18374]="107093:21418:4:2:1:::0:0:", -- Flamescarred Shoulders
	[16720]="107453:21490:4:2:1:::0:0:", -- Wildheart Cowl
	[19058]="109227:21845:4:2:1:::0:0:", -- Golden Mantle of the Dawn
	[13378]="109860:21972:4:2:1:::0:0:", -- Songbird Blouse
	[15065]="111165:22233:4:2:1:::0:0:", -- Warbear Woolies
	[11821]="111924:22384:4:2:1:::0:0:", -- Warstrife Leggings
	[15066]="118252:23650:4:2:1:::0:0:", -- Ironfeather Breastplate
	[13169]="119741:23948:4:2:1:::0:0:", -- Tressermane Leggings
	[15059]="123882:24776:4:2:1:::0:0:", -- Living Breastplate
	[14637]="125244:25048:4:2:1:::0:0:", -- Cadaverous Armor
	[12603]="125244:25048:4:2:1:::0:0:", -- Nightbrace Tunic
	[9402]="126543:25308:4:2:1:::0:0:", -- Earthborn Kilt
	[18682]="127282:25456:4:2:1:::0:0:", -- Ghoul Skin Leggings
	[16709]="127712:25542:4:2:1:::0:0:", -- Shadowcraft Pants
	[15062]="128545:25709:4:2:1:::0:0:", -- Devilsaur Leggings
	[18736]="130561:26112:4:2:1:::0:0:", -- Plaguehound Leggings
	[14545]="131987:26397:4:2:1:::0:0:", -- Ghostloom Leggings
	[13944]="134043:26808:4:2:1:::0:0:", -- Tombstone Breastplate
	[18390]="134059:26811:4:2:1:::0:0:", -- Tanglemoss Leggings
	[16719]="135964:27192:4:2:1:::0:0:", -- Wildheart Kilt
	[12963]="138586:27717:4:2:1:::0:0:", -- Blademaster Leggings
	[16706]="139205:27841:4:2:1:::0:0:", -- Wildheart Vest
	[18373]="142297:28459:4:2:1:::0:0:", -- Chestplate of Tranquility
	[16721]="150952:30190:4:2:1:::0:0:", -- Shadowcraft Tunic
	[867]="26720:5344:4:2:1:::0:0:", -- Gloves of Holy Might
	[16555]="51560:10312:4:2:1:Buff::0:0:", -- General's Dragonhide Gloves
	[16560]="52533:10506:4:2:1:::0:0:", -- General's Leather Mitts
	[16448]="52729:10545:4:2:1:Buff::0:0:", -- Marshal's Dragonhide Gauntlets
	[16454]="53893:10778:4:2:1:::0:0:", -- Marshal's Leather Handgrips
	[16459]="76459:15291:4:2:1:::0:0:", -- Marshal's Dragonhide Boots
	[16558]="78221:15644:4:2:1:::0:0:", -- General's Leather Treads
	[16446]="78506:15701:4:2:1:::0:0:", -- Marshal's Leather Footguards
	[16561]="79094:15818:4:2:1:::0:0:", -- Warlord's Leather Helm
	[16449]="79387:15877:4:2:1:::0:0:", -- Field Marshal's Dragonhide Spaulders
	[16562]="79387:15877:4:2:1:::0:0:", -- Warlord's Leather Spaulders
	[16451]="79967:15993:4:2:1:::0:0:", -- Field Marshal's Dragonhide Helmet
	[16455]="81133:16226:4:2:1:::0:0:", -- Field Marshal's Leather Mask
	[16457]="81712:16342:4:2:1:::0:0:", -- Field Marshal's Leather Epaulets
	[16550]="81728:16345:4:2:1:::0:0:", -- Warlord's Dragonhide Helmet
	[16551]="82022:16404:4:2:1:::0:0:", -- Warlord's Dragonhide Epaulets
	[16554]="82895:16579:4:2:1:::0:0:", -- General's Dragonhide Boots
	[14553]="88667:17733:4:2:1:::0:0:", -- Sash of Mercy
	[19587]="100919:20183:4:2:1:::1:0:353", -- Forest Stalker's Bracers
	[19146]="100919:20183:4:2:1:::0:0:", -- Wristguards of Stability
	[16450]="106231:21246:4:2:1:::0:0:", -- Marshal's Dragonhide Legguards
	[16563]="106231:21246:4:2:1:::0:0:", -- Warlord's Leather Breastplate
	[19149]="106243:21248:4:2:1:::0:0:", -- Lava Belt
	[16564]="106622:21324:4:2:1:::0:0:", -- General's Leather Legguards
	[16452]="107014:21402:4:2:1:::0:0:", -- Field Marshal's Dragonhide Breastplate
	[16453]="107405:21481:4:2:1:::0:0:", -- Field Marshal's Leather Chestpiece
	[16456]="108569:21713:4:2:1:::0:0:", -- Marshal's Leather Leggings
	[16549]="108580:21716:4:2:1:::0:0:", -- Warlord's Dragonhide Hauberk
	[16552]="109744:21948:4:2:1:::0:0:", -- General's Dragonhide Leggings
	[16825]="109887:21977:4:2:1:::0:0:", -- Nightslayer Bracelets
	[16826]="110287:22057:4:2:1:::0:0:", -- Nightslayer Gloves
	[16827]="110698:22139:4:2:1:::0:0:", -- Nightslayer Belt
	[16828]="111109:22221:4:2:1:::0:0:", -- Cenarion Belt
	[16830]="114864:22972:4:2:1:::0:0:", -- Cenarion Bracers
	[16831]="115275:23055:4:2:1:::0:0:", -- Cenarion Gloves
	[19134]="116827:23365:4:2:1:::0:0:", -- Flayed Doomguard Belt
	[16982]="121985:24397:4:2:1:::0:0:", -- Corehound Boots
	[16983]="128545:25709:4:2:1:::0:0:", -- Molten Helm
	[18823]="132532:26506:4:2:1:::0:0:", -- Aged Core Leather Gloves
	[19163]="139659:27931:4:2:1:::0:0:", -- Molten Belt
	[18544]="146060:29212:4:2:1:::0:0:", -- Doomhide Gauntlets
	[16836]="159298:31859:4:2:1:::0:0:", -- Cenarion Spaulders
	[16821]="162381:32476:4:2:1:::0:0:", -- Nightslayer Cover
	[16823]="163597:32719:4:2:1:::0:0:", -- Nightslayer Shoulder Pads
	[16824]="164214:32842:4:2:1:::0:0:", -- Nightslayer Boots
	[16829]="171697:34339:4:2:1:::0:0:", -- Cenarion Boots
	[16910]="173692:34738:4:2:1:::0:0:", -- Bloodfang Belt
	[16911]="174362:34872:4:2:1:::0:0:", -- Bloodfang Bracers
	[16834]="174746:34949:4:2:1:::0:0:", -- Cenarion Helm
	[12756]="175287:35057:4:2:1:::0:0:", -- Leggings of Arcana
	[12757]="175964:35192:4:2:1:::0:0:", -- Breastplate of Bloodthirst
	[16899]="179700:35940:4:2:1:::0:0:", -- Stormrage Handguards
	[16903]="182361:36472:4:2:1:::0:0:", -- Stormrage Belt
	[16904]="183030:36606:4:2:1:::0:0:", -- Stormrage Bracers
	[16907]="185021:37004:4:2:1:::0:0:", -- Bloodfang Gloves
	[18875]="192227:38445:4:2:1:::0:0:", -- Salamander Scale Pants
	[19390]="197217:39443:4:2:1:::0:0:", -- Taut Dragonhide Gloves
	[18810]="203394:40678:4:2:1:::0:0:", -- Wild Growth Spaulders
	[19139]="211221:42244:4:2:1:::0:0:", -- Fireguard Shoulders
	[16835]="211575:42315:4:2:1:::0:0:", -- Cenarion Leggings
	[16820]="215686:43137:4:2:1:::0:0:", -- Nightslayer Chestpiece
	[16822]="217330:43466:4:2:1:::0:0:", -- Nightslayer Pants
	[16833]="232195:46439:4:2:1:::0:0:", -- Cenarion Vestments
	[16898]="268546:53709:4:2:1:::0:0:", -- Stormrage Boots
	[16900]="270555:54111:4:2:1:::0:0:", -- Stormrage Cover
	[16902]="272537:54507:4:2:1:::0:0:", -- Stormrage Pauldrons
	[16906]="276527:55305:4:2:1:::0:0:", -- Bloodfang Boots
	[16908]="278536:55707:4:2:1:::0:0:", -- Bloodfang Hood
	[16832]="282661:56532:4:2:1:::0:0:", -- Bloodfang Spaulders
	[16909]="346046:69209:4:2:1:::0:0:", -- Bloodfang Pants
	[19405]="351387:70277:4:2:1:::0:0:", -- Malfurion's Blessed Bulwark
	[16901]="362079:72415:4:2:1:::0:0:", -- Stormrage Legguards
	[2649]="7:1:4:3:1:::0:0:", -- Flimsy Chain Belt
	[2654]="14:2:4:3:1:::0:0:", -- Flimsy Chain Pants
	[2653]="15:3:4:3:1:::0:0:", -- Flimsy Chain Gloves
	[2650]="16:3:4:3:1:::0:0:", -- Flimsy Chain Boots
	[2651]="16:3:4:3:1:::0:0:", -- Flimsy Chain Bracers
	[2656]="48:9:4:3:1:::0:0:", -- Flimsy Chain Vest
	[2645]="56:11:4:3:1:::0:0:", -- Loose Chain Gloves
	[2635]="82:16:4:3:1:::0:0:", -- Loose Chain Belt
	[2643]="144:28:4:3:1:::0:0:", -- Loose Chain Bracers
	[2646]="159:31:4:3:1:::0:0:", -- Loose Chain Pants
	[2642]="166:33:4:3:1:::0:0:", -- Loose Chain Boots
	[1734]="197:39:4:3:1:::0:0:", -- Worn Mail Gloves
	[1730]="243:48:4:3:1:::0:0:", -- Worn Mail Belt
	[2648]="293:58:4:3:1:::0:0:", -- Loose Chain Vest
	[1732]="368:73:4:3:1:::0:0:", -- Worn Mail Bracers
	[1735]="449:89:4:3:1:::0:0:", -- Worn Mail Pants
	[1731]="461:92:4:3:1:::0:0:", -- Worn Mail Boots
	[1740]="487:97:4:3:1:::0:0:", -- Laced Mail Bracers
	[1742]="648:129:4:3:1:::0:0:", -- Laced Mail Gloves
	[1737]="698:139:4:3:1:::0:0:", -- Worn Mail Vest
	[1738]="735:147:4:3:1:::0:0:", -- Laced Mail Belt
	[1745]="992:198:4:3:1:::0:0:", -- Laced Mail Vest
	[1748]="1160:232:4:3:1:::0:0:", -- Linked Chain Bracers
	[1739]="1279:255:4:3:1:::0:0:", -- Laced Mail Boots
	[1744]="1302:260:4:3:1:::0:0:", -- Laced Mail Shoulderpads
	[1752]="1433:286:4:3:1:::0:0:", -- Linked Chain Shoulderpads
	[1750]="1491:298:4:3:1:::0:0:", -- Linked Chain Gloves
	[1743]="1497:299:4:3:1:::0:0:", -- Laced Mail Pants
	[1747]="1514:302:4:3:1:::0:0:", -- Linked Chain Boots
	[1746]="1662:332:4:3:1:::0:0:", -- Linked Chain Belt
	[1754]="1796:359:4:3:1:::0:0:", -- Reinforced Chain Belt
	[1756]="2190:438:4:3:1:::0:0:", -- Reinforced Chain Bracers
	[1753]="2196:439:4:3:1:::0:0:", -- Linked Chain Vest
	[1758]="2670:534:4:3:1:::0:0:", -- Reinforced Chain Gloves
	[1755]="2989:597:4:3:1:::0:0:", -- Reinforced Chain Boots
	[1760]="3045:609:4:3:1:::0:0:", -- Reinforced Chain Shoulderpads
	[1751]="3384:676:4:3:1:::0:0:", -- Linked Chain Pants
	[1759]="3661:732:4:3:1:::0:0:", -- Reinforced Chain Pants
	[3808]="3851:770:4:3:1:::0:0:", -- Double Mail Belt
	[8748]="3874:774:4:3:1:::0:0:", -- Double Mail Coif
	[1761]="4463:892:4:3:1:::0:0:", -- Reinforced Chain Vest
	[3809]="4813:962:4:3:1:::0:0:", -- Double Mail Boots
	[3812]="4856:971:4:3:1:::0:0:", -- Double Mail Gloves
	[3810]="5728:1145:4:3:1:::0:0:", -- Double Mail Bracers
	[3815]="7377:1475:4:3:1:::0:0:", -- Double Mail Vest
	[3813]="8862:1772:4:3:1:::0:0:", -- Double Mail Pants
	[4000]="8986:1797:4:3:1:::0:0:", -- Overlinked Chain Belt
	[3814]="9457:1891:4:3:1:::0:0:", -- Double Mail Shoulderpads
	[4004]="11788:2357:4:3:1:::0:0:", -- Overlinked Chain Gloves
	[4006]="12172:2434:4:3:1:::0:0:", -- Overlinked Chain Shoulderpads
	[4002]="12315:2463:4:3:1:::0:0:", -- Overlinked Chain Bracers
	[8751]="13091:2618:4:3:1:::0:0:", -- Overlinked Coif
	[3992]="15410:3082:4:3:1:::0:0:", -- Laminated Scale Belt
	[4001]="15852:3170:4:3:1:::0:0:", -- Overlinked Chain Boots
	[4005]="17389:3477:4:3:1:::0:0:", -- Overlinked Chain Pants
	[4007]="18480:3696:4:3:1:::0:0:", -- Overlinked Chain Armor
	[3994]="22023:4404:4:3:1:::0:0:", -- Laminated Scale Bracers
	[3996]="23299:4659:4:3:1:::0:0:", -- Laminated Scale Gloves
	[3993]="24704:4940:4:3:1:::0:0:", -- Laminated Scale Boots
	[8752]="26086:5217:4:3:1:::0:0:", -- Laminated Scale Circlet
	[3998]="28280:5656:4:3:1:::0:0:", -- Laminated Scale Shoulderpads
	[3999]="35547:7109:4:3:1:::0:0:", -- Laminated Scale Armor
	[3997]="39648:7929:4:3:1:::0:0:", -- Laminated Scale Pants
	[4913]="35:7:4:3:1:::0:0:", -- Painted Chain Belt
	[2547]="36:7:4:3:1:::0:0:", -- Boar Handler Gloves
	[2172]="36:7:4:3:1:::0:0:", -- Rustic Belt
	[2380]="37:7:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Belt
	[2384]="37:7:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Bracers
	[2385]="37:7:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Gloves
	[2690]="38:7:4:3:1:::0:0:", -- Latched Belt
	[4910]="38:7:4:3:1:::0:0:", -- Painted Chain Gloves
	[2387]="38:7:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Belt
	[2390]="38:7:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Bracers
	[2391]="38:7:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Gloves
	[11849]="38:7:4:3:1:::0:0:", -- Rustmetal Bracers
	[2691]="54:10:4:3:1:::0:0:", -- Outfitter Boots
	[2383]="57:11:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Boots
	[2389]="59:11:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Boots
	[5399]="59:11:4:3:1:::0:0:", -- Tracking Boots
	[11852]="71:14:4:3:1:::0:0:", -- Roamer's Leggings
	[4917]="72:14:4:3:1:::0:0:", -- Battleworn Chain Leggings
	[2109]="72:14:4:3:1:::0:0:", -- Frostmane Chain Vest
	[10656]="73:14:4:3:1:::0:0:", -- Barkmail Vest
	[10635]="73:14:4:3:1:::0:0:", -- Painted Chain Leggings
	[2381]="75:15:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Leggings
	[2379]="75:15:4:3:1:::1:0:25,251,286,469", -- Tarnished Chain Vest
	[4922]="76:15:4:3:1:::0:0:", -- Jagged Chain Vest
	[3273]="77:15:4:3:1:::0:0:", -- Rugged Mail Vest
	[2388]="77:15:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Leggings
	[2386]="77:15:4:3:1:::1:0:69,98,325,674", -- Rusted Chain Vest
	[2853]="85:17:4:3:1:::0:0:", -- Copper Bracers
	[6061]="116:23:4:3:1:::0:0:", -- Graystone Bracers
	[6063]="117:23:4:3:1:::0:0:", -- Cold Steel Gauntlets
	[4935]="117:23:4:3:1:::0:0:", -- Wide Metal Girdle
	[15474]="119:23:4:3:1:::0:0:", -- Charger's Bindings
	[3437]="119:23:4:3:1:::0:0:", -- Clasped Belt
	[4659]="119:23:4:3:1:::0:0:", -- Warrior's Girdle
	[10421]="161:32:4:3:1:::0:0:", -- Rough Copper Vest
	[2898]="162:32:4:3:1:::0:0:", -- Mountaineer Chestpiece
	[3280]="165:33:4:3:1:::0:0:", -- Battle Chain Bracers
	[15472]="167:33:4:3:1:::0:0:", -- Charger's Belt
	[3214]="169:33:4:3:1:::0:0:", -- Warrior's Bracers
	[2968]="169:33:4:3:1:::0:0:", -- Warrior's Gloves
	[18612]="171:34:4:3:1:::0:0:", -- Bloody Chain Boots
	[3447]="174:34:4:3:1:::0:0:", -- Cryptwalker Boots
	[2393]="206:41:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Belt
	[5589]="206:41:4:3:1:::0:0:", -- Moss-covered Gauntlets
	[4669]="209:41:4:3:1:::0:0:", -- Battle Chain Girdle
	[4969]="210:42:4:3:1:::0:0:", -- Fortified Bindings
	[1360]="210:42:4:3:1:::0:0:", -- Stormwind Chain Gloves
	[2396]="215:43:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Bracers
	[2397]="215:43:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Gloves
	[2399]="217:43:4:3:1:::1:0:2,312,698,861", -- Light Chain Belt
	[2402]="219:43:4:3:1:::1:0:2,312,698,861", -- Light Chain Bracers
	[15476]="220:44:4:3:1:::0:0:", -- Charger's Handwraps
	[2403]="220:44:4:3:1:::1:0:2,312,698,861", -- Light Chain Gloves
	[1182]="222:44:4:3:1:::0:0:", -- Brass-studded Bracers
	[6507]="223:44:4:3:1:::0:0:", -- Infantry Bracers
	[6509]="224:44:4:3:1:::0:0:", -- Infantry Belt
	[3332]="242:48:4:3:1:::0:0:", -- Perrine's Boots
	[3469]="245:49:4:3:1:::0:0:", -- Copper Chain Boots
	[5592]="271:54:4:3:1:::0:0:", -- Shackled Girdle
	[15482]="271:54:4:3:1:::0:0:", -- War Torn Bands
	[6510]="272:54:4:3:1:::0:0:", -- Infantry Gauntlets
	[2546]="276:55:4:3:1:::0:0:", -- Royal Frostmane Girdle
	[3281]="280:56:4:3:1:::0:0:", -- Battle Chain Gloves
	[2851]="282:56:4:3:1:::0:0:", -- Copper Chain Belt
	[4972]="320:64:4:3:1:::0:0:", -- Cliff Runner Boots
	[2395]="322:64:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Boots
	[15473]="328:65:4:3:1:::0:0:", -- Charger's Boots
	[2401]="330:66:4:3:1:::1:0:2,312,698,861", -- Light Chain Boots
	[2967]="331:66:4:3:1:::0:0:", -- Warrior's Boots
	[2852]="335:67:4:3:1:::0:0:", -- Copper Chain Pants
	[4946]="337:67:4:3:1:::0:0:", -- Lightweight Boots
	[15484]="342:68:4:3:1:::0:0:", -- War Torn Handgrips
	[6177]="348:69:4:3:1:::0:0:", -- Ironwrought Bracers
	[3303]="353:70:4:3:1:::0:0:", -- Brackwater Bracers
	[3472]="357:71:4:3:1:::0:0:", -- Runed Copper Gauntlets
	[9758]="364:72:4:3:1:::0:0:", -- Cadet Belt
	[9760]="367:73:4:3:1:::0:0:", -- Cadet Bracers
	[2392]="413:82:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Armor
	[2394]="416:83:4:3:1:::1:0:13,28,78,96,575,666,714,735,753,809,832", -- Light Mail Leggings
	[15480]="422:84:4:3:1:::0:0:", -- War Torn Girdle
	[2398]="434:86:4:3:1:::1:0:2,312,698,861", -- Light Chain Armor
	[6506]="436:87:4:3:1:::0:0:", -- Infantry Boots
	[2400]="437:87:4:3:1:::1:0:2,312,698,861", -- Light Chain Leggings
	[3151]="437:87:4:3:1:::0:0:", -- Siege Brigade Vest
	[3213]="447:89:4:3:1:::0:0:", -- Veteran Bracers
	[9762]="463:92:4:3:1:::0:0:", -- Cadet Gauntlets
	[1154]="513:102:4:3:1:::0:0:", -- Belt of the People's Militia
	[3279]="525:105:4:3:1:::0:0:", -- Battle Chain Boots
	[3304]="533:106:4:3:1:::0:0:", -- Brackwater Gauntlets
	[4678]="543:108:4:3:1:::0:0:", -- Veteran Girdle
	[15400]="545:109:4:3:1:::0:0:", -- Clamshell Bracers
	[4681]="549:109:4:3:1:::0:0:", -- Brackwater Girdle
	[15402]="549:109:4:3:1:::0:0:", -- Noosegrip Gauntlets
	[5941]="578:115:4:3:1:::0:0:", -- Brass Scale Pants
	[15481]="639:127:4:3:1:::0:0:", -- War Torn Greaves
	[9759]="690:138:4:3:1:::0:0:", -- Cadet Boots
	[2979]="785:157:4:3:1:::0:0:", -- Veteran Boots
	[1845]="877:175:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Belt
	[1846]="880:176:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Bracers
	[850]="883:176:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Gloves
	[2857]="991:198:4:3:1:::0:0:", -- Runed Copper Belt
	[2854]="1127:225:4:3:1:::0:0:", -- Runed Copper Bracers
	[849]="1326:265:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Boots
	[6350]="1478:295:4:3:1:::0:0:", -- Rough Bronze Boots
	[718]="1614:322:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Gloves
	[1852]="1684:336:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Bracers
	[1853]="1690:338:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Belt
	[847]="1749:349:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Armor
	[848]="1755:351:4:3:1:::1:1:13,260,264,321,393,559,569,591,698,704,753,809", -- Chainmail Pants
	[10407]="2159:431:4:3:1:::0:0:", -- Raider's Shoulderpads
	[15496]="2309:461:4:3:1:::0:0:", -- Bloodspattered Shoulder Pads
	[14728]="2428:485:4:3:1:::0:0:", -- War Paint Shoulder Pads
	[287]="2441:488:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Boots
	[4694]="2576:515:4:3:1:::0:0:", -- Burnished Pauldrons
	[3480]="2660:532:4:3:1:::0:0:", -- Rough Bronze Shoulders
	[15505]="2808:561:4:3:1:::0:0:", -- Outrunner's Pauldrons
	[2148]="2907:581:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Belt
	[1445]="2919:583:4:3:1:::0:0:", -- Blackrock Pauldrons
	[2150]="2930:586:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Bracers
	[2151]="2941:588:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Gloves
	[6189]="3122:624:4:3:1:::0:0:", -- Durable Chain Shoulders
	[286]="3229:645:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Pants
	[6579]="3339:667:4:3:1:::0:0:", -- Defender Spaulders
	[285]="3555:711:4:3:1:::1:1:13,160,164,268,687,698,753,809,842,853", -- Scalemail Vest
	[2866]="3764:752:4:3:1:::0:0:", -- Rough Bronze Cuirass
	[2149]="4397:879:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Boots
	[3835]="5532:1106:4:3:1:::0:0:", -- Green Iron Bracers
	[2152]="5906:1181:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Leggings
	[2153]="5927:1185:4:3:1:::1:1:7,84,109,123,160,309,489,588,644,753,809,853", -- Polished Scale Vest
	[2419]="7894:1578:4:3:1:::1:0:7,109,160,200,490,570,644,753,809,860", -- Augmented Chain Belt
	[2421]="7952:1590:4:3:1:::1:0:7,109,160,200,490,570,644,753,809,860", -- Augmented Chain Bracers
	[2422]="7981:1596:4:3:1:::1:0:7,109,160,200,490,570,644,753,809,860", -- Augmented Chain Gloves
	[6040]="8247:1649:4:3:1:::0:0:", -- Golden Scale Bracers
	[2420]="11937:2387:4:3:1:::1:0:7,109,160,200,490,570,571,644,753,809,860", -- Augmented Chain Boots
	[3891]="12284:2456:4:3:1:::1:0:7,109,160,193,200,490,570,644,753,809,860", -- Augmented Chain Helm
	[2417]="15673:3134:4:3:1:::1:0:7,109,160,200,490,570,644,753,809,860", -- Augmented Chain Vest
	[2418]="15731:3146:4:3:1:::1:0:7,109,160,200,490,570,644,753,809,860", -- Augmented Chain Leggings
	[2427]="20146:4029:4:3:1:::1:0:7,279,632,641,644,751,753,809,860", -- Brigandine Bracers
	[2428]="20222:4044:4:3:1:::1:0:7,279,632,641,644,751,753,809,860", -- Brigandine Gloves
	[2424]="21461:4292:4:3:1:::1:0:7,279,632,641,644,751,753,809,860", -- Brigandine Belt
	[3894]="29986:5997:4:3:1:::1:0:7,193,279,632,641,644,751,753,809,860", -- Brigandine Helm
	[2426]="32568:6513:4:3:1:::1:0:7,279,571,632,641,644,751,753,809,860", -- Brigandine Boots
	[2423]="42770:8554:4:3:1:::1:0:7,279,632,641,644,751,753,809,860", -- Brigandine Vest
	[2425]="43077:8615:4:3:1:::1:0:7,279,632,641,644,751,753,809,860", -- Brigandine Leggings
	[3471]="712:142:4:3:1:::0:0:", -- Copper Chain Vest
	[9599]="713:142:4:3:1:::0:0:", -- Barkmail Leggings
	[2966]="731:146:4:3:1:::0:0:", -- Warrior's Pants
	[15479]="897:179:4:3:1:::0:0:", -- Charger's Armor
	[2965]="948:189:4:3:1:::0:0:", -- Warrior's Tunic
	[15477]="960:192:4:3:1:::0:0:", -- Charger's Pants
	[832]="1015:203:4:3:1:::0:0:", -- Silver Defias Belt
	[6550]="1024:204:4:3:1:::0:0:", -- Soldier's Wristguards
	[5328]="1028:205:4:3:1:::0:0:", -- Cinched Belt
	[2980]="1047:209:4:3:1:::0:0:", -- Veteran Gloves
	[15491]="1057:211:4:3:1:::0:0:", -- Bloodspattered Gloves
	[15492]="1061:212:4:3:1:::0:0:", -- Bloodspattered Sash
	[3474]="1083:216:4:3:1:::0:0:", -- Gemmed Copper Gauntlets
	[15495]="1100:220:4:3:1:::0:0:", -- Bloodspattered Wristbands
	[6548]="1169:233:4:3:1:::0:0:", -- Soldier's Girdle
	[3282]="1177:235:4:3:1:::0:0:", -- Battle Chain Pants
	[6337]="1225:245:4:3:1:::0:0:", -- Infantry Leggings
	[6547]="1339:267:4:3:1:::0:0:", -- Soldier's Gauntlets
	[9785]="1344:268:4:3:1:::0:0:", -- Raider's Bracers
	[4676]="1390:278:4:3:1:::0:0:", -- Skeletal Gauntlets
	[3330]="1405:281:4:3:1:::0:0:", -- Dargol's Hauberk
	[7229]="1427:285:4:3:1:::0:0:", -- Explorer's Vest
	[2274]="1447:289:4:3:1:::0:0:", -- Sapper's Gloves
	[14723]="1450:290:4:3:1:::0:0:", -- War Paint Bindings
	[6084]="1454:290:4:3:1:::0:0:", -- Stormwind Guard Leggings
	[14725]="1460:292:4:3:1:::0:0:", -- War Paint Waistband
	[3283]="1476:295:4:3:1:::0:0:", -- Battle Chain Tunic
	[3473]="1498:299:4:3:1:::0:0:", -- Runed Copper Pants
	[6188]="1525:305:4:3:1:::0:0:", -- Mud Stompers
	[6336]="1526:305:4:3:1:::0:0:", -- Infantry Tunic
	[15499]="1535:307:4:3:1:::0:0:", -- Outrunner's Cuffs
	[14147]="1559:311:4:3:1:::0:0:", -- Cavedweller Bracers
	[9788]="1563:312:4:3:1:::0:0:", -- Raider's Belt
	[3302]="1595:319:4:3:1:::0:0:", -- Brackwater Boots
	[5944]="1655:331:4:3:1:::0:0:", -- Greaves of the People's Militia
	[3458]="1670:334:4:3:1:::0:0:", -- Rugged Mail Gloves
	[9763]="1681:336:4:3:1:::0:0:", -- Cadet Leggings
	[15404]="1685:337:4:3:1:::0:0:", -- Breakwater Girdle
	[14726]="1685:337:4:3:1:::0:0:", -- War Paint Gloves
	[15485]="1722:344:4:3:1:::0:0:", -- War Torn Pants
	[9787]="1791:358:4:3:1:::0:0:", -- Raider's Gauntlets
	[15489]="1817:363:4:3:1:::0:0:", -- Bloodspattered Sabatons
	[15507]="1820:364:4:3:1:::0:0:", -- Grunt's Bracers
	[5320]="1862:372:4:3:1:::0:0:", -- Padded Lamellar Boots
	[3211]="1865:373:4:3:1:::0:0:", -- Burnished Bracers
	[15497]="1938:387:4:3:1:::0:0:", -- Outrunner's Cord
	[15406]="2012:402:4:3:1:::0:0:", -- Crustacean Boots
	[1448]="2027:405:4:3:1:::0:0:", -- Blackrock Gauntlets
	[9765]="2034:406:4:3:1:::0:0:", -- Cadet Vest
	[3166]="2039:407:4:3:1:::0:0:", -- Ironheart Chain
	[2992]="2044:408:4:3:1:::0:0:", -- Burnished Gloves
	[6551]="2048:409:4:3:1:::0:0:", -- Soldier's Boots
	[15502]="2055:411:4:3:1:::0:0:", -- Outrunner's Gloves
	[2978]="2079:415:4:3:1:::0:0:", -- Veteran Leggings
	[6195]="2080:416:4:3:1:::0:0:", -- Wax-polished Armor
	[1303]="2091:418:4:3:1:::0:0:", -- Bridgeworker's Gloves
	[5312]="2099:419:4:3:1:::0:0:", -- Riveted Gauntlets
	[5425]="2099:419:4:3:1:::0:0:", -- Runescale Girdle
	[15510]="2117:423:4:3:1:::0:0:", -- Grunt's Belt
	[6180]="2119:423:4:3:1:::0:0:", -- Slarkskin
	[14722]="2121:424:4:3:1:::0:0:", -- War Paint Anklewraps
	[4697]="2179:435:4:3:1:::0:0:", -- Burnished Girdle
	[2037]="2345:469:4:3:1:::0:0:", -- Tunneler's Boots
	[3559]="2368:473:4:3:1:::0:0:", -- Night Watch Gauntlets
	[2977]="2382:476:4:3:1:::0:0:", -- Veteran Armor
	[15487]="2395:479:4:3:1:::0:0:", -- War Torn Tunic
	[15509]="2426:485:4:3:1:::0:0:", -- Grunt's Handwraps
	[3305]="2463:492:4:3:1:::0:0:", -- Brackwater Leggings
	[6546]="2668:533:4:3:1:::0:0:", -- Soldier's Leggings
	[9784]="2669:533:4:3:1:::0:0:", -- Raider's Boots
	[2694]="2697:539:4:3:1:::0:0:", -- Settler's Leggings
	[7606]="2788:557:4:3:1:::0:0:", -- Polar Gauntlets
	[6574]="2840:568:4:3:1:::0:0:", -- Defender Bracers
	[1446]="2842:568:4:3:1:::0:0:", -- Blackrock Boots
	[6576]="2861:572:4:3:1:::0:0:", -- Defender Girdle
	[14743]="2916:583:4:3:1:::0:0:", -- Hulking Bands
	[14746]="2947:589:4:3:1:::0:0:", -- Hulking Belt
	[15203]="3107:621:4:3:1:::0:0:", -- Guststorm Legguards
	[2864]="3150:630:4:3:1:::0:0:", -- Runed Copper Breastplate
	[5750]="3208:641:4:3:1:::0:0:", -- Warchief's Girdle
	[6481]="3209:641:4:3:1:::0:0:", -- Dagmire Gauntlets
	[15451]="3216:643:4:3:1:::0:0:", -- Gargoyle Leggings
	[15493]="3238:647:4:3:1:::0:0:", -- Bloodspattered Loincloth
	[6577]="3245:649:4:3:1:::0:0:", -- Defender Gauntlets
	[3306]="3269:653:4:3:1:::0:0:", -- Brackwater Vest
	[14747]="3343:668:4:3:1:::0:0:", -- Hulking Gauntlets
	[15498]="3370:674:4:3:1:::0:0:", -- Outrunner's Slippers
	[6545]="3379:675:4:3:1:::0:0:", -- Soldier's Armor
	[2991]="3528:705:4:3:1:::0:0:", -- Burnished Boots
	[1943]="3566:713:4:3:1:::0:0:", -- Goblin Mail Leggings
	[2230]="3570:714:4:3:1:::0:0:", -- Gloves of Brawn
	[15506]="3615:723:4:3:1:::0:0:", -- Grunt's AnkleWraps
	[9811]="3628:725:4:3:1:::0:0:", -- Fortified Bracers
	[9814]="3668:733:4:3:1:::0:0:", -- Fortified Belt
	[9789]="3709:741:4:3:1:::0:0:", -- Raider's Legguards
	[14727]="3890:778:4:3:1:::0:0:", -- War Paint Legguards
	[15463]="3937:787:4:3:1:::0:0:", -- Palestrider Gloves
	[2868]="4035:807:4:3:1:::0:0:", -- Patterned Bronze Bracers
	[2166]="4054:810:4:3:1:::0:0:", -- Foreman's Leggings
	[9783]="4059:811:4:3:1:::0:0:", -- Raider's Chestpiece
	[9813]="4129:825:4:3:1:::0:0:", -- Fortified Gauntlets
	[6666]="4152:830:4:3:1:::0:0:", -- Dredge Boots
	[5943]="4202:840:4:3:1:::0:0:", -- Rift Bracers
	[15515]="4224:844:4:3:1:::0:0:", -- Spiked Chain Belt
	[16986]="4254:850:4:3:1:::0:0:", -- Sandspire Gloves
	[15517]="4254:850:4:3:1:::0:0:", -- Spiked Chain Wristbands
	[6731]="4358:871:4:3:1:::0:0:", -- Ironforge Breastplate
	[15520]="4397:879:4:3:1:::0:0:", -- Spiked Chain Gauntlets
	[4707]="4407:881:4:3:1:::0:0:", -- Lambent Scale Girdle
	[6665]="4477:895:4:3:1:::0:0:", -- Hexed Bracers
	[3212]="4645:929:4:3:1:::0:0:", -- Lambent Scale Bracers
	[15528]="4654:930:4:3:1:::0:0:", -- Sentry's Sash
	[2990]="4666:933:4:3:1:::0:0:", -- Burnished Leggings
	[6459]="4674:934:4:3:1:::0:0:", -- Savage Trodders
	[6573]="4691:938:4:3:1:::0:0:", -- Defender Boots
	[15532]="4722:944:4:3:1:::0:0:", -- Sentry's Armsplints
	[2865]="4810:962:4:3:1:::0:0:", -- Rough Bronze Leggings
	[3483]="4828:965:4:3:1:::0:0:", -- Silvered Bronze Gauntlets
	[15488]="4836:967:4:3:1:::0:0:", -- Bloodspattered Surcoat
	[7003]="4906:981:4:3:1:::0:0:", -- Beetle Clasps
	[2989]="5009:1001:4:3:1:::0:0:", -- Burnished Tunic
	[6591]="5039:1007:4:3:1:::0:0:", -- Battleforge Wristguards
	[15527]="5101:1020:4:3:1:::0:0:", -- Sentry's Gloves
	[6675]="5244:1048:4:3:1:::0:0:", -- Tempered Bracers
	[3047]="5260:1052:4:3:1:::0:0:", -- Lambent Scale Gloves
	[14750]="5340:1068:4:3:1:::0:0:", -- Slayer's Cuffs
	[15503]="5457:1091:4:3:1:::0:0:", -- Outrunner's Legguards
	[14755]="5590:1118:4:3:1:::0:0:", -- Slayer's Sash
	[14742]="5592:1118:4:3:1:::0:0:", -- Hulking Boots
	[6594]="5604:1120:4:3:1:::0:0:", -- Battleforge Girdle
	[6595]="5624:1124:4:3:1:::0:0:", -- Battleforge Gauntlets
	[6502]="5701:1140:4:3:1:::0:0:", -- Violet Scale Armor
	[15459]="5712:1142:4:3:1:::0:0:", -- Grimtoll Wristguards
	[4534]="5868:1173:4:3:1:::0:0:", -- Steel-clasped Bracers
	[14754]="5965:1193:4:3:1:::0:0:", -- Slayer's Gloves
	[4800]="6109:1221:4:3:1:::1:1:123,268,588,687,835,842", -- Mighty Chain Pants
	[6200]="6117:1223:4:3:1:::0:0:", -- Garneg's War Belt
	[14730]="6119:1223:4:3:1:::0:0:", -- War Paint Chestpiece
	[4712]="6140:1228:4:3:1:::0:0:", -- Glimmering Mail Girdle
	[6387]="6141:1228:4:3:1:::0:0:", -- Glimmering Mail Bracers
	[9810]="6155:1231:4:3:1:::0:0:", -- Fortified Boots
	[10658]="6248:1249:4:3:1:::0:0:", -- Quagmire Galoshes
	[2910]="6286:1257:4:3:1:::0:0:", -- Gold Militia Boots
	[15513]="6320:1264:4:3:1:::0:0:", -- Grunt's Pauldrons
	[3231]="6332:1266:4:3:1:::0:0:", -- Cutthroat Pauldrons
	[3733]="6347:1269:4:3:1:::0:0:", -- Orcish War Chain
	[15535]="6352:1270:4:3:1:::0:0:", -- Wicked Chain Bracers
	[15539]="6413:1282:4:3:1:::0:0:", -- Wicked Chain Waistband
	[3481]="6422:1284:4:3:1:::0:0:", -- Silvered Bronze Shoulders
	[9837]="6436:1287:4:3:1:::0:0:", -- Banded Bracers
	[3485]="6477:1295:4:3:1:::0:0:", -- Green Iron Gauntlets
	[6578]="6514:1302:4:3:1:::0:0:", -- Defender Leggings
	[6580]="6562:1312:4:3:1:::0:0:", -- Defender Tunic
	[3482]="6588:1317:4:3:1:::0:0:", -- Silvered Bronze Boots
	[14749]="6625:1325:4:3:1:::0:0:", -- Hulking Spaulders
	[6722]="6657:1331:4:3:1:::0:0:", -- Beastial Manacles
	[4072]="6704:1340:4:3:1:::0:0:", -- Glimmering Mail Gauntlets
	[15545]="6740:1348:4:3:1:::0:0:", -- Thick Scale Bracelets
	[15500]="6889:1377:4:3:1:::0:0:", -- Outrunner's Chestguard
	[9535]="7034:1406:4:3:1:::0:0:", -- Fire-welded Bracers
	[15538]="7063:1412:4:3:1:::0:0:", -- Wicked Chain Gauntlets
	[6721]="7094:1418:4:3:1:::0:0:", -- Chestplate of Kor
	[9839]="7134:1426:4:3:1:::0:0:", -- Banded Gauntlets
	[9817]="7134:1426:4:3:1:::0:0:", -- Fortified Spaulders
	[9840]="7161:1432:4:3:1:::0:0:", -- Banded Girdle
	[7416]="7213:1442:4:3:1:::0:0:", -- Phalanx Bracers
	[4705]="7248:1449:4:3:1:::0:0:", -- Lambent Scale Pauldrons
	[15511]="7371:1474:4:3:1:::0:0:", -- Grunt's Legguards
	[15523]="7373:1474:4:3:1:::0:0:", -- Spiked Chain Shoulder Pads
	[6974]="7485:1497:4:3:1:::0:0:", -- Fire Hardened Gauntlets
	[4816]="7518:1503:4:3:1:::1:1:123,231,268,588,687,835,842", -- Legionnaire's Leggings
	[15549]="7523:1504:4:3:1:::0:0:", -- Thick Scale Belt
	[7336]="7548:1509:4:3:1:::0:0:", -- Wildwood Chain
	[7129]="7734:1546:4:3:1:::0:0:", -- Brutal Gauntlets
	[14748]="7752:1550:4:3:1:::0:0:", -- Hulking Leggings
	[1955]="7868:1573:4:3:1:::0:0:", -- Dragonmaw Chain Boots
	[3045]="7869:1573:4:3:1:::0:0:", -- Lambent Scale Boots
	[4465]="7928:1585:4:3:1:::0:0:", -- Bonefist Gauntlets
	[15516]="7939:1587:4:3:1:::0:0:", -- Spiked Chain Slippers
	[3341]="8108:1621:4:3:1:::0:0:", -- Gauntlets of Ogre Strength
	[7422]="8113:1622:4:3:1:::0:0:", -- Phalanx Girdle
	[15525]="8171:1634:4:3:1:::0:0:", -- Sentry's Slippers
	[15548]="8245:1649:4:3:1:::0:0:", -- Thick Scale Gauntlets
	[1273]="8282:1656:4:3:1:::0:0:", -- Forest Chain
	[9815]="8320:1664:4:3:1:::0:0:", -- Fortified Leggings
	[1275]="8342:1668:4:3:1:::0:0:", -- Deputy Chain Coat
	[9818]="8410:1682:4:3:1:::0:0:", -- Fortified Chain
	[11229]="8481:1696:4:3:1:::0:0:", -- Brightscale Girdle
	[15556]="8485:1697:4:3:1:::0:0:", -- Pillager's Bracers
	[6597]="8536:1707:4:3:1:::0:0:", -- Battleforge Shoulderguards
	[4833]="8658:1731:4:3:1:::1:1:148,652,687,847", -- Glorious Shoulders
	[3484]="8837:1767:4:3:1:::0:0:", -- Green Iron Boots
	[6403]="8859:1771:4:3:1:::0:0:", -- Mail Combat Armguards
	[7421]="8891:1778:4:3:1:::0:0:", -- Phalanx Gauntlets
	[2545]="8984:1796:4:3:1:::0:0:", -- Malleable Chain Leggings
	[2906]="9051:1810:4:3:1:::0:0:", -- Darkshire Mail Leggings
	[3758]="9086:1817:4:3:1:::0:0:", -- Crusader Belt
	[6590]="9153:1830:4:3:1:::0:0:", -- Battleforge Boots
	[2869]="9155:1831:4:3:1:::0:0:", -- Silvered Bronze Breastplate
	[15554]="9267:1853:4:3:1:::0:0:", -- Pillager's Girdle
	[7107]="9293:1858:4:3:1:::0:0:", -- Belt of the Stars
	[14756]="9300:1860:4:3:1:::0:0:", -- Slayer's Slippers
	[15514]="9514:1902:4:3:1:::0:0:", -- Grunt's Chestpiece
	[3048]="9598:1919:4:3:1:::0:0:", -- Lambent Scale Legguards
	[15560]="9686:1937:4:3:1:::0:0:", -- Pillager's Gloves
	[9865]="9711:1942:4:3:1:::0:0:", -- Renegade Bracers
	[15521]="9712:1942:4:3:1:::0:0:", -- Spiked Chain Leggings
	[17006]="9831:1966:4:3:1:::0:0:", -- Cobalt Legguards
	[4075]="9924:1984:4:3:1:::0:0:", -- Mail Combat Gauntlets
	[4448]="9959:1991:4:3:1:::0:0:", -- Husk of Naraxis
	[14759]="10049:2009:4:3:1:::0:0:", -- Enduring Bracers
	[4717]="10071:2014:4:3:1:::0:0:", -- Mail Combat Belt
	[14761]="10122:2024:4:3:1:::0:0:", -- Enduring Belt
	[6388]="10216:2043:4:3:1:::0:0:", -- Glimmering Mail Pauldrons
	[6671]="10341:2068:4:3:1:::0:0:", -- Juggernaut Leggings
	[15531]="10380:2076:4:3:1:::0:0:", -- Sentry's Shoulderguards
	[4835]="10550:2110:4:3:1:::1:1:148,652,687,802,847", -- Elite Shoulders
	[3049]="10595:2119:4:3:1:::0:0:", -- Lambent Scale Breastplate
	[3053]="10703:2140:4:3:1:::0:0:", -- Humbert's Chestpiece
	[9868]="10802:2160:4:3:1:::0:0:", -- Renegade Gauntlets
	[15566]="10894:2178:4:3:1:::0:0:", -- Marauder's Bracers
	[15588]="10972:2194:4:3:1:::0:0:", -- Bracesteel Belt
	[15571]="11093:2218:4:3:1:::0:0:", -- Marauder's Belt
	[6971]="11105:2221:4:3:1:::0:0:", -- Fire Hardened Coif
	[9869]="11129:2225:4:3:1:::0:0:", -- Renegade Belt
	[4073]="11151:2230:4:3:1:::0:0:", -- Glimmering Mail Greaves
	[6389]="11229:2245:4:3:1:::0:0:", -- Glimmering Mail Coif
	[14764]="11254:2250:4:3:1:::0:0:", -- Enduring Gauntlets
	[6596]="11290:2258:4:3:1:::0:0:", -- Battleforge Legguards
	[14758]="11335:2267:4:3:1:::0:0:", -- Slayer's Shoulder Pads
	[15533]="11450:2290:4:3:1:::0:0:", -- Sentry's Headdress
	[15575]="11500:2300:4:3:1:::0:0:", -- Sparkleshell Belt
	[15534]="11542:2308:4:3:1:::0:0:", -- Wicked Chain Boots
	[14744]="11551:2310:4:3:1:::0:0:", -- Hulking Chestguard
	[10333]="11574:2314:4:3:1:::0:0:", -- Scarlet Wristguards
	[15577]="11587:2317:4:3:1:::0:0:", -- Sparkleshell Bracers
	[7130]="11642:2328:4:3:1:::0:0:", -- Brutal Helm
	[7132]="11692:2338:4:3:1:::0:0:", -- Brutal Legguards
	[15542]="11827:2365:4:3:1:::0:0:", -- Wicked Chain Shoulder Pads
	[4464]="11901:2380:4:3:1:::0:0:", -- Trouncing Boots
	[10408]="11951:2390:4:3:1:::0:0:", -- Banded Helm
	[9842]="11958:2391:4:3:1:::0:0:", -- Banded Pauldrons
	[10409]="12049:2409:4:3:1:::0:0:", -- Banded Boots
	[10358]="12107:2421:4:3:1:::0:0:", -- Duracin Bracers
	[7461]="12149:2429:4:3:1:::0:0:", -- Knight's Bracers
	[15570]="12159:2431:4:3:1:::0:0:", -- Marauder's Gauntlets
	[15470]="12162:2432:4:3:1:::0:0:", -- Plainsguard Leggings
	[6592]="12239:2447:4:3:1:::0:0:", -- Battleforge Armor
	[15544]="12243:2448:4:3:1:::0:0:", -- Thick Scale Sabatons
	[6973]="12326:2465:4:3:1:::0:0:", -- Fire Hardened Leggings
	[15529]="12437:2487:4:3:1:::0:0:", -- Sentry's Leggings
	[6413]="12487:2497:4:3:1:::0:0:", -- Chief Brigadier Bracers
	[7913]="12502:2500:4:3:1:::0:0:", -- Barbaric Iron Shoulders
	[10329]="12538:2507:4:3:1:::0:0:", -- Scarlet Belt
	[7457]="12823:2564:4:3:1:::0:0:", -- Knight's Gauntlets
	[3840]="12855:2571:4:3:1:::0:0:", -- Green Iron Shoulders
	[19509]="12917:2583:4:3:1:::0:0:", -- Dusty Mail Boots
	[14753]="13052:2610:4:3:1:::0:0:", -- Slayer's Skullcap
	[6686]="13135:2627:4:3:1:::0:0:", -- Tusken Helm
	[7420]="13290:2658:4:3:1:::0:0:", -- Phalanx Headguard
	[3751]="13307:2661:4:3:1:::0:0:", -- Mercenary Leggings
	[914]="13347:2669:4:3:1:::0:0:", -- Large Ogre Chain Armor
	[15590]="13373:2674:4:3:1:::0:0:", -- Steadfast Bracelets
	[4132]="13408:2681:4:3:1:::0:0:", -- Darkspear Armsplints
	[7462]="13412:2682:4:3:1:::0:0:", -- Knight's Girdle
	[6386]="13462:2692:4:3:1:::0:0:", -- Glimmering Mail Legguards
	[16794]="13525:2705:4:3:1:::0:0:", -- Gripsteel Wristguards
	[7424]="13545:2709:4:3:1:::0:0:", -- Phalanx Spaulders
	[7917]="13557:2711:4:3:1:::0:0:", -- Barbaric Iron Gloves
	[10331]="13644:2728:4:3:1:::0:0:", -- Scarlet Gauntlets
	[15598]="13816:2763:4:3:1:::0:0:", -- Steadfast Girdle
	[4727]="13955:2791:4:3:1:::0:0:", -- Chief Brigadier Girdle
	[15581]="13973:2794:4:3:1:::0:0:", -- Sparkleshell Gauntlets
	[15555]="14013:2802:4:3:1:::0:0:", -- Pillager's Boots
	[1282]="14125:2825:4:3:1:::0:0:", -- Sparkmetal Coif
	[15518]="14128:2825:4:3:1:::0:0:", -- Spiked Chain Breastplate
	[15540]="14139:2827:4:3:1:::0:0:", -- Wicked Chain Helmet
	[10423]="14211:2842:4:3:1:::0:0:", -- Silvered Bronze Leggings
	[1988]="14260:2852:4:3:1:::0:0:", -- Chief Brigadier Gauntlets
	[15524]="14383:2876:4:3:1:::0:0:", -- Sentry's Surcoat
	[7417]="14519:2903:4:3:1:::0:0:", -- Phalanx Boots
	[3842]="14531:2906:4:3:1:::0:0:", -- Green Iron Leggings
	[9896]="14567:2913:4:3:1:::0:0:", -- Jazeraint Bracers
	[4071]="14695:2939:4:3:1:::0:0:", -- Glimmering Mail Breastplate
	[15595]="14752:2950:4:3:1:::0:0:", -- Steadfast Gloves
	[14773]="15263:3052:4:3:1:::0:0:", -- Ravager's Cord
	[3836]="15268:3053:4:3:1:::0:0:", -- Green Iron Helm
	[15553]="15306:3061:4:3:1:::0:0:", -- Thick Scale Shoulder Pads
	[3841]="15534:3106:4:3:1:::0:0:", -- Golden Scale Shoulders
	[6793]="15786:3157:4:3:1:::0:0:", -- Auric Bracers
	[9841]="15815:3163:4:3:1:::0:0:", -- Banded Leggings
	[14770]="15864:3172:4:3:1:::0:0:", -- Ravager's Armguards
	[9900]="15975:3195:4:3:1:::0:0:", -- Jazeraint Gauntlets
	[9388]="15981:3196:4:3:1:::0:0:", -- Revelosh's Armguards
	[4745]="16153:3230:4:3:1:::0:0:", -- War Rider Bracers
	[6404]="16211:3242:4:3:1:::0:0:", -- Mail Combat Spaulders
	[7493]="16344:3268:4:3:1:::0:0:", -- Captain's Bracers
	[14772]="16423:3284:4:3:1:::0:0:", -- Ravager's Handwraps
	[9901]="16474:3294:4:3:1:::0:0:", -- Jazeraint Belt
	[14757]="16491:3298:4:3:1:::0:0:", -- Slayer's Pants
	[4077]="16494:3298:4:3:1:::0:0:", -- Mail Combat Headguard
	[4076]="16508:3301:4:3:1:::0:0:", -- Mail Combat Boots
	[15550]="16582:3316:4:3:1:::0:0:", -- Thick Scale Crown
	[7914]="16654:3330:4:3:1:::0:0:", -- Barbaric Iron Breastplate
	[7915]="16686:3337:4:3:1:::0:0:", -- Barbaric Iron Helm
	[15541]="17205:3441:4:3:1:::0:0:", -- Wicked Chain Legguards
	[14751]="17271:3454:4:3:1:::0:0:", -- Slayer's Surcoat
	[4443]="17360:3472:4:3:1:::0:0:", -- Grim Pauldrons
	[8187]="17387:3477:4:3:1:::0:0:", -- Turtle Scale Gloves
	[9864]="17637:3527:4:3:1:::0:0:", -- Renegade Boots
	[7494]="17717:3543:4:3:1:::0:0:", -- Captain's Waistguard
	[15562]="17790:3558:4:3:1:::0:0:", -- Pillager's Pauldrons
	[15606]="17928:3585:4:3:1:::0:0:", -- Ancient Belt
	[9836]="18387:3677:4:3:1:::0:0:", -- Banded Armor
	[9870]="18430:3686:4:3:1:::0:0:", -- Renegade Circlet
	[15613]="18440:3688:4:3:1:::0:0:", -- Bonelink Belt
	[9366]="18446:3689:4:3:1:::0:0:", -- Golden Scale Gauntlets
	[7916]="18502:3700:4:3:1:::0:0:", -- Barbaric Iron Boots
	[7489]="18703:3740:4:3:1:::0:0:", -- Captain's Gauntlets
	[15600]="18938:3787:4:3:1:::0:0:", -- Ancient Vambraces
	[4123]="19022:3804:4:3:1:::0:0:", -- Frost Metal Pauldrons
	[15605]="19293:3858:4:3:1:::0:0:", -- Ancient Gauntlets
	[3843]="19413:3882:4:3:1:::0:0:", -- Golden Scale Leggings
	[12257]="19429:3885:4:3:1:::1:1:200,352", -- Heavy Notched Belt
	[9927]="19638:3927:4:3:1:::0:0:", -- Brigade Bracers
	[3846]="19685:3937:4:3:1:::0:0:", -- Polished Steel Boots
	[7423]="19709:3941:4:3:1:::0:0:", -- Phalanx Leggings
	[7458]="19916:3983:4:3:1:::0:0:", -- Knight's Boots
	[8198]="20068:4013:4:3:1:::0:0:", -- Turtle Scale Bracers
	[14762]="20373:4074:4:3:1:::0:0:", -- Enduring Boots
	[9872]="20508:4101:4:3:1:::0:0:", -- Renegade Pauldrons
	[7924]="20516:4103:4:3:1:::0:0:", -- Mithril Scale Bracers
	[15536]="20537:4107:4:3:1:::0:0:", -- Wicked Chain Chestpiece
	[5755]="20638:4127:4:3:1:::0:0:", -- Onyx Shredder Plate
	[15558]="20643:4128:4:3:1:::0:0:", -- Pillager's Crown
	[7456]="20695:4139:4:3:1:::0:0:", -- Knight's Headguard
	[6426]="20811:4162:4:3:1:::0:0:", -- Blackforge Bracers
	[7418]="21280:4256:4:3:1:::0:0:", -- Phalanx Breastplate
	[15698]="21368:4273:4:3:1:::0:0:", -- Wrangling Spaulders
	[15565]="21370:4274:4:3:1:::0:0:", -- Marauder's Boots
	[15612]="21426:4285:4:3:1:::0:0:", -- Bonelink Gauntlets
	[9930]="21439:4287:4:3:1:::0:0:", -- Brigade Gauntlets
	[9931]="21516:4303:4:3:1:::0:0:", -- Brigade Girdle
	[7459]="21588:4317:4:3:1:::0:0:", -- Knight's Pauldrons
	[4083]="21644:4328:4:3:1:::0:0:", -- Blackforge Gauntlets
	[8205]="21734:4346:4:3:1:::0:0:", -- Tough Scorpid Bracers
	[16793]="21765:4353:4:3:1:::0:0:", -- Arcmetal Shoulders
	[15610]="21770:4354:4:3:1:::0:0:", -- Bonelink Bracers
	[3837]="22027:4405:4:3:1:::0:0:", -- Golden Scale Coif
	[14765]="22139:4427:4:3:1:::0:0:", -- Enduring Circlet
	[15551]="22190:4438:4:3:1:::0:0:", -- Thick Scale Legguards
	[15576]="22314:4462:4:3:1:::0:0:", -- Sparkleshell Sabatons
	[6425]="22393:4478:4:3:1:::0:0:", -- Blackforge Girdle
	[14767]="22393:4478:4:3:1:::0:0:", -- Enduring Pauldrons
	[7545]="23290:4658:4:3:1:::0:0:", -- Champion's Bracers
	[4078]="23364:4672:4:3:1:::0:0:", -- Chief Brigadier Coif
	[8204]="23382:4676:4:3:1:::0:0:", -- Tough Scorpid Gloves
	[6402]="23496:4699:4:3:1:::0:0:", -- Mail Combat Leggings
	[15561]="23527:4705:4:3:1:::0:0:", -- Pillager's Leggings
	[6412]="23558:4711:4:3:1:::0:0:", -- Chief Brigadier Boots
	[15572]="23571:4714:4:3:1:::0:0:", -- Marauder's Circlet
	[4725]="23680:4736:4:3:1:::0:0:", -- Chief Brigadier Pauldrons
	[6792]="23693:4738:4:3:1:::0:0:", -- Sanguine Pauldrons
	[4074]="23928:4785:4:3:1:::0:0:", -- Mail Combat Armor
	[15546]="23969:4793:4:3:1:::0:0:", -- Thick Scale Breastplate
	[3765]="24057:4811:4:3:1:::0:0:", -- Brigand's Pauldrons
	[15580]="24357:4871:4:3:1:::0:0:", -- Sparkleshell Headwrap
	[14778]="24666:4933:4:3:1:::0:0:", -- Khan's Bindings
	[3847]="24887:4977:4:3:1:::0:0:", -- Golden Scale Boots
	[14782]="25023:5004:4:3:1:::0:0:", -- Khan's Gloves
	[6747]="25076:5015:4:3:1:::0:0:", -- Enforcer Pauldrons
	[7546]="25251:5050:4:3:1:::0:0:", -- Champion's Girdle
	[9956]="25650:5130:4:3:1:::0:0:", -- Warmonger's Bracers
	[15574]="25751:5150:4:3:1:::0:0:", -- Marauder's Shoulder Pads
	[11861]="26039:5207:4:3:1:::0:0:", -- Girdle of Reprisal
	[9895]="26105:5221:4:3:1:::0:0:", -- Jazeraint Boots
	[10542]="26279:5255:4:3:1:::0:0:", -- Goblin Mining Helmet
	[15583]="26722:5344:4:3:1:::0:0:", -- Sparkleshell Shoulder Pads
	[9902]="26786:5357:4:3:1:::0:0:", -- Jazeraint Helm
	[9904]="27104:5420:4:3:1:::0:0:", -- Jazeraint Pauldrons
	[14783]="27123:5424:4:3:1:::0:0:", -- Khan's Belt
	[9871]="27128:5425:4:3:1:::0:0:", -- Renegade Leggings
	[4741]="27194:5438:4:3:1:::0:0:", -- Stromgarde Cavalry Leggings
	[15589]="27314:5462:4:3:1:::0:0:", -- Steadfast Stompers
	[7541]="27396:5479:4:3:1:::0:0:", -- Champion's Gauntlets
	[14766]="27430:5486:4:3:1:::0:0:", -- Enduring Breeches
	[15557]="27430:5486:4:3:1:::0:0:", -- Pillager's Chestguard
	[10706]="27606:5521:4:3:1:::0:0:", -- Nightscale Girdle
	[15593]="27663:5532:4:3:1:::0:0:", -- Steadfast Coronet
	[14769]="27772:5554:4:3:1:::0:0:", -- Ravager's Sandals
	[15620]="27824:5564:4:3:1:::0:0:", -- Gryphon Mail Bracelets
	[9866]="28025:5605:4:3:1:::0:0:", -- Renegade Chestguard
	[9960]="28119:5623:4:3:1:::0:0:", -- Warmonger's Gauntlets
	[15597]="28214:5642:4:3:1:::0:0:", -- Steadfast Shoulders
	[9961]="28224:5644:4:3:1:::0:0:", -- Warmonger's Belt
	[7490]="28403:5680:4:3:1:::0:0:", -- Captain's Boots
	[15625]="29094:5818:4:3:1:::0:0:", -- Gryphon Mail Gauntlets
	[15573]="29202:5840:4:3:1:::0:0:", -- Marauder's Leggings
	[15635]="29483:5896:4:3:1:::0:0:", -- Formidable Gauntlets
	[7454]="29575:5915:4:3:1:::0:0:", -- Knight's Breastplate
	[7455]="29688:5937:4:3:1:::0:0:", -- Knight's Legguards
	[15619]="29936:5987:4:3:1:::0:0:", -- Gryphon Mail Belt
	[4136]="30109:6021:4:3:1:::0:0:", -- Darkspear Boots
	[7488]="30193:6038:4:3:1:::0:0:", -- Captain's Circlet
	[7491]="30792:6158:4:3:1:::0:0:", -- Captain's Shoulderguards
	[1624]="30862:6172:4:3:1:::0:0:", -- Skullsplitter Helm
	[8128]="31148:6229:4:3:1:::0:0:", -- Myrmidon's Gauntlets
	[14774]="31262:6252:4:3:1:::0:0:", -- Ravager's Crown
	[8129]="31269:6253:4:3:1:::0:0:", -- Myrmidon's Girdle
	[14760]="31318:6263:4:3:1:::0:0:", -- Enduring Breastplate
	[14776]="31633:6326:4:3:1:::0:0:", -- Ravager's Mantle
	[15636]="31669:6333:4:3:1:::0:0:", -- Formidable Belt
	[8125]="31837:6367:4:3:1:::0:0:", -- Myrmidon's Bracers
	[9926]="31840:6368:4:3:1:::0:0:", -- Brigade Boots
	[15629]="31871:6374:4:3:1:::0:0:", -- Formidable Bracers
	[14788]="32042:6408:4:3:1:::0:0:", -- Protector Armguards
	[7963]="32440:6488:4:3:1:::0:0:", -- Steel Breastplate
	[15582]="32721:6544:4:3:1:::0:0:", -- Sparkleshell Legguards
	[3845]="32794:6558:4:3:1:::0:0:", -- Golden Scale Cuirass
	[10076]="32855:6571:4:3:1:::0:0:", -- Lord's Armguards
	[9934]="32888:6577:4:3:1:::0:0:", -- Brigade Pauldrons
	[15599]="33156:6631:4:3:1:::0:0:", -- Ancient Greaves
	[19125]="33261:6652:4:3:1:::0:0:", -- Seared Mail Girdle
	[15567]="33333:6666:4:3:1:::0:0:", -- Marauder's Tunic
	[4079]="33766:6753:4:3:1:::0:0:", -- Chief Brigadier Leggings
	[9638]="34376:6875:4:3:1:::0:0:", -- Chelonian Cuffs
	[15596]="34546:6909:4:3:1:::0:0:", -- Steadfast Legplates
	[14792]="34800:6960:4:3:1:::0:0:", -- Protector Gauntlets
	[15578]="34814:6962:4:3:1:::0:0:", -- Sparkleshell Breastplate
	[14793]="34926:6985:4:3:1:::0:0:", -- Protector Waistband
	[9932]="34977:6995:4:3:1:::0:0:", -- Brigade Circlet
	[15614]="35132:7026:4:3:1:::0:0:", -- Bonelink Sabatons
	[15608]="35177:7035:4:3:1:::0:0:", -- Ancient Pauldrons
	[15639]="35200:7040:4:3:1:::0:0:", -- Ironhide Bracers
	[15617]="35538:7107:4:3:1:::0:0:", -- Bonelink Epaulets
	[9411]="35780:7156:4:3:1:::0:0:", -- Rockshard Pauldrons
	[4653]="35890:7178:4:3:1:::0:0:", -- Ironheel Boots
	[15602]="36055:7211:4:3:1:::0:0:", -- Ancient Crown
	[6423]="36168:7233:4:3:1:::0:0:", -- Blackforge Greaves
	[9666]="36332:7266:4:3:1:::0:0:", -- Stronghorn Girdle
	[6411]="36343:7268:4:3:1:::0:0:", -- Chief Brigadier Armor
	[4118]="36567:7313:4:3:1:::0:0:", -- Poobah's Nose Ring
	[10080]="36598:7319:4:3:1:::0:0:", -- Lord's Gauntlets
	[10081]="36728:7345:4:3:1:::0:0:", -- Lord's Girdle
	[6773]="36831:7366:4:3:1:::0:0:", -- Gelkis Marauder Chain
	[9897]="36842:7368:4:3:1:::0:0:", -- Jazeraint Chestguard
	[4080]="37346:7469:4:3:1:::0:0:", -- Blackforge Cowl
	[10701]="37680:7536:4:3:1:::0:0:", -- Boots of Zua'tec
	[8189]="37838:7567:4:3:1:::0:0:", -- Turtle Scale Breastplate
	[15615]="37920:7584:4:3:1:::0:0:", -- Bonelink Helmet
	[15641]="37938:7587:4:3:1:::0:0:", -- Ironhide Belt
	[10196]="37967:7593:4:3:1:::0:0:", -- Crusader's Gauntlets
	[12416]="37979:7595:4:3:1:::0:0:", -- Radiant Belt
	[15077]="38077:7615:4:3:1:::0:0:", -- Heavy Scorpid Bracers
	[10197]="38115:7623:4:3:1:::0:0:", -- Crusader's Belt
	[7929]="38698:7739:4:3:1:::0:0:", -- Orcish War Leggings
	[9903]="38714:7742:4:3:1:::0:0:", -- Jazeraint Leggings
	[10191]="38887:7777:4:3:1:::0:0:", -- Crusader's Armguards
	[8191]="38900:7780:4:3:1:::0:0:", -- Turtle Scale Helm
	[4508]="38965:7793:4:3:1:::0:0:", -- Blood-tinged Armor
	[15649]="39041:7808:4:3:1:::0:0:", -- Merciless Bracers
	[8264]="39287:7857:4:3:1:::0:0:", -- Ebonhold Wristguards
	[7931]="39778:7955:4:3:1:::0:0:", -- Mithril Coif
	[4733]="39789:7957:4:3:1:::0:0:", -- Blackforge Pauldrons
	[7920]="40265:8053:4:3:1:::0:0:", -- Mithril Scale Pants
	[15653]="40266:8053:4:3:1:::0:0:", -- Merciless Gauntlets
	[7543]="40619:8123:4:3:1:::0:0:", -- Champion's Pauldrons
	[15644]="40651:8130:4:3:1:::0:0:", -- Ironhide Gauntlets
	[14784]="41011:8202:4:3:1:::0:0:", -- Khan's Greaves
	[14807]="41058:8211:4:3:1:::0:0:", -- Bloodlust Bracelets
	[7542]="41422:8284:4:3:1:::0:0:", -- Champion's Greaves
	[14787]="41618:8323:4:3:1:::0:0:", -- Khan's Mantle
	[14775]="41836:8367:4:3:1:::0:0:", -- Ravager's Woolies
	[8209]="41879:8375:4:3:1:::0:0:", -- Tough Scorpid Boots
	[14768]="42834:8566:4:3:1:::0:0:", -- Ravager's Armor
	[15654]="42848:8569:4:3:1:::0:0:", -- Merciless Belt
	[8203]="43140:8628:4:3:1:::0:0:", -- Tough Scorpid Breastplate
	[7932]="43309:8661:4:3:1:::0:0:", -- Mithril Scale Shoulders
	[7487]="43328:8665:4:3:1:::0:0:", -- Captain's Leggings
	[15591]="43699:8739:4:3:1:::0:0:", -- Steadfast Breastplate
	[11867]="43848:8769:4:3:1:::0:0:", -- Maddening Gauntlets
	[15626]="43993:8798:4:3:1:::0:0:", -- Gryphon Mail Greaves
	[7540]="44228:8845:4:3:1:::0:0:", -- Champion's Helmet
	[10126]="44327:8865:4:3:1:::0:0:", -- Ornate Bracers
	[8267]="44639:8927:4:3:1:::0:0:", -- Ebonhold Gauntlets
	[8268]="44800:8960:4:3:1:::0:0:", -- Ebonhold Girdle
	[8207]="44892:8978:4:3:1:::0:0:", -- Tough Scorpid Shoulders
	[12051]="44983:8996:4:3:1:::0:0:", -- Brazen Gauntlets
	[10122]="45035:9007:4:3:1:::0:0:", -- Ornate Girdle
	[14803]="45438:9087:4:3:1:::0:0:", -- Bloodlust Belt
	[15823]="45958:9191:4:3:1:::0:0:", -- Bricksteel Gauntlets
	[9963]="46058:9211:4:3:1:::0:0:", -- Warmonger's Circlet
	[9962]="46092:9218:4:3:1:::0:0:", -- Warmonger's Greaves
	[15607]="46529:9305:4:3:1:::0:0:", -- Ancient Legguards
	[7486]="46628:9325:4:3:1:::0:0:", -- Captain's Breastplate
	[9933]="46970:9394:4:3:1:::0:0:", -- Brigade Leggings
	[8130]="47294:9458:4:3:1:::0:0:", -- Myrmidon's Greaves
	[15659]="47540:9508:4:3:1:::0:0:", -- Impenetrable Bindings
	[11918]="47687:9537:4:3:1:::0:0:", -- Grotslab Gloves
	[14785]="47794:9558:4:3:1:::0:0:", -- Khan's Helmet
	[15628]="47854:9570:4:3:1:::0:0:", -- Gryphon Mail Pauldrons
	[15638]="48074:9614:4:3:1:::0:0:", -- Formidable Shoulder Pads
	[15078]="48245:9649:4:3:1:::0:0:", -- Heavy Scorpid Gauntlet
	[14802]="48747:9749:4:3:1:::0:0:", -- Bloodlust Gauntlets
	[11679]="48908:9781:4:3:1:::0:0:", -- Rubicund Armguards
	[9928]="49654:9930:4:3:1:::0:0:", -- Brigade Breastplate
	[9663]="49848:9969:4:3:1:::0:0:", -- Dawnrider's Chestpiece
	[9965]="49866:9973:4:3:1:::0:0:", -- Warmonger's Pauldrons
	[1677]="50466:10093:4:3:1:::0:0:", -- Drake-scale Vest
	[15813]="50568:10113:4:3:1:::0:0:", -- Gold Link Belt
	[8131]="50576:10115:4:3:1:::0:0:", -- Myrmidon's Helm
	[4084]="50681:10136:4:3:1:::0:0:", -- Blackforge Leggings
	[4138]="50704:10140:4:3:1:::0:0:", -- Blackwater Tunic
	[15616]="50755:10151:4:3:1:::0:0:", -- Bonelink Legplates
	[4478]="50883:10176:4:3:1:::0:0:", -- Iridescent Scale Leggings
	[15663]="51130:10226:4:3:1:::0:0:", -- Impenetrable Belt
	[12418]="51214:10242:4:3:1:::0:0:", -- Radiant Gloves
	[8208]="51360:10272:4:3:1:::0:0:", -- Tough Scorpid Helm
	[15630]="51564:10312:4:3:1:::0:0:", -- Formidable Sabatons
	[10229]="51657:10331:4:3:1:::0:0:", -- Engraved Bracers
	[15601]="51726:10345:4:3:1:::0:0:", -- Ancient Chestpiece
	[15082]="51878:10375:4:3:1:::0:0:", -- Heavy Scorpid Belt
	[12112]="52034:10406:4:3:1:::0:0:", -- Crypt Demon Bracers
	[10121]="52576:10515:4:3:1:::0:0:", -- Ornate Gauntlets
	[8133]="52585:10517:4:3:1:::0:0:", -- Myrmidon's Pauldrons
	[14794]="52818:10563:4:3:1:::0:0:", -- Protector Ankleguards
	[15623]="53579:10715:4:3:1:::0:0:", -- Gryphon Mail Crown
	[10083]="53728:10745:4:3:1:::0:0:", -- Lord's Crown
	[10082]="53763:10752:4:3:1:::0:0:", -- Lord's Boots
	[15662]="54007:10801:4:3:1:::0:0:", -- Impenetrable Gauntlets
	[17777]="54078:10815:4:3:1:::0:0:", -- Relentless Chain
	[10743]="54150:10830:4:3:1:::0:0:", -- Drakefire Headguard
	[8185]="54764:10952:4:3:1:::0:0:", -- Turtle Scale Leggings
	[8302]="55301:11060:4:3:1:::0:0:", -- Hero's Bracers
	[15673]="55375:11075:4:3:1:::0:0:", -- Magnificent Belt
	[10233]="55534:11106:4:3:1:::0:0:", -- Engraved Girdle
	[15859]="56480:11296:4:3:1:::0:0:", -- Seapost Girdle
	[14797]="57137:11427:4:3:1:::0:0:", -- Protector Pads
	[15634]="57208:11441:4:3:1:::0:0:", -- Formidable Circlet
	[10085]="57648:11529:4:3:1:::0:0:", -- Lord's Pauldrons
	[14808]="57907:11581:4:3:1:::0:0:", -- Warstrike Belt
	[14810]="58345:11669:4:3:1:::0:0:", -- Warstrike Armsplints
	[15668]="58488:11697:4:3:1:::0:0:", -- Magnificent Bracers
	[4082]="58495:11699:4:3:1:::0:0:", -- Blackforge Breastplate
	[10232]="58663:11732:4:3:1:::0:0:", -- Engraved Gauntlets
	[8305]="58718:11743:4:3:1:::0:0:", -- Hero's Gauntlets
	[8306]="58937:11787:4:3:1:::0:0:", -- Hero's Belt
	[15609]="59033:11806:4:3:1:::0:0:", -- Bonelink Armor
	[14786]="59209:11841:4:3:1:::0:0:", -- Khan's Legguards
	[13255]="59861:11972:4:3:1:::0:0:", -- Trueaim Gauntlets
	[10786]="59889:11977:4:3:1:::0:0:", -- Atal'ai Boots
	[13211]="60311:12062:4:3:1:::0:0:", -- Slashclaw Bracers
	[15796]="60317:12063:4:3:1:::0:0:", -- Seaspray Bracers
	[13244]="60342:12068:4:3:1:::0:0:", -- Gilded Gauntlets
	[15642]="60811:12162:4:3:1:::0:0:", -- Ironhide Greaves
	[15672]="60821:12164:4:3:1:::0:0:", -- Magnificent Gauntlets
	[10198]="60837:12167:4:3:1:::0:0:", -- Crusader's Helm
	[18458]="61064:12212:4:3:1:::0:0:", -- Modest Armguards
	[11627]="61120:12224:4:3:1:::0:0:", -- Fleetfoot Greaves
	[10200]="61571:12314:4:3:1:::0:0:", -- Crusader's Pauldrons
	[7538]="61612:12322:4:3:1:::0:0:", -- Champion's Armor
	[14615]="62152:12430:4:3:1:::0:0:", -- Bloodmail Gauntlets
	[18349]="62270:12454:4:3:1:::0:0:", -- Gauntlets of Accuracy
	[15683]="63333:12666:4:3:1:::0:0:", -- Triumphant Girdle
	[14795]="63454:12690:4:3:1:::0:0:", -- Protector Helm
	[7539]="63461:12692:4:3:1:::0:0:", -- Champion's Leggings
	[8206]="63521:12704:4:3:1:::0:0:", -- Tough Scorpid Leggings
	[10161]="63568:12713:4:3:1:::0:0:", -- Mercurial Gauntlets
	[13532]="63810:12762:4:3:1:::0:0:", -- Darkspinner Claws
	[10156]="63973:12794:4:3:1:::0:0:", -- Mercurial Bracers
	[15679]="65540:13108:4:3:1:::0:0:", -- Triumphant Bracers
	[15647]="65628:13125:4:3:1:::0:0:", -- Ironhide Pauldrons
	[9964]="65952:13190:4:3:1:::0:0:", -- Warmonger's Leggings
	[13528]="65993:13198:4:3:1:::0:0:", -- Twilight Void Bracers
	[10192]="66060:13212:4:3:1:::0:0:", -- Crusader's Boots
	[15694]="66322:13264:4:3:1:::0:0:", -- Merciless Greaves
	[10154]="66689:13337:4:3:1:::0:0:", -- Mercurial Girdle
	[14779]="66738:13347:4:3:1:::0:0:", -- Khan's Chestpiece
	[19128]="66790:13358:4:3:1:::0:0:", -- Seared Mail Vest
	[15656]="66833:13366:4:3:1:::0:0:", -- Merciless Epaulets
	[14614]="68445:13689:4:3:1:::0:0:", -- Bloodmail Belt
	[8272]="68489:13697:4:3:1:::0:0:", -- Ebonhold Shoulderpads
	[9957]="68766:13753:4:3:1:::0:0:", -- Warmonger's Chestpiece
	[14815]="68803:13760:4:3:1:::0:0:", -- Warstrike Gauntlets
	[12018]="69211:13842:4:3:1:::0:0:", -- Conservator Helm
	[10265]="69523:13904:4:3:1:::0:0:", -- Masterwork Bracers
	[11913]="70224:14044:4:3:1:::0:0:", -- Clayridge Helm
	[10269]="70531:14106:4:3:1:::0:0:", -- Masterwork Girdle
	[11842]="71043:14208:4:3:1:::0:0:", -- Lead Surveyor's Mantle
	[8270]="71758:14351:4:3:1:::0:0:", -- Ebonhold Helmet
	[8269]="71813:14362:4:3:1:::0:0:", -- Ebonhold Boots
	[8132]="72426:14485:4:3:1:::0:0:", -- Myrmidon's Leggings
	[15627]="72468:14493:4:3:1:::0:0:", -- Gryphon Mail Legguards
	[10125]="72757:14551:4:3:1:::0:0:", -- Ornate Pauldrons
	[15637]="72786:14557:4:3:1:::0:0:", -- Formidable Legguards
	[15645]="72887:14577:4:3:1:::0:0:", -- Ironhide Helmet
	[15682]="73050:14610:4:3:1:::0:0:", -- Triumphant Gauntlets
	[10268]="73791:14758:4:3:1:::0:0:", -- Masterwork Gauntlets
	[15622]="74173:14834:4:3:1:::0:0:", -- Gryphon Mail Breastplate
	[10123]="76198:15239:4:3:1:::0:0:", -- Ornate Circlet
	[10084]="76231:15246:4:3:1:::0:0:", -- Lord's Legguards
	[14806]="77804:15560:4:3:1:::0:0:", -- Bloodlust Epaulets
	[8126]="78284:15656:4:3:1:::0:0:", -- Myrmidon's Breastplate
	[15651]="78925:15785:4:3:1:::0:0:", -- Merciless Crown
	[10237]="81436:16287:4:3:1:::0:0:", -- Engraved Pauldrons
	[14804]="81482:16296:4:3:1:::0:0:", -- Bloodlust Helm
	[12419]="82107:16421:4:3:1:::0:0:", -- Radiant Boots
	[15076]="83020:16604:4:3:1:::0:0:", -- Heavy Scorpid Vest
	[15631]="83363:16672:4:3:1:::0:0:", -- Formidable Chestpiece
	[10119]="83383:16676:4:3:1:::0:0:", -- Ornate Greaves
	[12049]="84251:16850:4:3:1:::0:0:", -- Splintsteel Armor
	[10235]="84481:16896:4:3:1:::0:0:", -- Engraved Helm
	[10077]="84841:16968:4:3:1:::0:0:", -- Lord's Breastplate
	[14796]="84917:16983:4:3:1:::0:0:", -- Protector Legguards
	[12415]="85018:17003:4:3:1:::0:0:", -- Radiant Breastplate
	[12417]="85174:17034:4:3:1:::0:0:", -- Radiant Circlet
	[10199]="86305:17261:4:3:1:::0:0:", -- Crusader's Leggings
	[14799]="86542:17308:4:3:1:::0:0:", -- Bloodlust Boots
	[13284]="86560:17312:4:3:1:::0:0:", -- Swiftdart Battleboots
	[14789]="87708:17541:4:3:1:::0:0:", -- Protector Breastplate
	[18479]="88957:17791:4:3:1:::0:0:", -- Carrion Scorpid Helm
	[10234]="89007:17801:4:3:1:::0:0:", -- Engraved Boots
	[15658]="89254:17850:4:3:1:::0:0:", -- Impenetrable Sabatons
	[9650]="90081:18016:4:3:1:::0:0:", -- Honorguard Chestpiece
	[15080]="91152:18230:4:3:1:::0:0:", -- Heavy Scorpid Helm
	[15666]="91877:18375:4:3:1:::0:0:", -- Impenetrable Pauldrons
	[15674]="92321:18464:4:3:1:::0:0:", -- Magnificent Greaves
	[8308]="93517:18703:4:3:1:::0:0:", -- Hero's Band
	[8307]="93586:18717:4:3:1:::0:0:", -- Hero's Boots
	[14616]="93996:18799:4:3:1:::0:0:", -- Bloodmail Boots
	[15664]="95355:19071:4:3:1:::0:0:", -- Impenetrable Helmet
	[13538]="96115:19223:4:3:1:::0:0:", -- Windshrieker Pauldrons
	[11606]="96279:19255:4:3:1:::0:0:", -- Dark Iron Mail
	[8310]="97099:19419:4:3:1:::0:0:", -- Hero's Pauldrons
	[15646]="97534:19506:4:3:1:::0:0:", -- Ironhide Legguards
	[15677]="98029:19605:4:3:1:::0:0:", -- Magnificent Shoulders
	[10193]="98879:19775:4:3:1:::0:0:", -- Crusader's Armor
	[15655]="99310:19862:4:3:1:::0:0:", -- Merciless Legguards
	[8265]="99571:19914:4:3:1:::0:0:", -- Ebonhold Armor
	[10160]="99741:19948:4:3:1:::0:0:", -- Mercurial Circlet
	[10155]="100842:20168:4:3:1:::0:0:", -- Mercurial Greaves
	[15640]="101168:20233:4:3:1:::0:0:", -- Ironhide Breastplate
	[15081]="101305:20261:4:3:1:::0:0:", -- Heavy Scorpid Shoulders
	[10163]="101320:20264:4:3:1:::0:0:", -- Mercurial Pauldrons
	[14809]="101382:20276:4:3:1:::0:0:", -- Warstrike Sabatons
	[8271]="101790:20358:4:3:1:::0:0:", -- Ebonhold Leggings
	[10124]="101982:20396:4:3:1:::0:0:", -- Ornate Legguards
	[11194]="102024:20404:4:3:1:::0:0:", -- Prismscale Hauberk
	[15670]="102277:20455:4:3:1:::0:0:", -- Magnificent Helmet
	[11882]="102603:20520:4:3:1:::0:0:", -- Outrider Leggings
	[14805]="102886:20577:4:3:1:::0:0:", -- Bloodlust Britches
	[10272]="104328:20865:4:3:1:::0:0:", -- Masterwork Circlet
	[14817]="104419:20883:4:3:1:::0:0:", -- Warstrike Shoulder Pads
	[10274]="105594:21118:4:3:1:::0:0:", -- Masterwork Pauldrons
	[12953]="107923:21584:4:3:1:::0:0:", -- Dragoneye Coif
	[14814]="107967:21593:4:3:1:::0:0:", -- Warstrike Helmet
	[15678]="108468:21693:4:3:1:::0:0:", -- Triumphant Sabatons
	[15079]="108803:21760:4:3:1:::0:0:", -- Heavy Scorpid Leggings
	[15650]="111154:22230:4:3:1:::0:0:", -- Merciless Surcoat
	[11820]="111507:22301:4:3:1:::0:0:", -- Royal Decorated Armor
	[15686]="111657:22331:4:3:1:::0:0:", -- Triumphant Shoulder Pads
	[10270]="111982:22396:4:3:1:::0:0:", -- Masterwork Boots
	[15827]="112961:22592:4:3:1:::0:0:", -- Jadescale Breastplate
	[15787]="112961:22592:4:3:1:::0:0:", -- Willow Band Hauberk
	[10236]="113079:22615:4:3:1:::0:0:", -- Engraved Leggings
	[12108]="115274:23054:4:3:1:::0:0:", -- Basaltscale Armor
	[15684]="115893:23178:4:3:1:::0:0:", -- Triumphant Skullcap
	[10118]="116909:23381:4:3:1:::0:0:", -- Ornate Breastplate
	[14798]="120185:24037:4:3:1:::0:0:", -- Bloodlust Breastplate
	[12420]="126654:25330:4:3:1:::0:0:", -- Radiant Leggings
	[15665]="127600:25520:4:3:1:::0:0:", -- Impenetrable Legguards
	[10230]="128433:25686:4:3:1:::0:0:", -- Engraved Breastplate
	[15676]="129644:25928:4:3:1:::0:0:", -- Magnificent Leggings
	[8309]="131394:26278:4:3:1:::0:0:", -- Hero's Leggings
	[15660]="131577:26315:4:3:1:::0:0:", -- Impenetrable Breastplate
	[8303]="134948:26989:4:3:1:::0:0:", -- Hero's Breastplate
	[14612]="135925:27185:4:3:1:::0:0:", -- Bloodmail Legguards
	[14816]="138101:27620:4:3:1:::0:0:", -- Warstrike Legguards
	[10162]="140688:28137:4:3:1:::0:0:", -- Mercurial Legguards
	[15669]="142694:28538:4:3:1:::0:0:", -- Magnificent Breastplate
	[10273]="146619:29323:4:3:1:::0:0:", -- Masterwork Legplates
	[15685]="147698:29539:4:3:1:::0:0:", -- Triumphant Legplates
	[10157]="156081:31216:4:3:1:::0:0:", -- Mercurial Breastplate
	[15680]="159918:31983:4:3:1:::0:0:", -- Triumphant Chestpiece
	[10266]="161552:32310:4:3:1:::0:0:", -- Masterwork Breastplate
	[12978]="2674:534:4:3:1:::0:0:", -- Stormbringer Belt
	[12994]="3939:787:4:3:1:::0:0:", -- Thorbia's Gauntlets
	[6460]="4222:844:4:3:1:::0:0:", -- Cobrahn's Grasp
	[12982]="4254:850:4:3:1:::0:0:", -- Silver-linked Footguards
	[3228]="5492:1098:4:3:1:::0:0:", -- Jimmied Handcuffs
	[16978]="5794:1158:4:3:1:::0:0:", -- Warsong Gauntlets
	[13012]="6208:1241:4:3:1:::0:0:", -- Yorgen Bracers
	[6906]="6377:1275:4:3:1:::0:0:", -- Algae Fists
	[4438]="8464:1692:4:3:1:::0:0:", -- Pugilist Bracers
	[6087]="8639:1727:4:3:1:::0:0:", -- Chausses of Westfall
	[6907]="9364:1872:4:3:1:::0:0:", -- Tortoise Armor
	[6642]="9402:1880:4:3:1:::0:0:", -- Phantom Armor
	[9405]="10277:2055:4:3:1:::0:0:", -- Girdle of Golem Strength
	[3416]="11069:2213:4:3:1:::0:0:", -- Martyr's Chain
	[13010]="11207:2241:4:3:1:::0:0:", -- Dreamsinger Legguards
	[9445]="11302:2260:4:3:1:::0:0:", -- Grubbis Paws
	[13131]="11563:2312:4:3:1:::0:0:", -- Sparkleshell Mantle
	[6627]="13104:2620:4:3:1:::0:0:", -- Mutant Scale Breastplate
	[6742]="14150:2830:4:3:1:::0:0:", -- Stonefist Girdle
	[10584]="14528:2905:4:3:1:::0:0:", -- Stormgale Fists
	[9435]="14583:2916:4:3:1:::0:0:", -- Reticulated Bone Gauntlets
	[2870]="14677:2935:4:3:1:::0:0:", -- Shining Silver Breastplate
	[9510]="14729:2945:4:3:1:::0:0:", -- Caverndeep Trudgers
	[13127]="15107:3021:4:3:1:::0:0:", -- Frostreaver Crown
	[7133]="15493:3098:4:3:1:Buff::0:0:", -- Brutal Hauberk
	[1717]="15540:3108:4:3:1:::0:0:", -- Double Link Tunic
	[5819]="16009:3201:4:3:1:::0:0:", -- Sunblaze Coif
	[6972]="16213:3242:4:3:1:Buff::0:0:", -- Fire Hardened Hauberk
	[1488]="16899:3379:4:3:1:::0:0:", -- Avenger's Armor
	[10332]="18950:3790:4:3:1:::0:0:", -- Scarlet Boots
	[13124]="19981:3996:4:3:1:::0:0:", -- Ravasaur Scale Boots
	[18449]="21507:4301:4:3:1:::1:0:635", -- Sergeant Major's Chain Armguards
	[18432]="21742:4348:4:3:1:::1:0:708", -- First Sergeant's Mail Wristguards
	[13199]="21994:4398:4:3:1:::0:0:", -- Crushridge Bindings
	[9409]="22450:4490:4:3:1:::0:0:", -- Ironaya's Bracers
	[10768]="22705:4541:4:3:1:::0:0:", -- Boar Champion's Belt
	[1678]="22907:4581:4:3:1:::0:0:", -- Black Ogre Kickers
	[7688]="26602:5320:4:3:1:::0:0:", -- Ironspine's Ribcage
	[7724]="27180:5436:4:3:1:::0:0:", -- Gauntlets of Divinity
	[3844]="28293:5658:4:3:1:::0:0:", -- Green Iron Hauberk
	[8347]="29899:5979:4:3:1:::0:0:", -- Dragonscale Gauntlets
	[10631]="30433:6086:4:3:1:::0:0:", -- Murkwater Gauntlets
	[9625]="31721:6344:4:3:1:::0:0:", -- Dual Reinforced Leggings
	[7759]="33619:6723:4:3:1:::0:0:", -- Archon Chestpiece
	[7719]="34315:6863:4:3:1:::0:0:", -- Raging Berserker's Helm
	[7718]="34338:6867:4:3:1:::0:0:", -- Herod's Shoulder
	[10328]="34964:6992:4:3:1:::0:0:", -- Scarlet Chestpiece
	[9396]="36596:7319:4:3:1:::0:0:", -- Legguards of the Vault
	[13132]="36702:7340:4:3:1:::0:0:", -- Skeletal Shoulders
	[13129]="38107:7621:4:3:1:::0:0:", -- Firemane Leggings
	[10632]="38124:7624:4:3:1:::0:0:", -- Slimescale Bracers
	[13134]="38584:7716:4:3:1:::0:0:", -- Belt of the Gladiator
	[16403]="41118:8223:4:3:1:::0:0:", -- Knight-Lieutenant's Chain Gauntlets
	[16519]="41593:8318:4:3:1:::0:0:", -- Blood Guard's Mail Grips
	[9430]="42768:8553:4:3:1:::0:0:", -- Spaulders of a Lost Age
	[10833]="42986:8597:4:3:1:::0:0:", -- Horns of Eranikus
	[18711]="43502:8700:4:3:1:::0:0:", -- Arena Bands
	[18448]="44007:8801:4:3:1:::1:0:635", -- Sergeant Major's Chain Armguards
	[16530]="44482:8896:4:3:1:::0:0:", -- Blood Guard's Chain Gauntlets
	[16532]="44802:8960:4:3:1:::1:0:708", -- First Sergeant's Mail Wristguards
	[10330]="47938:9587:4:3:1:::0:0:", -- Scarlet Leggings
	[17736]="48234:9646:4:3:1:::0:0:", -- Rockgrip Gauntlets
	[17714]="51128:10225:4:3:1:::0:0:", -- Bracers of the Stone Princess
	[1715]="51509:10301:4:3:1:::0:0:", -- Polished Jazeraint Armor
	[13126]="51870:10374:4:3:1:::0:0:", -- Battlecaller Gauntlets
	[10764]="52173:10434:4:3:1:::0:0:", -- Deathchill Armor
	[13128]="52717:10543:4:3:1:::0:0:", -- High Bergg Helm
	[18296]="57448:11489:4:3:1:::0:0:", -- Marksman Bands
	[16518]="62426:12485:4:3:1:::0:0:", -- Blood Guard's Mail Walkers
	[11765]="62625:12525:4:3:1:::0:0:", -- Pyremail Wristguards
	[16521]="62862:12572:4:3:1:::0:0:", -- Champion's Mail Helm
	[16671]="62932:12586:4:3:1:::0:0:", -- Bindings of Elements
	[11730]="63813:12762:4:3:1:::0:0:", -- Savage Gladiator Grips
	[11783]="63838:12767:4:3:1:::0:0:", -- Chillsteel Girdle
	[16428]="64573:12914:4:3:1:::0:0:", -- Lieutenant Commander's Chain Helmet
	[16427]="64619:12923:4:3:1:::0:0:", -- Lieutenant Commander's Chain Pauldrons
	[13125]="64770:12954:4:3:1:::0:0:", -- Elven Chain Boots
	[16681]="65275:13055:4:3:1:::0:0:", -- Beaststalker's Bindings
	[11814]="65415:13083:4:3:1:::0:0:", -- Molten Fists
	[16524]="65588:13117:4:3:1:::0:0:", -- Champion's Mail Shoulders
	[16526]="65771:13154:4:3:1:::0:0:", -- Champion's Chain Headguard
	[16528]="66545:13309:4:3:1:::0:0:", -- Champion's Chain Pauldrons
	[16673]="67202:13440:4:3:1:::0:0:", -- Cord of Elements
	[16531]="67261:13452:4:3:1:::0:0:", -- Blood Guard's Chain Boots
	[16401]="67983:13596:4:3:1:::0:0:", -- Knight-Lieutenant's Chain Boots
	[17767]="68052:13610:4:3:1:::0:0:", -- Bloomsprout Headpiece
	[12549]="68349:13669:4:3:1:::0:0:", -- Braincage
	[16680]="68941:13788:4:3:1:::0:0:", -- Beaststalker's Belt
	[13135]="70008:14001:4:3:1:::0:0:", -- Lordly Armguards
	[16672]="70299:14059:4:3:1:::0:0:", -- Gauntlets of Elements
	[12632]="70498:14099:4:3:1:::0:0:", -- Storm Gauntlets
	[19092]="71165:14233:4:3:1:::1:0:224,774", -- Stormpike Mail Girdle
	[16676]="71344:14268:4:3:1:::0:0:", -- Beaststalker's Gloves
	[13963]="72665:14533:4:3:1:::0:0:", -- Voone's Vice Grips
	[9469]="73171:14634:4:3:1:::0:0:", -- Gahz'rilla Scale Armor
	[18367]="73814:14762:4:3:1:::0:0:", -- Gordok's Gauntlets
	[13179]="74583:14916:4:3:1:::0:0:", -- Brazecore Armguards
	[18721]="74724:14944:4:3:1:::0:0:", -- Barrage Girdle
	[18393]="74724:14944:4:3:1:::0:0:", -- Warpwood Binding
	[12634]="76552:15310:4:3:1:::0:0:", -- Chiselbrand Girdle
	[19088]="76597:15319:4:3:1:::1:0:287,416", -- Frostwolf Mail Belt
	[13387]="78899:15779:4:3:1:::0:0:", -- Foresight Girdle
	[13969]="80097:16019:4:3:1:::0:0:", -- Loomguard Armbraces
	[18676]="80404:16080:4:3:1:::0:0:", -- Sash of the Windreaver
	[10846]="80717:16143:4:3:1:::0:0:", -- Bloodshot Greaves
	[13950]="82235:16447:4:3:1:::0:0:", -- Detention Strap
	[16425]="82858:16571:4:3:1:::0:0:", -- Knight-Captain's Chain Hauberk
	[11722]="83052:16610:4:3:1:::0:0:", -- Dregmetal Spaulders
	[16426]="83178:16635:4:3:1:::0:0:", -- Knight-Captain's Chain Leggings
	[16522]="84136:16827:4:3:1:::0:0:", -- Legionnaire's Mail Chestpiece
	[11124]="84900:16980:4:3:1:::0:0:", -- Helm of Exile
	[18394]="85666:17133:4:3:1:::0:0:", -- Demon Howl Wristguards
	[18508]="85970:17194:4:3:1:::0:0:", -- Swift Flight Bracers
	[13344]="86053:17210:4:3:1:::0:0:", -- Dracorian Gauntlets
	[18104]="86424:17284:4:3:1:::0:0:", -- Feralsurge Girdle
	[16523]="86745:17349:4:3:1:::0:0:", -- Legionnaire's Mail Legguards
	[17754]="86971:17394:4:3:1:::0:0:", -- Infernal Trickster Leggings
	[16525]="87375:17475:4:3:1:::0:0:", -- Legionnaire's Chain Breastplate
	[16527]="88015:17603:4:3:1:::0:0:", -- Legionnaire's Chain Leggings
	[18527]="89941:17988:4:3:1:::0:0:", -- Harmonious Gauntlets
	[10784]="92164:18432:4:3:1:::0:0:", -- Atal'ai Breastplate
	[8367]="92276:18455:4:3:1:::0:0:", -- Dragonscale Breastplate
	[11729]="95365:19073:4:3:1:::0:0:", -- Savage Gladiator Helm
	[11731]="96500:19300:4:3:1:::0:0:", -- Savage Gladiator Greaves
	[15045]="99692:19938:4:3:1:::0:0:", -- Green Dragonscale Breastplate
	[11749]="100708:20141:4:3:1:::0:0:", -- Searingscale Leggings
	[15049]="102716:20543:4:3:1:::0:0:", -- Blue Dragonscale Shoulders
	[12624]="103212:20642:4:3:1:::0:0:", -- Wildthorn Mail
	[18319]="104945:20989:4:3:1:::0:0:", -- Fervent Helm
	[16670]="105136:21027:4:3:1:::0:0:", -- Boots of Elements
	[13402]="105842:21168:4:3:1:::0:0:", -- Timmy's Galoshes
	[16675]="107106:21421:4:3:1:::0:0:", -- Beaststalker's Boots
	[18494]="107223:21444:4:3:1:::0:0:", -- Denwatcher's Shoulders
	[18742]="107223:21444:4:3:1:::0:0:", -- Stratholme Militia Shoulderguard
	[15051]="108683:21736:4:3:1:::0:0:", -- Black Dragonscale Shoulders
	[16669]="109977:21995:4:3:1:::0:0:", -- Pauldrons of Elements
	[18318]="110286:22057:4:3:1:::0:0:", -- Merciful Greaves
	[15046]="112410:22482:4:3:1:::0:0:", -- Green Dragonscale Leggings
	[13260]="112807:22561:4:3:1:::0:0:", -- Wind Dancer Boots
	[16679]="114114:22822:4:3:1:::0:0:", -- Beaststalker's Mantle
	[13133]="115416:23083:4:3:1:::0:0:", -- Drakesfire Epaulets
	[13967]="116691:23338:4:3:1:::0:0:", -- Windreaver Greaves
	[18379]="118957:23791:4:3:1:::0:0:", -- Odious Greaves
	[12636]="121428:24285:4:3:1:::0:0:", -- Helm of the Great Chief
	[15048]="122046:24409:4:3:1:::0:0:", -- Blue Dragonscale Breastplate
	[18047]="122141:24428:4:3:1:::0:0:", -- Flame Walkers
	[18686]="122638:24527:4:3:1:::0:0:", -- Bone Golem Shoulders
	[11926]="122952:24590:4:3:1:::0:0:", -- Deathdealer Breastplate
	[14548]="123964:24792:4:3:1:::0:0:", -- Royal Cap Spaulders
	[19111]="124124:24824:4:3:1:::0:0:", -- Winteraxe Epaulets
	[16677]="124341:24868:4:3:1:::0:0:", -- Beaststalker's Cap
	[13130]="125329:25065:4:3:1:::0:0:", -- Windrunner Legguards
	[11728]="126681:25336:4:3:1:::0:0:", -- Savage Gladiator Leggings
	[13359]="126683:25336:4:3:1:::0:0:", -- Crown of Tyranny
	[12588]="127233:25446:4:3:1:::0:0:", -- Bonespike Shoulder
	[18421]="128705:25741:4:3:1:::0:0:", -- Backwood Helm
	[16667]="128894:25778:4:3:1:::0:0:", -- Coif of Elements
	[18807]="128980:25796:4:3:1:::0:0:", -- Helm of Latent Power
	[18694]="129554:25910:4:3:1:::0:0:", -- Shadowy Mail Greaves
	[15050]="130357:26071:4:3:1:::0:0:", -- Black Dragonscale Breastplate
	[13383]="134323:26864:4:3:1:::0:0:", -- Woollies of the Prancing Minstrel
	[15047]="149181:29836:4:3:1:::0:0:", -- Red Dragonscale Breastplate
	[16668]="152707:30541:4:3:1:::0:0:", -- Kilt of Elements
	[14522]="156591:31318:4:3:1:::0:0:", -- Maelstrom Leggings
	[18530]="156657:31331:4:3:1:::0:0:", -- Ogre Forged Hauberk
	[18378]="156920:31384:4:3:1:::0:0:", -- Silvermoon Leggings
	[16678]="158473:31694:4:3:1:::0:0:", -- Beaststalker's Pants
	[15052]="159667:31933:4:3:1:::0:0:", -- Black Dragonscale Leggings
	[14536]="161356:32271:4:3:1:::0:0:", -- Bonebrace Hauberk
	[14611]="162547:32509:4:3:1:::0:0:", -- Bloodmail Hauberk
	[13123]="166939:33387:4:3:1:::0:0:", -- Dreamwalker Armor
	[12964]="166942:33388:4:3:1:::0:0:", -- Tristam Legguards
	[16674]="172177:34435:4:3:1:::0:0:", -- Beaststalker's Tunic
	[18524]="177982:35596:4:3:1:::0:0:", -- Leggings of Destruction
	[16666]="179813:35962:4:3:1:::0:0:", -- Vest of Elements
	[14551]="53008:10601:4:3:1:::0:0:", -- Edgemaster's Handguards
	[17007]="57238:11447:4:3:1:::0:0:", -- Stonerender Gauntlets
	[16571]="60932:12186:4:3:1:::0:0:", -- General's Chain Gloves
	[16574]="61631:12326:4:3:1:::0:0:", -- General's Mail Gauntlets
	[16463]="62100:12420:4:3:1:::0:0:", -- Marshal's Chain Grips
	[1981]="70566:14113:4:3:1:::0:0:", -- Icemail Jerkin
	[16573]="92513:18502:4:3:1:::0:0:", -- General's Mail Boots
	[16989]="93050:18610:4:3:1:::0:0:", -- Fiery Chain Girdle
	[16462]="93211:18642:4:3:1:::0:0:", -- Marshal's Chain Boots
	[16465]="93846:18769:4:3:1:::0:0:", -- Field Marshal's Chain Helm
	[16578]="93846:18769:4:3:1:::0:0:", -- Warlord's Mail Helm
	[16580]="94971:18994:4:3:1:::0:0:", -- Warlord's Mail Spaulders
	[16468]="95325:19065:4:3:1:::0:0:", -- Field Marshal's Chain Spaulders
	[16566]="96665:19333:4:3:1:::0:0:", -- Warlord's Chain Helmet
	[16568]="97793:19558:4:3:1:::0:0:", -- Warlord's Chain Shoulders
	[16569]="98146:19629:4:3:1:::0:0:", -- General's Chain Boots
	[19582]="121103:24220:4:3:1:::1:0:353", -- Windtalker's Wristguards
	[16577]="124671:24934:4:3:1:::0:0:", -- Warlord's Mail Armor
	[16466]="125598:25119:4:3:1:::0:0:", -- Field Marshal's Chain Breastplate
	[16579]="125598:25119:4:3:1:::0:0:", -- General's Mail Leggings
	[16467]="126068:25213:4:3:1:::0:0:", -- Marshal's Chain Legguards
	[16838]="128411:25682:4:3:1:::0:0:", -- Earthfury Belt
	[16565]="128417:25683:4:3:1:::0:0:", -- Warlord's Chain Chestpiece
	[16839]="128905:25781:4:3:1:::0:0:", -- Earthfury Gauntlets
	[16567]="129343:25868:4:3:1:::0:0:", -- General's Chain Legguards
	[16840]="129398:25879:4:3:1:::0:0:", -- Earthfury Bracers
	[16850]="137824:27564:4:3:1:::0:0:", -- Giantstalker's Bracers
	[2245]="138183:27636:4:3:1:::0:0:", -- Helm of Narv
	[16851]="138317:27663:4:3:1:::0:0:", -- Giantstalker's Belt
	[16852]="138810:27762:4:3:1:::0:0:", -- Giantstalker's Gloves
	[18870]="156920:31384:4:3:1:::0:0:", -- Helm of the Lifegiver
	[16988]="157303:31460:4:3:1:::0:0:", -- Fiery Chain Shoulders
	[19157]="159715:31943:4:3:1:::0:0:", -- Chromatic Gauntlets
	[18812]="162290:32458:4:3:1:::0:0:", -- Wristguards of True Flight
	[16984]="163269:32653:4:3:1:::0:0:", -- Black Dragonscale Boots
	[11726]="167666:33533:4:3:1:::0:0:", -- Savage Gladiator Chain
	[16837]="192750:38550:4:3:1:::0:0:", -- Earthfury Boots
	[16842]="195557:39111:4:3:1:::0:0:", -- Earthfury Helmet
	[16844]="197913:39582:4:3:1:::0:0:", -- Earthfury Epaulets
	[16846]="203796:40759:4:3:1:::0:0:", -- Giantstalker's Helmet
	[16848]="206188:41237:4:3:1:::0:0:", -- Giantstalker's Epaulets
	[16849]="206912:41382:4:3:1:::0:0:", -- Giantstalker's Boots
	[16935]="212405:42481:4:3:1:::0:0:", -- Dragonstalker's Bracers
	[12945]="212825:42565:4:3:1:::0:0:", -- Legplates of the Chromatic Defier
	[16936]="213187:42637:4:3:1:::0:0:", -- Dragonstalker's Belt
	[16940]="216379:43275:4:3:1:::0:0:", -- Dragonstalker's Gauntlets
	[12641]="219182:43836:4:3:1:::0:0:", -- Invulnerable Mail
	[16943]="224522:44904:4:3:1:::0:0:", -- Bracers of Ten Storms
	[16944]="225326:45065:4:3:1:::0:0:", -- Belt of Ten Storms
	[12903]="227412:45482:4:3:1:::0:0:", -- Legguards of the Chromatic Defier
	[19144]="229869:45973:4:3:1:::0:0:", -- Sabatons of the Flamewalker
	[18546]="240179:48035:4:3:1:::0:0:", -- Infernal Headcage
	[18829]="244184:48836:4:3:1:::0:0:", -- Deep Earth Spaulders
	[16841]="259783:51956:4:3:1:::0:0:", -- Earthfury Vestments
	[16843]="261730:52346:4:3:1:::0:0:", -- Earthfury Legguards
	[16845]="270742:54148:4:3:1:::0:0:", -- Giantstalker's Breastplate
	[16847]="272715:54543:4:3:1:::0:0:", -- Giantstalker's Leggings
	[16949]="312759:62551:4:3:1:::0:0:", -- Greaves of Ten Storms
	[18817]="319878:63975:4:3:1:::0:0:", -- Crown of Destruction
	[16937]="322412:64482:4:3:1:::0:0:", -- Dragonstalker's Spaulders
	[16939]="323363:64672:4:3:1:::0:0:", -- Dragonstalker's Helm
	[19373]="326877:65375:4:3:1:::0:0:", -- Black Brood Pauldrons
	[16941]="335892:67178:4:3:1:::0:0:", -- Dragonstalker's Greaves
	[16947]="341572:68314:4:3:1:::0:0:", -- Helmet of Ten Storms
	[19433]="403299:80659:4:3:1:::0:0:", -- Emberweave Leggings
	[16938]="429588:85917:4:3:1:::0:0:", -- Dragonstalker's Legguards
	[16946]="453866:90773:4:3:1:::0:0:", -- Legplates of Ten Storms
	[8083]="11308:2261:4:4:1:::0:0:", -- Light Plate Bracers
	[8084]="13517:2703:4:4:1:::0:0:", -- Light Plate Gloves
	[8081]="14172:2834:4:4:1:::0:0:", -- Light Plate Belt
	[8082]="15945:3189:4:4:1:::0:0:", -- Light Plate Boots
	[8755]="18642:3728:4:4:1:::0:0:", -- Light Plate Helmet
	[8086]="18652:3730:4:4:1:::0:0:", -- Light Plate Shoulderpads
	[8085]="26269:5253:4:4:1:::0:0:", -- Light Plate Pants
	[8080]="29936:5987:4:4:1:::0:0:", -- Light Plate Chestpiece
	[7922]="11885:2377:4:4:1:::0:0:", -- Steel Plate Helm
	[8088]="13335:2667:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Belt
	[8090]="13439:2687:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Bracers
	[8091]="13489:2697:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Gloves
	[8089]="20081:4016:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Boots
	[8092]="20312:4062:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Helm
	[8093]="27186:5437:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Leggings
	[8094]="27290:5458:4:4:1:::1:0:7,279,632,641,644,751,753,809,860", -- Platemail Armor
	[14903]="10866:2173:4:4:1:::0:0:", -- Saltstone Armsplints
	[8156]="11099:2219:4:4:1:::0:0:", -- Jouster's Wristguards
	[8158]="11181:2236:4:4:1:::0:0:", -- Jouster's Gauntlets
	[8159]="11221:2244:4:4:1:::0:0:", -- Jouster's Girdle
	[14897]="11434:2286:4:4:1:::0:0:", -- Saltstone Gauntlets
	[14898]="11475:2295:4:4:1:::0:0:", -- Saltstone Girdle
	[14826]="11557:2311:4:4:1:::0:0:", -- Symbolic Gauntlets
	[14827]="11600:2320:4:4:1:::0:0:", -- Symbolic Belt
	[14832]="11819:2363:4:4:1:::0:0:", -- Symbolic Vambraces
	[9285]="11943:2388:4:4:1:::0:0:", -- Field Plate Vambraces
	[9287]="12031:2406:4:4:1:::0:0:", -- Field Plate Gauntlets
	[9288]="12074:2414:4:4:1:::0:0:", -- Field Plate Girdle
	[9972]="12378:2475:4:4:1:::0:0:", -- Embossed Plate Bracers
	[7919]="12382:2476:4:4:1:::0:0:", -- Heavy Mithril Gauntlet
	[14941]="12576:2515:4:4:1:::0:0:", -- Warbringer's Armsplints
	[14942]="12624:2524:4:4:1:::0:0:", -- Warbringer's Gauntlets
	[14943]="12671:2534:4:4:1:::0:0:", -- Warbringer's Belt
	[9968]="13476:2695:4:4:1:::0:0:", -- Embossed Plate Girdle
	[14834]="13889:2777:4:4:1:::0:0:", -- Tyrant's Armguards
	[8137]="14035:2807:4:4:1:::0:0:", -- Chromite Bracers
	[8140]="14188:2837:4:4:1:::0:0:", -- Chromite Girdle
	[14838]="14460:2892:4:4:1:::0:0:", -- Tyrant's Belt
	[9967]="14503:2900:4:4:1:::0:0:", -- Embossed Plate Gauntlets
	[7927]="14935:2987:4:4:1:::0:0:", -- Ornate Mithril Gloves
	[14833]="14944:2988:4:4:1:::0:0:", -- Tyrant's Gauntlets
	[14906]="14947:2989:4:4:1:::0:0:", -- Brutish Belt
	[14910]="15168:3033:4:4:1:::0:0:", -- Brutish Armguards
	[8139]="15269:3053:4:4:1:::0:0:", -- Chromite Gauntlets
	[14956]="15543:3108:4:4:1:::0:0:", -- Bloodforged Bindings
	[10088]="15772:3154:4:4:1:::0:0:", -- Gothic Plate Girdle
	[17688]="15776:3155:4:4:1:::0:0:", -- Jungle Boots
	[14905]="16086:3217:4:4:1:::0:0:", -- Brutish Gauntlets
	[10094]="16557:3311:4:4:1:::0:0:", -- Gothic Plate Vambraces
	[8160]="16893:3378:4:4:1:::0:0:", -- Jouster's Greaves
	[8161]="16954:3390:4:4:1:::0:0:", -- Jouster's Visor
	[10087]="16968:3393:4:4:1:::0:0:", -- Gothic Plate Gauntlets
	[14896]="17091:3418:4:4:1:::0:0:", -- Saltstone Sabatons
	[9387]="17194:3438:4:4:1:::0:0:", -- Revelosh's Boots
	[14901]="17472:3494:4:4:1:::0:0:", -- Saltstone Shoulder Pads
	[8273]="17871:3574:4:4:1:::0:0:", -- Valorous Wristguards
	[14914]="17950:3590:4:4:1:::0:0:", -- Jade Bracers
	[8277]="18128:3625:4:4:1:::0:0:", -- Valorous Girdle
	[14950]="18153:3630:4:4:1:::0:0:", -- Bloodforged Belt
	[9289]="18178:3635:4:4:1:::0:0:", -- Field Plate Boots
	[14918]="18273:3654:4:4:1:::0:0:", -- Jade Belt
	[9292]="18424:3684:4:4:1:::0:0:", -- Field Plate Pauldrons
	[8163]="18441:3688:4:4:1:::0:0:", -- Jouster's Pauldrons
	[7918]="18508:3701:4:4:1:::0:0:", -- Heavy Mithril Shoulder
	[9973]="18637:3727:4:4:1:::0:0:", -- Embossed Plate Boots
	[14899]="18655:3731:4:4:1:::0:0:", -- Saltstone Helm
	[14828]="18864:3772:4:4:1:::0:0:", -- Symbolic Greaves
	[14830]="19007:3801:4:4:1:::0:0:", -- Symbolic Pauldrons
	[17770]="19258:3851:4:4:1:::0:0:", -- Branchclaw Gauntlets
	[8276]="19509:3901:4:4:1:::0:0:", -- Valorous Gauntlets
	[14949]="19535:3907:4:4:1:::0:0:", -- Bloodforged Gauntlets
	[14917]="19659:3931:4:4:1:::0:0:", -- Jade Gauntlets
	[9290]="19703:3940:4:4:1:::0:0:", -- Field Plate Helmet
	[9969]="19824:3964:4:4:1:::0:0:", -- Embossed Plate Helmet
	[10202]="19943:3988:4:4:1:::0:0:", -- Overlord's Vambraces
	[9971]="19976:3995:4:4:1:::0:0:", -- Embossed Plate Pauldrons
	[10206]="20243:4048:4:4:1:::0:0:", -- Overlord's Girdle
	[14940]="20297:4059:4:4:1:::0:0:", -- Warbringer's Sabatons 
	[14831]="20603:4120:4:4:1:::0:0:", -- Symbolic Crown
	[14946]="20757:4151:4:4:1:::0:0:", -- Warbringer's Spaulders
	[14853]="20870:4174:4:4:1:::0:0:", -- Sunscale Wristguards
	[9656]="21256:4251:4:4:1:::0:0:", -- Granite Grips
	[14847]="21272:4254:4:4:1:::0:0:", -- Sunscale Belt
	[9662]="21291:4258:4:4:1:::0:0:", -- Rushridge Boots
	[14841]="21423:4284:4:4:1:::0:0:", -- Tyrant's Epaulets
	[14900]="21490:4298:4:4:1:::0:0:", -- Saltstone Legplates
	[10205]="21580:4316:4:4:1:::0:0:", -- Overlord's Gauntlets
	[10127]="21752:4350:4:4:1:::0:0:", -- Revenant Bracers
	[14965]="22252:4450:4:4:1:::0:0:", -- High Chief's Bindings
	[19126]="22255:4451:4:4:1:::0:0:", -- Slagplate Gauntlets
	[14846]="22673:4534:4:4:1:::0:0:", -- Sunscale Gauntlets
	[10746]="22748:4549:4:4:1:::0:0:", -- Runesteel Vambraces
	[14923]="23024:4604:4:4:1:::0:0:", -- Lofty Armguards
	[8141]="23068:4613:4:4:1:::0:0:", -- Chromite Greaves
	[8142]="23152:4630:4:4:1:::0:0:", -- Chromite Barbute
	[12406]="23183:4636:4:4:1:::0:0:", -- Thorium Belt
	[10129]="23445:4689:4:4:1:::0:0:", -- Revenant Gauntlets
	[14839]="23509:4701:4:4:1:::0:0:", -- Tyrant's Greaves
	[10130]="23531:4706:4:4:1:::0:0:", -- Revenant Girdle
	[10089]="23747:4749:4:4:1:::0:0:", -- Gothic Sabatons
	[9637]="23747:4749:4:4:1:::0:0:", -- Shinkicker Boots
	[14944]="24031:4806:4:4:1:::0:0:", -- Warbringer's Crown
	[7928]="24286:4857:4:4:1:::0:0:", -- Ornate Mithril Shoulder
	[14960]="24353:4870:4:4:1:::0:0:", -- High Chief's Belt
	[14909]="24486:4897:4:4:1:::0:0:", -- Brutish Shoulders
	[8162]="24500:4900:4:4:1:::0:0:", -- Jouster's Legplates
	[14895]="24524:4904:4:4:1:::0:0:", -- Saltstone Surcoat
	[10239]="24811:4962:4:4:1:::0:0:", -- Heavy Lamellar Vambraces
	[12408]="24991:4998:4:4:1:::0:0:", -- Thorium Bracers
	[9664]="25013:5002:4:4:1:::0:0:", -- Sentinel's Guard
	[10243]="25179:5035:4:4:1:::0:0:", -- Heavy Lamellar Girdle
	[14843]="25180:5036:4:4:1:::0:0:", -- Tyrant's Helm
	[8144]="25181:5036:4:4:1:::0:0:", -- Chromite Pauldrons
	[14861]="25227:5045:4:4:1:::0:0:", -- Vanguard Vambraces
	[14829]="25249:5049:4:4:1:::0:0:", -- Symbolic Legplates
	[8315]="25306:5061:4:4:1:::0:0:", -- Alabaster Plate Girdle
	[14959]="25717:5143:4:4:1:::0:0:", -- High Chief's Gauntlets
	[10090]="25742:5148:4:4:1:::0:0:", -- Gothic Plate Helmet
	[8157]="25989:5197:4:4:1:::0:0:", -- Jouster's Chestplate
	[9531]="26322:5264:4:4:1:::0:0:", -- Gemshale Pauldrons
	[9291]="26432:5286:4:4:1:::0:0:", -- Field Plate Leggings
	[14821]="26452:5290:4:4:1:::0:0:", -- Symbolic Breastplate
	[14927]="26505:5301:4:4:1:::0:0:", -- Lofty Belt
	[10242]="26592:5318:4:4:1:::0:0:", -- Heavy Lamellar Gauntlets
	[14911]="26637:5327:4:4:1:::0:0:", -- Brutish Boots
	[10788]="26693:5338:4:4:1:::0:0:", -- Atal'ai Girdle
	[8314]="26721:5344:4:4:1:::0:0:", -- Alabaster Plate Gauntlets
	[7921]="26936:5387:4:4:1:::0:0:", -- Heavy Mithril Pants
	[14955]="27090:5418:4:4:1:::0:0:", -- Bloodforged Shoulder Pads
	[8278]="27387:5477:4:4:1:::0:0:", -- Valorous Greaves
	[12424]="27665:5533:4:4:1:::0:0:", -- Imperial Plate Belt
	[17779]="27736:5547:4:4:1:::0:0:", -- Hulkstone Pauldrons
	[14926]="27991:5598:4:4:1:::0:0:", -- Lofty Gauntlets
	[10092]="28011:5602:4:4:1:::0:0:", -- Gothic Plate Spaulders
	[9970]="28654:5730:4:4:1:::0:0:", -- Embossed Plate Leggings
	[7933]="28847:5769:4:4:1:::0:0:", -- Heavy Mithril Boots
	[7934]="28952:5790:4:4:1:::0:0:", -- Heavy Mithril Helm
	[8311]="29224:5844:4:4:1:::0:0:", -- Alabaster Plate Vambraces
	[19037]="29389:5877:4:4:1:::0:0:", -- Emerald Peak Spaulders
	[14951]="29511:5902:4:4:1:::0:0:", -- Bloodforged Sabatons
	[10166]="29542:5908:4:4:1:::0:0:", -- Templar Girdle
	[8279]="29688:5937:4:4:1:::0:0:", -- Valorous Helm
	[7926]="29761:5952:4:4:1:::0:0:", -- Ornate Mithril Pants
	[10201]="29801:5960:4:4:1:::0:0:", -- Overlord's Greaves
	[8281]="29914:5982:4:4:1:::0:0:", -- Valorous Pauldrons
	[14974]="30045:6009:4:4:1:::0:0:", -- Glorious Bindings
	[10171]="30090:6018:4:4:1:::0:0:", -- Templar Bracers
	[9286]="30203:6040:4:4:1:::0:0:", -- Field Plate Armor
	[12425]="30221:6044:4:4:1:::0:0:", -- Imperial Plate Bracers
	[14907]="30619:6123:4:4:1:::0:0:", -- Brutish Helmet
	[11703]="30743:6148:4:4:1:::0:0:", -- Stonewall Girdle
	[14856]="30781:6156:4:4:1:::0:0:", -- Vanguard Girdle
	[10278]="31197:6239:4:4:1:::0:0:", -- Emerald Girdle
	[10165]="31200:6240:4:4:1:::0:0:", -- Templar Gauntlets
	[14921]="32036:6407:4:4:1:::0:0:", -- Jade Epaulets
	[14945]="32162:6432:4:4:1:::0:0:", -- Warbringer's Legguards
	[14938]="32350:6470:4:4:1:::0:0:", -- Heroic Bracers
	[14968]="32510:6502:4:4:1:::0:0:", -- Glorious Belt
	[14855]="32510:6502:4:4:1:::0:0:", -- Vanguard Gauntlets
	[11745]="32825:6565:4:4:1:::0:0:", -- Fists of Phalanx
	[10207]="33477:6695:4:4:1:::0:0:", -- Overlord's Crown
	[14913]="33487:6697:4:4:1:::0:0:", -- Jade Greaves
	[10282]="33561:6712:4:4:1:::0:0:", -- Emerald Vambraces
	[7936]="33696:6739:4:4:1:::0:0:", -- Ornate Mithril Boots
	[9966]="33715:6743:4:4:1:::0:0:", -- Embossed Plate Armor
	[14934]="33770:6754:4:4:1:::0:0:", -- Heroic Girdle
	[7937]="33818:6763:4:4:1:::0:0:", -- Ornate Mithril Helm
	[9646]="33959:6791:4:4:1:::0:0:", -- Gnomish Water Sinking Device
	[14939]="33965:6793:4:4:1:::0:0:", -- Warbringer's Chestguard
	[14848]="34271:6854:4:4:1:::0:0:", -- Sunscale Sabatons
	[14967]="34337:6867:4:4:1:::0:0:", -- Glorious Gauntlets
	[10277]="34926:6985:4:4:1:::0:0:", -- Emerald Gauntlets
	[10370]="34929:6985:4:4:1:::0:0:", -- Imbued Plate Girdle
	[12115]="35060:7012:4:4:1:::0:0:", -- Stalwart Clutch
	[7930]="35228:7045:4:4:1:::0:0:", -- Heavy Mithril Breastplate
	[10131]="35428:7085:4:4:1:::0:0:", -- Revenant Boots
	[10375]="35582:7116:4:4:1:::0:0:", -- Imbued Plate Vambraces
	[10209]="36080:7216:4:4:1:::0:0:", -- Overlord's Spaulders
	[14957]="36119:7223:4:4:1:::0:0:", -- High Chief's Sabatons
	[8143]="36135:7227:4:4:1:::0:0:", -- Chromite Legplates
	[15709]="36352:7270:4:4:1:::0:0:", -- Gearforge Girdle
	[14952]="36619:7323:4:4:1:::0:0:", -- Bloodforged Helmet
	[11889]="36728:7345:4:4:1:::0:0:", -- Bark Iron Pauldrons
	[10369]="36886:7377:4:4:1:::0:0:", -- Imbued Plate Gauntlets
	[14851]="37083:7416:4:4:1:::0:0:", -- Sunscale Spaulders
	[10091]="37208:7441:4:4:1:::0:0:", -- Gothic Plate Leggings
	[15797]="37653:7530:4:4:1:::0:0:", -- Shining Armplates
	[14869]="37886:7577:4:4:1:::0:0:", -- Warleader's Bracers
	[14864]="38012:7602:4:4:1:::0:0:", -- Warleader's Belt
	[10132]="38043:7608:4:4:1:::0:0:", -- Revenant Helmet
	[15795]="38157:7631:4:4:1:::0:0:", -- Emerald Mist Gauntlets
	[10238]="38250:7650:4:4:1:::0:0:", -- Heavy Lamellar Boots
	[10134]="38320:7664:4:4:1:::0:0:", -- Revenant Shoulders
	[8138]="38330:7666:4:4:1:::0:0:", -- Chromite Chestplate
	[14919]="38588:7717:4:4:1:::0:0:", -- Jade Circlet
	[12111]="38841:7768:4:4:1:::0:0:", -- Lavaplate Gauntlets
	[10707]="38862:7772:4:4:1:::0:0:", -- Steelsmith Greaves
	[11632]="39001:7800:4:4:1:::0:0:", -- Earthslag Shoulders
	[14933]="39420:7884:4:4:1:::0:0:", -- Heroic Gauntlets
	[15860]="39535:7907:4:4:1:::0:0:", -- Blinkstrike Armguards
	[18459]="39536:7907:4:4:1:::0:0:", -- Gallant's Wristguards
	[14840]="39627:7925:4:4:1:::0:0:", -- Tyrant's Legplates
	[14863]="39759:7951:4:4:1:::0:0:", -- Warleader's Gauntlets
	[10377]="39891:7978:4:4:1:::0:0:", -- Commander's Vambraces
	[14977]="39913:7982:4:4:1:::0:0:", -- Exalted Girdle
	[14983]="39927:7985:4:4:1:::0:0:", -- Exalted Armsplints
	[8316]="40393:8078:4:4:1:::0:0:", -- Alabaster Plate Greaves
	[10381]="40471:8094:4:4:1:::0:0:", -- Commander's Girdle
	[14835]="40964:8192:4:4:1:::0:0:", -- Tyrant's Chestpiece
	[10391]="40966:8193:4:4:1:::0:0:", -- Hyperion Vambraces
	[14908]="40977:8195:4:4:1:::0:0:", -- Brutish Legguards
	[19124]="41296:8259:4:4:1:::0:0:", -- Slagplate Leggings
	[14849]="41358:8271:4:4:1:::0:0:", -- Sunscale Helmet
	[14922]="41366:8273:4:4:1:::0:0:", -- Lofty Sabatons
	[14963]="41509:8301:4:4:1:::0:0:", -- High Chief's Pauldrons
	[14976]="41748:8349:4:4:1:::0:0:", -- Exalted Gauntlets
	[7935]="41842:8368:4:4:1:::0:0:", -- Ornate Mithril Breastplate
	[10241]="42125:8425:4:4:1:::0:0:", -- Heavy Lamellar Helm
	[10086]="42194:8438:4:4:1:::0:0:", -- Gothic Plate Armor
	[14620]="42231:8446:4:4:1:::0:0:", -- Deathbone Girdle
	[10380]="42342:8468:4:4:1:::0:0:", -- Commander's Gauntlets
	[10387]="42379:8475:4:4:1:::0:0:", -- Hyperion Girdle
	[8280]="42518:8503:4:4:1:::0:0:", -- Valorous Legguards
	[14622]="42553:8510:4:4:1:::0:0:", -- Deathbone Gauntlets
	[13539]="42677:8535:4:4:1:::0:0:", -- Banshee's Touch
	[10245]="42744:8548:4:4:1:::0:0:", -- Heavy Lamellar Pauldrons
	[11872]="42830:8566:4:4:1:::0:0:", -- Eschewal Greaves
	[8317]="42977:8595:4:4:1:::0:0:", -- Alabaster Plate Helmet
	[12428]="43233:8646:4:4:1:::0:0:", -- Imperial Plate Shoulders
	[18351]="43702:8740:4:4:1:::0:0:", -- Magically Sealed Bracers
	[10386]="44329:8865:4:4:1:::0:0:", -- Hyperion Gauntlets
	[19117]="44578:8915:4:4:1:::0:0:", -- Laquered Wooden Plate Legplates
	[14929]="44997:8999:4:4:1:::0:0:", -- Lofty Shoulder Pads
	[14953]="45794:9158:4:4:1:::0:0:", -- Bloodforged Legplates
	[8319]="45906:9181:4:4:1:::0:0:", -- Alabaster Plate Pauldrons
	[12405]="46199:9239:4:4:1:::0:0:", -- Thorium Armor
	[14904]="46227:9245:4:4:1:::0:0:", -- Brutish Breastplate
	[14961]="46295:9259:4:4:1:::0:0:", -- High Chief's Crown
	[14857]="46332:9266:4:4:1:::0:0:", -- Vanguard Sabatons
	[12021]="46636:9327:4:4:1:::0:0:", -- Shieldplate Sabatons
	[10167]="47147:9429:4:4:1:::0:0:", -- Templar Boots
	[11919]="47862:9572:4:4:1:::0:0:", -- Cragplate Greaves
	[10208]="47933:9586:4:4:1:::0:0:", -- Overlord's Legplates
	[14920]="48723:9744:4:4:1:::0:0:", -- Jade Legplates
	[10276]="49238:9847:4:4:1:::0:0:", -- Emerald Sabatons
	[10168]="50161:10032:4:4:1:::0:0:", -- Templar Crown
	[10170]="50528:10105:4:4:1:::0:0:", -- Templar Pauldrons
	[8274]="51259:10251:4:4:1:::0:0:", -- Valorous Chestguard
	[14948]="51509:10301:4:4:1:::0:0:", -- Bloodforged Chestpiece
	[12409]="51682:10336:4:4:1:::0:0:", -- Thorium Boots
	[12410]="51863:10372:4:4:1:::0:0:", -- Thorium Helm
	[10203]="51986:10397:4:4:1:::0:0:", -- Overlord's Chestplate
	[14850]="52214:10442:4:4:1:::0:0:", -- Sunscale Legplates
	[14972]="52430:10486:4:4:1:::0:0:", -- Glorious Sabatons
	[14860]="52616:10523:4:4:1:::0:0:", -- Vanguard Pauldrons
	[14925]="52810:10562:4:4:1:::0:0:", -- Lofty Helm
	[10740]="53464:10692:4:4:1:::0:0:", -- Centurion Legplates
	[11605]="53880:10776:4:4:1:::0:0:", -- Dark Iron Shoulders
	[10133]="53964:10792:4:4:1:::0:0:", -- Revenant Leggings
	[14971]="55380:11076:4:4:1:::0:0:", -- Glorious Shoulder Pads
	[10371]="55747:11149:4:4:1:::0:0:", -- Imbued Plate Greaves
	[10279]="55944:11188:4:4:1:::0:0:", -- Emerald Helm
	[10281]="56362:11272:4:4:1:::0:0:", -- Emerald Pauldrons
	[14937]="57030:11406:4:4:1:::0:0:", -- Heroic Pauldrons
	[14844]="57358:11471:4:4:1:::0:0:", -- Sunscale Chestguard
	[14915]="57847:11569:4:4:1:::0:0:", -- Jade Breastplate
	[14962]="58454:11690:4:4:1:::0:0:", -- High Chief's Legguards
	[11633]="58650:11730:4:4:1:::0:0:", -- Spiderfang Carapace
	[14858]="58702:11740:4:4:1:::0:0:", -- Vanguard Headdress
	[10372]="58754:11750:4:4:1:::0:0:", -- Imbued Plate Helmet
	[14932]="58922:11784:4:4:1:::0:0:", -- Heroic Greaves
	[10374]="59186:11837:4:4:1:::0:0:", -- Imbued Plate Pauldrons
	[18480]="59304:11860:4:4:1:::0:0:", -- Scarab Plate Helm
	[14935]="59428:11885:4:4:1:::0:0:", -- Heroic Skullcap
	[10128]="59538:11907:4:4:1:::0:0:", -- Revenant Chestplate
	[14865]="60094:12018:4:4:1:::0:0:", -- Warleader's Greaves
	[10244]="60199:12039:4:4:1:::0:0:", -- Heavy Lamellar Leggings
	[12426]="60311:12062:4:4:1:::0:0:", -- Imperial Plate Boots
	[12427]="60530:12106:4:4:1:::0:0:", -- Imperial Plate Helm
	[14969]="61205:12241:4:4:1:::0:0:", -- Glorious Headdress
	[12610]="61238:12247:4:4:1:::0:0:", -- Runic Plate Shoulders
	[12611]="61468:12293:4:4:1:::0:0:", -- Runic Plate Boots
	[11910]="61727:12345:4:4:1:::0:0:", -- Bejeweled Legguards
	[10376]="62599:12519:4:4:1:::0:0:", -- Commander's Boots
	[10383]="62609:12521:4:4:1:::0:0:", -- Commander's Pauldrons
	[10240]="62882:12576:4:4:1:::0:0:", -- Heavy Lamellar Chestpiece
	[14928]="63368:12673:4:4:1:::0:0:", -- Lofty Legguards
	[14621]="63588:12717:4:4:1:::0:0:", -- Deathbone Sabatons
	[13533]="64052:12810:4:4:1:::0:0:", -- Acid-etched Pauldrons
	[8318]="64634:12926:4:4:1:::0:0:", -- Alabaster Plate Leggings
	[14958]="64694:12938:4:4:1:::0:0:", -- High Chief's Armor
	[12612]="64783:12956:4:4:1:::0:0:", -- Runic Plate Helm
	[14868]="65547:13109:4:4:1:::0:0:", -- Warleader's Shoulders
	[13527]="65746:13149:4:4:1:::0:0:", -- Lavawalker Greaves
	[10385]="66239:13247:4:4:1:::0:0:", -- Hyperion Greaves
	[10379]="66454:13290:4:4:1:::0:0:", -- Commander's Helm
	[14866]="66507:13301:4:4:1:::0:0:", -- Warleader's Crown
	[11195]="68278:13655:4:4:1:::0:0:", -- Warforged Chestplate
	[14981]="68824:13764:4:4:1:::0:0:", -- Exalted Epaulets
	[14978]="69566:13913:4:4:1:::0:0:", -- Exalted Sabatons
	[14924]="70158:14031:4:4:1:::0:0:", -- Lofty Breastplate
	[10388]="70344:14068:4:4:1:::0:0:", -- Hyperion Helm
	[10390]="70876:14175:4:4:1:::0:0:", -- Hyperion Pauldrons
	[10169]="71151:14230:4:4:1:::0:0:", -- Templar Legplates
	[12952]="71682:14336:4:4:1:::0:0:", -- Skull of Gyth
	[18305]="71879:14375:4:4:1:::0:0:", -- Breakwater Legguards
	[14979]="73324:14664:4:4:1:::0:0:", -- Exalted Helmet
	[10164]="74044:14808:4:4:1:::0:0:", -- Templar Chestplate
	[8312]="74053:14810:4:4:1:::0:0:", -- Alabaster Breastplate
	[14859]="74102:14820:4:4:1:::0:0:", -- Vanguard Legplates
	[11802]="74901:14980:4:4:1:::0:0:", -- Lavacrest Leggings
	[14970]="77992:15598:4:4:1:::0:0:", -- Glorious Legplates
	[10280]="78615:15723:4:4:1:::0:0:", -- Emerald Legplates
	[10275]="81021:16204:4:4:1:::0:0:", -- Emerald Breastplate
	[12422]="81021:16204:4:4:1:::0:0:", -- Imperial Plate Chest
	[14854]="81023:16204:4:4:1:::0:0:", -- Vanguard Breastplate
	[14936]="83513:16702:4:4:1:::0:0:", -- Heroic Legplates
	[14623]="85428:17085:4:4:1:::0:0:", -- Deathbone Legguards
	[10373]="86682:17336:4:4:1:::0:0:", -- Imbued Plate Leggings
	[12414]="86882:17376:4:4:1:::0:0:", -- Thorium Leggings
	[14966]="89006:17801:4:4:1:::0:0:", -- Glorious Breastplate
	[14867]="89014:17802:4:4:1:::0:0:", -- Warleader's Leggings
	[10368]="89343:17868:4:4:1:::0:0:", -- Imbued Plate Armor
	[12429]="89615:17923:4:4:1:::0:0:", -- Imperial Plate Leggings
	[12613]="91025:18205:4:4:1:::0:0:", -- Runic Breastplate
	[12614]="91363:18272:4:4:1:::0:0:", -- Runic Plate Leggings
	[13498]="91372:18274:4:4:1:::0:0:", -- Handcrafted Mastersmith Leggings
	[14862]="91699:18339:4:4:1:::0:0:", -- Warleader's Breastplate
	[14931]="92743:18548:4:4:1:::0:0:", -- Heroic Armor
	[10382]="94041:18808:4:4:1:::0:0:", -- Commander's Leggings
	[14980]="96008:19201:4:4:1:::0:0:", -- Exalted Legplates
	[10378]="97332:19466:4:4:1:::0:0:", -- Commander's Armor
	[10389]="98854:19770:4:4:1:::0:0:", -- Hyperion Legplates
	[14975]="101099:20219:4:4:1:::0:0:", -- Exalted Harness
	[10384]="101850:20370:4:4:1:::0:0:", -- Hyperion Armor
	[13145]="13522:2704:4:4:1:::0:0:", -- Enormous Ogre Belt
	[18447]="14235:2847:4:4:1:::1:0:635", -- Sergeant Major's Plate Wristguards
	[18430]="14391:2878:4:4:1:::1:0:708", -- First Sergeant's Plate Bracers
	[9432]="15135:3027:4:4:1:::0:0:", -- Skullplate Bracers
	[9410]="18925:3785:4:4:1:::0:0:", -- Cragfists
	[7938]="20142:4028:4:4:1:::0:0:", -- Truesilver Gauntlets
	[13071]="20308:4061:4:4:1:::0:0:", -- Plated Fist of Hakoo
	[9394]="22878:4575:4:4:1:::0:0:", -- Horned Viking Helmet
	[13076]="23579:4715:4:4:1:::0:0:", -- Giantslayer Bracers
	[13068]="23927:4785:4:4:1:::0:0:", -- Obsidian Greaves
	[9640]="24201:4840:4:4:1:::0:0:", -- Vice Grips
	[10763]="25989:5197:4:4:1:::0:0:", -- Icemetal Barbute
	[16406]="27728:5545:4:4:1:::0:0:", -- Knight-Lieutenant's Plate Gauntlets
	[16410]="28152:5630:4:4:1:::0:0:", -- Knight-Lieutenant's Lamellar Gauntlets
	[17746]="28618:5723:4:4:1:::0:0:", -- Noxxion's Shackles
	[18445]="29021:5804:4:4:1:::1:0:635", -- Sergeant Major's Plate Wristguards
	[18712]="29105:5821:4:4:1:::0:0:", -- Arena Vambraces
	[18429]="29447:5889:4:4:1:::1:0:708", -- First Sergeant's Plate Bracers
	[16510]="29657:5931:4:4:1:::0:0:", -- Blood Guard's Plate Gloves
	[10798]="31319:6263:4:4:1:::0:0:", -- Atal'alarion's Tusk Ring
	[10775]="31888:6377:4:4:1:::0:0:", -- Carapace of Tuten'kash
	[12550]="32324:6464:4:4:1:::0:0:", -- Runed Golem Shackles
	[13074]="40124:8024:4:4:1:::0:0:", -- Golem Shard Leggings
	[16722]="40528:8105:4:4:1:::0:0:", -- Lightforge Bracers
	[16516]="41118:8223:4:4:1:::0:0:", -- Champion's Plate Pauldrons
	[13077]="41132:8226:4:4:1:::0:0:", -- Girdle of Uther
	[16405]="41433:8286:4:4:1:::0:0:", -- Knight-Lieutenant's Plate Boots
	[16409]="42068:8413:4:4:1:::0:0:", -- Knight-Lieutenant's Lamellar Sabatons
	[9476]="42968:8593:4:4:1:::0:0:", -- Big Bad Pauldrons
	[16723]="43127:8625:4:4:1:::0:0:", -- Lightforge Belt
	[11767]="43188:8637:4:4:1:::0:0:", -- Emberplate Armguards
	[16429]="43208:8641:4:4:1:::0:0:", -- Lieutenant Commander's Plate Helm
	[16432]="43683:8736:4:4:1:::0:0:", -- Lieutenant Commander's Plate Pauldrons
	[16735]="43690:8738:4:4:1:::0:0:", -- Bracers of Valor
	[16434]="44003:8800:4:4:1:::0:0:", -- Lieutenant Commander's Lamellar Headguard
	[16436]="44318:8863:4:4:1:::0:0:", -- Lieutenant Commander's Lamellar Shoulders
	[16509]="44331:8866:4:4:1:::0:0:", -- Blood Guard's Plate Boots
	[12631]="44598:8919:4:4:1:::0:0:", -- Fiery Plate Gauntlets
	[13384]="44941:8988:4:4:1:::0:0:", -- Rainbow Girdle
	[13066]="44989:8997:4:4:1:::0:0:", -- Wyrmslayer Spaulders
	[16514]="45121:9024:4:4:1:::0:0:", -- Champion's Plate Headguard
	[18326]="45184:9036:4:4:1:::0:0:", -- Razor Gauntlets
	[13073]="45404:9080:4:4:1:::0:0:", -- Mugthol's Helm
	[16724]="45459:9091:4:4:1:::0:0:", -- Lightforge Gauntlets
	[16736]="46475:9295:4:4:1:::0:0:", -- Belt of Valor
	[13400]="46482:9296:4:4:1:::0:0:", -- Vambraces of the Sadist
	[19051]="46827:9365:4:4:1:::0:0:", -- Girdle of the Dawn
	[18702]="47443:9488:4:4:1:::0:0:", -- Belt of the Ordained
	[19091]="47443:9488:4:4:1:::1:0:224,774", -- Stormpike Plate Girdle
	[13959]="47712:9542:4:4:1:::0:0:", -- Omokk's Girth Restrainer
	[16737]="48974:9794:4:4:1:::0:0:", -- Gauntlets of Valor
	[18366]="49025:9805:4:4:1:::0:0:", -- Gordok's Handguards
	[18529]="49816:9963:4:4:1:::0:0:", -- Elemental Plate Girdle
	[18741]="49816:9963:4:4:1:::0:0:", -- Morlune's Bracer
	[19087]="50881:10176:4:4:1:::1:0:287,416", -- Frostwolf Plate Belt
	[18383]="50897:10179:4:4:1:::0:0:", -- Force Imbued Gauntlets
	[12637]="51582:10316:4:4:1:::0:0:", -- Backusarian Gauntlets
	[13072]="52134:10426:4:4:1:::0:0:", -- Stonegrip Gauntlets
	[17734]="52285:10457:4:4:1:::0:0:", -- Helm of the Mountain
	[18754]="52306:10461:4:4:1:::0:0:", -- Fel Hardened Bracers
	[10749]="52774:10554:4:4:1:::0:0:", -- Avenguard Helm
	[13162]="52793:10558:4:4:1:::0:0:", -- Reiver Claws
	[14525]="52805:10561:4:4:1:::0:0:", -- Boneclenched Gauntlets
	[18722]="53442:10688:4:4:1:::0:0:", -- Death Grips
	[7939]="54496:10899:4:4:1:::0:0:", -- Truesilver Breastplate
	[19112]="54922:10984:4:4:1:::0:0:", -- Frozen Steel Vambraces
	[18533]="54922:10984:4:4:1:::0:0:", -- Gordok Bracers of Power
	[13951]="55026:11005:4:4:1:::0:0:", -- Vigorsteel Vambraces
	[12555]="57032:11406:4:4:1:::0:0:", -- Battlechaser's Greaves
	[16430]="57824:11564:4:4:1:::0:0:", -- Knight-Captain's Plate Chestguard
	[19057]="58031:11606:4:4:1:::0:0:", -- Gloves of the Dawn
	[16431]="58031:11606:4:4:1:::0:0:", -- Knight-Captain's Plate Leggings
	[12936]="58203:11640:4:4:1:::0:0:", -- Battleborn Armbraces
	[13142]="58209:11641:4:4:1:::0:0:", -- Brigam Girdle
	[10633]="58420:11684:4:4:1:::0:0:", -- Silvershell Leggings
	[16433]="58457:11691:4:4:1:::0:0:", -- Knight-Captain's Lamellar Breastplate
	[16435]="58878:11775:4:4:1:::0:0:", -- Knight-Captain's Lamellar Leggings
	[11746]="59309:11861:4:4:1:::0:0:", -- Golem Skull Helm
	[13502]="59937:11987:4:4:1:::0:0:", -- Handcrafted Mastersmith Girdle
	[16513]="59955:11991:4:4:1:::0:0:", -- Legionnaire's Plate Armor
	[16515]="60375:12075:4:4:1:::0:0:", -- Legionnaire's Plate Legguards
	[13405]="65511:13102:4:4:1:::0:0:", -- Wailing Nightbane Pauldrons
	[16725]="68444:13688:4:4:1:::0:0:", -- Lightforge Boots
	[18313]="68474:13694:4:4:1:::0:0:", -- Helm of Awareness
	[11787]="68664:13732:4:4:1:::0:0:", -- Shalehusk Boots
	[13070]="70437:14087:4:4:1:::0:0:", -- Sapphiron's Scale Boots
	[13166]="71024:14204:4:4:1:::0:0:", -- Slamshot Shoulders
	[18493]="71165:14233:4:4:1:::0:0:", -- Bulky Iron Spaulders
	[10845]="71166:14233:4:4:1:::0:0:", -- Warrior's Embrace
	[17711]="71223:14244:4:4:1:::0:0:", -- Elemental Rockridge Leggings
	[13067]="71709:14341:4:4:1:::0:0:", -- Hydralick Armor
	[12557]="71841:14368:4:4:1:::0:0:", -- Ebonsteel Spaulders
	[18692]="71877:14375:4:4:1:::0:0:", -- Death Knight Sabatons
	[16734]="72680:14536:4:4:1:::0:0:", -- Boots of Valor
	[16729]="72964:14592:4:4:1:::0:0:", -- Lightforge Spaulders
	[12633]="74299:14859:4:4:1:::0:0:", -- Whitesoul Helm
	[16733]="76038:15207:4:4:1:::0:0:", -- Spaulders of Valor
	[13381]="77167:15433:4:4:1:::0:0:", -- Master Cannoneer Boots
	[11678]="77981:15596:4:4:1:::0:0:", -- Carapace of Anub'shiah
	[16727]="79842:15968:4:4:1:::0:0:", -- Lightforge Helm
	[13259]="80348:16069:4:4:1:::0:0:", -- Ribsteel Footguards
	[18384]="80467:16093:4:4:1:::0:0:", -- Bile-etched Spaulders
	[16731]="81051:16210:4:4:1:::0:0:", -- Helm of Valor
	[13955]="81837:16367:4:4:1:::0:0:", -- Stoneform Shoulders
	[11927]="82283:16456:4:4:1:::0:0:", -- Legplates of the Eternal Guardian
	[18718]="82901:16580:4:4:1:::0:0:", -- Grand Crusader's Helm
	[12628]="83203:16640:4:4:1:::0:0:", -- Demon Forged Breastplate
	[14537]="85008:17001:4:4:1:::0:0:", -- Corpselight Greaves
	[12620]="86225:17245:4:4:1:::0:0:", -- Enchanted Thorium Helm
	[18521]="88032:17606:4:4:1:::0:0:", -- Grimy Metal Boots
	[18312]="90369:18073:4:4:1:::0:0:", -- Energized Chestplate
	[13394]="90880:18176:4:4:1:::0:0:", -- Skul's Cold Embrace
	[13168]="95425:19085:4:4:1:::0:0:", -- Plate of the Shaman King
	[11604]="97143:19428:4:4:1:::0:0:", -- Dark Iron Plate
	[18739]="100624:20124:4:4:1:::0:0:", -- Chitinous Plate Legguards
	[16728]="101773:20354:4:4:1:::0:0:", -- Lightforge Legplates
	[14624]="102891:20578:4:4:1:::0:0:", -- Deathbone Chestplate
	[18380]="105677:21135:4:4:1:::0:0:", -- Eldritch Reinforced Legplates
	[16732]="106066:21213:4:4:1:::0:0:", -- Legplates of Valor
	[18690]="110130:22026:4:4:1:::0:0:", -- Wraithplate Leggings
	[13075]="110454:22090:4:4:1:::0:0:", -- Direwing Legguards
	[16726]="111353:22270:4:4:1:::0:0:", -- Lightforge Breastplate
	[15413]="112596:22519:4:4:1:::0:0:", -- Ornate Adamantium Breastplate
	[18503]="112609:22521:4:4:1:::0:0:", -- Kromcrush's Chestplate
	[16730]="113045:22609:4:4:1:::0:0:", -- Breastplate of Valor
	[12935]="115982:23196:4:4:1:::0:0:", -- Warmaster Legguards
	[12618]="119863:23972:4:4:1:::0:0:", -- Enchanted Thorium Breastplate
	[12619]="120290:24058:4:4:1:::0:0:", -- Enchanted Thorium Leggings
	[14549]="39038:7807:4:4:1:::0:0:", -- Boots of Avoidance
	[16484]="41548:8309:4:4:1:::0:0:", -- Marshal's Plate Gauntlets
	[16471]="42644:8528:4:4:1:::0:0:", -- Marshal's Lamellar Gloves
	[16548]="43275:8655:4:4:1:::0:0:", -- General's Plate Gauntlets
	[16476]="60456:12091:4:4:1:::0:0:", -- Field Marshal's Lamellar Pauldrons
	[16478]="60926:12185:4:4:1:::0:0:", -- Field Marshal's Plate Helm
	[16480]="61389:12277:4:4:1:::0:0:", -- Field Marshal's Plate Shoulderguards
	[16483]="62094:12418:4:4:1:::0:0:", -- Marshal's Plate Boots
	[17014]="63189:12637:4:4:1:::0:0:", -- Dark Iron Bracers
	[16542]="63516:12703:4:4:1:::0:0:", -- Warlord's Plate Headpiece
	[16544]="63979:12795:4:4:1:::0:0:", -- Warlord's Plate Shoulders
	[16472]="64195:12839:4:4:1:::0:0:", -- Marshal's Lamellar Boots
	[16545]="64214:12842:4:4:1:::0:0:", -- General's Plate Boots
	[16474]="64665:12933:4:4:1:::0:0:", -- Field Marshal's Lamellar Faceguard
	[12639]="76359:15271:4:4:1:::0:0:", -- Stronghold Gauntlets
	[14552]="76890:15378:4:4:1:::0:0:", -- Stockade Pauldrons
	[16477]="80921:16184:4:4:1:::0:0:", -- Field Marshal's Plate Armor
	[16479]="81548:16309:4:4:1:::0:0:", -- Marshal's Plate Legguards
	[16541]="84375:16875:4:4:1:::0:0:", -- Warlord's Plate Armor
	[16543]="85001:17000:4:4:1:::0:0:", -- General's Plate Leggings
	[16857]="85270:17054:4:4:1:::0:0:", -- Lawbringer Bracers
	[16858]="85599:17119:4:4:1:::0:0:", -- Lawbringer Belt
	[16473]="85907:17181:4:4:1:::0:0:", -- Field Marshal's Lamellar Chestplate
	[16860]="86247:17249:4:4:1:::0:0:", -- Lawbringer Gauntlets
	[19578]="88497:17699:4:4:1:::1:0:353", -- Berserker Bracers
	[16475]="88777:17755:4:4:1:::0:0:", -- Marshal's Lamellar Legplates
	[16861]="88932:17786:4:4:1:::0:0:", -- Bracers of Might
	[16863]="89589:17917:4:4:1:::0:0:", -- Gauntlets of Might
	[16864]="89909:17981:4:4:1:::0:0:", -- Belt of Might
	[19143]="106417:21283:4:4:1:::0:0:", -- Flameguard Gauntlets
	[12640]="109471:21894:4:4:1:::0:0:", -- Lionheart Helm
	[19164]="112127:22425:4:4:1:::0:0:", -- Dark Iron Gauntlets
	[18547]="118096:23619:4:4:1:::0:0:", -- Unmelting Ice Girdle
	[19148]="126998:25399:4:4:1:::0:0:", -- Dark Iron Helm
	[16856]="127425:25485:4:4:1:::0:0:", -- Lawbringer Spaulders
	[16859]="128891:25778:4:4:1:::0:0:", -- Lawbringer Boots
	[17013]="132207:26441:4:4:1:::0:0:", -- Dark Iron Leggings
	[16862]="133891:26778:4:4:1:::0:0:", -- Sabatons of Might
	[16866]="135851:27170:4:4:1:::0:0:", -- Helm of Might
	[16868]="136824:27364:4:4:1:::0:0:", -- Pauldrons of Might
	[16951]="139446:27889:4:4:1:::0:0:", -- Judgement Bindings
	[16854]="139784:27956:4:4:1:::0:0:", -- Lawbringer Helm
	[16952]="139982:27996:4:4:1:::0:0:", -- Judgement Belt
	[16956]="142110:28422:4:4:1:::0:0:", -- Judgement Gauntlets
	[18861]="142467:28493:4:4:1:::0:0:", -- Flamewaker Legplates
	[12895]="147308:29461:4:4:1:::0:0:", -- Breastplate of the Chromatic Flight
	[16959]="147539:29507:4:4:1:::0:0:", -- Bracelets of Wrath
	[16960]="148074:29614:4:4:1:::0:0:", -- Waistband of Wrath
	[14554]="149502:29900:4:4:1:::0:0:", -- Cloudkeeper Legplates
	[16964]="150203:30040:4:4:1:::0:0:", -- Gauntlets of Wrath
	[19137]="157346:31469:4:4:1:::0:0:", -- Onslaught Girdle
	[18824]="167591:33518:4:4:1:::0:0:", -- Magma Tempered Boots
	[18806]="168806:33761:4:4:1:::0:0:", -- Core Forged Greaves
	[16855]="169242:33848:4:4:1:::0:0:", -- Lawbringer Legplates
	[16865]="180477:36095:4:4:1:::0:0:", -- Breastplate of Might
	[16867]="181792:36358:4:4:1:::0:0:", -- Legplates of Might
	[16853]="185721:37144:4:4:1:::0:0:", -- Lawbringer Chestguard
	[19394]="196975:39395:4:4:1:::0:0:", -- Drake Talon Pauldrons
	[19372]="205894:41178:4:4:1:::0:0:", -- Helm of Endless Rage
	[16953]="210776:42155:4:4:1:::0:0:", -- Judgement Spaulders
	[16955]="212361:42472:4:4:1:::0:0:", -- Judgement Crown
	[16957]="219723:43944:4:4:1:::0:0:", -- Judgement Sabatons
	[16963]="224501:44900:4:4:1:::0:0:", -- Helm of Wrath
	[19402]="278048:55609:4:4:1:::0:0:", -- Legguards of the Fallen Crusader
	[16954]="282077:56415:4:4:1:::0:0:", -- Judgement Legplates
	[16962]="298263:59652:4:4:1:::0:0:", -- Legplates of Wrath
	[2362]="7:1:4:6:1:::0:0:", -- Worn Wooden Shield
	[2210]="15:3:4:6:1:::0:0:", -- Battered Buckler
	[2211]="35:7:4:6:1:::0:0:", -- Bent Large Shield
	[2212]="80:16:4:6:1:::0:0:", -- Cracked Buckler
	[2213]="121:24:4:6:1:::0:0:", -- Worn Large Shield
	[2215]="405:81:4:6:1:::0:0:", -- Wooden Shield
	[2214]="910:182:4:6:1:::0:0:", -- Wooden Buckler
	[2216]="1054:210:4:6:1:::0:0:", -- Simple Buckler
	[2217]="1216:243:4:6:1:::0:0:", -- Rectangular Shield
	[2219]="2288:457:4:6:1:::0:0:", -- Small Round Shield
	[2220]="2596:519:4:6:1:::0:0:", -- Box Shield
	[2221]="4550:910:4:6:1:::0:0:", -- Targe Shield
	[2222]="5025:1005:4:6:1:::0:0:", -- Tower Shield
	[3817]="7925:1585:4:6:1:::0:0:", -- Reinforced Buckler
	[3816]="10511:2102:4:6:1:::0:0:", -- Reflective Heater
	[3989]="15772:3154:4:6:1:::0:0:", -- Blocking Targe
	[3986]="26664:5332:4:6:1:::0:0:", -- Protective Pavise
	[3987]="34185:6837:4:6:1:::0:0:", -- Deflecting Tower
	[3990]="41186:8237:4:6:1:::0:0:", -- Crested Buckler
	[17183]="34:6:4:6:1:::1:0:69,98,325,674", -- Dented Buckler
	[17184]="34:6:4:6:1:::1:0:25,251,286,469", -- Small Shield
	[3276]="76:15:4:6:1:::0:0:", -- Deathguard Buckler
	[4911]="76:15:4:6:1:::0:0:", -- Thick Bark Buckler
	[2129]="77:15:4:6:1:::1:0:25,251,286,469", -- Large Round Shield
	[6078]="78:15:4:6:1:::0:0:", -- Pikeman Shield
	[6176]="79:15:4:6:1:::0:0:", -- Dwarven Kite Shield
	[2133]="79:15:4:6:1:::1:0:25,251,286,469", -- Small Shield
	[1200]="82:16:4:6:1:::1:0:69,98,325,674", -- Large Wooden Shield
	[5395]="82:16:4:6:1:::0:0:", -- Woodland Shield
	[17185]="243:48:4:6:1:::1:0:2,312,698,861", -- Round Buckler
	[17186]="243:48:4:6:1:::1:0:28,96,575,666,714,735,832", -- Small Targe
	[15478]="260:52:4:6:1:::0:0:", -- Charger's Shield
	[15895]="265:53:4:6:1:::0:0:", -- Burnt Buckler
	[3650]="342:68:4:6:1:::0:0:", -- Battle Shield
	[1438]="352:70:4:6:1:::0:0:", -- Warrior's Shield
	[4937]="356:71:4:6:1:::0:0:", -- Charging Buckler
	[15006]="364:72:4:6:1:::0:0:", -- Primal Buckler
	[7109]="372:74:4:6:1:::0:0:", -- Pioneer Buckler
	[2900]="446:89:4:6:1:::0:0:", -- Stone Buckler
	[2376]="447:89:4:6:1:::1:0:2,312,698,861", -- Worn Heater Shield
	[2249]="457:91:4:6:1:::0:0:", -- Militia Buckler
	[4263]="470:94:4:6:1:::0:0:", -- Standard Issue Shield
	[1201]="473:94:4:6:1:::1:0:28,96,575,666,714,735,832", -- Dull Heater Shield
	[3649]="575:115:4:6:1:::0:0:", -- Tribal Buckler
	[4967]="580:116:4:6:1:::0:0:", -- Tribal Warrior's Shield
	[5593]="582:116:4:6:1:::0:0:", -- Crag Buckler
	[6203]="608:121:4:6:1:::0:0:", -- Thuggish Shield
	[5940]="769:153:4:6:1:::0:0:", -- Bone Buckler
	[17187]="1078:215:4:6:1:::1:0:321,559,569,698", -- Banded Buckler
	[5094]="1168:233:4:6:1:::0:0:", -- Razormane War Shield
	[1202]="1839:367:4:6:1:::1:0:321,559,569,698", -- Wall Shield
	[17188]="2265:453:4:6:1:::1:0:105,268,441,641,698", -- Ringed Buckler
	[6447]="2810:562:4:6:1:::0:0:", -- Worn Turtle Shell Shield
	[2445]="3433:686:4:6:1:::1:0:105,268,441,641,698", -- Large Metal Shield
	[17192]="4399:879:4:6:1:::1:1:7,84,105,109,123,309,588,641,644,753,809", -- Reinforced Targe
	[9444]="5602:1120:4:6:1:::0:0:", -- Techbot CPU Shell
	[2446]="6182:1236:4:6:1:::1:1:7,84,105,109,123,309,588,641,644,753,809", -- Kite Shield
	[17189]="12043:2408:4:6:1:::1:0:7,105,109,160,200,490,570,641,644,753,809,860", -- Metal Buckler
	[2448]="16158:3231:4:6:1:::1:0:7,105,109,160,200,490,570,641,644,753,809,860", -- Heavy Pavise
	[9403]="22184:4436:4:6:1:::0:0:", -- Battered Viking Shield
	[17190]="34609:6921:4:6:1:::1:0:7,105,279,632,641,644,751,753,809,860", -- Ornate Buckler
	[2451]="43629:8725:4:6:1:::1:0:7,105,279,632,641,644,751,753,809,860", -- Crested Heater Shield
	[7108]="1046:209:4:6:1:::0:0:", -- Infantry Shield
	[15486]="1229:245:4:6:1:::0:0:", -- War Torn Shield
	[9753]="1242:248:4:6:1:::0:0:", -- Gypsy Buckler
	[9764]="1501:300:4:6:1:::0:0:", -- Cadet Shield
	[15298]="1525:305:4:6:1:::0:0:", -- Grizzly Buckler
	[3652]="1820:364:4:6:1:::0:0:", -- Hunting Buckler
	[3654]="1834:366:4:6:1:::0:0:", -- Brackwater Shield
	[3651]="2176:435:4:6:1:::0:0:", -- Veteran Shield
	[3653]="2192:438:4:6:1:::0:0:", -- Ceremonial Buckler
	[3450]="2217:443:4:6:1:::0:0:", -- Faerleia's Shield
	[3160]="2351:470:4:6:1:::0:0:", -- Ironplate Buckler
	[5325]="2493:498:4:6:1:::0:0:", -- Welding Shield
	[6559]="2668:533:4:6:1:::0:0:", -- Bard's Buckler
	[15014]="2927:585:4:6:1:::0:0:", -- Lupine Buckler
	[6187]="3066:613:4:6:1:::0:0:", -- Dwarven Defender
	[6560]="3079:615:4:6:1:::0:0:", -- Soldier's Shield
	[6380]="3271:654:4:6:1:::0:0:", -- Inscribed Buckler
	[15494]="3467:693:4:6:1:::0:0:", -- Bloodspattered Shield
	[4290]="3576:715:4:6:1:::0:0:", -- Dust Bowl
	[9790]="3972:794:4:6:1:::0:0:", -- Raider's Shield
	[15307]="4077:815:4:6:1:::0:0:", -- Feral Buckler
	[15207]="4342:868:4:6:1:::0:0:", -- Steelcap Shield
	[14729]="4350:870:4:6:1:::0:0:", -- War Paint Shield
	[7120]="4479:895:4:6:1:::0:0:", -- Ruga's Bulwark
	[6970]="4531:906:4:6:1:::0:0:", -- Furen's Favor
	[1557]="4594:918:4:6:1:::0:0:", -- Buckler of the Seas
	[5302]="4647:929:4:6:1:::0:0:", -- Cobalt Buckler
	[9778]="4702:940:4:6:1:::0:0:", -- Bandit Buckler
	[3655]="5111:1022:4:6:1:::0:0:", -- Burnished Shield
	[2021]="5129:1025:4:6:1:::0:0:", -- Green Carapace Shield
	[15893]="5410:1082:4:6:1:::0:0:", -- Prospector's Buckler
	[6571]="5834:1166:4:6:1:::0:0:", -- Scouting Buckler
	[15504]="5843:1168:4:6:1:::0:0:", -- Outrunner's Shield
	[4821]="6541:1308:4:6:1:::1:1:164,268,441,835", -- Bear Buckler
	[6572]="6618:1323:4:6:1:::0:0:", -- Defender Shield
	[4822]="6746:1349:4:6:1:::1:1:268,441,835", -- Owl's Disk
	[15113]="6805:1361:4:6:1:::0:0:", -- Rigid Buckler
	[4444]="7450:1490:4:6:1:::0:0:", -- Black Husk Shield
	[6383]="7596:1519:4:6:1:::0:0:", -- Forest Buckler
	[15512]="7891:1578:4:6:1:::0:0:", -- Grunt's Shield
	[4820]="8320:1664:4:6:1:::1:1:164,268,441,835", -- Guardian Buckler
	[9607]="8810:1762:4:6:1:::0:0:", -- Bastion of Stormwind
	[9816]="8906:1781:4:6:1:::0:0:", -- Fortified Shield
	[15894]="9010:1802:4:6:1:::0:0:", -- Bristlebark Buckler
	[9804]="9372:1874:4:6:1:::0:0:", -- Superior Buckler
	[15891]="10074:2014:4:6:1:::0:0:", -- Hulking Shield
	[3656]="10584:2116:4:6:1:::0:0:", -- Lambent Scale Shield
	[16660]="11004:2200:4:6:1:::0:0:", -- Driftmire Shield
	[1276]="11101:2220:4:6:1:::0:0:", -- Fire Hardened Buckler
	[5357]="11107:2221:4:6:1:::0:0:", -- Ward of the Vale
	[6676]="11229:2245:4:6:1:::0:0:", -- Constable Buckler
	[15332]="11319:2263:4:6:1:::0:0:", -- Wrangler's Buckler
	[15466]="11619:2323:4:6:1:::0:0:", -- Clink Shield
	[6598]="12131:2426:4:6:1:::0:0:", -- Dervish Buckler
	[3743]="12256:2451:4:6:1:::0:0:", -- Sentry Buckler
	[15123]="12319:2463:4:6:1:::0:0:", -- Robust Buckler
	[15522]="12584:2516:4:6:1:::0:0:", -- Spiked Chain Shield
	[6599]="13393:2678:4:6:1:::0:0:", -- Battleforge Shield
	[1547]="13978:2795:4:6:1:::0:0:", -- Shield of the Faith
	[15342]="14537:2907:4:6:1:::0:0:", -- Pathfinder Guard
	[4064]="14938:2987:4:6:1:::0:0:", -- Emblazoned Buckler
	[6400]="15445:3089:4:6:1:::0:0:", -- Glimmering Shield
	[14608]="15810:3162:4:6:1:::0:0:", -- Dokebi Buckler
	[15530]="16110:3222:4:6:1:::0:0:", -- Sentry's Shield
	[3761]="16533:3306:4:6:1:::0:0:", -- Deadskull Shield
	[9830]="17445:3489:4:6:1:::0:0:", -- Scaled Shield
	[15892]="17911:3582:4:6:1:::0:0:", -- Slayer's Shield
	[9843]="18696:3739:4:6:1:::0:0:", -- Banded Shield
	[15133]="19134:3826:4:6:1:::0:0:", -- Cutthroat's Buckler
	[7330]="19615:3923:4:6:1:::0:0:", -- Infiltrator Buckler
	[15352]="20507:4101:4:6:1:::0:0:", -- Headhunter's Buckler
	[15543]="20898:4179:4:6:1:::0:0:", -- Wicked Chain Shield
	[7331]="21654:4330:4:6:1:::0:0:", -- Phalanx Shield
	[4477]="21953:4390:4:6:1:::0:0:", -- Nefarious Buckler
	[2916]="22028:4405:4:6:1:::0:0:", -- Gold Lion Shield
	[6223]="23986:4797:4:6:1:::0:0:", -- Crest of Darkshire
	[4066]="24227:4845:4:6:1:::0:0:", -- Insignia Buckler
	[9858]="24414:4882:4:6:1:::0:0:", -- Archer's Buckler
	[9522]="24694:4938:4:6:1:::0:0:", -- Energized Stone Circle
	[15145]="24717:4943:4:6:1:::0:0:", -- Ghostwalker Buckler
	[16788]="25476:5095:4:6:1:::0:0:", -- Captain Rackmore's Wheel
	[15552]="26130:5226:4:6:1:::0:0:", -- Thick Scale Shield
	[4065]="26558:5311:4:6:1:::0:0:", -- Combat Shield
	[15563]="27814:5562:4:6:1:::0:0:", -- Pillager's Shield
	[14607]="27906:5581:4:6:1:::0:0:", -- Hawkeye's Buckler
	[15695]="28856:5771:4:6:1:::0:0:", -- Studded Ring Shield
	[4115]="28915:5783:4:6:1:::0:0:", -- Grom'gol Buckler
	[9873]="29141:5828:4:6:1:::0:0:", -- Renegade Shield
	[7463]="31013:6202:4:6:1:::0:0:", -- Sentinel Buckler
	[15367]="31233:6246:4:6:1:::0:0:", -- Trickster's Protector
	[6828]="31340:6268:4:6:1:::0:0:", -- Visionary Buckler
	[4067]="31909:6381:4:6:1:::0:0:", -- Glyphed Buckler
	[4975]="32389:6477:4:6:1:::0:0:", -- Vigilant Buckler
	[15865]="32811:6562:4:6:1:::0:0:", -- Anchorhold Buckler
	[7465]="33735:6747:4:6:1:::0:0:", -- Knight's Crest
	[3763]="33805:6761:4:6:1:::0:0:", -- Lunar Buckler
	[15990]="34252:6850:4:6:1:::0:0:", -- Enduring Shield
	[4068]="34592:6918:4:6:1:::0:0:", -- Chief Brigadier Shield
	[6746]="35379:7075:4:6:1:::0:0:", -- Basalt Buckler
	[15569]="35813:7162:4:6:1:::0:0:", -- Marauder's Crest
	[17508]="36350:7270:4:6:1:::0:0:", -- Forcestone Buckler
	[14902]="37413:7482:4:6:1:::0:0:", -- Saltstone Shield
	[4070]="37638:7527:4:6:1:::0:0:", -- Jouster's Crest
	[15584]="37973:7594:4:6:1:::0:0:", -- Sparkleshell Shield
	[7747]="38774:7754:4:6:1:::0:0:", -- Vile Protector
	[9899]="39600:7920:4:6:1:::0:0:", -- Jazeraint Shield
	[4507]="41411:8282:4:6:1:::0:0:", -- Pit Fighter's Shield
	[15592]="42328:8465:4:6:1:::0:0:", -- Steadfast Buckler
	[14825]="42977:8595:4:6:1:::0:0:", -- Symbolic Crest
	[7496]="44412:8882:4:6:1:::0:0:", -- Field Plate Shield
	[9661]="45257:9051:4:6:1:::0:0:", -- Earthclasp Barrier
	[9706]="46062:9212:4:6:1:::0:0:", -- Tharg's Disk
	[4129]="47221:9444:4:6:1:::0:0:", -- Collection Plate
	[7495]="47792:9558:4:6:1:::0:0:", -- Captain's Buckler
	[14777]="48551:9710:4:6:1:::0:0:", -- Ravager's Shield
	[9935]="50486:10097:4:6:1:::0:0:", -- Embossed Plate Shield
	[4652]="50631:10126:4:6:1:::0:0:", -- Salbac Shield
	[9918]="51061:10212:4:6:1:::0:0:", -- Brigade Defender
	[7748]="54312:10862:4:6:1:::0:0:", -- Forcestone Buckler
	[15604]="55790:11158:4:6:1:::0:0:", -- Ancient Defender
	[14947]="55992:11198:4:6:1:::0:0:", -- Warbringer's Shield
	[8135]="56171:11234:4:6:1:::0:0:", -- Chromite Shield
	[15618]="58910:11782:4:6:1:::0:0:", -- Bonelink Wall Shield
	[4069]="59503:11900:4:6:1:::0:0:", -- Blackforge Buckler
	[14842]="62415:12483:4:6:1:::0:0:", -- Tyrant's Shield
	[7536]="65244:13048:4:6:1:::0:0:", -- Champion's Wall Shield
	[7537]="70062:14012:4:6:1:::0:0:", -- Gothic Shield
	[14780]="71446:14289:4:6:1:::0:0:", -- Khan's Buckler
	[9958]="73620:14724:4:6:1:::0:0:", -- Warmonger's Buckler
	[14912]="76163:15232:4:6:1:::0:0:", -- Brutish Shield
	[14954]="76174:15234:4:6:1:::0:0:", -- Bloodforged Shield
	[8282]="78478:15695:4:6:1:::0:0:", -- Valorous Shield
	[15621]="78830:15766:4:6:1:::0:0:", -- Gryphon Mail Buckler
	[9643]="79942:15988:4:6:1:::0:0:", -- Optomatic Deflector
	[8134]="79966:15993:4:6:1:::0:0:", -- Myrmidon's Defender
	[15633]="81050:16210:4:6:1:::0:0:", -- Formidable Crest
	[9974]="82246:16449:4:6:1:::0:0:", -- Overlord's Shield
	[11631]="82890:16578:4:6:1:::0:0:", -- Stoneshell Guard
	[14916]="86272:17254:4:6:1:::0:0:", -- Jade Deflector
	[10078]="93213:18642:4:6:1:::0:0:", -- Lord's Crest
	[14790]="93907:18781:4:6:1:::0:0:", -- Protector Buckler
	[10093]="94517:18903:4:6:1:::0:0:", -- Revenant Deflector
	[10195]="96107:19221:4:6:1:::0:0:", -- Crusader's Shield
	[14852]="97100:19420:4:6:1:::0:0:", -- Sunscale Shield
	[10204]="99441:19888:4:6:1:::0:0:", -- Heavy Lamellar Shield
	[11915]="100623:20124:4:6:1:::0:0:", -- Shizzle's Drizzle Blocker
	[10686]="105815:21163:4:6:1:::0:0:", -- Aegis of Battle
	[13254]="107849:21569:4:6:1:::0:0:", -- Astral Guard
	[14964]="108705:21741:4:6:1:::0:0:", -- High Chief's Shield
	[8275]="110140:22028:4:6:1:::0:0:", -- Ebonhold Buckler
	[8320]="110461:22092:4:6:1:::0:0:", -- Alabaster Shield
	[15648]="111061:22212:4:6:1:::0:0:", -- Ironhide Shield
	[15657]="113128:22625:4:6:1:::0:0:", -- Merciless Shield
	[14930]="114751:22950:4:6:1:::0:0:", -- Lofty Shield
	[10362]="123802:24760:4:6:1:::0:0:", -- Ornate Shield
	[10364]="124692:24938:4:6:1:::0:0:", -- Templar Shield
	[14800]="129132:25826:4:6:1:::0:0:", -- Bloodlust Buckler
	[15890]="129157:25831:4:6:1:::0:0:", -- Vanguard Shield
	[10365]="131381:26276:4:6:1:::0:0:", -- Emerald Shield
	[10363]="136982:27396:4:6:1:::0:0:", -- Engraved Wall
	[15943]="138761:27752:4:6:1:::0:0:", -- Imbued Shield
	[14973]="139051:27810:4:6:1:::0:0:", -- Glorious Shield
	[18352]="140363:28072:4:6:1:::0:0:", -- Petrified Bark Shield
	[15667]="143928:28785:4:6:1:::0:0:", -- Impenetrable Wall
	[15675]="144661:28932:4:6:1:::0:0:", -- Magnificent Guard
	[15991]="146151:29230:4:6:1:::0:0:", -- Warleader's Shield
	[15887]="147908:29581:4:6:1:::0:0:", -- Heroic Guard
	[8313]="153187:30637:4:6:1:::0:0:", -- Hero's Buckler
	[10158]="155200:31040:4:6:1:::0:0:", -- Mercurial Guard
	[10366]="160263:32052:4:6:1:::0:0:", -- Demon Guard
	[10271]="162960:32592:4:6:1:::0:0:", -- Masterwork Shield
	[10367]="164856:32971:4:6:1:::0:0:", -- Hyperion Shield
	[13245]="5323:1064:4:6:1:::0:0:", -- Kresh's Back
	[5443]="5335:1067:4:6:1:::0:0:", -- Gold-plated Buckler
	[12997]="9600:1920:4:6:1:::0:0:", -- Redbeard Crest
	[6630]="10337:2067:4:6:1:::0:0:", -- Seedcloud Buckler
	[6320]="13556:2711:4:6:1:::0:0:", -- Commander's Crest
	[7002]="15141:3028:4:6:1:::0:0:", -- Arctic Buckler
	[13079]="16798:3359:4:6:1:::0:0:", -- Shield of Thorsen
	[7787]="19802:3960:4:6:1:::0:0:", -- Resplendent Guardian
	[6725]="30528:6105:4:6:1:::0:0:", -- Marbled Buckler
	[6694]="31546:6309:4:6:1:::0:0:", -- Heart of Agamaggan
	[9458]="34589:6917:4:6:1:::0:0:", -- Thermaplugg's Central Core
	[13081]="35617:7123:4:6:1:::0:0:", -- Skullance Shield
	[9404]="46991:9398:4:6:1:::0:0:", -- Olaf's All Purpose Shield
	[10767]="48260:9652:4:6:1:::0:0:", -- Savage Boar's Guard
	[7726]="58406:11681:4:6:1:::0:0:", -- Aegis of the Scarlet Commander
	[13082]="66175:13235:4:6:1:::0:0:", -- Mountainside Buckler
	[2040]="76482:15296:4:6:1:::0:0:", -- Troll Protector
	[17718]="113150:22630:4:6:1:::0:0:", -- Gizlock's Hypertech Buckler
	[1203]="117526:23505:4:6:1:::0:0:", -- Aegis of Stormwind
	[10835]="123225:24645:4:6:1:::0:0:", -- Crest of Supremacy
	[18673]="144591:28918:4:6:1:::0:0:", -- Avalanchion's Stony Hide
	[11785]="145414:29082:4:6:1:::0:0:", -- Rock Golem Bulwark
	[18535]="151155:30231:4:6:1:::0:0:", -- Milli's Shield
	[13375]="153284:30656:4:6:1:::0:0:", -- Crest of Retribution
	[13529]="161517:32303:4:6:1:::0:0:", -- Husk of Nerub'enkan
	[18756]="167101:33420:4:6:1:::0:0:", -- Dreadguard's Protector
	[18696]="167382:33476:4:6:1:::0:0:", -- Intricately Runed Shield
	[14528]="170909:34181:4:6:1:::0:0:", -- Rattlecage Buckler
	[18485]="172849:34569:4:6:1:::0:0:", -- Observer's Shield
	[18499]="172945:34589:4:6:1:::0:0:", -- Barrier Shield
	[13083]="173470:34694:4:6:1:::0:0:", -- Garrett Family Crest
	[13205]="175155:35031:4:6:1:::0:0:", -- Rhombeard Protector
	[12602]="176064:35212:4:6:1:::0:0:", -- Draconian Deflector
	[16998]="178156:35631:4:6:1:::0:0:", -- Sacred Protector
	[13243]="182578:36515:4:6:1:::0:0:", -- Argent Defender
	[14002]="183600:36720:4:6:1:::0:0:", -- Darrowshire Strongguard
	[1204]="62886:12577:4:6:1:::0:0:", -- The Green Tower
	[18826]="84632:16926:4:6:1:::0:0:", -- High Warlord's Shield Wall
	[1169]="94076:18815:4:6:1:::0:0:", -- Blackskull Shield
	[1979]="116369:23273:4:6:1:::0:0:", -- Wall of the Dead
	[18825]="159036:31807:4:6:1:::0:0:", -- Grand Marshal's Aegis
	[1168]="211484:42296:4:6:1:::0:0:", -- Skullflame Shield
	[18168]="282082:56416:4:6:1:::0:0:", -- Force Reactive Disk
	[17066]="289852:57970:4:6:1:::0:0:", -- Drillborer Disk
	[19348]="422012:84402:4:6:1:::0:0:", -- Red Dragonscale Protector
	[17106]="439804:87960:4:6:1:::0:0:", -- Malistar's Defender
	[19349]="490283:98056:4:6:1:::0:0:", -- Elementium Reinforced Bulwark
	[19321]="795297:159059:4:6:1:::1:0:287,416,774", -- The Immovable Object
	[5529]="500:125:5:0:20:::0:0:", -- Tomb Dust
	[5178]="0:0:5:0:1:::0:0:", -- Air Totem
	[5175]="0:0:5:0:1:::0:0:", -- Earth Totem
	[5176]="0:0:5:0:1:::0:0:", -- Fire Totem
	[6265]="0:0:5:0:1::-9:0:0:", -- Soul Shard
	[5177]="0:0:5:0:1:::0:0:", -- Water Totem
	[6522]="16:4:5:0:20::185,171:0:0:", -- Deviate Fish
	[6358]="16:4:5:0:20::171:0:0:", -- Oily Blackmouth
	[6359]="20:5:5:0:20::171:0:0:", -- Firefin Snapper
	[2665]="20:5:5:0:20::185:1:0:204", -- Stormwind Seasoning Herbs
	[5140]="25:6:5:0:10::-4:1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Flash Powder
	[4470]="38:9:5:0:20::333:1:0:11,42,46,48,51,94,106,111,115,119,122,131,136,138,167,180,184,199,250,263,265,267,284,296,303,305,311,391,403,408,412,420,421,428,436,454,481,491,495,519,526,529,546,558,568,587,594,622,623,667,675,700,770,789,793,803,808,825,837,867,872", -- Simple Wood
	[6370]="40:10:5:0:20::171,333:0:0:", -- Blackmouth Oil
	[1251]="40:10:5:0:20:::0:0:", -- Linen Bandage
	[13422]="40:10:5:0:20::171:0:0:", -- Stonescale Eel
	[6371]="48:12:5:0:20::197,171,333:0:0:", -- Fire Oil
	[6470]="80:20:5:0:20::165:0:0:", -- Deviate Scale
	[2581]="80:20:5:0:20:::0:0:", -- Heavy Linen Bandage
	[6452]="115:28:5:0:20:::0:0:", -- Anti-Venom
	[3530]="115:28:5:0:20:::0:0:", -- Wool Bandage
	[4471]="135:33:5:0:1:::1:0:11,42,46,48,51,94,106,111,115,119,122,131,136,138,167,180,184,199,263,265,267,284,296,303,305,311,391,403,408,412,428,436,454,491,495,529,546,558,568,587,594,622,623,667,675,700,789,803,808,825,837,867,872", -- Flint and Tinder
	[4611]="200:50:5:0:20::202:0:0:", -- Blue Pearl
	[17034]="200:50:5:0:20::-11:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Maple Seed
	[3531]="230:57:5:0:20:::0:0:", -- Heavy Wool Bandage
	[6453]="250:62:5:0:20:::0:0:", -- Strong Anti-Venom
	[5636]="300:75:5:0:10:::0:0:", -- Delicate Feather
	[7071]="400:100:5:0:5::165,197:0:0:", -- Iron Buckle
	[15420]="400:100:5:0:50::165:0:0:", -- Ironfeather
	[8168]="400:100:5:0:20::164,165:0:0:", -- Jet Black Feather
	[17035]="400:100:5:0:20::-11:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Stranglethorn Seed
	[5530]="500:125:5:0:20::-4:0:0:", -- Blinding Powder
	[13423]="500:125:5:0:20::171:0:0:", -- Stonescale Oil
	[7072]="600:150:5:0:10::197:0:0:", -- Naga Scale
	[17028]="700:175:5:0:20:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Holy Candle
	[17021]="700:175:5:0:20:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Wild Berries
	[17036]="800:200:5:0:20::-11:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Ashwood Seed
	[6450]="800:200:5:0:20:::0:0:", -- Silk Bandage
	[17020]="1000:250:5:0:20:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Arcane Powder
	[9061]="1000:250:5:0:20::202:0:0:", -- Goblin Rocket Fuel
	[17031]="1000:250:5:0:10::-8:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Rune of Teleportation
	[17029]="1000:250:5:0:20:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Sacred Candle
	[17026]="1000:250:5:0:20:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Wild Thornroot
	[13757]="1200:10:5:0:20:::0:0:", -- Lightning Eel
	[5116]="1215:303:5:0:10::165:0:0:", -- Long Tail Feather
	[17037]="1400:350:5:0:20::-11:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Hornbeam Seed
	[13890]="1400:70:5:0:20:::0:0:", -- Plated Armorfish
	[7081]="1600:400:5:0:10::164,333:0:0:", -- Breath of Wind
	[7075]="1600:400:5:0:10::164,165,202,333:0:0:", -- Core of Earth
	[7069]="1600:400:5:0:10::202,164,197:0:0:", -- Elemental Air
	[7067]="1600:400:5:0:10::197,165,171,202,333,164:0:0:", -- Elemental Earth
	[7068]="1600:400:5:0:10::197,164,171,202,333:0:0:", -- Elemental Fire
	[7070]="1600:400:5:0:10::171,164,197,165:0:0:", -- Elemental Water
	[7079]="1600:400:5:0:10::197,165,333:0:0:", -- Globe of Water
	[7077]="1600:400:5:0:10::164,202,197,165,333:0:0:", -- Heart of Fire
	[10286]="1600:400:5:0:10::171,197,202:0:0:", -- Heart of the Wild
	[6451]="1600:400:5:0:20:::0:0:", -- Heavy Silk Bandage
	[7972]="1600:400:5:0:10::164,202,333,171:0:0:", -- Ichor of Undeath
	[8544]="1600:400:5:0:20:::0:0:", -- Mageweave Bandage
	[17030]="2000:500:5:0:5::-7:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Ankh
	[17038]="2000:500:5:0:20::-11:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Ironwood Seed
	[6471]="2000:500:5:0:20::165:0:0:", -- Perfect Deviate Scale
	[19440]="2000:500:5:0:10:::0:0:", -- Powerful Anti-Venom
	[17032]="2000:500:5:0:10::-8:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Rune of Portals
	[14529]="2000:500:5:0:20:::0:0:", -- Runecloth Bandage
	[17033]="2000:500:5:0:5::-2:1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Symbol of Divinity
	[8545]="2400:600:5:0:20:::0:0:", -- Heavy Mageweave Bandage
	[14530]="4000:1000:5:0:20:::0:0:", -- Heavy Runecloth Bandage
	[9060]="4000:1000:5:0:20::202:0:0:", -- Inlaid Mithril Cylinder
	[11291]="4500:1125:5:0:20::333:1:1:250,420,421,481,519,526,793", -- Star Wood
	[5565]="5000:1250:5:0:5:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Infernal Stone
	[19307]="8000:100:5:0:100:::20:0:224,287,416,774", -- Alterac Heavy Runecloth Bandage
	[16583]="10000:2500:5:0:5:::1:0:21,42,45,49,101,116,150,152,196,210,247,298,308,346,351,392,411,414,459,497,503,523,533,548,584,604,649,747,765,785,871", -- Demonic Figurine
	[18512]="16000:4000:5:0:5::165:0:0:", -- Larval Acid
	[7082]="1600:400:5:0:10::165,171,197,202,333:0:0:", -- Essence of Air
	[7076]="1600:400:5:0:10::164,202,165,171,197,333:0:0:", -- Essence of Earth
	[7078]="1600:400:5:0:10::165,202,197,333,171,164:0:0:", -- Essence of Fire
	[7080]="1600:400:5:0:10::164,165,197,171,202,333:0:0:", -- Essence of Water
	[12803]="2000:500:5:0:10::164,165,171,202,333,197:0:0:", -- Living Essence
	[12808]="4000:1000:5:0:10::164,171,197,202,333:0:0:", -- Essence of Undeath
	[17010]="8000:2000:5:0:10::197,165,164,202:0:0:", -- Fiery Core
	[17011]="8000:2000:5:0:10::165,197,164,202:0:0:", -- Lava Core
	[2512]="10:0:6:2:200:::200:0:5,11,44,48,51,63,79,92,94,102,114,119,122,124,138,167,175,180,181,184,199,218,243,246,267,296,314,403,412,415,418,424,430,436,452,458,476,491,495,496,527,529,544,560,587,594,595,607,608,616,667,671,730,747,772,789,803,804,808,826,854,867,872,880,886", -- Rough Arrow
	[2515]="50:0:6:2:200:::200:0:42,44,46,48,63,79,92,95,106,111,114,115,119,122,124,131,136,138,180,181,184,199,218,243,246,263,265,267,284,296,303,305,311,314,391,408,412,415,418,424,428,436,454,458,476,495,496,527,529,546,558,560,568,595,607,608,616,622,623,667,671,675,700,730,747,772,789,803,804,808,825,826,837,854,867,872,880,886", -- Sharp Arrow
	[3030]="300:0:6:2:200:::200:0:42,44,46,92,95,106,111,114,115,119,131,136,181,184,199,218,263,265,284,303,305,311,314,391,408,418,424,428,454,476,496,527,546,558,560,568,595,616,622,623,675,700,730,747,772,789,803,808,825,837,880", -- Razor Arrow
	[11285]="1000:2:6:2:200:::200:0:42,44,46,92,95,106,111,114,115,119,131,136,184,199,218,263,265,305,311,314,391,418,424,428,454,496,558,568,595,622,675,700,730,747,789,803,808,825,837,880", -- Jagged Arrow
	[3464]="35:8:6:2:200:::0:0:", -- Feathered Arrow
	[9399]="40:10:6:2:200:::0:0:", -- Precision Arrow
	[18042]="4000:10:6:2:200:::0:0:", -- Thorium Headed Arrow
	[19316]="6000:7:6:2:200:::200:0:224,287,416,774", -- Ice Threaded Arrow
	[12654]="250:62:6:2:200:::0:0:", -- Doomshot
	[8067]="10:0:6:3:200:::0:0:", -- Crafted Light Shot
	[2516]="10:0:6:3:200:::200:0:5,11,48,51,72,89,94,102,114,119,122,138,167,175,180,184,199,267,296,328,334,388,403,412,430,436,438,452,465,491,495,527,529,544,587,594,599,667,747,772,783,789,802,803,808,826,843,855,867,872", -- Light Shot
	[5568]="16:4:6:3:200:::0:0:", -- Smooth Pebble
	[8068]="50:0:6:3:200:::0:0:", -- Crafted Heavy Shot
	[4960]="50:12:6:3:200:::0:0:", -- Flash Pellet
	[2519]="50:0:6:3:200:::200:0:42,46,48,72,89,95,106,111,114,115,119,122,131,136,138,180,184,199,263,265,267,284,296,303,305,311,328,334,388,391,408,412,428,438,454,465,495,527,529,546,558,568,599,622,623,667,675,700,747,772,783,789,802,803,808,825,826,837,843,855,867,872", -- Heavy Shot
	[8069]="300:0:6:3:200:::0:0:", -- Crafted Solid Shot
	[3033]="300:0:6:3:200:::200:0:42,46,72,89,106,111,114,115,119,131,136,184,199,263,265,284,303,305,311,334,388,391,408,428,438,454,527,546,558,568,599,622,623,675,700,747,789,802,803,808,825,837,855", -- Solid Shot
	[11284]="1000:1:6:3:200:::200:0:42,46,72,89,106,111,114,115,119,131,136,184,199,263,265,305,311,391,428,438,454,527,558,568,599,622,675,700,747,789,802,803,808,825,837,855", -- Accurate Slugs
	[3465]="36:9:6:3:200:::0:0:", -- Exploding Shot
	[10512]="1000:2:6:3:200:::0:0:", -- Hi-Impact Mithril Slugs
	[10513]="2000:5:6:3:200:::0:0:", -- Mithril Gyro-Shot
	[15997]="4000:10:6:3:200:::0:0:", -- Thorium Shells
	[19317]="6000:7:6:3:200:::200:0:224,287,416,774", -- Ice Threaded Bullet
	[11630]="20:5:6:3:200:::0:0:", -- Rockshard Pellets
	[13377]="30:7:6:3:200:::0:0:", -- Miniature Cannon Balls
	[6986]="200:50:7:0:10:::0:0:", -- Crimson Lotus
	[878]="225:56:7:0:10:::0:0:", -- Fist-sized Spinneret
	[5833]="0:0:7:0:20:::0:0:", -- Indurium Ore
	[11040]="4:1:7:0:20:::0:0:", -- Morrowgrain
	[2835]="8:2:7:0:20::164:0:0:", -- Rough Stone
	[2320]="10:2:7:0:20::197,165:1:0:3,14,22,23,27,29,47,48,70,76,81,90,107,120,121,125,139,141,142,149,166,167,168,174,178,185,203,205,208,209,213,216,236,238,242,246,253,255,263,291,299,305,306,322,333,395,397,404,417,423,434,457,466,467,473,478,495,507,514,520,529,535,538,557,578,579,594,605,620,625,630,647,656,657,663,672,673,684,693,716,718,720,722,754,757,758,761,766,767,775,791,801,803,810,816,829,838,839,848,854,857,858,863,869,874,893", -- Coarse Thread
	[17194]="10:0:7:0:20::185:0:0:", -- Holiday Spices
	[2678]="10:0:7:0:20::185:5:0:3,23,27,47,48,80,107,120,121,139,141,154,166,167,178,185,191,192,203,205,208,213,246,248,253,255,263,291,305,333,395,404,457,463,466,467,478,495,507,529,538,578,579,594,605,606,620,625,634,645,663,672,716,718,721,722,754,757,758,764,766,775,803,816,838,854,862,863,868,884,893", -- Mild Spices
	[2862]="12:3:7:0:20:::0:0:", -- Rough Sharpening Stone
	[3239]="12:3:7:0:20:::0:0:", -- Rough Weightstone
	[5465]="12:3:7:0:10::185:0:0:", -- Small Spider Leg
	[769]="15:3:7:0:10:::0:0:", -- Chunk of Boar Meat
	[12223]="16:4:7:0:10::185:0:0:", -- Meaty Bat Wing
	[6889]="16:4:7:0:10::185:0:0:", -- Small Egg
	[2672]="16:4:7:0:10::185:0:0:", -- Stringy Wolf Meat
	[2770]="20:5:7:0:10:::0:0:", -- Copper Ore
	[2886]="20:5:7:0:10::185:0:0:", -- Crag Boar Rib
	[2928]="20:5:7:0:20::-4:1:0:23,27,47,121,139,141,178,195,203,205,239,255,263,305,333,351,404,406,411,457,478,495,497,507,529,538,555,605,625,651,663,672,681,696,716,718,722,733,734,737,754,757,803,813,838,871,893", -- Dust of Decay
	[3371]="20:1:7:0:20::171,-4:5:0:3,10,23,27,30,47,48,73,87,93,97,107,120,121,139,141,150,157,166,167,171,178,183,185,194,195,203,205,208,213,239,246,249,253,255,263,291,295,305,318,333,351,394,395,404,406,411,457,459,466,467,478,482,485,495,497,507,529,534,538,555,562,578,579,594,605,611,620,625,627,629,651,659,663,672,676,681,696,705,716,718,722,733,734,737,739,754,757,758,760,766,769,775,785,803,813,816,819,838,841,854,863,871,885,893", -- Empty Vial
	[3470]="20:5:7:0:20::164:0:0:", -- Rough Grinding Stone
	[8153]="20:5:7:0:20::164,171,165,197,202,333:0:0:", -- Wildvine
	[2324]="25:6:7:0:10::197,165:1:0:3,14,23,27,47,48,81,90,107,120,121,141,142,149,166,167,174,178,185,203,205,208,213,216,238,242,246,253,255,291,395,417,434,466,467,473,478,495,507,529,535,538,557,578,579,594,605,620,647,656,672,673,718,720,722,754,758,766,767,775,801,803,816,829,838,839,854,858,863,869,874,893", -- Bleach
	[732]="25:6:7:0:10:::0:0:", -- Okra
	[5467]="30:7:7:0:10::185:0:0:", -- Kodo Meat
	[2934]="30:7:7:0:10:::0:0:", -- Ruined Leather Scraps
	[5466]="32:8:7:0:10::185:0:0:", -- Scorpid Stinger
	[1274]="35:8:7:0:20:::0:0:", -- Hops
	[5469]="36:9:7:0:10::185:0:0:", -- Strider Meat
	[3478]="40:10:7:0:20::164:0:0:", -- Coarse Grinding Stone
	[2863]="40:10:7:0:20:::0:0:", -- Coarse Sharpening Stone
	[3240]="40:10:7:0:20:::0:0:", -- Coarse Weightstone
	[2840]="40:10:7:0:20::164,202:0:0:", -- Copper Bar
	[2673]="40:10:7:0:10::185:0:0:", -- Coyote Meat
	[2692]="40:10:7:0:20::185:1:0:23,27,47,48,80,107,120,121,139,141,154,166,178,185,191,192,203,205,208,246,248,255,263,291,305,333,395,404,457,463,466,467,478,495,507,529,538,578,579,605,606,625,634,645,663,672,716,718,721,722,754,757,764,766,803,816,838,854,862,868,884,893", -- Hot Spices
	[3777]="40:10:7:0:20:::1:0:47,121,139,141,178,195,205,239,255,263,305,333,351,404,406,411,457,478,497,507,538,555,605,625,651,663,681,696,716,718,722,733,734,737,754,757,803,813,838,871,893", -- Lethargy Root
	[2447]="40:10:7:0:20::171:1:1:183,351,562,705,769", -- Peacebloom
	[765]="40:10:7:0:20::171:1:1:183,351,562,705", -- Silverleaf
	[2675]="44:11:7:0:10::185:0:0:", -- Crawler Claw
	[2674]="48:12:7:0:10::185:0:0:", -- Crawler Meat
	[2251]="48:12:7:0:10::185:0:0:", -- Gooey Spider Leg
	[5468]="48:12:7:0:10::185:0:0:", -- Soft Frenzy Flesh
	[6260]="50:12:7:0:10::197:1:0:3,14,22,29,48,70,76,81,90,121,125,141,142,149,166,167,168,174,178,185,203,205,209,213,216,236,238,242,246,253,255,299,306,322,397,417,423,434,466,473,514,520,535,557,579,594,605,620,630,647,656,657,673,684,693,720,722,754,758,761,766,767,775,791,801,803,810,816,829,839,848,854,857,858,863,869,874,893", -- Blue Dye
	[2930]="50:12:7:0:10::-4:1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Essence of Pain
	[2604]="50:12:7:0:10::197:1:0:3,14,22,29,47,48,70,76,81,90,121,125,139,141,142,149,166,167,168,174,178,185,203,205,209,213,236,238,242,246,253,255,263,299,305,306,322,333,397,404,417,423,434,457,466,473,478,507,514,520,535,538,557,579,594,605,620,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,758,761,766,767,775,791,801,803,810,816,829,838,839,848,854,857,858,863,869,874,893", -- Red Dye
	[4289]="50:12:7:0:20::165:1:0:3,22,23,27,29,47,48,70,76,107,120,121,125,139,141,166,167,168,178,185,203,205,208,209,213,236,246,253,255,263,291,299,305,306,322,333,395,397,404,423,457,466,467,478,495,507,514,520,521,529,538,578,579,594,605,620,625,630,657,663,672,684,693,716,718,722,754,757,758,761,766,775,791,803,810,816,838,848,854,857,863,874,893", -- Salt
	[6987]="55:13:7:0:10:::0:0:", -- Fish Scale
	[2589]="55:13:7:0:20::164,129,202:0:0:", -- Linen Cloth
	[3173]="60:15:7:0:10::185:0:0:", -- Bear Meat
	[2677]="60:15:7:0:10::185:0:0:", -- Boar Ribs
	[2836]="60:15:7:0:20::164,202:0:0:", -- Coarse Stone
	[723]="60:15:7:0:10::185:0:0:", -- Goretusk Liver
	[2318]="60:15:7:0:10::202,165,197,164:0:0:", -- Light Leather
	[2452]="60:15:7:0:20::171,185:0:0:", -- Swiftthistle
	[5503]="65:16:7:0:10::185:0:0:", -- Clam Meat
	[2924]="65:16:7:0:10::185:0:0:", -- Crocolisk Meat
	[730]="65:16:7:0:10::185:0:0:", -- Murloc Eye
	[3174]="65:16:7:0:10::185:0:0:", -- Spider Ichor
	[729]="70:17:7:0:10::185:0:0:", -- Stringy Vulture Meat
	[3172]="75:18:7:0:10::185:0:0:", -- Boar Intestines
	[2449]="80:20:7:0:20::171:1:1:30,61,351,414,482,521,562,584,705,747", -- Earthroot
	[785]="80:20:7:0:20::171:1:1:30,61,351,414,482,521,529,562,584,705", -- Mageroyal
	[5504]="90:22:7:0:10::185:0:0:", -- Tangy Clam Meat
	[1015]="96:24:7:0:10::185:0:0:", -- Lean Wolf Flank
	[2450]="100:25:7:0:20::171:0:0:", -- Briarthorn
	[2453]="100:25:7:0:20::171:1:1:30,61,351,414,482,521,529,562,584,705", -- Bruiseweed
	[5173]="100:25:7:0:10::-4:1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Deathweed
	[8924]="100:25:7:0:20::-4:1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Dust of Deterioration
	[2321]="100:25:7:0:20::165,197,164:1:0:14,22,23,27,29,47,48,70,76,81,90,107,120,121,125,139,141,142,149,166,168,174,178,185,203,205,208,209,216,236,238,242,246,255,263,291,299,305,306,322,333,395,397,404,417,423,434,457,466,467,473,478,495,507,514,520,529,535,538,557,578,579,605,625,630,647,656,657,663,672,673,684,693,716,718,720,722,754,757,761,766,767,791,801,803,810,816,829,838,839,848,854,857,858,869,874,893", -- Fine Thread
	[814]="100:25:7:0:20::202:0:0:", -- Flask of Oil
	[3369]="100:25:7:0:20::171:0:0:", -- Grave Moss
	[2605]="100:25:7:0:10::165,197,164:1:0:14,22,29,48,70,76,81,90,121,125,141,142,149,166,168,174,178,185,203,205,209,236,238,242,246,255,299,306,322,397,417,423,434,466,473,514,520,535,557,579,605,630,647,656,657,673,684,693,720,722,754,761,766,767,791,801,803,810,816,829,839,848,854,857,858,869,874,893", -- Green Dye
	[3667]="100:25:7:0:10::185:0:0:", -- Tender Crocolisk Meat
	[5082]="100:25:7:0:10::165:0:0:", -- Thin Kodo Leather
	[2771]="100:25:7:0:10::186:0:0:", -- Tin Ore
	[2880]="100:25:7:0:10::164,202:1:0:3,23,27,47,48,59,64,91,100,107,120,121,139,141,166,167,178,185,203,205,208,213,215,225,233,241,246,252,253,255,257,263,273,283,291,305,311,315,333,335,348,352,395,401,404,413,419,437,442,445,457,466,467,478,493,495,507,510,529,538,539,542,553,568,572,578,579,594,605,609,620,623,625,663,672,689,716,718,722,736,740,742,753,754,757,758,766,775,776,782,788,795,803,805,806,816,838,854,861,863,870,879,893", -- Weak Flux
	[731]="110:27:7:0:10::185:0:0:", -- Goretusk Snout
	[1468]="115:28:7:0:10::185:0:0:", -- Murloc Fin
	[5470]="115:28:7:0:10::185:0:0:", -- Thunder Lizard Tail
	[3356]="120:30:7:0:20::171,165,333:1:1:30,61,414,482,521,562,584", -- Kingsblood
	[5471]="120:30:7:0:10::185:0:0:", -- Stag Meat
	[6217]="124:24:7:0:1:::1:0:3,23,27,47,48,87,107,120,121,139,141,166,167,178,183,185,203,205,208,213,246,250,253,255,263,291,295,305,333,395,404,420,421,457,466,467,478,481,495,507,519,526,529,538,578,579,594,605,620,625,663,672,705,716,718,722,754,757,758,766,775,793,803,816,819,838,854,863,885,893", -- Copper Rod
	[6218]="124:24:7:0:1:::0:0:", -- Runed Copper Rod
	[6339]="124:24:7:0:1:::0:0:", -- Runed Silver Rod
	[3340]="125:31:7:0:10:::0:0:", -- Incendicite Ore
	[3164]="135:33:7:0:10::171:0:0:", -- Discolored Worg Heart
	[2592]="135:33:7:0:20::202,197,164,129:0:0:", -- Wool Cloth
	[3576]="140:35:7:0:20:::0:0:", -- Tin Bar
	[2996]="160:40:7:0:10::197:0:0:", -- Bolt of Linen Cloth
	[2871]="160:40:7:0:20:::0:0:", -- Heavy Sharpening Stone
	[3241]="160:40:7:0:20:::0:0:", -- Heavy Weightstone
	[7964]="160:40:7:0:20:::0:0:", -- Solid Sharpening Stone
	[7965]="160:40:7:0:20:::0:0:", -- Solid Weightstone
	[3713]="160:40:7:0:20::185:1:0:47,80,107,120,121,139,141,154,178,185,191,192,203,205,208,248,255,263,291,305,333,395,404,457,463,467,478,507,538,578,605,606,625,634,645,663,716,718,721,722,754,757,764,803,838,862,868,884,893", -- Soothing Spices
	[3730]="180:45:7:0:10::185:0:0:", -- Big Bear Meat
	[5635]="180:45:7:0:5::171,164:0:0:", -- Sharp Claw
	[2841]="200:50:7:0:20::164,202:0:0:", -- Bronze Bar
	[1081]="200:50:7:0:10::185:0:0:", -- Crisp Spider Meat
	[8923]="200:50:7:0:10::-4:1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Essence of Agony
	[2296]="200:50:7:0:10:::0:0:", -- Great Goretusk Snout
	[3372]="200:10:7:0:20::171,-4:5:0:10,23,27,30,47,73,87,93,97,107,120,121,139,141,150,157,171,178,183,185,194,195,203,205,208,239,249,255,263,291,295,305,318,333,351,394,395,404,406,411,457,459,467,478,482,485,495,497,507,529,534,538,555,562,578,605,611,625,627,629,651,659,663,672,676,681,696,705,716,718,722,733,734,737,739,754,757,760,769,785,803,813,819,838,841,871,885,893", -- Leaded Vial
	[783]="200:50:7:0:5::165:0:0:", -- Light Hide
	[2319]="200:50:7:0:10::164,165,202,197:1:1:521", -- Medium Leather
	[3355]="200:50:7:0:20::171:1:1:30,61,414,482,521,562,584", -- Wild Steelbloom
	[7974]="200:50:7:0:10::185:0:0:", -- Zesty Clam Meat
	[3731]="220:55:7:0:10::185:0:0:", -- Lion Meat
	[2838]="240:60:7:0:20::164,202:0:0:", -- Heavy Stone
	[3859]="240:60:7:0:20::164,202:0:0:", -- Steel Bar
	[8838]="240:60:7:0:20::171,333:0:0:", -- Sungrass
	[4655]="285:71:7:0:10::185:0:0:", -- Giant Clam Meat
	[3685]="285:71:7:0:10::185:0:0:", -- Raptor Egg
	[12404]="300:75:7:0:20:::0:0:", -- Dense Sharpening Stone
	[12643]="300:75:7:0:20:::0:0:", -- Dense Weightstone
	[5637]="300:75:7:0:5::171,165,164,333:0:0:", -- Large Fang
	[3357]="300:75:7:0:20::171:1:1:30,61,414,482,521,562,584", -- Liferoot
	[5784]="300:75:7:0:10::165:0:0:", -- Slimy Murloc Scale
	[1080]="315:78:7:0:10::185:0:0:", -- Tough Condor Meat
	[1475]="330:82:7:0:5:::0:0:", -- Small Venom Sac
	[4340]="350:87:7:0:10::197,165:1:0:14,22,29,47,70,76,81,90,121,125,139,141,142,149,168,174,178,185,205,209,216,236,238,242,255,263,299,305,306,322,333,397,404,417,423,434,457,478,507,514,520,535,538,557,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Gray Dye
	[12037]="350:87:7:0:10::185:0:0:", -- Mystery Meat
	[12184]="350:87:7:0:10::185:0:0:", -- Raptor Flesh
	[12203]="350:87:7:0:10::185:0:0:", -- Red Wolf Meat
	[12202]="350:87:7:0:10::185:0:0:", -- Tiger Meat
	[3712]="350:87:7:0:10::185:0:0:", -- Turtle Meat
	[8836]="380:95:7:0:20::171:0:0:", -- Arthas' Tears
	[2997]="400:100:7:0:10::197,165:0:0:", -- Bolt of Woolen Cloth
	[13463]="400:100:7:0:20::171:1:1:521", -- Dreamfoil
	[13464]="400:100:7:0:20::171:1:1:521", -- Golden Sansam
	[3486]="400:100:7:0:20::164:0:0:", -- Heavy Grinding Stone
	[7912]="400:100:7:0:20::164,202:0:0:", -- Solid Stone
	[3820]="400:100:7:0:20::171:0:0:", -- Stranglekelp
	[8167]="400:100:7:0:20::165:0:0:", -- Turtle Scale
	[3819]="400:100:7:0:20::171,333:0:0:", -- Wintersbite
	[4231]="440:110:7:0:10::165:0:0:", -- Cured Light Hide
	[12204]="450:112:7:0:10::185:0:0:", -- Heavy Kodo Meat
	[12206]="450:112:7:0:10::185:0:0:", -- Tender Crab Meat
	[12205]="450:112:7:0:10::185:0:0:", -- White Spider Meat
	[10648]="500:125:7:0:10::202:1:0:4,64,215,225,233,335,539,572,609,623,740,742,795,806,870,879", -- Blank Parchment
	[3857]="500:125:7:0:10:::1:0:47,59,91,100,107,120,121,139,141,178,185,203,205,208,241,252,255,257,263,273,283,291,305,311,315,333,335,348,352,395,401,404,413,419,437,442,445,457,467,478,493,507,510,538,542,553,568,578,605,625,663,689,716,718,722,736,753,754,757,776,782,788,803,805,838,861,893", -- Coal
	[3818]="500:125:7:0:20::171,-4:0:0:", -- Fadeleaf
	[4232]="500:125:7:0:5::165:0:0:", -- Medium Hide
	[4291]="500:125:7:0:20::165,197:1:0:14,22,29,47,70,76,81,90,107,120,121,125,139,141,142,149,168,174,178,185,203,205,208,209,236,238,242,255,263,291,299,305,306,322,333,395,397,404,417,423,434,457,467,473,478,507,514,520,535,538,557,578,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Silken Thread
	[6338]="500:125:7:0:1::333:0:0:", -- Silver Rod
	[4341]="500:125:7:0:10::197:1:0:14,22,29,47,70,76,81,90,121,125,139,141,142,149,168,174,178,185,205,209,236,238,242,255,263,299,305,306,322,333,397,404,417,423,434,457,473,478,507,514,520,535,538,557,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Yellow Dye
	[12207]="600:150:7:0:10::185:0:0:", -- Giant Egg
	[3821]="600:150:7:0:20::171:0:0:", -- Goldthorn
	[4234]="600:150:7:0:10::165,164,202,197:1:1:521", -- Heavy Leather
	[2772]="600:150:7:0:10::333:0:0:", -- Iron Ore
	[13465]="600:150:7:0:20::171:0:0:", -- Mountain Silversage
	[4306]="600:150:7:0:20::202,129,164:0:0:", -- Silk Cloth
	[12208]="600:150:7:0:10::185:0:0:", -- Tender Wolf Meat
	[3358]="700:175:7:0:20::171:1:1:521", -- Khadgar's Whisker
	[3404]="725:181:7:0:10::185:0:0:", -- Buzzard Wing
	[1288]="740:185:7:0:5::171,129:0:0:", -- Large Venom Sac
	[4233]="800:200:7:0:10::165:0:0:", -- Cured Medium Hide
	[12644]="800:200:7:0:20::164:0:0:", -- Dense Grinding Stone
	[4235]="800:200:7:0:5::165:0:0:", -- Heavy Hide
	[3575]="800:200:7:0:20::202,164,171:0:0:", -- Iron Bar
	[7966]="800:200:7:0:20::164:0:0:", -- Solid Grinding Stone
	[10940]="800:0:7:0:10::333:1:1:250,420,421,481,519,526,540,621,771,780,793,828", -- Strange Dust
	[4461]="835:208:7:0:10::165:0:0:", -- Raptor Hide
	[4236]="900:225:7:0:10::165:0:0:", -- Cured Heavy Hide
	[2325]="1000:250:7:0:10::197,165:1:0:14,22,29,47,70,76,81,90,121,125,139,141,142,149,168,174,178,185,205,209,216,236,238,242,255,263,299,305,306,322,333,397,404,417,423,434,457,478,507,514,520,535,538,557,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Black Dye
	[8150]="1000:250:7:0:20::165:0:0:", -- Deeprock Salt
	[12365]="1000:250:7:0:20::164,202:0:0:", -- Dense Stone
	[4625]="1000:250:7:0:20::171:0:0:", -- Firebloom
	[8151]="1000:250:7:0:20::165,202:0:0:", -- Flask of Mojo
	[8846]="1000:250:7:0:20::171:0:0:", -- Gromsblood
	[13467]="1000:250:7:0:20::171,202,333:0:0:", -- Icecap
	[6042]="1000:250:7:0:5:::0:0:", -- Iron Shield Spike
	[9261]="1000:250:7:0:10:::0:0:", -- Lead Ore
	[4338]="1000:250:7:0:20::164,129,165,202,197:0:0:", -- Mageweave Cloth
	[3858]="1000:250:7:0:10::171:0:0:", -- Mithril Ore
	[6261]="1000:250:7:0:10::197:1:0:14,22,29,70,76,81,90,125,142,149,168,174,209,236,238,242,299,306,322,397,417,423,434,514,520,535,557,630,647,656,657,673,684,693,720,761,767,791,801,810,829,839,848,857,858,869,874", -- Orange Dye
	[9149]="1000:250:7:0:1:::0:0:", -- Philosophers' Stone
	[13466]="1000:250:7:0:20::171:0:0:", -- Plaguebloom
	[7428]="1000:250:7:0:5::165:0:0:", -- Shadowcat Hide
	[4402]="1000:250:7:0:5::185,171,202:0:0:", -- Small Flame Sac
	[10620]="1000:250:7:0:10::171:0:0:", -- Thorium Ore
	[8831]="1200:300:7:0:20::171:0:0:", -- Purple Lotus
	[4304]="1200:300:7:0:10::165,202,164,197:1:1:521", -- Thick Leather
	[8839]="1500:375:7:0:20::171:0:0:", -- Blindweed
	[8845]="1500:375:7:0:20::171:1:1:521", -- Ghost Mushroom
	[5060]="1500:0:7:0:1:::1:0:195,239,351,406,411,497,555,651,681,696,733,734,737,813,871", -- Thieves' Tools
	[3182]="1550:387:7:0:10::197,165:0:0:", -- Spider's Silk
	[3860]="1600:400:7:0:20::164,171,202:0:0:", -- Mithril Bar
	[14047]="1600:400:7:0:20::202,165,164,197:0:0:", -- Runecloth
	[15423]="2000:500:7:0:10::165:0:0:", -- Chimera Leather
	[15407]="2000:500:7:0:5::165:0:0:", -- Cured Rugged Hide
	[8172]="2000:500:7:0:10::165:0:0:", -- Cured Thick Hide
	[11370]="2000:500:7:0:10:::0:0:", -- Dark Iron Ore
	[15417]="2000:500:7:0:10::165:0:0:", -- Devilsaur Leather
	[12810]="2000:500:7:0:10::164,165,202,197:1:1:521", -- Enchanted Leather
	[12655]="2000:500:7:0:20::164,202:0:0:", -- Enchanted Thorium Bar
	[10647]="2000:500:7:0:10::202:1:0:4,64,215,225,233,335,539,572,609,623,740,742,795,806,870,879", -- Engineer's Ink
	[8152]="2000:500:7:0:20::165:0:0:", -- Flask of Big Mojo
	[15422]="2000:500:7:0:10::165:0:0:", -- Frostsaber Leather
	[11128]="2000:500:7:0:1::333:0:0:", -- Golden Rod
	[8343]="2000:500:7:0:20::165,197:1:0:14,22,29,47,70,76,81,90,121,125,139,141,142,149,168,174,178,185,205,209,236,238,242,255,263,299,305,306,322,333,397,404,417,423,434,457,473,478,507,514,520,535,538,557,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Heavy Silken Thread
	[6043]="2000:500:7:0:5:::0:0:", -- Iron Counterweight
	[8171]="2000:500:7:0:5::165:0:0:", -- Rugged Hide
	[8170]="2000:500:7:0:10::165,197,202,164,333:1:1:521", -- Rugged Leather
	[11130]="2000:500:7:0:1:::0:0:", -- Runed Golden Rod
	[3466]="2000:500:7:0:10::164:1:0:47,59,64,91,100,107,120,121,139,141,178,185,203,205,208,215,225,233,241,252,255,257,263,273,283,291,305,311,315,333,335,348,352,395,401,404,413,419,437,442,445,457,467,478,493,507,510,538,539,542,553,568,572,578,605,609,623,625,663,689,716,718,722,736,740,742,753,754,757,776,782,788,795,803,805,806,838,861,870,879,893", -- Strong Flux
	[8169]="2000:500:7:0:5::165:0:0:", -- Thick Hide
	[5785]="2000:500:7:0:10::165:0:0:", -- Thick Murloc Scale
	[8146]="2000:500:7:0:5::164,165:0:0:", -- Wicked Claw
	[4305]="2400:600:7:0:10::197,165:0:0:", -- Bolt of Silk Cloth
	[11371]="2400:600:7:0:20::164,202:0:0:", -- Dark Iron Bar
	[12662]="2400:600:7:0:20::164,197:0:0:", -- Demonic Rune
	[11083]="2400:0:7:0:10::333:0:0:", -- Soul Dust
	[12359]="2400:600:7:0:20::164,202,171,333:0:0:", -- Thorium Bar
	[15419]="2400:600:7:0:10::165:0:0:", -- Warbear Leather
	[8925]="2500:125:7:0:20::171,-4:5:0:10,30,47,73,87,93,97,121,139,141,150,157,171,178,183,185,194,195,205,239,249,255,263,295,305,318,333,351,394,404,406,411,457,459,478,482,485,497,507,534,538,555,562,605,611,625,627,629,651,659,663,676,681,696,705,716,718,722,733,734,737,739,754,757,760,769,785,803,813,819,838,841,871,885,893", -- Crystal Vial
	[10290]="2500:625:7:0:10::197:1:0:14,22,29,70,76,81,90,125,142,149,168,174,209,236,238,242,299,306,322,397,417,423,434,514,520,535,557,630,647,656,657,673,684,693,720,761,767,791,801,810,829,839,848,857,858,869,874", -- Pink Dye
	[4342]="2500:625:7:0:10::171,197:1:0:14,22,29,47,70,76,81,90,121,125,139,141,142,149,168,174,178,185,205,209,236,238,242,255,263,299,305,306,322,333,397,404,417,423,434,457,478,507,514,520,535,538,557,605,625,630,647,656,657,663,673,684,693,716,718,720,722,754,757,761,767,791,801,803,810,829,838,839,848,857,858,869,874,893", -- Purple Dye
	[9210]="3000:750:7:0:10::197:0:0:", -- Ghost Dye
	[4337]="3000:750:7:0:10::165,197,202:0:0:", -- Thick Spider's Silk
	[16206]="4000:1000:7:0:1::333:0:0:", -- Arcanite Rod
	[9262]="4000:1000:7:0:10::171:0:0:", -- Black Vitriol
	[17012]="4000:1000:7:0:10::165,197,164:0:0:", -- Core Leather
	[15409]="4000:1000:7:0:20::165:0:0:", -- Refined Deeprock Salt
	[10285]="4000:1000:7:0:10::202,197:0:0:", -- Shadow Silk
	[8368]="4000:1000:7:0:5::165:0:0:", -- Thick Wolfhide
	[11144]="4000:1000:7:0:1::333:0:0:", -- Truesilver Rod
	[11137]="4000:0:7:0:10::333:0:0:", -- Vision Dust
	[4339]="5000:1250:7:0:10::202,197:0:0:", -- Bolt of Mageweave
	[14341]="5000:1250:7:0:20::165,197:1:0:14,22,29,70,76,81,90,125,142,149,168,174,209,236,238,242,299,306,322,397,417,423,434,473,514,520,535,557,630,647,656,657,673,684,693,720,761,767,791,801,810,829,839,848,857,858,869,874", -- Rune Thread
	[16207]="5000:1250:7:0:1:::0:0:", -- Runed Arcanite Rod
	[11145]="5000:1250:7:0:1:::0:0:", -- Runed Truesilver Rod
	[19441]="6000:1500:7:0:5::129:0:0:", -- Huge Venom Sac
	[6041]="6000:1500:7:0:5:::0:0:", -- Steel Weapon Chain
	[14048]="8000:2000:7:0:10::197:0:0:", -- Bolt of Runecloth
	[11176]="8000:0:7:0:10::171,197,333:0:0:", -- Dream Dust
	[14256]="8000:2000:7:0:20::197,165:0:0:", -- Felcloth
	[12804]="8000:2000:7:0:20::164,165:0:0:", -- Powerful Mojo
	[14227]="10000:2500:7:0:10::202,197,165:0:0:", -- Ironweb Spider Silk
	[16204]="12000:0:7:0:10::333:0:0:", -- Illusion Dust
	[14342]="16000:4000:7:0:20::197,165:0:0:", -- Mooncloth
	[18256]="30000:1500:7:0:20::171:5:0:10,30,73,93,97,150,157,171,194,249,318,459,482,485,534,562,611,627,629,659,676,705,739,785,819,841", -- Imbued Vial
	[18567]="150000:37500:7:0:10:::1:0:91,185,241,273,311,315,348,352,401,413,437,442,493,510,568,689,736,753,782,788", -- Elemental Flux
	[18240]="0:0:7:0:20:::0:0:", -- Ogre Tannin
	[774]="60:15:7:0:20::202,164:0:0:", -- Malachite
	[15869]="200:50:7:0:20:::0:0:", -- Silver Skeleton Key
	[2775]="300:75:7:0:10::186:0:0:", -- Silver Ore
	[2842]="400:100:7:0:20::164,202:0:0:", -- Silver Bar
	[818]="400:100:7:0:20::202,164:0:0:", -- Tigerseye
	[10938]="800:0:7:0:10::333:1:1:250,420,421,481,519,526,540,621,771,780,793,828", -- Lesser Magic Essence
	[5498]="800:200:7:0:20::197,164,165:0:0:", -- Small Lustrous Pearl
	[7967]="1000:250:7:0:5:::0:0:", -- Mithril Shield Spike
	[7969]="1000:250:7:0:1:::0:0:", -- Mithril Spurs
	[1210]="1000:250:7:0:20::202,164,165,333:0:0:", -- Shadowgem
	[15870]="1200:300:7:0:20:::0:0:", -- Golden Skeleton Key
	[1206]="1600:400:7:0:20::165,164,202:0:0:", -- Moss Agate
	[2776]="2000:500:7:0:10:::0:0:", -- Gold Ore
	[12645]="2000:500:7:0:5:::0:0:", -- Thorium Shield Spike
	[7911]="2000:500:7:0:10:::0:0:", -- Truesilver Ore
	[3577]="2400:600:7:0:20::164,197:0:0:", -- Gold Bar
	[10939]="2400:0:7:0:10::333:0:0:", -- Greater Magic Essence
	[1705]="2400:600:7:0:20::164,202:0:0:", -- Lesser Moonstone
	[15872]="2500:625:7:0:20:::0:0:", -- Arcanite Skeleton Key
	[15871]="2500:625:7:0:20:::0:0:", -- Truesilver Skeleton Key
	[1529]="2800:700:7:0:20::164,202,165,197:0:0:", -- Jade
	[11382]="3000:750:7:0:20::333,164:0:0:", -- Blood of the Mountain
	[5500]="3000:750:7:0:20::164,165,197,333:0:0:", -- Iridescent Pearl
	[10998]="3000:0:7:0:10::333:0:0:", -- Lesser Astral Essence
	[3864]="3200:800:7:0:20::164,202,165,197:0:0:", -- Citrine
	[7909]="4000:1000:7:0:20::202,164,333:0:0:", -- Aquamarine
	[13468]="4000:1000:7:0:20::171:0:0:", -- Black Lotus
	[7971]="4000:1000:7:0:20::165,164,333:0:0:", -- Black Pearl
	[18262]="5000:1250:7:0:20:::0:0:", -- Elemental Sharpening Stone
	[6037]="5000:1250:7:0:20::202,164,197,333:0:0:", -- Truesilver Bar
	[12363]="8000:2000:7:0:20::171:0:0:", -- Arcane Crystal
	[11082]="9000:0:7:0:10::333:0:0:", -- Greater Astral Essence
	[11134]="10000:0:7:0:10::333:0:0:", -- Lesser Mystic Essence
	[12360]="20000:5000:7:0:20::202,164,197:0:0:", -- Arcanite Bar
	[11174]="20000:0:7:0:10::333:0:0:", -- Lesser Nether Essence
	[7910]="20000:5000:7:0:20::202,164,197:0:0:", -- Star Ruby
	[12361]="28000:7000:7:0:20::164,202:0:0:", -- Blue Sapphire
	[12799]="28000:7000:7:0:20::164,202:0:0:", -- Large Opal
	[11135]="30000:0:7:0:10::333:0:0:", -- Greater Mystic Essence
	[12800]="40000:10000:7:0:20::164,202,197:0:0:", -- Azerothian Diamond
	[13926]="40000:10000:7:0:20::333,197:0:0:", -- Golden Pearl
	[12809]="40000:10000:7:0:20::164,165,197:0:0:", -- Guardian Stone
	[12364]="40000:10000:7:0:20::164,202,197:0:0:", -- Huge Emerald
	[16202]="40000:0:7:0:10::333:0:0:", -- Lesser Eternal Essence
	[11175]="60000:0:7:0:10::333:0:0:", -- Greater Nether Essence
	[12811]="80000:20000:7:0:20::164,197,165,333:0:0:", -- Righteous Orb
	[16203]="120000:0:7:0:10::333:0:0:", -- Greater Eternal Essence
	[10978]="4000:0:7:0:10::333:0:0:", -- Small Glimmering Shard
	[11084]="6000:0:7:0:10::333:0:0:", -- Large Glimmering Shard
	[11138]="8000:0:7:0:10::333:0:0:", -- Small Glowing Shard
	[11139]="12000:0:7:0:10::333:0:0:", -- Large Glowing Shard
	[15410]="20000:5000:7:0:20:::0:0:", -- Scale of Onyxia
	[11177]="24000:0:7:0:10::333:0:0:", -- Small Radiant Shard
	[9719]="25000:6250:7:0:1:::0:0:", -- Broken Blade of Heroes
	[14344]="36000:0:7:0:10::333,197:0:0:", -- Large Brilliant Shard
	[11178]="36000:0:7:0:10::333:0:0:", -- Large Radiant Shard
	[14343]="36000:0:7:0:10::333:0:0:", -- Small Brilliant Shard
	[13503]="100000:25000:7:0:1:::0:0:", -- Alchemists' Stone
	[17203]="400000:100000:7:0:20::164:0:0:", -- Sulfuron Ingot
	[17771]="400000:100000:7:0:10:::0:0:", -- Elementium Bar
	[7191]="0:0:7:1:1::202:0:0:", -- Fused Wiring
	[4357]="16:4:7:1:20:::1:1:64,187,215,225,233,335,539,572,609,623,740,742,786,795,806,870,879", -- Rough Blasting Powder
	[4364]="48:12:7:1:20::202:1:1:64,187,215,225,233,335,539,572,609,623,740,742,786,795,806,870,879", -- Coarse Blasting Powder
	[4359]="50:12:7:1:10::202:0:0:", -- Handful of Copper Bolts
	[10498]="81:16:7:1:1:::0:0:", -- Gyromatic Micro-Adjustor
	[4404]="100:25:7:1:20:::1:1:64,187,215,225,233,335,539,572,609,623,740,742,795,806,870,879", -- Silver Contact
	[4363]="200:50:7:1:10::202:1:1:64,215,225,233,335,539,572,609,623,740,795,806,870,879", -- Copper Modulator
	[4399]="200:50:7:1:10::202:1:0:47,64,107,120,121,139,141,178,203,205,208,215,225,233,255,263,291,305,333,335,395,404,457,467,478,507,538,539,572,578,605,609,623,625,663,716,718,722,740,742,754,757,795,803,806,838,870,879,893", -- Wooden Stock
	[4375]="460:115:7:1:10::202:0:0:", -- Whirring Bronze Gizmo
	[4361]="480:120:7:1:10::202:1:1:64,215,225,233,335,539,572,609,623,740,742,795,806,870,879", -- Copper Tube
	[4377]="600:150:7:1:20::202:0:0:", -- Heavy Blasting Powder
	[4371]="800:200:7:1:10::202:1:1:64,187,215,225,233,335,539,572,609,623,740,786,795,806,870,879", -- Bronze Tube
	[15992]="1000:250:7:1:20::202:0:0:", -- Dense Blasting Powder
	[10558]="1000:250:7:1:20::202:0:0:", -- Gold Power Core
	[10505]="1000:250:7:1:20::202:0:0:", -- Solid Blasting Powder
	[4387]="1600:400:7:1:10::202:0:0:", -- Iron Strut
	[4400]="2000:500:7:1:10::202:1:0:47,64,107,120,121,139,141,178,203,205,208,215,225,233,255,263,291,305,333,335,395,404,457,467,478,507,538,539,572,578,605,609,623,625,663,716,718,722,740,742,754,757,795,803,806,838,870,879,893", -- Heavy Stock
	[4382]="2400:600:7:1:10::202:1:1:64,215,225,233,335,539,572,609,623,740,742,786,795,806,870,879", -- Bronze Framework
	[4389]="3000:750:7:1:10::202:1:1:64,187,215,225,233,335,539,572,609,623,740,742,795,806,870,879", -- Gyrochronatom
	[10559]="3000:750:7:1:10::202:0:0:", -- Mithril Tube
	[10561]="4000:1000:7:1:10::202:0:0:", -- Mithril Casing
	[10560]="4000:1000:7:1:10::202:0:0:", -- Unstable Trigger
	[15994]="10000:2500:7:1:10::202:0:0:", -- Thorium Widget
	[18631]="12000:3000:7:1:10::202:0:0:", -- Truesilver Transformer
	[16000]="15000:3750:7:1:10::202:0:0:", -- Thorium Tube
	[16006]="40000:10000:7:1:10::202:0:0:", -- Delicate Arcanite Converter
	[4358]="120:30:7:2:20:::0:0:", -- Rough Dynamite
	[4360]="240:60:7:2:10:::0:0:", -- Rough Copper Bomb
	[4365]="300:75:7:2:20:::0:0:", -- Coarse Dynamite
	[6714]="300:75:7:2:20:::0:0:", -- Ez-Thro Dynamite
	[4367]="600:150:7:2:10:::0:0:", -- Small Seaforium Charge
	[4370]="700:175:7:2:10:::0:0:", -- Large Copper Bomb
	[18588]="800:200:7:2:20:::0:0:", -- Ez-Thro Dynamite II
	[4374]="800:200:7:2:10:::0:0:", -- Small Bronze Bomb
	[4852]="1200:300:7:2:5:::0:0:", -- Flash Bomb
	[4378]="1400:350:7:2:20:::1:1:148", -- Heavy Dynamite
	[10507]="1400:350:7:2:20:::0:0:", -- Solid Dynamite
	[4380]="2000:500:7:2:10:::0:0:", -- Big Bronze Bomb
	[18641]="2000:500:7:2:20:::0:0:", -- Dense Dynamite
	[10646]="2000:500:7:2:10:::0:0:", -- Goblin Sapper Charge
	[4390]="2000:500:7:2:10:::0:0:", -- Iron Grenade
	[4394]="3000:750:7:2:10::202:0:0:", -- Big Iron Bomb
	[10562]="3000:750:7:2:10:::0:0:", -- Hi-Explosive Bomb
	[10514]="3000:750:7:2:10:::0:0:", -- Mithril Frag Bomb
	[10586]="3000:750:7:2:10:::0:0:", -- The Big One
	[4398]="3600:900:7:2:10:::0:0:", -- Large Seaforium Charge
	[4384]="4000:1000:7:2:5:::0:0:", -- Explosive Sheep
	[16005]="5000:1250:7:2:10:::0:0:", -- Dark Iron Bomb
	[15993]="6000:1500:7:2:10:::0:0:", -- Thorium Grenade
	[4395]="6400:1600:7:2:10:::0:0:", -- Goblin Land Mine
	[18594]="12000:3000:7:2:10:::0:0:", -- Powerful Seaforium Charge
	[16040]="16000:4000:7:2:10:::0:0:", -- Arcane Bomb
	[7148]="85:21:7:3:1:::0:0:", -- Goblin Jumper Cables
	[6715]="85:21:7:3:1:::0:0:", -- Ruined Jumper Cables
	[6533]="250:62:7:3:20:Lure::1:1:113,162,277,319,323,326,451,468,475,528,541,552,567,626,638,702,711,717,752,763,833,840,852,881,889", -- Aquadynamic Fish Attractor
	[4366]="300:75:7:3:10:::0:0:", -- Target Dummy
	[4401]="400:100:7:3:1:::0:0:", -- Mechanical Squirrel Box
	[18636]="400:100:7:3:1:::0:0:", -- Ruined Jumper Cables XL
	[4405]="500:125:7:3:5:::0:0:", -- Crude Scope
	[4386]="700:175:7:3:1:::0:0:", -- Ice Deflector
	[4376]="800:200:7:3:1:::0:0:", -- Flame Deflector
	[11590]="1000:250:7:3:5:::0:0:", -- Mechanical Repair Kit
	[5507]="2400:600:7:3:1:::0:0:", -- Ornate Spyglass
	[4406]="2400:600:7:3:5:::0:0:", -- Standard Scope
	[10645]="3000:750:7:3:1:::0:0:", -- Gnomish Death Ray
	[10720]="3000:750:7:3:1:::0:0:", -- Gnomish Net-o-Matic Projector
	[10716]="3000:750:7:3:1:::0:0:", -- Gnomish Shrink Ray
	[4388]="4000:1000:7:3:1:::0:0:", -- Discombobulator Ray
	[4407]="4800:1200:7:3:5::202:0:0:", -- Accurate Scope
	[18645]="6000:1500:7:3:1:::0:0:", -- Alarm-O-Bot
	[10546]="6000:1500:7:3:5::202:0:0:", -- Deadly Scope
	[10725]="6000:1500:7:3:1:::0:0:", -- Gnomish Battle Chicken
	[10587]="6000:1500:7:3:1:::0:0:", -- Goblin Bomb Dispenser
	[10727]="8000:2000:7:3:1:::0:0:", -- Goblin Dragon Gun
	[18587]="8000:2000:7:3:1:::0:0:", -- Goblin Jumper Cables XL
	[10577]="8000:2000:7:3:1:::0:0:", -- Goblin Mortar
	[4403]="8000:2000:7:3:1:::0:0:", -- Portable Bronze Mortar
	[4392]="10000:2500:7:3:10:::0:0:", -- Advanced Target Dummy
	[15996]="10000:2500:7:3:1:::0:0:", -- Lifelike Mechanical Toad
	[11826]="10000:2500:7:3:1:::0:0:", -- Lil' Smoky
	[11825]="10000:2500:7:3:1:::0:0:", -- Pet Bombling
	[10548]="10000:2500:7:3:5:::0:0:", -- Sniper Scope
	[4391]="16000:4000:7:3:5:::0:0:", -- Compact Harvest Reaper Kit
	[4397]="20000:5000:7:3:1:::0:0:", -- Gnomish Cloaking Device
	[4396]="24000:6000:7:3:1:::0:0:", -- Mechanical Dragonling
	[10576]="24000:6000:7:3:1::202:0:0:", -- Mithril Mechanical Dragonling
	[15846]="30000:7500:7:3:1:::0:0:", -- Salt Shaker
	[17716]="30000:7500:7:3:1:::0:0:", -- SnowMaster 9000
	[18232]="40000:10000:7:3:1:::0:0:", -- Field Repair Bot 74A
	[16023]="40000:10000:7:3:10:::0:0:", -- Masterwork Target Dummy
	[7506]="2000:500:7:3:1:::0:0:", -- Gnomish Universal Remote
	[18637]="2400:600:7:3:1:::0:0:", -- Major Recombobulator
	[4381]="2400:600:7:3:1:::0:0:", -- Minor Recombobulator
	[18660]="30000:7500:7:3:1:::0:0:", -- World Enlarger
	[18634]="50000:12500:7:3:1:::0:0:", -- Gyrofreeze Ice Reflector
	[18638]="50000:12500:7:3:1:::0:0:", -- Hyper-Radiant Flame Reflector
	[18639]="50000:12500:7:3:1:::0:0:", -- Ultra-Flash Shadow Reflector
	[16022]="160000:40000:7:3:1:::0:0:", -- Arcanite Dragonling
	[8046]="0:0:9:0:1:::0:0:", -- Kearnen's Journal
	[16321]="100:25:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Blood Pact (Rank 1)
	[16302]="100:25:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Firebolt (Rank 2)
	[16331]="600:150:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Phase Shift
	[16322]="900:225:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Blood Pact (Rank 2)
	[16326]="900:225:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Fire Shield (Rank 1)
	[16351]="1200:300:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 1)
	[16357]="1500:375:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 1)
	[16316]="1500:375:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Firebolt (Rank 3)
	[16346]="2000:500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Torment (Rank 2)
	[16375]="2500:625:9:0:1:::1:0:275,432,498,741", -- Grimoire of Soothing Kiss (Rank 1)
	[16327]="3000:750:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Fire Shield (Rank 2)
	[16352]="3000:750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 2)
	[16363]="3000:750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Suffering (Rank 1)
	[16323]="4000:1000:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Blood Pact (Rank 3)
	[16358]="4000:1000:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 2)
	[16379]="4000:1000:9:0:1:::1:0:275,432,498,741", -- Grimoire of Seduction
	[16317]="5000:1250:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Firebolt (Rank 4)
	[16368]="5000:1250:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lash of Pain (Rank 2)
	[16347]="6000:1500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Torment (Rank 3)
	[16380]="7000:1750:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lesser Invisibility
	[16353]="7000:1750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 3)
	[16384]="7000:1750:9:0:1:::1:0:275,432,498,741", -- Grimoire of Tainted Blood (Rank 1)
	[16359]="8000:2000:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 3)
	[16328]="8000:2000:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Fire Shield (Rank 3)
	[16376]="8000:2000:9:0:1:::1:0:275,432,498,741", -- Grimoire of Soothing Kiss (Rank 2)
	[16371]="9000:2250:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lash of Pain (Rank 3)
	[16388]="9000:2250:9:0:1:::1:0:275,432,498,741", -- Grimoire of Spell Lock (Rank 1)
	[16364]="9000:2250:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Suffering (Rank 2)
	[16324]="10000:2500:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Blood Pact (Rank 4)
	[16381]="10000:2500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Devour Magic (Rank 2)
	[16318]="10000:2500:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Firebolt (Rank 5)
	[16360]="11000:2750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 4)
	[16390]="11000:2750:9:0:1:::1:0:275,432,498,741", -- Grimoire of Paranoia
	[16354]="11000:2750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 4)
	[16385]="11000:2750:9:0:1:::1:0:275,432,498,741", -- Grimoire of Tainted Blood (Rank 2)
	[16348]="11000:2750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Torment (Rank 4)
	[16329]="12000:3000:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Fire Shield (Rank 4)
	[16372]="12000:3000:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lash of Pain (Rank 4)
	[16382]="13000:3250:9:0:1:::1:0:275,432,498,741", -- Grimoire of Devour Magic (Rank 3)
	[16377]="13000:3250:9:0:1:::1:0:275,432,498,741", -- Grimoire of Soothing Kiss (Rank 3)
	[16319]="14000:3500:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,822,859", -- Grimoire of Firebolt (Rank 6)
	[16355]="14000:3500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 5)
	[16365]="14000:3500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Suffering (Rank 3)
	[16386]="14000:3500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Tainted Blood (Rank 3)
	[16325]="15000:3750:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Blood Pact (Rank 5)
	[16361]="15000:3750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 5)
	[16349]="15000:3750:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Torment (Rank 5)
	[16373]="18000:4500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lash of Pain (Rank 5)
	[16389]="18000:4500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Spell Lock (Rank 2)
	[16383]="20000:5000:9:0:1:::1:0:275,432,498,741", -- Grimoire of Devour Magic (Rank 4)
	[16330]="20000:5000:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Fire Shield (Rank 5)
	[16356]="22000:5500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Sacrifice (Rank 6)
	[16387]="22000:5500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Tainted Blood (Rank 4)
	[16362]="24000:6000:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Consume Shadows (Rank 6)
	[16320]="24000:6000:9:0:1:::1:0:135,140,144,245,275,349,432,453,480,498,741,859", -- Grimoire of Firebolt (Rank 7)
	[16378]="24000:6000:9:0:1:::1:0:275,432,498,741", -- Grimoire of Soothing Kiss (Rank 4)
	[16374]="26000:6500:9:0:1:::1:0:275,432,498,741", -- Grimoire of Lash of Pain (Rank 6)
	[16366]="26000:6500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Suffering (Rank 4)
	[16350]="26000:6500:9:0:1:::1:0:135,144,245,275,432,480,498,741", -- Grimoire of Torment (Rank 6)
	[11733]="0:0:9:0:1:::0:0:", -- Libram of Constitution
	[18333]="0:0:9:0:1:::0:0:", -- Libram of Focus
	[18334]="0:0:9:0:1:::0:0:", -- Libram of Protection
	[18332]="0:0:9:0:1:::0:0:", -- Libram of Rapidity
	[11736]="0:0:9:0:1:::0:0:", -- Libram of Resilience
	[11732]="0:0:9:0:1:::0:0:", -- Libram of Rumination
	[11734]="0:0:9:0:1:::0:0:", -- Libram of Tenacity
	[11737]="0:0:9:0:1:::0:0:", -- Libram of Voracity
	[16665]="0:0:9:0:1:::0:0:", -- Tome of Tranquilizing Shot
	[4213]="10000:2500:9:0:1:::0:0:", -- Grimoire of Doom
	[9214]="10000:2500:9:0:1:::0:0:", -- Grimoire of Inferno
	[17413]="31000:7750:9:0:1:::0:0:", -- Codex: Prayer of Fortitude
	[17682]="35000:8750:9:0:1:::0:0:", -- Book: Gift of the Wild
	[18600]="48000:12000:9:0:1:::0:0:", -- Tome of Arcane Brilliance
	[17683]="59000:14750:9:0:1:::0:0:", -- Book: Gift of the Wild II
	[17414]="59000:14750:9:0:1:::0:0:", -- Codex: Prayer of Fortitude II
	[6474]="550:137:9:1:1:::0:0:", -- Pattern: Deviate Scale Cloak
	[5786]="550:137:9:1:1:::1:1:27,246,426,569,579,854", -- Pattern: Murloc Scale Belt
	[5787]="600:150:9:1:1:::1:1:27,246,569,579,854", -- Pattern: Murloc Scale Breastplate
	[5973]="650:162:9:1:1:::1:1:263,305,395,457,514,837", -- Pattern: Barbaric Leggings
	[7289]="650:162:9:1:1:::1:1:125", -- Pattern: Black Whelp Cloak
	[6475]="1500:375:9:1:1:::0:0:", -- Pattern: Deviate Scale Gloves
	[7290]="1600:400:9:1:1:::1:1:847", -- Pattern: Red Whelp Gloves
	[18949]="2000:500:9:1:1:::0:0:", -- Pattern: Barbaric Bracers
	[7362]="2000:500:9:1:1:::1:1:648,888", -- Pattern: Earthen Leather Shoulders
	[7613]="2000:500:9:1:1:::1:1:236,847", -- Pattern: Green Leather Armor
	[18731]="2000:500:9:1:1:::1:1:76,209,761,791", -- Pattern: Heavy Leather Ball
	[14635]="3000:750:9:1:1:::1:1:684", -- Pattern: Gem-studded Leather Belt
	[18239]="3500:875:9:1:1:::1:1:684", -- Pattern: Shadowskin Gloves
	[8385]="3500:875:9:1:1:::1:1:397,657", -- Pattern: Turtle Scale Gloves
	[15729]="12000:3000:9:1:1:::0:0:", -- Pattern: Chimeric Gloves
	[15726]="12000:3000:9:1:1:::0:0:", -- Pattern: Green Dragonscale Breastplate
	[15724]="12000:3000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Bracers
	[15725]="12000:3000:9:1:1:::1:1:520,848", -- Pattern: Wicked Leather Gauntlets
	[15735]="14000:3500:9:1:1:::0:0:", -- Pattern: Ironfeather Shoulders
	[15734]="14000:3500:9:1:1:::1:1:397,657", -- Pattern: Living Shoulders
	[15740]="16000:4000:9:1:1:::1:1:663", -- Pattern: Frostsaber Boots
	[15741]="16000:4000:9:1:1:::1:1:520,848", -- Pattern: Stormshroud Pants
	[15742]="16000:4000:9:1:1:::0:0:", -- Pattern: Warbear Harness
	[15751]="20000:5000:9:1:1:::0:0:", -- Pattern: Blue Dragonscale Breastplate
	[15754]="20000:5000:9:1:1:::0:0:", -- Pattern: Warbear Woolies
	[15759]="22000:5500:9:1:1:::0:0:", -- Pattern: Black Dragonscale Breastplate
	[19328]="22000:5500:9:1:1:::1:0:39,40,668", -- Pattern: Dawn Treaders
	[15758]="22000:5500:9:1:1:::0:0:", -- Pattern: Devilsaur Gauntlets
	[15756]="22000:5500:9:1:1:::1:1:38,404", -- Pattern: Runic Leather Headband
	[15762]="25000:6250:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Helm
	[19329]="40000:10000:9:1:1:::1:0:39,40,668", -- Pattern: Golden Mantle of the Dawn
	[17022]="150000:37500:9:1:1:::1:1:536", -- Pattern: Corehound Boots
	[17025]="160000:40000:9:1:1:::1:1:536", -- Pattern: Black Dragonscale Boots
	[17023]="160000:40000:9:1:1:::1:1:536", -- Pattern: Molten Helm
	[2406]="100:25:9:1:1:::0:0:", -- Pattern: Fine Leather Boots
	[5083]="200:50:9:1:1:::0:0:", -- Pattern: Kodo Hide Bag
	[2408]="500:125:9:1:1:::0:0:", -- Pattern: Fine Leather Gloves
	[7288]="500:125:9:1:1:::0:0:", -- Pattern: Rugged Leather Pants
	[6710]="550:137:9:1:1:::0:0:", -- Pattern: Moonglow Vest
	[4293]="650:162:9:1:1:::0:0:", -- Pattern: Hillman's Leather Vest
	[5788]="650:162:9:1:1:::1:1:70,120,578,664", -- Pattern: Thick Murloc Armor
	[2407]="650:162:9:1:1:::0:0:", -- Pattern: White Leather Jerkin
	[2409]="1400:350:9:1:1:::0:0:", -- Pattern: Dark Leather Tunic
	[5974]="1400:350:9:1:1:::0:0:", -- Pattern: Guardian Cloak
	[5972]="1500:375:9:1:1:::0:0:", -- Pattern: Fine Leather Pants
	[7360]="1600:400:9:1:1:::0:0:", -- Pattern: Dark Leather Gloves
	[4294]="1600:400:9:1:1:::0:0:", -- Pattern: Hillman's Belt
	[7361]="1800:450:9:1:1:::1:1:322", -- Pattern: Herbalist's Gloves
	[4297]="2000:500:9:1:1:::0:0:", -- Pattern: Barbaric Gloves
	[6476]="2000:500:9:1:1:::0:0:", -- Pattern: Deviate Scale Belt
	[7450]="2000:500:9:1:1:::0:0:", -- Pattern: Green Whelp Armor
	[4299]="2000:500:9:1:1:::0:0:", -- Pattern: Guardian Armor
	[4296]="2100:525:9:1:1:::0:0:", -- Pattern: Dark Leather Shoulders
	[7363]="2100:525:9:1:1:::0:0:", -- Pattern: Pilferer's Gloves
	[7364]="2200:550:9:1:1:::0:0:", -- Pattern: Heavy Earthen Gloves
	[7449]="2500:625:9:1:1:::0:0:", -- Pattern: Dusky Leather Leggings
	[13288]="2500:625:9:1:1:::1:1:29", -- Pattern: Raptor Hide Belt
	[13287]="2500:625:9:1:1:::1:1:810", -- Pattern: Raptor Hide Harness
	[17722]="2800:700:9:1:1:::0:0:", -- Pattern: Gloves of the Greatfather
	[7451]="2800:700:9:1:1:::1:1:397,657,693", -- Pattern: Green Whelp Bracers
	[4300]="2800:700:9:1:1:::0:0:", -- Pattern: Guardian Leather Bracers
	[5789]="2800:700:9:1:1:::1:1:70,333,664", -- Pattern: Murloc Scale Bracers
	[7453]="3500:875:9:1:1:::0:0:", -- Pattern: Swift Boots
	[8387]="4000:1000:9:1:1:::0:0:", -- Pattern: Big Voodoo Mask
	[8386]="4000:1000:9:1:1:::0:0:", -- Pattern: Big Voodoo Robe
	[8409]="4000:1000:9:1:1:::1:1:168,397,630,857", -- Pattern: Nightscape Shoulders
	[8397]="4000:1000:9:1:1:::0:0:", -- Pattern: Tough Scorpid Bracers
	[8395]="4000:1000:9:1:1:::0:0:", -- Pattern: Tough Scorpid Breastplate
	[8405]="4000:1000:9:1:1:::0:0:", -- Pattern: Wild Leather Helmet
	[8403]="4000:1000:9:1:1:::0:0:", -- Pattern: Wild Leather Shoulders
	[8404]="4000:1000:9:1:1:::0:0:", -- Pattern: Wild Leather Vest
	[8398]="4500:1125:9:1:1:::0:0:", -- Pattern: Tough Scorpid Gloves
	[8390]="5000:1250:9:1:1:::0:0:", -- Pattern: Big Voodoo Cloak
	[8389]="5000:1250:9:1:1:::0:0:", -- Pattern: Big Voodoo Pants
	[8399]="5000:1250:9:1:1:::0:0:", -- Pattern: Tough Scorpid Boots
	[8400]="5000:1250:9:1:1:::0:0:", -- Pattern: Tough Scorpid Shoulders
	[8406]="5000:1250:9:1:1:::0:0:", -- Pattern: Wild Leather Boots
	[8408]="5000:1250:9:1:1:::0:0:", -- Pattern: Wild Leather Cloak
	[8407]="5000:1250:9:1:1:::0:0:", -- Pattern: Wild Leather Leggings
	[8402]="5500:1375:9:1:1:::0:0:", -- Pattern: Tough Scorpid Helm
	[8401]="5500:1375:9:1:1:::0:0:", -- Pattern: Tough Scorpid Leggings
	[15727]="12000:3000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Vest
	[15728]="12000:3000:9:1:1:::0:0:", -- Pattern: Wicked Leather Bracers
	[15731]="14000:3500:9:1:1:::0:0:", -- Pattern: Runic Leather Gauntlets
	[15732]="14000:3500:9:1:1:::0:0:", -- Pattern: Volcanic Leggings
	[15737]="16000:4000:9:1:1:::0:0:", -- Pattern: Chimeric Boots
	[15738]="16000:4000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Gauntlets
	[15739]="16000:4000:9:1:1:::0:0:", -- Pattern: Runic Leather Bracers
	[15746]="20000:5000:9:1:1:::0:0:", -- Pattern: Chimeric Leggings
	[15747]="20000:5000:9:1:1:::0:0:", -- Pattern: Frostsaber Leggings
	[15743]="20000:5000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Belt
	[15748]="20000:5000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Leggings
	[15745]="20000:5000:9:1:1:::0:0:", -- Pattern: Runic Leather Belt
	[15749]="20000:5000:9:1:1:::0:0:", -- Pattern: Volcanic Breastplate
	[15744]="20000:5000:9:1:1:::0:0:", -- Pattern: Wicked Leather Headband
	[15755]="22000:5500:9:1:1:::0:0:", -- Pattern: Chimeric Vest
	[15757]="22000:5500:9:1:1:::0:0:", -- Pattern: Wicked Leather Pants
	[15761]="25000:6250:9:1:1:::0:0:", -- Pattern: Frostsaber Gloves
	[15765]="30000:7500:9:1:1:::0:0:", -- Pattern: Runic Leather Pants
	[15768]="30000:7500:9:1:1:::0:0:", -- Pattern: Wicked Leather Belt
	[15774]="40000:10000:9:1:1:::0:0:", -- Pattern: Heavy Scorpid Shoulders
	[15776]="40000:10000:9:1:1:::0:0:", -- Pattern: Runic Leather Armor
	[15775]="40000:10000:9:1:1:::0:0:", -- Pattern: Volcanic Shoulders
	[15773]="40000:10000:9:1:1:::0:0:", -- Pattern: Wicked Leather Armor
	[15779]="60000:15000:9:1:1:::0:0:", -- Pattern: Frostsaber Tunic
	[15777]="60000:15000:9:1:1:::0:0:", -- Pattern: Runic Leather Shoulders
	[4298]="650:162:9:1:1:::0:0:", -- Pattern: Guardian Belt
	[4301]="3500:875:9:1:1:::0:0:", -- Pattern: Barbaric Belt
	[8384]="3500:875:9:1:1:::0:0:", -- Pattern: Comfortable Leather Hat
	[7452]="3500:875:9:1:1:::0:0:", -- Pattern: Dusky Boots
	[15730]="12000:3000:9:1:1:::0:0:", -- Pattern: Red Dragonscale Breastplate
	[15733]="14000:3500:9:1:1:::0:0:", -- Pattern: Green Dragonscale Leggings
	[15752]="20000:5000:9:1:1:::0:0:", -- Pattern: Living Leggings
	[15753]="20000:5000:9:1:1:::0:0:", -- Pattern: Stormshroud Armor
	[15760]="22000:5500:9:1:1:::0:0:", -- Pattern: Ironfeather Breastplate
	[15763]="25000:6250:9:1:1:::0:0:", -- Pattern: Blue Dragonscale Shoulders
	[15764]="25000:6250:9:1:1:::0:0:", -- Pattern: Stormshroud Shoulders
	[15770]="30000:7500:9:1:1:::0:0:", -- Pattern: Black Dragonscale Shoulders
	[15772]="30000:7500:9:1:1:::0:0:", -- Pattern: Devilsaur Leggings
	[15771]="30000:7500:9:1:1:::0:0:", -- Pattern: Living Breastplate
	[15781]="60000:15000:9:1:1:::0:0:", -- Pattern: Black Dragonscale Leggings
	[18514]="60000:15000:9:1:1:::0:0:", -- Pattern: Girdle of Insight
	[18515]="60000:15000:9:1:1:::0:0:", -- Pattern: Mongoose Boots
	[18516]="60000:15000:9:1:1:::0:0:", -- Pattern: Swift Flight Bracers
	[18517]="160000:40000:9:1:1:::0:0:", -- Pattern: Chromatic Cloak
	[18518]="160000:40000:9:1:1:::0:0:", -- Pattern: Hide of the Wild
	[18519]="160000:40000:9:1:1:::0:0:", -- Pattern: Shifting Cloak
	[6270]="200:50:9:2:1:::1:1:81,82,127,282,473,677,713,775,801,829,858", -- Pattern: Blue Linen Vest
	[5771]="200:50:9:2:1:::1:1:27,246,282,426,551,579,713,829,854", -- Pattern: Red Linen Bag
	[6272]="300:75:9:2:1:::1:1:27,167,189,412,473,672,858", -- Pattern: Blue Linen Robe
	[6274]="400:100:9:2:1:::1:1:14,81,238,246,405,517,557,677,767,801,854,874", -- Pattern: Blue Overalls
	[5772]="500:125:9:2:1:::1:1:23,81,282,417,472,473,529,551,582,648,673,677,713,829,858,874,888", -- Pattern: Red Woolen Bag
	[14627]="800:200:9:2:1:::1:1:142,720", -- Pattern: Bright Yellow Shirt
	[6275]="800:200:9:2:1:::1:1:142,189,412,417,582,672,673,720", -- Pattern: Greater Adept's Robe
	[7114]="1000:250:9:2:1:::1:1:478,847", -- Pattern: Azure Silk Gloves
	[14630]="1000:250:9:2:1:::1:1:869", -- Pattern: Enchanter's Cowl
	[6401]="1100:275:9:2:1:::1:1:405,557,720,767", -- Pattern: Dark Silk Shirt
	[7087]="1200:300:9:2:1:::1:1:869", -- Pattern: Crimson Silk Cloak
	[7089]="1500:375:9:2:1:::1:1:90,434", -- Pattern: Azure Silk Cloak
	[10728]="1500:375:9:2:1:::1:1:463,618", -- Pattern: Black Swashbuckler's Shirt
	[17724]="1500:375:9:2:1:::0:0:", -- Pattern: Green Holiday Shirt
	[4355]="1500:375:9:2:1:::1:1:242,578", -- Pattern: Icy Cloak
	[10311]="3000:750:9:2:1:::1:1:189,551", -- Pattern: Orange Martial Shirt
	[10314]="4000:1000:9:2:1:::1:1:81,647,677,801", -- Pattern: Lavender Mageweave Shirt
	[10317]="4000:1000:9:2:1:::1:1:81,647,677", -- Pattern: Pink Mageweave Shirt
	[10323]="4500:1125:9:2:1:::1:1:582,647", -- Pattern: Tuxedo Pants
	[10321]="4500:1125:9:2:1:::1:1:582,647", -- Pattern: Tuxedo Shirt
	[7088]="5000:1250:9:2:1:::1:1:839", -- Pattern: Crimson Silk Robe
	[10326]="5000:1250:9:2:1:::1:1:582,647", -- Pattern: Tuxedo Jacket
	[10318]="7000:1750:9:2:1:::0:0:", -- Pattern: Admiral's Hat
	[10325]="10000:2500:9:2:1:::1:1:14,238,517,551", -- Pattern: White Wedding Dress
	[14468]="12000:3000:9:2:1:::1:1:663", -- Pattern: Runecloth Bag
	[14472]="12000:3000:9:2:1:::1:1:149", -- Pattern: Runecloth Cloak
	[14469]="12000:3000:9:2:1:::1:1:149", -- Pattern: Runecloth Robe
	[14483]="16000:4000:9:2:1:::1:1:538", -- Pattern: Felcloth Pants
	[14481]="16000:4000:9:2:1:::1:1:663", -- Pattern: Runecloth Gloves
	[14526]="20000:5000:9:2:1:::1:0:194,663", -- Pattern: Mooncloth
	[19216]="22000:5500:9:2:1:::1:0:39,40,668", -- Pattern: Argent Boots
	[19217]="40000:10000:9:2:1:::1:0:39,40,668", -- Pattern: Argent Shoulders
	[17018]="80000:20000:9:2:1:::1:1:536", -- Pattern: Flarecore Gloves
	[17017]="180000:45000:9:2:1:::1:1:536", -- Pattern: Flarecore Mantle
	[2598]="120:30:9:2:1:::0:0:", -- Pattern: Red Linen Robe
	[6271]="200:50:9:2:1:::0:0:", -- Pattern: Red Linen Vest
	[2601]="400:100:9:2:1:::0:0:", -- Pattern: Gray Woolen Robe
	[4346]="400:100:9:2:1:::0:0:", -- Pattern: Heavy Woolen Cloak
	[4345]="400:100:9:2:1:::0:0:", -- Pattern: Red Woolen Boots
	[4347]="600:150:9:2:1:::0:0:", -- Pattern: Reinforced Woolen Shoulders
	[6390]="600:150:9:2:1:::0:0:", -- Pattern: Stylish Blue Shirt
	[6391]="600:150:9:2:1:::0:0:", -- Pattern: Stylish Green Shirt
	[4348]="700:175:9:2:1:::0:0:", -- Pattern: Phoenix Gloves
	[4349]="700:175:9:2:1:::0:0:", -- Pattern: Phoenix Pants
	[10316]="800:200:9:2:1:::0:0:", -- Pattern: Colorful Kilt
	[4292]="800:200:9:2:1:::0:0:", -- Pattern: Green Woolen Bag
	[4350]="800:200:9:2:1:::0:0:", -- Pattern: Spider Silk Slippers
	[4351]="900:225:9:2:1:::0:0:", -- Pattern: Shadow Hood
	[7090]="1000:250:9:2:1:::0:0:", -- Pattern: Green Silk Armor
	[7092]="1000:250:9:2:1:::0:0:", -- Pattern: Hands of Darkness
	[5773]="1000:250:9:2:1:::0:0:", -- Pattern: Robes of Arcana
	[7091]="1000:250:9:2:1:::0:0:", -- Pattern: Truefaith Gloves
	[4352]="1100:275:9:2:1:::0:0:", -- Pattern: Boots of the Enchanter
	[5774]="1100:275:9:2:1:::0:0:", -- Pattern: Green Silk Pack
	[4353]="1200:300:9:2:1:::0:0:", -- Pattern: Spider Belt
	[7085]="1400:350:9:2:1:::0:0:", -- Pattern: Azure Shoulders
	[5775]="1400:350:9:2:1:::0:0:", -- Pattern: Black Silk Pack
	[7084]="1400:350:9:2:1:::0:0:", -- Pattern: Crimson Silk Shoulders
	[7086]="1500:375:9:2:1:::0:0:", -- Pattern: Earthen Silk Belt
	[4356]="1500:375:9:2:1:::0:0:", -- Pattern: Star Belt
	[10302]="5000:1250:9:2:1:::0:0:", -- Pattern: Red Mageweave Pants
	[10300]="5000:1250:9:2:1:::0:0:", -- Pattern: Red Mageweave Vest
	[10301]="5000:1250:9:2:1:::0:0:", -- Pattern: White Bandit Mask
	[10312]="6000:1500:9:2:1:::0:0:", -- Pattern: Red Mageweave Gloves
	[10320]="7000:1750:9:2:1:::0:0:", -- Pattern: Red Mageweave Headband
	[10315]="7000:1750:9:2:1:::0:0:", -- Pattern: Red Mageweave Shoulders
	[10463]="7000:1750:9:2:1:::0:0:", -- Pattern: Shadoweave Mask
	[14471]="12000:3000:9:2:1:::0:0:", -- Pattern: Cindercloth Vest
	[14474]="12000:3000:9:2:1:::0:0:", -- Pattern: Frostweave Gloves
	[14467]="12000:3000:9:2:1:::0:0:", -- Pattern: Frostweave Robe
	[14466]="12000:3000:9:2:1:::0:0:", -- Pattern: Frostweave Tunic
	[14473]="12000:3000:9:2:1:::0:0:", -- Pattern: Ghostweave Belt
	[14470]="12000:3000:9:2:1:::0:0:", -- Pattern: Runecloth Tunic
	[14479]="14000:3500:9:2:1:::0:0:", -- Pattern: Brightcloth Gloves
	[14478]="14000:3500:9:2:1:::0:0:", -- Pattern: Brightcloth Robe
	[14476]="14000:3500:9:2:1:::0:0:", -- Pattern: Cindercloth Gloves
	[14477]="14000:3500:9:2:1:::0:0:", -- Pattern: Ghostweave Gloves
	[14484]="16000:4000:9:2:1:::0:0:", -- Pattern: Brightcloth Cloak
	[14482]="16000:4000:9:2:1:::0:0:", -- Pattern: Cindercloth Cloak
	[14480]="16000:4000:9:2:1:::0:0:", -- Pattern: Ghostweave Vest
	[14485]="16000:4000:9:2:1:::0:0:", -- Pattern: Wizardweave Leggings
	[14490]="20000:5000:9:2:1:::0:0:", -- Pattern: Cindercloth Pants
	[14492]="20000:5000:9:2:1:::0:0:", -- Pattern: Felcloth Boots
	[14489]="20000:5000:9:2:1:::0:0:", -- Pattern: Frostweave Pants
	[14488]="20000:5000:9:2:1:::1:1:149", -- Pattern: Runecloth Boots
	[14491]="20000:5000:9:2:1:::0:0:", -- Pattern: Runecloth Pants
	[14494]="22000:5500:9:2:1:::0:0:", -- Pattern: Brightcloth Pants
	[14496]="22000:5500:9:2:1:::0:0:", -- Pattern: Felcloth Hood
	[14498]="25000:6250:9:2:1:::0:0:", -- Pattern: Runecloth Headband
	[14499]="30000:7500:9:2:1:::0:0:", -- Pattern: Mooncloth Bag
	[14500]="30000:7500:9:2:1:::0:0:", -- Pattern: Wizardweave Robe
	[14506]="40000:10000:9:2:1:::0:0:", -- Pattern: Felcloth Robe
	[14504]="40000:10000:9:2:1:::0:0:", -- Pattern: Runecloth Shoulders
	[14505]="40000:10000:9:2:1:::0:0:", -- Pattern: Wizardweave Turban
	[14508]="60000:15000:9:2:1:::0:0:", -- Pattern: Felcloth Shoulders
	[4354]="1400:350:9:2:1:::0:0:", -- Pattern: Rich Purple Silk Shirt
	[14493]="20000:5000:9:2:1:::0:0:", -- Pattern: Robe of Winter Night
	[14497]="22000:5500:9:2:1:::0:0:", -- Pattern: Mooncloth Leggings
	[14501]="30000:7500:9:2:1:::0:0:", -- Pattern: Mooncloth Vest
	[14486]="40000:10000:9:2:1:::0:0:", -- Pattern: Cloak of Fire
	[18418]="40000:10000:9:2:1:::0:0:", -- Pattern: Cloak of Warding
	[18415]="40000:10000:9:2:1:::0:0:", -- Pattern: Felcloth Gloves
	[18416]="40000:10000:9:2:1:::0:0:", -- Pattern: Inferno Gloves
	[18417]="40000:10000:9:2:1:::0:0:", -- Pattern: Mooncloth Gloves
	[18487]="40000:10000:9:2:1:::0:0:", -- Pattern: Mooncloth Robe
	[14507]="40000:10000:9:2:1:::0:0:", -- Pattern: Mooncloth Shoulders
	[18265]="120000:30000:9:2:1:::0:0:", -- Pattern: Flarecore Wraps
	[14513]="60000:15000:9:2:1:::0:0:", -- Pattern: Robe of the Archmage
	[14514]="60000:15000:9:2:1:::0:0:", -- Pattern: Robe of the Void
	[14512]="60000:15000:9:2:1:::0:0:", -- Pattern: Truefaith Vestments
	[18414]="120000:30000:9:2:1:::0:0:", -- Pattern: Belt of the Archmage
	[13309]="1000:250:9:3:1:::1:1:215", -- Schematic: Lovingly Crafted Boomstick
	[7560]="1200:300:9:3:1:::1:1:233,742,806", -- Schematic: Gnomish Universal Remote
	[14639]="1500:375:9:3:1:::1:1:215,609", -- Schematic: Minor Recombobulator
	[18649]="1800:450:9:3:1:Firework::1:1:147,233,742,806", -- Schematic: Blue Firework
	[18648]="1800:450:9:3:1:Firework::1:1:133,225", -- Schematic: Green Firework
	[13308]="1800:450:9:3:1:::0:0:", -- Schematic: Ice Deflector
	[18647]="1800:450:9:3:1:Firework::1:1:740", -- Schematic: Red Firework
	[13310]="2000:500:9:3:1:::1:1:572", -- Schematic: Accurate Scope
	[7561]="2000:500:9:3:1:::1:1:505,648,845,888", -- Schematic: Goblin Jumper Cables
	[7742]="2400:600:9:3:1:::1:1:879", -- Schematic: Gnomish Cloaking Device
	[10602]="3000:750:9:3:1:::0:0:", -- Schematic: Deadly Scope
	[10607]="3600:900:9:3:1:::0:0:", -- Schematic: Deepdive Helmet
	[10609]="4000:1000:9:3:1:::0:0:", -- Schematic: Mithril Mechanical Dragonling
	[18650]="5000:1250:9:3:1:::1:1:72,860", -- Schematic: EZ-Thro Dynamite II
	[13311]="10000:2500:9:3:1:::0:0:", -- Schematic: Mechanical Dragonling
	[18652]="12000:3000:9:3:1:::1:1:870", -- Schematic: Gyrofreeze Ice Reflector
	[16041]="12000:3000:9:3:1:::1:1:233,740,742,786,806", -- Schematic: Thorium Grenade
	[16042]="12000:3000:9:3:1:::1:1:233,740,742,786,806", -- Schematic: Thorium Widget
	[18651]="12000:3000:9:3:1:::1:1:572", -- Schematic: Truesilver Transformer
	[16046]="16000:4000:9:3:1:::1:1:870", -- Schematic: Masterwork Target Dummy
	[18656]="16000:4000:9:3:1:::1:1:870", -- Schematic: Powerful Seaforium Charge
	[16047]="16000:4000:9:3:1:::1:1:870", -- Schematic: Thorium Tube
	[16050]="20000:5000:9:3:1:::1:1:870", -- Schematic: Delicate Arcanite Converter
	[4408]="650:162:9:3:1:::0:0:", -- Schematic: Mechanical Squirrel
	[6716]="800:200:9:3:1:::0:0:", -- Schematic: EZ-Thro Dynamite
	[4409]="800:200:9:3:1:::0:0:", -- Schematic: Small Seaforium Charge
	[4410]="1000:250:9:3:1:::0:0:", -- Schematic: Shadow Goggles
	[4411]="1100:275:9:3:1:::0:0:", -- Schematic: Flame Deflector
	[4412]="1500:375:9:3:1:::0:0:", -- Schematic: Moonsight Rifle
	[4413]="1800:450:9:3:1:::0:0:", -- Schematic: Discombobulator Ray
	[4414]="1850:462:9:3:1:::0:0:", -- Schematic: Portable Bronze Mortar
	[10601]="2000:500:9:3:1:::0:0:", -- Schematic: Bright-Eye Goggles
	[6672]="2000:500:9:3:1:::0:0:", -- Schematic: Flash Bomb
	[4416]="2400:600:9:3:1:::0:0:", -- Schematic: Goblin Land Mine
	[17720]="2400:600:9:3:1:::0:0:", -- Schematic: Snowmaster 9000
	[4417]="2700:675:9:3:1:::0:0:", -- Schematic: Large Seaforium Charge
	[11827]="2700:675:9:3:1:::0:0:", -- Schematic: Lil' Smoky
	[10603]="3300:825:9:3:1:::0:0:", -- Schematic: Catseye Ultra Goggles
	[10604]="3300:825:9:3:1:::0:0:", -- Schematic: Mithril Heavy-bore Rifle
	[10606]="3500:875:9:3:1:::0:0:", -- Schematic: Parachute Cloak
	[16043]="12000:3000:9:3:1:::0:0:", -- Schematic: Thorium Rifle
	[18661]="12000:3000:9:3:1:::0:0:", -- Schematic: World Enlarger
	[16048]="16000:4000:9:3:1:::0:0:", -- Schematic: Dark Iron Rifle
	[18654]="16000:4000:9:3:1:::0:0:", -- Schematic: Gnomish Alarm-O-Bot
	[18653]="16000:4000:9:3:1:::0:0:", -- Schematic: Goblin Jumper Cables XL
	[16044]="16000:4000:9:3:1:::0:0:", -- Schematic: Lifelike Mechanical Toad
	[18655]="16000:4000:9:3:1:::0:0:", -- Schematic: Major Recombobulator
	[16045]="16000:4000:9:3:1:::0:0:", -- Schematic: Spellpower Goggles Xtreme Plus
	[16049]="20000:5000:9:3:1:::0:0:", -- Schematic: Dark Iron Bomb
	[18657]="20000:5000:9:3:1:::0:0:", -- Schematic: Hyper-Radiant Flame Reflector
	[16053]="20000:5000:9:3:1:::0:0:", -- Schematic: Master Engineer's Goggles
	[16051]="20000:5000:9:3:1:::0:0:", -- Schematic: Thorium Shells
	[16052]="20000:5000:9:3:1:::0:0:", -- Schematic: Voice Amplification Modulator
	[16055]="24000:6000:9:3:1:::0:0:", -- Schematic: Arcane Bomb
	[16054]="24000:6000:9:3:1:::0:0:", -- Schematic: Arcanite Dragonling
	[16056]="24000:6000:9:3:1:::0:0:", -- Schematic: Flawless Arcanite Rifle
	[18658]="24000:6000:9:3:1:::0:0:", -- Schematic: Ultra-Flash Shadow Reflector
	[4415]="2200:550:9:3:1:::0:0:", -- Schematic: Craftsman's Monocle
	[10605]="3500:875:9:3:1:::0:0:", -- Schematic: Spellpower Goggles Xtreme
	[10608]="3800:950:9:3:1:::0:0:", -- Schematic: Sniper Scope
	[18291]="120000:30000:9:3:1:::0:0:", -- Schematic: Force Reactive Disk
	[10713]="2000:500:9:4:1:::0:0:", -- Plans: Inlaid Mithril Cylinder
	[12162]="3000:750:9:4:1:::1:1:307,435,437,753,809", -- Plans: Hardened Iron Shortsword
	[10858]="3000:750:9:4:1:::1:1:399,413,600", -- Plans: Solid Iron Maul
	[6047]="4400:1100:9:4:1:::1:1:493,805", -- Plans: Golden Scale Coif
	[12164]="4400:1100:9:4:1:::1:1:836", -- Plans: Massive Iron Axe
	[12163]="4400:1100:9:4:1:::1:1:882", -- Plans: Moonsteel Broadsword
	[8030]="10000:2500:9:4:1:::0:0:", -- Plans: Ebon Shiv
	[12823]="20000:5000:9:4:1:::0:0:", -- Plans: Huge Thorium Battleaxe
	[19203]="22000:5500:9:4:1:::1:0:39,40,668", -- Plans: Girdle of the Dawn
	[19205]="40000:10000:9:4:1:::1:0:39,40,668", -- Plans: Gloves of the Dawn
	[3609]="100:25:9:4:1:::0:0:", -- Plans: Copper Chain Vest
	[3610]="200:50:9:4:1:::0:0:", -- Plans: Gemmed Copper Gauntlets
	[6735]="600:150:9:4:1:::0:0:", -- Plans: Ironforge Breastplate
	[2881]="600:150:9:4:1:::0:0:", -- Plans: Runed Copper Breastplate
	[5578]="1200:300:9:4:1:::0:0:", -- Plans: Silvered Bronze Breastplate
	[2882]="1200:300:9:4:1:::0:0:", -- Plans: Silvered Bronze Shoulders
	[2883]="1500:375:9:4:1:::0:0:", -- Plans: Deadly Bronze Poniard
	[5543]="1800:450:9:4:1:::0:0:", -- Plans: Iridescent Hammer
	[6044]="1800:450:9:4:1:::0:0:", -- Plans: Iron Shield Spike
	[3611]="2000:500:9:4:1:::0:0:", -- Plans: Green Iron Boots
	[3612]="2000:500:9:4:1:::0:0:", -- Plans: Green Iron Gauntlets
	[3608]="2000:500:9:4:1:::0:0:", -- Plans: Mighty Iron Hammer
	[6045]="2600:650:9:4:1:::0:0:", -- Plans: Iron Counterweight
	[7979]="3000:750:9:4:1:::0:0:", -- Plans: Barbaric Iron Breastplate
	[7978]="3000:750:9:4:1:::0:0:", -- Plans: Barbaric Iron Shoulders
	[3870]="3000:750:9:4:1:::0:0:", -- Plans: Green Iron Shoulders
	[10424]="3000:750:9:4:1:::0:0:", -- Plans: Silvered Bronze Leggings
	[3872]="3200:800:9:4:1:::0:0:", -- Plans: Golden Scale Leggings
	[7980]="3400:850:9:4:1:::0:0:", -- Plans: Barbaric Iron Helm
	[17706]="3800:950:9:4:1:::0:0:", -- Plans: Edge of Winter
	[3867]="3800:950:9:4:1:::0:0:", -- Plans: Golden Iron Destroyer
	[12261]="3800:950:9:4:1:::0:0:", -- Plans: Searing Golden Blade
	[6046]="3800:950:9:4:1:::0:0:", -- Plans: Steel Weapon Chain
	[3866]="4000:1000:9:4:1:::0:0:", -- Plans: Jade Serpentblade
	[7981]="4400:1100:9:4:1:::0:0:", -- Plans: Barbaric Iron Boots
	[7982]="4400:1100:9:4:1:::0:0:", -- Plans: Barbaric Iron Gloves
	[3873]="4400:1100:9:4:1:::0:0:", -- Plans: Golden Scale Cuirass
	[3874]="4400:1100:9:4:1:::0:0:", -- Plans: Polished Steel Boots
	[3868]="5000:1250:9:4:1:::0:0:", -- Plans: Frost Tiger Blade
	[9367]="5000:1250:9:4:1:::0:0:", -- Plans: Golden Scale Gauntlets
	[3869]="5000:1250:9:4:1:::0:0:", -- Plans: Shadow Crescent Axe
	[7975]="6000:1500:9:4:1:::0:0:", -- Plans: Heavy Mithril Pants
	[7995]="6000:1500:9:4:1:::1:1:241,315", -- Plans: Mithril Scale Bracers
	[7992]="8000:2000:9:4:1:::0:0:", -- Plans: Blue Glittering Axe
	[7984]="8000:2000:9:4:1:::0:0:", -- Plans: Ornate Mithril Gloves
	[7983]="8000:2000:9:4:1:::0:0:", -- Plans: Ornate Mithril Pants
	[7985]="8000:2000:9:4:1:::0:0:", -- Plans: Ornate Mithril Shoulder
	[8029]="8000:2000:9:4:1:::0:0:", -- Plans: Wicked Mithril Blade
	[7993]="10000:2500:9:4:1:::0:0:", -- Plans: Dazzling Mithril Rapier
	[7990]="10000:2500:9:4:1:::0:0:", -- Plans: Heavy Mithril Helm
	[7989]="10000:2500:9:4:1:::0:0:", -- Plans: Mithril Spurs
	[11614]="12000:3000:9:4:1:::0:0:", -- Plans: Dark Iron Mail
	[11615]="12000:3000:9:4:1:::0:0:", -- Plans: Dark Iron Shoulders
	[12688]="12000:3000:9:4:1:::0:0:", -- Plans: Imperial Plate Belt
	[12690]="12000:3000:9:4:1:::0:0:", -- Plans: Imperial Plate Bracers
	[12687]="12000:3000:9:4:1:::0:0:", -- Plans: Imperial Plate Shoulders
	[12685]="12000:3000:9:4:1:::0:0:", -- Plans: Radiant Belt
	[12682]="12000:3000:9:4:1:::0:0:", -- Plans: Thorium Armor
	[12683]="12000:3000:9:4:1:::0:0:", -- Plans: Thorium Belt
	[12684]="12000:3000:9:4:1:::0:0:", -- Plans: Thorium Bracers
	[12689]="14000:3500:9:4:1:::0:0:", -- Plans: Radiant Breastplate
	[12819]="16000:4000:9:4:1:::0:0:", -- Plans: Ornate Thorium Handaxe
	[12692]="16000:4000:9:4:1:::0:0:", -- Plans: Thorium Shield Spike
	[12825]="20000:5000:9:4:1:::0:0:", -- Plans: Blazing Rapier
	[12824]="20000:5000:9:4:1:::0:0:", -- Plans: Enchanted Battlehammer
	[12695]="20000:5000:9:4:1:::0:0:", -- Plans: Radiant Gloves
	[12827]="20000:5000:9:4:1:::0:0:", -- Plans: Serenity
	[12693]="20000:5000:9:4:1:::0:0:", -- Plans: Thorium Boots
	[12694]="20000:5000:9:4:1:::0:0:", -- Plans: Thorium Helm
	[12697]="22000:5500:9:4:1:::0:0:", -- Plans: Radiant Boots
	[12828]="22000:5500:9:4:1:::0:0:", -- Plans: Volcanic Hammer
	[12700]="25000:6250:9:4:1:::0:0:", -- Plans: Imperial Plate Boots
	[12701]="25000:6250:9:4:1:::0:0:", -- Plans: Imperial Plate Helm
	[12702]="25000:6250:9:4:1:::0:0:", -- Plans: Radiant Circlet
	[12705]="30000:7500:9:4:1:::0:0:", -- Plans: Imperial Plate Chest
	[12707]="30000:7500:9:4:1:::0:0:", -- Plans: Runic Plate Boots
	[12704]="30000:7500:9:4:1:::0:0:", -- Plans: Thorium Leggings
	[12715]="40000:10000:9:4:1:::0:0:", -- Plans: Imperial Plate Leggings
	[12713]="40000:10000:9:4:1:::0:0:", -- Plans: Radiant Leggings
	[12718]="60000:15000:9:4:1:::0:0:", -- Plans: Runic Breastplate
	[12719]="60000:15000:9:4:1:::0:0:", -- Plans: Runic Plate Leggings
	[3871]="3400:850:9:4:1:::0:0:", -- Plans: Golden Scale Shoulders
	[3875]="5000:1250:9:4:1:::0:0:", -- Plans: Golden Scale Boots
	[7976]="8000:2000:9:4:1:::0:0:", -- Plans: Mithril Shield Spike
	[7991]="10000:2500:9:4:1:::0:0:", -- Plans: Mithril Scale Shoulders
	[8028]="10000:2500:9:4:1:::0:0:", -- Plans: Runed Mithril Hammer
	[11612]="12000:3000:9:4:1:::0:0:", -- Plans: Dark Iron Plate
	[11610]="12000:3000:9:4:1:::0:0:", -- Plans: Dark Iron Pulverizer
	[11611]="12000:3000:9:4:1:::0:0:", -- Plans: Dark Iron Sunderer
	[12821]="16000:4000:9:4:1:::0:0:", -- Plans: Dawn's Edge
	[12691]="16000:4000:9:4:1:::0:0:", -- Plans: Wildthorn Mail
	[12696]="20000:5000:9:4:1:::0:0:", -- Plans: Demon Forged Breastplate
	[12699]="20000:5000:9:4:1:::0:0:", -- Plans: Fiery Plate Gauntlets
	[12830]="22000:5500:9:4:1:::0:0:", -- Plans: Corruption
	[12703]="40000:10000:9:4:1:::0:0:", -- Plans: Storm Gauntlets
	[12711]="40000:10000:9:4:1:::0:0:", -- Plans: Whitesoul Helm
	[12727]="60000:15000:9:4:1:::0:0:", -- Plans: Enchanted Thorium Breastplate
	[12725]="60000:15000:9:4:1:::0:0:", -- Plans: Enchanted Thorium Helm
	[12726]="60000:15000:9:4:1:::0:0:", -- Plans: Enchanted Thorium Leggings
	[12716]="60000:15000:9:4:1:::0:0:", -- Plans: Helm of the Great Chief
	[17051]="70000:17500:9:4:1:::1:1:536", -- Plans: Dark Iron Bracers
	[12835]="80000:20000:9:4:1:::0:0:", -- Plans: Annihilator
	[12834]="80000:20000:9:4:1:::0:0:", -- Plans: Arcanite Champion
	[12838]="80000:20000:9:4:1:::0:0:", -- Plans: Arcanite Reaper
	[12836]="80000:20000:9:4:1:::0:0:", -- Plans: Frostguard
	[12833]="80000:20000:9:4:1:::0:0:", -- Plans: Hammer of the Titans
	[12839]="80000:20000:9:4:1:::0:0:", -- Plans: Heartseeker
	[12837]="80000:20000:9:4:1:::0:0:", -- Plans: Masterwork Stormhammer
	[17049]="90000:22500:9:4:1:::1:1:536", -- Plans: Fiery Chain Girdle
	[17052]="180000:45000:9:4:1:::1:0:536", -- Plans: Dark Iron Leggings
	[17053]="200000:50000:9:4:1:::1:0:536", -- Plans: Fiery Chain Shoulders
	[17060]="220000:55000:9:4:1:::1:1:536", -- Plans: Dark Iron Destroyer
	[17059]="220000:55000:9:4:1:::1:1:536", -- Plans: Dark Iron Reaver
	[12717]="60000:15000:9:4:1:::0:0:", -- Plans: Lionheart Helm
	[12728]="80000:20000:9:4:1:::0:0:", -- Plans: Invulnerable Mail
	[12226]="25:6:9:5:1:::1:0:3", -- Recipe: Crispy Bat Wing
	[17200]="25:6:9:5:1:::0:0:", -- Recipe: Gingerbread Cookie
	[6325]="40:10:9:5:1:::1:0:113,277,323,468,567,634,711,717,775,884", -- Recipe: Brilliant Smallfish
	[5482]="40:10:9:5:1:::0:0:", -- Recipe: Kaldorei Spider Kabob
	[6326]="40:10:9:5:1:::1:0:492,567,626,763,881", -- Recipe: Slitherskin Mackerel
	[5483]="140:35:9:5:1:::1:0:280", -- Recipe: Scorpid Surprise
	[7678]="200:50:9:5:1:::1:0:737", -- Recipe: Thistle Tea
	[728]="200:50:9:5:1:::1:0:464", -- Recipe: Westfall Stew
	[2889]="240:60:9:5:1:::1:0:464", -- Recipe: Beer Basted Boar Ribs
	[17201]="240:60:9:5:1:::0:0:", -- Recipe: Egg Nog
	[5484]="240:60:9:5:1:::1:0:863", -- Recipe: Roasted Kodo Meat
	[6892]="250:62:9:5:1:::1:0:27,166", -- Recipe: Smoked Bear Meat
	[3679]="400:100:9:5:1:::1:0:464", -- Recipe: Blood Sausage
	[2698]="400:100:9:5:1:::1:0:464", -- Recipe: Cooked Crab Claw
	[5488]="400:100:9:5:1:::1:0:48,766", -- Recipe: Crispy Lizard Tail
	[3678]="400:100:9:5:1:::1:0:464", -- Recipe: Crocolisk Steak
	[5485]="400:100:9:5:1:::1:0:508", -- Recipe: Fillet of Frenzy
	[2697]="400:100:9:5:1:::1:0:464", -- Recipe: Goretusk Liver Pie
	[6329]="400:100:9:5:1:::1:0:468", -- Recipe: Loch Frenzy Delight
	[6328]="400:100:9:5:1:::1:0:323,468,474,606,634,763,775,884", -- Recipe: Longjaw Mud Snapper
	[6368]="400:100:9:5:1:::1:0:113,331,474,475,492,626,717,752,881", -- Recipe: Rainbow Fin Albacore
	[2700]="400:100:9:5:1:::1:0:464", -- Recipe: Succulent Pork Ribs
	[5486]="440:110:9:5:1:::1:0:48,766", -- Recipe: Strider Stew
	[5528]="800:200:9:5:1:::1:0:331,492", -- Recipe: Clam Chowder
	[5487]="800:200:9:5:1:::0:0:", -- Recipe: Dig Rat Stew
	[2699]="800:200:9:5:1:::1:0:464", -- Recipe: Redridge Goulash
	[4609]="1000:250:9:5:1:::1:0:617", -- Recipe: Barbecued Buzzard Wing
	[6330]="1200:300:9:5:1:::0:1:113,154,162,475,528,606,711,717", -- Recipe: Bristle Whisker Catfish
	[5489]="1200:300:9:5:1:::1:0:817", -- Recipe: Lean Venison
	[3734]="1600:400:9:5:1:::1:0:817", -- Recipe: Big Bear Steak
	[3681]="1600:400:9:5:1:::1:0:464", -- Recipe: Crocolisk Gumbo
	[3682]="1600:400:9:5:1:::1:0:263,457,464,625", -- Recipe: Curiously Tasty Omelet
	[3683]="1600:400:9:5:1:::1:0:464", -- Recipe: Gooey Spider Cake
	[12227]="1600:400:9:5:1:::0:0:", -- Recipe: Lean Wolf Steak
	[3680]="1600:400:9:5:1:::1:0:464", -- Recipe: Murloc Fin Soup
	[2701]="1600:400:9:5:1:::1:0:464", -- Recipe: Seasoned Wolf Kabob
	[3735]="1800:450:9:5:1:::1:0:883", -- Recipe: Hot Lion Chops
	[3736]="2000:500:9:5:1:::0:0:", -- Recipe: Tasty Lion Steak
	[17062]="2200:550:9:5:1:::1:0:162,331,463,528,717,752,763,852,862", -- Recipe: Mithril Head Trout
	[6369]="2200:550:9:5:1:::1:0:162,331,463,528,717,752,763,852,862", -- Recipe: Rockscale Cod
	[3737]="2200:550:9:5:1:::0:0:", -- Recipe: Soothing Turtle Bisque
	[12231]="3000:750:9:5:1:::1:0:131,625", -- Recipe: Jungle Stew
	[12233]="3000:750:9:5:1:::1:0:333,377,396", -- Recipe: Mystery Stew
	[16767]="3000:750:9:5:1:::1:1:391", -- Recipe: Undermine Clam Chowder
	[12232]="5000:1250:9:5:1:::1:0:47,478,636", -- Recipe: Carrion Surprise
	[6039]="5000:1250:9:5:1:::1:1:463", -- Recipe: Giant Clam Scorcho
	[12229]="5000:1250:9:5:1:::1:0:718,838", -- Recipe: Hot Wolf Ribs
	[12228]="5000:1250:9:5:1:::1:0:131,263,305,333,457,625,636", -- Recipe: Roast Raptor
	[12239]="7000:1750:9:5:1:::1:0:333,636", -- Recipe: Dragonbreath Chili
	[12240]="7000:1750:9:5:1:::1:0:377,396,478", -- Recipe: Heavy Kodo Stew
	[16072]="10000:2500:9:5:1:::1:0:716,862", -- Expert Cookbook
	[16110]="12000:3000:9:5:1:::1:0:46,340,558,663", -- Recipe: Monster Omelet
	[16111]="12000:3000:9:5:1:::1:0:47,492,825", -- Recipe: Spiced Chili Crab
	[18046]="12000:3000:9:5:1:::1:0:158,807", -- Recipe: Tender Wolf Steak
	[13940]="16000:4000:9:5:1:::1:1:463", -- Recipe: Cooked Glossy Mightfish
	[13941]="16000:4000:9:5:1:::1:1:463", -- Recipe: Filet of Redgill
	[13942]="16000:4000:9:5:1:::1:0:244", -- Recipe: Grilled Squid
	[13943]="16000:4000:9:5:1:::1:1:463", -- Recipe: Hot Smoked Bass
	[13939]="16000:4000:9:5:1:::1:0:244", -- Recipe: Spotted Yellowtail
	[13949]="20000:5000:9:5:1:::1:0:718,838", -- Recipe: Baked Salmon
	[13947]="20000:5000:9:5:1:::1:0:718,838", -- Recipe: Lobster Stew
	[13948]="20000:5000:9:5:1:::1:0:718,838", -- Recipe: Mightfish Steak
	[13945]="20000:5000:9:5:1:::1:0:244", -- Recipe: Nightfin Soup
	[13946]="20000:5000:9:5:1:::1:0:244", -- Recipe: Poached Sunscale Salmon
	[18160]="200:50:9:5:1:::1:0:737", -- Recipe: Thistle Tea
	[6661]="460:115:9:5:1:::0:0:", -- Recipe: Savory Deviate Delight
	[18267]="20000:5000:9:5:1:::0:0:", -- Recipe: Runn Tum Tuber Surprise
	[2553]="100:25:9:6:1:::0:0:", -- Recipe: Elixir of Minor Agility
	[5640]="100:25:9:6:1:::1:1:298,412,672,867", -- Recipe: Rage Potion
	[6053]="800:200:9:6:1:::1:1:351,505,845,867", -- Recipe: Holy Protection Potion
	[6054]="900:225:9:6:1:::1:1:120,318,501", -- Recipe: Shadow Protection Potion
	[3396]="1000:250:9:6:1:::0:0:", -- Recipe: Elixir of Lesser Agility
	[3394]="1000:250:9:6:1:::0:0:", -- Recipe: Elixir of Poison Resistance
	[3393]="1000:250:9:6:1:::0:0:", -- Recipe: Minor Magic Resistance Potion
	[6055]="1500:375:9:6:1:::1:1:414,611", -- Recipe: Fire Protection Potion
	[6068]="1500:375:9:6:1:::1:1:73,584,747", -- Recipe: Shadow Oil
	[6211]="1800:450:9:6:1:::0:0:", -- Recipe: Elixir of Ogre's Strength
	[5642]="1800:450:9:6:1:::1:1:485,739,760,818,841", -- Recipe: Free Action Potion
	[3830]="2000:500:9:6:1:::0:0:", -- Recipe: Elixir of Fortitude
	[17709]="2000:500:9:6:1:::0:0:", -- Recipe: Elixir of Frost Power
	[6056]="2000:500:9:6:1:::1:1:171,249,305", -- Recipe: Frost Protection Potion
	[10644]="2000:500:9:6:1:::0:0:", -- Recipe: Goblin Rocket Fuel
	[5643]="2000:500:9:6:1:::1:1:298,818", -- Recipe: Great Rage Potion
	[6057]="2000:500:9:6:1:::1:1:10,97,249,534", -- Recipe: Nature Protection Potion
	[4624]="2200:550:9:6:1:::0:0:", -- Recipe: Lesser Stoneshield Potion
	[3831]="2200:550:9:6:1:::0:0:", -- Recipe: Mighty Troll's Blood Potion
	[9303]="8000:2000:9:6:1:::1:0:10", -- Recipe: Philosophers' Stone
	[9304]="8000:2000:9:6:1:::1:0:10", -- Recipe: Transmute Iron to Gold
	[9305]="8000:2000:9:6:1:::1:1:10", -- Recipe: Transmute Mithril to Truesilver
	[9302]="9000:2250:9:6:1:::1:1:97,534,691", -- Recipe: Ghost Dye
	[9300]="10000:2500:9:6:1:::1:1:629,676", -- Recipe: Elixir of Demonslaying
	[13477]="12000:3000:9:6:1:::1:1:16,818", -- Recipe: Superior Mana Potion
	[13478]="13000:3250:9:6:1:::1:1:485,739,841", -- Recipe: Elixir of Superior Defense
	[13480]="15000:3750:9:6:1:::1:1:194", -- Recipe: Major Healing Potion
	[12958]="50000:12500:9:6:1:::1:0:10", -- Recipe: Transmute Arcanite
	[2555]="160:40:9:6:1:::0:0:", -- Recipe: Swiftness Potion
	[6663]="600:150:9:6:1:::0:0:", -- Recipe: Elixir of Giant Growth
	[4597]="1000:250:9:6:1:::0:0:", -- Recipe: Discolored Healing Potion
	[3395]="1000:250:9:6:1:::0:0:", -- Recipe: Limited Invulnerability Potion
	[3832]="2200:550:9:6:1:::0:0:", -- Recipe: Elixir of Detect Lesser Invisibility
	[14634]="2500:625:9:6:1:::1:1:93", -- Recipe: Frost Oil
	[9293]="5000:1250:9:6:1:::0:0:", -- Recipe: Magic Resistance Potion
	[9296]="8000:2000:9:6:1:::0:0:", -- Recipe: Gift of Arthas
	[9295]="8000:2000:9:6:1:::0:0:", -- Recipe: Invisibility Potion
	[9294]="8000:2000:9:6:1:::0:0:", -- Recipe: Wildvine Potion
	[9298]="9000:2250:9:6:1:::0:0:", -- Recipe: Elixir of Giants
	[9297]="10000:2500:9:6:1:::0:0:", -- Recipe: Elixir of Dream Vision
	[9301]="10000:2500:9:6:1:::1:1:16,183,562,769", -- Recipe: Elixir of Shadow Power
	[13476]="12000:3000:9:6:1:::0:0:", -- Recipe: Mighty Rage Potion
	[13479]="14000:3500:9:6:1:::0:0:", -- Recipe: Elixir of the Sages
	[13481]="15000:3750:9:6:1:::0:0:", -- Recipe: Elixir of Brute Force
	[13482]="15000:0:9:6:1:::1:0:39,40,668", -- Recipe: Transmute Air to Fire
	[13489]="15000:3750:9:6:1:::0:0:", -- Recipe: Transmute Earth to Life
	[13484]="15000:0:9:6:1:::0:0:", -- Recipe: Transmute Earth to Water
	[13483]="15000:0:9:6:1:::0:0:", -- Recipe: Transmute Fire to Earth
	[13488]="15000:3750:9:6:1:::0:0:", -- Recipe: Transmute Life to Earth
	[13486]="15000:3750:9:6:1:::0:0:", -- Recipe: Transmute Undeath to Water
	[13485]="15000:0:9:6:1:::0:0:", -- Recipe: Transmute Water to Air
	[13487]="15000:3750:9:6:1:::0:0:", -- Recipe: Transmute Water to Undeath
	[13491]="16000:4000:9:6:1:::0:0:", -- Recipe: Elixir of the Mongoose
	[13490]="16000:4000:9:6:1:::0:0:", -- Recipe: Greater Stoneshield Potion
	[13493]="20000:5000:9:6:1:::0:0:", -- Recipe: Greater Arcane Elixir
	[13492]="20000:5000:9:6:1:::0:0:", -- Recipe: Purification Potion
	[13497]="24000:6000:9:6:1:::0:0:", -- Recipe: Greater Arcane Protection Potion
	[13494]="24000:6000:9:6:1:::0:0:", -- Recipe: Greater Fire Protection Potion
	[13495]="24000:6000:9:6:1:::0:0:", -- Recipe: Greater Frost Protection Potion
	[13496]="24000:6000:9:6:1:::0:0:", -- Recipe: Greater Nature Protection Potion
	[13499]="24000:6000:9:6:1:::0:0:", -- Recipe: Greater Shadow Protection Potion
	[13501]="30000:7500:9:6:1:::0:0:", -- Recipe: Major Mana Potion
	[13522]="40000:10000:9:6:1:::0:0:", -- Recipe: Flask of Chromatic Resistance
	[13520]="40000:10000:9:6:1:::0:0:", -- Recipe: Flask of Distilled Wisdom
	[13518]="40000:10000:9:6:1:::0:0:", -- Recipe: Flask of Petrification
	[13521]="40000:10000:9:6:1:::0:0:", -- Recipe: Flask of Supreme Power
	[13519]="40000:10000:9:6:1:::0:0:", -- Recipe: Flask of the Titans
	[18257]="200000:50000:9:6:1:::0:0:", -- Recipe: Major Rejuvination Potion
	[16112]="2200:550:9:7:1:::1:0:45,152,242", -- Manual: Heavy Silk Bandage
	[16084]="10000:2500:9:7:1:::1:0:45,152,242", -- Expert First Aid - Under Wraps
	[19442]="100000:25000:9:7:1:::1:0:39,40,668", -- Formula: Powerful Anti-Venom
	[6454]="900:225:9:7:1:::0:0:", -- Manual: Strong Anti-Venom
	[16113]="5000:1250:9:7:1:::1:0:45,152,242", -- Manual: Mageweave Bandage
	[16217]="12000:3000:9:8:1:::1:1:141,605", -- Formula: Enchant Shield - Greater Stamina
	[16221]="16000:4000:9:8:1:::1:1:663", -- Formula: Enchant Chest - Major Health
	[16224]="20000:5000:9:8:1:::1:1:538", -- Formula: Enchant Cloak - Superior Defense
	[16243]="22000:5500:9:8:1:::1:1:538", -- Formula: Runed Arcanite Rod
	[19446]="30000:7500:9:8:1:::1:0:39,40,668", -- Formula: Enchant Bracer - Mana Regeneration
	[19444]="30000:7500:9:8:1:::1:1:536", -- Formula: Enchant Weapon - Strength
	[19447]="60000:15000:9:8:1:::1:0:39,40,668", -- Formula: Enchant Bracer - Healing
	[19448]="80000:20000:9:8:1:::1:1:536", -- Formula: Enchant Weapon - Mighty Spirit
	[6342]="300:75:9:8:1:::1:1:250,420,421,481,519,526,540,621,771,780,793,828", -- Formula: Enchant Chest - Minor Mana
	[6344]="400:100:9:8:1:::0:0:", -- Formula: Enchant Bracer - Minor Spirit
	[6347]="400:100:9:8:1:::0:0:", -- Formula: Enchant Bracer - Minor Strength
	[6346]="400:100:9:8:1:::1:1:250,421,481,526", -- Formula: Enchant Chest - Lesser Mana
	[6349]="500:125:9:8:1:::1:1:250,421,481,519,621,793", -- Formula: Enchant 2H Weapon - Lesser Intellect
	[6348]="500:125:9:8:1:::0:0:", -- Formula: Enchant Weapon - Minor Beastslayer
	[11038]="800:200:9:8:1:::0:0:", -- Formula: Enchant 2H Weapon - Lesser Spirit
	[11039]="800:200:9:8:1:::1:1:79,139,495", -- Formula: Enchant Cloak - Minor Agility
	[11081]="800:200:9:8:1:::0:0:", -- Formula: Enchant Shield - Lesser Protection
	[6377]="1000:250:9:8:1:::1:1:621,648,888", -- Formula: Enchant Boots - Minor Agility
	[6375]="1000:250:9:8:1:::0:0:", -- Formula: Enchant Bracer - Lesser Spirit
	[11098]="2000:500:9:8:1:::0:0:", -- Formula: Enchant Cloak - Lesser Shadow Resistance
	[11101]="2500:625:9:8:1:::1:1:79,139,495", -- Formula: Enchant Bracer - Lesser Strength
	[11163]="3000:750:9:8:1:::1:1:263,457,578", -- Formula: Enchant Bracer - Lesser Deflection
	[11152]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Gloves - Fishing
	[11151]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Gloves - Herbalism
	[11150]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Gloves - Mining
	[11164]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Weapon - Lesser Beastslayer
	[11165]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Weapon - Lesser Elemental Slayer
	[17725]="3000:750:9:8:1:::0:0:", -- Formula: Enchant Weapon - Winter Might
	[11167]="4000:1000:9:8:1:::0:0:", -- Formula: Enchant Boots - Lesser Spirit
	[11166]="4000:1000:9:8:1:::0:0:", -- Formula: Enchant Gloves - Skinning
	[11168]="4000:1000:9:8:1:::0:0:", -- Formula: Enchant Shield - Lesser Block
	[11204]="4400:1100:9:8:1:::0:0:", -- Formula: Enchant Bracer - Greater Spirit
	[11203]="4400:1100:9:8:1:::0:0:", -- Formula: Enchant Gloves - Advanced Mining
	[11202]="4400:1100:9:8:1:::0:0:", -- Formula: Enchant Shield - Stamina
	[11206]="5000:1250:9:8:1:::0:0:", -- Formula: Enchant Cloak - Lesser Agility
	[11205]="5000:1250:9:8:1:::0:0:", -- Formula: Enchant Gloves - Advanced Herbalism
	[11208]="5400:1350:9:8:1:::0:0:", -- Formula: Enchant Weapon - Demonslaying
	[11223]="5800:1450:9:8:1:::1:1:47,605", -- Formula: Enchant Bracer - Deflection
	[11224]="5800:1450:9:8:1:::0:0:", -- Formula: Enchant Shield - Frost Resistance
	[11225]="6200:1550:9:8:1:::0:0:", -- Formula: Enchant Bracer - Greater Stamina
	[11226]="6200:1550:9:8:1:::0:0:", -- Formula: Enchant Gloves - Riding Skill
	[16215]="12000:3000:9:8:1:::0:0:", -- Formula: Enchant Boots - Greater Stamina
	[16214]="12000:3000:9:8:1:::0:0:", -- Formula: Enchant Bracer - Greater Intellect
	[16216]="12000:3000:9:8:1:::0:0:", -- Formula: Enchant Cloak - Greater Resistance
	[11207]="12000:3000:9:8:1:::0:0:", -- Formula: Enchant Weapon - Fiery Weapon
	[11813]="12000:3000:9:8:1:::0:0:", -- Formula: Smoking Heart of the Mountain
	[16218]="14000:3500:9:8:1:::0:0:", -- Formula: Enchant Bracer - Superior Spirit
	[16219]="14000:3500:9:8:1:::0:0:", -- Formula: Enchant Gloves - Greater Agility
	[16220]="16000:4000:9:8:1:::0:0:", -- Formula: Enchant Boots - Spirit
	[16222]="20000:5000:9:8:1:::0:0:", -- Formula: Enchant Shield - Superior Spirit
	[16223]="20000:5000:9:8:1:::0:0:", -- Formula: Enchant Weapon - Icy Chill
	[16242]="22000:5500:9:8:1:::0:0:", -- Formula: Enchant Chest - Major Mana
	[16245]="24000:6000:9:8:1:::0:0:", -- Formula: Enchant Boots - Greater Agility
	[16246]="24000:6000:9:8:1:::0:0:", -- Formula: Enchant Bracer - Superior Strength
	[16244]="24000:6000:9:8:1:::0:0:", -- Formula: Enchant Gloves - Greater Strength
	[16247]="24000:6000:9:8:1:::0:0:", -- Formula: Enchant Weapon - Superior Impact
	[16248]="24000:6000:9:8:1:::0:0:", -- Formula: Enchant Weapon - Unholy
	[16249]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant 2H Weapon - Major Intellect
	[16255]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant 2H Weapon - Major Spirit
	[16251]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant Bracer - Superior Stamina
	[16252]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant Weapon - Crusader
	[16254]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant Weapon - Lifestealing
	[16250]="30000:7500:9:8:1:::0:0:", -- Formula: Enchant Weapon - Superior Striking
	[16083]="10000:2500:9:9:1:::1:0:638", -- Expert Fishing - The Bass and You
	[2101]="4:1:11:2:1:::1:1:218,527,560,772", -- Light Quiver
	[7278]="100:25:11:2:1:::0:0:", -- Light Leather Quiver
	[5439]="100:25:11:2:1:::1:0:44,63,79,92,114,124,181,218,243,246,314,415,418,424,436,458,476,496,527,595,607,608,616,671,730,747,804,826,854,880,886", -- Small Quiver
	[3573]="850:212:11:2:1:::0:0:", -- Hunting Quiver
	[11362]="1000:250:11:2:1:::1:0:44,63,79,92,114,124,181,218,243,246,314,415,418,424,436,458,476,496,527,560,595,607,608,616,671,730,747,772,804,826,854,880,886", -- Medium Quiver
	[7371]="2000:500:11:2:1:::1:1:560,772", -- Heavy Quiver
	[3605]="2000:500:11:2:1:::0:0:", -- Quiver of the Night Watch
	[8217]="4000:1000:11:2:1:::0:0:", -- Quickdraw Quiver
	[2662]="35000:8750:11:2:1:::0:0:", -- Ribbly's Quiver
	[19319]="350000:87500:11:2:1:::1:0:224,287,416,774", -- Harpy Hide Quiver
	[18714]="0:0:11:2:1:::0:0:", -- Ancient Sinew Wrapped Lamina
	[2102]="4:1:11:3:1:::0:0:", -- Small Ammo Pouch
	[7279]="100:25:11:3:1:::0:0:", -- Small Leather Ammo Pouch
	[3574]="850:212:11:3:1:::0:0:", -- Hunting Ammo Sack
	[5441]="1000:250:11:3:1:::1:1:89,328,334,388,438,465,527,747,772,783,826,843", -- Small Shot Pouch
	[3604]="2000:500:11:3:1:::0:0:", -- Bandolier of the Night Watch
	[7372]="2000:500:11:3:1:::0:0:", -- Heavy Leather Ammo Pouch
	[8218]="4000:1000:11:3:1:::0:0:", -- Thick Leather Ammo Pouch
	[2663]="35000:8750:11:3:1:::0:0:", -- Ribbly's Bandolier
	[19320]="350000:87500:11:3:1:::1:0:224,287,416,774", -- Gnoll Skin Bandolier
	[5334]="0:0:12:0:1:::0:0:", -- 99-Year-Old Port
	[939]="0:0:12:0:1:::0:0:", -- A Bloodstained Journal Page
	[9507]="0:0:12:0:1:::0:0:", -- A Carefully-packed Crate
	[1358]="0:0:12:0:1:::0:0:", -- A Clue to Sander's Treasure
	[11446]="0:0:12:0:1:::0:0:", -- A Crumpled Up Note
	[889]="0:0:12:0:1:::0:0:", -- A Dusty Unsent Letter
	[921]="0:0:12:0:1:::0:0:", -- A Faded Journal Page
	[2188]="0:0:12:0:1:::0:0:", -- A Letter to Grelin Whitebeard
	[2839]="0:0:12:0:1:::0:0:", -- A Letter to Yvette
	[1381]="0:0:12:0:1:::0:0:", -- A Mysterious Message
	[10664]="0:0:12:0:1:::0:0:", -- A Note to Magus Rimtori
	[9329]="0:0:12:0:1:::0:0:", -- A Short Note
	[9629]="0:0:12:0:1:::0:0:", -- A Shrunken Head
	[2998]="0:0:12:0:1:::0:0:", -- A Simple Compass
	[11107]="0:0:12:0:1:::0:0:", -- A Small Pack
	[9307]="0:0:12:0:1:::0:0:", -- A Sparkling Stone
	[2187]="0:0:12:0:1:::0:0:", -- A Stack of Letters
	[742]="0:0:12:0:1:::0:0:", -- A Sycamore Branch
	[3317]="0:0:12:0:1:::0:0:", -- A Talking Head
	[916]="0:0:12:0:1:::0:0:", -- A Torn Journal Page
	[1349]="0:0:12:0:1:::0:0:", -- Abercrombie's Crate
	[9440]="0:0:12:0:20:::0:0:", -- Acceptable Basilisk Sample
	[9441]="0:0:12:0:20:::0:0:", -- Acceptable Hyena Sample
	[9438]="0:0:12:0:20:::0:0:", -- Acceptable Scorpid Sample
	[5959]="0:0:12:0:20:::0:0:", -- Acidic Venom Sac
	[4883]="0:0:12:0:1:::0:0:", -- Admiral Proudmoore's Orders
	[2658]="0:0:12:0:1:::0:0:", -- Ados Fragment
	[7567]="0:0:12:0:1:::0:0:", -- Agamand Family Axe
	[7568]="0:0:12:0:1:::0:0:", -- Agamand Family Dagger
	[7569]="0:0:12:0:1:::0:0:", -- Agamand Family Mace
	[7566]="0:0:12:0:1:::0:0:", -- Agamand Family Sword
	[4881]="0:0:12:0:1:::0:0:", -- Aged Envelope
	[3862]="0:0:12:0:1:::0:0:", -- Aged Gorilla Sinew
	[6249]="0:0:12:0:20:::0:0:", -- Aged Kodo Hide
	[16283]="0:0:12:0:1:::0:0:", -- Ahanu's Leather Goods
	[4029]="0:0:12:0:20:::0:0:", -- Akiris Reed
	[3318]="0:0:12:0:1:::0:0:", -- Alaric's Remains
	[12467]="0:0:12:0:1:::0:0:", -- Alien Egg
	[4521]="0:0:12:0:20:::0:0:", -- Alterac Granite
	[17642]="0:0:12:0:100:::0:0:", -- Alterac Ram Hide
	[3505]="0:0:12:0:20:::0:0:", -- Alterac Signet Ring
	[11231]="0:0:12:0:10:::0:0:", -- Altered Black Dragonflight Molt
	[5098]="0:0:12:0:20:::0:0:", -- Altered Snapjaw Shell
	[4621]="0:0:12:0:1:::0:0:", -- Ambassador Infernus' Bracer
	[17009]="0:0:12:0:1:::0:0:", -- Ambassador Malcin's Head
	[1923]="0:0:12:0:1:::0:0:", -- Ambassador's Satchel
	[4809]="0:0:12:0:20:::0:0:", -- Ambercorn
	[5623]="0:0:12:0:1:::0:0:", -- Amethyst Phial
	[18152]="0:0:12:0:1:::0:0:", -- Amethyst Phial
	[4843]="0:0:12:0:1:::0:0:", -- Amethyst Runestone
	[10755]="0:0:12:0:1:::0:0:", -- Amulet of Allistarj
	[16787]="0:0:12:0:1:::0:0:", -- Amulet of Draconic Subversion
	[10753]="0:0:12:0:1:::0:0:", -- Amulet of Grol
	[10754]="0:0:12:0:1:::0:0:", -- Amulet of Sevine
	[17757]="0:0:12:0:1:::0:0:", -- Amulet of Spirits
	[17758]="0:0:12:0:1:::0:0:", -- Amulet of Union
	[2794]="0:0:12:0:1:::0:0:", -- An Old History Book
	[910]="0:0:12:0:1:::0:0:", -- An Undelivered Letter
	[2874]="0:0:12:0:1:::0:0:", -- An Unsent Letter
	[8052]="0:0:12:0:20:::0:0:", -- An'Alleum Power Stone
	[5382]="0:0:12:0:1:::0:0:", -- Anaya's Pendant
	[12402]="0:0:12:0:1:::0:0:", -- Ancient Egg
	[5338]="0:0:12:0:1:::0:0:", -- Ancient Moonstone Seal
	[5424]="0:0:12:0:1:::0:0:", -- Ancient Statuette
	[12638]="0:0:12:0:20:::0:0:", -- Andorhal Watch
	[7294]="0:0:12:0:1:::0:0:", -- Andron's Ledger
	[10679]="0:0:12:0:1:::0:0:", -- Andron's Note
	[12900]="0:0:12:0:1:::0:0:", -- Annals of Darrowshire
	[1361]="0:0:12:0:1:::0:0:", -- Another Clue to Sander's Treasure
	[17333]="0:0:12:0:1:::0:0:", -- Aqual Quintessence
	[17114]="0:0:12:0:1:::0:0:", -- Araj's Phylactery Shard
	[14610]="0:0:12:0:1:::0:0:", -- Araj's Scarab
	[18753]="0:0:12:0:1:::0:0:", -- Arcanite Barding
	[12925]="0:0:12:0:1:::0:0:", -- Arikara Serpent Skin
	[18925]="0:0:12:0:1:::0:0:", -- Artorius's Head
	[17310]="0:0:12:0:1:::0:0:", -- Aspect of Neptulos
	[3668]="0:0:12:0:1:::0:0:", -- Assassin's Contract
	[12564]="0:0:12:0:1:::0:0:", -- Assassination Note
	[7231]="0:0:12:0:1:::0:0:", -- Astor's Letter of Introduction
	[3515]="0:0:12:0:1:::0:0:", -- Ataeric's Staff
	[6175]="0:0:12:0:20:::0:0:", -- Atal'ai Artifact
	[11318]="0:0:12:0:20:::0:0:", -- Atal'ai Haze
	[10466]="0:0:12:0:1:::0:0:", -- Atal'ai Stone Circle
	[6288]="0:0:12:0:20:::0:0:", -- Atal'ai Tablet
	[6287]="0:0:12:0:1:::0:0:", -- Atal'ai Tablet Fragment
	[5383]="0:0:12:0:1:::0:0:", -- Athrikus Narassin's Head
	[15884]="0:0:12:0:1:::0:0:", -- Augustus' Receipt Book
	[12923]="0:0:12:0:1:::0:0:", -- Awbee's Scale
	[4527]="0:0:12:0:1:::0:0:", -- Azure Agate
	[4752]="0:0:12:0:20:::0:0:", -- Azure Feather
	[3960]="0:0:12:0:1:::0:0:", -- Bag of Water Elemental Bracers
	[3906]="0:0:12:0:20:::0:0:", -- Balia'mah Trophy
	[11843]="0:0:12:0:1:::0:0:", -- Bank Voucher
	[5022]="0:0:12:0:1:::0:0:", -- Barak's Head
	[5084]="0:0:12:0:1:::0:0:", -- Baron Longshore's Head
	[2548]="0:0:12:0:1:::0:0:", -- Barrel of Barleybrew Scalder
	[15044]="0:0:12:0:1:::0:0:", -- Barrel of Plagueland Termites
	[3085]="0:0:12:0:1:::0:0:", -- Barrel of Shimmer Stout
	[2666]="0:0:12:0:1:::0:0:", -- Barrel of Thunder Ale
	[5691]="0:0:12:0:1:::0:0:", -- Barrow Key
	[8394]="0:0:12:0:20:::0:0:", -- Basilisk Brain
	[5437]="0:0:12:0:20:::0:0:", -- Bathran's Hair
	[4849]="0:0:12:0:20:::0:0:", -- Battleboar Flank
	[4848]="0:0:12:0:20:::0:0:", -- Battleboar Snout
	[3014]="0:0:12:0:20:::0:0:", -- Battleworn Axe
	[12815]="0:0:12:0:1:::0:0:", -- Beacon Torch
	[4510]="0:0:12:0:1:::0:0:", -- Befouled Bloodstone Orb
	[5861]="0:0:12:0:1:::0:0:", -- Beginnings of the Undead Threat
	[4650]="0:0:12:0:1:::0:0:", -- Bel'dugur's Note
	[3711]="0:0:12:0:1:::0:0:", -- Belamoore's Research Journal
	[5850]="0:0:12:0:1:::0:0:", -- Belgrom's Sealed Note
	[3631]="0:0:12:0:1:::0:0:", -- Bellygrub's Tusk
	[10682]="0:0:12:0:1:::0:0:", -- Belnistrasz's Oathstone
	[3255]="0:0:12:0:1:::0:0:", -- Berard's Journal
	[981]="0:0:12:0:1:::0:0:", -- Bernice's Necklace
	[16192]="0:0:12:0:1:::0:0:", -- Besseleth's Fang
	[3251]="0:0:12:0:1:::0:0:", -- Bethor's Potion
	[3250]="0:0:12:0:1:::0:0:", -- Bethor's Scroll
	[12345]="0:0:12:0:1:::0:0:", -- Bijou's Belongings
	[12770]="0:0:12:0:1:::0:0:", -- Bijou's Information
	[12652]="0:0:12:0:1:::0:0:", -- Bijou's Reconnaissance Report
	[7376]="0:0:12:0:1:::0:0:", -- Bingles's Blastencapper
	[7346]="0:0:12:0:1:::0:0:", -- Bingles's Hammer
	[7345]="0:0:12:0:1:::0:0:", -- Bingles's Screwdriver
	[7343]="0:0:12:0:1:::0:0:", -- Bingles's Wrench
	[11752]="0:0:12:0:5:::0:0:", -- Black Blood of the Tormented
	[2788]="0:0:12:0:1:::0:0:", -- Black Claw Stout
	[16786]="0:0:12:0:20:::0:0:", -- Black Dragonspawn Eye
	[4612]="0:0:12:0:20:::0:0:", -- Black Drake's Heart
	[3406]="0:0:12:0:1:::0:0:", -- Black Feather Quill
	[5919]="0:0:12:0:1:::0:0:", -- Blackened Iron Shield
	[3163]="0:0:12:0:20:::0:0:", -- Blackened Skull
	[18987]="0:0:12:0:1:::0:0:", -- Blackhand's Command
	[4615]="0:0:12:0:1:::0:0:", -- Blacklash's Bindings
	[11467]="0:0:12:0:50:::0:0:", -- Blackrock Medallion
	[12341]="0:0:12:0:1:::0:0:", -- Blackwood Fruit Sample
	[12342]="0:0:12:0:1:::0:0:", -- Blackwood Grain Sample
	[12343]="0:0:12:0:1:::0:0:", -- Blackwood Nut Sample
	[8392]="0:0:12:0:20:::0:0:", -- Blasted Boar Lung
	[18792]="0:0:12:0:1:::0:0:", -- Blessed Arcanite Barding
	[11503]="0:0:12:0:20:::0:0:", -- Blood Amber
	[12938]="0:0:12:0:20:::0:0:", -- Blood of Heroes
	[13523]="0:0:12:0:1:::0:0:", -- Blood of Innocents
	[13140]="0:0:12:0:1:::0:0:", -- Blood Red Key
	[12848]="0:0:12:0:1:::0:0:", -- Blood Stained Pike
	[5204]="0:0:12:0:20:::0:0:", -- Bloodfeather Belt
	[16190]="0:0:12:0:1:::0:0:", -- Bloodfury Ripper's Remains
	[11316]="0:0:12:0:20:::0:0:", -- Bloodpetal
	[11315]="0:0:12:0:10:::0:0:", -- Bloodpetal Sprout
	[11320]="0:0:12:0:1:::0:0:", -- Bloodpetal Zapper
	[3920]="0:0:12:0:1:::0:0:", -- Bloodsail Charts
	[3921]="0:0:12:0:1:::0:0:", -- Bloodsail Orders
	[1519]="0:0:12:0:20:::0:0:", -- Bloodscalp Ear
	[3901]="0:0:12:0:20:::0:0:", -- Bloodscalp Tusk
	[4495]="0:0:12:0:20:::0:0:", -- Bloodstone Amulet
	[6928]="0:0:12:0:1:::0:0:", -- Bloodstone Choker
	[3689]="0:0:12:0:1:::0:0:", -- Bloodstone Marble
	[3688]="0:0:12:0:1:::0:0:", -- Bloodstone Oval
	[3744]="0:0:12:0:1:::0:0:", -- Bloodstone Pendant
	[3690]="0:0:12:0:1:::0:0:", -- Bloodstone Shard
	[3691]="0:0:12:0:1:::0:0:", -- Bloodstone Wedge
	[3915]="0:0:12:0:20:::0:0:", -- Bloody Bone Necklace
	[11184]="0:0:12:0:10::164:0:0:", -- Blue Power Crystal
	[9282]="0:0:12:0:1:::0:0:", -- Blue Punch Card
	[12524]="0:0:12:0:1:::0:0:", -- Blue-feathered Amulet
	[12558]="0:0:12:0:1:::0:0:", -- Blue-feathered Necklace
	[5876]="0:0:12:0:20:::0:0:", -- Blueleaf Tuber
	[7272]="0:0:12:0:1:::0:0:", -- Bolt Charged Bramble
	[11368]="0:0:12:0:1:::0:0:", -- Bolvar's Decree
	[13159]="0:0:12:0:20:::0:0:", -- Bone Dust
	[4649]="0:0:12:0:1:::0:0:", -- Bonegrip's Note
	[2161]="0:0:12:0:1:::0:0:", -- Book from Sven's Farm
	[11169]="0:0:12:0:1:::0:0:", -- Book of Aquor
	[18261]="0:0:12:0:1:::0:0:", -- Book of Incantations
	[15803]="0:0:12:0:1:::0:0:", -- Book of the Ancients
	[2795]="0:0:12:0:1:::0:0:", -- Book: Stresses of Iron
	[5352]="0:0:12:0:1:::0:0:", -- Book: The Powers Below
	[5440]="0:0:12:0:1:::0:0:", -- Bottle of Disease
	[1451]="0:0:12:0:1:::0:0:", -- Bottle of Zombie Juice
	[7500]="0:0:12:0:1:::0:0:", -- Bottom of Gelkak's Key
	[3715]="0:0:12:0:20:::0:0:", -- Bracers of Earth Binding
	[4628]="0:0:12:0:20:::0:0:", -- Bracers of Rock Binding
	[5461]="0:0:12:0:1:::0:0:", -- Branch of Cenarius
	[1006]="0:0:12:0:1:::0:0:", -- Brass Collar
	[4850]="0:0:12:0:1:::0:0:", -- Bristleback Attack Plans
	[4770]="0:0:12:0:20:::0:0:", -- Bristleback Belt
	[5085]="0:0:12:0:20:::0:0:", -- Bristleback Quilboar Tusk
	[16310]="0:0:12:0:1:::0:0:", -- Brock's List
	[11146]="0:0:12:0:1:::0:0:", -- Broken and Battered Samophlange
	[3909]="0:0:12:0:1:::0:0:", -- Broken Armor of Ana'thek
	[11142]="0:0:12:0:1:::0:0:", -- Broken Samophlange
	[6083]="0:0:12:0:20:::0:0:", -- Broken Tears
	[4703]="0:0:12:0:20:::0:0:", -- Broken Tools
	[4753]="0:0:12:0:20:::0:0:", -- Bronze Feather
	[12283]="0:0:12:0:20:::0:0:", -- Broodling Essence
	[4028]="0:0:12:0:1:::0:0:", -- Bundle of Akiris Reeds
	[6193]="0:0:12:0:1:::0:0:", -- Bundle of Atal'ai Artifacts
	[743]="0:0:12:0:1:::0:0:", -- Bundle of Charred Oak
	[3347]="0:0:12:0:1:::0:0:", -- Bundle of Crocolisk Skins
	[7626]="0:0:12:0:1:::0:0:", -- Bundle of Furs
	[16783]="0:0:12:0:20:::0:0:", -- Bundle of Reports
	[13872]="0:0:12:0:20:::0:0:", -- Bundle of Wood
	[4859]="0:0:12:0:1:::0:0:", -- Burning Blade Medallion
	[6844]="0:0:12:0:20:::0:0:", -- Burning Blood
	[11751]="0:0:12:0:5:::0:0:", -- Burning Essence
	[6436]="0:0:12:0:1:::0:0:", -- Burning Gem
	[6845]="0:0:12:0:20:::0:0:", -- Burning Rock
	[7847]="0:0:12:0:20:::0:0:", -- Buzzard Gizzard
	[9258]="0:0:12:0:1:::0:0:", -- Byltan Essence
	[12384]="0:0:12:0:1:::0:0:", -- Cache of Mau'ari
	[8073]="0:0:12:0:1:::0:0:", -- Cache of Zanzil's Altered Mixture
	[11583]="0:0:12:0:10:::0:0:", -- Cactus Apple
	[12263]="0:0:12:0:1:::0:0:", -- Caged Worg Pup
	[18643]="0:0:12:0:1:::0:0:", -- Cairne's Hoofprint
	[8723]="0:0:12:0:1:::0:0:", -- Caliph Scorpidsting's Head
	[2113]="0:0:12:0:1:::0:0:", -- Calor's Note
	[14650]="0:0:12:0:1:::0:0:", -- Camp Narache Gift Voucher
	[3080]="0:0:12:0:1:::0:0:", -- Candle of Beckoning
	[7308]="0:0:12:0:1:::0:0:", -- Cantation of Manifestation
	[4870]="0:0:12:0:20:::0:0:", -- Canvas Scraps
	[1357]="0:0:12:0:1:::0:0:", -- Captain Sander's Treasure Map
	[5882]="0:0:12:0:1:::0:0:", -- Captain's Documents
	[4098]="0:0:12:0:1:::0:0:", -- Carefully Folded Note
	[17118]="0:0:12:0:1:::0:0:", -- Carton of Mystery Meat
	[2636]="0:0:12:0:20:::0:0:", -- Carved Stone Idol
	[4610]="0:0:12:0:20:::0:0:", -- Carved Stone Urn
	[18591]="0:0:12:0:1:::0:0:", -- Case of Blood
	[2696]="0:0:12:0:1:::0:0:", -- Cask of Evershine
	[6843]="0:0:12:0:1:::0:0:", -- Cask of Scalder
	[3086]="0:0:12:0:1:::0:0:", -- Cask of Shimmer Stout
	[4027]="0:0:12:0:1:::0:0:", -- Catelyn's Blade
	[5097]="0:0:12:0:1:::0:0:", -- Cats Eye Emerald
	[17703]="0:0:12:0:1:::0:0:", -- Celebrian Diamond
	[17702]="0:0:12:0:1:::0:0:", -- Celebrian Rod
	[11511]="0:0:12:0:1:::0:0:", -- Cenarion Beacon
	[15710]="0:0:12:0:1:::0:0:", -- Cenarion Lunardust
	[15208]="0:0:12:0:1:::0:0:", -- Cenarion Moondust
	[11516]="0:0:12:0:100:::0:0:", -- Cenarion Plant Salve
	[5030]="0:0:12:0:20:::0:0:", -- Centaur Bracers
	[6067]="0:0:12:0:20:::0:0:", -- Centaur Ear
	[8587]="0:0:12:0:20:::0:0:", -- Centipaar Insect Parts
	[4645]="0:0:12:0:1:::0:0:", -- Chains of Hematus
	[7249]="0:0:12:0:20:::0:0:", -- Charged Rift Gem
	[18749]="0:0:12:0:1:::0:0:", -- Charger's Lost Soul
	[18799]="0:0:12:0:1:::0:0:", -- Charger's Redeemed Soul
	[6839]="0:0:12:0:20:::0:0:", -- Charred Horn
	[4926]="0:0:12:0:1:::0:0:", -- Chen's Empty Keg
	[10459]="0:0:12:0:1:::0:0:", -- Chief Sharptusk Thornmantle's Head
	[2476]="0:0:12:0:20:::0:0:", -- Chilled Basilisk Haunch
	[12434]="0:0:12:0:20:::0:0:", -- Chillwind E'ko
	[12623]="0:0:12:0:10:::0:0:", -- Chillwind Meat
	[2561]="0:0:12:0:1:::0:0:", -- Chok'sul's Head
	[3926]="0:0:12:0:1:::0:0:", -- Chucky's Huge Ring
	[6145]="0:0:12:0:1:::0:0:", -- Clarice's Pendant
	[5690]="0:0:12:0:1:::0:0:", -- Claw Key
	[12642]="0:0:12:0:1:::0:0:", -- Cleansed Infernal Orb
	[5218]="0:0:12:0:1:::0:0:", -- Cleansed Timberling Heart
	[3521]="0:0:12:0:1:::0:0:", -- Cleverly Encrypted Letter
	[12349]="0:0:12:0:1:::0:0:", -- Cliffspring River Sample
	[13507]="0:0:12:0:1:::0:0:", -- Cliffwatcher Longhorn Report
	[2724]="0:0:12:0:1:::0:0:", -- Cloth Request
	[5869]="0:0:12:0:1:::0:0:", -- Cloven Hoof
	[15448]="0:0:12:0:1:::0:0:", -- Coagulated Rot
	[17693]="0:0:12:0:1:::0:0:", -- Coated Cerulean Vial
	[4846]="0:0:12:0:1:::0:0:", -- Cog #5
	[14647]="0:0:12:0:1:::0:0:", -- Coldridge Valley Gift Voucher
	[12241]="0:0:12:0:20:::0:0:", -- Collected Dragon Egg
	[12287]="0:0:12:0:1:::0:0:", -- Collectronic Module
	[6313]="0:0:12:0:1:::0:0:", -- Comar's Heart
	[5535]="0:0:12:0:1:::0:0:", -- Compendium of the Fallen
	[9570]="0:0:12:0:1:::0:0:", -- Consecrated Letter
	[9563]="0:0:12:0:1:::0:0:", -- Consecrated Rune
	[5088]="0:0:12:0:1:::0:0:", -- Control Console Operating Manual
	[18412]="0:0:12:0:1:::0:0:", -- Core Fragment
	[4613]="0:0:12:0:1:::0:0:", -- Corroded Black Box
	[5664]="0:0:12:0:20:::0:0:", -- Corroded Shrapnel
	[5681]="0:0:12:0:1:::0:0:", -- Corrosive Sap
	[7812]="0:0:12:0:1:::0:0:", -- Corrupt Manifestation's Bracers
	[12907]="0:0:12:0:1:::0:0:", -- Corrupt Moonwell Water
	[5952]="0:0:12:0:20:::0:0:", -- Corrupted Brain Stem
	[12234]="0:0:12:0:20:::0:0:", -- Corrupted Felwood Sample
	[5389]="0:0:12:0:1:::0:0:", -- Corrupted Furbolg Totem
	[6995]="0:0:12:0:1:::0:0:", -- Corrupted Kor Gem
	[4056]="0:0:12:0:1:::0:0:", -- Cortello's Riddle
	[4802]="0:0:12:0:20:::0:0:", -- Cougar Claws
	[5585]="0:0:12:0:20:::0:0:", -- Courser Eye
	[5737]="0:0:12:0:1:::0:0:", -- Covert Ops Plans: Alpha & Beta
	[6166]="0:0:12:0:20:::0:0:", -- Coyote Jawbone
	[5877]="0:0:12:0:1:::0:0:", -- Cracked Silithid Carapace
	[7846]="0:0:12:0:20:::0:0:", -- Crag Coyote Fang
	[5849]="0:0:12:0:1:::0:0:", -- Crate of Crash Helmets
	[11113]="0:0:12:0:1:::0:0:", -- Crate of Foodstuffs
	[15848]="0:0:12:0:1:::0:0:", -- Crate of Ghost Magnets
	[9462]="0:0:12:0:1:::0:0:", -- Crate of Grimtotem Horns
	[1284]="0:0:12:0:1:::0:0:", -- Crate of Horseshoes
	[7646]="0:0:12:0:1:::0:0:", -- Crate of Inn Supplies
	[2712]="0:0:12:0:1:::0:0:", -- Crate of Lightforge Ingots
	[6091]="0:0:12:0:1:::0:0:", -- Crate of Power Stones
	[5385]="0:0:12:0:20:::0:0:", -- Crawler Leg
	[4888]="0:0:12:0:20:::0:0:", -- Crawler Mucus
	[3477]="0:0:12:0:1:::0:0:", -- Creeper Ichor
	[13351]="0:0:12:0:1:::0:0:", -- Crimson Hammersmith's Apron
	[2925]="0:0:12:0:20:::0:0:", -- Crocolisk Skin
	[2939]="0:0:12:0:1:::0:0:", -- Crocolisk Tear
	[12708]="0:0:12:0:1:::0:0:", -- Crossroads' Supply Crates
	[3554]="0:0:12:0:1:::0:0:", -- Crown of Will
	[6079]="0:0:12:0:20:::0:0:", -- Crude Charm
	[2611]="0:0:12:0:20:::0:0:", -- Crude Flint
	[6069]="0:0:12:0:20:::0:0:", -- Crudely Dried Meat
	[12842]="0:0:12:0:1:::0:0:", -- Crudely-written Log
	[4519]="0:0:12:0:1:::0:0:", -- Crumpled Scroll Fragment
	[1256]="0:0:12:0:20:::0:0:", -- Crystal Kelp Frond
	[5185]="0:0:12:0:1:::0:0:", -- Crystal Phial
	[11482]="0:0:12:0:1:::0:0:", -- Crystal Pylon User's Manual
	[5675]="0:0:12:0:20:::0:0:", -- Crystalized Scales
	[10714]="0:0:12:0:20:::0:0:", -- Crystallized Azsharite
	[10712]="0:0:12:0:1:::0:0:", -- Cuely's Elixir
	[9275]="0:0:12:0:1:::0:0:", -- Cuergo's Key
	[9254]="0:0:12:0:1:::0:0:", -- Cuergo's Treasure Map
	[15826]="0:0:12:0:1:::0:0:", -- Curative Animal Salve
	[1325]="0:0:12:0:1:::0:0:", -- Daffodil Bouquet
	[3509]="0:0:12:0:20:::0:0:", -- Daggerspine Scale
	[5544]="0:0:12:0:1:::0:0:", -- Dal Bloodclaw's Skull
	[7293]="0:0:12:0:20:::0:0:", -- Dalaran Mana Gem
	[3354]="0:0:12:0:20:::0:0:", -- Dalaran Pendant
	[7309]="0:0:12:0:1:::0:0:", -- Dalaran Status Report
	[6312]="0:0:12:0:1:::0:0:", -- Dalin's Heart
	[12739]="0:0:12:0:1:::0:0:", -- Dalson Cabinet Key
	[12738]="0:0:12:0:1:::0:0:", -- Dalson Outhouse Key
	[13195]="0:0:12:0:1:::0:0:", -- Dalson's Tears Cauldron Key
	[3082]="0:0:12:0:1:::0:0:", -- Dargol's Skull
	[11468]="0:0:12:0:20:::0:0:", -- Dark Iron Fanny Pack
	[18945]="0:0:12:0:100:::0:0:", -- Dark Iron Residue
	[6847]="0:0:12:0:1:::0:0:", -- Dark Iron Script
	[2858]="0:0:12:0:20:::0:0:", -- Darkhound Blood
	[18880]="0:0:12:0:1:::0:0:", -- Darkreaver's Head
	[3157]="0:0:12:0:20:::0:0:", -- Darksoul Shackle
	[18146]="0:0:12:0:100:::0:0:", -- Darkspear Troll Mojo
	[12358]="0:0:12:0:1:::0:0:", -- Darkstone Tablet
	[3701]="0:0:12:0:1:::0:0:", -- Darthalia's Sealed Commendation
	[5462]="0:0:12:0:1:::0:0:", -- Dartol's Rod of Transformation
	[12954]="0:0:12:0:1:::0:0:", -- Davil's Libram
	[12368]="0:0:12:0:1:::0:0:", -- Dawn's Gambit
	[6783]="0:0:12:0:1:::0:0:", -- Dead-tooth's Key
	[5945]="0:0:12:0:1:::0:0:", -- Deadmire's Tooth
	[5270]="0:0:12:0:20:::0:0:", -- Death Cap
	[14651]="0:0:12:0:1:::0:0:", -- Deathknell Gift Voucher
	[3252]="0:0:12:0:1:::0:0:", -- Deathstalker Report
	[3518]="0:0:12:0:1:::0:0:", -- Decrypted Letter
	[4429]="0:0:12:0:1:::0:0:", -- Deepfury's Orders
	[5570]="0:0:12:0:20:::0:0:", -- Deepmoss Egg
	[6082]="0:0:12:0:1:::0:0:", -- Deepstrider Tumor
	[5918]="0:0:12:0:1:::0:0:", -- Defiant Orc Head
	[5947]="0:0:12:0:1:::0:0:", -- Defias Docket
	[6846]="0:0:12:0:1:::0:0:", -- Defias Script
	[7675]="0:0:12:0:1:::0:0:", -- Defias Shipping Schedule
	[7269]="0:0:12:0:1:::0:0:", -- Deino's Flask
	[3234]="0:0:12:0:1:::0:0:", -- Deliah's Ring
	[5802]="0:0:12:0:1:::0:0:", -- Delicate Car Parts
	[7674]="0:0:12:0:1:::0:0:", -- Delivery to Mathias
	[13542]="0:0:12:0:1:::0:0:", -- Demon Box
	[14523]="0:0:12:0:1:::0:0:", -- Demon Pick
	[8009]="0:0:12:0:20:::0:0:", -- Dentrium Power Stone
	[6443]="0:0:12:0:20:::0:0:", -- Deviate Hide
	[2831]="0:0:12:0:1:::0:0:", -- Devlin's Remains
	[4845]="0:0:12:0:1:::0:0:", -- Diamond Runestone
	[5059]="0:0:12:0:1:::0:0:", -- Digging Claw
	[11114]="0:0:12:0:20:::0:0:", -- Dinosaur Bone
	[6625]="0:0:12:0:1:::0:0:", -- Dirt-caked Pendant
	[4851]="0:0:12:0:1:::0:0:", -- Dirt-stained Map
	[2843]="0:0:12:0:20:::0:0:", -- Dirty Knucklebones
	[2609]="0:0:12:0:1:::0:0:", -- Disarming Colloid
	[2610]="0:0:12:0:1:::0:0:", -- Disarming Mixture
	[11462]="0:0:12:0:1:::0:0:", -- Discarded Knife
	[17309]="0:0:12:0:20:::0:0:", -- Discordant Bracers
	[18746]="0:0:12:0:1:::0:0:", -- Divination Scryer
	[5455]="0:0:12:0:1:::0:0:", -- Divined Scroll
	[5456]="0:0:12:0:1:::0:0:", -- Divining Scroll
	[3897]="0:0:12:0:1:::0:0:", -- Dizzy's Eye
	[6626]="0:0:12:0:1:::0:0:", -- Dogran's Pendant
	[13702]="0:0:12:0:20:::0:0:", -- Doom Weed
	[12352]="0:0:12:0:1:::0:0:", -- Doomrigger's Clasp
	[6252]="0:0:12:0:20:::0:0:", -- Doomwarder Blood
	[12284]="0:0:12:0:1:::0:0:", -- Draco-Incarcinatrix 900
	[6071]="0:0:12:0:20:::0:0:", -- Draenethyst Crystal
	[6190]="0:0:12:0:1:::0:0:", -- Draenethyst Shard
	[7131]="0:0:12:0:20:::0:0:", -- Dragonmaw Shinbone
	[3337]="0:0:12:0:20:::0:0:", -- Dragonmaw War Banner
	[8685]="0:0:12:0:1:::0:0:", -- Dran's Ripple Delivery
	[10445]="0:0:12:0:1:::0:0:", -- Drawing Kit
	[5068]="0:0:12:0:1:::0:0:", -- Dried Seeds
	[16888]="0:0:12:0:1:::0:0:", -- Dull Drakefire Amulet
	[10439]="0:0:12:0:1:::0:0:", -- Durnan's Scalding Mornbrew
	[4892]="0:0:12:0:20:::0:0:", -- Durotar Tiger Fur
	[2876]="0:0:12:0:20:::0:0:", -- Duskbat Pelt
	[3264]="0:0:12:0:20:::0:0:", -- Duskbat Wing
	[2250]="0:0:12:0:1:::0:1:797", -- Dusky Crab Cakes
	[5669]="0:0:12:0:1:::0:0:", -- Dust Devil Debris
	[3339]="0:0:12:0:1:::0:0:", -- Dwarven Tinder
	[3639]="0:0:12:0:1:::0:0:", -- Ear of Balgaras
	[1410]="0:0:12:0:1:::0:0:", -- Ebonlocke's Response to Solomon
	[5100]="0:0:12:0:1:::0:0:", -- Echeyakee's Hide
	[13354]="0:0:12:0:20:::0:0:", -- Ectoplasmic Resonator
	[9528]="0:0:12:0:1:::0:0:", -- Edana's Dark Heart
	[6285]="0:0:12:0:1:::0:0:", -- Egalin's Grimoire
	[13289]="0:0:12:0:1:::0:0:", -- Egan's Blaster
	[8647]="0:0:12:0:1:::0:0:", -- Egg Crate
	[10465]="0:0:12:0:1:::0:0:", -- Egg of Hakkar
	[12286]="0:0:12:0:1:::0:0:", -- Eggscilloscope Prototype
	[4105]="0:0:12:0:20:::0:0:", -- Elder Crocolisk Skin
	[4473]="0:0:12:0:1:::0:0:", -- Eldritch Shackles
	[6718]="0:0:12:0:20:::0:0:", -- Electropeller
	[17126]="0:0:12:0:1:::0:0:", -- Elegant Letter
	[11267]="0:0:12:0:1:::0:0:", -- Elemental Shard Sample
	[3497]="0:0:12:0:1:::0:0:", -- Elixir of Pain
	[3495]="0:0:12:0:1:::0:0:", -- Elixir of Suffering
	[5493]="0:0:12:0:1:::0:0:", -- Elune's Tear
	[6808]="0:0:12:0:20:::0:0:", -- Elunite Ore
	[6809]="0:0:12:0:1:::0:0:", -- Elura's Medallion
	[4492]="0:0:12:0:20:::0:0:", -- Elven Gem
	[4493]="0:0:12:0:1:::0:0:", -- Elven Gems
	[2834]="0:0:12:0:20:::0:0:", -- Embalming Ichor
	[7767]="0:0:12:0:1:::0:0:", -- Empty Blue Waterskin
	[7766]="0:0:12:0:1:::0:0:", -- Empty Brown Waterskin
	[12346]="0:0:12:0:1:::0:0:", -- Empty Cleansing Bowl
	[15844]="0:0:12:0:1:::0:0:", -- Empty Cliffspring Falls Sampler
	[13187]="0:0:12:0:1:::0:0:", -- Empty Dalson's Tears Bottle
	[15842]="0:0:12:0:1:::0:0:", -- Empty Dreadmist Peak Sampler
	[13186]="0:0:12:0:1:::0:0:", -- Empty Felstone Field Bottle
	[12771]="0:0:12:0:1:::0:0:", -- Empty Firewater Flask
	[13189]="0:0:12:0:1:::0:0:", -- Empty Gahrron's Withering Bottle
	[9283]="0:0:12:0:1:::0:0:", -- Empty Leaden Collection Phial
	[7768]="0:0:12:0:1:::0:0:", -- Empty Red Waterskin
	[12350]="0:0:12:0:1:::0:0:", -- Empty Sampling Tube
	[15042]="0:0:12:0:1:::0:0:", -- Empty Termite Jar
	[7866]="0:0:12:0:1:::0:0:", -- Empty Thaumaturgy Vessel
	[14338]="0:0:12:0:1:::0:0:", -- Empty Water Tube
	[16974]="0:0:12:0:1:::0:0:", -- Empty Water Vial
	[12262]="0:0:12:0:1:::0:0:", -- Empty Worg Pup Cage
	[13188]="0:0:12:0:1:::0:0:", -- Empty Writhing Haunt Bottle
	[12288]="0:0:12:0:1:::0:0:", -- Encased Corrupt Ooze
	[11230]="0:0:12:0:1:::0:0:", -- Encased Fiery Essence
	[4529]="0:0:12:0:1:::0:0:", -- Enchanted Agate
	[16208]="0:0:12:0:1:::0:0:", -- Enchanted Gaea Seeds
	[16603]="0:0:12:0:1:::0:0:", -- Enchanted Resonite Crystal
	[12734]="0:0:12:0:10:::0:0:", -- Enchanted Scarlet Thread
	[9589]="0:0:12:0:20:::0:0:", -- Encrusted Minerals
	[17346]="0:0:12:0:1:::0:0:", -- Encrusted Silithid Object
	[5796]="0:0:12:0:20:::0:0:", -- Encrusted Tail Fin
	[9555]="0:0:12:0:1:::0:0:", -- Encrypted Letter
	[9558]="0:0:12:0:1:::0:0:", -- Encrypted Memorandum
	[9560]="0:0:12:0:1:::0:0:", -- Encrypted Parchment
	[9550]="0:0:12:0:1:::0:0:", -- Encrypted Rune
	[9559]="0:0:12:0:1:::0:0:", -- Encrypted Scroll
	[9551]="0:0:12:0:1:::0:0:", -- Encrypted Sigil
	[9554]="0:0:12:0:1:::0:0:", -- Encrypted Tablet
	[3706]="0:0:12:0:1:::0:0:", -- Ensorcelled Parchment
	[11617]="0:0:12:0:1:::0:0:", -- Eridan's Supplies
	[11682]="0:0:12:0:1:::0:0:", -- Eridan's Vial
	[3622]="0:0:12:0:1:::0:0:", -- Essence of Nightlash
	[11129]="0:0:12:0:20:::0:0:", -- Essence of the Elements
	[9278]="0:0:12:0:20:::0:0:", -- Essential Artificial
	[9565]="0:0:12:0:1:::0:0:", -- Etched Note
	[9553]="0:0:12:0:1:::0:0:", -- Etched Parchment
	[5867]="0:0:12:0:1:::0:0:", -- Etched Phial
	[9566]="0:0:12:0:1:::0:0:", -- Etched Rune
	[9567]="0:0:12:0:1:::0:0:", -- Etched Sigil
	[9564]="0:0:12:0:1:::0:0:", -- Etched Tablet
	[11024]="0:0:12:0:1:::0:0:", -- Evergreen Herb Casing
	[15788]="0:0:12:0:1:::0:0:", -- Everlook Report
	[11242]="0:0:12:0:1:::0:0:", -- Evoroot
	[6658]="0:0:12:0:1:::0:0:", -- Example Collar
	[18752]="0:0:12:0:1:::0:0:", -- Exorcism Censer
	[5021]="0:0:12:0:1:::0:0:", -- Explosive Stick of Gann
	[13202]="0:0:12:0:1:::0:0:", -- Extended Annals of Darrowshire
	[4903]="0:0:12:0:1:::0:0:", -- Eye of Burning Shadow
	[11753]="0:0:12:0:1:::0:0:", -- Eye of Kajal
	[17322]="0:0:12:0:1:::0:0:", -- Eye of the Emberseer
	[11108]="0:0:12:0:1:::0:0:", -- Faded Photograph
	[1956]="0:0:12:0:1:::0:0:", -- Faded Shadowhide Pendant
	[9596]="0:0:12:0:20:::0:0:", -- Faerie Dragon Muisek
	[9620]="0:0:12:0:1:::0:0:", -- Faerie Dragon Muisek Vessel
	[4517]="0:0:12:0:1:::0:0:", -- Falconcrest's Head
	[5508]="0:0:12:0:1:::0:0:", -- Fallen Moonstone
	[5390]="0:0:12:0:1:::0:0:", -- Fandral's Message
	[3876]="0:0:12:0:1:::0:0:", -- Fang of Bhag'thera
	[3627]="0:0:12:0:1:::0:0:", -- Fang of Vagash
	[3632]="0:0:12:0:1:::0:0:", -- Fangore's Paw
	[9436]="0:0:12:0:1:::0:0:", -- Faranell's Parcel
	[5831]="0:0:12:0:1:::0:0:", -- Fardel's Head
	[3721]="0:0:12:0:1:::0:0:", -- Farren's Report
	[16762]="0:0:12:0:1:::0:0:", -- Fathom Core
	[6753]="0:0:12:0:20:::0:0:", -- Feather Charm
	[3418]="0:0:12:0:20:::0:0:", -- Fel Cone
	[18626]="0:0:12:0:1:::0:0:", -- Fel Fire
	[3297]="0:0:12:0:20:::0:0:", -- Fel Moss
	[10831]="0:0:12:0:1:::0:0:", -- Fel Orb
	[10832]="0:0:12:0:1:::0:0:", -- Fel Tracker Owner's Manual
	[12647]="0:0:12:0:1:::0:0:", -- Felhas Ruby
	[6250]="0:0:12:0:20:::0:0:", -- Felhound Brain
	[10438]="0:0:12:0:1:::0:0:", -- Felix's Box
	[16314]="0:0:12:0:1:::0:0:", -- Felix's Bucket of Bolts
	[16313]="0:0:12:0:1:::0:0:", -- Felix's Chest
	[12445]="0:0:12:0:1:::0:0:", -- Felnok's Package
	[6640]="0:0:12:0:20:::0:0:", -- Felstalker Hoof
	[13194]="0:0:12:0:1:::0:0:", -- Felstone Field Cauldron Key
	[18501]="0:0:12:0:1:::0:0:", -- Felvine Shard
	[12230]="0:0:12:0:20:::0:0:", -- Felwood Slime Sample
	[7306]="0:0:12:0:1:::0:0:", -- Fenwick's Head
	[9331]="0:0:12:0:1:::0:0:", -- Feralas: A History
	[13157]="0:0:12:0:20:::0:0:", -- Fetid Skull
	[6181]="0:0:12:0:20:::0:0:", -- Fetish of Hakkar
	[5583]="0:0:12:0:20:::0:0:", -- Fey Dragon Scale
	[12740]="0:0:12:0:1:::0:0:", -- Fifth Mosh'aru Tablet
	[18151]="0:0:12:0:1:::0:0:", -- Filled Amethyst Phial
	[7770]="0:0:12:0:1:::0:0:", -- Filled Blue Waterskin
	[7769]="0:0:12:0:1:::0:0:", -- Filled Brown Waterskin
	[17696]="0:0:12:0:1:::0:0:", -- Filled Cerulean Vial
	[12347]="0:0:12:0:1:::0:0:", -- Filled Cleansing Bowl
	[15845]="0:0:12:0:1:::0:0:", -- Filled Cliffspring Falls Sampler
	[7292]="0:0:12:0:20:::0:0:", -- Filled Containment Coffer
	[5184]="0:0:12:0:1:::0:0:", -- Filled Crystal Phial
	[11947]="0:0:12:0:20:::0:0:", -- Filled Cursed Ooze Jar
	[13191]="0:0:12:0:1:::0:0:", -- Filled Dalson's Tears Bottle
	[15843]="0:0:12:0:1:::0:0:", -- Filled Dreadmist Peak Sampler
	[10662]="0:0:12:0:1:::0:0:", -- Filled Egg of Hakkar
	[5868]="0:0:12:0:1:::0:0:", -- Filled Etched Phial
	[13190]="0:0:12:0:1:::0:0:", -- Filled Felstone Field Bottle
	[12567]="0:0:12:0:1:::0:0:", -- Filled Flasket
	[13193]="0:0:12:0:1:::0:0:", -- Filled Gahrron's Withering Bottle
	[5639]="0:0:12:0:1:::0:0:", -- Filled Jade Phial
	[11954]="0:0:12:0:20:::0:0:", -- Filled Pure Sample Jar
	[7771]="0:0:12:0:1:::0:0:", -- Filled Red Waterskin
	[3913]="0:0:12:0:1:::0:0:", -- Filled Soul Gem
	[11949]="0:0:12:0:20:::0:0:", -- Filled Tainted Ooze Jar
	[5645]="0:0:12:0:1:::0:0:", -- Filled Tourmaline Phial
	[5188]="0:0:12:0:1:::0:0:", -- Filled Vessel
	[10691]="0:0:12:0:1:::0:0:", -- Filled Vial Labeled #1
	[10692]="0:0:12:0:1:::0:0:", -- Filled Vial Labeled #2
	[10693]="0:0:12:0:1:::0:0:", -- Filled Vial Labeled #3
	[10694]="0:0:12:0:1:::0:0:", -- Filled Vial Labeled #4
	[13192]="0:0:12:0:1:::0:0:", -- Filled Writhing Haunt Bottle
	[1362]="0:0:12:0:1:::0:0:", -- Final Clue to Sander's Treasure
	[12237]="0:0:12:0:20:::0:0:", -- Fine Crab Chunks
	[12293]="0:0:12:0:1:::0:0:", -- Fine Gold Thread
	[5386]="0:0:12:0:20:::0:0:", -- Fine Moonstalker Pelt
	[5026]="0:0:12:0:1:::0:1:181,218,459,503", -- Fire Tar
	[9246]="0:0:12:0:1:::0:0:", -- Firebeard's Head
	[10660]="0:0:12:0:1:::0:0:", -- First Mosh'aru Tablet
	[12896]="0:0:12:0:1:::0:0:", -- First Relic Fragment
	[4819]="0:0:12:0:1:::0:0:", -- Fizsprocket's Clipboard
	[5827]="0:0:12:0:1:::0:0:", -- Fizzle Brassbolts' Letter
	[4869]="0:0:12:0:1:::0:0:", -- Fizzle's Claw
	[8066]="0:0:12:0:1:::0:0:", -- Fizzule's Whistle
	[5234]="0:0:12:0:1:::0:0:", -- Flagongut's Fossil
	[12814]="0:0:12:0:1:::0:0:", -- Flame in a Bottle
	[8051]="0:0:12:0:1:::0:0:", -- Flare Gun
	[12813]="0:0:12:0:1:::0:0:", -- Flask of Mystery Goo
	[4805]="0:0:12:0:1:::0:0:", -- Flatland Cougar Femur
	[5203]="0:0:12:0:20:::0:0:", -- Flatland Prowler Claw
	[4986]="0:0:12:0:1:::0:0:", -- Flawed Power Stone
	[18624]="0:0:12:0:1:::0:0:", -- Flawless Fel Essence (Azshara)
	[18623]="0:0:12:0:1:::0:0:", -- Flawless Fel Essence (Dark Portal)
	[18622]="0:0:12:0:1:::0:0:", -- Flawless Fel Essence (Jaedenar)
	[7271]="0:0:12:0:20:::0:0:", -- Flawless Ivory Tusk
	[6766]="0:0:12:0:1:::0:0:", -- Flayed Demon Skin
	[11445]="0:0:12:0:1:::0:0:", -- Flute of the Ancients
	[11668]="0:0:12:0:1:::0:0:", -- Flute of Xavaric
	[5806]="0:0:12:0:1:::0:0:", -- Fool's Stout
	[5807]="0:0:12:0:1:::0:0:", -- Fool's Stout Report
	[3718]="0:0:12:0:1:::0:0:", -- Foreboding Plans
	[16114]="0:0:12:0:1:::0:0:", -- Foreman's Blackjack
	[12324]="0:0:12:0:1:::0:0:", -- Forged Seal of Ascension
	[6534]="0:0:12:0:1:::0:0:", -- Forged Steel Bars
	[5883]="0:0:12:0:20:::0:0:", -- Forked Mudrock Tongue
	[18147]="0:0:12:0:100:::0:0:", -- Forsaken Heart
	[12412]="0:0:12:0:1:::0:0:", -- Fourth Mosh'aru Tablet
	[12899]="0:0:12:0:1:::0:0:", -- Fourth Relic Fragment
	[11266]="0:0:12:0:20:::0:0:", -- Fractured Elemental Shard
	[11471]="0:0:12:0:1:::0:0:", -- Fragile Sprite Darter Egg
	[16662]="0:0:12:0:1:::0:0:", -- Fragment of the Dragon's Eye
	[5844]="0:0:12:0:1:::0:0:", -- Fragments of Rok'Alim
	[5810]="0:0:12:0:1:::0:0:", -- Fresh Carcass
	[10338]="0:0:12:0:1:::0:0:", -- Fresh Zhevra Carcass
	[12436]="0:0:12:0:20:::0:0:", -- Frostmaul E'ko
	[12334]="0:0:12:0:20:::0:0:", -- Frostmaul Shards
	[5811]="0:0:12:0:1:::0:0:", -- Frostmaw's Mane
	[12430]="0:0:12:0:20:::0:0:", -- Frostsaber E'ko
	[12736]="0:0:12:0:10:::0:0:", -- Frostwhisper's Embalming Fluid
	[17504]="0:0:12:0:100:::0:0:", -- Frostwolf Commander's Medal
	[17643]="0:0:12:0:100:::0:0:", -- Frostwolf Hide
	[17503]="0:0:12:0:100:::0:0:", -- Frostwolf Lieutenant's Medal
	[17502]="0:0:12:0:100:::0:0:", -- Frostwolf Soldier's Medal
	[5852]="0:0:12:0:1:::0:0:", -- Fuel Regulator Blueprints
	[9284]="0:0:12:0:1:::0:0:", -- Full Leaden Collection Phial
	[5012]="0:0:12:0:20:::0:0:", -- Fungal Spores
	[1971]="0:0:12:0:1:::0:0:", -- Furlbrow's Deed
	[841]="0:0:12:0:1:::0:0:", -- Furlbrow's Pocket Watch
	[9323]="0:0:12:0:1:::0:0:", -- Gadrin's Parchment
	[16205]="0:0:12:0:10:::0:0:", -- Gaea Seed
	[6717]="0:0:12:0:20:::0:0:", -- Gaffer Jack
	[13196]="0:0:12:0:1:::0:0:", -- Gahrron's Withering Cauldron Key
	[9978]="0:0:12:0:1:::0:0:", -- Gahz'ridian Detector
	[8443]="0:0:12:0:20:::0:0:", -- Gahz'ridian Ornament
	[8707]="0:0:12:0:1:::0:0:", -- Gahz'rilla's Electrified Scale
	[8074]="0:0:12:0:1:::0:0:", -- Gallywix's Head
	[6840]="0:0:12:0:20:::0:0:", -- Galvanized Horn
	[3904]="0:0:12:0:1:::0:0:", -- Gan'zulah's Head
	[8136]="0:0:12:0:1:::0:0:", -- Gargantuan Tumor
	[8026]="0:0:12:0:1:::0:0:", -- Garrett Family Treasure
	[182]="0:0:12:0:1:::0:0:", -- Garrick's Head
	[5687]="0:0:12:0:1:::0:0:", -- Gatekeeper's Key
	[18336]="0:0:12:0:1:::0:0:", -- Gauntlet of Gordok Might
	[5080]="0:0:12:0:10:::0:0:", -- Gazlowe's Ledger
	[9739]="0:0:12:0:20:::0:0:", -- Gem of Anacondra
	[9738]="0:0:12:0:20:::0:0:", -- Gem of Cobrahn
	[9740]="0:0:12:0:20:::0:0:", -- Gem of Pythas
	[9741]="0:0:12:0:20:::0:0:", -- Gem of Serpentis
	[17765]="0:0:12:0:1:::0:0:", -- Gem of the Fifth Kahn
	[17761]="0:0:12:0:1:::0:0:", -- Gem of the First Kahn
	[17764]="0:0:12:0:1:::0:0:", -- Gem of the Fourth Kahn
	[17762]="0:0:12:0:1:::0:0:", -- Gem of the Second Kahn
	[15766]="0:0:12:0:1:::0:0:", -- Gem of the Serpent
	[17763]="0:0:12:0:1:::0:0:", -- Gem of the Third Kahn
	[12780]="0:0:12:0:1:::0:0:", -- General Drakkisath's Command
	[5736]="0:0:12:0:1:::0:0:", -- Gerenzo's Mechanical Arm
	[1518]="0:0:12:0:1:::0:0:", -- Ghost Hair Comb
	[1596]="0:0:12:0:1:::0:0:", -- Ghost Hair Thread
	[15849]="0:0:12:0:20:::0:0:", -- Ghost-o-plasm
	[1129]="0:0:12:0:20:::0:0:", -- Ghoul Fang
	[884]="0:0:12:0:20:::0:0:", -- Ghoul Rib
	[3348]="0:0:12:0:20:::0:0:", -- Giant Crocolisk Skin
	[3552]="0:0:12:0:1:::0:0:", -- Glommus's Head
	[12737]="0:0:12:0:20:::0:0:", -- Gloom Weed
	[18601]="0:0:12:0:1:::0:0:", -- Glowing Crystal Prison
	[6655]="0:0:12:0:1:::0:0:", -- Glowing Ember
	[5189]="0:0:12:0:1:::0:0:", -- Glowing Fruit
	[5463]="0:0:12:0:1:::0:0:", -- Glowing Gem
	[12710]="0:0:12:0:1:::0:0:", -- Glowing Hunk of the Beast's Flesh
	[1962]="0:0:12:0:1:::0:0:", -- Glowing Shadowhide Pendant
	[10441]="0:0:12:0:1:::0:0:", -- Glowing Shard
	[5366]="0:0:12:0:1:::0:0:", -- Glowing Soul Gem
	[3156]="0:0:12:0:20:::0:0:", -- Glutton Shackle
	[1083]="0:0:12:0:1:::0:0:", -- Glyph of Azora
	[12663]="0:0:12:0:1:::0:0:", -- Glyphed Oaken Branch
	[9571]="0:0:12:0:1:::0:0:", -- Glyphic Letter
	[9573]="0:0:12:0:1:::0:0:", -- Glyphic Memorandum
	[9574]="0:0:12:0:1:::0:0:", -- Glyphic Scroll
	[9575]="0:0:12:0:1:::0:0:", -- Glyphic Tablet
	[7464]="0:0:12:0:1:::0:0:", -- Glyphs of Summoning
	[5220]="0:0:12:0:20:::0:0:", -- Gnarlpine Fang
	[8049]="0:0:12:0:1:::0:0:", -- Gnarlpine Necklace
	[7740]="0:0:12:0:1:::0:0:", -- Gni'kiv Medallion
	[7365]="0:0:12:0:1:::0:0:", -- Gnoam Sprecklesprocket
	[725]="0:0:12:0:20:::0:0:", -- Gnoll Paw
	[10790]="0:0:12:0:1:::0:0:", -- Gnome Engineer Membership Card
	[4863]="0:0:12:0:20:::0:0:", -- Gnomish Tools
	[3618]="0:0:12:0:1:::0:0:", -- Gobbler's Head
	[10791]="0:0:12:0:1:::0:0:", -- Goblin Engineer Membership Card
	[5804]="0:0:12:0:1:::0:0:", -- Goblin Rumors
	[9173]="0:0:12:0:1:::0:0:", -- Goblin Transponder
	[4491]="0:0:12:0:1:::0:0:", -- Goggles of Gem Hunting
	[773]="0:0:12:0:20:::0:0:", -- Gold Dust
	[1307]="0:0:12:0:1:::0:0:", -- Gold Pickup Schedule
	[11179]="0:0:12:0:1:::0:0:", -- Golden Flame
	[10511]="0:0:12:0:4:::0:0:", -- Golem Oil
	[2660]="0:0:12:0:1:::0:0:", -- Golm Fragment
	[12723]="0:0:12:0:1:::0:0:", -- Good Luck Charm
	[12721]="0:0:12:0:1:::0:0:", -- Good Luck Half-Charm
	[12722]="0:0:12:0:1:::0:0:", -- Good Luck Other-Half-Charm
	[11727]="0:0:12:0:1:::0:0:", -- Goodsteel Ledger
	[11723]="0:0:12:0:1:::0:0:", -- Goodsteel's Balanced Flameberge
	[11080]="0:0:12:0:1:::0:0:", -- Gor'tesh's Lopped Off Head
	[16210]="0:0:12:0:1:::0:0:", -- Gordon's Crate
	[9463]="0:0:12:0:20:::0:0:", -- Gordunni Cobalt
	[9371]="0:0:12:0:1:::0:0:", -- Gordunni Orb
	[9370]="0:0:12:0:1:::0:0:", -- Gordunni Scroll
	[11835]="0:0:12:0:1:::0:0:", -- Gorishi Queen Brain
	[11833]="0:0:12:0:1:::0:0:", -- Gorishi Queen Lure
	[11837]="0:0:12:0:1:::0:0:", -- Gorishi Scent Gland
	[1252]="0:0:12:0:1:::0:0:", -- Gramma Stonefield's Note
	[11125]="0:0:12:0:1:::0:0:", -- Grape Manifest
	[3476]="0:0:12:0:20:::0:0:", -- Gray Bear Tongue
	[2756]="0:0:12:0:1:::0:0:", -- Green Hills of Stranglethorn - Chapter I
	[2757]="0:0:12:0:1:::0:0:", -- Green Hills of Stranglethorn - Chapter II
	[2758]="0:0:12:0:1:::0:0:", -- Green Hills of Stranglethorn - Chapter III
	[2759]="0:0:12:0:1:::0:0:", -- Green Hills of Stranglethorn - Chapter IV
	[11185]="0:0:12:0:10::164:0:0:", -- Green Power Crystal
	[2829]="0:0:12:0:1:::0:0:", -- Gregor's Remains
	[2004]="0:0:12:0:1:::0:0:", -- Grelin Whitebeard's Journal
	[2619]="0:0:12:0:1:::0:0:", -- Grelin's Report
	[5336]="0:0:12:0:20:::0:0:", -- Grell Earring
	[5843]="0:0:12:0:1:::0:0:", -- Grenka's Claw
	[9326]="0:0:12:0:1:::0:0:", -- Grime-Encrusted Ring
	[11818]="0:0:12:0:1:::0:0:", -- Grimsite Outhouse Key
	[9460]="0:0:12:0:20:::0:0:", -- Grimtotem Horn
	[14381]="0:0:12:0:1:::0:0:", -- Grimtotem Satchel
	[3253]="0:0:12:0:20:::0:0:", -- Grizzled Bear Heart
	[5414]="0:0:12:0:20:::0:0:", -- Grizzled Scalp
	[6259]="0:0:12:0:20:::0:0:", -- Groddoc Liver
	[16307]="0:0:12:0:1:::0:0:", -- Gryshka's Letter
	[3016]="0:0:12:0:1:::0:0:", -- Gunther's Spellbook
	[7442]="0:0:12:0:1:::0:0:", -- Gyromast's Key
	[3084]="0:0:12:0:20:::0:0:", -- Gyromechanic Gear
	[15883]="0:0:12:0:1:::0:0:", -- Half Pendant of Aquatic Agility
	[15882]="0:0:12:0:1:::0:0:", -- Half Pendant of Aquatic Endurance
	[9548]="0:0:12:0:1:::0:0:", -- Hallowed Letter
	[9556]="0:0:12:0:1:::0:0:", -- Hallowed Rune
	[9557]="0:0:12:0:1:::0:0:", -- Hallowed Sigil
	[9561]="0:0:12:0:1:::0:0:", -- Hallowed Tablet
	[15767]="0:0:12:0:1:::0:0:", -- Hameya's Key
	[4635]="0:0:12:0:1:::0:0:", -- Hammertoe's Amulet
	[4641]="0:0:12:0:1:::0:0:", -- Hand of Dagun
	[3628]="0:0:12:0:1:::0:0:", -- Hand of Dextren Ward
	[17331]="0:0:12:0:1:::0:0:", -- Hand of Gehennas
	[14547]="0:0:12:0:1:::0:0:", -- Hand of Iruxos
	[17329]="0:0:12:0:1:::0:0:", -- Hand of Lucifron
	[17332]="0:0:12:0:1:::0:0:", -- Hand of Shazzrah
	[17330]="0:0:12:0:1:::0:0:", -- Hand of Sulfuron
	[1528]="0:0:12:0:20:::0:0:", -- Handful of Oats
	[5494]="0:0:12:0:20:::0:0:", -- Handful of Stardust
	[12566]="0:0:12:0:1:::0:0:", -- Hardened Flasket
	[5795]="0:0:12:0:20:::0:0:", -- Hardened Tortoise Shell
	[3258]="0:0:12:0:1:::0:0:", -- Hardened Tumor
	[5065]="0:0:12:0:20:::0:0:", -- Harpy Lieutenant Ring
	[5138]="0:0:12:0:1:::0:0:", -- Harvester's Head
	[9247]="0:0:12:0:20:::0:0:", -- Hatecrest Naga Scale
	[6246]="0:0:12:0:20:::0:0:", -- Hatefury Claw
	[6247]="0:0:12:0:20:::0:0:", -- Hatefury Horn
	[13470]="0:0:12:0:1:::0:0:", -- Head of Alexi Barov
	[11268]="0:0:12:0:1:::0:0:", -- Head of Argelmach
	[5442]="0:0:12:0:1:::0:0:", -- Head of Arugal
	[13250]="0:0:12:0:1:::0:0:", -- Head of Balnazzar
	[3880]="0:0:12:0:1:::0:0:", -- Head of Bangalash
	[13251]="0:0:12:0:1:::0:0:", -- Head of Baron Rivendare
	[3626]="0:0:12:0:1:::0:0:", -- Head of Baron Vardus
	[2926]="0:0:12:0:1:::0:0:", -- Head of Bazil Thredd
	[3640]="0:0:12:0:1:::0:0:", -- Head of Deepfury
	[3633]="0:0:12:0:1:::0:0:", -- Head of Gath'Ilzogg
	[3634]="0:0:12:0:1:::0:0:", -- Head of Grimson
	[6212]="0:0:12:0:1:::0:0:", -- Head of Jammal'an
	[5881]="0:0:12:0:1:::0:0:", -- Head of Kelris
	[11222]="0:0:12:0:1:::0:0:", -- Head of Krom'zar
	[10447]="0:0:12:0:1:::0:0:", -- Head of Lathoric the Black
	[10597]="0:0:12:0:1:::0:0:", -- Head of Magus Rimtori
	[3672]="0:0:12:0:1:::0:0:", -- Head of Nagaz
	[18946]="0:0:12:0:1:::0:0:", -- Head of Overlord Maltorius
	[15880]="0:0:12:0:1:::0:0:", -- Head of Ramstein the Gorger
	[12630]="0:0:12:0:1:::0:0:", -- Head of Rend Blackhand
	[3630]="0:0:12:0:1:::0:0:", -- Head of Targorr
	[3637]="0:0:12:0:1:::0:0:", -- Head of VanCleef
	[13469]="0:0:12:0:1:::0:0:", -- Head of Weldon Barov
	[13920]="0:0:12:0:1:::0:0:", -- Healthy Dragon Scale
	[10509]="0:0:12:0:4:::0:0:", -- Heart of Flame
	[5104]="0:0:12:0:1:::0:0:", -- Heart of Isha Awak
	[2797]="0:0:12:0:1:::0:0:", -- Heart of Mokk
	[10446]="0:0:12:0:1:::0:0:", -- Heart of Obsidion
	[5805]="0:0:12:0:20:::0:0:", -- Heart of Zeal
	[6912]="0:0:12:0:1:::0:0:", -- Heartswood
	[6913]="0:0:12:0:1:::0:0:", -- Heartswood Core
	[9364]="0:0:12:0:1:::0:0:", -- Heavy Leaden Collection Phial
	[3708]="0:0:12:0:1:::0:0:", -- Helcular's Rod
	[11366]="0:0:12:0:1:::0:0:", -- Helendis Riverhorn's Letter
	[5791]="0:0:12:0:1:::0:0:", -- Henrig Lonebrow's Journal
	[10599]="0:0:12:0:1:::0:0:", -- Hetaera's Beaten Head
	[10610]="0:0:12:0:1:::0:0:", -- Hetaera's Blood
	[10598]="0:0:12:0:1:::0:0:", -- Hetaera's Bloodied Head
	[10600]="0:0:12:0:1:::0:0:", -- Hetaera's Bruised Head
	[9472]="0:0:12:0:1:::0:0:", -- Hexx's Key
	[5025]="0:0:12:0:1:::0:0:", -- Hezrul's Head
	[9365]="0:0:12:0:1:::0:0:", -- High Potency Radioactive Fallout
	[5360]="0:0:12:0:20:::0:0:", -- Highborne Relic
	[4512]="0:0:12:0:20:::0:0:", -- Highland Raptor Eye
	[5809]="0:0:12:0:20:::0:0:", -- Highperch Venom Sac
	[12356]="0:0:12:0:20:::0:0:", -- Highperch Wyvern Egg
	[10958]="0:0:12:0:1:::0:0:", -- Hilary's Necklace
	[3117]="0:0:12:0:1:::0:0:", -- Hildelve's Journal
	[3692]="0:0:12:0:20:::0:0:", -- Hillsbrad Human Skull
	[3657]="0:0:12:0:1:::0:0:", -- Hillsbrad Town Registry
	[8684]="0:0:12:0:20:::0:0:", -- Hinterlands Honey Ripple
	[9595]="0:0:12:0:20:::0:0:", -- Hippogryph Muisek
	[9619]="0:0:12:0:1:::0:0:", -- Hippogryph Muisek Vessel
	[11131]="0:0:12:0:1:::0:0:", -- Hive Wall Sample
	[5848]="0:0:12:0:20:::0:0:", -- Hollow Vulture Bone
	[737]="0:0:12:0:1:::0:0:", -- Holy Spring Water
	[16311]="0:0:12:0:1:::0:0:", -- Honorary Picks
	[5099]="0:0:12:0:1:::0:0:", -- Hoof of Lakota'mani
	[4841]="0:0:12:0:1:::0:0:", -- Horn of Arra'chea
	[13536]="0:0:12:0:1:::0:0:", -- Horn of Awakening
	[10327]="0:0:12:0:1:::0:0:", -- Horn of Echeyakee
	[9530]="0:0:12:0:1:::0:0:", -- Horn of Hatetalon
	[6805]="0:0:12:0:1:::0:0:", -- Horn of Vorlus
	[7906]="0:0:12:0:1:::0:0:", -- Horns of Nez'ra
	[1931]="0:0:12:0:1:::0:0:", -- Huge Gnoll Claw
	[13626]="0:0:12:0:1:::0:0:", -- Human Head of Ras Frostwhisper
	[3693]="0:0:12:0:1:::0:0:", -- Humbert's Sword
	[10639]="0:0:12:0:20:::0:0:", -- Hyacinth Mushroom
	[18299]="0:0:12:0:1:::0:0:", -- Hydrospawn Essence
	[12946]="0:0:12:0:1:::0:0:", -- Hypercapacitor Gizmo
	[12435]="0:0:12:0:20:::0:0:", -- Ice Thistle E'ko
	[5533]="0:0:12:0:1:::0:0:", -- Ilkrud Magthrull's Tome
	[9256]="0:0:12:0:1:::0:0:", -- Imbel Essence
	[14628]="0:0:12:0:1:::0:0:", -- Imbued Skeletal Fragments
	[18688]="0:0:12:0:1:::0:0:", -- Imp in a Jar
	[12562]="0:0:12:0:1:::0:0:", -- Important Blackrock Documents
	[18605]="0:0:12:0:1:::0:0:", -- Imprisoned Doomguard
	[12648]="0:0:12:0:1:::0:0:", -- Imprisoned Felhound Spirit
	[12649]="0:0:12:0:1:::0:0:", -- Imprisoned Infernal Spirit
	[14396]="0:0:12:0:1:::0:0:", -- Incantations from the Nether
	[12732]="0:0:12:0:20:::0:0:", -- Incendia Agave
	[12785]="0:0:12:0:1:::0:0:", -- Incendia Powder
	[18944]="0:0:12:0:100:::0:0:", -- Incendosaur Scale
	[16312]="0:0:12:0:10:::0:0:", -- Incendrites
	[5797]="0:0:12:0:20:::0:0:", -- Indurium Flake
	[7291]="0:0:12:0:1:::0:0:", -- Infernal Orb
	[12646]="0:0:12:0:1:::0:0:", -- Infus Emerald
	[6435]="0:0:12:0:20:::0:0:", -- Infused Burning Gem
	[5272]="0:0:12:0:1:::0:0:", -- Insane Scribbles
	[5219]="0:0:12:0:1:::0:0:", -- Inscribed Bark
	[8594]="0:0:12:0:1:::0:0:", -- Insect Analysis Report
	[13350]="0:0:12:0:1:::0:0:", -- Insignia of the Black Guard
	[12220]="0:0:12:0:20:::0:0:", -- Intact Elemental Bracer
	[11269]="0:0:12:0:10:::0:0:", -- Intact Elemental Core
	[4887]="0:0:12:0:20:::0:0:", -- Intact Makrura Eye
	[5055]="0:0:12:0:20:::0:0:", -- Intact Raptor Horn
	[5853]="0:0:12:0:20:::0:0:", -- Intact Silithid Carapace
	[12841]="0:0:12:0:250:::0:0:", -- Invader's Scourgestone
	[1257]="0:0:12:0:1:::0:0:", -- Invisibility Liquor
	[9369]="0:0:12:0:20:::0:0:", -- Iridescent Sprite Darter Wing
	[2856]="0:0:12:0:20:::0:0:", -- Iron Pike
	[5519]="0:0:12:0:1:::0:0:", -- Iron Pommel
	[1013]="0:0:12:0:20:::0:0:", -- Iron Rivet
	[5464]="0:0:12:0:1:::0:0:", -- Iron Shaft
	[2637]="0:0:12:0:1:::0:0:", -- Ironband's Progress Report
	[10999]="0:0:12:0:1:::0:0:", -- Ironfel
	[6258]="0:0:12:0:20:::0:0:", -- Ironfur Liver
	[11173]="0:0:12:0:1:::0:0:", -- Irontree Heart
	[5101]="0:0:12:0:1:::0:0:", -- Ishamuhale's Fang
	[3621]="0:0:12:0:1:::0:0:", -- Ivar's Head
	[10642]="0:0:12:0:1:::0:0:", -- Iverron's Antidote
	[5619]="0:0:12:0:1:::0:0:", -- Jade Phial
	[11674]="0:0:12:0:20:::0:0:", -- Jadefire Felbind
	[7680]="0:0:12:0:20:::0:0:", -- Jadespine Basilisk Scale
	[18642]="0:0:12:0:1:::0:0:", -- Jaina's Autograph
	[9236]="0:0:12:0:1:::0:0:", -- Jangdor's Letter
	[12724]="0:0:12:0:1:::0:0:", -- Janice's Parcel
	[7735]="0:0:12:0:1:::0:0:", -- Jannok's Rose
	[12891]="0:0:12:0:1:::0:0:", -- Jaron's Pick
	[12525]="0:0:12:0:1:::0:0:", -- Jaron's Supplies
	[7207]="0:0:12:0:1:::0:0:", -- Jennea's Flask
	[9368]="0:0:12:0:1:::0:0:", -- Jer'kai's Signet Ring
	[10680]="0:0:12:0:1:::0:0:", -- Jes'rimon's Note
	[5942]="0:0:12:0:1:::0:0:", -- Jeweled Pendant
	[2560]="0:0:12:0:1:::0:0:", -- Jitters' Completed Journal
	[3238]="0:0:12:0:1:::0:0:", -- Johaan's Findings
	[3460]="0:0:12:0:1:::0:0:", -- Johaan's Special Drink
	[3925]="0:0:12:0:1:::0:0:", -- Jon-Jon's Golden Spyglass
	[6992]="0:0:12:0:1:::0:0:", -- Jordan's Ore Shipment
	[6993]="0:0:12:0:1:::0:0:", -- Jordan's Refined Ore Shipment
	[6895]="0:0:12:0:1:::0:0:", -- Jordan's Smithing Hammer
	[6996]="0:0:12:0:1:::0:0:", -- Jordan's Weapon Notes
	[3863]="0:0:12:0:20:::0:0:", -- Jungle Stalker Feather
	[10622]="0:0:12:0:1:::0:0:", -- Kadrak's Flag
	[16972]="0:0:12:0:1:::0:0:", -- Karang's Banner
	[6245]="0:0:12:0:1:::0:0:", -- Karnitol's Satchel
	[13585]="0:0:12:0:1:::0:0:", -- Keepsake of Remembrance
	[3517]="0:0:12:0:1:::0:0:", -- Keg of Shindigger Stout
	[6624]="0:0:12:0:1:::0:0:", -- Ken'zigla's Draught
	[5830]="0:0:12:0:1:::0:0:", -- Kenata's Head
	[6065]="0:0:12:0:1:::0:0:", -- Khadgar's Essays on Dimensional Convergence
	[6066]="0:0:12:0:1:::0:0:", -- Khan Dez'hepah's Head
	[6072]="0:0:12:0:1:::0:0:", -- Khan Jehn's Head
	[6073]="0:0:12:0:1:::0:0:", -- Khan Shaka's Head
	[5006]="0:0:12:0:1:::0:0:", -- Khazgorm's Journal
	[10717]="0:0:12:0:1:::0:0:", -- Kim'Jael's Compass
	[10715]="0:0:12:0:1:::0:0:", -- Kim'Jael's Scope
	[10722]="0:0:12:0:1:::0:0:", -- Kim'Jael's Stuffed Chicken
	[10718]="0:0:12:0:1:::0:0:", -- Kim'Jael's Wizzlegoober
	[7908]="0:0:12:0:1:::0:0:", -- Klaven Mortwake's Journal
	[18923]="0:0:12:0:1:::0:0:", -- Klinfran's Head
	[15852]="0:0:12:0:20:::0:0:", -- Kodo Horn
	[13892]="0:0:12:0:1:::0:0:", -- Kodo Kombobulator
	[4896]="0:0:12:0:20:::0:0:", -- Kodo Liver
	[5838]="0:0:12:0:1:::0:0:", -- Kodo Skin Scroll
	[5846]="0:0:12:0:1:::0:0:", -- Korran's Sealed Note
	[12472]="0:0:12:0:1:::0:0:", -- Krakle's Thermometer
	[13725]="0:0:12:0:1:::0:0:", -- Krastinov's Bag of Horrors
	[5801]="0:0:12:0:20:::0:0:", -- Kraul Guano
	[5800]="0:0:12:0:1:::0:0:", -- Kravel's Parts
	[5799]="0:0:12:0:1:::0:0:", -- Kravel's Parts Order
	[5826]="0:0:12:0:1:::0:0:", -- Kravel's Scheme
	[4085]="0:0:12:0:1:::0:0:", -- Krazek's Crock Pot
	[1987]="0:0:12:0:1:::0:0:", -- Krazek's Fixed Pot
	[5063]="0:0:12:0:1:::0:0:", -- Kreenig Snarlsnout's Tusk
	[8027]="0:0:12:0:1:::0:0:", -- Krom Stoutarm's Treasure
	[4891]="0:0:12:0:1:::0:0:", -- Kron's Amulet
	[18625]="0:0:12:0:1:::0:0:", -- Kroshius' Infernal Core
	[3615]="0:0:12:0:1:::0:0:", -- Kurzen's Head
	[5074]="0:0:12:0:1:::0:0:", -- Kuz's Skull
	[3035]="0:0:12:0:1:::0:0:", -- Laced Pumpkin
	[8428]="0:0:12:0:1:::0:0:", -- Laden Dew Gland
	[9255]="0:0:12:0:1:::0:0:", -- Lahassa Essence
	[16263]="0:0:12:0:1:::0:0:", -- Laird's Response
	[3257]="0:0:12:0:20:::0:0:", -- Lake Creeper Moss
	[3256]="0:0:12:0:20:::0:0:", -- Lake Skulker Moss
	[11510]="0:0:12:0:1:::0:0:", -- Lar'korwi's Head
	[772]="0:0:12:0:20:::0:0:", -- Large Candle
	[11104]="0:0:12:0:1:::0:0:", -- Large Compass
	[4053]="0:0:12:0:20:::0:0:", -- Large River Crocolisk Skin
	[6915]="0:0:12:0:1:::0:0:", -- Large Soran'ruk Fragment
	[4627]="0:0:12:0:5:::0:0:", -- Large Stone Slab
	[7270]="0:0:12:0:20:::0:0:", -- Laughing Sister's Hair
	[6253]="0:0:12:0:1:::0:0:", -- Leftwitch's Package
	[5860]="0:0:12:0:1:::0:0:", -- Legacy of the Aspects
	[3516]="0:0:12:0:1:::0:0:", -- Lescovar's Head
	[6990]="0:0:12:0:1:::0:0:", -- Lesser Infernal Stone
	[18426]="0:0:12:0:1:::0:0:", -- Lethtendris's Web
	[5539]="0:0:12:0:1:::0:0:", -- Letter of Commendation
	[5354]="0:0:12:0:1:::0:0:", -- Letter to Delgren
	[1637]="0:0:12:0:1:::0:0:", -- Letter to Ello
	[5594]="0:0:12:0:1:::0:0:", -- Letter to Jin'Zil
	[5948]="0:0:12:0:1:::0:0:", -- Letter to Jorgen
	[15998]="0:0:12:0:1:::0:0:", -- Lewis' Note
	[3898]="0:0:12:0:1:::0:0:", -- Library Scrip
	[14544]="0:0:12:0:1:::0:0:", -- Lieutenant's Insignia
	[2702]="0:0:12:0:20:::0:0:", -- Lightforge Ingot
	[4898]="0:0:12:0:20:::0:0:", -- Lightning Gland
	[11162]="0:0:12:0:1:::0:0:", -- Linken's Superior Sword
	[11136]="0:0:12:0:1:::0:0:", -- Linken's Tempered Sword
	[11133]="0:0:12:0:1:::0:0:", -- Linken's Training Sword
	[11106]="0:0:12:0:1:::0:0:", -- Lion-headed Key
	[15447]="0:0:12:0:1:::0:0:", -- Living Rot
	[16743]="0:0:12:0:20:::0:0:", -- Logging Rope
	[5072]="0:0:12:0:1:::0:0:", -- Lok's Skull
	[5790]="0:0:12:0:1:::0:0:", -- Lonebrow's Journal
	[18960]="0:0:12:0:1:::0:0:", -- Lookout's Spyglass
	[18804]="0:0:12:0:1:::0:0:", -- Lord Grayson's Satchel
	[5359]="0:0:12:0:1:::0:0:", -- Lorgalis Manuscript
	[6172]="0:0:12:0:1:::0:0:", -- Lost Supplies
	[11312]="0:0:12:0:1:::0:0:", -- Lost Thunderbrew Recipe
	[4847]="0:0:12:0:1:::0:0:", -- Lotwil's Shackles of Elemental Binding
	[15851]="0:0:12:0:20:::0:0:", -- Lunar Fungus
	[2606]="0:0:12:0:1:::0:0:", -- Lurker Venom
	[5588]="0:0:12:0:1:::0:0:", -- Lydon's Toxin
	[2667]="0:0:12:0:1:::0:0:", -- MacGrann's Dried Meats
	[4441]="0:0:12:0:1:::0:0:", -- MacKreel's Moonshine
	[10678]="0:0:12:0:1:::0:0:", -- Magatha's Note
	[7226]="0:0:12:0:1:::0:0:", -- Mage-tastic Gizmonitor
	[8047]="0:0:12:0:20:::0:0:", -- Magenta Fungus Cap
	[3635]="0:0:12:0:1:::0:0:", -- Maggot Eye's Paw
	[16189]="0:0:12:0:1:::0:0:", -- Maggran's Reserve Letter
	[4487]="0:0:12:0:1:::0:0:", -- Maiden's Folly Charts
	[4489]="0:0:12:0:1:::0:0:", -- Maiden's Folly Log
	[6479]="0:0:12:0:1:::0:0:", -- Malem Pendant
	[3183]="0:0:12:0:1:::0:0:", -- Mangy Claw
	[18775]="0:0:12:0:1:::0:0:", -- Manna-Enriched Horse Feed
	[10789]="0:0:12:0:1:::0:0:", -- Manual of Engineering Disciplines
	[6077]="0:0:12:0:1:::0:0:", -- Maraudine Key Fragment
	[5832]="0:0:12:0:1:::0:0:", -- Marcel's Head
	[4515]="0:0:12:0:1:::0:0:", -- Marez's Head
	[10005]="0:0:12:0:1:::0:0:", -- Margol's Gigantic Horn
	[10000]="0:0:12:0:1:::0:0:", -- Margol's Horn
	[745]="0:0:12:0:1:::0:0:", -- Marshal McBride's Documents
	[11464]="0:0:12:0:1:::0:0:", -- Marshal Windsor's Lost Information
	[11465]="0:0:12:0:1:::0:0:", -- Marshal Windsor's Lost Information
	[1946]="0:0:12:0:1:::0:0:", -- Mary's Looking Glass
	[5273]="0:0:12:0:20:::0:0:", -- Mathystra Relic
	[3924]="0:0:12:0:1:::0:0:", -- Maury's Clubbed Foot
	[1208]="0:0:12:0:1:::0:0:", -- Maybell's Love Letter
	[12845]="0:0:12:0:1:::0:0:", -- Medallion of Faith
	[5221]="0:0:12:0:1:::0:0:", -- Melenas' Head
	[2625]="0:0:12:0:1:::0:0:", -- Menethil Statuette
	[12291]="0:0:12:0:1:::0:0:", -- Merged Ooze Sample
	[2639]="0:0:12:0:1:::0:0:", -- Merrin's Letter
	[9592]="0:0:12:0:30:::0:0:", -- Metallic Fragments
	[7499]="0:0:12:0:1:::0:0:", -- Middle of Gelkak's Key
	[1261]="0:0:12:0:20:::0:0:", -- Midnight Orb
	[11119]="0:0:12:0:20:::0:0:", -- Milly's Harvest
	[3616]="0:0:12:0:1:::0:0:", -- Mind's Eye
	[2640]="0:0:12:0:20:::0:0:", -- Miners' Gear
	[1894]="0:0:12:0:20:::0:0:", -- Miners' Union Card
	[6064]="0:0:12:0:1:::0:0:", -- Miniature Platinum Discs
	[18956]="0:0:12:0:20:::0:0:", -- Miniaturization Residue
	[12840]="0:0:12:0:250:::0:0:", -- Minion's Scourgestone
	[4864]="0:0:12:0:10:::0:0:", -- Minshina's Skull
	[6081]="0:0:12:0:1:::0:0:", -- Mire Lord Fungus
	[5847]="0:0:12:0:20:::0:0:", -- Mirefin Head
	[7206]="0:0:12:0:1:::0:0:", -- Mirror Lake Water Sample
	[2252]="0:0:12:0:1:::0:0:", -- Miscellaneous Goblin Supplies
	[12192]="0:0:12:0:1:::0:0:", -- Mist Veil's Lockbox
	[3629]="0:0:12:0:1:::0:0:", -- Mistmantle Family Ring
	[3919]="0:0:12:0:20:::0:0:", -- Mistvale Giblets
	[16970]="0:0:12:0:1:::0:0:", -- Misty Reed Mahi Mahi
	[8686]="0:0:12:0:1:::0:0:", -- Mithril Pendant
	[2607]="0:0:12:0:1:::0:0:", -- Mo'grosh Crystal
	[5865]="0:0:12:0:1:::0:0:", -- Modified Seaforium Booster
	[2659]="0:0:12:0:1:::0:0:", -- Modr Fragment
	[5835]="0:0:12:0:1:::0:0:", -- Mok'Morokk's Grog
	[5834]="0:0:12:0:1:::0:0:", -- Mok'Morokk's Snuff
	[5836]="0:0:12:0:1:::0:0:", -- Mok'Morokk's Strongbox
	[6931]="0:0:12:0:1:::0:0:", -- Moldy Tome
	[6184]="0:0:12:0:20:::0:0:", -- Monstrous Crawler Leg
	[10641]="0:0:12:0:20:::0:0:", -- Moonpetal Lily
	[5413]="0:0:12:0:20:::0:0:", -- Moonstalker Fang
	[12383]="0:0:12:0:20:::0:0:", -- Moontouched Feather
	[14339]="0:0:12:0:1:::0:0:", -- Moonwell Water Tube
	[3514]="0:0:12:0:1:::0:0:", -- Mor'Ladim's Skull
	[18818]="0:0:12:0:1:::0:0:", -- Mor'zul's Instructions
	[15454]="0:0:12:0:1:::0:0:", -- Mortar and Pestle
	[5179]="0:0:12:0:1:::0:0:", -- Moss-twined Heart
	[5170]="0:0:12:0:20:::0:0:", -- Mossy Tumor
	[4435]="0:0:12:0:20:::0:0:", -- Mote of Myzrael
	[4742]="0:0:12:0:20:::0:0:", -- Mountain Cougar Pelt
	[9597]="0:0:12:0:20:::0:0:", -- Mountain Giant Muisek
	[9621]="0:0:12:0:1:::0:0:", -- Mountain Giant Muisek Vessel
	[3496]="0:0:12:0:20:::0:0:", -- Mountain Lion Blood
	[3551]="0:0:12:0:1:::0:0:", -- Muckrake's Head
	[938]="0:0:12:0:1:::0:0:", -- Muddy Journal Pages
	[2720]="0:0:12:0:1:::0:0:", -- Muddy Note
	[3502]="0:0:12:0:20:::0:0:", -- Mudsnout Blossoms
	[3506]="0:0:12:0:1:::0:0:", -- Mudsnout Composite
	[3508]="0:0:12:0:1:::0:0:", -- Mudsnout Mixture
	[3553]="0:0:12:0:1:::0:0:", -- Mug'thol's Head
	[16976]="0:0:12:0:1:::0:0:", -- Murgut's Totem
	[3716]="0:0:12:0:20:::0:0:", -- Murloc Head
	[2784]="0:0:12:0:1:::0:0:", -- Musquash Root
	[10442]="0:0:12:0:1:::0:0:", -- Mysterious Artifact
	[4654]="0:0:12:0:1:::0:0:", -- Mysterious Fossil
	[9248]="0:0:12:0:1:::0:0:", -- Mysterious Relic
	[5536]="0:0:12:0:1:::0:0:", -- Mythology of the Titans
	[11412]="0:0:12:0:1:::0:0:", -- Nagmara's Vial
	[5073]="0:0:12:0:1:::0:0:", -- Nak's Skull
	[15876]="0:0:12:0:1:::0:0:", -- Nathanos' Chest
	[7887]="0:0:12:0:1:::0:0:", -- Necklace and Gem Salvage
	[6167]="0:0:12:0:1:::0:0:", -- Neeka's Report
	[9628]="0:0:12:0:1:::0:0:", -- Neeru's Herb Pouch
	[3625]="0:0:12:0:1:::0:0:", -- Nek'rosh's Head
	[9471]="0:0:12:0:1:::0:0:", -- Nekrum's Medallion
	[2661]="0:0:12:0:1:::0:0:", -- Neru Fragment
	[16262]="0:0:12:0:1:::0:0:", -- Nessa's Collection
	[3081]="0:0:12:0:1:::0:0:", -- Nether Gem
	[6251]="0:0:12:0:20:::0:0:", -- Nether Wing
	[3905]="0:0:12:0:1:::0:0:", -- Nezzliok's Head
	[5732]="0:0:12:0:1:::0:0:", -- NG-5
	[5695]="0:0:12:0:1:::0:0:", -- NG-5 Explosives (Blue)
	[5694]="0:0:12:0:1:::0:0:", -- NG-5 Explosives (Red)
	[10649]="0:0:12:0:1:::0:0:", -- Nightmare Shard
	[3409]="0:0:12:0:20:::0:0:", -- Nightsaber Fang
	[15002]="0:0:12:0:1:::0:0:", -- Nimboya's Pike
	[2828]="0:0:12:0:1:::0:0:", -- Nissa's Remains
	[5017]="0:0:12:0:20:::0:0:", -- Nitroglycerin
	[10792]="0:0:12:0:1:::0:0:", -- Nixx's Pledge of Secrecy
	[11270]="0:0:12:0:1:::0:0:", -- Nixx's Signed Pledge
	[7628]="0:0:12:0:1:::0:0:", -- Nondescript Letter
	[10440]="0:0:12:0:1:::0:0:", -- Nori's Mug
	[14646]="0:0:12:0:1:::0:0:", -- Northshire Gift Voucher
	[3162]="0:0:12:0:20:::0:0:", -- Notched Rib
	[11143]="0:0:12:0:20:::0:0:", -- Nugget Slug
	[10589]="0:0:12:0:1:::0:0:", -- Oathstone of Ysera's Dragonflight
	[8053]="0:0:12:0:1:::0:0:", -- Obsidian Power Source
	[14679]="0:0:12:0:1:::0:0:", -- Of Love and Family
	[10794]="0:0:12:0:1:::0:0:", -- Oglethorpe's Pledge of Secrecy
	[11282]="0:0:12:0:1:::0:0:", -- Oglethorpe's Signed Pledge
	[1968]="0:0:12:0:1:::0:0:", -- Ogre's Monocle
	[2713]="0:0:12:0:1:::0:0:", -- Ol' Sooty's Head
	[12534]="0:0:12:0:1:::0:0:", -- Omokk's Head
	[7715]="0:0:12:0:1:::0:0:", -- Onin's Report
	[4844]="0:0:12:0:1:::0:0:", -- Opal Runestone
	[4551]="0:0:12:0:1:::0:0:", -- Or'Kalar's Head
	[6442]="0:0:12:0:1:::0:0:", -- Oracle Crystal
	[12300]="0:0:12:0:1:::0:0:", -- Orb of Draconic Energy
	[18207]="0:0:12:0:100:::0:0:", -- Orc Tooth
	[5686]="0:0:12:0:1:::0:0:", -- Ordanus' Head
	[5460]="0:0:12:0:1:::0:0:", -- Orendil's Cure
	[9466]="0:0:12:0:1:::0:0:", -- Orwin's Shovel
	[1309]="0:0:12:0:1:::0:0:", -- Oslow's Toolbox
	[16115]="0:0:12:0:1:::0:0:", -- Osric's Crate
	[13357]="0:0:12:0:20:::0:0:", -- Osseous Agitator
	[4516]="0:0:12:0:1:::0:0:", -- Otto's Head
	[11724]="0:0:12:0:1:::0:0:", -- Overdue Package
	[15879]="0:0:12:0:1:::0:0:", -- Overlord Ror's Claw
	[7333]="0:0:12:0:1:::0:0:", -- Overseer's Whistle
	[10793]="0:0:12:0:1:::0:0:", -- Overspark's Pledge of Secrecy
	[11283]="0:0:12:0:1:::0:0:", -- Overspark's Signed Pledge
	[5102]="0:0:12:0:1:::0:0:", -- Owatanka's Tailspike
	[2806]="0:0:12:0:1:::0:0:", -- Package for Stormpike
	[782]="0:0:12:0:20:::0:0:", -- Painted Gnoll Armband
	[12887]="0:0:12:0:1:::0:0:", -- Pamela's Doll's Left Side
	[12888]="0:0:12:0:1:::0:0:", -- Pamela's Doll's Right Side
	[12942]="0:0:12:0:1:::0:0:", -- Panther Cage Key
	[5534]="0:0:12:0:1:::0:0:", -- Parker's Lunch
	[5186]="0:0:12:0:1:::0:0:", -- Partially Filled Vessel
	[15850]="0:0:12:0:1:::0:0:", -- Patch of Duskwing's Fur
	[11512]="0:0:12:0:20:::0:0:", -- Patch of Tainted Skin
	[3879]="0:0:12:0:1:::0:0:", -- Paw of Sin'Dall
	[3617]="0:0:12:0:1:::0:0:", -- Pendant of Shadow
	[15885]="0:0:12:0:1:::0:0:", -- Pendant of the Sea Lion
	[3684]="0:0:12:0:1:::0:0:", -- Perenolde Tiara
	[11844]="0:0:12:0:1:::0:0:", -- Pestlezugg's Un'Goro Report
	[18708]="0:0:12:0:1:::0:0:", -- Petrified Bark
	[5251]="0:0:12:0:1:::0:0:", -- Phial of Scrying
	[11227]="0:0:12:0:1:::0:0:", -- Piece of Krom'zar's Banner
	[11504]="0:0:12:0:1:::0:0:", -- Piece of Threshadon Carcass
	[13174]="0:0:12:0:30:::0:0:", -- Plagued Flesh Sample
	[15043]="0:0:12:0:100:::0:0:", -- Plagueland Termites
	[5087]="0:0:12:0:20:::0:0:", -- Plainstrider Beak
	[4740]="0:0:12:0:20:::0:0:", -- Plainstrider Feather
	[4894]="0:0:12:0:20:::0:0:", -- Plainstrider Kidney
	[4739]="0:0:12:0:20:::0:0:", -- Plainstrider Meat
	[4806]="0:0:12:0:1:::0:0:", -- Plainstrider Scale
	[4759]="0:0:12:0:20:::0:0:", -- Plainstrider Talon
	[10590]="0:0:12:0:1:::0:0:", -- Pocked Black Box
	[16209]="0:0:12:0:1:::0:0:", -- Podrig's Order
	[962]="0:0:12:0:1:::0:0:", -- Pork Belly Pie
	[6785]="0:0:12:0:1:::0:0:", -- Powers of the Void
	[4803]="0:0:12:0:20:::0:0:", -- Prairie Alpha Tooth
	[4804]="0:0:12:0:1:::0:0:", -- Prairie Wolf Heart
	[4758]="0:0:12:0:20:::0:0:", -- Prairie Wolf Paw
	[9235]="0:0:12:0:1:::0:0:", -- Pratt's Letter
	[10458]="0:0:12:0:1:::0:0:", -- Prayer to Elune
	[11570]="0:0:12:0:1:::0:0:", -- Preserved Pheromone Mixture
	[11569]="0:0:12:0:1:::0:0:", -- Preserved Threshadon Meat
	[5808]="0:0:12:0:20:::0:0:", -- Pridewing Venom Sac
	[9316]="0:0:12:0:1:::0:0:", -- Prismatic Punch Card
	[5938]="0:0:12:0:20:::0:0:", -- Pristine Crawler Leg
	[7267]="0:0:12:0:20:::0:0:", -- Pristine Spider Silk
	[3839]="0:0:12:0:1:::0:0:", -- Pristine Tigress Fang
	[18969]="0:0:12:0:1:::0:0:", -- Pristine Yeti Hide
	[12367]="0:0:12:0:20:::0:0:", -- Pristine Yeti Horn
	[10022]="0:0:12:0:1:::0:0:", -- Proof of Deed
	[4702]="0:0:12:0:20:::0:0:", -- Prospector's Pick
	[5096]="0:0:12:0:20:::0:0:", -- Prowler Claws
	[3911]="0:0:12:0:20:::0:0:", -- Pulsing Blue Shard
	[3900]="0:0:12:0:20:::0:0:", -- Pupellyverbos Port
	[6286]="0:0:12:0:1:::0:0:", -- Pure Hearts
	[12236]="0:0:12:0:20:::0:0:", -- Pure Un'Goro Sample
	[7083]="0:0:12:0:1:::0:0:", -- Purified Kor Gem
	[12906]="0:0:12:0:1:::0:0:", -- Purified Moonwell Water
	[2855]="0:0:12:0:20:::0:0:", -- Putrid Claw
	[3218]="0:0:12:0:20:::0:0:", -- Pyrewood Shackle
	[15847]="0:0:12:0:1:::0:0:", -- Quel'Thalas Registry
	[3165]="0:0:12:0:1:::0:0:", -- Quinn's Potion
	[17355]="0:0:12:0:1:::0:0:", -- Rabine's Letter
	[15881]="0:0:12:0:1:::0:0:", -- Rackmore's Golden Key
	[15878]="0:0:12:0:1:::0:0:", -- Rackmore's Silver Key
	[18947]="0:0:12:0:20:::0:0:", -- Rage Scar Yeti Hide
	[18590]="0:0:12:0:30:::0:0:", -- Raging Beast's Blood
	[5388]="0:0:12:0:1:::0:0:", -- Ran Bloodtooth's Skull
	[5062]="0:0:12:0:20:::0:0:", -- Raptor Head
	[4513]="0:0:12:0:20:::0:0:", -- Raptor Heart
	[4526]="0:0:12:0:1:::0:0:", -- Raptor Talon Amulet
	[5391]="0:0:12:0:1:::0:0:", -- Rare Earth
	[11466]="0:0:12:0:1:::0:0:", -- Raschal's Report
	[17117]="0:0:12:0:1:::0:0:", -- Rat Catcher's Flute
	[6281]="0:0:12:0:20:::0:0:", -- Rattlecage Skull
	[2477]="0:0:12:0:20:::0:0:", -- Ravager's Skull
	[11509]="0:0:12:0:5:::0:0:", -- Ravasaur Pheromone Gland
	[3405]="0:0:12:0:1:::0:0:", -- Raven Claw Talisman
	[5793]="0:0:12:0:1:::0:0:", -- Razorflank's Heart
	[5792]="0:0:12:0:1:::0:0:", -- Razorflank's Medallion
	[6652]="0:0:12:0:1:::0:0:", -- Reagent Pouch
	[5547]="0:0:12:0:1:::0:0:", -- Reconstructed Rod
	[7006]="0:0:12:0:1:::0:0:", -- Reconstructed Tome
	[3658]="0:0:12:0:10:::0:0:", -- Recovered Tome
	[4992]="0:0:12:0:1:::0:0:", -- Recruitment Letter
	[752]="0:0:12:0:20:::0:0:", -- Red Burlap Bandana
	[829]="0:0:12:0:20:::0:0:", -- Red Leather Bandana
	[1019]="0:0:12:0:20:::0:0:", -- Red Linen Bandana
	[11186]="0:0:12:0:10::164:0:0:", -- Red Power Crystal
	[9281]="0:0:12:0:1:::0:0:", -- Red Punch Card
	[915]="0:0:12:0:20:::0:0:", -- Red Silk Bandana
	[2909]="0:0:12:0:20:::0:0:", -- Red Wool Bandana
	[12955]="0:0:12:0:1:::0:0:", -- Redpath's Shield
	[5950]="0:0:12:0:1:::0:0:", -- Reethe's Badge
	[15209]="0:0:12:0:1:::0:0:", -- Relic Bundle
	[18539]="0:0:12:0:1:::0:0:", -- Reliquary of Purity
	[7811]="0:0:12:0:1:::0:0:", -- Remaining Drops of Purest Water
	[3155]="0:0:12:0:1:::0:0:", -- Remedy of Arugal
	[5693]="0:0:12:0:1:::0:0:", -- Remote Detonator (Blue)
	[5692]="0:0:12:0:1:::0:0:", -- Remote Detonator (Red)
	[5027]="0:0:12:0:1:::0:0:", -- Rendered Spores
	[3468]="0:0:12:0:1:::0:0:", -- Renferrel's Findings
	[2956]="0:0:12:0:1:::0:0:", -- Report on the Defias Brotherhood
	[11112]="0:0:12:0:1:::0:0:", -- Research Equipment
	[9591]="0:0:12:0:20:::0:0:", -- Resilient Sinew
	[16581]="0:0:12:0:20:::0:0:", -- Resonite Crystal
	[3083]="0:0:12:0:20:::0:0:", -- Restabilization Cog
	[2798]="0:0:12:0:20:::0:0:", -- Rethban Ore
	[8070]="0:0:12:0:1:::0:0:", -- Reward Voucher
	[16785]="0:0:12:0:1:::0:0:", -- Rexxar's Testament
	[11313]="0:0:12:0:1:::0:0:", -- Ribbly's Head
	[12437]="0:0:12:0:1:::0:0:", -- Ridgewell's Crate
	[9153]="0:0:12:0:1:::0:0:", -- Rig Blueprints
	[8724]="0:0:12:0:1:::0:0:", -- Rin'ji's Secret
	[5445]="0:0:12:0:1:::0:0:", -- Ring of Zoram
	[6634]="0:0:12:0:20:::0:0:", -- Ritual Salve
	[7274]="0:0:12:0:1:::0:0:", -- Rituals of Power
	[9309]="0:0:12:0:20:::0:0:", -- Robo-mechanical Guts
	[6257]="0:0:12:0:20:::0:0:", -- Roc Gizzard
	[7848]="0:0:12:0:20:::0:0:", -- Rock Elemental Shard
	[5798]="0:0:12:0:20:::0:0:", -- Rocket Car Parts
	[6930]="0:0:12:0:20:::0:0:", -- Rod of Channeling
	[3710]="0:0:12:0:1:::0:0:", -- Rod of Helcular
	[4469]="0:0:12:0:1:::0:0:", -- Rod of Order
	[18819]="0:0:12:0:1:::0:0:", -- Rohan's Exorcism Censer
	[735]="0:0:12:0:1:::0:0:", -- Rolf and Malakai's Medallions
	[14546]="0:0:12:0:1:::0:0:", -- Roon's Kodo Horn
	[5056]="0:0:12:0:20:::0:0:", -- Root Sample
	[1598]="0:0:12:0:20:::0:0:", -- Rot Blossom
	[3236]="0:0:12:0:20:::0:0:", -- Rot Hide Ichor
	[15875]="0:0:12:0:1:::0:0:", -- Rotten Apple
	[6656]="0:0:12:0:1:::0:0:", -- Rough Quartz
	[10563]="0:0:12:0:1:::0:0:", -- Rubbing: Rune of Beth'Amara
	[10564]="0:0:12:0:1:::0:0:", -- Rubbing: Rune of Jin'yael
	[10565]="0:0:12:0:1:::0:0:", -- Rubbing: Rune of Markri
	[10566]="0:0:12:0:1:::0:0:", -- Rubbing: Rune of Sael'hai
	[15696]="0:0:12:0:1:::0:0:", -- Ruined Tome
	[13850]="0:0:12:0:1:::0:0:", -- Rumbleshot's Ammo
	[3408]="0:0:12:0:1:::0:0:", -- Rune of Nesting
	[3745]="0:0:12:0:20:::0:0:", -- Rune of Opening
	[9552]="0:0:12:0:1:::0:0:", -- Rune-Inscribed Note
	[9568]="0:0:12:0:1:::0:0:", -- Rune-Inscribed Parchment
	[3353]="0:0:12:0:1:::0:0:", -- Rune-inscribed Pendant
	[9562]="0:0:12:0:1:::0:0:", -- Rune-Inscribed Tablet
	[6284]="0:0:12:0:1:::0:0:", -- Runes of Summoning
	[17363]="0:0:12:0:1:::0:0:", -- Ryson's Beacon
	[738]="0:0:12:0:20:::0:0:", -- Sack of Barley
	[739]="0:0:12:0:20:::0:0:", -- Sack of Corn
	[3717]="0:0:12:0:1:::0:0:", -- Sack of Murloc Heads
	[740]="0:0:12:0:20:::0:0:", -- Sack of Rye
	[4918]="0:0:12:0:20:::0:0:", -- Sack of Supplies
	[12733]="0:0:12:0:1:::0:0:", -- Sacred Frostsaber Meat
	[13313]="0:0:12:0:1:::0:0:", -- Sacred Highborne Writings
	[9241]="0:0:12:0:1:::0:0:", -- Sacred Mallet
	[5794]="0:0:12:0:20:::0:0:", -- Salty Scorpid Venom
	[9257]="0:0:12:0:1:::0:0:", -- Samha Essence
	[5054]="0:0:12:0:1:::0:0:", -- Samophlange
	[11149]="0:0:12:0:1:::0:0:", -- Samophlange Manual
	[11147]="0:0:12:0:1:::0:0:", -- Samophlange Manual Cover
	[4502]="0:0:12:0:1:::0:0:", -- Sample Elven Gem
	[3237]="0:0:12:0:1:::0:0:", -- Sample Ichor
	[5866]="0:0:12:0:1:::0:0:", -- Sample of Indurium Ore
	[10414]="0:0:12:0:1:::0:0:", -- Sample Snapjaw Shell
	[16333]="0:0:12:0:1:::0:0:", -- Samuel's Remains
	[16784]="0:0:12:0:20:::0:0:", -- Sapphire of Aku'Mai
	[3407]="0:0:12:0:1:::0:0:", -- Sapphire of Sky
	[16968]="0:0:12:0:1:::0:0:", -- Sar'theris Striker
	[4514]="0:0:12:0:1:::0:0:", -- Sara Balloo's Plea
	[2162]="0:0:12:0:1:::0:0:", -- Sarah's Ring
	[5537]="0:0:12:0:1:::0:0:", -- Sarilus Foulborne's Head
	[4905]="0:0:12:0:1:::0:0:", -- Sarkoth's Mangled Claw
	[3638]="0:0:12:0:1:::0:0:", -- Sarltooth's Talon
	[8155]="0:0:12:0:1:::0:0:", -- Sathrah's Sacrifice
	[18603]="0:0:12:0:15:::0:0:", -- Satyr Blood
	[5481]="0:0:12:0:20:::0:0:", -- Satyr Horns
	[16969]="0:0:12:0:1:::0:0:", -- Savage Coast Blue Sailfin
	[4893]="0:0:12:0:20:::0:0:", -- Savannah Lion Tusk
	[6168]="0:0:12:0:20:::0:0:", -- Sawtooth Snapper Claw
	[5271]="0:0:12:0:20:::0:0:", -- Scaber Stalk
	[3636]="0:0:12:0:1:::0:0:", -- Scale of Old Murk-Eye
	[3266]="0:0:12:0:20:::0:0:", -- Scarlet Armband
	[2885]="0:0:12:0:1:::0:0:", -- Scarlet Crusade Documents
	[2875]="0:0:12:0:20:::0:0:", -- Scarlet Insignia Ring
	[11127]="0:0:12:0:20:::0:0:", -- Scavenged Goods
	[3265]="0:0:12:0:20:::0:0:", -- Scavenger Paw
	[15750]="0:0:12:0:1:::0:0:", -- Sceptre of Light
	[6838]="0:0:12:0:20:::0:0:", -- Scorched Spider Fang
	[6248]="0:0:12:0:20:::0:0:", -- Scorpashi Venom
	[4862]="0:0:12:0:20:::0:0:", -- Scorpid Worker Tail
	[8393]="0:0:12:0:20:::0:0:", -- Scorpok Pincer
	[12807]="0:0:12:0:1:::0:0:", -- Scourge Banner
	[13176]="0:0:12:0:1:::0:0:", -- Scourge Data
	[4630]="0:0:12:0:20:::0:0:", -- Scrap Metal
	[8593]="0:0:12:0:1:::0:0:", -- Scrimshank's Surveying Gear
	[5731]="0:0:12:0:1:::0:0:", -- Scroll of Messaging
	[4472]="0:0:12:0:1:Scroll::0:0:", -- Scroll of Myzrael
	[12242]="0:0:12:0:1:::0:0:", -- Sea Creature Bones
	[12289]="0:0:12:0:1:::0:0:", -- Sea Turtle Remains
	[5862]="0:0:12:0:1:::0:0:", -- Seaforium Booster
	[4494]="0:0:12:0:1:::0:0:", -- Seahorn's Sealed Letter
	[17125]="0:0:12:0:1:::0:0:", -- Seal of Ravenholdt
	[8687]="0:0:12:0:1:::0:0:", -- Sealed Description of Thredd's Visitor
	[5735]="0:0:12:0:1:::0:0:", -- Sealed Envelope
	[8527]="0:0:12:0:1:::0:0:", -- Sealed Field Testing Kit
	[4482]="0:0:12:0:1:::0:0:", -- Sealed Folder
	[10643]="0:0:12:0:1:::0:0:", -- Sealed Letter to Ag'tor
	[4533]="0:0:12:0:1:::0:0:", -- Sealed Letter to Archmage Malin
	[4622]="0:0:12:0:1:::0:0:", -- Sealed Note to Advisor Belgrum
	[5946]="0:0:12:0:1:::0:0:", -- Sealed Note to Elling
	[5960]="0:0:12:0:1:::0:0:", -- Sealed Note to Watcher Backus
	[18540]="0:0:12:0:1:::0:0:", -- Sealed Reliquary of Purity
	[4871]="0:0:12:0:20:::0:0:", -- Searing Collar
	[6848]="0:0:12:0:20:::0:0:", -- Searing Coral
	[5841]="0:0:12:0:20:::0:0:", -- Searing Heart
	[5840]="0:0:12:0:20:::0:0:", -- Searing Tongue
	[10661]="0:0:12:0:1:::0:0:", -- Second Mosh'aru Tablet
	[12897]="0:0:12:0:1:::0:0:", -- Second Relic Fragment
	[12765]="0:0:12:0:1:::0:0:", -- Secret Note #1
	[12766]="0:0:12:0:1:::0:0:", -- Secret Note #2
	[12768]="0:0:12:0:1:::0:0:", -- Secret Note #3
	[18922]="0:0:12:0:1:::0:0:", -- Secret Plans: Fiery Flux
	[6462]="0:0:12:0:1:::0:0:", -- Secure Crate
	[17760]="0:0:12:0:1:::0:0:", -- Seed of Life
	[11103]="0:0:12:0:1:::0:0:", -- Seed Voucher
	[2628]="0:0:12:0:1:::0:0:", -- Senir's Report
	[5067]="0:0:12:0:1:::0:0:", -- Serena's Head
	[5339]="0:0:12:0:20:::0:0:", -- Serpentbloom
	[7737]="0:0:12:0:1:::0:0:", -- Sethir's Journal
	[10759]="0:0:12:0:1:::0:0:", -- Severed Horn of the Defiler
	[3017]="0:0:12:0:1:::0:0:", -- Sevren's Orders
	[11058]="0:0:12:0:1:::0:0:", -- Sha'ni's Nose-Ring
	[13207]="0:0:12:0:1:::0:0:", -- Shadow Lord Fel'dan's Head
	[6080]="0:0:12:0:20:::0:0:", -- Shadow Panther Heart
	[14648]="0:0:12:0:1:::0:0:", -- Shadowglen Gift Voucher
	[1075]="0:0:12:0:20:::0:0:", -- Shadowhide Pendant
	[3838]="0:0:12:0:20:::0:0:", -- Shadowmaw Claw
	[17756]="0:0:12:0:20:::0:0:", -- Shadowshard Fragment
	[6441]="0:0:12:0:1:::0:0:", -- Shadowstalker Scalp
	[9324]="0:0:12:0:1:::0:0:", -- Shadra's Venom
	[3922]="0:0:12:0:1:::0:0:", -- Shaky's Payment
	[8363]="0:0:12:0:1:::0:0:", -- Shaman Voodoo Charm
	[7813]="0:0:12:0:1:::0:0:", -- Shard of Water
	[12432]="0:0:12:0:20:::0:0:", -- Shardtooth E'ko
	[12622]="0:0:12:0:10:::0:0:", -- Shardtooth Meat
	[9468]="0:0:12:0:1:::0:0:", -- Sharpbeak's Feather
	[7672]="0:0:12:0:1:::0:0:", -- Shattered Necklace Power Source
	[7669]="0:0:12:0:1:::0:0:", -- Shattered Necklace Ruby
	[7670]="0:0:12:0:1:::0:0:", -- Shattered Necklace Sapphire
	[7671]="0:0:12:0:1:::0:0:", -- Shattered Necklace Topaz
	[12957]="0:0:12:0:1:::0:0:", -- Shattered Sword of Marduk
	[1353]="0:0:12:0:1:::0:0:", -- Shaw's Report
	[9189]="0:0:12:0:1:::0:0:", -- Shay's Bell
	[4468]="0:0:12:0:1:::0:0:", -- Sheathed Trol'kalar
	[13545]="0:0:12:0:20:::0:0:", -- Shellfish
	[5190]="0:0:12:0:1:::0:0:", -- Shimmering Frond
	[2676]="0:0:12:0:20:::0:0:", -- Shimmerweed
	[12060]="0:0:12:0:1:::0:0:", -- Shindrell's Note
	[9250]="0:0:12:0:1:::0:0:", -- Ship Schedule
	[5076]="0:0:12:0:20:::0:0:", -- Shipment of Boots
	[3564]="0:0:12:0:1:::0:0:", -- Shipment of Iron
	[10738]="0:0:12:0:1:::0:0:", -- Shipment to Galvan
	[6178]="0:0:12:0:1:::0:0:", -- Shipment to Nethergarde
	[16642]="0:0:12:0:1:::0:0:", -- Shredder Operating Manual - Chapter 1
	[16643]="0:0:12:0:1:::0:0:", -- Shredder Operating Manual - Chapter 2
	[16644]="0:0:12:0:1:::0:0:", -- Shredder Operating Manual - Chapter 3
	[7679]="0:0:12:0:20:::0:0:", -- Shrike Bat Fang
	[15877]="0:0:12:0:1:::0:0:", -- Shrine Bauble
	[1532]="0:0:12:0:20:::0:0:", -- Shrunken Head
	[16001]="0:0:12:0:1:::0:0:", -- SI:7 Insignia (Fredo)
	[16003]="0:0:12:0:1:::0:0:", -- SI:7 Insignia (Rutger)
	[16002]="0:0:12:0:1:::0:0:", -- SI:7 Insignia (Turyen)
	[13172]="0:0:12:0:1:::0:0:", -- Siabi's Premium Tobacco
	[3349]="0:0:12:0:1:::0:0:", -- Sida's Bag
	[4450]="0:0:12:0:20:::0:0:", -- Sigil Fragment
	[4458]="0:0:12:0:1:::0:0:", -- Sigil of Arathor
	[4467]="0:0:12:0:1:::0:0:", -- Sigil of Ignaeus
	[4440]="0:0:12:0:1:::0:0:", -- Sigil of Strom
	[4648]="0:0:12:0:1:::0:0:", -- Sigil of the Hammer
	[4453]="0:0:12:0:1:::0:0:", -- Sigil of Thoradin
	[4466]="0:0:12:0:1:::0:0:", -- Sigil of Trollbane
	[4640]="0:0:12:0:1:::0:0:", -- Sign of the Earth
	[4995]="0:0:12:0:1:::0:0:", -- Signed Recruitment Letter
	[5058]="0:0:12:0:20:::0:0:", -- Silithid Egg
	[17345]="0:0:12:0:20:::0:0:", -- Silithid Goo
	[5855]="0:0:12:0:20:::0:0:", -- Silithid Heart
	[5854]="0:0:12:0:20:::0:0:", -- Silithid Talon
	[12191]="0:0:12:0:1:::0:0:", -- Silver Dawning's Lockbox
	[11472]="0:0:12:0:10:::0:0:", -- Silvermane Stalker Flank
	[11172]="0:0:12:0:20:::0:0:", -- Silvery Claws
	[8344]="0:0:12:0:1:::0:0:", -- Silvery Spinnerets
	[9542]="0:0:12:0:1:::0:0:", -- Simple Letter
	[9544]="0:0:12:0:1:::0:0:", -- Simple Memorandum
	[9547]="0:0:12:0:1:::0:0:", -- Simple Note
	[12635]="0:0:12:0:1:::0:0:", -- Simple Parchment
	[9543]="0:0:12:0:1:::0:0:", -- Simple Rune
	[9545]="0:0:12:0:1:::0:0:", -- Simple Sigil
	[6488]="0:0:12:0:1:::0:0:", -- Simple Tablet
	[10443]="0:0:12:0:1:::0:0:", -- Singed Letter
	[4520]="0:0:12:0:1:::0:0:", -- Singed Scroll Fragment
	[3917]="0:0:12:0:20:::0:0:", -- Singing Blue Crystal
	[3918]="0:0:12:0:20:::0:0:", -- Singing Crystal Shard
	[12741]="0:0:12:0:1:::0:0:", -- Sixth Mosh'aru Tablet
	[14619]="0:0:12:0:20:::0:0:", -- Skeletal Fragments
	[2378]="0:0:12:0:20:::0:0:", -- Skeleton Finger
	[14644]="0:0:12:0:1:::0:0:", -- Skeleton Key Mold
	[12753]="0:0:12:0:10::165:0:0:", -- Skin of Shadow
	[3254]="0:0:12:0:20:::0:0:", -- Skittering Blood
	[12956]="0:0:12:0:1:::0:0:", -- Skull of Horgus
	[18148]="0:0:12:0:1:::0:0:", -- Skull of Korrak
	[10420]="0:0:12:0:1:::0:0:", -- Skull of the Coldbringer
	[2466]="0:0:12:0:20:::0:0:", -- Skullsplitter Fetish
	[1524]="0:0:12:0:20:::0:0:", -- Skullsplitter Tusk
	[13853]="0:0:12:0:10:::0:0:", -- Slab of Carrion Worm Meat
	[5689]="0:0:12:0:1:::0:0:", -- Sleepers' Key
	[17507]="0:0:12:0:1:::0:0:", -- Slidore's Beacon
	[4626]="0:0:12:0:20:::0:0:", -- Small Stone Shard
	[18959]="0:0:12:0:1:::0:0:", -- Smithing Tuyere
	[7126]="0:0:12:0:20:::0:0:", -- Smokey Iron Ingot
	[15736]="0:0:12:0:1:::0:0:", -- Smokey's Special Compound
	[6991]="0:0:12:0:20:::0:0:", -- Smoldering Coal
	[5659]="0:0:12:0:20:::0:0:", -- Smoldering Embers
	[3932]="0:0:12:0:1:::0:0:", -- Smotts' Chest
	[4104]="0:0:12:0:20:::0:0:", -- Snapjaw Crocolisk Skin
	[9330]="0:0:12:0:1:::0:0:", -- Snapshot of Gammerita
	[3619]="0:0:12:0:1:::0:0:", -- Snellig's Snuffbox
	[8391]="0:0:12:0:20:::0:0:", -- Snickerfang Jowl
	[3910]="0:0:12:0:20:::0:0:", -- Snuff
	[6684]="0:0:12:0:1:::0:0:", -- Snufflenose Command Stick
	[5897]="0:0:12:0:1:::0:0:", -- Snufflenose Owner's Manual
	[5019]="0:0:12:0:20:::0:0:", -- Sodium Nitrate
	[15924]="0:0:12:0:10:::0:0:", -- Soft-shelled Clam Meat
	[18924]="0:0:12:0:1:::0:0:", -- Solenor's Head
	[11725]="0:0:12:0:20:::0:0:", -- Solid Crystal Leg Shaft
	[11367]="0:0:12:0:1:::0:0:", -- Solomon's Plea to Bolvar
	[1409]="0:0:12:0:1:::0:0:", -- Solomon's Plea to Darkshire
	[1407]="0:0:12:0:1:::0:0:", -- Solomon's Plea to Westfall
	[13356]="0:0:12:0:20:::0:0:", -- Somatic Intensifier
	[13815]="0:0:12:0:1:::0:0:", -- Some Rune
	[6914]="0:0:12:0:20:::0:0:", -- Soran'ruk Fragment
	[3912]="0:0:12:0:1:::0:0:", -- Soul Gem
	[12847]="0:0:12:0:1:::0:0:", -- Soul Stained Pike
	[13752]="0:0:12:0:1:::0:0:", -- Soulbound Keepsake
	[13624]="0:0:12:0:1:::0:0:", -- Soulbound Keepsake
	[7968]="0:0:12:0:1:::0:0:", -- Southsea Treasure
	[5803]="0:0:12:0:20:::0:0:", -- Speck of Dream Dust
	[1453]="0:0:12:0:1:::0:0:", -- Spectral Comb
	[14395]="0:0:12:0:1:::0:0:", -- Spells of Shadow
	[12530]="0:0:12:0:20:::0:0:", -- Spire Spider Egg
	[4488]="0:0:12:0:1:::0:0:", -- Spirit of Silverpine Charts
	[4490]="0:0:12:0:1:::0:0:", -- Spirit of Silverpine Log
	[9590]="0:0:12:0:1:::0:0:", -- Splintered Log
	[3916]="0:0:12:0:20:::0:0:", -- Split Bone Necklace
	[8431]="0:0:12:0:1:::0:0:", -- Spool of Light Chartreuse Silk Thread
	[11507]="0:0:12:0:20:::0:0:", -- Spotted Hyena Pelt
	[1467]="0:0:12:0:20:::0:0:", -- Spotted Sunfish
	[15722]="0:0:12:0:1:::0:0:", -- Spraggle's Canteen
	[11804]="0:0:12:0:1:::0:0:", -- Spraggle's Canteen
	[5917]="0:0:12:0:1:::0:0:", -- Spy's Report
	[10464]="0:0:12:0:1:::0:0:", -- Staff of Command
	[7733]="0:0:12:0:1:::0:0:", -- Staff of Prehistoria
	[4801]="0:0:12:0:20:::0:0:", -- Stalker Claws
	[10444]="0:0:12:0:1:::0:0:", -- Standard Issue Flare Gun
	[4646]="0:0:12:0:1:::0:0:", -- Star of Xil'yeh
	[9306]="0:0:12:0:1:::0:0:", -- Stave of Equinex
	[17411]="0:0:12:0:1:::0:0:", -- Steamsaw
	[2999]="0:0:12:0:1:::0:0:", -- Steelgrill's Tools
	[5837]="0:0:12:0:1:::0:0:", -- Steelsnap's Rib
	[5061]="0:0:12:0:20:::0:0:", -- Stolen Silver
	[17662]="0:0:12:0:1:::0:0:", -- Stolen Treats
	[9245]="0:0:12:0:1:::0:0:", -- Stoley's Bottle
	[9244]="0:0:12:0:1:::0:0:", -- Stoley's Shipment
	[10556]="0:0:12:0:1:::0:0:", -- Stone Circle
	[5233]="0:0:12:0:1:::0:0:", -- Stone of Relu
	[4034]="0:0:12:0:1:::0:0:", -- Stone of the Tides
	[5582]="0:0:12:0:20:::0:0:", -- Stonetalon Sap
	[17423]="0:0:12:0:100:::0:0:", -- Storm Crystal
	[17849]="0:0:12:0:1:::0:0:", -- Stormpike Banner
	[17328]="0:0:12:0:100:::0:0:", -- Stormpike Commander's Flesh
	[17327]="0:0:12:0:100:::0:0:", -- Stormpike Lieutenant's Flesh
	[17306]="0:0:12:0:100:::0:0:", -- Stormpike Soldier's Blood
	[17326]="0:0:12:0:100:::0:0:", -- Stormpike Soldier's Flesh
	[5998]="0:0:12:0:1:::0:0:", -- Stormpike's Request
	[748]="0:0:12:0:1:::0:0:", -- Stormwind Armor Marker
	[1408]="0:0:12:0:1:::0:0:", -- Stoutmantle's Response to Solomon
	[2563]="0:0:12:0:1:::0:0:", -- Strange Smelling Powder
	[12292]="0:0:12:0:1:::0:0:", -- Strangely Marked Box
	[13180]="0:0:12:0:50:::0:0:", -- Stratholme Holy Water
	[3411]="0:0:12:0:20:::0:0:", -- Strigid Owl Feather
	[4506]="0:0:12:0:20:::0:0:", -- Stromgarde Badge
	[15790]="0:0:12:0:1:::0:0:", -- Studies in Spirit Speaking
	[7134]="0:0:12:0:20:::0:0:", -- Sturdy Dragonmaw Shinbone
	[4432]="0:0:12:0:1:::0:0:", -- Sully Balloo's Letter
	[6146]="0:0:12:0:20:::0:0:", -- Sundried Driftwood
	[5165]="0:0:12:0:20:::0:0:", -- Sunscale Feather
	[6849]="0:0:12:0:20:::0:0:", -- Sunscorched Shell
	[5734]="0:0:12:0:1:::0:0:", -- Super Reaper 6000 Blueprints
	[9328]="0:0:12:0:1:::0:0:", -- Super Snapper FX
	[11834]="0:0:12:0:20:::0:0:", -- Super Sticky Tar
	[1922]="0:0:12:0:1:::0:0:", -- Supplies for Sven
	[4629]="0:0:12:0:20:::0:0:", -- Supply Crate
	[6810]="0:0:12:0:1:::0:0:", -- Surena's Choker
	[4807]="0:0:12:0:1:::0:0:", -- Swoop Gizzard
	[6866]="0:0:12:0:1:::0:0:", -- Symbol of Life
	[14625]="0:0:12:0:1:::0:0:", -- Symbol of Lost Honor
	[10552]="0:0:12:0:1:::0:0:", -- Symbol of Ragnaros
	[17124]="0:0:12:0:100:::0:0:", -- Syndicate Emblem
	[3601]="0:0:12:0:1:::0:0:", -- Syndicate Missive
	[10538]="0:0:12:0:1:::0:0:", -- Tablet of Beth'Amara
	[10539]="0:0:12:0:1:::0:0:", -- Tablet of Jin'yael
	[11126]="0:0:12:0:1:::0:0:", -- Tablet of Kurniya
	[10540]="0:0:12:0:1:::0:0:", -- Tablet of Markri
	[4631]="0:0:12:0:1:::0:0:", -- Tablet of Ryun'eh
	[10541]="0:0:12:0:1:::0:0:", -- Tablet of Sael'hai
	[6535]="0:0:12:0:1:::0:0:", -- Tablet of Verga
	[5824]="0:0:12:0:1:::0:0:", -- Tablet of Will
	[4094]="0:0:12:0:1:::0:0:", -- Tablet Shard
	[11470]="0:0:12:0:1:::0:0:", -- Tablet Transcript
	[14613]="0:0:12:0:1:::0:0:", -- Taelan's Hammer
	[4890]="0:0:12:0:20:::0:0:", -- Taillasher Egg
	[5217]="0:0:12:0:1:::0:0:", -- Tainted Heart
	[3520]="0:0:12:0:1:::0:0:", -- Tainted Keg
	[9576]="0:0:12:0:1:::0:0:", -- Tainted Letter
	[9577]="0:0:12:0:1:::0:0:", -- Tainted Memorandum
	[9579]="0:0:12:0:1:::0:0:", -- Tainted Parchment
	[9578]="0:0:12:0:1:::0:0:", -- Tainted Scroll
	[12355]="0:0:12:0:1:::0:0:", -- Talisman of Corruption
	[8050]="0:0:12:0:1:::0:0:", -- Tallonkai's Jewel
	[3877]="0:0:12:0:1:::0:0:", -- Talon of Tethis
	[7667]="0:0:12:0:1:::0:0:", -- Talvash's Phial of Scrying
	[15908]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15911]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15913]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15914]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15915]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15916]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15917]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15919]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15920]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15921]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15922]="0:0:12:0:1:::0:0:", -- Taming Rod
	[15923]="0:0:12:0:1:::0:0:", -- Taming Rod
	[8585]="0:0:12:0:1:::0:0:", -- Tapped Dowsing Widget
	[14540]="0:0:12:0:1:::0:0:", -- Taragaman the Hungerer's Heart
	[3498]="0:0:12:0:1:::0:0:", -- Taretha's Necklace
	[3550]="0:0:12:0:1:::0:0:", -- Targ's Head
	[6997]="0:0:12:0:1:::0:0:", -- Tattered Manuscript
	[18145]="0:0:12:0:100:::0:0:", -- Tauren Hoof
	[7208]="0:0:12:0:1:::0:0:", -- Tazan's Key
	[7295]="0:0:12:0:1:::0:0:", -- Tazan's Logbook
	[5038]="0:0:12:0:1:::0:0:", -- Tear of the Moons
	[2779]="0:0:12:0:1:::0:0:", -- Tear of Tilloa
	[18604]="0:0:12:0:5:::0:0:", -- Tears of the Hederine
	[9277]="0:0:12:0:1:::0:0:", -- Techbot's Memory Core
	[5077]="0:0:12:0:20:::0:0:", -- Telescopic Lens
	[12627]="0:0:12:0:1:::0:0:", -- Temporal Displacer
	[5505]="0:0:12:0:1:::0:0:", -- Teronis' Journal
	[1260]="0:0:12:0:1:::0:0:", -- Tharil'zun's Head
	[7586]="0:0:12:0:1:::0:0:", -- Tharnariun's Hope
	[7870]="0:0:12:0:1:::0:0:", -- Thaumaturgy Vessel Lockbox
	[16332]="0:0:12:0:1:::0:0:", -- Thazz'ril's Pick
	[6283]="0:0:12:0:1:::0:0:", -- The Book of Ur
	[2239]="0:0:12:0:1:::0:0:", -- The Collector's Ring
	[2223]="0:0:12:0:1:::0:0:", -- The Collector's Schedule
	[13471]="0:0:12:0:1:::0:0:", -- The Deed to Brill
	[13448]="0:0:12:0:1:::0:0:", -- The Deed to Caer Darrow
	[13450]="0:0:12:0:1:::0:0:", -- The Deed to Southshore
	[13451]="0:0:12:0:1:::0:0:", -- The Deed to Tarren Mill
	[2382]="0:0:12:0:1:::0:0:", -- The Embalmer's Heart
	[2005]="0:0:12:0:1:::0:0:", -- The First Troll Legend
	[2008]="0:0:12:0:1:::0:0:", -- The Fourth Troll Legend
	[1294]="0:0:12:0:1:::0:0:", -- The General's Response
	[13852]="0:0:12:0:1:::0:0:", -- The Grand Crusader's Command
	[15868]="0:0:12:0:1:::0:0:", -- The Grand Crusader's Command
	[11309]="0:0:12:0:1:::0:0:", -- The Heart of the Mountain
	[4644]="0:0:12:0:1:::0:0:", -- The Legacy Heart
	[2833]="0:0:12:0:1:::0:0:", -- The Lich's Spellbook
	[17781]="0:0:12:0:1:::0:0:", -- The Pariah's Instructions
	[2006]="0:0:12:0:1:::0:0:", -- The Second Troll Legend
	[7741]="0:0:12:0:1:::0:0:", -- The Shaft of Tsol
	[16872]="0:0:12:0:1:::0:0:", -- The Skull of Axtroz
	[16871]="0:0:12:0:1:::0:0:", -- The Skull of Chronalis
	[16869]="0:0:12:0:1:::0:0:", -- The Skull of Scryer
	[16870]="0:0:12:0:1:::0:0:", -- The Skull of Somnus
	[1293]="0:0:12:0:1:::0:0:", -- The State of Lakeshire
	[2007]="0:0:12:0:1:::0:0:", -- The Third Troll Legend
	[18719]="0:0:12:0:1:::0:0:", -- The Traitor's Heart
	[17684]="0:0:12:0:30:::0:0:", -- Theradric Crystal Carving
	[5078]="0:0:12:0:20:::0:0:", -- Theramore Medal
	[6952]="0:0:12:0:20:::0:0:", -- Thick Bear Fur
	[12366]="0:0:12:0:20:::0:0:", -- Thick Yeti Fur
	[8973]="0:0:12:0:20:::0:0:", -- Thick Yeti Hide
	[12411]="0:0:12:0:1:::0:0:", -- Third Mosh'aru Tablet
	[12898]="0:0:12:0:1:::0:0:", -- Third Relic Fragment
	[1875]="0:0:12:0:1:::0:0:", -- Thistlenettle's Badge
	[8603]="0:0:12:0:1:::0:0:", -- Thistleshrub Dew
	[10551]="0:0:12:0:10:::0:0:", -- Thorium Plated Dagger
	[11286]="0:0:12:0:1:::0:0:", -- Thorium Shackles
	[5412]="0:0:12:0:20:::0:0:", -- Thresher Eye
	[3623]="0:0:12:0:1:::0:0:", -- Thule's Head
	[7587]="0:0:12:0:1:::0:0:", -- Thun'grim's Instructions
	[5143]="0:0:12:0:20:::0:0:", -- Thunder Lizard Blood
	[4895]="0:0:12:0:1:::0:0:", -- Thunder Lizard Horn
	[4897]="0:0:12:0:20:::0:0:", -- Thunderhawk Saliva Gland
	[5164]="0:0:12:0:1:::0:0:", -- Thunderhawk Wings
	[5415]="0:0:12:0:1:::0:0:", -- Thunderhorn Cleansing Totem
	[2837]="0:0:12:0:1:::0:0:", -- Thurman's Letter
	[2830]="0:0:12:0:1:::0:0:", -- Thurman's Remains
	[2760]="0:0:12:0:1:::0:0:", -- Thurman's Sewing Kit
	[9234]="0:0:12:0:1:::0:0:", -- Tiara of the Deep
	[5168]="0:0:12:0:20:::0:0:", -- Timberling Seed
	[5169]="0:0:12:0:20:::0:0:", -- Timberling Sprout
	[15886]="0:0:12:0:1:::0:0:", -- Timolain's Phylactery
	[12438]="0:0:12:0:1:::0:0:", -- Tinkee's Letter
	[14872]="0:0:12:0:1:::0:0:", -- Tirion's Gift
	[2846]="0:0:12:0:20:::0:0:", -- Tirisfal Pumpkin
	[7871]="0:0:12:0:1:::0:0:", -- Token of Thievery
	[6775]="0:0:12:0:1:::0:0:", -- Tome of Divinity
	[6916]="0:0:12:0:1:::0:0:", -- Tome of Divinity
	[6999]="0:0:12:0:1:::0:0:", -- Tome of the Cabal
	[6776]="0:0:12:0:1:::0:0:", -- Tome of Valor
	[3660]="0:0:12:0:1:::0:0:", -- Tomes of Alterac
	[7498]="0:0:12:0:1:::0:0:", -- Top of Gelkak's Key
	[4528]="0:0:12:0:1:::0:0:", -- Tor'gan's Orb
	[6653]="0:0:12:0:1:::0:0:", -- Torch of the Dormant Flame
	[6654]="0:0:12:0:1:::0:0:", -- Torch of the Eternal Flame
	[3510]="0:0:12:0:20:::0:0:", -- Torn Fin Eye
	[780]="0:0:12:0:20:::0:0:", -- Torn Murloc Fin
	[4518]="0:0:12:0:1:::0:0:", -- Torn Scroll Fragment
	[4783]="0:0:12:0:1:::0:0:", -- Totem of Hawkwind
	[750]="0:0:12:0:20:::0:0:", -- Tough Wolf Meat
	[5621]="0:0:12:0:1:::0:0:", -- Tourmaline Phial
	[5638]="0:0:12:0:1:::0:0:", -- Toxic Fogger
	[12822]="0:0:12:0:20:::0:0:", -- Toxic Horror Droplet
	[1656]="0:0:12:0:1:::0:0:", -- Translated Letter
	[3248]="0:0:12:0:1:::0:0:", -- Translated Letter from The Embalmer
	[9593]="0:0:12:0:20:::0:0:", -- Treant Muisek
	[9606]="0:0:12:0:1:::0:0:", -- Treant Muisek Vessel
	[4532]="0:0:12:0:1:::0:0:", -- Trelane's Ember Agate
	[4531]="0:0:12:0:1:::0:0:", -- Trelane's Orb
	[4530]="0:0:12:0:1:::0:0:", -- Trelane's Phylactery
	[4525]="0:0:12:0:1:::0:0:", -- Trelane's Wand of Invocation
	[5825]="0:0:12:0:1:::0:0:", -- Treshala's Pendant
	[16991]="0:0:12:0:1:::0:0:", -- Triage Bandage
	[2536]="0:0:12:0:20:::0:0:", -- Trogg Stone Tooth
	[16602]="0:0:12:0:20:::0:0:", -- Troll Charm
	[9523]="0:0:12:0:20:::0:0:", -- Troll Temper
	[4769]="0:0:12:0:20:::0:0:", -- Trophy Swoop Quill
	[9263]="0:0:12:0:1:::0:0:", -- Troyas' Stave
	[4106]="0:0:12:0:20:::0:0:", -- Tumbled Crystal
	[3110]="0:0:12:0:20:::0:0:", -- Tunnel Rat Ear
	[5879]="0:0:12:0:20:::0:0:", -- Twilight Pendant
	[5584]="0:0:12:0:20:::0:0:", -- Twilight Whisker
	[7119]="0:0:12:0:1:::0:0:", -- Twitching Antenna
	[6767]="0:0:12:0:1:::0:0:", -- Tyranis' Pendant
	[11476]="0:0:12:0:1:::0:0:", -- U'cha's Pelt
	[6800]="0:0:12:0:20:::0:0:", -- Umbral Ore
	[12928]="0:0:12:0:1:::0:0:", -- Umi's Mechanical Yeti
	[11829]="0:0:12:0:20:::0:0:", -- Un'Goro Ash
	[11478]="0:0:12:0:10:::0:0:", -- Un'Goro Gorilla Pelt
	[12235]="0:0:12:0:20:::0:0:", -- Un'Goro Slime Sample
	[11479]="0:0:12:0:10:::0:0:", -- Un'Goro Stomper Pelt
	[11480]="0:0:12:0:10:::0:0:", -- Un'Goro Thunderer Pelt
	[12219]="0:0:12:0:1:::0:0:", -- Unadorned Seal of Ascension
	[7128]="0:0:12:0:20:::0:0:", -- Uncloven Satyr Hoof
	[12444]="0:0:12:0:20:::0:0:", -- Uncracked Chillwind Horn
	[9238]="0:0:12:0:20:::0:0:", -- Uncracked Scarab Shell
	[9322]="0:0:12:0:20:::0:0:", -- Undamaged Venom Sac
	[1221]="0:0:12:0:20:::0:0:", -- Underbelly Whelp Scale
	[14645]="0:0:12:0:1:::0:0:", -- Unfinished Skeleton Key
	[12323]="0:0:12:0:1:::0:0:", -- Unforged Seal of Ascension
	[11102]="0:0:12:0:1:::0:0:", -- Unhatched Sprite Darter Egg
	[5733]="0:0:12:0:1:::0:0:", -- Unidentified Ore
	[1217]="0:0:12:0:1:::0:0:", -- Unknown Reward
	[11319]="0:0:12:0:1:::0:0:", -- Unloaded Zapper
	[5884]="0:0:12:0:20:::0:0:", -- Unpopped Darkmist Eye
	[6169]="0:0:12:0:20:::0:0:", -- Unprepared Sawtooth Flank
	[5842]="0:0:12:0:1:::0:0:", -- Unrefined Ore Sample
	[8584]="0:0:12:0:1:::0:0:", -- Untapped Dowsing Widget
	[9437]="0:0:12:0:20:::0:0:", -- Untested Basilisk Sample
	[9439]="0:0:12:0:20:::0:0:", -- Untested Hyena Sample
	[9442]="0:0:12:0:20:::0:0:", -- Untested Scorpid Sample
	[7886]="0:0:12:0:1:::0:0:", -- Untranslated Journal
	[11132]="0:0:12:0:1:::0:0:", -- Unused Scraping Vial
	[11886]="0:0:12:0:1:::0:0:", -- Urgent Message
	[12339]="0:0:12:0:1:::0:0:", -- Vaelan's Gift
	[3613]="0:0:12:0:1:::0:0:", -- Valdred's Hands
	[14649]="0:0:12:0:1:::0:0:", -- Valley of Trials Gift Voucher
	[6799]="0:0:12:0:1:::0:0:", -- Vejrek's Head
	[5520]="0:0:12:0:1:::0:0:", -- Velinde's Journal
	[5521]="0:0:12:0:1:::0:0:", -- Velinde's Key
	[9321]="0:0:12:0:1:::0:0:", -- Venom Bottle
	[2634]="0:0:12:0:1:::0:0:", -- Venom Fern Extract
	[4904]="0:0:12:0:20:::0:0:", -- Venomtail Antidote
	[4886]="0:0:12:0:20:::0:0:", -- Venomtail Poison Sac
	[4834]="0:0:12:0:1:::0:0:", -- Venture Co. Documents
	[5718]="0:0:12:0:1:::0:0:", -- Venture Co. Engineering Plans
	[7389]="0:0:12:0:1:::0:0:", -- Venture Co. Ledger
	[5717]="0:0:12:0:1:::0:0:", -- Venture Co. Letters
	[9581]="0:0:12:0:1:::0:0:", -- Verdant Note
	[9580]="0:0:12:0:1:::0:0:", -- Verdant Sigil
	[2832]="0:0:12:0:1:::0:0:", -- Verna's Westfall Stew Recipe
	[1283]="0:0:12:0:1:::0:0:", -- Verner's Note
	[5023]="0:0:12:0:1:::0:0:", -- Verog's Head
	[7867]="0:0:12:0:20:::0:0:", -- Vessel of Dragon's Blood
	[5646]="0:0:12:0:1:::0:0:", -- Vial of Blessed Water
	[16973]="0:0:12:0:1:::0:0:", -- Vial of Dire Water
	[6989]="0:0:12:0:20:::0:0:", -- Vial of Hatefury Blood
	[5620]="0:0:12:0:20:::0:0:", -- Vial of Innocent Blood
	[7810]="0:0:12:0:1:::0:0:", -- Vial of Purest Water
	[1130]="0:0:12:0:20:::0:0:", -- Vial of Spider Venom
	[2872]="0:0:12:0:20:::0:0:", -- Vicious Night Web Spider Venom
	[11243]="0:0:12:0:20:::0:0:", -- Videre Elixir
	[6487]="0:0:12:0:20:::0:0:", -- Vile Familiar Head
	[2859]="0:0:12:0:20:::0:0:", -- Vile Fin Scale
	[8528]="0:0:12:0:1:::0:0:", -- Violet Powder
	[8526]="0:0:12:0:1:::0:0:", -- Violet Tragan
	[17506]="0:0:12:0:1:::0:0:", -- Vipore's Beacon
	[13370]="0:0:12:0:1:::0:0:", -- Vitreous Focuser
	[8149]="0:0:12:0:1:::0:0:", -- Voodoo Charm
	[5538]="0:0:12:0:1:::0:0:", -- Vorrel's Wedding Ring
	[13352]="0:0:12:0:1:::0:0:", -- Vosh'gajin's Snakestone
	[8396]="0:0:12:0:20:::0:0:", -- Vulture Gizzard
	[8463]="0:0:12:0:1:::0:0:", -- Warchief's Orders
	[12563]="0:0:12:0:1:::0:0:", -- Warlord Goretooth's Command
	[12730]="0:0:12:0:1:::0:0:", -- Warosh's Scroll
	[16745]="0:0:12:0:1:::0:0:", -- Warsong Axe Shipment
	[16744]="0:0:12:0:20:::0:0:", -- Warsong Oil
	[16765]="0:0:12:0:1:::0:0:", -- Warsong Outrider Update
	[16746]="0:0:12:0:20:::0:0:", -- Warsong Report
	[16763]="0:0:12:0:1:::0:0:", -- Warsong Runner Update
	[16742]="0:0:12:0:1:::0:0:", -- Warsong Saw Blades
	[16764]="0:0:12:0:1:::0:0:", -- Warsong Scout Update
	[5103]="0:0:12:0:1:::0:0:", -- Washte Pawne's Feather
	[3923]="0:0:12:0:20:::0:0:", -- Water Elemental Bracers
	[18958]="0:0:12:0:20:::0:0:", -- Water Elemental Core
	[4823]="0:0:12:0:1:::0:0:", -- Water of the Seers
	[4755]="0:0:12:0:1:::0:0:", -- Water Pitcher
	[4433]="0:0:12:0:1:::0:0:", -- Waterlogged Envelope
	[11830]="0:0:12:0:20:::0:0:", -- Webbed Diemetradon Scale
	[11831]="0:0:12:0:20:::0:0:", -- Webbed Pterrordax Scale
	[5167]="0:0:12:0:20:::0:0:", -- Webwood Egg
	[10640]="0:0:12:0:20:::0:0:", -- Webwood Ichor
	[3412]="0:0:12:0:20:::0:0:", -- Webwood Spider Silk
	[5166]="0:0:12:0:20:::0:0:", -- Webwood Venom Sac
	[4808]="0:0:12:0:20:::0:0:", -- Well Stone
	[2671]="0:0:12:0:20:::0:0:", -- Wendigo Mane
	[1972]="0:0:12:0:1:::0:0:", -- Westfall Deed
	[6894]="0:0:12:0:1:::0:0:", -- Whirlwind Heart
	[11477]="0:0:12:0:10:::0:0:", -- White Ravasaur Claw
	[6994]="0:0:12:0:1:::0:0:", -- Whitestone Oak Lumber
	[12433]="0:0:12:0:20:::0:0:", -- Wildkin E'ko
	[10819]="0:0:12:0:20:::0:0:", -- Wildkin Feather
	[9594]="0:0:12:0:20:::0:0:", -- Wildkin Muisek
	[9618]="0:0:12:0:1:::0:0:", -- Wildkin Muisek Vessel
	[5416]="0:0:12:0:1:::0:0:", -- Wildmane Cleansing Totem
	[1327]="0:0:12:0:1:::0:0:", -- Wiley's Note
	[957]="0:0:12:0:1:::0:0:", -- William's Shipment
	[4751]="0:0:12:0:20:::0:0:", -- Windfury Talon
	[2722]="0:0:12:0:1:::0:0:", -- Wine Ticket
	[12829]="0:0:12:0:1:::0:0:", -- Winterfall Crate
	[12431]="0:0:12:0:20:::0:0:", -- Winterfall E'ko
	[5064]="0:0:12:0:20:::0:0:", -- Witchwing Talon
	[4522]="0:0:12:0:20:::0:0:", -- Witherbark Medicine Pouch
	[9320]="0:0:12:0:20:::0:0:", -- Witherbark Skull
	[7273]="0:0:12:0:20:::0:0:", -- Witherbark Totem Stick
	[4503]="0:0:12:0:20:::0:0:", -- Witherbark Tusk
	[6170]="0:0:12:0:1:::0:0:", -- Wizards' Reagents
	[6016]="0:0:12:0:1:::0:0:", -- Wolf Heart Sample
	[10283]="0:0:12:0:1:::0:0:", -- Wolf Heart Samples
	[5018]="0:0:12:0:20:::0:0:", -- Wood Pulp
	[9266]="0:0:12:0:1:::0:0:", -- Woodpaw Battle Plans
	[9237]="0:0:12:0:20:::0:0:", -- Woodpaw Gnoll Mane
	[13158]="0:0:12:0:1:::0:0:", -- Words of the High Chief
	[896]="0:0:12:0:20:::0:0:", -- Worgen Fang
	[895]="0:0:12:0:20:::0:0:", -- Worgen Skull
	[3659]="0:0:12:0:1:::0:0:", -- Worn Leather Book
	[5348]="0:0:12:0:20:::0:0:", -- Worn Parchment
	[3714]="0:0:12:0:20:::0:0:", -- Worn Stone Token
	[3425]="0:0:12:0:1:::0:0:", -- Woven Wand
	[5490]="0:0:12:0:20:::0:0:", -- Wrathtail Head
	[13197]="0:0:12:0:1:::0:0:", -- Writhing Haunt Cauldron Key
	[7268]="0:0:12:0:1:::0:0:", -- Xavian Water Sample
	[10681]="0:0:12:0:1:::0:0:", -- Xylem's Note
	[4647]="0:0:12:0:1:::0:0:", -- Yagyin's Digest
	[10699]="0:0:12:0:1:::0:0:", -- Yeh'kinya's Bramble
	[10818]="0:0:12:0:1:::0:0:", -- Yeh'kinya's Scroll
	[11188]="0:0:12:0:10::164:0:0:", -- Yellow Power Crystal
	[9280]="0:0:12:0:1:::0:0:", -- Yellow Punch Card
	[3720]="0:0:12:0:20:::0:0:", -- Yeti Fur
	[3397]="0:0:12:0:20:::0:0:", -- Young Crocolisk Skin
	[3614]="0:0:12:0:1:::0:0:", -- Yowler's Paw
	[15785]="0:0:12:0:1:::0:0:", -- Zaeldarr's Head
	[4866]="0:0:12:0:1:::0:0:", -- Zalazane's Head
	[5628]="0:0:12:0:1:::0:0:", -- Zamah's Note
	[4016]="0:0:12:0:20:::0:0:", -- Zanzil's Mixture
	[16306]="0:0:12:0:1:::0:0:", -- Zargh's Meats
	[5086]="0:0:12:0:20:::0:0:", -- Zhevra Hooves
	[3907]="0:0:12:0:20:::0:0:", -- Ziata'jai Trophy
	[8525]="0:0:12:0:1:::0:0:", -- Zinge's Purchase Order
	[18904]="0:0:12:0:1:::0:0:", -- Zorbin's Ultra-Shrinker
	[3908]="0:0:12:0:20:::0:0:", -- Zul'Mamwe Trophy
	[11105]="1:0:12:0:1:::0:0:", -- Curled Map Parchment
	[5051]="1:1:12:0:20::185:0:0:", -- Dig Rat
	[8683]="4:1:12:0:20:Food::1:1:52", -- Clara's Fresh Apple
	[11515]="4:1:12:0:20:::0:0:", -- Corrupted Soul Shard
	[11514]="4:1:12:0:20:::0:0:", -- Fel Creep
	[11513]="4:1:12:0:20:::0:0:", -- Tainted Vitriol
	[17542]="8:2:12:0:20:::0:0:", -- Coldtooth Supplies
	[17522]="8:2:12:0:20:::0:0:", -- Irondeep Supplies
	[17422]="10:2:12:0:100:::0:0:", -- Armor Scraps
	[5446]="55:13:12:0:20:::0:0:", -- Broken Elemental Bracer
	[9265]="60:15:12:0:1:::0:0:", -- Cuergo's Hidden Treasure
	[5448]="70:17:12:0:20:::1:1:52", -- Fractured Elemental Bracer
	[5447]="80:20:12:0:20:::0:0:", -- Damaged Elemental Bracer
	[5451]="90:22:12:0:20:::1:1:52", -- Crushed Elemental Bracer
	[5075]="100:25:12:0:10:::1:1:52", -- Blood Shard
	[4278]="100:25:12:0:20:::0:0:", -- Lesser Bloodstone Ore
	[9308]="152:38:12:0:20:::1:1:52", -- Grime-Encrusted Object
	[9279]="180:45:12:0:1:::1:1:52", -- White Punch Card
	[9252]="250:62:12:0:1:::0:0:", -- Lower Map Fragment
	[9253]="250:62:12:0:1:::0:0:", -- Middle Map Fragment
	[9251]="250:62:12:0:1:::0:0:", -- Upper Map Fragment
	[2799]="270:67:12:0:20:::1:1:52", -- Gorilla Fang
	[4639]="650:162:12:0:1:::0:0:", -- Enchanted Sea Kelp
	[1939]="675:168:12:0:1:::1:1:51,52", -- Skin of Sweet Rum
	[8564]="800:200:12:0:1:::0:0:", -- Hippogryph Egg
	[1941]="815:203:12:0:1:::1:0:52,688", -- Cask of Merlot
	[8646]="1000:250:12:0:1:::0:0:", -- Bad Egg
	[8523]="1000:0:12:0:1:::0:0:", -- Field Testing Kit
	[11022]="1000:250:12:0:20:::0:0:", -- Packet of Tharlendris Seeds
	[1942]="1265:316:12:0:1:::1:0:52", -- Bottle of Moonshine
	[2725]="1500:375:12:0:10:::0:1:52", -- Green Hills of Stranglethorn - Page 1
	[2734]="1500:375:12:0:10:::0:1:52", -- Green Hills of Stranglethorn - Page 10
	[2735]="1500:375:12:0:10:::0:1:52", -- Green Hills of Stranglethorn - Page 11
	[2738]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 14
	[2740]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 16
	[2742]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 18
	[2744]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 20
	[2745]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 21
	[2748]="1500:375:12:0:10:::0:0:", -- Green Hills of Stranglethorn - Page 24
	[2749]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 25
	[2750]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 26
	[2751]="1500:375:12:0:10:::0:0:", -- Green Hills of Stranglethorn - Page 27
	[2728]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 4
	[2730]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 6
	[2732]="1500:375:12:0:10:::1:1:52", -- Green Hills of Stranglethorn - Page 8
	[10450]="1585:396:12:0:20:::0:0:", -- Undamaged Hippogryph Feather
	[11141]="2000:0:12:0:1:::0:0:", -- Bait
	[8645]="3000:750:12:0:1:::0:0:", -- Ordinary Egg
	[11566]="4000:1000:12:0:20:::0:0:", -- Crystal Charge
	[11563]="4000:1000:12:0:20:::0:0:", -- Crystal Force
	[11562]="4000:1000:12:0:20:::0:0:", -- Crystal Restore
	[11567]="4000:1000:12:0:20:::0:0:", -- Crystal Spire
	[11564]="4000:1000:12:0:20:::0:0:", -- Crystal Ward
	[11565]="4000:1000:12:0:20:::0:0:", -- Crystal Yield
	[13320]="5000:0:12:0:1:::0:0:", -- Arcane Quickener
	[8644]="6000:1500:12:0:1:::0:0:", -- Fine Egg
	[12457]="6000:1500:12:0:20:::0:0:", -- Juju Chill
	[12455]="6000:1500:12:0:20:::0:0:", -- Juju Ember
	[12459]="6000:1500:12:0:20:::0:0:", -- Juju Escape
	[12450]="6000:1500:12:0:20:::0:0:", -- Juju Flurry
	[12458]="6000:1500:12:0:20:::0:0:", -- Juju Guile
	[12460]="6000:1500:12:0:20:::0:0:", -- Juju Might
	[12451]="6000:1500:12:0:20:::0:0:", -- Juju Power
	[11020]="10000:0:12:0:1:::0:0:", -- Evergreen Pouch
	[8643]="10000:2500:12:0:1:::0:0:", -- Extraordinary Egg
	[18802]="60000:5000:12:0:5:::0:0:", -- Shadowy Potion
	[18629]="500000:0:12:0:1:::0:0:", -- Black Lodestone
	[18670]="500000:0:12:0:1:::0:0:", -- Xorothian Glyphs
	[18663]="1500000:0:12:0:1:::0:0:", -- J'eevee's Jar
	[18687]="1500000:0:12:0:1:::0:0:", -- Xorothian Stardust
	[18330]="0:0:12:0:1:::0:0:", -- Arcanum of Focus
	[18331]="0:0:12:0:1:::0:0:", -- Arcanum of Protection
	[18329]="0:0:12:0:1:::0:0:", -- Arcanum of Rapidity
	[12844]="0:0:12:0:250:::0:0:", -- Argent Dawn Valor Token
	[16408]="0:0:12:0:1:::0:0:", -- Befouled Water Globe
	[11754]="0:0:12:0:5::165:0:0:", -- Black Diamond
	[16663]="0:0:12:0:1:::0:0:", -- Blood of the Black Dragon Champion
	[12843]="0:0:12:0:250:::0:0:", -- Corruptor's Scourgestone
	[13347]="0:0:12:0:1:::0:0:", -- Crystal of Zin-Malor
	[12849]="0:0:12:0:1:::0:0:", -- Demon Kissed Sack
	[10454]="0:0:12:0:1:::0:0:", -- Essence of Eranikus
	[12735]="0:0:12:0:20:::0:0:", -- Frayed Abomination Stitching
	[12337]="0:0:12:0:1:::0:0:", -- Gemstone of Bloodaxe
	[12335]="0:0:12:0:1:::0:0:", -- Gemstone of Smolderthorn
	[12336]="0:0:12:0:1:::0:0:", -- Gemstone of Spirestone
	[10593]="0:0:12:0:20:::0:0:", -- Imperfect Draenethyst Fragment
	[11642]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Constitution
	[11644]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Resilience
	[11622]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Rumination
	[11643]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Tenacity
	[11646]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Voracity
	[11645]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Voracity
	[11647]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Voracity
	[11648]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Voracity
	[11649]="0:0:12:0:1:::0:0:", -- Lesser Arcanum of Voracity
	[9240]="0:0:12:0:1:::0:0:", -- Mallet of Zul'Farrak
	[8663]="0:0:12:0:1:::0:0:", -- Mithril Insignia
	[8524]="0:0:12:0:1:::0:0:", -- Model 4711-FTZ Power Source
	[8704]="0:0:12:0:1:::0:0:", -- OOX-09/HL Distress Beacon
	[8623]="0:0:12:0:1:::0:0:", -- OOX-17/TN Distress Beacon
	[8705]="0:0:12:0:1:::0:0:", -- OOX-22/FE Distress Beacon
	[18150]="0:0:12:0:1:::0:0:", -- Rune of Recall
	[16304]="0:0:12:0:1:::0:0:", -- Shadumbra's Head
	[16305]="0:0:12:0:1:::0:0:", -- Sharptalon's Claw
	[7666]="0:0:12:0:1:::0:0:", -- Shattered Necklace
	[19213]="0:0:12:0:250:::0:0:", -- Silverwing Talisman of Merit
	[16782]="0:0:12:0:1:::0:0:", -- Strange Water Globe
	[11463]="0:0:12:0:1:::0:0:", -- Undelivered Parcel
	[16303]="0:0:12:0:1:::0:0:", -- Ursangous's Paw
	[19322]="0:0:12:0:250:::0:0:", -- Warsong Mark of Honor
	[8703]="25968:6492:12:0:1:::0:0:", -- Signet of Expertise
	[18706]="40124:10031:12:0:1:::0:0:", -- Arena Master
	[10418]="65859:16464:12:0:1:::0:0:", -- Glimmering Mithril Insignia
	[18171]="100000:25000:12:0:1:::1:0:39,40,668", -- Arcane Mantle of the Dawn
	[18169]="100000:25000:12:0:1:::1:0:39,40,668", -- Flame Mantle of the Dawn
	[18170]="100000:25000:12:0:1:::1:0:39,40,668", -- Frost Mantle of the Dawn
	[18172]="100000:25000:12:0:1:::1:0:39,40,668", -- Nature Mantle of the Dawn
	[18173]="100000:25000:12:0:1:::1:0:39,40,668", -- Shadow Mantle of the Dawn
	[18182]="400000:100000:12:0:1:::1:0:40,668", -- Chromatic Mantle of the Dawn
	[18771]="0:0:12:0:1:::0:0:", -- Advanced Armorsmithing III - Enchanted Thorium Platemail
	[18779]="0:0:12:0:1:::0:0:", -- Bottom Half of Advanced Armorsmithing: Volume I
	[18781]="0:0:12:0:1:::0:0:", -- Bottom Half of Advanced Armorsmithing: Volume II
	[18783]="0:0:12:0:1:::0:0:", -- Bottom Half of Advanced Armorsmithing: Volume III
	[18769]="0:0:12:0:1:::0:0:", -- Enchanted Thorium Platemail
	[18770]="0:0:12:0:1:::0:0:", -- Enchanted Thorium Platemail
	[8244]="0:10000:12:0:20:::0:0:", -- Flawless Draenethyst Sphere
	[18335]="0:0:12:0:5:::0:0:", -- Pristine Black Diamond
	[17191]="0:0:12:0:1:::0:0:", -- Scepter of Celebras
	[18780]="0:0:12:0:1:::0:0:", -- Top Half of Advanced Armorsmithing: Volume I
	[18782]="0:0:12:0:1:::0:0:", -- Top Half of Advanced Armorsmithing: Volume II
	[18784]="0:0:12:0:1:::0:0:", -- Top Half of Advanced Armorsmithing: Volume III
	[12812]="0:0:12:0:1:::0:0:", -- Unfired Plate Gauntlets
	[12806]="0:0:12:0:1:::0:0:", -- Unforged Rune Covered Breastplate
	[17410]="0:0:12:0:1:::0:0:", -- Zinfizzlex's Portable Shredder Unit
	[18513]="0:0:12:0:1:::0:0:", -- A Dull and Flat Elven Blade
	[18703]="0:0:12:0:1:::0:0:", -- Ancient Petrified Leaf
	[18707]="0:0:12:0:1:::0:0:", -- Ancient Rune Etched Stave
	[18724]="0:0:12:0:1:::0:0:", -- Enchanted Black Dragon Sinew
	[18422]="0:0:12:0:1:::0:0:", -- Head of Onyxia
	[18423]="0:0:12:0:1:::0:0:", -- Head of Onyxia
	[18488]="0:0:12:0:1:::0:0:", -- Heated Ancient Blade
	[18705]="0:0:12:0:1:::0:0:", -- Mature Black Dragon Sinew
	[18704]="0:0:12:0:1:::0:0:", -- Mature Blue Dragon Sinew
	[12731]="0:0:12:0:1:::0:0:", -- Pristine Hide of the Beast
	[18659]="0:0:12:0:1:::0:0:", -- Splinter of Nordrassil
	[18492]="0:0:12:0:1:::0:0:", -- Treated Ancient Blade
	[18489]="0:0:12:0:1:::0:0:", -- Unfired Ancient Blade
	[18566]="0:0:12:0:1:::0:0:", -- Essence of the Firelord DEPRECATED
	[12301]="0:0:13:0:1:::0:0:", -- Bamboo Cage Key
	[4882]="0:0:13:0:1:::0:0:", -- Benedict's Key
	[4483]="0:0:13:0:1:::0:0:", -- Burning Key
	[3499]="0:0:13:0:1:::0:0:", -- Burnished Gold Key
	[5089]="0:0:13:0:1:::0:0:", -- Console Key
	[5851]="0:0:13:0:1:::0:0:", -- Cozzle's Key
	[18249]="0:0:13:0:1:::0:0:", -- Crescent Key
	[4484]="0:0:13:0:1:::0:0:", -- Cresting Key
	[13303]="0:0:13:0:20:::0:0:", -- Crusaders' Square Postbox Key
	[5397]="0:0:13:0:1:::0:0:", -- Defias Gunpowder
	[7923]="0:0:13:0:1:::0:0:", -- Defias Tower Key
	[3467]="0:0:13:0:1:::0:0:", -- Dull Iron Key
	[12144]="0:0:13:0:1:::0:0:", -- Eggscilloscope
	[13305]="0:0:13:0:20:::0:0:", -- Elders' Square Postbox Key
	[13304]="0:0:13:0:20:::0:0:", -- Festival Lane Postbox Key
	[13307]="0:0:13:0:20:::0:0:", -- Fras Siabi's Postbox Key
	[11079]="0:0:13:0:1:::0:0:", -- Gor'tesh's Lopped Off Head
	[18266]="0:0:13:0:1:::0:0:", -- Gordok Courtyard Key
	[18268]="0:0:13:0:1:::0:0:", -- Gordok Inner Door Key
	[11602]="0:0:13:0:1:::0:0:", -- Grim Guzzler Key
	[5050]="0:0:13:0:1:::0:0:", -- Ignition Key
	[2629]="0:0:13:0:1:::0:0:", -- Intrepid Strongbox Key
	[17262]="0:0:13:0:1:::0:0:", -- James' Key
	[17242]="0:0:13:0:1:::0:0:", -- Key to Salem's Chest
	[5396]="0:0:13:0:1:::0:0:", -- Key to Searing Gorge
	[12382]="0:0:13:0:1:::0:0:", -- Key to the City
	[13306]="0:0:13:0:20:::0:0:", -- King's Square Postbox Key
	[13302]="0:0:13:0:20:::0:0:", -- Market Row Postbox Key
	[3930]="0:0:13:0:1:::0:0:", -- Maury's Key
	[11140]="0:0:13:0:1:::0:0:", -- Prison Cell Key
	[11078]="0:0:13:0:20:::0:0:", -- Relic Coffer Key
	[3704]="0:0:13:0:1:::0:0:", -- Rusted Iron Key
	[12973]="0:0:13:0:1:::0:0:", -- Scarlet Cannonball
	[4103]="0:0:13:0:1:::0:0:", -- Shackle Key
	[11000]="0:0:13:0:1:::0:0:", -- Shadowforge Key
	[8072]="0:0:13:0:1:::0:0:", -- Silixiz's Tower Key
	[13704]="0:0:13:0:1:::0:0:", -- Skeleton Key
	[2719]="0:0:13:0:1:::0:0:", -- Small Brass Key
	[15874]="0:0:13:0:1:::0:0:", -- Soft-shelled Clam
	[9299]="0:0:13:0:1:::0:0:", -- Thermaplugg's Safe Combination
	[4485]="0:0:13:0:1:::0:0:", -- Thundering Key
	[13873]="0:0:13:0:1:::0:0:", -- Viewing Room Key
	[10757]="0:0:13:0:1:::0:0:", -- Ward of the Defiler
	[5475]="0:0:13:0:1:::0:0:", -- Wooden Key
	[6893]="0:0:13:0:1:::0:0:", -- Workshop Key
	[5020]="15:3:13:0:1:::0:0:", -- Kolkar Booty Key
	[10460]="2518:629:13:0:1:::0:0:", -- Hakkar'i Blood
	[7146]="0:0:13:0:1:::0:0:", -- The Scarlet Key
	[9249]="6215:1553:13:0:1:::0:0:", -- Captain's Key
	[18226]="0:0:15:0:1:::0:0:", -- A Sealed Pact
	[18365]="0:0:15:0:1:::0:0:", -- A Thoroughly Read Copy of "Nat Pagle's Extreme' Anglin."
	[18228]="0:0:15:0:1:::0:0:", -- Autographed Picture of Foror & Tigule
	[7135]="0:0:15:0:20:::0:0:", -- Broken Dragonmaw Shinbone
	[18230]="0:0:15:0:1:::0:0:", -- Broken I.W.I.N. Button
	[18234]="0:0:15:0:1:::0:0:", -- Document from Boomstick Imports
	[8426]="0:0:15:0:20:::0:0:", -- Large Ruffled Feather
	[8427]="0:0:15:0:20:::0:0:", -- Mutilated Rat Carcass
	[18229]="0:0:15:0:1:::0:0:", -- Nat Pagle's Guide to Extreme Anglin'
	[8425]="0:0:15:0:20:::0:0:", -- Parrot Droppings
	[7190]="0:0:15:0:1:::0:0:", -- Scorched Rocket Boots
	[18231]="0:0:15:0:1:::0:0:", -- Sleeveless T-Shirt
	[18233]="0:0:15:0:1:::0:0:", -- Tear Stained Handkerchief
	[2154]="0:0:15:0:1:::0:0:", -- The Story of Morgan Ladimore
	[5839]="4:1:15:0:1:::0:0:", -- Journal Page
	[755]="4:1:15:0:5:::0:0:", -- Melted Candle
	[5263]="4:1:15:0:10:::0:0:", -- Pocket Lint
	[6456]="12:3:15:0:10:::0:0:", -- Acidic Slime
	[7074]="16:4:15:0:5:::0:0:", -- Chipped Claw
	[6455]="16:4:15:0:5:::0:0:", -- Old Wagonwheel
	[6457]="16:4:15:0:5:::0:0:", -- Rusted Engineering Parts
	[4757]="19:4:15:0:5:::0:0:", -- Cracked Egg Shells
	[7101]="20:5:15:0:5:::0:0:", -- Bug Eye
	[2591]="20:5:15:0:5:::0:0:", -- Dirty Trogg Cloth
	[2590]="20:5:15:0:5:::0:0:", -- Forest Spider Webbing
	[7096]="20:5:15:0:5:::0:0:", -- Plucked Feather
	[4865]="20:5:15:0:5:::0:0:", -- Ruined Pelt
	[3171]="25:6:15:0:5:::0:0:", -- Broken Boar Tusk
	[7073]="25:6:15:0:5:::0:0:", -- Broken Fang
	[4814]="25:6:15:0:5:::0:0:", -- Discolored Fang
	[7099]="25:6:15:0:5:::0:0:", -- Severed Pincer
	[1476]="25:6:15:0:5:::0:0:", -- Snapped Spider Limb
	[7098]="25:6:15:0:5:::0:0:", -- Splintered Tusk
	[6297]="30:7:15:0:10:::0:0:", -- Old Skull
	[4879]="30:7:15:0:5:::0:0:", -- Squashed Rabbit Carcass
	[7100]="30:7:15:0:5:::0:0:", -- Sticky Ichor
	[4867]="35:8:15:0:5:::0:0:", -- Broken Scorpid Leg
	[555]="35:8:15:0:10:::0:0:", -- Rough Vulture Feathers
	[3300]="38:9:15:0:5:::0:0:", -- Rabbit's Foot
	[4877]="40:10:15:0:5:::0:0:", -- Stone Arrowhead
	[3769]="55:13:15:0:5:::0:0:", -- Broken Wand
	[3882]="55:13:15:0:10:::0:0:", -- Buzzard Feather
	[4779]="55:13:15:0:10:::0:0:", -- Dull Kodo Tooth
	[4875]="55:13:15:0:5:::0:0:", -- Slimy Bone
	[5329]="60:15:15:0:20:::0:0:", -- Cat Figurine
	[2085]="60:15:15:0:5:::0:0:", -- Chunk of Flesh
	[4873]="60:15:15:0:5:::0:0:", -- Dry Hardened Barnacle
	[16748]="60:15:15:0:20:::0:0:", -- Padded Lining
	[5361]="65:16:15:0:10:::0:0:", -- Fishbone Toothpick
	[5362]="75:18:15:0:5:::0:0:", -- Chew Toy
	[3169]="75:18:15:0:10:::0:0:", -- Chipped Bear Tooth
	[779]="75:18:15:0:5:::0:0:", -- Shiny Seashell
	[5363]="80:20:15:0:5:::0:0:", -- Folded Handkerchief
	[6301]="80:20:15:0:1:::0:0:", -- Old Teamster's Skull
	[1212]="85:21:15:0:5:::0:0:", -- Gnoll Spittle
	[777]="86:21:15:0:10:::0:0:", -- Prowler Teeth
	[6150]="90:22:15:0:20:::0:0:", -- A Frayed Knot
	[5601]="90:22:15:0:10:::0:0:", -- Hatched Egg Sac
	[5367]="90:22:15:0:5:::0:0:", -- Primitive Rock Tool
	[4100]="95:23:15:0:10:::0:0:", -- Crumpled Note
	[3767]="95:23:15:0:5:::0:0:", -- Fine Parchment
	[3181]="95:23:15:0:5:::0:0:", -- Partially Digested Meat
	[6304]="100:25:15:0:1:::0:0:", -- Damp Diary Page (Day 4)
	[6306]="100:25:15:0:1:::0:0:", -- Damp Diary Page (Day 512)
	[6305]="100:25:15:0:1:::0:0:", -- Damp Diary Page (Day 87)
	[3899]="100:25:15:0:1:::0:0:", -- Legends of the Gurubashi, Volume 3
	[4101]="105:26:15:0:10:::0:0:", -- Ripped Note
	[16747]="110:27:15:0:20:::0:0:", -- Broken Lock
	[5364]="110:27:15:0:5:::0:0:", -- Dry Salt Lick
	[1175]="115:28:15:0:1:::0:0:", -- A Gold Tooth
	[4775]="115:28:15:0:5:::0:0:", -- Cracked Bill
	[6296]="115:28:15:0:10:::0:0:", -- Patch of Bat Hair
	[3766]="120:30:15:0:10:::0:0:", -- Gryphon Feather Quill
	[8429]="125:31:15:0:10:::0:0:", -- Punctured Dew Gland
	[5369]="130:32:15:0:5:::0:0:", -- Gnawed Bone
	[6293]="135:33:15:0:10:::0:0:", -- Dried Bat Blood
	[4813]="135:33:15:0:10:::0:0:", -- Small Leather Collar
	[4102]="135:33:15:0:10:::0:0:", -- Torn Note
	[5370]="150:37:15:0:5:::0:0:", -- Bent Spoon
	[771]="155:38:15:0:5:::0:0:", -- Chipped Boar Tusk
	[9332]="155:38:15:0:20:::0:0:", -- Crusted Bandages
	[4776]="165:41:15:0:10:::0:0:", -- Ruffled Feather
	[2940]="175:43:15:0:5:::0:0:", -- Bloody Bear Paw
	[3673]="180:45:15:0:100:::0:0:", -- Broken Arrow
	[4874]="185:46:15:0:5:::0:0:", -- Clean Fishbones
	[8430]="185:46:15:0:10:::0:0:", -- Empty Dew Gland
	[9334]="190:47:15:0:10:::0:0:", -- Cracked Pottery
	[3170]="190:47:15:0:10:::0:0:", -- Large Bear Tooth
	[5368]="195:48:15:0:5:::0:0:", -- Empty Wallet
	[3299]="195:48:15:0:10:::0:0:", -- Fractured Canine
	[5371]="195:48:15:0:5:::0:0:", -- Piece of Coral
	[15793]="200:50:15:0:20:::0:0:", -- A Chewed Bone
	[15798]="200:50:15:0:20:::0:0:", -- Chipped Ogre Teeth
	[3177]="200:50:15:0:10:::0:0:", -- Tiny Fang
	[9335]="210:52:15:0:5:::0:0:", -- Broken Obsidian Club
	[4878]="225:56:15:0:1:::0:0:", -- Broken Bloodstained Bow
	[7296]="225:56:15:0:5:::0:0:", -- Extinguished Torch
	[4780]="225:56:15:0:5:::0:0:", -- Kodo Horn Fragment
	[5377]="230:57:15:0:5:::0:0:", -- Scallop Shell
	[5602]="255:63:15:0:10:::0:0:", -- Sticky Spider Webbing
	[2608]="255:63:15:0:5:::0:0:", -- Threshadon Ambergris
	[1630]="265:66:15:0:5:::0:0:", -- Broken Electro-lantern
	[5376]="265:66:15:0:5:::0:0:", -- Broken Mirror
	[3723]="275:68:15:0:5:::0:0:", -- Familiar Fang
	[3167]="275:68:15:0:10:::0:0:", -- Thick Spider Hair
	[11384]="280:70:15:0:20:::0:0:", -- Broken Basilisk Teeth
	[2295]="280:70:15:0:5:::0:0:", -- Large Boar Tusk
	[3670]="280:70:15:0:5:::0:0:", -- Large Slimy Bone
	[5506]="285:71:15:0:5:::0:0:", -- Beady Eye Stalk
	[1464]="285:71:15:0:5:::0:0:", -- Buzzard Talon
	[5118]="285:71:15:0:10:::0:0:", -- Large Flat Tooth
	[1520]="285:71:15:0:5:::0:0:", -- Troll Sweat
	[3176]="300:75:15:0:10:::0:0:", -- Small Claw
	[4876]="315:78:15:0:5:::0:0:", -- Bloody Leather Boot
	[11390]="320:80:15:0:20:::0:0:", -- Broken Bat Fang
	[3724]="325:81:15:0:5:::0:0:", -- Familiar Claw
	[3401]="325:81:15:0:5:::0:0:", -- Rough Crocolisk Scale
	[3399]="325:81:15:0:5:::0:0:", -- Vulture Talon
	[887]="330:82:15:0:5:::0:0:", -- Pound of Flesh
	[1706]="344:86:15:0:10:::0:0:", -- Azuredeep Shards
	[4880]="345:86:15:0:5:::0:0:", -- Broken Spear
	[537]="350:87:15:0:5:::0:0:", -- Dull Frenzy Scale
	[5374]="350:87:15:0:5:::0:0:", -- Small Pocket Watch
	[6445]="352:88:15:0:5:::0:0:", -- Brittle Molting
	[5134]="370:92:15:0:5:::0:0:", -- Small Furry Paw
	[3674]="380:95:15:0:5:::0:0:", -- Decomposed Boot
	[4872]="380:95:15:0:5:::0:0:", -- Dry Scorpid Eye
	[5375]="380:95:15:0:5:::0:0:", -- Scratching Stick
	[5269]="380:95:15:0:5:::0:0:", -- Silithid Ichor
	[5114]="385:96:15:0:5:::0:0:", -- Severed Talon
	[3175]="400:100:15:0:10:::0:0:", -- Ruined Dragonhide
	[5115]="405:101:15:0:5:::0:0:", -- Broken Wishbone
	[3010]="405:101:15:0:5:::0:0:", -- Fine Sand
	[3301]="410:102:15:0:10:::0:0:", -- Sharp Canine
	[5566]="420:105:15:0:5:::0:0:", -- Broken Antler
	[556]="425:106:15:0:5:::0:0:", -- Buzzard Beak
	[3676]="425:106:15:0:5:::0:0:", -- Slimy Ichor
	[11407]="435:108:15:0:10:::0:0:", -- Torn Bear Pelt
	[5741]="445:111:15:0:20:::0:0:", -- Rock Chip
	[5124]="470:117:15:0:10:::0:0:", -- Small Raptor Tooth
	[5123]="470:117:15:0:5:::0:0:", -- Steel Arrowhead
	[5119]="475:118:15:0:10:::0:0:", -- Fine Loose Hair
	[3179]="500:125:15:0:10:::0:0:", -- Cracked Dragon Molting
	[6298]="520:130:15:0:20:::0:0:", -- Bloody Bat Fang
	[5429]="550:137:15:0:5:::0:0:", -- A Pretty Rock
	[893]="550:137:15:0:10:::0:0:", -- Dire Wolf Fang
	[5433]="555:138:15:0:5:::0:0:", -- Rag Doll
	[10457]="570:142:15:0:5:::0:0:", -- Empty Sea Snail Shell
	[5135]="570:142:15:0:5:::0:0:", -- Thin Black Claw
	[11385]="580:145:15:0:20:::0:0:", -- Basilisk Scale
	[5427]="590:147:15:0:5:::0:0:", -- Crude Pocket Watch
	[4459]="600:150:15:0:10:::0:0:", -- Brittle Dragon Bone
	[5125]="620:155:15:0:5:::0:0:", -- Charged Scale
	[5431]="620:155:15:0:5:::0:0:", -- Empty Hip Flask
	[4555]="620:155:15:0:5:::0:0:", -- Thick Scaly Tail
	[5121]="650:162:15:0:5:::0:0:", -- Dirty Kodo Scale
	[3725]="666:166:15:0:5:::0:0:", -- Familiar Horn
	[3180]="675:168:15:0:5:::0:0:", -- Flecked Raptor Scale
	[11406]="675:168:15:0:5:::0:0:", -- Rotting Bear Carcass
	[4460]="700:175:15:0:10:::0:0:", -- Ripped Wing Webbing
	[5136]="710:177:15:0:5:::0:0:", -- Torn Furry Ear
	[3931]="740:185:15:0:5:::0:0:", -- Poisoned Spider Fang
	[5120]="775:193:15:0:5:::0:0:", -- Long Tail Hair
	[3669]="780:195:15:0:5:::0:0:", -- Gelatinous Goo
	[5567]="785:196:15:0:5:::0:0:", -- Silver Hook
	[3671]="805:201:15:0:5:::0:0:", -- Lifeless Skull
	[5128]="810:202:15:0:5:::0:0:", -- Shed Lizard Skin
	[5569]="815:203:15:0:5:::0:0:", -- Seaweed
	[11391]="820:205:15:0:10:::0:0:", -- Spined Bat Wing
	[3722]="855:213:15:0:5:::0:0:", -- Familiar Hide
	[9356]="870:217:15:0:5:::0:0:", -- A Wooden Leg
	[5137]="870:217:15:0:5:::0:0:", -- Bright Eyeball
	[5268]="875:218:15:0:5:::0:0:", -- Cracked Silithid Shell
	[4557]="900:225:15:0:10:::0:0:", -- Fiery Gland
	[9357]="910:227:15:0:10:::0:0:", -- A Parrot Skeleton
	[9358]="915:228:15:0:20:::0:0:", -- A Head Rag
	[6444]="915:228:15:0:5:::0:0:", -- Forked Tongue
	[6439]="950:237:15:0:5:::0:0:", -- Broken Binding Bracer
	[1687]="975:243:15:0:5:::0:0:", -- Retractable Claw
	[5113]="1000:250:15:0:5:::0:0:", -- Mark of the Syndicate
	[5435]="1090:272:15:0:5:::0:0:", -- Shiny Dinglehopper
	[5430]="1110:277:15:0:5:::0:0:", -- Intricate Bauble
	[5122]="1150:287:15:0:10:::0:0:", -- Thick Kodo Hair
	[5133]="1200:300:15:0:5:::0:0:", -- Seeping Gizzard
	[4097]="1220:305:15:0:10:::0:0:", -- Chipped Gorilla Tooth
	[770]="1265:316:15:0:10:::0:0:", -- Pointy Crocolisk Tooth
	[5871]="1275:318:15:0:5:::0:0:", -- Large Hoof
	[1702]="1280:320:15:0:5:::0:0:", -- Intact Basilisk Spine
	[3403]="1285:321:15:0:5:::0:0:", -- Ivory Boar Tusk
	[5428]="1290:322:15:0:5:::0:0:", -- An Exotic Cookbook
	[11416]="1315:328:15:0:10:::0:0:", -- Delicate Ribcage
	[5432]="1320:330:15:0:5:::0:0:", -- Hickory Pipe
	[4428]="1325:331:15:0:5:::0:0:", -- Spider Palp
	[4784]="1440:360:15:0:5:::0:0:", -- Lifeless Stone
	[6438]="1450:362:15:0:5:::0:0:", -- Dull Elemental Bracer
	[1701]="1505:376:15:0:5:::0:0:", -- Curved Basilisk Claw
	[9355]="1505:376:15:0:20:::0:0:", -- Hoop Earring
	[11940]="1558:389:15:0:20:::0:0:", -- Sparkly Necklace
	[11392]="1612:403:15:0:5:::0:0:", -- Severed Bat Claw
	[4553]="1645:411:15:0:5:::0:0:", -- Jagged Piece of Stone
	[4591]="1655:413:15:0:5:::0:0:", -- Eagle Eye
	[6300]="1775:443:15:0:10:::0:0:", -- Husk Fragment
	[1697]="1780:445:15:0:10:::0:0:", -- Keen Raptor Tooth
	[1074]="1965:491:15:0:5:::0:0:", -- Hard Spider Leg Tip
	[3702]="1995:498:15:0:10:::0:0:", -- Bear Gall Bladder
	[11409]="2015:503:15:0:10:::0:0:", -- Bear Flank
	[4552]="2120:530:15:0:10:::0:0:", -- Smooth Stone Chip
	[6826]="2195:548:15:0:10:::0:0:", -- Brilliant Scale
	[4787]="2310:577:15:0:5:::0:0:", -- Burning Pitch
	[11410]="2315:578:15:0:10:::0:0:", -- Savage Bear Claw
	[11394]="2320:580:15:0:10:::0:0:", -- Bat Heart
	[4585]="2335:583:15:0:5:::0:0:", -- Dripping Spider Mandible
	[3402]="2410:602:15:0:5:::0:0:", -- Soft Patch of Fur
	[11418]="2416:604:15:0:5:::0:0:", -- Hollow Wing Bone
	[1696]="2425:606:15:0:5:::0:0:", -- Curved Raptor Talon
	[6302]="2515:628:15:0:5:::0:0:", -- Delicate Insect Wing
	[4590]="2620:655:15:0:5:::0:0:", -- Curved Yellow Bill
	[11939]="2684:671:15:0:20:::0:0:", -- Shiny Bracelet
	[11386]="2705:676:15:0:10:::0:0:", -- Squishy Basilisk Eye
	[4554]="2835:708:15:0:5:::0:0:", -- Shiny Polished Stone
	[4093]="2855:713:15:0:5:::0:0:", -- Large Basilisk Tail
	[4586]="2855:713:15:0:5:::0:0:", -- Smooth Raptor Skin
	[1686]="2935:733:15:0:10:::0:0:", -- Bristly Whisker
	[4860]="2965:741:15:0:5:::0:0:", -- Glistening Frenzy Scale
	[4582]="2980:745:15:0:5:::0:0:", -- Soft Bushy Tail
	[11393]="3120:780:15:0:10:::0:0:", -- Small Bat Skull
	[4580]="3150:787:15:0:10:::0:0:", -- Sabertooth Fang
	[5829]="3216:804:15:0:5:::0:0:", -- Razor-sharp Beak
	[1688]="3225:806:15:0:5:::0:0:", -- Long Soft Tail
	[4587]="3230:807:15:0:10:::0:0:", -- Tribal Raptor Feathers
	[4583]="3250:812:15:0:5:::0:0:", -- Thick Furry Mane
	[5117]="3300:825:15:0:10:::0:0:", -- Vibrant Plume
	[11395]="3320:830:15:0:10:::0:0:", -- Bat Ear
	[4581]="3450:862:15:0:5:::0:0:", -- Patch of Fine Fur
	[11408]="3595:898:15:0:10:::0:0:", -- Bear Jaw
	[4588]="3600:900:15:0:5:::0:0:", -- Pristine Raptor Skull
	[4556]="3615:903:15:0:5:::0:0:", -- Speckled Shell Fragment
	[4584]="3750:937:15:0:5:::0:0:", -- Large Trophy Paw
	[11387]="4055:1013:15:0:5:::0:0:", -- Basilisk Heart
	[4099]="4525:1131:15:0:5:::0:0:", -- Tuft of Gorilla Hair
	[11417]="4816:1204:15:0:5:::0:0:", -- Feathery Wing
	[11402]="4820:1205:15:0:10:::0:0:", -- Sleek Bat Pelt
	[9336]="5155:1288:15:0:5:::0:0:", -- Gold-capped Troll Tusk
	[4092]="5185:1296:15:0:5:::0:0:", -- Prismatic Basilisk Scale
	[11388]="6255:1563:15:0:5:::0:0:", -- Basilisk Venom
	[4558]="6260:1565:15:0:1:::0:0:", -- Empty Barrel
	[11403]="6370:1592:15:0:10:::0:0:", -- Large Bat Fang
	[18237]="6490:1622:15:0:20:::0:0:", -- Mastiff Jawbone
	[11420]="6850:1712:15:0:10:::0:0:", -- Elegant Writing Tool
	[18224]="6912:1728:15:0:40:::0:0:", -- Lasher Root
	[11414]="7315:1828:15:0:10:::0:0:", -- Grizzled Mane
	[11419]="7600:1900:15:0:10:::0:0:", -- Mysterious Unhatched Egg
	[11404]="8320:2080:15:0:10:::0:0:", -- Evil Bat Eye
	[11389]="8655:2163:15:0:5:::0:0:", -- Shimmering Basilisk Skin
	[9242]="9685:2421:15:0:1:::0:0:", -- Ancient Tablet
	[18236]="10864:2716:15:0:20:::0:0:", -- Gordok Chew Toy
	[18286]="11812:2953:15:0:20:::0:0:", -- Condensed Mana Fragment
	[18222]="12280:3070:15:0:20:::0:0:", -- Thorny Vine
	[18285]="18234:4558:15:0:20:::0:0:", -- Crystallized Mana Shard
	[11942]="21215:5303:15:0:10:::0:0:", -- Legal Documents
	[11941]="23584:5896:15:0:10:::0:0:", -- False Documents
	[18223]="24568:6142:15:0:20:::0:0:", -- Serrated Petal
	[11944]="35284:8821:15:0:1:::0:0:", -- Dark Iron Baby Booties
	[11943]="85941:21485:15:0:1:::0:0:", -- Deed to Thandol Span
	[10456]="0:0:15:0:1:::0:0:", -- A Bulging Coin Purse
	[11883]="0:0:15:0:1:::0:0:", -- A Dingy Fanny Pack
	[19450]="0:0:15:0:1:::0:0:", -- A Jubling's Tiny Home
	[5335]="0:0:15:0:1:::0:0:", -- A Sack of Coins
	[6755]="0:0:15:0:1:::0:0:", -- A Small Container of Gems
	[11955]="0:0:15:0:1:::0:0:", -- Bag of Empty Ooze Containers
	[16882]="0:0:15:0:1:::0:0:", -- Battered Junkbox
	[10575]="0:0:15:0:10:::0:0:", -- Black Dragonflight Molt
	[7668]="0:0:15:0:1:::0:0:", -- Bloodstained Journal
	[10695]="0:0:15:0:1:::0:0:", -- Box of Empty Vials
	[7907]="0:0:15:0:1:::0:0:", -- Certificate of Thievery
	[7247]="0:0:15:0:1:::0:0:", -- Chest of Containment Coffers
	[15103]="0:0:15:0:1:::0:0:", -- Corrupt Tested Sample
	[5738]="0:0:15:0:1:::0:0:", -- Covert Ops Pack
	[10840]="0:0:15:0:1:::0:0:", -- Crystallized Note
	[10839]="0:0:15:0:1:::0:0:", -- Crystallized Note
	[16790]="0:0:15:0:1:::0:0:", -- Damp Note
	[19422]="0:0:15:0:1:::0:0:", -- Darkmoon Faire Fortune
	[13584]="0:0:15:0:1:::0:0:", -- Diablo Stone
	[11582]="0:0:15:0:1:::0:0:", -- Fel Salve
	[10834]="0:0:15:0:1:::0:0:", -- Felhound Tracker Kit
	[16967]="0:0:15:0:1:::0:0:", -- Feralas Ahi
	[11423]="0:0:15:0:1:::0:0:", -- Gnome Engineer's Renewal Gift
	[11422]="0:0:15:0:1:::0:0:", -- Goblin Engineer's Renewal Gift
	[5863]="0:0:15:0:1:::0:0:", -- Guild Charter
	[6948]="0:0:15:0:1:::0:0:", -- Hearthstone
	[16885]="0:0:15:0:1:::0:0:", -- Heavy Junkbox
	[10569]="0:0:15:0:1:::0:0:", -- Hoard of the Black Dragonflight
	[18598]="0:0:15:0:1:::0:0:", -- Human Orphan Whistle
	[18597]="0:0:15:0:1:::0:0:", -- Orcish Orphan Whistle
	[11912]="0:0:15:0:1:::0:0:", -- Package of Empty Ooze Containers
	[13583]="0:0:15:0:1:::0:0:", -- Panda Collar
	[8383]="0:0:15:0:1:::0:0:", -- Plain Letter
	[8087]="0:0:15:0:1:::0:0:", -- Sample of Zanzil's Altered Mixture
	[19229]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #1
	[19245]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #10
	[19248]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #13
	[19250]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #15
	[19251]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #16
	[19253]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #17
	[19256]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #2
	[19254]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #21
	[19255]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #22
	[19424]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #24
	[19452]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #27
	[19453]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #28
	[19238]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #3
	[19239]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #4
	[19243]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #8
	[19244]="0:0:15:0:1:::0:0:", -- Sayge's Fortune #9
	[17008]="0:0:15:0:1:::0:0:", -- Small Scroll
	[17727]="0:0:15:0:1:::0:0:", -- Smokywood Pastures Gift Pack
	[17685]="0:0:15:0:1:::0:0:", -- Smokywood Pastures Sampler
	[17726]="0:0:15:0:1:::0:0:", -- Smokywood Pastures Special Gift
	[16884]="0:0:15:0:1:::0:0:", -- Sturdy Junkbox
	[7209]="0:0:15:0:1:::0:0:", -- Tazan's Satchel
	[12033]="0:0:15:0:1:::0:0:", -- Thaurissan Family Jewels
	[17735]="0:0:15:0:1:::0:0:", -- The Feast of Winter Veil
	[19484]="0:0:15:0:1:::1:0:224,774", -- The Frostwolf Artichoke
	[11568]="0:0:15:0:1:::0:0:", -- Torwa's Pouch
	[10467]="0:0:15:0:1:::0:0:", -- Trader's Satchel
	[15102]="0:0:15:0:1:::0:0:", -- Un'Goro Tested Sample
	[5052]="0:0:15:0:1:::0:0:", -- Unconscious Dig Rat
	[19462]="0:0:15:0:1:::0:0:", -- Unhatched Jubling Egg
	[12565]="0:0:15:0:1:::0:0:", -- Winna's Kitten Carrier
	[17712]="0:0:15:0:1:::0:0:", -- Winter Veil Disguise Kit
	[16883]="0:0:15:0:1:::0:0:", -- Worn Junkbox
	[13582]="0:0:15:0:1:::0:0:", -- Zergling Leash
	[6356]="4:1:15:0:1:::0:0:", -- Battered Chest
	[6351]="4:1:15:0:1:::0:0:", -- Dented Crate
	[13874]="4:1:15:0:1:::0:0:", -- Heavy Crate
	[13875]="4:1:15:0:1:::0:0:", -- Ironbound Locked Chest
	[6307]="4:1:15:0:1:::0:0:", -- Message in a Bottle
	[13918]="4:1:15:0:1:::0:0:", -- Reinforced Locked Chest
	[6357]="4:1:15:0:1:::0:0:", -- Sealed Crate
	[6353]="4:1:15:0:1:::0:0:", -- Small Chest
	[6354]="4:1:15:0:1:::0:0:", -- Small Locked Chest
	[6355]="4:1:15:0:1:::0:0:", -- Sturdy Locked Chest
	[6352]="4:1:15:0:1:::0:0:", -- Waterlogged Crate
	[11110]="10:2:15:0:1:::0:0:", -- Chicken Egg
	[17195]="10:0:15:0:20:::0:0:", -- Mistletoe
	[17058]="30:7:15:0:20::-7:0:0:", -- Fish Oil
	[17056]="30:7:15:0:20::-8,-5:0:0:", -- Light Feather
	[17057]="30:7:15:0:20::-7:0:0:", -- Shiny Fish Scales
	[6292]="34:8:15:0:1:::0:0:", -- 10 Pound Mud Snapper
	[6294]="40:10:15:0:1:::0:0:", -- 12 Pound Mud Snapper
	[6295]="48:12:15:0:1:::0:0:", -- 15 Pound Mud Snapper
	[11887]="50:12:15:0:1:::0:0:", -- Cenarion Circle Cache
	[6712]="50:12:15:0:1:::0:0:", -- Practice Lock
	[9363]="50:12:15:0:1:::0:0:", -- Sparklematic-Wrapped Box
	[5332]="60:15:15:0:1:::0:0:", -- Glowing Cat Figurine
	[5523]="60:15:15:0:1:::0:0:", -- Small Barnacled Clam
	[5524]="85:21:15:0:1:::0:0:", -- Thick-shelled Clam
	[13901]="100:25:15:0:1:::0:0:", -- 15 Pound Salmon
	[13902]="100:25:15:0:1:::0:0:", -- 18 Pound Salmon
	[13903]="100:25:15:0:1:::0:0:", -- 22 Pound Salmon
	[13904]="100:25:15:0:1:::0:0:", -- 25 Pound Salmon
	[13905]="100:25:15:0:1:::0:0:", -- 29 Pound Salmon
	[13876]="100:25:15:0:1:::0:0:", -- 40 Pound Grouper
	[18664]="100:25:15:0:1:::1:0:635", -- A Treatise on Military Ranks
	[7286]="100:25:15:0:10::165:0:0:", -- Black Whelp Scale
	[18675]="100:25:15:0:1:::1:0:708", -- Military Ranks of the Horde & Alliance
	[15699]="100:25:15:0:1:::0:0:", -- Small Brown-wrapped Package
	[13877]="120:30:15:0:1:::0:0:", -- 47 Pound Grouper
	[13878]="130:32:15:0:1:::0:0:", -- 53 Pound Grouper
	[13879]="140:35:15:0:1:::0:0:", -- 59 Pound Grouper
	[13880]="150:37:15:0:1:::0:0:", -- 68 Pound Grouper
	[7973]="185:46:15:0:1:::0:0:", -- Big-mouth Clam
	[13885]="200:50:15:0:1:::0:0:", -- 34 Pound Redgill
	[13886]="200:50:15:0:1:::0:0:", -- 37 Pound Redgill
	[13907]="200:50:15:0:1:::0:0:", -- 7 Pound Lobster
	[9539]="200:50:15:0:1:::0:0:", -- Box of Rations
	[13909]="220:55:15:0:1:::0:0:", -- 12 Pound Lobster
	[13908]="220:55:15:0:1:::0:0:", -- 9 Pound Lobster
	[13882]="240:60:15:0:1:::0:0:", -- 42 Pound Redgill
	[13883]="240:60:15:0:1:::0:0:", -- 45 Pound Redgill
	[13910]="250:62:15:0:1:::0:0:", -- 15 Pound Lobster
	[16645]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 1
	[16654]="250:62:15:0:1:::0:0:", -- Shredder Operating Manual - Page 10
	[16655]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 11
	[16656]="250:62:15:0:1:::0:0:", -- Shredder Operating Manual - Page 12
	[16646]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 2
	[16647]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 3
	[16648]="250:62:15:0:1:::0:0:", -- Shredder Operating Manual - Page 4
	[16649]="250:62:15:0:1:::0:0:", -- Shredder Operating Manual - Page 5
	[16650]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 6
	[16651]="250:62:15:0:1:::0:0:", -- Shredder Operating Manual - Page 7
	[16652]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 8
	[16653]="250:62:15:0:1:::1:1:52", -- Shredder Operating Manual - Page 9
	[9259]="258:64:15:0:20:::0:0:", -- Troll Tribal Necklace
	[8484]="275:68:15:0:1:::0:0:", -- Gadgetzan Water Co. Care Package
	[5373]="290:72:15:0:5::165:0:0:", -- Lucky Charm
	[13884]="300:75:15:0:1:::0:0:", -- 49 Pound Redgill
	[13911]="320:80:15:0:1:::0:0:", -- 19 Pound Lobster
	[13912]="360:90:15:0:1:::0:0:", -- 21 Pound Lobster
	[6309]="400:100:15:0:1:::0:0:", -- 17 Pound Catfish
	[9276]="400:100:15:0:1:::0:0:", -- Pirate's Footlocker
	[7287]="400:100:15:0:5::165:0:0:", -- Red Whelp Scale
	[13914]="500:125:15:0:1:::0:0:", -- 70 Pound Mightfish
	[13915]="500:125:15:0:1:::0:0:", -- 85 Pound Mightfish
	[11018]="585:146:15:0:10:::0:0:", -- Un'Goro Soil
	[6310]="600:150:15:0:1:::0:0:", -- 19 Pound Catfish
	[9540]="600:150:15:0:1:::0:0:", -- Box of Spells
	[6827]="600:150:15:0:1:::0:0:", -- Box of Supplies
	[11966]="658:164:15:0:1:::0:0:", -- Small Sack of Coins
	[8483]="685:171:15:0:20:::0:0:", -- Wastewander Water Pouch
	[11937]="749:187:15:0:1:::0:0:", -- Fat Sack of Coins
	[6311]="750:187:15:0:1:::0:0:", -- 22 Pound Catfish
	[9541]="800:200:15:0:1:::0:0:", -- Box of Goodies
	[7392]="800:200:15:0:5::165,333:0:0:", -- Green Whelp Scale
	[11938]="854:213:15:0:1:::0:0:", -- Sack of Gems
	[6363]="1000:250:15:0:1:::0:0:", -- 26 Pound Catfish
	[8154]="1000:250:15:0:20::165:0:0:", -- Scorpid Scale
	[6364]="1500:375:15:0:1:::0:0:", -- 32 Pound Catfish
	[15415]="2000:500:15:0:20::165:0:0:", -- Blue Dragonscale
	[15412]="2000:500:15:0:20::165:0:0:", -- Green Dragonscale
	[15408]="2000:500:15:0:20::165:0:0:", -- Heavy Scorpid Scale
	[8497]="2000:500:15:0:1:::0:0:", -- Rabbit Crate (Snowshoe)
	[11474]="2000:500:15:0:1:::0:0:", -- Sprite Darter Egg
	[8165]="2000:500:15:0:20::165:0:0:", -- Worn Dragonscale
	[4589]="2120:530:15:0:10::197:0:0:", -- Long Elegant Feather
	[4096]="2435:608:15:0:10::165:0:0:", -- Coarse Gorilla Hair
	[15416]="4000:1000:15:0:20::165:0:0:", -- Black Dragonscale
	[8485]="4000:1000:15:0:1:::1:0:163", -- Cat Carrier (Bombay)
	[8486]="4000:1000:15:0:1:::1:0:163", -- Cat Carrier (Cornish Rex)
	[8487]="4000:1000:15:0:1:::1:0:163", -- Cat Carrier (Orange Tabby)
	[8488]="4000:1000:15:0:1:::1:0:163", -- Cat Carrier (Silver Tabby)
	[10398]="4000:1000:15:0:1:::0:0:", -- Mechanical Chicken
	[8496]="4000:1000:15:0:1:::1:1:618", -- Parrot Cage (Cockatiel)
	[8492]="4000:1000:15:0:1:::0:0:", -- Parrot Cage (Green Wing Macaw)
	[8494]="4000:1000:15:0:1:::0:0:", -- Parrot Cage (Hyacinth Macaw)
	[8495]="4000:1000:15:0:1:::1:1:618", -- Parrot Cage (Senegal)
	[10360]="5000:1250:15:0:1:::1:0:866", -- Black Kingsnake
	[10361]="5000:1250:15:0:1:::1:0:866", -- Brown Snake
	[10393]="5000:1250:15:0:1:::0:0:", -- Cockroach
	[10392]="5000:1250:15:0:1:::1:0:866", -- Crimson Snake
	[8500]="5000:1250:15:0:1:::1:0:727", -- Great Horned Owl
	[8501]="5000:1250:15:0:1:::1:0:727", -- Hawk Owl
	[10394]="5000:1250:15:0:1:::0:0:", -- Prairie Dog Whistle
	[8491]="6000:1500:15:0:1:::0:0:", -- Cat Carrier (Black Tabby)
	[8490]="6000:1500:15:0:1:::0:0:", -- Cat Carrier (Siamese)
	[8489]="6000:1500:15:0:1:::1:1:524", -- Cat Carrier (White Kitten)
	[15414]="6000:1500:15:0:20::165:0:0:", -- Red Dragonscale
	[12529]="6000:1500:15:0:1:::0:0:", -- Smolderweb Carrier
	[12264]="6000:1500:15:0:1:::0:0:", -- Worg Carrier
	[13364]="8000:2000:15:0:20:::0:0:", -- Fras Siabi's Advertisement
	[13362]="8000:2000:15:0:20:::0:0:", -- Letter from the Front
	[13363]="8000:2000:15:0:20:::0:0:", -- Municipal Proclamation
	[13365]="8000:2000:15:0:20:::0:0:", -- Town Meeting Notice
	[11023]="10000:2500:15:0:1:::0:0:", -- Ancona Chicken
	[10822]="10000:2500:15:0:1:::0:0:", -- Dark Whelpling
	[8499]="10000:2500:15:0:1:::0:0:", -- Tiny Crimson Whelpling
	[8498]="10000:2500:15:0:1:::0:0:", -- Tiny Emerald Whelpling
	[11026]="10000:2500:15:0:1:::0:0:", -- Tree Frog Box
	[11027]="10000:2500:15:0:1:::0:0:", -- Wood Frog Box
	[13366]="12000:3000:15:0:20:::0:0:", -- Ingenious Toy
	[15902]="80000:20000:15:0:1:::0:0:", -- A Crazy Grab Bag
	[2411]="800000:0:15:0:1:::1:0:449,820", -- Black Stallion Bridle
	[8595]="800000:0:15:0:1:::1:0:581", -- Blue Mechanostrider
	[13332]="800000:0:15:0:1:::1:0:877", -- Blue Skeletal Horse
	[5656]="800000:0:15:0:1:::1:0:270,449,576,820", -- Brown Horse Bridle
	[15290]="800000:0:15:0:1:::1:0:313", -- Brown Kodo
	[5872]="800000:0:15:0:1:::1:1:834", -- Brown Ram
	[13333]="800000:0:15:0:1:::1:0:877", -- Brown Skeletal Horse
	[5655]="800000:0:15:0:1:::1:0:270,449,576,820", -- Chestnut Mare Bridle
	[15277]="800000:0:15:0:1:::1:0:313", -- Gray Kodo
	[5864]="800000:0:15:0:1:::1:1:834", -- Gray Ram
	[13321]="800000:0:15:0:1:::1:0:581", -- Green Mechanostrider
	[5668]="800000:0:15:0:1:::1:1:637", -- Horn of the Brown Wolf
	[5665]="800000:0:15:0:1:::1:1:637", -- Horn of the Dire Wolf
	[1132]="800000:0:15:0:1:::0:1:637,723", -- Horn of the Timber Wolf
	[2414]="800000:0:15:0:1:::1:0:270,449,576,820", -- Pinto Bridle
	[8563]="800000:0:15:0:1:::1:0:581", -- Red Mechanostrider
	[13331]="800000:0:15:0:1:::1:0:877", -- Red Skeletal Horse
	[8632]="800000:0:15:0:1:::1:0:518", -- Reins of the Spotted Frostsaber
	[8631]="800000:0:15:0:1:::1:0:518", -- Reins of the Striped Frostsaber
	[8629]="800000:0:15:0:1:::1:0:518", -- Reins of the Striped Nightsaber
	[13322]="800000:0:15:0:1:::1:0:581", -- Unpainted Mechanostrider
	[8588]="800000:0:15:0:1:::1:0:723,891", -- Whistle of the Emerald Raptor
	[8591]="800000:0:15:0:1:::1:0:723,891", -- Whistle of the Turquoise Raptor
	[8592]="800000:0:15:0:1:::1:0:723,891", -- Whistle of the Violet Raptor
	[5873]="800000:0:15:0:1:::1:1:834", -- White Ram
	[18243]="1000000:0:15:0:1:::0:0:", -- Black Battlestrider
	[18247]="1000000:0:15:0:1:::0:0:", -- Black War Kodo
	[18244]="1000000:0:15:0:1:::0:0:", -- Black War Ram
	[18241]="1000000:0:15:0:1:::0:0:", -- Black War Steed Bridle
	[18245]="1000000:0:15:0:1:::0:0:", -- Horn of the Black War Wolf
	[18248]="1000000:0:15:0:1:::0:0:", -- Red Skeletal Warhorse
	[18242]="1000000:0:15:0:1:::0:0:", -- Reins of the Black War Tiger
	[18246]="1000000:0:15:0:1:::0:0:", -- Whistle of the Black War Raptor
	[13328]="10000000:0:15:0:1:::1:0:834", -- Black Ram
	[13329]="10000000:0:15:0:1:::1:0:834", -- Frost Ram
	[18794]="10000000:0:15:0:1:::1:0:313", -- Great Brown Kodo
	[18795]="10000000:0:15:0:1:::1:0:313", -- Great Gray Kodo
	[18793]="10000000:0:15:0:1:::1:0:313", -- Great White Kodo
	[15292]="10000000:0:15:0:1:::1:0:313", -- Green Kodo
	[13334]="10000000:0:15:0:1:::1:0:877", -- Green Skeletal Warhorse
	[12351]="10000000:0:15:0:1:::1:1:637", -- Horn of the Arctic Wolf
	[12330]="10000000:0:15:0:1:::1:0:637", -- Horn of the Red Wolf
	[18796]="10000000:0:15:0:1:::1:0:637", -- Horn of the Swift Brown Wolf
	[18798]="10000000:0:15:0:1:::1:0:637", -- Horn of the Swift Gray Wolf
	[18797]="10000000:0:15:0:1:::1:0:637", -- Horn of the Swift Timber Wolf
	[13327]="10000000:0:15:0:1:::1:0:581", -- Icy Blue Mechanostrider Mod A
	[12354]="10000000:0:15:0:1:::1:0:270,449,576,820", -- Palomino Bridle
	[18791]="10000000:0:15:0:1:::1:0:877", -- Purple Skeletal Warhorse
	[12302]="10000000:0:15:0:1:::1:0:518", -- Reins of the Frostsaber
	[12303]="10000000:0:15:0:1:::1:0:518", -- Reins of the Nightsaber
	[18766]="10000000:0:15:0:1:::0:0:", -- Reins of the Swift Frostsaber
	[18767]="10000000:0:15:0:1:::0:0:", -- Reins of the Swift Mistsaber
	[18902]="10000000:0:15:0:1:::0:0:", -- Reins of the Swift Stormsaber
	[13086]="10000000:0:15:0:1:::1:0:686", -- Reins of the Winterspring Frostsaber
	[18788]="10000000:0:15:0:1:::1:0:891", -- Swift Blue Raptor
	[18786]="10000000:0:15:0:1:::1:0:834", -- Swift Brown Ram
	[18777]="10000000:0:15:0:1:::1:0:270,449,576", -- Swift Brown Steed
	[18787]="10000000:0:15:0:1:::1:0:834", -- Swift Gray Ram
	[18772]="10000000:0:15:0:1:::1:0:581", -- Swift Green Mechanostrider
	[18789]="10000000:0:15:0:1:::0:0:", -- Swift Green Raptor
	[18790]="10000000:0:15:0:1:::1:0:891", -- Swift Orange Raptor
	[18776]="10000000:0:15:0:1:::1:0:270,449,576", -- Swift Palomino
	[18773]="10000000:0:15:0:1:::1:0:581", -- Swift White Mechanostrider
	[18785]="10000000:0:15:0:1:::1:0:834", -- Swift White Ram
	[18778]="10000000:0:15:0:1:::1:0:270,449,576", -- Swift White Steed
	[18774]="10000000:0:15:0:1:::1:0:581", -- Swift Yellow Mechanostrider
	[15293]="10000000:0:15:0:1:::1:0:313", -- Teal Kodo
	[13317]="10000000:0:15:0:1:::1:0:723,891", -- Whistle of the Ivory Raptor
	[8586]="10000000:0:15:0:1:::1:0:723,891", -- Whistle of the Mottled Red Raptor
	[13326]="10000000:0:15:0:1:::1:0:581", -- White Mechanostrider Mod A
	[12353]="10000000:0:15:0:1:::1:0:270,449,576,820", -- White Stallion Bridle
	[11116]="0:0:15:0:1:::0:0:", -- A Mangled Journal
	[10752]="0:0:15:0:1:::0:0:", -- Emerald Encrusted Chest
	[18250]="0:0:15:0:1:::0:0:", -- Gordok Shackle Key
	[10773]="0:0:15:0:1:::0:0:", -- Hakkar'i Urn
	[12122]="0:0:15:0:1:::0:0:", -- Kum'isha's Junk
	[10479]="48:24:15:0:1:::0:0:", -- Kovic's Trading Satchel
	[4632]="200:50:15:0:1:::0:0:", -- Ornate Bronze Lockbox
	[4633]="280:70:15:0:1:::0:0:", -- Heavy Bronze Lockbox
	[4634]="350:87:15:0:1:::0:0:", -- Iron Lockbox
	[4636]="440:110:15:0:1:::0:0:", -- Strong Iron Lockbox
	[4637]="600:150:15:0:1:::0:0:", -- Steel Lockbox
	[4638]="800:200:15:0:1:::0:0:", -- Reinforced Steel Lockbox
	[17963]="854:213:15:0:1:::0:0:", -- Green Sack of Gems
	[17965]="854:213:15:0:1:::0:0:", -- Yellow Sack of Gems
	[5758]="1000:250:15:0:1:::0:0:", -- Mithril Lockbox
	[5759]="1500:375:15:0:1:::0:0:", -- Thorium Lockbox
	[5760]="2000:500:15:0:1:::0:0:", -- Eternium Lockbox
	[9327]="2500:625:15:0:1:::0:0:", -- Security DELTA Data Access Card
	[17964]="22050:5512:15:0:1:::0:0:", -- Gray Sack of Gems
	[13247]="23350:5837:15:0:1:::0:0:", -- Quartermaster Zigris' Footlocker
	[18357]="0:0:15:0:1:::0:0:", -- Codex of Defense
	[18363]="0:0:15:0:1:::0:0:", -- Frost Shock and You
	[18356]="0:0:15:0:1:::0:0:", -- Garona: A Study on Stealth and Treachery
	[18360]="0:0:15:0:1:::0:0:", -- Harnessing Shadows
	[18362]="0:0:15:0:1:::0:0:", -- Holy Bologna: What the Light Won't Tell You
	[18358]="0:0:15:0:1:::0:0:", -- The Arcanist's Cookbook
	[18364]="0:0:15:0:1:::0:0:", -- The Emerald Dream
	[18361]="0:0:15:0:1:::0:0:", -- The Greatest Race of Hunters
	[18359]="0:0:15:0:1:::0:0:", -- The Light and How to Swing It
	[12607]="32195:8048:15:0:20::165:0:0:", -- Brilliant Chromatic Scale
	[19227]="50000:12500:15:0:1:::0:0:", -- Ace of Beasts
	[19268]="50000:12500:15:0:1:::0:0:", -- Ace of Elementals
	[19276]="50000:12500:15:0:1:::0:0:", -- Ace of Portals
	[19258]="50000:12500:15:0:1:::0:0:", -- Ace of Warlords
	[19236]="50000:12500:15:0:1:::0:0:", -- Eight of Beasts
	[19275]="50000:12500:15:0:1:::0:0:", -- Eight of Elementals
	[19284]="50000:12500:15:0:1:::0:0:", -- Eight of Portals
	[19265]="50000:12500:15:0:1:::0:0:", -- Eight of Warlords
	[19233]="50000:12500:15:0:1:::0:0:", -- Five of Beasts
	[19272]="50000:12500:15:0:1:::0:0:", -- Five of Elementals
	[19281]="50000:12500:15:0:1:::0:0:", -- Five of Portals
	[19262]="50000:12500:15:0:1:::0:0:", -- Five of Warlords
	[19232]="50000:12500:15:0:1:::0:0:", -- Four of Beasts
	[19271]="50000:12500:15:0:1:::0:0:", -- Four of Elementals
	[19280]="50000:12500:15:0:1:::0:0:", -- Four of Portals
	[19261]="50000:12500:15:0:1:::0:0:", -- Four of Warlords
	[19235]="50000:12500:15:0:1:::0:0:", -- Seven of Beasts
	[19274]="50000:12500:15:0:1:::0:0:", -- Seven of Elementals
	[19283]="50000:12500:15:0:1:::0:0:", -- Seven of Portals
	[19264]="50000:12500:15:0:1:::0:0:", -- Seven of Warlords
	[19234]="50000:12500:15:0:1:::0:0:", -- Six of Beasts
	[19273]="50000:12500:15:0:1:::0:0:", -- Six of Elementals
	[19282]="50000:12500:15:0:1:::0:0:", -- Six of Portals
	[19263]="50000:12500:15:0:1:::0:0:", -- Six of Warlords
	[19231]="50000:12500:15:0:1:::0:0:", -- Three of Beasts
	[19270]="50000:12500:15:0:1:::0:0:", -- Three of Elementals
	[19279]="50000:12500:15:0:1:::0:0:", -- Three of Portals
	[19260]="50000:12500:15:0:1:::0:0:", -- Three of Warlords
	[19230]="50000:12500:15:0:1:::0:0:", -- Two of Beasts
	[19269]="50000:12500:15:0:1:::0:0:", -- Two of Elementals
	[19278]="50000:12500:15:0:1:::0:0:", -- Two of Portals
	[19259]="50000:12500:15:0:1:::0:0:", -- Two of Warlords
	[13335]="1000000:250000:15:0:1:::0:0:", -- Deathcharger's Reins
	[18401]="0:0:15:0:1:::0:0:", -- Foror's Compendium of Dragon Slaying
	[12871]="32195:8048:15:0:1:::0:0:", -- Chromatic Carapace
	[19228]="400000:100000:15:0:1:::0:0:", -- Beasts Deck
	[19287]="400000:100000:15:0:1:::0:0:", -- Darkmoon Card: Heroism
	[19267]="400000:100000:15:0:1:::0:0:", -- Elementals Deck
	[19277]="400000:100000:15:0:1:::0:0:", -- Portals Deck
	[19257]="400000:100000:15:0:1:::0:0:", -- Warlords Deck
	[19030]="8000000:0:15:0:1:::1:0:774", -- Stormpike Battle Charger
	[18564]="0:0:15:0:1:::0:0:", -- Bindings of the Windseeker
})

