local function lineMatches(line, search_text)
      local foundMatch = false;
      if (string.len(search_text) == 0) then
	      foundMatch = true;
      else
	      if ( string.gmatch ) then 
		if ( string.gmatch(string.lower(line), search_text)() ) then
		   foundMatch = true;
		end
	      else 
		if ( string.gfind(string.lower(line), search_text)() ) then
		   foundMatch = true;
		end
	      end
      end
      return foundMatch;
end

function AtlasMajorCitiesSearch(data, text)
	 local new = {};			-- create a new table
	 local i;
	 local v;
	 local n;

	 local search_text = string.lower(text);
	 local match;

	 if ( data.Areas == nil ) then
	     i, v = next(data, nil);		-- i is an index of data, v = data[i]
	     n = i;
	     while i do
		   if ( string.gmatch ) then 
			match = string.gmatch(string.lower(data[i]), search_text)();
		   else 
			match = string.gfind(string.lower(data[i]), search_text)(); 
		   end

		   if ( match ) then
			new[n] = data[i];
			n = n + 1;
		   end
		   i, v = next(data, i);			-- get next index
	    end
	else
	     n = 1;
	     local areaKey;
	     local areaData;
	     local addSeparator = false;
	     local shownAreaTitle = false;

	     for areaKey,areaData in pairs(data.Areas) do
		   local color = areaData.Color;
		   local areaName = areaData.Name;
		   local labelsKey;
		   local labelsData;
	   	   addSeparator = false;
	           shownAreaTitle = false;

		   for labelsKey,labelsData in pairs(areaData) do
			   local labelKey;
		           local labelData;

			   if ( type(labelsData) == "table" and labelsData.Label ~= nil ) then
			      local labelName = labelsData.Label;
			      local foundMatch = false;
			      for labelKey,labelData in ipairs(labelsData) do
			          if (lineMatches(labelData, search_text)) then
				      foundMatch = true;
				      break;
			          end
			      end

			      if ( foundMatch ) then
				  for labelKey,labelData in ipairs(labelsData) do
					 if (not shownAreaTitle) then
					    new[n] = color..areaName;
					    n = n + 1;
					    shownAreaTitle = true;
					    if (lineMatches(labelData, search_text)) then
					        new[n] = " "..color..labelName..") "..labelData;
					    else
					        new[n] = " ".."|c88888888"..labelName..") "..labelData;
					    end
					 else
					    if ( labelKey > 1 ) then
						if (lineMatches(labelData, search_text)) then
						    new[n] = " ".."|c00000000"..labelName..") "..color..labelData;
						else
						    new[n] = " ".."|c00000000"..labelName..") ".."|c88888888"..labelData;
						end
					    else
						if (lineMatches(labelData, search_text)) then
						    new[n] = " "..color..labelName..") "..labelData;
						else
						    new[n] = " ".."|c88888888"..labelName..") "..labelData;
						end
					    end
					 end
					 n = n + 1;
					 addSeparator = true;
				  end
			      end
			end
		  end
		  if (addSeparator) then
		           new[n] = " ";
		           n = n + 1;
		  end
	     end
	end

	return new;
end

if ( GetLocale() == "enUS" or GetLocale() == "enGB" ) then

	local BLUE = "|cff6666ff";
	local GREY = "|cff999999";
	local GREN = "|cff66cc33";
	local YELL = "|cffcccc00";
	local _RED = "|cffcc6666";
	local ORNG = "|cffcc9933";
	local PURP = "|cff9900ff";
	local WHITE = "|cffffffff";
	local CYAN = "|cff008888";
	local INVIS = "|c00000000";

	local myCategory = "Major Cities";

	local myData = {
	  Search = AtlasMajorCitiesSearch;

	  Darnassus = {
	    ZoneName = "Darnassus (Alliance - Night Elf)";
	    Location = "Teldrassil";

	    Areas = {
	      {
		Name = "Warrior's Terrace";
		Color = WHITE;
		{
		  Label = "1";
		  "Mydrannul, General Goods Vendor";
		  "Shylenai, Owl Trainer";
		  "Fyrenna, Good & Drink Vendor";
		},
		{
		  Label = "2";
		  "Darnath Bladesinger, Warrior Trainer";
		  "Arias'ta Bladesinger, Warrior Trainer";
		  "Elanaria";
		},
		{
		  Label = "3";
		  "Ariyell Skyshadow, Weapon Merchant";
		  "Mathiel";
		  "Forge";
		  "Cylania, Night Elf Armorer";
		  "Ilyenia Moonfire, Weapon Master";
		  "  Daggers";
		  "  Staves";
		  "  Bows";
		}
	      },
	      {
		Name = "Tradesmen's Terrace";
		Color = PURP;
		{
		  Label = "1";
		  "General Goods & Bags";
		  "Ellandrieth, General Goods Vendor";
		  "Yldan, Bag Vendor";
		},
		{
		  Label = "2";
		  "Weapons";
		  "Glorandiir, Axe Merchant";
		  "Merelyssa, Blade Merchant";
		  "Mythidan, Mace & Staff Merchant";
		  "Kieran, Weapon Merchant";
		},
		{
		  Label = "3";
		  "Fletcher & Thrown Weapons";
		  "Landria, Bow Merchant";
		  "Turian, Thrown Weapon Merchant";
		},
		{
		  Label = "4";
		  "Cloth Armor & Two-handed Weapons";
		  "Vinasia, Cloth Armor Merchant";
		  "Easlysia Dewwhisper, Two-handed";
		  " Weapon Merchant";
		},
		{
		  Label = "5";
		  "Leather Armor";
		  "Cyridan, Leather Armor Merchant";
		},
		{
		  Label = "6";
		  "Mail Armor & Shields";
		  "Melea, Mail Armor Merchant";
		  "Caynrus, Shield Merchant";
		},
		{
		  Label = "7";
		  "Jareth Wildwoods";
		},
		{
		  Label = "8";
		  "Sentinel's Bunkhouse";
		},
		{
		  Label = "9";
		  "Staff & Robe";
		  "Andrus, Staff Merchant";
		  "Anadyia, Robe Vendor";
		}
	      },
	      {
		Name = "The Temple of the Moon";
		Color = BLUE;
		{
		  Label = "1";
		  "Alaindia, Reagent Vendor";
		},
		{
		  Label = "2";
		  "Jandria, Priest Trainer";
		  "JElissa Drumas, Portal Trainer";
		  "Lariia, Priest Trainer";
		  "Sentinel Dalia Sunblade";
		  "Priestess A'Moora";
		  "Astarii Starseeker, Priest Trainer";
		  "Tyrande Whisperwind, High Priestess";
		  " of Elune";
		  "Priestess Alathea";
		  "Gracina Spiritmight";
		},
		{
		  Label = "3";
		  "Chief Archaeologist Greywhisker,";
		  " Explorers' League";
		},
		{
		  Label = "4";
		  "Firodren Mooncaller, Herbalism";
		  " Trainer";
		  "Chardryn, Herbalism Supplier";
		}
	      },
	      {
		Name = "The Temple Gardens";
		Color = GREN;
		{
		  Label = "1";
		  "The Bank";
		},
		{
		  Label = "2";
		  "Portal to Rut'theran Village";
		},
		{
		  Label = "3";
		  "Sister Aquinne, Novice Priestess";
		  "Sarin Starlight";
		},
		{
		  Label = "4";
		  "Astaia, Fishing Trainer";
		  "Voloren, Fishing Supplier";
		  "Talaelar, Fish Vendor";
		}
	      },
	      {
		Name = "The Cenarion Enclave";
		Color = ORNG;
		{
		  Label = "1";
		  "Rellian Greenspyre";
		},
		{
		  Label = "2";
		  "Lelanai, Tiger Handler";
		  "Jartsam, Nightsaber Riding Instructor";
		},
		{
		  Label = "3";
		  "Dendrythis, Food & Drink Vendor";
		},
		{
		  Label = "4";
		  "Faelyssa";
		  "Kyria, Poison Vendor";
		},
		{
		  Label = "5";
		  "Cyroen, Reagent Vendor";
		  "Fylerian Nightwing, Druid Trainer";
		  "Denatharion, Druid Trainer";
		  "Mathrengyl Bearwalker, Druid Trainer";
		},
		{
		  Label = "6";
		  "Alassin, Stable Master";
		  "Jocaste, Hunter Trainer";
		},
		{
		  Label = "7";
		  "Corand";
		},
		{
		  Label = "8";
		  "Dorion, Hunter Trainer";
		  "Silvaria, Pet Trainer";
		},
		{
		  Label = "9";
		  "Jeen'ra Nightrunner, Hunter Trainer";
		},
		{
		  Label = "10";
		  "Syurna, Rogue Trainer, (down tunnel)";
		  "Anishar, Rogue Trainer";
		  "Eriohn Shadewhisper, Rogue Trainer";
		}
	      },
	      {
		Name = "Craftmen's Terrace";
		Color = CYAN;
		{
		  Label = "1";
		  "Tailoring & Leatherworking";
		  "M`e'lynn, Expert Tailor";
		  "Trianna, Journeyman Tailor";
		  "Elynna, Tailoring Supplies";
		  "Darinna, Journeyman Leatherworker";
		  "Telonis, Artisan Leatherworker";
		  "Faldon, Expert Leatherworker";
		  "Lotheria";
		  "Eladriel, Skinning Trainer";
		  "Saenorion, Leatherworking Supplies";
		},
		{
		  Label = "2";
		  "General Trade";
		  "Mythrin'dir, General Trade Supplier";
		},
		{
		  Label = "3";
		  "Argent Dawn";
		  "Argent Guard Manados";
		  "Dawnwatcher Shaedlass";
		  "Dawnwatcher Selgorm";
		},
		{
		  Label = "4";
		  "Alchemy";
		  "Milla Fairancora, Journeyman";
		  " Alchemist";
		  "Sylvanna Forestmoon, Expert";
		  " Alchemist";
		  "Ainethil, Artisan Alchemist";
		  "Ulthir, Alchemy Supplies";
		},
		{
		  Label = "5";
		  "Cooking";
		  "Alegorn, Cooking Trainer";
		  "Fyldan, Cooking Supplier";
		},
		{
		  Label = "6";
		  "First Aid";
		  "Dannelor, First Aid Trainer";
		},
		{
		  Label = "7";
		  "Enchanting";
		  "Lalina Summermoon, Journeyman";
		  " Enchanter";
		  "Taladan, Expert Enchanter";
		  "Vaean, Enchanting Supplies";
		},
		{
		  Label = "8";
		  "Inn";
		  "Innkeeper Saelienne";
		  "Mailbox";
		},
		{
		  Label = "9";
		  "Guild (1st floor bridge)";
		  "Lysheana, Guild Master";
		  "Shalumon, Tabard Vendor";
		};
	      };
	    };
	  };
	  Ironforge = {
	    ZoneName = "Ironforge (Alliance - Dwarven)";
	    Location = "Dun Morogh";

	    Areas = {
	      {
		Name = "The Commons";
		Color = WHITE;

		{
		  Label = "1";
		  "Auctioneer";
		},
		{
		  Label = "2";

		  "Barin's Reagents";
		  "Barin Jurgenstaad, Reagent Vendor";

		},
		{
		  Label = "3";
		  "The Stonefire Tavern";
		  "Gwenna Firebrew, Barmaid";
		  "Innkeeper Firebrew";
		  "Mailbox";
		},
		{
		  Label = "4";

		  "Ironforge Aromory";
		  "Mangorn Flinthammer, Heavy Armor";
		  " Merchant";
		  "Raena Flinthammer, Light Armor";
		  " Merchant";
		  "Bromiir Ormsen, Heavy Armor";
		  " Merchant";
		},
		{
		  Label = "5";

		  "Bank (Vault)";
		  "Mailbox";
		  "Dinita Stonemantle, Vault";
		  " Administrator";
		},
		{
		  Label = "6";

		  "Steelfury's Weapon Emporium";
		  "Dolman Steelfury, Weapon Merchant";
		  "Grenil Steelfury, Weapon Merchant";
		},
		{
		  Label = "7";

		  "Fizzlespinner's General Goods";
		  "Fillius Fizzlespinner, Trade Supplier";
		  "Bryllia Ironbrand, General Goods";
		  " Vendor";
		  "Pithwick, Bag Vendor";
		},
		{
		  Label = "8";

		  "Grand Mason Marblesten. Royal";
		  " Stonecutters Union";
		},
		{
		  Label = "9";

		  "Ironforge's Visitor Center";
		  "Jondor Steelbrow, Guild Master";
		  "Lyesa Steelbrow, Guild Tabard Vendor";
		}
	      },

	      {
		Name = "Mystic Ward";
		Color = PURP;
		{
		  Label = "1";
		  "The Fighting Wizard";
		  "Bingus, Staff Merchant";
		  "Harick Boulderdrum, Wands Merchant";
		},
		{
		  Label = "2";
		  "Hall of Mysteries";
		  "Toldren Deepiron, Priest Trainer";
		  "Braenna Flintcrag, Priest Trainer";
		  "Theodrus Frostbeard, Priest Trainer";
		  "Bink, Mage Trainer";
		  "Dink, Mage Trainer";
		  "Juli Stormkettle, Mage Trainer";
		  "Nittlebur Sparkfizzle, Mage Trainer";
		  "Brandur Ironhammer, Paladin Trainer";
		  "Beldruk Doombrow, Paladin Trainer";
		  "Valgar Highforge, Paladin Trainer";
		  "Milstaff Stormeye, Portal Trainer";
		  "Muiredon Battleforge";
		  "Tiza Battelforge";
		  "High Priest Rohan";
		},
		{
		  Label = "3";
		  "Mage Tymor";
		},
		{
		  Label = "4";
		  "Talvash del Kizzel";
		},
		{
		  Label = "5";
		  "Maeva's Mystical Apparel";
		  "Maeva Snowbraid, Robe Merchant";
		  "Ingrys Stonebrow, Cloth Armor";
		  " Merchant";
		},
		{
		  Label = "6";
		  "Longberry's Reagents";
		  "Ginny Longberry, Reagent Vendor";
		}
	      },

	      {
		Name = "The Forlorn Cavern";
		Color = ORNG;
		{
		  Label = "1";

		  "Stoneblades";
		  "Hjoldir Stoneblade, Blade Merchant";
		  "Binny Springblade";
		  "Prynne";
		},
		{
		  Label = "2";
		  "Traveling Fisherman";
		  "Tansy Puddlefizz, Fishing Supplier";
		  "Grimnur Stonebrand, Fishing Trainer";
		},
		{
		  Label = "3";
		  "Lago Blackwrench";
		},
		{
		  Label = "4";
		  "Thistleheart, Warlock Trainer";
		  "Briarthorn, Warlock Trainer";
		  "Alexander Calder, Warlock  Trainer";
		  "Gerrig Bonegrip";
		},
		{
		  Label = "5";
		  "Jubahl Corpseseeker, Demon Trainer";
		},
		{
		  Label = "6";
		  "Tynnus Venomsprout, Shady Dealer";
		  "Fenthwick, Rogue Trainer";
		  "Ormyr Flinteye, Rogue Trainer";
		  "Hulfdan Blackbeard, Rogue Trainer";
		  "Durtham Greldon";
		}
	      },

	      {
		Name = "Hall of Explorers";
		Color = BLUE;
		{
		  Label = "1";
		  "Roetten Stonehammer, Reclaimers Inc.";
		  "High Explorer Magellas, Explorers'";
		  " League";
		},
		{
		  Label = "2";
		  "Library";
		  "Lyon Mountainheart";
		  "Curator Thorius";
		  "Laris Geardawdle";
		  "Krom Stoutarm";
		  "Prospector Stormpike";
		  "Librarian Mae Paledust, Explorers'";
		  " League";
		  "Adviser Belgrum";
		  "Historian Karnik";
		}
	      },
	      {
		Name = "Tinker Town";
		Color = GREN;
		{
		  Label = "1";
		  "Mailbox";
		},
		{
		  Label = "2";
		  "Lomac Gearstrip";
		},
		{
		  Label = "3";
		  "Things that go Boom!";
		  "Fizzlebang Booms, Fireworks Vendor";
		},
		{
		  Label = "4";
		  "Berryfizz's Potions and Mixed Drinks";
		  "Vosur Brakthel, Journeyman Alchemist";
		  "Tally Berryfizz, Expert Alchemist";
		  "Soolie Berryfizz, Alchemy Supplier";
		},
		{
		  Label = "5";
		  "Tinkermaster Overspark, Master";
		  " Gnome Engineer";
		  "Gnoarn";
		  "High Tinker Mekkatorque, King of the";
		  " Gnomes";
		  "Master Mechanic Castpipe";
		},
		{
		  Label = "6";
		  "Klockmort Spannerspan";
		},
		{
		  Label = "7";
		  "Springspindle's Gadgets";
		  "Gearcutter Cogspinner, Engineering";
		  " Supplies";
		  "Jemma Quikswitch, Journeyman";
		  " Engineer";
		  "Trixie Quikswitch, Expert Engineer";
		  "Springspindle Fisslegear, Artisan";
		  " Engineer";
		},
		{
		  Label = "8";
		  "Deeprun Tram";
		}
	      },

	      {
		Name = "Military Ward";
		Color = _RED;
		{
		  Label = "1";
		  "Goldfury's Hunting Supplies";
		  "Bretta Goldfury, Gun Merchant";
		  "Skolmin Goldfury, Bow Merchant";
		},
		{
		  Label = "2";
		  "Mailbox";
		},
		{
		  Label = "3";
		  "Bruuk's Corner";
		  "Tisa, Martine";
		  "Bruuk Barleybeard, Bartender";
		  "Edris Barleybeard, Barmaid";
		},
		{
		  Label = "4";
		  "Sognar Cliffbeard, Meat Vendor";
		},
		{
		  Label = "5";
		  "Hall of Arms";
		  "Regnus Thundergranite, Hunter Trainer";
		  "Olmin Burningbeard, Hunter Trainer";
		  "Daera Brightspear, Hunter Trainer";
		  "Bilban Tosslespanner, Warrior Trainer";
		  "Kelv Sternhammer, Warrior Trainer";
		  "Kelstrum Stonebreaker, Warrior Trainer";
		  "Pilot Longbeard, Ironforge Siege";
		  " Brigade";
		  "Ulbrek Firehand, Stable Master";
		  "Belia Thundergranite, Pet Trainer";
		  "Xiggs Fuselighter";
		  "Demnul Farmountain";
		  "Muren Stormpike";
		},
		{
		  Label = "6";
		  "Timberline Arms";
		  "Kelomir Ironhand, Maces & Staves";
		  "Thalgus Thunderfist, Weapon";
		  " Merchant";
		  "Hegnar Swiftaxe, Axe Merchant";
		  "Brenwyn Wintersteel, Blade Merchant";
		  "Buliwyf Stonhand, Weapon Master";
		  "  Guns";
		},
		{
		  Label = "7";
		  "Craghelm's Plate and Chain";
		  "Lissyphus Finespindle, Light Armor";
		  " Merchant";
		  "Dolkin Craghelm, Mail Armor";
		  " Merchant";
		  "Olthran Craghelm, Heavy Armor";
		  " Merchant";
		},
		{
		  Label = "8";
		  "Sara Balloo";
		},
	      },
	      {
		Name = "The Great Forge";
		Color = YELL;
		{
		  Label = "1";
		  "Ironforge Pysician";
		  "Reyna Stonebranch, Herbalism Trainer";
		  "Gwina Stonebranch, Herbalism";
		  " Supplier";
		  "Nissa Firestone, First Aid Trainer";
		},
		{
		  Label = "2";
		  "Thistlefuzz Arcanery";
		  "Tilli Thistlefuzz, Enchanting Supplier";
		  "Thonys Pillarstone, Journeyman";
		  " Enchanter";
		  "Gimble Thistlefuzz, Expert Enchanter";
		},
		{
		  Label = "3";
		  "The Bronze Kettle";
		  "Daryl Riknussun, Cooking Trainer";
		  "Emrul Riknussun, Cooking Supplier";
		},
		{
		  Label = "4";
		  "Deep Mountain Mining Guild";
		  "Geofram Bouldertoe, Mining Trainer";
		  "Golnir Bouldertoe, Mining Supplier";
		},
		{
		  Label = "5";
		  "Burbik's Supplies";
		  "Burbik Gearspanner, Trade Supplier";
		},
		{
		  Label = "6";
		  "Stonebrow's Clothier";
		  "Poranna Snowbraid, Tailoring Supplies";
		  "Outfitter Eric, Speciality Tailoring";
		  " Supplies";
		  "Uthrar Threx, Journeyman Tailor";
		},
		{
		  Label = "7";
		  "Finespindle's Leather Goods";
		  "Balthus Stoneflayer, Skinning Trainer";
		  "Gretta Finespindle, Journeyman";
		  " Leatherworker";
		  "Fimble Finespindle, Expert";
		  " Leatherworker";
		  "Bombus Finespindle, Leatherworking";
		  " Supplies";
		},
		{
		  Label = "8";
		  "The High Seat";
		  "King Magni Bronzebeard, Lord of";
		  " Ironforge";
		  "Senator Barin Redstone";
		  "Royal Historian Archesonus";
		},
		{
		  Label = "9";
		  "Gryth Thurden, Gryphon Master";
		},
		{
		  Label = "10";
		  "The Great Anvil";
		  "Forge";
		  "Grumnus Steelshaper, Armor Crafter";
		  "Ironus Coldsteel, Special Weapon";
		  " Crafter";
		  "Tormus Deepforge";
		  "Thurgrum Deepforge, Blacksmithing";
		  " Supplier";
		  "Groum Stonebeard, Journeyman";
		  " Blacksmith";
		  "Rotgarth Stonebeard, Expert";
		  " Blacksmith";
		  "Bengus Deepforge, Artisan";
		  " Blacksmith";
		  "Brombar Higgleby, The Keymaster";
		  "Myolor Sunderfury";
		};
	      };
	    };
	  };
	  Orgrimmar = {
	    ZoneName = "Orgrimmar (Horde - Orc)";
	    Location = "Durotar";
	    Areas  = {
	      {
		Name = "Valley of Strength";
		Color = WHITE;
		{
		  Label = "1";
		  "Soran's Leather & Steel Armory";
		  "Sana, Mail Armor Merchant";
		  "Morgum, Leather Armor Merchant";
		  "Ollanus, Light Armor Merchant";
		},
		{
		  Label = "2";
		  "Inn";
		  "Innkeeper Gryshka";
		  "Kozish";
		  "Sarok";
		  "Doyo'da";
		  "Barkeep Morag";
		  "Zaro";
		  "Goma";
		  "Gamon";
		},
		{
		  Label = "3";
		  "Auctionhouse";
		},
		{
		  Label = "4";
		  "Boomstick Imports";
		  "Kaja, Guns & Ammo Merchant";
		},
		{
		  Label = "5";
		  "Spiritfury Reagents";
		  "Horthus, Reagents Vendor";
		},
		{
		  Label = "6";
		  "Horde Embassy";
		  "Urtrun Clanbringer, Guildmaster";
		  "Garyl, Tabard Vendor";
		},
		{
		  Label = "7";
		  "Orgrimmar General Store";
		  "Trak'gen, General Goods Merchant";
		  "Shimra, General Trade Goods";
		  " Merchant";
		},
		{
		  Label = "8";
		  "Bank";
		  "Mailbox";
		},
		{
		  Label = "9";
		  "The Shattered Axe";
		  "Urtharo, Weapon Merchant";
		},
		{
		  Label = "10";
		  "The Chophouse";
		  "Olvia, Meat Vendor";
		},
		{
		  Label = "11";
		  "Slope up to Valley of Spirits";
		},
		{
		  Label = "12";
		  "Zankaja";
		},
		{
		  Label = "13";
		  "The Skytower";
		  "Doras, Wind Rider Master";
		},
		{
		  Label = "14";
		  "Skyfury Staves";
		  "Ukra'nor, Staff Merchant";
		},
		{
		  Label = "15";
		  "Keldran";
		}
	      },
	      {
		Name = "The Drag";
		Color = ORNG;
		{
		  Label = "1";
		  "Borstan's Firepit (upstairs)";
		  "Zamja, Cooking Trainer";
		  "Borstand, Meat Vendor";
		  "Xen'lo, Cooking Supplier";
		},
		{
		  Label = "2";
		  "Zilzibin Drumlore, (upstairs)";
		  "Sarlek";
		  "Tamaro";
		},
		{
		  Label = "3";
		  "Jandi's Arboretum (upstairs)";
		  "Zeal'aya, Herbalism Supplier";
		  "Jandi, Herbalism Trainer";
		},
		{
		  Label = "4";
		  "Gotri's Travelling Gear (downstairs)";
		  "Gotri, bag Vendor";
		},
		{
		  Label = "5";
		  "Magar's Cloth Goods";
		  "Borya, Tailoring Supplies";
		  "Tor'phan, Cloth & Leather Armor";
		  " Merchant";
		  "Magar, Expert Tailor";
		  "Shang, Journeyman Tailor";
		},
		{
		  Label = "6";
		  "Kodohide Leatherworks";
		  "Kamari, Journeyman Leatherworker";
		  "Karolek, Expert Leatherworker";
		  "Tamar, Leatherworking Supplies";
		  "Thuwd, Skinning Trainer";
		  "Handor, Cloth & Leather Armor";
		  " Merchant";
		},
		{
		  Label = "7";
		  "Droffers & Sons Salvage";
		  "Dran Droffers";
		  "Malton Droffers";
		},
		{
		  Label = "8";
		  "Yelmak's Alchemy & Potions";
		  "Kor'geld, Alchemy Supplies";
		  "Whuut, Journeyman alchemist";
		  "Yelmak, Expert Alchemist";
		},
		{
		  Label = "9";
		  "Godan's Runeworks";
		  "Kithas, Enchanting Supplies";
		  "Jhag, Journeyman Enchanter";
		  "Godan, Expert Enchanter";
		},
		{
		  Label = "10";
		  "Mailbox";
		}
	      },
	      {
		Name = "Valley of Honor";
		Color = GREN;
		{
		  Label = "1";
		  "Lumak's Fishing";
		  "Lumak, Fishing Trainer";
		  "Shankys, Fishing Supplies";
		},
		{
		  Label = "2";
		  "Kiro's Harnesses";
		  "Kiro, War harness Maker";
		},
		{
		  Label = "3";
		  "Orgrimmar Bowyer";
		  "Jin'sora, Bow Merchant";
		},
		{
		  Label = "4";
		  "Hall of the Brave";
		  "Zel'mak, Warrior Trainer";
		  "Sorek, Warrior Trainer";
		  "Grezz Ragefist, Warrior Trainer";
		},
		{
		  Label = "5";
		  "Red Canyon Mining";
		  "Makaru, Mining Trainer";
		  "Gorina, Mining Supplier";
		},
		{
		  Label = "6";
		  "Nogg's Machine Shop";
		  "Thund, Journeyman Engineer";
		  "Nogg, Expert Engineer";
		  "Roxxik, Artisan Engineer";
		  "Sovik, Engineering Supplies";
		  "Rilli Greasygob";
		},
		{
		  Label = "7";
		  "Snarl, Expert Blacksmith";
		  "Borgosh Corebender, Weaponsmith";
		  "Okothos Ironrager, Armorsmith";
		  "Krathok Moltenfist";
		  "Shayis Steelfury, Armor Crafter";
		  "Ox, The Mithril Order";
		  "Ug'thock, Journeyman Blacksmith";
		},
		{
		  Label = "8";
		  "The Burning Anvil";
		  "Saru Steelfury, Artisan Blacksmith";
		  "Tumi, Heavy Armor Merchant";
		  "Sumi, Blacksmithing Supplies";
		},
		{
		  Label = "9";
		  "Arms of Legend";
		  "Zendo'jian, Weapon Vendor";
		  "Kelgruk Bloodaxe, Weapon Crafter";
		  "Shoma, Weapon Merchant";
		  "Galthuk, 2-handed Weapon Merchant";
		  "Sayoc, Weapon Master";
		  "  Bows";
		  "  Daggers";
		  "  Fist Weapons";
		  "  One Handed Axes";
		  "  Two Handed Axes";
		  "  Thrown Weapons";
		},
		{
		  Label = "10";
		  "Ring of Valor";
		},
		{
		  Label = "11";
		  "Hunter's Hall";
		  "Sian'dur, Hunter Trainer";
		  "Xorjuui, Hunter Trainer";
		  "Ormak Grimshot, Hunter Trainer";
		  "Shim'la";
		  "Xao'tsu, Pet Trainer";
		},
		{
		  Label = "12";
		  "Ogunaro Wolfrunner, Kennel Master";
		  "Kildar, Wolf Riding Instructor";
		}
	      },
	      {
		Name = "Cleft of Shadows";
		Color = BLUE;
		{
		  Label = "1";
		  "Darkfire Enclave";
		  "Mirket, Warlock Trainer";
		  "Zevrost, Warlock Trainer";
		  "Gan'rul Bloodeye";
		  "Grol'dar, Warlock Trainer";
		  "Kurgul, Demon Trainer";
		},
		{
		  Label = "2";
		  "Shadowdeep Reagents";
		  "Hagrus, Reagent Vendor";
		},
		{
		  Label = "3";
		  "Ironwood Staves & Wands";
		  "Muragus, Staff Merchant";
		  "Katis, Wand Merchant";
		},
		{
		  Label = "4";
		  "Neeru Fireblade";
		},
		{
		  Label = "5";
		  "Kor'jus, Mushroom Vendor";
		},
		{
		  Label = "6";
		  "Kor'ghan";
		},
		{
		  Label = "7";
		  "The Slow Blade";
		  "Kareth, Blade Merchant";
		},
		{
		  Label = "8";
		  "Shadowswift Brotherbood";
		  "Gest, Rogue Trainer";
		  "Ormok, Rogue Trainer";
		  "Shenthul, Rogue Trainer";
		  "Therzok";
		  "Zando'san";
		},
		{
		  Label = "9";
		  "Rekkul's Poisons";
		  "Rekkul, Poison Vendor";
		},
		{
		  Label = "R";
		  "  Ragefire Chasm Instance";
		}
	      },
	      {
		Name = "Valley of Wisdom";
		Color = _RED;
		{
		  Label = "1";
		  "Asoran's Market";
		  "Asoran, General Goods Vendor";
		  "Magenius, Reagents Vendor";
		},
		{
		  Label = "2";
		  "Grommash Hold";
		  "Sian'tsu, Shaman Trainer";
		  "Grelkor, Shaman Trainer";
		  "Kardris Dreamseeker, Shaman Trainer";
		  "Zor Lonetree, Elder Far Seer";
		  "Searn Firewarder";
		  "Eitrigg";
		  "Vol'jin";
		  "Nazgrel, Advisor to Thrall";
		  "Thrall, Warchief";
		},
		{
		  Label = "3";
		  "Stranglethorn Imported Fruits";
		  "Shanti, Fruit Vendor";
		}
	      },
	      {
		Name = "Valley of Spirit";
		Color = PURP;
		{
		  Label = "1";
		  "Darkbriar Lodge";
		  "Uthel'nay, Mage Trainer";
		  "Enyo, Mage Trainer";
		  "Deino, Mage Trainer";
		  "Pephredo, Mage Trainer";
		  "Dat'xus, Staves Trainer";
		  "Thull, Portal Trainer";
		},
		{
		  Label = "2";
		  "Witch Doctor Mau'ari";
		},
		{
		  Label = "3";
		  "Spirit Lodge";
		  "Ur'kyro, Priest Trainer";
		  "X'yera, Priest Trainer";
		  "Zayus, High Priest";
		},
		{
		  Label = "4";
		  "Survival of the Fittest";
		  "Arnok, First Aid Trainer";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Xan'tish, Snake Vendor";
		};
	      };
	    };
	  };
	  Stormwind = {
	    ZoneName = "Stormwind (Alliance - Human)";
	    Location = "Elwynn Forest";
	    Areas = {
	      {
		Name = "Trade District";
		Color = WHITE;
		{
		  Label = "1";
		  "Stormwind Visitor Center";
		  "Adwin Laughlin, Guild Master";
		  "Rebecca Laughlin, Tabard Vendor";
		},
		{
		  Label = "2";
		  "Trias' Cheese";
		  "Elain Trias, Mistress of Cheese";
		  "Ben Trias, Apprentice of Cheese";
		  "Elling Trias, Master of Cheese";
		},
		{
		  Label = "3";
		  "Pestle's Apothecary";
		  "Kyra Boucher, Reagent Vendor";
		  "Keldric Boucher, Arcane Goods";
		  " Vendor";
		  "Morga Pestle";
		},
		{
		  Label = "4";
		  "Everyday Merchandise";
		  "Edna Mullby, Trade Supplier";
		  "Thurman Mullby, General Goods";
		  " Vendor";
		},
		{
		  Label = "5";
		  "The Guided Rose Inn";
		  "Innkeeper Allison";
		},
		{
		  Label = "6";
		  "Counting House";
		  "Bank";
		  "Mailbox";
		},
		{
		  Label = "7";
		  "Weller's Arsenal";
		  "Marda Weller, Weapon's Merchant";
		  "Gunther Weller, Weapon's Merchant";
		  "Woo Ping, Weapon Master";
		  "  One-Handed Swords";
		  "  Two-Handed Swords";
		  "  Crossbows";
		},
		{
		  Label = "8";
		  "Lionheart Armory";
		  "Carla Granger, Cloth Armor Merchant";
		  "Lara Moore, Leather Armor Merchant";
		  "Aldric Moore, Mail Armor Merchant";
		  "Harlan Bagley";
		},
		{
		  Label = "9";
		  "The Empty Quiver";
		  "Frederick Stover, Bow & Arrow";
		  " Merchant";
		  "Lina Stover, Arrow Merchant";
		  "Topper McNabb";
		},
		{
		  Label = "10";
		  "Dungar Longdrink, Gryphon Master";
		},
		{
		  Label = "11";
		  "Fragrant Flowers";
		  "Bernard Gump, Florist";
		  "Felicia Gump, Herbalism Supplier";
		},
		{
		  Label = "12";
		  "Jetty";
		},
		{
		  Label = "13";
		  "Canal Tailor & Fit Shop";
		  "Lisbeth Schneider, Clothier";
		  "Rema Schneider";
		},
		{
		  Label = "14";
		  "Jetty";
		  "Arnold Leland, Fishing Trainer";
		  "Catherine Leland, Fishing Supplier";
		},
		{
		  Label = "15";
		  "Gallina Winery";
		  "Julia Gallina, Wine Vendor";
		  "Roberto Pupellyverbos, Merlot";
		  " Connoisseur";
		  "Suzette Gallina";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Corbett Schneider";
		}
	      },
	      {
		Name = "Cathedral Square";
		Color = PURP;
		{
		  Label = "1";
		  "Ol' Emma";
		},
		{
		  Label = "2";
		  "The Argent Dawn";
		},
		{
		  Label = "3";
		  "City Hall";
		  "Baros Alexston, City Architect";
		  "Royal Factor Bathrilor, Stormwind";
		  " Census";
		},
		{
		  Label = "4";
		  "Brother Kristoff";
		},
		{
		  Label = "5";
		  "Cathedral of Light";
		  "Brother Sarno";
		  "Dunthorian Rall";
		  "Bishop Farthing";
		  "Arch Bishop Benedictus";
		  "Garzin Tenorm";
		  "High Priestess Laurena, Priest Trainer";
		  "Arthur the Faithfull, Paladin Trainer";
		  "Katherine the Pure, Paladin Trainer";
		  "Lord Grayson Shadowbreaker, Paladin";
		  " Trainer";
		  "Brother Joshua, Priest Trainer";
		  "Brother Benjamin, Priest Trainer";
		  "Sharina Fuller, First Aid Trainer";
		  "Brother Cassius, Reagent Vendor";
		  "Talent Master";
		  "Brother Anton, Scarlet Crusade";
		  " Emissary";
		  " (downstairs)";
		},
		{
		  Label = "6";
		  "Just Maces";
		  "Gregory Ardus, Staff & Mace";
		  " Merchant";
		},
		{
		  Label = "7";
		  "Righteous Plates";
		  "Agustus Moulaine, Mail Armor";
		  " Merchant";
		  "Theresa Moulaine, Robe Vendor";
		},
		{
		  Label = "8";
		  "The Finest Thread";
		},
		{
		  Label = "9";
		  "Morris Lawry";
		}
	      },
	      {
		Name = "The Park";
		Color = GREN;
		{
		  Label = "1";
		  "Sylista, Stable Master";
		},
		{
		  Label = "2";
		  "Inn";
		},
		{
		  Label = "3";
		  "Shylamir, Herbalism Trainer";
		},
		{
		  Label = "4";
		  "Tavern";
		  "Mailbox";
		},
		{
		  Label = "5";
		  "Argos Nightwhisper";
		  "Sheldras Moontree, Druid Trainer";
		  "Theridian, Druid Trainer";
		  "Nara Meideroe";
		  "Maldryn, Druid Trainer";
		},
		{
		  Label = "6";
		  "Imelda";
		  "Shailiea";
		  "Kimberly Grant";
		},
		{
		  Label = "7";
		  "Caretaker Folsom";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Kelly Grant";
		}
	      },
	      {
		Name = "Mage Quarter";
		Color = BLUE;
		{
		  Label = "1";
		  "Stockade";
		},
		{
		  Label = "2";
		  "Mazen Mac'Nadir, Academy of";
		  " Arcane Arts & Sciences";
		  "Adair Gilroy, Librarian";
		  "Acolyte Dellis";
		},
		{
		  Label = "3";
		  "Betty Quin, Journeyman Enchanter";
		  "Lucan Cordell, Expert Enchanter";
		  "Jessara Cordell, Enchanting Supplies";
		},
		{
		  Label = "4";
		  "Stormwind Staves";
		  "Ardwyn Cailen, Wand Merchant";
		  "Allan Hafgan, Saves Merchant";
		},
		{
		  Label = "5";
		  "Pyrotechnics";
		  "Darian Singh, Fireworks Vendor";
		},
		{
		  Label = "6";
		  "The Slaughtered Lamb";
		  "Jalane Ayrole, Master Shadoweave";
		  " Tailor";
		  "Zardeth of the Black Claw";
		  "Sandahl, Warlock Trainer";
		  "Gakin the Darkbinder";
		  "Demisette Cloyce, Warlock Trainer";
		  "Spackle Thornberry, Demon Trainer";
		  "Ursula Deline, Warlock Trainer";
		  "Acolyte Porena (downstairs)";
		},
		{
		  Label = "7";
		  "Ancient Curios";
		  "Charys Yserian, Arcane Trinkets";
		  " Vendor";
		},
		{
		  Label = "8";
		  "Essential Components";
		  "Owen Vaughn, Reagent Vendor";
		},
		{
		  Label = "9";
		  "Larson Clothiers";
		  "Wynne Larson, Robe Merchant";
		  "Evan Larson, Hatter";
		  "Sellandus, Expert Tailor";
		  "Thurman Shneider";
		},
		{
		  Label = "10";
		  "Archmage Malin";
		},
		{
		  Label = "11";
		  "The Blue Recluse";
		  "Angus Stern, Head Chef";
		  "Joachim Brenlow, Bartender";
		  "Conner Rivers, Apprentice Chef";
		  "Steven Lohan";
		  "Mailbox";
		},
		{
		  Label = "12";
		  "Collin Mauren";
		},
		{
		  Label = "13";
		  "Tannysa, Herbalism Trainer";
		},
		{
		  Label = "14";
		  "Alchemy Needs";
		  "Lilyssia Nightbreeze, Expert";
		  " Alchemist";
		  "Tel'Athir, Journeyman Alchemist";
		  "Maria Lumere, Alchemy Supplies";
		  "Eldraeith, Herbalism Supplies";
		},
		{
		  Label = "15";
		  "Duncan's Textiles";
		  "Duncan Cullen, Light Armor";
		  " Merchant";
		  "Alexandra Bolero, Tailoring Supplies";
		  "Georgio Bolero, Artisan Tailor";
		  "Lawrence Schneider, Journeyman";
		  " Tailor";
		},
		{
		  Label = "16";
		  "Wizard's Sanctum (big central tower)";
		  "Larimaine Purdue, Portal Trainer";
		  "Jennea Cannon, Mage Trainer";
		  "Elsharin, Mage Trainer";
		  "High Sorcerer Andromath";
		  "Maginor Dumas, Master Mage";
		}
	      },
	      {
		Name = "The Old Town";
		Color = ORNG;
		{
		  Label = "1";
		  "Pig & Whistle Tavern";
		  "Mailbox";
		  "Reese Langston, Tavernkeeper";
		  "Stephen Ryback, Cooking Trainer";
		  "Erika Tage, Cooking Supplier";
		  "Kendor Kabonka, Master of Cooking";
		  " Recipes (upstairs)";
		  "Bartleby, Drunk";
		  "David Langston";
		  "Aedis Bron";
		  "Christoph Faral";
		  "Harry Burlguard";
		  "Elly Langston, Barmaid";
		},
		{
		  Label = "2";
		  "Heavy Handed Weapons";
		  "Gerik Koen, Two-handed Weapon";
		  " Merchant";
		},
		{
		  Label = "3";
		  "Honest Blades";
		  "Heinrich Stone, Blade Merchant";
		},
		{
		  Label = "4";
		  "Limited Immunity";
		  "Osric Strang, Heavy Armor Merchant";
		  "Wilhelm Strang, Mail Armor Merchant";
		},
		{
		  Label = "5";
		  "Osborne the Night Man, Rogue Trainer";
		  "Officer Areyn, Non-com Accessories";
		  " Quartermaster";
		},
		{
		  Label = "6";
		  "Barracks";
		  "Master Mathias Shaw, Leader of SI:7";
		  "Renzik (The Shiv), SI:7 Operative";
		  "Jasper Fel, Shady Dealer";
		  "Sloan McCoy, Poison Supplier";
		},
		{
		  Label = "7";
		  "Master Wood";
		  "Ilsa Corbin, Warrior Trainer";
		  "Wu Shen, Warrior Trainer";
		  "Ander Germaine, Warrior Trainer";
		},
		{
		  Label = "8";
		  "The Protective Hide";
		  "Randal Worth, Journeyman";
		  " Leatherworker";
		  "Simon Tanner, Expert Leatherworker";
		  "Jillian Tanner, Leatherworking Supplier";
		  "Maris Granger, Skinning Trainer";
		  "Alyssa Griffith, Bag Vendor";
		  "Seoman Griffith, Leather Armor";
		  " Merchant";
		},
		{
		  Label = "9";
		  "Thane's Boots";
		  "Mayda Thane, Cobbler";
		},
		{
		  Label = "10";
		  "The Silver Shield";
		  "Bryan Cross, Shield Merchant";
		}
	      },
	      {
		Name = "Stormwind Keep";
		Color = YELL;
		{
		  Label = "1";
		  "Petitioner's Chamber";
		  "Count Remington Ridgewell, House of";
		  " Nobles";
		  "Lord Baurles K Wishock, House of";
		  " Nobles";
		  "Caledra Dawnbreeze";
		},
		{
		  Label = "2";
		  "High Lord Bolvar Fordragon";
		  "Anduin Wrynn, King of Stormwind";
		  "Lady Katrana Prestor";
		},
		{
		  Label = "3";
		  "Bishop Delavey";
		},
		{
		  Label = "4";
		  "War Room";
		  "Grand Admiral Jes-Tereth";
		  "Mithras Ironhill";
		},
		{
		  Label = "5";
		  "Major Samuelson, Stormwind City";
		  " Guard";
		},
		{
		  Label = "6";
		  "Tyrlon";
		},
		{
		  Label = "7";
		  "Royal Library";
		  "Milton Sheaf, Librarian";
		  "Donyal Tovald, Librarian";
		  "Lord Gregor Lescover";
		},
		{
		  Label = "8";
		  "Royal Gallery";
		}
	      },
	      {
		Name = "The Dwarven District";
		Color = _RED;
		{
		  Label = "1";
		  "Tavern";
		  "Brohann Caskbelly, Explorerers'";
		  " League";
		  "Wilder Thistlenettle";
		},
		{
		  Label = "2";
		  "Morgg Stormshot";
		},
		{
		  Label = "3";
		  "Jenova Stoneshield, Stable Master";
		},
		{
		  Label = "4";
		  "Einris Brightspear, Hunter Trainer";
		  "Ulfir Ironbeard, Hunter Trainer";
		  "Thorfin Stoneshield, Hunter Trainer";
		  "Karrina Mekenda, Pet Trainer";
		},
		{
		  Label = "5";
		  "Deeprun Tram";
		},
		{
		  Label = "6";
		  "Dwarven Embassy";
		},
		{
		  Label = "7";
		  "Sprite Jumpsprocket, Journeyman";
		  " Engineer";
		  "Lilliam Sparkspinkdle, Expert Engineer";
		  "Billibub Cogspinner, Engeineer";
		  " Supplier";
		},
		{
		  Label = "8";
		  "Thulman Flintcrag, Guns Vendor";
		},
		{
		  Label = "9";
		  "Borgus Steelhand, Weapon Crafter";
		  "Kathrum Axehand, Axe Merchant";
		  "Grimand Elmore";
		  "Anvil";
		},
		{
		  Label = "10";
		  "Brook Stonebraid, Mining Supplier";
		  "Gelman Stonehand, Mining Trainer";
		},
		{
		  Label = "11";
		  "Furen Longbeard";
		  "Dane Lindgren, Journeyman";
		  " Blacksmith";
		  "Therum Deepforge, Expert";
		  " Blacksmith";
		  "Kaita Deepforge, Blacksmith";
		  " Supplier";
		  "Hank the Hammer, Mithril Order";
		  "Forge";
		  "Anvil";
		},
		{
		  Label = "12";
		  "Shoni the Shilent";
		};
	      };
	    };
	  };
	  Thunderbluff = {
	    ZoneName = "Thunder Bluff (Horde - Tauren)";
	    Location = "Mulgore";
	    Areas =  {
	      {
		Name = "Center Column and Lifts";
		Color = WHITE;
		{
		  Label = "1";
		  "Tal, Wind Rider Master";
		  "Access to Lower, Middle, and Upper";
		  " Rise";
		},
		{
		  Label = "2";
		  "Lifts to Mulgore";
		}
	      },
	      {
		Name = "Lower Rise";
		Color = CYAN;
		{
		  Label = "1";
		  "Karn's Smithy";
		  "Orm Stonehoof";
		  "Taur Stonehoof, Blacksmith Supplier";
		  "Thrag Stonehoof, Journeyman";
		  " Blacksmith";
		  "Karn Stonehoof, Expert Blacksmith";
		  "  Trainer";
		  "Forge";
		  "Anvil";
		},
		{
		  Label = "2";
		  "Fry Mistrunner, Bread Vendor";
		},
		{
		  Label = "3";
		  "Sage Truthseeker";
		},
		{
		  Label = "4";
		  "Stonehoof Geology";
		  "Kurm Stonehoof, Mining Supplier";
		  "Brek Stonehoof, Mining Trainer";
		},
		{
		  Label = "5";
		  "Eyahn Eagletalon";
		  "Auld Stonespire";
		},
		{
		  Label = "6";
		  "Thunder Bluff Civic Information";
		  "Thrumn, Tabard Vendor";
		  "Krumn, Guild Master";
		},
		{
		  Label = "7";
		  "Kuruk's Goods";
		  "Pakwa, Bag Vendor";
		  "Kuruk, General Goods Vendor";
		},
		{
		  Label = "8";
		  "Trade Goods and Supplies";
		  "Shadi Mistrunner, Trade Goods";
		  " Supplier";
		},
		{
		  Label = "9";
		  "Jyn Stonehoof, Weapons Merchant";
		  "Ansekhwa, Weapon Master";
		},
		{
		  Label = "10";
		  "Innkeeper Pala";
		},
		{
		  Label = "11";
		  "Bulrug, Stable Master";
		},
		{
		  Label = "12";
		  "Bank";
		  "Chesmu, Banker";
		  "Torn, Banker";
		  "Atepa, Banker";
		  "Mailbox";
		},
		{
		  Label = "13";
		  "Hewa's Armory";
		  "Hewa, Cloth Armor Merchant";
		  "Elki, Mail Armor Merchant";
		  "Ahanu, Armor Merchant";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Chepi, Reagent Vendor";
		}
	      },
	      {
		Name = "Middle Elevation";
		Color = PURP;
		{
		  Label = "1";
		  "Thunderhorn's Archery";
		  "Kuna Thunderhorn, Bowyer &";
		  " Fletching Goods";
		},
		{
		  Label = "2";
		  "Fruits and Vegetables";
		  "Nan Mistrunner, Fruit Vendor";
		},
		{
		  Label = "3";
		  "Holistic Herbalism";
		  "Nida Winterhoof, Herbalism Supplier";
		  "Komin Winterhoof, Herbalism Trainer";
		},
		{
		  Label = "4";
		  "Cloudeweavers Baskets";
		  "Tand, Basket Weaver";
		},
		{
		  Label = "5";
		  "Bena's Alcehcmy";
		  "Bena Winterhoof, Expert Alchemist";
		  "Mani Winterhoof, Alchemy Supplier";
		  "Kray, Journeyman Alchemist";
		},
		{
		  Label = "6";
		  "Dawnstrider Enchanters";
		  "Nata Dawnstrider, Enchanting Supplier";
		  "Teg Dawnstrider, Expert Enchanter";
		  "Mot Dawnstrider, Journeyman";
		  " Enchanter";
		},
		{
		  Label = "7";
		  "Thunder Bluff Armorers";
		  "Mooranta, Skinning Trainer";
		  "Vhan, Journeyman Tailor";
		  "Veren Tallstrider";
		  "Tepa, Expert Tailor";
		  "Mahu, Leatherworking & Tailoring";
		  "  Supplies";
		  "Tagain, Cloth Armor Merchant";
		  "Fela, Heavy Armor Merchant";
		  "Grod, Leather Armour Merchant";
		  "Mak, Journeyman Leatherworker";
		  "Una, Artisan Leatherworker";
		  "Tarn, Expert Leatherworking";
		  "Rumstag Proudstrider";
		  "Horde Cloth Quartermaster";
		}
	      },
	      {
		Name = "Upper Rise";
		Color = GREN;
		{
		  Label = "1";
		  "Rainsticks";
		  "Sunn Ragetotem, Staff Merchant";
		},
		{
		  Label = "2";
		  "Kodo Steak & Ribs";
		  "Kaga Mistrunner, Meat Vendor";
		},
		{
		  Label = "3";
		  "Winterhoof Totems";
		  "Tah Winterhoof";
		},
		{
		  Label = "4";
		  "Mountaintop Bait & Tackle";
		  "Sewa Mistrunner, Fishing Supplier";
		  "Kah Mistrunner, Fishing Trainer";
		},
		{
		  Label = "5";
		  "Cairne Bloodhoof, High Chieftain";
		},
		{
		  Label = "6";
		  "Thunderbluff Firearms";
		  "Hogor Thunderhoof, Guns Merchant";
		},
		{
		  Label = "7";
		  "Ragetotem Arms";
		  "Delgo Ragetotem, Axe Merchant";
		  "Etu Ragetotem, Mace & Staff";
		  " Merchant";
		  "Ohanko, Two Handed Weapon";
		  " Merchant";
		  "Kard Ragetotem, Sword & Dagger";
		  "  Merchant";
		},
		{
		  Label = "8";
		  "Sura Wildmane, War Harness Vendor";
		},
		{
		  Label = "9";
		  "Aska's Kitchen";
		  "Naal Mistrunner, Cooking Supplier";
		  "Aska Mistrunner, Cooking Trainer";
		},
		{
		  Label = "10";
		  "Zangen Stonehoof";
		},
	      },
	      {
		Name = "Elder Rise";
		Color = _RED;
		{
		  Label = "1";
		  "Hall of Elders";
		  "Kym Wildmane, Druid Trainer";
		  "Turak Runetotem, Druid Trainer";
		  "Sheal Runetotem, Druid Trainer";
		  "Nara Wildmane";
		  "Arch Druid Hamuul Runetotem";
		},
		{
		  Label = "2";
		  "Bashana Runetotem";
		},
		{
		  Label = "3";
		  "Cor Grimtotem";
		  "Magatha Grimtotem, Elder Crone";
		  "Gorm Grimtotem";
		  "Rahuro, Magatha's Servant";
		},
		{
		  Label = "4";
		  "Elder Rise Drums";
		  "Sheza Wildmane";
		},
		{
		  Label = "5";
		  "Ghede";
		}
	      },
	      {
		Name = "Hunter Rise";
		Color = ORNG;
		{
		  Label = "1";
		  "Hunter's Hall";
		  "Henen Ragetotem";
		  "Urek Thunderhorn, Hunter Trainer";
		  "Kary Thunderhorn, Hunter Trainer";
		  "Holt Thunderhorn, Hunter Trainer";
		  "Sark Ragetotem, Warrior Trainer";
		  "Torm Ragetotem, Warrior Trainer";
		  "Ker Ragetotem, Warrior Trainer";
		},
		{
		  Label = "2";
		  "Saern Priderunner";
		  "Kon Yelloweyes";
		  "Melor Stonehoof";
		},
		{
		  Label = "3";
		  "Taim Ragetotem, Alterac Valley";
		  "  Battlemaster";
		},
		{
		  Label = "4";
		  "Kergul Bloodaxe, Warsong Gulch";
		  "  Battlemaster";
		},
		{
		  Label = "5";
		  "Mosarn";
		},
		{
		  Label = "6";
		  "Hesuwa Thunderhorn, Pet Trainer";
		}
	      },
	      {
		Name = "Spirit Rise";
		Color = CYAN;
		{
		  Label = "1";
		  "Hall of Spirits";
		  "Xanis Flameweaver";
		  "Beram Skychaser, Shaman Trainer";
		  "Siln Skychaser, Shaman Trainer";
		  "Tigor Skychaser, Shaman Trainer";
		},
		{
		  Label = "2";
		  "Spiritual Healing";
		  "Pand Stonebinder, First Aid Trainer";
		},
		{
		  Label = "3";
		  "Pawe Mistrunner";
		}
	      },
	      {
		Name = "Pools of Vision";
		Color = BLUE;
		{
		  Label = "1";
		  "Clarice Foster";
		  "Malakai Cross, Priest Trainer";
		  "Apothecary Zamah, Royal Apothecary";
		  "  Society";
		  "Birgitte Cranston, Portal Trainer";
		  "Archmage Shymm, Mage Trainer";
		  "Miles Welsh, Priest Trainer";
		  "Ursyn Ghull, Mage Trainer";
		};
	      };
	    };
	  };
	  Undercity = {
	    ZoneName = "Undercity (Horde - Undead)";
	    Location = "Tirisfal Glades";
	    Areas = {
	      {
		Name = "Trade Quarter";
		Color = WHITE;
		{
		  Label = "1";
		  "Eleanor Rusk, General Goods Vendor";
		},
		{
		  Label = "2";
		  "Felicia Doan, General Trade Goods";
		  " Vendor";
		  "Genavie Callow";
		},
		{
		  Label = "3";
		  "Michael Garrett, Bat Handler";
		  "Patrick Garrett";
		},
		{
		  Label = "4";
		  "Gordon Wendham, Weapons";
		  " Merchant";
		  "Louis Warren, Weapons Merchant";
		},
		{
		  Label = "5";
		  "Timothy Weldon, Heavy Armor";
		  " Merchant";
		  "Velora Nitely";
		  "Walter Ellingson, Heavy Armor";
		  " Merchant";
		  "Tawny Grisette, Mushroom Vendor";
		},
		{
		  Label = "6";
		  "Lauren Newcomb, Light Armor";
		  " Merchant";
		  "Daniel Bartlett, General Trade Supplier";
		},
		{
		  Label = "7";
		  "Anya Maulray, Stable Master";
		  "Innkeeper Norman";
		  "Mailbox";
		},
		{
		  Label = "8";
		  "Thomas Mordan, Reagent Vendor";
		},
		{
		  Label = "9";
		  "Bank";
		},
		{
		  Label = "10";
		  "Royal Overseer Bauhaus, Undercity";
		  "  Census";
		  "Edward Remington, Guild Tabard";
		  "  Designer";
		  "Christopher Drakul, Guild Master";
		  "Merill Pleasance, Tabard Vendor";
		},
		{
		  Label = "11";
		  "Eunice Burch, Cooking Trainer";
		  "Ronald Burch, Cooking Supplier";
		  "Raleigh Andrean, Ex-Chef";
		}
	      },
	      {
		Name = "The Apothecarium";
		Color = GREN;
		{
		  Label = "1";
		  "Keeper Bel'dugur";
		},
		{
		  Label = "2";
		  "Martha Alliestar, Herbalism Trainer";
		  "Katrina Alliestar, Herbalism Supplier";
		},
		{
		  Label = "3";
		  "Blue Moon Odds and Ends";
		  "Alessandro Luca";
		},
		{
		  Label = "2";
		  "Malcomb Whynn, Journeyman";
		  " Enchanter";
		  "Thaddeus Webb, Enchanting Supplies";
		  "Lavinia Crowe, Expert Enchanter";
		},
		{
		  Label = "5";
		  "Andron Gant";
		},
		{
		  Label = "6";
		  "Doctor Marsh, Expert Alchemist";
		  "Algernon, Alchemy Supplies";
		},
		{
		  Label = "7";
		  "Doctor Martin Felben, Journeyman";
		  "  Alchemist";
		  "Chemist Cuely";
		  "Master Apothecary Faranell";
		  "Apothecary Zinge";
		  "Doctor Herbert Halsey, Artisan";
		  "  Alchemist";
		  "Chemist Fuely";
		  "Theodore Griffs";
		  "Apothecary Keever, Royal Apothecary";
		  "  Society";
		},
		{
		  Label = "8";
		  "Ganoosh";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Apothecary Vallia";
		  "Apothecary Katrina";
		  "Apothecary  Lycanus";
		  "Parqual Fintallas";
		}
	      },
	      {
		Name = "War Quarter";
		Color = BLUE;
		{
		  Label = "1";
		  "Gerard Abernathy";
		  "Leona Tharpe";
		  "Joanna Whitehall";
		},
		{
		  Label = "2";
		  "Abigail Sawyer, Bow Merchant";
		},
		{
		  Label = "3";
		  "Sarah Killan, Mining Supplier";
		  "Brom Killian, Mining Trainer";
		},
		{
		  Label = "4";
		  "Archibald, Weapon Master";
		  "Geoffrey Hartwell, Weapon Merchant";
		  "Benijah Fenner, Weapon Merchant";
		  "Francis Eliot, Weapon Merchant";
		},
		{
		  Label = "5";
		  "Basil Frye, Journeyman Blacksmith";
		  "Mirelle Tremayne, Heavy Armor";
		  "  Merchant";
		  "Samuel Van Brunt, Blacksmithing";
		  "  Supplies";
		  "James Van Brunt, Expert Blacksmith";
		},
		{
		  Label = "6";
		  "Nicholas Atwood, Gun Merchant";
		},
		{
		  Label = "7";
		  "Helena Atwood";
		},
		{
		  Label = "8";
		  "Sergeant Houser";
		},
		{
		  Label = "9";
		  "Father Lankester, Priest Trainer";
		  "Father Lazarus, Priest Trainer";
		  "Aelthalyste, Priest Trainer";
		},
		{
		  Label = "10";
		  "Baltus Fowler, Warrior Trainer";
		  "Angela Curthas, Warrior Trainer";
		  "Christopher Walker, Warrior Trainer";
		},
	      },
	      {
		Name = "Magic Quarter";
		Color = ORNG;
		{
		  Label = "1";
		  "Zane Bradford, Wand Vendor";
		  "Sydney Upton, Staff Merchant";
		},
		{
		  Label = "2";
		  "Sheldon Von Croy, Cloth Armor";
		  "  Merchant";
		  "Victor Wand, Journeyman Tailor";
		  "Riannon Davis, Expert Tailor";
		  "Millie Gregorian, Tailoring Supplies";
		  "Josef Gregorian, Artisan Tailor";
		  "Lucille Castleton, Robe Vendor";
		},
		{
		  Label = "3";
		  "Oran Snakewrite";
		  "Samatha Shackleton";
		  "Andrew Brownell";
		},
		{
		  Label = "4";
		  "Jorah Annison";
		},
		{
		  Label = "5";
		  "Salazar Bloch, Book Dealer";
		},
		{
		  Label = "6";
		  "Hannah Akeley, Reagent Supplies";
		},
		{
		  Label = "7";
		  "Silas Zimmer";
		},
		{
		  Label = "8";
		  "Josephine Lister, Master Shadoweave";
		  "  Tailor";
		},
		{
		  Label = "9";
		  "Carendin Halgar";
		},
		{
		  Label = "10";
		  "Bethor Iceshard";
		  "Lexington Mortaim, Portal Trainer";
		},
		{
		  Label = "11";
		  "Richard Kerwin, Warlock Trainer";
		},
		{
		  Label = "12";
		  "Anastasia Hartwell, Mage Trainer";
		},
		{
		  Label = "13";
		  "Luther Pickman, Warlock Trainer";
		  "Kaal Soulreaper, Warlock Trainer";
		  "Martha Strain, Demon Trainer";
		  "Godrick Farsan";
		  "Kaelystia Hatebringer, Mage Trainer";
		  "Pierce Shackleton, Mage Trainer";
		},
		{
		  Label = "14";
		  "Armand Cromwell, Fishing Trainer";
		  "Lizbeth Cromwell, Fishing Supplies";
		}
	      },
	      {
		Name = "Royal Quarter";
		Color = PURP;
		{
		  Label = "1";
		  "Lady Sylvanas Windrunner, Banshee";
		  "  Queen";
		  "Sharlindra";
		  "Varimathras";
		},
		{
		  Label = "2";
		  "Sir Malory Wheeler; Arathi Basin";
		  "  Battlemaster";
		},
		{
		  Label = "3";
		  "Grizzle Halfmane; Alterac Valley";
		  "  Battlemaster";
		},
		{
		  Label = "4";
		  "Horde Warbringer";
		},
		{
		  Label = "5";
		  "Kurden Bloodclaw";
		}
	      },
	      {
		Name = "Rogues' Quarter";
		Color = _RED;
		{
		  Label = "1";
		  "Charles Seaton, Blade Merchant";
		  "Nathaniel Steenwick, Thrown Weapon";
		  "  Merchant";
		},
		{
		  Label = "2";
		  "Ezekiel Graves, Poison Vendor";
		},
		{
		  Label = "3";
		  "Mary Edras, First Aid Trainer";
		},
		{
		  Label = "4";
		  "Dan Golthas, Journeyman";
		  " Leatherworker";
		  "Gillian Moore, Leather Armor";
		  " Merchant";
		  "Arthur Moore, Expert Leatherworker";
		  "Joseph Moore, Leatherworking";
		  " Supplies";
		  "Killian Hagey, Skinning Trainer";
		},
		{
		  Label = "5";
		  "Jonathan Chambers, Bag Vendor";
		},
		{
		  Label = "6";
		  "Carolyn Ward, Rogue Trainer";
		  "Miles Dexter, Rogue Trainer";
		  "Gregory Charles, Rogue Trainer";
		},
		{
		  Label = "7";
		  "Gothard Winslow";
		  "Men net Carkard";
		},
		{
		  Label = "8";
		  "Estelle Gendry";
		},
		{
		  Label = "9";
		  "Lucian Fenner";
		  "Forge";
		  "Anvil";
		  "Graham Van Talen, Journeyman";
		  " Engineer";
		  "Franklin Lloyd, Expert Engineer";
		  "Elizabeth Van Talen, Engineering";
		  "  Supplies";
		},
		{
		  Label = "Wandering";
		  " ";
		  "Cedric Stumpel";
		  "Susan Tillinghast";
		};
	      };
	    };
	  };
	  Shattrath = {
	    ZoneName = "Shattrath (Neutral)";
	    Location = "Terokkar Forest";

	    Areas = {
	      {
		Name = "Scryers Tier";
		Color = GREN;
		{
		  Label = "1";
		  "Inn";
		  "Innkeeper Haelthol";
		  "Ilthuril, Stable Master";
		  "Trader Endernor, Trade Goods";
		  "Dathris Sunstriker";
		  "Lisrythe Bloodwatch, Fence";
		  "Mahir Redstroke, Dagger Vendor";
		},
		{
		  Label = "2";
		  "Nalama the Merchant, General Goods";
		  "Urumir Stavebright, Staff Vendor";
		},
		{
		  Label = "3";
		  "Magister Falris";
		  "Magistrix Fyalenn";
		},
		{
		  Label = "4";
		  "The Seer's Library";
		  "Arodis Sunblade, Keeper of Sha'tari";
		  " Artifacts (Tier 4 Vendor)";
		  "Veynna Dawnstar, Keeper of Sha'tari";
		  "Heirlooms (Tier 5 Vendor)";
		  "Enchanter Salias, Journeyman";
		  " Enchanter";
		  "Enchantress Metura, Expert Enchanter";
		  "Enchanter Aeldron, Artisan Enchanter";
		  "Enchantress Volali, Master Enchanter";
		  "High Enchanter Bardolan, Grand";
		  " Master Enchanter";
		  "Voren'thal the Seer";
		},
		{
		  Label = "5";
		  "Quelama Lightblade, Wand Vendor";
		  "Selanam the Blade, Sword Vendor";
		},
		{
		  Label = "6";
		  "Lift to Aldor Rise";
		},
		{
		  Label = "7";
		  "Vinemaster Alamaro, Wine Vendor";
		  "Amshesha Stilldark, Reagent Vendor";
		  "Yurial Soulwater, Enchanting Supplies";
		}
	      },
	      {
		Name = "Terrace of the Light";
		Color = WHITE;
		{
		  Label = "1";
		  "A'dal";
		  "Khadgar";
		  "Grand Anchorite Almonen";
		},
		{
		  Label = "2";
		  "Shattrath Portal to Thunder Bluff";
		  "Shattrath Portal to Orgrimmar";
		  "Shattrath Portal to Undercity";
		},
		{
		  Label = "3";
		  "G'eras (Heroic Mode Instance reward";
		  " vendor)";
		  "Almaador, Sha'tari Quartermaster";
		},
		{
		  Label = "4";
		  "Shattrath Portal to Darnassus";
		  "Shattrath Portal to Stormwind";
		  "Shattrath Portal to Ironforge";
		},
		{
		  Label = "5";
		  "V'eru";
		  "Iorioa, Portal Trainer";
		  "Shattrath Portal to the Exodar";
		  "Shattrath Portal to Silvermoon City";
		},
		{
		  Label = "6";
		  "Nutral, Flight Master";
		},
		{
		  Label = "7";
		  "Bank (Aldor aligned)";
		  "Mailbox";
		  "Gromden, Banker";
		  "Mendorn, Banker";
		  "Quartermaster Endarin, Aldor";
		  " Quartermaster";
		},
		{
		  Label = "8";
		  "Bank (Scryer aligned)";
		  "Mailbox";
		  "L'lura Goldspun, Banker";
		  "Berudan Keysworn, Banker";
		  "Quartermaster Enuril, Scryer";
		  " Quartermaster";
		  "Inscriber Veredis, Scryer Inscriptions";
		},
		{
		  Label = "9";
		  "Lift to Scryer's Tier";
		},
		{
		  Label = "10";
		  "Lift to Aldor Rise";
		}
	      },
	      {
		Name = "Lower City";
		Color = CYAN;
		{
		  Label = "1";
		  "Dirty Larry";
		  "Epic Malone";
		  "Creepjack";
		},
		{
		  Label = "2";
		  "Karokka, Poison Supplies";
		  "Skreah, Alchemy Supplies";
		  "Lorokeem, Grand Master Alchemist";
		},
		{
		  Label = "3";
		  "Araac";
		},
		{
		  Label = "4";
		  "Lissaf, Blade Merchant";
		  "Vekax";
		},
		{
		  Label = "5";
		  "Ramp to Terrace of Light";
		  "Rilak the Redeemed";
		  "Defender Grashna";
		  "Iz'zard";
		  "Arcanist Adyria";
		},
		{
		  Label = "6";
		  "Oloraak, Fish Merchant";
		},
		{
		  Label = "7";
		  "Shattrath Infirmary";
		  "Sha'nir";
		  "Seth";
		  "Zahila";
		},
		{
		  Label = "8";
		  "Exit to Terokkar Forest";
		},
		{
		  Label = "9";
		  "Ramp to Terrace of Light";
		  "Haelga Slatefist, Alterac Valley";
		  " Battlemaster";
		  "Lylandor, Warsong Gulch Battlemaster";
		  "Iravar, Eye of the Storm Battlemaster";
		  "Adam Eternum, Arathi Basin";
		  " Battlemaster";
		  "Battle-Tiger, Adam Eternum's Pet";
		  "Oric Coe";
		},
		{
		  Label = "10";
		  "World's End Tavern";
		  "Mailbox";
		  "Wind Trader Lathrai";
		  "Shaarubo, Bartender";
		  "Lonika Stillblade, Rogue Academy";
		  " Proprietor";
		  "Sal'salabim";
		  "Albert Quarksprocket";
		  "Kylene, Barmaid";
		  "Haris Pilton, Socialite";
		  "Tinkerbell, Haris Pilton's Pet";
		  "Leatei";
		  "Raliq the Drunk";
		  "Shattrath Saul";
		},
		{
		  Label = "11";
		  "Exit to Terokkar Forest";
		},
		{
		  Label = "12";
		  "Kradu Grimblade, Weapon Crafter";
		  "Zula Slagfury, Armor Crafter";
		  "Anvil";
		},
		{
		  Label = "13";
		  "Mailbox";
		  "Nicole Bartlett, Matron";
		},
		{
		  Label = "14";
		  "Ramp to Terrace of Light";
		  "Backstab Bindo Gearbomb, Arena";
		  " Battlemaster";
		  "Montok Redhands, Warsong Gulch";
		  " Battlemaster";
		  "Wolf-Sister Maka, Alterac Valley";
		  " Battlemaster";
		  "Keldor the Lost, Arathi Basin";
		  " Battlemaster";
		  "Yula the Fair, Eye of the Storm";
		  " Battlemaster";
		},
		{
		  Label = "15";
		  "Exit to Terokkar Forest";
		},
		{
		  Label = "16";
		  "Mana Loom";
		  "Ernie Packwell, Trade Goods";
		  "Cro Threadstrong, Leatherworking";
		  " Supplies";
		  "Darmari, Grand Master";
		  " Leatherworker";
		  "Andrion Darkspinner, Shadoweave";
		  " Specialist";
		  "Gidge Spellweaver, Spellfire";
		  " Specialist";
		  "Nasmara Moonsong, Mooncloth";
		  " Specialist";
		  "Eiin, Specialty Tailoring Supplies";
		  "Griftah, Amazing Amulets";
		  "Viggz Shinesparked, Engineering";
		  " Supplies";
		  "Fantai, Reagent Vendor";
		  "Gordie";
		  "Tobias the Filth Gorger";
		  "Aaron Hollman, Blacksmithing";
		  " Supplies";
		  "Madam Ruby, Enchanting Supplies";
		  "Eral, General Goods";
		  "Muffin Man Moser, Bread Merchant";
		  "Nakodu, Lower City Quartermaster";
		  "Jack Trapper, Cook";
		  "Jim Saltit, Cooking Supplier";
		  "Granny Smith, Fruit Seller";
		  "Seymour, Grand Master Skinner";
		}
	      },
	      {
		Name = "Aldor Rise";
		Color = PURP;
		{
		  Label = "1";
		  "Inn";
		  "Mailbox";
		  "Minalei, Innkeeper";
		  "Garul, Food and Drink Vendor";
		  "Oruhe, Stable Master";
		},
		{
		  Label = "2";
		  "Exit to Nagrand";
		},
		{
		  Label = "3";
		  "Harbinger Erothem";
		},
		{
		  Label = "4";
		  "Shrine of Unending Light";
		  "Ishanah, High Priestess of the Aldor";
		  "Kelara, Keeper of Sha'tari Heirlooms";
		  " (Tier 5 Vendor)";
		  "Asuur, Keeper of Sha'tari Artifacts";
		  " (Tier 4 Vendor)";
		},
		{
		  Label = "5";
		  "Hamanar, Grand Master Jewelcrafter";
		  "Inessera, Jewelcrafting Supplies";
		  " Vendor";
		  "Ahemen, Staff Vendor";
		};
	      };
	    };
	  };
	  Silvermoon = {
	    ZoneName = "Silvermoon (Horde - Blood Elf)";
	    Location = "Eversong Woods";

	    Areas = {
	      {
		Name = "Sundury Spire";
		Color = BLUE;
		{
		  Label = "1";
		  "Orb of Translocation to Undercity";
		},
		{
		  Label = "2";
		  "Lor'themar Theron, Regent Lord of";
		  " Quel'Thalas";
		  "Halduron Brightwing, Ranger General";
		  "Grand Magister Rommath";
		},
		{
		  Label = "3";
		  "Lotheolan, Priest Trainer";
		  "Belestra, Priest Trainer";
		  "Aldrea, Priest Trainer";
		},
		{
		  Label = "4";
		  "Zaedana, Mage Trainer";
		  "Quithas, Mage Trainer";
		  "Inethven, Mage Trainer";
		  "Narinth, Portal Trainer";
		}
	      },
	      {
		Name = "Court of the Sun";
		Color = ORNG;
		{
		  Label = "1";
		  "Razia, Journeyman Alchemist";
		  "Camberon, Expert Alchemist";
		  "Botanist Nathera, Herbalist";
		  "Melaris, Alchemy Supplier";
		},
		{
		  Label = "2";
		  "Dolothos, Journeyman Enchanter";
		  "Sedana, Expert Enchanter";
		  "Lyna, Enchanting Supplier";
		},
		{
		  Label = "3";
		  "Mailbox";
		}
	      },
	      {
		Name = "Farstriders Square";
		Color = _RED;
		{
		  Label = "1";
		  "Gloresse, Journeyman Engineer";
		  "Danwe, Expert Engineer";
		  "Yatheon, Engineering Supplier";
		},
		{
		  Label = "2";
		  "Forge & Anvils";
		  "Mirvedon, Journeyman Blacksmith";
		  "Bemarrin, Expert Blacksmith";
		  "Eriden, Blacksmithing Supplier";
		  "Belil, Mining Trainer";
		  "Zelan, Mining Supplies";
		},
		{
		  Label = "3";
		  "Shalenn, Stable Master";
		  "Tana, Hunter Trainer";
		  "Oninath, Hunter Trainer";
		  "Zandine, Hunter Trainer";
		  "Halthenis, Pet Trainer";
		},
		{
		  Label = "4";
		  "Stairs to Lower Section";
		},
		{
		  Label = "5";
		  "Celana, Bowyer";
		  "Mathaleron, Gunsmith";
		},
		{
		  Label = "6";
		  "Osselan, Paladin Trainer";
		  "Ithelis, Paladin Trainer";
		  "Champion Bachi, Paladin Trainer";
		  "M'uru (Lower Section)";
		  "Lady Liadrin, Blood Knight Matriach";
		  " (Lower Section)";
		},
		{
		  Label = "7";
		  "Bipp Glizzitor, Arena Battlemaster";
		  "Karen Wentworth, Arathi Basin";
		  " Battlemaster";
		  "Gurak, Alterac Valley Battlemaster";
		  "Duyash the Cruel, Eye of the Storm";
		  " Battlemaster";
		  "Krukk, Warsong Gulch Battlemaster";
		},
		{
		  Label = "8";
		  "Mailbox";
		}
	      },
	      {
		Name = "The Royal Exchange";
		Color = GREN;
		{
		  Label = "1";
		  "Mailbox";
		},
		{
		  Label = "2";
		  "Bank";
		  "Novia, Banker";
		  "Periel, Banker";
		  "Daenice, Banker";
		},
		{
		  Label = "3";
		  "Auction House";
		  "Tandron, Auctioneer";
		  "Ithillan, Auctioneer";
		  "Caidori, Auctioneer";
		},
		{
		  Label = "4";
		  "Inn";
		  "Vinemaster Suntouched, Wine &";
		  " Spirits Merchant";
		  "Innkeeper Velandra, Innkeeper";
		  "Blood Knight Adept";
		  "Blood Knight Stillblade";
		},
		{
		  Label = "5";
		  "Double Mailboxes";
		},
		{
		  Label = "6";
		  "Amin, Journeyman Jewelcrafter";
		  "Kalinda, Master Jewelcrafter";
		  "Gelanthis, Jewelcrafting Supplier";
		}
	      },
	      {
		Name = "Walk of Elders";
		Color = PURP;
		{
		  Label = "1";
		  "Alestus, First Aid Trainer";
		  "Drathen, Fishing Trainer";
		  "Olirea, Fishing Supplier";
		},
		{
		  Label = "2";
		  "Talmar, Journeyman Leatherworker";
		  "Lynalis, Expert Leatherworker";
		  "Zaralda, Leatherworking Supplier";
		  "Tyn, Skinner";
		},
		{
		  Label = "3";
		  "Tandrine, Guild Master";
		  "Kredis, Tabard Vendor";
		},
		{
		  Label = "4";
		  "Double Mailboxes";
		},
		{
		  Label = "5";
		  "Zathanna, Wand Vendor";
		  "Velanni, Arcane Goods Vendor";
		},
		{
		  Label = "6";
		  "Harene Plainwalker, Druid Trainer";
		},
		{
		  Label = "7";
		  "Exit to Eversong Woods";
		}
	      },
	      {
		Name = "Murder Row";
		Color = CYAN;
		{
		  Label = "1";
		  "Nerisen, Rogue Trainer";
		  "Elara, Rogue Trainer";
		  "Zelanis, Rogue Trainer";
		  "Darlia, Poison Supplier";
		},
		{
		  Label = "2";
		  "Talionia, Warlock Trainer";
		  "Alamma, Warlock Trainer";
		  "Zanien, Warlock Trainer";
		  "Torian, Demon Trainer";
		},
		{
		  Label = "3";
		  "Mailbox";
		}
	      },
	      {
		Name = "The Bazaar";
		Color = WHITE;
		{
		  Label = "1";
		  "Sorim Lightsong, Horde Cloth";
		  " Quartmaster";
		  "Zyandrel, Cloth Armor Merchant";
		  "Andra, Clothier";
		  "Rathin, Bag Vendor";
		},
		{
		  Label = "2";
		  "Bithrus, Fireworks Vendor";
		},
		{
		  Label = "3";
		  "Galana, Journeyman Tailor";
		  "Keelen Sheets, Expert Tailor";
		  "Deynna, Tailoring Supplier";
		},
		{
		  Label = "4";
		  "Welethelon, Blunt Weapon Merchant";
		  "Noraelath, Leather Armor Merchant";
		  "Rahein, Blade Vendor";
		  "Feledis, Axe Vendor";
		},
		{
		  Label = "5";
		  "Auction House";
		  "Jenath, Auctioneer";
		  "Darise, Auctioneer";
		  "Feynna, Auctioneer";
		  "Vynna, Auctioneer";
		},
		{
		  Label = "6";
		  "Parnis, Tradesman";
		},
		{
		  Label = "7";
		  "Inn";
		  "Innkeeper Jovia, Innkeeper";
		  "Sylann, Cook";
		  "Quelis, Cooking Supplier";
		},
		{
		  Label = "8";
		  "Bank";
		  "Officer Dawning, Silvermoon City";
		  " Commendations";
		  "Hatheon, Banker";
		  "Ceera, Banker";
		  "Elana, Banker";
		},
		{
		  Label = "9";
		  "Keeli, Mail Armor Merchant";
		  "Tynna, Plate Armor Merchant";
		  "Winthren, Shield Merchant";
		},
		{
		  Label = "10";
		  "Sathren Azuredawn, General Goods";
		  "Zalle, Reagent Vendor";
		};
	      };
	    };
	  };
	  Exodar = {
	    ZoneName = "Exodar (Alliance - Draeni)";
	    Location = "Azuremyst Isle";

	    Areas = {
	      {
		Name = "Entrance";
		Color = _RED;
		{
		  Label = "1";
		  "Front";
		},
		{
		  Label = "2";
		  "Rear";
		}
	      },
	      {
		Name = "Outside";
		Color = YELL;
		{
		  Label = "1";
		  "Mailbox";
		},
		{
		  Label = "2";
		  "Stephanos, Hippogryph Master";
		  " (outside)";
		},
		{
		  Label = "3";
		  "Elekk";
		  "Torallius the Pack Handler, Elekk";
		  " Breeder";
		  "Aalun, Riding Trainer";
		}
	      },
	      {
		Name = "Seat of the Naaru";
		Color = GREN;
		{
		  Label = "1";
		  "Auction House";
		  "Eoch, Auctioneer";
		  "Iressa, Auctioneer";
		  "Fanin, Auctioneer";
		},
		{
		  Label = "2";
		  "Bank";
		  "Ossco, Banker";
		  "Jaela, Banker";
		  "Kellag, Banker";
		},
		{
		  Label = "3";
		  "Mailbox";
		},
		{
		  Label = "4";
		  "Inn";
		  "Caregiver Breel, Innkeeper";
		  "Miglik Blotstrom, Arena Battlemaster";
		  "Arthaid, Stable Master";
		},
		{
		  Label = "5";
		  "Mumman, Cook";
		  "Phea, Cooking Supplier";
		},
		{
		  Label = "6";
		  "Onnis, General Goods Vendor";
		  "Cuzi, Bag Vendor";
		},
		{
		  Label = "7";
		  "Herald Brandaan";
		},
		{
		  Label = "8";
		  "Nurguni, Tradesman";
		},
		{
		  Label = "9";
		  "Oros (lower)";
		}
	      },
	      {
		Name = "Traders Tier";
		Color = WHITE;
		{
		  Label = "1";
		  "Tailors";
		  "Kayaart, Journeyman Tailor";
		  "Refik, Master Tailor";
		  "Neii, Tailoring Supplies";
		  "Dugiru, Alliance Cloth Quartermaster";
		},
		{
		  Label = "2";
		  "Leatherworking and Skinning";
		  "Remere, Skinner";
		  "Feruul, Journeyman Leatherworker";
		  "Akham, Expert Leatherworker";
		  "Heferet, Leatherworking Supplier";
		},
		{
		  Label = "3";
		  "Plate Armor & Shields";
		  "Gotaan, Plate Armor Merchant";
		  "Treall, Shield Merchant";
		},
		{
		  Label = "4";
		  "Bladed Weapons";
		  "Ven, Blade Vendor";
		},
		{
		  Label = "5";
		  "Blunt Weapons";
		  "Ellomin, Blunt Weapon Merchant";
		},
		{
		  Label = "6";
		  "Leather & Cloth Armor (up stairs)";
		  "Mahri, Leather Armor Merchant";
		  "Gornii, Cloth Armor Merchant";
		},
		{
		  Label = "7";
		  "Mail Armor (up stairs)";
		  "Yil, Mail Armor Merchant";
		},
		{
		  Label = "8";
		  "Mining and Smithing";
		  "Muaat, Mining Trainer";
		  "Merran, Mining Supplies";
		  "Edrem, Journeyman Blacksmith";
		  "Miall, Expert Blacksmith";
		  "Arras, Blacksmithing Supplies";
		},
		{
		  Label = "9";
		  "Engineering";
		  "Ghermas, Journeyman Engineer";
		  "Ockil, Expert Engineer";
		  "Feera, Engineering Supplies";
		},
		{
		  Label = "10";
		  "Hunters Sanctum";
		  "Deremiis, Hunter Trainer";
		  "Vord, Hunter Trainer";
		  "Killac, Hunter Trainer";
		  "Ganaar, Pet Trainer";
		  "Avelii, Bower";
		  "Muhaa, Gunsmith";
		},
		{
		  Label = "11";
		  "Ring of Arms";
		  "Ahonan, Warrior Trainer";
		  "Kazi, Warrior Trainer";
		  "Behomat, Warrior Trainer";
		  "Handiir, Weapon Master";
		},
		{
		  Label = "12";
		  "Guild Master and Tabards";
		  "Funaam, Guild Master";
		  "Issca, Tabard Vendor";
		}
	      },
	      {
		Name = "The Vault of Lights";
		Color = PURP;
		{
		  Label = "1";
		  "Hall of the Mystics";
		  "Bati, Mage Trainer";
		  "Harnan, Mage Trainer";
		  "Edirah, Mage Trainer";
		  "Lunaraa, Portal Trainer";
		  "Oss, Wand Vendor";
		},
		{
		  Label = "2";
		  "Vindicators Sanctum";
		  "Kavaan, Paladin Trainer";
		  "Jol, Paladin Trainer";
		  "Baatun, Paladin Trainer";
		},
		{
		  Label = "3";
		  "Alchemy and Herbalism";
		  "Deriz, Journeyman Herbalist";
		  "Lucc, Expert Herbalist";
		  "Altaa, Alchemy Supplier";
		  "Cemmorhan, Herbalist";
		},
		{
		  Label = "4";
		  "Tolo, Arathi Basin Battlemaster";
		},
		{
		  Label = "5";
		  "Mahul, Alterac Valley Battlemaster";
		},
		{
		  Label = "6";
		  "Mitia, Eye of the Storm Battlemaster";
		},
		{
		  Label = "7";
		  "Jihi, Warsong Gulch Battlemaster";
		},
		{
		  Label = "8";
		  "Prophet Velen, Level ?? (Boss)";
		},
		{
		  Label = "9";
		  "Anchorites Sanctum";
		  "Izmir, Priest Trainer";
		  "Fallat, Priest Trainer";
		  "Caedmos, Priest Trainer";
		}
	      },
	      {
		Name = "The Crystal Hall";
		Color = CYAN;
		{
		  Label = "1";
		  "Enchanting";
		  "Kudrii, Journeyman Enchanter";
		  "Nahogg, Expert Enchanter";
		  "Egomis, Echanting Supplier";
		},
		{
		  Label = "2";
		  "Sixx, Moth Vendor (lower)";
		},
		{
		  Label = "3";
		  "Gurrag, Shaman Trainer";
		},
		{
		  Label = "4";
		  "Farseer Nobundo, Shaman Trainer";
		  " (upper)";
		  "Foreman Dunaer";
		  "Valon";
		},
		{
		  Label = "5";
		  "Sulaa, Shaman Trainer";
		},
		{
		  Label = "6";
		  "Fishing";
		  "Erett, Fishing Trainer";
		  "Dekin, Fishing Supplier";
		},
		{
		  Label = "7";
		  "Hobahken, Shaman Trainer";
		},
		{
		  Label = "8";
		  "Reagents";
		  "Bildine, Reagent Vendor";
		},
		{
		  Label = "9";
		  "First Aid";
		  "Nus, First Aid Trainer";
		},
		{
		  Label = "10";
		  "Jewelcrafting";
		  "Padaar, Journeyman Jewelcrafter";
		  "Farii, Expert Jewelcrafter";
		  "Arred, Jewelcrafting Supplier";
		},
		{
		  Label = "11";
		  "Seer Skaltesh";
		}
	      }
	    }
	  }
	}

	Atlas_RegisterPlugin("AtlasMajorCities", myCategory, myData);

end
