-------------------------------------------------------------------------------
-- SmartBuff
-- Created by Aeldra (EU-Proudmoore)
--
-- FuBar support
-------------------------------------------------------------------------------

SMARTBUFF_FU_ICON_ON = "Interface\\AddOns\\SmartBuff\\Icons\\TitanButtonEnabled";
SMARTBUFF_FU_ICON_OFF = "Interface\\AddOns\\SmartBuff\\Icons\\TitanButtonDisabled";

local tablet;
local SMARTBUFF_Fu;

function SMARTBUFF_Fu_SetIcon()
	if (SMARTBUFF_Fu and SMARTBUFF_Options) then
    if (SMARTBUFF_Options.Toggle) then
      SMARTBUFF_Fu:SetIcon(TITAN_SMARTBUFF_ICON_ON);
	  else
      SMARTBUFF_Fu:SetIcon(TITAN_SMARTBUFF_ICON_OFF);
	  end
	  SMARTBUFF_AddMsgD("SB FuBar icon set");		
	end
end

function SMARTBUFF_FuBar_OnLoad()
  if (not AceLibrary("AceAddon-2.0")) then return; end
  
  tablet = AceLibrary("Tablet-2.0");
  SMARTBUFF_Fu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0");
  SMARTBUFF_Fu.hasIcon = SMARTBUFF_FU_ICON_ON;
  SMARTBUFF_Fu.hasNoColor = true;
  --SMARTBUFF_Fu.hasNoText = true;
  SMARTBUFF_Fu.cannotHideText = true;
  SMARTBUFF_Fu.cannotDetachTooltip = true;
  SMARTBUFF_Fu.defaultMinimapPosition = 220;
  SMARTBUFF_Fu.title = SMARTBUFF_TITLE;
  SMARTBUFF_Fu.version = SMARTBUFF_VERSION;
  SMARTBUFF_Fu.name = SMARTBUFF_TITLE;
  SMARTBUFF_Fu.category = "interface";

  function SMARTBUFF_Fu:OnTooltipUpdate()
    if (tablet) then
      tablet:SetHint("\nLeft Click: Open options\nShift-Left Click: on/off");
    end
  end

  function SMARTBUFF_Fu:OnClick()
    if (arg1 == "LeftButton" and IsShiftKeyDown()) then
      SMARTBUFF_OToggle();
    elseif (arg1 == "LeftButton") then
      SMARTBUFF_OptionsFrame_Toggle();    
    end
    SMARTBUFF_AddMsgD("SB FuBar clicked: " .. arg1);
  end

  function SMARTBUFF_Fu:OnTextUpdate()
    self:SetText("SB");
  end
  
  SMARTBUFF_AddMsgD("SB FuBar loaded");
end

