--
-- AutoBar
-- Item List Database
--
-- Maintained by Azethoth / Toadkiller of Proudmoore.  Original author Saien of Hyjal
-- http://www.wowace.com/wiki/AutoBar
-- http://www.curse-gaming.com/en/wow/addons-4430-1-autobar-toadkiller.html
--

AutoBarItemList = {};

local L = AceLibrary("AceLocale-2.2"):new("AutoBar");
local PT = PeriodicTableEmbed:GetInstance("1");


local function sortList(a, b)
	return a[2] < b[2];
end


-- Get set as a simple array of itemIds, ordered by their value in the set
function AutoBarItemList:GetSetTable(set)
	local setTable, cacheSet;
	if type(set) == "string" then
		local rset = PT:GetSet(set);
		if rset and type(rset) == "string" then
			setTable = PT:GetSetTable(set);
		elseif type(rset) == "table" then
			setTable = {};
			for _, s in pairs(rset) do
				cacheSet = self:GetSetTable(s);
				for itemId, value in pairs(cacheSet) do
					setTable[itemId] = value;
				end
			end
		end
	elseif type(set) == "table" then
		setTable = {};
		for _, s in pairs(set) do
			cacheSet = self:GetSetTable(s);
			for itemId, value in pairs(cacheSet) do
				setTable[itemId] = value;
			end
		end
	end

	return setTable;
end


-- Get set as a simple array of itemIds, ordered by their value in the set
function AutoBarItemList:GetSetItemsArray(set)
	local itemArray = {};
	local cacheSet = self:GetSetTable(set);
	if (cacheSet) then
		local sortedList = {};
		local index = 1;
		for itemId, value in pairs(cacheSet) do
			sortedList[index] = { itemId, value };
			index = index + 1;
		end
		table.sort(sortedList, sortList);
		for i, j in ipairs(sortedList) do
			itemArray[i] = j[1];
		end
	end
	return itemArray;
end


function AutoBarItemList:OnInitialize()
	-- Ok, step 1 is to start getting the raw data from PeriodicTable.  Later we can use more of its functionality.
	AutoBar_Category_Info["ANTI_VENOM"]["items"] = self:GetSetItemsArray("antivenom");
	AutoBar_Category_Info["ARROWS"]["items"] = self:GetSetItemsArray("ammoarrows");
	AutoBar_Category_Info["BULLETS"]["items"] = self:GetSetItemsArray("ammobullets");
	AutoBar_Category_Info["THROWN"]["items"] = self:GetSetItemsArray("ammothrown");
	AutoBar_Category_Info["BANDAGES"]["items"] = self:GetSetItemsArray("bandagesgeneral");
	AutoBar_Category_Info["ALTERAC_BANDAGES"]["items"] = self:GetSetItemsArray("bandagesalterac");
	AutoBar_Category_Info["ARATHI_BANDAGES"]["items"] = self:GetSetItemsArray("bandagesarathi");
	AutoBar_Category_Info["WARSONG_BANDAGES"]["items"] = self:GetSetItemsArray("bandageswarsong");
	AutoBar_Category_Info["EXPLOSIVES"]["items"] = self:GetSetItemsArray("explosives");
	AutoBar_Category_Info["FISHING_LURES"]["items"] = self:GetSetItemsArray("fishinglures");
	AutoBar_Category_Info["FISHING_GEAR"]["items"] = self:GetSetItemsArray("fishinggear");
	AutoBar_Category_Info["FISHING_POLES"]["items"] = self:GetSetItemsArray("fishingpoles");
	AutoBar_Category_Info["FOOD"]["items"] = self:GetSetItemsArray("foodregular");
	AutoBar_Category_Info["FOOD_ARATHI"]["items"] = self:GetSetItemsArray("foodarathi");
	AutoBar_Category_Info["FOOD_WARSONG"]["items"] = self:GetSetItemsArray("foodwarsong");
	AutoBar_Category_Info["FOOD_COMBO"]["items"] = self:GetSetItemsArray("foodcombohealth");
	AutoBar_Category_Info["FOOD_CONJURED"]["items"] = self:GetSetItemsArray("foodbreadconjured");
	AutoBar_Category_Info["FOOD_PERCENT"]["items"] = self:GetSetItemsArray("foodperc");
	AutoBar_Category_Info["FOOD_PERCENT_BONUS"]["items"] = self:GetSetItemsArray("foodpercbonus");
	AutoBar_Category_Info["FOOD_PERCENT_COMBO"]["items"] = self:GetSetItemsArray("foodcomboperc");
	AutoBar_Category_Info["FOOD_PET_BREAD"]["items"] = self:GetSetItemsArray("foodclassbread");
	AutoBar_Category_Info["FOOD_PET_CHEESE"]["items"] = self:GetSetItemsArray("foodcheese");
	AutoBar_Category_Info["FOOD_PET_FISH"]["items"] = self:GetSetItemsArray("foodclassfish");
	AutoBar_Category_Info["FOOD_PET_FRUIT"]["items"] = self:GetSetItemsArray("foodfruit");
	AutoBar_Category_Info["FOOD_PET_FUNGUS"]["items"] = self:GetSetItemsArray("foodfungus");	-- Now includes senjin combo ;-(
	AutoBar_Category_Info["FOOD_PET_MEAT"]["items"] = self:GetSetItemsArray("foodclassmeat");
	AutoBar_Category_Info["FOOD_WELL_FED"]["items"] = self:GetSetItemsArray("foodbonus");
	AutoBar_Category_Info["FOOD_STRENGTH"]["items"] = self:GetSetItemsArray("foodstrength");
	AutoBar_Category_Info["FOOD_AGILITY"]["items"] = self:GetSetItemsArray("foodagility");
	AutoBar_Category_Info["FOOD_STAMINA"]["items"] = self:GetSetItemsArray("foodstamina");
	AutoBar_Category_Info["FOOD_INTELLECT"]["items"] = self:GetSetItemsArray("foodintellect");
	AutoBar_Category_Info["FOOD_SPIRIT"]["items"] = self:GetSetItemsArray("foodspirit");
	AutoBar_Category_Info["FOOD_HPREGEN"]["items"] = self:GetSetItemsArray("foodregenhp");
	AutoBar_Category_Info["FOOD_MANAREGEN"]["items"] = self:GetSetItemsArray("foodregenmana");
	AutoBar_Category_Info["FOOD_OTHER"]["items"] = self:GetSetItemsArray("foodother");
	AutoBar_Category_Info["HEALPOTIONS"]["items"] = self:GetSetItemsArray("potionheal");
	AutoBar_Category_Info["ALTERAC_HEAL"]["items"] = self:GetSetItemsArray("potionhealalterac");
	AutoBar_Category_Info["HEALTHSTONE"]["items"] = self:GetSetItemsArray("healthstone");
	AutoBar_Category_Info["MINI_PET"]["items"] = self:GetSetItemsArray("minipet");
	AutoBar_Category_Info["MINI_PET_HOLIDAY"]["items"] = self:GetSetItemsArray("minipetholiday");
	AutoBar_Category_Info["MOUNTS"]["items"] = self:GetSetItemsArray("mounts");
	AutoBar_Category_Info["MOUNTS_QIRAJI"]["items"] = self:GetSetItemsArray("mountsaq");
	AutoBar_Category_Info["MANAPOTIONS"]["items"] = self:GetSetItemsArray("potionmana");
	AutoBar_Category_Info["ALTERAC_MANA"]["items"] = self:GetSetItemsArray("potionmanaalterac");
	AutoBar_Category_Info["REJUVENATION_POTIONS"]["items"] = self:GetSetItemsArray("potionrejuvenation");
	AutoBar_Category_Info["DREAMLESS_SLEEP"]["items"] = self:GetSetItemsArray("potiondreamless");
	AutoBar_Category_Info["MANASTONE"]["items"] = self:GetSetItemsArray("manastone");
	AutoBar_Category_Info["OIL_MANA"]["items"] = self:GetSetItemsArray("oilmana");
	AutoBar_Category_Info["OIL_WIZARD"]["items"] = self:GetSetItemsArray("oilwizard");
	AutoBar_Category_Info["POISON-CRIPPLING"]["items"] = self:GetSetItemsArray("poisoncrippling");
	AutoBar_Category_Info["POISON-DEADLY"]["items"] = self:GetSetItemsArray("poisondeadly");
	AutoBar_Category_Info["POISON-INSTANT"]["items"] = self:GetSetItemsArray("poisoninstant");
	AutoBar_Category_Info["POISON-MINDNUMBING"]["items"] = self:GetSetItemsArray("poisonmindnumbing");
	AutoBar_Category_Info["POISON-WOUND"]["items"] = self:GetSetItemsArray("poisonwound");
	AutoBar_Category_Info["RAGEPOTIONS"]["items"] = self:GetSetItemsArray("potionrage");
	AutoBar_Category_Info["SHARPENINGSTONES"]["items"] = self:GetSetItemsArray("sharpeningstones");
	AutoBar_Category_Info["WEIGHTSTONES"]["items"] = self:GetSetItemsArray("weightstones");
	AutoBar_Category_Info["WATER"]["items"] = self:GetSetItemsArray("water");
	AutoBar_Category_Info["WATER_CONJURED"]["items"] = self:GetSetItemsArray("waterconjured");
	AutoBar_Category_Info["WATER_PERCENT"]["items"] = self:GetSetItemsArray("waterperc");
	AutoBar_Category_Info["WATER_SPIRIT"]["items"] = self:GetSetItemsArray("waterspirit");
end


AutoBar_Category_Info = {
	["CUSTOM"] = {
		["description"] = AUTOBAR_CLASS_CUSTOM;
		["texture"] = "INV_Misc_Bandage_12",
		["custom"] = true;
		["items"] = { 19307 },
	},
	["MINI_PET"] = {
		["description"] = AUTOBAR_CLASS_MINI_PET;
		["texture"] = "Ability_Creature_Poison_05";
		["arrangeOnUse"] = true,
	},
	["MINI_PET_HOLIDAY"] = {
		["description"] = AUTOBAR_CLASS_MINI_PET_HOLIDAY;
		["texture"] = "INV_Misc_Bag_17";
		["arrangeOnUse"] = true,
	},
	["AAACLEAR"] = {
		["description"] = AUTOBAR_CLASS_CLEAR;
		["texture"] = "INV_Misc_Fork&Knife";
		["items"] = {},
	},
	["BANDAGES"] = {
		["description"] = AUTOBAR_CLASS_BANDAGES;
		["texture"] = "INV_Misc_Bandage_12";
		["targetted"] = true;
		["smarttarget"] = true;
	},
	["ALTERAC_BANDAGES"] = {
		["description"] = AUTOBAR_CLASS_ALTERAC_BANDAGE;
		["texture"] = "INV_Misc_Bandage_12";
		["targetted"] = true;
		["location"] = AUTOBAR_ALTERACVALLEY;
		["smarttarget"] = true;
	},
	["WARSONG_BANDAGES"] = {
		["description"] = AUTOBAR_CLASS_WARSONG_BANDAGE;
		["texture"] = "INV_Misc_Bandage_12";
		["targetted"] = true;
		["location"] = AUTOBAR_WARSONGGULCH;
		["smarttarget"] = true;
	},
	["ARATHI_BANDAGES"] = {
		["description"] = AUTOBAR_CLASS_ARATHI_BANDAGE;
		["texture"] = "INV_Misc_Bandage_12";
		["targetted"] = true;
		["location"] = AUTOBAR_ARATHIBASIN;
		["smarttarget"] = true;
	},
	["UNGORO_RESTORE"] = {
		["description"] = AUTOBAR_CLASS_UNGORORESTORE;
		["texture"] = "INV_Misc_Gem_Diamond_02";
		["targetted"] = true;
		["smarttarget"] = true;
		["limit"] = { ["downhp"] = { 670 } },
		["items"] = { 11562 },
	},
	["ANTI_VENOM"] = {
		["description"] = AUTOBAR_CLASS_ANTIVENOM;
		["texture"] = "INV_Drink_14";
		["targetted"] = true;
		["smarttarget"] = true;
	},
	----------------
	["POTION_AGILITY"] = {
		["texture"] = "INV_Potion_94",
		["description"] = AUTOBAR_CLASS_AGILITYPOTIONS,
		["items"] = {
			2457,	-- Elixir of Minor Agility		4		60
			3390,	-- Elixir of Lesser Agility		8		60
			8949,	-- Elixir of Agility			15		60
			9187,	-- Elixir of Greater Agility	25		60
			13452,	-- Elixir of the Mongoose		25		60 2% crit
		},
	},
	["POTION_STRENGTH"] = {
		["texture"] = "INV_Potion_61",
		["description"] = AUTOBAR_CLASS_STRENGTHPOTIONS,
		["items"] = {
			2454,	-- Elixir of Lion's Strength	4		60
			3391,	-- Elixir of Ogre's Strength	8		60
			6662,	-- Elixir of Giant Growth		8		60
			9206,	-- Elixir of Giants				25		60
			13453,	-- Elixir of Brute Force		18		60 18 sta
		},
	},
	["POTION_FORTITUDE"] = {
		["texture"] = "INV_Potion_43",
		["description"] = AUTOBAR_CLASS_FORTITUDEPOTIONS,
		["items"] = {
			2458,	-- Elixir of Minor Fortitude	27		60
			3825,	-- Elixir of Fortitude			120		60
		},
	},
	["POTION_INTELLECT"] = {
		["texture"] = "INV_Potion_10",
		["description"] = AUTOBAR_CLASS_INTELLECTPOTIONS,
		["items"] = {
			9179,	-- Elixir of Greater Intellect	25		60
			13447,	-- Elixir of the Sages			18		60 18 spi
		},
	},
	["POTION_WISDOM"] = {
		["texture"] = "INV_Potion_06",
		["description"] = AUTOBAR_CLASS_WISDOMPOTIONS,
		["items"] = {
			3383,	-- Elixir of Wisdom				6		60
		},
	},
	["POTION_DEFENSE"] = {
		["texture"] = "INV_Potion_66",
		["description"] = AUTOBAR_CLASS_DEFENSEPOTIONS,
		["items"] = {
			5997,	-- Elixir of Minor Defense		50		60
			3389,	-- Elixir of Defense			150		60
			8951,	-- Elixir of Greater Defense	250		60
			13445,	-- Elixir of Superior Defense	450		60
		},
	},
	["POTION_TROLL"] = {
		["texture"] = "INV_Potion_80",
		["description"] = AUTOBAR_CLASS_TROLLBLOODPOTIONS,
		["items"] = {
			3382,	-- Weak Troll's Blood Potion	2/5		60
			3388,	-- Strong Troll's Blood Potion	6/5		60
			3826,	-- Mighty Troll's Blood Potion	12/5	60
			20004,	-- Major Troll's Blood Potion	20/5	60
		},
	},
	----------------
	["SCROLL_AGILITY"] = {
		["texture"] = "INV_Scroll_02",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFAGILITY,
		["items"] = {
			3012,	-- Scroll of Agility
			1477,	-- Scroll of Agility II
			4425,	-- Scroll of Agility III
			10309,	-- Scroll of Agility IV
		},
	},
	["SCROLL_INTELLECT"] = {
		["texture"] = "INV_Scroll_01",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFINTELLECT,
		["items"] = {
			955,	-- Scroll of Intellect
			2290,	-- Scroll of Intellect II
			4419,	-- Scroll of Intellect III
			10308,	-- Scroll of Intellect IV
			12458,	-- Juju Guile				40
		},
	},
	["SCROLL_PROTECTION"] = {
		["texture"] = "INV_Scroll_07",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFPROTECTION,
		["items"] = {
			3013,	-- Scroll of Protection
			1478,	-- Scroll of Protection II
			4421,	-- Scroll of Protection III
			10305,	-- Scroll of Protection IV
		},
	},
	["SCROLL_SPIRIT"] = {
		["texture"] = "INV_Scroll_01",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFSPIRIT,
		["items"] = {
			1181,	-- Scroll of Spirit
			1712,	-- Scroll of Spirit II
			4424,	-- Scroll of Spirit III
			10306,	-- Scroll of Spirit IV
		},
	},
	["SCROLL_STAMINA"] = {
		["texture"] = "INV_Scroll_07",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFSTAMINA,
		["items"] = {
			1180,	-- Scroll of Stamina
			1711,	-- Scroll of Stamina II
			4422,	-- Scroll of Stamina III
			10307,	-- Scroll of Stamina IV
		},
	},
	["SCROLL_STRENGTH"] = {
		["texture"] = "INV_Scroll_02",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_SCROLLOFSTRENGTH,
		["items"] = {
			954,	-- Scroll of Strength		5
			2289,	-- Scroll of Strength II	9
			4426,	-- Scroll of Strength III	13
			10310,	-- Scroll of Strength IV	17
			12451,	-- Juju Power				30
		},
	},
	["BUFF_ATTACKPOWER"] = {
		["texture"] = "INV_Misc_MonsterScales_07",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_BUFF_ATTACKPOWER,
		["items"] = {
			12820,	-- Winterfall Firewater		35	20m
			12460,	-- Juju Might				40	30m
		},
	},
	["BUFF_ATTACKSPEED"] = {
		["texture"] = "INV_Misc_MonsterScales_17",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_BUFF_ATTACKSPEED,
		["items"] = {
			12450,	-- Juju Flurry				3%	20s
		},
	},
	["BUFF_DODGE"] = {
		["texture"] = "INV_Misc_MonsterScales_17",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_BUFF_DODGE,
		["items"] = {
			12459,	-- Juju Escape				5%	10s
		},
	},
	["BUFF_FROST"] = {
		["texture"] = "INV_Misc_MonsterScales_09",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_BUFF_FROST,
		["items"] = {
			12457,	-- Juju Chill				15	10m
		},
	},
	["BUFF_FIRE"] = {
		["texture"] = "INV_Misc_MonsterScales_15",
		["targetted"] = true,
		["description"] = AUTOBAR_CLASS_BUFF_FIRE,
		["items"] = {
			12455,	-- Juju Ember				15	10m
		},
	},
	----------------
	["FISHING_LURES"] = {
		["texture"] = "INV_Misc_Food_26",
		["targetted"] = "WEAPON",
		["description"] = L["FISHING_LURES"],
	},
	["FISHING_GEAR"] = {
		["texture"] = "INV_Helmet_31",
		["description"] = L["FISHING_GEAR"],
	},
	["FISHING_POLES"] = {
		["texture"] = "INV_Fishingpole_01",
		["description"] = L["FISHING_POLES"],
	},
	----------------
	["HEALPOTIONS"] = {
		["description"] = AUTOBAR_CLASS_HEALPOTIONS;
		["texture"] = "INV_Potion_54";
		["limit"] = { ["downhp"] = { 70, 140, 140, 280, 455, 700, 800, 1050} },
	},
	["HEALTHSTONE"] = {
		["description"] = AUTOBAR_CLASS_HEALTHSTONE;
		["texture"] = "INV_Stone_04";
	},
	["WHIPPER_ROOT"] = {
		["description"] = AUTOBAR_CLASS_WHIPPER_ROOT;
		["texture"] = "INV_Misc_Food_55";
		["items"] = { 11951 },
		["limit"] = { ["downhp"] = { 700 } },
	},
	["ALTERAC_HEAL"] = {
		["description"] = AUTOBAR_CLASS_BATTLEGROUNDHEALPOTIONS;
		["texture"] = "INV_Potion_39";
		["battleground"] = true;
	},
	----------------
	["MANAPOTIONS"] = {
		["description"] = AUTOBAR_CLASS_MANAPOTIONS;
		["texture"] = "INV_Potion_76";
		["limit"] = { ["downmana"] = { 140, 280, 455, 700, 900, 900, 1350} },
	},
	["MANASTONE"] = {
		["description"] = AUTOBAR_CLASS_MANASTONE;
		["texture"] = "INV_Misc_Gem_Emerald_01";
	},
	["ALTERAC_MANA"] = {
		["description"] = AUTOBAR_CLASS_BATTLEGROUNDMANAPOTIONS;
		["texture"] = "INV_Potion_81";
		["battleground"] = true;
	},
	["DREAMLESS_SLEEP"] = {
		["description"] = AUTOBAR_CLASS_DREAMLESS_SLEEP;
		["texture"] = "INV_Potion_83";
	},
	----------------
	["NIGHT_DRAGONS_BREATH"] = {
		["description"] = AUTOBAR_CLASS_NIGHT_DRAGONS_BREATH;
		["texture"] = "INV_Misc_Food_45";
		["limit"] = { ["downhp"] = { 456 }, ["downmana"] = { 456 }, },
		["items"] = { 11952 },
	},
	["REJUVENATION_POTIONS"] = {
		["description"] = AUTOBAR_CLASS_REJUVENATION_POTIONS;
		["texture"] = "INV_Potion_47";
		["limit"] = { ["downhp"] = { 150, 750, 1760 }, ["downmana"] = { 150, 750, 1760 }, },
	},
	----------------
	["BATTLE_STANDARD"] = {
		["description"] = AUTOBAR_CLASS_BATTLESTANDARD;
		["texture"] = "INV_BannerPVP_01";
		["battleground"] = true;
		["items"] = {
			18606,	-- Alliance Battle Standard
			18607,	-- Horde Battle Standard
		},
	},
	["BATTLE_STANDARD_AV"] = {
		["description"] = AUTOBAR_CLASS_BATTLESTANDARDAV;
		["texture"] = "INV_BannerPVP_02";
		["location"] = AUTOBAR_ALTERACVALLEY;
		["items"] = {
			19045,	-- Stormpike Battle Standard
			19046,	-- Frostwolf Battle Standard
		},
	},
	["HOURGLASS_SAND"] = {
		["description"] = AUTOBAR_CLASS_BATTLESTANDARDAV;
		["texture"] = "INV_BannerPVP_02";
		["location"] = AUTOBAR_BWL;
		["items"] = {
			19183,	-- Hourglass Sand
		},
	},
	["QUEST_ITEMS"] = {
		["description"] = AUTOBAR_CLASS_QUEST_ITEMS;
		["texture"] = "INV_BannerPVP_02";
		["arrangeOnUse"] = true;
		["items"] = {
			13892,	-- Kodo Kombobulator
			9466,	-- Orwin's Spade
			10699,	-- Bramble
			9618,	-- Muisek
			9619,	-- Muisek
			9620,	-- Muisek
			9621,	-- Muisek
			9606,	-- Muisek
			19036,	-- Final Message
			8584,	-- Dowsing
			9978,
			10687,
			10688,
			10689,
			10690,
			9437,
			9439,
			9442,
			12288,
			12566,
			11132,
			12922,
			12565,
			12906,
			11141,
			12472,
			12807,
			12815,
			11522,
			15454,

			11020,
		},
	},
	----------------
	["RUNES"] = {
		["description"] = AUTOBAR_CLASS_DEMONIC_DARK_RUNES;
		["texture"] = "Spell_Shadow_SealOfKings";
		["limit"] = { ["downmana"] = { 900, 900 }, },
		["items"] = {
			20520,	-- Dark Rune
			12662,	-- Demonic Rune
		},
	},
	----------------
	["PROTECTION_ARCANE"] = {
		["description"] = AUTOBAR_CLASS_ARCANE_PROTECTION;
		["texture"] = "INV_Potion_83";
		["items"] = { 13461 },
	},
	["PROTECTION_FIRE"] = {
		["description"] = AUTOBAR_CLASS_FIRE_PROTECTION;
		["texture"] = "INV_Potion_24";
		["items"] = { 6049, 13457 },
	},
	["PROTECTION_FROST"] = {
		["description"] = AUTOBAR_CLASS_FROST_PROTECTION;
		["texture"] = "INV_Potion_20";
		["items"] = { 6050, 13456 },
	},
	["PROTECTION_NATURE"] = {
		["description"] = AUTOBAR_CLASS_NATURE_PROTECTION;
		["texture"] = "INV_Potion_22";
		["items"] = { 6052, 13458 },
	},
	["PROTECTION_SHADOW"] = {
		["description"] = AUTOBAR_CLASS_SHADOW_PROTECTION;
		["texture"] = "INV_Potion_23";
		["items"] = { 6048, 13459 },
	},
	["PROTECTION_SPELLS"] = {
		["description"] = AUTOBAR_CLASS_SPELL_PROTECTION;
		["texture"] = "INV_Potion_29";
		["items"] = {
			20080	-- Sheen of Zanza
		},
	},
	["PROTECTION_HOLY"] = {
		["description"] = AUTOBAR_CLASS_HOLY_PROTECTION;
		["texture"] = "INV_Potion_09";
		["items"] = { 6051 },
		["noncombat"] = false,
	},
	["PROTECTION_DAMAGE"] = {
		["description"] = AUTOBAR_CLASS_INVULNERABILITY_POTIONS;
		["texture"] = "INV_Potion_62";
		["items"] = { 3387 },
		["noncombat"] = false,
	},
	["ACTION_POTIONS"] = {
		["description"] = AUTOBAR_CLASS_FREE_ACTION_POTION;
		["texture"] = "INV_Potion_04";
		["items"] = {
			20008,		-- Living Action Potion
			5634,		-- Free Action Potion
		},
	},
	----------------
	["HEARTHSTONE"] = {
		["description"] = AUTOBAR_CLASS_HEARTHSTONE;
		["texture"] = "INV_Misc_Rune_01";
		["items"] = {
			6948,			-- HearthStone
		},
	},
	----------------
	["WATER"] = {
		["description"] = AUTOBAR_CLASS_WATER;
		["texture"] = "INV_Drink_10";
		["noncombat"] = true,
	},
	["WATER_PERCENT"] = {
		["description"] = AUTOBAR_CLASS_WATER_PERCENT;
		["texture"] = "INV_Drink_04";
		["noncombat"] = true,
	},
	["WATER_CONJURED"] = {
		["description"] = AUTOBAR_CLASS_WATER_CONJURED;
		["texture"] = "INV_Drink_18";
		["noncombat"] = true,
	},
	["WATER_SPIRIT"] = {
		["description"] = AUTOBAR_CLASS_WATER_SPIRIT;
		["texture"] = "INV_Drink_16";
		["noncombat"] = true,
	},
	["RAGEPOTIONS"] = {
		["description"] = AUTOBAR_CLASS_RAGEPOTIONS;
		["texture"] = "INV_Potion_24";
	},
	["ENERGYPOTIONS"] = {
		["description"] = AUTOBAR_CLASS_ENERGYPOTIONS;
		["texture"] = "INV_Drink_Milk_05";
		["items"] = { 7676 },
	},
	["SWIFTNESSPOTIONS"] = {
		["description"] = AUTOBAR_CLASS_SWIFTNESSPOTIONS;
		["texture"] = "INV_Potion_95";
		["items"] = { 20081, 2459, },
	},
	["SOULSHARDS"] = {
		["description"] = AUTOBAR_CLASS_SOULSHARDS;
		["texture"] = "INV_Misc_Gem_Amethyst_02";
		["notusable"] = true;
		["items"] = { 6265 },
	},
	--------------
	["ARROWS"] = {
		["description"] = AUTOBAR_CLASS_ARROWS;
		["texture"] = "INV_Ammo_Arrow_02";
		["notusable"] = true;
	},
	["BULLETS"] = {
		["description"] = AUTOBAR_CLASS_BULLETS;
		["texture"] = "INV_Ammo_Bullet_02";
		["notusable"] = true;
	},
	["THROWN"] = {
		["description"] = AUTOBAR_CLASS_THROWNWEAPON;
		["texture"] = "INV_Axe_19";
		["notusable"] = true;
	},
	--------------
	["FOOD"] = {
		["description"] = AUTOBAR_CLASS_FOOD;
		["texture"] = "INV_Misc_Food_23";
		["noncombat"] = true,
	},
	["FOOD_PERCENT"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PERCENT;
		["texture"] = "INV_Misc_Food_60",
		["custom"] = true;
	},
	["FOOD_PERCENT_BONUS"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PERCENT_BONUS;
		["texture"] = "INV_Misc_Food_62",
		["custom"] = true;
	},
	["FOOD_PERCENT_COMBO"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PERCENT_COMBO;
		["texture"] = "INV_Food_ChristmasFruitCake_01",
		["custom"] = true;
	},
	["FOOD_PET_BREAD"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_BREAD;
		["texture"] = "INV_Misc_Food_35";
		["noncombat"] = true,
	},
	["FOOD_PET_CHEESE"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_CHEESE;
		["texture"] = "INV_Misc_Food_37";
		["noncombat"] = true,
	},
	["FOOD_PET_FISH"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_FISH;
		["texture"] = "INV_Misc_Fish_22";
		["noncombat"] = true,
	},
	["FOOD_PET_FRUIT"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_FRUIT;
		["texture"] = "INV_Misc_Food_19";
		["noncombat"] = true,
	},
	["FOOD_PET_FUNGUS"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_FUNGUS;
		["texture"] = "INV_Mushroom_05";
		["noncombat"] = true,
	},
	["FOOD_PET_MEAT"] = {
		["description"] = AUTOBAR_CLASS_FOOD_PET_MEAT;
		["texture"] = "INV_Misc_Food_14";
		["noncombat"] = true,
	},
	["FOOD_COMBO"] = {
		["description"] = AUTOBAR_CLASS_FOOD_COMBO;
		["texture"] = "INV_Misc_Food_33";
		["noncombat"] = true,
	},
	["FOOD_CONJURED"] = {
		["description"] = AUTOBAR_CLASS_FOOD_CONJURED;
		["texture"] = "INV_Misc_Food_73CinnamonRoll";
		["noncombat"] = true,
	},
	["FOOD_WELL_FED"] = {
		["description"] = L["FOOD_WELL_FED"];
		["texture"] = "INV_Misc_Food_47";
		["noncombat"] = true,
	},
	["FOOD_STRENGTH"] = {
		["description"] = L["FOOD_STRENGTH"];
		["texture"] = "INV_Misc_Food_41";
		["noncombat"] = true,
	},
	["FOOD_AGILITY"] = {
		["description"] = L["FOOD_AGILITY"];
		["texture"] = "INV_Misc_Fish_13";
		["noncombat"] = true,
	},
	["FOOD_STAMINA"] = {
		["description"] = L["FOOD_STAMINA"];
		["texture"] = "INV_Misc_Food_65";
		["noncombat"] = true,
	},
	["FOOD_INTELLECT"] = {
		["description"] = L["FOOD_INTELLECT"];
		["texture"] = "INV_Misc_Food_63";
		["noncombat"] = true,
	},
	["FOOD_SPIRIT"] = {
		["description"] = L["FOOD_SPIRIT"];
		["texture"] = "INV_Misc_Fish_03";
		["noncombat"] = true,
	},
	["FOOD_HPREGEN"] = {
		["description"] = L["FOOD_HPREGEN"];
		["texture"] = "INV_Misc_Fish_19";
		["noncombat"] = true,
	},
	["FOOD_MANAREGEN"] = {
		["description"] = L["FOOD_MANAREGEN"];
		["texture"] = "INV_Drink_17";
		["noncombat"] = true,
	},
	["FOOD_OTHER"] = {
		["description"] = L["FOOD_OTHER"];
		["texture"] = "INV_Drink_17";
		["noncombat"] = true,
	},
	["FOOD_ARATHI"] = {
		["description"] = AUTOBAR_CLASS_FOOD_ARATHI;
		["texture"] = "INV_Misc_Food_33";
		["noncombat"] = true,
		["location"] = AUTOBAR_ARATHIBASIN;
	},
	["FOOD_WARSONG"] = {
		["description"] = AUTOBAR_CLASS_FOOD_WARSONG;
		["texture"] = "INV_Misc_Food_33";
		["noncombat"] = true,
		["location"] = AUTOBAR_WARSONGGULCH;
	},
	--------------
	["SHARPENINGSTONES"] = {
		["description"] = AUTOBAR_CLASS_SHARPENINGSTONES;
		["texture"] = "INV_Stone_SharpeningStone_01";
		["targetted"] = "WEAPON";
	},
	["WEIGHTSTONES"] = {
		["description"] = AUTOBAR_CLASS_WEIGHTSTONE;
		["texture"] = "INV_Stone_WeightStone_02";
		["targetted"] = "WEAPON";
	},
	--------------
	["POISON-CRIPPLING"] = {
		["description"] = AUTOBAR_CLASS_POISON_CRIPPLING;
		["texture"] = "INV_Potion_19";
		["targetted"] = "WEAPON";
	},
	["POISON-DEADLY"] = {
		["description"] = AUTOBAR_CLASS_POISON_DEADLY;
		["texture"] = "Ability_Rogue_DualWeild";
		["targetted"] = "WEAPON";
	},
	["POISON-INSTANT"] = {
		["description"] = AUTOBAR_CLASS_POISON_INSTANT;
		["texture"] = "Ability_Poisons";
		["targetted"] = "WEAPON";
	},
	["POISON-MINDNUMBING"] = {
		["description"] = AUTOBAR_CLASS_POISON_MINDNUMBING;
		["texture"] = "Spell_Nature_NullifyDisease";
		["targetted"] = "WEAPON";
	},
	["POISON-WOUND"] = {
		["description"] = AUTOBAR_CLASS_POISON_WOUND;
		["texture"] = "Ability_PoisonSting";
		["targetted"] = "WEAPON";
	},
	--------------
	["EXPLOSIVES"] = {
		["description"] = AUTOBAR_CLASS_EXPLOSIVES;
		["texture"] = "INV_Misc_Bomb_08";
		["nosmartcast"] = true;
		["targetted"] = true;
	},
	--------------
	["MOUNTS"] = {
		["description"] = AUTOBAR_CLASS_MOUNTS;
		["texture"] = "Ability_Mount_JungleTiger";
		["noncombat"] = true,
		["arrangeOnUse"] = true,
	},
	["MOUNTS_QIRAJI"] = {
		["description"] = AUTOBAR_CLASS_MOUNTS_QIRAJI;
		["texture"] = "INV_Misc_QirajiCrystal_05";
		["noncombat"] = true,
		["arrangeOnUse"] = true,
		["location"] = AUTOBAR_AHN_QIRAJ;
	},
	--------------
	["OIL_MANA"] = {
		["texture"] = "INV_Potion_100";
		["targetted"] = "WEAPON";
		["description"] = AUTOBAR_CLASS_MANA_OIL;
	},
	["OIL_WIZARD"] = {
		["texture"] = "INV_Potion_105";
		["targetted"] = "WEAPON";
		["description"] = AUTOBAR_CLASS_WIZARD_OIL;
	},
};

