--[[
Name: Babble-Spell-2.2
Revision: $Rev: 20793 $
Author(s): ckknight (ckknight@gmail.com)
Website: http://ckknight.wowinterface.com/
Documentation: http://wiki.wowace.com/index.php/Babble-Spell-2.2
SVN: http://svn.wowace.com/root/trunk/Babble-2.2/Babble-Spell-2.2
Description: A library to provide localizations for spells.
Dependencies: AceLibrary, AceLocale-2.2
]]

local MAJOR_VERSION = "Babble-Spell-2.2"
local MINOR_VERSION = tonumber(string.sub("$Revision: 20793 $", 12, -3))

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end

local _, x = AceLibrary("AceLocale-2.2"):GetLibraryVersion()
MINOR_VERSION = MINOR_VERSION * 100000 + x

if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local BabbleSpell = AceLibrary("AceLocale-2.2"):new(MAJOR_VERSION)

-- uncomment below for debug information
-- BabbleSpell:EnableDebugging()

BabbleSpell:RegisterTranslations("enUS", function()
	return {
		["Abolish Disease"] = true,
		["Abolish Poison Effect"] = true,
		["Abolish Poison"] = true,
		["Activate MG Turret"] = true,
		["Adrenaline Rush"] = true,
		["Aftermath"] = true,
		["Aggression"] = true,
		["Aimed Shot"] = true,
		["Alchemy"] = true,
		["Ambush"] = true,
		["Amplify Curse"] = true,
		["Amplify Magic"] = true,
		["Ancestral Fortitude"] = true,
		["Ancestral Healing"] = true,
		["Ancestral Knowledge"] = true,
		["Ancestral Spirit"] = true,
		["Anesthetic Poison"] = true,
		["Anger Management"] = true,
		["Anguish"] = true,
		["Anticipation"] = true,
		["Aquatic Form"] = true,
		["Arcane Blast"] = true,
		["Arcane Brilliance"] = true,
		["Arcane Concentration"] = true,
		["Arcane Explosion"] = true,
		["Arcane Focus"] = true,
		["Arcane Instability"] = true,
		["Arcane Intellect"] = true,
		["Arcane Meditation"] = true,
		["Arcane Mind"] = true,
		["Arcane Missiles"] = true,
		["Arcane Power"] = true,
		["Arcane Resistance"] = true,
		["Arcane Shot"] = true,
		["Arcane Subtlety"] = true,
		["Arctic Reach"] = true,
		["Armorsmith"] = true,
		["Armor of Faith"] = true,
		["Aspect of the Beast"] = true,
		["Aspect of the Cheetah"] = true,
		["Aspect of the Hawk"] = true,
		["Aspect of the Monkey"] = true,
		["Aspect of the Pack"] = true,
		["Aspect of the Viper"] = true,
		["Aspect of the Wild"] = true,
		["Astral Recall"] = true,
		["Attack"] = true,
		["Attacking"] = true,
		["Auto Shot"] = true,
		["Avenger's Shield"] = true,
		["Avenging Wrath"] = true,
		["Avoidance"] = true,
		["Axe Specialization"] = true,
		["Backlash"] = true,
		["Backstab"] = true,
		["Bane"] = true,
		["Banish"] = true,
		["Barkskin Effect"] = true,
		["Barkskin"] = true,
		["Barrage"] = true,
		["Bash"] = true,
		["Basic Campfire"] = true,
		["Battle Shout"] = true,
		["Battle Stance Passive"] = true,
		["Battle Stance"] = true,
		["Bear Form"] = true,
		["Beast Lore"] = true,
		["Beast Slaying"] = true,
		["Beast Training"] = true,
		["Benediction"] = true,
		["Berserker Rage"] = true,
		["Berserker Stance Passive"] = true,
		["Berserker Stance"] = true,
		["Berserking"] = true,
		["Bestial Discipline"] = true,
		["Bestial Swiftness"] = true,
		["Bestial Wrath"] = true,
		["Binding Heal"] = true,
		["Bite"] = true,
		["Black Arrow"] = true,
		["Blackout"] = true,
		["Blacksmithing"] = true,
		["Blade Flurry"] = true,
		["Blast Wave"] = true,
		["Blazing Speed"] = true,
		["Blessed Recovery"] = true,
		["Blessing of Freedom"] = true,
		["Blessing of Kings"] = true,
		["Blessing of Light"] = true,
		["Blessing of Might"] = true,
		["Blessing of Protection"] = true,
		["Blessing of Sacrifice"] = true,
		["Blessing of Salvation"] = true,
		["Blessing of Sanctuary"] = true,
		["Blessing of Wisdom"] = true,
		["Blind"] = true,
		["Blinding Powder"] = true,
		["Blink"] = true,
		["Blizzard"] = true,
		["Block"] = true,
		["Blood Craze"] = true,
		["Blood Frenzy"] = true,
		["Blood Fury"] = true,
		["Blood Pact"] = true,
		["Bloodlust"] = true,
		["Bloodrage"] = true,
		["Bloodthirst"] = true,
		["Booming Voice"] = true,
		["Bow Specialization"] = true,
		["Bows"] = true,
		["Bright Campfire"] = true,
		["Brutal Impact"] = true,
		["Burning Soul"] = true,
		["Call Pet"] = true,
		["Call of Flame"] = true,
		["Call of Thunder"] = true,
		["Camouflage"] = true,
		["Cannibalize"] = true,
		["Cat Form"] = true,
		["Cataclysm"] = true,
		["Chain Heal"] = true,
		["Chain Lightning"] = true,
		["Challenging Roar"] = true,
		["Challenging Shout"] = true,
		["Charge Rage Bonus Effect"] = true,
		["Charge"] = true,
		["Charge Stun"] = true,
		["Cheap Shot"] = true,
		["Chilled"] = true,
		["Circle of Healing"] = true,
		["Claw"] = true,
		["Cleanse"] = true,
		["Clearcasting"] = true,
		["Cleave"] = true,
		["Clever Traps"] = true,
		["Cloak of Shadows"] = true,
		["Closing"] = true,
		["Cloth"] = true,
		["Coarse Sharpening Stone"] = true,
		["Cobra Reflexes"] = true,
		["Cold Blood"] = true,
		["Cold Snap"] = true,
		["Combat Endurance"] = true,
		["Combustion"] = true,
		["Command"] = true,
		["Commanding Shout"] = true,
		["Concentration Aura"] = true,
		["Concussion Blow"] = true,
		["Concussion"] = true,
		["Concussive Shot"] = true,
		["Cone of Cold"] = true,
		["Conflagrate"] = true,
		["Conjure Food"] = true,
		["Conjure Mana Agate"] = true,
		["Conjure Mana Citrine"] = true,
		["Conjure Mana Jade"] = true,
		["Conjure Mana Ruby"] = true,
		["Conjure Water"] = true,
		["Consecrated Sharpening Stone"] = true,
		["Consecration"] = true,
		["Consume Magic"] = true,
		["Consume Shadows"] = true,
		["Convection"] = true,
		["Conviction"] = true,
		["Cooking"] = true,
		["Corruption"] = true,
		["Counterattack"] = true,
		["Counterspell"] = true,
		["Counterspell - Silenced"] = true,
		["Cower"] = true,
		["Create Firestone"] = true,
		["Create Firestone (Major)"] = true,
		["Create Firestone (Greater)"] = true,
		["Create Firestone (Lesser)"] = true,
		["Create Healthstone"] = true,
		["Create Healthstone (Major)"] = true,
		["Create Healthstone (Greater)"] = true,
		["Create Healthstone (Lesser)"] = true,
		["Create Healthstone (Minor)"] = true,
		["Create Soulstone"] = true,
		["Create Soulstone (Major)"] = true,
		["Create Soulstone (Greater)"] = true,
		["Create Soulstone (Lesser)"] = true,
		["Create Soulstone (Minor)"] = true,
		["Create Spellstone"] = true,
		["Create Spellstone (Master)"] = true,
		["Create Spellstone (Major)"] = true,
		["Create Spellstone (Greater)"] = true,
		["Crippling Poison II"] = true,
		["Crippling Poison"] = true,
		["Critical Mass"] = true,
		["Crossbows"] = true,
		["Cruelty"] = true,
		["Crusader Aura"] = true,
		["Crusader Strike"] = true,
		["Cultivation"] = true,
		["Cure Disease"] = true,
		["Cure Poison"] = true,
		["Curse of Agony"] = true,
		["Curse of Doom Effect"] = true,
		["Curse of Doom"] = true,
		["Curse of Exhaustion"] = true,
		["Curse of Idiocy"] = true,
		["Curse of Recklessness"] = true,
		["Curse of Shadow"] = true,
		["Curse of Tongues"] = true,
		["Curse of Weakness"] = true,
		["Curse of the Elements"] = true,
		["Cyclone"] = true,
		["Dagger Specialization"] = true,
		["Daggers"] = true,
		["Dampen Magic"] = true,
		["Dark Pact"] = true,
		["Darkness"] = true,
		["Dash"] = true,
		["Deadly Poison II"] = true,
		["Deadly Poison III"] = true,
		["Deadly Poison IV"] = true,
		["Deadly Poison V"] = true,
		["Deadly Poison"] = true,
		["Deadly Throw"] = true,
		["Death Coil"] = true,
		["Death Wish"] = true,
		["Deep Wounds"] = true,
		["Defense"] = true,
		["Defensive Stance Passive"] = true,
		["Defensive Stance"] = true,
		["Defensive State 2"] = true,
		["Defensive State"] = true,
		["Defiance"] = true,
		["Deflection"] = true,
		["Demon Armor"] = true,
		["Demon Skin"] = true,
		["Demonic Embrace"] = true,
		["Demonic Frenzy"] = true,
		["Demonic Sacrifice"] = true,
		["Demoralizing Roar"] = true,
		["Demoralizing Shout"] = true,
		["Dense Sharpening Stone"] = true,
		["Desperate Prayer"] = true,
		["Destructive Reach"] = true,
		["Detect Greater Invisibility"] = true,
		["Detect Invisibility"] = true,
		["Detect Lesser Invisibility"] = true,
		["Detect Magic"] = true,
		["Detect Traps"] = true,
		["Detect"] = true,
		["Deterrence"] = true,
		["Devastate"] = true,
		["Devastation"] = true,
		["Devotion Aura"] = true,
		["Devour Magic Effect"] = true,
		["Devour Magic"] = true,
		["Devouring Plague"] = true,
		["Diplomacy"] = true,
		["Dire Bear Form"] = true,
		["Disarm Trap"] = true,
		["Disarm"] = true,
		["Disease Cleansing Totem"] = true,
		["Disenchant"] = true,
		["Disengage"] = true,
		["Dismiss Pet"] = true,
		["Dispel Magic"] = true,
		["Distract"] = true,
		["Distracting Shot"] = true,
		["Dive"] = true,
		["Divine Favor"] = true,
		["Divine Fury"] = true,
		["Divine Illumination"] = true,
		["Divine Intellect"] = true,
		["Divine Intervention"] = true,
		["Divine Protection"] = true,
		["Divine Shield"] = true,
		["Divine Spirit"] = true,
		["Divine Strength"] = true,
		["Dodge"] = true,
		["Dragon's Breath"] = true,
		["Dragonscale Leatherworking"] = true,
		["Drain Life"] = true,
		["Drain Mana"] = true,
		["Drain Soul"] = true,
		["Drink"] = true,
		["Dual Wield Specialization"] = true,
		["Dual Wield"] = true,
		["Duel"] = true,
		["Eagle Eye"] = true,
		["Earth Elemental Totem"] = true,
		["Earth Shield"] = true,
		["Earth Shock"] = true,
		["Earthbind Totem"] = true,
		["Efficiency"] = true,
		["Elemental Focus"] = true,
		["Elemental Fury"] = true,
		["Elemental Leatherworking"] = true,
		["Elemental Mastery"] = true,
		["Elemental Sharpening Stone"] = true,
		["Elune's Grace"] = true,
		["Elusiveness"] = true,
		["Emberstorm"] = true,
		["Enamored Water Spirit"] = true,
		["Enchanting"] = true,
		["Endurance Training"] = true,
		["Endurance"] = true,
		["Engineering Specialization"] = true,
		["Engineering"] = true,
		["Enrage"] = true,
		["Enriched Manna Biscuit"] = true,
		["Enslave Demon"] = true,
		["Entangling Roots"] = true,
		["Entrapment"] = true,
		["Envenom"] = true,
		["Escape Artist"] = true,
		["Evasion"] = true,
		["Eventide"] = true,
		["Eviscerate"] = true,
		["Evocation"] = true,
		["Execute"] = true,
		["Exorcism"] = true,
		["Expansive Mind"] = true,
		["Explosive Trap Effect"] = true,
		["Explosive Trap"] = true,
		["Expose Armor"] = true,
		["Eye for an Eye"] = true,
		["Eye of Kilrogg"] = true,
		["Eyes of the Beast"] = true,
		["Fade"] = true,
		["Faerie Fire"] = true,
		["Faerie Fire (Feral)"] = true,
		["Far Sight"] = true,
		["Fear Ward"] = true,
		["Fear"] = true,
		["Feed Pet"] = true,
		["Feedback"] = true,
		["Feign Death"] = true,
		["Feint"] = true,
		["Fel Armor"] = true,
		["Fel Concentration"] = true,
		["Fel Domination"] = true,
		["Fel Intellect"] = true,
		["Fel Stamina"] = true,
		["Felfire"] = true,
		["Feline Grace"] = true,
		["Feline Swiftness"] = true,
		["Feral Aggression"] = true,
		["Feral Charge"] = true,
		["Feral Instinct"] = true,
		["Ferocious Bite"] = true,
		["Ferocity"] = true,
		["Fetish"] = true,
		["Find Herbs"] = true,
		["Find Minerals"] = true,
		["Find Treasure"] = true,
		["Find Weakness"] = true,
		["Fire Blast"] = true,
		["Fire Elemental Totem"] = true,
		["Fire Nova Totem"] = true,
		["Fire Power"] = true,
		["Fire Resistance Aura"] = true,
		["Fire Resistance Totem"] = true,
		["Fire Resistance"] = true,
		["Fire Shield"] = true,
		["Fire Vulnerability"] = true,
		["Fire Ward"] = true,
		["Fireball"] = true,
		["Firebolt"] = true,
		["First Aid"] = true,
		["Fishing Poles"] = true,
		["Fishing"] = true,
		["Fist Weapon Specialization"] = true,
		["Fist Weapons"] = true,
		["Flame Shock"] = true,
		["Flame Throwing"] = true,
		["Flamestrike"] = true,
		["Flamethrower"] = true,
		["Flametongue Totem"] = true,
		["Flametongue Weapon"] = true,
		["Flare"] = true,
		["Flash Heal"] = true,
		["Flash of Light"] = true,
		["Flight Form"] = true,
		["Flurry"] = true,
		["Focused Casting"] = true,
		["Food"] = true,
		["Forbearance"] = true,
		["Force of Nature"] = true,
		["Force of Will"] = true,
		["Freezing Trap Effect"] = true,
		["Freezing Trap"] = true,
		["Frenzied Regeneration"] = true,
		["Frenzy"] = true,
		["Frost Armor"] = true,
		["Frost Channeling"] = true,
		["Frost Nova"] = true,
		["Frost Resistance Aura"] = true,
		["Frost Resistance Totem"] = true,
		["Frost Resistance"] = true,
		["Frost Shock"] = true,
		["Frost Trap"] = true,
		["Frost Trap Aura"] = true,
		["Frost Ward"] = true,
		["Frostbite"] = true,
		["Frostbolt"] = true,
		["Frostbrand Weapon"] = true,
		["Furious Howl"] = true,
		["Furor"] = true,
		["Garrote"] = true,
		["Generic"] = true,
		["Ghost Wolf"] = true,
		["Ghostly Strike"] = true,
		["Gift of Nature"] = true,
		["Gift of the Wild"] = true,
		["Gouge"] = true,
		["Grace of Air Totem"] = true,
		["Great Stamina"] = true,
		["Greater Blessing of Kings"] = true,
		["Greater Blessing of Light"] = true,
		["Greater Blessing of Might"] = true,
		["Greater Blessing of Salvation"] = true,
		["Greater Blessing of Sanctuary"] = true,
		["Greater Blessing of Wisdom"] = true,
		["Greater Heal"] = true,
		["Grim Reach"] = true,
		["Grounding Totem"] = true,
		["Grovel"] = true,
		["Growl"] = true,
		["Guardian's Favor"] = true,
		["Gun Specialization"] = true,
		["Guns"] = true,
		["Hammer of Justice"] = true,
		["Hammer of Wrath"] = true,
		["Hamstring"] = true,
		["Harass"] = true,
		["Hardiness"] = true,
		["Hawk Eye"] = true,
		["Heal"] = true,
		["Healing Focus"] = true,
		["Healing Light"] = true,
		["Healing Stream Totem"] = true,
		["Healing Touch"] = true,
		["Healing Wave"] = true,
		["Healing Way"] = true,
		["Health Funnel"] = true,
		["Heart of the Wild"] = true,
		["Heavy Sharpening Stone"] = true,
		["Hellfire Effect"] = true,
		["Hellfire"] = true,
		["Hemorrhage"] = true,
		["Herb Gathering"] = true,
		["Herbalism"] = true,
		["Heroic Strike"] = true,
		["Heroism"] = true,
		["Hex of Weakness"] = true,
		["Hibernate"] = true,
		["Holy Fire"] = true,
		["Holy Light"] = true,
		["Holy Nova"] = true,
		["Holy Power"] = true,
		["Holy Reach"] = true,
		["Holy Shield"] = true,
		["Holy Shock"] = true,
		["Holy Specialization"] = true,
		["Holy Wrath"] = true,
		["Honorless Target"] = true,
		["Horse Riding"] = true,
		["Howl of Terror"] = true,
		["Humanoid Slaying"] = true,
		["Hunter's Mark"] = true,
		["Hurricane"] = true,
		["Ice Armor"] = true,
		["Ice Barrier"] = true,
		["Ice Block"] = true,
		["Ice Lance"] = true,
		["Ice Shards"] = true,
		["Ignite"] = true,
		["Illumination"] = true,
		["Immolate"] = true,
		["Immolation Trap Effect"] = true,
		["Immolation Trap"] = true,
		["Impact"] = true,
		["Impale"] = true,
		["Improved Ambush"] = true,
		["Improved Arcane Explosion"] = true,
		["Improved Arcane Missiles"] = true,
		["Improved Arcane Shot"] = true,
		["Improved Aspect of the Hawk"] = true,
		["Improved Aspect of the Monkey"] = true,
		["Improved Backstab"] = true,
		["Improved Battle Shout"] = true,
		["Improved Berserker Rage"] = true,
		["Improved Blessing of Might"] = true,
		["Improved Blessing of Wisdom"] = true,
		["Improved Blizzard"] = true,
		["Improved Bloodrage"] = true,
		["Improved Chain Heal"] = true,
		["Improved Chain Lightning"] = true,
		["Improved Challenging Shout"] = true,
		["Improved Charge"] = true,
		["Improved Cheap Shot"] = true,
		["Improved Cleave"] = true,
		["Improved Concentration Aura"] = true,
		["Improved Concussive Shot"] = true,
		["Improved Cone of Cold"] = true,
		["Improved Corruption"] = true,
		["Improved Counterspell"] = true,
		["Improved Curse of Agony"] = true,
		["Improved Curse of Exhaustion"] = true,
		["Improved Curse of Weakness"] = true,
		["Improved Dampen Magic"] = true,
		["Improved Deadly Poison"] = true,
		["Improved Demoralizing Shout"] = true,
		["Improved Devotion Aura"] = true,
		["Improved Disarm"] = true,
		["Improved Distract"] = true,
		["Improved Drain Life"] = true,
		["Improved Drain Mana"] = true,
		["Improved Drain Soul"] = true,
		["Improved Enrage"] = true,
		["Improved Enslave Demon"] = true,
		["Improved Entangling Roots"] = true,
		["Improved Evasion"] = true,
		["Improved Eviscerate"] = true,
		["Improved Execute"] = true,
		["Improved Expose Armor"] = true,
		["Improved Eyes of the Beast"] = true,
		["Improved Fade"] = true,
		["Improved Feign Death"] = true,
		["Improved Fire Blast"] = true,
		["Improved Fire Nova Totem"] = true,
		["Improved Fire Ward"] = true,
		["Improved Fireball"] = true,
		["Improved Firebolt"] = true,
		["Improved Firestone"] = true,
		["Improved Flamestrike"] = true,
		["Improved Flametongue Weapon"] = true,
		["Improved Flash of Light"] = true,
		["Improved Frost Nova"] = true,
		["Improved Frost Ward"] = true,
		["Improved Frostbolt"] = true,
		["Improved Frostbrand Weapon"] = true,
		["Improved Garrote"] = true,
		["Improved Ghost Wolf"] = true,
		["Improved Gouge"] = true,
		["Improved Grace of Air Totem"] = true,
		["Improved Grounding Totem"] = true,
		["Improved Hammer of Justice"] = true,
		["Improved Hamstring"] = true,
		["Improved Healing Stream Totem"] = true,
		["Improved Healing Touch"] = true,
		["Improved Healing Wave"] = true,
		["Improved Healing"] = true,
		["Improved Health Funnel"] = true,
		["Improved Healthstone"] = true,
		["Improved Heroic Strike"] = true,
		["Improved Hunter's Mark"] = true,
		["Improved Immolate"] = true,
		["Improved Imp"] = true,
		["Improved Inner Fire"] = true,
		["Improved Instant Poison"] = true,
		["Improved Intercept"] = true,
		["Improved Intimidating Shout"] = true,
		["Improved Judgement"] = true,
		["Improved Kick"] = true,
		["Improved Kidney Shot"] = true,
		["Improved Lash of Pain"] = true,
		["Improved Lay on Hands"] = true,
		["Improved Lesser Healing Wave"] = true,
		["Improved Life Tap"] = true,
		["Improved Lightning Bolt"] = true,
		["Improved Lightning Shield"] = true,
		["Improved Magma Totem"] = true,
		["Improved Mana Burn"] = true,
		["Improved Mana Shield"] = true,
		["Improved Mana Spring Totem"] = true,
		["Improved Mark of the Wild"] = true,
		["Improved Mend Pet"] = true,
		["Improved Mind Blast"] = true,
		["Improved Moonfire"] = true,
		["Improved Nature's Grasp"] = true,
		["Improved Overpower"] = true,
		["Improved Power Word: Fortitude"] = true,
		["Improved Power Word: Shield"] = true,
		["Improved Prayer of Healing"] = true,
		["Improved Psychic Scream"] = true,
		["Improved Pummel"] = true,
		["Improved Regrowth"] = true,
		["Improved Reincarnation"] = true,
		["Improved Rejuvenation"] = true,
		["Improved Rend"] = true,
		["Improved Renew"] = true,
		["Improved Retribution Aura"] = true,
		["Improved Revenge"] = true,
		["Improved Revive Pet"] = true,
		["Improved Righteous Fury"] = true,
		["Improved Rockbiter Weapon"] = true,
		["Improved Rupture"] = true,
		["Improved Sap"] = true,
		["Improved Scorch"] = true,
		["Improved Scorpid Sting"] = true,
		["Improved Seal of Righteousness"] = true,
		["Improved Seal of the Crusader"] = true,
		["Improved Searing Pain"] = true,
		["Improved Searing Totem"] = true,
		["Improved Serpent Sting"] = true,
		["Improved Shadow Bolt"] = true,
		["Improved Shadow Word: Pain"] = true,
		["Improved Shield Bash"] = true,
		["Improved Shield Block"] = true,
		["Improved Shield Wall"] = true,
		["Improved Shred"] = true,
		["Improved Sinister Strike"] = true,
		["Improved Slam"] = true,
		["Improved Slice and Dice"] = true,
		["Improved Spellstone"] = true,
		["Improved Sprint"] = true,
		["Improved Starfire"] = true,
		["Improved Stoneclaw Totem"] = true,
		["Improved Stoneskin Totem"] = true,
		["Improved Strength of Earth Totem"] = true,
		["Improved Succubus"] = true,
		["Improved Sunder Armor"] = true,
		["Improved Taunt"] = true,
		["Improved Thorns"] = true,
		["Improved Thunder Clap"] = true,
		["Improved Tranquility"] = true,
		["Improved Vampiric Embrace"] = true,
		["Improved Vanish"] = true,
		["Improved Voidwalker"] = true,
		["Improved Windfury Weapon"] = true,
		["Improved Wing Clip"] = true,
		["Improved Wrath"] = true,
		["Incinerate"] = true,
		["Inferno"] = true,
		["Initiative"] = true,
		["Inner Fire"] = true,
		["Inner Focus"] = true,
		["Innervate"] = true,
		["Insect Swarm"] = true,
		["Inspiration"] = true,
		["Instant Poison II"] = true,
		["Instant Poison III"] = true,
		["Instant Poison IV"] = true,
		["Instant Poison V"] = true,
		["Instant Poison VI"] = true,
		["Instant Poison"] = true,
		["Intensity"] = true,
		["Intercept"] = true,
		["Intercept Stun"] = true,
		["Intervene"] = true,
		["Intimidating Shout"] = true,
		["Intimidation"] = true,
		["Invisibility"] = true,
		["Iron Will"] = true,
		["Jewelcrafting"] = true,
		["Judgement of Command"] = true,
		["Judgement of Justice"] = true,
		["Judgement of Light"] = true,
		["Judgement of Righteousness"] = true,
		["Judgement of Wisdom"] = true,
		["Judgement of the Crusader"] = true,
		["Judgement"] = true,
		["Kick"] = true,
		["Kick - Silenced"] = true,
		["Kidney Shot"] = true,
		["Kill Command"] = true, 
		["Killer Instinct"] = true,
		["Kodo Riding"] = true,
		["Lacerate"] = true,
		["Lash of Pain"] = true,
		["Last Stand"] = true,
		["Lasting Judgement"] = true,
		["Lay on Hands"] = true,
		["Leader of the Pack"] = true,
		["Leather"] = true,
		["Leatherworking"] = true,
		["Lesser Heal"] = true,
		["Lesser Healing Wave"] = true,
		["Lesser Invisibility"] = true,
		["Lethal Shots"] = true,
		["Lethality"] = true,
		["Levitate"] = true,
		["Libram"] = true,
		["Lifebloom"] = true,
		["Life Tap"] = true,
		["Lightning Bolt"] = true,
		["Lightning Breath"] = true,
		["Lightning Mastery"] = true,
		["Lightning Reflexes"] = true,
		["Lightning Shield"] = true,
		["Lightwell Renew"] = true,
		["Lightwell"] = true,
		["Lockpicking"] = true,
		["Long Daze"] = true,
		["Mace Specialization"] = true,
		["Mace Stun Effect"] = true,
		["Mage Armor"] = true,
		["Magma Totem"] = true,
		["Mail"] = true,
		["Maim"] = true,
		["Malice"] = true,
		["Mana Burn"] = true,
		["Mana Shield"] = true,
		["Mana Spring Totem"] = true,
		["Mana Tide Totem"] = true,
		["Mangle"] = true,
		["Mangle (Cat)"] = true,
		["Mangle (Bear)"] = true,
		["Mark of the Wild"] = true,
		["Martyrdom"] = true,
		["Mass Dispel"] = true,
		["Master Demonologist"] = true,
		["Master Summoner"] = true,
		["Master of Deception"] = true,
		["Maul"] = true,
		["Mechanostrider Piloting"] = true,
		["Meditation"] = true,
		["Melee Specialization"] = true,
		["Mend Pet"] = true,
		["Mental Agility"] = true,
		["Mental Strength"] = true,
		["Mind Blast"] = true,
		["Mind Control"] = true,
		["Mind Flay"] = true,
		["Mind Soothe"] = true,
		["Mind Vision"] = true,
		["Mind-numbing Poison II"] = true,
		["Mind-numbing Poison III"] = true,
		["Mind-numbing Poison"] = true,
		["Mining"] = true,
		["Misdirection"] = true,
		["Mocking Blow"] = true,
		["Molten Armor"] = true,
		["Mongoose Bite"] = true,
		["Monster Slaying"] = true,
		["Moonfire"] = true,
		["Moonfury"] = true,
		["Moonglow"] = true,
		["Moonkin Aura"] = true,
		["Moonkin Form"] = true,
		["Mortal Shots"] = true,
		["Mortal Strike"] = true,
		["Multi-Shot"] = true,
		["Murder"] = true,
		["Mutilate"] = true,
		["Natural Armor"] = true,
		["Natural Shapeshifter"] = true,
		["Natural Weapons"] = true,
		["Nature Resistance Totem"] = true,
		["Nature Resistance"] = true,
		["Nature's Focus"] = true,
		["Nature's Grace"] = true,
		["Nature's Grasp"] = true,
		["Nature's Reach"] = true,
		["Nature's Swiftness"] = true,
		["Nightfall"] = true,
		["Omen of Clarity"] = true,
		["One-Handed Axes"] = true,
		["One-Handed Maces"] = true,
		["One-Handed Swords"] = true,
		["One-Handed Weapon Specialization"] = true,
		["Opening - No Text"] = true,
		["Opening"] = true,
		["Opportunity"] = true,
		["Overpower"] = true,
		["Pain Suppression"] = true,
		["Paranoia"] = true,
		["Parry"] = true,
		["Pathfinding"] = true,
		["Perception"] = true,
		["Permafrost"] = true,
		["Pet Aggression"] = true,
		["Pet Hardiness"] = true,
		["Pet Recovery"] = true,
		["Pet Resistance"] = true,
		["Phase Shift"] = true,
		["Pick Lock"] = true,
		["Pick Pocket"] = true,
		["Piercing Howl"] = true,
		["Piercing Ice"] = true,
		["Plate Mail"] = true,
		["Poison Cleansing Totem"] = true,
		["Poisons"] = true,
		["Polearm Specialization"] = true,
		["Polearms"] = true,
		["Polymorph"] = true,
		["Polymorph: Pig"] = true,
		["Polymorph: Turtle"] = true,
		["Portal: Darnassus"] = true,
		["Portal: Ironforge"] = true,
		["Portal: Orgrimmar"] = true,
		["Portal: Stormwind"] = true,
		["Portal: Thunder Bluff"] = true,
		["Portal: Undercity"] = true,
		["Pounce Bleed"] = true,
		["Pounce"] = true,
		["Power Infusion"] = true,
		["Power Word: Fortitude"] = true,
		["Power Word: Shield"] = true,
		["Prayer of Fortitude"] = true,
		["Prayer of Healing"] = true,
		["Prayer of Mending"] = true,
		["Prayer of Shadow Protection"] = true,
		["Prayer of Spirit"] = true,
		["Precision"] = true,
		["Predatory Strikes"] = true,
		["Premeditation"] = true,
		["Preparation"] = true,
		["Presence of Mind"] = true,
		["Primal Fury"] = true,
		["Prowl"] = true,
		["Psychic Scream"] = true,
		["Pummel"] = true,
		["Purge"] = true,
		["Purification"] = true,
		["Purify"] = true,
		["Pursuit of Justice"] = true,
		["Pyroblast"] = true,
		["Pyroclasm"] = true,
		["Quick Shots"] = true,
		["Quickness"] = true,
		["Rain of Fire"] = true,
		["Rake"] = true,
		["Rampage"] = true,
		["Ram Riding"] = true,
		["Ranged Weapon Specialization"] = true,
		["Rapid Concealment"] = true,
		["Rapid Fire"] = true,
		["Raptor Riding"] = true,
		["Raptor Strike"] = true,
		["Ravage"] = true,
		["Readiness"] = true,
		["Rebirth"] = true,
		["Reckless Charge"] = true,
		["Recklessness"] = true,
		["Reckoning"] = true,
		["Redemption"] = true,
		["Redoubt"] = true,
		["Reflection"] = true,
		["Regeneration"] = true,
		["Regrowth"] = true,
		["Reincarnation"] = true,
		["Rejuvenation"] = true,
		["Relentless Strikes"] = true,
		["Remorseless"] = true,
		["Remorseless Attacks"] = true,
		["Remove Curse"] = true,
		["Remove Insignia"] = true,
		["Remove Lesser Curse"] = true,
		["Rend"] = true,
		["Renew"] = true,
		["Repentance"] = true,
		["Resurrection"] = true,
		["Retaliation"] = true,
		["Retribution Aura"] = true,
		["Revenge Stun"] = true,
		["Revenge"] = true,
		["Reverberation"] = true,
		["Revive Pet"] = true,
		["Righteous Defense"] = true,
		["Righteous Fury"] = true,
		["Rip"] = true,
		["Riposte"] = true,
		["Ritual of Doom Effect"] = true,
		["Ritual of Doom"] = true,
		["Ritual of Souls"] = true,
		["Ritual of Summoning"] = true,
		["Rockbiter Weapon"] = true,
		["Rogue Passive"] = true,
		["Rough Sharpening Stone"] = true,
		["Ruin"] = true,
		["Rupture"] = true,
		["Ruthlessness"] = true,
		["Sacrifice"] = true,
		["Safe Fall"] = true,
		["Sanctity Aura"] = true,
		["Sap"] = true,
		["Savage Fury"] = true,
		["Savage Strikes"] = true,
		["Scare Beast"] = true,
		["Scatter Shot"] = true,
		["Scorch"] = true,
		["Scorpid Poison"] = true,
		["Scorpid Sting"] = true,
		["Screech"] = true,
		["Seal Fate"] = true,
		["Seal of Blood"] = true,
		["Seal of Command"] = true,
		["Seal of Justice"] = true,
		["Seal of Light"] = true,
		["Seal of Righteousness"] = true,
		["Seal of Wisdom"] = true,
		["Seal of the Crusader"] = true,
		["Seal of Vengeance"] = true,
		["Searing Light"] = true,
		["Searing Pain"] = true,
		["Searing Totem"] = true,
		["Second Wind"] = true,
		["Seduction"] = true,
		["Seed of Corruption"] = true,
		["Sense Demons"] = true,
		["Sense Undead"] = true,
		["Sentry Totem"] = true,
		["Serpent Sting"] = true,
		["Setup"] = true,
		["Shackle Undead"] = true,
		["Shadow Affinity"] = true,
		["Shadow Bolt"] = true,
		["Shadow Focus"] = true,
		["Shadow Mastery"] = true,
		["Shadow Protection"] = true,
		["Shadow Reach"] = true,
		["Shadow Resistance Aura"] = true,
		["Shadow Resistance"] = true,
		["Shadow Trance"] = true,
		["Shadow Vulnerability"] = true,
		["Shadow Ward"] = true,
		["Shadow Weaving"] = true,
		["Shadow Word: Death"] = true,
		["Shadow Word: Pain"] = true,
		["Shadowburn"] = true,
		["Shadowfiend"] = true,
		["Shadowform"] = true,
		["Shadowfury"] = true,
		["Shadowguard"] = true,
		["Shadowmeld Passive"] = true,
		["Shadowmeld"] = true,
		["Shadowstep"] = true,
		["Shamanistic Rage"] = true,
		["Sharpened Claws"] = true,
		["Shatter"] = true,
		["Sheep"] = true,
		["Shell Shield"] = true,
		["Shield Bash"] = true,
		["Shield Bash - Silenced"] = true,
		["Shield Block"] = true,
		["Shield Slam"] = true,
		["Shield Specialization"] = true,
		["Shield Wall"] = true,
		["Shield"] = true,
		["Shiv"] = true,
		["Shoot Bow"] = true,
		["Shoot Crossbow"] = true,
		["Shoot Gun"] = true,
		["Shoot"] = true,
		["Shred"] = true,
		["Silence"] = true,
		["Silencing Shot"] = true,
		["Silent Resolve"] = true,
		["Sinister Strike"] = true,
		["Siphon Life"] = true,
		["Skinning"] = true,
		["Slam"] = true,
		["Sleep"] = true,
		["Slice and Dice"] = true,
		["Slow"] = true,
		["Slow Fall"] = true,
		["Smelting"] = true,
		["Smite"] = true,
		["Snake Trap"] = true,
		["Solid Sharpening Stone"] = true,
		["Soothe Animal"] = true,
		["Soothing Kiss"] = true,
		["Soul Fire"] = true,
		["Soul Link"] = true,
		["Soul Siphon"] = true,
		["Soulshatter"] = true,
		["Soulstone Resurrection"] = true,
		["Spell Lock"] = true,
		["Spellsteal"] = true,
		["Spell Reflection"] = true,
		["Spell Warding"] = true,
		["Spirit Bond"] = true,
		["Spirit Tap"] = true,
		["Spirit of Redemption"] = true,
		["Spiritual Attunement"] = true,
		["Spiritual Focus"] = true,
		["Spiritual Guidance"] = true,
		["Spiritual Healing"] = true,
		["Sprint"] = true,
		["Stance Mastery"] = true,
		["Starfire"] = true,
		["Starfire Stun"] = true,
		["Starshards"] = true,
		["Staves"] = true,
		["Steady Shot"] = true,
		["Stealth"] = true,
		["Stoneclaw Totem"] = true,
		["Stoneform"] = true,
		["Stoneskin Totem"] = true,
		["Stormstrike"] = true,
		["Strength of Earth Totem"] = true,
		["Stuck"] = true,
		["Subtlety"] = true,
		["Suffering"] = true,
		["Summon Charger"] = true,
		["Summon Dreadsteed"] = true,
		["Summon Felguard"] = true,
		["Summon Felhunter"] = true,
		["Summon Felsteed"] = true,
		["Summon Imp"] = true,
		["Summon Succubus"] = true,
		["Summon Voidwalker"] = true,
		["Summon Warhorse"] = true,
		["Summon Water Elemental"] = true,
		["Sunder Armor"] = true,
		["Suppression"] = true,
		["Surefooted"] = true,
		["Survivalist"] = true,
		["Sweeping Strikes"] = true,
		["Swiftmend"] = true,
		["Swipe"] = true,
		["Sword Specialization"] = true,
		["Tactical Mastery"] = true,
		["Tainted Blood"] = true,
		["Tailoring"] = true,
		["Tame Beast"] = true,
		["Tamed Pet Passive"] = true,
		["Taunt"] = true,
		["Teleport: Darnassus"] = true,
		["Teleport: Ironforge"] = true,
		["Teleport: Moonglade"] = true,
		["Teleport: Orgrimmar"] = true,
		["Teleport: Stormwind"] = true,
		["Teleport: Thunder Bluff"] = true,
		["Teleport: Undercity"] = true,
		["The Beast Within"] = true,
		["The Human Spirit"] = true,
		["Thick Hide"] = true,
		["Thorns"] = true,
		["Throw"] = true,
		["Throwing Specialization"] = true,
		["Throwing Weapon Specialization"] = true,
		["Thrown"] = true,
		["Thunder Clap"] = true,
		["Thundering Strikes"] = true,
		["Thunderstomp"] = true,
		["Tidal Focus"] = true,
		["Tidal Mastery"] = true,
		["Tiger Riding"] = true,
		["Tiger's Fury"] = true,
		["Torment"] = true,
		["Totem"] = true,
		["Totem of Wrath"] = true,
		["Totemic Focus"] = true,
		["Touch of Weakness"] = true,
		["Toughness"] = true,
		["Track Beasts"] = true,
		["Track Demons"] = true,
		["Track Dragonkin"] = true,
		["Track Elementals"] = true,
		["Track Giants"] = true,
		["Track Hidden"] = true,
		["Track Humanoids"] = true,
		["Track Undead"] = true,
		["Tranquil Air Totem"] = true,
		["Tranquil Spirit"] = true,
		["Tranquility"] = true,
		["Tranquilizing Shot"] = true,
		["Trap Mastery"] = true,
		["Travel Form"] = true,
		["Tree of Life"] = true,
		["Tremor Totem"] = true,
		["Tribal Leatherworking"] = true,
		["Trueshot Aura"] = true,
		["Turn Undead"] = true,
		["Two-Handed Axes and Maces"] = true,
		["Two-Handed Axes"] = true,
		["Two-Handed Maces"] = true,
		["Two-Handed Swords"] = true,
		["Two-Handed Weapon Specialization"] = true,
		["Unarmed"] = true,
		["Unbreakable Will"] = true,
		["Unbridled Wrath Effect"] = true,
		["Unbridled Wrath"] = true,
		["Undead Horsemanship"] = true,
		["Underwater Breathing"] = true,
		["Unending Breath"] = true,
		["Unholy Power"] = true,
		["Unleashed Fury"] = true,
		["Unleashed Rage"] = true,
		["Unstable Affliction"] = true,
		["Unyielding Faith"] = true,
		["Vampiric Embrace"] = true,
		["Vanish"] = true,
		["Vanished"] = true,
		["Vampiric Touch"] = true,
		["Vengeance"] = true,
		["Victory Rush"] = true,
		["Vigor"] = true,
		["Vile Poisons"] = true,
		["Vindication"] = true,
		["Viper Sting"] = true,
		["Volley"] = true,
		["Wand Specialization"] = true,
		["Wands"] = true,
		["War Stomp"] = true,
		["Water Breathing"] = true,
		["Water Shield"] = true,
		["Water Walking"] = true,
		["Waterbolt"] =	true,
		["Weakened Soul"] = true,
		["Weaponsmith"] = true,
		["Whirlwind"] = true,
		["Will of the Forsaken"] = true,
		["Windfury Totem"] = true,
		["Windfury Weapon"] = true,
		["Windwall Totem"] = true,
		["Wing Clip"] = true,
		["Winter's Chill"] = true,
		["Wisp Spirit"] = true,
		["Wolf Riding"] = true,
		["Wound Poison II"] = true,
		["Wound Poison III"] = true,
		["Wound Poison IV"] = true,
		["Wound Poison"] = true,
		["Wrath"] = true,
		["Wrath of Air Totem"] = true,
		["Wyvern Sting"] = true,
	}
end)

BabbleSpell:RegisterTranslations("deDE", function()
	return {
		["Abolish Disease"] = "Krankheit aufheben",
		["Abolish Poison Effect"] = "Vergiftung aufheben - Effekt",
		["Abolish Poison"] = "Vergiftung aufheben",
		["Activate MG Turret"] = "MG-Turm aktivieren",
		["Adrenaline Rush"] = "Adrenalinrausch",
		["Aftermath"] = "Nachwirkung",
		["Aggression"] = "Aggression",
		["Aimed Shot"] = "Gezielter Schuss",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Hinterhalt",
		["Amplify Curse"] = "Fluch verst\195\164rken",
		["Amplify Magic"] = "Magie verst\195\164rken",
		["Ancestral Fortitude"] = "Seelenstrke der Ahnen",
		["Ancestral Healing"] = "Heilung der Ahnen",
		["Ancestral Knowledge"] = "Wissen der Ahnen",
		["Ancestral Spirit"] = "Geist der Ahnen",
		["Anesthetic Poison"] = "Beruhigendes Gift",
		["Anger Management"] = "Aggressionskontrolle",
		["Anguish"] = "Seelenpein",
		["Anticipation"] = "Vorahnung",
		["Aquatic Form"] = "Wassergestalt",
		["Arcane Blast"] = "Arkanschlag",
		["Arcane Brilliance"] = "Arkane Brillanz",
		["Arcane Concentration"] = "Arkane Konzentration",
		["Arcane Explosion"] = "Arkane Explosion",
		["Arcane Focus"] = "Arkaner Fokus",
		["Arcane Instability"] = "Arkane Instabilit\195\164t",
		["Arcane Intellect"] = "Arkane Intelligenz",
		["Arcane Meditation"] = "Arkane Meditation",
		["Arcane Mind"] = "Arkaner Geist",
		["Arcane Missiles"] = "Arkane Geschosse",
		["Arcane Power"] = "Arkane Macht",
		["Arcane Resistance"] = "Arkanwiderstand",
		["Arcane Shot"] = "Arkaner Schuss",
		["Arcane Subtlety"] = "Arkanes Feingef\195\188hl",
		["Arctic Reach"] = "Arktische Reichweite",
		["Armorsmith"] = "R\195\188stungsschmied",
		["Aspect of the Beast"] = "Aspekt des Wildtiers",
		["Aspect of the Cheetah"] = "Aspekt des Geparden",
		["Aspect of the Hawk"] = "Aspekt des Falken",
		["Aspect of the Monkey"] = "Aspekt des Affen",
		["Aspect of the Pack"] = "Aspekt des Rudels",
		["Aspect of the Viper"] = "Aspekt der Viper",
		["Aspect of the Wild"] = "Aspekt der Wildnis",
		["Astral Recall"] = "Astraler R\195\188ckruf",
		["Attack"] = "Angreifen",
		["Attacking"] = "Angreifen",
		["Auto Shot"] = "Autom. Schuss",
		["Avenger's Shield"] = "Schild des R\195\164chers",
		["Avenging Wrath"] = "Zornige Vergeltung",
		["Avoidance"] = "Vermeidung",
		["Axe Specialization"] = "Axt-Spezialisierung",
		["Backlash"] = "Heimzahlen",
		["Backstab"] = "Meucheln",
		["Bane"] = "Dunkle Macht",
		["Banish"] = "Verbannen",
		["Barkskin Effect"] = "Baumrindeneffekt",
		["Barkskin"] = "Baumrinde",
		["Barrage"] = "Sperrfeuer",
		["Bash"] = "Hieb",
		["Basic Campfire"] = "Einfaches Lagerfeuer",
		["Battle Shout"] = "Schlachtruf",
		["Battle Stance Passive"] = "Kampfhaltung Passiv",
		["Battle Stance"] = "Kampfhaltung",
		["Bear Form"] = "B\195\164rengestalt",
		["Beast Lore"] = "Wildtierkunde",
		["Beast Slaying"] = "Wildtierschl\195\164chter",
		["Beast Training"] = "Wildtierausbildung",
		["Benediction"] = "Segnung",
		["Berserker Rage"] = "Berserkerwut",
		["Berserker Stance Passive"] = "Berserkerhaltung - Passiv",
		["Berserker Stance"] = "Berserkerhaltung",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Wildtierdisziplin",
		["Bestial Swiftness"] = "Erh\195\182hte Tiergeschwindigkeit",
		["Bestial Wrath"] = "Zorn des Wildtiers",
		["Binding Heal"] = "Verbindende Heilung",
		["Bite"] = "Bei\195\159en",
		["Black Arrow"] = "Schwarzer Pfeil",
		["Blackout"] = "Verdunkelung",
		["Blacksmithing"] = "Schmiedekunst",
		["Blade Flurry"] = "Klingenwirbel",
		["Blast Wave"] = "Druckwelle",
		["Blazing Speed"] = "Hei\195\159e Sohlen",
		["Blessed Recovery"] = "Gesegnete Erholung",
		["Blessing of Freedom"] = "Segen der Freiheit",
		["Blessing of Kings"] = "Segen der K\195\182nige",
		["Blessing of Light"] = "Segen des Lichts",
		["Blessing of Might"] = "Segen der Macht",
		["Blessing of Protection"] = "Segen des Schutzes",
		["Blessing of Sacrifice"] = "Segen der Opferung",
		["Blessing of Salvation"] = "Segen der Rettung",
		["Blessing of Sanctuary"] = "Segen des Refugiums",
		["Blessing of Wisdom"] = "Segen der Weisheit",
		["Blind"] = "Blenden",
		["Blinding Powder"] = "Blendungspulver",
		["Blink"] = "Blinzeln",
		["Blizzard"] = "Blizzard",
		["Block"] = "Blocken",
		["Blood Craze"] = "Blutwahnsinn",
		["Blood Frenzy"] = "Blutraserei",
		["Blood Fury"] = "Kochendes Blut",
		["Blood Pact"] = "Blutpakt",
		["Bloodlust"] = "Kampfrausch",
		["Bloodrage"] = "Blutrausch",
		["Bloodthirst"] = "Blutdurst",
		["Booming Voice"] = "Donnernde Stimme",
		["Bow Specialization"] = "Bogenspezialisierung",
		["Bows"] = "Bogen",
		["Bright Campfire"] = "Helles Lagerfeuer",
		["Brutal Impact"] = "Brutaler Hieb",
		["Burning Soul"] = "Brennende Seele",
		["Call Pet"] = "Tier rufen",
		["Call of Flame"] = "Ruf der Flamme",
		["Call of Thunder"] = "Ruf des Donners",
		["Camouflage"] = "Tarnung",
		["Cannibalize"] = "Kannibalismus",
		["Cat Form"] = "Katzengestalt",
		["Cataclysm"] = "Katastrophe",
		["Chain Heal"] = "Kettenheilung",
		["Chain Lightning"] = "Kettenblitzschlag",
		["Challenging Roar"] = "Herausforderndes Gebr\195\188ll",
		["Challenging Shout"] = "Herausforderungsruf",
		["Charge Rage Bonus Effect"] = "Wut-Aufladung-Bonus-Effekt",
		["Charge"] = "Sturmangriff",
		["Charge Stun"] = "Sturmangriffsbetubung",
		["Cheap Shot"] = "Fieser Trick",
		["Chilled"] = "K\195\164lte",
		["Circle of Healing"] = "Kreis der Heilung",
		["Claw"] = "Klaue",
		["Cleanse"] = "Reinigung des Glaubens",
		["Clearcasting"] = "Freizaubern",
		["Cleave"] = "Spalten",
		["Clever Traps"] = "Falleneffizienz",
		["Cloak of Shadows"] = "Mantel der Schatten",
		["Closing"] = "Schlie\195\159en",
		["Cloth"] = "Stoff",
		["Cobra Reflexes"] = "Kobrareflexe",
		["Cold Blood"] = "Kaltbl\195\188tigkeit",
		["Cold Snap"] = "K\195\164lteeinbruch",
		["Combat Endurance"] = "Durchhalteverm\195\182gen des K\195\164mpfers",
		["Combustion"] = "Verbrennung",
		["Command"] = "Befehlsgewalt",
		["Commanding Shout"] = "Befehlsruf",
		["Concentration Aura"] = "Aura der Konzentration",
		["Concussion Blow"] = "Ersch\195\188tternder Schlag",
		["Concussion"] = "Ersch\195\188tterung",
		["Concussive Shot"] = "Ersch\195\188tternder Schuss",
		["Cone of Cold"] = "K\195\164ltekegel",
		["Conflagrate"] = "Feuersbrunst",
		["Conjure Food"] = "Essen herbeizaubern",
		["Conjure Mana Agate"] = "Mana-Achat herbeizaubern",
		["Conjure Mana Citrine"] = "Mana-Citrin herbeizaubern",
		["Conjure Mana Jade"] = "Mana-Jadestein herbeizaubern",
		["Conjure Mana Ruby"] = "Mana-Rubin herbeizaubern",
		["Conjure Water"] = "Wasser herbeizaubern",
		["Consecration"] = "Weihe",
		["Consume Magic"] = "Magie verzehren",
		["Consume Shadows"] = "Schatten verzehren",
		["Convection"] = "Konvektion",
		["Conviction"] = "\195\156berzeugung",
		["Cooking"] = "Kochkunst",
		["Corruption"] = "Verderbnis",
		["Counterattack"] = "Gegenangriff",
		["Counterspell"] = "Gegenzauber",
		["Counterspell - Silenced"] = "Gegenzauber - zum Schweigen gebracht",
		["Cower"] = "Ducken",
		["Create Firestone"] = "Feuerstein herstellen",
		["Create Firestone (Major)"] = "Feuerstein herstellen (Gro\195\159er)",
		["Create Firestone (Greater)"] = "Feuerstein herstellen (Gr\195\182\sser)",
		["Create Firestone (Lesser)"] = "Feuerstein herstellen (Kleiner)",
		["Create Healthstone"] = "Gesundheitsstein herstellen",
		["Create Healthstone (Major)"] = "Gesundheitsstein herstellen (Gro\195\159er)",
		["Create Healthstone (Greater)"] = "Gesundheitsstein herstellen (Gr\195\182\sser)",
		["Create Healthstone (Lesser)"] = "Gesundheitsstein herstellen (Kleiner)",
		["Create Healthstone (Minor)"] = "Gesundheitsstein herstellen (Klein)",
		["Create Soulstone"] = "Seelenstein herstellen",
		["Create Soulstone (Major)"] = "Seelenstein herstellen (Gro\195\159er)",
		["Create Soulstone (Greater)"] = "Seelenstein herstellen (Gr\195\182\sser)",
		["Create Soulstone (Lesser)"] = "Seelenstein herstellen (Kleiner)",
		["Create Soulstone (Minor)"] = "Seelenstein herstellen (Klein)",
		["Create Spellstone"] = "Zauberstein herstellen",
		["Create Spellstone (Master)"] = "Zauberstein herstellen (meisterlich)",
		["Create Spellstone (Major)"] = "Zauberstein herstellen (Gro\195\159er)",
		["Create Spellstone (Greater)"] = "Zauberstein herstellen (Gr\195\182\sser)",
		["Crippling Poison II"] = "Verkr\195\188ppelndes Gift II",
		["Crippling Poison"] = "Verkr\195\188ppelndes Gift",
		["Critical Mass"] = "Kritische Masse",
		["Crossbows"] = "Armbr\195\188ste",
		["Cruelty"] = "Grausamkeit",
		["Crusader Aura"] = "Aura des Kreuzfahrers",
		["Crusader Strike"] = "Kreuzfahrersto\195\159",
		["Cultivation"] = "Gr\195\188ner Daumen",
		["Cure Disease"] = "Krankheit heilen",
		["Cure Poison"] = "Vergiftung heilen",
		["Curse of Agony"] = "Fluch der Pein",
		["Curse of Doom Effect"] = "Fluch der Verdammnis'-Effekt",
		["Curse of Doom"] = "Fluch der Verdammnis",
		["Curse of Exhaustion"] = "Fluch der Ersch\195\182pfung",
		["Curse of Idiocy"] = "Fluch der Torheit",
		["Curse of Recklessness"] = "Fluch der Tollk\195\188hnheit",
		["Curse of Shadow"] = "Fluch der Schatten",
		["Curse of Tongues"] = "Fluch der Sprachen",
		["Curse of Weakness"] = "Fluch der Schw\195\164che",
		["Curse of the Elements"] = "Fluch der Elemente",
		["Cyclone"] = "Wirbelsturm",
		["Dagger Specialization"] = "Dolch-Spezialisierung",
		["Daggers"] = "Dolche",
		["Dampen Magic"] = "Magie d\195\164mpfen",
		["Dark Pact"] = "Dunkler Pakt",
		["Darkness"] = "Dunkelheit",
		["Dash"] = "Spurt",
		["Deadly Poison II"] = "T\195\182dliches Gift II",
		["Deadly Poison III"] = "T\195\182dliches Gift III",
		["Deadly Poison IV"] = "T\195\182dliches Gift IV",
		["Deadly Poison V"] = "T\195\182dliches Gift V",
		["Deadly Poison"] = "T\195\182dliches Gift",
		["Deadly Throw"] = "T\195\182dlicher Wurf",
		["Death Coil"] = "Todesmantel",
		["Death Wish"] = "Todeswunsch",
		["Deep Wounds"] = "Tiefe Wunden",
		["Defense"] = "Verteidigung",
		["Defensive Stance Passive"] = "Verteidigungshaltung - Passiv",
		["Defensive Stance"] = "Verteidigungshaltung",
		["Defensive State 2"] = "Verteidigungsstatus 2",
		["Defensive State"] = "Verteidigungsstatus",
		["Defiance"] = "Trotz",
		["Deflection"] = "Abwehr",
		["Demon Armor"] = "D\195\164monenr\195\188stung",
		["Demon Skin"] = "D\195\164monenhaut",
		["Demonic Embrace"] = "D\195\164monische Umarmung",
		["Demonic Frenzy"] = "D\195\164monische Raserei",
		["Demonic Sacrifice"] = "D\195\164monische Opferung",
		["Demoralizing Roar"] = "Demoralisierendes Gebr\195\188ll",
		["Demoralizing Shout"] = "Demoralisierungsruf",
		["Desperate Prayer"] = "Verzweifeltes Gebet",
		["Destructive Reach"] = "Zerst\195\182rerische Reichweite",
		["Detect Greater Invisibility"] = "Gro\195\159e Unsichtbarkeit entdecken",
		["Detect Invisibility"] = "Unsichtbarkeit entdecken",
		["Detect Lesser Invisibility"] = "Geringe Unsichtbarkeit entdecken",
		["Detect Magic"] = "Magie entdecken",
		["Detect Traps"] = "Fallen entdecken",
		["Detect"] = "Entdecken",
		["Deterrence"] = "Abschreckung",
		["Devastate"] = "Verw\195\188sten",
		["Devastation"] = "Verw\195\188stung",
		["Devotion Aura"] = "Aura der Hingabe",
		["Devour Magic Effect"] = "Magie verschlingen' - Effekt",
		["Devour Magic"] = "Magie verschlingen",
		["Devouring Plague"] = "Verschlingende Seuche",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Terrorb\195\164rengestalt",
		["Disarm Trap"] = "Falle entsch\195\164rfen",
		["Disarm"] = "Entwaffnen",
		["Disease Cleansing Totem"] = "Totem der Krankheitsreinigung",
		["Disenchant"] = "Entzaubern",
		["Disengage"] = "R\195\188ckzug",
		["Dismiss Pet"] = "Tier freigeben",
		["Dispel Magic"] = "Magiebannung",
		["Distract"] = "Ablenken",
		["Distracting Shot"] = "Ablenkender Schuss",
		["Dive"] = "Sturzflug",
		["Divine Favor"] = "G\195\182ttliche Gunst",
		["Divine Fury"] = "G\195\182ttlicher Furor",
		["Divine Illumination"] = "G\195\182ttliche Eingebung",
		["Divine Intellect"] = "G\195\182ttliche Weisheit",
		["Divine Intervention"] = "G\195\182ttliches Eingreifen",
		["Divine Protection"] = "G\195\182ttlicher Schutz",
		["Divine Shield"] = "Gottesschild",
		["Divine Spirit"] = "G\195\182ttlicher Willen",
		["Divine Strength"] = "G\195\182ttliche St\195\164rke",
		["Dodge"] = "Ausweichen",
		["Dragon's Breath"] = "Drachenodem",
		["Dragonscale Leatherworking"] = "Drachenschuppenlederverarbeitung",
		["Drain Life"] = "Blutsauger",
		["Drain Mana"] = "Mana entziehen",
		["Drain Soul"] = "Seelendieb",
		["Drink"] = "Trinken",
		["Dual Wield Specialization"] = "Beidh\195\164ndigkeits-Spezialisierung",
		["Dual Wield"] = "Beidh\195\164ndigkeit",
		["Duel"] = "Duell",
		["Eagle Eye"] = "Adlerauge",
		["Earth Elemental Totem"] = "Totem des Erdelementars",
		["Earth Shield"] = "Erdschild",
		["Earth Shock"] = "Erdschock",
		["Earthbind Totem"] = "Totem der Erdbindung",
		["Efficiency"] = "Effizienz",
		["Elemental Focus"] = "Elementarfokus",
		["Elemental Fury"] = "Elementarfuror",
		["Elemental Leatherworking"] = "Elementarlederverarbeitung",
		["Elemental Mastery"] = "Elementarbeherrschung",
		["Elune's Grace"] = "Elunes Anmut",
		["Elusiveness"] = "Fl\195\188chtigkeit",
		["Emberstorm"] = "Glutsturm",
		["Enamored Water Spirit"] = "Entzckter Wassergeist",
		["Enchanting"] = "Verzauberkunst",
		["Endurance Training"] = "Belastbarkeit-Ausbildung",
		["Endurance"] = "Durchhalteverm\195\182gen",
		["Engineering Specialization"] = "Technologist",
		["Engineering"] = "Ingenieurskunst",
		["Enrage"] = "Wutanfall",
		["Enriched Manna Biscuit"] = "Angereicherter Manakeks",
		["Enslave Demon"] = "D\195\164monensklave",
		["Entangling Roots"] = "Wucherwurzeln",
		["Entrapment"] = "Einfangen",
		["Envenom"] = "Vergiften",
		["Escape Artist"] = "Entfesselungsk\195\188nstler",
		["Evasion"] = "Entrinnen",
		["Eventide"] = "Abendzeit",
		["Eviscerate"] = "Ausweiden",
		["Evocation"] = "Hervorrufung",
		["Execute"] = "Hinrichten",
		["Exorcism"] = "Exorzismus",
		["Expansive Mind"] = "Wacher Geist",
		["Explosive Trap Effect"] = "Sprengfalle'-Effekt",
		["Explosive Trap"] = "Sprengfalle",
		["Expose Armor"] = "R\195\188stung schw\195\164chen",
		["Eye for an Eye"] = "Auge um Auge",
		["Eye of Kilrogg"] = "Auge von Kilrogg",
		["Eyes of the Beast"] = "Augen des Wildtiers",
		["Fade"] = "Verblassen",
		["Faerie Fire"] = "Feenfeuer",
		["Faerie Fire (Feral)"] = "Feenfeuer (Tiergestalt)",
		["Far Sight"] = "Fernsicht",
		["Fear Ward"] = "Furchtzauberschutz",
		["Fear"] = "Furcht",
		["Feed Pet"] = "Tier f\195\188ttern",
		["Feedback"] = "R\195\188ckkopplung",
		["Feign Death"] = "Totstellen",
		["Feint"] = "Finte",
		["Fel Armor"] = "Teufelsr\195\188stung",
		["Fel Concentration"] = "Teufelskonzentration",
		["Fel Domination"] = "Teufelsbeherrschung",
		["Fel Intellect"] = "Teufelsintelligenz",
		["Fel Stamina"] = "Teufelsausdauer",
		["Felfire"] = "Teufelsfeuer",
		["Feline Grace"] = "Katzenhafte Anmut",
		["Feline Swiftness"] = "Katzenhafte Schnelligkeit",
		["Feral Aggression"] = "Wilde Aggression",
		["Feral Charge"] = "Wilde Attacke",
		["Feral Instinct"] = "Instinkt der Wildnis",
		["Ferocious Bite"] = "Wilder Biss",
		["Ferocity"] = "Wildheit",
		["Fetish"] = "Fetisch",
		["Find Herbs"] = "Kr\195\164utersuche",
		["Find Minerals"] = "Mineraliensuche",
		["Find Treasure"] = "Schatzsucher",
		["Find Weakness"] = "Finde Schw\195\164che",
		["Fire Blast"] = "Feuerschlag",
		["Fire Elemental Totem"] = "Totem des Feuerelementars",
		["Fire Nova Totem"] = "Totem der Feuernova",
		["Fire Power"] = "Feuermacht",
		["Fire Resistance Aura"] = "Aura des Feuerwiderstands",
		["Fire Resistance Totem"] = "Totem des Feuerwiderstands",
		["Fire Resistance"] = "Feuerwiderstand",
		["Fire Shield"] = "Feuerschild",
		["Fire Vulnerability"] = "Feuerverwundbarkeit",
		["Fire Ward"] = "Feuerzauberschutz",
		["Fireball"] = "Feuerball",
		["Firebolt"] = "Feuerblitz",
		["First Aid"] = "Erste Hilfe",
		["Fishing Poles"] = "Angeln",
		["Fishing"] = "Angeln",
		["Fist Weapon Specialization"] = "Faustwaffen-Spezialisierung",
		["Fist Weapons"] = "Faustwaffen",
		["Flame Shock"] = "Flammenschock",
		["Flame Throwing"] = "Flammenwerfen",
		["Flamestrike"] = "Flammensto\195\159",
		["Flamethrower"] = "Flammenwerfer",
		["Flametongue Totem"] = "Totem der Flammenzunge",
		["Flametongue Weapon"] = "Waffe der Flammenzunge",
		["Flare"] = "Leuchtfeuer",
		["Flash Heal"] = "Blitzheilung",
		["Flash of Light"] = "Lichtblitz",
		["Flight Form"] = "Fluggestalt",
		["Flurry"] = "Schlaghagel",
		["Focused Casting"] = "Fokussiertes Zauberwirken",
		["Food"] = "Essen",
		["Forbearance"] = "Vorahnung",
		["Force of Nature"] = "Naturgewalt",
		["Force of Will"] = "Macht des Willens",
		["Freezing Trap Effect"] = "Eisk?tefalle",
		["Freezing Trap"] = "Eisk\195\164ltefalle",
		["Frenzied Regeneration"] = "Rasende Regeneration",
		["Frenzy"] = "Raserei",
		["Frost Armor"] = "Frostr\195\188stung",
		["Frost Channeling"] = "Frost-Kanalisierung",
		["Frost Nova"] = "Frostnova",
		["Frost Resistance Aura"] = "Aura des Frostwiderstands",
		["Frost Resistance Totem"] = "Totem des Frostwiderstands",
		["Frost Resistance"] = "Frostwiderstand",
		["Frost Shock"] = "Frostschock",
		["Frost Trap"] = "Frostfalle",
		["Frost Trap Aura"] = "Frostfalle-Aura",
		["Frost Ward"] = "Frostzauberschutz",
		["Frostbite"] = "Erfrierung",
		["Frostbolt"] = "Frostblitz",
		["Frostbrand Weapon"] = "Waffe des Frostbrands",
		["Furious Howl"] = "Wutgeheul",
		["Furor"] = "Furor",
		["Garrote"] = "Erdrosseln",
		["Generic"] = "Allgemein",
		["Ghost Wolf"] = "Geisterwolf",
		["Ghostly Strike"] = "Geisterhafter Sto\195\159",
		["Gift of Nature"] = "Geschenk der Natur",
		["Gift of the Wild"] = "Gabe der Wildnis",
		["Gouge"] = "Solarplexus",
		["Grace of Air Totem"] = "Totem der luftgleichen Anmut",
		["Great Stamina"] = "Gro\195\159e Ausdauer",
		["Greater Blessing of Kings"] = "Gro\195\159er Segen der K\195\182nige",
		["Greater Blessing of Light"] = "Gro\195\159er Segen des Lichts",
		["Greater Blessing of Might"] = "Gro\195\159er Segen der Macht",
		["Greater Blessing of Salvation"] = "Gro\195\159er Segen der Rettung",
		["Greater Blessing of Sanctuary"] = "Gro\195\159er Segen des Refugiums",
		["Greater Blessing of Wisdom"] = "Gro\195\159er Segen der Weisheit",
		["Greater Heal"] = "Gro\195\159e Heilung",
		["Grim Reach"] = "Grimmige Reichweite",
		["Grounding Totem"] = "Totem der Erdung",
		["Grovel"] = "Kriechen",
		["Growl"] = "Knurren",
		["Guardian's Favor"] = "Gunst des H\195\188ters",
		["Gun Specialization"] = "Schusswaffenspezialisierung",
		["Guns"] = "Schusswaffen",
		["Hammer of Justice"] = "Hammer der Gerechtigkeit",
		["Hammer of Wrath"] = "Hammer des Zorns",
		["Hamstring"] = "Kniesehne",
		["Harass"] = "Bel\195\164stigen",
		["Hardiness"] = "Z\195\164higkeit",
		["Hawk Eye"] = "Falkenauge",
		["Heal"] = "Heilen",
		["Healing Focus"] = "Heilfokus",
		["Healing Light"] = "Heilendes Licht",
		["Healing Stream Totem"] = "Totem des heilenden Flusses",
		["Healing Touch"] = "Heilende Ber\195\188hrung",
		["Healing Wave"] = "Welle der Heilung",
		["Healing Way"] = "Pfad der Heilung",
		["Health Funnel"] = "Lebenslinie",
		["Heart of the Wild"] = "Herz der Wildnis",
		["Hellfire Effect"] = "H\195\182llenfeuer - Effekt",
		["Hellfire"] = "H\195\182llenfeuer",
		["Hemorrhage"] = "Blutsturz",
        ["Herb Gathering"] = "Kr\195\164utersammeln",
		["Herbalism"] = "Kr\195\164uterkunde",
		["Heroic Strike"] = "Heldenhafter Sto\195\159",
		["Heroism"] = "Heldentum",
		["Hex of Weakness"] = "Verhexung der Schw\195\164che",
		["Hibernate"] = "Winterschlaf",
		["Holy Fire"] = "Heiliges Feuer",
		["Holy Light"] = "Heiliges Licht",
		["Holy Nova"] = "Heilige Nova",
		["Holy Power"] = "Heilige Macht",
		["Holy Reach"] = "Heilige Reichweite",
		["Holy Shield"] = "Heiliger Schild",
		["Holy Shock"] = "Heiliger Schock",
		["Holy Specialization"] = "Macht des Glaubens",
		["Holy Wrath"] = "Heiliger Zorn",
		["Honorless Target"] = "Ehrenloses Ziel",
		["Horse Riding"] = "Pferdreiten",
		["Howl of Terror"] = "Schreckgeheul",
		["Humanoid Slaying"] = "Humanoident\195\182ten",
		["Hunter's Mark"] = "Mal des J\195\164gers",
		["Hurricane"] = "Hurrikan",
		["Ice Armor"] = "Eisr\195\188stung",
		["Ice Barrier"] = "Eis-Barriere",
		["Ice Block"] = "Eisblock",
		["Ice Lance"] = "Eislanze",
		["Ice Shards"] = "Eissplitter",
		["Ignite"] = "Entz\195\188nden",
		["Illumination"] = "Illumination",
		["Immolate"] = "Feuerbrand",
		["Immolation Trap Effect"] = "Feuerbrandfalle",
		["Immolation Trap"] = "Feuerbrandfalle",
		["Impact"] = "Einschlag",
		["Impale"] = "Durchbohren",
		["Improved Ambush"] = "Verbesserter Hinterhalt",
		["Improved Arcane Explosion"] = "Verbesserte Arkane Explosion",
		["Improved Arcane Missiles"] = "Verbesserte arkane Geschosse",
		["Improved Arcane Shot"] = "Verbesserter Arkaner Schuss",
		["Improved Aspect of the Hawk"] = "Verbesserter Aspekt des Falken",
		["Improved Aspect of the Monkey"] = "Verbesserter Aspekt des Affen",
		["Improved Backstab"] = "Verbessertes Meucheln",
		["Improved Battle Shout"] = "Verbesserter Schlachtruf",
		["Improved Berserker Rage"] = "Verbesserte Berserkerwut",
		["Improved Blessing of Might"] = "Verbesserter Segen der Macht",
		["Improved Blessing of Wisdom"] = "Verbesserter Segen der Weisheit",
		["Improved Blizzard"] = "Verbesserter Blizzard",
		["Improved Bloodrage"] = "Verbesserter Blutrausch",
		["Improved Chain Heal"] = "Verbesserte Kettenheilung",
		["Improved Chain Lightning"] = "Verbesserter Kettenblitzschlag",
		["Improved Challenging Shout"] = "Verbesserter Herausforderungsruf",
		["Improved Charge"] = "Verbesserter Sturmangriff",
		["Improved Cheap Shot"] = "Verbesserter Fieser Trick",
		["Improved Cleave"] = "Verbessertes Spalten",
		["Improved Concentration Aura"] = "Verbesserte Aura der Konzentration",
		["Improved Concussive Shot"] = "Verbesserter Ersch\195\188tternder Schuss",
		["Improved Cone of Cold"] = "Verbesserter K\195\164ltekegel",
		["Improved Corruption"] = "Verbesserte Verderbnis",
		["Improved Counterspell"] = "Verbesserter Gegenzauber",
		["Improved Curse of Agony"] = "Verbesserter Fluch der Pein",
		["Improved Curse of Exhaustion"] = "Verbesserter Fluch der Ersch\195\182pfung",
		["Improved Curse of Weakness"] = "Verbesserter Fluch der Schw\195\164che",
		["Improved Dampen Magic"] = "Verbesserter Magied\195\164mpfer",
		["Improved Deadly Poison"] = "Verbessertes t\195\182dliches Gift",
		["Improved Demoralizing Shout"] = "Verbesserter Demoralisierender Ruf",
		["Improved Devotion Aura"] = "Verbesserte Aura der Hingabe",
		["Improved Disarm"] = "Verbessertes Entwaffnen",
		["Improved Distract"] = "Verbessertes Ablenken",
		["Improved Drain Life"] = "Verbesserter Blutsauger",
		["Improved Drain Mana"] = "Verbessertes Mana entziehen",
		["Improved Drain Soul"] = "Verbesserter Seelendieb",
		["Improved Enrage"] = "Verbesserter Wutanfall",
		["Improved Enslave Demon"] = "Verbesserter D\195\164monensklave",
		["Improved Entangling Roots"] = "Verbesserte Wucherwurzeln",
		["Improved Evasion"] = "Verbessertes Entrinnen",
		["Improved Eviscerate"] = "Verbessertes Ausweiden",
		["Improved Execute"] = "Verbessertes Hinrichten",
		["Improved Expose Armor"] = "Verbessertes R\195\188stung schw\195\164chen",
		["Improved Eyes of the Beast"] = "Verbesserte Augen des Wildtiers",
		["Improved Fade"] = "Verbessertes Verblassen",
		["Improved Feign Death"] = "Verbessertes Totstellen",
		["Improved Fire Blast"] = "Verbesserter Feuerschlag",
		["Improved Fire Nova Totem"] = "Verbessertes Totem der Feuernova",
		["Improved Fire Ward"] = "Verbesserter Feuerzauberschutz",
		["Improved Fireball"] = "Verbesserter Feuerball",
		["Improved Firebolt"] = "Verbesserter Feuerblitz",
		["Improved Firestone"] = "Verbesserter Feuerstein",
		["Improved Flamestrike"] = "Verbesserter Flammensto\195\159",
		["Improved Flametongue Weapon"] = "Verbesserte Waffe der Flammenzunge",
		["Improved Flash of Light"] = "Verbesserter Lichtblitz",
		["Improved Frost Nova"] = "Verbesserte Frostnova",
		["Improved Frost Ward"] = "Verbesserter Frostzauberschutz",
		["Improved Frostbolt"] = "Verbesserter Frostblitz",
		["Improved Frostbrand Weapon"] = "Verbesserte Waffe des Frostbrands",
		["Improved Garrote"] = "Verbessertes Erdrosseln",
		["Improved Ghost Wolf"] = "Verbesserter Geisterwolf",
		["Improved Gouge"] = "Verbesserter Solarplexus",
		["Improved Grace of Air Totem"] = "Verbessertes Totem der luftgleichen Anmut",
		["Improved Grounding Totem"] = "Verbessertes Totem der Erdung",
		["Improved Hammer of Justice"] = "Verbesserter Hammer der Gerechtigkeit",
		["Improved Hamstring"] = "Verbesserte Kniesehne",
		["Improved Healing Stream Totem"] = "Verbessertes Totem des heilenden Flusses",
		["Improved Healing Touch"] = "Verbesserte Heilende Ber\195\188hrung",
		["Improved Healing Wave"] = "Verbesserte Welle der Heilung",
		["Improved Healing"] = "Verbesserte Heilung",
		["Improved Health Funnel"] = "Verbesserte Lebenslinie",
		["Improved Healthstone"] = "Verbesserter Gesundheitsstein",
		["Improved Heroic Strike"] = "Verbesserter Heldenhafter Sto\195\159",
		["Improved Hunter's Mark"] = "Verbessertes Mal des J\195\164gers",
		["Improved Immolate"] = "Verbesserter Feuerbrand",
		["Improved Imp"] = "Verbesserter Wichtel",
		["Improved Inner Fire"] = "Verbessertes Inneres Feuer",
		["Improved Instant Poison"] = "Verbessertes sofort wirkendes Gift",
		["Improved Intercept"] = "Verbessertes Abfangen",
		["Improved Intimidating Shout"] = "Verbesserter Drohruf",
		["Improved Judgement"] = "Verbessertes Richturteil",
		["Improved Kick"] = "Verbesserter Tritt",
		["Improved Kidney Shot"] = "Verbesserter Nierenhieb",
		["Improved Lash of Pain"] = "Verbesserte Schmerzenspeitsche",
		["Improved Lay on Hands"] = "Verbesserte Handauflegung",
		["Improved Lesser Healing Wave"] = "Verbesserte Geringe Welle der Heilung",
		["Improved Life Tap"] = "Verbesserter Aderlass",
		["Improved Lightning Bolt"] = "Verbesserter Blitzschlag",
		["Improved Lightning Shield"] = "Verbesserter Blitzschlag-Schild",
		["Improved Magma Totem"] = "Verbessertes Totem der gl\195\188henden Magma",
		["Improved Mana Burn"] = "Verbesserter Manabrand",
		["Improved Mana Shield"] = "Verbesserter Manaschild",
		["Improved Mana Spring Totem"] = "Verbessertes Totem der Manaquelle",
		["Improved Mark of the Wild"] = "Verbessertes Mal der Wildnis",
		["Improved Mend Pet"] = "Verbessertes Tier heilen",
		["Improved Mind Blast"] = "Verbesserter Gedankenschlag",
		["Improved Moonfire"] = "Verbessertes Mondfeuer",
		["Improved Nature's Grasp"] = "Verbesserter Griff der Natur",
		["Improved Overpower"] = "Verbessertes \195\156berw\195\164ltigen",
		["Improved Power Word: Fortitude"] = "Verbessertes Machtwort: Seelenst\195\164rke",
		["Improved Power Word: Shield"] = "Verbessertes Machtwort: Schild",
		["Improved Prayer of Healing"] = "Verbessertes Gebet der Heilung",
		["Improved Psychic Scream"] = "Verbesserter Psychischer Schrei",
		["Improved Pummel"] = "Verbessertes Zuschlagen",
		["Improved Regrowth"] = "Verbessertes Nachwachsen",
		["Improved Reincarnation"] = "Verbesserte Reinkarnation",
		["Improved Rejuvenation"] = "Verbesserte Verj\195\188ngung",
		["Improved Rend"] = "Verbessertes Verwunden",
		["Improved Renew"] = "Verbesserte Erneuerung",
		["Improved Retribution Aura"] = "Verbesserte Aura der Vergeltung",
		["Improved Revenge"] = "Verbesserte Rache",
		["Improved Revive Pet"] = "Verbessertes Tier wiederbeleben",
		["Improved Righteous Fury"] = "Verbesserter Zorn der Gerechtigkeit",
		["Improved Rockbiter Weapon"] = "Verbesserte Felsbei\195\159erwaffe",
		["Improved Rupture"] = "Verbesserte Blutung",
		["Improved Sap"] = "Verbesserte Kopfnuss",
		["Improved Scorch"] = "Verbessertes Versengen",
		["Improved Scorpid Sting"] = "Verbesserter Skorpidstich",
		["Improved Seal of Righteousness"] = "Verbessertes Siegel der Rechtschaffenheit",
		["Improved Seal of the Crusader"] = "Verbessertes Siegel des Kreuzfahrers",
		["Improved Searing Pain"] = "Verbesserter Sengender Schmerz",
		["Improved Searing Totem"] = "Verbessertes Totem der Verbrennung",
		["Improved Serpent Sting"] = "Verbesserter Schlangenbiss",
		["Improved Shadow Bolt"] = "Verbesserter Schattenblitz",
		["Improved Shadow Word: Pain"] = "Verbessertes Schattenwort: Schmerz",
		["Improved Shield Bash"] = "Verbesserter Schildhieb",
		["Improved Shield Block"] = "Verbesserter Schildblock",
		["Improved Shield Wall"] = "Verbesserter Schildwall",
		["Improved Shred"] = "Verbessertes Schreddern",
		["Improved Sinister Strike"] = "Verbesserter Finsterer Sto\195\159",
		["Improved Slam"] = "Verbessertes Zerschmettern",
		["Improved Slice and Dice"] = "Verbessertes Zerh\195\164ckseln",
		["Improved Spellstone"] = "Verbesserter Zauberstein",
		["Improved Sprint"] = "Verbessertes Sprinten",
		["Improved Starfire"] = "Verbessertes Sternenfeuer",
		["Improved Stoneclaw Totem"] = "Verbessertes Totem der Steinklaue",
		["Improved Stoneskin Totem"] = "Verbessertes Totem der Steinhaut",
		["Improved Strength of Earth Totem"] = "Verbessertes Totem der Erdst\195\164rke",
		["Improved Succubus"] = "Verbesserter Sukkubus",
		["Improved Sunder Armor"] = "Verbessertes R\195\188stung zerrei\195\159en",
		["Improved Taunt"] = "Verbesserter Spott",
		["Improved Thorns"] = "Verbesserte Dornen",
		["Improved Thunder Clap"] = "Verbesserter Donnerknall",
		["Improved Tranquility"] = "Verbesserte Gelassenheit",
		["Improved Vampiric Embrace"] = "Verbesserte Vampirumarmung",
		["Improved Vanish"] = "Verbessertes Verschwinden",
		["Improved Voidwalker"] = "Verbesserter Leerwandler",
		["Improved Windfury Weapon"] = "Verbesserte Waffe des Windfurors",
		["Improved Wing Clip"] = "Verbessertes Zurechtstutzen",
		["Improved Wrath"] = "Verbesserter Zorn",
		["Incinerate"] = "Verbrennen",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Inneres Feuer",
		["Inner Focus"] = "Innerer Fokus",
		["Innervate"] = "Anregen",
		["Insect Swarm"] = "Insektenschwarm",
		["Inspiration"] = "Inspiration",
		["Instant Poison II"] = "Sofort wirkendes Gift II",
		["Instant Poison III"] = "Sofort wirkendes Gift III",
		["Instant Poison IV"] = "Sofort wirkendes Gift IV",
		["Instant Poison V"] = "Sofort wirkendes Gift V",
		["Instant Poison VI"] = "Sofort wirkendes Gift VI",
		["Instant Poison"] = "Sofort wirkendes Gift",
		["Intensity"] = "Intensit\195\164t",
		["Intercept"] = "Abfangen",
		["Intercept Stun"] = "Betubung abfangen",
		["Intervene"] = "Einschreiten",
		["Intimidating Shout"] = "Drohruf",
		["Intimidation"] = "Einsch\195\188chterung",
		["Invisibility"] = "Unsichtbarkeit",
		["Iron Will"] = "Eiserner Wille",
		["Jewelcrafting"] = "Juwelenschleifen",
		["Judgement of Command"] = "Richturteil des Befehls",
		["Judgement of Justice"] = "Richturteil der Gerechtigkeit",
		["Judgement of Light"] = "Richturteil des Lichts",
		["Judgement of Righteousness"] = "Richturteil der Rechtschaffenheit",
		["Judgement of Wisdom"] = "Richturteil der Weisheit",
		["Judgement of the Crusader"] = "Richturteil des Kreuzfahrers",
		["Judgement"] = "Richturteil",
		["Kick"] = "Tritt",
		["Kick - Silenced"] = "Tritt - zum Schweigen gebracht",
		["Kidney Shot"] = "Nierenhieb",
		["Kill Command"] = "Fass!", 
		["Killer Instinct"] = "T\195\182tungstrieb",
		["Kodo Riding"] = "Kodoreiten",
		["Lacerate"] = "Aufschlitzen",
		["Lash of Pain"] = "Schmerzenspeitsche",
		["Last Stand"] = "Letztes Gefecht",
		["Lasting Judgement"] = "Dauerhaftes Richturteil",
		["Lay on Hands"] = "Handauflegung",
		["Leader of the Pack"] = "Rudelf\195\188hrer",
		["Leather"] = "Leder",
		["Leatherworking"] = "Lederverarbeitung",
		["Lesser Heal"] = "Geringes Heilen",
		["Lesser Healing Wave"] = "Geringe Welle der Heilung",
		["Lesser Invisibility"] = "Geringe Unsichtbarkeit",
		["Lethal Shots"] = "T\195\182dliche Sch\195\188sse",
		["Lethality"] = "T\195\182dlichkeit",
		["Levitate"] = "Levitieren",
		["Libram"] = "Buchband",
		["Lifebloom"] = "Bl\195\188hendes Leben",
		["Life Tap"] = "Aderlass",
		["Lightning Bolt"] = "Blitzschlag",
		["Lightning Breath"] = "Blitzschlagatem",
		["Lightning Mastery"] = "Blitzschlagbeherrschung",
		["Lightning Reflexes"] = "Blitzartige Reflexe",
		["Lightning Shield"] = "Blitzschlagschild",
		["Lightwell Renew"] = "Erneuerung des Lichtbrunnens",
		["Lightwell"] = "Brunnen des Lichts",
		["Lockpicking"] = "Schlossknacken",
		["Long Daze"] = "Lange Benommenheit",
		["Mace Specialization"] = "Streitkolben-Spezialisierung",
		["Mace Stun Effect"] = "Streitkolbenbet\195\164ubung-Effekt",
		["Mage Armor"] = "Magische R\195\188stung",
		["Magma Totem"] = "Totem der gl\195\188henden Magma",
		["Mail"] = "Panzer",
		["Maim"] = "Fleddern",
		["Malice"] = "T\195\188cke",
		["Mana Burn"] = "Manabrand",
		["Mana Shield"] = "Manaschild",
		["Mana Spring Totem"] = "Totem der Manaquelle",
		["Mana Tide Totem"] = "Totem der Manaflut",
		["Mangle"] = "Fleddern",
		["Mangle (Cat)"] = "Zerfleischen (Katze)",
		["Mangle (Bear)"] = "Zerfleischen (B\195\164r)",
		["Mark of the Wild"] = "Mal der Wildnis",
		["Martyrdom"] = "M\195\164rtyrertum",
		["Mass Dispel"] = "Massenbannung",
		["Master Demonologist"] = "Meister der D\195\164monologie",
		["Master Summoner"] = "Meister der Beschw\195\182rung",
		["Master of Deception"] = "Meister der T\195\164uschung",
		["Maul"] = "Zermalmen",
		["Mechanostrider Piloting"] = "Roboschreiter-Lenken",
		["Meditation"] = "Meditation",
		["Melee Specialization"] = "Nahkampf-Spezialisierung",
		["Mend Pet"] = "Tier heilen",
		["Mental Agility"] = "Mentale Beweglichkeit",
		["Mental Strength"] = "Mentale St\195\164rke",
		["Mind Blast"] = "Gedankenschlag",
		["Mind Control"] = "Gedankenkontrolle",
		["Mind Flay"] = "Gedankenschinden",
		["Mind Soothe"] = "Gedankenbes\195\164nftigung",
		["Mind Vision"] = "Gedankensicht",
		["Mind-numbing Poison II"] = "Gedankenbenebelndes Gift II",
		["Mind-numbing Poison III"] = "Gedankenbenebelndes Gift III",
		["Mind-numbing Poison"] = "Gedankenbenebelndes Gift",
		["Mining"] = "Bergbau",
		["Misdirection"] = "Irref\195\188hrung",
		["Mocking Blow"] = "Sp\195\182ttischer Schlag",
		["Molten Armor"] = "Gl\195\188hende R\195\188stung",
		["Mongoose Bite"] = "Mungobiss",
		["Monster Slaying"] = "Monstert\195\182ten",
		["Moonfire"] = "Mondfeuer",
		["Moonfury"] = "Mondfuror",
		["Moonglow"] = "Mondschein",
		["Moonkin Aura"] = "Aura des Moonkin",
		["Moonkin Form"] = "Moonkingestalt",
		["Mortal Shots"] = "Todbringende Sch\195\188sse",
		["Mortal Strike"] = "T\195\182dlicher Sto\195\159",
		["Multi-Shot"] = "Mehrfachschuss",
		["Murder"] = "Mord",
		["Mutilate"] = "Verst\195\188mmeln",
		["Natural Armor"] = "Nat\195\188rliche R\195\188stung",
		["Natural Shapeshifter"] = "Schnellwandlung",
		["Natural Weapons"] = "Waffenbalance",
		["Nature Resistance Totem"] = "Totem des Naturwiderstands",
		["Nature Resistance"] = "Naturwiderstand",
		["Nature's Focus"] = "Naturfokus",
		["Nature's Grace"] = "Anmut der Natur",
		["Nature's Grasp"] = "Griff der Natur",
		["Nature's Reach"] = "Reichweite der Natur",
		["Nature's Swiftness"] = "Schnelligkeit der Natur",
		["Nightfall"] = "Einbruch der Nacht",
		["Omen of Clarity"] = "Omen der Klarsicht",
		["One-Handed Axes"] = "Einhand\195\164xte",
		["One-Handed Maces"] = "Einhandstreitkolben",
		["One-Handed Swords"] = "Einhandschwerter",
		["One-Handed Weapon Specialization"] = "Einhandwaffen-Spezialisierung",
		["Opening - No Text"] = "\195\150ffnen - Kein Text",
		["Opening"] = "\195\150ffnen",
		["Opportunity"] = "G\195\188nstige Gelegenheit",
		["Overpower"] = "\195\156berw\195\164ltigen",
		["Pain Suppression"] = "Schmerzunterdr\195\188ckung",
		["Paranoia"] = "Paranoia",
		["Parry"] = "Parieren",
		["Pathfinding"] = "Orientierung",
		["Perception"] = "Wachsamkeit",
		["Permafrost"] = "Dauerfrost",
		["Pet Aggression"] = "Tieraggression",
		["Pet Hardiness"] = "Tier-Widerstandskraft",
		["Pet Recovery"] = "Tiererholung",
		["Pet Resistance"] = "Tier-Widerstand",
		["Phase Shift"] = "Phasenverschiebung",
		["Pick Lock"] = "Schloss knacken",
		["Pick Pocket"] = "Taschendiebstahl",
		["Piercing Howl"] = "Durchdringendes Heulen",
		["Piercing Ice"] = "Stechendes Eis",
		["Plate Mail"] = "Plattenpanzer",
		["Poison Cleansing Totem"] = "Totem der Giftreinigung",
		["Poisons"] = "Gifte",
		["Polearm Specialization"] = "Stangenwaffen-Spezialisierung",
		["Polearms"] = "Stangenwaffen",
		["Polymorph"] = "Verwandlung",
		["Polymorph: Pig"] = "Verwandlung: Schwein",
		["Polymorph: Turtle"] = "Verwandlung: Schildkr\195\182te",
		["Portal: Darnassus"] = "Portal: Darnassus",
		["Portal: Ironforge"] = "Portal: Ironforge",
		["Portal: Orgrimmar"] = "Portal: Orgrimmar",
		["Portal: Stormwind"] = "Portal: Stormwind",
		["Portal: Thunder Bluff"] = "Portal: Thunder Bluff",
		["Portal: Undercity"] = "Portal: Undercity",
		["Pounce Bleed"] = "Anspringblutung",
		["Pounce"] = "Anspringen",
		["Power Infusion"] = "Seele der Macht",
		["Power Word: Fortitude"] = "Machtwort: Seelenst\195\164rke",
		["Power Word: Shield"] = "Machtwort: Schild",
		["Prayer of Fortitude"] = "Gebet der Seelenst\195\164rke",
		["Prayer of Healing"] = "Gebet der Heilung",
		["Prayer of Mending"] = "Best\195\164ndige Heilung",
		["Prayer of Shadow Protection"] = "Gebet des Schattenschutzes",
		["Prayer of Spirit"] = "Gebet der Willenskraft",
		["Precision"] = "Pr\195\164zision",
		["Predatory Strikes"] = "Raubtierschl\195\164ge",
		["Premeditation"] = "Konzentration",
		["Preparation"] = "Vorbereitung",
		["Presence of Mind"] = "Geistesgegenwart",
		["Primal Fury"] = "Urfuror",
		["Prowl"] = "Schleichen",
		["Psychic Scream"] = "Psychischer Schrei",
		["Pummel"] = "Zuschlagen",
		["Purge"] = "Reinigen",
		["Purification"] = "L\195\164uterung",
		["Purify"] = "L\195\164utern",
		["Pursuit of Justice"] = "Streben nach Gerechtigkeit",
		["Pyroblast"] = "Pyroschlag",
		["Pyroclasm"] = "Feuerschwall",
		["Quick Shots"] = "Schnelle SchÃ¼sse",
		["Quickness"] = "Schnelligkeit",
		["Rain of Fire"] = "Feuerregen",
		["Rake"] = "Krallenhieb",
		["Rampage"] = "Toben",
		["Ram Riding"] = "Widderreiten",
		["Ranged Weapon Specialization"] = "Distanzwaffen-Spezialisierung",
		["Rapid Concealment"] = "Schnelles Verstecken",
		["Rapid Fire"] = "Schnellfeuer",
		["Raptor Riding"] = "Raptorreiten",
		["Raptor Strike"] = "Raptorsto\195\159",
		["Ravage"] = "Verheeren",
		["Readiness"] = "Bereitschaft",
		["Rebirth"] = "Wiedergeburt",
		["Reckless Charge"] = "Tollk?nes St?men",
		["Recklessness"] = "Tollk\195\188hnheit",
		["Reckoning"] = "Abrechnung",
		["Redemption"] = "Erl\195\182sung",
		["Redoubt"] = "Verschanzen",
		["Reflection"] = "Reflexion",
		["Regeneration"] = "Regeneration",
		["Regrowth"] = "Nachwachsen",
		["Reincarnation"] = "Reinkarnation",
		["Rejuvenation"] = "Verj\195\188ngung",
		["Relentless Strikes"] = "Unerbittliche St\195\182\195\159e",
		["Remorseless"] = "Gnadenlos",
		["Remorseless Attacks"] = "Gnadenlose Angriffe",
		["Remove Curse"] = "Fluch aufheben",
		["Remove Insignia"] = "Abzeichen entfernen",
		["Remove Lesser Curse"] = "Geringen Fluch aufheben",
		["Rend"] = "Verwunden",
		["Renew"] = "Erneuerung",
		["Repentance"] = "Bu\195\159e",
		["Resurrection"] = "Auferstehung",
		["Retaliation"] = "Gegenschlag",
		["Retribution Aura"] = "Aura der Vergeltung",
		["Revenge Stun"] = "Rachebet\195\164ubung",
		["Revenge"] = "Rache",
		["Reverberation"] = "Nachklingen",
		["Revive Pet"] = "Tier wiederbeleben",
		["Righteous Defense"] = "Rechtschaffene Verteidigung",
		["Righteous Fury"] = "Zorn der Gerechtigkeit",
		["Rip"] = "Zerfetzen",
		["Riposte"] = "Riposte",
		["Ritual of Doom Effect"] = "Ritual der Verdammnis'-Effekt",
		["Ritual of Doom"] = "Ritual der Verdammnis",
		["Ritual of Souls"] = "Ritual der Seelen",
		["Ritual of Summoning"] = "Ritual der Beschw\195\182rung",
		["Rockbiter Weapon"] = "Felsbei\195\159erwaffe",
		["Rogue Passive"] = "Schurke Passiv",
		["Ruin"] = "Verderben",
		["Rupture"] = "Blutung",
		["Ruthlessness"] = "Skrupellosigkeit",
		["Sacrifice"] = "Opferung",
		["Safe Fall"] = "Sicheres Fallen",
		["Sanctity Aura"] = "Aura der Heiligkeit",
		["Sap"] = "Kopfnuss",
		["Savage Fury"] = "Ungez\195\164hmte Wut",
		["Savage Strikes"] = "Wilde Schl\195\164ge",
		["Scare Beast"] = "Wildtier \195\164ngstigen",
		["Scatter Shot"] = "Streuschuss",
		["Scorch"] = "Versengen",
		["Scorpid Poison"] = "Skorpidgift",
		["Scorpid Sting"] = "Skorpidstich",
		["Screech"] = "Schrei",
		["Seal Fate"] = "Schicksal besiegeln",
		["Seal of Blood"] = "Siegel des Blutes",
		["Seal of Command"] = "Siegel des Befehls",
		["Seal of Justice"] = "Siegel der Gerechtigkeit",
		["Seal of Light"] = "Siegel des Lichts",
		["Seal of Righteousness"] = "Siegel der Rechtschaffenheit",
		["Seal of Wisdom"] = "Siegel der Weisheit",
		["Seal of the Crusader"] = "Siegel des Kreuzfahrers",
		["Seal of Vengeance"] = "Siegel der Vergeltung",
		["Searing Light"] = "Sengendes Licht",
		["Searing Pain"] = "Sengender Schmerz",
		["Searing Totem"] = "Totem der Verbrennung",
		["Second Wind"] = "Kr\195\164fte sammeln",
		["Seduction"] = "Verf\195\188hrung",
		["Seed of Corruption"] = "Saat der Verderbnis",
		["Sense Demons"] = "D\195\164monen sp\195\188ren",
		["Sense Undead"] = "Untote sp\195\188ren",
		["Sentry Totem"] = "Totem des Wachens",
		["Serpent Sting"] = "Schlangenbiss",
		["Setup"] = "Reinlegen",
		["Shackle Undead"] = "Untote fesseln",
		["Shadow Affinity"] = "Schattenaffinit\195\164t",
		["Shadow Bolt"] = "Schattenblitz",
		["Shadow Focus"] = "Schattenfokus",
		["Shadow Mastery"] = "Schattenbeherrschung",
		["Shadow Protection"] = "Schattenschutz",
		["Shadow Reach"] = "Schattenreichweite",
		["Shadow Resistance Aura"] = "Aura des Schattenwiderstands",
		["Shadow Resistance"] = "Schattenwiderstand",
		["Shadow Trance"] = "Schattentrance",
		["Shadow Vulnerability"] = "Schattenverwundbarkeit",
		["Shadow Ward"] = "Schattenzauberschutz",
		["Shadow Weaving"] = "Schattenwirken",
		["Shadow Word: Death"] = "Schattenwort: Tod",
		["Shadow Word: Pain"] = "Schattenwort: Schmerz",
		["Shadowburn"] = "Schattenbrand",
		["Shadowfiend"] = "Schattengeist",
		["Shadowform"] = "Schattengestalt",
		["Shadowfury"] = "Schattenfurie",
		["Shadowguard"] = "Schattenschild",
		["Shadowmeld Passive"] = "Schattenmimik Passiv",
		["Shadowmeld"] = "Schattenhaftigkeit",
		["Shadowstep"] = "Schattenschritt",
		["Shamanistic Rage"] = "Schamanistische Wut",
		["Sharpened Claws"] = "Gesch\195\164rfte Klauen",
		["Shatter"] = "Zertr\195\188mmern",
		["Shell Shield"] = "Panzerschild",
		["Shield Bash"] = "Schildhieb",
		["Shield Bash - Silenced"] = "Schildhieb - zum Schweigen gebracht",
		["Shield Block"] = "Schildblock",
		["Shield Slam"] = "Schildschlag",
		["Shield Specialization"] = "Schild-Spezialisierung",
		["Shield Wall"] = "Schildwall",
		["Shield"] = "Schild",
		["Shiv"] = "T\195\188ckische Klinge",
		["Shoot Bow"] = "Bogenschuss",
		["Shoot Crossbow"] = "Armbrust abschie\195\159en",
		["Shoot Gun"] = "Schusswaffe abfeuern",
		["Shoot"] = "Schie\195\159en",
		["Shred"] = "Schreddern",
		["Silence"] = "Stille",
		["Silencing Shot"] = "Schweigeschuss",
		["Silent Resolve"] = "Schweigsame Entschlossenheit",
		["Sinister Strike"] = "Finsterer Sto\195\159",
		["Siphon Life"] = "Lebensentzug",
		["Skinning"] = "K\195\188rschnerei",
		["Slam"] = "Zerschmettern",
		["Sleep"] = "Schlaf",
		["Slice and Dice"] = "Zerh\195\164ckseln",
		["Slow"] = "Verlangsamen",
		["Slow Fall"] = "Langsamer Fall",
		["Smelting"] = "Verh\195\188ttung",
		["Smite"] = "G\195\182ttliche Pein",
		["Snake Trap"] = "Schlangenfalle",
		["Solid Sharpening Stone"] = "Robuster Wetzstein", 		
		["Soothe Animal"] = "Tier bes\195\164nftigen",
		["Soothing Kiss"] = "Bes\195\164nftigender Kuss",
		["Soul Fire"] = "Seelenfeuer",
		["Soul Link"] = "Seelenverbindung",
		["Soul Siphon"] = "Seelen-Siphon",
		["Soulshatter"] = "Seele brechen",
		["Soulstone Resurrection"] = "Seelenstein-Auferstehung",
		["Spell Lock"] = "Zaubersperre",
		["Spellsteal"] = "Zauberraub",
		["Spell Reflection"] = "Zauberreflexion",
		["Spell Warding"] = "Zauberschutz",
		["Spirit Bond"] = "Geistbande",
		["Spirit Tap"] = "Willensentzug",
		["Spirit of Redemption"] = "Geist der Erl\195\182sung",
		["Spiritual Attunement"] = "Einklang des Geistes",
		["Spiritual Focus"] = "Spiritueller Fokus",
		["Spiritual Guidance"] = "Geistige F\195\188hrung",
		["Spiritual Healing"] = "Spirituelle Heilung",
		["Sprint"] = "Sprinten",
		["Stance Mastery"] = "Haltung bewahren",
		["Starfire"] = "Sternenfeuer",
		["Starfire Stun"] = "Sternenfeuer-Betubung",
		["Starshards"] = "Sternensplitter",
		["Staves"] = "St\195\164be",
		["Steady Shot"] = "Zuverl\195\164ssiger Schuss",
		["Stealth"] = "Verstohlenheit",
		["Stoneclaw Totem"] = "Totem der Steinklaue",
		["Stoneform"] = "Steingestalt",
		["Stoneskin Totem"] = "Totem der Steinhaut",
		["Stormstrike"] = "Sturmschlag",
		["Strength of Earth Totem"] = "Totem der Erdst\195\164rke",
		["Stuck"] = "Feststecken",
		["Subtlety"] = "Feingef\195\188hl",
		["Suffering"] = "Leiden",
		["Summon Charger"] = "Streitross beschw\195\182ren",
		["Summon Dreadsteed"] = "Schreckensross herbeirufen",
		["Summon Felguard"] = "Teufelswache beschw\195\182ren",
		["Summon Felhunter"] = "Teufelsj\195\164ger beschw\195\182ren",
		["Summon Felsteed"] = "Teufelsross beschw\195\182ren",
		["Summon Imp"] = "Wichtel beschw\195\182ren",
		["Summon Succubus"] = "Sukkubus beschw\195\182ren",
		["Summon Voidwalker"] = "Leerwandler beschw\195\182ren",
		["Summon Warhorse"] = "Schlachtross beschw\195\182ren",
		["Summon Water Elemental"] = "Wasserelementar beschw\195\182ren",
		["Sunder Armor"] = "R\195\188stung zerrei\195\159en",
		["Suppression"] = "Unterdr\195\188ckung",
		["Surefooted"] = "Sicherer Stand",
		["Survivalist"] = "\195\156berlebensk\195\188nstler",
		["Sweeping Strikes"] = "Weitreichende St\195\182\195\159e",
		["Swiftmend"] = "Rasche Heilung",
		["Swipe"] = "Prankenhieb",
		["Sword Specialization"] = "Schwert-Spezialisierung",
		["Tactical Mastery"] = "Taktiker",
		["Tainted Blood"] = "Besudeltes Blut",
		["Tailoring"] = "Schneiderei",
		["Tame Beast"] = "Wildtier z\195\164hmen",
		["Tamed Pet Passive"] = "Gez\195\164hmtes Tier - Passiv",
		["Taunt"] = "Spott",
		["Teleport: Darnassus"] = "Teleportieren: Darnassus",
		["Teleport: Ironforge"] = "Teleportieren: Ironforge",
		["Teleport: Moonglade"] = "Teleportieren: Moonglade",
		["Teleport: Orgrimmar"] = "Teleportieren: Orgrimmar",
		["Teleport: Stormwind"] = "Teleportieren: Stormwind",
		["Teleport: Thunder Bluff"] = "Teleportieren: Thunder Bluff",
		["Teleport: Undercity"] = "Teleportieren: Undercity",
		["The Beast Within"] = "Wildes Herz",
		["The Human Spirit"] = "Unbeugsamkeit",
		["Thick Hide"] = "Dickes Fell",
		["Thorns"] = "Dornen",
		["Throw"] = "Werfen",
		["Throwing Specialization"] = "Wurfwaffen-Spezialisierung",
		["Throwing Weapon Specialization"] = "Wurfwaffen-Spezialisierung",
		["Thrown"] = "Wurfwaffe",
		["Thunder Clap"] = "Donnerknall",
		["Thundering Strikes"] = "Donnernde St\195\182\195\159e",
		["Thunderstomp"] = "Donnerstampfer",
		["Tidal Focus"] = "Gezeitenfokus",
		["Tidal Mastery"] = "Gezeitenbeherrschung",
		["Tiger Riding"] = "Tigerreiten",
		["Tiger's Fury"] = "Tigerfuror",
		["Torment"] = "Qual",
		["Totem"] = "Totem",
		["Totem of Wrath"] = "Totem des Ingrimms",
		["Totemic Focus"] = "Totemfokus",
		["Touch of Weakness"] = "Ber\195\188hrung der Schw\195\164che",
		["Toughness"] = "Z\195\164higkeit",
		["Track Beasts"] = "Wildtiere aufsp\195\188ren",
		["Track Demons"] = "D\195\164monen aufsp\195\188ren",
		["Track Dragonkin"] = "Drachkin aufsp\195\188ren",
		["Track Elementals"] = "Elementare aufsp\195\188ren",
		["Track Giants"] = "Riesen aufsp\195\188ren",
		["Track Hidden"] = "Verborgenes aufsp\195\188ren",
		["Track Humanoids"] = "Humanoide aufsp\195\188ren",
		["Track Undead"] = "Untote aufsp\195\188ren",
		["Tranquil Air Totem"] = "Totem der beruhigenden Winde",
		["Tranquil Spirit"] = "Gelassener Geist",
		["Tranquility"] = "Gelassenheit",
		["Tranquilizing Shot"] = "Einlullender Schuss",
		["Trap Mastery"] = "Fallenbeherrschung",
		["Travel Form"] = "Reisegestalt",
		["Tree of Life"] = "Baum des Lebens",
		["Tremor Totem"] = "Totem des Erdsto\195\159es",
		["Tribal Leatherworking"] = "Stammeslederverarbeitung",
		["Trueshot Aura"] = "Aura des Volltreffers",
		["Turn Undead"] = "Untote vertreiben",
		["Two-Handed Axes and Maces"] = "Zweihand\195\164xte und -Streitkolben",
		["Two-Handed Axes"] = "Zweihand\195\164xte",
		["Two-Handed Maces"] = "Zweihandstreitkolben",
		["Two-Handed Swords"] = "Zweihandschwerter",
		["Two-Handed Weapon Specialization"] = "Zweihandwaffen-Spezialisierung",
		["Unarmed"] = "Unbewaffnet",
		["Unbreakable Will"] = "Unbezwingbarer Wille",
		["Unbridled Wrath Effect"] = "Entfesselter Zorn'-Effekt",
		["Unbridled Wrath"] = "Entfesselter Zorn",
		["Undead Horsemanship"] = "Untotenreitkunst",
		["Underwater Breathing"] = "Unterwasseratmung",
		["Unending Breath"] = "Unendlicher Atem",
		["Unholy Power"] = "Unheilige Macht",
		["Unleashed Fury"] = "Entfesselter Zorn",
		["Unleashed Rage"] = "Entfesselte Wut",
		["Unstable Affliction"] = "Instabiles Gebrechen",
		["Unyielding Faith"] = "Unumst\195\182\195\159licher Glaube",
		["Vampiric Embrace"] = "Vampirumarmung",
		["Vanish"] = "Verschwinden",
		["Vanished"] = "Verschwunden",
		["Vampiric Touch"] = "Vampirber\195\188hrung",
		["Vengeance"] = "Rache",
		["Victory Rush"] = "Siegesrausch",
		["Vigor"] = "Lebenskraft",
		["Vile Poisons"] = "\195\156ble Gifte",
		["Vindication"] = "Rechtschaffene Schw\195\164chung",
		["Viper Sting"] = "Vipernbiss",
		["Volley"] = "Salve",
		["Wand Specialization"] = "Zauberstab-Spezialisierung",
		["Wands"] = "Zauberst\195\164be",
		["War Stomp"] = "Kriegsdonner",
		["Water Breathing"] = "Wasseratmung",
		["Water Shield"] = "Wasserschild",
		["Water Walking"] = "Wasserwandeln",
		["Waterbolt"] =	"Wasserblitz",
		["Weakened Soul"] = "GeschwÃ¤chte Seele",
		["Weaponsmith"] = "Waffenschmied",
		["Whirlwind"] = "Wirbelwind",
		["Will of the Forsaken"] = "Wille der Verlassenen",
		["Windfury Totem"] = "Totem des Windzorns",
		["Windfury Weapon"] = "Waffe des Windfurors",
		["Windwall Totem"] = "Totem der Windmauer",
		["Wing Clip"] = "Zurechtstutzen",
		["Winter's Chill"] = "Winterk\195\164lte",
		["Wisp Spirit"] = "Irrwisch-Geist",
		["Wolf Riding"] = "Wolfreiten",
		["Wound Poison II"] = "Wundgift II",
		["Wound Poison III"] = "Wundgift III",
		["Wound Poison IV"] = "Wundgift IV",
		["Wound Poison"] = "Wundgift",
		["Wrath"] = "Zorn",
		["Wrath of Air Totem"] = "Totem des st\195\188rmischen Zorns",
		["Wyvern Sting"] = "Stich des Fl\195\188geldrachen",
	}
end)

BabbleSpell:RegisterTranslations("frFR", function()
	return {
		["Abolish Disease"] = "Abolir maladie",
		["Abolish Poison Effect"] = "Effet Abolir le poison",
		["Abolish Poison"] = "Abolir le poison",
		["Activate MG Turret"] = "Activation de la tourelle de mitrailleuse",
		["Adrenaline Rush"] = "Pouss\195\169e d'adr\195\169naline",
		["Aftermath"] = "Cons\195\169quences",
		["Aggression"] = "Agressivit\195\169",
		["Aimed Shot"] = "Vis\195\169e",
		["Alchemy"] = "Alchimie",
		["Ambush"] = "Embuscade",
		["Amplify Curse"] = "Mal\195\169diction amplifi\195\169e",
		["Amplify Magic"] = "Amplification de la magie",
		["Ancestral Fortitude"] = "Robustesse des anciens",
		["Ancestral Healing"] = "Gu\195\169rison des anciens",
		["Ancestral Knowledge"] = "Connaissance ancestrale",
		["Ancestral Spirit"] = "Esprit ancestral",
		["Anesthetic Poison"] = "Poison anesth\195\169siant",
		["Anger Management"] = "Ma\195\174trise de la Rage",
		["Anguish"] = "Angoisse",
		["Anticipation"] = "Anticipation",
		["Aquatic Form"] = "Forme aquatique",
		["Arcane Blast"] = "D\195\169flagration des arcanes",
		["Arcane Brilliance"] = "Illumination des arcanes",
		["Arcane Concentration"] = "Concentration des arcanes",
		["Arcane Explosion"] = "Explosion des arcanes",
		["Arcane Focus"] = "Focalisation des arcanes",
		["Arcane Instability"] = "Instabilit\195\169 des arcanes",
		["Arcane Intellect"] = "Intelligence des arcanes",
		["Arcane Meditation"] = "M\195\169ditation des arcanes",
		["Arcane Mind"] = "Esprit des arcanes",
		["Arcane Missiles"] = "Projectiles des arcanes",
		["Arcane Power"] = "Pouvoir des arcanes",
		["Arcane Resistance"] = "R\195\169sistance aux Arcanes",
		["Arcane Shot"] = "Tir des arcanes",
		["Arcane Subtlety"] = "Subtilit\195\169 des arcanes",
		["Arctic Reach"] = "Allonge arctique",
		["Armorsmith"] = "Fabricant d'armures",
		["Aspect of the Beast"] = "Aspect de la b\195\170te",
		["Aspect of the Cheetah"] = "Aspect du gu\195\169pard",
		["Aspect of the Hawk"] = "Aspect du faucon",
		["Aspect of the Monkey"] = "Aspect du singe",
		["Aspect of the Pack"] = "Aspect de la meute",
		["Aspect of the Viper"] = "Aspect de la vip\195\168re",
		["Aspect of the Wild"] = "Aspect de la nature",
		["Astral Recall"] = "Rappel astral",
		["Attack"] = "Attaque",
		["Attacking"] = "Attaque",
		["Auto Shot"] = "Tir automatique",
		["Avenger's Shield"] = "Bouclier du vengeur",
		["Avenging Wrath"] = "Courroux vengeur",
		["Avoidance"] = "Evitement",
		["Axe Specialization"] = "Sp\195\169cialisation Hache",
		["Backlash"] = "Contrecoup",
		["Backstab"] = "Attaque sournoise",
		["Bane"] = "Fl\195\169au",
		["Banish"] = "Bannir",
		["Barkskin Effect"] = "Effet Ecorce",
		["Barkskin"] = "Ecorce",
		["Barrage"] = "Barrage",
		["Bash"] = "Sonner",
		["Basic Campfire"] = "Feu de camp basique",
		["Battle Shout"] = "Cri de guerre",
		["Battle Stance Passive"] = "Posture de combat",
		["Battle Stance"] = "Posture de combat",
		["Bear Form"] = "Forme d'ours",
		["Beast Lore"] = "Connaissance des b\195\170tes",
		["Beast Slaying"] = "Tueur de b\195\170tes",
		["Beast Training"] = "Apprivoisement",
		["Benediction"] = "B\195\169n\195\169diction",
		["Berserker Rage"] = "Rage berserker",
		["Berserker Stance Passive"] = "Posture berserker",
		["Berserker Stance"] = "Posture berserker",
		["Berserking"] = "Berserker",
		["Bestial Discipline"] = "Discipline bestiale",
		["Bestial Swiftness"] = "Rapidit\195\169 bestiale",
		["Bestial Wrath"] = "Courroux bestial",
		["Binding Heal"] = "Soins de lien",
		["Bite"] = "Morsure",
		["Black Arrow"] = "Fl\195\168che noire",
		["Blackout"] = "Aveuglement",
		["Blacksmithing"] = "Forge",
		["Blade Flurry"] = "D\195\169luge de lames",
		["Blast Wave"] = "Vague explosive",
		["Blazing Speed"] = "Vitesse flamboyante",
		["Blessed Recovery"] = "R\195\169tablissement b\195\169ni",
		["Blessing of Freedom"] = "B\195\169n\195\169diction de libert\195\169",
		["Blessing of Kings"] = "B\195\169n\195\169diction des rois",
		["Blessing of Light"] = "B\195\169n\195\169diction de lumi\195\168re",
		["Blessing of Might"] = "B\195\169n\195\169diction de puissance",
		["Blessing of Protection"] = "B\195\169n\195\169diction de protection",
		["Blessing of Sacrifice"] = "B\195\169n\195\169diction de sacrifice",
		["Blessing of Salvation"] = "B\195\169n\195\169diction de salut",
		["Blessing of Sanctuary"] = "B\195\169n\195\169diction du sanctuaire",
		["Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse",
		["Blind"] = "C\195\169cit\195\169",
		["Blinding Powder"] = "Poudre aveuglante",
		["Blink"] = "Transfert",
		["Blizzard"] = "Blizzard",
		["Block"] = "Bloquer",
		["Blood Craze"] = "Folie sanguinaire",
		["Blood Frenzy"] = "Fr\195\169n\195\169sie sanglante",
		["Blood Fury"] = "Fureur sanguinaire",
		["Blood Pact"] = "Pacte de sang",
		["Bloodlust"] = "Furie sanguinaire",
		["Bloodrage"] = "Rage sanguinaire",
		["Bloodthirst"] = "Sanguinaire",
		["Booming Voice"] = "Voix tonitruante",
		["Bow Specialization"] = "Sp\195\169cialisation Arc",
		["Bows"] = "Arcs",
		["Bright Campfire"] = "Feu de camp \195\169clatant",
		["Brutal Impact"] = "Impact brutal",
		["Burning Soul"] = "Ame ardente",
		["Call Pet"] = "Appel du familier",
		["Call of Flame"] = "Appel des flammes",
		["Call of Thunder"] = "Appel de la foudre",
		["Camouflage"] = "Dissimulation",
		["Cannibalize"] = "Cannibalisme",
		["Cat Form"] = "Forme de f\195\169lin",
		["Cataclysm"] = "Cataclysme",
		["Chain Heal"] = "Salve de gu\195\169rison",
		["Chain Lightning"] = "Cha\195\174ne d'\195\169clairs",
		["Challenging Roar"] = "Rugissement provocateur",
		["Challenging Shout"] = "Cri de d\195\169fi",
		["Charge Rage Bonus Effect"] = "Effet Bonus de Rage de la Charge",
		["Charge"] = "Charge",
		["Charge Stun"] = "Charge \195\169tourdissante",
		["Cheap Shot"] = "Coup bas",
		["Chilled"] = "Transi",
		["Circle of Healing"] = "Cercle de soins",
		["Claw"] = "Griffe",
		["Cleanse"] = "Epuration",
		["Clearcasting"] = "Id\195\169es claires",
		["Cleave"] = "Encha\195\174nement",
		["Clever Traps"] = "Pi\195\168ges astucieux",
		["Cloak of Shadows"] = "Cape d'ombre",
		["Closing"] = "Fermeture",
		["Cloth"] = "Tissu",
		["Coarse Sharpening Stone"] = "Pierre \195\160 aiguiser grossi\195\168re",
		["Cobra Reflexes"] = "R\195\169flexes du cobra",
		["Cold Blood"] = "Sang froid",
		["Cold Snap"] = "Morsure de glace",
		["Combat Endurance"] = "Endurance de combat",
		["Combustion"] = "Combustion",
		["Command"] = "Commande",
		["Commanding Shout"] = "Cri de commandement",
		["Concentration Aura"] = "Aura de concentration",
		["Concussion Blow"] = "Bourrasque",
		["Concussion"] = "Commotion",
		["Concussive Shot"] = "Trait de choc",
		["Cone of Cold"] = "C\195\180ne de froid",
		["Conflagrate"] = "Conflagration",
		["Conjure Food"] = "Invocation de nourriture",
		["Conjure Mana Agate"] = "Invocation d'une agate de mana",
		["Conjure Mana Citrine"] = "Invocation d'une citrine de mana",
		["Conjure Mana Jade"] = "Invocation d'une jade de mana",
		["Conjure Mana Ruby"] = "Invocation d'un rubis de mana",
		["Conjure Water"] = "Invocation d'eau",
		["Consecrated Sharpening Stone"] = "Pierre \195\160 aiguiser consacr\195\169e",
		["Consecration"] = "Cons\195\169cration",
		["Consume Magic"] = "Consumer la magie",
		["Consume Shadows"] = "Consumer les ombres",
		["Convection"] = "Convection",
		["Conviction"] = "Conviction",
		["Cooking"] = "Cuisine",
		["Corruption"] = "Corruption",
		["Counterattack"] = "Contre-attaque",
		["Counterspell"] = "Contresort",
		["Counterspell - Silenced"] = "Contresort - Silencieux",
		["Cower"] = "D\195\169robade",
		["Create Firestone"] = "Cr\195\169ation de Pierre de feu",
		["Create Firestone (Major)"] = "Cr\195\169ation de Pierre de feu (majeure)",
		["Create Firestone (Greater)"] = "Cr\195\169ation de Pierre de feu (sup\195\169rieure)",
		["Create Firestone (Lesser)"] = "Cr\195\169ation de Pierre de feu (inf\195\169rieure)",
		["Create Healthstone"] = "Cr\195\169ation de Pierre de soins",
		["Create Healthstone (Major)"] = "Cr\195\169ation de Pierre de soins (majeure)",
		["Create Healthstone (Greater)"] = "Cr\195\169ation de Pierre de soins (sup\195\169rieure)",
		["Create Healthstone (Lesser)"] = "Cr\195\169ation de Pierre de soins (inf\195\169rieure)",
		["Create Healthstone (Minor)"] = "Cr\195\169ation de Pierre de soins (mineure)",
		["Create Soulstone"] = "Cr\195\169ation de Pierre d'\195\162me",
		["Create Soulstone (Major)"] = "Cr\195\169ation de Pierre d'\195\162me (majeure)",
		["Create Soulstone (Greater)"] = "Cr\195\169ation de Pierre d'\195\162me (sup\195\169rieure)",
		["Create Soulstone (Lesser)"] = "Cr\195\169ation de Pierre d'\195\162me (inf\195\169rieure)",
		["Create Soulstone (Minor)"] = "Cr\195\169ation de Pierre d'\195\162me (mineure)",
		["Create Spellstone"] = "Cr\195\169ation de Pierre de sort",
		["Create Spellstone (Master)"] = "Cr\195\169ation de Pierre de sort (magistrale)",
		["Create Spellstone (Major)"] = "Cr\195\169ation de Pierre de sort (majeure)",
		["Create Spellstone (Greater)"] = "Cr\195\169ation de Pierre de sort (sup\195\169rieure)",
		["Crippling Poison II"] = "Poison affaiblissant II",
		["Crippling Poison"] = "Poison affaiblissant",
		["Critical Mass"] = "Masse critique",
		["Crossbows"] = "Arbal\195\168tes",
		["Cruelty"] = "Cruaut\195\169",
		["Crusader Aura"] = "Aura de crois\195\169",
		["Crusader Strike"] = "Inquisition",
		["Cultivation"] = "Culture",
		["Cure Disease"] = "Gu\195\169rison des maladies",
		["Cure Poison"] = "Gu\195\169rison du poison",
		["Curse of Agony"] = "Mal\195\169diction d'agonie",
		["Curse of Doom Effect"] = "Effet Mal\195\169diction funeste",
		["Curse of Doom"] = "Mal\195\169diction funeste",
		["Curse of Exhaustion"] = "Mal\195\169diction de fatigue",
		["Curse of Idiocy"] = "Mal\195\169diction d'idiotie",
		["Curse of Recklessness"] = "Mal\195\169diction de t\195\169m\195\169rit\195\169",
		["Curse of Shadow"] = "Mal\195\169diction de l'ombre",
		["Curse of Tongues"] = "Mal\195\169diction des langages",
		["Curse of Weakness"] = "Mal\195\169diction de faiblesse",
		["Curse of the Elements"] = "Mal\195\169diction des \195\169l\195\169ments",
		["Cyclone"] = "Cyclone",
		["Dagger Specialization"] = "Sp\195\169cialisation Dague",
		["Daggers"] = "Dagues",
		["Dampen Magic"] = "Att\195\169nuation de la magie",
		["Dark Pact"] = "Pacte noir",
		["Darkness"] = "T\195\169n\195\168bres",
		["Dash"] = "C\195\169l\195\169rit\195\169",
		["Deadly Poison II"] = "Poison mortel II",
		["Deadly Poison III"] = "Poison mortel III",
		["Deadly Poison IV"] = "Poison mortel IV",
		["Deadly Poison V"] = "Poison mortel V",
		["Deadly Poison"] = "Poison mortel",
		["Deadly Throw"] = "Lancer mortel",
		["Death Coil"] = "Voile mortel",
		["Death Wish"] = "Souhait mortel",
		["Deep Wounds"] = "Blessures profondes",
		["Defense"] = "D\195\169fense",
		["Defensive Stance Passive"] = "Posture d\195\169fensive",
		["Defensive Stance"] = "Posture d\195\169fensive",
		["Defensive State 2"] = "Posture d\195\169fensive 2",
		["Defensive State"] = "Posture d\195\169fensive",
		["Defiance"] = "D\195\169fi",
		["Deflection"] = "D\195\169viation",
		["Demon Armor"] = "Armure d\195\169moniaque",
		["Demon Skin"] = "Peau de d\195\169mon",
		["Demonic Embrace"] = "Baiser d\195\169moniaque",
		["Demonic Frenzy"] = "Fr\195\169n\195\169sie d\195\169moniaque",
		["Demonic Sacrifice"] = "Sacrifice d\195\169moniaque",
		["Demoralizing Roar"] = "Rugissement d\195\169moralisant",
		["Demoralizing Shout"] = "Cri d\195\169moralisant",
		["Dense Sharpening Stone"] = "Pierre \195\160 aiguiser dense",
		["Desperate Prayer"] = "Pri\195\168re du d\195\169sespoir",
		["Destructive Reach"] = "Allonge de destruction",
		["Detect Greater Invisibility"] = "D\195\169tection de l'invisibilit\195\169 sup\195\169rieure",
		["Detect Invisibility"] = "D\195\169tection de l'invisibilit\195\169",
		["Detect Lesser Invisibility"] = "D\195\169tection de l'invisibilit\195\169 inf\195\169rieure",
		["Detect Magic"] = "D\195\169tection de la magie",
		["Detect Traps"] = "D\195\169tection des pi\195\168ges",
		["Detect"] = "D\195\169tection",
		["Deterrence"] = "Dissuasion",
		["Devastate"] = "D\195\169vaster",
		["Devastation"] = "D\195\169vastation",
		["Devotion Aura"] = "Aura de d\195\169votion",
		["Devour Magic Effect"] = "Effet festin magique",
		["Devour Magic"] = "Festin magique",
		["Devouring Plague"] = "Peste d\195\169vorante",
		["Diplomacy"] = "Diplomatie",
		["Dire Bear Form"] = "Forme d'ours redoutable",
		["Disarm Trap"] = "D\195\169sarmement de pi\195\168ge",
		["Disarm"] = "D\195\169sarmement",
		["Disease Cleansing Totem"] = "Totem de Purification des maladies",
		["Disenchant"] = "D\195\169senchanter",
		["Disengage"] = "D\195\169sengagement",
		["Dismiss Pet"] = "Renvoyer le familier",
		["Dispel Magic"] = "Dissipation de la magie",
		["Distract"] = "Distraction",
		["Distracting Shot"] = "Trait provocateur",
		["Dive"] = "Plongeon",
		["Divine Favor"] = "Faveur divine",
		["Divine Fury"] = "Fureur divine",
		["Divine Illumination"] = "Illumination divine",
		["Divine Intellect"] = "Intelligence divine",
		["Divine Intervention"] = "Intervention divine",
		["Divine Protection"] = "Protection divine",
		["Divine Shield"] = "Bouclier divin",
		["Divine Spirit"] = "Esprit divin",
		["Divine Strength"] = "Force divine",
		["Dodge"] = "Esquiver",
		["Dragon's Breath"] = "Souffle du dragon",
		["Dragonscale Leatherworking"] = "Travail du cuir d'\195\169cailles de dragon",
		["Drain Life"] = "Drain de vie",
		["Drain Mana"] = "Drain de mana",
		["Drain Soul"] = "Siphon d'\195\162me",
		["Drink"] = "Boisson",
		["Dual Wield Specialization"] = "Sp\195\169cialisation Ambidextrie",
		["Dual Wield"] = "Ambidextrie",
		["Duel"] = "Duel",
		["Eagle Eye"] = "Oeil d'aigle",
		["Earth Elemental Totem"] = "Totem d'\195\169l\195\169mentaire de terre",
		["Earth Shield"] = "Bouclier de terre",
		["Earth Shock"] = "Horion de terre",
		["Earthbind Totem"] = "Totem de lien terrestre",
		["Efficiency"] = "Efficacit\195\169",
		["Elemental Focus"] = "Focalisation \195\169l\195\169mentaire",
		["Elemental Fury"] = "Fureur \195\169l\195\169mentaire",
		["Elemental Leatherworking"] = "Travail du cuir \195\169l\195\169mentaire",
		["Elemental Mastery"] = "Ma\195\174trise \195\169l\195\169mentaire",
		["Elemental Sharpening Stone"] = "Pierre \195\160 aiguiser \195\169l\195\169mentaire",
		["Elune's Grace"] = "Gr\195\162ce d'Elune",
		["Elusiveness"] = "Insaisissable",
		["Emberstorm"] = "Temp\195\170te ardente",
		["Enamored Water Spirit"] = "Esprit de l'eau amoureux",
		["Enchanting"] = "Enchantement",
		["Endurance Training"] = "Entra\195\174nement \195\160 l'Endurance",
		["Endurance"] = "Endurance",
		["Engineering Specialization"] = "Sp\195\169cialisation",
		["Engineering"] = "Ing\195\169nieur",
		["Enrage"] = "Enrager",
		["Enriched Manna Biscuit"] = "Biscuit enrichi en manne",
		["Enslave Demon"] = "Asservir d\195\169mon",
		["Entangling Roots"] = "Sarments",
		["Entrapment"] = "Pi\195\168ge",
		["Envenom"] = "Envenimer",
		["Escape Artist"] = "Ma\195\174tre de l'\195\169vasion",
		["Evasion"] = "Evasion",
		["Eventide"] = "Tomb\195\169e du jour",
		["Eviscerate"] = "Evisc\195\169ration",
		["Evocation"] = "Evocation",
		["Execute"] = "Ex\195\169cution",
		["Exorcism"] = "Exorcisme",
		["Expansive Mind"] = "Pens\195\169e expansive",
		["Explosive Trap Effect"] = "Effet Pi\195\168ge explosif",
		["Explosive Trap"] = "Pi\195\168ge explosif",
		["Expose Armor"] = "Exposer l'armure",
		["Eye for an Eye"] = "Oeil pour oeil",
		["Eye of Kilrogg"] = "Oeil de Kilrogg",
		["Eyes of the Beast"] = "Oeil de la b\195\170te",
		["Fade"] = "Oubli",
		["Faerie Fire"] = "Lucioles",
		["Faerie Fire (Feral)"] = "Lucioles (farouche)",
		["Far Sight"] = "Double vue",
		["Fear Ward"] = "Gardien de peur",
		["Fear"] = "Peur",
		["Feed Pet"] = "Nourrir le familier",
		["Feedback"] = "R\195\169action",
		["Feign Death"] = "Feindre la mort",
		["Feint"] = "Feinte",
		["Fel Armor"] = "Gangrarmure",
		["Fel Concentration"] = "Concentration corrompue",
		["Fel Domination"] = "Domination corrompue",
		["Fel Intellect"] = "Intelligence corrompue",
		["Fel Stamina"] = "Endurance corrompue",
		["Felfire"] = "Gangrefeu",
		["Feline Grace"] = "Gr\195\162ce f\195\169line",
		["Feline Swiftness"] = "C\195\169l\195\169rit\195\169 f\195\169line",
		["Feral Aggression"] = "Agressivit\195\169 farouche",
		["Feral Charge"] = "Charge farouche",
		["Feral Instinct"] = "Instinct farouche",
		["Ferocious Bite"] = "Morsure f\195\169roce",
		["Ferocity"] = "Ferocit\195\169",
		["Fetish"] = "F\195\169tiche",
		["Find Herbs"] = "D\195\169couverte d'herbes",
		["Find Minerals"] = "D\195\169couverte de gisements",
		["Find Treasure"] = "D\195\169couverte de tr\195\169sors",
		["Find Weakness"] = "D\195\169couverte des faiblesses",
		["Fire Blast"] = "Trait de feu",
		["Fire Elemental Totem"] = "Totem d'\195\169l\195\169mentaire de Feu",
		["Fire Nova Totem"] = "Totem Nova de feu",
		["Fire Power"] = "Puissance du feu",
		["Fire Resistance Aura"] = "Aura de r\195\169sistance au Feu",
		["Fire Resistance Totem"] = "Totem de r\195\169sistance au feu",
		["Fire Resistance"] = "R\195\169sistance au Feu",
		["Fire Shield"] = "Bouclier de feu",
		["Fire Vulnerability"] = "Vuln\195\169rabilit\195\169 au Feu",
		["Fire Ward"] = "Gardien de feu",
		["Fireball"] = "Boule de feu",
		["Firebolt"] = "Eclair de feu",
		["First Aid"] = "Premiers soins",
		["Fishing Poles"] = "Cannes \195\160 p\195\170che",
		["Fishing"] = "P\195\170che",
		["Fist Weapon Specialization"] = "Sp\195\169cialisation Arme de pugilat",
		["Fist Weapons"] = "Armes de pugilat",
		["Flame Shock"] = "Horion de flammes",
		["Flame Throwing"] = "Jet de flammes",
		["Flamestrike"] = "Choc de flammes",
		["Flamethrower"] = "Lance-flammes",
		["Flametongue Totem"] = "Totem Langue de feu",
		["Flametongue Weapon"] = "Arme Langue de feu",
		["Flare"] = "Fus\195\169e \195\169clairante",
		["Flash Heal"] = "Soins rapides",
		["Flash of Light"] = "Eclair lumineux",
		["Flight Form"] = "Forme de vol",
		["Flurry"] = "Rafale",
		["Focused Casting"] = "Incantation focalis\195\169e",
		["Food"] = "Nourriture",
		["Forbearance"] = "Longanimit\195\169",
		["Force of Nature"] = "Force de la nature",
		["Force of Will"] = "Force de volont\195\169",
		["Freezing Trap Effect"] = "Effet Pi?e givrant",
		["Freezing Trap"] = "Pi\195\168ge givrant",
		["Frenzied Regeneration"] = "R\195\169g\195\169n\195\169ration fr\195\169n\195\169tique",
		["Frenzy"] = "Fr\195\169n\195\169sie",
		["Frost Armor"] = "Armure de givre",
		["Frost Channeling"] = "Canalisation du givre",
		["Frost Nova"] = "Nova de givre",
		["Frost Resistance Aura"] = "Aura de r\195\169sistance au Givre",
		["Frost Resistance Totem"] = "Totem de r\195\169sistance au Givre",
		["Frost Resistance"] = "R\195\169sistance au Givre",
		["Frost Shock"] = "Horion de givre",
		["Frost Trap"] = "Pi\195\168ge de givre",
		["Frost Trap Aura"] = "Effet Pi\195\168ge de givre",
		["Frost Ward"] = "Gardien de givre",
		["Frostbite"] = "Morsure du givre",
		["Frostbolt"] = "Eclair de givre",
		["Frostbrand Weapon"] = "Arme de givre",
		["Furious Howl"] = "Hurlement furieux",
		["Furor"] = "Fureur",
		["Garrote"] = "Garrot",
		["Generic"] = "G\195\169n\195\169rique",
		["Ghost Wolf"] = "Loup fant\195\180me",
		["Ghostly Strike"] = "Frappe fantomatique",
		["Gift of Nature"] = "Don de la Nature",
		["Gift of the Wild"] = "Don du fauve",
		["Gouge"] = "Suriner",
		["Grace of Air Totem"] = "Totem de Gr\195\162ce a\195\169rienne",
		["Great Stamina"] = "Endurance sup\195\169rieure",
		["Greater Blessing of Kings"] = "B\195\169n\195\169diction des rois sup\195\169rieure",
		["Greater Blessing of Light"] = "B\195\169n\195\169diction de lumi\195\168re sup\195\169rieure",
		["Greater Blessing of Might"] = "B\195\169n\195\169diction de puissance sup\195\169rieure",
		["Greater Blessing of Salvation"] = "B\195\169n\195\169diction de salut sup\195\169rieure",
		["Greater Blessing of Sanctuary"] = "B\195\169n\195\169diction du sanctuaire sup\195\169rieure",
		["Greater Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse sup\195\169rieure",
		["Greater Heal"] = "Soins sup\195\169rieurs",
		["Grim Reach"] = "Allonge sinistre",
		["Grounding Totem"] = "Totem de Gl\195\168be",
		["Grovel"] = "Ramper",
		["Growl"] = "Grondement",
		["Guardian's Favor"] = "Faveur du Gardien",
		["Gun Specialization"] = "Sp\195\169cialisation Armes \195\160 feu",
		["Guns"] = "Armes \195\160 feu",
		["Hammer of Justice"] = "Marteau de la justice",
		["Hammer of Wrath"] = "Marteau de courroux",
		["Hamstring"] = "Brise-genou",
		["Harass"] = "Harc\195\168lement",
		["Hardiness"] = "Solidit\195\169",
		["Hawk Eye"] = "Oeil de faucon",
		["Heal"] = "Soins",
		["Healing Focus"] = "Focalisation des soins",
		["Healing Light"] = "Lumi\195\168re gu\195\169risseuse",
		["Healing Stream Totem"] = "Totem gu\195\169risseur",
		["Healing Touch"] = "Toucher gu\195\169risseur",
		["Healing Wave"] = "Vague de soins",
		["Healing Way"] = "Flots de soins",
		["Health Funnel"] = "Captation de vie",
		["Heart of the Wild"] = "C\197\147ur de fauve",
		["Heavy Sharpening Stone"] = "Pierre \195\160 aiguiser lourde",
		["Hellfire Effect"] = "Effet Flammes infernales",
		["Hellfire"] = "Flammes infernales",
		["Hemorrhage"] = "H\195\169morragie",
		["Herb Gathering"] = "Cueillette",
		["Herbalism"] = "Herboristerie",
		["Heroic Strike"] = "Frappe h\195\169ro\195\175que",
		["Heroism"] = "H\195\169ro\195\175sme",
		["Hex of Weakness"] = "Mal\195\169fice de faiblesse",
		["Hibernate"] = "Hibernation",
		["Holy Fire"] = "Flammes sacr\195\169es",
		["Holy Light"] = "Lumi\195\168re sacr\195\169e",
		["Holy Nova"] = "Nova sacr\195\169e",
		["Holy Power"] = "Puissance sacr\195\169e",
		["Holy Reach"] = "Allonge du Sacr\195\169",
		["Holy Shield"] = "Bouclier sacr\195\169",
		["Holy Shock"] = "Horion sacr\195\169",
		["Holy Specialization"] = "Sp\195\169cialisation",
		["Holy Wrath"] = "Col\195\168re divine",
		["Honorless Target"] = "Cible sans honneur",
		["Horse Riding"] = "Equitation",
		["Howl of Terror"] = "Hurlement de terreur",
		["Humanoid Slaying"] = "Tueur d'humano\195\175des",
		["Hunter's Mark"] = "Marque du chasseur",
		["Hurricane"] = "Ouragan",
		["Ice Armor"] = "Armure de glace",
		["Ice Barrier"] = "Barri\195\168re de glace",
		["Ice Block"] = "Parade de glace",
		["Ice Lance"] = "Javelot de glace",
		["Ice Shards"] = "Eclats de glace",
		["Ignite"] = "Enflammer",
		["Illumination"] = "Illumination",
		["Immolate"] = "Immolation",
		["Immolation Trap Effect"] = "Effet Pi\195\168ge immolation",
		["Immolation Trap"] = "Pi\195\168ge d'Immolation",
		["Impact"] = "Impact",
		["Impale"] = "Empaler",
		["Improved Ambush"] = "Embuscade am\195\169lior\195\169e",
		["Improved Arcane Explosion"] = "Explosion des arcanes am\195\169lior\195\169e",
		["Improved Arcane Missiles"] = "Projectiles des arcanes am\195\169lior\195\169s",
		["Improved Arcane Shot"] = "Tir des arcanes am\195\169lior\195\169",
		["Improved Aspect of the Hawk"] = "Aspect du faucon am\195\169lior\195\169",
		["Improved Aspect of the Monkey"] = "Aspect du singe am\195\169lior\195\169",
		["Improved Backstab"] = "Attaque sournoise am\195\169lior\195\169e",
		["Improved Battle Shout"] = "Cri de guerre am\195\169lior\195\169",
		["Improved Berserker Rage"] = "Rage berserker am\195\169lior\195\169e",
		["Improved Blessing of Might"] = "B\195\169n\195\169diction de puissance am\195\169lior\195\169e",
		["Improved Blessing of Wisdom"] = "B\195\169n\195\169diction de sagesse am\195\169lior\195\169e",
		["Improved Blizzard"] = "Blizzard am\195\169lior\195\169",
		["Improved Bloodrage"] = "Rage sanguinaire am\195\169lior\195\169e",
		["Improved Chain Heal"] = "Salve de gu\195\169rison am\195\169lior\195\169e",
		["Improved Chain Lightning"] = "Cha\195\174ne d'\195\169clairs am\195\169lior\195\169e",
		["Improved Challenging Shout"] = "Cri de d\195\169fi am\195\169lior\195\169",
		["Improved Charge"] = "Charge am\195\169lior\195\169e",
		["Improved Cheap Shot"] = "Coup bas am\195\169lior\195\169",
		["Improved Cleave"] = "Encha\195\174nement am\195\169lior\195\169",
		["Improved Concentration Aura"] = "Aura de concentration am\195\169lior\195\169e",
		["Improved Concussive Shot"] = "Trait de choc am\195\169lior\195\169",
		["Improved Cone of Cold"] = "C\195\180ne de froid am\195\169lior\195\169",
		["Improved Corruption"] = "Corruption am\195\169lior\195\169e",
		["Improved Counterspell"] = "Contresort am\195\169lior\195\169",
		["Improved Curse of Agony"] = "Mal\195\169diction d'agonie am\195\169lior\195\169e",
		["Improved Curse of Exhaustion"] = "Mal\195\169diction de fatigue am\195\169lior\195\169e",
		["Improved Curse of Weakness"] = "Mal\195\169diction de faiblesse am\195\169lior\195\169e",
		["Improved Dampen Magic"] = "Att\195\169nuation de la magie am\195\169lior\195\169e",
		["Improved Deadly Poison"] = "Poison mortel am\195\169lior\195\169",
		["Improved Demoralizing Shout"] = "Cri d\195\169moralisant am\195\169lior\195\169",
		["Improved Devotion Aura"] = "Aura de d\195\169votion am\195\169lior\195\169e",
		["Improved Disarm"] = "D\195\169sarmement am\195\169lior\195\169",
		["Improved Distract"] = "Distraction am\195\169lior\195\169e",
		["Improved Drain Life"] = "Drain de vie am\195\169lior\195\169",
		["Improved Drain Mana"] = "Drain de mana am\195\169lior\195\169",
		["Improved Drain Soul"] = "Siphon d'\195\162me am\195\169lior\195\169",
		["Improved Enrage"] = "Enrager am\195\169lior\195\169",
		["Improved Enslave Demon"] = "Asservir d\195\169mon am\195\169lior\195\169",
		["Improved Entangling Roots"] = "Sarments am\195\169lior\195\169s",
		["Improved Evasion"] = "Evasion am\195\169lior\195\169e",
		["Improved Eviscerate"] = "Evisc\195\169ration am\195\169lior\195\169e",
		["Improved Execute"] = "Ex\195\169cution am\195\169lior\195\169e",
		["Improved Expose Armor"] = "Exposer l'armure am\195\169lior\195\169",
		["Improved Eyes of the Beast"] = "Oeil de la b\195\170te am\195\169lior\195\169",
		["Improved Fade"] = "Oubli am\195\169lior\195\169",
		["Improved Feign Death"] = "Feindre la mort am\195\169lior\195\169",
		["Improved Fire Blast"] = "Trait de feu am\195\169lior\195\169",
		["Improved Fire Nova Totem"] = "Totem Nova de feu am\195\169lior\195\169",
		["Improved Fire Ward"] = "Gardien de feu am\195\169lior\195\169",
		["Improved Fireball"] = "Boule de feu am\195\169lior\195\169e",
		["Improved Firebolt"] = "Eclair de feu am\195\169lior\195\169",
		["Improved Firestone"] = "Pierre de feu am\195\169lior\195\169e",
		["Improved Flamestrike"] = "Choc de flammes am\195\169lior\195\169",
		["Improved Flametongue Weapon"] = "Arme Langue de feu am\195\169lior\195\169e",
		["Improved Flash of Light"] = "Eclair lumineux am\195\169lior\195\169",
		["Improved Frost Nova"] = "Nova de givre am\195\169lior\195\169e",
		["Improved Frost Ward"] = "Gardien de givre am\195\169lior\195\169",
		["Improved Frostbolt"] = "Eclair de givre am\195\169lior\195\169",
		["Improved Frostbrand Weapon"] = "Arme de givre am\195\169lior\195\169e",
		["Improved Garrote"] = "Garrot am\195\169lior\195\169",
		["Improved Ghost Wolf"] = "Loup fant\195\180me am\195\169lior\195\169",
		["Improved Gouge"] = "Suriner am\195\169lior\195\169",
		["Improved Grace of Air Totem"] = "Totem de Gr\195\162ce a\195\169rienne am\195\169lior\195\169",
		["Improved Grounding Totem"] = "Totem de Gl\195\168be am\195\169lior\195\169",
		["Improved Hammer of Justice"] = "Marteau de la justice am\195\169lior\195\169",
		["Improved Hamstring"] = "Brise-genou am\195\169lior\195\169",
		["Improved Healing Stream Totem"] = "Totem gu\195\169risseur am\195\169lior\195\169",
		["Improved Healing Touch"] = "Toucher gu\195\169risseur am\195\169lior\195\169",
		["Improved Healing Wave"] = "Vague de soins am\195\169lior\195\169e",
		["Improved Healing"] = "Soin am\195\169lior\195\169",
		["Improved Health Funnel"] = "Captation de vie am\195\169lior\195\169e",
		["Improved Healthstone"] = "Pierre de soins am\195\169lior\195\169e",
		["Improved Heroic Strike"] = "Frappe h\195\169ro\195\175que am\195\169lior\195\169e",
		["Improved Hunter's Mark"] = "Marque du chasseur am\195\169lior\195\169e",
		["Improved Immolate"] = "Immolation am\195\169lior\195\169e",
		["Improved Imp"] = "Diablotin am\195\169lior\195\169",
		["Improved Inner Fire"] = "Feu int\195\169rieur am\195\169lior\195\169",
		["Improved Instant Poison"] = "Poison instantan\195\169 am\195\169lior\195\169",
		["Improved Intercept"] = "Interception am\195\169lior\195\169e",
		["Improved Intimidating Shout"] = "Cri d\226\128\153intimidation am\195\169lior\195\169",
		["Improved Judgement"] = "Jugement am\195\169lior\195\169",
		["Improved Kick"] = "Coup de pied am\195\169lior\195\169",
		["Improved Kidney Shot"] = "Aiguillon perfide am\195\169lior\195\169",
		["Improved Lash of Pain"] = "Fouet de la douleur am\195\169lior\195\169",
		["Improved Lay on Hands"] = "Imposition des mains am\195\169lior\195\169e",
		["Improved Lesser Healing Wave"] = "Vague de soins inf\195\169rieurs am\195\169lior\195\169e",
		["Improved Life Tap"] = "Connexion am\195\169lior\195\169e",
		["Improved Lightning Bolt"] = "Eclair am\195\169lior\195\169",
		["Improved Lightning Shield"] = "Bouclier de foudre am\195\169lior\195\169",
		["Improved Magma Totem"] = "Totem de Magma am\195\169lior\195\169",
		["Improved Mana Burn"] = "Br\195\187lure de mana am\195\169lior\195\169e",
		["Improved Mana Shield"] = "Bouclier de mana am\195\169lior\195\169",
		["Improved Mana Spring Totem"] = "Totem Fontaine de mana am\195\169lior\195\169",
		["Improved Mark of the Wild"] = "Marque du fauve am\195\169lior\195\169e",
		["Improved Mend Pet"] = "Gu\195\169rison du familier am\195\169lior\195\169e",
		["Improved Mind Blast"] = "Attaque mentale am\195\169lior\195\169e",
		["Improved Moonfire"] = "Eclat lunaire am\195\169lior\195\169",
		["Improved Nature's Grasp"] = "Emprise de la nature am\195\169lior\195\169e",
		["Improved Overpower"] = "Fulgurance am\195\169lior\195\169e",
		["Improved Power Word: Fortitude"] = "Mot de pouvoir : Robustesse am\195\169lior\195\169",
		["Improved Power Word: Shield"] = "Mot de pouvoir : Bouclier am\195\169lior\195\169",
		["Improved Prayer of Healing"] = "Pri\195\168re de soins am\195\169lior\195\169e",
		["Improved Psychic Scream"] = "Cri psychique am\195\169lior\195\169",
		["Improved Pummel"] = "Vol\195\169e de coups am\195\169lior\195\169e",
		["Improved Regrowth"] = "R\195\169tablissement am\195\169lior\195\169",
		["Improved Reincarnation"] = "R\195\169incarnation am\195\169lior\195\169e",
		["Improved Rejuvenation"] = "R\195\169cup\195\169ration am\195\169lior\195\169e",
		["Improved Rend"] = "Pourfendre am\195\169lior\195\169",
		["Improved Renew"] = "R\195\169novation am\195\169lior\195\169e",
		["Improved Retribution Aura"] = "Aura de vindicte am\195\169lior\195\169e",
		["Improved Revenge"] = "Vengeance am\195\169lior\195\169e",
		["Improved Revive Pet"] = "Ressusciter le familier am\195\169lior\195\169",
		["Improved Righteous Fury"] = "Fureur vertueuse am\195\169lior\195\169e",
		["Improved Rockbiter Weapon"] = "Arme Croque-roc am\195\169lior\195\169e",
		["Improved Rupture"] = "Rupture am\195\169lior\195\169e",
		["Improved Sap"] = "Assommer am\195\169lior\195\169",
		["Improved Scorch"] = "Br\195\187lure am\195\169lior\195\169e",
		["Improved Scorpid Sting"] = "Piq\195\187re de scorpide am\195\169lior\195\169e",
		["Improved Seal of Righteousness"] = "Sceau de pi\195\169t\195\169 am\195\169lior\195\169",
		["Improved Seal of the Crusader"] = "Sceau du Crois\195\169 am\195\169lior\195\169",
		["Improved Searing Pain"] = "Douleur br\195\187lante am\195\169lior\195\169e",
		["Improved Searing Totem"] = "Totem incendiaire am\195\169lior\195\169",
		["Improved Serpent Sting"] = "Morsure de serpent am\195\169lior\195\169e",
		["Improved Shadow Bolt"] = "Trait de l'ombre am\195\169lior\195\169",
		["Improved Shadow Word: Pain"] = "Mot de l'ombre : Douleur am\195\169lior\195\169",
		["Improved Shield Bash"] = "Coup de bouclier am\195\169lior\195\169",
		["Improved Shield Block"] = "Ma\195\174trise du blocage am\195\169lior\195\169e",
		["Improved Shield Wall"] = "Mur protecteur am\195\169lior\195\169",
		["Improved Shred"] = "Lambeau am\195\169lior\195\169",
		["Improved Sinister Strike"] = "Attaque pernicieuse am\195\169lior\195\169e",
		["Improved Slam"] = "Heurtoir am\195\169lior\195\169",
		["Improved Slice and Dice"] = "D\195\169biter am\195\169lior\195\169",
		["Improved Spellstone"] = "Pierre de sort am\195\169lior\195\169e",
		["Improved Sprint"] = "Sprint am\195\169lior\195\169",
		["Improved Starfire"] = "Feu stellaire am\195\169lior\195\169",
		["Improved Stoneclaw Totem"] = "Totem de Griffes de pierre am\195\169lior\195\169",
		["Improved Stoneskin Totem"] = "Totem de Peau de pierre am\195\169lior\195\169",
		["Improved Strength of Earth Totem"] = "Totem de Force de la Terre am\195\169lior\195\169",
		["Improved Succubus"] = "Succube am\195\169lior\195\169e",
		["Improved Sunder Armor"] = "Fracasser armure am\195\169lior\195\169",
		["Improved Taunt"] = "Provocation am\195\169lior\195\169e",
		["Improved Thorns"] = "Epines am\195\169lior\195\169es",
		["Improved Thunder Clap"] = "Coup de tonnerre am\195\169lior\195\169",
		["Improved Tranquility"] = "Tranquillit\195\169 am\195\169lior\195\169e",
		["Improved Vampiric Embrace"] = "Etreinte vampirique am\195\169lior\195\169e",
		["Improved Vanish"] = "Disparition am\195\169lior\195\169e",
		["Improved Voidwalker"] = "Marcheur du Vide am\195\169lior\195\169",
		["Improved Windfury Weapon"] = "Arme Furie-des-vents am\195\169lior\195\169e",
		["Improved Wing Clip"] = "Coupure d'ailes am\195\169lior\195\169e",
		["Improved Wrath"] = "Col\195\168re am\195\169lior\195\169e",
		["Incinerate"] = "Incin\195\169rer",
		["Inferno"] = "Inferno",
		["Initiative"] = "Initiative",
		["Inner Fire"] = "Feu int\195\169rieur",
		["Inner Focus"] = "Focalisation am\195\169lior\195\169e",
		["Innervate"] = "Innervation",
		["Insect Swarm"] = "Essaim d'insectes",
		["Inspiration"] = "Inspiration",
		["Instant Poison II"] = "Poison instantan\195\169 II",
		["Instant Poison III"] = "Poison instantan\195\169 III",
		["Instant Poison IV"] = "Poison instantan\195\169 IV",
		["Instant Poison V"] = "Poison instantan\195\169 V",
		["Instant Poison VI"] = "Poison instantan\195\169 VI",
		["Instant Poison"] = "Poison instantan\195\169",
		["Intensity"] = "Intensit\195\169",
		["Intercept"] = "Interception",
		["Intercept Stun"] = "Interception \195\169tourdissante",
		["Intervene"] = "Intervention",
		["Intimidating Shout"] = "Cri d\226\128\153intimidation",
		["Intimidation"] = "Intimidation",
		["Invisibility"] = "Invisibilit\195\169",
		["Iron Will"] = "Volont\195\169 de fer",
		["Jewelcrafting"] = "Joaillerie",
		["Judgement of Command"] = "Jugement d'autorit\195\169",
		["Judgement of Justice"] = "Jugement de justice",
		["Judgement of Light"] = "Jugement de lumi\195\168re",
		["Judgement of Righteousness"] = "Jugement de pi\195\169t\195\169",
		["Judgement of Wisdom"] = "Jugement de sagesse",
		["Judgement of the Crusader"] = "Jugement du Crois\195\169",
		["Judgement"] = "Jugement",
		["Kick"] = "Coup de pied",
		["Kick - Silenced"] = "Coup de pied - Silencieux",
		["Kidney Shot"] = "Aiguillon perfide",
		["Kill Command"] = "Ordre de tuer", 
		["Killer Instinct"] = "Instinct du tueur",
		["Kodo Riding"] = "Monte de kodo",
		["Lacerate"] = "Lac\195\169rer",
		["Lash of Pain"] = "Fouet de la douleur",
		["Last Stand"] = "Dernier rempart",
		["Lasting Judgement"] = "Jugement durable",
		["Lay on Hands"] = "Imposition des mains",
		["Leader of the Pack"] = "Chef de la meute",
		["Leather"] = "Cuir",
		["Leatherworking"] = "Travail du cuir",
		["Lesser Heal"] = "Soins inf\195\169rieurs",
		["Lesser Healing Wave"] = "Vague de soins inf\195\169rieurs",
		["Lesser Invisibility"] = "Invisibilit\195\169 inf\195\169rieure",
		["Lethal Shots"] = "Coups fatals",
		["Lethality"] = "Mortalit\195\169",
		["Levitate"] = "L\195\169vitation",
		["Libram"] = "Libram",
		["Lifebloom"] = "Fleur de vie",
		["Life Tap"] = "Connexion",
		["Lightning Bolt"] = "Eclair",
		["Lightning Breath"] = "Souffle de foudre",
		["Lightning Mastery"] = "Ma\195\174trise de la foudre",
		["Lightning Reflexes"] = "R\195\169flexes \195\169clairs",
		["Lightning Shield"] = "Bouclier de foudre",
		["Lightwell Renew"] = "R\195\169novation du Puits de lumi\195\168re",
		["Lightwell"] = "Puits de lumi\195\168re",
		["Lockpicking"] = "Crochetage",
		["Long Daze"] = "H\195\169b\195\169tement prolong\195\169",
		["Mace Specialization"] = "Sp\195\169cialisation Masse",
		["Mace Stun Effect"] = "Effet \195\169tourdissant de la masse",
		["Mage Armor"] = "Armure du mage",
		["Magma Totem"] = "Totem de Magma",
		["Mail"] = "Mailles",
		["Maim"] = "Estropier",
		["Malice"] = "Malice",
		["Mana Burn"] = "Br\195\187lure de mana",
		["Mana Shield"] = "Bouclier de mana",
		["Mana Spring Totem"] = "Totem Fontaine de mana",
		["Mana Tide Totem"] = "Totem de Vague de mana",
		["Mangle"] = "Mutilation",
		["Mangle (Cat)"] = "Mutilation (f\195\169lin)",
		["Mangle (Bear)"] = "Mutilation (ours)",
		["Mark of the Wild"] = "Marque du fauve",
		["Martyrdom"] = "Martyre",
		["Mass Dispel"] = "Dissipation de masse",
		["Master Demonologist"] = "Ma\195\174tre d\195\169monologue",
		["Master Summoner"] = "Ma\195\174tre invocateur",
		["Master of Deception"] = "Ma\195\174tre des illusions",
		["Maul"] = "Mutiler",
		["Mechanostrider Piloting"] = "Pilotage de m\195\169canotrotteur",
		["Meditation"] = "M\195\169ditation",
		["Melee Specialization"] = "Sp\195\169cialisation M\195\170l\195\169e",
		["Mend Pet"] = "Gu\195\169rison du familier",
		["Mental Agility"] = "Sagacit\195\169",
		["Mental Strength"] = "Force mentale",
		["Mind Blast"] = "Attaque mentale",
		["Mind Control"] = "Contr\195\180le mental",
		["Mind Flay"] = "Fouet mental",
		["Mind Soothe"] = "Apaisement",
		["Mind Vision"] = "Vision t\195\169l\195\169pathique",
		["Mind-numbing Poison II"] = "Poison de distraction mentale II",
		["Mind-numbing Poison III"] = "Poison de distraction mentale III",
		["Mind-numbing Poison"] = "Poison de distraction mentale",
		["Mining"] = "Minage",
		["Misdirection"] = "D\195\169tournement",
		["Mocking Blow"] = "Coup railleur",
		["Molten Armor"] = "Armure de la fournaise",
		["Mongoose Bite"] = "Morsure de la mangouste",
		["Monster Slaying"] = "Tueur de monstres",
		["Moonfire"] = "Eclat lunaire",
		["Moonfury"] = "Fureur lunaire",
		["Moonglow"] = "Lueur de la lune",
		["Moonkin Aura"] = "Aura de s\195\169l\195\169nien",
		["Moonkin Form"] = "Forme de s\195\169l\195\169nien",
		["Mortal Shots"] = "Coups mortels",
		["Mortal Strike"] = "Frappe mortelle",
		["Multi-Shot"] = "Fl\195\168ches multiples",
		["Murder"] = "Meurtre",
		["Mutilate"] = "Estropier",
		["Natural Armor"] = "Armure naturelle",
		["Natural Shapeshifter"] = "Changeforme naturel",
		["Natural Weapons"] = "Armes naturelles",
		["Nature Resistance Totem"] = "Totem de r\195\169sistance \195\160 la Nature",
		["Nature Resistance"] = "R\195\169sistance \195\160 la Nature",
		["Nature's Focus"] = "Focalisation de la nature",
		["Nature's Grace"] = "Gr\195\162ce de la nature",
		["Nature's Grasp"] = "Emprise de la nature",
		["Nature's Reach"] = "Allonge de la Nature",
		["Nature's Swiftness"] = "Rapidit\195\169 de la nature",
		["Nightfall"] = "Cr\195\169puscule",
		["Omen of Clarity"] = "Augure de clart\195\169",
		["One-Handed Axes"] = "Haches \195\160 une main",
		["One-Handed Maces"] = "Masses \195\160 une main",
		["One-Handed Swords"] = "Ep\195\169es \195\160 une main",
		["One-Handed Weapon Specialization"] = "Sp\195\169cialisation Arme 1M",
		["Opening - No Text"] = "Ouverture - pas de texte",
		["Opening"] = "Ouverture",
		["Opportunity"] = "Opportunit\195\169",
		["Overpower"] = "Fulgurance",
		["Pain Suppression"] = "Suppression de la douleur",
		["Paranoia"] = "Parano\195\175a",
		["Parry"] = "Parade",
		["Pathfinding"] = "Science des chemins",
		["Perception"] = "Perception",
		["Permafrost"] = "Gel prolong\195\169",
		["Pet Aggression"] = "Agressivit\195\169 du familier",
		["Pet Hardiness"] = "Robustesse du familier",
		["Pet Recovery"] = "R\195\169tablissement du familier",
		["Pet Resistance"] = "R\195\169sistance du familier",
		["Phase Shift"] = "Changement de phase",
		["Pick Lock"] = "Crochetage",
		["Pick Pocket"] = "Vol \195\160 la tire",
		["Piercing Howl"] = "Hurlement per\195\167ant",
		["Piercing Ice"] = "Glace per\195\167ante",
		["Plate Mail"] = "Armure en plaques",
		["Poison Cleansing Totem"] = "Totem de Purification du poison",
		["Poisons"] = "Poisons",
		["Polearm Specialization"] = "Sp\195\169cialisation Arme d'hast",
		["Polearms"] = "Armes d'hast",
		["Polymorph"] = "M\195\169tamorphose",
		["Polymorph: Pig"] = "M\195\169tamorphose: cochon",
		["Polymorph: Turtle"] = "M\195\169tamorphose: Tortue",  -- all other polymorph spells don't have a capital letter before the animal name, to test
		["Portal: Darnassus"] = "Portail : Darnassus",
		["Portal: Ironforge"] = "Portail : Forgefer",
		["Portal: Orgrimmar"] = "Portail : Orgrimmar",
		["Portal: Stormwind"] = "Portail : Hurlevent",
		["Portal: Thunder Bluff"] = "Portail : Pitons du Tonnerre",
		["Portal: Undercity"] = "Portail : Fossoyeuse",
		["Pounce Bleed"] = "Traquenard sanglant",
		["Pounce"] = "Traquenard",
		["Power Infusion"] = "Infusion de puissance",
		["Power Word: Fortitude"] = "Mot de pouvoir\194\160: Robustesse",
		["Power Word: Shield"] = "Mot de pouvoir\194\160: Bouclier",
		["Prayer of Fortitude"] = "Pri\195\168re de robustesse",
		["Prayer of Healing"] = "Pri\195\168re de soins",
		["Prayer of Mending"] = "Pri\195\168re de gu\195\169rison",
		["Prayer of Shadow Protection"] = "Pri\195\168re de protection contre l'Ombre",
		["Prayer of Spirit"] = "Pri\195\168re d'Esprit",
		["Precision"] = "Pr\195\169cision",
		["Predatory Strikes"] = "Frappes de pr\195\169dateur",
		["Premeditation"] = "Pr\195\169m\195\169ditation",
		["Preparation"] = "Pr\195\169paration",
		["Presence of Mind"] = "Pr\195\169sence spirituelle",
		["Primal Fury"] = "Fureur primitive",
		["Prowl"] = "R\195\180der",
		["Psychic Scream"] = "Cri psychique",
		["Pummel"] = "Vol\195\169e de coups",
		["Purge"] = "Expiation",
		["Purification"] = "Purification",
		["Purify"] = "Purification",
		["Pursuit of Justice"] = "Poursuite de la justice",
		["Pyroblast"] = "Explosion pyrotechnique",
		["Pyroclasm"] = "Pyroclasme",
		["Quick Shots"] = "Tir rapide",
		["Quickness"] = "Rapidit\195\169",
		["Rain of Fire"] = "Pluie de feu",
		["Rake"] = "Griffure",
		["Rampage"] = "Saccager",
		["Ram Riding"] = "Monte de b\195\169lier",
		["Ranged Weapon Specialization"] = "Sp\195\169cialisation Armes \195\160 distance",
		["Rapid Concealment"] = "Dissimulation rapide",
		["Rapid Fire"] = "Tir rapide",
		["Raptor Riding"] = "Monte de raptor",
		["Raptor Strike"] = "Attaque du raptor",
		["Ravage"] = "Ravage",
		["Readiness"] = "Promptitude",
		["Rebirth"] = "Renaissance",
		["Reckless Charge"] = "Charge furieuse",
		["Recklessness"] = "T\195\169m\195\169rit\195\169",
		["Reckoning"] = "R\195\169tribution",
		["Redemption"] = "R\195\169demption",
		["Redoubt"] = "Redoute",
		["Reflection"] = "Renvoi",
		["Regeneration"] = "R\195\169g\195\169n\195\169ration",
		["Regrowth"] = "R\195\169tablissement",
		["Reincarnation"] = "R\195\169incarnation",
		["Rejuvenation"] = "R\195\169cup\195\169ration",
		["Relentless Strikes"] = "Frappes implacables",
		["Remorseless"] = "Impitoyable",
		["Remorseless Attacks"] = "Attaques impitoyables",
		["Remove Curse"] = "D\195\169livrance de la mal\195\169diction",
		["Remove Insignia"] = "Enlever l'insigne",
		["Remove Lesser Curse"] = "D\195\169livrance de la mal\195\169diction mineure",
		["Rend"] = "Pourfendre",
		["Renew"] = "R\195\169novation",
		["Repentance"] = "Repentir",
		["Resurrection"] = "R\195\169surrection",
		["Retaliation"] = "Repr\195\169sailles",
		["Retribution Aura"] = "Aura de vindicte",
		["Revenge Stun"] = "Etourdissement vengeur",
		["Revenge"] = "Vengeance",
		["Reverberation"] = "R\195\169verb\195\169ration",
		["Revive Pet"] = "Ressusciter le familier",
		["Righteous Defense"] = "D\195\169fense vertueuse",
		["Righteous Fury"] = "Fureur vertueuse",
		["Rip"] = "D\195\169chirure",
		["Riposte"] = "Riposte",
		["Ritual of Doom Effect"] = "Effet Rituel de mal\195\169diction",
		["Ritual of Doom"] = "Rituel de mal\195\169diction",
		["Ritual of Souls"] = "Rituel des \195\162mes",
		["Ritual of Summoning"] = "Rituel d'invocation",
		["Rockbiter Weapon"] = "Arme Croque-roc",
		["Rogue Passive"] = "Voleur",
		["Rough Sharpening Stone"] = "Pierre \195\160 aiguiser brute",
		["Ruin"] = "Ruine",
		["Rupture"] = "Rupture",
		["Ruthlessness"] = "N\195\169m\195\169sis",
		["Sacrifice"] = "Sacrifice",
		["Safe Fall"] = "Chute amortie",
		["Sanctity Aura"] = "Aura de saintet\195\169",
		["Sap"] = "Assommer",
		["Savage Fury"] = "Furie sauvage",
		["Savage Strikes"] = "Frappes sauvages",
		["Scare Beast"] = "Effrayer une b\195\170te",
		["Scatter Shot"] = "Fl\195\168che de dispersion",
		["Scorch"] = "Br\195\187lure",
		["Scorpid Poison"] = "Poison de scorpide",
		["Scorpid Sting"] = "Piq\195\187re de scorpide",
		["Screech"] = "Hurlement",
		["Seal Fate"] = "Scelle le destin",
		["Seal of Blood"] = "Sceau de sang",
		["Seal of Command"] = "Sceau d'autorit\195\169",
		["Seal of Justice"] = "Sceau de justice",
		["Seal of Light"] = "Sceau de lumi\195\168re",
		["Seal of Righteousness"] = "Sceau de pi\195\169t\195\169",
		["Seal of Wisdom"] = "Sceau de sagesse",
		["Seal of the Crusader"] = "Sceau du Crois\195\169",
		["Seal of Vengeance"] = "Sceau de vengeance",
		["Searing Light"] = "Lumi\195\168re incendiaire",
		["Searing Pain"] = "Douleur br\195\187lante",
		["Searing Totem"] = "Totem incendiaire",
		["Second Wind"] = "Second souffle",
		["Seduction"] = "S\195\169duction",
		["Seed of Corruption"] = "Graine de Corruption",
		["Sense Demons"] = "D\195\169tection des d\195\169mons",
		["Sense Undead"] = "D\195\169tection des morts-vivants",
		["Sentry Totem"] = "Totem Sentinelle",
		["Serpent Sting"] = "Morsure de serpent",
		["Setup"] = "Pr\195\169paratifs",
		["Shackle Undead"] = "Entraves des morts-vivants",
		["Shadow Affinity"] = "Affinit\195\169 avec l'ombre",
		["Shadow Bolt"] = "Trait de l'ombre",
		["Shadow Focus"] = "Focalisation de l'ombre",
		["Shadow Mastery"] = "Ma\195\174trise de l'ombre",
		["Shadow Protection"] = "Protection contre l'Ombre",
		["Shadow Reach"] = "Allonge de l'Ombre",
		["Shadow Resistance Aura"] = "Aura de r\195\169sistance \195\160 l'Ombre",
		["Shadow Resistance"] = "R\195\169sistance \195\160 l'Ombre",
		["Shadow Trance"] = "Transe de l'ombre",
		["Shadow Vulnerability"] = "Vuln\195\169rabilit\195\169 \195\160 l'ombre",
		["Shadow Ward"] = "Gardien de l'ombre",
		["Shadow Weaving"] = "Tissage de l'ombre",
		["Shadow Word: Death"] = "Mot de l'ombre\194\160: Mort",
		["Shadow Word: Pain"] = "Mot de l'ombre\194\160: Douleur",
		["Shadowburn"] = "Br\195\187lure de l'ombre",
		["Shadowfiend"] = "Ombrefiel",
		["Shadowform"] = "Forme d'Ombre",
		["Shadowfury"] = "Furie de l'ombre",
		["Shadowguard"] = "Garde de l'ombre",
		["Shadowmeld Passive"] = "Camouflage dans l'ombre",
		["Shadowmeld"] = "Camouflage dans l'ombre",
		["Shadowstep"] = "Pas de l'ombre",
		["Shamanistic Rage"] = "Rage du chaman",
		["Sharpened Claws"] = "Griffes aiguis\195\169es",
		["Shatter"] = "Fracasser",
		["Sheep"] = "Mouton",
		["Shell Shield"] = "Carapace bouclier",
		["Shield Bash"] = "Coup de bouclier",
		["Shield Bash - Silenced"] = "Coup de bouclier - silencieux",  -- seems to be the only "- Silenced" not having a Cap letter, will try to test!
		["Shield Block"] = "Ma\195\174trise du blocage",
		["Shield Slam"] = "Heurt de bouclier",
		["Shield Specialization"] = "Sp\195\169cialisation Bouclier",
		["Shield Wall"] = "Mur protecteur",
		["Shield"] = "Bouclier",
		["Shiv"] = "Kriss",
		["Shoot Bow"] = "Tir \195\160 l'arc",
		["Shoot Crossbow"] = "Tir \195\160 l\226\128\153arbal\195\168te",
		["Shoot Gun"] = "Tir avec une arme \195\160 feu",
		["Shoot"] = "Tir",
		["Shred"] = "Lambeau",
		["Silence"] = "Silence",
		["Silencing Shot"] = "Fl\195\168che-ba\195\174llon",
		["Silent Resolve"] = "R\195\169solution silencieuse",
		["Sinister Strike"] = "Attaque pernicieuse",
		["Siphon Life"] = "Siphon de vie",
		["Skinning"] = "D\195\169pe\195\167age",
		["Slam"] = "Heurtoir",
		["Sleep"] = "Sommeil",
		["Slice and Dice"] = "D\195\169biter",
		["Slow"] = "Lenteur",
		["Slow Fall"] = "Chute lente",
		["Smelting"] = "Fondre",
		["Smite"] = "Ch\195\162timent",
		["Solid Sharpening Stone"] = "Pierre \195\160 aiguiser solide",
		["Snake Trap"] = "Pi\195\169ge \195\160 serpent",
		["Soothe Animal"] = "Apaiser les animaux",
		["Soothing Kiss"] = "Baiser apaisant",
		["Soul Fire"] = "Feu de l'\195\162me",
		["Soul Link"] = "Lien spirituel",
		["Soul Siphon"] = "Siphon d'\195\162me",
		["Soulshatter"] = "Brise-\195\162me",
		["Soulstone Resurrection"] = "R\195\169surrection de Pierre d'\195\162me",
		["Spell Lock"] = "Verrou magique",
		["Spellsteal"] = "Vol de sort",
		["Spell Reflection"] = "Renvoi de sort",
		["Spell Warding"] = "Protection contre les sorts",
		["Spirit Bond"] = "Engagement spirituel",
		["Spirit Tap"] = "Connexion spirituelle",
		["Spirit of Redemption"] = "Esprit de r\195\169demption",
		["Spiritual Attunement"] = "Harmonisation spirituelle",
		["Spiritual Focus"] = "Focalisation spirituelle",
		["Spiritual Guidance"] = "Direction spirituelle",
		["Spiritual Healing"] = "Soins spirituels",
		["Sprint"] = "Sprint",
		["Stance Mastery"] = "Ma\195\174trise des postures",
		["Starfire"] = "Feu stellaire",
		["Starfire Stun"] = "Feu stellaire \195\169tourdissant",
		["Starshards"] = "Eclats stellaires",
		["Staves"] = "B\195\162tons",
		["Steady Shot"] = "Tir assur\195\169",
		["Stealth"] = "Camouflage",
		["Stoneclaw Totem"] = "Totem de Griffes de pierre",
		["Stoneform"] = "Forme de pierre",
		["Stoneskin Totem"] = "Totem de Peau de pierre",
		["Stormstrike"] = "Courroux naturel",
		["Strength of Earth Totem"] = "Totem de Force de la Terre",
		["Stuck"] = "Bloqu\195\169",
		["Subtlety"] = "Discr\195\169tion",
		["Suffering"] = "Souffrance",
		["Summon Charger"] = "Invocation de destrier",
		["Summon Dreadsteed"] = "Invocation d'un Destrier de l'Effroi",
		["Summon Felguard"] = "Invocation d'un gangregarde",
		["Summon Felhunter"] = "Invocation d'un chasseur corrompu",
		["Summon Felsteed"] = "Invocation d'un palefroi corrompu",
		["Summon Imp"] = "Invocation d'un diablotin",
		["Summon Succubus"] = "Invocation d'une succube",
		["Summon Voidwalker"] = "Invocation d'un marcheur du Vide",
		["Summon Warhorse"] = "Invocation d'un cheval de guerre",
		["Summon Water Elemental"] = "Invocation d'un \195\169l\195\169mentaire d'eau",
		["Sunder Armor"] = "Fracasser armure",
		["Suppression"] = "Suppression",
		["Surefooted"] = "Pied s\195\187r",
		["Survivalist"] = "Survivant",
		["Sweeping Strikes"] = "Attaques circulaires",
		["Swiftmend"] = "Prompte gu\195\169rison",
		["Swipe"] = "Balayage",
		["Sword Specialization"] = "Sp\195\169cialisation Ep\195\169e",
		["Tactical Mastery"] = "Ma\195\174trise tactique",
		["Tailoring"] = "Couture",
		["Tainted Blood"] = "Corruption sanguine",
		["Tame Beast"] = "Dompte une b\195\170te",
		["Tamed Pet Passive"] = "Familier dompt\195\169",
		["Taunt"] = "Provocation",
		["Teleport: Darnassus"] = "T\195\169l\195\169portation : Darnassus",
		["Teleport: Ironforge"] = "T\195\169l\195\169portation : Forgefer",
		["Teleport: Moonglade"] = "T\195\169l\195\169portation : Reflet-de-Lune",
		["Teleport: Orgrimmar"] = "T\195\169l\195\169portation : Orgrimmar",
		["Teleport: Stormwind"] = "T\195\169l\195\169portation : Hurlevent",
		["Teleport: Thunder Bluff"] = "T\195\169l\195\169portation : Pitons du Tonnerre",
		["Teleport: Undercity"] = "T\195\169l\195\169portation : Fossoyeuse",
		["The Beast Within"] = "La b\195\170te int\195\169rieure",
		["The Human Spirit"] = "L'esprit humain",
		["Thick Hide"] = "Peau \195\169paisse",
		["Thorns"] = "Epines",
		["Throw"] = "Lancer",
		["Throwing Specialization"] = "Sp\195\169cialisation Armes de jet",
		["Throwing Weapon Specialization"] = "Sp\195\169cialisation Armes de jet",
		["Thrown"] = "Armes de jet",
		["Thunder Clap"] = "Coup de tonnerre",
		["Thundering Strikes"] = "Frappe foudroyante",
		["Thunderstomp"] = "Grondeterre",
		["Tidal Focus"] = "Focalisation des flots",
		["Tidal Mastery"] = "Ma\195\174trise des flots",
		["Tiger Riding"] = "Monte de tigre",
		["Tiger's Fury"] = "Fureur du tigre",
		["Torment"] = "Tourment",
		["Totem"] = "Totem",
		["Totem of Wrath"] = "Totem de courroux",
		["Totemic Focus"] = "Focalisation tot\195\169mique",
		["Touch of Weakness"] = "Toucher de faiblesse",
		["Toughness"] = "R\195\169sistance",
		["Track Beasts"] = "Pistage des b\195\170tes",
		["Track Demons"] = "Pistage des d\195\169mons",
		["Track Dragonkin"] = "Pistage des draconiens",
		["Track Elementals"] = "Pistage des \195\169l\195\169mentaires",
		["Track Giants"] = "Pistage des g\195\169ants",
		["Track Hidden"] = "Pistage des camoufl\195\169s",
		["Track Humanoids"] = "Pistage des humano\195\175des",
		["Track Undead"] = "Pistage des morts-vivants",
		["Tranquil Air Totem"] = "Totem de Tranquillit\195\169 de l'air",
		["Tranquil Spirit"] = "Tranquillit\195\169 de l'esprit",
		["Tranquility"] = "Tranquillit\195\169",
		["Tranquilizing Shot"] = "Tir tranquillisant",
		["Trap Mastery"] = "Ma\195\174trise des pi\195\168ges",
		["Travel Form"] = "Forme de voyage",
		["Tree of Life"] = "Arbre de vie",
		["Tremor Totem"] = "Totem de S\195\169isme",
		["Tribal Leatherworking"] = "Travail du cuir tribal",
		["Trueshot Aura"] = "Aura de pr\195\169cision",
		["Turn Undead"] = "Renvoi des morts-vivants",
		["Two-Handed Axes and Maces"] = "Haches et masses \195\160 deux mains",
		["Two-Handed Axes"] = "Haches \195\160 deux mains",
		["Two-Handed Maces"] = "Masses \195\160 deux mains",
		["Two-Handed Swords"] = "Ep\195\169es \195\160 deux mains",
		["Two-Handed Weapon Specialization"] = "Sp\195\169cialisation Arme 2M",
		["Unarmed"] = "Mains nues",
		["Unbreakable Will"] = "Volont\195\169 inflexible",
		["Unbridled Wrath Effect"] = "Effet Col\195\168re d\195\169cha\195\174n\195\169e",
		["Unbridled Wrath"] = "Col\195\168re d\195\169cha\195\174n\195\169e",
		["Undead Horsemanship"] = "Monte de cheval squelette",
		["Underwater Breathing"] = "Respiration aquatique",
		["Unending Breath"] = "Respiration interminable",
		["Unholy Power"] = "Puissance impie",
		["Unleashed Fury"] = "Fureur lib\195\169r\195\169e",
		["Unleashed Rage"] = "Rage lib\195\169r\195\169e",
		["Unstable Affliction"] = "Affliction instable",
		["Unyielding Faith"] = "Foi inflexible",
		["Vampiric Embrace"] = "Etreinte vampirique",
		["Vanish"] = "Disparition",
		["Vanished"] = "Invisible",
		["Vampiric Touch"] = "Toucher vampirique",
		["Vengeance"] = "Vengeance",
		["Victory Rush"] = "Ivresse de la victoire",
		["Vigor"] = "Vigueur",
		["Vile Poisons"] = "Poisons abominables",
		["Vindication"] = "Justification",
		["Viper Sting"] = "Morsure de vip\195\168re",
		["Volley"] = "Salve",
		["Wand Specialization"] = "Sp\195\169cialisation Baguette",
		["Wands"] = "Baguettes",
		["War Stomp"] = "Choc martial",
		["Water Breathing"] = "Respiration aquatique",
		["Water Shield"] = "Bouclier d'eau",
		["Water Walking"] = "Marcher sur l\226\128\153eau",
		["Waterbolt"] =	"Eclair d'eau",
		["Weakened Soul"] = "Ame affaiblie",
		["Weaponsmith"] = "Fabricant d'armes",
		["Whirlwind"] = "Tourbillon",
		["Will of the Forsaken"] = "Volont\195\169 des R\195\169prouv\195\169s",
		["Windfury Totem"] = "Totem Furie-des-vents",
		["Windfury Weapon"] = "Arme Furie-des-vents",
		["Windwall Totem"] = "Totem de Mur des vents",
		["Wing Clip"] = "Coupure d'ailes",
		["Winter's Chill"] = "Froid hivernal",
		["Wisp Spirit"] = "Esprit feu follet",
		["Wolf Riding"] = "Monte de loup",
		["Wound Poison II"] = "Poison douloureux II",
		["Wound Poison III"] = "Poison douloureux III",
		["Wound Poison IV"] = "Poison douloureux IV",
		["Wound Poison"] = "Poison douloureux",
		["Wrath"] = "Col\195\168re",
		["Wrath of Air Totem"] = "Totem de courroux de l'air",
		["Wyvern Sting"] = "Piq\195\187re de wyverne",
	}
end)

BabbleSpell:RegisterTranslations("zhCN", function()
	return {
		["Abolish Disease"] = "驱除疾病",
		["Abolish Poison Effect"] = "驱毒术效果",
		["Abolish Poison"] = "驱毒术",
		["Activate MG Turret"] = "速射炮台",
		["Adrenaline Rush"] = "冲动",
		["Aftermath"] = "清算",
		["Aggression"] = "侵略",
		["Aimed Shot"] = "瞄准射击",
		["Alchemy"] = "炼金术",
		["Ambush"] = "伏击",
		["Amplify Curse"] = "诅咒增幅",
		["Amplify Magic"] = "魔法增效",
		["Ancestral Fortitude"] = "先祖坚韧",
		["Ancestral Healing"] = "先祖治疗",
		["Ancestral Knowledge"] = "先祖知识",
		["Ancestral Spirit"] = "先祖之魂",
--		["Anesthetic Poison"] = true,
		["Anger Management"] = "愤怒掌控",
--		["Anguish"] = true,
		["Anticipation"] = "预知",
		["Aquatic Form"] = "水栖形态",
--		["Arcane Blast"] = true,
		["Arcane Brilliance"] = "奥术光辉",
		["Arcane Concentration"] = "奥术专注",
		["Arcane Explosion"] = "魔爆术",
		["Arcane Focus"] = "奥术集中",
		["Arcane Instability"] = "奥术增效",
		["Arcane Intellect"] = "奥术智慧",
		["Arcane Meditation"] = "奥术冥想",
		["Arcane Mind"] = "奥术心智",
		["Arcane Missiles"] = "奥术飞弹",
		["Arcane Power"] = "奥术强化",
		["Arcane Resistance"] = "奥术抗性",
		["Arcane Shot"] = "奥术射击",
		["Arcane Subtlety"] = "奥术精妙",
		["Arctic Reach"] = "极寒延伸",
		["Armorsmith"] = "护甲锻造师",
		["Aspect of the Beast"] = "野兽守护",
		["Aspect of the Cheetah"] = "猎豹守护",
		["Aspect of the Hawk"] = "雄鹰守护",
		["Aspect of the Monkey"] = "灵猴守护",
		["Aspect of the Pack"] = "豹群守护",
--		["Aspect of the Viper"] = true,
		["Aspect of the Wild"] = "野性守护",
		["Astral Recall"] = "星界传送",
		["Attack"] = "攻击",
		["Attacking"] = "攻击",
		["Auto Shot"] = "自动射击",
--		["Avenger's Shield"] = true,
--		["Avenging Wrath"] = true,
--		["Avoidance"] = true,
		["Axe Specialization"] = "斧专精",
--		["Backlash"] = true,
		["Backstab"] = "背刺",
		["Bane"] = "灾祸",
		["Banish"] = "放逐术",
		["Barkskin Effect"] = "树皮术效果",
		["Barkskin"] = "树皮术",
		["Barrage"] = "弹幕",
		["Bash"] = "重击",
		["Basic Campfire"] = "基础营火",
		["Battle Shout"] = "战斗怒吼",
		["Battle Stance Passive"] = "战斗姿态（被动）",
		["Battle Stance"] = "战斗姿态",
		["Bear Form"] = "熊形态",
		["Beast Lore"] = "野兽知识",
		["Beast Slaying"] = "野兽杀手",
		["Beast Training"] = "训练野兽",
		["Benediction"] = "祈福",
		["Berserker Rage"] = "狂暴之怒",
		["Berserker Stance Passive"] = "狂暴姿态（被动）",
		["Berserker Stance"] = "狂暴姿态",
		["Berserking"] = "狂暴",
		["Bestial Discipline"] = "野兽戒律",
		["Bestial Swiftness"] = "野兽迅捷",
		["Bestial Wrath"] = "狂野怒火",
--		["Binding Heal"] = true,
		["Bite"] = "撕咬",
		["Black Arrow"] = "黑箭",
		["Blackout"] = "昏阙",
		["Blacksmithing"] = "锻造",
		["Blade Flurry"] = "剑刃乱舞",
		["Blast Wave"] = "冲击波",
--		["Blazing Speed"] = true,
		["Blessed Recovery"] = "神恩回复",
		["Blessing of Freedom"] = "自由祝福",
		["Blessing of Kings"] = "王者祝福",
		["Blessing of Light"] = "光明祝福",
		["Blessing of Might"] = "力量祝福",
		["Blessing of Protection"] = "保护祝福",
		["Blessing of Sacrifice"] = "牺牲祝福",
		["Blessing of Salvation"] = "拯救祝福",
		["Blessing of Sanctuary"] = "庇护祝福",
		["Blessing of Wisdom"] = "智慧祝福",
		["Blind"] = "致盲",
		["Blinding Powder"] = "致盲粉",
		["Blink"] = "闪现术",
		["Blizzard"] = "暴风雪",
		["Block"] = "格挡",
		["Blood Craze"] = "血之狂热",
		["Blood Frenzy"] = "血之狂暴",
		["Blood Fury"] = "血性狂暴",
		["Blood Pact"] = "血之契印",
--		["Bloodlust"] = true,
		["Bloodrage"] = "血性狂暴",
		["Bloodthirst"] = "残忍",
		["Booming Voice"] = "震耳嗓音",
		["Bow Specialization"] = "弓专精",
		["Bows"] = "弓",
		["Bright Campfire"] = "明亮篝火",
		["Brutal Impact"] = "野蛮冲撞",
		["Burning Soul"] = "燃烧之魂",
		["Call Pet"] = "召唤宠物",
		["Call of Flame"] = "烈焰召唤",
		["Call of Thunder"] = "雷霆召唤",
		["Camouflage"] = "伪装",
		["Cannibalize"] = "食尸",
		["Cat Form"] = "猎豹形态",
		["Cataclysm"] = "灾变",
		["Chain Heal"] = "治疗链",
		["Chain Lightning"] = "闪电链",
		["Challenging Roar"] = "挑战咆哮",
		["Challenging Shout"] = "挑战怒吼",
		["Charge Rage Bonus Effect"] = "冲锋额外怒气效果",  -- not sure about this one
		["Charge"] = "冲锋",
		["Charge Stun"] = "冲锋击昏",
		["Cheap Shot"] = "偷袭",
		["Chilled"] = "冰冻",
--		["Circle of Healing"] = true,
		["Claw"] = "爪击",
		["Cleanse"] = "清洁术",
		["Clearcasting"] = "节能施法",
		["Cleave"] = "顺劈斩",
		["Clever Traps"] = "灵巧陷阱",
--		["Cloak of Shadows"] = true,
		["Closing"] = "关闭",
		["Cloth"] = "布甲",
		["Coarse Sharpening Stone"] = "粗制磨刀石",
		["Cobra Reflexes"] = "毒蛇反射",
		["Cold Blood"] = "冷血",
		["Cold Snap"] = "急速冷却",
		["Combat Endurance"] = "作战持久",
		["Combustion"] = "燃烧",
		["Command"] = "命令",
--		["Commanding Shout"] = true,
		["Concentration Aura"] = "专注光环",
		["Concussion Blow"] = "震荡猛击",
		["Concussion"] = "震荡",
		["Concussive Shot"] = "震荡射击",
		["Cone of Cold"] = "冰锥术",
		["Conflagrate"] = "燃烧",
		["Conjure Food"] = "造食术",
		["Conjure Mana Agate"] = "制造魔法玛瑙",
		["Conjure Mana Citrine"] = "制造魔法黄水晶",
		["Conjure Mana Jade"] = "制造魔法翡翠",
		["Conjure Mana Ruby"] = "制造魔法红宝石",
		["Conjure Water"] = "造水术",
		["Consecrated Sharpening Stone"] = "神圣磨刀石",
		["Consecration"] = "奉献",
--		["Consume Magic"] = true,
		["Consume Shadows"] = "吞噬暗影",
		["Convection"] = "传导",
		["Conviction"] = "定罪",
		["Cooking"] = "烹饪",
		["Corruption"] = "腐蚀",
		["Counterattack"] = "反击",
		["Counterspell"] = "法术反制",
		["Counterspell - Silenced"] = "法术反制 - 沉默",
		["Cower"] = "畏缩",
		["Create Firestone"] = "制造火焰石",
		["Create Firestone (Major)"] = "制造极效火焰石",
		["Create Firestone (Greater)"] = "制造强效火焰石",
		["Create Firestone (Lesser)"] = "制造次级火焰石",
		["Create Healthstone"] = "制造治疗石",
		["Create Healthstone (Major)"] = "制造极效治疗石",
		["Create Healthstone (Greater)"] = "制造强效治疗石",
		["Create Healthstone (Lesser)"] = "制造次级治疗石",
		["Create Healthstone (Minor)"] = "制造初级治疗石",
		["Create Soulstone"] = "制造灵魂石",
		["Create Soulstone (Major)"] = "制造极效灵魂石",
		["Create Soulstone (Greater)"] = "制造强效灵魂石",
		["Create Soulstone (Lesser)"] = "制造次级灵魂石",
		["Create Soulstone (Minor)"] = "制造初级灵魂石",
		["Create Spellstone"] = "制造法术石",
--		["Create Spellstone (Master)"] = true,
		["Create Spellstone (Major)"] = "制造极效法术石",
		["Create Spellstone (Greater)"] = "制造强效法术石",
		["Crippling Poison II"] = "致残毒药 II",
		["Crippling Poison"] = "致残毒药",
		["Critical Mass"] = "火焰重击",
		["Crossbows"] = "弩",
		["Cruelty"] = "残忍",
--		["Crusader Aura"] = true,
--		["Crusader Strike"] = true,
		["Cultivation"] = "栽培",
		["Cure Disease"] = "祛病术",
		["Cure Poison"] = "消毒术",
		["Curse of Agony"] = "痛苦诅咒",
		["Curse of Doom Effect"] = "厄运诅咒效果",
		["Curse of Doom"] = "厄运诅咒",
		["Curse of Exhaustion"] = "疲劳诅咒",
		["Curse of Idiocy"] = "痴呆诅咒",
		["Curse of Recklessness"] = "鲁莽诅咒",
		["Curse of Shadow"] = "暗影诅咒",
		["Curse of Tongues"] = "语言诅咒",
		["Curse of Weakness"] = "虚弱诅咒",
		["Curse of the Elements"] = "元素诅咒",
--		["Cyclone"] = true,
		["Dagger Specialization"] = "匕首专精",
		["Daggers"] = "匕首",
		["Dampen Magic"] = "魔法抑制",
		["Dark Pact"] = "黑暗契约",
		["Darkness"] = "黑暗",
		["Dash"] = "急奔",
		["Deadly Poison II"] = "致命毒药 II",
		["Deadly Poison III"] = "致命毒药 III",
		["Deadly Poison IV"] = "致命毒药 IV",
		["Deadly Poison V"] = "致命毒药 V",
		["Deadly Poison"] = "致命毒药",
--		["Deadly Throw"] = true,
		["Death Coil"] = "死亡缠绕",
		["Death Wish"] = "死亡之愿",
		["Deep Wounds"] = "重度伤口",
		["Defense"] = "防御",
		["Defensive Stance Passive"] = "防御姿态（被动）",
		["Defensive Stance"] = "防御姿态",
		["Defensive State 2"] = "防御状态 2",			-- not sure about this one
		["Defensive State"] = "防御状态",			-- and this one
		["Defiance"] = "挑衅",
		["Deflection"] = "偏斜",
		["Demon Armor"] = "魔甲术",
		["Demon Skin"] = "恶魔皮肤",
		["Demonic Embrace"] = "恶魔之拥",
--		["Demonic Frenzy"] = true,
		["Demonic Sacrifice"] = "恶魔牺牲",
		["Demoralizing Roar"] = "挫志咆哮",
		["Demoralizing Shout"] = "挫志怒吼",
		["Dense Sharpening Stone"] = "致密磨刀石",
		["Desperate Prayer"] = "绝望祷言",
		["Destructive Reach"] = "毁灭延伸",
		["Detect Greater Invisibility"] = "侦测强效隐形",
		["Detect Invisibility"] = "侦测隐形",
		["Detect Lesser Invisibility"] = "侦测次级隐形",
		["Detect Magic"] = "侦测魔法",
		["Detect Traps"] = "侦测陷阱",
		["Detect"] = "侦测",
		["Deterrence"] = "威慑",
--		["Devastate"] = true,
		["Devastation"] = "毁灭",
		["Devotion Aura"] = "虔诚光环",
		["Devour Magic Effect"] = "吞噬魔法效果",
		["Devour Magic"] = "吞噬魔法",
		["Devouring Plague"] = "噬灵瘟疫",
		["Diplomacy"] = "外交",
		["Dire Bear Form"] = "巨熊形态",
		["Disarm Trap"] = "解除陷阱",
		["Disarm"] = "缴械",
		["Disease Cleansing Totem"] = "祛病图腾",
		["Disenchant"] = "分解",
		["Disengage"] = "逃脱",
		["Dismiss Pet"] = "解散野兽",
		["Dispel Magic"] = "驱散魔法",
		["Distract"] = "扰乱",
		["Distracting Shot"] = "扰乱射击",
		["Dive"] = "俯冲",
		["Divine Favor"] = "神恩术",
		["Divine Fury"] = "神圣之怒",
--		["Divine Illumination"] = true,
		["Divine Intellect"] = "神圣智慧",
		["Divine Intervention"] = "神圣干涉",
		["Divine Protection"] = "圣佑术",
		["Divine Shield"] = "圣盾术",
		["Divine Spirit"] = "神圣之灵",
		["Divine Strength"] = "神圣之力",
		["Dodge"] = "躲闪",
--		["Dragon's Breath"] = true,
		["Dragonscale Leatherworking"] = "龙鳞制皮",
		["Drain Life"] = "吸取生命",
		["Drain Mana"] = "吸取法力",
		["Drain Soul"] = "吸取灵魂",
		["Drink"] = "喝水",
		["Dual Wield Specialization"] = "双武器专精",
		["Dual Wield"] = "双武器",
		["Duel"] = "决斗",
		["Eagle Eye"] = "鹰眼术",
--		["Earth Elemental Totem"] = true,
--		["Earth Shield"] = true,
		["Earth Shock"] = "大地震击",
		["Earthbind Totem"] = "地缚图腾",
		["Efficiency"] = "效率",
		["Elemental Focus"] = "元素集中",
		["Elemental Fury"] = "元素之怒",
		["Elemental Leatherworking"] = "元素制皮",
		["Elemental Mastery"] = "元素掌握",
		["Elemental Sharpening Stone"] = "元素磨刀石",
		["Elune's Grace"] = "艾露恩的赐福",
		["Elusiveness"] = "飘忽不定",
		["Emberstorm"] = "琥珀风暴",
		["Enamored Water Spirit"] = "被迷惑的水之魂",
		["Enchanting"] = "附魔",
		["Endurance Training"] = "耐久训练",
		["Endurance"] = "耐久",
		["Engineering Specialization"] = "工程学专精",
		["Engineering"] = "工程学",
		["Enrage"] = "狂怒",
		["Enriched Manna Biscuit"] = "可口的魔法点心",
		["Enslave Demon"] = "奴役恶魔",
		["Entangling Roots"] = "纠缠根须",
		["Entrapment"] = "诱捕",
--		["Envenom"] = true,
		["Escape Artist"] = "逃命专家",
		["Evasion"] = "闪避",
		["Eventide"] = "黄昏",		--An old talent of shamans, removed from the game.
		["Eviscerate"] = "剔骨",
		["Evocation"] = "唤醒",
		["Execute"] = "斩杀",
		["Exorcism"] = "驱邪术",
		["Expansive Mind"] = "开阔思维",
		["Explosive Trap Effect"] = "爆炸陷阱效果",
		["Explosive Trap"] = "爆炸陷阱",
		["Expose Armor"] = "破甲",
		["Eye for an Eye"] = "以眼还眼",
		["Eye of Kilrogg"] = "基尔罗格之眼",
		["Eyes of the Beast"] = "野兽之眼",
		["Fade"] = "渐隐术",
		["Faerie Fire"] = "精灵之火",
		["Faerie Fire (Feral)"] = "精灵之火（野性）",
		["Far Sight"] = "视界术",
		["Fear Ward"] = "防护恐惧结界",
		["Fear"] = "恐惧术",
		["Feed Pet"] = "喂养宠物",
		["Feedback"] = "回馈",
		["Feign Death"] = "假死",
		["Feint"] = "佯攻",
--		["Fel Armor"] = true,
		["Fel Concentration"] = "恶魔专注",
		["Fel Domination"] = "恶魔支配",
		["Fel Intellect"] = "恶魔智力",
		["Fel Stamina"] = "恶魔耐力",
		["Felfire"] = "魔火",
		["Feline Grace"] = "豹之优雅",
		["Feline Swiftness"] = "豹之迅捷",
		["Feral Aggression"] = "野性侵略",
		["Feral Charge"] = "野性冲锋",
		["Feral Instinct"] = "野性本能",
		["Ferocious Bite"] = "凶猛撕咬",
		["Ferocity"] = "凶暴",
		["Fetish"] = "神像",
		["Find Herbs"] = "寻找草药",
		["Find Minerals"] = "寻找矿物",
		["Find Treasure"] = "寻找财宝",
--		["Find Weakness"] = true,
		["Fire Blast"] = "火焰冲击",
--		["Fire Elemental Totem"] = true,
		["Fire Nova Totem"] = "火焰新星图腾",
		["Fire Power"] = "火焰强化",
		["Fire Resistance Aura"] = "火焰抗性光环",
		["Fire Resistance Totem"] = "抗火图腾",
		["Fire Resistance"] = "火焰抗性",
		["Fire Shield"] = "火焰之盾",
		["Fire Vulnerability"] = "火焰易伤",
		["Fire Ward"] = "防护火焰结界",
		["Fireball"] = "火球术",
		["Firebolt"] = "火焰箭",
		["First Aid"] = "急救",
		["Fishing Poles"] = "鱼竿",
		["Fishing"] = "钓鱼",
		["Fist Weapon Specialization"] = "拳套专精",
		["Fist Weapons"] = "拳套",
		["Flame Shock"] = "烈焰震击",
		["Flame Throwing"] = "烈焰投掷",
		["Flamestrike"] = "烈焰冲击",
		["Flamethrower"] = "火焰喷射器",
		["Flametongue Totem"] = "火舌图腾",
		["Flametongue Weapon"] = "火舌武器",
		["Flare"] = "照明弹",
		["Flash Heal"] = "快速治疗",
		["Flash of Light"] = "圣光闪现",
--		["Flight Form"] = true,
		["Flurry"] = "乱舞",
		["Focused Casting"] = "专注施法",
		["Food"] = "进食",
		["Forbearance"] = "自律",
--		["Force of Nature"] = true,
		["Force of Will"] = "意志之力",
		["Freezing Trap Effect"] = "冰冻陷阱效果",
		["Freezing Trap"] = "冰冻陷阱",
		["Frenzied Regeneration"] = "狂暴回复",
		["Frenzy"] = "疯狂",
		["Frost Armor"] = "霜甲术",
		["Frost Channeling"] = "冰霜导能",
		["Frost Nova"] = "冰霜新星",
		["Frost Resistance Aura"] = "冰霜抗性光环",
		["Frost Resistance Totem"] = "抗寒图腾",
		["Frost Resistance"] = "冰霜抗性",
		["Frost Shock"] = "冰霜震击",
		["Frost Trap"] = "冰霜陷阱",
		["Frost Trap Aura"] = "冰霜陷阱光环",
		["Frost Ward"] = "防护冰霜结界",
		["Frostbite"] = "霜寒刺骨",
		["Frostbolt"] = "寒冰箭",
		["Frostbrand Weapon"] = "冰封武器",
		["Furious Howl"] = "狂怒之嚎",
		["Furor"] = "激怒",
		["Garrote"] = "绞喉",
		["Generic"] = "基本",		-- not sure about this one
		["Ghost Wolf"] = "幽魂之狼",
		["Ghostly Strike"] = "鬼魅攻击",
		["Gift of Nature"] = "自然赐福",
		["Gift of the Wild"] = "野性赐福",
		["Gouge"] = "凿击",
		["Grace of Air Totem"] = "风之优雅图腾",
		["Great Stamina"] = "持久耐力",
		["Greater Blessing of Kings"] = "强效王者祝福",
		["Greater Blessing of Light"] = "强效光明祝福",
		["Greater Blessing of Might"] = "强效力量祝福",
		["Greater Blessing of Salvation"] = "强效拯救祝福",
		["Greater Blessing of Sanctuary"] = "强效庇护祝福",
		["Greater Blessing of Wisdom"] = "强效智慧祝福",
		["Greater Heal"] = "强效治疗术",
		["Grim Reach"] = "无情延伸",
		["Grounding Totem"] = "根基图腾",
		["Grovel"] = "匍匐",
		["Growl"] = "低吼",
		["Guardian's Favor"] = "守护者的宠爱",
		["Gun Specialization"] = "枪械专精",
		["Guns"] = "枪械",
		["Hammer of Justice"] = "制裁之锤",
		["Hammer of Wrath"] = "愤怒之锤",
		["Hamstring"] = "断筋",
		["Harass"] = "侵扰",
		["Hardiness"] = "坚韧",
		["Hawk Eye"] = "鹰眼",
		["Heal"] = "治疗术",
		["Healing Focus"] = "治疗专注",
		["Healing Light"] = "治疗之光",
		["Healing Stream Totem"] = "治疗之泉图腾",
		["Healing Touch"] = "治疗之触",
		["Healing Wave"] = "治疗波",
		["Healing Way"] = "治疗之道",
		["Health Funnel"] = "生命通道",
		["Heart of the Wild"] = "野性之心",
		["Heavy Sharpening Stone"] = "重磨刀石",
		["Hellfire Effect"] = "地狱烈焰效果",
		["Hellfire"] = "地狱烈焰",
		["Hemorrhage"] = "出血",
		["Herb Gathering"] = "采集草药",
		["Herbalism"] = "草药学",
		["Heroic Strike"] = "英勇打击",
--		["Heroism"] = true,
		["Hex of Weakness"] = "虚弱妖术",
		["Hibernate"] = "休眠",
		["Holy Fire"] = "神圣之火",
		["Holy Light"] = "圣光术",
		["Holy Nova"] = "神圣新星",
		["Holy Power"] = "神圣强化",
		["Holy Reach"] = "神圣延伸",
		["Holy Shield"] = "神圣之盾",
		["Holy Shock"] = "神圣震击",
		["Holy Specialization"] = "神圣专精",
		["Holy Wrath"] = "神圣愤怒",
		["Honorless Target"] = "无荣誉目标",
		["Horse Riding"] = "骑术：马",
		["Howl of Terror"] = "恐惧嚎叫",
		["Humanoid Slaying"] = "人型生物杀手",
		["Hunter's Mark"] = "猎人印记",
		["Hurricane"] = "飓风",
		["Ice Armor"] = "冰甲术",
		["Ice Barrier"] = "寒冰护体",
		["Ice Block"] = "寒冰屏障",
--		["Ice Lance"] = true,
		["Ice Shards"] = "寒冰碎片",
		["Ignite"] = "点燃",
		["Illumination"] = "启发",
		["Immolate"] = "献祭",
		["Immolation Trap Effect"] = "献祭陷阱效果",
		["Immolation Trap"] = "献祭陷阱",
		["Impact"] = "冲击",
		["Impale"] = "穿刺",
		["Improved Ambush"] = "强化伏击",
		["Improved Arcane Explosion"] = "强化魔爆术",
		["Improved Arcane Missiles"] = "强化奥术飞弹",
		["Improved Arcane Shot"] = "强化奥术射击",
		["Improved Aspect of the Hawk"] = "强化雄鹰守护",
		["Improved Aspect of the Monkey"] = "强化灵猴守护",
		["Improved Backstab"] = "强化背刺",
		["Improved Battle Shout"] = "强化战斗怒吼",
		["Improved Berserker Rage"] = "强化狂暴之怒",
		["Improved Blessing of Might"] = "强化力量祝福",
		["Improved Blessing of Wisdom"] = "强化智慧祝福",
		["Improved Blizzard"] = "强化暴风雪",
		["Improved Bloodrage"] = "强化血性狂暴",
		["Improved Chain Heal"] = "强化治疗链",
		["Improved Chain Lightning"] = "强化闪电链",
		["Improved Challenging Shout"] = "强化挑战怒吼",
		["Improved Charge"] = "强化冲锋",
		["Improved Cheap Shot"] = "强化偷袭",
		["Improved Cleave"] = "强化顺劈斩",
		["Improved Concentration Aura"] = "强化专注光环",
		["Improved Concussive Shot"] = "强化震荡射击",
		["Improved Cone of Cold"] = "强化冰锥术",
		["Improved Corruption"] = "强化腐蚀术",
		["Improved Counterspell"] = "强化法术反制",
		["Improved Curse of Agony"] = "强化痛苦诅咒",
		["Improved Curse of Exhaustion"] = "强化疲劳诅咒",
		["Improved Curse of Weakness"] = "强化虚弱诅咒",
		["Improved Dampen Magic"] = "强化魔法抑制",
		["Improved Deadly Poison"] = "强化致命毒药",
		["Improved Demoralizing Shout"] = "强化挫志怒吼",
		["Improved Devotion Aura"] = "强化虔诚光环",
		["Improved Disarm"] = "强化缴械",
		["Improved Distract"] = "强化扰乱",
		["Improved Drain Life"] = "强化吸取生命",
		["Improved Drain Mana"] = "强化吸取法力",
		["Improved Drain Soul"] = "强化吸取灵魂",
		["Improved Enrage"] = "强化狂怒",
		["Improved Enslave Demon"] = "强化奴役恶魔",
		["Improved Entangling Roots"] = "强化纠缠根须",
		["Improved Evasion"] = "强化闪避",
		["Improved Eviscerate"] = "强化剔骨",
		["Improved Execute"] = "强化斩杀",
		["Improved Expose Armor"] = "强化破甲",
		["Improved Eyes of the Beast"] = "强化野兽之眼",
		["Improved Fade"] = "强化渐隐术",
		["Improved Feign Death"] = "强化假死",
		["Improved Fire Blast"] = "强化火焰冲击",
		["Improved Fire Nova Totem"] = "强化火焰图腾",
		["Improved Fire Ward"] = "强化防护火焰结界",
		["Improved Fireball"] = "强化火球术",
		["Improved Firebolt"] = "强化火焰箭",
		["Improved Firestone"] = "强化火焰石",
		["Improved Flamestrike"] = "强化烈焰冲击",
		["Improved Flametongue Weapon"] = "强化火舌武器",
		["Improved Flash of Light"] = "强化圣光闪现",
		["Improved Frost Nova"] = "强化冰霜新星",
		["Improved Frost Ward"] = "强化防护冰霜结界",
		["Improved Frostbolt"] = "强化寒冰箭",
		["Improved Frostbrand Weapon"] = "强化冰封武器",
		["Improved Garrote"] = "强化绞喉",
		["Improved Ghost Wolf"] = "强化幽魂之狼",
		["Improved Gouge"] = "强化凿击",
		["Improved Grace of Air Totem"] = "强化风之优雅图腾",
		["Improved Grounding Totem"] = "强化根基图腾",
		["Improved Hammer of Justice"] = "强化制裁之锤",
		["Improved Hamstring"] = "强化断筋",
		["Improved Healing Stream Totem"] = "强化治疗之泉图腾",
		["Improved Healing Touch"] = "强化治疗之触",
		["Improved Healing Wave"] = "强化治疗波",
		["Improved Healing"] = "强化治疗术",
		["Improved Health Funnel"] = "强化生命通道",
		["Improved Healthstone"] = "强化治疗石",
		["Improved Heroic Strike"] = "强化英勇打击",
		["Improved Hunter's Mark"] = "强化猎人印记",
		["Improved Immolate"] = "强化献祭",
		["Improved Imp"] = "强化小鬼",
		["Improved Inner Fire"] = "强化心灵之火",
		["Improved Instant Poison"] = "强化速效毒药",
		["Improved Intercept"] = "强化拦截",
		["Improved Intimidating Shout"] = "强化破胆怒吼",
		["Improved Judgement"] = "强化审判",
		["Improved Kick"] = "强化脚踢",
		["Improved Kidney Shot"] = "强化肾击",
		["Improved Lash of Pain"] = "强化剧痛鞭笞",
		["Improved Lay on Hands"] = "强化圣疗术",
		["Improved Lesser Healing Wave"] = "强化次级治疗波",
		["Improved Life Tap"] = "强化生命分流",
		["Improved Lightning Bolt"] = "强化闪电箭",
		["Improved Lightning Shield"] = "强化闪电护盾",
		["Improved Magma Totem"] = "强化熔岩图腾",
		["Improved Mana Burn"] = "强化法力燃烧",
		["Improved Mana Shield"] = "强化法力护盾",
		["Improved Mana Spring Totem"] = "强化法力之泉图腾",
		["Improved Mark of the Wild"] = "强化野性印记",
		["Improved Mend Pet"] = "强化治疗宠物",
		["Improved Mind Blast"] = "强化心灵震爆",
		["Improved Moonfire"] = "强化月火术",
		["Improved Nature's Grasp"] = "强化自然之握",
		["Improved Overpower"] = "强化压制",
		["Improved Power Word: Fortitude"] = "强化真言术：韧",
		["Improved Power Word: Shield"] = "强化圣言术：盾",
		["Improved Prayer of Healing"] = "强化治疗祷言",
		["Improved Psychic Scream"] = "强化心灵尖啸",
		["Improved Pummel"] = "强化拳击",
		["Improved Regrowth"] = "强化愈合",
		["Improved Reincarnation"] = "强化复生",
		["Improved Rejuvenation"] = "强化回春",
		["Improved Rend"] = "强化撕裂",
		["Improved Renew"] = "强化恢复",
		["Improved Retribution Aura"] = "强化惩罚光环",
		["Improved Revenge"] = "强化复仇",
		["Improved Revive Pet"] = "强化复活宠物",
		["Improved Righteous Fury"] = "强化正义之怒",
		["Improved Rockbiter Weapon"] = "强化石化武器",
		["Improved Rupture"] = "强化割裂",
		["Improved Sap"] = "强化闷棍",
		["Improved Scorch"] = "强化灼烧",
		["Improved Scorpid Sting"] = "强化毒蝎钉刺",
		["Improved Seal of Righteousness"] = "强化正义圣印",
		["Improved Seal of the Crusader"] = "强化十字军圣印",
		["Improved Searing Pain"] = "强化灼热之痛",
		["Improved Searing Totem"] = "强化灼热图腾",
		["Improved Serpent Sting"] = "强化毒蛇钉刺",
		["Improved Shadow Bolt"] = "强化暗影箭",
		["Improved Shadow Word: Pain"] = "强化暗言术：痛",
		["Improved Shield Bash"] = "强化盾击",
		["Improved Shield Block"] = "强化盾牌格挡",
		["Improved Shield Wall"] = "强化盾墙",
		["Improved Shred"] = "强化撕碎",
		["Improved Sinister Strike"] = "强化邪恶攻击",
		["Improved Slam"] = "强化猛击",
		["Improved Slice and Dice"] = "强化切割",
		["Improved Spellstone"] = "强化法术石",
		["Improved Sprint"] = "强化疾跑",
		["Improved Starfire"] = "强化星火术",
		["Improved Stoneclaw Totem"] = "强化石爪图腾",
		["Improved Stoneskin Totem"] = "强化石肤图腾",
		["Improved Strength of Earth Totem"] = "强化大地之力图腾",
		["Improved Succubus"] = "强化魅魔",
		["Improved Sunder Armor"] = "强化破甲攻击",
		["Improved Taunt"] = "强化嘲讽",
		["Improved Thorns"] = "强化荆棘术",
		["Improved Thunder Clap"] = "强化雷霆一击",
		["Improved Tranquility"] = "强化宁静",
		["Improved Vampiric Embrace"] = "强化吸血鬼的拥抱",
		["Improved Vanish"] = "强化消失",
		["Improved Voidwalker"] = "强化虚空行者",
		["Improved Windfury Weapon"] = "强化风怒武器",
		["Improved Wing Clip"] = "强化摔绊",
		["Improved Wrath"] = "强化愤怒",
		["Incinerate"] = "焚烧",
		["Inferno"] = "地狱火",
		["Initiative"] = "先发制人",
		["Inner Fire"] = "心灵之火",
		["Inner Focus"] = "心灵专注",
		["Innervate"] = "激活",
		["Insect Swarm"] = "虫群",
		["Inspiration"] = "灵感",
		["Instant Poison II"] = "速效毒药 II",
		["Instant Poison III"] = "速效毒药 III",
		["Instant Poison IV"] = "速效毒药 IV",
		["Instant Poison V"] = "速效毒药 V",
		["Instant Poison VI"] = "速效毒药 VI",
		["Instant Poison"] = "速效毒药",
		["Intensity"] = "强烈",
		["Intercept"] = "拦截",
		["Intercept Stun"] = "拦截昏迷",
--		["Intervene"] = true,
		["Intimidating Shout"] = "破胆怒吼",
		["Intimidation"] = "胁迫",
--		["Invisibility"] = true,
		["Judgement of Command"] = "命令审判",
		["Judgement of Justice"] = "公正审判",
		["Judgement of Light"] = "光明审判",
		["Judgement of Righteousness"] = "正义审判",
		["Judgement of Wisdom"] = "智慧审判",
		["Judgement of the Crusader"] = "十字军审判",
		["Judgement"] = "审判",
		["Kick"] = "脚踢",
		["Kick - Silenced"] = "脚踢 - 沉默",
		["Kidney Shot"] = "肾击",
--		["Kill Command"] = true, 
		["Killer Instinct"] = "杀戮本能",
		["Kodo Riding"] = "骑术：科多兽",
--		["Lacerate"] = true,
		["Lash of Pain"] = "剧痛鞭笞",
		["Last Stand"] = "破釜沉舟",
		["Lasting Judgement"] = "持久审判",
		["Lay on Hands"] = "圣疗术",
		["Leader of the Pack"] = "兽群领袖",
		["Leather"] = "皮甲",
		["Leatherworking"] = "制皮",
		["Lesser Heal"] = "次级治疗术",
		["Lesser Healing Wave"] = "次级治疗波",
		["Lesser Invisibility"] = "次级隐形术",
		["Lethal Shots"] = "夺命射击",
		["Lethality"] = "致命偷袭",
		["Levitate"] = "漂浮",
		["Libram"] = "圣物",
--		["Lifebloom"] = true,
		["Life Tap"] = "生命分流",
		["Lightning Bolt"] = "闪电箭",
		["Lightning Breath"] = "闪电吐息",
		["Lightning Mastery"] = "闪电掌握",
		["Lightning Reflexes"] = "闪电反射",
		["Lightning Shield"] = "闪电护盾",
		["Lightwell Renew"] = "光明之泉回复",
		["Lightwell"] = "光明之泉",
		["Lockpicking"] = "开锁",
		["Long Daze"] = "长时间眩晕",
		["Mace Specialization"] = "锤类武器专精",
		["Mace Stun Effect"] = "锤击昏迷效果",
		["Mage Armor"] = "魔甲术",
		["Magma Totem"] = "熔岩图腾",
		["Mail"] = "锁甲",
--		["Maim"] = true,
		["Malice"] = "恶意",
		["Mana Burn"] = "法力燃烧",
		["Mana Shield"] = "法力护盾",
		["Mana Spring Totem"] = "法力之泉图腾",
		["Mana Tide Totem"] = "法力之潮图腾",
		["Mangle"] = "割碎",
--		["Mangle (Cat)"] = true,
--		["Mangle (Bear)"] = true,
		["Mark of the Wild"] = "野性印记",
		["Martyrdom"] = "殉难",
--		["Mass Dispel"] = true,
		["Master Demonologist"] = "恶魔学识大师",
		["Master Summoner"] = "召唤大师",
		["Master of Deception"] = "欺诈高手",
		["Maul"] = "槌击",
		["Mechanostrider Piloting"] = "骑术：机械陆行鸟",
		["Meditation"] = "冥想",
		["Melee Specialization"] = "近战专精",
		["Mend Pet"] = "治疗宠物",
		["Mental Agility"] = "精神敏锐",
		["Mental Strength"] = "心灵之力",
		["Mind Blast"] = "心灵震爆",
		["Mind Control"] = "精神控制",
		["Mind Flay"] = "精神鞭笞",
		["Mind Soothe"] = "安抚心灵",
		["Mind Vision"] = "心灵视界",
		["Mind-numbing Poison II"] = "麻痹毒药 II",
		["Mind-numbing Poison III"] = "麻痹毒药 III",
		["Mind-numbing Poison"] = "麻痹毒药",
		["Mining"] = "采矿",
--		["Misdirection"] = true,
		["Mocking Blow"] = "惩戒痛击",
--		["Molten Armor"] = true,
		["Mongoose Bite"] = "猫鼬撕咬",
		["Monster Slaying"] = "怪物杀手",
		["Moonfire"] = "月火术",
		["Moonfury"] = "月怒",
		["Moonglow"] = "月光",
		["Moonkin Aura"] = "枭兽光环",
		["Moonkin Form"] = "枭兽形态",
		["Mortal Shots"] = "致死射击",
		["Mortal Strike"] = "致死打击",
		["Multi-Shot"] = "多重射击",
		["Murder"] = "谋杀",
--		["Mutilate"] = true,
		["Natural Armor"] = "自然护甲",
		["Natural Shapeshifter"] = "自然变形",
		["Natural Weapons"] = "武器平衡",
		["Nature Resistance Totem"] = "自然抗性图腾",
		["Nature Resistance"] = "自然抗性",
		["Nature's Focus"] = "自然集中",
		["Nature's Grace"] = "自然之赐",
		["Nature's Grasp"] = "自然之握",
		["Nature's Reach"] = "自然延伸",
		["Nature's Swiftness"] = "自然迅捷",
		["Nightfall"] = "夜幕",
		["Omen of Clarity"] = "清晰预兆",
		["One-Handed Axes"] = "单手斧",
		["One-Handed Maces"] = "单手锤",
		["One-Handed Swords"] = "单手剑",
		["One-Handed Weapon Specialization"] = "单手武器专精",
		["Opening - No Text"] = "打开 - No Text",	--not sure what this is
		["Opening"] = "打开",
		["Opportunity"] = "伺机而动",
		["Overpower"] = "压制",
--		["Pain Suppression"] = true,
		["Paranoia"] = "多疑",
		["Parry"] = "招架",
		["Pathfinding"] = "寻路",
		["Perception"] = "感知",
		["Permafrost"] = "极寒冰霜",
		["Pet Aggression"] = "宠物好斗",
		["Pet Hardiness"] = "宠物耐久",
		["Pet Recovery"] = "宠物恢复",
		["Pet Resistance"] = "宠物抗魔",
		["Phase Shift"] = "相位变换",
		["Pick Lock"] = "开锁",
		["Pick Pocket"] = "偷窃",
		["Piercing Howl"] = "刺耳怒吼",
		["Piercing Ice"] = "刺骨寒冰",
		["Plate Mail"] = "板甲",
		["Poison Cleansing Totem"] = "祛病图腾",
		["Poisons"] = "毒药",
		["Polearm Specialization"] = "长柄武器专精",
		["Polearms"] = "长柄武器",
		["Polymorph"] = "变形术",
		["Polymorph: Pig"] = "变形术：猪",
		["Polymorph: Turtle"] = "变形术：龟",
		["Portal: Darnassus"] = "传送门：达纳苏斯",
		["Portal: Ironforge"] = " 传送门：铁炉堡",
		["Portal: Orgrimmar"] = "传送门：奥格瑞玛",
		["Portal: Stormwind"] = "传送门：暴风城",
		["Portal: Thunder Bluff"] = "传送门：雷霆崖",
		["Portal: Undercity"] = "传送门：幽暗城",
		["Pounce Bleed"] = "突袭",
		["Pounce"] = "突袭",
		["Power Infusion"] = "能量灌注",
		["Power Word: Fortitude"] = "真言术：韧",
		["Power Word: Shield"] = "真言术：盾",
		["Prayer of Fortitude"] = "坚韧祷言",
		["Prayer of Healing"] = "治疗祷言",
--		["Prayer of Mending"] = true,
		["Prayer of Spirit"] = "精神祷言",
		["Prayer of Shadow Protection"] = "暗影防护祷言",
		["Precision"] = "精确",
		["Predatory Strikes"] = "猛兽攻击",
		["Premeditation"] = "预谋",
		["Preparation"] = "伺机待发",
		["Presence of Mind"] = "气定神闲",
		["Primal Fury"] = "原始狂怒",
		["Prowl"] = "潜伏",
		["Psychic Scream"] = "心灵尖啸",
		["Pummel"] = "拳击",
		["Purge"] = "净化术",
		["Purification"] = "净化",
		["Purify"] = "纯净术",
		["Pursuit of Justice"] = "正义追击",
		["Pyroblast"] = "炎爆术",
		["Pyroclasm"] = "火焰冲撞",
		["Quick Shots"] = "快速射击",
		["Quickness"] = "迅捷",
		["Rain of Fire"] = "火焰之雨",
		["Rake"] = "扫击",
--		["Rampage"] = true,
		["Ram Riding"] = " 	骑术：羊",
		["Ranged Weapon Specialization"] = "远程武器专精",
		["Rapid Concealment"] = "迅速隐蔽",
		["Rapid Fire"] = "急速射击",
		["Raptor Riding"] = "骑术：迅猛龙",
		["Raptor Strike"] = "猛禽一击",
		["Ravage"] = "毁灭",
		["Readiness"] = "准备就绪",
		["Rebirth"] = "复生",
		["Reckless Charge"] = "无畏冲锋",
		["Recklessness"] = "鲁莽",
		["Reckoning"] = "清算",
		["Redemption"] = "救赎",
		["Redoubt"] = "盾牌壁垒",
		["Reflection"] = "反射",
		["Regeneration"] = "回复",
		["Regrowth"] = "愈合",
		["Reincarnation"] = "复生",
		["Rejuvenation"] = "回春术",
		["Relentless Strikes"] = "无情打击",
		["Remorseless"] = "冷酷",
		["Remorseless Attacks"] = "冷酷攻击",
		["Remove Curse"] = "解除诅咒",
		["Remove Insignia"] = "解除徽记",
		["Remove Lesser Curse"] = "解除次级诅咒",
		["Rend"] = "撕裂",
		["Renew"] = "恢复",
		["Repentance"] = "忏悔",
		["Resurrection"] = "复活",
		["Retaliation"] = "反击风暴",
		["Retribution Aura"] = "惩罚光环",
		["Revenge Stun"] = "复仇昏迷",
		["Revenge"] = "复仇",
		["Reverberation"] = "回响",
		["Revive Pet"] = "复活宠物",
--		["Righteous Defense"] = true,
		["Righteous Fury"] = "正义之怒",
		["Rip"] = "撕扯",
		["Riposte"] = "还击",
		["Ritual of Doom Effect"] = "末日仪式效果",
		["Ritual of Doom"] = "末日仪式",
--		["Ritual of Souls"] = true,
		["Ritual of Summoning"] = "召唤仪式",
		["Rockbiter Weapon"] = "石化武器",
		["Rogue Passive"] = "盗贼被动效果",  -- not sure
		["Rough Sharpening Stone"] = "劣质磨刀石",
		["Ruin"] = "毁灭",
		["Rupture"] = "割裂",
		["Ruthlessness"] = "无情",
		["Sacrifice"] = "牺牲",
		["Safe Fall"] = "安全降落",
		["Sanctity Aura"] = "圣洁光环",
		["Sap"] = "闷棍",
		["Savage Fury"] = "野蛮暴怒",
		["Savage Strikes"] = "野蛮打击",
		["Scare Beast"] = "恐吓野兽",
		["Scatter Shot"] = "驱散射击",
		["Scorch"] = "灼烧",
		["Scorpid Poison"] = "蝎毒",
		["Scorpid Sting"] = "毒蝎钉刺",
		["Screech"] = "尖啸",
		["Seal Fate"] = "封印命运",
--		["Seal of Blood"] = true,
		["Seal of Command"] = "命令圣印",
		["Seal of Justice"] = "公正圣印",
		["Seal of Light"] = "光明圣印",
		["Seal of Righteousness"] = "正义圣印",
		["Seal of Wisdom"] = "智慧圣印",
		["Seal of the Crusader"] = "十字军圣印",
--		["Seal of Vengeance"] = true,
		["Searing Light"] = "灼热之光",
		["Searing Pain"] = "灼热之痛",
		["Searing Totem"] = "灼热图腾",
--		["Second Wind"] = true,
		["Seduction"] = "诱惑",
--		["Seed of Corruption"] = true,
		["Sense Demons"] = "感知恶魔",
		["Sense Undead"] = "感知亡灵",
		["Sentry Totem"] = "岗哨图腾",
		["Serpent Sting"] = "毒蛇钉刺",
		["Setup"] = "调整",
		["Shackle Undead"] = "束缚亡灵",
		["Shadow Affinity"] = "暗影亲和",
		["Shadow Bolt"] = "暗影箭",
		["Shadow Focus"] = "暗影集中",
		["Shadow Mastery"] = "暗影掌握",
		["Shadow Protection"] = "暗影防护",
		["Shadow Reach"] = "暗影延伸",
		["Shadow Resistance Aura"] = "暗影抗性光环",
		["Shadow Resistance"] = "暗影抗性",
		["Shadow Trance"] = "暗影冥思",
		["Shadow Vulnerability"] = "暗影易伤",
		["Shadow Ward"] = "防护暗影结界",
		["Shadow Weaving"] = "暗影之波",
--		["Shadow Word: Death"] = true,
		["Shadow Word: Pain"] = "暗言术：痛",
		["Shadowburn"] = "暗影灼烧",
--		["Shadowfiend"] = true,
		["Shadowform"] = "暗影形态",
--		["Shadowfury"] = true,
		["Shadowguard"] = "暗影守卫",
		["Shadowmeld Passive"] = "影遁",
		["Shadowmeld"] = "影遁",
--		["Shadowstep"] = true,
--		["Shamanistic Rage"] = true,
		["Sharpened Claws"] = "锋利兽爪",
		["Shatter"] = "碎冰",
		["Sheep"] = "绵羊",  --not sure
		["Shell Shield"] = "甲壳护盾",
		["Shield Bash"] = "盾击",
		["Shield Bash - Silenced"] = "盾击 - 沉默",
		["Shield Block"] = "盾牌格挡",
		["Shield Slam"] = "盾牌猛击",
		["Shield Specialization"] = "盾牌专精",
		["Shield Wall"] = "盾墙",
		["Shield"] = "盾牌",
--		["Shiv"] = true,
		["Shoot Bow"] = "弓射击",
		["Shoot Crossbow"] = "弩射击",
		["Shoot Gun"] = "枪械射击",
		["Shoot"] = "射击",
		["Shred"] = "撕碎",
		["Silence"] = "沉默",
--		["Silencing Shot"] = true,
		["Silent Resolve"] = "无声消退",
		["Sinister Strike"] = "邪恶攻击",
		["Siphon Life"] = "生命虹吸",
		["Skinning"] = "剥皮",
		["Slam"] = "猛击",
		["Sleep"] = "沉睡", --not so sure
		["Slice and Dice"] = "切割",
--		["Slow"] = true,
		["Slow Fall"] = "缓落术",
		["Smelting"] = "熔炼",
		["Smite"] = "惩击",
--		["Snake Trap"] = true,
		["Solid Sharpening Stone"] = "坚固的磨刀石",
		["Soothe Animal"] = "安抚动物",
		["Soothing Kiss"] = "安抚之吻",
		["Soul Fire"] = "灵魂之火",
		["Soul Link"] = "灵魂链接",
		["Soul Siphon"] = "灵魂虹吸",
--		["Soulshatter"] = true,
		["Soulstone Resurrection"] = "灵魂石复活",
		["Spell Lock"] = "法术封锁",
--		["Spellsteal"] = true,
--		["Spell Reflection"] = true,
		["Spell Warding"] = "法术屏障",
		["Spirit Bond"] = "灵魂连接",
		["Spirit Tap"] = "精神分流",
		["Spirit of Redemption"] = "救赎之魂",
--		["Spiritual Attunement"] = true,
		["Spiritual Focus"] = "精神集中",
		["Spiritual Guidance"] = "精神指引",
		["Spiritual Healing"] = "精神治疗",
		["Sprint"] = "疾跑",
--		["Stance Mastery"] = true,
		["Starfire"] = "星火术",
		["Starfire Stun"] = "星火昏迷",
		["Starshards"] = "星辰碎片",
		["Staves"] = "法杖",
--		["Steady Shot"] = true,
		["Stealth"] = "潜行",
		["Stoneclaw Totem"] = "石爪图腾",
		["Stoneform"] = "石像形态",
		["Stoneskin Totem"] = "石肤图腾",
		["Stormstrike"] = "风暴打击",
		["Strength of Earth Totem"] = "大地之力图腾",
		["Stuck"] = "卡死",
		["Subtlety"] = "微妙",
		["Suffering"] = "受难",
		["Summon Charger"] = "召唤战马",
		["Summon Dreadsteed"] = "召唤恐惧战马",
--		["Summon Felguard"] = true,
		["Summon Felhunter"] = "召唤地狱猎犬",
		["Summon Felsteed"] = "召唤地狱战马",
		["Summon Imp"] = "召唤小鬼",
		["Summon Succubus"] = "召唤魅魔",
		["Summon Voidwalker"] = "召唤虚空行者",
		["Summon Warhorse"] = "召唤军马",
--		["Summon Water Elemental"] = true,
		["Sunder Armor"] = "破甲",
		["Suppression"] = "压制",
		["Surefooted"] = "稳固",
		["Survivalist"] = "生存专家",
		["Sweeping Strikes"] = "横扫攻击",
		["Swiftmend"] = "迅捷治愈",
		["Swipe"] = "挥击",
		["Sword Specialization"] = "剑类武器专精",
		["Tactical Mastery"] = "战术掌握",
		["Tainted Blood"] = "腐坏之血",
		["Tailoring"] = "裁缝",
		["Tame Beast"] = "驯服野兽",
		["Tamed Pet Passive"] = "驯服宠物（被动）",
		["Taunt"] = "嘲讽",
		["Teleport: Darnassus"] = "传送：达纳苏斯",
		["Teleport: Ironforge"] = "传送：铁炉堡",
		["Teleport: Moonglade"] = "传送：月光林地",
		["Teleport: Orgrimmar"] = "传送：奥格瑞玛",
		["Teleport: Stormwind"] = "传送：暴风城",
		["Teleport: Thunder Bluff"] = "传送：雷霆崖",
		["Teleport: Undercity"] = "传送：幽暗城",
--		["The Beast Within"] = true,
		["The Human Spirit"] = "人类精魂",
		["Thick Hide"] = "厚皮",
		["Thorns"] = "荆棘术",
		["Throw"] = "投掷",
		["Throwing Specialization"] = "投掷专精",
		["Throwing Weapon Specialization"] = "投掷武器专精",
		["Thrown"] = "投掷",
		["Thunder Clap"] = "雷霆一击",
		["Thundering Strikes"] = "雷鸣猛击",
		["Thunderstomp"] = "雷霆践踏",
		["Tidal Focus"] = "潮汐集中",
		["Tidal Mastery"] = "潮汐掌握",
		["Tiger Riding"] = "骑术：豹",
		["Tiger's Fury"] = "猛虎之怒",
		["Torment"] = "折磨",
		["Totem"] = "图腾",
		-- ["Totem of Wrath"] = true,
		["Totemic Focus"] = "图腾集中",
		["Touch of Weakness"] = "虚弱之触",
		["Toughness"] = "坚韧",
		["Track Beasts"] = "追踪野兽",
		["Track Demons"] = "追踪恶魔",
		["Track Dragonkin"] = "追踪龙类",
		["Track Elementals"] = "追踪元素生物",
		["Track Giants"] = "追踪巨人",
		["Track Hidden"] = "追踪隐藏生物",
		["Track Humanoids"] = "追踪人型生物",
		["Track Undead"] = "追踪亡灵",
		["Tranquil Air Totem"] = "宁静之风图腾",
		["Tranquil Spirit"] = "宁静之魂",
		["Tranquility"] = "宁静",
		["Tranquilizing Shot"] = "宁神射击",
		["Trap Mastery"] = "陷阱掌握",
		["Travel Form"] = "旅行形态",
--		["Tree of Life"] = true,
		["Tremor Totem"] = "战栗图腾",
		["Tribal Leatherworking"] = "部族制皮",
		["Trueshot Aura"] = "强击光环",
		["Turn Undead"] = "超度亡灵",
		["Two-Handed Axes and Maces"] = "双手斧和锤",
		["Two-Handed Axes"] = "双手斧",
		["Two-Handed Maces"] = "双手锤",
		["Two-Handed Swords"] = "无光泽的双刃刀",
		["Two-Handed Weapon Specialization"] = "双手武器专精",
		["Unarmed"] = "徒手",
		["Unbreakable Will"] = "坚定意志",
		["Unbridled Wrath Effect"] = "怒不可遏",
		["Unbridled Wrath"] = "怒不可遏",
		["Undead Horsemanship"] = "骑术：骸骨战马",
		["Underwater Breathing"] = "水下呼吸",
		["Unending Breath"] = "魔息术",
		["Unholy Power"] = "邪恶强化",
		["Unleashed Fury"] = "狂怒释放",
--		["Unleashed Rage"] = true,
--		["Unstable Affliction"] = true,
		["Unyielding Faith"] = "不灭信仰",
		["Vampiric Embrace"] = "吸血鬼的拥抱",
		["Vanish"] = "消失",
		["Vanished"] = "消失",
--		["Vampiric Touch"] = true,
		["Vengeance"] = "复仇",
--		["Victory Rush"] = true,
		["Vigor"] = "精力",
		["Vile Poisons"] = "恶性毒药",
		["Vindication"] = "辩护",
		["Viper Sting"] = "蝰蛇钉刺",
		["Volley"] = "乱射",
		["Wand Specialization"] = "魔杖掌握",
		["Wands"] = "魔杖",
		["War Stomp"] = "战争践踏",
		["Water Breathing"] = "水下呼吸",
--		["Water Shield"] = true,
		["Water Walking"] = "水上行走",
--		["Waterbolt"] =	true,
		["Weakened Soul"] = "虚弱灵魂",
		["Weaponsmith"] = "武器锻造师",
		["Whirlwind"] = "旋风斩",
		["Will of the Forsaken"] = "亡灵意志",
		["Windfury Totem"] = "风怒图腾",
		["Windfury Weapon"] = "风怒武器",
		["Windwall Totem"] = "风墙图腾",
		["Wing Clip"] = "摔绊",
		["Winter's Chill"] = "深冬之寒",
		["Wisp Spirit"] = "精灵之魂",
		["Wolf Riding"] = "骑术：狼",
		["Wound Poison II"] = "致伤毒药 II",
		["Wound Poison III"] = "致伤毒药 III",
		["Wound Poison IV"] = "致伤毒药 IV",
		["Wound Poison"] = "致伤毒药",
		["Wrath"] = "愤怒",
		-- ["Wrath of Air Totem"] = true,
		["Wyvern Sting"] = "翼龙钉刺",
	}
end)

BabbleSpell:RegisterTranslations("zhTW", function()
	return {
		["Abolish Disease"]="驅除疾病",
		["Abolish Poison Effect"]="驅毒術效果",
		["Abolish Poison"]="驅毒術",
		["Activate MG Turret"]="發射MGs",
		["Adrenaline Rush"]="能量刺激",
		["Aftermath"]="清算",
		["Aggression"]="侵略",
		["Aimed Shot"]="瞄準射擊",
		["Alchemy"]="煉金術",
		["Ambush"]="伏擊",
		["Amplify Curse"]="詛咒增幅",
		["Amplify Magic"]="魔法增效",
		["Ancestral Fortitude"] = "先祖堅韌",
		["Ancestral Healing"]="先祖治療",
		["Ancestral Knowledge"]="先祖知識",
		["Ancestral Spirit"]="先祖之魂",
--		["Anesthetic Poison"] = true,
		["Anger Management"]="憤怒掌控",
--		["Anguish"] = true,
		["Anticipation"]="預知",
		["Aquatic Form"]="水棲形態",
--		["Arcane Blast"] = true,
		["Arcane Brilliance"]="祕法光輝",
		["Arcane Concentration"]="祕法專注",
		["Arcane Explosion"]="魔爆術",
		["Arcane Focus"]="祕法集中",
		["Arcane Instability"]="祕法增效",
		["Arcane Intellect"]="祕法智慧",
		["Arcane Meditation"]="祕法冥想",
		["Arcane Mind"]="祕法心智",
		["Arcane Missiles"]="祕法飛彈",
		["Arcane Power"]="祕法強化",
		["Arcane Resistance"]="祕法抗性",
		["Arcane Shot"]="祕法射擊",
		["Arcane Subtlety"]="祕法精妙",
		["Arctic Reach"]="極寒延伸",
		["Armorsmith"]="護甲鍛造師",
		["Aspect of the Beast"]="野獸守護",
		["Aspect of the Cheetah"]="獵豹守護",
		["Aspect of the Hawk"]="雄鷹守護",
		["Aspect of the Monkey"]="靈猴守護",
		["Aspect of the Pack"]="豹群守護",
--		["Aspect of the Viper"] = true,
		["Aspect of the Wild"]="野性守護",
		["Astral Recall"]="星界傳送",
		["Attack"]="攻擊",
		["Attacking"]="攻擊",
		["Auto Shot"]="自動射擊",
--		["Avenger's Shield"] = true,
--		["Avenging Wrath"] = true,
--		["Avoidance"] = true,
		["Axe Specialization"]="斧專精",
--		["Backlash"] = true,
		["Backstab"]="背刺",
		["Bane"]="災禍",
		["Banish"]="放逐術",
		["Barkskin Effect"]="樹皮效果",
		["Barkskin"]="樹皮術",
		["Barrage"]="彈幕",
		["Bash"]="重擊",
		["Basic Campfire"]="基礎篝火",
		["Battle Shout"]="戰鬥怒吼",
		["Battle Stance Passive"]="戰鬥姿態（被動）",
		["Battle Stance"]="戰鬥姿態",
		["Bear Form"]="熊形態",
		["Beast Lore"]="野獸知識",
		["Beast Slaying"]="野獸殺手",
		["Beast Training"]="訓練野獸",
		["Benediction"]="祈福",
		["Berserker Rage"]="狂暴之怒",
		["Berserker Stance Passive"]="狂暴姿態（被動）",
		["Berserker Stance"]="狂暴姿態",
		["Berserking"]="狂暴",
		["Bestial Discipline"]="野獸戒律",
		["Bestial Swiftness"]="野獸迅捷",
		["Bestial Wrath"]="狂野怒火",
--		["Binding Heal"] = true,
		["Bite"]="撕咬",
		["Black Arrow"]="黑箭",
		["Blackout"]="昏厥",
		["Blacksmithing"]="鍛造",
		["Blade Flurry"]="劍刃亂舞",
		["Blast Wave"]="衝擊波",
--		["Blazing Speed"] = true,
		["Blessed Recovery"]="祝福復元",
		["Blessing of Freedom"]="自由祝福",
		["Blessing of Kings"]="王者祝福",
		["Blessing of Light"]="光明祝福",
		["Blessing of Might"]="力量祝福",
		["Blessing of Protection"]="保護祝福",
		["Blessing of Sacrifice"]="犧牲祝福",
		["Blessing of Salvation"]="拯救祝福",
		["Blessing of Sanctuary"]="庇護祝福",
		["Blessing of Wisdom"]="智慧祝福",
		["Blind"]="致盲",
		["Blinding Powder"]="致盲粉",
		["Blink"]="閃現術",
		["Blizzard"]="暴風雪",
		["Block"]="格擋",
		["Blood Craze"]="血之狂熱",
		["Blood Frenzy"]="血之狂暴",
		["Blood Fury"]="血性狂暴",
		["Blood Pact"]="血之契印",
--		["Bloodlust"] = true,
		["Bloodrage"]="血性狂暴",
		["Bloodthirst"]="嗜血",
		["Booming Voice"]="震耳嗓音",
		["Bow Specialization"]="弓箭專精",
		["Bows"]="弓",
		["Bright Campfire"]="明亮篝火",
		["Brutal Impact"]="野蠻衝撞",
		["Burning Soul"]="燃燒之魂",
		["Call Pet"]="召喚寵物",
		["Call of Flame"]="烈焰召喚",
		["Call of Thunder"]="雷霆召喚",
		["Camouflage"]="偽裝",
		["Cannibalize"]="食屍",
		["Cat Form"]="獵豹形態",
		["Cataclysm"]="災變",
		["Chain Heal"]="治療鍊",
		["Chain Lightning"]="閃電鏈",
		["Challenging Roar"]="挑戰咆哮",
		["Challenging Shout"]="挑戰怒吼",
		["Charge Rage Bonus Effect"]="Charge Rage Bonus Effect",
		["Charge"]="衝鋒",
		["Charge Stun"] = "衝鋒擊昏",
		["Cheap Shot"]="偷襲",
		["Chilled"]="冰凍",
--		["Circle of Healing"] = true,
		["Claw"]="爪擊",
		["Cleanse"]="淨化術",
		["Clearcasting"]="節能施法",
		["Cleave"]="順劈斬",
		["Clever Traps"]="靈巧陷阱",
--		["Cloak of Shadows"] = true,
		["Closing"]="關閉",
		["Cloth"]="布甲",
		["Coarse Sharpening Stone"]="粗製磨刀石",
		["Cobra Reflexes"]="毒蛇反射",
		["Cold Blood"]="冷血",
		["Cold Snap"]="急速冷卻",
		["Combat Endurance"]="作戰持久",
		["Combustion"]="燃燒",
		["Command"]="命令",
--		["Commanding Shout"] = true,
		["Concentration Aura"]="專注光環",
		["Concussion Blow"]="震盪猛擊",
		["Concussion"]="奉獻",
		["Concussive Shot"]="震盪射擊",
		["Cone of Cold"]="冰錐術",
		["Conflagrate"]="燃燒",
		["Conjure Food"]="造食術",
		["Conjure Mana Agate"]="製造魔法瑪瑙",
		["Conjure Mana Citrine"]="製造魔法黃水晶",
		["Conjure Mana Jade"]="製造魔法翡翠",
		["Conjure Mana Ruby"]="製造魔法紅寶石",
		["Conjure Water"]="造水術",
		["Consecrated Sharpening Stone"]="神聖的磨刀石",
		["Consecration"]="奉獻",
--		["Consume Magic"] = true,
		["Consume Shadows"]="吞噬暗影",
		["Convection"]="傳導",
		["Conviction"]="定罪",
		["Cooking"]="烹飪",
		["Corruption"]="腐蝕術",
		["Counterattack"]="反擊",
		["Counterspell"]="法術反制",
		["Counterspell - Silenced"] = "法術反制 - 沉默",
		["Cower"]="畏縮",
		["Create Firestone"]="製造火焰石",
--		["Create Firestone (Major)"] ="製造極效火焰石",
--		["Create Firestone (Greater)"] ="製造強效火焰石",
--		["Create Firestone (Lesser)"] ="製造次級火焰石",
		["Create Healthstone"]="製造治療石",
--		["Create Healthstone (Major)"] ="製造極效治療石",
--		["Create Healthstone (Greater)"] ="製造強效治療石",
--		["Create Healthstone (Lesser)"] ="製造次級治療石",
--		["Create Healthstone (Minor)"] ="製造初級治療石",
		["Create Soulstone"]="製造靈魂石",
--		["Create Soulstone (Major)"] ="製造極效靈魂石",
--		["Create Soulstone (Greater)"] ="製造強效靈魂石",
--		["Create Soulstone (Lesser)"] ="製造次級靈魂石",
--		["Create Soulstone (Minor)"] ="製造初級靈魂石",
		["Create Spellstone"]="製造法術石",
--		["Create Spellstone (Major)"] ="製造極效法術石",
--		["Create Spellstone (Greater)"] ="製造強效法術石",
--		["Create Spellstone (Greater)"] ="製造強效法術石",
		["Crippling Poison II"]="致殘毒藥 II",
		["Crippling Poison"]="致殘毒藥",
		["Critical Mass"]="火焰重擊",
		["Crossbows"]="弩",
		["Cruelty"]="殘忍",
--		["Crusader Aura"] = true,
--		["Crusader Strike"] = "十字軍打擊",
		["Cultivation"]="栽培",
		["Cure Disease"]="祛病術",
		["Cure Poison"]="消毒術",
		["Curse of Agony"]="痛苦詛咒",
		["Curse of Doom Effect"]="厄運詛咒效果",
		["Curse of Doom"]="厄運詛咒",
		["Curse of Exhaustion"]="疲勞詛咒",
		["Curse of Idiocy"]="癡呆詛咒",
		["Curse of Recklessness"]="魯莽詛咒",
		["Curse of Shadow"]="暗影詛咒",
		["Curse of Tongues"]="語言詛咒",
		["Curse of Weakness"]="虛弱詛咒",
		["Curse of the Elements"]="元素詛咒",
--		["Cyclone"] = "颶風術",
		["Dagger Specialization"]="匕首專精",
		["Daggers"]="匕首",
		["Dampen Magic"]="魔法抑制",
		["Dark Pact"]="黑暗契約",
		["Darkness"]="黑暗",
		["Dash"]="急奔",
		["Deadly Poison II"]="致命毒藥 II",
		["Deadly Poison III"]="致命毒藥 III",
		["Deadly Poison IV"]="致命毒藥 IV",
		["Deadly Poison V"]="致命毒藥 V",
		["Deadly Poison"]="致命毒藥",
--		["Deadly Throw"] = true,
		["Death Coil"]="死亡纏繞",
		["Death Wish"]="死亡之願",
		["Deep Wounds"]="重傷",
		["Defense"]="防禦",
		["Defensive Stance Passive"]="防禦姿態（被動）",
		["Defensive Stance"]="防禦姿態",
		["Defensive State 2"]="防禦狀態 2",
		["Defensive State"]="防禦狀態",
		["Defiance"]="挑釁",
		["Deflection"]="偏斜",
		["Demon Armor"]="魔甲術",
		["Demon Skin"]="惡魔皮膚",
		["Demonic Embrace"]="惡魔之擁",
--		["Demonic Frenzy"] = "惡魔之狂",
		["Demonic Sacrifice"]="惡魔犧牲",
		["Demoralizing Roar"]="挫志咆哮",
		["Demoralizing Shout"]="挫志怒吼",
		["Dense Sharpening Stone"]="緻密磨刀石",
		["Desperate Prayer"]="絕望禱言",
		["Destructive Reach"]="毀滅延伸",
		["Detect Greater Invisibility"]="偵測強效隱形",
		["Detect Invisibility"]="偵測隱形",
		["Detect Lesser Invisibility"]="偵測次級隱形",
		["Detect Magic"]="偵測魔法",
		["Detect Traps"]="偵測陷阱",
		["Detect"]="偵測",
		["Deterrence"]="威懾",
--		["Devastate"] = "挫敗",
		["Devastation"]="毀滅",
		["Devotion Aura"]="虔誠光環",
		["Devour Magic Effect"]="吞噬魔法效果",
		["Devour Magic"]="吞噬魔法",
		["Devouring Plague"]="噬靈瘟疫",
		["Diplomacy"]="外交",
		["Dire Bear Form"]="巨熊形態",
		["Disarm Trap"]="解除陷阱",
		["Disarm"]="繳械",
		["Disease Cleansing Totem"]="祛病圖騰",
		["Disenchant"]="分解",
		["Disengage"]="逃脫",
		["Dismiss Pet"]="解散野獸",
		["Dispel Magic"]="驅散魔法",
		["Distract"]="擾亂",
		["Distracting Shot"]="擾亂射擊",
		["Dive"]="俯衝",
		["Divine Favor"]="神恩術",
		["Divine Fury"]="神聖之怒",
--		["Divine Illumination"] = true,
		["Divine Intellect"]="神聖智慧",
		["Divine Intervention"]="神聖干涉",
		["Divine Protection"]="聖佑術",
		["Divine Shield"]="聖盾術",
		["Divine Spirit"]="神聖之靈",
		["Divine Strength"]="神聖之力",
		["Dodge"]="躲閃",
--		["Dragon's Breath"] = true,
		["Dragonscale Leatherworking"]="龍鱗製皮",
		["Drain Life"]="吸取生命",
		["Drain Mana"]="吸取法力",
		["Drain Soul"]="吸取靈魂",
		["Drink"]="喝水",
		["Dual Wield Specialization"]="雙武器專精",
		["Dual Wield"]="雙武器",
		["Duel"]="決鬥",
		["Eagle Eye"]="鷹眼術",
--		["Earth Elemental Totem"] = true,
--		["Earth Shield"] = true,
		["Earth Shock"]="地震術",
		["Earthbind Totem"]="地縛圖騰",
		["Efficiency"]="效率",
		["Elemental Focus"]="元素集中",
		["Elemental Fury"]="元素之怒",
		["Elemental Leatherworking"]="元素製皮",
		["Elemental Mastery"]="元素專精",
		["Elemental Sharpening Stone"]="元素磨刀石",
		["Elune's Grace"]="伊露恩的賜福",
		["Elusiveness"]="飄忽不定",
		["Emberstorm"]="琥珀風暴",
		["Enamored Water Spirit"] = "被迷惑的水之魂",
		["Enchanting"]="附魔",
		["Endurance Training"]="耐久訓練",
		["Endurance"]="耐久",
		["Engineering Specialization"]="工程學專精",
		["Engineering"]="工程學",
		["Enrage"]="狂怒",
		["Enriched Manna Biscuit"]="可口的魔法點心",
		["Enslave Demon"]="奴役惡魔",
		["Entangling Roots"]="糾纏根鬚",
		["Entrapment"]="誘捕",
--		["Envenom"] = true,
		["Escape Artist"]="逃命專家",
		["Evasion"]="閃避",
		["Eventide"]="黃昏",
		["Eviscerate"]="剔骨",
		["Evocation"]="喚醒",
		["Execute"]="斬殺",
		["Exorcism"]="驅邪術",
		["Expansive Mind"]="開闊思維",
		["Explosive Trap Effect"]="爆炸陷阱效果",
		["Explosive Trap"]="爆炸陷阱",
		["Expose Armor"]="破甲",
		["Eye for an Eye"]="以眼還眼",
		["Eye of Kilrogg"]="基爾羅格之眼",
		["Eyes of the Beast"]="野獸之眼",
		["Fade"]="漸隱術",
		["Faerie Fire"]="精靈之火",
		["Faerie Fire (Feral)"] = "精靈之火（野性）",
		["Far Sight"]="視界術",
		["Fear Ward"]="防護恐懼結界",
		["Fear"]="恐懼術",
		["Feed Pet"]="餵養寵物",
		["Feedback"]="回饋",
		["Feign Death"]="假死",
		["Feint"]="佯攻",
--		["Fel Armor"] = true,
		["Fel Concentration"]="惡魔專注",
		["Fel Domination"]="惡魔支配",
		["Fel Intellect"]="惡魔智力",
		["Fel Stamina"]="惡魔耐力",
		["Felfire"]="魔火",
		["Feline Grace"]="豹之優雅",
		["Feline Swiftness"]="豹之迅捷",
		["Feral Aggression"]="野性侵略",
		["Feral Charge"]="野性衝鋒",
		["Feral Instinct"]="野性本能",
		["Ferocious Bite"]="兇猛撕咬",
		["Ferocity"]="兇暴",
		["Fetish"]="塑像",
		["Find Herbs"]="尋找草藥",
		["Find Minerals"]="尋找礦物",
		["Find Treasure"]="尋找財寶",
		["Fire Blast"]="火焰衝擊",
--		["Fire Elemental Totem"] = true,
		["Fire Nova Totem"]="火焰新星圖騰",
		["Fire Power"]="火焰強化",
		["Fire Resistance Aura"]="火焰抗性光環",
		["Fire Resistance Totem"]="抗火圖騰",
		["Fire Resistance"]="火焰抗性",
		["Fire Shield"]="火焰之盾",
		["Fire Vulnerability"]="火焰易傷",
		["Fire Ward"]="防護火焰結界",
		["Fireball"]="火球術",
		["Firebolt"]="火焰箭",
		["First Aid"]="急救",
		["Fishing Poles"]="魚竿",
		["Fishing"]="釣魚",
		["Fist Weapon Specialization"]="拳套專精",
		["Fist Weapons"]="拳套",
		["Flame Shock"]="烈焰震擊",
		["Flame Throwing"]="烈焰投擲",
		["Flamestrike"]="烈焰風暴",
		["Flamethrower"]="火焰噴射器",
		["Flametongue Totem"]="火舌圖騰",
		["Flametongue Weapon"]="火舌武器",
		["Flare"]="照明彈",
		["Flash Heal"]="快速治療",
		["Flash of Light"]="聖光閃現",
--		["Flight Form"] = true,
		["Flurry"]="亂舞",
		["Focused Casting"]="專注施法",
		["Food"]="進食",
		["Forbearance"] = "自律",
--		["Force of Nature"] = "自然之力",
		["Force of Will"]="意志之力",
		["Freezing Trap Effect"]="冰凍陷阱效果",
		["Freezing Trap"]="冰凍陷阱",
		["Frenzied Regeneration"]="狂暴回復",
		["Frenzy"]="狂亂",
		["Frost Armor"]="霜甲術",
		["Frost Channeling"]="冰霜導能",
		["Frost Nova"]="Frost Nova",
		["Frost Resistance Aura"]="冰霜抗性光環",
		["Frost Resistance Totem"]="抗寒圖騰",
		["Frost Resistance"]="冰霜抗性",
		["Frost Shock"]="冰霜震擊",
		["Frost Trap"]="冰霜陷阱",
		["Frost Trap Aura"] = "冰霜陷阱光環",
		["Frost Ward"]="防護冰霜結界",
		["Frostbite"]="霜寒刺骨",
		["Frostbolt"]="寒冰箭",
		["Frostbrand Weapon"]="冰封武器",
		["Furious Howl"]="狂怒之嚎",
		["Furor"]="激怒",
		["Garrote"]="絞喉",
		["Generic"]="Generic",
		["Ghost Wolf"]="幽魂之狼",
		["Ghostly Strike"]="鬼魅攻擊",
		["Gift of Nature"]="自然賜福",
		["Gift of the Wild"]="野性賜福",
		["Gouge"]="鑿擊",
		["Grace of Air Totem"]="風之優雅圖騰",
		["Great Stamina"]="強效耐力",
		["Greater Blessing of Kings"]="強效王者祝福",
		["Greater Blessing of Light"]="強效光明祝福",
		["Greater Blessing of Might"]="強效力量祝福",
		["Greater Blessing of Salvation"]="強效拯救祝福",
		["Greater Blessing of Sanctuary"]="強效庇護祝福",
		["Greater Blessing of Wisdom"]="強效智慧祝福",
		["Greater Heal"]="強效治療術",
		["Grim Reach"]="無情延伸",
		["Grounding Totem"]="根基圖騰",
		["Grovel"]="匍匐",
		["Growl"]="低吼",
		["Guardian's Favor"]="守護者的寵愛",
		["Gun Specialization"]="槍械專精",
		["Guns"]="槍械",
		["Hammer of Justice"]="制裁之錘",
		["Hammer of Wrath"]="憤怒之錘",
		["Hamstring"]="斷筋",
		["Harass"]="侵擾",
		["Hardiness"]="堅韌",
		["Hawk Eye"]="鷹眼",
		["Heal"]="治療術",
		["Healing Focus"]="專注治療",
		["Healing Light"]="治療之光",
		["Healing Stream Totem"]="治療之泉圖騰",
		["Healing Touch"]="治療之觸",
		["Healing Wave"]="治療波",
		["Healing Way"] = "治療之路",
		["Health Funnel"]="生命通道",
		["Heart of the Wild"]="野性之心",
		["Heavy Sharpening Stone"]="重磨刀石",
		["Hellfire Effect"]="地獄烈焰效果",
		["Hellfire"]="地獄烈焰",
		["Hemorrhage"]="出血",
		["Herb Gathering"]="採集草藥",
		["Herbalism"]="草藥學",
		["Heroic Strike"]="英勇打擊",
--		["Heroism"] = "英雄",
		["Hex of Weakness"]="虛弱妖術",
		["Hibernate"]="休眠",
		["Holy Fire"]="神聖之火",
		["Holy Light"]="聖光術",
		["Holy Nova"]="神聖新星",
		["Holy Power"]="神聖強化",
		["Holy Reach"]="神聖延伸",
		["Holy Shield"]="神聖之盾",
		["Holy Shock"]="神聖震擊",
		["Holy Specialization"]="神聖專精",
		["Holy Wrath"]="神聖憤怒",
		["Honorless Target"]="無榮譽目標",
		["Horse Riding"]="騎術：馬",
		["Howl of Terror"]="恐懼嚎叫",
		["Humanoid Slaying"]="人型生物殺手",
		["Hunter's Mark"]="獵人印記",
		["Hurricane"]="颶風",
		["Ice Armor"]="冰甲術",
		["Ice Barrier"]="寒冰護體",
		["Ice Block"]="寒冰屏障",
--		["Ice Lance"] = true,
		["Ice Shards"]="寒冰碎片",
		["Ignite"]="點燃",
		["Illumination"]="啟發",
		["Immolate"]="獻祭",
		["Immolation Trap Effect"]="獻祭陷阱效果",
		["Immolation Trap"]="獻祭陷阱",
		["Impact"]="衝擊",
		["Impale"]="穿刺",
		["Improved Ambush"]="強化伏擊",
		["Improved Arcane Explosion"]="強化魔爆術",
		["Improved Arcane Missiles"]="強化祕法飛彈",
		["Improved Arcane Shot"]="強化祕法射擊",
		["Improved Aspect of the Hawk"]="強化雄鷹守護",
		["Improved Aspect of the Monkey"]="強化靈猴守護",
		["Improved Backstab"]="強化背刺",
		["Improved Battle Shout"]="強化戰鬥怒吼",
		["Improved Berserker Rage"]="強化狂暴之怒",
		["Improved Blessing of Might"]="強化力量祝福",
		["Improved Blessing of Wisdom"]="強化智慧祝福",
		["Improved Blizzard"]="強化暴風雪",
		["Improved Bloodrage"]="強化血性狂暴",
		["Improved Chain Heal"]="強化治療鍊",
		["Improved Chain Lightning"]="強化閃電鏈",
		["Improved Challenging Shout"]="強化挑戰怒吼",
		["Improved Charge"]="強化衝鋒",
		["Improved Cheap Shot"]="強化偷襲",
		["Improved Cleave"]="強化順劈斬",
		["Improved Concentration Aura"]="強化專注光環",
		["Improved Concussive Shot"]="強化震盪射擊",
		["Improved Cone of Cold"]="強化冰錐術",
		["Improved Corruption"]="強化腐蝕術",
		["Improved Counterspell"]="強化法術反制",
		["Improved Curse of Agony"]="強化痛苦詛咒",
		["Improved Curse of Exhaustion"]="強化疲勞詛咒",
		["Improved Curse of Weakness"]="強化虛弱詛咒",
		["Improved Dampen Magic"]="強化魔法抑制",
		["Improved Deadly Poison"]="強化致命毒藥",
		["Improved Demoralizing Shout"]="強化挫志怒吼",
		["Improved Devotion Aura"]="強化虔誠光環",
		["Improved Disarm"]="強化繳械",
		["Improved Distract"]="強化擾亂",
		["Improved Drain Life"]="強化吸取生命",
		["Improved Drain Mana"]="強化吸取法力",
		["Improved Drain Soul"]="強化吸取靈魂",
		["Improved Enrage"]="強化狂怒",
		["Improved Enslave Demon"]="強化奴役惡魔",
		["Improved Entangling Roots"]="強化糾纏根鬚",
		["Improved Evasion"]="強化閃避",
		["Improved Eviscerate"]="強化剔骨",
		["Improved Execute"]="強化斬殺",
		["Improved Expose Armor"]="強化破甲",
		["Improved Eyes of the Beast"]="強化野獸之眼",
		["Improved Fade"]="強化漸隱術",
		["Improved Feign Death"]="強化假死",
		["Improved Fire Blast"]="強化火焰衝擊",
		["Improved Fire Nova Totem"]="強化火焰新星圖騰",
		["Improved Fire Ward"]="強化防護火焰結界",
		["Improved Fireball"]="強化火球術",
		["Improved Firebolt"]="強化火焰箭",
		["Improved Firestone"]="強化火焰石",
		["Improved Flamestrike"]="強化烈焰風暴",
		["Improved Flametongue Weapon"]="強化火舌武器",
		["Improved Flash of Light"]="強化聖光閃現",
		["Improved Frost Nova"]="強化冰霜新星",
		["Improved Frost Ward"]="強化防護冰霜結界",
		["Improved Frostbolt"]="強化寒冰箭",
		["Improved Frostbrand Weapon"]="強化冰封武器",
		["Improved Garrote"]="強化絞喉",
		["Improved Ghost Wolf"]="強化幽魂之狼",
		["Improved Gouge"]="強化鑿擊",
		["Improved Grace of Air Totem"]="強化風之優雅圖騰",
		["Improved Grounding Totem"]="強化根基圖騰",
		["Improved Hammer of Justice"]="強化裁決之錘",
		["Improved Hamstring"]="強化斷筋",
		["Improved Healing Stream Totem"]="強化治療之泉圖騰",
		["Improved Healing Touch"]="強化治療之觸",
		["Improved Healing Wave"]="強化治療波",
		["Improved Healing"]="強化治療術",
		["Improved Health Funnel"]="強化生命通道",
		["Improved Healthstone"]="強化治療石",
		["Improved Heroic Strike"]="強化英勇打擊",
		["Improved Hunter's Mark"]="強化獵人印記",
		["Improved Immolate"]="強化獻祭",
		["Improved Imp"]="強化小鬼",
		["Improved Inner Fire"]="強化心靈之火",
		["Improved Instant Poison"]="強化速效毒藥",
		["Improved Intercept"]="強化攔截",
		["Improved Intimidating Shout"]="強化破膽怒吼",
		["Improved Judgement"]="強化審判",
		["Improved Kick"]="強化腳踢",
		["Improved Kidney Shot"]="強化腎擊",
		["Improved Lash of Pain"]="強化劇痛鞭笞",
		["Improved Lay on Hands"]="強化聖療術",
		["Improved Lesser Healing Wave"]="強化次級治療波",
		["Improved Life Tap"]="強化生命分流",
		["Improved Lightning Bolt"]="強化閃電箭",
		["Improved Lightning Shield"]="強化閃電之盾",
		["Improved Magma Totem"]="強化熔岩圖騰",
		["Improved Mana Burn"]="強化法力燃燒",
		["Improved Mana Shield"]="強化法力護盾",
		["Improved Mana Spring Totem"]="強化法力之泉圖騰",
		["Improved Mark of the Wild"]="強化野性印記",
		["Improved Mend Pet"]="強化治療寵物",
		["Improved Mind Blast"]="強化心靈震爆",
		["Improved Moonfire"]="強化月火術",
		["Improved Nature's Grasp"]="強化自然之握",
		["Improved Overpower"]="強化壓制",
		["Improved Power Word: Fortitude"]="強化真言術：韌",
		["Improved Power Word: Shield"]="強化真言術：盾",
		["Improved Prayer of Healing"]="強化治療禱言",
		["Improved Psychic Scream"]="強化心靈尖嘯",
		["Improved Pummel"]="強化拳擊",
		["Improved Regrowth"]="強化癒合",
		["Improved Reincarnation"]="強化複生",
		["Improved Rejuvenation"]="強化回春術",
		["Improved Rend"]="強化撕裂",
		["Improved Renew"]="強化恢復",
		["Improved Retribution Aura"]="強化懲罰光環",
		["Improved Revenge"]="強化復仇",
		["Improved Revive Pet"]="強化復活寵物",
		["Improved Righteous Fury"]="強化正義之怒",
		["Improved Rockbiter Weapon"]="強化石化武器",
		["Improved Rupture"]="強化割裂",
		["Improved Sap"]="強化悶棍",
		["Improved Scorch"]="強化灼燒",
		["Improved Scorpid Sting"]="強化毒蠍釘刺",
		["Improved Seal of Righteousness"]="強化正義聖印",
		["Improved Seal of the Crusader"]="強化十字軍聖印",
		["Improved Searing Pain"]="強化灼熱之痛",
		["Improved Searing Totem"]="強化灼熱圖騰",
		["Improved Serpent Sting"]="強化毒蛇釘刺",
		["Improved Shadow Bolt"]="強化暗影箭",
		["Improved Shadow Word: Pain"]="強化暗言術：痛",
		["Improved Shield Bash"]="強化盾擊",
		["Improved Shield Block"]="強化盾牌格擋",
		["Improved Shield Wall"]="強化盾牆",
		["Improved Shred"]="強化撕碎",
		["Improved Sinister Strike"]="強化邪惡攻擊",
		["Improved Slam"]="強化猛擊",
		["Improved Slice and Dice"]="強化切割",
		["Improved Spellstone"]="強化法術石",
		["Improved Sprint"]="強化疾跑",
		["Improved Starfire"]="強化星火術",
		["Improved Stoneclaw Totem"]="強化石爪圖騰",
		["Improved Stoneskin Totem"]="強化石甲圖騰",
		["Improved Strength of Earth Totem"]="強化大地之力圖騰",
		["Improved Succubus"]="強化魅魔",
		["Improved Sunder Armor"]="強化破甲攻擊",
		["Improved Taunt"]="強化嘲諷",
		["Improved Thorns"]="強化荊棘術",
		["Improved Thunder Clap"]="強化雷霆一擊",
		["Improved Tranquility"]="強化寧靜",
		["Improved Vampiric Embrace"]="強化吸血鬼的擁抱",
		["Improved Vanish"]="強化消失",
		["Improved Voidwalker"]="強化虛空行者",
		["Improved Windfury Weapon"]="強化風怒武器",
		["Improved Wing Clip"]="強化摔絆",
		["Improved Wrath"]="強化憤怒",
		["Incinerate"]="燒盡",
		["Inferno"]="地獄火",
		["Initiative"]="先發制人",
		["Inner Fire"]="心靈之火",
		["Inner Focus"]="心靈專注",
		["Innervate"]="啟動",
		["Insect Swarm"]="蟲群",
		["Inspiration"]="靈感",
		["Instant Poison II"]="速效毒藥 II",
		["Instant Poison III"]="速效毒藥 III",
		["Instant Poison IV"]="速效毒藥 IV",
		["Instant Poison V"]="速效毒藥 V",
		["Instant Poison VI"]="速效毒藥 VI",
		["Instant Poison"]="速效毒藥",
		["Intensity"]="強烈",
		["Intercept"]="攔截",
		["Intercept Stun"] = "攔截昏迷",
--		["Intervene"] = true,
		["Intimidating Shout"]="破膽怒吼",
		["Intimidation"]="脅迫",
--		["Invisibility"] = "隱形術",
		["Iron Will"]="鋼鐵意志",
		["Judgement of Command"]="命令審判",
		["Judgement of Justice"]="正義審判",
		["Judgement of Light"]="聖光審判",
		["Judgement of Righteousness"]="正義審判",
		["Judgement of Wisdom"]="智慧審判",
		["Judgement of the Crusader"]="十字軍審判",
		["Judgement"]="審判",
		["Kick"]="腳踢",
		["Kick - Silenced"] = "腳踢 - 沉默",
		["Kidney Shot"]="腎擊",
--		["Kill Command"] = true, 
		["Killer Instinct"]="殺戮本能",
		["Kodo Riding"]="騎術：科多獸",
--		["Lacerate"] = true,
		["Lash of Pain"]="劇痛鞭笞",
		["Last Stand"]="破釜沉舟",
		["Lasting Judgement"]="持久審判",
		["Lay on Hands"]="聖療術",
		["Leader of the Pack"]="獸群領袖",
		["Leather"]="皮革",
		["Leatherworking"]="製皮",
		["Lesser Heal"]="次級治療術",
		["Lesser Healing Wave"]="次級治療波",
		["Lesser Invisibility"]="次級隱形術",
		["Lethal Shots"]="奪命射擊",
		["Lethality"]="致命偷襲",
		["Levitate"]="漂浮術",
		["Libram"]="聖契",
--		["Lifebloom"] = true,
		["Life Tap"]="生命分流",
		["Lightning Bolt"]="閃電箭",
		["Lightning Breath"]="閃電吐息",
		["Lightning Mastery"]="閃電專精",
		["Lightning Reflexes"]="閃電反射",
		["Lightning Shield"]="閃電之盾",
		["Lightwell Renew"]="恢復光束泉",
		["Lightwell"]="光束泉",
		["Lockpicking"]="開鎖",
		["Long Daze"]="長時間眩暈",
		["Mace Specialization"]="錘類武器專精",
		["Mace Stun Effect"]="錘擊昏迷效果",
		["Mage Armor"]="魔甲術",
		["Magma Totem"]="熔岩圖騰",
		["Mail"]="鎖甲",
--		["Maim"] = true,
		["Malice"]="惡意",
		["Mana Burn"]="法力燃燒",
		["Mana Shield"]="法力護盾",
		["Mana Spring Totem"]="法力之泉圖騰",
		["Mana Tide Totem"]="法力之潮圖騰",
		["Mangle"]="割碎",
--		["Mangle (Cat)"] = true,
--		["Mangle (Bear)"] = true,
		["Mark of the Wild"]="野性印記",
		["Martyrdom"]="殉難",
--		["Mass Dispel"] = true,
		["Master Demonologist"]="惡魔學識大師",
		["Master Summoner"]="召喚大師",
		["Master of Deception"]="欺詐大師",
		["Maul"]="槌擊",
		["Mechanostrider Piloting"]="騎術：機械陸行鳥",
		["Meditation"]="冥想",
		["Melee Specialization"]="近戰專精",
		["Mend Pet"]="治療寵物",
		["Mental Agility"]="精神敏銳",
		["Mental Strength"]="心靈之力",
		["Mind Blast"]="心靈震爆",
		["Mind Control"]="精神控制",
		["Mind Flay"]="精神鞭笞",
		["Mind Soothe"]="安撫心靈",
		["Mind Vision"]="心靈視界",
		["Mind-numbing Poison II"]="麻痹毒藥 II",
		["Mind-numbing Poison III"]="麻痹毒藥 III",
		["Mind-numbing Poison"]="麻痹毒藥",
		["Mining"]="採礦",
--		["Misdirection"] = true,
		["Mocking Blow"]="懲戒痛擊",
--		["Molten Armor"] = true,
		["Mongoose Bite"]="貓鼬撕咬",
		["Monster Slaying"]="怪物殺手",
		["Moonfire"]="月火術",
		["Moonfury"]="月怒",
		["Moonglow"]="月光",
		["Moonkin Aura"]="梟獸光環",
		["Moonkin Form"]="梟獸形態",
		["Mortal Shots"]="致死射擊",
		["Mortal Strike"]="致死打擊",
		["Multi-Shot"]="多重射擊",
		["Murder"]="謀殺",
--		["Mutilate"] = true,
		["Natural Armor"]="自然護甲",
		["Natural Shapeshifter"]="自然變形",
		["Natural Weapons"]="武器平衡",
		["Nature Resistance Totem"]="自然抗性圖騰",
		["Nature Resistance"]="自然抗性",
		["Nature's Focus"]="自然集中",
		["Nature's Grace"]="自然之賜",
		["Nature's Grasp"]="自然之握",
		["Nature's Reach"]="自然延伸",
		["Nature's Swiftness"]="自然迅捷",
		["Nightfall"]="夜幕",
		["Omen of Clarity"]="清晰預兆",
		["One-Handed Axes"]="單手斧",
		["One-Handed Maces"]="單手錘",
		["One-Handed Swords"]="單手劍",
		["One-Handed Weapon Specialization"]="單手武器專精",
		["Opening - No Text"]="Opening - No Text",
		["Opening"]="打開",
		["Opportunity"]="伺機而動",
		["Overpower"]="壓制",
--		["Pain Suppression"] = true,
		["Paranoia"]="多疑",
		["Parry"]="招架",
		["Pathfinding"]="尋路",
		["Perception"]="感知",
		["Permafrost"]="極寒冰霜",
		["Pet Aggression"]="寵物好鬥",
		["Pet Hardiness"]="寵物耐久",
		["Pet Recovery"]="寵物恢復",
		["Pet Resistance"]="寵物抗魔",
		["Phase Shift"]="相位變換",
		["Pick Lock"]="開鎖",
		["Pick Pocket"]="偷竊",
		["Piercing Howl"]="刺耳怒吼",
		["Piercing Ice"]="刺骨寒冰",
		["Plate Mail"]="鎧甲",
		["Poison Cleansing Totem"]="清毒圖騰",
		["Poisons"]="毒藥",
		["Polearm Specialization"]="長柄武器專精",
		["Polearms"]="長柄武器",
		["Polymorph"]="變形術",
		["Polymorph: Pig"] ="變豬術",
		["Polymorph: Turtle"] ="變龜術",
		["Portal: Darnassus"]="傳送門：達納蘇斯",
		["Portal: Ironforge"]="傳送門：鐵爐堡",
		["Portal: Orgrimmar"]="傳送門：奧格瑪",
		["Portal: Stormwind"]="傳送門：暴風城",
		["Portal: Thunder Bluff"]="傳送門：雷霆崖",
		["Portal: Undercity"]="傳送門：幽暗城",
		["Pounce Bleed"]="血襲",
		["Pounce"]="突襲",
		["Power Infusion"]="注入能量",
		["Power Word: Fortitude"]="真言術：韌",
		["Power Word: Shield"]="真言術：盾",
		["Prayer of Fortitude"]="堅韌禱言",
		["Prayer of Healing"]="治療禱言",
--		["Prayer of Mending"] = true,
		["Prayer of Shadow Protection"]="暗影防護禱言",
		["Prayer of Spirit"]="精神禱言",
		["Precision"]="精確",
		["Predatory Strikes"]="猛獸攻擊",
		["Premeditation"]="預謀",
		["Preparation"]="伺機待發",
		["Presence of Mind"]="力量的證明",
		["Primal Fury"]="原始狂怒",
		["Prowl"]="潛行",
		["Psychic Scream"]="心靈尖嘯",
		["Pummel"]="拳擊",
		["Purge"]="淨化術",
		["Purification"]="淨化",
		["Purify"]="純淨術",
		["Pursuit of Justice"]="正義追擊",
		["Pyroblast"]="炎爆術",
		["Pyroclasm"]="火焰衝撞",
		["Quick Shots"] = "快速射擊",
		["Quickness"]="迅捷",
		["Rain of Fire"]="火焰之雨",
		["Rake"]="掃擊",
		["Ram Riding"]="騎術：羊",
		["Ranged Weapon Specialization"]="遠程武器專精",
		["Rapid Concealment"]="迅速隱蔽",
		["Rapid Fire"]="急速射擊",
		["Raptor Riding"]="騎術：迅猛龍",
		["Raptor Strike"]="猛禽一擊",
		["Ravage"]="毀滅",
		["Readiness"]="準備就緒",
		["Rebirth"]="複生",
		["Reckless Charge"]="無畏衝鋒",
		["Recklessness"]="魯莽",
		["Reckoning"]="清算",
		["Redemption"]="救贖",
		["Redoubt"]="盾牌壁壘",
		["Reflection"]="反射",
		["Regeneration"]="再生",
		["Regrowth"]="癒合",
		["Reincarnation"]="複生效果",
		["Rejuvenation"]="回春術",
		["Relentless Strikes"]="無情打擊",
		["Remorseless"] = "å†·é…·",
		["Remorseless Attacks"]="冷酷攻擊",
		["Remove Curse"]="解除詛咒",
		["Remove Insignia"]="解除徽記",
		["Remove Lesser Curse"]="解除次級詛咒",
		["Rend"]="撕裂",
		["Renew"]="恢復",
		["Repentance"]="懺悔",
		["Resurrection"]="復活術",
		["Retaliation"]="反擊風暴",
		["Retribution Aura"]="懲罰光環",
		["Revenge Stun"]="復仇昏迷",
		["Revenge"]="復仇",
		["Reverberation"]="迴響",
		["Revive Pet"]="復活寵物",
--		["Righteous Defense"] = true,
		["Righteous Fury"]="正義之怒",
		["Rip"]="撕扯",
		["Riposte"]="還擊",
		["Ritual of Doom Effect"]="末日儀式效果",
		["Ritual of Doom"]="末日儀式",
--		["Ritual of Souls"] = true,
		["Ritual of Summoning"]="召喚儀式",
		["Rockbiter Weapon"]="石化武器",
		["Rogue Passive"]="Rogue Passive",
		["Rough Sharpening Stone"]="劣質磨刀石",
		["Ruin"]="毀滅",
		["Rupture"]="割裂",
		["Ruthlessness"]="無情",
		["Sacrifice"]="犧牲",
		["Safe Fall"]="安全降落",
		["Sanctity Aura"]="聖潔光環",
		["Sap"]="悶棍",
		["Savage Fury"]="野蠻暴怒",
		["Savage Strikes"]="猛烈強擊",
		["Scare Beast"]="恐嚇野獸",
		["Scatter Shot"]="驅散射擊",
		["Scorch"]="灼燒",
		["Scorpid Poison"]="蠍毒",
		["Scorpid Sting"]="毒蠍釘刺",
		["Screech"]="尖嘯",
		["Seal Fate"]="封印命運",
--		["Seal of Blood"] = true,
		["Seal of Command"]="命令聖印",
		["Seal of Justice"]="公正聖印",
		["Seal of Light"]="光明聖印",
		["Seal of Righteousness"]="正義聖印",
		["Seal of Wisdom"]="智慧聖印",
		["Seal of the Crusader"]="十字軍聖印",
--		["Seal of Vengeance"] = true,
		["Searing Light"]="灼熱之光",
		["Searing Pain"]="灼熱之痛",
		["Searing Totem"]="灼熱圖騰",
--		["Second Wind"] = true,
		["Seduction"]="誘惑",
--		["Seed of Corruption"] = true,
		["Sense Demons"]="感知惡魔",
		["Sense Undead"]="感知不死生物",
		["Sentry Totem"]="崗哨圖騰",
		["Serpent Sting"]="毒蛇釘刺",
		["Setup"]="調整",
		["Shackle Undead"]="束縛不死生物",
		["Shadow Affinity"]="暗影親和",
		["Shadow Bolt"]="暗影箭",
		["Shadow Focus"]="暗影集中",
		["Shadow Mastery"]="暗影專精",
		["Shadow Protection"]="暗影防護",
		["Shadow Reach"]="暗影延伸",
		["Shadow Resistance Aura"]="暗影抗性光環",
		["Shadow Resistance"]="暗影抗性",
		["Shadow Trance"]="暗影冥思",
		["Shadow Vulnerability"] = "暗影易傷",
		["Shadow Ward"]="防護暗影結界",
		["Shadow Weaving"]="暗影之波",
--		["Shadow Word: Death"] = true,
		["Shadow Word: Pain"]="暗言術：痛",
		["Shadowburn"]="暗影灼燒",
--		["Shadowfiend"] = true,
		["Shadowform"]="暗影形態",
--		["Shadowfury"] = true,
		["Shadowguard"]="暗影守衛",
		["Shadowmeld Passive"]="影遁",
		["Shadowmeld"]="影遁",
--		["Shadowstep"] = true,
--		["Shamanistic Rage"] = true,
		["Sharpened Claws"]="鋒利獸爪",
		["Shatter"]="碎冰",
		["Sheep"]="羊",
		["Shell Shield"]="甲殼護盾",
		["Shield Bash"]="盾擊",
		["Shield Bash - Silenced"] = "盾擊 - 沉默",
		["Shield Block"]="盾牌格擋",
		["Shield Slam"]="盾牌猛擊",
		["Shield Specialization"]="盾牌專精",
		["Shield Wall"]="盾牆",
		["Shield"]="盾牌",
		["Shoot Bow"]="弓射擊",
		["Shoot Crossbow"]="弩射擊",
		["Shoot Gun"]="槍械射擊",
		["Shoot"]="射擊",
		["Shred"]="撕碎",
		["Silence"]="沉默",
--		["Silencing Shot"] = true,
		["Silent Resolve"]="無聲消退",
		["Sinister Strike"]="邪惡攻擊",
		["Siphon Life"]="生命虹吸",
		["Skinning"]="剝皮",
		["Slam"]="猛擊",
		["Sleep"]="催眠術",
		["Slice and Dice"]="切割",
--		["Slow"] = true,
		["Slow Fall"]="緩落術",
		["Smelting"]="熔煉",
		["Smite"]="懲擊",
--		["Snake Trap"] = true,
		["Solid Sharpening Stone"]="堅固的磨刀石",
		["Soothe Animal"]="安撫動物",
		["Soothing Kiss"]="安撫之吻",
		["Soul Fire"]="靈魂之火",
		["Soul Link"]="靈魂鏈結",
		["Soul Siphon"] = "靈魂虹吸",
--		["Soulshatter"] = true,
		["Soulstone Resurrection"]="靈魂石復活",
		["Spell Lock"]="法術封鎖",
--		["Spellsteal"] = true,
--		["Spell Reflection"] = true,
		["Spell Warding"]="法術護衛",
		["Spirit Bond"]="靈魂聯結",
		["Spirit Tap"]="精神分流",
		["Spirit of Redemption"]="救贖之魂",
--		["Spiritual Attunement"] = true,
		["Spiritual Focus"]="精神集中",
		["Spiritual Guidance"]="精神導引",
		["Spiritual Healing"]="精神治療",
		["Sprint"]="疾跑",
--		["Stance Mastery"] = true,
		["Starfire"]="星火術",
		["Starfire Stun"] = "星火昏迷",
		["Starshards"]="星辰碎片",
		["Staves"]="法杖",
--		["Steady Shot"] = true,
		["Stealth"]="潛行",
		["Stoneclaw Totem"]="石爪圖騰",
		["Stoneform"]="石像形態",
		["Stoneskin Totem"]="石甲圖騰",
		["Stormstrike"]="風暴打擊",
		["Strength of Earth Totem"]="大地之力圖騰",
		["Stuck"]="卡死",
		["Subtlety"]="微妙",
		["Suffering"]="受難",
		["Summon Charger"]="召喚戰馬",
		["Summon Dreadsteed"]="召喚恐懼戰馬",
--		["Summon Felguard"] = true,
		["Summon Felhunter"]="召喚地獄獵犬",
		["Summon Felsteed"]="召喚地獄戰馬",
		["Summon Imp"]="召喚小鬼",
		["Summon Succubus"]="召喚魅魔",
		["Summon Voidwalker"]="召喚虛空行者",
		["Summon Warhorse"]="召喚戰馬",
--		["Summon Water Elemental"] = true,
		["Sunder Armor"]="破甲攻擊",
		["Suppression"]="鎮壓",
		["Surefooted"]="穩固",
		["Survivalist"]="生存技能專家",
		["Sweeping Strikes"]="橫掃攻擊",
		["Swiftmend"] = "迅癒",
		["Swipe"]="揮擊",
		["Sword Specialization"]="劍類武器專精",
		["Tactical Mastery"]="戰術專精",
		["Tainted Blood"]="腐壞之血",
		["Tailoring"]="裁縫",
		["Tame Beast"]="馴服野獸",
		["Tamed Pet Passive"]="馴服野獸（被動）",
		["Taunt"]="嘲諷",
		["Teleport: Darnassus"]="傳送：達納蘇斯",
		["Teleport: Ironforge"]="傳送：鐵爐堡",
		["Teleport: Moonglade"]="傳送：月光林地",
		["Teleport: Orgrimmar"]="傳送：奧格瑪",
		["Teleport: Stormwind"]="傳送：暴風城",
		["Teleport: Thunder Bluff"]="傳送：雷霆崖",
		["Teleport: Undercity"]="傳送：幽暗城",
--		["The Beast Within"] = true,
		["The Human Spirit"]="人類精魂",
		["Thick Hide"]="厚皮",
		["Thorns"]="荊棘術",
		["Throw"]="投擲",
		["Throwing Specialization"]="投擲專精",
		["Throwing Weapon Specialization"]="投擲武器專精",
		["Thrown"]="投擲",
		["Thunder Clap"]="雷霆一擊",
		["Thundering Strikes"]="雷鳴猛擊",
		["Thunderstomp"]="雷霆踐踏",
		["Tidal Focus"]="潮汐集中",
		["Tidal Mastery"]="潮汐專精",
		["Tiger Riding"]="騎術：豹",
		["Tiger's Fury"]="猛虎之怒",
		["Torment"]="折磨",
		["Totem"]="圖騰",
		-- ["Totem of Wrath"] = true,
		["Totemic Focus"]="圖騰集中",
		["Touch of Weakness"]="虛弱之觸",
		["Toughness"]="堅韌",
		["Track Beasts"]="追蹤野獸",
		["Track Demons"]="追蹤惡魔",
		["Track Dragonkin"]="追蹤龍類",
		["Track Elementals"]="追蹤元素生物",
		["Track Giants"]="追蹤巨人",
		["Track Hidden"]="追蹤隱藏生物",
		["Track Humanoids"]="追蹤人型生物",
		["Track Undead"]="追蹤亡靈",
		["Tranquil Air Totem"]="寧靜之風圖騰",
		["Tranquil Spirit"]="寧靜之魂",
		["Tranquility"]="寧靜",
		["Tranquilizing Shot"]="寧神射擊",
		["Trap Mastery"]="陷阱掌握",
		["Travel Form"]="旅行形態",
--		["Tree of Life"] = true,
		["Tremor Totem"]="戰慄圖騰",
		["Tribal Leatherworking"]="部族製皮",
		["Trueshot Aura"]="強擊光環",
		["Turn Undead"]="超渡不死生物",
		["Two-Handed Axes and Maces"]="雙手斧和錘",
		["Two-Handed Axes"]="雙手斧",
		["Two-Handed Maces"]="雙手錘",
		["Two-Handed Swords"]="雙手劍",
		["Two-Handed Weapon Specialization"]="雙手武器專精",
		["Unarmed"]="徒手",
		["Unbreakable Will"]="堅定意志",
		["Unbridled Wrath Effect"]="怒不可遏",
		["Unbridled Wrath"]="怒不可遏",
		["Undead Horsemanship"]="騎術：骸骨戰馬",
		["Underwater Breathing"]="水下呼吸",
		["Unending Breath"]="魔息術",
		["Unholy Power"]="邪惡強化",
		["Unleashed Fury"]="狂怒釋放",
--		["Unleashed Rage"] = true,
--		["Unstable Affliction"] = true,
		["Unyielding Faith"]="不滅信仰",
		["Vampiric Embrace"]="吸血鬼的擁抱",
		["Vanish"]="消失",
		["Vanished"]="消失",
--		["Vampiric Touch"] = true,
		["Vengeance"]="復仇",
--		["Victory Rush"] = true,
		["Vigor"]="精力",
		["Vile Poisons"]="惡性毒藥",
		["Vindication"]="辯護",
		["Viper Sting"]="蝮蛇釘刺",
		["Volley"]="亂射",
		["Wand Specialization"]="魔杖專精",
		["Wands"]="魔杖",
		["War Stomp"]="戰爭踐踏",
		["Water Breathing"]="水下呼吸",
--		["Water Shield"] = true,
		["Water Walking"]="水上行走",
--		["Waterbolt"] =	true,
		["Weakened Soul"] = "虛弱靈魂",
		["Weaponsmith"]="武器鑄造",
		["Whirlwind"]="旋風斬",
		["Will of the Forsaken"]="亡靈意志",
		["Windfury Totem"]="風怒圖騰",
		["Windfury Weapon"]="風怒武器",
		["Windwall Totem"]="風牆圖騰",
		["Wing Clip"]="摔絆",
		["Winter's Chill"]="深冬之寒",
		["Wisp Spirit"]="精靈之魂",
		["Wolf Riding"]="騎術：狼",
		["Wound Poison II"]="致傷毒藥 II",
		["Wound Poison III"]="致傷毒藥 III",
		["Wound Poison IV"]="致傷毒藥 IV",
		["Wound Poison"]="致傷毒藥",
		["Wrath"]="憤怒",
		-- ["Wrath of Air Totem"] = true,
		["Wyvern Sting"]="翼龍釘刺"
	}
end)

BabbleSpell:RegisterTranslations("koKR", function()
	return {
		["Abolish Disease"] = "질병 해제",
		["Abolish Poison Effect"] = "독 해제 효과",
		["Abolish Poison"] = "독 해제",
		["Activate MG Turret"] = "",    --확인 요망
		["Adrenaline Rush"] = "아드레날린 촉진",
		["Aftermath"] = "재앙의 여파",
		["Aggression"] = "공격성",
		["Aimed Shot"] = "조준 사격",
		["Alchemy"] = "연금술",
		["Ambush"] = "매복",
		["Amplify Curse"] = "저주 증폭",
		["Amplify Magic"] = "마법 증폭",
		["Ancestral Fortitude"] = "선인의 인내력",
		["Ancestral Healing"] = "선인의 치유력",
		["Ancestral Knowledge"] = "선인의 지혜",
		["Ancestral Spirit"] = "고대의 영혼",
		["Anesthetic Poison"] = "정신 마취 독",
		["Anger Management"] = "분노 제어",
		["Anguish"] = "고통",
		["Anticipation"] = "직감",
		["Aquatic Form"] = "바다표범 변신",
		["Arcane Blast"] = "비전 작열",
		["Arcane Brilliance"] = "신비한 총명함",
		["Arcane Concentration"] = "신비한 정신집중",
		["Arcane Explosion"] = "신비한 폭발",
		["Arcane Focus"] = "신비한 집중",
		["Arcane Instability"] = "신비한 불안정성",
		["Arcane Intellect"] = "신비한 지능",
		["Arcane Meditation"] = "신비한 명상",
		["Arcane Mind"] = "신비한 정신",
		["Arcane Missiles"] = "신비한 화살",
		["Arcane Power"] = "신비의 마법 강화",
		["Arcane Resistance"] = "비전 저항력",
		["Arcane Shot"] = "신비한 사격",
		["Arcane Subtlety"] = "신비한 미묘함",
		["Arctic Reach"] = "혹한의 손길",
		["Armorsmith"] = "방어구제작",
		["Aspect of the Beast"] = "야수의 상",
		["Aspect of the Cheetah"] = "치타의 상",
		["Aspect of the Hawk"] = "매의 상",
		["Aspect of the Monkey"] = "원숭이의 상",
		["Aspect of the Pack"] = "치타 무리의 상",
		["Aspect of the Viper"] = "독사의 상",
		["Aspect of the Wild"] = "야생의 상",
		["Astral Recall"] = "영혼의 귀환",
		["Attack"] = "공격",
		["Attacking"] = "파괴 중",
		["Auto Shot"] = "자동 사격",
		["Avenger's Shield"] = "응징의 방패",
		["Avenging Wrath"] = "응징의 격노",
		["Avoidance"] = "마력 회피",
		["Axe Specialization"] = "도끼류 전문화",
		["Backlash"] = "반발력",
		["Backstab"] = "기습",
		["Bane"] = "파멸",
		["Banish"] = "추방",
		["Barkskin Effect"] = "나무 껍질 효과",    --확인 요망
		["Barkskin"] = "나무 껍질",
		["Barrage"] = "탄막",
		["Bash"] = "강타",
		["Basic Campfire"] = "작은 모닥불",
		["Battle Shout"] = "전투의 외침",
		["Battle Stance Passive"] = "전투 태세",
		["Battle Stance"] = "전투 태세",
		["Bear Form"] = "곰 변신",
		["Beast Lore"] = "야수 연구",
		["Beast Slaying"] = "야수 사냥 전문화",
		["Beast Training"] = "야수 조련",
		["Benediction"] = "축복의 기도",
		["Berserker Rage"] = "광전사의 격노",
		["Berserker Stance Passive"] = "광폭 태세 지속효과",
		["Berserker Stance"] = "광폭 태세",
		["Berserking"] = "광폭화",
		["Bestial Discipline"] = "야수 훈련",
		["Bestial Swiftness"] = "야수의 신속함",
		["Bestial Wrath"] = "야수의 격노",
		["Binding Heal"] = "결속의 치유",
		["Bite"] = "물기",
		["Black Arrow"] = "검은 화살",
		["Blackout"] = "의식 상실",
		["Blacksmithing"] = "대장기술",
		["Blade Flurry"] = "폭풍의 칼날",
		["Blast Wave"] = "화염 폭풍",
		["Blazing Speed"] = "불타는 속도",
		["Blessed Recovery"] = "축복받은 회복력",
		["Blessing of Freedom"] = "자유의 축복",
		["Blessing of Kings"] = "왕의 축복",
		["Blessing of Light"] = "빛의 축복",
		["Blessing of Might"] = "힘의 축복",
		["Blessing of Protection"] = "보호의 축복",
		["Blessing of Sacrifice"] = "희생의 축복",
		["Blessing of Salvation"] = "구원의 축복",
		["Blessing of Sanctuary"] = "성역의 축복",
		["Blessing of Wisdom"] = "지혜의 축복",
		["Blind"] = "실명",
		["Blinding Powder"] = "실명 가루",
		["Blink"] = "점멸",
		["Blizzard"] = "눈보라",
		["Block"] = "방어",
		["Blood Craze"] = "피의 광기",
		["Blood Frenzy"] = "피의 광기",
		["Blood Fury"] = "피의 격노",
		["Blood Pact"] = "피의 서약",
		["Bloodlust"] = "피의 욕망",
		["Bloodrage"] = "피의 분노",
		["Bloodthirst"] = "피의 갈증",
		["Booming Voice"] = "우렁찬 음성",
		["Bow Specialization"] = "활류 전문화",
		["Bows"] = "활",
		["Bright Campfire"] = "밝은 모닥불",
		["Brutal Impact"] = "야수의 습격",
		["Burning Soul"] = "불타는 영혼",
		["Call Pet"] = "야수 부르기",
		["Call of Flame"] = "불꽃의 부름",
		["Call of Thunder"] = "천둥의 부름",
		["Camouflage"] = "위장술",
		["Cannibalize"] = "시체먹기",
		["Cat Form"] = "표범 변신",
		["Cataclysm"] = "재앙",
		["Chain Heal"] = "연쇄 치유",
		["Chain Lightning"] = "연쇄 번개",
		["Challenging Roar"] = "도전의 포효",
		["Challenging Shout"] = "도전의 외침",
		["Charge Rage Bonus Effect"] = "보너스 분노 충전 효과",
		["Charge"] = "돌진",
		["Charge Stun"] = "돌진 기절",
		["Cheap Shot"] = "비열한 습격",
		["Chilled"] = "빙결",
		["Circle of Healing"] = "치유의 마법진",
		["Claw"] = "할퀴기",
		["Cleanse"] = "정화",
		["Clearcasting"] = "정신 집중",
		["Cleave"] = "회전베기",
		["Clever Traps"] = "덫 개량",
		["Cloak of Shadows"] = "그림자 망토",
		["Closing"] = "닫는 중",
		["Cloth"] = "천",
		["Coarse Sharpening Stone"] = "일반 숫돌",
		["Cobra Reflexes"] = "",    --확인 요망
		["Cold Blood"] = "냉혈",
		["Cold Snap"] = "매서운 한파",
		["Combat Endurance"] = "전투 지구력",
		["Combustion"] = "발화",
		["Command"] = "지배",
		["Commanding Shout"] = "지휘의 외침",
		["Concentration Aura"] = "집중의 오라",
		["Concussion Blow"] = "충격의 일격",
		["Concussion"] = "촉발",
		["Concussive Shot"] = "충격포",
		["Cone of Cold"] = "냉기 돌풍",
		["Conflagrate"] = "점화",
		["Conjure Food"] = "음식 창조",
		["Conjure Mana Agate"] = "마나 마노 창조",
		["Conjure Mana Citrine"] = "마나 황수정 창조",
		["Conjure Mana Jade"] = "마나 비취 창조",
		["Conjure Mana Ruby"] = "마나 루비 창조",
		["Conjure Water"] = "음료 창조",
		["Consecrated Sharpening Stone"] = "신성한 숫돌",
		["Consecration"] = "신성화",
		["Consume Magic"] = "마법 삼키기",
		["Consume Shadows"] = "어둠 흡수",
		["Convection"] = "기의 흐름",
		["Conviction"] = "자각",
		["Cooking"] = "요리",
		["Corruption"] = "부패",
		["Counterattack"] = "역습",
		["Counterspell"] = "마법 차단",
		["Counterspell - Silenced"] = "마법 차단 - 침묵",
		["Cower"] = "웅크리기",
		["Create Firestone"] = "화염석 창조",
		["Create Firestone (Major)"] = "화염석 창조 (최상급)",
		["Create Firestone (Greater)"] = "화염석 창조 (상급)",
		["Create Firestone (Lesser)"] = "화염석 창조 (하급)",
		["Create Healthstone"] = "생명석 창조",
		["Create Healthstone (Major)"] = "생명석 창조 (최상급)",
		["Create Healthstone (Greater)"] = "생명석 창조 (상급)",
		["Create Healthstone (Lesser)"] = "생명석 창조 (하급)",
		["Create Healthstone (Minor)"] = "생명석 창조 (최하급)",
		["Create Soulstone"] = "영혼석 창조",
		["Create Soulstone (Major)"] = "영혼석 창조 (최상급)",
		["Create Soulstone (Greater)"] = "영혼석 창조 (상급)",
		["Create Soulstone (Lesser)"] = "영혼석 창조 (하급)",
		["Create Soulstone (Minor)"] = "영혼석 창조 (최하급)",
		["Create Spellstone"] = "주문석 창조",
		["Create Spellstone (Master)"] = "주문석 창조 (일급)",
		["Create Spellstone (Major)"] = "주문석 창조 (최상급)",
		["Create Spellstone (Greater)"] = "주문석 창조 (상급)",
		["Crippling Poison II"] = "신경 마비 독 II",
		["Crippling Poison"] = "신경 마비 독",
		["Critical Mass"] = "화염 결집",
		["Crossbows"] = "석궁",
		["Cruelty"] = "무자비함",
		["Crusader Aura"] = "성전사의 오라",
		["Crusader Strike"] = "성전사의 일격",
		["Cultivation"] = "재배",
		["Cure Disease"] = "질병 치료",
		["Cure Poison"] = "해독",
		["Curse of Agony"] = "고통의 저주",
		["Curse of Doom Effect"] = "파멸의 저주 효과",
		["Curse of Doom"] = "파멸의 저주",
		["Curse of Exhaustion"] = "피로의 저주",
		["Curse of Idiocy"] = "무지의 저주",
		["Curse of Recklessness"] = "무모함의 저주",
		["Curse of Shadow"] = "어둠의 저주",
		["Curse of Tongues"] = "언어의 저주",
		["Curse of Weakness"] = "무력화 저주",
		["Curse of the Elements"] = "원소의 저주",
		["Cyclone"] = "회오리바람",
		["Dagger Specialization"] = "단검류 전문화",
		["Daggers"] = "단검",
		["Dampen Magic"] = "마법 감쇠",
		["Dark Pact"] = "암흑의 계약",
		["Darkness"] = "어둠",
		["Dash"] = "질주",
		["Deadly Poison II"] = "맹독 II",
		["Deadly Poison III"] = "맹독 III",
		["Deadly Poison IV"] = "맹독 IV",
		["Deadly Poison V"] = "맹독 V",
		["Deadly Poison"] = "맹독",
		["Deadly Throw"] = "죽음의 투척",
		["Death Coil"] = "죽음의 고리",
		["Death Wish"] = "죽음의 소원",
		["Deep Wounds"] = "치명상",
		["Defense"] = "방어",
		["Defensive Stance Passive"] = "방어 태세 지속효과",
		["Defensive Stance"] = "방어 태세",
		["Defensive State 2"] = "방어 상태 2",
		["Defensive State"] = "방어 상태",
		["Defiance"] = "도전",
		["Deflection"] = "재빠른 손놀림",
		["Demon Armor"] = "악마의 갑옷",
		["Demon Skin"] = "악마의 피부",
		["Demonic Embrace"] = "악마의 은총",
		["Demonic Frenzy"] = "악마의 광기",
		["Demonic Sacrifice"] = "악의 제물",
		["Demoralizing Roar"] = "위협의 포효",
		["Demoralizing Shout"] = "사기의 외침",
		["Dense Sharpening Stone"] = "강도 높은 숫돌",
		["Desperate Prayer"] = "구원의 기도",
		["Destructive Reach"] = "파괴의 테두리",
		["Detect Greater Invisibility"] = "상급 투명체 감지",
		["Detect Invisibility"] = "투명체 감지",
		["Detect Lesser Invisibility"] = "하급 투명체 감지",
		["Detect Magic"] = "마법 감지",
		["Detect Traps"] = "함정 감지",
		["Detect"] = "감지",
		["Deterrence"] = "공격 저지",
		["Devastate"] = "압도",
		["Devastation"] = "황폐",
		["Devotion Aura"] = "기원의 오라",
		["Devour Magic Effect"] = "마법 삼키기 효과",
		["Devour Magic"] = "마법 삼키기",
		["Devouring Plague"] = "파멸의 역병",
		["Diplomacy"] = "외교",
		["Dire Bear Form"] = "광포한 곰 변신",
		["Disarm Trap"] = "함정 해제",
		["Disarm"] = "무장 해제",
		["Disease Cleansing Totem"] = "질병 정화 토템",
		["Disenchant"] = "마력 추출",
		["Disengage"] = "철수",
		["Dismiss Pet"] = "야수 소환해제",
		["Dispel Magic"] = "마법 무효화",
		["Distract"] = "혼란",
		["Distracting Shot"] = "견제 사격",
		["Dive"] = "급강하",
		["Divine Favor"] = "신의 은총",
		["Divine Fury"] = "신의 격노",
		["Divine Illumination"] = "신의 계시",
		["Divine Intellect"] = "천상의 지능",
		["Divine Intervention"] = "성스러운 중재",
		["Divine Protection"] = "신의 가호",
		["Divine Shield"] = "천상의 보호막",
		["Divine Spirit"] = "천상의 정신",
		["Divine Strength"] = "천상의 힘",
		["Dodge"] = "회피",
		["Dragon's Breath"] = "용의 숨결",
		["Dragonscale Leatherworking"] = "용비늘 가죽세공",
		["Drain Life"] = "생명력 흡수",
		["Drain Mana"] = "마나 흡수",
		["Drain Soul"] = "영혼 흡수",
		["Drink"] = "음료",
		["Dual Wield Specialization"] = "쌍수 무기 전문화",
		["Dual Wield"] = "쌍수 무기",
		["Duel"] = "주문 7266",
		["Eagle Eye"] = "독수리의 눈",
		["Earth Elemental Totem"] = "대지의 정령 토템",
		["Earth Shield"] = "대지의 보호막",
		["Earth Shock"] = "대지 충격",
		["Earthbind Totem"] = "속박의 토템",
		["Efficiency"] = "사격술",
		["Elemental Focus"] = "정기의 집중",
		["Elemental Fury"] = "자연의 격노",
		["Elemental Leatherworking"] = "원소 가죽세공",
		["Elemental Mastery"] = "정기의 깨달음",
		["Elemental Sharpening Stone"] = "원소 숫돌",
		["Elune's Grace"] = "엘룬의 은총",
		["Elusiveness"] = "약삭빠름",
		["Emberstorm"] = "불보라",
		["Enamored Water Spirit"] = "사로잡힌 물의 정령",
		["Enchanting"] = "마법부여",
		["Endurance Training"] = "지구력 훈련",
		["Endurance"] = "인내력",
		["Engineering Specialization"] = "기계공학 전문화",
		["Engineering"] = "기계공학",
		["Enrage"] = "격노",
		["Enriched Manna Biscuit"] = "맛좋은 만나빵",
		["Enslave Demon"] = "악마 지배",
		["Entangling Roots"] = "휘감는 뿌리",
		["Entrapment"] = "올가미",
		["Envenom"] = "독살",
		["Escape Artist"] = "탈출의 명수",
		["Evasion"] = "회피",
		["Eventide"] = "자연의 가르침",
		["Eviscerate"] = "절개",
		["Evocation"] = "환기",
		["Execute"] = "마무리 일격",
		["Exorcism"] = "퇴마술",
		["Expansive Mind"] = "영리함",
		["Explosive Trap Effect"] = "폭발의 덫",
		["Explosive Trap"] = "폭발의 덫",
		["Expose Armor"] = "약점 노출",
		["Eye for an Eye"] = "눈에는 눈",
		["Eye of Kilrogg"] = "킬로그의 눈",
		["Eyes of the Beast"] = "야수의 눈",
		["Fade"] = "소실",
		["Faerie Fire"] = "요정의 불꽃",
		["Faerie Fire (Feral)"] = "요정의 불꽃 (야성)",
		["Far Sight"] = "천리안",
		["Fear Ward"] = "공포의 수호물",
		["Fear"] = "공포",
		["Feed Pet"] = "먹이주기",
		["Feedback"] = "역순환",
		["Feign Death"] = "죽은척하기",
		["Feint"] = "교란",
		["Fel Armor"] = "마의 갑옷",
		["Fel Concentration"] = "마의 정신집중",
		["Fel Domination"] = "마의 지배",
		["Fel Intellect"] = "마의 지능",
		["Fel Stamina"] = "마의 체력",
		["Felfire"] = "지옥불",
		["Feline Grace"] = "살쾡이의 우아함",
		["Feline Swiftness"] = "살쾡이의 기민함",
		["Feral Aggression"] = "야생의 공격성",
		["Feral Charge"] = "야성의 돌진",
		["Feral Instinct"] = "야생의 본능",
		["Ferocious Bite"] = "흉포한 이빨",
		["Ferocity"] = "미사용 주문",
		["Fetish"] = "",    --확인 요망
		["Find Herbs"] = "약초 찾기",
		["Find Minerals"] = "광물 찾기",
		["Find Treasure"] = "보물 찾기",
--		["Find Weakness"] = true,
		["Fire Blast"] = "화염 작열",
		["Fire Elemental Totem"] = "불의 정령 토템",
		["Fire Nova Totem"] = "불꽃 회오리 토템",
		["Fire Power"] = "화염 마법 강화",
		["Fire Resistance Aura"] = "화염 저항의 오라",
		["Fire Resistance Totem"] = "화염 저항 토템",
		["Fire Resistance"] = "화염 마법 저항",
		["Fire Shield"] = "화염 보호막",
		["Fire Vulnerability"] = "화염 저항력 약화",
		["Fire Ward"] = "화염계 수호",
		["Fireball"] = "화염구",
		["Firebolt"] = "불화살",
		["First Aid"] = "응급치료", -- CHECK
		["Fishing Poles"] = "낚싯대",
		["Fishing"] = "낚시",
		["Fist Weapon Specialization"] = "장착 무기류 전문화",
		["Fist Weapons"] = "장착 무기류",
		["Flame Shock"] = "화염 충격",
		["Flame Throwing"] = "화염 발사",
		["Flamestrike"] = "불기둥",
		["Flamethrower"] = "화염방사기",
		["Flametongue Totem"] = "불꽃의 토템",
		["Flametongue Weapon"] = "불꽃의 무기",
		["Flare"] = "섬광",
		["Flash Heal"] = "순간 치유",
		["Flash of Light"] = "빛의 섬광",
		["Flight Form"] = "폭풍까마귀 변신",
		["Flurry"] = "질풍",
		["Focused Casting"] = "집중력",
		["Food"] = "음식",
		["Forbearance"] = "참을성",
		["Force of Nature"] = "자연의 군대",
		["Force of Will"] = "의지의 힘",
		["Freezing Trap Effect"] = "얼음의 덫",
		["Freezing Trap"] = "얼음의 덫",
		["Frenzied Regeneration"] = "광포한 재생력",
		["Frenzy"] = "광기",
		["Frost Armor"] = "냉기 갑옷",
		["Frost Channeling"] = "냉기계 정신집중",
		["Frost Nova"] = "얼음 회오리",
		["Frost Resistance Aura"] = "냉기 저항의 오라",
		["Frost Resistance Totem"] = "냉기 저항 토템",
		["Frost Resistance"] = "냉기 마법 저항",
		["Frost Shock"] = "냉기 충격",
		["Frost Trap"] = "냉기의 덫",
		["Frost Trap Aura"] = "냉기의 덫",
		["Frost Ward"] = "냉기계 수호",
		["Frostbite"] = "동상",
		["Frostbolt"] = "얼음 화살",
		["Frostbrand Weapon"] = "냉기의 무기",
		["Furious Howl"] = "사나운 울음소리",
		["Furor"] = "광란",
		["Garrote"] = "목조르기",
		["Generic"] = "주문 2382",
		["Ghost Wolf"] = "늑대 정령",
		["Ghostly Strike"] = "그림자 일격",
		["Gift of Nature"] = "자연의 선물",
		["Gift of the Wild"] = "야생의 선물",
		["Gouge"] = "후려치기",
		["Grace of Air Totem"] = "은총의 토템",
		["Great Stamina"] = "강인한 체력",
		["Greater Blessing of Kings"] = "상급 왕의 축복",
		["Greater Blessing of Light"] = "상급 빛의 축복",
		["Greater Blessing of Might"] = "상급 힘의 축복",
		["Greater Blessing of Salvation"] = "상급 구원의 축복",
		["Greater Blessing of Sanctuary"] = "상급 성역의 축복",
		["Greater Blessing of Wisdom"] = "상급 지혜의 축복",
		["Greater Heal"] = "상급 치유",
		["Grim Reach"] = "냉혹의 테두리",
		["Grounding Totem"] = "마법정화 토템",
		["Grovel"] = "주문 7267",
		["Growl"] = "포효",
		["Guardian's Favor"] = "수호신의 은총",
		["Gun Specialization"] = "총기류 전문화",
		["Guns"] = "총",
		["Hammer of Justice"] = "심판의 망치",
		["Hammer of Wrath"] = "일격",
		["Hamstring"] = "무력화",
		["Harass"] = "괴롭히기",
		["Hardiness"] = "강인함",
		["Hawk Eye"] = "매의 눈",
		["Heal"] = "치유",
		["Healing Focus"] = "치유의 정신 집중",
		["Healing Light"] = "치유의 빛",
		["Healing Stream Totem"] = "치유의 토템",
		["Healing Touch"] = "치유의 손길",
		["Healing Wave"] = "치유의 물결",
		["Healing Way"] = "치유의 길",
		["Health Funnel"] = "생명력 집중",
		["Heart of the Wild"] = "야생의 정수",
		["Heavy Sharpening Stone"] = "단단한 숫돌",
		["Hellfire Effect"] = "지옥의 불길 효과",
		["Hellfire"] = "지옥의 불길",
		["Hemorrhage"] = "과다출혈",
		["Herb Gathering"] = "약초채집",
		["Herbalism"] = "약초 채집",
		["Heroic Strike"] = "영웅의 일격",
		["Heroism"] = "영웅심",
		["Hex of Weakness"] = "무력의 주술",
		["Hibernate"] = "겨울잠",
		["Holy Fire"] = "신성한 불꽃",
		["Holy Light"] = "성스러운 빛",
		["Holy Nova"] = "신성한 폭발",
		["Holy Power"] = "신성 마법 강화",
		["Holy Reach"] = "신성한 테두리",
		["Holy Shield"] = "신성 보호막",
		["Holy Shock"] = "신성 충격",
		["Holy Specialization"] = "신성 마법 전문화",
		["Holy Wrath"] = "신의 격노",
		["Honorless Target"] = "명예 점수 없음",
		["Horse Riding"] = "말 타기",
		["Howl of Terror"] = "공포의 울부짖음",
		["Humanoid Slaying"] = "인간형 사냥술",
		["Hunter's Mark"] = "사냥꾼의 징표",
		["Hurricane"] = "허리케인",
		["Ice Armor"] = "얼음 갑옷",
		["Ice Barrier"] = "얼음 보호막",
		["Ice Block"] = "얼음 방패",
		["Ice Lance"] = "얼음창",
		["Ice Shards"] = "얼음 파편",
		["Ignite"] = "작열",
		["Illumination"] = "계시",
		["Immolate"] = "제물",
		["Immolation Trap Effect"] = "제물의 덫",
		["Immolation Trap"] = "제물의 덫",
		["Impact"] = "충돌",
		["Impale"] = "꿰뚫기",
		["Improved Ambush"] = "매복 연마",
		["Improved Arcane Explosion"] = "신비한 폭발 연마",
		["Improved Arcane Missiles"] = "신비한 화살 연마",
		["Improved Arcane Shot"] = "신비한 사격 연마",
		["Improved Aspect of the Hawk"] = "매의 상 연마",
		["Improved Aspect of the Monkey"] = "원숭이의 상 연마",
		["Improved Backstab"] = "기습 연마",
		["Improved Battle Shout"] = "전투의 외침 연마",
		["Improved Berserker Rage"] = "광전사의 격노 연마",
		["Improved Blessing of Might"] = "힘의 축복 연마",
		["Improved Blessing of Wisdom"] = "지혜의 축복 연마",
		["Improved Blizzard"] = "눈보라 연마",
		["Improved Bloodrage"] = "피의 분노 연마",
		["Improved Chain Heal"] = "연쇄 치유 연마",
		["Improved Chain Lightning"] = "연쇄 번개 연마",
		["Improved Challenging Shout"] = "도전의 외침 연마",
		["Improved Charge"] = "돌진 연마",
		["Improved Cheap Shot"] = "비열한 습격 연마",
		["Improved Cleave"] = "회전베기 연마",
		["Improved Concentration Aura"] = "집중의 오라 연마",
		["Improved Concussive Shot"] = "충격포 연마",
		["Improved Cone of Cold"] = "냉기 돌풍 연마",
		["Improved Corruption"] = "부패 연마",
		["Improved Counterspell"] = "마법 차단 연마",
		["Improved Curse of Agony"] = "고통의 저주 연마",
		["Improved Curse of Exhaustion"] = "피로의 저주 연마",
		["Improved Curse of Weakness"] = "무력화 저주 연마",
		["Improved Dampen Magic"] = "마법의 조화",
		["Improved Deadly Poison"] = "맹독 연구",
		["Improved Demoralizing Shout"] = "사기의 외침 연마",
		["Improved Devotion Aura"] = "기원의 오라 연마",
		["Improved Disarm"] = "무장 해제 연마",
		["Improved Distract"] = "혼란 연마",
		["Improved Drain Life"] = "생명력 흡수 연마",
		["Improved Drain Mana"] = "마나 흡수 연마",
		["Improved Drain Soul"] = "영혼 흡수 연마",
		["Improved Enrage"] = "분노 연마",
		["Improved Enslave Demon"] = "악마 지배 연마",
		["Improved Entangling Roots"] = "휘감는 뿌리 연마",
		["Improved Evasion"] = "회피 연마",
		["Improved Eviscerate"] = "절개 연마",
		["Improved Execute"] = "마무리 일격 연마",
		["Improved Expose Armor"] = "약점 노출 연마",
		["Improved Eyes of the Beast"] = "야수의 눈 연마",
		["Improved Fade"] = "소실 연마",
		["Improved Feign Death"] = "죽은척하기 연마",
		["Improved Fire Blast"] = "화염 작열 연마",
		["Improved Fire Nova Totem"] = "불의 토템 연마",
		["Improved Fire Ward"] = "화염계 수호 연마",
		["Improved Fireball"] = "화염구 연마",
		["Improved Firebolt"] = "불화살 연마",
		["Improved Firestone"] = "화염석 연마",
		["Improved Flamestrike"] = "불기둥 연마",
		["Improved Flametongue Weapon"] = "불꽃의 무기 연마",
		["Improved Flash of Light"] = "빛의 섬광 연마",
		["Improved Frost Nova"] = "얼음 회오리 연마",
		["Improved Frost Ward"] = "냉기의 수호",
		["Improved Frostbolt"] = "얼음 화살 연마",
		["Improved Frostbrand Weapon"] = "냉기의 무기 연마",
		["Improved Garrote"] = "목 조르기 연마",
		["Improved Ghost Wolf"] = "늑대 정령 연마",
		["Improved Gouge"] = "후려치기 연마",
		["Improved Grace of Air Totem"] = "은총의 토템 연마",
		["Improved Grounding Totem"] = "마법정화 토템 연마",
		["Improved Hammer of Justice"] = "심판의 망치 연마",
		["Improved Hamstring"] = "무력화 연마",
		["Improved Healing Stream Totem"] = "치유의 토템 연마",
		["Improved Healing Touch"] = "치유의 손길 연마",
		["Improved Healing Wave"] = "치유의 물결 연마",
		["Improved Healing"] = "치유 연마",
		["Improved Health Funnel"] = "생명력 집중 연마",
		["Improved Healthstone"] = "생명석 연마",
		["Improved Heroic Strike"] = "영웅의 일격 연마",
		["Improved Hunter's Mark"] = "사냥꾼의 징표 연마",
		["Improved Immolate"] = "제물 연마",
		["Improved Imp"] = "임프 연마",
		["Improved Inner Fire"] = "내면의 열정 연마",
		["Improved Instant Poison"] = "순간 효과 독 연구",
		["Improved Intercept"] = "봉쇄 연마",
		["Improved Intimidating Shout"] = "위협의 외침 연마",
		["Improved Judgement"] = "심판 연마",
		["Improved Kick"] = "발차기 연마",
		["Improved Kidney Shot"] = "급소 가격 연마",
		["Improved Lash of Pain"] = "고통의 채찍 연마",
		["Improved Lay on Hands"] = "신의 축복 연마",
		["Improved Lesser Healing Wave"] = "치유의 집중",
		["Improved Life Tap"] = "생명력 전환 연마",
		["Improved Lightning Bolt"] = "번개 화살 연마",
		["Improved Lightning Shield"] = "번개 보호막 연마",
		["Improved Magma Totem"] = "용암 토템 연마",
		["Improved Mana Burn"] = "마나 연소 연마",
		["Improved Mana Shield"] = "마나 보호막 연마",
		["Improved Mana Spring Totem"] = "회복의 토템",
		["Improved Mark of the Wild"] = "야생의 징표 연마",
		["Improved Mend Pet"] = "동물 치료 연마",
		["Improved Mind Blast"] = "정신 분열 연마",
		["Improved Moonfire"] = "달빛 섬광 연마",
		["Improved Nature's Grasp"] = "자연의 손아귀 연마",
		["Improved Overpower"] = "제압 연마",
		["Improved Power Word: Fortitude"] = "신의 권능: 인내 연마",
		["Improved Power Word: Shield"] = "신의 권능: 보호막 연마",
		["Improved Prayer of Healing"] = "치유의 기원 연마",
		["Improved Psychic Scream"] = "영혼의 절규 연마",
		["Improved Pummel"] = "자루 공격 연마",
		["Improved Regrowth"] = "재생 연마",
		["Improved Reincarnation"] = "윤회 연마",
		["Improved Rejuvenation"] = "회복 연마",
		["Improved Rend"] = "분쇄 연마",
		["Improved Renew"] = "소생 연마",
		["Improved Retribution Aura"] = "응보의 오라 연마",
		["Improved Revenge"] = "복수 연마",
		["Improved Revive Pet"] = "야수 되살리기 연마",
		["Improved Righteous Fury"] = "정의의 격노 연마",
		["Improved Rockbiter Weapon"] = "대지의 무기 연마",
		["Improved Rupture"] = "파열 연마",
		["Improved Sap"] = "기절시키기 연마",
		["Improved Scorch"] = "불태우기 연마",
		["Improved Scorpid Sting"] = "전갈 쐐기 연마",
		["Improved Seal of Righteousness"] = "정의의 문장 연마",
		["Improved Seal of the Crusader"] = "성전사의 문장 연마",
		["Improved Searing Pain"] = "불타는 고통 연마",
		["Improved Searing Totem"] = "불타는 토템 연마",
		["Improved Serpent Sting"] = "독사 쐐기 연마",
		["Improved Shadow Bolt"] = "어둠의 화살 연마",
		["Improved Shadow Word: Pain"] = "어둠의 권능: 고통 연마",
		["Improved Shield Bash"] = "방패 가격 연마",
		["Improved Shield Block"] = "방패 막기 연마",
		["Improved Shield Wall"] = "방패의 벽 연마",
		["Improved Shred"] = "칼날 발톱 연마",
		["Improved Sinister Strike"] = "사악한 일격 연마",
		["Improved Slam"] = "격돌 연마",
		["Improved Slice and Dice"] = "난도질 연마",
		["Improved Spellstone"] = "주문석 연마",
		["Improved Sprint"] = "전력 질주 연마",
		["Improved Starfire"] = "별빛 화살 연마",
		["Improved Stoneclaw Totem"] = "대지의 올가미",
		["Improved Stoneskin Totem"] = "수호의 토템",
		["Improved Strength of Earth Totem"] = "강화의 토템",
		["Improved Succubus"] = "서큐버스 연마",
		["Improved Sunder Armor"] = "방어구 가르기 연마",
		["Improved Taunt"] = "도발 연마",
		["Improved Thorns"] = "가시 연마",
		["Improved Thunder Clap"] = "천둥벼락 연마",
		["Improved Tranquility"] = "평온 연마",
		["Improved Vampiric Embrace"] = "흡혈의 선물 연마",
		["Improved Vanish"] = "소멸 연마",
		["Improved Voidwalker"] = "보이드워커 연마",
		["Improved Windfury Weapon"] = "자연의 무기",
		["Improved Wing Clip"] = "날개 절단 연마",
		["Improved Wrath"] = "천벌 연마",
		["Incinerate"] = "소각",
		["Inferno"] = "불지옥",
		["Initiative"] = "선제 공격",
		["Inner Fire"] = "내면의 열정",
		["Inner Focus"] = "내면의 집중력",
		["Innervate"] = "정신 자극",
		["Insect Swarm"] = "곤충 떼",
		["Inspiration"] = "신의 계시",
		["Instant Poison II"] = "순간 효과 독 II",
		["Instant Poison III"] = "순간 효과 독 III",
		["Instant Poison IV"] = "순간 효과 독 IV",
		["Instant Poison V"] = "순간 효과 독 V",
		["Instant Poison VI"] = "순간 효과 독 VI",
		["Instant Poison"] = "순간 효과 독",
		["Intensity"] = "격렬",
		["Intercept"] = "봉쇄",
		["Intercept Stun"] = "봉쇄 기절",
		["Intervene"] = "가로막기",
		["Intimidating Shout"] = "위협의 외침",
		["Intimidation"] = "위협",
		["Invisibility"] = "투명화",
		["Iron Will"] = "강건한 의지",
		["Jewelcrafting"] = "보석세공",
		["Judgement of Command"] = "지휘의 심판",
		["Judgement of Justice"] = "정의의 심판",
		["Judgement of Light"] = "빛의 심판",
		["Judgement of Righteousness"] = "",    --확인 요망
		["Judgement of Wisdom"] = "지혜의 심판",
		["Judgement of the Crusader"] = "성전사의 심판",
		["Judgement"] = "심판",
		["Kick"] = "발차기",
		["Kick - Silenced"] = "발차기 - 침묵",
		["Kidney Shot"] = "급소 가격",
		["Kill Command"] = "살상 명령",
		["Killer Instinct"] = "살수의 본능",
		["Kodo Riding"] = "코도 타기",
		["Lacerate"] = "가르기",
		["Lash of Pain"] = "고통의 채찍",
		["Last Stand"] = "최후의 저항",
		["Lasting Judgement"] = "영원한 심판",
		["Lay on Hands"] = "신의 축복",
		["Leader of the Pack"] = "무리의 우두머리",
		["Leather"] = "가죽",
		["Leatherworking"] = "가죽 세공",
		["Lesser Heal"] = "하급 치유",
		["Lesser Healing Wave"] = "하급 치유의 물결",
		["Lesser Invisibility"] = "하급 투명화",
		["Lethal Shots"] = "정밀한 사격",
		["Lethality"] = "치명상",
		["Levitate"] = "공중 부양",
		["Libram"] = "성서",    --확인 요망
		["Lifebloom"] = "피어나는 생명",
		["Life Tap"] = "생명력 전환",
		["Lightning Bolt"] = "번개 화살",
		["Lightning Breath"] = "번개 숨결",
		["Lightning Mastery"] = "번개 전문화",
		["Lightning Reflexes"] = "번개같은 반사 신경",
		["Lightning Shield"] = "번개 보호막",
		["Lightwell Renew"] = "빛샘의 소생",
		["Lightwell"] = "빛샘",
		["Lockpicking"] = "자물쇠 따기",
		["Long Daze"] = "오랜 멍해짐",
		["Mace Specialization"] = "둔기류 전문화",
		["Mace Stun Effect"] = "철퇴 기절 효과",
		["Mage Armor"] = "마법사 갑옷",
		["Magma Totem"] = "용암 토템",
		["Mail"] = "사슬",
		["Maim"] = "무력화",
		["Malice"] = "원한",
		["Mana Burn"] = "마나 연소",
		["Mana Shield"] = "마나 보호막",
		["Mana Spring Totem"] = "마나샘 토템",
		["Mana Tide Totem"] = "마나 해일 토템",
		["Mangle"] = "짓이기기",
		["Mangle (Cat)"] = "짓이기기 (표범)",
		["Mangle (Bear)"] = "짓이기기 (곰)",
		["Mark of the Wild"] = "야생의 징표",
		["Martyrdom"] = "헌신",
		["Mass Dispel"] = "대규모 무효화",
		["Master Demonologist"] = "악령술의 대가",
		["Master Summoner"] = "소환의 대가",
		["Master of Deception"] = "속임수의 대가",
		["Maul"] = "후려치기",
		["Mechanostrider Piloting"] = "기계타조 조종",
		["Meditation"] = "명상",
		["Melee Specialization"] = "근접 무기 전문화",
		["Mend Pet"] = "동물 치료",
		["Mental Agility"] = "마음의 기민함",
		["Mental Strength"] = "정신력",
		["Mind Blast"] = "정신 분열",
		["Mind Control"] = "정신 지배",
		["Mind Flay"] = "정신의 채찍",
		["Mind Soothe"] = "평정",
		["Mind Vision"] = "마음의 눈",
		["Mind-numbing Poison II"] = "정신 마비 독 II",
		["Mind-numbing Poison III"] = "정신 마비 독 III",
		["Mind-numbing Poison"] = "정신 마비 독",
		["Mining"] = "채광",
		["Misdirection"] = "눈속임",
		["Mocking Blow"] = "도발의 일격",
		["Molten Armor"] = "타오르는 갑옷",
		["Mongoose Bite"] = "살쾡이의 이빨",
		["Monster Slaying"] = "몬스터 사냥술",
		["Moonfire"] = "달빛 섬광",
		["Moonfury"] = "달의 분노",
		["Moonglow"] = "달빛",
		["Moonkin Aura"] = "달빛야수 오라",
		["Moonkin Form"] = "달빛야수 변신",
		["Mortal Shots"] = "죽음의 사격",
		["Mortal Strike"] = "죽음의 일격",
		["Multi-Shot"] = "일제 사격",
		["Murder"] = "학살",
		["Mutilate"] = "절단",
		["Natural Armor"] = "무쇠 가죽",
		["Natural Shapeshifter"] = "변신의 대가",
		["Natural Weapons"] = "자연의 무기",
		["Nature Resistance Totem"] = "자연 저항 토템",
		["Nature Resistance"] = "자연 마법 저항",
		["Nature's Focus"] = "자연의 정신 집중",
		["Nature's Grace"] = "자연의 은혜",
		["Nature's Grasp"] = "자연의 손아귀",
		["Nature's Reach"] = "자연의 테두리",
		["Nature's Swiftness"] = "자연의 신속함",
		["Nightfall"] = "일몰",
		["Omen of Clarity"] = "청명의 전조",
		["One-Handed Axes"] = "한손 도끼",
		["One-Handed Maces"] = "한손 철퇴",
		["One-Handed Swords"] = "한손 검",
		["One-Handed Weapon Specialization"] = "한손 무기류 전문화",
		["Opening - No Text"] = "열기",
		["Opening"] = "열기",
		["Opportunity"] = "기회 포착",
		["Overpower"] = "제압",
		["Pain Suppression"] = "고통 억제",
		["Paranoia"] = "망상",
		["Parry"] = "무기 막기",
		["Pathfinding"] = "길 찾기",
		["Perception"] = "직관력",
		["Permafrost"] = "영구 결빙",
		["Pet Aggression"] = "야수의 공격성",
		["Pet Hardiness"] = "야수의 강인함",
		["Pet Recovery"] = "야수의 회복력",
		["Pet Resistance"] = "야수의 저항력",
		["Phase Shift"] = "위상 변화",
		["Pick Lock"] = "자물쇠 따기",
		["Pick Pocket"] = "훔치기",
		["Piercing Howl"] = "날카로운 고함",
		["Piercing Ice"] = "사무치는 냉기",
		["Plate Mail"] = "판금 갑옷",
		["Poison Cleansing Totem"] = "독 정화 토템",
		["Poisons"] = "독 조제",
		["Polearm Specialization"] = "장창류 전문화",
		["Polearms"] = "장창류",
		["Polymorph"] = "변이",
		["Polymorph: Pig"] = "변이: 돼지",
		["Polymorph: Turtle"] = "변이: 거북이",
		["Portal: Darnassus"] = "차원의 문: 다르나서스",
		["Portal: Ironforge"] = "차원의 문: 아이언포지",
		["Portal: Orgrimmar"] = "차원의 문: 오그리마",
		["Portal: Stormwind"] = "차원의 문: 스톰윈드",
		["Portal: Thunder Bluff"] = "차원의 문: 썬더 블러프",
		["Portal: Undercity"] = "차원의 문: 언더시티",
		["Pounce Bleed"] = "암습 피해",
		["Pounce"] = "암습",
		["Power Infusion"] = "마력 주입",
		["Power Word: Fortitude"] = "신의 권능: 인내",
		["Power Word: Shield"] = "신의 권능: 보호막",
		["Prayer of Fortitude"] = "인내의 기원",
		["Prayer of Healing"] = "치유의 기원",
		["Prayer of Mending"] = "회복의 기원",
		["Prayer of Shadow Protection"] = "암흑 보호의 기원",
		["Prayer of Spirit"] = "정신력의 기원",
		["Precision"] = "정밀함",
		["Predatory Strikes"] = "야생의 포식자",
		["Premeditation"] = "사전계획",
		["Preparation"] = "마음가짐",
		["Presence of Mind"] = "냉정",
		["Primal Fury"] = "야수의 분노",
		["Prowl"] = "숨기",
		["Psychic Scream"] = "영혼의 절규",
		["Pummel"] = "자루 공격",
		["Purge"] = "정화",
		["Purification"] = "심신의 정화",
		["Purify"] = "순화",
		["Pursuit of Justice"] = "심판의 추격",
		["Pyroblast"] = "불덩이 작열",
		["Pyroclasm"] = "화염 파열",
		["Quick Shots"] = "신속 사격",
		["Quickness"] = "민첩",
		["Rain of Fire"] = "불의 비",
		["Rake"] = "갈퀴 발톱",
		["Rampage"] = "광란",
		["Ram Riding"] = "산양 타기",
		["Ranged Weapon Specialization"] = "원거리 무기 전문화",
		["Rapid Concealment"] = "은신술 연마",
		["Rapid Fire"] = "속사",
		["Raptor Riding"] = "랩터 타기",
		["Raptor Strike"] = "랩터의 일격",
		["Ravage"] = "약탈",
		["Readiness"] = "만반의 준비",
		["Rebirth"] = "환생",
		["Reckless Charge"] = "무모한 돌진",
		["Recklessness"] = "무모한 희생",
		["Reckoning"] = "징벌",
		["Redemption"] = "구원",
		["Redoubt"] = "보루",
		["Reflection"] = "반사",
		["Regeneration"] = "재생력",
		["Regrowth"] = "재생",
		["Reincarnation"] = "윤회",
		["Rejuvenation"] = "회복",
		["Relentless Strikes"] = "가혹한 일격",
		["Remorseless"] = "냉혹함",
		["Remorseless Attacks"] = "냉혹함",
		["Remove Curse"] = "저주 해제",
		["Remove Insignia"] = "계급장 제거",
		["Remove Lesser Curse"] = "하급 저주 해제",
		["Rend"] = "분쇄",
		["Renew"] = "소생",
		["Repentance"] = "참회",
		["Resurrection"] = "부활",
		["Retaliation"] = "보복",
		["Retribution Aura"] = "응보의 오라",
		["Revenge Stun"] = "복수 기절",
		["Revenge"] = "복수",
		["Reverberation"] = "산울림",
		["Revive Pet"] = "야수 되살리기",
		["Righteous Defense"] = "정의의 방어",
		["Righteous Fury"] = "정의의 격노",
		["Rip"] = "도려내기",
		["Riposte"] = "반격",
		["Ritual of Doom Effect"] = "파멸의 의식",
		["Ritual of Doom"] = "파멸의 의식",
		["Ritual of Souls"] = "영혼의 의식",
		["Ritual of Summoning"] = "소환 의식",
		["Rockbiter Weapon"] = "대지의 무기",
		["Rogue Passive"] = "",    --확인 요망
		["Rough Sharpening Stone"] = "조잡한 숫돌",
		["Ruin"] = "붕괴",
		["Rupture"] = "파열",
		["Ruthlessness"] = "무정함",
		["Sacrifice"] = "희생",
		["Safe Fall"] = "낙법",
		["Sanctity Aura"] = "고결의 오라",
		["Sap"] = "기절시키기",
		["Savage Fury"] = "맹렬한 격노",
		["Savage Strikes"] = "야생의 일격",
		["Scare Beast"] = "야수 겁주기",
		["Scatter Shot"] = "산탄 사격",
		["Scorch"] = "불태우기",
		["Scorpid Poison"] = "전갈독",
		["Scorpid Sting"] = "전갈 쐐기",
		["Screech"] = "날카로운 울음소리",
		["Seal Fate"] = "운명의 낙인",
		["Seal of Blood"] = "피의 문장",
		["Seal of Command"] = "지휘의 문장",
		["Seal of Justice"] = "심판의 문장",
		["Seal of Light"] = "빛의 문장",
		["Seal of Righteousness"] = "정의의 문장",
		["Seal of Wisdom"] = "지혜의 문장",
		["Seal of the Crusader"] = "성전사의 문장",
		["Seal of Vengeance"] = "복수의 문장",
		["Searing Light"] = "타오르는 빛",
		["Searing Pain"] = "불타는 고통",
		["Searing Totem"] = "불타는 토템",
		["Second Wind"] = "재기의 바람",
		["Seduction"] = "현혹",
		["Seed of Corruption"] = "부패의 씨앗",
		["Sense Demons"] = "악마 감지",
		["Sense Undead"] = "언데드 감지",
		["Sentry Totem"] = "감시의 토템",
		["Serpent Sting"] = "독사 쐐기",
		["Setup"] = "사전 준비",
		["Shackle Undead"] = "언데드 속박",
		["Shadow Affinity"] = "암흑 마법 친화",
		["Shadow Bolt"] = "어둠의 화살",
		["Shadow Focus"] = "암흑 마법 집중",
		["Shadow Mastery"] = "암흑 마법 전문화",
		["Shadow Protection"] = "어둠의 보호",
		["Shadow Reach"] = "어둠의 테두리",
		["Shadow Resistance Aura"] = "암흑 저항의 오라",
		["Shadow Resistance"] = "암흑 마법 저항",
		["Shadow Trance"] = "어둠의 무아지경",
		["Shadow Vulnerability"] = "암흑 저항력 약화",
		["Shadow Ward"] = "암흑계 수호",
		["Shadow Weaving"] = "어둠의 매듭",
		["Shadow Word: Death"] = "어둠의 권능: 죽음",
		["Shadow Word: Pain"] = "어둠의 권능: 고통",
		["Shadowburn"] = "어둠의 연소",
		["Shadowfiend"] = "어둠의 마귀",
		["Shadowform"] = "어둠의 형상",
		["Shadowfury"] = "어둠의 격노",
		["Shadowguard"] = "어둠의 수호",
		["Shadowmeld Passive"] = "그림자 숨기",
		["Shadowmeld"] = "그림자 숨기",
		["Shadowstep"] = "그림자 걷기",
		["Shamanistic Rage"] = "주술의 분노",
		["Sharpened Claws"] = "날카로운 발톱",
		["Shatter"] = "산산조각",
		["Sheep"] = "변이",
		["Shell Shield"] = "껍질 방패",
		["Shield Bash"] = "방패 가격",
		["Shield Bash - Silenced"] = "방패 가격 - 침묵",
		["Shield Block"] = "방패 막기",
		["Shield Slam"] = "방패 밀쳐내기",
		["Shield Specialization"] = "방패 전문화",
		["Shield Wall"] = "방패의 벽",
		["Shield"] = "방패",
		["Shiv"] = "독칼",
		["Shoot Bow"] = "활 발사",
		["Shoot Crossbow"] = "석궁 발사",
		["Shoot Gun"] = "총 발사",
		["Shoot"] = "마법봉 발사",
		["Shred"] = "절단",
		["Silence"] = "침묵",
		["Silencing Shot"] = "침묵의 사격",
		["Silent Resolve"] = "무언의 결심",
		["Sinister Strike"] = "사악한 일격",
		["Siphon Life"] = "생명력 착취",
		["Skinning"] = "무두질",
		["Slam"] = "격돌",
		["Sleep"] = "수면",
		["Slice and Dice"] = "난도질",
		["Slow"] = "감속",
		["Slow Fall"] = "저속 낙하",
		["Smelting"] = "제련술",
		["Smite"] = "성스러운 일격",
		["Snake Trap"] = "뱀 덫",
		["Solid Sharpening Stone"] = "견고한 숫돌",
		["Soothe Animal"] = "동물 달래기",
		["Soothing Kiss"] = "유혹의 입맞춤",
		["Soul Fire"] = "영혼의 불꽃",
		["Soul Link"] = "영혼의 고리",
		["Soul Siphon"] = "영혼 착취",
		["Soulshatter"] = "영혼 붕괴",
		["Soulstone Resurrection"] = "영혼석 부활",
		["Spell Lock"] = "주문 잠금",
		["Spellsteal"] = "마법 훔치기",
		["Spell Reflection"] = "주문 반사",
		["Spell Warding"] = "주문 수호",
		["Spirit Bond"] = "정신의 결속",
		["Spirit Tap"] = "정신력 누출",
		["Spirit of Redemption"] = "구원의 영혼",
		["Spiritual Attunement"] = "영혼의 조화",
		["Spiritual Focus"] = "영적인 집중력",
		["Spiritual Guidance"] = "영혼의 길잡이",
		["Spiritual Healing"] = "영혼의 치유",
		["Sprint"] = "전력 질주",
		["Stance Mastery"] = "태세 숙련",
		["Starfire"] = "별빛 화살",
		["Starfire Stun"] = "별빛 화살 기절",
		["Starshards"] = "별조각",
		["Staves"] = "지팡이",
		["Steady Shot"] = "고정 사격",
		["Stealth"] = "은신",
		["Stoneclaw Totem"] = "돌발톱 토템",
		["Stoneform"] = "석화",
		["Stoneskin Totem"] = "돌가죽 토템",
		["Stormstrike"] = "폭풍의 일격",
		["Strength of Earth Totem"] = "대지력 토템",
		["Stuck"] = "고립 상태 벗어나기",
		["Subtlety"] = "영혼의 길잡이",
		["Suffering"] = "고통",
		["Summon Charger"] = "군마 소환",
		["Summon Dreadsteed"] = "공포마 소환",
		["Summon Felguard"] = "지옥수호병 소환",
		["Summon Felhunter"] = "지옥사냥개 소환",
		["Summon Felsteed"] = "지옥마 소환",
		["Summon Imp"] = "임프 소환",
		["Summon Succubus"] = "서큐버스 소환",
		["Summon Voidwalker"] = "보이드워커 소환",
		["Summon Warhorse"] = "군마 소환",
		["Summon Water Elemental"] = "물의 정령 소환",
		["Sunder Armor"] = "방어구 가르기",
		["Suppression"] = "억제",
		["Surefooted"] = "침착함",
		["Survivalist"] = "생존의 대가",
		["Sweeping Strikes"] = "휩쓸기 일격",
		["Swiftmend"] = "신속한 치유",
		["Swipe"] = "휘둘러치기",
		["Sword Specialization"] = "도검류 전문화",
		["Tactical Mastery"] = "전술 숙련",
		["Tainted Blood"] = "얼룩진 피",
		["Tailoring"] = "재봉술",
		["Tame Beast"] = "야수 길들이기",
		["Tamed Pet Passive"] = "",    --확인 요망
		["Taunt"] = "도발",
		["Teleport: Darnassus"] = "순간이동: 다르나서스",
		["Teleport: Ironforge"] = "순간이동: 아이언포지",
		["Teleport: Moonglade"] = "순간이동: 달의 숲",
		["Teleport: Orgrimmar"] = "순간이동: 오그리마",
		["Teleport: Stormwind"] = "순간이동: 스톰윈드",
		["Teleport: Thunder Bluff"] = "순간이동: 썬더 블러프",
		["Teleport: Undercity"] = "순간이동: 언더시티",
		["The Beast Within"] = "내면의 야수",
		["The Human Spirit"] = "인간의 정신력",
		["Thick Hide"] = "두꺼운 가죽",
		["Thorns"] = "가시",
		["Throw"] = "투척",
		["Throwing Specialization"] = "투척술 전문화",
		["Throwing Weapon Specialization"] = "투척 무기류 전문화",
		["Thrown"] = "투척",
		["Thunder Clap"] = "천둥벼락",
		["Thundering Strikes"] = "우레의 일격",
		["Thunderstomp"] = "천둥 발구르기",
		["Tidal Focus"] = "해일의 집중",
		["Tidal Mastery"] = "해일의 깨달음",
		["Tiger Riding"] = "호랑이 타기",
		["Tiger's Fury"] = "맹공격",
		["Torment"] = "고문",
		["Totem"] = "토템",
		["Totem of Wrath"] = "격노의 토템",
		["Totemic Focus"] = "토템 집중",
		["Touch of Weakness"] = "무력의 손길",
		["Toughness"] = "강인함",
		["Track Beasts"] = "야수 추적",
		["Track Demons"] = "악마 추적",
		["Track Dragonkin"] = "용족 추적",
		["Track Elementals"] = "정령 추적",
		["Track Giants"] = "거인 추적",
		["Track Hidden"] = "은신 추적",
		["Track Humanoids"] = "인간형 추적",
		["Track Undead"] = "언데드 추적",
		["Tranquil Air Totem"] = "평온의 토템",
		["Tranquil Spirit"] = "평온한 정신",
		["Tranquility"] = "평온",
		["Tranquilizing Shot"] = "평정의 사격",
		["Trap Mastery"] = "덫 숙련",
		["Travel Form"] = "치타 변신",
		["Tree of Life"] = "생명의 나무",
		["Tremor Totem"] = "진동의 토템",
		["Tribal Leatherworking"] = "전통 가죽세공",
		["Trueshot Aura"] = "정조준 오라",
		["Turn Undead"] = "언데드 퇴치",
		["Two-Handed Axes and Maces"] = "양손 도끼류 및 둔기류",
		["Two-Handed Axes"] = "양손 도끼",
		["Two-Handed Maces"] = "양손 철퇴",
		["Two-Handed Swords"] = "양손 검",
		["Two-Handed Weapon Specialization"] = "양손 무기류 전문화",
		["Unarmed"] = "맨손",
		["Unbreakable Will"] = "굳은 의지",
		["Unbridled Wrath Effect"] = "분노 해방",
		["Unbridled Wrath"] = "분노 해방",
		["Undead Horsemanship"] = "언데드 승마술",
		["Underwater Breathing"] = "수중 호흡",
		["Unending Breath"] = "영원의 숨결",
		["Unholy Power"] = "부정의 힘",
		["Unleashed Fury"] = "격노 폭발",
		["Unleashed Rage"] = "해방된 분노",
		["Unstable Affliction"] = "불안정한 고통",
		["Unyielding Faith"] = "굳은 신념",
		["Vampiric Embrace"] = "흡혈의 선물",
		["Vanish"] = "소멸",
		["Vanished"] = "소멸",
		["Vampiric Touch"] = "흡혈의 손길",
		["Vengeance"] = "복수",
		["Victory Rush"] = "승리의 돌진",
		["Vigor"] = "강한 체력",
		["Vile Poisons"] = "치명적인 독",
		["Vindication"] = "비호",
		["Viper Sting"] = "살무사 쐐기",
		["Volley"] = "연발 사격",
		["Wand Specialization"] = "마법봉류 전문화",
		["Wands"] = "마법봉",
		["War Stomp"] = "전투 발구르기",
		["Water Breathing"] = "수중 호흡",
		["Water Shield"] = "물의 보호막",
		["Water Walking"] = "수면 걷기",
		["Waterbolt"] =	"물화살",
		["Weakened Soul"] = "약화된 영혼",
		["Weaponsmith"] = "무기제작",
		["Whirlwind"] = "소용돌이",
		["Will of the Forsaken"] = "포세이큰의 의지",
		["Windfury Totem"] = "질풍의 토템",
		["Windfury Weapon"] = "질풍의 무기",
		["Windwall Totem"] = "바람막이 토템",
		["Wing Clip"] = "날개 절단",
		["Winter's Chill"] = "혹한의 추위",
		["Wisp Spirit"] = "위습의 영혼",
		["Wolf Riding"] = "늑대 타기",
		["Wound Poison II"] = "상처 감염 독 II",
		["Wound Poison III"] = "상처 감염 독 III",
		["Wound Poison IV"] = "상처 감염 독 IV",
		["Wound Poison"] = "상처 감염 독",
		["Wrath"] = "천벌",
		["Wrath of Air Totem"] = "천벌의 토템",
		["Wyvern Sting"] = "비룡 쐐기",
	}
end)

local spellIcons = {
	["Abolish Disease"] = "Spell_Nature_NullifyDisease",
	["Abolish Poison Effect"] = "Spell_Nature_NullifyPoison_02",
	["Abolish Poison"] = "Spell_Nature_NullifyPoison_02",
	["Activate MG Turret"] = "INV_Weapon_Rifle_10",
	["Adrenaline Rush"] = "Spell_Shadow_ShadowWordDominate",
	["Aftermath"] = "Spell_Fire_Fire",
	["Aggression"] = "Ability_Racial_Avatar",
	["Aimed Shot"] = "INV_Spear_07",
	["Alchemy"] = "Trade_Alchemy",
	["Ambush"] = "Ability_Rogue_Ambush",
	["Amplify Curse"] = "Spell_Shadow_Contagion",
	["Amplify Magic"] = "Spell_Holy_FlashHeal",
	["Ancestral Healing"] = "Spell_Nature_UndyingStrength",
	["Ancestral Knowledge"] = "Spell_Shadow_GrimWard",
	["Ancestral Spirit"] = "Spell_Nature_Regenerate",
--	["Anesthetic Poison"] = true,
	["Anger Management"] = "Spell_Holy_BlessingOfStamina",
--	["Anguish"] = true,
	["Anticipation"] = "Spell_Nature_MirrorImage",
	["Aquatic Form"] = "Ability_Druid_AquaticForm",
--	["Arcane Blast"] = true,
	["Arcane Brilliance"] = "Spell_Holy_ArcaneIntellect",
	["Arcane Concentration"] = "Spell_Shadow_ManaBurn",
	["Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Arcane Focus"] = "Spell_Holy_Devotion",
	["Arcane Instability"] = "Spell_Shadow_Teleport",
	["Arcane Intellect"] = "Spell_Holy_MagicalSentry",
	["Arcane Meditation"] = "Spell_Shadow_SiphonMana",
	["Arcane Mind"] = "Spell_Shadow_Charm",
	["Arcane Missiles"] = "Spell_Nature_StarFall",
	["Arcane Power"] = "Spell_Nature_Lightning",
	["Arcane Resistance"] = "Spell_Nature_StarFall",
	["Arcane Shot"] = "Ability_ImpalingBolt",
	["Arcane Subtlety"] = "Spell_Holy_DispelMagic",
	["Arctic Reach"] = "Spell_Shadow_DarkRitual",
	["Armor of Faith"] = "Spell_Holy_BlessingOfProtection",
	["Aspect of the Beast"] = "Ability_Mount_PinkTiger",
	["Aspect of the Cheetah"] = "Ability_Mount_JungleTiger",
	["Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Aspect of the Pack"] = "Ability_Mount_WhiteTiger",
--	["Aspect of the Viper"] = true,
	["Aspect of the Wild"] = "Spell_Nature_ProtectionformNature",
	["Astral Recall"] = "Spell_Nature_AstralRecal",
	["Attack"] = "Temp",
	["Attacking"] = "Temp",
	["Auto Shot"] = "Ability_Whirlwind",
--	["Avenger's Shield"] = true,
--	["Avenging Wrath"] = true,
--	["Avoidance"] = true,
	["Axe Specialization"] = "INV_Axe_06",
--	["Backlash"] = true,
	["Backstab"] = "Ability_BackStab",
	["Bane"] = "Spell_Shadow_DeathPact",
	["Banish"] = "Spell_Shadow_Cripple",
	["Barkskin Effect"] = "Spell_Nature_StoneClawTotem",
	["Barkskin"] = "Spell_Nature_StoneClawTotem",
	["Barrage"] = "Ability_UpgradeMoonGlaive",
	["Bash"] = "Ability_Druid_Bash",
	["Basic Campfire"] = "Spell_Fire_Fire",
	["Battle Shout"] = "Ability_Warrior_BattleShout",
	["Battle Stance Passive"] = "Ability_Warrior_OffensiveStance",
	["Battle Stance"] = "Ability_Warrior_OffensiveStance",
	["Bear Form"] = "Ability_Racial_BearForm",
	["Beast Lore"] = "Ability_Physical_Taunt",
	["Beast Slaying"] = "INV_Misc_Pelt_Bear_Ruin_02",
	["Beast Training"] = "Ability_Hunter_BeastCall02",
	["Benediction"] = "Spell_Frost_WindWalkOn",
	["Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Berserker Stance Passive"] = "Ability_Racial_Avatar",
	["Berserker Stance"] = "Ability_Racial_Avatar",
	["Berserking"] = "Racial_Troll_Berserk",
	["Bestial Discipline"] = "Spell_Nature_AbolishMagic",
	["Bestial Swiftness"] = "Ability_Druid_Dash",
	["Bestial Wrath"] = "Ability_Druid_FerociousBite",
--	["Binding Heal"] = true,
	["Bite"] = "Ability_Racial_Cannibalize",
	["Black Arrow"] = "Ability_TheBlackArrow",
	["Blackout"] = "Spell_Shadow_GatherShadows",
	["Blacksmithing"] = "Trade_BlackSmithing",
	["Blade Flurry"] = "Ability_Warrior_PunishingBlow",
	["Blast Wave"] = "Spell_Holy_Excorcism_02",
--	["Blazing Speed"] = true,
	["Blessed Recovery"] = "Spell_Holy_BlessedRecovery",
	["Blessing of Freedom"] = "Spell_Holy_SealOfValor",
	["Blessing of Kings"] = "Spell_Magic_MageArmor",
	["Blessing of Light"] = "Spell_Holy_PrayerOfHealing02",
	["Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Blessing of Protection"] = "Spell_Holy_SealOfProtection",
	["Blessing of Sacrifice"] = "Spell_Holy_SealOfSacrifice",
	["Blessing of Salvation"] = "Spell_Holy_SealOfSalvation",
	["Blessing of Sanctuary"] = "Spell_Nature_LightningShield",
	["Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Blind"] = "Spell_Shadow_MindSteal",
	["Blinding Powder"] = "INV_Misc_Ammo_Gunpowder_02",
	["Blink"] = "Spell_Arcane_Blink",
	["Blizzard"] = "Spell_Frost_IceStorm",
	["Block"] = "Ability_Defend",
	["Blood Craze"] = "Spell_Shadow_SummonImp",
	["Blood Frenzy"] = "Ability_GhoulFrenzy",
	["Blood Fury"] = "Racial_Orc_BerserkerStrength",
	["Blood Pact"] = "Spell_Shadow_BloodBoil",
--	["Bloodlust"] = true,
	["Bloodrage"] = "Ability_Racial_BloodRage",
	["Bloodthirst"] = "Spell_Nature_BloodLust",
	["Booming Voice"] = "Spell_Nature_Purge",
	["Bow Specialization"] = "INV_Weapon_Bow_12",
	["Bows"] = "INV_Weapon_Bow_05",
	["Bright Campfire"] = "Spell_Fire_Fire",
	["Brutal Impact"] = "Ability_Druid_Bash",
	["Burning Soul"] = "Spell_Fire_Fire",
	["Call Pet"] = "Ability_Hunter_BeastCall",
	["Call of Flame"] = "Spell_Fire_Immolation",
	["Call of Thunder"] = "Spell_Nature_CallStorm",
	["Camouflage"] = "Ability_Stealth",
	["Cannibalize"] = "Ability_Racial_Cannibalize",
	["Cat Form"] = "Ability_Druid_CatForm",
	["Cataclysm"] = "Spell_Fire_WindsofWoe",
	["Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Challenging Roar"] = "Ability_Druid_ChallangingRoar",
	["Challenging Shout"] = "Ability_BullRush",
	["Charge Rage Bonus Effect"] = "Ability_Warrior_Charge",
	["Charge"] = "Ability_Warrior_Charge",
	["Cheap Shot"] = "Ability_CheapShot",
	["Chilled"] = "Spell_Frost_IceStorm",
	["Circle of Healing"] = "Spell_Holy_CircleOfRenewal",
	["Claw"] = "Ability_Druid_Rake",
	["Cleanse"] = "Spell_Holy_Renew",
	["Clearcasting"] = "Spell_Shadow_ManaBurn",
	["Cleave"] = "Ability_Warrior_Cleave",
	["Clever Traps"] = "Spell_Nature_TimeStop",
--	["Cloak of Shadows"] = true,
	["Closing"] = "Temp",
	["Cloth"] = "INV_Chest_Cloth_21",
	["Cobra Reflexes"] = "Spell_Nature_GuardianWard",
	["Cold Blood"] = "Spell_Ice_Lament",
	["Cold Snap"] = "Spell_Frost_WizardMark",
	["Combat Endurance"] = "Spell_Nature_AncestralGuardian",
	["Combustion"] = "Spell_Fire_SealOfFire",
	["Command"] = "Ability_Warrior_WarCry",
--	["Commanding Shout"] = true,
	["Concentration Aura"] = "Spell_Holy_MindSooth",
	["Concussion Blow"] = "Ability_ThunderBolt",
	["Concussion"] = "Spell_Fire_Fireball",
	["Concussive Shot"] = "Spell_Frost_Stun",
	["Cone of Cold"] = "Spell_Frost_Glacier",
	["Conflagrate"] = "Spell_Fire_Fireball",
	["Conjure Food"] = "INV_Misc_Food_10",
	["Conjure Mana Agate"] = "INV_Misc_Gem_Emerald_01",
	["Conjure Mana Citrine"] = "INV_Misc_Gem_Opal_01",
	["Conjure Mana Jade"] = "INV_Misc_Gem_Emerald_02",
	["Conjure Mana Ruby"] = "INV_Misc_Gem_Ruby_01",
	["Conjure Water"] = "INV_Drink_06",
	["Consecration"] = "Spell_Holy_InnerFire",
--	["Consume Magic"] = true,
	["Consume Shadows"] = "Spell_Shadow_AntiShadow",
	["Convection"] = "Spell_Nature_WispSplode",
	["Conviction"] = "Spell_Holy_RetributionAura",
	["Cooking"] = "INV_Misc_Food_15",
	["Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Counterattack"] = "Ability_Warrior_Challange",
	["Counterspell"] = "Spell_Frost_IceShock",
	["Cower"] = "Ability_Druid_Cower",
	["Create Firestone (Lesser)"]="INV_Ammo_FireTar",
	["Create Firestone"]="INV_Ammo_FireTar",
	["Create Firestone (Greater)"]="INV_Ammo_FireTar",
	["Create Firestone (Major)"]="INV_Ammo_FireTar",
	["Create Healthstone (Minor)"]="INV_Stone_04",
	["Create Healthstone (Lesser)"]="INV_Stone_04",
	["Create Healthstone"]="INV_Stone_04",
	["Create Healthstone (Greater)"]="INV_Stone_04",
	["Create Healthstone (Major)"]="INV_Stone_04",
	["Create Soulstone (Minor)"]="Spell_Shadow_SoulGem",
	["Create Soulstone (Lesser)"]="Spell_Shadow_SoulGem",
	["Create Soulstone"]="Spell_Shadow_SoulGem",
	["Create Soulstone (Greater)"]="Spell_Shadow_SoulGem",
	["Create Soulstone (Major)"]="Spell_Shadow_SoulGem",
	["Create Spellstone"]="INV_Misc_Gem_Sapphire_01",
--	["Create Spellstone (Master)"] = true,
	["Create Spellstone (Greater)"]="INV_Misc_Gem_Sapphire_01",
	["Create Spellstone (Major)"]="INV_Misc_Gem_Sapphire_01",
	["Crippling Poison II"] = "Ability_PoisonSting",
	["Crippling Poison"] = "Ability_PoisonSting",
	["Critical Mass"] = "Spell_Nature_WispHeal",
	["Crossbows"] = "INV_Weapon_Crossbow_01",
	["Cruelty"] = "Ability_Rogue_Eviscerate",
--	["Crusader Aura"] = true,
--	["Crusader Strike"] = true,
	["Cultivation"] = "INV_Misc_Flower_01",
	["Cure Disease"] = "Spell_Holy_NullifyDisease",
	["Cure Poison"] = "Spell_Nature_NullifyPoison",
	["Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Curse of Doom Effect"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Doom"] = "Spell_Shadow_AuraOfDarkness",
	["Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Curse of Idiocy"] = "Spell_Shadow_MindRot",
	["Curse of Recklessness"] = "Spell_Shadow_UnholyStrength",
	["Curse of Shadow"] = "Spell_Shadow_CurseOfAchimonde",
	["Curse of Tongues"] = "Spell_Shadow_CurseOfTounges",
	["Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Curse of the Elements"] = "Spell_Shadow_ChillTouch",
--	["Cyclone"] = true,
	["Dagger Specialization"] = "INV_Weapon_ShortBlade_05",
	["Daggers"] = "Ability_SteelMelee",
	["Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Dark Pact"] = "Spell_Shadow_DarkRitual",
	["Darkness"] = "Spell_Shadow_Twilight",
	["Dash"] = "Ability_Druid_Dash",
	["Deadly Poison II"] = "Ability_Rogue_DualWeild",
	["Deadly Poison III"] = "Ability_Rogue_DualWeild",
	["Deadly Poison IV"] = "Ability_Rogue_DualWeild",
	["Deadly Poison V"] = "Ability_Rogue_DualWeild",
	["Deadly Poison"] = "Ability_Rogue_DualWeild",
--	["Deadly Throw"] = true,
	["Death Coil"] = "Spell_Shadow_DeathCoil",
	["Death Wish"] = "Spell_Shadow_DeathPact",
	["Deep Wounds"] = "Ability_BackStab",
	["Defense"] = "Ability_Racial_ShadowMeld",
	["Defensive Stance Passive"] = "Ability_Warrior_DefensiveStance",
	["Defensive Stance"] = "Ability_Warrior_DefensiveStance",
	["Defensive State 2"] = "Ability_Defend",
	["Defensive State"] = "Ability_Defend",
	["Defiance"] = "Ability_Warrior_InnerRage",
	["Deflection"] = "Ability_Parry",
	["Demon Armor"] = "Spell_Shadow_RagingScream",
	["Demon Skin"] = "Spell_Shadow_RagingScream",
	["Demonic Embrace"] = "Spell_Shadow_Metamorphosis",
--	["Demonic Frenzy"] = true,
	["Demonic Sacrifice"] = "Spell_Shadow_PsychicScream",
	["Demoralizing Roar"] = "Ability_Druid_DemoralizingRoar",
	["Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Desperate Prayer"] = "Spell_Holy_Restoration",
	["Destructive Reach"] = "Spell_Shadow_CorpseExplode",
	["Detect Greater Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Invisibility"] = "Spell_Shadow_DetectInvisibility",
	["Detect Lesser Invisibility"] = "Spell_Shadow_DetectLesserInvisibility",
	["Detect Magic"] = "Spell_Holy_Dizzy",
	["Detect Traps"] = "Ability_Spy",
	["Detect"] = "Ability_Hibernation",
	["Deterrence"] = "Ability_Whirlwind",
--	["Devastate"] = true,
	["Devastation"] = "Spell_Fire_FlameShock",
	["Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Devour Magic Effect"] = "Spell_Nature_Purge",
	["Devour Magic"] = "Spell_Nature_Purge",
	["Devouring Plague"] = "Spell_Shadow_BlackPlague",
	["Diplomacy"] = "INV_Misc_Note_02",
	["Dire Bear Form"] = "Ability_Racial_BearForm",
	["Disarm Trap"] = "Spell_Shadow_GrimWard",
	["Disarm"] = "Ability_Warrior_Disarm",
	["Disease Cleansing Totem"] = "Spell_Nature_DiseaseCleansingTotem",
	["Disenchant"] = "Spell_Holy_RemoveCurse",
	["Disengage"] = "Ability_Rogue_Feint",
	["Dismiss Pet"] = "Spell_Nature_SpiritWolf",
	["Dispel Magic"] = "Spell_Holy_DispelMagic",
	["Distract"] = "Ability_Rogue_Distract",
	["Distracting Shot"] = "Spell_Arcane_Blink",
	["Dive"] = "Spell_Shadow_BurningSpirit",
	["Divine Favor"] = "Spell_Holy_Heal",
	["Divine Fury"] = "Spell_Holy_SealOfWrath",
--	["Divine Illumination"] = true,
--	["Divine Intellect"] = "Spell_Nature_Sleep",
	["Divine Intervention"] = "Spell_Nature_TimeStop",
	["Divine Protection"] = "Spell_Holy_Restoration",
	["Divine Shield"] = "Spell_Holy_DivineIntervention",
	["Divine Spirit"] = "Spell_Holy_DivineSpirit",
	["Divine Strength"] = "Ability_GolemThunderClap",
	["Dodge"] = "Spell_Nature_Invisibilty",
--	["Dragon's Breath"] = true,
--	["Dragonscale Leatherworking"] = true,	
	["Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Drain Soul"] = "Spell_Shadow_Haunting",
	["Dual Wield Specialization"] = "Ability_DualWield",
	["Dual Wield"] = "Ability_DualWield",
	["Duel"] = "Temp",
	["Eagle Eye"] = "Ability_Hunter_EagleEye",
--	["Earth Elemental Totem"] = true,
--	["Earth Shield"] = true,
	["Earth Shock"] = "Spell_Nature_EarthShock",
	["Earthbind Totem"] = "Spell_Nature_StrengthOfEarthTotem02",
	["Efficiency"] = "Spell_Frost_WizardMark",
	["Elemental Focus"] = "Spell_Shadow_ManaBurn",
	["Elemental Fury"] = "Spell_Fire_Volcano",
	["Elemental Mastery"] = "Spell_Nature_WispHeal",
	["Elune's Grace"] = "Spell_Holy_ElunesGrace",
	["Elusiveness"] = "Spell_Magic_LesserInvisibilty",
	["Emberstorm"] = "Spell_Fire_SelfDestruct",
	["Enchanting"] = "Trade_Engraving",
	["Endurance Training"] = "Spell_Nature_Reincarnation",
	["Endurance"] = "Spell_Nature_UnyeildingStamina",
	["Engineering Specialization"] = "INV_Misc_Gear_01",
	["Engineering"] = "Trade_Engineering",
	["Enrage"] = "Ability_Druid_Enrage",
	["Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Entrapment"] = "Spell_Nature_StrangleVines",
--	["Envenom"] = true,
	["Escape Artist"] = "Ability_Rogue_Trip",
	["Evasion"] = "Spell_Shadow_ShadowWard",
	["Eventide"] = "Spell_Frost_Stun",
	["Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Evocation"] = "Spell_Nature_Purge",
	["Execute"] = "INV_Sword_48",
	["Exorcism"] = "Spell_Holy_Excorcism_02",
	["Expansive Mind"] = "INV_Enchant_EssenceEternalLarge",
	["Explosive Trap Effect"] = "Spell_Fire_SelfDestruct",
	["Explosive Trap"] = "Spell_Fire_SelfDestruct",
	["Expose Armor"] = "Ability_Warrior_Riposte",
	["Eye for an Eye"] = "Spell_Holy_EyeforanEye",
	["Eye of Kilrogg"] = "Spell_Shadow_EvilEye",
	["Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Fade"] = "Spell_Magic_LesserInvisibilty",
	["Faerie Fire"] = "Spell_Nature_FaerieFire",
	["Far Sight"] = "Spell_Nature_FarSight",
	["Fear Ward"] = "Spell_Holy_Excorcism",
	["Fear"] = "Spell_Shadow_Possession",
	["Feed Pet"] = "Ability_Hunter_BeastTraining",
	["Feedback"] = "Spell_Shadow_RitualOfSacrifice",
	["Feign Death"] = "Ability_Rogue_FeignDeath",
	["Feint"] = "Ability_Rogue_Feint",
--	["Fel Armor"] = true,
	["Fel Concentration"] = "Spell_Shadow_FingerOfDeath",
	["Fel Domination"] = "Spell_Nature_RemoveCurse",
	["Fel Intellect"] = "Spell_Holy_MagicalSentry",
	["Fel Stamina"] = "Spell_Shadow_AntiShadow",
	["Felfire"] = "Spell_Fire_Fireball",
	["Feline Grace"] = "INV_Feather_01",
	["Feline Swiftness"] = "Spell_Nature_SpiritWolf",
	["Feral Aggression"] = "Ability_Druid_DemoralizingRoar",
	["Feral Charge"] = "Ability_Hunter_Pet_Bear",
	["Feral Instinct"] = "Ability_Ambush",
	["Ferocious Bite"] = "Ability_Druid_FerociousBite",
	["Ferocity"] = "INV_Misc_MonsterClaw_04",
	["Fetish"] = "INV_Misc_Horn_01",
	["Find Herbs"] = "INV_Misc_Flower_02",
	["Find Minerals"] = "Spell_Nature_Earthquake",
	["Find Treasure"] = "Racial_Dwarf_FindTreasure",
	["Find Weakness"] = "Ability_Rogue_FindWeakness",
	["Fire Blast"] = "Spell_Fire_Fireball",
--	["Fire Elemental Totem"] = true,
	["Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Fire Power"] = "Spell_Fire_Immolation",
	["Fire Resistance Aura"] = "Spell_Fire_SealOfFire",
	["Fire Resistance Totem"] = "Spell_FireResistanceTotem_01",
	["Fire Resistance"] = "Spell_Fire_FireArmor",
	["Fire Shield"] = "Spell_Fire_FireArmor",
	["Fire Vulnerability"] = "Spell_Fire_SoulBurn",
	["Fire Ward"] = "Spell_Fire_FireArmor",
	["Fireball"] = "Spell_Fire_FlameBolt",
	["Firebolt"] = "Spell_Fire_FireBolt",
	["First Aid"] = "Spell_Holy_SealOfSacrifice",
	["Fishing Poles"] = "Trade_Fishing",
	["Fishing"] = "Trade_Fishing",
	["Fist Weapon Specialization"] = "INV_Gauntlets_04",
	["Fist Weapons"] = "INV_Gauntlets_04",
	["Flame Shock"] = "Spell_Fire_FlameShock",
	["Flame Throwing"] = "Spell_Fire_Flare",
	["Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Flamethrower"] = "Spell_Fire_Incinerate",
	["Flametongue Totem"] = "Spell_Nature_GuardianWard",
	["Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Flare"] = "Spell_Fire_Flare",
	["Flash Heal"] = "Spell_Holy_FlashHeal",
	["Flash of Light"] = "Spell_Holy_FlashHeal",
--	["Flight Form"] = true,
	["Flurry"] = "Ability_GhoulFrenzy",
	["Focused Casting"] = "Spell_Arcane_Blink",
--	["Forbearance"] = true,
--	["Force of Nature"] = true,
	["Force of Will"] = "Spell_Nature_SlowingTotem",
	["Freezing Trap"] = "Spell_Frost_ChainsOfIce",
	["Frenzied Regeneration"] = "Ability_BullRush",
	["Frenzy"] = "INV_Misc_MonsterClaw_03",
	["Frost Armor"] = "Spell_Frost_FrostArmor02",
	["Frost Channeling"] = "Spell_Frost_Stun",
	["Frost Nova"] = "Spell_Frost_FrostNova",
	["Frost Resistance Aura"] = "Spell_Frost_WizardMark",
	["Frost Resistance Totem"] = "Spell_FrostResistanceTotem_01",
	["Frost Resistance"] = "Spell_Frost_FrostWard",
	["Frost Shock"] = "Spell_Frost_FrostShock",
	["Frost Trap"] = "Spell_Frost_FreezingBreath",
	["Frost Ward"] = "Spell_Frost_FrostWard",
	["Frostbite"] = "Spell_Frost_FrostArmor",
	["Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Furious Howl"] = "Ability_Hunter_Pet_Wolf",
	["Furor"] = "Spell_Holy_BlessingOfStamina",
	["Garrote"] = "Ability_Rogue_Garrote",
	["Generic"] = "INV_Shield_09",
	["Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Ghostly Strike"] = "Spell_Shadow_Curse",
	["Gift of Nature"] = "Spell_Nature_ProtectionformNature",
	["Gift of the Wild"] = "Spell_Nature_Regeneration",
	["Gouge"] = "Ability_Gouge",
	["Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Great Stamina"] = "Spell_Nature_UnyeildingStamina",
	["Greater Blessing of Kings"] = "Spell_Magic_GreaterBlessingofKings",
	["Greater Blessing of Light"] = "Spell_Holy_GreaterBlessingofLight",
	["Greater Blessing of Might"] = "Spell_Holy_GreaterBlessingofKings",
	["Greater Blessing of Salvation"] = "Spell_Holy_GreaterBlessingofSalvation",
	["Greater Blessing of Sanctuary"] = "Spell_Holy_GreaterBlessingofSanctuary",
	["Greater Blessing of Wisdom"] = "Spell_Holy_GreaterBlessingofWisdom",
	["Greater Heal"] = "Spell_Holy_GreaterHeal",
	["Grim Reach"] = "Spell_Shadow_CallofBone",
	["Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Grovel"] = "Temp",
	["Growl"] = "Ability_Physical_Taunt",
	["Guardian's Favor"] = "Spell_Holy_SealOfProtection",
	["Gun Specialization"] = "INV_Musket_03",
	["Guns"] = "INV_Weapon_Rifle_01",
	["Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Hammer of Wrath"] = "Ability_ThunderClap",
	["Hamstring"] = "Ability_ShockWave",
	["Harass"] = "Ability_Hunter_Harass",
	["Hardiness"] = "INV_Helmet_23",
	["Hawk Eye"] = "Ability_TownWatch",
	["Heal"] = "Spell_Holy_Heal",
	["Healing Focus"] = "Spell_Holy_HealingFocus",
	["Healing Light"] = "Spell_Holy_HolyBolt",
	["Healing Stream Totem"] = "INV_Spear_04",
	["Healing Touch"] = "Spell_Nature_HealingTouch",
	["Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Heart of the Wild"] = "Spell_Holy_BlessingOfAgility",
	["Hellfire Effect"] = "Spell_Fire_Incinerate",
	["Hellfire"] = "Spell_Fire_Incinerate",
	["Hemorrhage"] = "Spell_Shadow_LifeDrain",
	["Herbalism"] = "Spell_Nature_NatureTouchGrow",
	["Heroic Strike"] = "Ability_Rogue_Ambush",
--	["Heroism"] = true,
	["Hex of Weakness"] = "Spell_Shadow_FingerOfDeath",
	["Hibernate"] = "Spell_Nature_Sleep",
	["Holy Fire"] = "Spell_Holy_SearingLight",
	["Holy Light"] = "Spell_Holy_HolyBolt",
	["Holy Nova"] = "Spell_Holy_HolyNova",
	["Holy Power"] = "Spell_Holy_Power",
	["Holy Reach"] = "Spell_Holy_Purify",
	["Holy Shield"] = "Spell_Holy_BlessingOfProtection",
	["Holy Shock"] = "Spell_Holy_SearingLight",
	["Holy Specialization"] = "Spell_Holy_SealOfSalvation",
	["Holy Wrath"] = "Spell_Holy_Excorcism",
	["Honorless Target"] = "Spell_Magic_LesserInvisibilty",
	["Horse Riding"] = "Spell_Nature_Swiftness",
	["Howl of Terror"] = "Spell_Shadow_DeathScream",
	["Humanoid Slaying"] = "Spell_Holy_PrayerOfHealing",
	["Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Hurricane"] = "Spell_Nature_Cyclone",
	["Ice Armor"] = "Spell_Frost_FrostArmor02",
	["Ice Barrier"] = "Spell_Ice_Lament",
	["Ice Block"] = "Spell_Frost_Frost",
--	["Ice Lance"] = true,
	["Ice Shards"] = "Spell_Frost_IceShard",
	["Ignite"] = "Spell_Fire_Incinerate",
	["Illumination"] = "Spell_Holy_GreaterHeal",
	["Immolate"] = "Spell_Fire_Immolation",
	["Immolation Trap Effect"] = "Spell_Fire_FlameShock",
	["Immolation Trap"] = "Spell_Fire_FlameShock",
	["Impact"] = "Spell_Fire_MeteorStorm",
	["Impale"] = "Ability_SearingArrow",
	["Improved Ambush"] = "Ability_Rogue_Ambush",
	["Improved Arcane Explosion"] = "Spell_Nature_WispSplode",
	["Improved Arcane Missiles"] = "Spell_Nature_StarFall",
	["Improved Arcane Shot"] = "Ability_ImpalingBolt",
	["Improved Aspect of the Hawk"] = "Spell_Nature_RavenForm",
	["Improved Aspect of the Monkey"] = "Ability_Hunter_AspectOfTheMonkey",
	["Improved Backstab"] = "Ability_BackStab",
	["Improved Battle Shout"] = "Ability_Warrior_BattleShout",
	["Improved Berserker Rage"] = "Spell_Nature_AncestralGuardian",
	["Improved Blessing of Might"] = "Spell_Holy_FistOfJustice",
	["Improved Blessing of Wisdom"] = "Spell_Holy_SealOfWisdom",
	["Improved Blizzard"] = "Spell_Frost_IceStorm",
	["Improved Bloodrage"] = "Ability_Racial_BloodRage",
	["Improved Chain Heal"] = "Spell_Nature_HealingWaveGreater",
	["Improved Chain Lightning"] = "Spell_Nature_ChainLightning",
	["Improved Challenging Shout"] = "Ability_Warrior_Challange",
	["Improved Charge"] = "Ability_Warrior_Charge",
	["Improved Cheap Shot"] = "Ability_CheapShot",
	["Improved Cleave"] = "Ability_Warrior_Cleave",
	["Improved Concentration Aura"] = "Spell_Holy_MindSooth",
	["Improved Concussive Shot"] = "Spell_Frost_Stun",
	["Improved Cone of Cold"] = "Spell_Frost_Glacier",
	["Improved Corruption"] = "Spell_Shadow_AbominationExplosion",
	["Improved Counterspell"] = "Spell_Frost_IceShock",
	["Improved Curse of Agony"] = "Spell_Shadow_CurseOfSargeras",
	["Improved Curse of Exhaustion"] = "Spell_Shadow_GrimWard",
	["Improved Curse of Weakness"] = "Spell_Shadow_CurseOfMannoroth",
	["Improved Dampen Magic"] = "Spell_Nature_AbolishMagic",
	["Improved Deadly Poison"] = "Ability_Rogue_DualWeild",
	["Improved Demoralizing Shout"] = "Ability_Warrior_WarCry",
	["Improved Devotion Aura"] = "Spell_Holy_DevotionAura",
	["Improved Disarm"] = "Ability_Warrior_Disarm",
	["Improved Distract"] = "Ability_Rogue_Distract",
	["Improved Drain Life"] = "Spell_Shadow_LifeDrain02",
	["Improved Drain Mana"] = "Spell_Shadow_SiphonMana",
	["Improved Drain Soul"] = "Spell_Shadow_Haunting",
	["Improved Enrage"] = "Ability_Druid_Enrage",
	["Improved Enslave Demon"] = "Spell_Shadow_EnslaveDemon",
	["Improved Entangling Roots"] = "Spell_Nature_StrangleVines",
	["Improved Evasion"] = "Spell_Shadow_ShadowWard",
	["Improved Eviscerate"] = "Ability_Rogue_Eviscerate",
	["Improved Execute"] = "INV_Sword_48",
	["Improved Expose Armor"] = "Ability_Warrior_Riposte",
	["Improved Eyes of the Beast"] = "Ability_EyeOfTheOwl",
	["Improved Fade"] = "Spell_Magic_LesserInvisibilty",
	["Improved Feign Death"] = "Ability_Rogue_FeignDeath",
	["Improved Fire Blast"] = "Spell_Fire_Fireball",
	["Improved Fire Nova Totem"] = "Spell_Fire_SealOfFire",
	["Improved Fire Ward"] = "Spell_Fire_FireArmor",
	["Improved Fireball"] = "Spell_Fire_FlameBolt",
	["Improved Firebolt"] = "Spell_Fire_FireBolt",
	["Improved Firestone"] = "INV_Ammo_FireTar",
	["Improved Flamestrike"] = "Spell_Fire_SelfDestruct",
	["Improved Flametongue Weapon"] = "Spell_Fire_FlameTounge",
	["Improved Flash of Light"] = "Spell_Holy_FlashHeal",
	["Improved Frost Nova"] = "Spell_Frost_FreezingBreath",
	["Improved Frost Ward"] = "Spell_Frost_FrostWard",
	["Improved Frostbolt"] = "Spell_Frost_FrostBolt02",
	["Improved Frostbrand Weapon"] = "Spell_Frost_FrostBrand",
	["Improved Garrote"] = "Ability_Rogue_Garrote",
	["Improved Ghost Wolf"] = "Spell_Nature_SpiritWolf",
	["Improved Gouge"] = "Ability_Gouge",
	["Improved Grace of Air Totem"] = "Spell_Nature_InvisibilityTotem",
	["Improved Grounding Totem"] = "Spell_Nature_GroundingTotem",
	["Improved Hammer of Justice"] = "Spell_Holy_SealOfMight",
	["Improved Hamstring"] = "Ability_ShockWave",
	["Improved Healing Stream Totem"] = "INV_Spear_04",
	["Improved Healing Touch"] = "Spell_Nature_HealingTouch",
	["Improved Healing Wave"] = "Spell_Nature_MagicImmunity",
	["Improved Healing"] = "Spell_Holy_Heal02",
	["Improved Health Funnel"] = "Spell_Shadow_LifeDrain",
	["Improved Healthstone"] = "INV_Stone_04",
	["Improved Heroic Strike"] = "Ability_Rogue_Ambush",
	["Improved Hunter's Mark"] = "Ability_Hunter_SniperShot",
	["Improved Immolate"] = "Spell_Fire_Immolation",
	["Improved Imp"] = "Spell_Shadow_SummonImp",
	["Improved Inner Fire"] = "Spell_Holy_InnerFire",
	["Improved Instant Poison"] = "Ability_Poisons",
	["Improved Intercept"] = "Ability_Rogue_Sprint",
	["Improved Intimidating Shout"] = "Ability_GolemThunderClap",
	["Improved Judgement"] = "Spell_Holy_RighteousFury",
	["Improved Kick"] = "Ability_Kick",
	["Improved Kidney Shot"] = "Ability_Rogue_KidneyShot",
	["Improved Lash of Pain"] = "Spell_Shadow_Curse",
	["Improved Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Improved Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Improved Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Improved Lightning Bolt"] = "Spell_Nature_Lightning",
	["Improved Lightning Shield"] = "Spell_Nature_LightningShield",
	["Improved Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Improved Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Improved Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Improved Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Improved Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Improved Mend Pet"] = "Ability_Hunter_MendPet",
	["Improved Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Improved Moonfire"] = "Spell_Nature_StarFall",
	["Improved Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Improved Overpower"] = "INV_Sword_05",
	["Improved Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Improved Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Improved Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
	["Improved Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Improved Pummel"] = "INV_Gauntlets_04",
	["Improved Regrowth"] = "Spell_Nature_ResistNature",
	["Improved Reincarnation"] = "Spell_Nature_Reincarnation",
	["Improved Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Improved Rend"] = "Ability_Gouge",
	["Improved Renew"] = "Spell_Holy_Renew",
	["Improved Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Improved Revenge"] = "Ability_Warrior_Revenge",
	["Improved Revive Pet"] = "Ability_Hunter_BeastSoothe",
	["Improved Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Improved Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Improved Rupture"] = "Ability_Rogue_Rupture",
	["Improved Sap"] = "Ability_Sap",
	["Improved Scorch"] = "Spell_Fire_SoulBurn",
	["Improved Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Improved Seal of Righteousness"] = "Ability_ThunderBolt",
	["Improved Seal of the Crusader"] = "Spell_Holy_HolySmite",
	["Improved Searing Pain"] = "Spell_Fire_SoulBurn",
	["Improved Searing Totem"] = "Spell_Fire_SearingTotem",
	["Improved Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Improved Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Improved Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Improved Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Improved Shield Block"] = "Ability_Defend",
	["Improved Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Improved Shred"] = "Spell_Shadow_VampiricAura",
	["Improved Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Improved Slam"] = "Ability_Warrior_DecisiveStrike",
	["Improved Slice and Dice"] = "Ability_Rogue_SliceDice",
	["Improved Spellstone"] = "INV_Misc_Gem_Sapphire_01",
	["Improved Sprint"] = "Ability_Rogue_Sprint",
	["Improved Starfire"] = "Spell_Arcane_StarFire",
	["Improved Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Improved Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Improved Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Improved Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Improved Sunder Armor"] = "Ability_Warrior_Sunder",
	["Improved Taunt"] = "Spell_Nature_Reincarnation",
	["Improved Thorns"] = "Spell_Nature_Thorns",
	["Improved Thunder Clap"] = "Ability_ThunderClap",
	["Improved Tranquility"] = "Spell_Nature_Tranquility",
	["Improved Vampiric Embrace"] = "Spell_Shadow_ImprovedVampiricEmbrace",
	["Improved Vanish"] = "Ability_Vanish",
	["Improved Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Improved Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Improved Wing Clip"] = "Ability_Rogue_Trip",
	["Improved Wrath"] = "Spell_Nature_AbolishMagic",
	["Incinerate"] = "Spell_Fire_FlameShock",
	["Inferno"] = "Spell_Shadow_SummonInfernal",
	["Initiative"] = "Spell_Shadow_Fumble",
	["Inner Fire"] = "Spell_Holy_InnerFire",
	["Inner Focus"] = "Spell_Frost_WindWalkOn",
	["Innervate"] = "Spell_Nature_Lightning",
	["Insect Swarm"] = "Spell_Nature_InsectSwarm",
	["Inspiration"] = "Spell_Holy_LayOnHands",
	["Instant Poison II"] = "Ability_Poisons",
	["Instant Poison III"] = "Ability_Poisons",
	["Instant Poison IV"] = "Ability_Poisons",
	["Instant Poison V"] = "Ability_Poisons",
	["Instant Poison VI"] = "Ability_Poisons",
	["Instant Poison"] = "Ability_Poisons",
	["Intensity"] = "Spell_Fire_LavaSpawn",
	["Intercept"] = "Ability_Rogue_Sprint",
	["Intimidating Shout"] = "Ability_GolemThunderClap",
	["Intimidation"] = "Ability_Devour",
--	["Invisibility"] = true,
	["Iron Will"] = "Spell_Magic_MageArmor",
	["Judgement of Command"] = "Ability_Warrior_InnerRage",
	["Judgement of Justice"] = "Spell_Holy_SealOfWrath",
	["Judgement of Light"] = "Spell_Holy_HealingAura",
	["Judgement of Righteousness"] = "Ability_ThunderBolt",
	["Judgement of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Judgement of the Crusader"] = "Spell_Holy_HolySmite",
	["Judgement"] = "Spell_Holy_RighteousFury",
	["Kick"] = "Ability_Kick",
	["Kidney Shot"] = "Ability_Rogue_KidneyShot",
--	["Kill Command"] = true, 
	["Killer Instinct"] = "Spell_Holy_BlessingOfStamina",
	["Kodo Riding"] = "Spell_Nature_Swiftness",
--	["Lacerate"] = true,
	["Lash of Pain"] = "Spell_Shadow_Curse",
	["Last Stand"] = "Spell_Holy_AshesToAshes",
	["Lasting Judgement"] = "Spell_Holy_HealingAura",
	["Lay on Hands"] = "Spell_Holy_LayOnHands",
	["Leader of the Pack"] = "Spell_Nature_UnyeildingStamina",
	["Leather"] = "INV_Chest_Leather_09",
	["Leatherworking"] = "INV_Misc_ArmorKit_17",
	["Lesser Heal"] = "Spell_Holy_LesserHeal",
	["Lesser Healing Wave"] = "Spell_Nature_HealingWaveLesser",
	["Lesser Invisibility"] = "Spell_Magic_LesserInvisibilty",
	["Lethal Shots"] = "Ability_SearingArrow",
	["Lethality"] = "Ability_CriticalStrike",
	["Levitate"] = "Spell_Holy_LayOnHands",
	["Libram"] = "INV_Misc_Book_11",
	["Lifebloom"] = "INV_Misc_Herb_Felblossom",
	["Life Tap"] = "Spell_Shadow_BurningSpirit",
	["Lightning Bolt"] = "Spell_Nature_Lightning",
	["Lightning Breath"] = "Spell_Nature_Lightning",
	["Lightning Mastery"] = "Spell_Lightning_LightningBolt01",
	["Lightning Reflexes"] = "Spell_Nature_Invisibilty",
	["Lightning Shield"] = "Spell_Nature_LightningShield",
	["Lightwell Renew"] = "Spell_Holy_SummonLightwell",
	["Lightwell"] = "Spell_Holy_SummonLightwell",
	["Long Daze"] = "Spell_Frost_Stun",
	["Mace Specialization"] = "INV_Mace_01",
	["Mace Stun Effect"] = "Spell_Frost_Stun",
	["Mage Armor"] = "Spell_MageArmor",
	["Magma Totem"] = "Spell_Fire_SelfDestruct",
	["Mail"] = "INV_Chest_Chain_05",
--	["Maim"] = true,
	["Malice"] = "Ability_Racial_BloodRage",
	["Mana Burn"] = "Spell_Shadow_ManaBurn",
	["Mana Shield"] = "Spell_Shadow_DetectLesserInvisibility",
	["Mana Spring Totem"] = "Spell_Nature_ManaRegenTotem",
	["Mana Tide Totem"] = "Spell_Frost_SummonWaterElemental",
	["Mangle"] = "Ability_Druid_Mangle",
--	["Mangle (Cat)"] = true,
--	["Mangle (Bear)"] = true,
	["Mark of the Wild"] = "Spell_Nature_Regeneration",
	["Martyrdom"] = "Spell_Nature_Tranquility",
--	["Mass Dispel"] = true,
	["Master Demonologist"] = "Spell_Shadow_ShadowPact",
	["Master Summoner"] = "Spell_Shadow_ImpPhaseShift",
	["Master of Deception"] = "Spell_Shadow_Charm",
	["Maul"] = "Ability_Druid_Maul",
	["Mechanostrider Piloting"] = "Spell_Nature_Swiftness",
	["Meditation"] = "Spell_Nature_Sleep",
	["Melee Specialization"] = "INV_Axe_02",
	["Mend Pet"] = "Ability_Hunter_MendPet",
	["Mental Agility"] = "Ability_Hibernation",
	["Mental Strength"] = "Spell_Nature_EnchantArmor",
	["Mind Blast"] = "Spell_Shadow_UnholyFrenzy",
	["Mind Control"] = "Spell_Shadow_ShadowWordDominate",
	["Mind Flay"] = "Spell_Shadow_SiphonMana",
	["Mind Soothe"] = "Spell_Holy_MindSooth",
	["Mind Vision"] = "Spell_Holy_MindVision",
	["Mind-numbing Poison II"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison III"] = "Spell_Nature_NullifyDisease",
	["Mind-numbing Poison"] = "Spell_Nature_NullifyDisease",
	["Mining"] = "Spell_Fire_FlameBlades",
--	["Misdirection"] = true,
	["Mocking Blow"] = "Ability_Warrior_PunishingBlow",
--	["Molten Armor"] = true,
	["Mongoose Bite"] = "Ability_Hunter_SwiftStrike",
	["Monster Slaying"] = "INV_Misc_Head_Dragon_Black",
	["Moonfire"] = "Spell_Nature_StarFall",
	["Moonfury"] = "Spell_Nature_MoonGlow",
	["Moonglow"] = "Spell_Nature_Sentinal",
	["Moonkin Aura"] = "Spell_Nature_MoonGlow",
	["Moonkin Form"] = "Spell_Nature_ForceOfNature",
	["Mortal Shots"] = "Ability_PierceDamage",
	["Mortal Strike"] = "Ability_Warrior_SavageBlow",
	["Multi-Shot"] = "Ability_UpgradeMoonGlaive",
	["Murder"] = "Spell_Shadow_DeathScream",
--	["Mutilate"] = true,
	["Natural Armor"] = "Spell_Nature_SpiritArmor",
	["Natural Shapeshifter"] = "Spell_Nature_WispSplode",
	["Natural Weapons"] = "INV_Staff_01",
	["Nature Resistance Totem"] = "Spell_Nature_NatureResistanceTotem",
	["Nature Resistance"] = "Spell_Nature_ResistNature",
	["Nature's Focus"] = "Spell_Nature_HealingWaveGreater",
	["Nature's Grace"] = "Spell_Nature_NaturesBlessing",
	["Nature's Grasp"] = "Spell_Nature_NaturesWrath",
	["Nature's Reach"] = "Spell_Nature_NatureTouchGrow",
	["Nature's Swiftness"] = "Spell_Nature_RavenForm",
	["Nightfall"] = "Spell_Shadow_Twilight",
	["Omen of Clarity"] = "Spell_Nature_CrystalBall",
	["One-Handed Axes"] = "INV_Axe_01",
	["One-Handed Maces"] = "INV_Mace_01",
	["One-Handed Swords"] = "Ability_MeleeDamage",
	["One-Handed Weapon Specialization"] = "INV_Sword_20",
	["Opening - No Text"] = "Temp",
	["Opening"] = "Temp",
	["Opportunity"] = "Ability_Warrior_WarCry",
	["Overpower"] = "Ability_MeleeDamage",
	["Pain Suppression"] = "Spell_Holy_PainSuppression",
	["Paranoia"] = "Spell_Shadow_AuraOfDarkness",
	["Parry"] = "Ability_Parry",
	["Pathfinding"] = "Ability_Mount_JungleTiger",
	["Perception"] = "Spell_Nature_Sleep",
	["Permafrost"] = "Spell_Frost_Wisp",
	["Pet Aggression"] = "Ability_Druid_Maul",
	["Pet Hardiness"] = "Ability_BullRush",
	["Pet Recovery"] = "Ability_Hibernation",
	["Pet Resistance"] = "Spell_Holy_BlessingOfAgility",
	["Phase Shift"] = "Spell_Shadow_ImpPhaseShift",
	["Pick Lock"] = "Spell_Nature_MoonKey",
	["Pick Pocket"] = "INV_Misc_Bag_11",
	["Piercing Howl"] = "Spell_Shadow_DeathScream",
	["Piercing Ice"] = "Spell_Frost_Frostbolt",
	["Plate Mail"] = "INV_Chest_Plate01",
	["Poison Cleansing Totem"] = "Spell_Nature_PoisonCleansingTotem",
	["Poisons"] = "Trade_BrewPoison",
	["Polearm Specialization"] = "INV_Weapon_Halbard_01",
	["Polearms"] = "INV_Spear_06",
	["Polymorph"] = "Spell_Nature_Polymorph",
	["Polymorph: Pig"] = "Spell_Magic_PolymorphPig",
	["Polymorph: Turtle"] = "Ability_Hunter_Pet_Turtle",
	["Portal: Darnassus"] = "Spell_Arcane_PortalDarnassus",
	["Portal: Ironforge"] = "Spell_Arcane_PortalIronForge",
	["Portal: Orgrimmar"] = "Spell_Arcane_PortalOrgrimmar",
	["Portal: Stormwind"] = "Spell_Arcane_PortalStormWind",
	["Portal: Thunder Bluff"] = "Spell_Arcane_PortalThunderBluff",
	["Portal: Undercity"] = "Spell_Arcane_PortalUnderCity",
	["Pounce Bleed"] = "Ability_Druid_SupriseAttack",
	["Pounce"] = "Ability_Druid_SupriseAttack",
	["Power Infusion"] = "Spell_Holy_PowerInfusion",
	["Power Word: Fortitude"] = "Spell_Holy_WordFortitude",
	["Power Word: Shield"] = "Spell_Holy_PowerWordShield",
	["Prayer of Fortitude"] = "Spell_Holy_PrayerOfFortitude",
	["Prayer of Healing"] = "Spell_Holy_PrayerOfHealing02",
--	["Prayer of Mending"] = true,
	["Prayer of Shadow Protection"] = "Spell_Holy_PrayerofShadowProtection",
	["Prayer of Spirit"] = "Spell_Holy_PrayerofSpirit",
	["Precision"] = "Ability_Marksmanship",
	["Predatory Strikes"] = "Ability_Hunter_Pet_Cat",
	["Premeditation"] = "Spell_Shadow_Possession",
	["Preparation"] = "Spell_Shadow_AntiShadow",
	["Presence of Mind"] = "Spell_Nature_EnchantArmor",
	["Primal Fury"] = "Ability_Racial_Cannibalize",
	["Prowl"] = "Ability_Druid_SupriseAttack",
	["Psychic Scream"] = "Spell_Shadow_PsychicScream",
	["Pummel"] = "INV_Gauntlets_04",
	["Purge"] = "Spell_Nature_Purge",
	["Purification"] = "Spell_Frost_WizardMark",
	["Purify"] = "Spell_Holy_Purify",
	["Pursuit of Justice"] = "Spell_Holy_PersuitofJustice",
	["Pyroblast"] = "Spell_Fire_Fireball02",
	["Pyroclasm"] = "Spell_Fire_Volcano",
	["Quickness"] = "Ability_Racial_ShadowMeld",
	["Rain of Fire"] = "Spell_Shadow_RainOfFire",
	["Rake"] = "Ability_Druid_Disembowel",
--	["Rampage"] = true,
	["Ram Riding"] = "Spell_Nature_Swiftness",
	["Ranged Weapon Specialization"] = "INV_Weapon_Rifle_06",
	["Rapid Concealment"] = "Ability_Ambush",
	["Rapid Fire"] = "Ability_Hunter_RunningShot",
	["Raptor Riding"] = "Spell_Nature_Swiftness",
	["Raptor Strike"] = "Ability_MeleeDamage",
	["Ravage"] = "Ability_Druid_Ravage",
--	["Readiness"] = "Spell_Nature_Sleep",
	["Rebirth"] = "Spell_Nature_Reincarnation",
	["Recklessness"] = "Ability_CriticalStrike",
	["Reckoning"] = "Spell_Holy_BlessingOfStrength",
	["Redemption"] = "Spell_Holy_Resurrection",
	["Redoubt"] = "Ability_Defend",
	["Reflection"] = "Spell_Frost_WindWalkOn",
	["Regeneration"] = "Spell_Nature_Regenerate",
	["Regrowth"] = "Spell_Nature_ResistNature",
	["Reincarnation"] = "Spell_Nature_Reincarnation",
	["Rejuvenation"] = "Spell_Nature_Rejuvenation",
	["Relentless Strikes"] = "Ability_Warrior_DecisiveStrike",
	["Remorseless Attacks"] = "Ability_FiegnDead",
	["Remove Curse"] = "Spell_Holy_RemoveCurse",
	["Remove Insignia"] = "Temp",
	["Remove Lesser Curse"] = "Spell_Nature_RemoveCurse",
	["Rend"] = "Ability_Gouge",
	["Renew"] = "Spell_Holy_Renew",
	["Repentance"] = "Spell_Holy_PrayerOfHealing",
	["Resurrection"] = "Spell_Holy_Resurrection",
	["Retaliation"] = "Ability_Warrior_Challange",
	["Retribution Aura"] = "Spell_Holy_AuraOfLight",
	["Revenge Stun"] = "Ability_Warrior_Revenge",
	["Revenge"] = "Ability_Warrior_Revenge",
	["Reverberation"] = "Spell_Frost_FrostWard",
	["Revive Pet"] = "Ability_Hunter_BeastSoothe",
--	["Righteous Defense"] = true,
	["Righteous Fury"] = "Spell_Holy_SealOfFury",
	["Rip"] = "Ability_GhoulFrenzy",
	["Riposte"] = "Ability_Warrior_Challange",
	["Ritual of Doom Effect"] = "Spell_Arcane_PortalDarnassus",
	["Ritual of Doom"] = "Spell_Shadow_AntiMagicShell",
--	["Ritual of Souls"] = true,
	["Ritual of Summoning"] = "Spell_Shadow_Twilight",
	["Rockbiter Weapon"] = "Spell_Nature_RockBiter",
	["Rogue Passive"] = "Ability_Stealth",
	["Ruin"] = "Spell_Shadow_ShadowWordPain",
	["Rupture"] = "Ability_Rogue_Rupture",
	["Ruthlessness"] = "Ability_Druid_Disembowel",
	["Sacrifice"] = "Spell_Shadow_SacrificialShield",
	["Safe Fall"] = "INV_Feather_01",
	["Sanctity Aura"] = "Spell_Holy_MindVision",
	["Sap"] = "Ability_Sap",
	["Savage Fury"] = "Ability_Druid_Ravage",
	["Savage Strikes"] = "Ability_Racial_BloodRage",
	["Scare Beast"] = "Ability_Druid_Cower",
	["Scatter Shot"] = "Ability_GolemStormBolt",
	["Scorch"] = "Spell_Fire_SoulBurn",
	["Scorpid Poison"] = "Ability_PoisonSting",
	["Scorpid Sting"] = "Ability_Hunter_CriticalShot",
	["Screech"] = "Ability_Hunter_Pet_Bat",
	["Seal Fate"] = "Spell_Shadow_ChillTouch",
--	["Seal of Blood"] = true,
	["Seal of Command"] = "Ability_Warrior_InnerRage",
	["Seal of Justice"] = "Spell_Holy_SealOfWrath",
	["Seal of Light"] = "Spell_Holy_HealingAura",
	["Seal of Righteousness"] = "Ability_ThunderBolt",
	["Seal of Wisdom"] = "Spell_Holy_RighteousnessAura",
	["Seal of the Crusader"] = "Spell_Holy_HolySmite",
--	["Seal of Vengeance"] = true,
	["Searing Light"] = "Spell_Holy_SearingLightPriest",
	["Searing Pain"] = "Spell_Fire_SoulBurn",
	["Searing Totem"] = "Spell_Fire_SearingTotem",
--	["Second Wind"] = true,
	["Seduction"] = "Spell_Shadow_MindSteal",
--	["Seed of Corruption"] = true,
	["Sense Demons"] = "Spell_Shadow_Metamorphosis",
	["Sense Undead"] = "Spell_Holy_SenseUndead",
	["Sentry Totem"] = "Spell_Nature_RemoveCurse",
	["Serpent Sting"] = "Ability_Hunter_Quickshot",
	["Setup"] = "Spell_Nature_MirrorImage",
	["Shackle Undead"] = "Spell_Nature_Slow",
	["Shadow Affinity"] = "Spell_Shadow_ShadowWard",
	["Shadow Bolt"] = "Spell_Shadow_ShadowBolt",
	["Shadow Focus"] = "Spell_Shadow_BurningSpirit",
	["Shadow Mastery"] = "Spell_Shadow_ShadeTrueSight",
	["Shadow Protection"] = "Spell_Shadow_AntiShadow",
	["Shadow Reach"] = "Spell_Shadow_ChillTouch",
	["Shadow Resistance Aura"] = "Spell_Shadow_SealOfKings",
	["Shadow Resistance"] = "Spell_Shadow_AntiShadow",
	["Shadow Trance"] = "Spell_Shadow_Twilight",
	["Shadow Ward"] = "Spell_Shadow_AntiShadow",
	["Shadow Weaving"] = "Spell_Shadow_BlackPlague",
--	["Shadow Word: Death"] = true,
	["Shadow Word: Pain"] = "Spell_Shadow_ShadowWordPain",
	["Shadowburn"] = "Spell_Shadow_ScourgeBuild",
--	["Shadowfiend"] = true,
	["Shadowform"] = "Spell_Shadow_Shadowform",
--	["Shadowfury"] = true,
	["Shadowguard"] = "Spell_Nature_LightningShield",
	["Shadowmeld Passive"] = "Ability_Ambush",
	["Shadowmeld"] = "Ability_Ambush",
--	["Shadowstep"] = true,
--	["Shamanistic Rage"] = true,
	["Sharpened Claws"] = "INV_Misc_MonsterClaw_04",
	["Shatter"] = "Spell_Frost_FrostShock",
	["Shell Shield"] = "Ability_Hunter_Pet_Turtle",
	["Shield Bash"] = "Ability_Warrior_ShieldBash",
	["Shield Block"] = "Ability_Defend",
	["Shield Slam"] = "INV_Shield_05",
	["Shield Specialization"] = "INV_Shield_06",
	["Shield Wall"] = "Ability_Warrior_ShieldWall",
	["Shield"] = "INV_Shield_04",
--	["Shiv"] = true,
	["Shoot Bow"] = "Ability_Marksmanship",
	["Shoot Crossbow"] = "Ability_Marksmanship",
	["Shoot Gun"] = "Ability_Marksmanship",
	["Shoot"] = "Ability_ShootWand",
	["Shred"] = "Spell_Shadow_VampiricAura",
	["Silence"] = "Spell_Shadow_ImpPhaseShift",
--	["Silencing Shot"] = true,
	["Silent Resolve"] = "Spell_Nature_ManaRegenTotem",
	["Sinister Strike"] = "Spell_Shadow_RitualOfSacrifice",
	["Siphon Life"] = "Spell_Shadow_Requiem",
	["Skinning"] = "INV_Misc_Pelt_Wolf_01",
	["Slam"] = "Ability_Warrior_DecisiveStrike",
	["Slice and Dice"] = "Ability_Rogue_SliceDice",
--	["Slow"] = true,
	["Slow Fall"] = "Spell_Magic_FeatherFall",
	["Smelting"] = "Spell_Fire_FlameBlades",
	["Smite"] = "Spell_Holy_HolySmite",
--	["Snake Trap"] = true,
	["Soothe Animal"] = "Ability_Hunter_BeastSoothe",
	["Soothing Kiss"] = "Spell_Shadow_SoothingKiss",
	["Soul Fire"] = "Spell_Fire_Fireball02",
	["Soul Link"] = "Spell_Shadow_GatherShadows",
--	["Soul Siphon"] = true,
--	["Soulshatter"] = true,
	["Soulstone Resurrection"] = "INV_Misc_Orb_04",
	["Spell Lock"] = "Spell_Shadow_MindRot",
--	["Spellsteal"] = true,
--	["Spell Reflection"] = true,
	["Spell Warding"] = "Spell_Holy_SpellWarding",
	["Spirit Bond"] = "Ability_Druid_DemoralizingRoar",
	["Spirit Tap"] = "Spell_Shadow_Requiem",
	["Spirit of Redemption"] = "INV_Enchant_EssenceEternalLarge",
--	["Spiritual Attunement"] = true,
	["Spiritual Focus"] = "Spell_Arcane_Blink",
	["Spiritual Guidance"] = "Spell_Holy_SpiritualGuidence",
	["Spiritual Healing"] = "Spell_Nature_MoonGlow",
	["Sprint"] = "Ability_Rogue_Sprint",
--	["Stance Mastery"] = true,
	["Starfire"] = "Spell_Arcane_StarFire",
	["Starshards"] = "Spell_Arcane_StarFire",
	["Staves"] = "INV_Staff_08",
--	["Steady Shot"] = true,
	["Stealth"] = "Ability_Stealth",
	["Stoneclaw Totem"] = "Spell_Nature_StoneClawTotem",
	["Stoneform"] = "Spell_Shadow_UnholyStrength",
	["Stoneskin Totem"] = "Spell_Nature_StoneSkinTotem",
	["Stormstrike"] = "Spell_Holy_SealOfMight",
	["Strength of Earth Totem"] = "Spell_Nature_EarthBindTotem",
	["Stuck"] = "Spell_Shadow_Teleport",
	["Subtlety"] = "Ability_EyeOfTheOwl",
	["Suffering"] = "Spell_Shadow_BlackPlague",
	["Summon Charger"] = "Ability_Mount_Charger",
	["Summon Dreadsteed"] = "Ability_Mount_Dreadsteed",
--	["Summon Felguard"] = true,
	["Summon Felhunter"] = "Spell_Shadow_SummonFelHunter",
	["Summon Felsteed"] = "Spell_Nature_Swiftness",
	["Summon Imp"] = "Spell_Shadow_SummonImp",
	["Summon Succubus"] = "Spell_Shadow_SummonSuccubus",
	["Summon Voidwalker"] = "Spell_Shadow_SummonVoidWalker",
	["Summon Warhorse"] = "Spell_Nature_Swiftness",
--	["Summon Water Elemental"] = true,
	["Sunder Armor"] = "Ability_Warrior_Sunder",
	["Suppression"] = "Spell_Shadow_UnsummonBuilding",
	["Surefooted"] = "Ability_Kick",
	["Survivalist"] = "Spell_Shadow_Twilight",
	["Sweeping Strikes"] = "Ability_Rogue_SliceDice",
	["Swipe"] = "INV_Misc_MonsterClaw_03",
	["Sword Specialization"] = "INV_Sword_27",
	["Tactical Mastery"] = "Spell_Nature_EnchantArmor",
	["Tailoring"] = "Trade_Tailoring",
	["Tainted Blood"] = "Spell_Shadow_LifeDrain",
	["Tame Beast"] = "Ability_Hunter_BeastTaming",
	["Tamed Pet Passive"] = "Ability_Mount_PinkTiger",
	["Taunt"] = "Spell_Nature_Reincarnation",
	["Teleport: Darnassus"] = "Spell_Arcane_TeleportDarnassus",
	["Teleport: Ironforge"] = "Spell_Arcane_TeleportIronForge",
	["Teleport: Moonglade"] = "Spell_Arcane_TeleportMoonglade",
	["Teleport: Orgrimmar"] = "Spell_Arcane_TeleportOrgrimmar",
	["Teleport: Stormwind"] = "Spell_Arcane_TeleportStormWind",
	["Teleport: Thunder Bluff"] = "Spell_Arcane_TeleportThunderBluff",
	["Teleport: Undercity"] = "Spell_Arcane_TeleportUnderCity",
--	["The Beast Within"] = true,
	["The Human Spirit"] = "INV_Enchant_ShardBrilliantSmall",
	["Thick Hide"] = "INV_Misc_Pelt_Bear_03",
	["Thorns"] = "Spell_Nature_Thorns",
	["Throw"] = "Ability_Throw",
	["Throwing Specialization"] = "INV_ThrowingAxe_03",
	["Throwing Weapon Specialization"] = "INV_ThrowingKnife_01",
	["Thrown"] = "INV_ThrowingKnife_02",
	["Thunder Clap"] = "Spell_Nature_ThunderClap",
	["Thundering Strikes"] = "Ability_ThunderBolt",
	["Thunderstomp"] = "Ability_Hunter_Pet_Gorilla",
	["Tidal Focus"] = "Spell_Frost_ManaRecharge",
	["Tidal Mastery"] = "Spell_Nature_Tranquility",
	["Tiger Riding"] = "Spell_Nature_Swiftness",
	["Tiger's Fury"] = "Ability_Mount_JungleTiger",
	["Torment"] = "Spell_Shadow_GatherShadows",
	["Totem"] = "Spell_Nature_StoneClawTotem",
	["Totem of Wrath"] = "Spell_Fire_TotemOfWrath",
	["Totemic Focus"] = "Spell_Nature_MoonGlow",
	["Touch of Weakness"] = "Spell_Shadow_DeadofNight",
	["Toughness"] = "Spell_Holy_Devotion",
	["Track Beasts"] = "Ability_Tracking",
	["Track Demons"] = "Spell_Shadow_SummonFelHunter",
	["Track Dragonkin"] = "INV_Misc_Head_Dragon_01",
	["Track Elementals"] = "Spell_Frost_SummonWaterElemental",
	["Track Giants"] = "Ability_Racial_Avatar",
	["Track Hidden"] = "Ability_Stealth",
	["Track Humanoids"] = "Spell_Holy_PrayerOfHealing",
	["Track Undead"] = "Spell_Shadow_DarkSummoning",
	["Tranquil Air Totem"] = "Spell_Nature_Brilliance",
	["Tranquil Spirit"] = "Spell_Holy_ElunesGrace",
	["Tranquility"] = "Spell_Nature_Tranquility",
	["Tranquilizing Shot"] = "Spell_Nature_Drowsy",
	["Trap Mastery"] = "Ability_Ensnare",
	["Travel Form"] = "Ability_Druid_TravelForm",
--	["Tree of Life"] = true,
	["Tremor Totem"] = "Spell_Nature_TremorTotem",
	["Trueshot Aura"] = "Ability_TrueShot",
	["Turn Undead"] = "Spell_Holy_TurnUndead",
	["Two-Handed Axes and Maces"] = "INV_Axe_10",
	["Two-Handed Axes"] = "INV_Axe_04",
	["Two-Handed Maces"] = "INV_Mace_04",
	["Two-Handed Swords"] = "Ability_MeleeDamage",
	["Two-Handed Weapon Specialization"] = "INV_Axe_09",
	["Unarmed"] = "Ability_GolemThunderClap",
	["Unbreakable Will"] = "Spell_Magic_MageArmor",
	["Unbridled Wrath Effect"] = "Spell_Nature_StoneClawTotem",
	["Unbridled Wrath"] = "Spell_Nature_StoneClawTotem",
	["Undead Horsemanship"] = "Spell_Nature_Swiftness",
	["Underwater Breathing"] = "Spell_Shadow_DemonBreath",
	["Unending Breath"] = "Spell_Shadow_DemonBreath",
	["Unholy Power"] = "Spell_Shadow_ShadowWordDominate",
	["Unleashed Fury"] = "Ability_BullRush",
--	["Unleashed Rage"] = true,
--	["Unstable Affliction"] = true,
	["Unyielding Faith"] = "Spell_Holy_UnyieldingFaith",
	["Vampiric Embrace"] = "Spell_Shadow_UnsummonBuilding",
	["Vanish"] = "Ability_Vanish",
	["Vanished"] = "Ability_Vanish",
	["Vampiric Touch"] = "Spell_Holy_Stoicism",
	["Vengeance"] = "Spell_Nature_Purge",
--	["Victory Rush"] = true,
	["Vigor"] = "Spell_Nature_EarthBindTotem",
	["Vile Poisons"] = "Ability_Rogue_FeignDeath",
	["Vindication"] = "Spell_Holy_Vindication",
	["Viper Sting"] = "Ability_Hunter_AimedShot",
	["Volley"] = "Ability_Marksmanship",
	["Wand Specialization"] = "INV_Wand_01",
	["Wands"] = "Ability_ShootWand",
	["War Stomp"] = "Ability_WarStomp",
	["Water Breathing"] = "Spell_Shadow_DemonBreath",
--	["Water Shield"] = true,
	["Water Walking"] = "Spell_Frost_WindWalkOn",
	["Waterbolt"] =	"Spell_Frost_FrostBolt",
	["Weakened Soul"] = "Spell_Holy_AshesToAshes",
	["Whirlwind"] = "Ability_Whirlwind",
	["Will of the Forsaken"] = "Spell_Shadow_RaiseDead",
	["Windfury Totem"] = "Spell_Nature_Windfury",
	["Windfury Weapon"] = "Spell_Nature_Cyclone",
	["Windwall Totem"] = "Spell_Nature_EarthBind",
	["Wing Clip"] = "Ability_Rogue_Trip",
	["Winter's Chill"] = "Spell_Frost_ChillingBlast",
	["Wisp Spirit"] = "Spell_Nature_WispSplode",
	["Wolf Riding"] = "Spell_Nature_Swiftness",
	["Wound Poison II"] = "INV_Misc_Herb_16",
	["Wound Poison III"] = "INV_Misc_Herb_16",
	["Wound Poison IV"] = "INV_Misc_Herb_16",
	["Wound Poison"] = "INV_Misc_Herb_16",
	["Wrath"] = "Spell_Nature_AbolishMagic",
	["Wrath of Air Totem"] = "Spell_Nature_SlowingTotem",
	["Wyvern Sting"] = "INV_Spear_02",
}

BabbleSpell:Debug()
BabbleSpell:SetStrictness(true)

function BabbleSpell:GetSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	local icon = spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
	if not icon then
		return nil
	end
	return "Interface\\Icons\\" .. icon
end

function BabbleSpell:GetShortSpellIcon(spell)
	self:argCheck(spell, 2, "string")
	return spellIcons[spell] or spellIcons[self:HasReverseTranslation(spell) and self:GetReverseTranslation(spell) or false]
end

AceLibrary:Register(BabbleSpell, MAJOR_VERSION, MINOR_VERSION)
BabbleSpell = nil
